// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociatePhoneNumbersWithVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePhoneNumbersWithVoiceConnectorError {
    /// Kind of error that occurred.
    pub kind: AssociatePhoneNumbersWithVoiceConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePhoneNumbersWithVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePhoneNumbersWithVoiceConnectorErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePhoneNumbersWithVoiceConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociatePhoneNumbersWithVoiceConnectorError {
    fn code(&self) -> Option<&str> {
        AssociatePhoneNumbersWithVoiceConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePhoneNumbersWithVoiceConnectorError {
    /// Creates a new `AssociatePhoneNumbersWithVoiceConnectorError`.
    pub fn new(
        kind: AssociatePhoneNumbersWithVoiceConnectorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePhoneNumbersWithVoiceConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePhoneNumbersWithVoiceConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePhoneNumbersWithVoiceConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePhoneNumbersWithVoiceConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for AssociatePhoneNumbersWithVoiceConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            AssociatePhoneNumbersWithVoiceConnectorErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociatePhoneNumbersWithVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePhoneNumbersWithVoiceConnectorGroupError {
    /// Kind of error that occurred.
    pub kind: AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePhoneNumbersWithVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePhoneNumbersWithVoiceConnectorGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::AccessDeniedException(
                _inner,
            ) => _inner.fmt(f),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for AssociatePhoneNumbersWithVoiceConnectorGroupError
{
    fn code(&self) -> Option<&str> {
        AssociatePhoneNumbersWithVoiceConnectorGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePhoneNumbersWithVoiceConnectorGroupError {
    /// Creates a new `AssociatePhoneNumbersWithVoiceConnectorGroupError`.
    pub fn new(
        kind: AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePhoneNumbersWithVoiceConnectorGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePhoneNumbersWithVoiceConnectorGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for AssociatePhoneNumbersWithVoiceConnectorGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::AccessDeniedException(
                _inner,
            ) => Some(_inner),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            AssociatePhoneNumbersWithVoiceConnectorGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociatePhoneNumberWithUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePhoneNumberWithUserError {
    /// Kind of error that occurred.
    pub kind: AssociatePhoneNumberWithUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePhoneNumberWithUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePhoneNumberWithUserErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePhoneNumberWithUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePhoneNumberWithUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociatePhoneNumberWithUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AssociatePhoneNumberWithUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AssociatePhoneNumberWithUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AssociatePhoneNumberWithUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            AssociatePhoneNumberWithUserErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumberWithUserErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumberWithUserErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePhoneNumberWithUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociatePhoneNumberWithUserError {
    fn code(&self) -> Option<&str> {
        AssociatePhoneNumberWithUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePhoneNumberWithUserError {
    /// Creates a new `AssociatePhoneNumberWithUserError`.
    pub fn new(kind: AssociatePhoneNumberWithUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePhoneNumberWithUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePhoneNumberWithUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePhoneNumberWithUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePhoneNumberWithUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePhoneNumberWithUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePhoneNumberWithUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for AssociatePhoneNumberWithUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePhoneNumberWithUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociatePhoneNumberWithUserErrorKind::BadRequestException(_inner) => Some(_inner),
            AssociatePhoneNumberWithUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            AssociatePhoneNumberWithUserErrorKind::NotFoundException(_inner) => Some(_inner),
            AssociatePhoneNumberWithUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            AssociatePhoneNumberWithUserErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumberWithUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            AssociatePhoneNumberWithUserErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            AssociatePhoneNumberWithUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateSigninDelegateGroupsWithAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateSigninDelegateGroupsWithAccountError {
    /// Kind of error that occurred.
    pub kind: AssociateSigninDelegateGroupsWithAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateSigninDelegateGroupsWithAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateSigninDelegateGroupsWithAccountErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateSigninDelegateGroupsWithAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateSigninDelegateGroupsWithAccountErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            AssociateSigninDelegateGroupsWithAccountErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            AssociateSigninDelegateGroupsWithAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateSigninDelegateGroupsWithAccountError {
    fn code(&self) -> Option<&str> {
        AssociateSigninDelegateGroupsWithAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateSigninDelegateGroupsWithAccountError {
    /// Creates a new `AssociateSigninDelegateGroupsWithAccountError`.
    pub fn new(
        kind: AssociateSigninDelegateGroupsWithAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateSigninDelegateGroupsWithAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateSigninDelegateGroupsWithAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateSigninDelegateGroupsWithAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateSigninDelegateGroupsWithAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateSigninDelegateGroupsWithAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSigninDelegateGroupsWithAccountErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSigninDelegateGroupsWithAccountErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSigninDelegateGroupsWithAccountErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSigninDelegateGroupsWithAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSigninDelegateGroupsWithAccountErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSigninDelegateGroupsWithAccountErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSigninDelegateGroupsWithAccountErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSigninDelegateGroupsWithAccountErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSigninDelegateGroupsWithAccountErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for AssociateSigninDelegateGroupsWithAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateSigninDelegateGroupsWithAccountErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            AssociateSigninDelegateGroupsWithAccountErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            AssociateSigninDelegateGroupsWithAccountErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            AssociateSigninDelegateGroupsWithAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchCreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreateAttendeeError {
    /// Kind of error that occurred.
    pub kind: BatchCreateAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreateAttendeeErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreateAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreateAttendeeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            BatchCreateAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreateAttendeeError {
    fn code(&self) -> Option<&str> {
        BatchCreateAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreateAttendeeError {
    /// Creates a new `BatchCreateAttendeeError`.
    pub fn new(kind: BatchCreateAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreateAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreateAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreateAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreateAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateAttendeeErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateAttendeeErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchCreateAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreateAttendeeErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            BatchCreateAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchCreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreateChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: BatchCreateChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreateChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreateChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreateChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchCreateChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchCreateChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateChannelMembershipErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreateChannelMembershipError {
    fn code(&self) -> Option<&str> {
        BatchCreateChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreateChannelMembershipError {
    /// Creates a new `BatchCreateChannelMembershipError`.
    pub fn new(kind: BatchCreateChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreateChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreateChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreateChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreateChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCreateChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchCreateChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreateChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            BatchCreateChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchCreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            BatchCreateChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchCreateRoomMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreateRoomMembershipError {
    /// Kind of error that occurred.
    pub kind: BatchCreateRoomMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreateRoomMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreateRoomMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreateRoomMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreateRoomMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchCreateRoomMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchCreateRoomMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchCreateRoomMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchCreateRoomMembershipErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateRoomMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            BatchCreateRoomMembershipErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateRoomMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreateRoomMembershipError {
    fn code(&self) -> Option<&str> {
        BatchCreateRoomMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreateRoomMembershipError {
    /// Creates a new `BatchCreateRoomMembershipError`.
    pub fn new(kind: BatchCreateRoomMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreateRoomMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreateRoomMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreateRoomMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreateRoomMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCreateRoomMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateRoomMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateRoomMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateRoomMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateRoomMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateRoomMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateRoomMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateRoomMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateRoomMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateRoomMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateRoomMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateRoomMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateRoomMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateRoomMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchCreateRoomMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreateRoomMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchCreateRoomMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchCreateRoomMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchCreateRoomMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchCreateRoomMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchCreateRoomMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchCreateRoomMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            BatchCreateRoomMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeletePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeletePhoneNumberError {
    /// Kind of error that occurred.
    pub kind: BatchDeletePhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeletePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeletePhoneNumberErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeletePhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeletePhoneNumberErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchDeletePhoneNumberErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchDeletePhoneNumberErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchDeletePhoneNumberErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchDeletePhoneNumberErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchDeletePhoneNumberErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            BatchDeletePhoneNumberErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            BatchDeletePhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeletePhoneNumberError {
    fn code(&self) -> Option<&str> {
        BatchDeletePhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeletePhoneNumberError {
    /// Creates a new `BatchDeletePhoneNumberError`.
    pub fn new(kind: BatchDeletePhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeletePhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeletePhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeletePhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeletePhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeletePhoneNumberErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePhoneNumberErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePhoneNumberErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePhoneNumberErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePhoneNumberErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePhoneNumberErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePhoneNumberErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePhoneNumberErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePhoneNumberErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePhoneNumberErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePhoneNumberErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePhoneNumberErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePhoneNumberErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePhoneNumberErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchDeletePhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeletePhoneNumberErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchDeletePhoneNumberErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchDeletePhoneNumberErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchDeletePhoneNumberErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchDeletePhoneNumberErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchDeletePhoneNumberErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchDeletePhoneNumberErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            BatchDeletePhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchSuspendUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchSuspendUserError {
    /// Kind of error that occurred.
    pub kind: BatchSuspendUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchSuspendUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchSuspendUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchSuspendUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchSuspendUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchSuspendUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchSuspendUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchSuspendUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchSuspendUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchSuspendUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            BatchSuspendUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            BatchSuspendUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchSuspendUserError {
    fn code(&self) -> Option<&str> {
        BatchSuspendUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchSuspendUserError {
    /// Creates a new `BatchSuspendUserError`.
    pub fn new(kind: BatchSuspendUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchSuspendUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchSuspendUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchSuspendUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchSuspendUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchSuspendUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSuspendUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchSuspendUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, BatchSuspendUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `BatchSuspendUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, BatchSuspendUserErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `BatchSuspendUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSuspendUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchSuspendUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSuspendUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchSuspendUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSuspendUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchSuspendUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSuspendUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchSuspendUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchSuspendUserErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchSuspendUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchSuspendUserErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchSuspendUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchSuspendUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchSuspendUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchSuspendUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            BatchSuspendUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchUnsuspendUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchUnsuspendUserError {
    /// Kind of error that occurred.
    pub kind: BatchUnsuspendUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchUnsuspendUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchUnsuspendUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchUnsuspendUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchUnsuspendUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchUnsuspendUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchUnsuspendUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchUnsuspendUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchUnsuspendUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchUnsuspendUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            BatchUnsuspendUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            BatchUnsuspendUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchUnsuspendUserError {
    fn code(&self) -> Option<&str> {
        BatchUnsuspendUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchUnsuspendUserError {
    /// Creates a new `BatchUnsuspendUserError`.
    pub fn new(kind: BatchUnsuspendUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchUnsuspendUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchUnsuspendUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchUnsuspendUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchUnsuspendUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchUnsuspendUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUnsuspendUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUnsuspendUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUnsuspendUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUnsuspendUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUnsuspendUserErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUnsuspendUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUnsuspendUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUnsuspendUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUnsuspendUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUnsuspendUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUnsuspendUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUnsuspendUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUnsuspendUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchUnsuspendUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchUnsuspendUserErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchUnsuspendUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchUnsuspendUserErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchUnsuspendUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchUnsuspendUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchUnsuspendUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchUnsuspendUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            BatchUnsuspendUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchUpdatePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchUpdatePhoneNumberError {
    /// Kind of error that occurred.
    pub kind: BatchUpdatePhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchUpdatePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchUpdatePhoneNumberErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchUpdatePhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchUpdatePhoneNumberErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchUpdatePhoneNumberErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchUpdatePhoneNumberErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchUpdatePhoneNumberErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchUpdatePhoneNumberErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchUpdatePhoneNumberErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            BatchUpdatePhoneNumberErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            BatchUpdatePhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchUpdatePhoneNumberError {
    fn code(&self) -> Option<&str> {
        BatchUpdatePhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchUpdatePhoneNumberError {
    /// Creates a new `BatchUpdatePhoneNumberError`.
    pub fn new(kind: BatchUpdatePhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchUpdatePhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchUpdatePhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchUpdatePhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchUpdatePhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchUpdatePhoneNumberErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePhoneNumberErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePhoneNumberErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePhoneNumberErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePhoneNumberErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePhoneNumberErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePhoneNumberErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePhoneNumberErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePhoneNumberErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePhoneNumberErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePhoneNumberErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePhoneNumberErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePhoneNumberErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePhoneNumberErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchUpdatePhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchUpdatePhoneNumberErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchUpdatePhoneNumberErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchUpdatePhoneNumberErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchUpdatePhoneNumberErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchUpdatePhoneNumberErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchUpdatePhoneNumberErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchUpdatePhoneNumberErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            BatchUpdatePhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchUpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchUpdateUserError {
    /// Kind of error that occurred.
    pub kind: BatchUpdateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchUpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchUpdateUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchUpdateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchUpdateUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchUpdateUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchUpdateUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            BatchUpdateUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            BatchUpdateUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchUpdateUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            BatchUpdateUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            BatchUpdateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchUpdateUserError {
    fn code(&self) -> Option<&str> {
        BatchUpdateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchUpdateUserError {
    /// Creates a new `BatchUpdateUserError`.
    pub fn new(kind: BatchUpdateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchUpdateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchUpdateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchUpdateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchUpdateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchUpdateUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, BatchUpdateUserErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `BatchUpdateUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, BatchUpdateUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `BatchUpdateUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, BatchUpdateUserErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `BatchUpdateUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for BatchUpdateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchUpdateUserErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchUpdateUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchUpdateUserErrorKind::NotFoundException(_inner) => Some(_inner),
            BatchUpdateUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            BatchUpdateUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchUpdateUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            BatchUpdateUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            BatchUpdateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccountError {
    /// Kind of error that occurred.
    pub kind: CreateAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccountErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccountError {
    fn code(&self) -> Option<&str> {
        CreateAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccountError {
    /// Creates a new `CreateAccountError`.
    pub fn new(kind: CreateAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAccountErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateAccountErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAccountErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAccountErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAccountErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAccountErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateAccountErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAccountErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateAccountErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAppInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppInstanceError {
    /// Kind of error that occurred.
    pub kind: CreateAppInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAppInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppInstanceErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppInstanceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateAppInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppInstanceError {
    fn code(&self) -> Option<&str> {
        CreateAppInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppInstanceError {
    /// Creates a new `CreateAppInstanceError`.
    pub fn new(kind: CreateAppInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateAppInstanceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateAppInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppInstanceErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateAppInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAppInstanceAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppInstanceAdminError {
    /// Kind of error that occurred.
    pub kind: CreateAppInstanceAdminErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAppInstanceAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppInstanceAdminErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppInstanceAdminError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppInstanceAdminErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAppInstanceAdminErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAppInstanceAdminErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAppInstanceAdminErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateAppInstanceAdminErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateAppInstanceAdminErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAppInstanceAdminErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateAppInstanceAdminErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateAppInstanceAdminErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppInstanceAdminError {
    fn code(&self) -> Option<&str> {
        CreateAppInstanceAdminError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppInstanceAdminError {
    /// Creates a new `CreateAppInstanceAdminError`.
    pub fn new(kind: CreateAppInstanceAdminErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppInstanceAdminError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppInstanceAdminErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppInstanceAdminError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppInstanceAdminErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceAdminErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceAdminErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateAppInstanceAdminError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppInstanceAdminErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateAppInstanceAdminErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: CreateAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppInstanceUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        CreateAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppInstanceUserError {
    /// Creates a new `CreateAppInstanceUserError`.
    pub fn new(kind: CreateAppInstanceUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppInstanceUserErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateAppInstanceUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAttendeeError {
    /// Kind of error that occurred.
    pub kind: CreateAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAttendeeErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAttendeeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAttendeeError {
    fn code(&self) -> Option<&str> {
        CreateAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAttendeeError {
    /// Creates a new `CreateAttendeeError`.
    pub fn new(kind: CreateAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAttendeeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateAttendeeErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAttendeeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAttendeeErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAttendeeErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAttendeeErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBotError {
    /// Kind of error that occurred.
    pub kind: CreateBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBotErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBotErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBotError {
    fn code(&self) -> Option<&str> {
        CreateBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBotError {
    /// Creates a new `CreateBotError`.
    pub fn new(kind: CreateBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBotErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBotErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateBotErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBotErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateBotErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateBotErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateBotErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateBotErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelError {
    /// Kind of error that occurred.
    pub kind: CreateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelError {
    fn code(&self) -> Option<&str> {
        CreateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelError {
    /// Creates a new `CreateChannelError`.
    pub fn new(kind: CreateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateChannelErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelBanError {
    /// Kind of error that occurred.
    pub kind: CreateChannelBanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelBanErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelBanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelBanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelBanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelBanError {
    fn code(&self) -> Option<&str> {
        CreateChannelBanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelBanError {
    /// Creates a new `CreateChannelBanError`.
    pub fn new(kind: CreateChannelBanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelBanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelBanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelBanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelBanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelBanErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelBanErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelBanErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelBanErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelBanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelBanErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelBanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: CreateChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelMembershipError {
    fn code(&self) -> Option<&str> {
        CreateChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelMembershipError {
    /// Creates a new `CreateChannelMembershipError`.
    pub fn new(kind: CreateChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelModeratorError {
    /// Kind of error that occurred.
    pub kind: CreateChannelModeratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelModeratorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelModeratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelModeratorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateChannelModeratorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateChannelModeratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelModeratorError {
    fn code(&self) -> Option<&str> {
        CreateChannelModeratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelModeratorError {
    /// Creates a new `CreateChannelModeratorError`.
    pub fn new(kind: CreateChannelModeratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelModeratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelModeratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelModeratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelModeratorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelModeratorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelModeratorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateChannelModeratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelModeratorErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ConflictException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateChannelModeratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMediaCapturePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMediaCapturePipelineError {
    /// Kind of error that occurred.
    pub kind: CreateMediaCapturePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMediaCapturePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMediaCapturePipelineErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMediaCapturePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMediaCapturePipelineErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMediaCapturePipelineErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateMediaCapturePipelineErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateMediaCapturePipelineErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateMediaCapturePipelineErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateMediaCapturePipelineErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateMediaCapturePipelineErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateMediaCapturePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMediaCapturePipelineError {
    fn code(&self) -> Option<&str> {
        CreateMediaCapturePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMediaCapturePipelineError {
    /// Creates a new `CreateMediaCapturePipelineError`.
    pub fn new(kind: CreateMediaCapturePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMediaCapturePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMediaCapturePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMediaCapturePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMediaCapturePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMediaCapturePipelineErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMediaCapturePipelineErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMediaCapturePipelineErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMediaCapturePipelineErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMediaCapturePipelineErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMediaCapturePipelineErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMediaCapturePipelineErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMediaCapturePipelineErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMediaCapturePipelineErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMediaCapturePipelineErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMediaCapturePipelineErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMediaCapturePipelineErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMediaCapturePipelineErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMediaCapturePipelineErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateMediaCapturePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMediaCapturePipelineErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMediaCapturePipelineErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateMediaCapturePipelineErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateMediaCapturePipelineErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateMediaCapturePipelineErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateMediaCapturePipelineErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateMediaCapturePipelineErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            CreateMediaCapturePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMeetingError {
    /// Kind of error that occurred.
    pub kind: CreateMeetingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMeetingErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMeetingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMeetingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateMeetingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMeetingError {
    fn code(&self) -> Option<&str> {
        CreateMeetingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMeetingError {
    /// Creates a new `CreateMeetingError`.
    pub fn new(kind: CreateMeetingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMeetingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMeetingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMeetingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMeetingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateMeetingErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateMeetingErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateMeetingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMeetingErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMeetingErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateMeetingErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateMeetingErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateMeetingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateMeetingErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateMeetingErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateMeetingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMeetingDialOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMeetingDialOutError {
    /// Kind of error that occurred.
    pub kind: CreateMeetingDialOutErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMeetingDialOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMeetingDialOutErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMeetingDialOutError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMeetingDialOutErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMeetingDialOutErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateMeetingDialOutErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateMeetingDialOutErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateMeetingDialOutErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateMeetingDialOutErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateMeetingDialOutErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateMeetingDialOutErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMeetingDialOutError {
    fn code(&self) -> Option<&str> {
        CreateMeetingDialOutError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMeetingDialOutError {
    /// Creates a new `CreateMeetingDialOutError`.
    pub fn new(kind: CreateMeetingDialOutErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMeetingDialOutError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMeetingDialOutErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMeetingDialOutError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMeetingDialOutErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMeetingDialOutErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingDialOutErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingDialOutErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingDialOutErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingDialOutErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingDialOutErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingDialOutErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingDialOutErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingDialOutErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingDialOutErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingDialOutErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingDialOutErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingDialOutErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingDialOutErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateMeetingDialOutError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMeetingDialOutErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMeetingDialOutErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateMeetingDialOutErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateMeetingDialOutErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateMeetingDialOutErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateMeetingDialOutErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateMeetingDialOutErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateMeetingDialOutErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMeetingWithAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMeetingWithAttendeesError {
    /// Kind of error that occurred.
    pub kind: CreateMeetingWithAttendeesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMeetingWithAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMeetingWithAttendeesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMeetingWithAttendeesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMeetingWithAttendeesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMeetingWithAttendeesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateMeetingWithAttendeesErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateMeetingWithAttendeesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateMeetingWithAttendeesErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateMeetingWithAttendeesErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateMeetingWithAttendeesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMeetingWithAttendeesError {
    fn code(&self) -> Option<&str> {
        CreateMeetingWithAttendeesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMeetingWithAttendeesError {
    /// Creates a new `CreateMeetingWithAttendeesError`.
    pub fn new(kind: CreateMeetingWithAttendeesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMeetingWithAttendeesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMeetingWithAttendeesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMeetingWithAttendeesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMeetingWithAttendeesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeetingWithAttendeesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeetingWithAttendeesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateMeetingWithAttendeesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMeetingWithAttendeesErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMeetingWithAttendeesErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateMeetingWithAttendeesErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateMeetingWithAttendeesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateMeetingWithAttendeesErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateMeetingWithAttendeesErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateMeetingWithAttendeesErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            CreateMeetingWithAttendeesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePhoneNumberOrder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePhoneNumberOrderError {
    /// Kind of error that occurred.
    pub kind: CreatePhoneNumberOrderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePhoneNumberOrder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePhoneNumberOrderErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePhoneNumberOrderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePhoneNumberOrderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePhoneNumberOrderErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreatePhoneNumberOrderErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreatePhoneNumberOrderErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreatePhoneNumberOrderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreatePhoneNumberOrderErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreatePhoneNumberOrderErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreatePhoneNumberOrderErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreatePhoneNumberOrderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePhoneNumberOrderError {
    fn code(&self) -> Option<&str> {
        CreatePhoneNumberOrderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePhoneNumberOrderError {
    /// Creates a new `CreatePhoneNumberOrderError`.
    pub fn new(kind: CreatePhoneNumberOrderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePhoneNumberOrderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePhoneNumberOrderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePhoneNumberOrderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePhoneNumberOrderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePhoneNumberOrderErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePhoneNumberOrderErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreatePhoneNumberOrderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePhoneNumberOrderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::BadRequestException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreatePhoneNumberOrderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProxySession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProxySessionError {
    /// Kind of error that occurred.
    pub kind: CreateProxySessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProxySession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProxySessionErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProxySessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProxySessionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateProxySessionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateProxySessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateProxySessionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateProxySessionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateProxySessionErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateProxySessionErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateProxySessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProxySessionError {
    fn code(&self) -> Option<&str> {
        CreateProxySessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProxySessionError {
    /// Creates a new `CreateProxySessionError`.
    pub fn new(kind: CreateProxySessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProxySessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProxySessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProxySessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProxySessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProxySessionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProxySessionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProxySessionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProxySessionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProxySessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProxySessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProxySessionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProxySessionErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProxySessionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProxySessionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProxySessionErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProxySessionErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProxySessionErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProxySessionErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateProxySessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProxySessionErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateProxySessionErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateProxySessionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateProxySessionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateProxySessionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateProxySessionErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateProxySessionErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateProxySessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRoomError {
    /// Kind of error that occurred.
    pub kind: CreateRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRoomErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRoomErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRoomError {
    fn code(&self) -> Option<&str> {
        CreateRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRoomError {
    /// Creates a new `CreateRoomError`.
    pub fn new(kind: CreateRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRoomErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateRoomErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateRoomErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateRoomErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateRoomErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, CreateRoomErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `CreateRoomErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRoomErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRoomErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateRoomErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRoomErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateRoomErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateRoomErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateRoomErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateRoomErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoomMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRoomMembershipError {
    /// Kind of error that occurred.
    pub kind: CreateRoomMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoomMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRoomMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRoomMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRoomMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateRoomMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRoomMembershipError {
    fn code(&self) -> Option<&str> {
        CreateRoomMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRoomMembershipError {
    /// Creates a new `CreateRoomMembershipError`.
    pub fn new(kind: CreateRoomMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRoomMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRoomMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRoomMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRoomMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoomMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoomMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateRoomMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRoomMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateRoomMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSipMediaApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSipMediaApplicationError {
    /// Kind of error that occurred.
    pub kind: CreateSipMediaApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSipMediaApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSipMediaApplicationErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSipMediaApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSipMediaApplicationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSipMediaApplicationError {
    fn code(&self) -> Option<&str> {
        CreateSipMediaApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSipMediaApplicationError {
    /// Creates a new `CreateSipMediaApplicationError`.
    pub fn new(kind: CreateSipMediaApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSipMediaApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSipMediaApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSipMediaApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSipMediaApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateSipMediaApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSipMediaApplicationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateSipMediaApplicationErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateSipMediaApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSipMediaApplicationCall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSipMediaApplicationCallError {
    /// Kind of error that occurred.
    pub kind: CreateSipMediaApplicationCallErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSipMediaApplicationCall` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSipMediaApplicationCallErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSipMediaApplicationCallError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSipMediaApplicationCallErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationCallErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationCallErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateSipMediaApplicationCallErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationCallErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationCallErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationCallErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationCallErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateSipMediaApplicationCallErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSipMediaApplicationCallError {
    fn code(&self) -> Option<&str> {
        CreateSipMediaApplicationCallError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSipMediaApplicationCallError {
    /// Creates a new `CreateSipMediaApplicationCallError`.
    pub fn new(
        kind: CreateSipMediaApplicationCallErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSipMediaApplicationCallError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSipMediaApplicationCallErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSipMediaApplicationCallError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSipMediaApplicationCallErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipMediaApplicationCallErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipMediaApplicationCallErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateSipMediaApplicationCallError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSipMediaApplicationCallErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSipMediaApplicationCallErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSipMediaApplicationCallErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateSipMediaApplicationCallErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateSipMediaApplicationCallErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateSipMediaApplicationCallErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateSipMediaApplicationCallErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            CreateSipMediaApplicationCallErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            CreateSipMediaApplicationCallErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSipRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSipRuleError {
    /// Kind of error that occurred.
    pub kind: CreateSipRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSipRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSipRuleErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSipRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSipRuleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateSipRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSipRuleError {
    fn code(&self) -> Option<&str> {
        CreateSipRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSipRuleError {
    /// Creates a new `CreateSipRuleError`.
    pub fn new(kind: CreateSipRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSipRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSipRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSipRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSipRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateSipRuleErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateSipRuleErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateSipRuleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateSipRuleErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipRuleErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipRuleErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipRuleErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSipRuleErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSipRuleErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateSipRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSipRuleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateSipRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateUserErrorKind::ConflictException(_inner) => Some(_inner),
            CreateUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateUserErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVoiceConnectorError {
    /// Kind of error that occurred.
    pub kind: CreateVoiceConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVoiceConnectorErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVoiceConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVoiceConnectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVoiceConnectorError {
    fn code(&self) -> Option<&str> {
        CreateVoiceConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVoiceConnectorError {
    /// Creates a new `CreateVoiceConnectorError`.
    pub fn new(kind: CreateVoiceConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVoiceConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVoiceConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVoiceConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVoiceConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateVoiceConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVoiceConnectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateVoiceConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVoiceConnectorGroupError {
    /// Kind of error that occurred.
    pub kind: CreateVoiceConnectorGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVoiceConnectorGroupErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVoiceConnectorGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVoiceConnectorGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorGroupErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            CreateVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            CreateVoiceConnectorGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVoiceConnectorGroupError {
    fn code(&self) -> Option<&str> {
        CreateVoiceConnectorGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVoiceConnectorGroupError {
    /// Creates a new `CreateVoiceConnectorGroupError`.
    pub fn new(kind: CreateVoiceConnectorGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVoiceConnectorGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVoiceConnectorGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVoiceConnectorGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVoiceConnectorGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVoiceConnectorGroupErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVoiceConnectorGroupErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for CreateVoiceConnectorGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVoiceConnectorGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateVoiceConnectorGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateVoiceConnectorGroupErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) => Some(_inner),
            CreateVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            CreateVoiceConnectorGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccountError {
    /// Kind of error that occurred.
    pub kind: DeleteAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccountErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// <p>The request was well-formed but was unable to be followed due to semantic errors.</p>
    UnprocessableEntityException(crate::error::UnprocessableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::UnprocessableEntityException(_inner) => _inner.fmt(f),
            DeleteAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccountError {
    fn code(&self) -> Option<&str> {
        DeleteAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccountError {
    /// Creates a new `DeleteAccountError`.
    pub fn new(kind: DeleteAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAccountErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteAccountErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAccountErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountErrorKind::UnauthorizedClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountErrorKind::UnprocessableEntityException`.
    pub fn is_unprocessable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountErrorKind::UnprocessableEntityException(_)
        )
    }
}
impl std::error::Error for DeleteAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAccountErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAccountErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAccountErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAccountErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAccountErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteAccountErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteAccountErrorKind::UnprocessableEntityException(_inner) => Some(_inner),
            DeleteAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteAppInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppInstanceErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppInstanceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAppInstanceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAppInstanceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAppInstanceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAppInstanceErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteAppInstanceErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteAppInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteAppInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppInstanceError {
    /// Creates a new `DeleteAppInstanceError`.
    pub fn new(kind: DeleteAppInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteAppInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppInstanceErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAppInstanceErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAppInstanceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAppInstanceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAppInstanceErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteAppInstanceErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteAppInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppInstanceAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppInstanceAdminError {
    /// Kind of error that occurred.
    pub kind: DeleteAppInstanceAdminErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppInstanceAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppInstanceAdminErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppInstanceAdminError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppInstanceAdminErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAppInstanceAdminErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAppInstanceAdminErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAppInstanceAdminErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAppInstanceAdminErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAppInstanceAdminErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteAppInstanceAdminErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteAppInstanceAdminErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppInstanceAdminError {
    fn code(&self) -> Option<&str> {
        DeleteAppInstanceAdminError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppInstanceAdminError {
    /// Creates a new `DeleteAppInstanceAdminError`.
    pub fn new(kind: DeleteAppInstanceAdminErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppInstanceAdminError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppInstanceAdminErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppInstanceAdminError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppInstanceAdminErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceAdminErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceAdminErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceAdminErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceAdminErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceAdminErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceAdminErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceAdminErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceAdminErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceAdminErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceAdminErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceAdminErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceAdminErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceAdminErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceAdminErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteAppInstanceAdminError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppInstanceAdminErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAppInstanceAdminErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAppInstanceAdminErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAppInstanceAdminErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAppInstanceAdminErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAppInstanceAdminErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteAppInstanceAdminErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteAppInstanceAdminErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppInstanceStreamingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppInstanceStreamingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DeleteAppInstanceStreamingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppInstanceStreamingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppInstanceStreamingConfigurationsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppInstanceStreamingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppInstanceStreamingConfigurationsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DeleteAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DeleteAppInstanceStreamingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppInstanceStreamingConfigurationsError {
    fn code(&self) -> Option<&str> {
        DeleteAppInstanceStreamingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppInstanceStreamingConfigurationsError {
    /// Creates a new `DeleteAppInstanceStreamingConfigurationsError`.
    pub fn new(
        kind: DeleteAppInstanceStreamingConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppInstanceStreamingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppInstanceStreamingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppInstanceStreamingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppInstanceStreamingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceStreamingConfigurationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceStreamingConfigurationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceStreamingConfigurationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceStreamingConfigurationsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceStreamingConfigurationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceStreamingConfigurationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteAppInstanceStreamingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppInstanceStreamingConfigurationsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DeleteAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            DeleteAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DeleteAppInstanceStreamingConfigurationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: DeleteAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppInstanceUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAppInstanceUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAppInstanceUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAppInstanceUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAppInstanceUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteAppInstanceUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        DeleteAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppInstanceUserError {
    /// Creates a new `DeleteAppInstanceUserError`.
    pub fn new(kind: DeleteAppInstanceUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppInstanceUserErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAppInstanceUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAppInstanceUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAppInstanceUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAppInstanceUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteAppInstanceUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteAppInstanceUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAttendeeError {
    /// Kind of error that occurred.
    pub kind: DeleteAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAttendeeErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAttendeeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAttendeeError {
    fn code(&self) -> Option<&str> {
        DeleteAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAttendeeError {
    /// Creates a new `DeleteAttendeeError`.
    pub fn new(kind: DeleteAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAttendeeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteAttendeeErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAttendeeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttendeeErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttendeeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttendeeErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttendeeErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttendeeErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAttendeeErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelError {
    fn code(&self) -> Option<&str> {
        DeleteChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelError {
    /// Creates a new `DeleteChannelError`.
    pub fn new(kind: DeleteChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelBanError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelBanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelBanErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelBanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelBanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelBanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelBanError {
    fn code(&self) -> Option<&str> {
        DeleteChannelBanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelBanError {
    /// Creates a new `DeleteChannelBanError`.
    pub fn new(kind: DeleteChannelBanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelBanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelBanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelBanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelBanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChannelBanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelBanErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelBanErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteChannelBanErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelBanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelBanErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelBanErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelBanErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelBanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelBanErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelBanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelMembershipError {
    fn code(&self) -> Option<&str> {
        DeleteChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelMembershipError {
    /// Creates a new `DeleteChannelMembershipError`.
    pub fn new(kind: DeleteChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMembershipErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelMessageError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelMessageErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelMessageError {
    fn code(&self) -> Option<&str> {
        DeleteChannelMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelMessageError {
    /// Creates a new `DeleteChannelMessageError`.
    pub fn new(kind: DeleteChannelMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelMessageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChannelMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMessageErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMessageErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMessageErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelMessageErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelMessageErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelModeratorError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelModeratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelModeratorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelModeratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelModeratorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteChannelModeratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelModeratorError {
    fn code(&self) -> Option<&str> {
        DeleteChannelModeratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelModeratorError {
    /// Creates a new `DeleteChannelModeratorError`.
    pub fn new(kind: DeleteChannelModeratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelModeratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelModeratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelModeratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelModeratorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChannelModeratorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelModeratorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelModeratorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelModeratorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelModeratorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelModeratorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelModeratorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteChannelModeratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelModeratorErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteChannelModeratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventsConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventsConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteEventsConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventsConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventsConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventsConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventsConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteEventsConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteEventsConfigurationErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEventsConfigurationErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteEventsConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEventsConfigurationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEventsConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventsConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteEventsConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventsConfigurationError {
    /// Creates a new `DeleteEventsConfigurationError`.
    pub fn new(kind: DeleteEventsConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventsConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventsConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventsConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventsConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventsConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventsConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventsConfigurationErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsConfigurationErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventsConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventsConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventsConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsConfigurationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteEventsConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventsConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteEventsConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteEventsConfigurationErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            DeleteEventsConfigurationErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteEventsConfigurationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteEventsConfigurationErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteEventsConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMediaCapturePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMediaCapturePipelineError {
    /// Kind of error that occurred.
    pub kind: DeleteMediaCapturePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMediaCapturePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMediaCapturePipelineErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMediaCapturePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMediaCapturePipelineErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMediaCapturePipelineErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteMediaCapturePipelineErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMediaCapturePipelineErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteMediaCapturePipelineErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMediaCapturePipelineErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteMediaCapturePipelineErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMediaCapturePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMediaCapturePipelineError {
    fn code(&self) -> Option<&str> {
        DeleteMediaCapturePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMediaCapturePipelineError {
    /// Creates a new `DeleteMediaCapturePipelineError`.
    pub fn new(kind: DeleteMediaCapturePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMediaCapturePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMediaCapturePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMediaCapturePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMediaCapturePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMediaCapturePipelineErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMediaCapturePipelineErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMediaCapturePipelineErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMediaCapturePipelineErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMediaCapturePipelineErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMediaCapturePipelineErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMediaCapturePipelineErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMediaCapturePipelineErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMediaCapturePipelineErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMediaCapturePipelineErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMediaCapturePipelineErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMediaCapturePipelineErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMediaCapturePipelineErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMediaCapturePipelineErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteMediaCapturePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMediaCapturePipelineErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMediaCapturePipelineErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteMediaCapturePipelineErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMediaCapturePipelineErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteMediaCapturePipelineErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteMediaCapturePipelineErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteMediaCapturePipelineErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            DeleteMediaCapturePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMeetingError {
    /// Kind of error that occurred.
    pub kind: DeleteMeetingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMeetingErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMeetingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMeetingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteMeetingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMeetingError {
    fn code(&self) -> Option<&str> {
        DeleteMeetingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMeetingError {
    /// Creates a new `DeleteMeetingError`.
    pub fn new(kind: DeleteMeetingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMeetingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMeetingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMeetingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMeetingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeetingErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeetingErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeetingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMeetingErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMeetingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMeetingErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMeetingErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMeetingErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteMeetingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMeetingErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteMeetingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePhoneNumberError {
    /// Kind of error that occurred.
    pub kind: DeletePhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePhoneNumberErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePhoneNumberErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeletePhoneNumberErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeletePhoneNumberErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeletePhoneNumberErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeletePhoneNumberErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeletePhoneNumberErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeletePhoneNumberErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeletePhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePhoneNumberError {
    fn code(&self) -> Option<&str> {
        DeletePhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePhoneNumberError {
    /// Creates a new `DeletePhoneNumberError`.
    pub fn new(kind: DeletePhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePhoneNumberErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePhoneNumberErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePhoneNumberErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePhoneNumberErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePhoneNumberErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeletePhoneNumberErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeletePhoneNumberErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePhoneNumberErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePhoneNumberErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePhoneNumberErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePhoneNumberErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePhoneNumberErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePhoneNumberErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePhoneNumberErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeletePhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePhoneNumberErrorKind::BadRequestException(_inner) => Some(_inner),
            DeletePhoneNumberErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeletePhoneNumberErrorKind::NotFoundException(_inner) => Some(_inner),
            DeletePhoneNumberErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeletePhoneNumberErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeletePhoneNumberErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeletePhoneNumberErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeletePhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProxySession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProxySessionError {
    /// Kind of error that occurred.
    pub kind: DeleteProxySessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProxySession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProxySessionErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProxySessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProxySessionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteProxySessionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteProxySessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteProxySessionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteProxySessionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteProxySessionErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteProxySessionErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteProxySessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProxySessionError {
    fn code(&self) -> Option<&str> {
        DeleteProxySessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProxySessionError {
    /// Creates a new `DeleteProxySessionError`.
    pub fn new(kind: DeleteProxySessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProxySessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProxySessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProxySessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProxySessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProxySessionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProxySessionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProxySessionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProxySessionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProxySessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProxySessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProxySessionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProxySessionErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProxySessionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProxySessionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProxySessionErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProxySessionErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProxySessionErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProxySessionErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteProxySessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProxySessionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteProxySessionErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteProxySessionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteProxySessionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteProxySessionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteProxySessionErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteProxySessionErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteProxySessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRoomError {
    /// Kind of error that occurred.
    pub kind: DeleteRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRoomErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRoomErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRoomError {
    fn code(&self) -> Option<&str> {
        DeleteRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRoomError {
    /// Creates a new `DeleteRoomError`.
    pub fn new(kind: DeleteRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRoomErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRoomErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoomErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoomErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoomErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoomErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoomErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoomErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoomErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoomErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoomErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoomErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoomErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRoomErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteRoomErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteRoomErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRoomErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteRoomErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRoomErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteRoomErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoomMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRoomMembershipError {
    /// Kind of error that occurred.
    pub kind: DeleteRoomMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoomMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRoomMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRoomMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRoomMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteRoomMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteRoomMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRoomMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteRoomMembershipErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRoomMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteRoomMembershipErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteRoomMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRoomMembershipError {
    fn code(&self) -> Option<&str> {
        DeleteRoomMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRoomMembershipError {
    /// Creates a new `DeleteRoomMembershipError`.
    pub fn new(kind: DeleteRoomMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRoomMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRoomMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRoomMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRoomMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRoomMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoomMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoomMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoomMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoomMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoomMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoomMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteRoomMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRoomMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteRoomMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteRoomMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRoomMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteRoomMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRoomMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteRoomMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteRoomMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSipMediaApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSipMediaApplicationError {
    /// Kind of error that occurred.
    pub kind: DeleteSipMediaApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSipMediaApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSipMediaApplicationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSipMediaApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSipMediaApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSipMediaApplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSipMediaApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteSipMediaApplicationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSipMediaApplicationErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteSipMediaApplicationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSipMediaApplicationErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteSipMediaApplicationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSipMediaApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSipMediaApplicationError {
    fn code(&self) -> Option<&str> {
        DeleteSipMediaApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSipMediaApplicationError {
    /// Creates a new `DeleteSipMediaApplicationError`.
    pub fn new(kind: DeleteSipMediaApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSipMediaApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSipMediaApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSipMediaApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSipMediaApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipMediaApplicationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipMediaApplicationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteSipMediaApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSipMediaApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteSipMediaApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSipRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSipRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteSipRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSipRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSipRuleErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSipRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSipRuleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteSipRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSipRuleError {
    fn code(&self) -> Option<&str> {
        DeleteSipRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSipRuleError {
    /// Creates a new `DeleteSipRuleError`.
    pub fn new(kind: DeleteSipRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSipRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSipRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSipRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSipRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteSipRuleErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSipRuleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteSipRuleErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSipRuleErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipRuleErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipRuleErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSipRuleErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSipRuleErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteSipRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSipRuleErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteSipRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceConnectorError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorError {
    /// Creates a new `DeleteVoiceConnectorError`.
    pub fn new(kind: DeleteVoiceConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteVoiceConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceConnectorEmergencyCallingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorEmergencyCallingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnectorEmergencyCallingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorEmergencyCallingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DeleteVoiceConnectorEmergencyCallingConfigurationError
{
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorEmergencyCallingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorEmergencyCallingConfigurationError {
    /// Creates a new `DeleteVoiceConnectorEmergencyCallingConfigurationError`.
    pub fn new(
        kind: DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorEmergencyCallingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorEmergencyCallingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException(
                _
            )
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorEmergencyCallingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException(_inner) =>
            Some(_inner)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException(_inner) =>
            Some(_inner)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException(_inner) =>
            Some(_inner)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException(_inner) =>
            Some(_inner)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException(_inner) =>
            Some(_inner)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException(_inner) =>
            Some(_inner)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException(_inner) =>
            Some(_inner)
            ,
            DeleteVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorGroupErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request could not be processed because of conflict in the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceConnectorGroupError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorGroupError {
    /// Creates a new `DeleteVoiceConnectorGroupError`.
    pub fn new(kind: DeleteVoiceConnectorGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorGroupErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorGroupErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteVoiceConnectorGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceConnectorOrigination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorOriginationError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorOriginationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnectorOrigination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorOriginationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorOriginationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorOriginationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorOriginationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorOriginationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorOriginationErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorOriginationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorOriginationErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorOriginationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorOriginationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceConnectorOriginationError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorOriginationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorOriginationError {
    /// Creates a new `DeleteVoiceConnectorOriginationError`.
    pub fn new(
        kind: DeleteVoiceConnectorOriginationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorOriginationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorOriginationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorOriginationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorOriginationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorOriginationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorOriginationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorOriginationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorOriginationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorOriginationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorOriginationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorOriginationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorOriginationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorOriginationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorOriginationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorOriginationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorOriginationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorOriginationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorOriginationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorOriginationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorOriginationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVoiceConnectorOriginationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVoiceConnectorOriginationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVoiceConnectorOriginationErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorOriginationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorOriginationErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorOriginationErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorOriginationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceConnectorProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorProxyError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorProxyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnectorProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorProxyErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorProxyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorProxyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorProxyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorProxyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorProxyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorProxyErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorProxyErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorProxyErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorProxyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceConnectorProxyError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorProxyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorProxyError {
    /// Creates a new `DeleteVoiceConnectorProxyError`.
    pub fn new(kind: DeleteVoiceConnectorProxyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorProxyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorProxyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorProxyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorProxyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorProxyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorProxyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorProxyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorProxyErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorProxyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorProxyErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorProxyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorProxyErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorProxyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorProxyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorProxyErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorProxyErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorProxyErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorProxyErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorProxyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorProxyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVoiceConnectorProxyErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVoiceConnectorProxyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVoiceConnectorProxyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteVoiceConnectorProxyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVoiceConnectorProxyErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DeleteVoiceConnectorProxyErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DeleteVoiceConnectorProxyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceConnectorStreamingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorStreamingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorStreamingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnectorStreamingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorStreamingConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorStreamingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorStreamingConfigurationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorStreamingConfigurationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceConnectorStreamingConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorStreamingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorStreamingConfigurationError {
    /// Creates a new `DeleteVoiceConnectorStreamingConfigurationError`.
    pub fn new(
        kind: DeleteVoiceConnectorStreamingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorStreamingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorStreamingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorStreamingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorStreamingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorStreamingConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorStreamingConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorStreamingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorStreamingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorStreamingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorStreamingConfigurationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorStreamingConfigurationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorStreamingConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteVoiceConnectorTermination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorTerminationError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorTerminationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnectorTermination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorTerminationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorTerminationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorTerminationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorTerminationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorTerminationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVoiceConnectorTerminationErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorTerminationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorTerminationErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorTerminationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorTerminationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceConnectorTerminationError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorTerminationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorTerminationError {
    /// Creates a new `DeleteVoiceConnectorTerminationError`.
    pub fn new(
        kind: DeleteVoiceConnectorTerminationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorTerminationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorTerminationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorTerminationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorTerminationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorTerminationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorTerminationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVoiceConnectorTerminationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVoiceConnectorTerminationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVoiceConnectorTerminationErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorTerminationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorTerminationErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorTerminationErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorTerminationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVoiceConnectorTerminationCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVoiceConnectorTerminationCredentialsError {
    /// Kind of error that occurred.
    pub kind: DeleteVoiceConnectorTerminationCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVoiceConnectorTerminationCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVoiceConnectorTerminationCredentialsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVoiceConnectorTerminationCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVoiceConnectorTerminationCredentialsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorTerminationCredentialsErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVoiceConnectorTerminationCredentialsError {
    fn code(&self) -> Option<&str> {
        DeleteVoiceConnectorTerminationCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVoiceConnectorTerminationCredentialsError {
    /// Creates a new `DeleteVoiceConnectorTerminationCredentialsError`.
    pub fn new(
        kind: DeleteVoiceConnectorTerminationCredentialsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVoiceConnectorTerminationCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVoiceConnectorTerminationCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVoiceConnectorTerminationCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVoiceConnectorTerminationCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationCredentialsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationCredentialsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationCredentialsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationCredentialsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationCredentialsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationCredentialsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVoiceConnectorTerminationCredentialsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVoiceConnectorTerminationCredentialsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DeleteVoiceConnectorTerminationCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVoiceConnectorTerminationCredentialsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorTerminationCredentialsErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DeleteVoiceConnectorTerminationCredentialsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAppInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAppInstanceError {
    /// Kind of error that occurred.
    pub kind: DescribeAppInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAppInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAppInstanceErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAppInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAppInstanceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeAppInstanceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeAppInstanceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeAppInstanceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAppInstanceErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeAppInstanceErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeAppInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAppInstanceError {
    fn code(&self) -> Option<&str> {
        DescribeAppInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAppInstanceError {
    /// Creates a new `DescribeAppInstanceError`.
    pub fn new(kind: DescribeAppInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAppInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAppInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAppInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAppInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeAppInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAppInstanceErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeAppInstanceErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeAppInstanceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeAppInstanceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeAppInstanceErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeAppInstanceErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeAppInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAppInstanceAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAppInstanceAdminError {
    /// Kind of error that occurred.
    pub kind: DescribeAppInstanceAdminErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAppInstanceAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAppInstanceAdminErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAppInstanceAdminError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAppInstanceAdminErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeAppInstanceAdminErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeAppInstanceAdminErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeAppInstanceAdminErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAppInstanceAdminErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeAppInstanceAdminErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeAppInstanceAdminErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAppInstanceAdminError {
    fn code(&self) -> Option<&str> {
        DescribeAppInstanceAdminError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAppInstanceAdminError {
    /// Creates a new `DescribeAppInstanceAdminError`.
    pub fn new(kind: DescribeAppInstanceAdminErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAppInstanceAdminError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAppInstanceAdminErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAppInstanceAdminError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAppInstanceAdminErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceAdminErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceAdminErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceAdminErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceAdminErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceAdminErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceAdminErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceAdminErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceAdminErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceAdminErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceAdminErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceAdminErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceAdminErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeAppInstanceAdminError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAppInstanceAdminErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeAppInstanceAdminErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeAppInstanceAdminErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeAppInstanceAdminErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeAppInstanceAdminErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeAppInstanceAdminErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeAppInstanceAdminErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: DescribeAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAppInstanceUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeAppInstanceUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeAppInstanceUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeAppInstanceUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAppInstanceUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeAppInstanceUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        DescribeAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAppInstanceUserError {
    /// Creates a new `DescribeAppInstanceUserError`.
    pub fn new(kind: DescribeAppInstanceUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAppInstanceUserErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeAppInstanceUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeAppInstanceUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeAppInstanceUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeAppInstanceUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeAppInstanceUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeAppInstanceUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelError {
    fn code(&self) -> Option<&str> {
        DescribeChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelError {
    /// Creates a new `DescribeChannelError`.
    pub fn new(kind: DescribeChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelBanError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelBanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelBan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelBanErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelBanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelBanErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeChannelBanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelBanError {
    fn code(&self) -> Option<&str> {
        DescribeChannelBanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelBanError {
    /// Creates a new `DescribeChannelBanError`.
    pub fn new(kind: DescribeChannelBanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelBanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelBanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelBanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelBanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelBanErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelBanErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelBanErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelBanErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelBanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelBanErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelBanErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelBanErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelBanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelBanErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelBanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelMembershipError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelMembershipErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelMembershipErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelMembershipErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelMembershipError {
    fn code(&self) -> Option<&str> {
        DescribeChannelMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelMembershipError {
    /// Creates a new `DescribeChannelMembershipError`.
    pub fn new(kind: DescribeChannelMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelMembershipErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannelMembershipForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelMembershipForAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelMembershipForAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelMembershipForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelMembershipForAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelMembershipForAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeChannelMembershipForAppInstanceUserError
{
    fn code(&self) -> Option<&str> {
        DescribeChannelMembershipForAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelMembershipForAppInstanceUserError {
    /// Creates a new `DescribeChannelMembershipForAppInstanceUserError`.
    pub fn new(
        kind: DescribeChannelMembershipForAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelMembershipForAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelMembershipForAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelMembershipForAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelMembershipForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelMembershipForAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeChannelModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelModeratedByAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelModeratedByAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelModeratedByAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelModeratedByAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelModeratedByAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        DescribeChannelModeratedByAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelModeratedByAppInstanceUserError {
    /// Creates a new `DescribeChannelModeratedByAppInstanceUserError`.
    pub fn new(
        kind: DescribeChannelModeratedByAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelModeratedByAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelModeratedByAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelModeratedByAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            DescribeChannelModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DescribeChannelModeratedByAppInstanceUserErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DescribeChannelModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelModeratorError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelModeratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannelModerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelModeratorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelModeratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelModeratorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            DescribeChannelModeratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelModeratorError {
    fn code(&self) -> Option<&str> {
        DescribeChannelModeratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelModeratorError {
    /// Creates a new `DescribeChannelModeratorError`.
    pub fn new(kind: DescribeChannelModeratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelModeratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelModeratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelModeratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelModeratorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelModeratorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelModeratorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DescribeChannelModeratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelModeratorErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            DescribeChannelModeratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociatePhoneNumberFromUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociatePhoneNumberFromUserError {
    /// Kind of error that occurred.
    pub kind: DisassociatePhoneNumberFromUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociatePhoneNumberFromUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociatePhoneNumberFromUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociatePhoneNumberFromUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociatePhoneNumberFromUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DisassociatePhoneNumberFromUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DisassociatePhoneNumberFromUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisassociatePhoneNumberFromUserErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePhoneNumberFromUserErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePhoneNumberFromUserErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePhoneNumberFromUserErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePhoneNumberFromUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociatePhoneNumberFromUserError {
    fn code(&self) -> Option<&str> {
        DisassociatePhoneNumberFromUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociatePhoneNumberFromUserError {
    /// Creates a new `DisassociatePhoneNumberFromUserError`.
    pub fn new(
        kind: DisassociatePhoneNumberFromUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociatePhoneNumberFromUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociatePhoneNumberFromUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociatePhoneNumberFromUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociatePhoneNumberFromUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumberFromUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumberFromUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumberFromUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumberFromUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumberFromUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumberFromUserErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumberFromUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumberFromUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumberFromUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumberFromUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumberFromUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumberFromUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumberFromUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumberFromUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DisassociatePhoneNumberFromUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociatePhoneNumberFromUserErrorKind::BadRequestException(_inner) => Some(_inner),
            DisassociatePhoneNumberFromUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            DisassociatePhoneNumberFromUserErrorKind::NotFoundException(_inner) => Some(_inner),
            DisassociatePhoneNumberFromUserErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            DisassociatePhoneNumberFromUserErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DisassociatePhoneNumberFromUserErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            DisassociatePhoneNumberFromUserErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            DisassociatePhoneNumberFromUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociatePhoneNumbersFromVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociatePhoneNumbersFromVoiceConnectorError {
    /// Kind of error that occurred.
    pub kind: DisassociatePhoneNumbersFromVoiceConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociatePhoneNumbersFromVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociatePhoneNumbersFromVoiceConnectorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociatePhoneNumbersFromVoiceConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociatePhoneNumbersFromVoiceConnectorError {
    fn code(&self) -> Option<&str> {
        DisassociatePhoneNumbersFromVoiceConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociatePhoneNumbersFromVoiceConnectorError {
    /// Creates a new `DisassociatePhoneNumbersFromVoiceConnectorError`.
    pub fn new(
        kind: DisassociatePhoneNumbersFromVoiceConnectorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociatePhoneNumbersFromVoiceConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociatePhoneNumbersFromVoiceConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociatePhoneNumbersFromVoiceConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociatePhoneNumbersFromVoiceConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DisassociatePhoneNumbersFromVoiceConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DisassociatePhoneNumbersFromVoiceConnectorErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociatePhoneNumbersFromVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociatePhoneNumbersFromVoiceConnectorGroupError {
    /// Kind of error that occurred.
    pub kind: DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociatePhoneNumbersFromVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociatePhoneNumbersFromVoiceConnectorGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::BadRequestException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ForbiddenException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::NotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DisassociatePhoneNumbersFromVoiceConnectorGroupError
{
    fn code(&self) -> Option<&str> {
        DisassociatePhoneNumbersFromVoiceConnectorGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociatePhoneNumbersFromVoiceConnectorGroupError {
    /// Creates a new `DisassociatePhoneNumbersFromVoiceConnectorGroupError`.
    pub fn new(
        kind: DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociatePhoneNumbersFromVoiceConnectorGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociatePhoneNumbersFromVoiceConnectorGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceUnavailableException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::UnauthorizedClientException(
                _
            )
        )
    }
}
impl std::error::Error for DisassociatePhoneNumbersFromVoiceConnectorGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::BadRequestException(_inner) =>
            Some(_inner)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ForbiddenException(_inner) =>
            Some(_inner)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::NotFoundException(_inner) =>
            Some(_inner)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) =>
            Some(_inner)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) =>
            Some(_inner)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) =>
            Some(_inner)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) =>
            Some(_inner)
            ,
            DisassociatePhoneNumbersFromVoiceConnectorGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateSigninDelegateGroupsFromAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateSigninDelegateGroupsFromAccountError {
    /// Kind of error that occurred.
    pub kind: DisassociateSigninDelegateGroupsFromAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateSigninDelegateGroupsFromAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateSigninDelegateGroupsFromAccountErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateSigninDelegateGroupsFromAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateSigninDelegateGroupsFromAccountErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateSigninDelegateGroupsFromAccountErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DisassociateSigninDelegateGroupsFromAccountError
{
    fn code(&self) -> Option<&str> {
        DisassociateSigninDelegateGroupsFromAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateSigninDelegateGroupsFromAccountError {
    /// Creates a new `DisassociateSigninDelegateGroupsFromAccountError`.
    pub fn new(
        kind: DisassociateSigninDelegateGroupsFromAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateSigninDelegateGroupsFromAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateSigninDelegateGroupsFromAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateSigninDelegateGroupsFromAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateSigninDelegateGroupsFromAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateSigninDelegateGroupsFromAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSigninDelegateGroupsFromAccountErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSigninDelegateGroupsFromAccountErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSigninDelegateGroupsFromAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSigninDelegateGroupsFromAccountErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSigninDelegateGroupsFromAccountErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSigninDelegateGroupsFromAccountErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSigninDelegateGroupsFromAccountErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for DisassociateSigninDelegateGroupsFromAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateSigninDelegateGroupsFromAccountErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            DisassociateSigninDelegateGroupsFromAccountErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            DisassociateSigninDelegateGroupsFromAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountError {
    /// Kind of error that occurred.
    pub kind: GetAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountError {
    fn code(&self) -> Option<&str> {
        GetAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountError {
    /// Creates a new `GetAccountError`.
    pub fn new(kind: GetAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, GetAccountErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `GetAccountErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAccountErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAccountErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAccountErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetAccountErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetAccountErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetAccountErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: GetAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountSettingsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountSettingsError {
    fn code(&self) -> Option<&str> {
        GetAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountSettingsError {
    /// Creates a new `GetAccountSettingsError`.
    pub fn new(kind: GetAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppInstanceRetentionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppInstanceRetentionSettingsError {
    /// Kind of error that occurred.
    pub kind: GetAppInstanceRetentionSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppInstanceRetentionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppInstanceRetentionSettingsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppInstanceRetentionSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppInstanceRetentionSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAppInstanceRetentionSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAppInstanceRetentionSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAppInstanceRetentionSettingsErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceRetentionSettingsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceRetentionSettingsErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceRetentionSettingsErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceRetentionSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppInstanceRetentionSettingsError {
    fn code(&self) -> Option<&str> {
        GetAppInstanceRetentionSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppInstanceRetentionSettingsError {
    /// Creates a new `GetAppInstanceRetentionSettingsError`.
    pub fn new(
        kind: GetAppInstanceRetentionSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppInstanceRetentionSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppInstanceRetentionSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppInstanceRetentionSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppInstanceRetentionSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAppInstanceRetentionSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceRetentionSettingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceRetentionSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceRetentionSettingsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceRetentionSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceRetentionSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceRetentionSettingsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceRetentionSettingsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceRetentionSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceRetentionSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceRetentionSettingsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceRetentionSettingsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceRetentionSettingsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceRetentionSettingsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetAppInstanceRetentionSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppInstanceRetentionSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAppInstanceRetentionSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAppInstanceRetentionSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAppInstanceRetentionSettingsErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceRetentionSettingsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceRetentionSettingsErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceRetentionSettingsErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceRetentionSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppInstanceStreamingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppInstanceStreamingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: GetAppInstanceStreamingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppInstanceStreamingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppInstanceStreamingConfigurationsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppInstanceStreamingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppInstanceStreamingConfigurationsErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppInstanceStreamingConfigurationsError {
    fn code(&self) -> Option<&str> {
        GetAppInstanceStreamingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppInstanceStreamingConfigurationsError {
    /// Creates a new `GetAppInstanceStreamingConfigurationsError`.
    pub fn new(
        kind: GetAppInstanceStreamingConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppInstanceStreamingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppInstanceStreamingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppInstanceStreamingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppInstanceStreamingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAppInstanceStreamingConfigurationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceStreamingConfigurationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceStreamingConfigurationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceStreamingConfigurationsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceStreamingConfigurationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceStreamingConfigurationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetAppInstanceStreamingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppInstanceStreamingConfigurationsErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetAppInstanceStreamingConfigurationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAttendeeError {
    /// Kind of error that occurred.
    pub kind: GetAttendeeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAttendee` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAttendeeErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAttendeeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetAttendeeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAttendeeError {
    fn code(&self) -> Option<&str> {
        GetAttendeeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAttendeeError {
    /// Creates a new `GetAttendeeError`.
    pub fn new(kind: GetAttendeeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAttendeeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAttendeeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAttendeeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAttendeeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetAttendeeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetAttendeeErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAttendeeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetAttendeeErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAttendeeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAttendeeErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAttendeeErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAttendeeErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetAttendeeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAttendeeErrorKind::BadRequestException(_inner) => Some(_inner),
            GetAttendeeErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetAttendeeErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAttendeeErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetAttendeeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetAttendeeErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetAttendeeErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetAttendeeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotError {
    /// Kind of error that occurred.
    pub kind: GetBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetBotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBotErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetBotErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetBotErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetBotErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotError {
    fn code(&self) -> Option<&str> {
        GetBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotError {
    /// Creates a new `GetBotError`.
    pub fn new(kind: GetBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::ServiceUnavailableException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::UnauthorizedClientException(_))
    }
}
impl std::error::Error for GetBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetBotErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBotErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetBotErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetBotErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetBotErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChannelMessageError {
    /// Kind of error that occurred.
    pub kind: GetChannelMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChannelMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChannelMessageErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChannelMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChannelMessageErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetChannelMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChannelMessageError {
    fn code(&self) -> Option<&str> {
        GetChannelMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChannelMessageError {
    /// Creates a new `GetChannelMessageError`.
    pub fn new(kind: GetChannelMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChannelMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChannelMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChannelMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChannelMessageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetChannelMessageErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelMessageErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelMessageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetChannelMessageErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetChannelMessageErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelMessageErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChannelMessageErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelMessageErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetChannelMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChannelMessageErrorKind::BadRequestException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::NotFoundException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetChannelMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventsConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventsConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetEventsConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventsConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventsConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request exceeds the resource limit.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventsConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventsConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetEventsConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetEventsConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetEventsConfigurationErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetEventsConfigurationErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetEventsConfigurationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetEventsConfigurationErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetEventsConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventsConfigurationError {
    fn code(&self) -> Option<&str> {
        GetEventsConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventsConfigurationError {
    /// Creates a new `GetEventsConfigurationError`.
    pub fn new(kind: GetEventsConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventsConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventsConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventsConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventsConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventsConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventsConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventsConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventsConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventsConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventsConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventsConfigurationErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventsConfigurationErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventsConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventsConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventsConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventsConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventsConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventsConfigurationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetEventsConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventsConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetEventsConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetEventsConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetEventsConfigurationErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            GetEventsConfigurationErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetEventsConfigurationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetEventsConfigurationErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetEventsConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGlobalSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGlobalSettingsError {
    /// Kind of error that occurred.
    pub kind: GetGlobalSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGlobalSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGlobalSettingsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGlobalSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGlobalSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGlobalSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetGlobalSettingsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetGlobalSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetGlobalSettingsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetGlobalSettingsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetGlobalSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGlobalSettingsError {
    fn code(&self) -> Option<&str> {
        GetGlobalSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGlobalSettingsError {
    /// Creates a new `GetGlobalSettingsError`.
    pub fn new(kind: GetGlobalSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGlobalSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGlobalSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGlobalSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGlobalSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGlobalSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGlobalSettingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGlobalSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGlobalSettingsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGlobalSettingsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGlobalSettingsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGlobalSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGlobalSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGlobalSettingsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGlobalSettingsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGlobalSettingsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGlobalSettingsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetGlobalSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGlobalSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGlobalSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetGlobalSettingsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetGlobalSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetGlobalSettingsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetGlobalSettingsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetGlobalSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMediaCapturePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMediaCapturePipelineError {
    /// Kind of error that occurred.
    pub kind: GetMediaCapturePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMediaCapturePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMediaCapturePipelineErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMediaCapturePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMediaCapturePipelineErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMediaCapturePipelineErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetMediaCapturePipelineErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetMediaCapturePipelineErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetMediaCapturePipelineErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetMediaCapturePipelineErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetMediaCapturePipelineErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetMediaCapturePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMediaCapturePipelineError {
    fn code(&self) -> Option<&str> {
        GetMediaCapturePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMediaCapturePipelineError {
    /// Creates a new `GetMediaCapturePipelineError`.
    pub fn new(kind: GetMediaCapturePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMediaCapturePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMediaCapturePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMediaCapturePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMediaCapturePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMediaCapturePipelineErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMediaCapturePipelineErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMediaCapturePipelineErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMediaCapturePipelineErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMediaCapturePipelineErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMediaCapturePipelineErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMediaCapturePipelineErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMediaCapturePipelineErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMediaCapturePipelineErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMediaCapturePipelineErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMediaCapturePipelineErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMediaCapturePipelineErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMediaCapturePipelineErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMediaCapturePipelineErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetMediaCapturePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMediaCapturePipelineErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMediaCapturePipelineErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetMediaCapturePipelineErrorKind::NotFoundException(_inner) => Some(_inner),
            GetMediaCapturePipelineErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetMediaCapturePipelineErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetMediaCapturePipelineErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetMediaCapturePipelineErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetMediaCapturePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMeetingError {
    /// Kind of error that occurred.
    pub kind: GetMeetingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMeeting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMeetingErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMeetingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMeetingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetMeetingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMeetingError {
    fn code(&self) -> Option<&str> {
        GetMeetingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMeetingError {
    /// Creates a new `GetMeetingError`.
    pub fn new(kind: GetMeetingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMeetingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMeetingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMeetingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMeetingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMeetingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, GetMeetingErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `GetMeetingErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMeetingErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetMeetingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMeetingErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMeetingErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetMeetingErrorKind::NotFoundException(_inner) => Some(_inner),
            GetMeetingErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetMeetingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetMeetingErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetMeetingErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetMeetingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMessagingSessionEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMessagingSessionEndpointError {
    /// Kind of error that occurred.
    pub kind: GetMessagingSessionEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMessagingSessionEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMessagingSessionEndpointErrorKind {
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMessagingSessionEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMessagingSessionEndpointErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetMessagingSessionEndpointErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetMessagingSessionEndpointErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetMessagingSessionEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMessagingSessionEndpointError {
    fn code(&self) -> Option<&str> {
        GetMessagingSessionEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMessagingSessionEndpointError {
    /// Creates a new `GetMessagingSessionEndpointError`.
    pub fn new(kind: GetMessagingSessionEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMessagingSessionEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMessagingSessionEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMessagingSessionEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMessagingSessionEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMessagingSessionEndpointErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMessagingSessionEndpointErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMessagingSessionEndpointErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMessagingSessionEndpointErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMessagingSessionEndpointErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetMessagingSessionEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMessagingSessionEndpointErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetMessagingSessionEndpointErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetMessagingSessionEndpointErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetMessagingSessionEndpointErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetMessagingSessionEndpointErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetMessagingSessionEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPhoneNumberError {
    /// Kind of error that occurred.
    pub kind: GetPhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPhoneNumberErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPhoneNumberErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetPhoneNumberErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetPhoneNumberErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetPhoneNumberErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetPhoneNumberErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPhoneNumberErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetPhoneNumberErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetPhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPhoneNumberError {
    fn code(&self) -> Option<&str> {
        GetPhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPhoneNumberError {
    /// Creates a new `GetPhoneNumberError`.
    pub fn new(kind: GetPhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPhoneNumberErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetPhoneNumberErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetPhoneNumberErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetPhoneNumberErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetPhoneNumberErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPhoneNumberErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPhoneNumberErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetPhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPhoneNumberErrorKind::BadRequestException(_inner) => Some(_inner),
            GetPhoneNumberErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetPhoneNumberErrorKind::NotFoundException(_inner) => Some(_inner),
            GetPhoneNumberErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetPhoneNumberErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPhoneNumberErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetPhoneNumberErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetPhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPhoneNumberOrder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPhoneNumberOrderError {
    /// Kind of error that occurred.
    pub kind: GetPhoneNumberOrderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPhoneNumberOrder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPhoneNumberOrderErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPhoneNumberOrderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPhoneNumberOrderErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetPhoneNumberOrderErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetPhoneNumberOrderErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetPhoneNumberOrderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetPhoneNumberOrderErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPhoneNumberOrderErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetPhoneNumberOrderErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetPhoneNumberOrderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPhoneNumberOrderError {
    fn code(&self) -> Option<&str> {
        GetPhoneNumberOrderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPhoneNumberOrderError {
    /// Creates a new `GetPhoneNumberOrderError`.
    pub fn new(kind: GetPhoneNumberOrderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPhoneNumberOrderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPhoneNumberOrderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPhoneNumberOrderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPhoneNumberOrderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPhoneNumberOrderErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberOrderErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberOrderErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberOrderErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberOrderErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberOrderErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberOrderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberOrderErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberOrderErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberOrderErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberOrderErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberOrderErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberOrderErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberOrderErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetPhoneNumberOrderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPhoneNumberOrderErrorKind::BadRequestException(_inner) => Some(_inner),
            GetPhoneNumberOrderErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetPhoneNumberOrderErrorKind::NotFoundException(_inner) => Some(_inner),
            GetPhoneNumberOrderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetPhoneNumberOrderErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPhoneNumberOrderErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetPhoneNumberOrderErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetPhoneNumberOrderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPhoneNumberSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPhoneNumberSettingsError {
    /// Kind of error that occurred.
    pub kind: GetPhoneNumberSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPhoneNumberSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPhoneNumberSettingsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPhoneNumberSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPhoneNumberSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetPhoneNumberSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetPhoneNumberSettingsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetPhoneNumberSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPhoneNumberSettingsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetPhoneNumberSettingsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetPhoneNumberSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPhoneNumberSettingsError {
    fn code(&self) -> Option<&str> {
        GetPhoneNumberSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPhoneNumberSettingsError {
    /// Creates a new `GetPhoneNumberSettingsError`.
    pub fn new(kind: GetPhoneNumberSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPhoneNumberSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPhoneNumberSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPhoneNumberSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPhoneNumberSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPhoneNumberSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberSettingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberSettingsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberSettingsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberSettingsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberSettingsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberSettingsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPhoneNumberSettingsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPhoneNumberSettingsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetPhoneNumberSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPhoneNumberSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetPhoneNumberSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetPhoneNumberSettingsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetPhoneNumberSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPhoneNumberSettingsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetPhoneNumberSettingsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetPhoneNumberSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProxySession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProxySessionError {
    /// Kind of error that occurred.
    pub kind: GetProxySessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProxySession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProxySessionErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProxySessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProxySessionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetProxySessionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetProxySessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetProxySessionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetProxySessionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetProxySessionErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetProxySessionErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetProxySessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProxySessionError {
    fn code(&self) -> Option<&str> {
        GetProxySessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProxySessionError {
    /// Creates a new `GetProxySessionError`.
    pub fn new(kind: GetProxySessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProxySessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProxySessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProxySessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProxySessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProxySessionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetProxySessionErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetProxySessionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetProxySessionErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetProxySessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetProxySessionErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetProxySessionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProxySessionErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProxySessionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProxySessionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProxySessionErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProxySessionErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProxySessionErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProxySessionErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetProxySessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProxySessionErrorKind::BadRequestException(_inner) => Some(_inner),
            GetProxySessionErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetProxySessionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetProxySessionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetProxySessionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetProxySessionErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetProxySessionErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetProxySessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRetentionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRetentionSettingsError {
    /// Kind of error that occurred.
    pub kind: GetRetentionSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRetentionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRetentionSettingsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRetentionSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRetentionSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRetentionSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetRetentionSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRetentionSettingsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetRetentionSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetRetentionSettingsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetRetentionSettingsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetRetentionSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRetentionSettingsError {
    fn code(&self) -> Option<&str> {
        GetRetentionSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRetentionSettingsError {
    /// Creates a new `GetRetentionSettingsError`.
    pub fn new(kind: GetRetentionSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRetentionSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRetentionSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRetentionSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRetentionSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRetentionSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetentionSettingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetentionSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetentionSettingsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetentionSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetentionSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetentionSettingsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetentionSettingsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetentionSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetentionSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetentionSettingsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetentionSettingsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetentionSettingsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetentionSettingsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetRetentionSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRetentionSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRetentionSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetRetentionSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRetentionSettingsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetRetentionSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetRetentionSettingsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetRetentionSettingsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetRetentionSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRoomError {
    /// Kind of error that occurred.
    pub kind: GetRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRoomErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRoomErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRoomError {
    fn code(&self) -> Option<&str> {
        GetRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRoomError {
    /// Creates a new `GetRoomError`.
    pub fn new(kind: GetRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRoomErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRoomErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetRoomErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetRoomErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetRoomErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `GetRoomErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::ServiceUnavailableException(_))
    }
    /// Returns `true` if the error kind is `GetRoomErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `GetRoomErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::UnauthorizedClientException(_))
    }
}
impl std::error::Error for GetRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRoomErrorKind::BadRequestException(_inner) => Some(_inner),
            GetRoomErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetRoomErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRoomErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetRoomErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetRoomErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetRoomErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSipMediaApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSipMediaApplicationError {
    /// Kind of error that occurred.
    pub kind: GetSipMediaApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSipMediaApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSipMediaApplicationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSipMediaApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSipMediaApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSipMediaApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSipMediaApplicationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSipMediaApplicationErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetSipMediaApplicationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetSipMediaApplicationErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetSipMediaApplicationErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetSipMediaApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSipMediaApplicationError {
    fn code(&self) -> Option<&str> {
        GetSipMediaApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSipMediaApplicationError {
    /// Creates a new `GetSipMediaApplicationError`.
    pub fn new(kind: GetSipMediaApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSipMediaApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSipMediaApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSipMediaApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSipMediaApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetSipMediaApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSipMediaApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSipMediaApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSipMediaApplicationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSipMediaApplicationErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetSipMediaApplicationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetSipMediaApplicationErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetSipMediaApplicationErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetSipMediaApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSipMediaApplicationLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSipMediaApplicationLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetSipMediaApplicationLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSipMediaApplicationLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSipMediaApplicationLoggingConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSipMediaApplicationLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSipMediaApplicationLoggingConfigurationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetSipMediaApplicationLoggingConfigurationErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            GetSipMediaApplicationLoggingConfigurationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceFailureException(
                _inner,
            ) => _inner.fmt(f),
            GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            GetSipMediaApplicationLoggingConfigurationErrorKind::ThrottledClientException(
                _inner,
            ) => _inner.fmt(f),
            GetSipMediaApplicationLoggingConfigurationErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            GetSipMediaApplicationLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSipMediaApplicationLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        GetSipMediaApplicationLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSipMediaApplicationLoggingConfigurationError {
    /// Creates a new `GetSipMediaApplicationLoggingConfigurationError`.
    pub fn new(
        kind: GetSipMediaApplicationLoggingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSipMediaApplicationLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSipMediaApplicationLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSipMediaApplicationLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSipMediaApplicationLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationLoggingConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationLoggingConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationLoggingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationLoggingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationLoggingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationLoggingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationLoggingConfigurationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationLoggingConfigurationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipMediaApplicationLoggingConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipMediaApplicationLoggingConfigurationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetSipMediaApplicationLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSipMediaApplicationLoggingConfigurationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetSipMediaApplicationLoggingConfigurationErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            GetSipMediaApplicationLoggingConfigurationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceFailureException(
                _inner,
            ) => Some(_inner),
            GetSipMediaApplicationLoggingConfigurationErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            GetSipMediaApplicationLoggingConfigurationErrorKind::ThrottledClientException(
                _inner,
            ) => Some(_inner),
            GetSipMediaApplicationLoggingConfigurationErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            GetSipMediaApplicationLoggingConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetSipRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSipRuleError {
    /// Kind of error that occurred.
    pub kind: GetSipRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSipRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSipRuleErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSipRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSipRuleErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSipRuleErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetSipRuleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSipRuleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetSipRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetSipRuleErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetSipRuleErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetSipRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSipRuleError {
    fn code(&self) -> Option<&str> {
        GetSipRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSipRuleError {
    /// Creates a new `GetSipRuleError`.
    pub fn new(kind: GetSipRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSipRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSipRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSipRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSipRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSipRuleErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSipRuleErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetSipRuleErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetSipRuleErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetSipRuleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSipRuleErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSipRuleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetSipRuleErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `GetSipRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSipRuleErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, GetSipRuleErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `GetSipRuleErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSipRuleErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetSipRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSipRuleErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSipRuleErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetSipRuleErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSipRuleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetSipRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetSipRuleErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetSipRuleErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetSipRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserError {
    /// Kind of error that occurred.
    pub kind: GetUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetUserErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserError {
    fn code(&self) -> Option<&str> {
        GetUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserError {
    /// Creates a new `GetUserError`.
    pub fn new(kind: GetUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ServiceUnavailableException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::UnauthorizedClientException(_))
    }
}
impl std::error::Error for GetUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUserErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetUserErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetUserErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetUserErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserSettingsError {
    /// Kind of error that occurred.
    pub kind: GetUserSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserSettingsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserSettingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetUserSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserSettingsError {
    fn code(&self) -> Option<&str> {
        GetUserSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserSettingsError {
    /// Creates a new `GetUserSettingsError`.
    pub fn new(kind: GetUserSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetUserSettingsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetUserSettingsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUserSettingsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserSettingsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserSettingsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserSettingsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserSettingsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetUserSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserSettingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetUserSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVoiceConnectorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetVoiceConnectorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceConnectorErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetVoiceConnectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetVoiceConnectorErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetVoiceConnectorErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetVoiceConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorError {
    /// Creates a new `GetVoiceConnectorError`.
    pub fn new(kind: GetVoiceConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetVoiceConnectorErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVoiceConnectorErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceConnectorErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceConnectorErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetVoiceConnectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetVoiceConnectorErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetVoiceConnectorErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetVoiceConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceConnectorEmergencyCallingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorEmergencyCallingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorEmergencyCallingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorEmergencyCallingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorEmergencyCallingConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorEmergencyCallingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException(_inner) =>
            _inner.fmt(f)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException(_inner) =>
            _inner.fmt(f)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException(_inner) =>
            _inner.fmt(f)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException(_inner) =>
            _inner.fmt(f)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException(_inner) =>
            _inner.fmt(f)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for GetVoiceConnectorEmergencyCallingConfigurationError
{
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorEmergencyCallingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorEmergencyCallingConfigurationError {
    /// Creates a new `GetVoiceConnectorEmergencyCallingConfigurationError`.
    pub fn new(
        kind: GetVoiceConnectorEmergencyCallingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorEmergencyCallingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorEmergencyCallingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorEmergencyCallingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::BadRequestException(_inner) =>
            Some(_inner)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ForbiddenException(_inner) =>
            Some(_inner)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::NotFoundException(_inner) =>
            Some(_inner)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceFailureException(_inner) =>
            Some(_inner)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ServiceUnavailableException(_inner) =>
            Some(_inner)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::ThrottledClientException(_inner) =>
            Some(_inner)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::UnauthorizedClientException(_inner) =>
            Some(_inner)
            ,
            GetVoiceConnectorEmergencyCallingConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorGroupError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorGroupErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetVoiceConnectorGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetVoiceConnectorGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorGroupError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorGroupError {
    /// Creates a new `GetVoiceConnectorGroupError`.
    pub fn new(kind: GetVoiceConnectorGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorGroupErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorGroupErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorGroupErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorGroupErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorGroupErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorGroupErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorGroupErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorGroupErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVoiceConnectorGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceConnectorGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceConnectorGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetVoiceConnectorGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetVoiceConnectorGroupErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetVoiceConnectorGroupErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetVoiceConnectorGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceConnectorLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorLoggingConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorLoggingConfigurationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorLoggingConfigurationError {
    /// Creates a new `GetVoiceConnectorLoggingConfigurationError`.
    pub fn new(
        kind: GetVoiceConnectorLoggingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorLoggingConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorLoggingConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorLoggingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorLoggingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorLoggingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorLoggingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorLoggingConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorLoggingConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorLoggingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorLoggingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorLoggingConfigurationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorLoggingConfigurationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorLoggingConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorLoggingConfigurationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorLoggingConfigurationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorLoggingConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetVoiceConnectorOrigination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorOriginationError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorOriginationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorOrigination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorOriginationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorOriginationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorOriginationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVoiceConnectorOriginationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetVoiceConnectorOriginationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceConnectorOriginationErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetVoiceConnectorOriginationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorOriginationErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorOriginationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorOriginationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorOriginationError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorOriginationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorOriginationError {
    /// Creates a new `GetVoiceConnectorOriginationError`.
    pub fn new(kind: GetVoiceConnectorOriginationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorOriginationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorOriginationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorOriginationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorOriginationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorOriginationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorOriginationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorOriginationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorOriginationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorOriginationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorOriginationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorOriginationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorOriginationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorOriginationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorOriginationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorOriginationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorOriginationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorOriginationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorOriginationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorOriginationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorOriginationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVoiceConnectorOriginationErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceConnectorOriginationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceConnectorOriginationErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetVoiceConnectorOriginationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorOriginationErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetVoiceConnectorOriginationErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorOriginationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceConnectorProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorProxyError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorProxyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorProxyErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorProxyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorProxyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVoiceConnectorProxyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetVoiceConnectorProxyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceConnectorProxyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetVoiceConnectorProxyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetVoiceConnectorProxyErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            GetVoiceConnectorProxyErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            GetVoiceConnectorProxyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorProxyError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorProxyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorProxyError {
    /// Creates a new `GetVoiceConnectorProxyError`.
    pub fn new(kind: GetVoiceConnectorProxyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorProxyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorProxyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorProxyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorProxyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorProxyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorProxyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorProxyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorProxyErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorProxyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorProxyErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorProxyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorProxyErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorProxyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorProxyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorProxyErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorProxyErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorProxyErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorProxyErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorProxyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorProxyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVoiceConnectorProxyErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceConnectorProxyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceConnectorProxyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetVoiceConnectorProxyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetVoiceConnectorProxyErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetVoiceConnectorProxyErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            GetVoiceConnectorProxyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceConnectorStreamingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorStreamingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorStreamingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorStreamingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorStreamingConfigurationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorStreamingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorStreamingConfigurationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            GetVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            GetVoiceConnectorStreamingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorStreamingConfigurationError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorStreamingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorStreamingConfigurationError {
    /// Creates a new `GetVoiceConnectorStreamingConfigurationError`.
    pub fn new(
        kind: GetVoiceConnectorStreamingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorStreamingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorStreamingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorStreamingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorStreamingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorStreamingConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorStreamingConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorStreamingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorStreamingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorStreamingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorStreamingConfigurationErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            GetVoiceConnectorStreamingConfigurationErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorStreamingConfigurationErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            GetVoiceConnectorStreamingConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetVoiceConnectorTermination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorTerminationError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorTerminationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorTermination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorTerminationErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorTerminationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorTerminationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetVoiceConnectorTerminationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetVoiceConnectorTerminationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceConnectorTerminationErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetVoiceConnectorTerminationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorTerminationError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorTerminationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorTerminationError {
    /// Creates a new `GetVoiceConnectorTerminationError`.
    pub fn new(kind: GetVoiceConnectorTerminationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorTerminationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorTerminationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorTerminationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorTerminationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorTerminationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorTerminationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetVoiceConnectorTerminationErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceConnectorTerminationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceConnectorTerminationErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetVoiceConnectorTerminationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorTerminationErrorKind::ThrottledClientException(_inner) => Some(_inner),
            GetVoiceConnectorTerminationErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorTerminationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVoiceConnectorTerminationHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVoiceConnectorTerminationHealthError {
    /// Kind of error that occurred.
    pub kind: GetVoiceConnectorTerminationHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVoiceConnectorTerminationHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVoiceConnectorTerminationHealthErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVoiceConnectorTerminationHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVoiceConnectorTerminationHealthErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationHealthErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationHealthErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVoiceConnectorTerminationHealthErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationHealthErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationHealthErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationHealthErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            GetVoiceConnectorTerminationHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVoiceConnectorTerminationHealthError {
    fn code(&self) -> Option<&str> {
        GetVoiceConnectorTerminationHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVoiceConnectorTerminationHealthError {
    /// Creates a new `GetVoiceConnectorTerminationHealthError`.
    pub fn new(
        kind: GetVoiceConnectorTerminationHealthErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVoiceConnectorTerminationHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVoiceConnectorTerminationHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVoiceConnectorTerminationHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVoiceConnectorTerminationHealthErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationHealthErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationHealthErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationHealthErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationHealthErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationHealthErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationHealthErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationHealthErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationHealthErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationHealthErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationHealthErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationHealthErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationHealthErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVoiceConnectorTerminationHealthErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVoiceConnectorTerminationHealthErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for GetVoiceConnectorTerminationHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVoiceConnectorTerminationHealthErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorTerminationHealthErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetVoiceConnectorTerminationHealthErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVoiceConnectorTerminationHealthErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorTerminationHealthErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorTerminationHealthErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorTerminationHealthErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            GetVoiceConnectorTerminationHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InviteUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InviteUsersError {
    /// Kind of error that occurred.
    pub kind: InviteUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InviteUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InviteUsersErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InviteUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InviteUsersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            InviteUsersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            InviteUsersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            InviteUsersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            InviteUsersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            InviteUsersErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            InviteUsersErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            InviteUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InviteUsersError {
    fn code(&self) -> Option<&str> {
        InviteUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InviteUsersError {
    /// Creates a new `InviteUsersError`.
    pub fn new(kind: InviteUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InviteUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InviteUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InviteUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InviteUsersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InviteUsersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, InviteUsersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `InviteUsersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, InviteUsersErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `InviteUsersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, InviteUsersErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `InviteUsersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, InviteUsersErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `InviteUsersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteUsersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteUsersErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteUsersErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `InviteUsersErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteUsersErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for InviteUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InviteUsersErrorKind::BadRequestException(_inner) => Some(_inner),
            InviteUsersErrorKind::ForbiddenException(_inner) => Some(_inner),
            InviteUsersErrorKind::NotFoundException(_inner) => Some(_inner),
            InviteUsersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            InviteUsersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            InviteUsersErrorKind::ThrottledClientException(_inner) => Some(_inner),
            InviteUsersErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            InviteUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountsError {
    /// Kind of error that occurred.
    pub kind: ListAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountsError {
    fn code(&self) -> Option<&str> {
        ListAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountsError {
    /// Creates a new `ListAccountsError`.
    pub fn new(kind: ListAccountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListAccountsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListAccountsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAccountsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAccountsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAccountsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListAccountsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAccountsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAccountsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListAccountsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAppInstanceAdmins` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAppInstanceAdminsError {
    /// Kind of error that occurred.
    pub kind: ListAppInstanceAdminsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAppInstanceAdmins` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAppInstanceAdminsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAppInstanceAdminsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAppInstanceAdminsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAppInstanceAdminsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAppInstanceAdminsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAppInstanceAdminsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAppInstanceAdminsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListAppInstanceAdminsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListAppInstanceAdminsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAppInstanceAdminsError {
    fn code(&self) -> Option<&str> {
        ListAppInstanceAdminsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAppInstanceAdminsError {
    /// Creates a new `ListAppInstanceAdminsError`.
    pub fn new(kind: ListAppInstanceAdminsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAppInstanceAdminsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAppInstanceAdminsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAppInstanceAdminsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAppInstanceAdminsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAppInstanceAdminsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceAdminsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceAdminsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceAdminsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceAdminsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceAdminsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceAdminsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceAdminsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceAdminsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceAdminsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceAdminsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceAdminsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListAppInstanceAdminsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAppInstanceAdminsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAppInstanceAdminsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAppInstanceAdminsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAppInstanceAdminsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAppInstanceAdminsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListAppInstanceAdminsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListAppInstanceAdminsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAppInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAppInstancesError {
    /// Kind of error that occurred.
    pub kind: ListAppInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAppInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAppInstancesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAppInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAppInstancesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAppInstancesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAppInstancesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAppInstancesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAppInstancesErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListAppInstancesErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListAppInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAppInstancesError {
    fn code(&self) -> Option<&str> {
        ListAppInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAppInstancesError {
    /// Creates a new `ListAppInstancesError`.
    pub fn new(kind: ListAppInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAppInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAppInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAppInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAppInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAppInstancesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstancesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstancesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListAppInstancesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListAppInstancesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstancesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstancesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstancesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstancesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstancesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstancesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstancesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListAppInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAppInstancesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAppInstancesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAppInstancesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAppInstancesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAppInstancesErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListAppInstancesErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListAppInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAppInstanceUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAppInstanceUsersError {
    /// Kind of error that occurred.
    pub kind: ListAppInstanceUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAppInstanceUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAppInstanceUsersErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAppInstanceUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAppInstanceUsersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAppInstanceUsersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAppInstanceUsersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAppInstanceUsersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAppInstanceUsersErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListAppInstanceUsersErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListAppInstanceUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAppInstanceUsersError {
    fn code(&self) -> Option<&str> {
        ListAppInstanceUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAppInstanceUsersError {
    /// Creates a new `ListAppInstanceUsersError`.
    pub fn new(kind: ListAppInstanceUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAppInstanceUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAppInstanceUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAppInstanceUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAppInstanceUsersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAppInstanceUsersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceUsersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceUsersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceUsersErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceUsersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceUsersErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceUsersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceUsersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceUsersErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceUsersErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAppInstanceUsersErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppInstanceUsersErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListAppInstanceUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAppInstanceUsersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAppInstanceUsersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAppInstanceUsersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAppInstanceUsersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAppInstanceUsersErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListAppInstanceUsersErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListAppInstanceUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttendeesError {
    /// Kind of error that occurred.
    pub kind: ListAttendeesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttendees` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttendeesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttendeesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttendeesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListAttendeesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttendeesError {
    fn code(&self) -> Option<&str> {
        ListAttendeesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttendeesError {
    /// Creates a new `ListAttendeesError`.
    pub fn new(kind: ListAttendeesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttendeesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttendeesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttendeesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttendeesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttendeesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListAttendeesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttendeesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAttendeesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAttendeesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListAttendeesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAttendeesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAttendeesErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListAttendeesErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListAttendeesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttendeeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttendeeTagsError {
    /// Kind of error that occurred.
    pub kind: ListAttendeeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttendeeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttendeeTagsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttendeeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttendeeTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAttendeeTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListAttendeeTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListAttendeeTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAttendeeTagsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAttendeeTagsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListAttendeeTagsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListAttendeeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttendeeTagsError {
    fn code(&self) -> Option<&str> {
        ListAttendeeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttendeeTagsError {
    /// Creates a new `ListAttendeeTagsError`.
    pub fn new(kind: ListAttendeeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttendeeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttendeeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttendeeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttendeeTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttendeeTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeeTagsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttendeeTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeeTagsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListAttendeeTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAttendeeTagsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListAttendeeTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeeTagsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttendeeTagsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeeTagsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttendeeTagsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeeTagsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttendeeTagsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttendeeTagsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListAttendeeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttendeeTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAttendeeTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListAttendeeTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListAttendeeTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAttendeeTagsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAttendeeTagsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListAttendeeTagsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListAttendeeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBotsError {
    /// Kind of error that occurred.
    pub kind: ListBotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBotsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBotsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBotsError {
    fn code(&self) -> Option<&str> {
        ListBotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBotsError {
    /// Creates a new `ListBotsError`.
    pub fn new(kind: ListBotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListBotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBotsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListBotsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListBotsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListBotsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListBotsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBotsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListBotsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListBotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelBans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelBansError {
    /// Kind of error that occurred.
    pub kind: ListChannelBansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelBans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelBansErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelBansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelBansErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelBansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelBansError {
    fn code(&self) -> Option<&str> {
        ListChannelBansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelBansError {
    /// Creates a new `ListChannelBansError`.
    pub fn new(kind: ListChannelBansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelBansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelBansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelBansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelBansErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelBansErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListChannelBansErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListChannelBansErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListChannelBansErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListChannelBansErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelBansErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelBansErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelBansErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelBansErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelBansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelBansErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelBansErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelBansErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelBansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelMembershipsError {
    /// Kind of error that occurred.
    pub kind: ListChannelMembershipsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelMembershipsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelMembershipsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelMembershipsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelMembershipsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelMembershipsError {
    fn code(&self) -> Option<&str> {
        ListChannelMembershipsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelMembershipsError {
    /// Creates a new `ListChannelMembershipsError`.
    pub fn new(kind: ListChannelMembershipsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelMembershipsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelMembershipsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelMembershipsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelMembershipsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelMembershipsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelMembershipsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelMembershipsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelMembershipsForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelMembershipsForAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: ListChannelMembershipsForAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelMembershipsForAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelMembershipsForAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelMembershipsForAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelMembershipsForAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        ListChannelMembershipsForAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelMembershipsForAppInstanceUserError {
    /// Creates a new `ListChannelMembershipsForAppInstanceUserError`.
    pub fn new(
        kind: ListChannelMembershipsForAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelMembershipsForAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelMembershipsForAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelMembershipsForAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelMembershipsForAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            ListChannelMembershipsForAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            ListChannelMembershipsForAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            ListChannelMembershipsForAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListChannelMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelMessagesError {
    /// Kind of error that occurred.
    pub kind: ListChannelMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelMessagesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelMessagesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelMessagesError {
    fn code(&self) -> Option<&str> {
        ListChannelMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelMessagesError {
    /// Creates a new `ListChannelMessagesError`.
    pub fn new(kind: ListChannelMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelMessagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelMessagesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMessagesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMessagesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMessagesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMessagesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelMessagesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelMessagesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelMessagesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelModerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelModeratorsError {
    /// Kind of error that occurred.
    pub kind: ListChannelModeratorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelModerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelModeratorsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelModeratorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelModeratorsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelModeratorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelModeratorsError {
    fn code(&self) -> Option<&str> {
        ListChannelModeratorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelModeratorsError {
    /// Creates a new `ListChannelModeratorsError`.
    pub fn new(kind: ListChannelModeratorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelModeratorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelModeratorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelModeratorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelModeratorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelModeratorsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelModeratorsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelModeratorsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelModeratorsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelModeratorsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelModeratorsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelModeratorsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelModeratorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelModeratorsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelModeratorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsError {
    /// Kind of error that occurred.
    pub kind: ListChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsError {
    fn code(&self) -> Option<&str> {
        ListChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsError {
    /// Creates a new `ListChannelsError`.
    pub fn new(kind: ListChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListChannelsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListChannelsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListChannelsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListChannelsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannelsModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsModeratedByAppInstanceUserError {
    /// Kind of error that occurred.
    pub kind: ListChannelsModeratedByAppInstanceUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannelsModeratedByAppInstanceUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsModeratedByAppInstanceUserErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsModeratedByAppInstanceUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => _inner.fmt(f),
            ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsModeratedByAppInstanceUserError {
    fn code(&self) -> Option<&str> {
        ListChannelsModeratedByAppInstanceUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsModeratedByAppInstanceUserError {
    /// Creates a new `ListChannelsModeratedByAppInstanceUserError`.
    pub fn new(
        kind: ListChannelsModeratedByAppInstanceUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsModeratedByAppInstanceUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsModeratedByAppInstanceUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListChannelsModeratedByAppInstanceUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsModeratedByAppInstanceUserErrorKind::BadRequestException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ForbiddenException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::ServiceUnavailableException(
                _inner,
            ) => Some(_inner),
            ListChannelsModeratedByAppInstanceUserErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            ListChannelsModeratedByAppInstanceUserErrorKind::UnauthorizedClientException(
                _inner,
            ) => Some(_inner),
            ListChannelsModeratedByAppInstanceUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListMediaCapturePipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMediaCapturePipelinesError {
    /// Kind of error that occurred.
    pub kind: ListMediaCapturePipelinesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMediaCapturePipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMediaCapturePipelinesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMediaCapturePipelinesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMediaCapturePipelinesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListMediaCapturePipelinesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListMediaCapturePipelinesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListMediaCapturePipelinesErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListMediaCapturePipelinesErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListMediaCapturePipelinesErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            ListMediaCapturePipelinesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMediaCapturePipelinesError {
    fn code(&self) -> Option<&str> {
        ListMediaCapturePipelinesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMediaCapturePipelinesError {
    /// Creates a new `ListMediaCapturePipelinesError`.
    pub fn new(kind: ListMediaCapturePipelinesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMediaCapturePipelinesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMediaCapturePipelinesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMediaCapturePipelinesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMediaCapturePipelinesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMediaCapturePipelinesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMediaCapturePipelinesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMediaCapturePipelinesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMediaCapturePipelinesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMediaCapturePipelinesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMediaCapturePipelinesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMediaCapturePipelinesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMediaCapturePipelinesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMediaCapturePipelinesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMediaCapturePipelinesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMediaCapturePipelinesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMediaCapturePipelinesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListMediaCapturePipelinesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMediaCapturePipelinesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListMediaCapturePipelinesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListMediaCapturePipelinesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListMediaCapturePipelinesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListMediaCapturePipelinesErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListMediaCapturePipelinesErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListMediaCapturePipelinesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMeetings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMeetingsError {
    /// Kind of error that occurred.
    pub kind: ListMeetingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMeetings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMeetingsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMeetingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMeetingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListMeetingsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListMeetingsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListMeetingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListMeetingsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListMeetingsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListMeetingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMeetingsError {
    fn code(&self) -> Option<&str> {
        ListMeetingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMeetingsError {
    /// Creates a new `ListMeetingsError`.
    pub fn new(kind: ListMeetingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMeetingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMeetingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMeetingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMeetingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMeetingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListMeetingsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListMeetingsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListMeetingsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListMeetingsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeetingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeetingsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeetingsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListMeetingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMeetingsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListMeetingsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListMeetingsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListMeetingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListMeetingsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListMeetingsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListMeetingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMeetingTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMeetingTagsError {
    /// Kind of error that occurred.
    pub kind: ListMeetingTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMeetingTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMeetingTagsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMeetingTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMeetingTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListMeetingTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListMeetingTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListMeetingTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListMeetingTagsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListMeetingTagsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListMeetingTagsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListMeetingTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMeetingTagsError {
    fn code(&self) -> Option<&str> {
        ListMeetingTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMeetingTagsError {
    /// Creates a new `ListMeetingTagsError`.
    pub fn new(kind: ListMeetingTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMeetingTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMeetingTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMeetingTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMeetingTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMeetingTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListMeetingTagsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListMeetingTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListMeetingTagsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListMeetingTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListMeetingTagsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListMeetingTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingTagsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeetingTagsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingTagsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeetingTagsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingTagsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeetingTagsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeetingTagsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListMeetingTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMeetingTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListMeetingTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListMeetingTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListMeetingTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListMeetingTagsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListMeetingTagsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListMeetingTagsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListMeetingTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPhoneNumberOrders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPhoneNumberOrdersError {
    /// Kind of error that occurred.
    pub kind: ListPhoneNumberOrdersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPhoneNumberOrders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPhoneNumberOrdersErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPhoneNumberOrdersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPhoneNumberOrdersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListPhoneNumberOrdersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListPhoneNumberOrdersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListPhoneNumberOrdersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPhoneNumberOrdersErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListPhoneNumberOrdersErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListPhoneNumberOrdersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPhoneNumberOrdersError {
    fn code(&self) -> Option<&str> {
        ListPhoneNumberOrdersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPhoneNumberOrdersError {
    /// Creates a new `ListPhoneNumberOrdersError`.
    pub fn new(kind: ListPhoneNumberOrdersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPhoneNumberOrdersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPhoneNumberOrdersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPhoneNumberOrdersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPhoneNumberOrdersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPhoneNumberOrdersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumberOrdersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumberOrdersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumberOrdersErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumberOrdersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumberOrdersErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumberOrdersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumberOrdersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumberOrdersErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumberOrdersErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumberOrdersErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumberOrdersErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListPhoneNumberOrdersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPhoneNumberOrdersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListPhoneNumberOrdersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListPhoneNumberOrdersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListPhoneNumberOrdersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPhoneNumberOrdersErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListPhoneNumberOrdersErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListPhoneNumberOrdersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPhoneNumbersError {
    /// Kind of error that occurred.
    pub kind: ListPhoneNumbersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPhoneNumbersErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPhoneNumbersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPhoneNumbersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPhoneNumbersError {
    fn code(&self) -> Option<&str> {
        ListPhoneNumbersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPhoneNumbersError {
    /// Creates a new `ListPhoneNumbersError`.
    pub fn new(kind: ListPhoneNumbersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPhoneNumbersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPhoneNumbersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPhoneNumbersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPhoneNumbersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListPhoneNumbersErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListPhoneNumbersErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListPhoneNumbersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPhoneNumbersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::NotFoundException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProxySessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProxySessionsError {
    /// Kind of error that occurred.
    pub kind: ListProxySessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProxySessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProxySessionsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProxySessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProxySessionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListProxySessionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListProxySessionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListProxySessionsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListProxySessionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListProxySessionsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListProxySessionsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListProxySessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProxySessionsError {
    fn code(&self) -> Option<&str> {
        ListProxySessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProxySessionsError {
    /// Creates a new `ListProxySessionsError`.
    pub fn new(kind: ListProxySessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProxySessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProxySessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProxySessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProxySessionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProxySessionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProxySessionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProxySessionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProxySessionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProxySessionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListProxySessionsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListProxySessionsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProxySessionsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProxySessionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProxySessionsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProxySessionsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProxySessionsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProxySessionsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProxySessionsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListProxySessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProxySessionsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListProxySessionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListProxySessionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListProxySessionsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListProxySessionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListProxySessionsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListProxySessionsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListProxySessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoomMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoomMembershipsError {
    /// Kind of error that occurred.
    pub kind: ListRoomMembershipsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoomMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoomMembershipsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoomMembershipsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoomMembershipsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListRoomMembershipsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListRoomMembershipsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListRoomMembershipsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListRoomMembershipsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListRoomMembershipsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListRoomMembershipsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListRoomMembershipsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoomMembershipsError {
    fn code(&self) -> Option<&str> {
        ListRoomMembershipsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoomMembershipsError {
    /// Creates a new `ListRoomMembershipsError`.
    pub fn new(kind: ListRoomMembershipsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoomMembershipsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoomMembershipsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoomMembershipsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoomMembershipsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoomMembershipsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomMembershipsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoomMembershipsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomMembershipsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoomMembershipsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomMembershipsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoomMembershipsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomMembershipsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoomMembershipsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomMembershipsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoomMembershipsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomMembershipsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoomMembershipsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomMembershipsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListRoomMembershipsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoomMembershipsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListRoomMembershipsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListRoomMembershipsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListRoomMembershipsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListRoomMembershipsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListRoomMembershipsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListRoomMembershipsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListRoomMembershipsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRooms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoomsError {
    /// Kind of error that occurred.
    pub kind: ListRoomsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRooms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoomsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoomsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoomsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListRoomsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListRoomsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListRoomsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListRoomsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListRoomsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListRoomsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListRoomsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoomsError {
    fn code(&self) -> Option<&str> {
        ListRoomsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoomsError {
    /// Creates a new `ListRoomsError`.
    pub fn new(kind: ListRoomsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoomsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoomsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoomsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoomsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoomsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListRoomsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListRoomsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListRoomsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListRoomsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListRoomsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListRoomsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, ListRoomsErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `ListRoomsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoomsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, ListRoomsErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `ListRoomsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoomsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListRoomsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoomsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListRoomsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListRoomsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListRoomsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListRoomsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListRoomsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListRoomsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListRoomsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSipMediaApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSipMediaApplicationsError {
    /// Kind of error that occurred.
    pub kind: ListSipMediaApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSipMediaApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSipMediaApplicationsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSipMediaApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSipMediaApplicationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListSipMediaApplicationsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListSipMediaApplicationsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListSipMediaApplicationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListSipMediaApplicationsErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListSipMediaApplicationsErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListSipMediaApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSipMediaApplicationsError {
    fn code(&self) -> Option<&str> {
        ListSipMediaApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSipMediaApplicationsError {
    /// Creates a new `ListSipMediaApplicationsError`.
    pub fn new(kind: ListSipMediaApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSipMediaApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSipMediaApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSipMediaApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSipMediaApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSipMediaApplicationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipMediaApplicationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipMediaApplicationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipMediaApplicationsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipMediaApplicationsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipMediaApplicationsErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipMediaApplicationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipMediaApplicationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipMediaApplicationsErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipMediaApplicationsErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipMediaApplicationsErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipMediaApplicationsErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListSipMediaApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSipMediaApplicationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListSipMediaApplicationsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListSipMediaApplicationsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListSipMediaApplicationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListSipMediaApplicationsErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListSipMediaApplicationsErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListSipMediaApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSipRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSipRulesError {
    /// Kind of error that occurred.
    pub kind: ListSipRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSipRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSipRulesErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSipRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSipRulesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListSipRulesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListSipRulesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListSipRulesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListSipRulesErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListSipRulesErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListSipRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSipRulesError {
    fn code(&self) -> Option<&str> {
        ListSipRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSipRulesError {
    /// Creates a new `ListSipRulesError`.
    pub fn new(kind: ListSipRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSipRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSipRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSipRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSipRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSipRulesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListSipRulesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListSipRulesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListSipRulesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListSipRulesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipRulesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipRulesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipRulesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipRulesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipRulesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSipRulesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSipRulesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListSipRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSipRulesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListSipRulesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListSipRulesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListSipRulesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListSipRulesErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListSipRulesErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListSipRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSupportedPhoneNumberCountries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSupportedPhoneNumberCountriesError {
    /// Kind of error that occurred.
    pub kind: ListSupportedPhoneNumberCountriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSupportedPhoneNumberCountries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSupportedPhoneNumberCountriesErrorKind {
    /// <p>You don't have permissions to perform the requested operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSupportedPhoneNumberCountriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSupportedPhoneNumberCountriesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListSupportedPhoneNumberCountriesErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListSupportedPhoneNumberCountriesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListSupportedPhoneNumberCountriesErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListSupportedPhoneNumberCountriesErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListSupportedPhoneNumberCountriesErrorKind::ThrottledClientException(_inner) => {
                _inner.fmt(f)
            }
            ListSupportedPhoneNumberCountriesErrorKind::UnauthorizedClientException(_inner) => {
                _inner.fmt(f)
            }
            ListSupportedPhoneNumberCountriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSupportedPhoneNumberCountriesError {
    fn code(&self) -> Option<&str> {
        ListSupportedPhoneNumberCountriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSupportedPhoneNumberCountriesError {
    /// Creates a new `ListSupportedPhoneNumberCountriesError`.
    pub fn new(
        kind: ListSupportedPhoneNumberCountriesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSupportedPhoneNumberCountriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSupportedPhoneNumberCountriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSupportedPhoneNumberCountriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSupportedPhoneNumberCountriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSupportedPhoneNumberCountriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSupportedPhoneNumberCountriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSupportedPhoneNumberCountriesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSupportedPhoneNumberCountriesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSupportedPhoneNumberCountriesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSupportedPhoneNumberCountriesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSupportedPhoneNumberCountriesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSupportedPhoneNumberCountriesErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSupportedPhoneNumberCountriesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSupportedPhoneNumberCountriesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSupportedPhoneNumberCountriesErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSupportedPhoneNumberCountriesErrorKind::ThrottledClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSupportedPhoneNumberCountriesErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSupportedPhoneNumberCountriesErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListSupportedPhoneNumberCountriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSupportedPhoneNumberCountriesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListSupportedPhoneNumberCountriesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListSupportedPhoneNumberCountriesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListSupportedPhoneNumberCountriesErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            ListSupportedPhoneNumberCountriesErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ListSupportedPhoneNumberCountriesErrorKind::ThrottledClientException(_inner) => {
                Some(_inner)
            }
            ListSupportedPhoneNumberCountriesErrorKind::UnauthorizedClientException(_inner) => {
                Some(_inner)
            }
            ListSupportedPhoneNumberCountriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>One or more of the resources in the request does not exist in the system.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ThrottledClientException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::UnauthorizedClientException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ThrottledClientException`.
    pub fn is_throttled_client_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ThrottledClientException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::UnauthorizedClientException`.
    pub fn is_unauthorized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::UnauthorizedClientException(_)
        )
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListUsersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListUsersErrorKind::NotFoundException(_inner) => Some(_inner),
            ListUsersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListUsersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListUsersErrorKind::ThrottledClientException(_inner) => Some(_inner),
            ListUsersErrorKind::UnauthorizedClientException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVoiceConnectorGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVoiceConnectorGroupsError {
    /// Kind of error that occurred.
    pub kind: ListVoiceConnectorGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVoiceConnectorGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVoiceConnectorGroupsErrorKind {
    /// <p>The input parameters don't match the service's restrictions.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is permanently forbidden from making the request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The service encountered an unexpected error.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The client exceeded its request rate limit.</p>
    ThrottledClientException(crate::error::ThrottledClientException),
    /// <p>The client is not currently authorized to make the request.</p>
    UnauthorizedClientException(crate::error::UnauthorizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVoiceConnectorGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVoiceConnectorGroupsErrorK