// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Chime
///
/// Client for invoking operations on Amazon Chime. Each operation on Amazon Chime is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_chime::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_chime::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_chime::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociatePhoneNumbersWithVoiceConnector`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`e164_phone_numbers(Vec<String>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector::e164_phone_numbers) / [`set_e164_phone_numbers(Option<Vec<String>>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector::set_e164_phone_numbers): <p>List of phone numbers, in E.164 format.</p>
    ///   - [`force_associate(bool)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector::force_associate) / [`set_force_associate(Option<bool>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector::set_force_associate): <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
    /// - On success, responds with [`AssociatePhoneNumbersWithVoiceConnectorOutput`](crate::output::AssociatePhoneNumbersWithVoiceConnectorOutput) with field(s):
    ///   - [`phone_number_errors(Option<Vec<PhoneNumberError>>)`](crate::output::AssociatePhoneNumbersWithVoiceConnectorOutput::phone_number_errors): <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<AssociatePhoneNumbersWithVoiceConnectorError>`](crate::error::AssociatePhoneNumbersWithVoiceConnectorError)
    pub fn associate_phone_numbers_with_voice_connector(
        &self,
    ) -> fluent_builders::AssociatePhoneNumbersWithVoiceConnector<C, M, R> {
        fluent_builders::AssociatePhoneNumbersWithVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociatePhoneNumbersWithVoiceConnectorGroup`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_group_id(impl Into<String>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::voice_connector_group_id) / [`set_voice_connector_group_id(Option<String>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::set_voice_connector_group_id): <p>The Amazon Chime Voice Connector group ID.</p>
    ///   - [`e164_phone_numbers(Vec<String>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::e164_phone_numbers) / [`set_e164_phone_numbers(Option<Vec<String>>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::set_e164_phone_numbers): <p>List of phone numbers, in E.164 format.</p>
    ///   - [`force_associate(bool)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::force_associate) / [`set_force_associate(Option<bool>)`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::set_force_associate): <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
    /// - On success, responds with [`AssociatePhoneNumbersWithVoiceConnectorGroupOutput`](crate::output::AssociatePhoneNumbersWithVoiceConnectorGroupOutput) with field(s):
    ///   - [`phone_number_errors(Option<Vec<PhoneNumberError>>)`](crate::output::AssociatePhoneNumbersWithVoiceConnectorGroupOutput::phone_number_errors): <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<AssociatePhoneNumbersWithVoiceConnectorGroupError>`](crate::error::AssociatePhoneNumbersWithVoiceConnectorGroupError)
    pub fn associate_phone_numbers_with_voice_connector_group(
        &self,
    ) -> fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup<C, M, R> {
        fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociatePhoneNumberWithUser`](crate::client::fluent_builders::AssociatePhoneNumberWithUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::AssociatePhoneNumberWithUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::AssociatePhoneNumberWithUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::AssociatePhoneNumberWithUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::AssociatePhoneNumberWithUser::set_user_id): <p>The user ID.</p>
    ///   - [`e164_phone_number(impl Into<String>)`](crate::client::fluent_builders::AssociatePhoneNumberWithUser::e164_phone_number) / [`set_e164_phone_number(Option<String>)`](crate::client::fluent_builders::AssociatePhoneNumberWithUser::set_e164_phone_number): <p>The phone number, in E.164 format.</p>
    /// - On success, responds with [`AssociatePhoneNumberWithUserOutput`](crate::output::AssociatePhoneNumberWithUserOutput)

    /// - On failure, responds with [`SdkError<AssociatePhoneNumberWithUserError>`](crate::error::AssociatePhoneNumberWithUserError)
    pub fn associate_phone_number_with_user(
        &self,
    ) -> fluent_builders::AssociatePhoneNumberWithUser<C, M, R> {
        fluent_builders::AssociatePhoneNumberWithUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateSigninDelegateGroupsWithAccount`](crate::client::fluent_builders::AssociateSigninDelegateGroupsWithAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::AssociateSigninDelegateGroupsWithAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::AssociateSigninDelegateGroupsWithAccount::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`signin_delegate_groups(Vec<SigninDelegateGroup>)`](crate::client::fluent_builders::AssociateSigninDelegateGroupsWithAccount::signin_delegate_groups) / [`set_signin_delegate_groups(Option<Vec<SigninDelegateGroup>>)`](crate::client::fluent_builders::AssociateSigninDelegateGroupsWithAccount::set_signin_delegate_groups): <p>The sign-in delegate groups.</p>
    /// - On success, responds with [`AssociateSigninDelegateGroupsWithAccountOutput`](crate::output::AssociateSigninDelegateGroupsWithAccountOutput)

    /// - On failure, responds with [`SdkError<AssociateSigninDelegateGroupsWithAccountError>`](crate::error::AssociateSigninDelegateGroupsWithAccountError)
    pub fn associate_signin_delegate_groups_with_account(
        &self,
    ) -> fluent_builders::AssociateSigninDelegateGroupsWithAccount<C, M, R> {
        fluent_builders::AssociateSigninDelegateGroupsWithAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchCreateAttendee`](crate::client::fluent_builders::BatchCreateAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::BatchCreateAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::BatchCreateAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendees(Vec<CreateAttendeeRequestItem>)`](crate::client::fluent_builders::BatchCreateAttendee::attendees) / [`set_attendees(Option<Vec<CreateAttendeeRequestItem>>)`](crate::client::fluent_builders::BatchCreateAttendee::set_attendees): <p>The request containing the attendees to create.</p>
    /// - On success, responds with [`BatchCreateAttendeeOutput`](crate::output::BatchCreateAttendeeOutput) with field(s):
    ///   - [`attendees(Option<Vec<Attendee>>)`](crate::output::BatchCreateAttendeeOutput::attendees): <p>The attendee information, including attendees IDs and join tokens.</p>
    ///   - [`errors(Option<Vec<CreateAttendeeError>>)`](crate::output::BatchCreateAttendeeOutput::errors): <p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchCreateAttendeeError>`](crate::error::BatchCreateAttendeeError)
    pub fn batch_create_attendee(&self) -> fluent_builders::BatchCreateAttendee<C, M, R> {
        fluent_builders::BatchCreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchCreateChannelMembership`](crate::client::fluent_builders::BatchCreateChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_channel_arn): <p>The ARN of the channel to which you're adding users.</p>
    ///   - [`r#type(ChannelMembershipType)`](crate::client::fluent_builders::BatchCreateChannelMembership::r#type) / [`set_type(Option<ChannelMembershipType>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_type): <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    ///   - [`member_arns(Vec<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::member_arns) / [`set_member_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_member_arns): <p>The ARNs of the members you want to add to the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::BatchCreateChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`BatchCreateChannelMembershipOutput`](crate::output::BatchCreateChannelMembershipOutput) with field(s):
    ///   - [`batch_channel_memberships(Option<BatchChannelMemberships>)`](crate::output::BatchCreateChannelMembershipOutput::batch_channel_memberships): <p>The list of channel memberships in the response.</p>
    ///   - [`errors(Option<Vec<BatchCreateChannelMembershipError>>)`](crate::output::BatchCreateChannelMembershipOutput::errors): <p>If the action fails for one or more of the memberships in the request, a list of the memberships is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchCreateChannelMembershipError>`](crate::error::BatchCreateChannelMembershipError)
    pub fn batch_create_channel_membership(
        &self,
    ) -> fluent_builders::BatchCreateChannelMembership<C, M, R> {
        fluent_builders::BatchCreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchCreateRoomMembership`](crate::client::fluent_builders::BatchCreateRoomMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::BatchCreateRoomMembership::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::BatchCreateRoomMembership::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::BatchCreateRoomMembership::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::BatchCreateRoomMembership::set_room_id): <p>The room ID.</p>
    ///   - [`membership_item_list(Vec<MembershipItem>)`](crate::client::fluent_builders::BatchCreateRoomMembership::membership_item_list) / [`set_membership_item_list(Option<Vec<MembershipItem>>)`](crate::client::fluent_builders::BatchCreateRoomMembership::set_membership_item_list): <p>The list of membership items.</p>
    /// - On success, responds with [`BatchCreateRoomMembershipOutput`](crate::output::BatchCreateRoomMembershipOutput) with field(s):
    ///   - [`errors(Option<Vec<MemberError>>)`](crate::output::BatchCreateRoomMembershipOutput::errors): <p>If the action fails for one or more of the member IDs in the request, a list of the member IDs is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchCreateRoomMembershipError>`](crate::error::BatchCreateRoomMembershipError)
    pub fn batch_create_room_membership(
        &self,
    ) -> fluent_builders::BatchCreateRoomMembership<C, M, R> {
        fluent_builders::BatchCreateRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDeletePhoneNumber`](crate::client::fluent_builders::BatchDeletePhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_ids(Vec<String>)`](crate::client::fluent_builders::BatchDeletePhoneNumber::phone_number_ids) / [`set_phone_number_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDeletePhoneNumber::set_phone_number_ids): <p>List of phone number IDs.</p>
    /// - On success, responds with [`BatchDeletePhoneNumberOutput`](crate::output::BatchDeletePhoneNumberOutput) with field(s):
    ///   - [`phone_number_errors(Option<Vec<PhoneNumberError>>)`](crate::output::BatchDeletePhoneNumberOutput::phone_number_errors): <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchDeletePhoneNumberError>`](crate::error::BatchDeletePhoneNumberError)
    pub fn batch_delete_phone_number(&self) -> fluent_builders::BatchDeletePhoneNumber<C, M, R> {
        fluent_builders::BatchDeletePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchSuspendUser`](crate::client::fluent_builders::BatchSuspendUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::BatchSuspendUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::BatchSuspendUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id_list(Vec<String>)`](crate::client::fluent_builders::BatchSuspendUser::user_id_list) / [`set_user_id_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchSuspendUser::set_user_id_list): <p>The request containing the user IDs to suspend.</p>
    /// - On success, responds with [`BatchSuspendUserOutput`](crate::output::BatchSuspendUserOutput) with field(s):
    ///   - [`user_errors(Option<Vec<UserError>>)`](crate::output::BatchSuspendUserOutput::user_errors): <p>If the <code>BatchSuspendUser</code> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchSuspendUserError>`](crate::error::BatchSuspendUserError)
    pub fn batch_suspend_user(&self) -> fluent_builders::BatchSuspendUser<C, M, R> {
        fluent_builders::BatchSuspendUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchUnsuspendUser`](crate::client::fluent_builders::BatchUnsuspendUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::BatchUnsuspendUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::BatchUnsuspendUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id_list(Vec<String>)`](crate::client::fluent_builders::BatchUnsuspendUser::user_id_list) / [`set_user_id_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchUnsuspendUser::set_user_id_list): <p>The request containing the user IDs to unsuspend.</p>
    /// - On success, responds with [`BatchUnsuspendUserOutput`](crate::output::BatchUnsuspendUserOutput) with field(s):
    ///   - [`user_errors(Option<Vec<UserError>>)`](crate::output::BatchUnsuspendUserOutput::user_errors): <p>If the <code>BatchUnsuspendUser</code> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchUnsuspendUserError>`](crate::error::BatchUnsuspendUserError)
    pub fn batch_unsuspend_user(&self) -> fluent_builders::BatchUnsuspendUser<C, M, R> {
        fluent_builders::BatchUnsuspendUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchUpdatePhoneNumber`](crate::client::fluent_builders::BatchUpdatePhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_phone_number_request_items(Vec<UpdatePhoneNumberRequestItem>)`](crate::client::fluent_builders::BatchUpdatePhoneNumber::update_phone_number_request_items) / [`set_update_phone_number_request_items(Option<Vec<UpdatePhoneNumberRequestItem>>)`](crate::client::fluent_builders::BatchUpdatePhoneNumber::set_update_phone_number_request_items): <p>The request containing the phone number IDs and product types or calling names to update.</p>
    /// - On success, responds with [`BatchUpdatePhoneNumberOutput`](crate::output::BatchUpdatePhoneNumberOutput) with field(s):
    ///   - [`phone_number_errors(Option<Vec<PhoneNumberError>>)`](crate::output::BatchUpdatePhoneNumberOutput::phone_number_errors): <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchUpdatePhoneNumberError>`](crate::error::BatchUpdatePhoneNumberError)
    pub fn batch_update_phone_number(&self) -> fluent_builders::BatchUpdatePhoneNumber<C, M, R> {
        fluent_builders::BatchUpdatePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchUpdateUser`](crate::client::fluent_builders::BatchUpdateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::BatchUpdateUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::BatchUpdateUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`update_user_request_items(Vec<UpdateUserRequestItem>)`](crate::client::fluent_builders::BatchUpdateUser::update_user_request_items) / [`set_update_user_request_items(Option<Vec<UpdateUserRequestItem>>)`](crate::client::fluent_builders::BatchUpdateUser::set_update_user_request_items): <p>The request containing the user IDs and details to update.</p>
    /// - On success, responds with [`BatchUpdateUserOutput`](crate::output::BatchUpdateUserOutput) with field(s):
    ///   - [`user_errors(Option<Vec<UserError>>)`](crate::output::BatchUpdateUserOutput::user_errors): <p>If the <code>BatchUpdateUser</code> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<BatchUpdateUserError>`](crate::error::BatchUpdateUserError)
    pub fn batch_update_user(&self) -> fluent_builders::BatchUpdateUser<C, M, R> {
        fluent_builders::BatchUpdateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccount`](crate::client::fluent_builders::CreateAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAccount::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAccount::set_name): <p>The name of the Amazon Chime account.</p>
    /// - On success, responds with [`CreateAccountOutput`](crate::output::CreateAccountOutput) with field(s):
    ///   - [`account(Option<Account>)`](crate::output::CreateAccountOutput::account): <p>The Amazon Chime account details.</p>
    /// - On failure, responds with [`SdkError<CreateAccountError>`](crate::error::CreateAccountError)
    pub fn create_account(&self) -> fluent_builders::CreateAccount<C, M, R> {
        fluent_builders::CreateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAppInstance`](crate::client::fluent_builders::CreateAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstance::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAppInstance::set_name): <p>The name of the <code>AppInstance</code>.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstance::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::CreateAppInstance::set_metadata): <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstance::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateAppInstance::set_client_request_token): <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAppInstance::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAppInstance::set_tags): <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`CreateAppInstanceOutput`](crate::output::CreateAppInstanceOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::CreateAppInstanceOutput::app_instance_arn): <p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>
    /// - On failure, responds with [`SdkError<CreateAppInstanceError>`](crate::error::CreateAppInstanceError)
    pub fn create_app_instance(&self) -> fluent_builders::CreateAppInstance<C, M, R> {
        fluent_builders::CreateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAppInstanceAdmin`](crate::client::fluent_builders::CreateAppInstanceAdmin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_admin_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::app_instance_admin_arn) / [`set_app_instance_admin_arn(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::set_app_instance_admin_arn): <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceAdmin::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`CreateAppInstanceAdminOutput`](crate::output::CreateAppInstanceAdminOutput) with field(s):
    ///   - [`app_instance_admin(Option<Identity>)`](crate::output::CreateAppInstanceAdminOutput::app_instance_admin): <p>The name and ARN of the admin for the <code>AppInstance</code>.</p>
    ///   - [`app_instance_arn(Option<String>)`](crate::output::CreateAppInstanceAdminOutput::app_instance_arn): <p>The ARN of the of the admin for the <code>AppInstance</code>.</p>
    /// - On failure, responds with [`SdkError<CreateAppInstanceAdminError>`](crate::error::CreateAppInstanceAdminError)
    pub fn create_app_instance_admin(&self) -> fluent_builders::CreateAppInstanceAdmin<C, M, R> {
        fluent_builders::CreateAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAppInstanceUser`](crate::client::fluent_builders::CreateAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code> request.</p>
    ///   - [`app_instance_user_id(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::app_instance_user_id) / [`set_app_instance_user_id(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_app_instance_user_id): <p>The user ID of the <code>AppInstance</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_name): <p>The user's name.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_metadata): <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_client_request_token): <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAppInstanceUser::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAppInstanceUser::set_tags): <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`CreateAppInstanceUserOutput`](crate::output::CreateAppInstanceUserOutput) with field(s):
    ///   - [`app_instance_user_arn(Option<String>)`](crate::output::CreateAppInstanceUserOutput::app_instance_user_arn): <p>The user's ARN.</p>
    /// - On failure, responds with [`SdkError<CreateAppInstanceUserError>`](crate::error::CreateAppInstanceUserError)
    pub fn create_app_instance_user(&self) -> fluent_builders::CreateAppInstanceUser<C, M, R> {
        fluent_builders::CreateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAttendee`](crate::client::fluent_builders::CreateAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::CreateAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::CreateAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`external_user_id(impl Into<String>)`](crate::client::fluent_builders::CreateAttendee::external_user_id) / [`set_external_user_id(Option<String>)`](crate::client::fluent_builders::CreateAttendee::set_external_user_id): <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAttendee::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAttendee::set_tags): <p>The tag key-value pairs.</p>
    /// - On success, responds with [`CreateAttendeeOutput`](crate::output::CreateAttendeeOutput) with field(s):
    ///   - [`attendee(Option<Attendee>)`](crate::output::CreateAttendeeOutput::attendee): <p>The attendee information, including attendee ID and join token.</p>
    /// - On failure, responds with [`SdkError<CreateAttendeeError>`](crate::error::CreateAttendeeError)
    pub fn create_attendee(&self) -> fluent_builders::CreateAttendee<C, M, R> {
        fluent_builders::CreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBot`](crate::client::fluent_builders::CreateBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateBot::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateBot::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateBot::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateBot::set_display_name): <p>The bot display name.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateBot::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateBot::set_domain): <p>The domain of the Amazon Chime Enterprise account.</p>
    /// - On success, responds with [`CreateBotOutput`](crate::output::CreateBotOutput) with field(s):
    ///   - [`bot(Option<Bot>)`](crate::output::CreateBotOutput::bot): <p>The bot details.</p>
    /// - On failure, responds with [`SdkError<CreateBotError>`](crate::error::CreateBotError)
    pub fn create_bot(&self) -> fluent_builders::CreateBot<C, M, R> {
        fluent_builders::CreateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannel`](crate::client::fluent_builders::CreateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_app_instance_arn): <p>The ARN of the channel request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_name): <p>The name of the channel.</p>
    ///   - [`mode(ChannelMode)`](crate::client::fluent_builders::CreateChannel::mode) / [`set_mode(Option<ChannelMode>)`](crate::client::fluent_builders::CreateChannel::set_mode): <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
    ///   - [`privacy(ChannelPrivacy)`](crate::client::fluent_builders::CreateChannel::privacy) / [`set_privacy(Option<ChannelPrivacy>)`](crate::client::fluent_builders::CreateChannel::set_privacy): <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_metadata): <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_client_request_token): <p>The client token for the request. An <code>Idempotency</code> token.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateChannel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateChannel::set_tags): <p>The tags for the creation request.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelOutput`](crate::output::CreateChannelOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelOutput::channel_arn): <p>The ARN of the channel.</p>
    /// - On failure, responds with [`SdkError<CreateChannelError>`](crate::error::CreateChannelError)
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannelBan`](crate::client::fluent_builders::CreateChannelBan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelBan::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelBan::set_channel_arn): <p>The ARN of the ban request.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelBan::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelBan::set_member_arn): <p>The ARN of the member being banned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannelBan::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannelBan::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelBanOutput`](crate::output::CreateChannelBanOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelBanOutput::channel_arn): <p>The ARN of the response to the ban request.</p>
    ///   - [`member(Option<Identity>)`](crate::output::CreateChannelBanOutput::member): <p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.</p>
    /// - On failure, responds with [`SdkError<CreateChannelBanError>`](crate::error::CreateChannelBanError)
    pub fn create_channel_ban(&self) -> fluent_builders::CreateChannelBan<C, M, R> {
        fluent_builders::CreateChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannelMembership`](crate::client::fluent_builders::CreateChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelMembership::set_channel_arn): <p>The ARN of the channel to which you're adding users.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelMembership::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelMembership::set_member_arn): <p>The ARN of the member you want to add to the channel.</p>
    ///   - [`r#type(ChannelMembershipType)`](crate::client::fluent_builders::CreateChannelMembership::r#type) / [`set_type(Option<ChannelMembershipType>)`](crate::client::fluent_builders::CreateChannelMembership::set_type): <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelMembershipOutput`](crate::output::CreateChannelMembershipOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelMembershipOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member(Option<Identity>)`](crate::output::CreateChannelMembershipOutput::member): <p>The ARN and metadata of the member being added.</p>
    /// - On failure, responds with [`SdkError<CreateChannelMembershipError>`](crate::error::CreateChannelMembershipError)
    pub fn create_channel_membership(&self) -> fluent_builders::CreateChannelMembership<C, M, R> {
        fluent_builders::CreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannelModerator`](crate::client::fluent_builders::CreateChannelModerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelModerator::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelModerator::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannelModerator::channel_moderator_arn) / [`set_channel_moderator_arn(Option<String>)`](crate::client::fluent_builders::CreateChannelModerator::set_channel_moderator_arn): <p>The ARN of the moderator.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::CreateChannelModerator::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::CreateChannelModerator::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`CreateChannelModeratorOutput`](crate::output::CreateChannelModeratorOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelModeratorOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator(Option<Identity>)`](crate::output::CreateChannelModeratorOutput::channel_moderator): <p>The ARNs of the channel and the moderator.</p>
    /// - On failure, responds with [`SdkError<CreateChannelModeratorError>`](crate::error::CreateChannelModeratorError)
    pub fn create_channel_moderator(&self) -> fluent_builders::CreateChannelModerator<C, M, R> {
        fluent_builders::CreateChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMediaCapturePipeline`](crate::client::fluent_builders::CreateMediaCapturePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_type(MediaPipelineSourceType)`](crate::client::fluent_builders::CreateMediaCapturePipeline::source_type) / [`set_source_type(Option<MediaPipelineSourceType>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::set_source_type): <p>Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.</p>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::set_source_arn): <p>ARN of the source from which the media artifacts are captured.</p>
    ///   - [`sink_type(MediaPipelineSinkType)`](crate::client::fluent_builders::CreateMediaCapturePipeline::sink_type) / [`set_sink_type(Option<MediaPipelineSinkType>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::set_sink_type): <p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>
    ///   - [`sink_arn(impl Into<String>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::sink_arn) / [`set_sink_arn(Option<String>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::set_sink_arn): <p>The ARN of the sink type.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::set_client_request_token): <p>The token assigned to the client making the pipeline request.</p>
    ///   - [`chime_sdk_meeting_configuration(ChimeSdkMeetingConfiguration)`](crate::client::fluent_builders::CreateMediaCapturePipeline::chime_sdk_meeting_configuration) / [`set_chime_sdk_meeting_configuration(Option<ChimeSdkMeetingConfiguration>)`](crate::client::fluent_builders::CreateMediaCapturePipeline::set_chime_sdk_meeting_configuration): <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
    /// - On success, responds with [`CreateMediaCapturePipelineOutput`](crate::output::CreateMediaCapturePipelineOutput) with field(s):
    ///   - [`media_capture_pipeline(Option<MediaCapturePipeline>)`](crate::output::CreateMediaCapturePipelineOutput::media_capture_pipeline): <p>A media capture pipeline object, the ID, source type, source ARN, sink type, and sink ARN of a media capture pipeline object.</p>
    /// - On failure, responds with [`SdkError<CreateMediaCapturePipelineError>`](crate::error::CreateMediaCapturePipelineError)
    pub fn create_media_capture_pipeline(
        &self,
    ) -> fluent_builders::CreateMediaCapturePipeline<C, M, R> {
        fluent_builders::CreateMediaCapturePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMeeting`](crate::client::fluent_builders::CreateMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_client_request_token): <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    ///   - [`external_meeting_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::external_meeting_id) / [`set_external_meeting_id(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_external_meeting_id): <p>The external meeting ID.</p>
    ///   - [`meeting_host_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::meeting_host_id) / [`set_meeting_host_id(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_meeting_host_id): <p>Reserved.</p>
    ///   - [`media_region(impl Into<String>)`](crate::client::fluent_builders::CreateMeeting::media_region) / [`set_media_region(Option<String>)`](crate::client::fluent_builders::CreateMeeting::set_media_region): <p> The Region in which to create the meeting. Default: <code>us-east-1</code>. </p>  <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateMeeting::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateMeeting::set_tags): <p>The tag key-value pairs.</p>
    ///   - [`notifications_configuration(MeetingNotificationConfiguration)`](crate::client::fluent_builders::CreateMeeting::notifications_configuration) / [`set_notifications_configuration(Option<MeetingNotificationConfiguration>)`](crate::client::fluent_builders::CreateMeeting::set_notifications_configuration): <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
    /// - On success, responds with [`CreateMeetingOutput`](crate::output::CreateMeetingOutput) with field(s):
    ///   - [`meeting(Option<Meeting>)`](crate::output::CreateMeetingOutput::meeting): <p> The meeting information, including the meeting ID and <code>MediaPlacement</code> . </p>
    /// - On failure, responds with [`SdkError<CreateMeetingError>`](crate::error::CreateMeetingError)
    pub fn create_meeting(&self) -> fluent_builders::CreateMeeting<C, M, R> {
        fluent_builders::CreateMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMeetingDialOut`](crate::client::fluent_builders::CreateMeetingDialOut) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`from_phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::from_phone_number) / [`set_from_phone_number(Option<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::set_from_phone_number): <p>Phone number used as the caller ID when the remote party receives a call.</p>
    ///   - [`to_phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::to_phone_number) / [`set_to_phone_number(Option<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::set_to_phone_number): <p>Phone number called when inviting someone to a meeting.</p>
    ///   - [`join_token(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::join_token) / [`set_join_token(Option<String>)`](crate::client::fluent_builders::CreateMeetingDialOut::set_join_token): <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
    /// - On success, responds with [`CreateMeetingDialOutOutput`](crate::output::CreateMeetingDialOutOutput) with field(s):
    ///   - [`transaction_id(Option<String>)`](crate::output::CreateMeetingDialOutOutput::transaction_id): <p>Unique ID that tracks API calls.</p>
    /// - On failure, responds with [`SdkError<CreateMeetingDialOutError>`](crate::error::CreateMeetingDialOutError)
    pub fn create_meeting_dial_out(&self) -> fluent_builders::CreateMeetingDialOut<C, M, R> {
        fluent_builders::CreateMeetingDialOut::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMeetingWithAttendees`](crate::client::fluent_builders::CreateMeetingWithAttendees) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_client_request_token): <p>The unique identifier for the client request. Use a different token for different meetings.</p>
    ///   - [`external_meeting_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::external_meeting_id) / [`set_external_meeting_id(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_external_meeting_id): <p>The external meeting ID.</p>
    ///   - [`meeting_host_id(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::meeting_host_id) / [`set_meeting_host_id(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_meeting_host_id): <p>Reserved.</p>
    ///   - [`media_region(impl Into<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::media_region) / [`set_media_region(Option<String>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_media_region): <p> The Region in which to create the meeting. Default: <code>us-east-1</code> . </p>  <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_tags): <p>The tag key-value pairs.</p>
    ///   - [`notifications_configuration(MeetingNotificationConfiguration)`](crate::client::fluent_builders::CreateMeetingWithAttendees::notifications_configuration) / [`set_notifications_configuration(Option<MeetingNotificationConfiguration>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_notifications_configuration): <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>). </p>
    ///   - [`attendees(Vec<CreateAttendeeRequestItem>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::attendees) / [`set_attendees(Option<Vec<CreateAttendeeRequestItem>>)`](crate::client::fluent_builders::CreateMeetingWithAttendees::set_attendees): <p>The request containing the attendees to create.</p>
    /// - On success, responds with [`CreateMeetingWithAttendeesOutput`](crate::output::CreateMeetingWithAttendeesOutput) with field(s):
    ///   - [`meeting(Option<Meeting>)`](crate::output::CreateMeetingWithAttendeesOutput::meeting): <p>A meeting created using the Amazon Chime SDK.</p>
    ///   - [`attendees(Option<Vec<Attendee>>)`](crate::output::CreateMeetingWithAttendeesOutput::attendees): <p>The attendee information, including attendees IDs and join tokens.</p>
    ///   - [`errors(Option<Vec<CreateAttendeeError>>)`](crate::output::CreateMeetingWithAttendeesOutput::errors): <p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<CreateMeetingWithAttendeesError>`](crate::error::CreateMeetingWithAttendeesError)
    pub fn create_meeting_with_attendees(
        &self,
    ) -> fluent_builders::CreateMeetingWithAttendees<C, M, R> {
        fluent_builders::CreateMeetingWithAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePhoneNumberOrder`](crate::client::fluent_builders::CreatePhoneNumberOrder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_type(PhoneNumberProductType)`](crate::client::fluent_builders::CreatePhoneNumberOrder::product_type) / [`set_product_type(Option<PhoneNumberProductType>)`](crate::client::fluent_builders::CreatePhoneNumberOrder::set_product_type): <p>The phone number product type.</p>
    ///   - [`e164_phone_numbers(Vec<String>)`](crate::client::fluent_builders::CreatePhoneNumberOrder::e164_phone_numbers) / [`set_e164_phone_numbers(Option<Vec<String>>)`](crate::client::fluent_builders::CreatePhoneNumberOrder::set_e164_phone_numbers): <p>List of phone numbers, in E.164 format.</p>
    /// - On success, responds with [`CreatePhoneNumberOrderOutput`](crate::output::CreatePhoneNumberOrderOutput) with field(s):
    ///   - [`phone_number_order(Option<PhoneNumberOrder>)`](crate::output::CreatePhoneNumberOrderOutput::phone_number_order): <p>The phone number order details.</p>
    /// - On failure, responds with [`SdkError<CreatePhoneNumberOrderError>`](crate::error::CreatePhoneNumberOrderError)
    pub fn create_phone_number_order(&self) -> fluent_builders::CreatePhoneNumberOrder<C, M, R> {
        fluent_builders::CreatePhoneNumberOrder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProxySession`](crate::client::fluent_builders::CreateProxySession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::CreateProxySession::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::CreateProxySession::set_voice_connector_id): <p>The Amazon Chime voice connector ID.</p>
    ///   - [`participant_phone_numbers(Vec<String>)`](crate::client::fluent_builders::CreateProxySession::participant_phone_numbers) / [`set_participant_phone_numbers(Option<Vec<String>>)`](crate::client::fluent_builders::CreateProxySession::set_participant_phone_numbers): <p>The participant phone numbers.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProxySession::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProxySession::set_name): <p>The name of the proxy session.</p>
    ///   - [`expiry_minutes(i32)`](crate::client::fluent_builders::CreateProxySession::expiry_minutes) / [`set_expiry_minutes(Option<i32>)`](crate::client::fluent_builders::CreateProxySession::set_expiry_minutes): <p>The number of minutes allowed for the proxy session.</p>
    ///   - [`capabilities(Vec<Capability>)`](crate::client::fluent_builders::CreateProxySession::capabilities) / [`set_capabilities(Option<Vec<Capability>>)`](crate::client::fluent_builders::CreateProxySession::set_capabilities): <p>The proxy session capabilities.</p>
    ///   - [`number_selection_behavior(NumberSelectionBehavior)`](crate::client::fluent_builders::CreateProxySession::number_selection_behavior) / [`set_number_selection_behavior(Option<NumberSelectionBehavior>)`](crate::client::fluent_builders::CreateProxySession::set_number_selection_behavior): <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
    ///   - [`geo_match_level(GeoMatchLevel)`](crate::client::fluent_builders::CreateProxySession::geo_match_level) / [`set_geo_match_level(Option<GeoMatchLevel>)`](crate::client::fluent_builders::CreateProxySession::set_geo_match_level): <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
    ///   - [`geo_match_params(GeoMatchParams)`](crate::client::fluent_builders::CreateProxySession::geo_match_params) / [`set_geo_match_params(Option<GeoMatchParams>)`](crate::client::fluent_builders::CreateProxySession::set_geo_match_params): <p>The country and area code for the proxy phone number.</p>
    /// - On success, responds with [`CreateProxySessionOutput`](crate::output::CreateProxySessionOutput) with field(s):
    ///   - [`proxy_session(Option<ProxySession>)`](crate::output::CreateProxySessionOutput::proxy_session): <p>The proxy session details.</p>
    /// - On failure, responds with [`SdkError<CreateProxySessionError>`](crate::error::CreateProxySessionError)
    pub fn create_proxy_session(&self) -> fluent_builders::CreateProxySession<C, M, R> {
        fluent_builders::CreateProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoom`](crate::client::fluent_builders::CreateRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoom::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateRoom::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRoom::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRoom::set_name): <p>The room name.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateRoom::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateRoom::set_client_request_token): <p>The idempotency token for the request.</p>
    /// - On success, responds with [`CreateRoomOutput`](crate::output::CreateRoomOutput) with field(s):
    ///   - [`room(Option<Room>)`](crate::output::CreateRoomOutput::room): <p>The room details.</p>
    /// - On failure, responds with [`SdkError<CreateRoomError>`](crate::error::CreateRoomError)
    pub fn create_room(&self) -> fluent_builders::CreateRoom<C, M, R> {
        fluent_builders::CreateRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoomMembership`](crate::client::fluent_builders::CreateRoomMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoomMembership::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateRoomMembership::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoomMembership::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::CreateRoomMembership::set_room_id): <p>The room ID.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoomMembership::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::CreateRoomMembership::set_member_id): <p>The Amazon Chime member ID (user ID or bot ID).</p>
    ///   - [`role(RoomMembershipRole)`](crate::client::fluent_builders::CreateRoomMembership::role) / [`set_role(Option<RoomMembershipRole>)`](crate::client::fluent_builders::CreateRoomMembership::set_role): <p>The role of the member.</p>
    /// - On success, responds with [`CreateRoomMembershipOutput`](crate::output::CreateRoomMembershipOutput) with field(s):
    ///   - [`room_membership(Option<RoomMembership>)`](crate::output::CreateRoomMembershipOutput::room_membership): <p>The room membership details.</p>
    /// - On failure, responds with [`SdkError<CreateRoomMembershipError>`](crate::error::CreateRoomMembershipError)
    pub fn create_room_membership(&self) -> fluent_builders::CreateRoomMembership<C, M, R> {
        fluent_builders::CreateRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSipMediaApplication`](crate::client::fluent_builders::CreateSipMediaApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::CreateSipMediaApplication::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::CreateSipMediaApplication::set_aws_region): <p>The AWS Region assigned to the SIP media application.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSipMediaApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSipMediaApplication::set_name): <p>The SIP media application name.</p>
    ///   - [`endpoints(Vec<SipMediaApplicationEndpoint>)`](crate::client::fluent_builders::CreateSipMediaApplication::endpoints) / [`set_endpoints(Option<Vec<SipMediaApplicationEndpoint>>)`](crate::client::fluent_builders::CreateSipMediaApplication::set_endpoints): <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
    /// - On success, responds with [`CreateSipMediaApplicationOutput`](crate::output::CreateSipMediaApplicationOutput) with field(s):
    ///   - [`sip_media_application(Option<SipMediaApplication>)`](crate::output::CreateSipMediaApplicationOutput::sip_media_application): <p>The SIP media application details.</p>
    /// - On failure, responds with [`SdkError<CreateSipMediaApplicationError>`](crate::error::CreateSipMediaApplicationError)
    pub fn create_sip_media_application(
        &self,
    ) -> fluent_builders::CreateSipMediaApplication<C, M, R> {
        fluent_builders::CreateSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSipMediaApplicationCall`](crate::client::fluent_builders::CreateSipMediaApplicationCall) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`from_phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::from_phone_number) / [`set_from_phone_number(Option<String>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::set_from_phone_number): <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
    ///   - [`to_phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::to_phone_number) / [`set_to_phone_number(Option<String>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::set_to_phone_number): <p>The phone number that the service should call.</p>
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::set_sip_media_application_id): <p>The ID of the SIP media application.</p>
    ///   - [`sip_headers(HashMap<String, String>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::sip_headers) / [`set_sip_headers(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateSipMediaApplicationCall::set_sip_headers): <p>The SIP headers added to an outbound call leg.</p>
    /// - On success, responds with [`CreateSipMediaApplicationCallOutput`](crate::output::CreateSipMediaApplicationCallOutput) with field(s):
    ///   - [`sip_media_application_call(Option<SipMediaApplicationCall>)`](crate::output::CreateSipMediaApplicationCallOutput::sip_media_application_call): <p>The actual call.</p>
    /// - On failure, responds with [`SdkError<CreateSipMediaApplicationCallError>`](crate::error::CreateSipMediaApplicationCallError)
    pub fn create_sip_media_application_call(
        &self,
    ) -> fluent_builders::CreateSipMediaApplicationCall<C, M, R> {
        fluent_builders::CreateSipMediaApplicationCall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSipRule`](crate::client::fluent_builders::CreateSipRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSipRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSipRule::set_name): <p>The name of the SIP rule.</p>
    ///   - [`trigger_type(SipRuleTriggerType)`](crate::client::fluent_builders::CreateSipRule::trigger_type) / [`set_trigger_type(Option<SipRuleTriggerType>)`](crate::client::fluent_builders::CreateSipRule::set_trigger_type): <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
    ///   - [`trigger_value(impl Into<String>)`](crate::client::fluent_builders::CreateSipRule::trigger_value) / [`set_trigger_value(Option<String>)`](crate::client::fluent_builders::CreateSipRule::set_trigger_value): <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>
    ///   - [`disabled(bool)`](crate::client::fluent_builders::CreateSipRule::disabled) / [`set_disabled(Option<bool>)`](crate::client::fluent_builders::CreateSipRule::set_disabled): <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
    ///   - [`target_applications(Vec<SipRuleTargetApplication>)`](crate::client::fluent_builders::CreateSipRule::target_applications) / [`set_target_applications(Option<Vec<SipRuleTargetApplication>>)`](crate::client::fluent_builders::CreateSipRule::set_target_applications): <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
    /// - On success, responds with [`CreateSipRuleOutput`](crate::output::CreateSipRuleOutput) with field(s):
    ///   - [`sip_rule(Option<SipRule>)`](crate::output::CreateSipRuleOutput::sip_rule): <p>Returns the SIP rule information, including the rule ID, triggers, and target applications.</p>
    /// - On failure, responds with [`SdkError<CreateSipRuleError>`](crate::error::CreateSipRuleError)
    pub fn create_sip_rule(&self) -> fluent_builders::CreateSipRule<C, M, R> {
        fluent_builders::CreateSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::CreateUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::CreateUser::set_username): <p>The user name.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::CreateUser::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::CreateUser::set_email): <p>The user's email address.</p>
    ///   - [`user_type(UserType)`](crate::client::fluent_builders::CreateUser::user_type) / [`set_user_type(Option<UserType>)`](crate::client::fluent_builders::CreateUser::set_user_type): <p>The user type.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::CreateUserOutput::user): <p>The user on the Amazon Chime account.</p>
    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVoiceConnector`](crate::client::fluent_builders::CreateVoiceConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVoiceConnector::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVoiceConnector::set_name): <p>The name of the Amazon Chime Voice Connector.</p>
    ///   - [`aws_region(VoiceConnectorAwsRegion)`](crate::client::fluent_builders::CreateVoiceConnector::aws_region) / [`set_aws_region(Option<VoiceConnectorAwsRegion>)`](crate::client::fluent_builders::CreateVoiceConnector::set_aws_region): <p> The AWS Region in which the Amazon Chime Voice Connector is created. Default value: <code>us-east-1</code> . </p>
    ///   - [`require_encryption(bool)`](crate::client::fluent_builders::CreateVoiceConnector::require_encryption) / [`set_require_encryption(Option<bool>)`](crate::client::fluent_builders::CreateVoiceConnector::set_require_encryption): <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
    /// - On success, responds with [`CreateVoiceConnectorOutput`](crate::output::CreateVoiceConnectorOutput) with field(s):
    ///   - [`voice_connector(Option<VoiceConnector>)`](crate::output::CreateVoiceConnectorOutput::voice_connector): <p>The Amazon Chime Voice Connector details.</p>
    /// - On failure, responds with [`SdkError<CreateVoiceConnectorError>`](crate::error::CreateVoiceConnectorError)
    pub fn create_voice_connector(&self) -> fluent_builders::CreateVoiceConnector<C, M, R> {
        fluent_builders::CreateVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVoiceConnectorGroup`](crate::client::fluent_builders::CreateVoiceConnectorGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVoiceConnectorGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVoiceConnectorGroup::set_name): <p>The name of the Amazon Chime Voice Connector group.</p>
    ///   - [`voice_connector_items(Vec<VoiceConnectorItem>)`](crate::client::fluent_builders::CreateVoiceConnectorGroup::voice_connector_items) / [`set_voice_connector_items(Option<Vec<VoiceConnectorItem>>)`](crate::client::fluent_builders::CreateVoiceConnectorGroup::set_voice_connector_items): <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
    /// - On success, responds with [`CreateVoiceConnectorGroupOutput`](crate::output::CreateVoiceConnectorGroupOutput) with field(s):
    ///   - [`voice_connector_group(Option<VoiceConnectorGroup>)`](crate::output::CreateVoiceConnectorGroupOutput::voice_connector_group): <p>The Amazon Chime Voice Connector group details.</p>
    /// - On failure, responds with [`SdkError<CreateVoiceConnectorGroupError>`](crate::error::CreateVoiceConnectorGroupError)
    pub fn create_voice_connector_group(
        &self,
    ) -> fluent_builders::CreateVoiceConnectorGroup<C, M, R> {
        fluent_builders::CreateVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccount`](crate::client::fluent_builders::DeleteAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteAccount::set_account_id): <p>The Amazon Chime account ID.</p>
    /// - On success, responds with [`DeleteAccountOutput`](crate::output::DeleteAccountOutput)

    /// - On failure, responds with [`SdkError<DeleteAccountError>`](crate::error::DeleteAccountError)
    pub fn delete_account(&self) -> fluent_builders::DeleteAccount<C, M, R> {
        fluent_builders::DeleteAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppInstance`](crate::client::fluent_builders::DeleteAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstance::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstance::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DeleteAppInstanceOutput`](crate::output::DeleteAppInstanceOutput)

    /// - On failure, responds with [`SdkError<DeleteAppInstanceError>`](crate::error::DeleteAppInstanceError)
    pub fn delete_app_instance(&self) -> fluent_builders::DeleteAppInstance<C, M, R> {
        fluent_builders::DeleteAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppInstanceAdmin`](crate::client::fluent_builders::DeleteAppInstanceAdmin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_admin_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::app_instance_admin_arn) / [`set_app_instance_admin_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::set_app_instance_admin_arn): <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstanceAdmin::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DeleteAppInstanceAdminOutput`](crate::output::DeleteAppInstanceAdminOutput)

    /// - On failure, responds with [`SdkError<DeleteAppInstanceAdminError>`](crate::error::DeleteAppInstanceAdminError)
    pub fn delete_app_instance_admin(&self) -> fluent_builders::DeleteAppInstanceAdmin<C, M, R> {
        fluent_builders::DeleteAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppInstanceStreamingConfigurations`](crate::client::fluent_builders::DeleteAppInstanceStreamingConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstanceStreamingConfigurations::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstanceStreamingConfigurations::set_app_instance_arn): <p>The ARN of the streaming configurations being deleted.</p>
    /// - On success, responds with [`DeleteAppInstanceStreamingConfigurationsOutput`](crate::output::DeleteAppInstanceStreamingConfigurationsOutput)

    /// - On failure, responds with [`SdkError<DeleteAppInstanceStreamingConfigurationsError>`](crate::error::DeleteAppInstanceStreamingConfigurationsError)
    pub fn delete_app_instance_streaming_configurations(
        &self,
    ) -> fluent_builders::DeleteAppInstanceStreamingConfigurations<C, M, R> {
        fluent_builders::DeleteAppInstanceStreamingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppInstanceUser`](crate::client::fluent_builders::DeleteAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the user request being deleted.</p>
    /// - On success, responds with [`DeleteAppInstanceUserOutput`](crate::output::DeleteAppInstanceUserOutput)

    /// - On failure, responds with [`SdkError<DeleteAppInstanceUserError>`](crate::error::DeleteAppInstanceUserError)
    pub fn delete_app_instance_user(&self) -> fluent_builders::DeleteAppInstanceUser<C, M, R> {
        fluent_builders::DeleteAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAttendee`](crate::client::fluent_builders::DeleteAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::DeleteAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendee_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAttendee::attendee_id) / [`set_attendee_id(Option<String>)`](crate::client::fluent_builders::DeleteAttendee::set_attendee_id): <p>The Amazon Chime SDK attendee ID.</p>
    /// - On success, responds with [`DeleteAttendeeOutput`](crate::output::DeleteAttendeeOutput)

    /// - On failure, responds with [`SdkError<DeleteAttendeeError>`](crate::error::DeleteAttendeeError)
    pub fn delete_attendee(&self) -> fluent_builders::DeleteAttendee<C, M, R> {
        fluent_builders::DeleteAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannel::set_channel_arn): <p>The ARN of the channel being deleted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelError>`](crate::error::DeleteChannelError)
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelBan`](crate::client::fluent_builders::DeleteChannelBan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelBan::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelBan::set_channel_arn): <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelBan::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelBan::set_member_arn): <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelBan::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelBan::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelBanOutput`](crate::output::DeleteChannelBanOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelBanError>`](crate::error::DeleteChannelBanError)
    pub fn delete_channel_ban(&self) -> fluent_builders::DeleteChannelBan<C, M, R> {
        fluent_builders::DeleteChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelMembership`](crate::client::fluent_builders::DeleteChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelMembership::set_channel_arn): <p>The ARN of the channel from which you want to remove the user.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMembership::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelMembership::set_member_arn): <p>The ARN of the member that you're removing from the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelMembershipOutput`](crate::output::DeleteChannelMembershipOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelMembershipError>`](crate::error::DeleteChannelMembershipError)
    pub fn delete_channel_membership(&self) -> fluent_builders::DeleteChannelMembership<C, M, R> {
        fluent_builders::DeleteChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelMessage`](crate::client::fluent_builders::DeleteChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::DeleteChannelMessage::set_message_id): <p>The ID of the message being deleted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelMessageOutput`](crate::output::DeleteChannelMessageOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelMessageError>`](crate::error::DeleteChannelMessageError)
    pub fn delete_channel_message(&self) -> fluent_builders::DeleteChannelMessage<C, M, R> {
        fluent_builders::DeleteChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannelModerator`](crate::client::fluent_builders::DeleteChannelModerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelModerator::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelModerator::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelModerator::channel_moderator_arn) / [`set_channel_moderator_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannelModerator::set_channel_moderator_arn): <p>The ARN of the moderator being deleted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DeleteChannelModerator::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DeleteChannelModerator::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DeleteChannelModeratorOutput`](crate::output::DeleteChannelModeratorOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelModeratorError>`](crate::error::DeleteChannelModeratorError)
    pub fn delete_channel_moderator(&self) -> fluent_builders::DeleteChannelModerator<C, M, R> {
        fluent_builders::DeleteChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventsConfiguration`](crate::client::fluent_builders::DeleteEventsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEventsConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteEventsConfiguration::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEventsConfiguration::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteEventsConfiguration::set_bot_id): <p>The bot ID.</p>
    /// - On success, responds with [`DeleteEventsConfigurationOutput`](crate::output::DeleteEventsConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteEventsConfigurationError>`](crate::error::DeleteEventsConfigurationError)
    pub fn delete_events_configuration(
        &self,
    ) -> fluent_builders::DeleteEventsConfiguration<C, M, R> {
        fluent_builders::DeleteEventsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMediaCapturePipeline`](crate::client::fluent_builders::DeleteMediaCapturePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`media_pipeline_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMediaCapturePipeline::media_pipeline_id) / [`set_media_pipeline_id(Option<String>)`](crate::client::fluent_builders::DeleteMediaCapturePipeline::set_media_pipeline_id): <p>The ID of the media capture pipeline being deleted. </p>
    /// - On success, responds with [`DeleteMediaCapturePipelineOutput`](crate::output::DeleteMediaCapturePipelineOutput)

    /// - On failure, responds with [`SdkError<DeleteMediaCapturePipelineError>`](crate::error::DeleteMediaCapturePipelineError)
    pub fn delete_media_capture_pipeline(
        &self,
    ) -> fluent_builders::DeleteMediaCapturePipeline<C, M, R> {
        fluent_builders::DeleteMediaCapturePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMeeting`](crate::client::fluent_builders::DeleteMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMeeting::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::DeleteMeeting::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    /// - On success, responds with [`DeleteMeetingOutput`](crate::output::DeleteMeetingOutput)

    /// - On failure, responds with [`SdkError<DeleteMeetingError>`](crate::error::DeleteMeetingError)
    pub fn delete_meeting(&self) -> fluent_builders::DeleteMeeting<C, M, R> {
        fluent_builders::DeleteMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePhoneNumber`](crate::client::fluent_builders::DeletePhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_id(impl Into<String>)`](crate::client::fluent_builders::DeletePhoneNumber::phone_number_id) / [`set_phone_number_id(Option<String>)`](crate::client::fluent_builders::DeletePhoneNumber::set_phone_number_id): <p>The phone number ID.</p>
    /// - On success, responds with [`DeletePhoneNumberOutput`](crate::output::DeletePhoneNumberOutput)

    /// - On failure, responds with [`SdkError<DeletePhoneNumberError>`](crate::error::DeletePhoneNumberError)
    pub fn delete_phone_number(&self) -> fluent_builders::DeletePhoneNumber<C, M, R> {
        fluent_builders::DeletePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProxySession`](crate::client::fluent_builders::DeleteProxySession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProxySession::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteProxySession::set_voice_connector_id): <p>The Amazon Chime voice connector ID.</p>
    ///   - [`proxy_session_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProxySession::proxy_session_id) / [`set_proxy_session_id(Option<String>)`](crate::client::fluent_builders::DeleteProxySession::set_proxy_session_id): <p>The proxy session ID.</p>
    /// - On success, responds with [`DeleteProxySessionOutput`](crate::output::DeleteProxySessionOutput)

    /// - On failure, responds with [`SdkError<DeleteProxySessionError>`](crate::error::DeleteProxySessionError)
    pub fn delete_proxy_session(&self) -> fluent_builders::DeleteProxySession<C, M, R> {
        fluent_builders::DeleteProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoom`](crate::client::fluent_builders::DeleteRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoom::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteRoom::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoom::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::DeleteRoom::set_room_id): <p>The chat room ID.</p>
    /// - On success, responds with [`DeleteRoomOutput`](crate::output::DeleteRoomOutput)

    /// - On failure, responds with [`SdkError<DeleteRoomError>`](crate::error::DeleteRoomError)
    pub fn delete_room(&self) -> fluent_builders::DeleteRoom<C, M, R> {
        fluent_builders::DeleteRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoomMembership`](crate::client::fluent_builders::DeleteRoomMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoomMembership::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteRoomMembership::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoomMembership::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::DeleteRoomMembership::set_room_id): <p>The room ID.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoomMembership::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::DeleteRoomMembership::set_member_id): <p>The member ID (user ID or bot ID).</p>
    /// - On success, responds with [`DeleteRoomMembershipOutput`](crate::output::DeleteRoomMembershipOutput)

    /// - On failure, responds with [`SdkError<DeleteRoomMembershipError>`](crate::error::DeleteRoomMembershipError)
    pub fn delete_room_membership(&self) -> fluent_builders::DeleteRoomMembership<C, M, R> {
        fluent_builders::DeleteRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSipMediaApplication`](crate::client::fluent_builders::DeleteSipMediaApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSipMediaApplication::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::DeleteSipMediaApplication::set_sip_media_application_id): <p>The SIP media application ID.</p>
    /// - On success, responds with [`DeleteSipMediaApplicationOutput`](crate::output::DeleteSipMediaApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteSipMediaApplicationError>`](crate::error::DeleteSipMediaApplicationError)
    pub fn delete_sip_media_application(
        &self,
    ) -> fluent_builders::DeleteSipMediaApplication<C, M, R> {
        fluent_builders::DeleteSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSipRule`](crate::client::fluent_builders::DeleteSipRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_rule_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSipRule::sip_rule_id) / [`set_sip_rule_id(Option<String>)`](crate::client::fluent_builders::DeleteSipRule::set_sip_rule_id): <p>The SIP rule ID.</p>
    /// - On success, responds with [`DeleteSipRuleOutput`](crate::output::DeleteSipRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteSipRuleError>`](crate::error::DeleteSipRuleError)
    pub fn delete_sip_rule(&self) -> fluent_builders::DeleteSipRule<C, M, R> {
        fluent_builders::DeleteSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnector`](crate::client::fluent_builders::DeleteVoiceConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnector::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnector::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`DeleteVoiceConnectorOutput`](crate::output::DeleteVoiceConnectorOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorError>`](crate::error::DeleteVoiceConnectorError)
    pub fn delete_voice_connector(&self) -> fluent_builders::DeleteVoiceConnector<C, M, R> {
        fluent_builders::DeleteVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnectorEmergencyCallingConfiguration`](crate::client::fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`DeleteVoiceConnectorEmergencyCallingConfigurationOutput`](crate::output::DeleteVoiceConnectorEmergencyCallingConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorEmergencyCallingConfigurationError>`](crate::error::DeleteVoiceConnectorEmergencyCallingConfigurationError)
    pub fn delete_voice_connector_emergency_calling_configuration(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration<C, M, R> {
        fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnectorGroup`](crate::client::fluent_builders::DeleteVoiceConnectorGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorGroup::voice_connector_group_id) / [`set_voice_connector_group_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorGroup::set_voice_connector_group_id): <p>The Amazon Chime Voice Connector group ID.</p>
    /// - On success, responds with [`DeleteVoiceConnectorGroupOutput`](crate::output::DeleteVoiceConnectorGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorGroupError>`](crate::error::DeleteVoiceConnectorGroupError)
    pub fn delete_voice_connector_group(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorGroup<C, M, R> {
        fluent_builders::DeleteVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnectorOrigination`](crate::client::fluent_builders::DeleteVoiceConnectorOrigination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorOrigination::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorOrigination::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`DeleteVoiceConnectorOriginationOutput`](crate::output::DeleteVoiceConnectorOriginationOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorOriginationError>`](crate::error::DeleteVoiceConnectorOriginationError)
    pub fn delete_voice_connector_origination(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorOrigination<C, M, R> {
        fluent_builders::DeleteVoiceConnectorOrigination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnectorProxy`](crate::client::fluent_builders::DeleteVoiceConnectorProxy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorProxy::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorProxy::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`DeleteVoiceConnectorProxyOutput`](crate::output::DeleteVoiceConnectorProxyOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorProxyError>`](crate::error::DeleteVoiceConnectorProxyError)
    pub fn delete_voice_connector_proxy(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorProxy<C, M, R> {
        fluent_builders::DeleteVoiceConnectorProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnectorStreamingConfiguration`](crate::client::fluent_builders::DeleteVoiceConnectorStreamingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorStreamingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorStreamingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`DeleteVoiceConnectorStreamingConfigurationOutput`](crate::output::DeleteVoiceConnectorStreamingConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorStreamingConfigurationError>`](crate::error::DeleteVoiceConnectorStreamingConfigurationError)
    pub fn delete_voice_connector_streaming_configuration(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorStreamingConfiguration<C, M, R> {
        fluent_builders::DeleteVoiceConnectorStreamingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnectorTermination`](crate::client::fluent_builders::DeleteVoiceConnectorTermination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorTermination::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorTermination::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`DeleteVoiceConnectorTerminationOutput`](crate::output::DeleteVoiceConnectorTerminationOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorTerminationError>`](crate::error::DeleteVoiceConnectorTerminationError)
    pub fn delete_voice_connector_termination(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorTermination<C, M, R> {
        fluent_builders::DeleteVoiceConnectorTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVoiceConnectorTerminationCredentials`](crate::client::fluent_builders::DeleteVoiceConnectorTerminationCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorTerminationCredentials::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorTerminationCredentials::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`usernames(Vec<String>)`](crate::client::fluent_builders::DeleteVoiceConnectorTerminationCredentials::usernames) / [`set_usernames(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteVoiceConnectorTerminationCredentials::set_usernames): <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
    /// - On success, responds with [`DeleteVoiceConnectorTerminationCredentialsOutput`](crate::output::DeleteVoiceConnectorTerminationCredentialsOutput)

    /// - On failure, responds with [`SdkError<DeleteVoiceConnectorTerminationCredentialsError>`](crate::error::DeleteVoiceConnectorTerminationCredentialsError)
    pub fn delete_voice_connector_termination_credentials(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorTerminationCredentials<C, M, R> {
        fluent_builders::DeleteVoiceConnectorTerminationCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppInstance`](crate::client::fluent_builders::DescribeAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstance::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstance::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DescribeAppInstanceOutput`](crate::output::DescribeAppInstanceOutput) with field(s):
    ///   - [`app_instance(Option<AppInstance>)`](crate::output::DescribeAppInstanceOutput::app_instance): <p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>
    /// - On failure, responds with [`SdkError<DescribeAppInstanceError>`](crate::error::DescribeAppInstanceError)
    pub fn describe_app_instance(&self) -> fluent_builders::DescribeAppInstance<C, M, R> {
        fluent_builders::DescribeAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppInstanceAdmin`](crate::client::fluent_builders::DescribeAppInstanceAdmin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_admin_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::app_instance_admin_arn) / [`set_app_instance_admin_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::set_app_instance_admin_arn): <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceAdmin::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`DescribeAppInstanceAdminOutput`](crate::output::DescribeAppInstanceAdminOutput) with field(s):
    ///   - [`app_instance_admin(Option<AppInstanceAdmin>)`](crate::output::DescribeAppInstanceAdminOutput::app_instance_admin): <p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>
    /// - On failure, responds with [`SdkError<DescribeAppInstanceAdminError>`](crate::error::DescribeAppInstanceAdminError)
    pub fn describe_app_instance_admin(
        &self,
    ) -> fluent_builders::DescribeAppInstanceAdmin<C, M, R> {
        fluent_builders::DescribeAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppInstanceUser`](crate::client::fluent_builders::DescribeAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`DescribeAppInstanceUserOutput`](crate::output::DescribeAppInstanceUserOutput) with field(s):
    ///   - [`app_instance_user(Option<AppInstanceUser>)`](crate::output::DescribeAppInstanceUserOutput::app_instance_user): <p>The name of the <code>AppInstanceUser</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeAppInstanceUserError>`](crate::error::DescribeAppInstanceUserError)
    pub fn describe_app_instance_user(&self) -> fluent_builders::DescribeAppInstanceUser<C, M, R> {
        fluent_builders::DescribeAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannel::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelOutput`](crate::output::DescribeChannelOutput) with field(s):
    ///   - [`channel(Option<Channel>)`](crate::output::DescribeChannelOutput::channel): <p>The channel details.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelError>`](crate::error::DescribeChannelError)
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel<C, M, R> {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelBan`](crate::client::fluent_builders::DescribeChannelBan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelBan::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelBan::set_channel_arn): <p>The ARN of the channel from which the user is banned.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelBan::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelBan::set_member_arn): <p>The ARN of the member being banned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelBan::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelBan::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelBanOutput`](crate::output::DescribeChannelBanOutput) with field(s):
    ///   - [`channel_ban(Option<ChannelBan>)`](crate::output::DescribeChannelBanOutput::channel_ban): <p>The details of the ban.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelBanError>`](crate::error::DescribeChannelBanError)
    pub fn describe_channel_ban(&self) -> fluent_builders::DescribeChannelBan<C, M, R> {
        fluent_builders::DescribeChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelMembership`](crate::client::fluent_builders::DescribeChannelMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembership::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembership::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`member_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembership::member_arn) / [`set_member_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembership::set_member_arn): <p>The ARN of the member.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembership::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembership::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelMembershipOutput`](crate::output::DescribeChannelMembershipOutput) with field(s):
    ///   - [`channel_membership(Option<ChannelMembership>)`](crate::output::DescribeChannelMembershipOutput::channel_membership): <p>The details of the membership.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelMembershipError>`](crate::error::DescribeChannelMembershipError)
    pub fn describe_channel_membership(
        &self,
    ) -> fluent_builders::DescribeChannelMembership<C, M, R> {
        fluent_builders::DescribeChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelMembershipForAppInstanceUser`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::set_channel_arn): <p>The ARN of the channel to which the user belongs.</p>
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the user in a channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelMembershipForAppInstanceUserOutput`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput) with field(s):
    ///   - [`channel_membership(Option<ChannelMembershipForAppInstanceUserSummary>)`](crate::output::DescribeChannelMembershipForAppInstanceUserOutput::channel_membership): <p>The channel to which a user belongs.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelMembershipForAppInstanceUserError>`](crate::error::DescribeChannelMembershipForAppInstanceUserError)
    pub fn describe_channel_membership_for_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelMembershipForAppInstanceUser<C, M, R> {
        fluent_builders::DescribeChannelMembershipForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelModeratedByAppInstanceUser`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::set_channel_arn): <p>The ARN of the moderated channel.</p>
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelModeratedByAppInstanceUserOutput`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput) with field(s):
    ///   - [`channel(Option<ChannelModeratedByAppInstanceUserSummary>)`](crate::output::DescribeChannelModeratedByAppInstanceUserOutput::channel): <p>The moderated channel.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelModeratedByAppInstanceUserError>`](crate::error::DescribeChannelModeratedByAppInstanceUserError)
    pub fn describe_channel_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelModeratedByAppInstanceUser<C, M, R> {
        fluent_builders::DescribeChannelModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannelModerator`](crate::client::fluent_builders::DescribeChannelModerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModerator::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModerator::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_moderator_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModerator::channel_moderator_arn) / [`set_channel_moderator_arn(Option<String>)`](crate::client::fluent_builders::DescribeChannelModerator::set_channel_moderator_arn): <p>The ARN of the channel moderator.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::DescribeChannelModerator::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::DescribeChannelModerator::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`DescribeChannelModeratorOutput`](crate::output::DescribeChannelModeratorOutput) with field(s):
    ///   - [`channel_moderator(Option<ChannelModerator>)`](crate::output::DescribeChannelModeratorOutput::channel_moderator): <p>The details of the channel moderator.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelModeratorError>`](crate::error::DescribeChannelModeratorError)
    pub fn describe_channel_moderator(&self) -> fluent_builders::DescribeChannelModerator<C, M, R> {
        fluent_builders::DescribeChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociatePhoneNumberFromUser`](crate::client::fluent_builders::DisassociatePhoneNumberFromUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DisassociatePhoneNumberFromUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DisassociatePhoneNumberFromUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DisassociatePhoneNumberFromUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DisassociatePhoneNumberFromUser::set_user_id): <p>The user ID.</p>
    /// - On success, responds with [`DisassociatePhoneNumberFromUserOutput`](crate::output::DisassociatePhoneNumberFromUserOutput)

    /// - On failure, responds with [`SdkError<DisassociatePhoneNumberFromUserError>`](crate::error::DisassociatePhoneNumberFromUserError)
    pub fn disassociate_phone_number_from_user(
        &self,
    ) -> fluent_builders::DisassociatePhoneNumberFromUser<C, M, R> {
        fluent_builders::DisassociatePhoneNumberFromUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociatePhoneNumbersFromVoiceConnector`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnector::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnector::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`e164_phone_numbers(Vec<String>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnector::e164_phone_numbers) / [`set_e164_phone_numbers(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnector::set_e164_phone_numbers): <p>List of phone numbers, in E.164 format.</p>
    /// - On success, responds with [`DisassociatePhoneNumbersFromVoiceConnectorOutput`](crate::output::DisassociatePhoneNumbersFromVoiceConnectorOutput) with field(s):
    ///   - [`phone_number_errors(Option<Vec<PhoneNumberError>>)`](crate::output::DisassociatePhoneNumbersFromVoiceConnectorOutput::phone_number_errors): <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<DisassociatePhoneNumbersFromVoiceConnectorError>`](crate::error::DisassociatePhoneNumbersFromVoiceConnectorError)
    pub fn disassociate_phone_numbers_from_voice_connector(
        &self,
    ) -> fluent_builders::DisassociatePhoneNumbersFromVoiceConnector<C, M, R> {
        fluent_builders::DisassociatePhoneNumbersFromVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociatePhoneNumbersFromVoiceConnectorGroup`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_group_id(impl Into<String>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup::voice_connector_group_id) / [`set_voice_connector_group_id(Option<String>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup::set_voice_connector_group_id): <p>The Amazon Chime Voice Connector group ID.</p>
    ///   - [`e164_phone_numbers(Vec<String>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup::e164_phone_numbers) / [`set_e164_phone_numbers(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup::set_e164_phone_numbers): <p>List of phone numbers, in E.164 format.</p>
    /// - On success, responds with [`DisassociatePhoneNumbersFromVoiceConnectorGroupOutput`](crate::output::DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) with field(s):
    ///   - [`phone_number_errors(Option<Vec<PhoneNumberError>>)`](crate::output::DisassociatePhoneNumbersFromVoiceConnectorGroupOutput::phone_number_errors): <p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>
    /// - On failure, responds with [`SdkError<DisassociatePhoneNumbersFromVoiceConnectorGroupError>`](crate::error::DisassociatePhoneNumbersFromVoiceConnectorGroupError)
    pub fn disassociate_phone_numbers_from_voice_connector_group(
        &self,
    ) -> fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup<C, M, R> {
        fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateSigninDelegateGroupsFromAccount`](crate::client::fluent_builders::DisassociateSigninDelegateGroupsFromAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateSigninDelegateGroupsFromAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DisassociateSigninDelegateGroupsFromAccount::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`group_names(Vec<String>)`](crate::client::fluent_builders::DisassociateSigninDelegateGroupsFromAccount::group_names) / [`set_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateSigninDelegateGroupsFromAccount::set_group_names): <p>The sign-in delegate group names.</p>
    /// - On success, responds with [`DisassociateSigninDelegateGroupsFromAccountOutput`](crate::output::DisassociateSigninDelegateGroupsFromAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateSigninDelegateGroupsFromAccountError>`](crate::error::DisassociateSigninDelegateGroupsFromAccountError)
    pub fn disassociate_signin_delegate_groups_from_account(
        &self,
    ) -> fluent_builders::DisassociateSigninDelegateGroupsFromAccount<C, M, R> {
        fluent_builders::DisassociateSigninDelegateGroupsFromAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccount`](crate::client::fluent_builders::GetAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccount::set_account_id): <p>The Amazon Chime account ID.</p>
    /// - On success, responds with [`GetAccountOutput`](crate::output::GetAccountOutput) with field(s):
    ///   - [`account(Option<Account>)`](crate::output::GetAccountOutput::account): <p>The Amazon Chime account details.</p>
    /// - On failure, responds with [`SdkError<GetAccountError>`](crate::error::GetAccountError)
    pub fn get_account(&self) -> fluent_builders::GetAccount<C, M, R> {
        fluent_builders::GetAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccountSettings`](crate::client::fluent_builders::GetAccountSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccountSettings::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccountSettings::set_account_id): <p>The Amazon Chime account ID.</p>
    /// - On success, responds with [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput) with field(s):
    ///   - [`account_settings(Option<AccountSettings>)`](crate::output::GetAccountSettingsOutput::account_settings): <p>The Amazon Chime account settings.</p>
    /// - On failure, responds with [`SdkError<GetAccountSettingsError>`](crate::error::GetAccountSettingsError)
    pub fn get_account_settings(&self) -> fluent_builders::GetAccountSettings<C, M, R> {
        fluent_builders::GetAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAppInstanceRetentionSettings`](crate::client::fluent_builders::GetAppInstanceRetentionSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::GetAppInstanceRetentionSettings::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::GetAppInstanceRetentionSettings::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`GetAppInstanceRetentionSettingsOutput`](crate::output::GetAppInstanceRetentionSettingsOutput) with field(s):
    ///   - [`app_instance_retention_settings(Option<AppInstanceRetentionSettings>)`](crate::output::GetAppInstanceRetentionSettingsOutput::app_instance_retention_settings): <p>The retention settings for the <code>AppInstance</code>.</p>
    ///   - [`initiate_deletion_timestamp(Option<DateTime>)`](crate::output::GetAppInstanceRetentionSettingsOutput::initiate_deletion_timestamp): <p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>
    /// - On failure, responds with [`SdkError<GetAppInstanceRetentionSettingsError>`](crate::error::GetAppInstanceRetentionSettingsError)
    pub fn get_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::GetAppInstanceRetentionSettings<C, M, R> {
        fluent_builders::GetAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAppInstanceStreamingConfigurations`](crate::client::fluent_builders::GetAppInstanceStreamingConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::GetAppInstanceStreamingConfigurations::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::GetAppInstanceStreamingConfigurations::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    /// - On success, responds with [`GetAppInstanceStreamingConfigurationsOutput`](crate::output::GetAppInstanceStreamingConfigurationsOutput) with field(s):
    ///   - [`app_instance_streaming_configurations(Option<Vec<AppInstanceStreamingConfiguration>>)`](crate::output::GetAppInstanceStreamingConfigurationsOutput::app_instance_streaming_configurations): <p>The streaming settings.</p>
    /// - On failure, responds with [`SdkError<GetAppInstanceStreamingConfigurationsError>`](crate::error::GetAppInstanceStreamingConfigurationsError)
    pub fn get_app_instance_streaming_configurations(
        &self,
    ) -> fluent_builders::GetAppInstanceStreamingConfigurations<C, M, R> {
        fluent_builders::GetAppInstanceStreamingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAttendee`](crate::client::fluent_builders::GetAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::GetAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::GetAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendee_id(impl Into<String>)`](crate::client::fluent_builders::GetAttendee::attendee_id) / [`set_attendee_id(Option<String>)`](crate::client::fluent_builders::GetAttendee::set_attendee_id): <p>The Amazon Chime SDK attendee ID.</p>
    /// - On success, responds with [`GetAttendeeOutput`](crate::output::GetAttendeeOutput) with field(s):
    ///   - [`attendee(Option<Attendee>)`](crate::output::GetAttendeeOutput::attendee): <p>The Amazon Chime SDK attendee information.</p>
    /// - On failure, responds with [`SdkError<GetAttendeeError>`](crate::error::GetAttendeeError)
    pub fn get_attendee(&self) -> fluent_builders::GetAttendee<C, M, R> {
        fluent_builders::GetAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBot`](crate::client::fluent_builders::GetBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetBot::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetBot::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::GetBot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::GetBot::set_bot_id): <p>The bot ID.</p>
    /// - On success, responds with [`GetBotOutput`](crate::output::GetBotOutput) with field(s):
    ///   - [`bot(Option<Bot>)`](crate::output::GetBotOutput::bot): <p>The chat bot details.</p>
    /// - On failure, responds with [`SdkError<GetBotError>`](crate::error::GetBotError)
    pub fn get_bot(&self) -> fluent_builders::GetBot<C, M, R> {
        fluent_builders::GetBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChannelMessage`](crate::client::fluent_builders::GetChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::GetChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::GetChannelMessage::set_message_id): <p>The ID of the message.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::GetChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::GetChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`GetChannelMessageOutput`](crate::output::GetChannelMessageOutput) with field(s):
    ///   - [`channel_message(Option<ChannelMessage>)`](crate::output::GetChannelMessageOutput::channel_message): <p>The details of and content in the message.</p>
    /// - On failure, responds with [`SdkError<GetChannelMessageError>`](crate::error::GetChannelMessageError)
    pub fn get_channel_message(&self) -> fluent_builders::GetChannelMessage<C, M, R> {
        fluent_builders::GetChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventsConfiguration`](crate::client::fluent_builders::GetEventsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetEventsConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetEventsConfiguration::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::GetEventsConfiguration::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::GetEventsConfiguration::set_bot_id): <p>The bot ID.</p>
    /// - On success, responds with [`GetEventsConfigurationOutput`](crate::output::GetEventsConfigurationOutput) with field(s):
    ///   - [`events_configuration(Option<EventsConfiguration>)`](crate::output::GetEventsConfigurationOutput::events_configuration): <p>The events configuration details.</p>
    /// - On failure, responds with [`SdkError<GetEventsConfigurationError>`](crate::error::GetEventsConfigurationError)
    pub fn get_events_configuration(&self) -> fluent_builders::GetEventsConfiguration<C, M, R> {
        fluent_builders::GetEventsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGlobalSettings`](crate::client::fluent_builders::GetGlobalSettings) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetGlobalSettings::send) it.

    /// - On success, responds with [`GetGlobalSettingsOutput`](crate::output::GetGlobalSettingsOutput) with field(s):
    ///   - [`business_calling(Option<BusinessCallingSettings>)`](crate::output::GetGlobalSettingsOutput::business_calling): <p>The Amazon Chime Business Calling settings.</p>
    ///   - [`voice_connector(Option<VoiceConnectorSettings>)`](crate::output::GetGlobalSettingsOutput::voice_connector): <p>The Amazon Chime Voice Connector settings.</p>
    /// - On failure, responds with [`SdkError<GetGlobalSettingsError>`](crate::error::GetGlobalSettingsError)
    pub fn get_global_settings(&self) -> fluent_builders::GetGlobalSettings<C, M, R> {
        fluent_builders::GetGlobalSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMediaCapturePipeline`](crate::client::fluent_builders::GetMediaCapturePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`media_pipeline_id(impl Into<String>)`](crate::client::fluent_builders::GetMediaCapturePipeline::media_pipeline_id) / [`set_media_pipeline_id(Option<String>)`](crate::client::fluent_builders::GetMediaCapturePipeline::set_media_pipeline_id): <p>The ID of the pipeline that you want to get.</p>
    /// - On success, responds with [`GetMediaCapturePipelineOutput`](crate::output::GetMediaCapturePipelineOutput) with field(s):
    ///   - [`media_capture_pipeline(Option<MediaCapturePipeline>)`](crate::output::GetMediaCapturePipelineOutput::media_capture_pipeline): <p>The media capture pipeline object.</p>
    /// - On failure, responds with [`SdkError<GetMediaCapturePipelineError>`](crate::error::GetMediaCapturePipelineError)
    pub fn get_media_capture_pipeline(&self) -> fluent_builders::GetMediaCapturePipeline<C, M, R> {
        fluent_builders::GetMediaCapturePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMeeting`](crate::client::fluent_builders::GetMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::GetMeeting::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::GetMeeting::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    /// - On success, responds with [`GetMeetingOutput`](crate::output::GetMeetingOutput) with field(s):
    ///   - [`meeting(Option<Meeting>)`](crate::output::GetMeetingOutput::meeting): <p>The Amazon Chime SDK meeting information.</p>
    /// - On failure, responds with [`SdkError<GetMeetingError>`](crate::error::GetMeetingError)
    pub fn get_meeting(&self) -> fluent_builders::GetMeeting<C, M, R> {
        fluent_builders::GetMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMessagingSessionEndpoint`](crate::client::fluent_builders::GetMessagingSessionEndpoint) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetMessagingSessionEndpoint::send) it.

    /// - On success, responds with [`GetMessagingSessionEndpointOutput`](crate::output::GetMessagingSessionEndpointOutput) with field(s):
    ///   - [`endpoint(Option<MessagingSessionEndpoint>)`](crate::output::GetMessagingSessionEndpointOutput::endpoint): <p>The endpoint returned in the response.</p>
    /// - On failure, responds with [`SdkError<GetMessagingSessionEndpointError>`](crate::error::GetMessagingSessionEndpointError)
    pub fn get_messaging_session_endpoint(
        &self,
    ) -> fluent_builders::GetMessagingSessionEndpoint<C, M, R> {
        fluent_builders::GetMessagingSessionEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPhoneNumber`](crate::client::fluent_builders::GetPhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_id(impl Into<String>)`](crate::client::fluent_builders::GetPhoneNumber::phone_number_id) / [`set_phone_number_id(Option<String>)`](crate::client::fluent_builders::GetPhoneNumber::set_phone_number_id): <p>The phone number ID.</p>
    /// - On success, responds with [`GetPhoneNumberOutput`](crate::output::GetPhoneNumberOutput) with field(s):
    ///   - [`phone_number(Option<PhoneNumber>)`](crate::output::GetPhoneNumberOutput::phone_number): <p>The phone number details.</p>
    /// - On failure, responds with [`SdkError<GetPhoneNumberError>`](crate::error::GetPhoneNumberError)
    pub fn get_phone_number(&self) -> fluent_builders::GetPhoneNumber<C, M, R> {
        fluent_builders::GetPhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPhoneNumberOrder`](crate::client::fluent_builders::GetPhoneNumberOrder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_order_id(impl Into<String>)`](crate::client::fluent_builders::GetPhoneNumberOrder::phone_number_order_id) / [`set_phone_number_order_id(Option<String>)`](crate::client::fluent_builders::GetPhoneNumberOrder::set_phone_number_order_id): <p>The ID for the phone number order.</p>
    /// - On success, responds with [`GetPhoneNumberOrderOutput`](crate::output::GetPhoneNumberOrderOutput) with field(s):
    ///   - [`phone_number_order(Option<PhoneNumberOrder>)`](crate::output::GetPhoneNumberOrderOutput::phone_number_order): <p>The phone number order details.</p>
    /// - On failure, responds with [`SdkError<GetPhoneNumberOrderError>`](crate::error::GetPhoneNumberOrderError)
    pub fn get_phone_number_order(&self) -> fluent_builders::GetPhoneNumberOrder<C, M, R> {
        fluent_builders::GetPhoneNumberOrder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPhoneNumberSettings`](crate::client::fluent_builders::GetPhoneNumberSettings) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetPhoneNumberSettings::send) it.

    /// - On success, responds with [`GetPhoneNumberSettingsOutput`](crate::output::GetPhoneNumberSettingsOutput) with field(s):
    ///   - [`calling_name(Option<String>)`](crate::output::GetPhoneNumberSettingsOutput::calling_name): <p>The default outbound calling name for the account.</p>
    ///   - [`calling_name_updated_timestamp(Option<DateTime>)`](crate::output::GetPhoneNumberSettingsOutput::calling_name_updated_timestamp): <p>The updated outbound calling name timestamp, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<GetPhoneNumberSettingsError>`](crate::error::GetPhoneNumberSettingsError)
    pub fn get_phone_number_settings(&self) -> fluent_builders::GetPhoneNumberSettings<C, M, R> {
        fluent_builders::GetPhoneNumberSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProxySession`](crate::client::fluent_builders::GetProxySession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetProxySession::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetProxySession::set_voice_connector_id): <p>The Amazon Chime voice connector ID.</p>
    ///   - [`proxy_session_id(impl Into<String>)`](crate::client::fluent_builders::GetProxySession::proxy_session_id) / [`set_proxy_session_id(Option<String>)`](crate::client::fluent_builders::GetProxySession::set_proxy_session_id): <p>The proxy session ID.</p>
    /// - On success, responds with [`GetProxySessionOutput`](crate::output::GetProxySessionOutput) with field(s):
    ///   - [`proxy_session(Option<ProxySession>)`](crate::output::GetProxySessionOutput::proxy_session): <p>The proxy session details.</p>
    /// - On failure, responds with [`SdkError<GetProxySessionError>`](crate::error::GetProxySessionError)
    pub fn get_proxy_session(&self) -> fluent_builders::GetProxySession<C, M, R> {
        fluent_builders::GetProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRetentionSettings`](crate::client::fluent_builders::GetRetentionSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetRetentionSettings::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetRetentionSettings::set_account_id): <p>The Amazon Chime account ID.</p>
    /// - On success, responds with [`GetRetentionSettingsOutput`](crate::output::GetRetentionSettingsOutput) with field(s):
    ///   - [`retention_settings(Option<RetentionSettings>)`](crate::output::GetRetentionSettingsOutput::retention_settings): <p>The retention settings.</p>
    ///   - [`initiate_deletion_timestamp(Option<DateTime>)`](crate::output::GetRetentionSettingsOutput::initiate_deletion_timestamp): <p>The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<GetRetentionSettingsError>`](crate::error::GetRetentionSettingsError)
    pub fn get_retention_settings(&self) -> fluent_builders::GetRetentionSettings<C, M, R> {
        fluent_builders::GetRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRoom`](crate::client::fluent_builders::GetRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetRoom::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetRoom::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::GetRoom::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::GetRoom::set_room_id): <p>The room ID.</p>
    /// - On success, responds with [`GetRoomOutput`](crate::output::GetRoomOutput) with field(s):
    ///   - [`room(Option<Room>)`](crate::output::GetRoomOutput::room): <p>The room details.</p>
    /// - On failure, responds with [`SdkError<GetRoomError>`](crate::error::GetRoomError)
    pub fn get_room(&self) -> fluent_builders::GetRoom<C, M, R> {
        fluent_builders::GetRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSipMediaApplication`](crate::client::fluent_builders::GetSipMediaApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::GetSipMediaApplication::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::GetSipMediaApplication::set_sip_media_application_id): <p>The SIP media application ID.</p>
    /// - On success, responds with [`GetSipMediaApplicationOutput`](crate::output::GetSipMediaApplicationOutput) with field(s):
    ///   - [`sip_media_application(Option<SipMediaApplication>)`](crate::output::GetSipMediaApplicationOutput::sip_media_application): <p>The SIP media application details.</p>
    /// - On failure, responds with [`SdkError<GetSipMediaApplicationError>`](crate::error::GetSipMediaApplicationError)
    pub fn get_sip_media_application(&self) -> fluent_builders::GetSipMediaApplication<C, M, R> {
        fluent_builders::GetSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSipMediaApplicationLoggingConfiguration`](crate::client::fluent_builders::GetSipMediaApplicationLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::GetSipMediaApplicationLoggingConfiguration::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::GetSipMediaApplicationLoggingConfiguration::set_sip_media_application_id): <p>The SIP media application ID.</p>
    /// - On success, responds with [`GetSipMediaApplicationLoggingConfigurationOutput`](crate::output::GetSipMediaApplicationLoggingConfigurationOutput) with field(s):
    ///   - [`sip_media_application_logging_configuration(Option<SipMediaApplicationLoggingConfiguration>)`](crate::output::GetSipMediaApplicationLoggingConfigurationOutput::sip_media_application_logging_configuration): <p>The actual logging configuration.</p>
    /// - On failure, responds with [`SdkError<GetSipMediaApplicationLoggingConfigurationError>`](crate::error::GetSipMediaApplicationLoggingConfigurationError)
    pub fn get_sip_media_application_logging_configuration(
        &self,
    ) -> fluent_builders::GetSipMediaApplicationLoggingConfiguration<C, M, R> {
        fluent_builders::GetSipMediaApplicationLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSipRule`](crate::client::fluent_builders::GetSipRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_rule_id(impl Into<String>)`](crate::client::fluent_builders::GetSipRule::sip_rule_id) / [`set_sip_rule_id(Option<String>)`](crate::client::fluent_builders::GetSipRule::set_sip_rule_id): <p>The SIP rule ID.</p>
    /// - On success, responds with [`GetSipRuleOutput`](crate::output::GetSipRuleOutput) with field(s):
    ///   - [`sip_rule(Option<SipRule>)`](crate::output::GetSipRuleOutput::sip_rule): <p>The SIP rule details.</p>
    /// - On failure, responds with [`SdkError<GetSipRuleError>`](crate::error::GetSipRuleError)
    pub fn get_sip_rule(&self) -> fluent_builders::GetSipRule<C, M, R> {
        fluent_builders::GetSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUser`](crate::client::fluent_builders::GetUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetUser::set_user_id): <p>The user ID.</p>
    /// - On success, responds with [`GetUserOutput`](crate::output::GetUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::GetUserOutput::user): <p>The user details.</p>
    /// - On failure, responds with [`SdkError<GetUserError>`](crate::error::GetUserError)
    pub fn get_user(&self) -> fluent_builders::GetUser<C, M, R> {
        fluent_builders::GetUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUserSettings`](crate::client::fluent_builders::GetUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetUserSettings::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetUserSettings::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetUserSettings::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetUserSettings::set_user_id): <p>The user ID.</p>
    /// - On success, responds with [`GetUserSettingsOutput`](crate::output::GetUserSettingsOutput) with field(s):
    ///   - [`user_settings(Option<UserSettings>)`](crate::output::GetUserSettingsOutput::user_settings): <p>The user settings.</p>
    /// - On failure, responds with [`SdkError<GetUserSettingsError>`](crate::error::GetUserSettingsError)
    pub fn get_user_settings(&self) -> fluent_builders::GetUserSettings<C, M, R> {
        fluent_builders::GetUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnector`](crate::client::fluent_builders::GetVoiceConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnector::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnector::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorOutput`](crate::output::GetVoiceConnectorOutput) with field(s):
    ///   - [`voice_connector(Option<VoiceConnector>)`](crate::output::GetVoiceConnectorOutput::voice_connector): <p>The Amazon Chime Voice Connector details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorError>`](crate::error::GetVoiceConnectorError)
    pub fn get_voice_connector(&self) -> fluent_builders::GetVoiceConnector<C, M, R> {
        fluent_builders::GetVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorEmergencyCallingConfiguration`](crate::client::fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorEmergencyCallingConfigurationOutput`](crate::output::GetVoiceConnectorEmergencyCallingConfigurationOutput) with field(s):
    ///   - [`emergency_calling_configuration(Option<EmergencyCallingConfiguration>)`](crate::output::GetVoiceConnectorEmergencyCallingConfigurationOutput::emergency_calling_configuration): <p>The emergency calling configuration details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorEmergencyCallingConfigurationError>`](crate::error::GetVoiceConnectorEmergencyCallingConfigurationError)
    pub fn get_voice_connector_emergency_calling_configuration(
        &self,
    ) -> fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration<C, M, R> {
        fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorGroup`](crate::client::fluent_builders::GetVoiceConnectorGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_group_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorGroup::voice_connector_group_id) / [`set_voice_connector_group_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorGroup::set_voice_connector_group_id): <p>The Amazon Chime Voice Connector group ID.</p>
    /// - On success, responds with [`GetVoiceConnectorGroupOutput`](crate::output::GetVoiceConnectorGroupOutput) with field(s):
    ///   - [`voice_connector_group(Option<VoiceConnectorGroup>)`](crate::output::GetVoiceConnectorGroupOutput::voice_connector_group): <p>The Amazon Chime Voice Connector group details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorGroupError>`](crate::error::GetVoiceConnectorGroupError)
    pub fn get_voice_connector_group(&self) -> fluent_builders::GetVoiceConnectorGroup<C, M, R> {
        fluent_builders::GetVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorLoggingConfiguration`](crate::client::fluent_builders::GetVoiceConnectorLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorLoggingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorLoggingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorLoggingConfigurationOutput`](crate::output::GetVoiceConnectorLoggingConfigurationOutput) with field(s):
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::GetVoiceConnectorLoggingConfigurationOutput::logging_configuration): <p>The logging configuration details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorLoggingConfigurationError>`](crate::error::GetVoiceConnectorLoggingConfigurationError)
    pub fn get_voice_connector_logging_configuration(
        &self,
    ) -> fluent_builders::GetVoiceConnectorLoggingConfiguration<C, M, R> {
        fluent_builders::GetVoiceConnectorLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorOrigination`](crate::client::fluent_builders::GetVoiceConnectorOrigination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorOrigination::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorOrigination::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorOriginationOutput`](crate::output::GetVoiceConnectorOriginationOutput) with field(s):
    ///   - [`origination(Option<Origination>)`](crate::output::GetVoiceConnectorOriginationOutput::origination): <p>The origination setting details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorOriginationError>`](crate::error::GetVoiceConnectorOriginationError)
    pub fn get_voice_connector_origination(
        &self,
    ) -> fluent_builders::GetVoiceConnectorOrigination<C, M, R> {
        fluent_builders::GetVoiceConnectorOrigination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorProxy`](crate::client::fluent_builders::GetVoiceConnectorProxy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorProxy::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorProxy::set_voice_connector_id): <p>The Amazon Chime voice connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorProxyOutput`](crate::output::GetVoiceConnectorProxyOutput) with field(s):
    ///   - [`proxy(Option<Proxy>)`](crate::output::GetVoiceConnectorProxyOutput::proxy): <p>The proxy configuration details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorProxyError>`](crate::error::GetVoiceConnectorProxyError)
    pub fn get_voice_connector_proxy(&self) -> fluent_builders::GetVoiceConnectorProxy<C, M, R> {
        fluent_builders::GetVoiceConnectorProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorStreamingConfiguration`](crate::client::fluent_builders::GetVoiceConnectorStreamingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorStreamingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorStreamingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorStreamingConfigurationOutput`](crate::output::GetVoiceConnectorStreamingConfigurationOutput) with field(s):
    ///   - [`streaming_configuration(Option<StreamingConfiguration>)`](crate::output::GetVoiceConnectorStreamingConfigurationOutput::streaming_configuration): <p>The streaming configuration details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorStreamingConfigurationError>`](crate::error::GetVoiceConnectorStreamingConfigurationError)
    pub fn get_voice_connector_streaming_configuration(
        &self,
    ) -> fluent_builders::GetVoiceConnectorStreamingConfiguration<C, M, R> {
        fluent_builders::GetVoiceConnectorStreamingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorTermination`](crate::client::fluent_builders::GetVoiceConnectorTermination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorTermination::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorTermination::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorTerminationOutput`](crate::output::GetVoiceConnectorTerminationOutput) with field(s):
    ///   - [`termination(Option<Termination>)`](crate::output::GetVoiceConnectorTerminationOutput::termination): <p>The termination setting details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorTerminationError>`](crate::error::GetVoiceConnectorTerminationError)
    pub fn get_voice_connector_termination(
        &self,
    ) -> fluent_builders::GetVoiceConnectorTermination<C, M, R> {
        fluent_builders::GetVoiceConnectorTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVoiceConnectorTerminationHealth`](crate::client::fluent_builders::GetVoiceConnectorTerminationHealth) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::GetVoiceConnectorTerminationHealth::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::GetVoiceConnectorTerminationHealth::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`GetVoiceConnectorTerminationHealthOutput`](crate::output::GetVoiceConnectorTerminationHealthOutput) with field(s):
    ///   - [`termination_health(Option<TerminationHealth>)`](crate::output::GetVoiceConnectorTerminationHealthOutput::termination_health): <p>The termination health details.</p>
    /// - On failure, responds with [`SdkError<GetVoiceConnectorTerminationHealthError>`](crate::error::GetVoiceConnectorTerminationHealthError)
    pub fn get_voice_connector_termination_health(
        &self,
    ) -> fluent_builders::GetVoiceConnectorTerminationHealth<C, M, R> {
        fluent_builders::GetVoiceConnectorTerminationHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InviteUsers`](crate::client::fluent_builders::InviteUsers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::InviteUsers::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::InviteUsers::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_email_list(Vec<String>)`](crate::client::fluent_builders::InviteUsers::user_email_list) / [`set_user_email_list(Option<Vec<String>>)`](crate::client::fluent_builders::InviteUsers::set_user_email_list): <p>The user email addresses to which to send the email invitation.</p>
    ///   - [`user_type(UserType)`](crate::client::fluent_builders::InviteUsers::user_type) / [`set_user_type(Option<UserType>)`](crate::client::fluent_builders::InviteUsers::set_user_type): <p>The user type.</p>
    /// - On success, responds with [`InviteUsersOutput`](crate::output::InviteUsersOutput) with field(s):
    ///   - [`invites(Option<Vec<Invite>>)`](crate::output::InviteUsersOutput::invites): <p>The email invitation details.</p>
    /// - On failure, responds with [`SdkError<InviteUsersError>`](crate::error::InviteUsersError)
    pub fn invite_users(&self) -> fluent_builders::InviteUsers<C, M, R> {
        fluent_builders::InviteUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccounts`](crate::client::fluent_builders::ListAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListAccounts::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListAccounts::set_name): <p>Amazon Chime account name prefix with which to filter results.</p>
    ///   - [`user_email(impl Into<String>)`](crate::client::fluent_builders::ListAccounts::user_email) / [`set_user_email(Option<String>)`](crate::client::fluent_builders::ListAccounts::set_user_email): <p>User email address with which to filter results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccounts::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccounts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccounts::set_max_results): <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    /// - On success, responds with [`ListAccountsOutput`](crate::output::ListAccountsOutput) with field(s):
    ///   - [`accounts(Option<Vec<Account>>)`](crate::output::ListAccountsOutput::accounts): <p>List of Amazon Chime accounts and account details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListAccountsError>`](crate::error::ListAccountsError)
    pub fn list_accounts(&self) -> fluent_builders::ListAccounts<C, M, R> {
        fluent_builders::ListAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppInstanceAdmins`](crate::client::fluent_builders::ListAppInstanceAdmins) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppInstanceAdmins::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppInstanceAdmins::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppInstanceAdmins::set_max_results): <p>The maximum number of administrators that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppInstanceAdmins::set_next_token): <p>The token returned from previous API requests until the number of administrators is reached.</p>
    /// - On success, responds with [`ListAppInstanceAdminsOutput`](crate::output::ListAppInstanceAdminsOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::ListAppInstanceAdminsOutput::app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`app_instance_admins(Option<Vec<AppInstanceAdminSummary>>)`](crate::output::ListAppInstanceAdminsOutput::app_instance_admins): <p>The information for each administrator.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppInstanceAdminsOutput::next_token): <p>The token returned from previous API requests until the number of administrators is reached.</p>
    /// - On failure, responds with [`SdkError<ListAppInstanceAdminsError>`](crate::error::ListAppInstanceAdminsError)
    pub fn list_app_instance_admins(&self) -> fluent_builders::ListAppInstanceAdmins<C, M, R> {
        fluent_builders::ListAppInstanceAdmins::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppInstances`](crate::client::fluent_builders::ListAppInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppInstances::set_max_results): <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppInstances::set_next_token): <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
    /// - On success, responds with [`ListAppInstancesOutput`](crate::output::ListAppInstancesOutput) with field(s):
    ///   - [`app_instances(Option<Vec<AppInstanceSummary>>)`](crate::output::ListAppInstancesOutput::app_instances): <p>The information for each <code>AppInstance</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppInstancesOutput::next_token): <p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>
    /// - On failure, responds with [`SdkError<ListAppInstancesError>`](crate::error::ListAppInstancesError)
    pub fn list_app_instances(&self) -> fluent_builders::ListAppInstances<C, M, R> {
        fluent_builders::ListAppInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppInstanceUsers`](crate::client::fluent_builders::ListAppInstanceUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppInstanceUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppInstanceUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppInstanceUsers::set_max_results): <p>The maximum number of requests that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppInstanceUsers::set_next_token): <p>The token passed by previous API calls until all requested users are returned.</p>
    /// - On success, responds with [`ListAppInstanceUsersOutput`](crate::output::ListAppInstanceUsersOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::ListAppInstanceUsersOutput::app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`app_instance_users(Option<Vec<AppInstanceUserSummary>>)`](crate::output::ListAppInstanceUsersOutput::app_instance_users): <p>The information for each requested <code>AppInstanceUser</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppInstanceUsersOutput::next_token): <p>The token passed by previous API calls until all requested users are returned.</p>
    /// - On failure, responds with [`SdkError<ListAppInstanceUsersError>`](crate::error::ListAppInstanceUsersError)
    pub fn list_app_instance_users(&self) -> fluent_builders::ListAppInstanceUsers<C, M, R> {
        fluent_builders::ListAppInstanceUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttendees`](crate::client::fluent_builders::ListAttendees) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttendees::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::ListAttendees::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::ListAttendees::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAttendees::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAttendees::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAttendees::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAttendees::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListAttendeesOutput`](crate::output::ListAttendeesOutput) with field(s):
    ///   - [`attendees(Option<Vec<Attendee>>)`](crate::output::ListAttendeesOutput::attendees): <p>The Amazon Chime SDK attendee information.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAttendeesOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListAttendeesError>`](crate::error::ListAttendeesError)
    pub fn list_attendees(&self) -> fluent_builders::ListAttendees<C, M, R> {
        fluent_builders::ListAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttendeeTags`](crate::client::fluent_builders::ListAttendeeTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::ListAttendeeTags::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::ListAttendeeTags::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendee_id(impl Into<String>)`](crate::client::fluent_builders::ListAttendeeTags::attendee_id) / [`set_attendee_id(Option<String>)`](crate::client::fluent_builders::ListAttendeeTags::set_attendee_id): <p>The Amazon Chime SDK attendee ID.</p>
    /// - On success, responds with [`ListAttendeeTagsOutput`](crate::output::ListAttendeeTagsOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListAttendeeTagsOutput::tags): <p>A list of tag key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListAttendeeTagsError>`](crate::error::ListAttendeeTagsError)
    pub fn list_attendee_tags(&self) -> fluent_builders::ListAttendeeTags<C, M, R> {
        fluent_builders::ListAttendeeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBots`](crate::client::fluent_builders::ListBots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListBots::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListBots::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBots::set_max_results): <p>The maximum number of results to return in a single call. The default is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBots::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`ListBotsOutput`](crate::output::ListBotsOutput) with field(s):
    ///   - [`bots(Option<Vec<Bot>>)`](crate::output::ListBotsOutput::bots): <p>List of bots and bot details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBotsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListBotsError>`](crate::error::ListBotsError)
    pub fn list_bots(&self) -> fluent_builders::ListBots<C, M, R> {
        fluent_builders::ListBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelBans`](crate::client::fluent_builders::ListChannelBans) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelBans::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelBans::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelBans::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelBans::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelBans::set_max_results): <p>The maximum number of bans that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelBans::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelBans::set_next_token): <p>The token passed by previous API calls until all requested bans are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelBans::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelBans::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelBansOutput`](crate::output::ListChannelBansOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelBansOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelBansOutput::next_token): <p>The token passed by previous API calls until all requested bans are returned.</p>
    ///   - [`channel_bans(Option<Vec<ChannelBanSummary>>)`](crate::output::ListChannelBansOutput::channel_bans): <p>The information for each requested ban.</p>
    /// - On failure, responds with [`SdkError<ListChannelBansError>`](crate::error::ListChannelBansError)
    pub fn list_channel_bans(&self) -> fluent_builders::ListChannelBans<C, M, R> {
        fluent_builders::ListChannelBans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelMemberships`](crate::client::fluent_builders::ListChannelMemberships) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelMemberships::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelMemberships::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelMemberships::set_channel_arn): <p>The maximum number of channel memberships that you want returned.</p>
    ///   - [`r#type(ChannelMembershipType)`](crate::client::fluent_builders::ListChannelMemberships::r#type) / [`set_type(Option<ChannelMembershipType>)`](crate::client::fluent_builders::ListChannelMemberships::set_type): <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelMemberships::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelMemberships::set_max_results): <p>The maximum number of channel memberships that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelMemberships::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelMemberships::set_next_token): <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelMemberships::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelMemberships::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelMembershipsOutput`](crate::output::ListChannelMembershipsOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelMembershipsOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`channel_memberships(Option<Vec<ChannelMembershipSummary>>)`](crate::output::ListChannelMembershipsOutput::channel_memberships): <p>The information for the requested channel memberships.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelMembershipsOutput::next_token): <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
    /// - On failure, responds with [`SdkError<ListChannelMembershipsError>`](crate::error::ListChannelMembershipsError)
    pub fn list_channel_memberships(&self) -> fluent_builders::ListChannelMemberships<C, M, R> {
        fluent_builders::ListChannelMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelMembershipsForAppInstanceUser`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>s</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_max_results): <p>The maximum number of users that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_next_token): <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelMembershipsForAppInstanceUserOutput`](crate::output::ListChannelMembershipsForAppInstanceUserOutput) with field(s):
    ///   - [`channel_memberships(Option<Vec<ChannelMembershipForAppInstanceUserSummary>>)`](crate::output::ListChannelMembershipsForAppInstanceUserOutput::channel_memberships): <p>The token passed by previous API calls until all requested users are returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelMembershipsForAppInstanceUserOutput::next_token): <p>The token passed by previous API calls until all requested users are returned.</p>
    /// - On failure, responds with [`SdkError<ListChannelMembershipsForAppInstanceUserError>`](crate::error::ListChannelMembershipsForAppInstanceUserError)
    pub fn list_channel_memberships_for_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelMembershipsForAppInstanceUser<C, M, R> {
        fluent_builders::ListChannelMembershipsForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelMessages`](crate::client::fluent_builders::ListChannelMessages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelMessages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelMessages::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelMessages::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::ListChannelMessages::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::ListChannelMessages::set_sort_order): <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
    ///   - [`not_before(DateTime)`](crate::client::fluent_builders::ListChannelMessages::not_before) / [`set_not_before(Option<DateTime>)`](crate::client::fluent_builders::ListChannelMessages::set_not_before): <p>The initial or starting time stamp for your requested messages.</p>
    ///   - [`not_after(DateTime)`](crate::client::fluent_builders::ListChannelMessages::not_after) / [`set_not_after(Option<DateTime>)`](crate::client::fluent_builders::ListChannelMessages::set_not_after): <p>The final or ending time stamp for your requested messages.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelMessages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelMessages::set_max_results): <p>The maximum number of messages that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelMessages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelMessages::set_next_token): <p>The token passed by previous API calls until all requested messages are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelMessages::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelMessages::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelMessagesOutput`](crate::output::ListChannelMessagesOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelMessagesOutput::channel_arn): <p>The ARN of the channel containing the requested messages.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelMessagesOutput::next_token): <p>The token passed by previous API calls until all requested messages are returned.</p>
    ///   - [`channel_messages(Option<Vec<ChannelMessageSummary>>)`](crate::output::ListChannelMessagesOutput::channel_messages): <p>The information about, and content of, each requested message.</p>
    /// - On failure, responds with [`SdkError<ListChannelMessagesError>`](crate::error::ListChannelMessagesError)
    pub fn list_channel_messages(&self) -> fluent_builders::ListChannelMessages<C, M, R> {
        fluent_builders::ListChannelMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelModerators`](crate::client::fluent_builders::ListChannelModerators) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelModerators::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelModerators::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListChannelModerators::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelModerators::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelModerators::set_max_results): <p>The maximum number of moderators that you want returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelModerators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelModerators::set_next_token): <p>The token passed by previous API calls until all requested moderators are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelModerators::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelModerators::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelModeratorsOutput`](crate::output::ListChannelModeratorsOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::ListChannelModeratorsOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelModeratorsOutput::next_token): <p>The token passed by previous API calls until all requested moderators are returned.</p>
    ///   - [`channel_moderators(Option<Vec<ChannelModeratorSummary>>)`](crate::output::ListChannelModeratorsOutput::channel_moderators): <p>The information about and names of each moderator.</p>
    /// - On failure, responds with [`SdkError<ListChannelModeratorsError>`](crate::error::ListChannelModeratorsError)
    pub fn list_channel_moderators(&self) -> fluent_builders::ListChannelModerators<C, M, R> {
        fluent_builders::ListChannelModerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannels`](crate::client::fluent_builders::ListChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannels::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::ListChannels::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`privacy(ChannelPrivacy)`](crate::client::fluent_builders::ListChannels::privacy) / [`set_privacy(Option<ChannelPrivacy>)`](crate::client::fluent_builders::ListChannels::set_privacy): <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannels::set_max_results): <p>The maximum number of channels that you want to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannels::set_next_token): <p>The token passed by previous API calls until all requested channels are returned.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannels::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannels::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelsOutput`](crate::output::ListChannelsOutput) with field(s):
    ///   - [`channels(Option<Vec<ChannelSummary>>)`](crate::output::ListChannelsOutput::channels): <p>The information about each channel.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsOutput::next_token): <p>The token returned from previous API requests until the number of channels is reached.</p>
    /// - On failure, responds with [`SdkError<ListChannelsError>`](crate::error::ListChannelsError)
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannelsModeratedByAppInstanceUser`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the user in the moderated channel.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_max_results): <p>The maximum number of channels in the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_next_token): <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`ListChannelsModeratedByAppInstanceUserOutput`](crate::output::ListChannelsModeratedByAppInstanceUserOutput) with field(s):
    ///   - [`channels(Option<Vec<ChannelModeratedByAppInstanceUserSummary>>)`](crate::output::ListChannelsModeratedByAppInstanceUserOutput::channels): <p>The moderated channels in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsModeratedByAppInstanceUserOutput::next_token): <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
    /// - On failure, responds with [`SdkError<ListChannelsModeratedByAppInstanceUserError>`](crate::error::ListChannelsModeratedByAppInstanceUserError)
    pub fn list_channels_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelsModeratedByAppInstanceUser<C, M, R> {
        fluent_builders::ListChannelsModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMediaCapturePipelines`](crate::client::fluent_builders::ListMediaCapturePipelines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMediaCapturePipelines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMediaCapturePipelines::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMediaCapturePipelines::set_next_token): <p>The token used to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMediaCapturePipelines::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMediaCapturePipelines::set_max_results): <p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>
    /// - On success, responds with [`ListMediaCapturePipelinesOutput`](crate::output::ListMediaCapturePipelinesOutput) with field(s):
    ///   - [`media_capture_pipelines(Option<Vec<MediaCapturePipeline>>)`](crate::output::ListMediaCapturePipelinesOutput::media_capture_pipelines): <p>The media capture pipeline objects in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMediaCapturePipelinesOutput::next_token): <p>The token used to retrieve the next page of results. </p>
    /// - On failure, responds with [`SdkError<ListMediaCapturePipelinesError>`](crate::error::ListMediaCapturePipelinesError)
    pub fn list_media_capture_pipelines(
        &self,
    ) -> fluent_builders::ListMediaCapturePipelines<C, M, R> {
        fluent_builders::ListMediaCapturePipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMeetings`](crate::client::fluent_builders::ListMeetings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMeetings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMeetings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMeetings::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMeetings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMeetings::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListMeetingsOutput`](crate::output::ListMeetingsOutput) with field(s):
    ///   - [`meetings(Option<Vec<Meeting>>)`](crate::output::ListMeetingsOutput::meetings): <p>The Amazon Chime SDK meeting information.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMeetingsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListMeetingsError>`](crate::error::ListMeetingsError)
    pub fn list_meetings(&self) -> fluent_builders::ListMeetings<C, M, R> {
        fluent_builders::ListMeetings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMeetingTags`](crate::client::fluent_builders::ListMeetingTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::ListMeetingTags::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::ListMeetingTags::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    /// - On success, responds with [`ListMeetingTagsOutput`](crate::output::ListMeetingTagsOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListMeetingTagsOutput::tags): <p>A list of tag key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListMeetingTagsError>`](crate::error::ListMeetingTagsError)
    pub fn list_meeting_tags(&self) -> fluent_builders::ListMeetingTags<C, M, R> {
        fluent_builders::ListMeetingTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPhoneNumberOrders`](crate::client::fluent_builders::ListPhoneNumberOrders) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPhoneNumberOrders::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPhoneNumberOrders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPhoneNumberOrders::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPhoneNumberOrders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPhoneNumberOrders::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListPhoneNumberOrdersOutput`](crate::output::ListPhoneNumberOrdersOutput) with field(s):
    ///   - [`phone_number_orders(Option<Vec<PhoneNumberOrder>>)`](crate::output::ListPhoneNumberOrdersOutput::phone_number_orders): <p>The phone number order details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPhoneNumberOrdersOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListPhoneNumberOrdersError>`](crate::error::ListPhoneNumberOrdersError)
    pub fn list_phone_number_orders(&self) -> fluent_builders::ListPhoneNumberOrders<C, M, R> {
        fluent_builders::ListPhoneNumberOrders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPhoneNumbers`](crate::client::fluent_builders::ListPhoneNumbers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPhoneNumbers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`status(PhoneNumberStatus)`](crate::client::fluent_builders::ListPhoneNumbers::status) / [`set_status(Option<PhoneNumberStatus>)`](crate::client::fluent_builders::ListPhoneNumbers::set_status): <p>The phone number status.</p>
    ///   - [`product_type(PhoneNumberProductType)`](crate::client::fluent_builders::ListPhoneNumbers::product_type) / [`set_product_type(Option<PhoneNumberProductType>)`](crate::client::fluent_builders::ListPhoneNumbers::set_product_type): <p>The phone number product type.</p>
    ///   - [`filter_name(PhoneNumberAssociationName)`](crate::client::fluent_builders::ListPhoneNumbers::filter_name) / [`set_filter_name(Option<PhoneNumberAssociationName>)`](crate::client::fluent_builders::ListPhoneNumbers::set_filter_name): <p>The filter to use to limit the number of results.</p>
    ///   - [`filter_value(impl Into<String>)`](crate::client::fluent_builders::ListPhoneNumbers::filter_value) / [`set_filter_value(Option<String>)`](crate::client::fluent_builders::ListPhoneNumbers::set_filter_value): <p>The value to use for the filter.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPhoneNumbers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPhoneNumbers::set_max_results): <p>The maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPhoneNumbers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPhoneNumbers::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`ListPhoneNumbersOutput`](crate::output::ListPhoneNumbersOutput) with field(s):
    ///   - [`phone_numbers(Option<Vec<PhoneNumber>>)`](crate::output::ListPhoneNumbersOutput::phone_numbers): <p>The phone number details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPhoneNumbersOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListPhoneNumbersError>`](crate::error::ListPhoneNumbersError)
    pub fn list_phone_numbers(&self) -> fluent_builders::ListPhoneNumbers<C, M, R> {
        fluent_builders::ListPhoneNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProxySessions`](crate::client::fluent_builders::ListProxySessions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProxySessions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::ListProxySessions::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::ListProxySessions::set_voice_connector_id): <p>The Amazon Chime voice connector ID.</p>
    ///   - [`status(ProxySessionStatus)`](crate::client::fluent_builders::ListProxySessions::status) / [`set_status(Option<ProxySessionStatus>)`](crate::client::fluent_builders::ListProxySessions::set_status): <p>The proxy session status.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProxySessions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProxySessions::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProxySessions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProxySessions::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListProxySessionsOutput`](crate::output::ListProxySessionsOutput) with field(s):
    ///   - [`proxy_sessions(Option<Vec<ProxySession>>)`](crate::output::ListProxySessionsOutput::proxy_sessions): <p>The proxy session details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProxySessionsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListProxySessionsError>`](crate::error::ListProxySessionsError)
    pub fn list_proxy_sessions(&self) -> fluent_builders::ListProxySessions<C, M, R> {
        fluent_builders::ListProxySessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRoomMemberships`](crate::client::fluent_builders::ListRoomMemberships) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRoomMemberships::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListRoomMemberships::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListRoomMemberships::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::ListRoomMemberships::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::ListRoomMemberships::set_room_id): <p>The room ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRoomMemberships::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRoomMemberships::set_max_results): <p>The maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRoomMemberships::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRoomMemberships::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`ListRoomMembershipsOutput`](crate::output::ListRoomMembershipsOutput) with field(s):
    ///   - [`room_memberships(Option<Vec<RoomMembership>>)`](crate::output::ListRoomMembershipsOutput::room_memberships): <p>The room membership details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRoomMembershipsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListRoomMembershipsError>`](crate::error::ListRoomMembershipsError)
    pub fn list_room_memberships(&self) -> fluent_builders::ListRoomMemberships<C, M, R> {
        fluent_builders::ListRoomMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRooms`](crate::client::fluent_builders::ListRooms) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRooms::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListRooms::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListRooms::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::ListRooms::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::ListRooms::set_member_id): <p>The member ID (user ID or bot ID).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRooms::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRooms::set_max_results): <p>The maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRooms::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRooms::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`ListRoomsOutput`](crate::output::ListRoomsOutput) with field(s):
    ///   - [`rooms(Option<Vec<Room>>)`](crate::output::ListRoomsOutput::rooms): <p>The room details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRoomsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListRoomsError>`](crate::error::ListRoomsError)
    pub fn list_rooms(&self) -> fluent_builders::ListRooms<C, M, R> {
        fluent_builders::ListRooms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSipMediaApplications`](crate::client::fluent_builders::ListSipMediaApplications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSipMediaApplications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSipMediaApplications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSipMediaApplications::set_max_results): <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSipMediaApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSipMediaApplications::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`ListSipMediaApplicationsOutput`](crate::output::ListSipMediaApplicationsOutput) with field(s):
    ///   - [`sip_media_applications(Option<Vec<SipMediaApplication>>)`](crate::output::ListSipMediaApplicationsOutput::sip_media_applications): <p>List of SIP media applications and application details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSipMediaApplicationsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListSipMediaApplicationsError>`](crate::error::ListSipMediaApplicationsError)
    pub fn list_sip_media_applications(
        &self,
    ) -> fluent_builders::ListSipMediaApplications<C, M, R> {
        fluent_builders::ListSipMediaApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSipRules`](crate::client::fluent_builders::ListSipRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSipRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::ListSipRules::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::ListSipRules::set_sip_media_application_id): <p>The SIP media application ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSipRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSipRules::set_max_results): <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSipRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSipRules::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`ListSipRulesOutput`](crate::output::ListSipRulesOutput) with field(s):
    ///   - [`sip_rules(Option<Vec<SipRule>>)`](crate::output::ListSipRulesOutput::sip_rules): <p>List of SIP rules and rule details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSipRulesOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListSipRulesError>`](crate::error::ListSipRulesError)
    pub fn list_sip_rules(&self) -> fluent_builders::ListSipRules<C, M, R> {
        fluent_builders::ListSipRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSupportedPhoneNumberCountries`](crate::client::fluent_builders::ListSupportedPhoneNumberCountries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_type(PhoneNumberProductType)`](crate::client::fluent_builders::ListSupportedPhoneNumberCountries::product_type) / [`set_product_type(Option<PhoneNumberProductType>)`](crate::client::fluent_builders::ListSupportedPhoneNumberCountries::set_product_type): <p>The phone number product type.</p>
    /// - On success, responds with [`ListSupportedPhoneNumberCountriesOutput`](crate::output::ListSupportedPhoneNumberCountriesOutput) with field(s):
    ///   - [`phone_number_countries(Option<Vec<PhoneNumberCountry>>)`](crate::output::ListSupportedPhoneNumberCountriesOutput::phone_number_countries): <p>The supported phone number countries.</p>
    /// - On failure, responds with [`SdkError<ListSupportedPhoneNumberCountriesError>`](crate::error::ListSupportedPhoneNumberCountriesError)
    pub fn list_supported_phone_number_countries(
        &self,
    ) -> fluent_builders::ListSupportedPhoneNumberCountries<C, M, R> {
        fluent_builders::ListSupportedPhoneNumberCountries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The resource ARN.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tag-key value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsers`](crate::client::fluent_builders::ListUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListUsers::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListUsers::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_email(impl Into<String>)`](crate::client::fluent_builders::ListUsers::user_email) / [`set_user_email(Option<String>)`](crate::client::fluent_builders::ListUsers::set_user_email): <p>Optional. The user email address used to filter results. Maximum 1.</p>
    ///   - [`user_type(UserType)`](crate::client::fluent_builders::ListUsers::user_type) / [`set_user_type(Option<UserType>)`](crate::client::fluent_builders::ListUsers::set_user_type): <p>The user type.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUsers::set_max_results): <p>The maximum number of results to return in a single call. Defaults to 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsers::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`ListUsersOutput`](crate::output::ListUsersOutput) with field(s):
    ///   - [`users(Option<Vec<User>>)`](crate::output::ListUsersOutput::users): <p>List of users and user details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUsersOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListUsersError>`](crate::error::ListUsersError)
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVoiceConnectorGroups`](crate::client::fluent_builders::ListVoiceConnectorGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVoiceConnectorGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVoiceConnectorGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVoiceConnectorGroups::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListVoiceConnectorGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListVoiceConnectorGroups::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListVoiceConnectorGroupsOutput`](crate::output::ListVoiceConnectorGroupsOutput) with field(s):
    ///   - [`voice_connector_groups(Option<Vec<VoiceConnectorGroup>>)`](crate::output::ListVoiceConnectorGroupsOutput::voice_connector_groups): <p>The details of the Amazon Chime Voice Connector groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVoiceConnectorGroupsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListVoiceConnectorGroupsError>`](crate::error::ListVoiceConnectorGroupsError)
    pub fn list_voice_connector_groups(
        &self,
    ) -> fluent_builders::ListVoiceConnectorGroups<C, M, R> {
        fluent_builders::ListVoiceConnectorGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVoiceConnectors`](crate::client::fluent_builders::ListVoiceConnectors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVoiceConnectors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVoiceConnectors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVoiceConnectors::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListVoiceConnectors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListVoiceConnectors::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListVoiceConnectorsOutput`](crate::output::ListVoiceConnectorsOutput) with field(s):
    ///   - [`voice_connectors(Option<Vec<VoiceConnector>>)`](crate::output::ListVoiceConnectorsOutput::voice_connectors): <p>The details of the Amazon Chime Voice Connectors.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVoiceConnectorsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListVoiceConnectorsError>`](crate::error::ListVoiceConnectorsError)
    pub fn list_voice_connectors(&self) -> fluent_builders::ListVoiceConnectors<C, M, R> {
        fluent_builders::ListVoiceConnectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVoiceConnectorTerminationCredentials`](crate::client::fluent_builders::ListVoiceConnectorTerminationCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::ListVoiceConnectorTerminationCredentials::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::ListVoiceConnectorTerminationCredentials::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    /// - On success, responds with [`ListVoiceConnectorTerminationCredentialsOutput`](crate::output::ListVoiceConnectorTerminationCredentialsOutput) with field(s):
    ///   - [`usernames(Option<Vec<String>>)`](crate::output::ListVoiceConnectorTerminationCredentialsOutput::usernames): <p>A list of user names.</p>
    /// - On failure, responds with [`SdkError<ListVoiceConnectorTerminationCredentialsError>`](crate::error::ListVoiceConnectorTerminationCredentialsError)
    pub fn list_voice_connector_termination_credentials(
        &self,
    ) -> fluent_builders::ListVoiceConnectorTerminationCredentials<C, M, R> {
        fluent_builders::ListVoiceConnectorTerminationCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`LogoutUser`](crate::client::fluent_builders::LogoutUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::LogoutUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::LogoutUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::LogoutUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::LogoutUser::set_user_id): <p>The user ID.</p>
    /// - On success, responds with [`LogoutUserOutput`](crate::output::LogoutUserOutput)

    /// - On failure, responds with [`SdkError<LogoutUserError>`](crate::error::LogoutUserError)
    pub fn logout_user(&self) -> fluent_builders::LogoutUser<C, M, R> {
        fluent_builders::LogoutUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAppInstanceRetentionSettings`](crate::client::fluent_builders::PutAppInstanceRetentionSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`app_instance_retention_settings(AppInstanceRetentionSettings)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::app_instance_retention_settings) / [`set_app_instance_retention_settings(Option<AppInstanceRetentionSettings>)`](crate::client::fluent_builders::PutAppInstanceRetentionSettings::set_app_instance_retention_settings): <p>The time in days to retain data. Data type: number.</p>
    /// - On success, responds with [`PutAppInstanceRetentionSettingsOutput`](crate::output::PutAppInstanceRetentionSettingsOutput) with field(s):
    ///   - [`app_instance_retention_settings(Option<AppInstanceRetentionSettings>)`](crate::output::PutAppInstanceRetentionSettingsOutput::app_instance_retention_settings): <p>The time in days to retain data. Data type: number.</p>
    ///   - [`initiate_deletion_timestamp(Option<DateTime>)`](crate::output::PutAppInstanceRetentionSettingsOutput::initiate_deletion_timestamp): <p>The time at which the API deletes data.</p>
    /// - On failure, responds with [`SdkError<PutAppInstanceRetentionSettingsError>`](crate::error::PutAppInstanceRetentionSettingsError)
    pub fn put_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::PutAppInstanceRetentionSettings<C, M, R> {
        fluent_builders::PutAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAppInstanceStreamingConfigurations`](crate::client::fluent_builders::PutAppInstanceStreamingConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::PutAppInstanceStreamingConfigurations::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::PutAppInstanceStreamingConfigurations::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`app_instance_streaming_configurations(Vec<AppInstanceStreamingConfiguration>)`](crate::client::fluent_builders::PutAppInstanceStreamingConfigurations::app_instance_streaming_configurations) / [`set_app_instance_streaming_configurations(Option<Vec<AppInstanceStreamingConfiguration>>)`](crate::client::fluent_builders::PutAppInstanceStreamingConfigurations::set_app_instance_streaming_configurations): <p>The streaming configurations set for an <code>AppInstance</code>.</p>
    /// - On success, responds with [`PutAppInstanceStreamingConfigurationsOutput`](crate::output::PutAppInstanceStreamingConfigurationsOutput) with field(s):
    ///   - [`app_instance_streaming_configurations(Option<Vec<AppInstanceStreamingConfiguration>>)`](crate::output::PutAppInstanceStreamingConfigurationsOutput::app_instance_streaming_configurations): <p>The streaming configurations of an <code>AppInstance</code>.</p>
    /// - On failure, responds with [`SdkError<PutAppInstanceStreamingConfigurationsError>`](crate::error::PutAppInstanceStreamingConfigurationsError)
    pub fn put_app_instance_streaming_configurations(
        &self,
    ) -> fluent_builders::PutAppInstanceStreamingConfigurations<C, M, R> {
        fluent_builders::PutAppInstanceStreamingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEventsConfiguration`](crate::client::fluent_builders::PutEventsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutEventsConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutEventsConfiguration::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::PutEventsConfiguration::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::PutEventsConfiguration::set_bot_id): <p>The bot ID.</p>
    ///   - [`outbound_events_https_endpoint(impl Into<String>)`](crate::client::fluent_builders::PutEventsConfiguration::outbound_events_https_endpoint) / [`set_outbound_events_https_endpoint(Option<String>)`](crate::client::fluent_builders::PutEventsConfiguration::set_outbound_events_https_endpoint): <p>HTTPS endpoint that allows the bot to receive outgoing events.</p>
    ///   - [`lambda_function_arn(impl Into<String>)`](crate::client::fluent_builders::PutEventsConfiguration::lambda_function_arn) / [`set_lambda_function_arn(Option<String>)`](crate::client::fluent_builders::PutEventsConfiguration::set_lambda_function_arn): <p>Lambda function ARN that allows the bot to receive outgoing events.</p>
    /// - On success, responds with [`PutEventsConfigurationOutput`](crate::output::PutEventsConfigurationOutput) with field(s):
    ///   - [`events_configuration(Option<EventsConfiguration>)`](crate::output::PutEventsConfigurationOutput::events_configuration): <p>The configuration that allows a bot to receive outgoing events. Can be either an HTTPS endpoint or a Lambda function ARN.</p>
    /// - On failure, responds with [`SdkError<PutEventsConfigurationError>`](crate::error::PutEventsConfigurationError)
    pub fn put_events_configuration(&self) -> fluent_builders::PutEventsConfiguration<C, M, R> {
        fluent_builders::PutEventsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRetentionSettings`](crate::client::fluent_builders::PutRetentionSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutRetentionSettings::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutRetentionSettings::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`retention_settings(RetentionSettings)`](crate::client::fluent_builders::PutRetentionSettings::retention_settings) / [`set_retention_settings(Option<RetentionSettings>)`](crate::client::fluent_builders::PutRetentionSettings::set_retention_settings): <p>The retention settings.</p>
    /// - On success, responds with [`PutRetentionSettingsOutput`](crate::output::PutRetentionSettingsOutput) with field(s):
    ///   - [`retention_settings(Option<RetentionSettings>)`](crate::output::PutRetentionSettingsOutput::retention_settings): <p>The retention settings.</p>
    ///   - [`initiate_deletion_timestamp(Option<DateTime>)`](crate::output::PutRetentionSettingsOutput::initiate_deletion_timestamp): <p>The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<PutRetentionSettingsError>`](crate::error::PutRetentionSettingsError)
    pub fn put_retention_settings(&self) -> fluent_builders::PutRetentionSettings<C, M, R> {
        fluent_builders::PutRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSipMediaApplicationLoggingConfiguration`](crate::client::fluent_builders::PutSipMediaApplicationLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::PutSipMediaApplicationLoggingConfiguration::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::PutSipMediaApplicationLoggingConfiguration::set_sip_media_application_id): <p>The SIP media application ID.</p>
    ///   - [`sip_media_application_logging_configuration(SipMediaApplicationLoggingConfiguration)`](crate::client::fluent_builders::PutSipMediaApplicationLoggingConfiguration::sip_media_application_logging_configuration) / [`set_sip_media_application_logging_configuration(Option<SipMediaApplicationLoggingConfiguration>)`](crate::client::fluent_builders::PutSipMediaApplicationLoggingConfiguration::set_sip_media_application_logging_configuration): <p>The actual logging configuration.</p>
    /// - On success, responds with [`PutSipMediaApplicationLoggingConfigurationOutput`](crate::output::PutSipMediaApplicationLoggingConfigurationOutput) with field(s):
    ///   - [`sip_media_application_logging_configuration(Option<SipMediaApplicationLoggingConfiguration>)`](crate::output::PutSipMediaApplicationLoggingConfigurationOutput::sip_media_application_logging_configuration): <p>Logging configuration of the SIP media application.</p>
    /// - On failure, responds with [`SdkError<PutSipMediaApplicationLoggingConfigurationError>`](crate::error::PutSipMediaApplicationLoggingConfigurationError)
    pub fn put_sip_media_application_logging_configuration(
        &self,
    ) -> fluent_builders::PutSipMediaApplicationLoggingConfiguration<C, M, R> {
        fluent_builders::PutSipMediaApplicationLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVoiceConnectorEmergencyCallingConfiguration`](crate::client::fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`emergency_calling_configuration(EmergencyCallingConfiguration)`](crate::client::fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration::emergency_calling_configuration) / [`set_emergency_calling_configuration(Option<EmergencyCallingConfiguration>)`](crate::client::fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration::set_emergency_calling_configuration): <p>The emergency calling configuration details.</p>
    /// - On success, responds with [`PutVoiceConnectorEmergencyCallingConfigurationOutput`](crate::output::PutVoiceConnectorEmergencyCallingConfigurationOutput) with field(s):
    ///   - [`emergency_calling_configuration(Option<EmergencyCallingConfiguration>)`](crate::output::PutVoiceConnectorEmergencyCallingConfigurationOutput::emergency_calling_configuration): <p>The emergency calling configuration details.</p>
    /// - On failure, responds with [`SdkError<PutVoiceConnectorEmergencyCallingConfigurationError>`](crate::error::PutVoiceConnectorEmergencyCallingConfigurationError)
    pub fn put_voice_connector_emergency_calling_configuration(
        &self,
    ) -> fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration<C, M, R> {
        fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVoiceConnectorLoggingConfiguration`](crate::client::fluent_builders::PutVoiceConnectorLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorLoggingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorLoggingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`logging_configuration(LoggingConfiguration)`](crate::client::fluent_builders::PutVoiceConnectorLoggingConfiguration::logging_configuration) / [`set_logging_configuration(Option<LoggingConfiguration>)`](crate::client::fluent_builders::PutVoiceConnectorLoggingConfiguration::set_logging_configuration): <p>The logging configuration details to add.</p>
    /// - On success, responds with [`PutVoiceConnectorLoggingConfigurationOutput`](crate::output::PutVoiceConnectorLoggingConfigurationOutput) with field(s):
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::PutVoiceConnectorLoggingConfigurationOutput::logging_configuration): <p>The updated logging configuration details.</p>
    /// - On failure, responds with [`SdkError<PutVoiceConnectorLoggingConfigurationError>`](crate::error::PutVoiceConnectorLoggingConfigurationError)
    pub fn put_voice_connector_logging_configuration(
        &self,
    ) -> fluent_builders::PutVoiceConnectorLoggingConfiguration<C, M, R> {
        fluent_builders::PutVoiceConnectorLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVoiceConnectorOrigination`](crate::client::fluent_builders::PutVoiceConnectorOrigination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorOrigination::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorOrigination::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`origination(Origination)`](crate::client::fluent_builders::PutVoiceConnectorOrigination::origination) / [`set_origination(Option<Origination>)`](crate::client::fluent_builders::PutVoiceConnectorOrigination::set_origination): <p>The origination setting details to add.</p>
    /// - On success, responds with [`PutVoiceConnectorOriginationOutput`](crate::output::PutVoiceConnectorOriginationOutput) with field(s):
    ///   - [`origination(Option<Origination>)`](crate::output::PutVoiceConnectorOriginationOutput::origination): <p>The updated origination setting details.</p>
    /// - On failure, responds with [`SdkError<PutVoiceConnectorOriginationError>`](crate::error::PutVoiceConnectorOriginationError)
    pub fn put_voice_connector_origination(
        &self,
    ) -> fluent_builders::PutVoiceConnectorOrigination<C, M, R> {
        fluent_builders::PutVoiceConnectorOrigination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVoiceConnectorProxy`](crate::client::fluent_builders::PutVoiceConnectorProxy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::set_voice_connector_id): <p>The Amazon Chime voice connector ID.</p>
    ///   - [`default_session_expiry_minutes(i32)`](crate::client::fluent_builders::PutVoiceConnectorProxy::default_session_expiry_minutes) / [`set_default_session_expiry_minutes(Option<i32>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::set_default_session_expiry_minutes): <p>The default number of minutes allowed for proxy sessions.</p>
    ///   - [`phone_number_pool_countries(Vec<String>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::phone_number_pool_countries) / [`set_phone_number_pool_countries(Option<Vec<String>>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::set_phone_number_pool_countries): <p>The countries for proxy phone numbers to be selected from.</p>
    ///   - [`fall_back_phone_number(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::fall_back_phone_number) / [`set_fall_back_phone_number(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::set_fall_back_phone_number): <p>The phone number to route calls to after a proxy session expires.</p>
    ///   - [`disabled(bool)`](crate::client::fluent_builders::PutVoiceConnectorProxy::disabled) / [`set_disabled(Option<bool>)`](crate::client::fluent_builders::PutVoiceConnectorProxy::set_disabled): <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
    /// - On success, responds with [`PutVoiceConnectorProxyOutput`](crate::output::PutVoiceConnectorProxyOutput) with field(s):
    ///   - [`proxy(Option<Proxy>)`](crate::output::PutVoiceConnectorProxyOutput::proxy): <p>The proxy configuration details.</p>
    /// - On failure, responds with [`SdkError<PutVoiceConnectorProxyError>`](crate::error::PutVoiceConnectorProxyError)
    pub fn put_voice_connector_proxy(&self) -> fluent_builders::PutVoiceConnectorProxy<C, M, R> {
        fluent_builders::PutVoiceConnectorProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVoiceConnectorStreamingConfiguration`](crate::client::fluent_builders::PutVoiceConnectorStreamingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorStreamingConfiguration::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorStreamingConfiguration::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`streaming_configuration(StreamingConfiguration)`](crate::client::fluent_builders::PutVoiceConnectorStreamingConfiguration::streaming_configuration) / [`set_streaming_configuration(Option<StreamingConfiguration>)`](crate::client::fluent_builders::PutVoiceConnectorStreamingConfiguration::set_streaming_configuration): <p>The streaming configuration details to add.</p>
    /// - On success, responds with [`PutVoiceConnectorStreamingConfigurationOutput`](crate::output::PutVoiceConnectorStreamingConfigurationOutput) with field(s):
    ///   - [`streaming_configuration(Option<StreamingConfiguration>)`](crate::output::PutVoiceConnectorStreamingConfigurationOutput::streaming_configuration): <p>The updated streaming configuration details.</p>
    /// - On failure, responds with [`SdkError<PutVoiceConnectorStreamingConfigurationError>`](crate::error::PutVoiceConnectorStreamingConfigurationError)
    pub fn put_voice_connector_streaming_configuration(
        &self,
    ) -> fluent_builders::PutVoiceConnectorStreamingConfiguration<C, M, R> {
        fluent_builders::PutVoiceConnectorStreamingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVoiceConnectorTermination`](crate::client::fluent_builders::PutVoiceConnectorTermination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorTermination::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorTermination::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`termination(Termination)`](crate::client::fluent_builders::PutVoiceConnectorTermination::termination) / [`set_termination(Option<Termination>)`](crate::client::fluent_builders::PutVoiceConnectorTermination::set_termination): <p>The termination setting details to add.</p>
    /// - On success, responds with [`PutVoiceConnectorTerminationOutput`](crate::output::PutVoiceConnectorTerminationOutput) with field(s):
    ///   - [`termination(Option<Termination>)`](crate::output::PutVoiceConnectorTerminationOutput::termination): <p>The updated termination setting details.</p>
    /// - On failure, responds with [`SdkError<PutVoiceConnectorTerminationError>`](crate::error::PutVoiceConnectorTerminationError)
    pub fn put_voice_connector_termination(
        &self,
    ) -> fluent_builders::PutVoiceConnectorTermination<C, M, R> {
        fluent_builders::PutVoiceConnectorTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVoiceConnectorTerminationCredentials`](crate::client::fluent_builders::PutVoiceConnectorTerminationCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::PutVoiceConnectorTerminationCredentials::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::PutVoiceConnectorTerminationCredentials::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`credentials(Vec<Credential>)`](crate::client::fluent_builders::PutVoiceConnectorTerminationCredentials::credentials) / [`set_credentials(Option<Vec<Credential>>)`](crate::client::fluent_builders::PutVoiceConnectorTerminationCredentials::set_credentials): <p>The termination SIP credentials.</p>
    /// - On success, responds with [`PutVoiceConnectorTerminationCredentialsOutput`](crate::output::PutVoiceConnectorTerminationCredentialsOutput)

    /// - On failure, responds with [`SdkError<PutVoiceConnectorTerminationCredentialsError>`](crate::error::PutVoiceConnectorTerminationCredentialsError)
    pub fn put_voice_connector_termination_credentials(
        &self,
    ) -> fluent_builders::PutVoiceConnectorTerminationCredentials<C, M, R> {
        fluent_builders::PutVoiceConnectorTerminationCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RedactChannelMessage`](crate::client::fluent_builders::RedactChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::RedactChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::RedactChannelMessage::set_channel_arn): <p>The ARN of the channel containing the messages that you want to redact.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::RedactChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::RedactChannelMessage::set_message_id): <p>The ID of the message being redacted.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::RedactChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::RedactChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`RedactChannelMessageOutput`](crate::output::RedactChannelMessageOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::RedactChannelMessageOutput::channel_arn): <p>The ARN of the channel containing the messages that you want to redact.</p>
    ///   - [`message_id(Option<String>)`](crate::output::RedactChannelMessageOutput::message_id): <p>The ID of the message being redacted.</p>
    /// - On failure, responds with [`SdkError<RedactChannelMessageError>`](crate::error::RedactChannelMessageError)
    pub fn redact_channel_message(&self) -> fluent_builders::RedactChannelMessage<C, M, R> {
        fluent_builders::RedactChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RedactConversationMessage`](crate::client::fluent_builders::RedactConversationMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::RedactConversationMessage::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::RedactConversationMessage::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`conversation_id(impl Into<String>)`](crate::client::fluent_builders::RedactConversationMessage::conversation_id) / [`set_conversation_id(Option<String>)`](crate::client::fluent_builders::RedactConversationMessage::set_conversation_id): <p>The conversation ID.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::RedactConversationMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::RedactConversationMessage::set_message_id): <p>The message ID.</p>
    /// - On success, responds with [`RedactConversationMessageOutput`](crate::output::RedactConversationMessageOutput)

    /// - On failure, responds with [`SdkError<RedactConversationMessageError>`](crate::error::RedactConversationMessageError)
    pub fn redact_conversation_message(
        &self,
    ) -> fluent_builders::RedactConversationMessage<C, M, R> {
        fluent_builders::RedactConversationMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RedactRoomMessage`](crate::client::fluent_builders::RedactRoomMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::RedactRoomMessage::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::RedactRoomMessage::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::RedactRoomMessage::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::RedactRoomMessage::set_room_id): <p>The room ID.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::RedactRoomMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::RedactRoomMessage::set_message_id): <p>The message ID.</p>
    /// - On success, responds with [`RedactRoomMessageOutput`](crate::output::RedactRoomMessageOutput)

    /// - On failure, responds with [`SdkError<RedactRoomMessageError>`](crate::error::RedactRoomMessageError)
    pub fn redact_room_message(&self) -> fluent_builders::RedactRoomMessage<C, M, R> {
        fluent_builders::RedactRoomMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegenerateSecurityToken`](crate::client::fluent_builders::RegenerateSecurityToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::RegenerateSecurityToken::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::RegenerateSecurityToken::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::RegenerateSecurityToken::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::RegenerateSecurityToken::set_bot_id): <p>The bot ID.</p>
    /// - On success, responds with [`RegenerateSecurityTokenOutput`](crate::output::RegenerateSecurityTokenOutput) with field(s):
    ///   - [`bot(Option<Bot>)`](crate::output::RegenerateSecurityTokenOutput::bot): <p>A resource that allows Enterprise account administrators to configure an interface to receive events from Amazon Chime.</p>
    /// - On failure, responds with [`SdkError<RegenerateSecurityTokenError>`](crate::error::RegenerateSecurityTokenError)
    pub fn regenerate_security_token(&self) -> fluent_builders::RegenerateSecurityToken<C, M, R> {
        fluent_builders::RegenerateSecurityToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetPersonalPIN`](crate::client::fluent_builders::ResetPersonalPIN) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ResetPersonalPIN::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ResetPersonalPIN::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::ResetPersonalPIN::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::ResetPersonalPIN::set_user_id): <p>The user ID.</p>
    /// - On success, responds with [`ResetPersonalPinOutput`](crate::output::ResetPersonalPinOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::ResetPersonalPinOutput::user): <p>The user details and new personal meeting PIN.</p>
    /// - On failure, responds with [`SdkError<ResetPersonalPINError>`](crate::error::ResetPersonalPINError)
    pub fn reset_personal_pin(&self) -> fluent_builders::ResetPersonalPIN<C, M, R> {
        fluent_builders::ResetPersonalPIN::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestorePhoneNumber`](crate::client::fluent_builders::RestorePhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_id(impl Into<String>)`](crate::client::fluent_builders::RestorePhoneNumber::phone_number_id) / [`set_phone_number_id(Option<String>)`](crate::client::fluent_builders::RestorePhoneNumber::set_phone_number_id): <p>The phone number.</p>
    /// - On success, responds with [`RestorePhoneNumberOutput`](crate::output::RestorePhoneNumberOutput) with field(s):
    ///   - [`phone_number(Option<PhoneNumber>)`](crate::output::RestorePhoneNumberOutput::phone_number): <p>The phone number details.</p>
    /// - On failure, responds with [`SdkError<RestorePhoneNumberError>`](crate::error::RestorePhoneNumberError)
    pub fn restore_phone_number(&self) -> fluent_builders::RestorePhoneNumber<C, M, R> {
        fluent_builders::RestorePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchAvailablePhoneNumbers`](crate::client::fluent_builders::SearchAvailablePhoneNumbers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`area_code(impl Into<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::area_code) / [`set_area_code(Option<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_area_code): <p>The area code used to filter results. Only applies to the US.</p>
    ///   - [`city(impl Into<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::city) / [`set_city(Option<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_city): <p>The city used to filter results. Only applies to the US.</p>
    ///   - [`country(impl Into<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::country) / [`set_country(Option<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_country): <p>The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.</p>
    ///   - [`state(impl Into<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::state) / [`set_state(Option<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_state): <p>The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.</p>
    ///   - [`toll_free_prefix(impl Into<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::toll_free_prefix) / [`set_toll_free_prefix(Option<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_toll_free_prefix): <p>The toll-free prefix that you use to filter results. Only applies to the US.</p>
    ///   - [`phone_number_type(PhoneNumberType)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::phone_number_type) / [`set_phone_number_type(Option<PhoneNumberType>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_phone_number_type): <p>The phone number type used to filter results. Required for non-US numbers.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_max_results): <p>The maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchAvailablePhoneNumbers::set_next_token): <p>The token used to retrieve the next page of results.</p>
    /// - On success, responds with [`SearchAvailablePhoneNumbersOutput`](crate::output::SearchAvailablePhoneNumbersOutput) with field(s):
    ///   - [`e164_phone_numbers(Option<Vec<String>>)`](crate::output::SearchAvailablePhoneNumbersOutput::e164_phone_numbers): <p>List of phone numbers, in E.164 format.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchAvailablePhoneNumbersOutput::next_token): <p>The token used to retrieve the next page of search results.</p>
    /// - On failure, responds with [`SdkError<SearchAvailablePhoneNumbersError>`](crate::error::SearchAvailablePhoneNumbersError)
    pub fn search_available_phone_numbers(
        &self,
    ) -> fluent_builders::SearchAvailablePhoneNumbers<C, M, R> {
        fluent_builders::SearchAvailablePhoneNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendChannelMessage`](crate::client::fluent_builders::SendChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_content): <p>The content of the message.</p>
    ///   - [`r#type(ChannelMessageType)`](crate::client::fluent_builders::SendChannelMessage::r#type) / [`set_type(Option<ChannelMessageType>)`](crate::client::fluent_builders::SendChannelMessage::set_type): <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
    ///   - [`persistence(ChannelMessagePersistenceType)`](crate::client::fluent_builders::SendChannelMessage::persistence) / [`set_persistence(Option<ChannelMessagePersistenceType>)`](crate::client::fluent_builders::SendChannelMessage::set_persistence): <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_metadata): <p>The optional metadata for each message.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_client_request_token): <p>The <code>Idempotency</code> token for each client request.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::SendChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::SendChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`SendChannelMessageOutput`](crate::output::SendChannelMessageOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::SendChannelMessageOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(Option<String>)`](crate::output::SendChannelMessageOutput::message_id): <p>The ID string assigned to each message.</p>
    /// - On failure, responds with [`SdkError<SendChannelMessageError>`](crate::error::SendChannelMessageError)
    pub fn send_channel_message(&self) -> fluent_builders::SendChannelMessage<C, M, R> {
        fluent_builders::SendChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartMeetingTranscription`](crate::client::fluent_builders::StartMeetingTranscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::StartMeetingTranscription::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::StartMeetingTranscription::set_meeting_id): <p>The unique ID of the meeting being transcribed.</p>
    ///   - [`transcription_configuration(TranscriptionConfiguration)`](crate::client::fluent_builders::StartMeetingTranscription::transcription_configuration) / [`set_transcription_configuration(Option<TranscriptionConfiguration>)`](crate::client::fluent_builders::StartMeetingTranscription::set_transcription_configuration): <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
    /// - On success, responds with [`StartMeetingTranscriptionOutput`](crate::output::StartMeetingTranscriptionOutput)

    /// - On failure, responds with [`SdkError<StartMeetingTranscriptionError>`](crate::error::StartMeetingTranscriptionError)
    pub fn start_meeting_transcription(
        &self,
    ) -> fluent_builders::StartMeetingTranscription<C, M, R> {
        fluent_builders::StartMeetingTranscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopMeetingTranscription`](crate::client::fluent_builders::StopMeetingTranscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::StopMeetingTranscription::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::StopMeetingTranscription::set_meeting_id): <p>The unique ID of the meeting for which you stop transcription.</p>
    /// - On success, responds with [`StopMeetingTranscriptionOutput`](crate::output::StopMeetingTranscriptionOutput)

    /// - On failure, responds with [`SdkError<StopMeetingTranscriptionError>`](crate::error::StopMeetingTranscriptionError)
    pub fn stop_meeting_transcription(&self) -> fluent_builders::StopMeetingTranscription<C, M, R> {
        fluent_builders::StopMeetingTranscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagAttendee`](crate::client::fluent_builders::TagAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::TagAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::TagAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendee_id(impl Into<String>)`](crate::client::fluent_builders::TagAttendee::attendee_id) / [`set_attendee_id(Option<String>)`](crate::client::fluent_builders::TagAttendee::set_attendee_id): <p>The Amazon Chime SDK attendee ID.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagAttendee::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagAttendee::set_tags): <p>The tag key-value pairs.</p>
    /// - On success, responds with [`TagAttendeeOutput`](crate::output::TagAttendeeOutput)

    /// - On failure, responds with [`SdkError<TagAttendeeError>`](crate::error::TagAttendeeError)
    pub fn tag_attendee(&self) -> fluent_builders::TagAttendee<C, M, R> {
        fluent_builders::TagAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagMeeting`](crate::client::fluent_builders::TagMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::TagMeeting::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::TagMeeting::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagMeeting::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagMeeting::set_tags): <p>The tag key-value pairs.</p>
    /// - On success, responds with [`TagMeetingOutput`](crate::output::TagMeetingOutput)

    /// - On failure, responds with [`SdkError<TagMeetingError>`](crate::error::TagMeetingError)
    pub fn tag_meeting(&self) -> fluent_builders::TagMeeting<C, M, R> {
        fluent_builders::TagMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tag key-value pairs.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagAttendee`](crate::client::fluent_builders::UntagAttendee) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::UntagAttendee::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::UntagAttendee::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`attendee_id(impl Into<String>)`](crate::client::fluent_builders::UntagAttendee::attendee_id) / [`set_attendee_id(Option<String>)`](crate::client::fluent_builders::UntagAttendee::set_attendee_id): <p>The Amazon Chime SDK attendee ID.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagAttendee::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagAttendee::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagAttendeeOutput`](crate::output::UntagAttendeeOutput)

    /// - On failure, responds with [`SdkError<UntagAttendeeError>`](crate::error::UntagAttendeeError)
    pub fn untag_attendee(&self) -> fluent_builders::UntagAttendee<C, M, R> {
        fluent_builders::UntagAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagMeeting`](crate::client::fluent_builders::UntagMeeting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`meeting_id(impl Into<String>)`](crate::client::fluent_builders::UntagMeeting::meeting_id) / [`set_meeting_id(Option<String>)`](crate::client::fluent_builders::UntagMeeting::set_meeting_id): <p>The Amazon Chime SDK meeting ID.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagMeeting::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagMeeting::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagMeetingOutput`](crate::output::UntagMeetingOutput)

    /// - On failure, responds with [`SdkError<UntagMeetingError>`](crate::error::UntagMeetingError)
    pub fn untag_meeting(&self) -> fluent_builders::UntagMeeting<C, M, R> {
        fluent_builders::UntagMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccount`](crate::client::fluent_builders::UpdateAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateAccount::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAccount::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAccount::set_name): <p>The new name for the specified Amazon Chime account.</p>
    ///   - [`default_license(License)`](crate::client::fluent_builders::UpdateAccount::default_license) / [`set_default_license(Option<License>)`](crate::client::fluent_builders::UpdateAccount::set_default_license): <p>The default license applied when you add users to an Amazon Chime account.</p>
    /// - On success, responds with [`UpdateAccountOutput`](crate::output::UpdateAccountOutput) with field(s):
    ///   - [`account(Option<Account>)`](crate::output::UpdateAccountOutput::account): <p>The updated Amazon Chime account details.</p>
    /// - On failure, responds with [`SdkError<UpdateAccountError>`](crate::error::UpdateAccountError)
    pub fn update_account(&self) -> fluent_builders::UpdateAccount<C, M, R> {
        fluent_builders::UpdateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccountSettings`](crate::client::fluent_builders::UpdateAccountSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAccountSettings::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateAccountSettings::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`account_settings(AccountSettings)`](crate::client::fluent_builders::UpdateAccountSettings::account_settings) / [`set_account_settings(Option<AccountSettings>)`](crate::client::fluent_builders::UpdateAccountSettings::set_account_settings): <p>The Amazon Chime account settings to update.</p>
    /// - On success, responds with [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)

    /// - On failure, responds with [`SdkError<UpdateAccountSettingsError>`](crate::error::UpdateAccountSettingsError)
    pub fn update_account_settings(&self) -> fluent_builders::UpdateAccountSettings<C, M, R> {
        fluent_builders::UpdateAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAppInstance`](crate::client::fluent_builders::UpdateAppInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstance::app_instance_arn) / [`set_app_instance_arn(Option<String>)`](crate::client::fluent_builders::UpdateAppInstance::set_app_instance_arn): <p>The ARN of the <code>AppInstance</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstance::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAppInstance::set_name): <p>The name that you want to change.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstance::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateAppInstance::set_metadata): <p>The metadata that you want to change.</p>
    /// - On success, responds with [`UpdateAppInstanceOutput`](crate::output::UpdateAppInstanceOutput) with field(s):
    ///   - [`app_instance_arn(Option<String>)`](crate::output::UpdateAppInstanceOutput::app_instance_arn): <p>The ARN of the <code>AppInstance</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateAppInstanceError>`](crate::error::UpdateAppInstanceError)
    pub fn update_app_instance(&self) -> fluent_builders::UpdateAppInstance<C, M, R> {
        fluent_builders::UpdateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAppInstanceUser`](crate::client::fluent_builders::UpdateAppInstanceUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_instance_user_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::app_instance_user_arn) / [`set_app_instance_user_arn(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::set_app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::set_name): <p>The name of the <code>AppInstanceUser</code>.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateAppInstanceUser::set_metadata): <p>The metadata of the <code>AppInstanceUser</code>.</p>
    /// - On success, responds with [`UpdateAppInstanceUserOutput`](crate::output::UpdateAppInstanceUserOutput) with field(s):
    ///   - [`app_instance_user_arn(Option<String>)`](crate::output::UpdateAppInstanceUserOutput::app_instance_user_arn): <p>The ARN of the <code>AppInstanceUser</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateAppInstanceUserError>`](crate::error::UpdateAppInstanceUserError)
    pub fn update_app_instance_user(&self) -> fluent_builders::UpdateAppInstanceUser<C, M, R> {
        fluent_builders::UpdateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBot`](crate::client::fluent_builders::UpdateBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBot::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateBot::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateBot::set_bot_id): <p>The bot ID.</p>
    ///   - [`disabled(bool)`](crate::client::fluent_builders::UpdateBot::disabled) / [`set_disabled(Option<bool>)`](crate::client::fluent_builders::UpdateBot::set_disabled): <p>When true, stops the specified bot from running in your account.</p>
    /// - On success, responds with [`UpdateBotOutput`](crate::output::UpdateBotOutput) with field(s):
    ///   - [`bot(Option<Bot>)`](crate::output::UpdateBotOutput::bot): <p>The updated bot details.</p>
    /// - On failure, responds with [`SdkError<UpdateBotError>`](crate::error::UpdateBotError)
    pub fn update_bot(&self) -> fluent_builders::UpdateBot<C, M, R> {
        fluent_builders::UpdateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_name): <p>The name of the channel.</p>
    ///   - [`mode(ChannelMode)`](crate::client::fluent_builders::UpdateChannel::mode) / [`set_mode(Option<ChannelMode>)`](crate::client::fluent_builders::UpdateChannel::set_mode): <p>The mode of the update request.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_metadata): <p>The metadata for the update request.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`UpdateChannelOutput`](crate::output::UpdateChannelOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::UpdateChannelOutput::channel_arn): <p>The ARN of the channel.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelError>`](crate::error::UpdateChannelError)
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannelMessage`](crate::client::fluent_builders::UpdateChannelMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_message_id): <p>The ID string of the message being updated.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_content): <p>The content of the message being updated.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_metadata): <p>The metadata of the message being updated.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelMessage::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::UpdateChannelMessage::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`UpdateChannelMessageOutput`](crate::output::UpdateChannelMessageOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::UpdateChannelMessageOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`message_id(Option<String>)`](crate::output::UpdateChannelMessageOutput::message_id): <p>The ID string of the message being updated.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelMessageError>`](crate::error::UpdateChannelMessageError)
    pub fn update_channel_message(&self) -> fluent_builders::UpdateChannelMessage<C, M, R> {
        fluent_builders::UpdateChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannelReadMarker`](crate::client::fluent_builders::UpdateChannelReadMarker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::set_channel_arn): <p>The ARN of the channel.</p>
    ///   - [`chime_bearer(impl Into<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::chime_bearer) / [`set_chime_bearer(Option<String>)`](crate::client::fluent_builders::UpdateChannelReadMarker::set_chime_bearer): <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
    /// - On success, responds with [`UpdateChannelReadMarkerOutput`](crate::output::UpdateChannelReadMarkerOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::UpdateChannelReadMarkerOutput::channel_arn): <p>The ARN of the channel.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelReadMarkerError>`](crate::error::UpdateChannelReadMarkerError)
    pub fn update_channel_read_marker(&self) -> fluent_builders::UpdateChannelReadMarker<C, M, R> {
        fluent_builders::UpdateChannelReadMarker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGlobalSettings`](crate::client::fluent_builders::UpdateGlobalSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`business_calling(BusinessCallingSettings)`](crate::client::fluent_builders::UpdateGlobalSettings::business_calling) / [`set_business_calling(Option<BusinessCallingSettings>)`](crate::client::fluent_builders::UpdateGlobalSettings::set_business_calling): <p>The Amazon Chime Business Calling settings.</p>
    ///   - [`voice_connector(VoiceConnectorSettings)`](crate::client::fluent_builders::UpdateGlobalSettings::voice_connector) / [`set_voice_connector(Option<VoiceConnectorSettings>)`](crate::client::fluent_builders::UpdateGlobalSettings::set_voice_connector): <p>The Amazon Chime Voice Connector settings.</p>
    /// - On success, responds with [`UpdateGlobalSettingsOutput`](crate::output::UpdateGlobalSettingsOutput)

    /// - On failure, responds with [`SdkError<UpdateGlobalSettingsError>`](crate::error::UpdateGlobalSettingsError)
    pub fn update_global_settings(&self) -> fluent_builders::UpdateGlobalSettings<C, M, R> {
        fluent_builders::UpdateGlobalSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePhoneNumber`](crate::client::fluent_builders::UpdatePhoneNumber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_number_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::phone_number_id) / [`set_phone_number_id(Option<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_phone_number_id): <p>The phone number ID.</p>
    ///   - [`product_type(PhoneNumberProductType)`](crate::client::fluent_builders::UpdatePhoneNumber::product_type) / [`set_product_type(Option<PhoneNumberProductType>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_product_type): <p>The product type.</p>
    ///   - [`calling_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::calling_name) / [`set_calling_name(Option<String>)`](crate::client::fluent_builders::UpdatePhoneNumber::set_calling_name): <p>The outbound calling name associated with the phone number.</p>
    /// - On success, responds with [`UpdatePhoneNumberOutput`](crate::output::UpdatePhoneNumberOutput) with field(s):
    ///   - [`phone_number(Option<PhoneNumber>)`](crate::output::UpdatePhoneNumberOutput::phone_number): <p>The updated phone number details.</p>
    /// - On failure, responds with [`SdkError<UpdatePhoneNumberError>`](crate::error::UpdatePhoneNumberError)
    pub fn update_phone_number(&self) -> fluent_builders::UpdatePhoneNumber<C, M, R> {
        fluent_builders::UpdatePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePhoneNumberSettings`](crate::client::fluent_builders::UpdatePhoneNumberSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calling_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePhoneNumberSettings::calling_name) / [`set_calling_name(Option<String>)`](crate::client::fluent_builders::UpdatePhoneNumberSettings::set_calling_name): <p>The default outbound calling name for the account.</p>
    /// - On success, responds with [`UpdatePhoneNumberSettingsOutput`](crate::output::UpdatePhoneNumberSettingsOutput)

    /// - On failure, responds with [`SdkError<UpdatePhoneNumberSettingsError>`](crate::error::UpdatePhoneNumberSettingsError)
    pub fn update_phone_number_settings(
        &self,
    ) -> fluent_builders::UpdatePhoneNumberSettings<C, M, R> {
        fluent_builders::UpdatePhoneNumberSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProxySession`](crate::client::fluent_builders::UpdateProxySession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProxySession::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::UpdateProxySession::set_voice_connector_id): <p>The Amazon Chime voice connector ID.</p>
    ///   - [`proxy_session_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProxySession::proxy_session_id) / [`set_proxy_session_id(Option<String>)`](crate::client::fluent_builders::UpdateProxySession::set_proxy_session_id): <p>The proxy session ID.</p>
    ///   - [`capabilities(Vec<Capability>)`](crate::client::fluent_builders::UpdateProxySession::capabilities) / [`set_capabilities(Option<Vec<Capability>>)`](crate::client::fluent_builders::UpdateProxySession::set_capabilities): <p>The proxy session capabilities.</p>
    ///   - [`expiry_minutes(i32)`](crate::client::fluent_builders::UpdateProxySession::expiry_minutes) / [`set_expiry_minutes(Option<i32>)`](crate::client::fluent_builders::UpdateProxySession::set_expiry_minutes): <p>The number of minutes allowed for the proxy session.</p>
    /// - On success, responds with [`UpdateProxySessionOutput`](crate::output::UpdateProxySessionOutput) with field(s):
    ///   - [`proxy_session(Option<ProxySession>)`](crate::output::UpdateProxySessionOutput::proxy_session): <p>The proxy session details.</p>
    /// - On failure, responds with [`SdkError<UpdateProxySessionError>`](crate::error::UpdateProxySessionError)
    pub fn update_proxy_session(&self) -> fluent_builders::UpdateProxySession<C, M, R> {
        fluent_builders::UpdateProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoom`](crate::client::fluent_builders::UpdateRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoom::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateRoom::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoom::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::UpdateRoom::set_room_id): <p>The room ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRoom::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRoom::set_name): <p>The room name.</p>
    /// - On success, responds with [`UpdateRoomOutput`](crate::output::UpdateRoomOutput) with field(s):
    ///   - [`room(Option<Room>)`](crate::output::UpdateRoomOutput::room): <p>The room details.</p>
    /// - On failure, responds with [`SdkError<UpdateRoomError>`](crate::error::UpdateRoomError)
    pub fn update_room(&self) -> fluent_builders::UpdateRoom<C, M, R> {
        fluent_builders::UpdateRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoomMembership`](crate::client::fluent_builders::UpdateRoomMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoomMembership::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateRoomMembership::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`room_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoomMembership::room_id) / [`set_room_id(Option<String>)`](crate::client::fluent_builders::UpdateRoomMembership::set_room_id): <p>The room ID.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoomMembership::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::UpdateRoomMembership::set_member_id): <p>The member ID.</p>
    ///   - [`role(RoomMembershipRole)`](crate::client::fluent_builders::UpdateRoomMembership::role) / [`set_role(Option<RoomMembershipRole>)`](crate::client::fluent_builders::UpdateRoomMembership::set_role): <p>The role of the member.</p>
    /// - On success, responds with [`UpdateRoomMembershipOutput`](crate::output::UpdateRoomMembershipOutput) with field(s):
    ///   - [`room_membership(Option<RoomMembership>)`](crate::output::UpdateRoomMembershipOutput::room_membership): <p>The room membership details.</p>
    /// - On failure, responds with [`SdkError<UpdateRoomMembershipError>`](crate::error::UpdateRoomMembershipError)
    pub fn update_room_membership(&self) -> fluent_builders::UpdateRoomMembership<C, M, R> {
        fluent_builders::UpdateRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSipMediaApplication`](crate::client::fluent_builders::UpdateSipMediaApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSipMediaApplication::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::UpdateSipMediaApplication::set_sip_media_application_id): <p>The SIP media application ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateSipMediaApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateSipMediaApplication::set_name): <p>The new name for the specified SIP media application.</p>
    ///   - [`endpoints(Vec<SipMediaApplicationEndpoint>)`](crate::client::fluent_builders::UpdateSipMediaApplication::endpoints) / [`set_endpoints(Option<Vec<SipMediaApplicationEndpoint>>)`](crate::client::fluent_builders::UpdateSipMediaApplication::set_endpoints): <p>The new set of endpoints for the specified SIP media application.</p>
    /// - On success, responds with [`UpdateSipMediaApplicationOutput`](crate::output::UpdateSipMediaApplicationOutput) with field(s):
    ///   - [`sip_media_application(Option<SipMediaApplication>)`](crate::output::UpdateSipMediaApplicationOutput::sip_media_application): <p>The updated SIP media application details.</p>
    /// - On failure, responds with [`SdkError<UpdateSipMediaApplicationError>`](crate::error::UpdateSipMediaApplicationError)
    pub fn update_sip_media_application(
        &self,
    ) -> fluent_builders::UpdateSipMediaApplication<C, M, R> {
        fluent_builders::UpdateSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSipMediaApplicationCall`](crate::client::fluent_builders::UpdateSipMediaApplicationCall) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_media_application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSipMediaApplicationCall::sip_media_application_id) / [`set_sip_media_application_id(Option<String>)`](crate::client::fluent_builders::UpdateSipMediaApplicationCall::set_sip_media_application_id): <p>The ID of the SIP media application handling the call.</p>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSipMediaApplicationCall::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::UpdateSipMediaApplicationCall::set_transaction_id): <p>The ID of the call transaction.</p>
    ///   - [`arguments(HashMap<String, String>)`](crate::client::fluent_builders::UpdateSipMediaApplicationCall::arguments) / [`set_arguments(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateSipMediaApplicationCall::set_arguments): <p>Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can contain 0-20 key-value pairs.</p>
    /// - On success, responds with [`UpdateSipMediaApplicationCallOutput`](crate::output::UpdateSipMediaApplicationCallOutput) with field(s):
    ///   - [`sip_media_application_call(Option<SipMediaApplicationCall>)`](crate::output::UpdateSipMediaApplicationCallOutput::sip_media_application_call): <p>A <code>Call</code> instance for a SIP media application.</p>
    /// - On failure, responds with [`SdkError<UpdateSipMediaApplicationCallError>`](crate::error::UpdateSipMediaApplicationCallError)
    pub fn update_sip_media_application_call(
        &self,
    ) -> fluent_builders::UpdateSipMediaApplicationCall<C, M, R> {
        fluent_builders::UpdateSipMediaApplicationCall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSipRule`](crate::client::fluent_builders::UpdateSipRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sip_rule_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSipRule::sip_rule_id) / [`set_sip_rule_id(Option<String>)`](crate::client::fluent_builders::UpdateSipRule::set_sip_rule_id): <p>The SIP rule ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateSipRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateSipRule::set_name): <p>The new name for the specified SIP rule.</p>
    ///   - [`disabled(bool)`](crate::client::fluent_builders::UpdateSipRule::disabled) / [`set_disabled(Option<bool>)`](crate::client::fluent_builders::UpdateSipRule::set_disabled): <p>The new value specified to indicate whether the rule is disabled.</p>
    ///   - [`target_applications(Vec<SipRuleTargetApplication>)`](crate::client::fluent_builders::UpdateSipRule::target_applications) / [`set_target_applications(Option<Vec<SipRuleTargetApplication>>)`](crate::client::fluent_builders::UpdateSipRule::set_target_applications): <p>The new value of the list of target applications.</p>
    /// - On success, responds with [`UpdateSipRuleOutput`](crate::output::UpdateSipRuleOutput) with field(s):
    ///   - [`sip_rule(Option<SipRule>)`](crate::output::UpdateSipRuleOutput::sip_rule): <p>Updated SIP rule details.</p>
    /// - On failure, responds with [`SdkError<UpdateSipRuleError>`](crate::error::UpdateSipRuleError)
    pub fn update_sip_rule(&self) -> fluent_builders::UpdateSipRule<C, M, R> {
        fluent_builders::UpdateSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUser`](crate::client::fluent_builders::UpdateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_user_id): <p>The user ID.</p>
    ///   - [`license_type(License)`](crate::client::fluent_builders::UpdateUser::license_type) / [`set_license_type(Option<License>)`](crate::client::fluent_builders::UpdateUser::set_license_type): <p>The user license type to update. This must be a supported license type for the Amazon Chime account that the user belongs to.</p>
    ///   - [`user_type(UserType)`](crate::client::fluent_builders::UpdateUser::user_type) / [`set_user_type(Option<UserType>)`](crate::client::fluent_builders::UpdateUser::set_user_type): <p>The user type.</p>
    ///   - [`alexa_for_business_metadata(AlexaForBusinessMetadata)`](crate::client::fluent_builders::UpdateUser::alexa_for_business_metadata) / [`set_alexa_for_business_metadata(Option<AlexaForBusinessMetadata>)`](crate::client::fluent_builders::UpdateUser::set_alexa_for_business_metadata): <p>The Alexa for Business metadata.</p>
    /// - On success, responds with [`UpdateUserOutput`](crate::output::UpdateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::UpdateUserOutput::user): <p>The updated user details.</p>
    /// - On failure, responds with [`SdkError<UpdateUserError>`](crate::error::UpdateUserError)
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserSettings`](crate::client::fluent_builders::UpdateUserSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserSettings::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateUserSettings::set_account_id): <p>The Amazon Chime account ID.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserSettings::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUserSettings::set_user_id): <p>The user ID.</p>
    ///   - [`user_settings(UserSettings)`](crate::client::fluent_builders::UpdateUserSettings::user_settings) / [`set_user_settings(Option<UserSettings>)`](crate::client::fluent_builders::UpdateUserSettings::set_user_settings): <p>The user settings to update.</p>
    /// - On success, responds with [`UpdateUserSettingsOutput`](crate::output::UpdateUserSettingsOutput)

    /// - On failure, responds with [`SdkError<UpdateUserSettingsError>`](crate::error::UpdateUserSettingsError)
    pub fn update_user_settings(&self) -> fluent_builders::UpdateUserSettings<C, M, R> {
        fluent_builders::UpdateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVoiceConnector`](crate::client::fluent_builders::UpdateVoiceConnector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVoiceConnector::voice_connector_id) / [`set_voice_connector_id(Option<String>)`](crate::client::fluent_builders::UpdateVoiceConnector::set_voice_connector_id): <p>The Amazon Chime Voice Connector ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateVoiceConnector::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateVoiceConnector::set_name): <p>The name of the Amazon Chime Voice Connector.</p>
    ///   - [`require_encryption(bool)`](crate::client::fluent_builders::UpdateVoiceConnector::require_encryption) / [`set_require_encryption(Option<bool>)`](crate::client::fluent_builders::UpdateVoiceConnector::set_require_encryption): <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
    /// - On success, responds with [`UpdateVoiceConnectorOutput`](crate::output::UpdateVoiceConnectorOutput) with field(s):
    ///   - [`voice_connector(Option<VoiceConnector>)`](crate::output::UpdateVoiceConnectorOutput::voice_connector): <p>The updated Amazon Chime Voice Connector details.</p>
    /// - On failure, responds with [`SdkError<UpdateVoiceConnectorError>`](crate::error::UpdateVoiceConnectorError)
    pub fn update_voice_connector(&self) -> fluent_builders::UpdateVoiceConnector<C, M, R> {
        fluent_builders::UpdateVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVoiceConnectorGroup`](crate::client::fluent_builders::UpdateVoiceConnectorGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`voice_connector_group_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVoiceConnectorGroup::voice_connector_group_id) / [`set_voice_connector_group_id(Option<String>)`](crate::client::fluent_builders::UpdateVoiceConnectorGroup::set_voice_connector_group_id): <p>The Amazon Chime Voice Connector group ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateVoiceConnectorGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateVoiceConnectorGroup::set_name): <p>The name of the Amazon Chime Voice Connector group.</p>
    ///   - [`voice_connector_items(Vec<VoiceConnectorItem>)`](crate::client::fluent_builders::UpdateVoiceConnectorGroup::voice_connector_items) / [`set_voice_connector_items(Option<Vec<VoiceConnectorItem>>)`](crate::client::fluent_builders::UpdateVoiceConnectorGroup::set_voice_connector_items): <p>The <code>VoiceConnectorItems</code> to associate with the group.</p>
    /// - On success, responds with [`UpdateVoiceConnectorGroupOutput`](crate::output::UpdateVoiceConnectorGroupOutput) with field(s):
    ///   - [`voice_connector_group(Option<VoiceConnectorGroup>)`](crate::output::UpdateVoiceConnectorGroupOutput::voice_connector_group): <p>The updated Amazon Chime Voice Connector group details.</p>
    /// - On failure, responds with [`SdkError<UpdateVoiceConnectorGroupError>`](crate::error::UpdateVoiceConnectorGroupError)
    pub fn update_voice_connector_group(
        &self,
    ) -> fluent_builders::UpdateVoiceConnectorGroup<C, M, R> {
        fluent_builders::UpdateVoiceConnectorGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociatePhoneNumbersWithVoiceConnector`.
    ///
    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePhoneNumbersWithVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_phone_numbers_with_voice_connector_input::Builder,
    }
    impl<C, M, R> AssociatePhoneNumbersWithVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePhoneNumbersWithVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePhoneNumbersWithVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociatePhoneNumbersWithVoiceConnectorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePhoneNumbersWithVoiceConnectorInputOperationOutputAlias,
                crate::output::AssociatePhoneNumbersWithVoiceConnectorOutput,
                crate::error::AssociatePhoneNumbersWithVoiceConnectorError,
                crate::input::AssociatePhoneNumbersWithVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(input.into());
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn force_associate(mut self, input: bool) -> Self {
            self.inner = self.inner.force_associate(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn set_force_associate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_associate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePhoneNumbersWithVoiceConnectorGroup`.
    ///
    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePhoneNumbersWithVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_phone_numbers_with_voice_connector_group_input::Builder,
    }
    impl<C, M, R> AssociatePhoneNumbersWithVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePhoneNumbersWithVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePhoneNumbersWithVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociatePhoneNumbersWithVoiceConnectorGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::AssociatePhoneNumbersWithVoiceConnectorGroupOutput,
                crate::error::AssociatePhoneNumbersWithVoiceConnectorGroupError,
                crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(input.into());
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn force_associate(mut self, input: bool) -> Self {
            self.inner = self.inner.force_associate(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn set_force_associate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_associate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePhoneNumberWithUser`.
    ///
    /// <p>Associates a phone number with the specified Amazon Chime user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePhoneNumberWithUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_phone_number_with_user_input::Builder,
    }
    impl<C, M, R> AssociatePhoneNumberWithUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePhoneNumberWithUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePhoneNumberWithUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePhoneNumberWithUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePhoneNumberWithUserInputOperationOutputAlias,
                crate::output::AssociatePhoneNumberWithUserOutput,
                crate::error::AssociatePhoneNumberWithUserError,
                crate::input::AssociatePhoneNumberWithUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn e164_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_number(input.into());
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn set_e164_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSigninDelegateGroupsWithAccount`.
    ///
    /// <p>Associates the specified sign-in delegate groups with the specified Amazon Chime account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateSigninDelegateGroupsWithAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_signin_delegate_groups_with_account_input::Builder,
    }
    impl<C, M, R> AssociateSigninDelegateGroupsWithAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSigninDelegateGroupsWithAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSigninDelegateGroupsWithAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateSigninDelegateGroupsWithAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSigninDelegateGroupsWithAccountInputOperationOutputAlias,
                crate::output::AssociateSigninDelegateGroupsWithAccountOutput,
                crate::error::AssociateSigninDelegateGroupsWithAccountError,
                crate::input::AssociateSigninDelegateGroupsWithAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `SigninDelegateGroups`.
        ///
        /// To override the contents of this collection use [`set_signin_delegate_groups`](Self::set_signin_delegate_groups).
        ///
        /// <p>The sign-in delegate groups.</p>
        pub fn signin_delegate_groups(mut self, input: crate::model::SigninDelegateGroup) -> Self {
            self.inner = self.inner.signin_delegate_groups(input);
            self
        }
        /// <p>The sign-in delegate groups.</p>
        pub fn set_signin_delegate_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigninDelegateGroup>>,
        ) -> Self {
            self.inner = self.inner.set_signin_delegate_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateAttendee`.
    ///
    /// <p> Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_attendee_input::Builder,
    }
    impl<C, M, R> BatchCreateAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateAttendeeInputOperationOutputAlias,
                crate::output::BatchCreateAttendeeOutput,
                crate::error::BatchCreateAttendeeError,
                crate::input::BatchCreateAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The request containing the attendees to create.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            self.inner = self.inner.attendees(input);
            self
        }
        /// <p>The request containing the attendees to create.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateChannelMembership`.
    ///
    /// <p>Adds a specified number of users to a channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_channel_membership_input::Builder,
    }
    impl<C, M, R> BatchCreateChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateChannelMembershipInputOperationOutputAlias,
                crate::output::BatchCreateChannelMembershipOutput,
                crate::error::BatchCreateChannelMembershipError,
                crate::input::BatchCreateChannelMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `MemberArns`.
        ///
        /// To override the contents of this collection use [`set_member_arns`](Self::set_member_arns).
        ///
        /// <p>The ARNs of the members you want to add to the channel.</p>
        pub fn member_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arns(input.into());
            self
        }
        /// <p>The ARNs of the members you want to add to the channel.</p>
        pub fn set_member_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_member_arns(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateRoomMembership`.
    ///
    /// <p>Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateRoomMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_room_membership_input::Builder,
    }
    impl<C, M, R> BatchCreateRoomMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateRoomMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateRoomMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateRoomMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateRoomMembershipInputOperationOutputAlias,
                crate::output::BatchCreateRoomMembershipOutput,
                crate::error::BatchCreateRoomMembershipError,
                crate::input::BatchCreateRoomMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// Appends an item to `MembershipItemList`.
        ///
        /// To override the contents of this collection use [`set_membership_item_list`](Self::set_membership_item_list).
        ///
        /// <p>The list of membership items.</p>
        pub fn membership_item_list(mut self, input: crate::model::MembershipItem) -> Self {
            self.inner = self.inner.membership_item_list(input);
            self
        }
        /// <p>The list of membership items.</p>
        pub fn set_membership_item_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MembershipItem>>,
        ) -> Self {
            self.inner = self.inner.set_membership_item_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeletePhoneNumber`.
    ///
    /// <p> Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted. </p>
    /// <p> Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeletePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_phone_number_input::Builder,
    }
    impl<C, M, R> BatchDeletePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeletePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeletePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeletePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeletePhoneNumberInputOperationOutputAlias,
                crate::output::BatchDeletePhoneNumberOutput,
                crate::error::BatchDeletePhoneNumberError,
                crate::input::BatchDeletePhoneNumberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `PhoneNumberIds`.
        ///
        /// To override the contents of this collection use [`set_phone_number_ids`](Self::set_phone_number_ids).
        ///
        /// <p>List of phone number IDs.</p>
        pub fn phone_number_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_ids(input.into());
            self
        }
        /// <p>List of phone number IDs.</p>
        pub fn set_phone_number_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchSuspendUser`.
    ///
    /// <p>Suspends up to 50 users from a <code>Team</code> or <code>EnterpriseLWA</code> Amazon Chime account. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    /// <p>Users suspended from a <code>Team</code> account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended <code>Team</code> account users, invite them to the <code>Team</code> account again. You can use the <code>InviteUsers</code> action to do so.</p>
    /// <p>Users suspended from an <code>EnterpriseLWA</code> account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended <code>EnterpriseLWA</code> account users, use the <code>BatchUnsuspendUser</code> action.</p>
    /// <p> To sign out users without suspending them, use the <code>LogoutUser</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchSuspendUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_suspend_user_input::Builder,
    }
    impl<C, M, R> BatchSuspendUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchSuspendUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchSuspendUserOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchSuspendUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchSuspendUserInputOperationOutputAlias,
                crate::output::BatchSuspendUserOutput,
                crate::error::BatchSuspendUserError,
                crate::input::BatchSuspendUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UserIdList`.
        ///
        /// To override the contents of this collection use [`set_user_id_list`](Self::set_user_id_list).
        ///
        /// <p>The request containing the user IDs to suspend.</p>
        pub fn user_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id_list(input.into());
            self
        }
        /// <p>The request containing the user IDs to suspend.</p>
        pub fn set_user_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_id_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUnsuspendUser`.
    ///
    /// <p>Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime <code>EnterpriseLWA</code> account. Only users on <code>EnterpriseLWA</code> accounts can be unsuspended using this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html"> Managing Your Amazon Chime Accounts </a> in the account types, in the <i>Amazon Chime Administration Guide</i>. </p>
    /// <p> Previously suspended users who are unsuspended using this action are returned to <code>Registered</code> status. Users who are not previously suspended are ignored. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchUnsuspendUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_unsuspend_user_input::Builder,
    }
    impl<C, M, R> BatchUnsuspendUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUnsuspendUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUnsuspendUserOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUnsuspendUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUnsuspendUserInputOperationOutputAlias,
                crate::output::BatchUnsuspendUserOutput,
                crate::error::BatchUnsuspendUserError,
                crate::input::BatchUnsuspendUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UserIdList`.
        ///
        /// To override the contents of this collection use [`set_user_id_list`](Self::set_user_id_list).
        ///
        /// <p>The request containing the user IDs to unsuspend.</p>
        pub fn user_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id_list(input.into());
            self
        }
        /// <p>The request containing the user IDs to unsuspend.</p>
        pub fn set_user_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_id_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdatePhoneNumber`.
    ///
    /// <p>Updates phone number product types or calling names. You can update one attribute at a time for each <code>UpdatePhoneNumberRequestItem</code>. For example, you can update the product type or the calling name.</p>
    /// <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p>
    /// <p>Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchUpdatePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_phone_number_input::Builder,
    }
    impl<C, M, R> BatchUpdatePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdatePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdatePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdatePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdatePhoneNumberInputOperationOutputAlias,
                crate::output::BatchUpdatePhoneNumberOutput,
                crate::error::BatchUpdatePhoneNumberError,
                crate::input::BatchUpdatePhoneNumberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UpdatePhoneNumberRequestItems`.
        ///
        /// To override the contents of this collection use [`set_update_phone_number_request_items`](Self::set_update_phone_number_request_items).
        ///
        /// <p>The request containing the phone number IDs and product types or calling names to update.</p>
        pub fn update_phone_number_request_items(
            mut self,
            input: crate::model::UpdatePhoneNumberRequestItem,
        ) -> Self {
            self.inner = self.inner.update_phone_number_request_items(input);
            self
        }
        /// <p>The request containing the phone number IDs and product types or calling names to update.</p>
        pub fn set_update_phone_number_request_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdatePhoneNumberRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_update_phone_number_request_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdateUser`.
    ///
    /// <p>Updates user details within the <code>UpdateUserRequestItem</code> object for up to 20 users for the specified Amazon Chime account. Currently, only <code>LicenseType</code> updates are supported for this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchUpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_user_input::Builder,
    }
    impl<C, M, R> BatchUpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdateUserInputOperationOutputAlias,
                crate::output::BatchUpdateUserOutput,
                crate::error::BatchUpdateUserError,
                crate::input::BatchUpdateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UpdateUserRequestItems`.
        ///
        /// To override the contents of this collection use [`set_update_user_request_items`](Self::set_update_user_request_items).
        ///
        /// <p>The request containing the user IDs and details to update.</p>
        pub fn update_user_request_items(
            mut self,
            input: crate::model::UpdateUserRequestItem,
        ) -> Self {
            self.inner = self.inner.update_user_request_items(input);
            self
        }
        /// <p>The request containing the user IDs and details to update.</p>
        pub fn set_update_user_request_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateUserRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_update_user_request_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccount`.
    ///
    /// <p>Creates an Amazon Chime account under the administrator's AWS account. Only <code>Team</code> account types are currently supported for this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_account_input::Builder,
    }
    impl<C, M, R> CreateAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccountInputOperationOutputAlias,
                crate::output::CreateAccountOutput,
                crate::error::CreateAccountError,
                crate::input::CreateAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Chime account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon Chime account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstance`.
    ///
    /// <p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_input::Builder,
    }
    impl<C, M, R> CreateAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceInputOperationOutputAlias,
                crate::output::CreateAppInstanceOutput,
                crate::error::CreateAppInstanceError,
                crate::input::CreateAppInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceAdmin`.
    ///
    /// <p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the following actions. </p>
    /// <ul>
    /// <li> <p> <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p> </li>
    /// <li> <p> <code>DeleteChannelMessage</code> actions.</p> </li>
    /// </ul>
    /// <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_admin_input::Builder,
    }
    impl<C, M, R> CreateAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceAdminInputOperationOutputAlias,
                crate::output::CreateAppInstanceAdminOutput,
                crate::error::CreateAppInstanceAdminError,
                crate::input::CreateAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(input.into());
            self
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceUser`.
    ///
    /// <p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_user_input::Builder,
    }
    impl<C, M, R> CreateAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceUserInputOperationOutputAlias,
                crate::output::CreateAppInstanceUserOutput,
                crate::error::CreateAppInstanceUserError,
                crate::input::CreateAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn app_instance_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_id(input.into());
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_id(input);
            self
        }
        /// <p>The user's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The user's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAttendee`.
    ///
    /// <p> Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_attendee_input::Builder,
    }
    impl<C, M, R> CreateAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAttendeeInputOperationOutputAlias,
                crate::output::CreateAttendeeOutput,
                crate::error::CreateAttendeeError,
                crate::input::CreateAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_user_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_user_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBot`.
    ///
    /// <p>Creates a bot for an Amazon Chime Enterprise account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bot_input::Builder,
    }
    impl<C, M, R> CreateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBotInputOperationOutputAlias,
                crate::output::CreateBotOutput,
                crate::error::CreateBotError,
                crate::input::CreateBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot display name.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The bot display name.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The domain of the Amazon Chime Enterprise account.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain of the Amazon Chime Enterprise account.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Creates a channel to which you can add users and send messages.</p>
    /// <p> <b>Restriction</b>: You can't change a channel's privacy.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel request.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the channel request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.inner = self.inner.mode(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelBan`.
    ///
    /// <p>Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or channels.</p>
    /// <p>If you ban a user who is already part of a channel, that user is automatically kicked from the channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_ban_input::Builder,
    }
    impl<C, M, R> CreateChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelBanInputOperationOutputAlias,
                crate::output::CreateChannelBanOutput,
                crate::error::CreateChannelBanError,
                crate::input::CreateChannelBanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the ban request.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the ban request.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelMembership`.
    ///
    /// <p>Adds a user to a channel. The <code>InvitedBy</code> response field is derived from the request header. A channel member can:</p>
    /// <ul>
    /// <li> <p>List messages</p> </li>
    /// <li> <p>Send messages</p> </li>
    /// <li> <p>Receive messages</p> </li>
    /// <li> <p>Edit their own messages</p> </li>
    /// <li> <p>Leave the channel</p> </li>
    /// </ul>
    /// <p>Privacy settings impact this action as follows:</p>
    /// <ul>
    /// <li> <p>Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.</p> </li>
    /// <li> <p>Private Channels: You must be a member to list or send messages.</p> </li>
    /// </ul> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_membership_input::Builder,
    }
    impl<C, M, R> CreateChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelMembershipInputOperationOutputAlias,
                crate::output::CreateChannelMembershipOutput,
                crate::error::CreateChannelMembershipError,
                crate::input::CreateChannelMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member you want to add to the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The ARN of the member you want to add to the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelModerator`.
    ///
    /// <p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p>
    /// <ul>
    /// <li> <p>Add and remove other members of the channel.</p> </li>
    /// <li> <p>Add and remove other moderators of the channel.</p> </li>
    /// <li> <p>Add and remove user bans for the channel.</p> </li>
    /// <li> <p>Redact messages in the channel.</p> </li>
    /// <li> <p>List messages in the channel.</p> </li>
    /// </ul> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_moderator_input::Builder,
    }
    impl<C, M, R> CreateChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelModeratorInputOperationOutputAlias,
                crate::output::CreateChannelModeratorOutput,
                crate::error::CreateChannelModeratorError,
                crate::input::CreateChannelModeratorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(input.into());
            self
        }
        /// <p>The ARN of the moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMediaCapturePipeline`.
    ///
    /// <p>Creates a media capture pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMediaCapturePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_media_capture_pipeline_input::Builder,
    }
    impl<C, M, R> CreateMediaCapturePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMediaCapturePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMediaCapturePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMediaCapturePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMediaCapturePipelineInputOperationOutputAlias,
                crate::output::CreateMediaCapturePipelineOutput,
                crate::error::CreateMediaCapturePipelineError,
                crate::input::CreateMediaCapturePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.</p>
        pub fn source_type(mut self, input: crate::model::MediaPipelineSourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>ARN of the source from which the media artifacts are captured.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>ARN of the source from which the media artifacts are captured.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>
        pub fn sink_type(mut self, input: crate::model::MediaPipelineSinkType) -> Self {
            self.inner = self.inner.sink_type(input);
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>
        pub fn set_sink_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSinkType>,
        ) -> Self {
            self.inner = self.inner.set_sink_type(input);
            self
        }
        /// <p>The ARN of the sink type.</p>
        pub fn sink_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sink_arn(input.into());
            self
        }
        /// <p>The ARN of the sink type.</p>
        pub fn set_sink_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sink_arn(input);
            self
        }
        /// <p>The token assigned to the client making the pipeline request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The token assigned to the client making the pipeline request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn chime_sdk_meeting_configuration(
            mut self,
            input: crate::model::ChimeSdkMeetingConfiguration,
        ) -> Self {
            self.inner = self.inner.chime_sdk_meeting_configuration(input);
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn set_chime_sdk_meeting_configuration(
            mut self,
            input: std::option::Option<crate::model::ChimeSdkMeetingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_chime_sdk_meeting_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeeting`.
    ///
    /// <p> Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i> . For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_input::Builder,
    }
    impl<C, M, R> CreateMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingInputOperationOutputAlias,
                crate::output::CreateMeetingOutput,
                crate::error::CreateMeetingError,
                crate::input::CreateMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code>. </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(input.into());
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code>. </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::MeetingNotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::MeetingNotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeetingDialOut`.
    ///
    /// <p>Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.</p>
    /// <p>To play welcome audio or implement an interactive voice response (IVR), use the <code>CreateSipMediaApplicationCall</code> action with the corresponding SIP media application ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMeetingDialOut<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_dial_out_input::Builder,
    }
    impl<C, M, R> CreateMeetingDialOut<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeetingDialOut`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingDialOutOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingDialOutError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingDialOutInputOperationOutputAlias,
                crate::output::CreateMeetingDialOutOutput,
                crate::error::CreateMeetingDialOutError,
                crate::input::CreateMeetingDialOutInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>Phone number used as the caller ID when the remote party receives a call.</p>
        pub fn from_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_phone_number(input.into());
            self
        }
        /// <p>Phone number used as the caller ID when the remote party receives a call.</p>
        pub fn set_from_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_phone_number(input);
            self
        }
        /// <p>Phone number called when inviting someone to a meeting.</p>
        pub fn to_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.to_phone_number(input.into());
            self
        }
        /// <p>Phone number called when inviting someone to a meeting.</p>
        pub fn set_to_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_to_phone_number(input);
            self
        }
        /// <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
        pub fn join_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.join_token(input.into());
            self
        }
        /// <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
        pub fn set_join_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_join_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeetingWithAttendees`.
    ///
    /// <p> Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i> . For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMeetingWithAttendees<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_with_attendees_input::Builder,
    }
    impl<C, M, R> CreateMeetingWithAttendees<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeetingWithAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingWithAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingWithAttendeesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingWithAttendeesInputOperationOutputAlias,
                crate::output::CreateMeetingWithAttendeesOutput,
                crate::error::CreateMeetingWithAttendeesError,
                crate::input::CreateMeetingWithAttendeesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code> . </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(input.into());
            self
        }
        /// <p> The Region in which to create the meeting. Default: <code>us-east-1</code> . </p>
        /// <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>). </p>
        pub fn notifications_configuration(
            mut self,
            input: crate::model::MeetingNotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(input);
            self
        }
        /// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>). </p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::MeetingNotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The request containing the attendees to create.</p>
        pub fn attendees(mut self, input: crate::model::CreateAttendeeRequestItem) -> Self {
            self.inner = self.inner.attendees(input);
            self
        }
        /// <p>The request containing the attendees to create.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePhoneNumberOrder`.
    ///
    /// <p>Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePhoneNumberOrder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_phone_number_order_input::Builder,
    }
    impl<C, M, R> CreatePhoneNumberOrder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePhoneNumberOrder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePhoneNumberOrderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePhoneNumberOrderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePhoneNumberOrderInputOperationOutputAlias,
                crate::output::CreatePhoneNumberOrderOutput,
                crate::error::CreatePhoneNumberOrderError,
                crate::input::CreatePhoneNumberOrderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, input: crate::model::PhoneNumberProductType) -> Self {
            self.inner = self.inner.product_type(input);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(input.into());
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProxySession`.
    ///
    /// <p>Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProxySession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_proxy_session_input::Builder,
    }
    impl<C, M, R> CreateProxySession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProxySession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProxySessionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProxySessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProxySessionInputOperationOutputAlias,
                crate::output::CreateProxySessionOutput,
                crate::error::CreateProxySessionError,
                crate::input::CreateProxySessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `ParticipantPhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_participant_phone_numbers`](Self::set_participant_phone_numbers).
        ///
        /// <p>The participant phone numbers.</p>
        pub fn participant_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.participant_phone_numbers(input.into());
            self
        }
        /// <p>The participant phone numbers.</p>
        pub fn set_participant_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_participant_phone_numbers(input);
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn expiry_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.expiry_minutes(input);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn set_expiry_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiry_minutes(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>The proxy session capabilities.</p>
        pub fn capabilities(mut self, input: crate::model::Capability) -> Self {
            self.inner = self.inner.capabilities(input);
            self
        }
        /// <p>The proxy session capabilities.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn number_selection_behavior(
            mut self,
            input: crate::model::NumberSelectionBehavior,
        ) -> Self {
            self.inner = self.inner.number_selection_behavior(input);
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn set_number_selection_behavior(
            mut self,
            input: std::option::Option<crate::model::NumberSelectionBehavior>,
        ) -> Self {
            self.inner = self.inner.set_number_selection_behavior(input);
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn geo_match_level(mut self, input: crate::model::GeoMatchLevel) -> Self {
            self.inner = self.inner.geo_match_level(input);
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn set_geo_match_level(
            mut self,
            input: std::option::Option<crate::model::GeoMatchLevel>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_level(input);
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn geo_match_params(mut self, input: crate::model::GeoMatchParams) -> Self {
            self.inner = self.inner.geo_match_params(input);
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn set_geo_match_params(
            mut self,
            input: std::option::Option<crate::model::GeoMatchParams>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_params(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoom`.
    ///
    /// <p>Creates a chat room for the specified Amazon Chime Enterprise account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_room_input::Builder,
    }
    impl<C, M, R> CreateRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoomInputOperationOutputAlias,
                crate::output::CreateRoomOutput,
                crate::error::CreateRoomError,
                crate::input::CreateRoomInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The room name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoomMembership`.
    ///
    /// <p>Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoomMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_room_membership_input::Builder,
    }
    impl<C, M, R> CreateRoomMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoomMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoomMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoomMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoomMembershipInputOperationOutputAlias,
                crate::output::CreateRoomMembershipOutput,
                crate::error::CreateRoomMembershipError,
                crate::input::CreateRoomMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The Amazon Chime member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The Amazon Chime member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The role of the member.</p>
        pub fn role(mut self, input: crate::model::RoomMembershipRole) -> Self {
            self.inner = self.inner.role(input);
            self
        }
        /// <p>The role of the member.</p>
        pub fn set_role(
            mut self,
            input: std::option::Option<crate::model::RoomMembershipRole>,
        ) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSipMediaApplication`.
    ///
    /// <p>Creates a SIP media application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSipMediaApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sip_media_application_input::Builder,
    }
    impl<C, M, R> CreateSipMediaApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSipMediaApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSipMediaApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSipMediaApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSipMediaApplicationInputOperationOutputAlias,
                crate::output::CreateSipMediaApplicationOutput,
                crate::error::CreateSipMediaApplicationError,
                crate::input::CreateSipMediaApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Region assigned to the SIP media application.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region assigned to the SIP media application.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The SIP media application name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The SIP media application name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
        pub fn endpoints(mut self, input: crate::model::SipMediaApplicationEndpoint) -> Self {
            self.inner = self.inner.endpoints(input);
            self
        }
        /// <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_endpoints(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSipMediaApplicationCall`.
    ///
    /// <p>Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified <code>sipMediaApplicationId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSipMediaApplicationCall<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sip_media_application_call_input::Builder,
    }
    impl<C, M, R> CreateSipMediaApplicationCall<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSipMediaApplicationCall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSipMediaApplicationCallOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSipMediaApplicationCallError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSipMediaApplicationCallInputOperationOutputAlias,
                crate::output::CreateSipMediaApplicationCallOutput,
                crate::error::CreateSipMediaApplicationCallError,
                crate::input::CreateSipMediaApplicationCallInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
        pub fn from_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_phone_number(input.into());
            self
        }
        /// <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
        pub fn set_from_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_phone_number(input);
            self
        }
        /// <p>The phone number that the service should call.</p>
        pub fn to_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.to_phone_number(input.into());
            self
        }
        /// <p>The phone number that the service should call.</p>
        pub fn set_to_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_to_phone_number(input);
            self
        }
        /// <p>The ID of the SIP media application.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(input.into());
            self
        }
        /// <p>The ID of the SIP media application.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// Adds a key-value pair to `SipHeaders`.
        ///
        /// To override the contents of this collection use [`set_sip_headers`](Self::set_sip_headers).
        ///
        /// <p>The SIP headers added to an outbound call leg.</p>
        pub fn sip_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.sip_headers(k.into(), v.into());
            self
        }
        /// <p>The SIP headers added to an outbound call leg.</p>
        pub fn set_sip_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_sip_headers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSipRule`.
    ///
    /// <p>Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSipRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sip_rule_input::Builder,
    }
    impl<C, M, R> CreateSipRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSipRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSipRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSipRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSipRuleInputOperationOutputAlias,
                crate::output::CreateSipRuleOutput,
                crate::error::CreateSipRuleError,
                crate::input::CreateSipRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SIP rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the SIP rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
        pub fn trigger_type(mut self, input: crate::model::SipRuleTriggerType) -> Self {
            self.inner = self.inner.trigger_type(input);
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::SipRuleTriggerType>,
        ) -> Self {
            self.inner = self.inner.set_trigger_type(input);
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>
        pub fn trigger_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trigger_value(input.into());
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>
        pub fn set_trigger_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trigger_value(input);
            self
        }
        /// <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.disabled(input);
            self
        }
        /// <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
        /// Appends an item to `TargetApplications`.
        ///
        /// To override the contents of this collection use [`set_target_applications`](Self::set_target_applications).
        ///
        /// <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
        pub fn target_applications(
            mut self,
            input: crate::model::SipRuleTargetApplication,
        ) -> Self {
            self.inner = self.inner.target_applications(input);
            self
        }
        /// <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
        pub fn set_target_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
        ) -> Self {
            self.inner = self.inner.set_target_applications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user under the specified Amazon Chime account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The user's email address.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The user's email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(input);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVoiceConnector`.
    ///
    /// <p>Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.</p>
    /// <p> Enabling <code>CreateVoiceConnectorRequest$RequireEncryption</code> configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_voice_connector_input::Builder,
    }
    impl<C, M, R> CreateVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVoiceConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVoiceConnectorInputOperationOutputAlias,
                crate::output::CreateVoiceConnectorOutput,
                crate::error::CreateVoiceConnectorError,
                crate::input::CreateVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The AWS Region in which the Amazon Chime Voice Connector is created. Default value: <code>us-east-1</code> . </p>
        pub fn aws_region(mut self, input: crate::model::VoiceConnectorAwsRegion) -> Self {
            self.inner = self.inner.aws_region(input);
            self
        }
        /// <p> The AWS Region in which the Amazon Chime Voice Connector is created. Default value: <code>us-east-1</code> . </p>
        pub fn set_aws_region(
            mut self,
            input: std::option::Option<crate::model::VoiceConnectorAwsRegion>,
        ) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn require_encryption(mut self, input: bool) -> Self {
            self.inner = self.inner.require_encryption(input);
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn set_require_encryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_encryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVoiceConnectorGroup`.
    ///
    /// <p>Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including <code>VoiceConnectorItems</code> in the request.</p>
    /// <p>You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_voice_connector_group_input::Builder,
    }
    impl<C, M, R> CreateVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVoiceConnectorGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::CreateVoiceConnectorGroupOutput,
                crate::error::CreateVoiceConnectorGroupError,
                crate::input::CreateVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `VoiceConnectorItems`.
        ///
        /// To override the contents of this collection use [`set_voice_connector_items`](Self::set_voice_connector_items).
        ///
        /// <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
        pub fn voice_connector_items(mut self, input: crate::model::VoiceConnectorItem) -> Self {
            self.inner = self.inner.voice_connector_items(input);
            self
        }
        /// <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
        pub fn set_voice_connector_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccount`.
    ///
    /// <p>Deletes the specified Amazon Chime account. You must suspend all users before deleting <code>Team</code> account. You can use the <code>BatchSuspendUser</code> action to dodo.</p>
    /// <p>For <code>EnterpriseLWA</code> and <code>EnterpriseAD</code> accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.</p>
    /// <p>Deleted accounts appear in your <code>Disabled</code> accounts list for 90 days. To restore deleted account from your <code>Disabled</code> accounts list, you must contact AWS Support.</p>
    /// <p>After 90 days, deleted accounts are permanently removed from your <code>Disabled</code> accounts list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_input::Builder,
    }
    impl<C, M, R> DeleteAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountInputOperationOutputAlias,
                crate::output::DeleteAccountOutput,
                crate::error::DeleteAccountError,
                crate::input::DeleteAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstance`.
    ///
    /// <p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_input::Builder,
    }
    impl<C, M, R> DeleteAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceInputOperationOutputAlias,
                crate::output::DeleteAppInstanceOutput,
                crate::error::DeleteAppInstanceError,
                crate::input::DeleteAppInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceAdmin`.
    ///
    /// <p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_admin_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceAdminInputOperationOutputAlias,
                crate::output::DeleteAppInstanceAdminOutput,
                crate::error::DeleteAppInstanceAdminError,
                crate::input::DeleteAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceStreamingConfigurations`.
    ///
    /// <p>Deletes the streaming configurations of an <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppInstanceStreamingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_streaming_configurations_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceStreamingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceStreamingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceStreamingConfigurationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteAppInstanceStreamingConfigurationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceStreamingConfigurationsInputOperationOutputAlias,
                crate::output::DeleteAppInstanceStreamingConfigurationsOutput,
                crate::error::DeleteAppInstanceStreamingConfigurationsError,
                crate::input::DeleteAppInstanceStreamingConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the streaming configurations being deleted.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the streaming configurations being deleted.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceUser`.
    ///
    /// <p>Deletes an <code>AppInstanceUser</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_user_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceUserInputOperationOutputAlias,
                crate::output::DeleteAppInstanceUserOutput,
                crate::error::DeleteAppInstanceUserError,
                crate::input::DeleteAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttendee`.
    ///
    /// <p>Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_attendee_input::Builder,
    }
    impl<C, M, R> DeleteAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAttendeeInputOperationOutputAlias,
                crate::output::DeleteAttendeeOutput,
                crate::error::DeleteAttendeeError,
                crate::input::DeleteAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelBan`.
    ///
    /// <p>Removes a user from a channel's ban list.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_ban_input::Builder,
    }
    impl<C, M, R> DeleteChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelBanInputOperationOutputAlias,
                crate::output::DeleteChannelBanOutput,
                crate::error::DeleteChannelBanError,
                crate::input::DeleteChannelBanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMembership`.
    ///
    /// <p>Removes a member from a channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_membership_input::Builder,
    }
    impl<C, M, R> DeleteChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelMembershipInputOperationOutputAlias,
                crate::output::DeleteChannelMembershipOutput,
                crate::error::DeleteChannelMembershipError,
                crate::input::DeleteChannelMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member that you're removing from the channel.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The ARN of the member that you're removing from the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMessage`.
    ///
    /// <p>Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by <code>UpdateChannelMessage</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_message_input::Builder,
    }
    impl<C, M, R> DeleteChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelMessageInputOperationOutputAlias,
                crate::output::DeleteChannelMessageOutput,
                crate::error::DeleteChannelMessageError,
                crate::input::DeleteChannelMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelModerator`.
    ///
    /// <p>Deletes a channel moderator.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_moderator_input::Builder,
    }
    impl<C, M, R> DeleteChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelModeratorInputOperationOutputAlias,
                crate::output::DeleteChannelModeratorOutput,
                crate::error::DeleteChannelModeratorError,
                crate::input::DeleteChannelModeratorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the moderator being deleted.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(input.into());
            self
        }
        /// <p>The ARN of the moderator being deleted.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventsConfiguration`.
    ///
    /// <p>Deletes the events configuration that allows a bot to receive outgoing events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventsConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_events_configuration_input::Builder,
    }
    impl<C, M, R> DeleteEventsConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventsConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventsConfigurationInputOperationOutputAlias,
                crate::output::DeleteEventsConfigurationOutput,
                crate::error::DeleteEventsConfigurationError,
                crate::input::DeleteEventsConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMediaCapturePipeline`.
    ///
    /// <p>Deletes the media capture pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMediaCapturePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_media_capture_pipeline_input::Builder,
    }
    impl<C, M, R> DeleteMediaCapturePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMediaCapturePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMediaCapturePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMediaCapturePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMediaCapturePipelineInputOperationOutputAlias,
                crate::output::DeleteMediaCapturePipelineOutput,
                crate::error::DeleteMediaCapturePipelineError,
                crate::input::DeleteMediaCapturePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the media capture pipeline being deleted. </p>
        pub fn media_pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_pipeline_id(input.into());
            self
        }
        /// <p>The ID of the media capture pipeline being deleted. </p>
        pub fn set_media_pipeline_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_pipeline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMeeting`.
    ///
    /// <p>Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_meeting_input::Builder,
    }
    impl<C, M, R> DeleteMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMeetingInputOperationOutputAlias,
                crate::output::DeleteMeetingOutput,
                crate::error::DeleteMeetingError,
                crate::input::DeleteMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePhoneNumber`.
    ///
    /// <p>Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.</p>
    /// <p>Deleted phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_phone_number_input::Builder,
    }
    impl<C, M, R> DeletePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePhoneNumberInputOperationOutputAlias,
                crate::output::DeletePhoneNumberOutput,
                crate::error::DeletePhoneNumberError,
                crate::input::DeletePhoneNumberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(input.into());
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProxySession`.
    ///
    /// <p>Deletes the specified proxy session from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProxySession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_proxy_session_input::Builder,
    }
    impl<C, M, R> DeleteProxySession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProxySession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProxySessionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProxySessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProxySessionInputOperationOutputAlias,
                crate::output::DeleteProxySessionOutput,
                crate::error::DeleteProxySessionError,
                crate::input::DeleteProxySessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proxy_session_id(input.into());
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proxy_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoom`.
    ///
    /// <p>Deletes a chat room in an Amazon Chime Enterprise account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_room_input::Builder,
    }
    impl<C, M, R> DeleteRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoomInputOperationOutputAlias,
                crate::output::DeleteRoomOutput,
                crate::error::DeleteRoomError,
                crate::input::DeleteRoomInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The chat room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(input.into());
            self
        }
        /// <p>The chat room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoomMembership`.
    ///
    /// <p>Removes a member from a chat room in an Amazon Chime Enterprise account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoomMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_room_membership_input::Builder,
    }
    impl<C, M, R> DeleteRoomMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoomMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoomMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoomMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoomMembershipInputOperationOutputAlias,
                crate::output::DeleteRoomMembershipOutput,
                crate::error::DeleteRoomMembershipError,
                crate::input::DeleteRoomMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSipMediaApplication`.
    ///
    /// <p>Deletes a SIP media application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSipMediaApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sip_media_application_input::Builder,
    }
    impl<C, M, R> DeleteSipMediaApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSipMediaApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSipMediaApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSipMediaApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSipMediaApplicationInputOperationOutputAlias,
                crate::output::DeleteSipMediaApplicationOutput,
                crate::error::DeleteSipMediaApplicationError,
                crate::input::DeleteSipMediaApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSipRule`.
    ///
    /// <p>Deletes a SIP rule. You must disable a SIP rule before you can delete it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSipRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sip_rule_input::Builder,
    }
    impl<C, M, R> DeleteSipRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSipRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSipRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSipRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSipRuleInputOperationOutputAlias,
                crate::output::DeleteSipRuleOutput,
                crate::error::DeleteSipRuleError,
                crate::input::DeleteSipRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_rule_id(input.into());
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sip_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnector`.
    ///
    /// <p>Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice Connector must be disassociated from it before it can be deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorOutput,
                crate::error::DeleteVoiceConnectorError,
                crate::input::DeleteVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorEmergencyCallingConfiguration`.
    ///
    /// <p>Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnectorEmergencyCallingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_emergency_calling_configuration_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorEmergencyCallingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorEmergencyCallingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DeleteVoiceConnectorEmergencyCallingConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorEmergencyCallingConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias,
                                    crate::output::DeleteVoiceConnectorEmergencyCallingConfigurationOutput,
                                    crate::error::DeleteVoiceConnectorEmergencyCallingConfigurationError,
                                    crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorGroup`.
    ///
    /// <p>Deletes the specified Amazon Chime Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers associated with the group must be removed before it can be deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_group_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorGroupOutput,
                crate::error::DeleteVoiceConnectorGroupError,
                crate::input::DeleteVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorOrigination`.
    ///
    /// <p>Deletes the origination settings for the specified Amazon Chime Voice Connector.</p> <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnectorOrigination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_origination_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorOrigination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorOrigination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorOriginationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorOriginationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorOriginationInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorOriginationOutput,
                crate::error::DeleteVoiceConnectorOriginationError,
                crate::input::DeleteVoiceConnectorOriginationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorProxy`.
    ///
    /// <p>Deletes the proxy configuration from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnectorProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_proxy_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorProxyInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorProxyOutput,
                crate::error::DeleteVoiceConnectorProxyError,
                crate::input::DeleteVoiceConnectorProxyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorStreamingConfiguration`.
    ///
    /// <p>Deletes the streaming configuration for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnectorStreamingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_streaming_configuration_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorStreamingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorStreamingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorStreamingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteVoiceConnectorStreamingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorStreamingConfigurationInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorStreamingConfigurationOutput,
                crate::error::DeleteVoiceConnectorStreamingConfigurationError,
                crate::input::DeleteVoiceConnectorStreamingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorTermination`.
    ///
    /// <p>Deletes the termination settings for the specified Amazon Chime Voice Connector.</p> <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnectorTermination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_termination_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorTermination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorTerminationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorTerminationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorTerminationInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorTerminationOutput,
                crate::error::DeleteVoiceConnectorTerminationError,
                crate::input::DeleteVoiceConnectorTerminationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorTerminationCredentials`.
    ///
    /// <p>Deletes the specified SIP credentials used by your equipment to authenticate during call termination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVoiceConnectorTerminationCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_termination_credentials_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorTerminationCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorTerminationCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorTerminationCredentialsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteVoiceConnectorTerminationCredentialsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorTerminationCredentialsInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorTerminationCredentialsOutput,
                crate::error::DeleteVoiceConnectorTerminationCredentialsError,
                crate::input::DeleteVoiceConnectorTerminationCredentialsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `Usernames`.
        ///
        /// To override the contents of this collection use [`set_usernames`](Self::set_usernames).
        ///
        /// <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
        pub fn usernames(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usernames(input.into());
            self
        }
        /// <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
        pub fn set_usernames(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usernames(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstance`.
    ///
    /// <p>Returns the full details of an <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_input::Builder,
    }
    impl<C, M, R> DescribeAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceInputOperationOutputAlias,
                crate::output::DescribeAppInstanceOutput,
                crate::error::DescribeAppInstanceError,
                crate::input::DescribeAppInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceAdmin`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_admin_input::Builder,
    }
    impl<C, M, R> DescribeAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceAdminInputOperationOutputAlias,
                crate::output::DescribeAppInstanceAdminOutput,
                crate::error::DescribeAppInstanceAdminError,
                crate::input::DescribeAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn app_instance_admin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceUser`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceUser</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeAppInstanceUserOutput,
                crate::error::DescribeAppInstanceUserError,
                crate::input::DescribeAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// <p>Returns the full details of a channel in an Amazon Chime <code>AppInstance</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl<C, M, R> DescribeChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelInputOperationOutputAlias,
                crate::output::DescribeChannelOutput,
                crate::error::DescribeChannelError,
                crate::input::DescribeChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelBan`.
    ///
    /// <p>Returns the full details of a channel ban.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_ban_input::Builder,
    }
    impl<C, M, R> DescribeChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelBanInputOperationOutputAlias,
                crate::output::DescribeChannelBanOutput,
                crate::error::DescribeChannelBanError,
                crate::input::DescribeChannelBanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembership`.
    ///
    /// <p>Returns the full details of a user's channel membership.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_membership_input::Builder,
    }
    impl<C, M, R> DescribeChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelMembershipInputOperationOutputAlias,
                crate::output::DescribeChannelMembershipOutput,
                crate::error::DescribeChannelMembershipError,
                crate::input::DescribeChannelMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(input.into());
            self
        }
        /// <p>The ARN of the member.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembershipForAppInstanceUser`.
    ///
    /// <p> Returns the details of a channel based on the membership of the specified <code>AppInstanceUser</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelMembershipForAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_membership_for_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeChannelMembershipForAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelMembershipForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelMembershipForAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelMembershipForAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
                crate::error::DescribeChannelMembershipForAppInstanceUserError,
                crate::input::DescribeChannelMembershipForAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModeratedByAppInstanceUser`.
    ///
    /// <p>Returns the full details of a channel moderated by the specified <code>AppInstanceUser</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelModeratedByAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_moderated_by_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeChannelModeratedByAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelModeratedByAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelModeratedByAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
                crate::error::DescribeChannelModeratedByAppInstanceUserError,
                crate::input::DescribeChannelModeratedByAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModerator`.
    ///
    /// <p>Returns the full details of a single ChannelModerator.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_moderator_input::Builder,
    }
    impl<C, M, R> DescribeChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelModeratorInputOperationOutputAlias,
                crate::output::DescribeChannelModeratorOutput,
                crate::error::DescribeChannelModeratorError,
                crate::input::DescribeChannelModeratorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the channel moderator.</p>
        pub fn channel_moderator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(input.into());
            self
        }
        /// <p>The ARN of the channel moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePhoneNumberFromUser`.
    ///
    /// <p>Disassociates the primary provisioned phone number from the specified Amazon Chime user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociatePhoneNumberFromUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_phone_number_from_user_input::Builder,
    }
    impl<C, M, R> DisassociatePhoneNumberFromUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociatePhoneNumberFromUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociatePhoneNumberFromUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociatePhoneNumberFromUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociatePhoneNumberFromUserInputOperationOutputAlias,
                crate::output::DisassociatePhoneNumberFromUserOutput,
                crate::error::DisassociatePhoneNumberFromUserError,
                crate::input::DisassociatePhoneNumberFromUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePhoneNumbersFromVoiceConnector`.
    ///
    /// <p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociatePhoneNumbersFromVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_phone_numbers_from_voice_connector_input::Builder,
    }
    impl<C, M, R> DisassociatePhoneNumbersFromVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociatePhoneNumbersFromVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociatePhoneNumbersFromVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociatePhoneNumbersFromVoiceConnectorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociatePhoneNumbersFromVoiceConnectorInputOperationOutputAlias,
                crate::output::DisassociatePhoneNumbersFromVoiceConnectorOutput,
                crate::error::DisassociatePhoneNumbersFromVoiceConnectorError,
                crate::input::DisassociatePhoneNumbersFromVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(input.into());
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePhoneNumbersFromVoiceConnectorGroup`.
    ///
    /// <p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociatePhoneNumbersFromVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_phone_numbers_from_voice_connector_group_input::Builder,
    }
    impl<C, M, R> DisassociatePhoneNumbersFromVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociatePhoneNumbersFromVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, aws_smithy_http::result::SdkError<crate::error::DisassociatePhoneNumbersFromVoiceConnectorGroupError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInputOperationOutputAlias,
                                    crate::output::DisassociatePhoneNumbersFromVoiceConnectorGroupOutput,
                                    crate::error::DisassociatePhoneNumbersFromVoiceConnectorGroupError,
                                    crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(input.into());
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSigninDelegateGroupsFromAccount`.
    ///
    /// <p>Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateSigninDelegateGroupsFromAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_signin_delegate_groups_from_account_input::Builder,
    }
    impl<C, M, R> DisassociateSigninDelegateGroupsFromAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSigninDelegateGroupsFromAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSigninDelegateGroupsFromAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateSigninDelegateGroupsFromAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSigninDelegateGroupsFromAccountInputOperationOutputAlias,
                crate::output::DisassociateSigninDelegateGroupsFromAccountOutput,
                crate::error::DisassociateSigninDelegateGroupsFromAccountError,
                crate::input::DisassociateSigninDelegateGroupsFromAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `GroupNames`.
        ///
        /// To override the contents of this collection use [`set_group_names`](Self::set_group_names).
        ///
        /// <p>The sign-in delegate group names.</p>
        pub fn group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_names(input.into());
            self
        }
        /// <p>The sign-in delegate group names.</p>
        pub fn set_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccount`.
    ///
    /// <p>Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_input::Builder,
    }
    impl<C, M, R> GetAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountInputOperationOutputAlias,
                crate::output::GetAccountOutput,
                crate::error::GetAccountError,
                crate::input::GetAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSettings`.
    ///
    /// <p>Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_settings_input::Builder,
    }
    impl<C, M, R> GetAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountSettingsInputOperationOutputAlias,
                crate::output::GetAccountSettingsOutput,
                crate::error::GetAccountSettingsError,
                crate::input::GetAccountSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppInstanceRetentionSettings`.
    ///
    /// <p>Gets the retention settings for an <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAppInstanceRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_instance_retention_settings_input::Builder,
    }
    impl<C, M, R> GetAppInstanceRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppInstanceRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInstanceRetentionSettingsInputOperationOutputAlias,
                crate::output::GetAppInstanceRetentionSettingsOutput,
                crate::error::GetAppInstanceRetentionSettingsError,
                crate::input::GetAppInstanceRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppInstanceStreamingConfigurations`.
    ///
    /// <p>Gets the streaming settings for an <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAppInstanceStreamingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_instance_streaming_configurations_input::Builder,
    }
    impl<C, M, R> GetAppInstanceStreamingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppInstanceStreamingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppInstanceStreamingConfigurationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAppInstanceStreamingConfigurationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInstanceStreamingConfigurationsInputOperationOutputAlias,
                crate::output::GetAppInstanceStreamingConfigurationsOutput,
                crate::error::GetAppInstanceStreamingConfigurationsError,
                crate::input::GetAppInstanceStreamingConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAttendee`.
    ///
    /// <p> Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_attendee_input::Builder,
    }
    impl<C, M, R> GetAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAttendeeInputOperationOutputAlias,
                crate::output::GetAttendeeOutput,
                crate::error::GetAttendeeError,
                crate::input::GetAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBot`.
    ///
    /// <p>Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_input::Builder,
    }
    impl<C, M, R> GetBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotInputOperationOutputAlias,
                crate::output::GetBotOutput,
                crate::error::GetBotError,
                crate::input::GetBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMessage`.
    ///
    /// <p>Gets the full details of a channel message.</p> <note>
    /// <p>The x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channel_message_input::Builder,
    }
    impl<C, M, R> GetChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelMessageInputOperationOutputAlias,
                crate::output::GetChannelMessageOutput,
                crate::error::GetChannelMessageError,
                crate::input::GetChannelMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventsConfiguration`.
    ///
    /// <p>Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventsConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_events_configuration_input::Builder,
    }
    impl<C, M, R> GetEventsConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventsConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventsConfigurationInputOperationOutputAlias,
                crate::output::GetEventsConfigurationOutput,
                crate::error::GetEventsConfigurationError,
                crate::input::GetEventsConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGlobalSettings`.
    ///
    /// <p>Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGlobalSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_global_settings_input::Builder,
    }
    impl<C, M, R> GetGlobalSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGlobalSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGlobalSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGlobalSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGlobalSettingsInputOperationOutputAlias,
                crate::output::GetGlobalSettingsOutput,
                crate::error::GetGlobalSettingsError,
                crate::input::GetGlobalSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMediaCapturePipeline`.
    ///
    /// <p>Gets an existing media capture pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMediaCapturePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_media_capture_pipeline_input::Builder,
    }
    impl<C, M, R> GetMediaCapturePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMediaCapturePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMediaCapturePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMediaCapturePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMediaCapturePipelineInputOperationOutputAlias,
                crate::output::GetMediaCapturePipelineOutput,
                crate::error::GetMediaCapturePipelineError,
                crate::input::GetMediaCapturePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline that you want to get.</p>
        pub fn media_pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline that you want to get.</p>
        pub fn set_media_pipeline_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_pipeline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMeeting`.
    ///
    /// <p> Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_meeting_input::Builder,
    }
    impl<C, M, R> GetMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMeetingInputOperationOutputAlias,
                crate::output::GetMeetingOutput,
                crate::error::GetMeetingError,
                crate::input::GetMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMessagingSessionEndpoint`.
    ///
    /// <p>The details of the endpoint for the messaging session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMessagingSessionEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_messaging_session_endpoint_input::Builder,
    }
    impl<C, M, R> GetMessagingSessionEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMessagingSessionEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMessagingSessionEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMessagingSessionEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMessagingSessionEndpointInputOperationOutputAlias,
                crate::output::GetMessagingSessionEndpointOutput,
                crate::error::GetMessagingSessionEndpointError,
                crate::input::GetMessagingSessionEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPhoneNumber`.
    ///
    /// <p>Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_phone_number_input::Builder,
    }
    impl<C, M, R> GetPhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPhoneNumberInputOperationOutputAlias,
                crate::output::GetPhoneNumberOutput,
                crate::error::GetPhoneNumberError,
                crate::input::GetPhoneNumberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(input.into());
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPhoneNumberOrder`.
    ///
    /// <p>Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPhoneNumberOrder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_phone_number_order_input::Builder,
    }
    impl<C, M, R> GetPhoneNumberOrder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPhoneNumberOrder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPhoneNumberOrderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPhoneNumberOrderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPhoneNumberOrderInputOperationOutputAlias,
                crate::output::GetPhoneNumberOrderOutput,
                crate::error::GetPhoneNumberOrderError,
                crate::input::GetPhoneNumberOrderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the phone number order.</p>
        pub fn phone_number_order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_order_id(input.into());
            self
        }
        /// <p>The ID for the phone number order.</p>
        pub fn set_phone_number_order_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_order_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPhoneNumberSettings`.
    ///
    /// <p>Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPhoneNumberSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_phone_number_settings_input::Builder,
    }
    impl<C, M, R> GetPhoneNumberSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPhoneNumberSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPhoneNumberSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPhoneNumberSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPhoneNumberSettingsInputOperationOutputAlias,
                crate::output::GetPhoneNumberSettingsOutput,
                crate::error::GetPhoneNumberSettingsError,
                crate::input::GetPhoneNumberSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetProxySession`.
    ///
    /// <p>Gets the specified proxy session details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProxySession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_proxy_session_input::Builder,
    }
    impl<C, M, R> GetProxySession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProxySession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProxySessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProxySessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProxySessionInputOperationOutputAlias,
                crate::output::GetProxySessionOutput,
                crate::error::GetProxySessionError,
                crate::input::GetProxySessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proxy_session_id(input.into());
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proxy_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRetentionSettings`.
    ///
    /// <p> Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_retention_settings_input::Builder,
    }
    impl<C, M, R> GetRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRetentionSettingsInputOperationOutputAlias,
                crate::output::GetRetentionSettingsOutput,
                crate::error::GetRetentionSettingsError,
                crate::input::GetRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoom`.
    ///
    /// <p>Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_room_input::Builder,
    }
    impl<C, M, R> GetRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRoomInputOperationOutputAlias,
                crate::output::GetRoomOutput,
                crate::error::GetRoomError,
                crate::input::GetRoomInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSipMediaApplication`.
    ///
    /// <p>Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSipMediaApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sip_media_application_input::Builder,
    }
    impl<C, M, R> GetSipMediaApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSipMediaApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSipMediaApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSipMediaApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSipMediaApplicationInputOperationOutputAlias,
                crate::output::GetSipMediaApplicationOutput,
                crate::error::GetSipMediaApplicationError,
                crate::input::GetSipMediaApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSipMediaApplicationLoggingConfiguration`.
    ///
    /// <p>Returns the logging configuration for the specified SIP media application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSipMediaApplicationLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sip_media_application_logging_configuration_input::Builder,
    }
    impl<C, M, R> GetSipMediaApplicationLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSipMediaApplicationLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSipMediaApplicationLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetSipMediaApplicationLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSipMediaApplicationLoggingConfigurationInputOperationOutputAlias,
                crate::output::GetSipMediaApplicationLoggingConfigurationOutput,
                crate::error::GetSipMediaApplicationLoggingConfigurationError,
                crate::input::GetSipMediaApplicationLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSipRule`.
    ///
    /// <p>Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSipRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sip_rule_input::Builder,
    }
    impl<C, M, R> GetSipRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSipRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSipRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSipRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSipRuleInputOperationOutputAlias,
                crate::output::GetSipRuleOutput,
                crate::error::GetSipRuleError,
                crate::input::GetSipRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_rule_id(input.into());
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sip_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUser`.
    ///
    /// <p>Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.</p>
    /// <p> To retrieve user details with an email address instead of a user ID, use the <code>ListUsers</code> action, and then filter by email address. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_input::Builder,
    }
    impl<C, M, R> GetUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserInputOperationOutputAlias,
                crate::output::GetUserOutput,
                crate::error::GetUserError,
                crate::input::GetUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserSettings`.
    ///
    /// <p>Retrieves settings for the specified user ID, such as any associated phone number settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_settings_input::Builder,
    }
    impl<C, M, R> GetUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserSettingsInputOperationOutputAlias,
                crate::output::GetUserSettingsOutput,
                crate::error::GetUserSettingsError,
                crate::input::GetUserSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnector`.
    ///
    /// <p>Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_input::Builder,
    }
    impl<C, M, R> GetVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorInputOperationOutputAlias,
                crate::output::GetVoiceConnectorOutput,
                crate::error::GetVoiceConnectorError,
                crate::input::GetVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorEmergencyCallingConfiguration`.
    ///
    /// <p>Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorEmergencyCallingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_emergency_calling_configuration_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorEmergencyCallingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorEmergencyCallingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::GetVoiceConnectorEmergencyCallingConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorEmergencyCallingConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::GetVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias,
                                    crate::output::GetVoiceConnectorEmergencyCallingConfigurationOutput,
                                    crate::error::GetVoiceConnectorEmergencyCallingConfigurationError,
                                    crate::input::GetVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorGroup`.
    ///
    /// <p> Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated <code>VoiceConnectorItems</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_group_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::GetVoiceConnectorGroupOutput,
                crate::error::GetVoiceConnectorGroupError,
                crate::input::GetVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorLoggingConfiguration`.
    ///
    /// <p>Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_logging_configuration_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetVoiceConnectorLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorLoggingConfigurationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorLoggingConfigurationOutput,
                crate::error::GetVoiceConnectorLoggingConfigurationError,
                crate::input::GetVoiceConnectorLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorOrigination`.
    ///
    /// <p>Retrieves origination setting details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorOrigination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_origination_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorOrigination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorOrigination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorOriginationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorOriginationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorOriginationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorOriginationOutput,
                crate::error::GetVoiceConnectorOriginationError,
                crate::input::GetVoiceConnectorOriginationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorProxy`.
    ///
    /// <p>Gets the proxy configuration details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_proxy_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorProxyInputOperationOutputAlias,
                crate::output::GetVoiceConnectorProxyOutput,
                crate::error::GetVoiceConnectorProxyError,
                crate::input::GetVoiceConnectorProxyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorStreamingConfiguration`.
    ///
    /// <p>Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorStreamingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_streaming_configuration_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorStreamingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorStreamingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorStreamingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetVoiceConnectorStreamingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorStreamingConfigurationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorStreamingConfigurationOutput,
                crate::error::GetVoiceConnectorStreamingConfigurationError,
                crate::input::GetVoiceConnectorStreamingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorTermination`.
    ///
    /// <p>Retrieves termination setting details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorTermination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_termination_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorTermination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorTerminationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorTerminationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorTerminationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorTerminationOutput,
                crate::error::GetVoiceConnectorTerminationError,
                crate::input::GetVoiceConnectorTerminationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorTerminationHealth`.
    ///
    /// <p>Retrieves information about the last time a SIP <code>OPTIONS</code> ping was received from your SIP infrastructure for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVoiceConnectorTerminationHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_termination_health_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorTerminationHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorTerminationHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorTerminationHealthOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetVoiceConnectorTerminationHealthError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorTerminationHealthInputOperationOutputAlias,
                crate::output::GetVoiceConnectorTerminationHealthOutput,
                crate::error::GetVoiceConnectorTerminationHealthError,
                crate::input::GetVoiceConnectorTerminationHealthInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InviteUsers`.
    ///
    /// <p>Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime <code>Team</code> account. Only <code>Team</code> account types are currently supported for this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InviteUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invite_users_input::Builder,
    }
    impl<C, M, R> InviteUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InviteUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InviteUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::InviteUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InviteUsersInputOperationOutputAlias,
                crate::output::InviteUsersOutput,
                crate::error::InviteUsersError,
                crate::input::InviteUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UserEmailList`.
        ///
        /// To override the contents of this collection use [`set_user_email_list`](Self::set_user_email_list).
        ///
        /// <p>The user email addresses to which to send the email invitation.</p>
        pub fn user_email_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_email_list(input.into());
            self
        }
        /// <p>The user email addresses to which to send the email invitation.</p>
        pub fn set_user_email_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_email_list(input);
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(input);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccounts`.
    ///
    /// <p>Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_accounts_input::Builder,
    }
    impl<C, M, R> ListAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountsInputOperationOutputAlias,
                crate::output::ListAccountsOutput,
                crate::error::ListAccountsError,
                crate::input::ListAccountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountsPaginator<C, M, R> {
            crate::paginator::ListAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>Amazon Chime account name prefix with which to filter results.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Amazon Chime account name prefix with which to filter results.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>User email address with which to filter results.</p>
        pub fn user_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_email(input.into());
            self
        }
        /// <p>User email address with which to filter results.</p>
        pub fn set_user_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_email(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceAdmins`.
    ///
    /// <p>Returns a list of the administrators in the <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppInstanceAdmins<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instance_admins_input::Builder,
    }
    impl<C, M, R> ListAppInstanceAdmins<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstanceAdmins`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceAdminsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceAdminsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstanceAdminsInputOperationOutputAlias,
                crate::output::ListAppInstanceAdminsOutput,
                crate::error::ListAppInstanceAdminsError,
                crate::input::ListAppInstanceAdminsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppInstanceAdminsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppInstanceAdminsPaginator<C, M, R> {
            crate::paginator::ListAppInstanceAdminsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstances`.
    ///
    /// <p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instances_input::Builder,
    }
    impl<C, M, R> ListAppInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstancesInputOperationOutputAlias,
                crate::output::ListAppInstancesOutput,
                crate::error::ListAppInstancesError,
                crate::input::ListAppInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppInstancesPaginator<C, M, R> {
            crate::paginator::ListAppInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceUsers`.
    ///
    /// <p>List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppInstanceUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instance_users_input::Builder,
    }
    impl<C, M, R> ListAppInstanceUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstanceUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstanceUsersInputOperationOutputAlias,
                crate::output::ListAppInstanceUsersOutput,
                crate::error::ListAppInstanceUsersError,
                crate::input::ListAppInstanceUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppInstanceUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppInstanceUsersPaginator<C, M, R> {
            crate::paginator::ListAppInstanceUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttendees`.
    ///
    /// <p> Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttendees<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attendees_input::Builder,
    }
    impl<C, M, R> ListAttendees<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttendeesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttendeesInputOperationOutputAlias,
                crate::output::ListAttendeesOutput,
                crate::error::ListAttendeesError,
                crate::input::ListAttendeesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttendeesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttendeesPaginator<C, M, R> {
            crate::paginator::ListAttendeesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttendeeTags`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK attendee resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttendeeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attendee_tags_input::Builder,
    }
    impl<C, M, R> ListAttendeeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttendeeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttendeeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttendeeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttendeeTagsInputOperationOutputAlias,
                crate::output::ListAttendeeTagsOutput,
                crate::error::ListAttendeeTagsError,
                crate::input::ListAttendeeTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBots`.
    ///
    /// <p>Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bots_input::Builder,
    }
    impl<C, M, R> ListBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotsInputOperationOutputAlias,
                crate::output::ListBotsOutput,
                crate::error::ListBotsError,
                crate::input::ListBotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBotsPaginator<C, M, R> {
            crate::paginator::ListBotsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelBans`.
    ///
    /// <p>Lists all the users banned from a particular channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelBans<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_bans_input::Builder,
    }
    impl<C, M, R> ListChannelBans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelBans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelBansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelBansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelBansInputOperationOutputAlias,
                crate::output::ListChannelBansOutput,
                crate::error::ListChannelBansError,
                crate::input::ListChannelBansInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelBansPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelBansPaginator<C, M, R> {
            crate::paginator::ListChannelBansPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMemberships`.
    ///
    /// <p>Lists all channel memberships in a channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_memberships_input::Builder,
    }
    impl<C, M, R> ListChannelMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMembershipsInputOperationOutputAlias,
                crate::output::ListChannelMembershipsOutput,
                crate::error::ListChannelMembershipsError,
                crate::input::ListChannelMembershipsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelMembershipsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelMembershipsPaginator<C, M, R> {
            crate::paginator::ListChannelMembershipsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMembershipsForAppInstanceUser`.
    ///
    /// <p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelMembershipsForAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_memberships_for_app_instance_user_input::Builder,
    }
    impl<C, M, R> ListChannelMembershipsForAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMembershipsForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelMembershipsForAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMembershipsForAppInstanceUserInputOperationOutputAlias,
                crate::output::ListChannelMembershipsForAppInstanceUserOutput,
                crate::error::ListChannelMembershipsForAppInstanceUserError,
                crate::input::ListChannelMembershipsForAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelMembershipsForAppInstanceUserPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListChannelMembershipsForAppInstanceUserPaginator<C, M, R> {
            crate::paginator::ListChannelMembershipsForAppInstanceUserPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMessages`.
    ///
    /// <p>List all the messages in a channel. Returns a paginated list of <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending order.</p> <note>
    /// <p>Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.</p>
    /// <p>Also, the x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_messages_input::Builder,
    }
    impl<C, M, R> ListChannelMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMessagesInputOperationOutputAlias,
                crate::output::ListChannelMessagesOutput,
                crate::error::ListChannelMessagesError,
                crate::input::ListChannelMessagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelMessagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelMessagesPaginator<C, M, R> {
            crate::paginator::ListChannelMessagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time created.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn not_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.not_before(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_not_before(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn not_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.not_after(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_not_after(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelModerators`.
    ///
    /// <p>Lists all the moderators for a channel.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelModerators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_moderators_input::Builder,
    }
    impl<C, M, R> ListChannelModerators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelModerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelModeratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelModeratorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelModeratorsInputOperationOutputAlias,
                crate::output::ListChannelModeratorsOutput,
                crate::error::ListChannelModeratorsError,
                crate::input::ListChannelModeratorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelModeratorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelModeratorsPaginator<C, M, R> {
            crate::paginator::ListChannelModeratorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.</p>
    /// <p class="title"> <b>Functionality &amp; restrictions</b> </p>
    /// <ul>
    /// <li> <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the account.</p> </li>
    /// <li> <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to list the private channels in an account.</p> </li>
    /// </ul> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelsPaginator<C, M, R> {
            crate::paginator::ListChannelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(input);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelsModeratedByAppInstanceUser`.
    ///
    /// <p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannelsModeratedByAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_moderated_by_app_instance_user_input::Builder,
    }
    impl<C, M, R> ListChannelsModeratedByAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelsModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelsModeratedByAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsModeratedByAppInstanceUserInputOperationOutputAlias,
                crate::output::ListChannelsModeratedByAppInstanceUserOutput,
                crate::error::ListChannelsModeratedByAppInstanceUserError,
                crate::input::ListChannelsModeratedByAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsModeratedByAppInstanceUserPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListChannelsModeratedByAppInstanceUserPaginator<C, M, R> {
            crate::paginator::ListChannelsModeratedByAppInstanceUserPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(input.into());
            self
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMediaCapturePipelines`.
    ///
    /// <p>Returns a list of media capture pipelines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMediaCapturePipelines<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_media_capture_pipelines_input::Builder,
    }
    impl<C, M, R> ListMediaCapturePipelines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMediaCapturePipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMediaCapturePipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMediaCapturePipelinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMediaCapturePipelinesInputOperationOutputAlias,
                crate::output::ListMediaCapturePipelinesOutput,
                crate::error::ListMediaCapturePipelinesError,
                crate::input::ListMediaCapturePipelinesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMediaCapturePipelinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListMediaCapturePipelinesPaginator<C, M, R> {
            crate::paginator::ListMediaCapturePipelinesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMeetings`.
    ///
    /// <p> Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMeetings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_meetings_input::Builder,
    }
    impl<C, M, R> ListMeetings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMeetings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMeetingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMeetingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMeetingsInputOperationOutputAlias,
                crate::output::ListMeetingsOutput,
                crate::error::ListMeetingsError,
                crate::input::ListMeetingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMeetingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMeetingsPaginator<C, M, R> {
            crate::paginator::ListMeetingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMeetingTags`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMeetingTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_meeting_tags_input::Builder,
    }
    impl<C, M, R> ListMeetingTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMeetingTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMeetingTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMeetingTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMeetingTagsInputOperationOutputAlias,
                crate::output::ListMeetingTagsOutput,
                crate::error::ListMeetingTagsError,
                crate::input::ListMeetingTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPhoneNumberOrders`.
    ///
    /// <p>Lists the phone number orders for the administrator's Amazon Chime account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPhoneNumberOrders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_phone_number_orders_input::Builder,
    }
    impl<C, M, R> ListPhoneNumberOrders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPhoneNumberOrders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPhoneNumberOrdersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPhoneNumberOrdersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPhoneNumberOrdersInputOperationOutputAlias,
                crate::output::ListPhoneNumberOrdersOutput,
                crate::error::ListPhoneNumberOrdersError,
                crate::input::ListPhoneNumberOrdersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPhoneNumberOrdersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPhoneNumberOrdersPaginator<C, M, R> {
            crate::paginator::ListPhoneNumberOrdersPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPhoneNumbers`.
    ///
    /// <p>Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPhoneNumbers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_phone_numbers_input::Builder,
    }
    impl<C, M, R> ListPhoneNumbers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPhoneNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPhoneNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPhoneNumbersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPhoneNumbersInputOperationOutputAlias,
                crate::output::ListPhoneNumbersOutput,
                crate::error::ListPhoneNumbersError,
                crate::input::ListPhoneNumbersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPhoneNumbersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPhoneNumbersPaginator<C, M, R> {
            crate::paginator::ListPhoneNumbersPaginator::new(self.handle, self.inner)
        }
        /// <p>The phone number status.</p>
        pub fn status(mut self, input: crate::model::PhoneNumberStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The phone number status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, input: crate::model::PhoneNumberProductType) -> Self {
            self.inner = self.inner.product_type(input);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// <p>The filter to use to limit the number of results.</p>
        pub fn filter_name(mut self, input: crate::model::PhoneNumberAssociationName) -> Self {
            self.inner = self.inner.filter_name(input);
            self
        }
        /// <p>The filter to use to limit the number of results.</p>
        pub fn set_filter_name(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberAssociationName>,
        ) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
        /// <p>The value to use for the filter.</p>
        pub fn filter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_value(input.into());
            self
        }
        /// <p>The value to use for the filter.</p>
        pub fn set_filter_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_value(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProxySessions`.
    ///
    /// <p>Lists the proxy sessions for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProxySessions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_proxy_sessions_input::Builder,
    }
    impl<C, M, R> ListProxySessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProxySessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProxySessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProxySessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProxySessionsInputOperationOutputAlias,
                crate::output::ListProxySessionsOutput,
                crate::error::ListProxySessionsError,
                crate::input::ListProxySessionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProxySessionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProxySessionsPaginator<C, M, R> {
            crate::paginator::ListProxySessionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The proxy session status.</p>
        pub fn status(mut self, input: crate::model::ProxySessionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The proxy session status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProxySessionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoomMemberships`.
    ///
    /// <p>Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRoomMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_room_memberships_input::Builder,
    }
    impl<C, M, R> ListRoomMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoomMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoomMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoomMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoomMembershipsInputOperationOutputAlias,
                crate::output::ListRoomMembershipsOutput,
                crate::error::ListRoomMembershipsError,
                crate::input::ListRoomMembershipsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoomMembershipsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRoomMembershipsPaginator<C, M, R> {
            crate::paginator::ListRoomMembershipsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRooms`.
    ///
    /// <p>Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRooms<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rooms_input::Builder,
    }
    impl<C, M, R> ListRooms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRooms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoomsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoomsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoomsInputOperationOutputAlias,
                crate::output::ListRoomsOutput,
                crate::error::ListRoomsError,
                crate::input::ListRoomsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoomsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRoomsPaginator<C, M, R> {
            crate::paginator::ListRoomsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSipMediaApplications`.
    ///
    /// <p>Lists the SIP media applications under the administrator's AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSipMediaApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_sip_media_applications_input::Builder,
    }
    impl<C, M, R> ListSipMediaApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSipMediaApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSipMediaApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSipMediaApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSipMediaApplicationsInputOperationOutputAlias,
                crate::output::ListSipMediaApplicationsOutput,
                crate::error::ListSipMediaApplicationsError,
                crate::input::ListSipMediaApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSipMediaApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListSipMediaApplicationsPaginator<C, M, R> {
            crate::paginator::ListSipMediaApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSipRules`.
    ///
    /// <p>Lists the SIP rules under the administrator's AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSipRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_sip_rules_input::Builder,
    }
    impl<C, M, R> ListSipRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSipRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSipRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSipRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSipRulesInputOperationOutputAlias,
                crate::output::ListSipRulesOutput,
                crate::error::ListSipRulesError,
                crate::input::ListSipRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSipRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSipRulesPaginator<C, M, R> {
            crate::paginator::ListSipRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSupportedPhoneNumberCountries`.
    ///
    /// <p>Lists supported phone number countries.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSupportedPhoneNumberCountries<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_supported_phone_number_countries_input::Builder,
    }
    impl<C, M, R> ListSupportedPhoneNumberCountries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSupportedPhoneNumberCountries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSupportedPhoneNumberCountriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSupportedPhoneNumberCountriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSupportedPhoneNumberCountriesInputOperationOutputAlias,
                crate::output::ListSupportedPhoneNumberCountriesOutput,
                crate::error::ListSupportedPhoneNumberCountriesError,
                crate::input::ListSupportedPhoneNumberCountriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, input: crate::model::PhoneNumberProductType) -> Self {
            self.inner = self.inner.product_type(input);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsersPaginator<C, M, R> {
            crate::paginator::ListUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Optional. The user email address used to filter results. Maximum 1.</p>
        pub fn user_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_email(input.into());
            self
        }
        /// <p>Optional. The user email address used to filter results. Maximum 1.</p>
        pub fn set_user_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_email(input);
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(input);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVoiceConnectorGroups`.
    ///
    /// <p>Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVoiceConnectorGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_voice_connector_groups_input::Builder,
    }
    impl<C, M, R> ListVoiceConnectorGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVoiceConnectorGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVoiceConnectorGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVoiceConnectorGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVoiceConnectorGroupsInputOperationOutputAlias,
                crate::output::ListVoiceConnectorGroupsOutput,
                crate::error::ListVoiceConnectorGroupsError,
                crate::input::ListVoiceConnectorGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVoiceConnectorGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListVoiceConnectorGroupsPaginator<C, M, R> {
            crate::paginator::ListVoiceConnectorGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVoiceConnectors`.
    ///
    /// <p>Lists the Amazon Chime Voice Connectors for the administrator's AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVoiceConnectors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_voice_connectors_input::Builder,
    }
    impl<C, M, R> ListVoiceConnectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVoiceConnectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVoiceConnectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVoiceConnectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVoiceConnectorsInputOperationOutputAlias,
                crate::output::ListVoiceConnectorsOutput,
                crate::error::ListVoiceConnectorsError,
                crate::input::ListVoiceConnectorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVoiceConnectorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVoiceConnectorsPaginator<C, M, R> {
            crate::paginator::ListVoiceConnectorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVoiceConnectorTerminationCredentials`.
    ///
    /// <p>Lists the SIP credentials for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVoiceConnectorTerminationCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_voice_connector_termination_credentials_input::Builder,
    }
    impl<C, M, R> ListVoiceConnectorTerminationCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVoiceConnectorTerminationCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVoiceConnectorTerminationCredentialsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListVoiceConnectorTerminationCredentialsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVoiceConnectorTerminationCredentialsInputOperationOutputAlias,
                crate::output::ListVoiceConnectorTerminationCredentialsOutput,
                crate::error::ListVoiceConnectorTerminationCredentialsError,
                crate::input::ListVoiceConnectorTerminationCredentialsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LogoutUser`.
    ///
    /// <p>Logs out the specified user from all of the devices they are currently logged into.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct LogoutUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::logout_user_input::Builder,
    }
    impl<C, M, R> LogoutUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LogoutUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LogoutUserOutput,
            aws_smithy_http::result::SdkError<crate::error::LogoutUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LogoutUserInputOperationOutputAlias,
                crate::output::LogoutUserOutput,
                crate::error::LogoutUserError,
                crate::input::LogoutUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppInstanceRetentionSettings`.
    ///
    /// <p>Sets the amount of time in days that a given <code>AppInstance</code> retains data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAppInstanceRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_instance_retention_settings_input::Builder,
    }
    impl<C, M, R> PutAppInstanceRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppInstanceRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppInstanceRetentionSettingsInputOperationOutputAlias,
                crate::output::PutAppInstanceRetentionSettingsOutput,
                crate::error::PutAppInstanceRetentionSettingsError,
                crate::input::PutAppInstanceRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn app_instance_retention_settings(
            mut self,
            input: crate::model::AppInstanceRetentionSettings,
        ) -> Self {
            self.inner = self.inner.app_instance_retention_settings(input);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn set_app_instance_retention_settings(
            mut self,
            input: std::option::Option<crate::model::AppInstanceRetentionSettings>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_retention_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppInstanceStreamingConfigurations`.
    ///
    /// <p>The data streaming configurations of an <code>AppInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAppInstanceStreamingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_instance_streaming_configurations_input::Builder,
    }
    impl<C, M, R> PutAppInstanceStreamingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppInstanceStreamingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppInstanceStreamingConfigurationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAppInstanceStreamingConfigurationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppInstanceStreamingConfigurationsInputOperationOutputAlias,
                crate::output::PutAppInstanceStreamingConfigurationsOutput,
                crate::error::PutAppInstanceStreamingConfigurationsError,
                crate::input::PutAppInstanceStreamingConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// Appends an item to `AppInstanceStreamingConfigurations`.
        ///
        /// To override the contents of this collection use [`set_app_instance_streaming_configurations`](Self::set_app_instance_streaming_configurations).
        ///
        /// <p>The streaming configurations set for an <code>AppInstance</code>.</p>
        pub fn app_instance_streaming_configurations(
            mut self,
            input: crate::model::AppInstanceStreamingConfiguration,
        ) -> Self {
            self.inner = self.inner.app_instance_streaming_configurations(input);
            self
        }
        /// <p>The streaming configurations set for an <code>AppInstance</code>.</p>
        pub fn set_app_instance_streaming_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AppInstanceStreamingConfiguration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_app_instance_streaming_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEventsConfiguration`.
    ///
    /// <p>Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see <code>Bot</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEventsConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_events_configuration_input::Builder,
    }
    impl<C, M, R> PutEventsConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEventsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventsConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventsConfigurationInputOperationOutputAlias,
                crate::output::PutEventsConfigurationOutput,
                crate::error::PutEventsConfigurationError,
                crate::input::PutEventsConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>HTTPS endpoint that allows the bot to receive outgoing events.</p>
        pub fn outbound_events_https_endpoint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.outbound_events_https_endpoint(input.into());
            self
        }
        /// <p>HTTPS endpoint that allows the bot to receive outgoing events.</p>
        pub fn set_outbound_events_https_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_outbound_events_https_endpoint(input);
            self
        }
        /// <p>Lambda function ARN that allows the bot to receive outgoing events.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lambda_function_arn(input.into());
            self
        }
        /// <p>Lambda function ARN that allows the bot to receive outgoing events.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lambda_function_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRetentionSettings`.
    ///
    /// <p> Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see <a href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS CloudTrail</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    /// <p> To turn off existing retention settings, remove the number of days from the corresponding <b>RetentionDays</b> field in the <b>RetentionSettings</b> object. For more information about retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_retention_settings_input::Builder,
    }
    impl<C, M, R> PutRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRetentionSettingsInputOperationOutputAlias,
                crate::output::PutRetentionSettingsOutput,
                crate::error::PutRetentionSettingsError,
                crate::input::PutRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The retention settings.</p>
        pub fn retention_settings(mut self, input: crate::model::RetentionSettings) -> Self {
            self.inner = self.inner.retention_settings(input);
            self
        }
        /// <p>The retention settings.</p>
        pub fn set_retention_settings(
            mut self,
            input: std::option::Option<crate::model::RetentionSettings>,
        ) -> Self {
            self.inner = self.inner.set_retention_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSipMediaApplicationLoggingConfiguration`.
    ///
    /// <p>Updates the logging configuration for the specified SIP media application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSipMediaApplicationLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_sip_media_application_logging_configuration_input::Builder,
    }
    impl<C, M, R> PutSipMediaApplicationLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSipMediaApplicationLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSipMediaApplicationLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutSipMediaApplicationLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSipMediaApplicationLoggingConfigurationInputOperationOutputAlias,
                crate::output::PutSipMediaApplicationLoggingConfigurationOutput,
                crate::error::PutSipMediaApplicationLoggingConfigurationError,
                crate::input::PutSipMediaApplicationLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// <p>The actual logging configuration.</p>
        pub fn sip_media_application_logging_configuration(
            mut self,
            input: crate::model::SipMediaApplicationLoggingConfiguration,
        ) -> Self {
            self.inner = self
                .inner
                .sip_media_application_logging_configuration(input);
            self
        }
        /// <p>The actual logging configuration.</p>
        pub fn set_sip_media_application_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::SipMediaApplicationLoggingConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_sip_media_application_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorEmergencyCallingConfiguration`.
    ///
    /// <p>Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for the Amazon Chime Voice Connector before emergency calling can be configured.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVoiceConnectorEmergencyCallingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_emergency_calling_configuration_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorEmergencyCallingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorEmergencyCallingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::PutVoiceConnectorEmergencyCallingConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorEmergencyCallingConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::PutVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias,
                                    crate::output::PutVoiceConnectorEmergencyCallingConfigurationOutput,
                                    crate::error::PutVoiceConnectorEmergencyCallingConfigurationError,
                                    crate::input::PutVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The emergency calling configuration details.</p>
        pub fn emergency_calling_configuration(
            mut self,
            input: crate::model::EmergencyCallingConfiguration,
        ) -> Self {
            self.inner = self.inner.emergency_calling_configuration(input);
            self
        }
        /// <p>The emergency calling configuration details.</p>
        pub fn set_emergency_calling_configuration(
            mut self,
            input: std::option::Option<crate::model::EmergencyCallingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_emergency_calling_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorLoggingConfiguration`.
    ///
    /// <p>Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVoiceConnectorLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_logging_configuration_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutVoiceConnectorLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorLoggingConfigurationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorLoggingConfigurationOutput,
                crate::error::PutVoiceConnectorLoggingConfigurationError,
                crate::input::PutVoiceConnectorLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The logging configuration details to add.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p>The logging configuration details to add.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorOrigination`.
    ///
    /// <p>Adds origination settings for the specified Amazon Chime Voice Connector.</p> <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVoiceConnectorOrigination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_origination_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorOrigination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorOrigination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorOriginationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorOriginationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorOriginationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorOriginationOutput,
                crate::error::PutVoiceConnectorOriginationError,
                crate::input::PutVoiceConnectorOriginationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The origination setting details to add.</p>
        pub fn origination(mut self, input: crate::model::Origination) -> Self {
            self.inner = self.inner.origination(input);
            self
        }
        /// <p>The origination setting details to add.</p>
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.inner = self.inner.set_origination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorProxy`.
    ///
    /// <p>Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVoiceConnectorProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_proxy_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorProxyInputOperationOutputAlias,
                crate::output::PutVoiceConnectorProxyOutput,
                crate::error::PutVoiceConnectorProxyError,
                crate::input::PutVoiceConnectorProxyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The default number of minutes allowed for proxy sessions.</p>
        pub fn default_session_expiry_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.default_session_expiry_minutes(input);
            self
        }
        /// <p>The default number of minutes allowed for proxy sessions.</p>
        pub fn set_default_session_expiry_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_default_session_expiry_minutes(input);
            self
        }
        /// Appends an item to `PhoneNumberPoolCountries`.
        ///
        /// To override the contents of this collection use [`set_phone_number_pool_countries`](Self::set_phone_number_pool_countries).
        ///
        /// <p>The countries for proxy phone numbers to be selected from.</p>
        pub fn phone_number_pool_countries(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.phone_number_pool_countries(input.into());
            self
        }
        /// <p>The countries for proxy phone numbers to be selected from.</p>
        pub fn set_phone_number_pool_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_pool_countries(input);
            self
        }
        /// <p>The phone number to route calls to after a proxy session expires.</p>
        pub fn fall_back_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fall_back_phone_number(input.into());
            self
        }
        /// <p>The phone number to route calls to after a proxy session expires.</p>
        pub fn set_fall_back_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fall_back_phone_number(input);
            self
        }
        /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.disabled(input);
            self
        }
        /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorStreamingConfiguration`.
    ///
    /// <p>Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Indonesians. It also sets the retention period, in hours, for the Amazon Kinesis data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVoiceConnectorStreamingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_streaming_configuration_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorStreamingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorStreamingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorStreamingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutVoiceConnectorStreamingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorStreamingConfigurationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorStreamingConfigurationOutput,
                crate::error::PutVoiceConnectorStreamingConfigurationError,
                crate::input::PutVoiceConnectorStreamingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The streaming configuration details to add.</p>
        pub fn streaming_configuration(
            mut self,
            input: crate::model::StreamingConfiguration,
        ) -> Self {
            self.inner = self.inner.streaming_configuration(input);
            self
        }
        /// <p>The streaming configuration details to add.</p>
        pub fn set_streaming_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_streaming_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorTermination`.
    ///
    /// <p>Adds termination settings for the specified Amazon Chime Voice Connector.</p> <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVoiceConnectorTermination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_termination_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorTermination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorTerminationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorTerminationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorTerminationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorTerminationOutput,
                crate::error::PutVoiceConnectorTerminationError,
                crate::input::PutVoiceConnectorTerminationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The termination setting details to add.</p>
        pub fn termination(mut self, input: crate::model::Termination) -> Self {
            self.inner = self.inner.termination(input);
            self
        }
        /// <p>The termination setting details to add.</p>
        pub fn set_termination(
            mut self,
            input: std::option::Option<crate::model::Termination>,
        ) -> Self {
            self.inner = self.inner.set_termination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorTerminationCredentials`.
    ///
    /// <p>Adds termination SIP credentials for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVoiceConnectorTerminationCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_termination_credentials_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorTerminationCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorTerminationCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorTerminationCredentialsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutVoiceConnectorTerminationCredentialsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorTerminationCredentialsInputOperationOutputAlias,
                crate::output::PutVoiceConnectorTerminationCredentialsOutput,
                crate::error::PutVoiceConnectorTerminationCredentialsError,
                crate::input::PutVoiceConnectorTerminationCredentialsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `Credentials`.
        ///
        /// To override the contents of this collection use [`set_credentials`](Self::set_credentials).
        ///
        /// <p>The termination SIP credentials.</p>
        pub fn credentials(mut self, input: crate::model::Credential) -> Self {
            self.inner = self.inner.credentials(input);
            self
        }
        /// <p>The termination SIP credentials.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Credential>>,
        ) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactChannelMessage`.
    ///
    /// <p>Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RedactChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::redact_channel_message_input::Builder,
    }
    impl<C, M, R> RedactChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RedactChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RedactChannelMessageInputOperationOutputAlias,
                crate::output::RedactChannelMessageOutput,
                crate::error::RedactChannelMessageError,
                crate::input::RedactChannelMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactConversationMessage`.
    ///
    /// <p>Redacts the specified message from the specified Amazon Chime conversation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RedactConversationMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::redact_conversation_message_input::Builder,
    }
    impl<C, M, R> RedactConversationMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RedactConversationMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactConversationMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactConversationMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RedactConversationMessageInputOperationOutputAlias,
                crate::output::RedactConversationMessageOutput,
                crate::error::RedactConversationMessageError,
                crate::input::RedactConversationMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The conversation ID.</p>
        pub fn conversation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conversation_id(input.into());
            self
        }
        /// <p>The conversation ID.</p>
        pub fn set_conversation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conversation_id(input);
            self
        }
        /// <p>The message ID.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The message ID.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactRoomMessage`.
    ///
    /// <p>Redacts the specified message from the specified Amazon Chime channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RedactRoomMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::redact_room_message_input::Builder,
    }
    impl<C, M, R> RedactRoomMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RedactRoomMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactRoomMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactRoomMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RedactRoomMessageInputOperationOutputAlias,
                crate::output::RedactRoomMessageOutput,
                crate::error::RedactRoomMessageError,
                crate::input::RedactRoomMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The message ID.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>The message ID.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegenerateSecurityToken`.
    ///
    /// <p>Regenerates the security token for a bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegenerateSecurityToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::regenerate_security_token_input::Builder,
    }
    impl<C, M, R> RegenerateSecurityToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegenerateSecurityToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegenerateSecurityTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::RegenerateSecurityTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegenerateSecurityTokenInputOperationOutputAlias,
                crate::output::RegenerateSecurityTokenOutput,
                crate::error::RegenerateSecurityTokenError,
                crate::input::RegenerateSecurityTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetPersonalPIN`.
    ///
    /// <p>Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the <code>User</code> object with the updated personal meeting PIN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetPersonalPIN<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_personal_pin_input::Builder,
    }
    impl<C, M, R> ResetPersonalPIN<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetPersonalPIN`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetPersonalPinOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetPersonalPINError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetPersonalPinInputOperationOutputAlias,
                crate::output::ResetPersonalPinOutput,
                crate::error::ResetPersonalPINError,
                crate::input::ResetPersonalPinInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestorePhoneNumber`.
    ///
    /// <p>Moves a phone number from the <b>Deletion queue</b> back into the phone number <b>Inventory</b>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestorePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_phone_number_input::Builder,
    }
    impl<C, M, R> RestorePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestorePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestorePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::RestorePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestorePhoneNumberInputOperationOutputAlias,
                crate::output::RestorePhoneNumberOutput,
                crate::error::RestorePhoneNumberError,
                crate::input::RestorePhoneNumberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(input.into());
            self
        }
        /// <p>The phone number.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchAvailablePhoneNumbers`.
    ///
    /// <p>Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: <code>AreaCode</code>, <code>City</code>, <code>State</code>, or <code>TollFreePrefix</code>. If you provide <code>City</code>, you must also provide <code>State</code>. Numbers outside the US only support the <code>PhoneNumberType</code> filter, which you must use.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchAvailablePhoneNumbers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_available_phone_numbers_input::Builder,
    }
    impl<C, M, R> SearchAvailablePhoneNumbers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchAvailablePhoneNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchAvailablePhoneNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchAvailablePhoneNumbersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchAvailablePhoneNumbersInputOperationOutputAlias,
                crate::output::SearchAvailablePhoneNumbersOutput,
                crate::error::SearchAvailablePhoneNumbersError,
                crate::input::SearchAvailablePhoneNumbersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchAvailablePhoneNumbersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::SearchAvailablePhoneNumbersPaginator<C, M, R> {
            crate::paginator::SearchAvailablePhoneNumbersPaginator::new(self.handle, self.inner)
        }
        /// <p>The area code used to filter results. Only applies to the US.</p>
        pub fn area_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.area_code(input.into());
            self
        }
        /// <p>The area code used to filter results. Only applies to the US.</p>
        pub fn set_area_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_area_code(input);
            self
        }
        /// <p>The city used to filter results. Only applies to the US.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.city(input.into());
            self
        }
        /// <p>The city used to filter results. Only applies to the US.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_city(input);
            self
        }
        /// <p>The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.country(input.into());
            self
        }
        /// <p>The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_country(input);
            self
        }
        /// <p>The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state(input.into());
            self
        }
        /// <p>The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The toll-free prefix that you use to filter results. Only applies to the US.</p>
        pub fn toll_free_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.toll_free_prefix(input.into());
            self
        }
        /// <p>The toll-free prefix that you use to filter results. Only applies to the US.</p>
        pub fn set_toll_free_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_toll_free_prefix(input);
            self
        }
        /// <p>The phone number type used to filter results. Required for non-US numbers.</p>
        pub fn phone_number_type(mut self, input: crate::model::PhoneNumberType) -> Self {
            self.inner = self.inner.phone_number_type(input);
            self
        }
        /// <p>The phone number type used to filter results. Required for non-US numbers.</p>
        pub fn set_phone_number_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberType>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_type(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendChannelMessage`.
    ///
    /// <p>Sends a message to a particular channel that the member is a part of.</p> <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p>
    /// <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata. <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_channel_message_input::Builder,
    }
    impl<C, M, R> SendChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendChannelMessageInputOperationOutputAlias,
                crate::output::SendChannelMessageOutput,
                crate::error::SendChannelMessageError,
                crate::input::SendChannelMessageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMessageType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn persistence(mut self, input: crate::model::ChannelMessagePersistenceType) -> Self {
            self.inner = self.inner.persistence(input);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn set_persistence(
            mut self,
            input: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        ) -> Self {
            self.inner = self.inner.set_persistence(input);
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(input.into());
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMeetingTranscription`.
    ///
    /// <p>Starts transcription for the specified <code>meetingId</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMeetingTranscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_meeting_transcription_input::Builder,
    }
    impl<C, M, R> StartMeetingTranscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMeetingTranscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMeetingTranscriptionInputOperationOutputAlias,
                crate::output::StartMeetingTranscriptionOutput,
                crate::error::StartMeetingTranscriptionError,
                crate::input::StartMeetingTranscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn transcription_configuration(
            mut self,
            input: crate::model::TranscriptionConfiguration,
        ) -> Self {
            self.inner = self.inner.transcription_configuration(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn set_transcription_configuration(
            mut self,
            input: std::option::Option<crate::model::TranscriptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_transcription_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopMeetingTranscription`.
    ///
    /// <p>Stops transcription for the specified <code>meetingId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopMeetingTranscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_meeting_transcription_input::Builder,
    }
    impl<C, M, R> StopMeetingTranscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopMeetingTranscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopMeetingTranscriptionInputOperationOutputAlias,
                crate::output::StopMeetingTranscriptionOutput,
                crate::error::StopMeetingTranscriptionError,
                crate::input::StopMeetingTranscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagAttendee`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK attendee.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_attendee_input::Builder,
    }
    impl<C, M, R> TagAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::TagAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagAttendeeInputOperationOutputAlias,
                crate::output::TagAttendeeOutput,
                crate::error::TagAttendeeError,
                crate::input::TagAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagMeeting`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK meeting.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_meeting_input::Builder,
    }
    impl<C, M, R> TagMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::TagMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagMeetingInputOperationOutputAlias,
                crate::output::TagMeetingOutput,
                crate::error::TagMeetingError,
                crate::input::TagMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK meeting resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagAttendee`.
    ///
    /// <p>Untags the specified tags from the specified Amazon Chime SDK attendee.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_attendee_input::Builder,
    }
    impl<C, M, R> UntagAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagAttendeeInputOperationOutputAlias,
                crate::output::UntagAttendeeOutput,
                crate::error::UntagAttendeeError,
                crate::input::UntagAttendeeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagMeeting`.
    ///
    /// <p>Untags the specified tags from the specified Amazon Chime SDK meeting.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_meeting_input::Builder,
    }
    impl<C, M, R> UntagMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagMeetingInputOperationOutputAlias,
                crate::output::UntagMeetingOutput,
                crate::error::UntagMeetingError,
                crate::input::UntagMeetingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Untags the specified tags from the specified Amazon Chime SDK meeting resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccount`.
    ///
    /// <p>Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_input::Builder,
    }
    impl<C, M, R> UpdateAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountInputOperationOutputAlias,
                crate::output::UpdateAccountOutput,
                crate::error::UpdateAccountError,
                crate::input::UpdateAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The new name for the specified Amazon Chime account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name for the specified Amazon Chime account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The default license applied when you add users to an Amazon Chime account.</p>
        pub fn default_license(mut self, input: crate::model::License) -> Self {
            self.inner = self.inner.default_license(input);
            self
        }
        /// <p>The default license applied when you add users to an Amazon Chime account.</p>
        pub fn set_default_license(
            mut self,
            input: std::option::Option<crate::model::License>,
        ) -> Self {
            self.inner = self.inner.set_default_license(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountSettings`.
    ///
    /// <p>Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_settings_input::Builder,
    }
    impl<C, M, R> UpdateAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountSettingsInputOperationOutputAlias,
                crate::output::UpdateAccountSettingsOutput,
                crate::error::UpdateAccountSettingsError,
                crate::input::UpdateAccountSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The Amazon Chime account settings to update.</p>
        pub fn account_settings(mut self, input: crate::model::AccountSettings) -> Self {
            self.inner = self.inner.account_settings(input);
            self
        }
        /// <p>The Amazon Chime account settings to update.</p>
        pub fn set_account_settings(
            mut self,
            input: std::option::Option<crate::model::AccountSettings>,
        ) -> Self {
            self.inner = self.inner.set_account_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstance`.
    ///
    /// <p>Up