// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociatePhoneNumbersWithVoiceConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_phone_numbers_with_voice_connector`](crate::client::Client::associate_phone_numbers_with_voice_connector).
///
/// See [`crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePhoneNumbersWithVoiceConnector {
    _private: (),
}
impl AssociatePhoneNumbersWithVoiceConnector {
    /// Creates a new builder-style object to manufacture [`AssociatePhoneNumbersWithVoiceConnectorInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorInput)
    pub fn builder() -> crate::input::associate_phone_numbers_with_voice_connector_input::Builder {
        crate::input::associate_phone_numbers_with_voice_connector_input::Builder::default()
    }
    /// Creates a new `AssociatePhoneNumbersWithVoiceConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociatePhoneNumbersWithVoiceConnector {
    type Output = std::result::Result<
        crate::output::AssociatePhoneNumbersWithVoiceConnectorOutput,
        crate::error::AssociatePhoneNumbersWithVoiceConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_phone_numbers_with_voice_connector_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_phone_numbers_with_voice_connector_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociatePhoneNumbersWithVoiceConnectorGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_phone_numbers_with_voice_connector_group`](crate::client::Client::associate_phone_numbers_with_voice_connector_group).
///
/// See [`crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePhoneNumbersWithVoiceConnectorGroup {
    _private: (),
}
impl AssociatePhoneNumbersWithVoiceConnectorGroup {
    /// Creates a new builder-style object to manufacture [`AssociatePhoneNumbersWithVoiceConnectorGroupInput`](crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInput)
    pub fn builder(
    ) -> crate::input::associate_phone_numbers_with_voice_connector_group_input::Builder {
        crate::input::associate_phone_numbers_with_voice_connector_group_input::Builder::default()
    }
    /// Creates a new `AssociatePhoneNumbersWithVoiceConnectorGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for AssociatePhoneNumbersWithVoiceConnectorGroup
{
    type Output = std::result::Result<
        crate::output::AssociatePhoneNumbersWithVoiceConnectorGroupOutput,
        crate::error::AssociatePhoneNumbersWithVoiceConnectorGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_phone_numbers_with_voice_connector_group_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_phone_numbers_with_voice_connector_group_response(response)
        }
    }
}

/// Operation shape for `AssociatePhoneNumberWithUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_phone_number_with_user`](crate::client::Client::associate_phone_number_with_user).
///
/// See [`crate::client::fluent_builders::AssociatePhoneNumberWithUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePhoneNumberWithUser {
    _private: (),
}
impl AssociatePhoneNumberWithUser {
    /// Creates a new builder-style object to manufacture [`AssociatePhoneNumberWithUserInput`](crate::input::AssociatePhoneNumberWithUserInput)
    pub fn builder() -> crate::input::associate_phone_number_with_user_input::Builder {
        crate::input::associate_phone_number_with_user_input::Builder::default()
    }
    /// Creates a new `AssociatePhoneNumberWithUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociatePhoneNumberWithUser {
    type Output = std::result::Result<
        crate::output::AssociatePhoneNumberWithUserOutput,
        crate::error::AssociatePhoneNumberWithUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_phone_number_with_user_error(response)
        } else {
            crate::operation_deser::parse_associate_phone_number_with_user_response(response)
        }
    }
}

/// Operation shape for `AssociateSigninDelegateGroupsWithAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_signin_delegate_groups_with_account`](crate::client::Client::associate_signin_delegate_groups_with_account).
///
/// See [`crate::client::fluent_builders::AssociateSigninDelegateGroupsWithAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSigninDelegateGroupsWithAccount {
    _private: (),
}
impl AssociateSigninDelegateGroupsWithAccount {
    /// Creates a new builder-style object to manufacture [`AssociateSigninDelegateGroupsWithAccountInput`](crate::input::AssociateSigninDelegateGroupsWithAccountInput)
    pub fn builder() -> crate::input::associate_signin_delegate_groups_with_account_input::Builder {
        crate::input::associate_signin_delegate_groups_with_account_input::Builder::default()
    }
    /// Creates a new `AssociateSigninDelegateGroupsWithAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSigninDelegateGroupsWithAccount {
    type Output = std::result::Result<
        crate::output::AssociateSigninDelegateGroupsWithAccountOutput,
        crate::error::AssociateSigninDelegateGroupsWithAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_signin_delegate_groups_with_account_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_signin_delegate_groups_with_account_response(
                response,
            )
        }
    }
}

/// Operation shape for `BatchCreateAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_attendee`](crate::client::Client::batch_create_attendee).
///
/// See [`crate::client::fluent_builders::BatchCreateAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreateAttendee {
    _private: (),
}
impl BatchCreateAttendee {
    /// Creates a new builder-style object to manufacture [`BatchCreateAttendeeInput`](crate::input::BatchCreateAttendeeInput)
    pub fn builder() -> crate::input::batch_create_attendee_input::Builder {
        crate::input::batch_create_attendee_input::Builder::default()
    }
    /// Creates a new `BatchCreateAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreateAttendee {
    type Output = std::result::Result<
        crate::output::BatchCreateAttendeeOutput,
        crate::error::BatchCreateAttendeeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_batch_create_attendee_error(response)
        } else {
            crate::operation_deser::parse_batch_create_attendee_response(response)
        }
    }
}

/// Operation shape for `BatchCreateChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_channel_membership`](crate::client::Client::batch_create_channel_membership).
///
/// See [`crate::client::fluent_builders::BatchCreateChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreateChannelMembership {
    _private: (),
}
impl BatchCreateChannelMembership {
    /// Creates a new builder-style object to manufacture [`BatchCreateChannelMembershipInput`](crate::input::BatchCreateChannelMembershipInput)
    pub fn builder() -> crate::input::batch_create_channel_membership_input::Builder {
        crate::input::batch_create_channel_membership_input::Builder::default()
    }
    /// Creates a new `BatchCreateChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreateChannelMembership {
    type Output = std::result::Result<
        crate::output::BatchCreateChannelMembershipOutput,
        crate::error::BatchCreateChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_create_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_batch_create_channel_membership_response(response)
        }
    }
}

/// Operation shape for `BatchCreateRoomMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_room_membership`](crate::client::Client::batch_create_room_membership).
///
/// See [`crate::client::fluent_builders::BatchCreateRoomMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreateRoomMembership {
    _private: (),
}
impl BatchCreateRoomMembership {
    /// Creates a new builder-style object to manufacture [`BatchCreateRoomMembershipInput`](crate::input::BatchCreateRoomMembershipInput)
    pub fn builder() -> crate::input::batch_create_room_membership_input::Builder {
        crate::input::batch_create_room_membership_input::Builder::default()
    }
    /// Creates a new `BatchCreateRoomMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreateRoomMembership {
    type Output = std::result::Result<
        crate::output::BatchCreateRoomMembershipOutput,
        crate::error::BatchCreateRoomMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_batch_create_room_membership_error(response)
        } else {
            crate::operation_deser::parse_batch_create_room_membership_response(response)
        }
    }
}

/// Operation shape for `BatchDeletePhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_phone_number`](crate::client::Client::batch_delete_phone_number).
///
/// See [`crate::client::fluent_builders::BatchDeletePhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeletePhoneNumber {
    _private: (),
}
impl BatchDeletePhoneNumber {
    /// Creates a new builder-style object to manufacture [`BatchDeletePhoneNumberInput`](crate::input::BatchDeletePhoneNumberInput)
    pub fn builder() -> crate::input::batch_delete_phone_number_input::Builder {
        crate::input::batch_delete_phone_number_input::Builder::default()
    }
    /// Creates a new `BatchDeletePhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeletePhoneNumber {
    type Output = std::result::Result<
        crate::output::BatchDeletePhoneNumberOutput,
        crate::error::BatchDeletePhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_phone_number_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_phone_number_response(response)
        }
    }
}

/// Operation shape for `BatchSuspendUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_suspend_user`](crate::client::Client::batch_suspend_user).
///
/// See [`crate::client::fluent_builders::BatchSuspendUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchSuspendUser {
    _private: (),
}
impl BatchSuspendUser {
    /// Creates a new builder-style object to manufacture [`BatchSuspendUserInput`](crate::input::BatchSuspendUserInput)
    pub fn builder() -> crate::input::batch_suspend_user_input::Builder {
        crate::input::batch_suspend_user_input::Builder::default()
    }
    /// Creates a new `BatchSuspendUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchSuspendUser {
    type Output = std::result::Result<
        crate::output::BatchSuspendUserOutput,
        crate::error::BatchSuspendUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_suspend_user_error(response)
        } else {
            crate::operation_deser::parse_batch_suspend_user_response(response)
        }
    }
}

/// Operation shape for `BatchUnsuspendUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_unsuspend_user`](crate::client::Client::batch_unsuspend_user).
///
/// See [`crate::client::fluent_builders::BatchUnsuspendUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUnsuspendUser {
    _private: (),
}
impl BatchUnsuspendUser {
    /// Creates a new builder-style object to manufacture [`BatchUnsuspendUserInput`](crate::input::BatchUnsuspendUserInput)
    pub fn builder() -> crate::input::batch_unsuspend_user_input::Builder {
        crate::input::batch_unsuspend_user_input::Builder::default()
    }
    /// Creates a new `BatchUnsuspendUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUnsuspendUser {
    type Output = std::result::Result<
        crate::output::BatchUnsuspendUserOutput,
        crate::error::BatchUnsuspendUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_unsuspend_user_error(response)
        } else {
            crate::operation_deser::parse_batch_unsuspend_user_response(response)
        }
    }
}

/// Operation shape for `BatchUpdatePhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_update_phone_number`](crate::client::Client::batch_update_phone_number).
///
/// See [`crate::client::fluent_builders::BatchUpdatePhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUpdatePhoneNumber {
    _private: (),
}
impl BatchUpdatePhoneNumber {
    /// Creates a new builder-style object to manufacture [`BatchUpdatePhoneNumberInput`](crate::input::BatchUpdatePhoneNumberInput)
    pub fn builder() -> crate::input::batch_update_phone_number_input::Builder {
        crate::input::batch_update_phone_number_input::Builder::default()
    }
    /// Creates a new `BatchUpdatePhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUpdatePhoneNumber {
    type Output = std::result::Result<
        crate::output::BatchUpdatePhoneNumberOutput,
        crate::error::BatchUpdatePhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_update_phone_number_error(response)
        } else {
            crate::operation_deser::parse_batch_update_phone_number_response(response)
        }
    }
}

/// Operation shape for `BatchUpdateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_update_user`](crate::client::Client::batch_update_user).
///
/// See [`crate::client::fluent_builders::BatchUpdateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUpdateUser {
    _private: (),
}
impl BatchUpdateUser {
    /// Creates a new builder-style object to manufacture [`BatchUpdateUserInput`](crate::input::BatchUpdateUserInput)
    pub fn builder() -> crate::input::batch_update_user_input::Builder {
        crate::input::batch_update_user_input::Builder::default()
    }
    /// Creates a new `BatchUpdateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUpdateUser {
    type Output = std::result::Result<
        crate::output::BatchUpdateUserOutput,
        crate::error::BatchUpdateUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_update_user_error(response)
        } else {
            crate::operation_deser::parse_batch_update_user_response(response)
        }
    }
}

/// Operation shape for `CreateAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_account`](crate::client::Client::create_account).
///
/// See [`crate::client::fluent_builders::CreateAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccount {
    _private: (),
}
impl CreateAccount {
    /// Creates a new builder-style object to manufacture [`CreateAccountInput`](crate::input::CreateAccountInput)
    pub fn builder() -> crate::input::create_account_input::Builder {
        crate::input::create_account_input::Builder::default()
    }
    /// Creates a new `CreateAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccount {
    type Output =
        std::result::Result<crate::output::CreateAccountOutput, crate::error::CreateAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_account_error(response)
        } else {
            crate::operation_deser::parse_create_account_response(response)
        }
    }
}

/// Operation shape for `CreateAppInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app_instance`](crate::client::Client::create_app_instance).
///
/// See [`crate::client::fluent_builders::CreateAppInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAppInstance {
    _private: (),
}
impl CreateAppInstance {
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceInput`](crate::input::CreateAppInstanceInput)
    pub fn builder() -> crate::input::create_app_instance_input::Builder {
        crate::input::create_app_instance_input::Builder::default()
    }
    /// Creates a new `CreateAppInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAppInstance {
    type Output = std::result::Result<
        crate::output::CreateAppInstanceOutput,
        crate::error::CreateAppInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_app_instance_error(response)
        } else {
            crate::operation_deser::parse_create_app_instance_response(response)
        }
    }
}

/// Operation shape for `CreateAppInstanceAdmin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app_instance_admin`](crate::client::Client::create_app_instance_admin).
///
/// See [`crate::client::fluent_builders::CreateAppInstanceAdmin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAppInstanceAdmin {
    _private: (),
}
impl CreateAppInstanceAdmin {
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceAdminInput`](crate::input::CreateAppInstanceAdminInput)
    pub fn builder() -> crate::input::create_app_instance_admin_input::Builder {
        crate::input::create_app_instance_admin_input::Builder::default()
    }
    /// Creates a new `CreateAppInstanceAdmin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAppInstanceAdmin {
    type Output = std::result::Result<
        crate::output::CreateAppInstanceAdminOutput,
        crate::error::CreateAppInstanceAdminError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_app_instance_admin_error(response)
        } else {
            crate::operation_deser::parse_create_app_instance_admin_response(response)
        }
    }
}

/// Operation shape for `CreateAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app_instance_user`](crate::client::Client::create_app_instance_user).
///
/// See [`crate::client::fluent_builders::CreateAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAppInstanceUser {
    _private: (),
}
impl CreateAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`CreateAppInstanceUserInput`](crate::input::CreateAppInstanceUserInput)
    pub fn builder() -> crate::input::create_app_instance_user_input::Builder {
        crate::input::create_app_instance_user_input::Builder::default()
    }
    /// Creates a new `CreateAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAppInstanceUser {
    type Output = std::result::Result<
        crate::output::CreateAppInstanceUserOutput,
        crate::error::CreateAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_app_instance_user_error(response)
        } else {
            crate::operation_deser::parse_create_app_instance_user_response(response)
        }
    }
}

/// Operation shape for `CreateAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_attendee`](crate::client::Client::create_attendee).
///
/// See [`crate::client::fluent_builders::CreateAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAttendee {
    _private: (),
}
impl CreateAttendee {
    /// Creates a new builder-style object to manufacture [`CreateAttendeeInput`](crate::input::CreateAttendeeInput)
    pub fn builder() -> crate::input::create_attendee_input::Builder {
        crate::input::create_attendee_input::Builder::default()
    }
    /// Creates a new `CreateAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAttendee {
    type Output =
        std::result::Result<crate::output::CreateAttendeeOutput, crate::error::CreateAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_attendee_error(response)
        } else {
            crate::operation_deser::parse_create_attendee_response(response)
        }
    }
}

/// Operation shape for `CreateBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bot`](crate::client::Client::create_bot).
///
/// See [`crate::client::fluent_builders::CreateBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBot {
    _private: (),
}
impl CreateBot {
    /// Creates a new builder-style object to manufacture [`CreateBotInput`](crate::input::CreateBotInput)
    pub fn builder() -> crate::input::create_bot_input::Builder {
        crate::input::create_bot_input::Builder::default()
    }
    /// Creates a new `CreateBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBot {
    type Output = std::result::Result<crate::output::CreateBotOutput, crate::error::CreateBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_bot_error(response)
        } else {
            crate::operation_deser::parse_create_bot_response(response)
        }
    }
}

/// Operation shape for `CreateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel`](crate::client::Client::create_channel).
///
/// See [`crate::client::fluent_builders::CreateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannel {
    _private: (),
}
impl CreateChannel {
    /// Creates a new builder-style object to manufacture [`CreateChannelInput`](crate::input::CreateChannelInput)
    pub fn builder() -> crate::input::create_channel_input::Builder {
        crate::input::create_channel_input::Builder::default()
    }
    /// Creates a new `CreateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannel {
    type Output =
        std::result::Result<crate::output::CreateChannelOutput, crate::error::CreateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_error(response)
        } else {
            crate::operation_deser::parse_create_channel_response(response)
        }
    }
}

/// Operation shape for `CreateChannelBan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel_ban`](crate::client::Client::create_channel_ban).
///
/// See [`crate::client::fluent_builders::CreateChannelBan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannelBan {
    _private: (),
}
impl CreateChannelBan {
    /// Creates a new builder-style object to manufacture [`CreateChannelBanInput`](crate::input::CreateChannelBanInput)
    pub fn builder() -> crate::input::create_channel_ban_input::Builder {
        crate::input::create_channel_ban_input::Builder::default()
    }
    /// Creates a new `CreateChannelBan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannelBan {
    type Output = std::result::Result<
        crate::output::CreateChannelBanOutput,
        crate::error::CreateChannelBanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_ban_error(response)
        } else {
            crate::operation_deser::parse_create_channel_ban_response(response)
        }
    }
}

/// Operation shape for `CreateChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel_membership`](crate::client::Client::create_channel_membership).
///
/// See [`crate::client::fluent_builders::CreateChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannelMembership {
    _private: (),
}
impl CreateChannelMembership {
    /// Creates a new builder-style object to manufacture [`CreateChannelMembershipInput`](crate::input::CreateChannelMembershipInput)
    pub fn builder() -> crate::input::create_channel_membership_input::Builder {
        crate::input::create_channel_membership_input::Builder::default()
    }
    /// Creates a new `CreateChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannelMembership {
    type Output = std::result::Result<
        crate::output::CreateChannelMembershipOutput,
        crate::error::CreateChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_create_channel_membership_response(response)
        }
    }
}

/// Operation shape for `CreateChannelModerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel_moderator`](crate::client::Client::create_channel_moderator).
///
/// See [`crate::client::fluent_builders::CreateChannelModerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannelModerator {
    _private: (),
}
impl CreateChannelModerator {
    /// Creates a new builder-style object to manufacture [`CreateChannelModeratorInput`](crate::input::CreateChannelModeratorInput)
    pub fn builder() -> crate::input::create_channel_moderator_input::Builder {
        crate::input::create_channel_moderator_input::Builder::default()
    }
    /// Creates a new `CreateChannelModerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannelModerator {
    type Output = std::result::Result<
        crate::output::CreateChannelModeratorOutput,
        crate::error::CreateChannelModeratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_moderator_error(response)
        } else {
            crate::operation_deser::parse_create_channel_moderator_response(response)
        }
    }
}

/// Operation shape for `CreateMediaCapturePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_media_capture_pipeline`](crate::client::Client::create_media_capture_pipeline).
///
/// See [`crate::client::fluent_builders::CreateMediaCapturePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMediaCapturePipeline {
    _private: (),
}
impl CreateMediaCapturePipeline {
    /// Creates a new builder-style object to manufacture [`CreateMediaCapturePipelineInput`](crate::input::CreateMediaCapturePipelineInput)
    pub fn builder() -> crate::input::create_media_capture_pipeline_input::Builder {
        crate::input::create_media_capture_pipeline_input::Builder::default()
    }
    /// Creates a new `CreateMediaCapturePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMediaCapturePipeline {
    type Output = std::result::Result<
        crate::output::CreateMediaCapturePipelineOutput,
        crate::error::CreateMediaCapturePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_media_capture_pipeline_error(response)
        } else {
            crate::operation_deser::parse_create_media_capture_pipeline_response(response)
        }
    }
}

/// Operation shape for `CreateMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_meeting`](crate::client::Client::create_meeting).
///
/// See [`crate::client::fluent_builders::CreateMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMeeting {
    _private: (),
}
impl CreateMeeting {
    /// Creates a new builder-style object to manufacture [`CreateMeetingInput`](crate::input::CreateMeetingInput)
    pub fn builder() -> crate::input::create_meeting_input::Builder {
        crate::input::create_meeting_input::Builder::default()
    }
    /// Creates a new `CreateMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMeeting {
    type Output =
        std::result::Result<crate::output::CreateMeetingOutput, crate::error::CreateMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_meeting_error(response)
        } else {
            crate::operation_deser::parse_create_meeting_response(response)
        }
    }
}

/// Operation shape for `CreateMeetingDialOut`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_meeting_dial_out`](crate::client::Client::create_meeting_dial_out).
///
/// See [`crate::client::fluent_builders::CreateMeetingDialOut`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMeetingDialOut {
    _private: (),
}
impl CreateMeetingDialOut {
    /// Creates a new builder-style object to manufacture [`CreateMeetingDialOutInput`](crate::input::CreateMeetingDialOutInput)
    pub fn builder() -> crate::input::create_meeting_dial_out_input::Builder {
        crate::input::create_meeting_dial_out_input::Builder::default()
    }
    /// Creates a new `CreateMeetingDialOut` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMeetingDialOut {
    type Output = std::result::Result<
        crate::output::CreateMeetingDialOutOutput,
        crate::error::CreateMeetingDialOutError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_meeting_dial_out_error(response)
        } else {
            crate::operation_deser::parse_create_meeting_dial_out_response(response)
        }
    }
}

/// Operation shape for `CreateMeetingWithAttendees`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_meeting_with_attendees`](crate::client::Client::create_meeting_with_attendees).
///
/// See [`crate::client::fluent_builders::CreateMeetingWithAttendees`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMeetingWithAttendees {
    _private: (),
}
impl CreateMeetingWithAttendees {
    /// Creates a new builder-style object to manufacture [`CreateMeetingWithAttendeesInput`](crate::input::CreateMeetingWithAttendeesInput)
    pub fn builder() -> crate::input::create_meeting_with_attendees_input::Builder {
        crate::input::create_meeting_with_attendees_input::Builder::default()
    }
    /// Creates a new `CreateMeetingWithAttendees` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMeetingWithAttendees {
    type Output = std::result::Result<
        crate::output::CreateMeetingWithAttendeesOutput,
        crate::error::CreateMeetingWithAttendeesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_meeting_with_attendees_error(response)
        } else {
            crate::operation_deser::parse_create_meeting_with_attendees_response(response)
        }
    }
}

/// Operation shape for `CreatePhoneNumberOrder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_phone_number_order`](crate::client::Client::create_phone_number_order).
///
/// See [`crate::client::fluent_builders::CreatePhoneNumberOrder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePhoneNumberOrder {
    _private: (),
}
impl CreatePhoneNumberOrder {
    /// Creates a new builder-style object to manufacture [`CreatePhoneNumberOrderInput`](crate::input::CreatePhoneNumberOrderInput)
    pub fn builder() -> crate::input::create_phone_number_order_input::Builder {
        crate::input::create_phone_number_order_input::Builder::default()
    }
    /// Creates a new `CreatePhoneNumberOrder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePhoneNumberOrder {
    type Output = std::result::Result<
        crate::output::CreatePhoneNumberOrderOutput,
        crate::error::CreatePhoneNumberOrderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_phone_number_order_error(response)
        } else {
            crate::operation_deser::parse_create_phone_number_order_response(response)
        }
    }
}

/// Operation shape for `CreateProxySession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_proxy_session`](crate::client::Client::create_proxy_session).
///
/// See [`crate::client::fluent_builders::CreateProxySession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProxySession {
    _private: (),
}
impl CreateProxySession {
    /// Creates a new builder-style object to manufacture [`CreateProxySessionInput`](crate::input::CreateProxySessionInput)
    pub fn builder() -> crate::input::create_proxy_session_input::Builder {
        crate::input::create_proxy_session_input::Builder::default()
    }
    /// Creates a new `CreateProxySession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProxySession {
    type Output = std::result::Result<
        crate::output::CreateProxySessionOutput,
        crate::error::CreateProxySessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_proxy_session_error(response)
        } else {
            crate::operation_deser::parse_create_proxy_session_response(response)
        }
    }
}

/// Operation shape for `CreateRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_room`](crate::client::Client::create_room).
///
/// See [`crate::client::fluent_builders::CreateRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoom {
    _private: (),
}
impl CreateRoom {
    /// Creates a new builder-style object to manufacture [`CreateRoomInput`](crate::input::CreateRoomInput)
    pub fn builder() -> crate::input::create_room_input::Builder {
        crate::input::create_room_input::Builder::default()
    }
    /// Creates a new `CreateRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoom {
    type Output =
        std::result::Result<crate::output::CreateRoomOutput, crate::error::CreateRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_room_error(response)
        } else {
            crate::operation_deser::parse_create_room_response(response)
        }
    }
}

/// Operation shape for `CreateRoomMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_room_membership`](crate::client::Client::create_room_membership).
///
/// See [`crate::client::fluent_builders::CreateRoomMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoomMembership {
    _private: (),
}
impl CreateRoomMembership {
    /// Creates a new builder-style object to manufacture [`CreateRoomMembershipInput`](crate::input::CreateRoomMembershipInput)
    pub fn builder() -> crate::input::create_room_membership_input::Builder {
        crate::input::create_room_membership_input::Builder::default()
    }
    /// Creates a new `CreateRoomMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoomMembership {
    type Output = std::result::Result<
        crate::output::CreateRoomMembershipOutput,
        crate::error::CreateRoomMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_room_membership_error(response)
        } else {
            crate::operation_deser::parse_create_room_membership_response(response)
        }
    }
}

/// Operation shape for `CreateSipMediaApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sip_media_application`](crate::client::Client::create_sip_media_application).
///
/// See [`crate::client::fluent_builders::CreateSipMediaApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSipMediaApplication {
    _private: (),
}
impl CreateSipMediaApplication {
    /// Creates a new builder-style object to manufacture [`CreateSipMediaApplicationInput`](crate::input::CreateSipMediaApplicationInput)
    pub fn builder() -> crate::input::create_sip_media_application_input::Builder {
        crate::input::create_sip_media_application_input::Builder::default()
    }
    /// Creates a new `CreateSipMediaApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSipMediaApplication {
    type Output = std::result::Result<
        crate::output::CreateSipMediaApplicationOutput,
        crate::error::CreateSipMediaApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_sip_media_application_error(response)
        } else {
            crate::operation_deser::parse_create_sip_media_application_response(response)
        }
    }
}

/// Operation shape for `CreateSipMediaApplicationCall`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sip_media_application_call`](crate::client::Client::create_sip_media_application_call).
///
/// See [`crate::client::fluent_builders::CreateSipMediaApplicationCall`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSipMediaApplicationCall {
    _private: (),
}
impl CreateSipMediaApplicationCall {
    /// Creates a new builder-style object to manufacture [`CreateSipMediaApplicationCallInput`](crate::input::CreateSipMediaApplicationCallInput)
    pub fn builder() -> crate::input::create_sip_media_application_call_input::Builder {
        crate::input::create_sip_media_application_call_input::Builder::default()
    }
    /// Creates a new `CreateSipMediaApplicationCall` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSipMediaApplicationCall {
    type Output = std::result::Result<
        crate::output::CreateSipMediaApplicationCallOutput,
        crate::error::CreateSipMediaApplicationCallError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_sip_media_application_call_error(response)
        } else {
            crate::operation_deser::parse_create_sip_media_application_call_response(response)
        }
    }
}

/// Operation shape for `CreateSipRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sip_rule`](crate::client::Client::create_sip_rule).
///
/// See [`crate::client::fluent_builders::CreateSipRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSipRule {
    _private: (),
}
impl CreateSipRule {
    /// Creates a new builder-style object to manufacture [`CreateSipRuleInput`](crate::input::CreateSipRuleInput)
    pub fn builder() -> crate::input::create_sip_rule_input::Builder {
        crate::input::create_sip_rule_input::Builder::default()
    }
    /// Creates a new `CreateSipRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSipRule {
    type Output =
        std::result::Result<crate::output::CreateSipRuleOutput, crate::error::CreateSipRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_sip_rule_error(response)
        } else {
            crate::operation_deser::parse_create_sip_rule_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `CreateVoiceConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_voice_connector`](crate::client::Client::create_voice_connector).
///
/// See [`crate::client::fluent_builders::CreateVoiceConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVoiceConnector {
    _private: (),
}
impl CreateVoiceConnector {
    /// Creates a new builder-style object to manufacture [`CreateVoiceConnectorInput`](crate::input::CreateVoiceConnectorInput)
    pub fn builder() -> crate::input::create_voice_connector_input::Builder {
        crate::input::create_voice_connector_input::Builder::default()
    }
    /// Creates a new `CreateVoiceConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVoiceConnector {
    type Output = std::result::Result<
        crate::output::CreateVoiceConnectorOutput,
        crate::error::CreateVoiceConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_voice_connector_error(response)
        } else {
            crate::operation_deser::parse_create_voice_connector_response(response)
        }
    }
}

/// Operation shape for `CreateVoiceConnectorGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_voice_connector_group`](crate::client::Client::create_voice_connector_group).
///
/// See [`crate::client::fluent_builders::CreateVoiceConnectorGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVoiceConnectorGroup {
    _private: (),
}
impl CreateVoiceConnectorGroup {
    /// Creates a new builder-style object to manufacture [`CreateVoiceConnectorGroupInput`](crate::input::CreateVoiceConnectorGroupInput)
    pub fn builder() -> crate::input::create_voice_connector_group_input::Builder {
        crate::input::create_voice_connector_group_input::Builder::default()
    }
    /// Creates a new `CreateVoiceConnectorGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVoiceConnectorGroup {
    type Output = std::result::Result<
        crate::output::CreateVoiceConnectorGroupOutput,
        crate::error::CreateVoiceConnectorGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_voice_connector_group_error(response)
        } else {
            crate::operation_deser::parse_create_voice_connector_group_response(response)
        }
    }
}

/// Operation shape for `DeleteAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_account`](crate::client::Client::delete_account).
///
/// See [`crate::client::fluent_builders::DeleteAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccount {
    _private: (),
}
impl DeleteAccount {
    /// Creates a new builder-style object to manufacture [`DeleteAccountInput`](crate::input::DeleteAccountInput)
    pub fn builder() -> crate::input::delete_account_input::Builder {
        crate::input::delete_account_input::Builder::default()
    }
    /// Creates a new `DeleteAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccount {
    type Output =
        std::result::Result<crate::output::DeleteAccountOutput, crate::error::DeleteAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_account_error(response)
        } else {
            crate::operation_deser::parse_delete_account_response(response)
        }
    }
}

/// Operation shape for `DeleteAppInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_instance`](crate::client::Client::delete_app_instance).
///
/// See [`crate::client::fluent_builders::DeleteAppInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppInstance {
    _private: (),
}
impl DeleteAppInstance {
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceInput`](crate::input::DeleteAppInstanceInput)
    pub fn builder() -> crate::input::delete_app_instance_input::Builder {
        crate::input::delete_app_instance_input::Builder::default()
    }
    /// Creates a new `DeleteAppInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppInstance {
    type Output = std::result::Result<
        crate::output::DeleteAppInstanceOutput,
        crate::error::DeleteAppInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_app_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_app_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteAppInstanceAdmin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_instance_admin`](crate::client::Client::delete_app_instance_admin).
///
/// See [`crate::client::fluent_builders::DeleteAppInstanceAdmin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppInstanceAdmin {
    _private: (),
}
impl DeleteAppInstanceAdmin {
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceAdminInput`](crate::input::DeleteAppInstanceAdminInput)
    pub fn builder() -> crate::input::delete_app_instance_admin_input::Builder {
        crate::input::delete_app_instance_admin_input::Builder::default()
    }
    /// Creates a new `DeleteAppInstanceAdmin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppInstanceAdmin {
    type Output = std::result::Result<
        crate::output::DeleteAppInstanceAdminOutput,
        crate::error::DeleteAppInstanceAdminError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_app_instance_admin_error(response)
        } else {
            crate::operation_deser::parse_delete_app_instance_admin_response(response)
        }
    }
}

/// Operation shape for `DeleteAppInstanceStreamingConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_instance_streaming_configurations`](crate::client::Client::delete_app_instance_streaming_configurations).
///
/// See [`crate::client::fluent_builders::DeleteAppInstanceStreamingConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppInstanceStreamingConfigurations {
    _private: (),
}
impl DeleteAppInstanceStreamingConfigurations {
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceStreamingConfigurationsInput`](crate::input::DeleteAppInstanceStreamingConfigurationsInput)
    pub fn builder() -> crate::input::delete_app_instance_streaming_configurations_input::Builder {
        crate::input::delete_app_instance_streaming_configurations_input::Builder::default()
    }
    /// Creates a new `DeleteAppInstanceStreamingConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppInstanceStreamingConfigurations {
    type Output = std::result::Result<
        crate::output::DeleteAppInstanceStreamingConfigurationsOutput,
        crate::error::DeleteAppInstanceStreamingConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_app_instance_streaming_configurations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_app_instance_streaming_configurations_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_instance_user`](crate::client::Client::delete_app_instance_user).
///
/// See [`crate::client::fluent_builders::DeleteAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppInstanceUser {
    _private: (),
}
impl DeleteAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`DeleteAppInstanceUserInput`](crate::input::DeleteAppInstanceUserInput)
    pub fn builder() -> crate::input::delete_app_instance_user_input::Builder {
        crate::input::delete_app_instance_user_input::Builder::default()
    }
    /// Creates a new `DeleteAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppInstanceUser {
    type Output = std::result::Result<
        crate::output::DeleteAppInstanceUserOutput,
        crate::error::DeleteAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_app_instance_user_error(response)
        } else {
            crate::operation_deser::parse_delete_app_instance_user_response(response)
        }
    }
}

/// Operation shape for `DeleteAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_attendee`](crate::client::Client::delete_attendee).
///
/// See [`crate::client::fluent_builders::DeleteAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAttendee {
    _private: (),
}
impl DeleteAttendee {
    /// Creates a new builder-style object to manufacture [`DeleteAttendeeInput`](crate::input::DeleteAttendeeInput)
    pub fn builder() -> crate::input::delete_attendee_input::Builder {
        crate::input::delete_attendee_input::Builder::default()
    }
    /// Creates a new `DeleteAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAttendee {
    type Output =
        std::result::Result<crate::output::DeleteAttendeeOutput, crate::error::DeleteAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_attendee_error(response)
        } else {
            crate::operation_deser::parse_delete_attendee_response(response)
        }
    }
}

/// Operation shape for `DeleteChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel`](crate::client::Client::delete_channel).
///
/// See [`crate::client::fluent_builders::DeleteChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannel {
    _private: (),
}
impl DeleteChannel {
    /// Creates a new builder-style object to manufacture [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    pub fn builder() -> crate::input::delete_channel_input::Builder {
        crate::input::delete_channel_input::Builder::default()
    }
    /// Creates a new `DeleteChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannel {
    type Output =
        std::result::Result<crate::output::DeleteChannelOutput, crate::error::DeleteChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelBan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_ban`](crate::client::Client::delete_channel_ban).
///
/// See [`crate::client::fluent_builders::DeleteChannelBan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelBan {
    _private: (),
}
impl DeleteChannelBan {
    /// Creates a new builder-style object to manufacture [`DeleteChannelBanInput`](crate::input::DeleteChannelBanInput)
    pub fn builder() -> crate::input::delete_channel_ban_input::Builder {
        crate::input::delete_channel_ban_input::Builder::default()
    }
    /// Creates a new `DeleteChannelBan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelBan {
    type Output = std::result::Result<
        crate::output::DeleteChannelBanOutput,
        crate::error::DeleteChannelBanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_ban_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_ban_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_membership`](crate::client::Client::delete_channel_membership).
///
/// See [`crate::client::fluent_builders::DeleteChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelMembership {
    _private: (),
}
impl DeleteChannelMembership {
    /// Creates a new builder-style object to manufacture [`DeleteChannelMembershipInput`](crate::input::DeleteChannelMembershipInput)
    pub fn builder() -> crate::input::delete_channel_membership_input::Builder {
        crate::input::delete_channel_membership_input::Builder::default()
    }
    /// Creates a new `DeleteChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelMembership {
    type Output = std::result::Result<
        crate::output::DeleteChannelMembershipOutput,
        crate::error::DeleteChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_membership_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_message`](crate::client::Client::delete_channel_message).
///
/// See [`crate::client::fluent_builders::DeleteChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelMessage {
    _private: (),
}
impl DeleteChannelMessage {
    /// Creates a new builder-style object to manufacture [`DeleteChannelMessageInput`](crate::input::DeleteChannelMessageInput)
    pub fn builder() -> crate::input::delete_channel_message_input::Builder {
        crate::input::delete_channel_message_input::Builder::default()
    }
    /// Creates a new `DeleteChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelMessage {
    type Output = std::result::Result<
        crate::output::DeleteChannelMessageOutput,
        crate::error::DeleteChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_message_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_message_response(response)
        }
    }
}

/// Operation shape for `DeleteChannelModerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel_moderator`](crate::client::Client::delete_channel_moderator).
///
/// See [`crate::client::fluent_builders::DeleteChannelModerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannelModerator {
    _private: (),
}
impl DeleteChannelModerator {
    /// Creates a new builder-style object to manufacture [`DeleteChannelModeratorInput`](crate::input::DeleteChannelModeratorInput)
    pub fn builder() -> crate::input::delete_channel_moderator_input::Builder {
        crate::input::delete_channel_moderator_input::Builder::default()
    }
    /// Creates a new `DeleteChannelModerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannelModerator {
    type Output = std::result::Result<
        crate::output::DeleteChannelModeratorOutput,
        crate::error::DeleteChannelModeratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_moderator_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_moderator_response(response)
        }
    }
}

/// Operation shape for `DeleteEventsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_events_configuration`](crate::client::Client::delete_events_configuration).
///
/// See [`crate::client::fluent_builders::DeleteEventsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventsConfiguration {
    _private: (),
}
impl DeleteEventsConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteEventsConfigurationInput`](crate::input::DeleteEventsConfigurationInput)
    pub fn builder() -> crate::input::delete_events_configuration_input::Builder {
        crate::input::delete_events_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteEventsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventsConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteEventsConfigurationOutput,
        crate::error::DeleteEventsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_events_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_events_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteMediaCapturePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_media_capture_pipeline`](crate::client::Client::delete_media_capture_pipeline).
///
/// See [`crate::client::fluent_builders::DeleteMediaCapturePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMediaCapturePipeline {
    _private: (),
}
impl DeleteMediaCapturePipeline {
    /// Creates a new builder-style object to manufacture [`DeleteMediaCapturePipelineInput`](crate::input::DeleteMediaCapturePipelineInput)
    pub fn builder() -> crate::input::delete_media_capture_pipeline_input::Builder {
        crate::input::delete_media_capture_pipeline_input::Builder::default()
    }
    /// Creates a new `DeleteMediaCapturePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMediaCapturePipeline {
    type Output = std::result::Result<
        crate::output::DeleteMediaCapturePipelineOutput,
        crate::error::DeleteMediaCapturePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_media_capture_pipeline_error(response)
        } else {
            crate::operation_deser::parse_delete_media_capture_pipeline_response(response)
        }
    }
}

/// Operation shape for `DeleteMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_meeting`](crate::client::Client::delete_meeting).
///
/// See [`crate::client::fluent_builders::DeleteMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMeeting {
    _private: (),
}
impl DeleteMeeting {
    /// Creates a new builder-style object to manufacture [`DeleteMeetingInput`](crate::input::DeleteMeetingInput)
    pub fn builder() -> crate::input::delete_meeting_input::Builder {
        crate::input::delete_meeting_input::Builder::default()
    }
    /// Creates a new `DeleteMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMeeting {
    type Output =
        std::result::Result<crate::output::DeleteMeetingOutput, crate::error::DeleteMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_meeting_error(response)
        } else {
            crate::operation_deser::parse_delete_meeting_response(response)
        }
    }
}

/// Operation shape for `DeletePhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_phone_number`](crate::client::Client::delete_phone_number).
///
/// See [`crate::client::fluent_builders::DeletePhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePhoneNumber {
    _private: (),
}
impl DeletePhoneNumber {
    /// Creates a new builder-style object to manufacture [`DeletePhoneNumberInput`](crate::input::DeletePhoneNumberInput)
    pub fn builder() -> crate::input::delete_phone_number_input::Builder {
        crate::input::delete_phone_number_input::Builder::default()
    }
    /// Creates a new `DeletePhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePhoneNumber {
    type Output = std::result::Result<
        crate::output::DeletePhoneNumberOutput,
        crate::error::DeletePhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_phone_number_error(response)
        } else {
            crate::operation_deser::parse_delete_phone_number_response(response)
        }
    }
}

/// Operation shape for `DeleteProxySession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_proxy_session`](crate::client::Client::delete_proxy_session).
///
/// See [`crate::client::fluent_builders::DeleteProxySession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProxySession {
    _private: (),
}
impl DeleteProxySession {
    /// Creates a new builder-style object to manufacture [`DeleteProxySessionInput`](crate::input::DeleteProxySessionInput)
    pub fn builder() -> crate::input::delete_proxy_session_input::Builder {
        crate::input::delete_proxy_session_input::Builder::default()
    }
    /// Creates a new `DeleteProxySession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProxySession {
    type Output = std::result::Result<
        crate::output::DeleteProxySessionOutput,
        crate::error::DeleteProxySessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_proxy_session_error(response)
        } else {
            crate::operation_deser::parse_delete_proxy_session_response(response)
        }
    }
}

/// Operation shape for `DeleteRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_room`](crate::client::Client::delete_room).
///
/// See [`crate::client::fluent_builders::DeleteRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoom {
    _private: (),
}
impl DeleteRoom {
    /// Creates a new builder-style object to manufacture [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    pub fn builder() -> crate::input::delete_room_input::Builder {
        crate::input::delete_room_input::Builder::default()
    }
    /// Creates a new `DeleteRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoom {
    type Output =
        std::result::Result<crate::output::DeleteRoomOutput, crate::error::DeleteRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_room_error(response)
        } else {
            crate::operation_deser::parse_delete_room_response(response)
        }
    }
}

/// Operation shape for `DeleteRoomMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_room_membership`](crate::client::Client::delete_room_membership).
///
/// See [`crate::client::fluent_builders::DeleteRoomMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoomMembership {
    _private: (),
}
impl DeleteRoomMembership {
    /// Creates a new builder-style object to manufacture [`DeleteRoomMembershipInput`](crate::input::DeleteRoomMembershipInput)
    pub fn builder() -> crate::input::delete_room_membership_input::Builder {
        crate::input::delete_room_membership_input::Builder::default()
    }
    /// Creates a new `DeleteRoomMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoomMembership {
    type Output = std::result::Result<
        crate::output::DeleteRoomMembershipOutput,
        crate::error::DeleteRoomMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_room_membership_error(response)
        } else {
            crate::operation_deser::parse_delete_room_membership_response(response)
        }
    }
}

/// Operation shape for `DeleteSipMediaApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_sip_media_application`](crate::client::Client::delete_sip_media_application).
///
/// See [`crate::client::fluent_builders::DeleteSipMediaApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSipMediaApplication {
    _private: (),
}
impl DeleteSipMediaApplication {
    /// Creates a new builder-style object to manufacture [`DeleteSipMediaApplicationInput`](crate::input::DeleteSipMediaApplicationInput)
    pub fn builder() -> crate::input::delete_sip_media_application_input::Builder {
        crate::input::delete_sip_media_application_input::Builder::default()
    }
    /// Creates a new `DeleteSipMediaApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSipMediaApplication {
    type Output = std::result::Result<
        crate::output::DeleteSipMediaApplicationOutput,
        crate::error::DeleteSipMediaApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_sip_media_application_error(response)
        } else {
            crate::operation_deser::parse_delete_sip_media_application_response(response)
        }
    }
}

/// Operation shape for `DeleteSipRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_sip_rule`](crate::client::Client::delete_sip_rule).
///
/// See [`crate::client::fluent_builders::DeleteSipRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSipRule {
    _private: (),
}
impl DeleteSipRule {
    /// Creates a new builder-style object to manufacture [`DeleteSipRuleInput`](crate::input::DeleteSipRuleInput)
    pub fn builder() -> crate::input::delete_sip_rule_input::Builder {
        crate::input::delete_sip_rule_input::Builder::default()
    }
    /// Creates a new `DeleteSipRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSipRule {
    type Output =
        std::result::Result<crate::output::DeleteSipRuleOutput, crate::error::DeleteSipRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_sip_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_sip_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector`](crate::client::Client::delete_voice_connector).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnector {
    _private: (),
}
impl DeleteVoiceConnector {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorInput`](crate::input::DeleteVoiceConnectorInput)
    pub fn builder() -> crate::input::delete_voice_connector_input::Builder {
        crate::input::delete_voice_connector_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceConnector {
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorOutput,
        crate::error::DeleteVoiceConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_connector_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceConnectorEmergencyCallingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector_emergency_calling_configuration`](crate::client::Client::delete_voice_connector_emergency_calling_configuration).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnectorEmergencyCallingConfiguration {
    _private: (),
}
impl DeleteVoiceConnectorEmergencyCallingConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInput)
    pub fn builder(
    ) -> crate::input::delete_voice_connector_emergency_calling_configuration_input::Builder {
        crate::input::delete_voice_connector_emergency_calling_configuration_input::Builder::default(
        )
    }
    /// Creates a new `DeleteVoiceConnectorEmergencyCallingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DeleteVoiceConnectorEmergencyCallingConfiguration
{
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorEmergencyCallingConfigurationOutput,
        crate::error::DeleteVoiceConnectorEmergencyCallingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_emergency_calling_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_connector_emergency_calling_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceConnectorGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector_group`](crate::client::Client::delete_voice_connector_group).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnectorGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnectorGroup {
    _private: (),
}
impl DeleteVoiceConnectorGroup {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorGroupInput`](crate::input::DeleteVoiceConnectorGroupInput)
    pub fn builder() -> crate::input::delete_voice_connector_group_input::Builder {
        crate::input::delete_voice_connector_group_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceConnectorGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceConnectorGroup {
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorGroupOutput,
        crate::error::DeleteVoiceConnectorGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_group_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_connector_group_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceConnectorOrigination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector_origination`](crate::client::Client::delete_voice_connector_origination).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnectorOrigination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnectorOrigination {
    _private: (),
}
impl DeleteVoiceConnectorOrigination {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorOriginationInput`](crate::input::DeleteVoiceConnectorOriginationInput)
    pub fn builder() -> crate::input::delete_voice_connector_origination_input::Builder {
        crate::input::delete_voice_connector_origination_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceConnectorOrigination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceConnectorOrigination {
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorOriginationOutput,
        crate::error::DeleteVoiceConnectorOriginationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_origination_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_connector_origination_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceConnectorProxy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector_proxy`](crate::client::Client::delete_voice_connector_proxy).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnectorProxy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnectorProxy {
    _private: (),
}
impl DeleteVoiceConnectorProxy {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorProxyInput`](crate::input::DeleteVoiceConnectorProxyInput)
    pub fn builder() -> crate::input::delete_voice_connector_proxy_input::Builder {
        crate::input::delete_voice_connector_proxy_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceConnectorProxy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceConnectorProxy {
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorProxyOutput,
        crate::error::DeleteVoiceConnectorProxyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_proxy_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_connector_proxy_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceConnectorStreamingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector_streaming_configuration`](crate::client::Client::delete_voice_connector_streaming_configuration).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnectorStreamingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnectorStreamingConfiguration {
    _private: (),
}
impl DeleteVoiceConnectorStreamingConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorStreamingConfigurationInput`](crate::input::DeleteVoiceConnectorStreamingConfigurationInput)
    pub fn builder() -> crate::input::delete_voice_connector_streaming_configuration_input::Builder
    {
        crate::input::delete_voice_connector_streaming_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceConnectorStreamingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceConnectorStreamingConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorStreamingConfigurationOutput,
        crate::error::DeleteVoiceConnectorStreamingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_streaming_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_voice_connector_streaming_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteVoiceConnectorTermination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector_termination`](crate::client::Client::delete_voice_connector_termination).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnectorTermination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnectorTermination {
    _private: (),
}
impl DeleteVoiceConnectorTermination {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorTerminationInput`](crate::input::DeleteVoiceConnectorTerminationInput)
    pub fn builder() -> crate::input::delete_voice_connector_termination_input::Builder {
        crate::input::delete_voice_connector_termination_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceConnectorTermination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceConnectorTermination {
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorTerminationOutput,
        crate::error::DeleteVoiceConnectorTerminationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_termination_error(response)
        } else {
            crate::operation_deser::parse_delete_voice_connector_termination_response(response)
        }
    }
}

/// Operation shape for `DeleteVoiceConnectorTerminationCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_voice_connector_termination_credentials`](crate::client::Client::delete_voice_connector_termination_credentials).
///
/// See [`crate::client::fluent_builders::DeleteVoiceConnectorTerminationCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVoiceConnectorTerminationCredentials {
    _private: (),
}
impl DeleteVoiceConnectorTerminationCredentials {
    /// Creates a new builder-style object to manufacture [`DeleteVoiceConnectorTerminationCredentialsInput`](crate::input::DeleteVoiceConnectorTerminationCredentialsInput)
    pub fn builder() -> crate::input::delete_voice_connector_termination_credentials_input::Builder
    {
        crate::input::delete_voice_connector_termination_credentials_input::Builder::default()
    }
    /// Creates a new `DeleteVoiceConnectorTerminationCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVoiceConnectorTerminationCredentials {
    type Output = std::result::Result<
        crate::output::DeleteVoiceConnectorTerminationCredentialsOutput,
        crate::error::DeleteVoiceConnectorTerminationCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_voice_connector_termination_credentials_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_voice_connector_termination_credentials_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeAppInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app_instance`](crate::client::Client::describe_app_instance).
///
/// See [`crate::client::fluent_builders::DescribeAppInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAppInstance {
    _private: (),
}
impl DescribeAppInstance {
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceInput`](crate::input::DescribeAppInstanceInput)
    pub fn builder() -> crate::input::describe_app_instance_input::Builder {
        crate::input::describe_app_instance_input::Builder::default()
    }
    /// Creates a new `DescribeAppInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAppInstance {
    type Output = std::result::Result<
        crate::output::DescribeAppInstanceOutput,
        crate::error::DescribeAppInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_instance_error(response)
        } else {
            crate::operation_deser::parse_describe_app_instance_response(response)
        }
    }
}

/// Operation shape for `DescribeAppInstanceAdmin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app_instance_admin`](crate::client::Client::describe_app_instance_admin).
///
/// See [`crate::client::fluent_builders::DescribeAppInstanceAdmin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAppInstanceAdmin {
    _private: (),
}
impl DescribeAppInstanceAdmin {
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceAdminInput`](crate::input::DescribeAppInstanceAdminInput)
    pub fn builder() -> crate::input::describe_app_instance_admin_input::Builder {
        crate::input::describe_app_instance_admin_input::Builder::default()
    }
    /// Creates a new `DescribeAppInstanceAdmin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAppInstanceAdmin {
    type Output = std::result::Result<
        crate::output::DescribeAppInstanceAdminOutput,
        crate::error::DescribeAppInstanceAdminError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_instance_admin_error(response)
        } else {
            crate::operation_deser::parse_describe_app_instance_admin_response(response)
        }
    }
}

/// Operation shape for `DescribeAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app_instance_user`](crate::client::Client::describe_app_instance_user).
///
/// See [`crate::client::fluent_builders::DescribeAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAppInstanceUser {
    _private: (),
}
impl DescribeAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`DescribeAppInstanceUserInput`](crate::input::DescribeAppInstanceUserInput)
    pub fn builder() -> crate::input::describe_app_instance_user_input::Builder {
        crate::input::describe_app_instance_user_input::Builder::default()
    }
    /// Creates a new `DescribeAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAppInstanceUser {
    type Output = std::result::Result<
        crate::output::DescribeAppInstanceUserOutput,
        crate::error::DescribeAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_instance_user_error(response)
        } else {
            crate::operation_deser::parse_describe_app_instance_user_response(response)
        }
    }
}

/// Operation shape for `DescribeChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel`](crate::client::Client::describe_channel).
///
/// See [`crate::client::fluent_builders::DescribeChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannel {
    _private: (),
}
impl DescribeChannel {
    /// Creates a new builder-style object to manufacture [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    pub fn builder() -> crate::input::describe_channel_input::Builder {
        crate::input::describe_channel_input::Builder::default()
    }
    /// Creates a new `DescribeChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannel {
    type Output = std::result::Result<
        crate::output::DescribeChannelOutput,
        crate::error::DescribeChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_response(response)
        }
    }
}

/// Operation shape for `DescribeChannelBan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_ban`](crate::client::Client::describe_channel_ban).
///
/// See [`crate::client::fluent_builders::DescribeChannelBan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelBan {
    _private: (),
}
impl DescribeChannelBan {
    /// Creates a new builder-style object to manufacture [`DescribeChannelBanInput`](crate::input::DescribeChannelBanInput)
    pub fn builder() -> crate::input::describe_channel_ban_input::Builder {
        crate::input::describe_channel_ban_input::Builder::default()
    }
    /// Creates a new `DescribeChannelBan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelBan {
    type Output = std::result::Result<
        crate::output::DescribeChannelBanOutput,
        crate::error::DescribeChannelBanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_ban_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_ban_response(response)
        }
    }
}

/// Operation shape for `DescribeChannelMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_membership`](crate::client::Client::describe_channel_membership).
///
/// See [`crate::client::fluent_builders::DescribeChannelMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelMembership {
    _private: (),
}
impl DescribeChannelMembership {
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipInput`](crate::input::DescribeChannelMembershipInput)
    pub fn builder() -> crate::input::describe_channel_membership_input::Builder {
        crate::input::describe_channel_membership_input::Builder::default()
    }
    /// Creates a new `DescribeChannelMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelMembership {
    type Output = std::result::Result<
        crate::output::DescribeChannelMembershipOutput,
        crate::error::DescribeChannelMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_membership_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_membership_response(response)
        }
    }
}

/// Operation shape for `DescribeChannelMembershipForAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_membership_for_app_instance_user`](crate::client::Client::describe_channel_membership_for_app_instance_user).
///
/// See [`crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelMembershipForAppInstanceUser {
    _private: (),
}
impl DescribeChannelMembershipForAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`DescribeChannelMembershipForAppInstanceUserInput`](crate::input::DescribeChannelMembershipForAppInstanceUserInput)
    pub fn builder(
    ) -> crate::input::describe_channel_membership_for_app_instance_user_input::Builder {
        crate::input::describe_channel_membership_for_app_instance_user_input::Builder::default()
    }
    /// Creates a new `DescribeChannelMembershipForAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeChannelMembershipForAppInstanceUser
{
    type Output = std::result::Result<
        crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
        crate::error::DescribeChannelMembershipForAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_membership_for_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_channel_membership_for_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeChannelModeratedByAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_moderated_by_app_instance_user`](crate::client::Client::describe_channel_moderated_by_app_instance_user).
///
/// See [`crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelModeratedByAppInstanceUser {
    _private: (),
}
impl DescribeChannelModeratedByAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratedByAppInstanceUserInput`](crate::input::DescribeChannelModeratedByAppInstanceUserInput)
    pub fn builder() -> crate::input::describe_channel_moderated_by_app_instance_user_input::Builder
    {
        crate::input::describe_channel_moderated_by_app_instance_user_input::Builder::default()
    }
    /// Creates a new `DescribeChannelModeratedByAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelModeratedByAppInstanceUser {
    type Output = std::result::Result<
        crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
        crate::error::DescribeChannelModeratedByAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_moderated_by_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_channel_moderated_by_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeChannelModerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel_moderator`](crate::client::Client::describe_channel_moderator).
///
/// See [`crate::client::fluent_builders::DescribeChannelModerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannelModerator {
    _private: (),
}
impl DescribeChannelModerator {
    /// Creates a new builder-style object to manufacture [`DescribeChannelModeratorInput`](crate::input::DescribeChannelModeratorInput)
    pub fn builder() -> crate::input::describe_channel_moderator_input::Builder {
        crate::input::describe_channel_moderator_input::Builder::default()
    }
    /// Creates a new `DescribeChannelModerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannelModerator {
    type Output = std::result::Result<
        crate::output::DescribeChannelModeratorOutput,
        crate::error::DescribeChannelModeratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_moderator_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_moderator_response(response)
        }
    }
}

/// Operation shape for `DisassociatePhoneNumberFromUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_phone_number_from_user`](crate::client::Client::disassociate_phone_number_from_user).
///
/// See [`crate::client::fluent_builders::DisassociatePhoneNumberFromUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociatePhoneNumberFromUser {
    _private: (),
}
impl DisassociatePhoneNumberFromUser {
    /// Creates a new builder-style object to manufacture [`DisassociatePhoneNumberFromUserInput`](crate::input::DisassociatePhoneNumberFromUserInput)
    pub fn builder() -> crate::input::disassociate_phone_number_from_user_input::Builder {
        crate::input::disassociate_phone_number_from_user_input::Builder::default()
    }
    /// Creates a new `DisassociatePhoneNumberFromUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociatePhoneNumberFromUser {
    type Output = std::result::Result<
        crate::output::DisassociatePhoneNumberFromUserOutput,
        crate::error::DisassociatePhoneNumberFromUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_phone_number_from_user_error(response)
        } else {
            crate::operation_deser::parse_disassociate_phone_number_from_user_response(response)
        }
    }
}

/// Operation shape for `DisassociatePhoneNumbersFromVoiceConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_phone_numbers_from_voice_connector`](crate::client::Client::disassociate_phone_numbers_from_voice_connector).
///
/// See [`crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociatePhoneNumbersFromVoiceConnector {
    _private: (),
}
impl DisassociatePhoneNumbersFromVoiceConnector {
    /// Creates a new builder-style object to manufacture [`DisassociatePhoneNumbersFromVoiceConnectorInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorInput)
    pub fn builder() -> crate::input::disassociate_phone_numbers_from_voice_connector_input::Builder
    {
        crate::input::disassociate_phone_numbers_from_voice_connector_input::Builder::default()
    }
    /// Creates a new `DisassociatePhoneNumbersFromVoiceConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociatePhoneNumbersFromVoiceConnector {
    type Output = std::result::Result<
        crate::output::DisassociatePhoneNumbersFromVoiceConnectorOutput,
        crate::error::DisassociatePhoneNumbersFromVoiceConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_phone_numbers_from_voice_connector_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_phone_numbers_from_voice_connector_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociatePhoneNumbersFromVoiceConnectorGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_phone_numbers_from_voice_connector_group`](crate::client::Client::disassociate_phone_numbers_from_voice_connector_group).
///
/// See [`crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociatePhoneNumbersFromVoiceConnectorGroup {
    _private: (),
}
impl DisassociatePhoneNumbersFromVoiceConnectorGroup {
    /// Creates a new builder-style object to manufacture [`DisassociatePhoneNumbersFromVoiceConnectorGroupInput`](crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInput)
    pub fn builder(
    ) -> crate::input::disassociate_phone_numbers_from_voice_connector_group_input::Builder {
        crate::input::disassociate_phone_numbers_from_voice_connector_group_input::Builder::default(
        )
    }
    /// Creates a new `DisassociatePhoneNumbersFromVoiceConnectorGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DisassociatePhoneNumbersFromVoiceConnectorGroup
{
    type Output = std::result::Result<
        crate::output::DisassociatePhoneNumbersFromVoiceConnectorGroupOutput,
        crate::error::DisassociatePhoneNumbersFromVoiceConnectorGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_phone_numbers_from_voice_connector_group_error(response)
        } else {
            crate::operation_deser::parse_disassociate_phone_numbers_from_voice_connector_group_response(response)
        }
    }
}

/// Operation shape for `DisassociateSigninDelegateGroupsFromAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_signin_delegate_groups_from_account`](crate::client::Client::disassociate_signin_delegate_groups_from_account).
///
/// See [`crate::client::fluent_builders::DisassociateSigninDelegateGroupsFromAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateSigninDelegateGroupsFromAccount {
    _private: (),
}
impl DisassociateSigninDelegateGroupsFromAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateSigninDelegateGroupsFromAccountInput`](crate::input::DisassociateSigninDelegateGroupsFromAccountInput)
    pub fn builder() -> crate::input::disassociate_signin_delegate_groups_from_account_input::Builder
    {
        crate::input::disassociate_signin_delegate_groups_from_account_input::Builder::default()
    }
    /// Creates a new `DisassociateSigninDelegateGroupsFromAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DisassociateSigninDelegateGroupsFromAccount
{
    type Output = std::result::Result<
        crate::output::DisassociateSigninDelegateGroupsFromAccountOutput,
        crate::error::DisassociateSigninDelegateGroupsFromAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_signin_delegate_groups_from_account_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_signin_delegate_groups_from_account_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account`](crate::client::Client::get_account).
///
/// See [`crate::client::fluent_builders::GetAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccount {
    _private: (),
}
impl GetAccount {
    /// Creates a new builder-style object to manufacture [`GetAccountInput`](crate::input::GetAccountInput)
    pub fn builder() -> crate::input::get_account_input::Builder {
        crate::input::get_account_input::Builder::default()
    }
    /// Creates a new `GetAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccount {
    type Output =
        std::result::Result<crate::output::GetAccountOutput, crate::error::GetAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_error(response)
        } else {
            crate::operation_deser::parse_get_account_response(response)
        }
    }
}

/// Operation shape for `GetAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_settings`](crate::client::Client::get_account_settings).
///
/// See [`crate::client::fluent_builders::GetAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountSettings {
    _private: (),
}
impl GetAccountSettings {
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
    /// Creates a new `GetAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountSettings {
    type Output = std::result::Result<
        crate::output::GetAccountSettingsOutput,
        crate::error::GetAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_settings_error(response)
        } else {
            crate::operation_deser::parse_get_account_settings_response(response)
        }
    }
}

/// Operation shape for `GetAppInstanceRetentionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app_instance_retention_settings`](crate::client::Client::get_app_instance_retention_settings).
///
/// See [`crate::client::fluent_builders::GetAppInstanceRetentionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppInstanceRetentionSettings {
    _private: (),
}
impl GetAppInstanceRetentionSettings {
    /// Creates a new builder-style object to manufacture [`GetAppInstanceRetentionSettingsInput`](crate::input::GetAppInstanceRetentionSettingsInput)
    pub fn builder() -> crate::input::get_app_instance_retention_settings_input::Builder {
        crate::input::get_app_instance_retention_settings_input::Builder::default()
    }
    /// Creates a new `GetAppInstanceRetentionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppInstanceRetentionSettings {
    type Output = std::result::Result<
        crate::output::GetAppInstanceRetentionSettingsOutput,
        crate::error::GetAppInstanceRetentionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_instance_retention_settings_error(response)
        } else {
            crate::operation_deser::parse_get_app_instance_retention_settings_response(response)
        }
    }
}

/// Operation shape for `GetAppInstanceStreamingConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app_instance_streaming_configurations`](crate::client::Client::get_app_instance_streaming_configurations).
///
/// See [`crate::client::fluent_builders::GetAppInstanceStreamingConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppInstanceStreamingConfigurations {
    _private: (),
}
impl GetAppInstanceStreamingConfigurations {
    /// Creates a new builder-style object to manufacture [`GetAppInstanceStreamingConfigurationsInput`](crate::input::GetAppInstanceStreamingConfigurationsInput)
    pub fn builder() -> crate::input::get_app_instance_streaming_configurations_input::Builder {
        crate::input::get_app_instance_streaming_configurations_input::Builder::default()
    }
    /// Creates a new `GetAppInstanceStreamingConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppInstanceStreamingConfigurations {
    type Output = std::result::Result<
        crate::output::GetAppInstanceStreamingConfigurationsOutput,
        crate::error::GetAppInstanceStreamingConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_instance_streaming_configurations_error(response)
        } else {
            crate::operation_deser::parse_get_app_instance_streaming_configurations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_attendee`](crate::client::Client::get_attendee).
///
/// See [`crate::client::fluent_builders::GetAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAttendee {
    _private: (),
}
impl GetAttendee {
    /// Creates a new builder-style object to manufacture [`GetAttendeeInput`](crate::input::GetAttendeeInput)
    pub fn builder() -> crate::input::get_attendee_input::Builder {
        crate::input::get_attendee_input::Builder::default()
    }
    /// Creates a new `GetAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAttendee {
    type Output =
        std::result::Result<crate::output::GetAttendeeOutput, crate::error::GetAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_attendee_error(response)
        } else {
            crate::operation_deser::parse_get_attendee_response(response)
        }
    }
}

/// Operation shape for `GetBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bot`](crate::client::Client::get_bot).
///
/// See [`crate::client::fluent_builders::GetBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBot {
    _private: (),
}
impl GetBot {
    /// Creates a new builder-style object to manufacture [`GetBotInput`](crate::input::GetBotInput)
    pub fn builder() -> crate::input::get_bot_input::Builder {
        crate::input::get_bot_input::Builder::default()
    }
    /// Creates a new `GetBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBot {
    type Output = std::result::Result<crate::output::GetBotOutput, crate::error::GetBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bot_error(response)
        } else {
            crate::operation_deser::parse_get_bot_response(response)
        }
    }
}

/// Operation shape for `GetChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_channel_message`](crate::client::Client::get_channel_message).
///
/// See [`crate::client::fluent_builders::GetChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChannelMessage {
    _private: (),
}
impl GetChannelMessage {
    /// Creates a new builder-style object to manufacture [`GetChannelMessageInput`](crate::input::GetChannelMessageInput)
    pub fn builder() -> crate::input::get_channel_message_input::Builder {
        crate::input::get_channel_message_input::Builder::default()
    }
    /// Creates a new `GetChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChannelMessage {
    type Output = std::result::Result<
        crate::output::GetChannelMessageOutput,
        crate::error::GetChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_channel_message_error(response)
        } else {
            crate::operation_deser::parse_get_channel_message_response(response)
        }
    }
}

/// Operation shape for `GetEventsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_events_configuration`](crate::client::Client::get_events_configuration).
///
/// See [`crate::client::fluent_builders::GetEventsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEventsConfiguration {
    _private: (),
}
impl GetEventsConfiguration {
    /// Creates a new builder-style object to manufacture [`GetEventsConfigurationInput`](crate::input::GetEventsConfigurationInput)
    pub fn builder() -> crate::input::get_events_configuration_input::Builder {
        crate::input::get_events_configuration_input::Builder::default()
    }
    /// Creates a new `GetEventsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEventsConfiguration {
    type Output = std::result::Result<
        crate::output::GetEventsConfigurationOutput,
        crate::error::GetEventsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_events_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_events_configuration_response(response)
        }
    }
}

/// Operation shape for `GetGlobalSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_global_settings`](crate::client::Client::get_global_settings).
///
/// See [`crate::client::fluent_builders::GetGlobalSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGlobalSettings {
    _private: (),
}
impl GetGlobalSettings {
    /// Creates a new builder-style object to manufacture [`GetGlobalSettingsInput`](crate::input::GetGlobalSettingsInput)
    pub fn builder() -> crate::input::get_global_settings_input::Builder {
        crate::input::get_global_settings_input::Builder::default()
    }
    /// Creates a new `GetGlobalSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGlobalSettings {
    type Output = std::result::Result<
        crate::output::GetGlobalSettingsOutput,
        crate::error::GetGlobalSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_global_settings_error(response)
        } else {
            crate::operation_deser::parse_get_global_settings_response(response)
        }
    }
}

/// Operation shape for `GetMediaCapturePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_media_capture_pipeline`](crate::client::Client::get_media_capture_pipeline).
///
/// See [`crate::client::fluent_builders::GetMediaCapturePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMediaCapturePipeline {
    _private: (),
}
impl GetMediaCapturePipeline {
    /// Creates a new builder-style object to manufacture [`GetMediaCapturePipelineInput`](crate::input::GetMediaCapturePipelineInput)
    pub fn builder() -> crate::input::get_media_capture_pipeline_input::Builder {
        crate::input::get_media_capture_pipeline_input::Builder::default()
    }
    /// Creates a new `GetMediaCapturePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMediaCapturePipeline {
    type Output = std::result::Result<
        crate::output::GetMediaCapturePipelineOutput,
        crate::error::GetMediaCapturePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_media_capture_pipeline_error(response)
        } else {
            crate::operation_deser::parse_get_media_capture_pipeline_response(response)
        }
    }
}

/// Operation shape for `GetMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_meeting`](crate::client::Client::get_meeting).
///
/// See [`crate::client::fluent_builders::GetMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMeeting {
    _private: (),
}
impl GetMeeting {
    /// Creates a new builder-style object to manufacture [`GetMeetingInput`](crate::input::GetMeetingInput)
    pub fn builder() -> crate::input::get_meeting_input::Builder {
        crate::input::get_meeting_input::Builder::default()
    }
    /// Creates a new `GetMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMeeting {
    type Output =
        std::result::Result<crate::output::GetMeetingOutput, crate::error::GetMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_meeting_error(response)
        } else {
            crate::operation_deser::parse_get_meeting_response(response)
        }
    }
}

/// Operation shape for `GetMessagingSessionEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_messaging_session_endpoint`](crate::client::Client::get_messaging_session_endpoint).
///
/// See [`crate::client::fluent_builders::GetMessagingSessionEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMessagingSessionEndpoint {
    _private: (),
}
impl GetMessagingSessionEndpoint {
    /// Creates a new builder-style object to manufacture [`GetMessagingSessionEndpointInput`](crate::input::GetMessagingSessionEndpointInput)
    pub fn builder() -> crate::input::get_messaging_session_endpoint_input::Builder {
        crate::input::get_messaging_session_endpoint_input::Builder::default()
    }
    /// Creates a new `GetMessagingSessionEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMessagingSessionEndpoint {
    type Output = std::result::Result<
        crate::output::GetMessagingSessionEndpointOutput,
        crate::error::GetMessagingSessionEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_messaging_session_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_messaging_session_endpoint_response(response)
        }
    }
}

/// Operation shape for `GetPhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_phone_number`](crate::client::Client::get_phone_number).
///
/// See [`crate::client::fluent_builders::GetPhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPhoneNumber {
    _private: (),
}
impl GetPhoneNumber {
    /// Creates a new builder-style object to manufacture [`GetPhoneNumberInput`](crate::input::GetPhoneNumberInput)
    pub fn builder() -> crate::input::get_phone_number_input::Builder {
        crate::input::get_phone_number_input::Builder::default()
    }
    /// Creates a new `GetPhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPhoneNumber {
    type Output =
        std::result::Result<crate::output::GetPhoneNumberOutput, crate::error::GetPhoneNumberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_phone_number_error(response)
        } else {
            crate::operation_deser::parse_get_phone_number_response(response)
        }
    }
}

/// Operation shape for `GetPhoneNumberOrder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_phone_number_order`](crate::client::Client::get_phone_number_order).
///
/// See [`crate::client::fluent_builders::GetPhoneNumberOrder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPhoneNumberOrder {
    _private: (),
}
impl GetPhoneNumberOrder {
    /// Creates a new builder-style object to manufacture [`GetPhoneNumberOrderInput`](crate::input::GetPhoneNumberOrderInput)
    pub fn builder() -> crate::input::get_phone_number_order_input::Builder {
        crate::input::get_phone_number_order_input::Builder::default()
    }
    /// Creates a new `GetPhoneNumberOrder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPhoneNumberOrder {
    type Output = std::result::Result<
        crate::output::GetPhoneNumberOrderOutput,
        crate::error::GetPhoneNumberOrderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_phone_number_order_error(response)
        } else {
            crate::operation_deser::parse_get_phone_number_order_response(response)
        }
    }
}

/// Operation shape for `GetPhoneNumberSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_phone_number_settings`](crate::client::Client::get_phone_number_settings).
///
/// See [`crate::client::fluent_builders::GetPhoneNumberSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPhoneNumberSettings {
    _private: (),
}
impl GetPhoneNumberSettings {
    /// Creates a new builder-style object to manufacture [`GetPhoneNumberSettingsInput`](crate::input::GetPhoneNumberSettingsInput)
    pub fn builder() -> crate::input::get_phone_number_settings_input::Builder {
        crate::input::get_phone_number_settings_input::Builder::default()
    }
    /// Creates a new `GetPhoneNumberSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPhoneNumberSettings {
    type Output = std::result::Result<
        crate::output::GetPhoneNumberSettingsOutput,
        crate::error::GetPhoneNumberSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_phone_number_settings_error(response)
        } else {
            crate::operation_deser::parse_get_phone_number_settings_response(response)
        }
    }
}

/// Operation shape for `GetProxySession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_proxy_session`](crate::client::Client::get_proxy_session).
///
/// See [`crate::client::fluent_builders::GetProxySession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProxySession {
    _private: (),
}
impl GetProxySession {
    /// Creates a new builder-style object to manufacture [`GetProxySessionInput`](crate::input::GetProxySessionInput)
    pub fn builder() -> crate::input::get_proxy_session_input::Builder {
        crate::input::get_proxy_session_input::Builder::default()
    }
    /// Creates a new `GetProxySession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProxySession {
    type Output = std::result::Result<
        crate::output::GetProxySessionOutput,
        crate::error::GetProxySessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_proxy_session_error(response)
        } else {
            crate::operation_deser::parse_get_proxy_session_response(response)
        }
    }
}

/// Operation shape for `GetRetentionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_retention_settings`](crate::client::Client::get_retention_settings).
///
/// See [`crate::client::fluent_builders::GetRetentionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRetentionSettings {
    _private: (),
}
impl GetRetentionSettings {
    /// Creates a new builder-style object to manufacture [`GetRetentionSettingsInput`](crate::input::GetRetentionSettingsInput)
    pub fn builder() -> crate::input::get_retention_settings_input::Builder {
        crate::input::get_retention_settings_input::Builder::default()
    }
    /// Creates a new `GetRetentionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRetentionSettings {
    type Output = std::result::Result<
        crate::output::GetRetentionSettingsOutput,
        crate::error::GetRetentionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_retention_settings_error(response)
        } else {
            crate::operation_deser::parse_get_retention_settings_response(response)
        }
    }
}

/// Operation shape for `GetRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_room`](crate::client::Client::get_room).
///
/// See [`crate::client::fluent_builders::GetRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRoom {
    _private: (),
}
impl GetRoom {
    /// Creates a new builder-style object to manufacture [`GetRoomInput`](crate::input::GetRoomInput)
    pub fn builder() -> crate::input::get_room_input::Builder {
        crate::input::get_room_input::Builder::default()
    }
    /// Creates a new `GetRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRoom {
    type Output = std::result::Result<crate::output::GetRoomOutput, crate::error::GetRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_room_error(response)
        } else {
            crate::operation_deser::parse_get_room_response(response)
        }
    }
}

/// Operation shape for `GetSipMediaApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sip_media_application`](crate::client::Client::get_sip_media_application).
///
/// See [`crate::client::fluent_builders::GetSipMediaApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSipMediaApplication {
    _private: (),
}
impl GetSipMediaApplication {
    /// Creates a new builder-style object to manufacture [`GetSipMediaApplicationInput`](crate::input::GetSipMediaApplicationInput)
    pub fn builder() -> crate::input::get_sip_media_application_input::Builder {
        crate::input::get_sip_media_application_input::Builder::default()
    }
    /// Creates a new `GetSipMediaApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSipMediaApplication {
    type Output = std::result::Result<
        crate::output::GetSipMediaApplicationOutput,
        crate::error::GetSipMediaApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sip_media_application_error(response)
        } else {
            crate::operation_deser::parse_get_sip_media_application_response(response)
        }
    }
}

/// Operation shape for `GetSipMediaApplicationLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sip_media_application_logging_configuration`](crate::client::Client::get_sip_media_application_logging_configuration).
///
/// See [`crate::client::fluent_builders::GetSipMediaApplicationLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSipMediaApplicationLoggingConfiguration {
    _private: (),
}
impl GetSipMediaApplicationLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`GetSipMediaApplicationLoggingConfigurationInput`](crate::input::GetSipMediaApplicationLoggingConfigurationInput)
    pub fn builder() -> crate::input::get_sip_media_application_logging_configuration_input::Builder
    {
        crate::input::get_sip_media_application_logging_configuration_input::Builder::default()
    }
    /// Creates a new `GetSipMediaApplicationLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSipMediaApplicationLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::GetSipMediaApplicationLoggingConfigurationOutput,
        crate::error::GetSipMediaApplicationLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sip_media_application_logging_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_sip_media_application_logging_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetSipRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sip_rule`](crate::client::Client::get_sip_rule).
///
/// See [`crate::client::fluent_builders::GetSipRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSipRule {
    _private: (),
}
impl GetSipRule {
    /// Creates a new builder-style object to manufacture [`GetSipRuleInput`](crate::input::GetSipRuleInput)
    pub fn builder() -> crate::input::get_sip_rule_input::Builder {
        crate::input::get_sip_rule_input::Builder::default()
    }
    /// Creates a new `GetSipRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSipRule {
    type Output =
        std::result::Result<crate::output::GetSipRuleOutput, crate::error::GetSipRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sip_rule_error(response)
        } else {
            crate::operation_deser::parse_get_sip_rule_response(response)
        }
    }
}

/// Operation shape for `GetUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user`](crate::client::Client::get_user).
///
/// See [`crate::client::fluent_builders::GetUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUser {
    _private: (),
}
impl GetUser {
    /// Creates a new builder-style object to manufacture [`GetUserInput`](crate::input::GetUserInput)
    pub fn builder() -> crate::input::get_user_input::Builder {
        crate::input::get_user_input::Builder::default()
    }
    /// Creates a new `GetUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUser {
    type Output = std::result::Result<crate::output::GetUserOutput, crate::error::GetUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_error(response)
        } else {
            crate::operation_deser::parse_get_user_response(response)
        }
    }
}

/// Operation shape for `GetUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user_settings`](crate::client::Client::get_user_settings).
///
/// See [`crate::client::fluent_builders::GetUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUserSettings {
    _private: (),
}
impl GetUserSettings {
    /// Creates a new builder-style object to manufacture [`GetUserSettingsInput`](crate::input::GetUserSettingsInput)
    pub fn builder() -> crate::input::get_user_settings_input::Builder {
        crate::input::get_user_settings_input::Builder::default()
    }
    /// Creates a new `GetUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUserSettings {
    type Output = std::result::Result<
        crate::output::GetUserSettingsOutput,
        crate::error::GetUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_settings_error(response)
        } else {
            crate::operation_deser::parse_get_user_settings_response(response)
        }
    }
}

/// Operation shape for `GetVoiceConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector`](crate::client::Client::get_voice_connector).
///
/// See [`crate::client::fluent_builders::GetVoiceConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnector {
    _private: (),
}
impl GetVoiceConnector {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorInput`](crate::input::GetVoiceConnectorInput)
    pub fn builder() -> crate::input::get_voice_connector_input::Builder {
        crate::input::get_voice_connector_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnector {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorOutput,
        crate::error::GetVoiceConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_error(response)
        } else {
            crate::operation_deser::parse_get_voice_connector_response(response)
        }
    }
}

/// Operation shape for `GetVoiceConnectorEmergencyCallingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_emergency_calling_configuration`](crate::client::Client::get_voice_connector_emergency_calling_configuration).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorEmergencyCallingConfiguration {
    _private: (),
}
impl GetVoiceConnectorEmergencyCallingConfiguration {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::GetVoiceConnectorEmergencyCallingConfigurationInput)
    pub fn builder(
    ) -> crate::input::get_voice_connector_emergency_calling_configuration_input::Builder {
        crate::input::get_voice_connector_emergency_calling_configuration_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorEmergencyCallingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for GetVoiceConnectorEmergencyCallingConfiguration
{
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorEmergencyCallingConfigurationOutput,
        crate::error::GetVoiceConnectorEmergencyCallingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_emergency_calling_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_voice_connector_emergency_calling_configuration_response(response)
        }
    }
}

/// Operation shape for `GetVoiceConnectorGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_group`](crate::client::Client::get_voice_connector_group).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorGroup {
    _private: (),
}
impl GetVoiceConnectorGroup {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorGroupInput`](crate::input::GetVoiceConnectorGroupInput)
    pub fn builder() -> crate::input::get_voice_connector_group_input::Builder {
        crate::input::get_voice_connector_group_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnectorGroup {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorGroupOutput,
        crate::error::GetVoiceConnectorGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_group_error(response)
        } else {
            crate::operation_deser::parse_get_voice_connector_group_response(response)
        }
    }
}

/// Operation shape for `GetVoiceConnectorLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_logging_configuration`](crate::client::Client::get_voice_connector_logging_configuration).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorLoggingConfiguration {
    _private: (),
}
impl GetVoiceConnectorLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorLoggingConfigurationInput`](crate::input::GetVoiceConnectorLoggingConfigurationInput)
    pub fn builder() -> crate::input::get_voice_connector_logging_configuration_input::Builder {
        crate::input::get_voice_connector_logging_configuration_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnectorLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorLoggingConfigurationOutput,
        crate::error::GetVoiceConnectorLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_voice_connector_logging_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetVoiceConnectorOrigination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_origination`](crate::client::Client::get_voice_connector_origination).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorOrigination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorOrigination {
    _private: (),
}
impl GetVoiceConnectorOrigination {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorOriginationInput`](crate::input::GetVoiceConnectorOriginationInput)
    pub fn builder() -> crate::input::get_voice_connector_origination_input::Builder {
        crate::input::get_voice_connector_origination_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorOrigination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnectorOrigination {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorOriginationOutput,
        crate::error::GetVoiceConnectorOriginationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_origination_error(response)
        } else {
            crate::operation_deser::parse_get_voice_connector_origination_response(response)
        }
    }
}

/// Operation shape for `GetVoiceConnectorProxy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_proxy`](crate::client::Client::get_voice_connector_proxy).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorProxy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorProxy {
    _private: (),
}
impl GetVoiceConnectorProxy {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorProxyInput`](crate::input::GetVoiceConnectorProxyInput)
    pub fn builder() -> crate::input::get_voice_connector_proxy_input::Builder {
        crate::input::get_voice_connector_proxy_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorProxy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnectorProxy {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorProxyOutput,
        crate::error::GetVoiceConnectorProxyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_proxy_error(response)
        } else {
            crate::operation_deser::parse_get_voice_connector_proxy_response(response)
        }
    }
}

/// Operation shape for `GetVoiceConnectorStreamingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_streaming_configuration`](crate::client::Client::get_voice_connector_streaming_configuration).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorStreamingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorStreamingConfiguration {
    _private: (),
}
impl GetVoiceConnectorStreamingConfiguration {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorStreamingConfigurationInput`](crate::input::GetVoiceConnectorStreamingConfigurationInput)
    pub fn builder() -> crate::input::get_voice_connector_streaming_configuration_input::Builder {
        crate::input::get_voice_connector_streaming_configuration_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorStreamingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnectorStreamingConfiguration {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorStreamingConfigurationOutput,
        crate::error::GetVoiceConnectorStreamingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_streaming_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_voice_connector_streaming_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetVoiceConnectorTermination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_termination`](crate::client::Client::get_voice_connector_termination).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorTermination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorTermination {
    _private: (),
}
impl GetVoiceConnectorTermination {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorTerminationInput`](crate::input::GetVoiceConnectorTerminationInput)
    pub fn builder() -> crate::input::get_voice_connector_termination_input::Builder {
        crate::input::get_voice_connector_termination_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorTermination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnectorTermination {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorTerminationOutput,
        crate::error::GetVoiceConnectorTerminationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_termination_error(response)
        } else {
            crate::operation_deser::parse_get_voice_connector_termination_response(response)
        }
    }
}

/// Operation shape for `GetVoiceConnectorTerminationHealth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_voice_connector_termination_health`](crate::client::Client::get_voice_connector_termination_health).
///
/// See [`crate::client::fluent_builders::GetVoiceConnectorTerminationHealth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVoiceConnectorTerminationHealth {
    _private: (),
}
impl GetVoiceConnectorTerminationHealth {
    /// Creates a new builder-style object to manufacture [`GetVoiceConnectorTerminationHealthInput`](crate::input::GetVoiceConnectorTerminationHealthInput)
    pub fn builder() -> crate::input::get_voice_connector_termination_health_input::Builder {
        crate::input::get_voice_connector_termination_health_input::Builder::default()
    }
    /// Creates a new `GetVoiceConnectorTerminationHealth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVoiceConnectorTerminationHealth {
    type Output = std::result::Result<
        crate::output::GetVoiceConnectorTerminationHealthOutput,
        crate::error::GetVoiceConnectorTerminationHealthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_voice_connector_termination_health_error(response)
        } else {
            crate::operation_deser::parse_get_voice_connector_termination_health_response(response)
        }
    }
}

/// Operation shape for `InviteUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invite_users`](crate::client::Client::invite_users).
///
/// See [`crate::client::fluent_builders::InviteUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InviteUsers {
    _private: (),
}
impl InviteUsers {
    /// Creates a new builder-style object to manufacture [`InviteUsersInput`](crate::input::InviteUsersInput)
    pub fn builder() -> crate::input::invite_users_input::Builder {
        crate::input::invite_users_input::Builder::default()
    }
    /// Creates a new `InviteUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InviteUsers {
    type Output =
        std::result::Result<crate::output::InviteUsersOutput, crate::error::InviteUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_invite_users_error(response)
        } else {
            crate::operation_deser::parse_invite_users_response(response)
        }
    }
}

/// Operation shape for `ListAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_accounts`](crate::client::Client::list_accounts).
///
/// See [`crate::client::fluent_builders::ListAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccounts {
    _private: (),
}
impl ListAccounts {
    /// Creates a new builder-style object to manufacture [`ListAccountsInput`](crate::input::ListAccountsInput)
    pub fn builder() -> crate::input::list_accounts_input::Builder {
        crate::input::list_accounts_input::Builder::default()
    }
    /// Creates a new `ListAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccounts {
    type Output =
        std::result::Result<crate::output::ListAccountsOutput, crate::error::ListAccountsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_accounts_response(response)
        }
    }
}

/// Operation shape for `ListAppInstanceAdmins`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_instance_admins`](crate::client::Client::list_app_instance_admins).
///
/// See [`crate::client::fluent_builders::ListAppInstanceAdmins`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppInstanceAdmins {
    _private: (),
}
impl ListAppInstanceAdmins {
    /// Creates a new builder-style object to manufacture [`ListAppInstanceAdminsInput`](crate::input::ListAppInstanceAdminsInput)
    pub fn builder() -> crate::input::list_app_instance_admins_input::Builder {
        crate::input::list_app_instance_admins_input::Builder::default()
    }
    /// Creates a new `ListAppInstanceAdmins` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppInstanceAdmins {
    type Output = std::result::Result<
        crate::output::ListAppInstanceAdminsOutput,
        crate::error::ListAppInstanceAdminsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_instance_admins_error(response)
        } else {
            crate::operation_deser::parse_list_app_instance_admins_response(response)
        }
    }
}

/// Operation shape for `ListAppInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_instances`](crate::client::Client::list_app_instances).
///
/// See [`crate::client::fluent_builders::ListAppInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppInstances {
    _private: (),
}
impl ListAppInstances {
    /// Creates a new builder-style object to manufacture [`ListAppInstancesInput`](crate::input::ListAppInstancesInput)
    pub fn builder() -> crate::input::list_app_instances_input::Builder {
        crate::input::list_app_instances_input::Builder::default()
    }
    /// Creates a new `ListAppInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppInstances {
    type Output = std::result::Result<
        crate::output::ListAppInstancesOutput,
        crate::error::ListAppInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_instances_error(response)
        } else {
            crate::operation_deser::parse_list_app_instances_response(response)
        }
    }
}

/// Operation shape for `ListAppInstanceUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_instance_users`](crate::client::Client::list_app_instance_users).
///
/// See [`crate::client::fluent_builders::ListAppInstanceUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppInstanceUsers {
    _private: (),
}
impl ListAppInstanceUsers {
    /// Creates a new builder-style object to manufacture [`ListAppInstanceUsersInput`](crate::input::ListAppInstanceUsersInput)
    pub fn builder() -> crate::input::list_app_instance_users_input::Builder {
        crate::input::list_app_instance_users_input::Builder::default()
    }
    /// Creates a new `ListAppInstanceUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppInstanceUsers {
    type Output = std::result::Result<
        crate::output::ListAppInstanceUsersOutput,
        crate::error::ListAppInstanceUsersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_instance_users_error(response)
        } else {
            crate::operation_deser::parse_list_app_instance_users_response(response)
        }
    }
}

/// Operation shape for `ListAttendees`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attendees`](crate::client::Client::list_attendees).
///
/// See [`crate::client::fluent_builders::ListAttendees`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttendees {
    _private: (),
}
impl ListAttendees {
    /// Creates a new builder-style object to manufacture [`ListAttendeesInput`](crate::input::ListAttendeesInput)
    pub fn builder() -> crate::input::list_attendees_input::Builder {
        crate::input::list_attendees_input::Builder::default()
    }
    /// Creates a new `ListAttendees` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttendees {
    type Output =
        std::result::Result<crate::output::ListAttendeesOutput, crate::error::ListAttendeesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attendees_error(response)
        } else {
            crate::operation_deser::parse_list_attendees_response(response)
        }
    }
}

/// Operation shape for `ListAttendeeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attendee_tags`](crate::client::Client::list_attendee_tags).
///
/// See [`crate::client::fluent_builders::ListAttendeeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttendeeTags {
    _private: (),
}
impl ListAttendeeTags {
    /// Creates a new builder-style object to manufacture [`ListAttendeeTagsInput`](crate::input::ListAttendeeTagsInput)
    pub fn builder() -> crate::input::list_attendee_tags_input::Builder {
        crate::input::list_attendee_tags_input::Builder::default()
    }
    /// Creates a new `ListAttendeeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttendeeTags {
    type Output = std::result::Result<
        crate::output::ListAttendeeTagsOutput,
        crate::error::ListAttendeeTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attendee_tags_error(response)
        } else {
            crate::operation_deser::parse_list_attendee_tags_response(response)
        }
    }
}

/// Operation shape for `ListBots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bots`](crate::client::Client::list_bots).
///
/// See [`crate::client::fluent_builders::ListBots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBots {
    _private: (),
}
impl ListBots {
    /// Creates a new builder-style object to manufacture [`ListBotsInput`](crate::input::ListBotsInput)
    pub fn builder() -> crate::input::list_bots_input::Builder {
        crate::input::list_bots_input::Builder::default()
    }
    /// Creates a new `ListBots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBots {
    type Output = std::result::Result<crate::output::ListBotsOutput, crate::error::ListBotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bots_error(response)
        } else {
            crate::operation_deser::parse_list_bots_response(response)
        }
    }
}

/// Operation shape for `ListChannelBans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_bans`](crate::client::Client::list_channel_bans).
///
/// See [`crate::client::fluent_builders::ListChannelBans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelBans {
    _private: (),
}
impl ListChannelBans {
    /// Creates a new builder-style object to manufacture [`ListChannelBansInput`](crate::input::ListChannelBansInput)
    pub fn builder() -> crate::input::list_channel_bans_input::Builder {
        crate::input::list_channel_bans_input::Builder::default()
    }
    /// Creates a new `ListChannelBans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelBans {
    type Output = std::result::Result<
        crate::output::ListChannelBansOutput,
        crate::error::ListChannelBansError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_bans_error(response)
        } else {
            crate::operation_deser::parse_list_channel_bans_response(response)
        }
    }
}

/// Operation shape for `ListChannelMemberships`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_memberships`](crate::client::Client::list_channel_memberships).
///
/// See [`crate::client::fluent_builders::ListChannelMemberships`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelMemberships {
    _private: (),
}
impl ListChannelMemberships {
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsInput`](crate::input::ListChannelMembershipsInput)
    pub fn builder() -> crate::input::list_channel_memberships_input::Builder {
        crate::input::list_channel_memberships_input::Builder::default()
    }
    /// Creates a new `ListChannelMemberships` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelMemberships {
    type Output = std::result::Result<
        crate::output::ListChannelMembershipsOutput,
        crate::error::ListChannelMembershipsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_memberships_error(response)
        } else {
            crate::operation_deser::parse_list_channel_memberships_response(response)
        }
    }
}

/// Operation shape for `ListChannelMembershipsForAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_memberships_for_app_instance_user`](crate::client::Client::list_channel_memberships_for_app_instance_user).
///
/// See [`crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelMembershipsForAppInstanceUser {
    _private: (),
}
impl ListChannelMembershipsForAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`ListChannelMembershipsForAppInstanceUserInput`](crate::input::ListChannelMembershipsForAppInstanceUserInput)
    pub fn builder() -> crate::input::list_channel_memberships_for_app_instance_user_input::Builder
    {
        crate::input::list_channel_memberships_for_app_instance_user_input::Builder::default()
    }
    /// Creates a new `ListChannelMembershipsForAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelMembershipsForAppInstanceUser {
    type Output = std::result::Result<
        crate::output::ListChannelMembershipsForAppInstanceUserOutput,
        crate::error::ListChannelMembershipsForAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_memberships_for_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_channel_memberships_for_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListChannelMessages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_messages`](crate::client::Client::list_channel_messages).
///
/// See [`crate::client::fluent_builders::ListChannelMessages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelMessages {
    _private: (),
}
impl ListChannelMessages {
    /// Creates a new builder-style object to manufacture [`ListChannelMessagesInput`](crate::input::ListChannelMessagesInput)
    pub fn builder() -> crate::input::list_channel_messages_input::Builder {
        crate::input::list_channel_messages_input::Builder::default()
    }
    /// Creates a new `ListChannelMessages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelMessages {
    type Output = std::result::Result<
        crate::output::ListChannelMessagesOutput,
        crate::error::ListChannelMessagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_messages_error(response)
        } else {
            crate::operation_deser::parse_list_channel_messages_response(response)
        }
    }
}

/// Operation shape for `ListChannelModerators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channel_moderators`](crate::client::Client::list_channel_moderators).
///
/// See [`crate::client::fluent_builders::ListChannelModerators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelModerators {
    _private: (),
}
impl ListChannelModerators {
    /// Creates a new builder-style object to manufacture [`ListChannelModeratorsInput`](crate::input::ListChannelModeratorsInput)
    pub fn builder() -> crate::input::list_channel_moderators_input::Builder {
        crate::input::list_channel_moderators_input::Builder::default()
    }
    /// Creates a new `ListChannelModerators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelModerators {
    type Output = std::result::Result<
        crate::output::ListChannelModeratorsOutput,
        crate::error::ListChannelModeratorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channel_moderators_error(response)
        } else {
            crate::operation_deser::parse_list_channel_moderators_response(response)
        }
    }
}

/// Operation shape for `ListChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channels`](crate::client::Client::list_channels).
///
/// See [`crate::client::fluent_builders::ListChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannels {
    _private: (),
}
impl ListChannels {
    /// Creates a new builder-style object to manufacture [`ListChannelsInput`](crate::input::ListChannelsInput)
    pub fn builder() -> crate::input::list_channels_input::Builder {
        crate::input::list_channels_input::Builder::default()
    }
    /// Creates a new `ListChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannels {
    type Output =
        std::result::Result<crate::output::ListChannelsOutput, crate::error::ListChannelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channels_error(response)
        } else {
            crate::operation_deser::parse_list_channels_response(response)
        }
    }
}

/// Operation shape for `ListChannelsModeratedByAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channels_moderated_by_app_instance_user`](crate::client::Client::list_channels_moderated_by_app_instance_user).
///
/// See [`crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannelsModeratedByAppInstanceUser {
    _private: (),
}
impl ListChannelsModeratedByAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`ListChannelsModeratedByAppInstanceUserInput`](crate::input::ListChannelsModeratedByAppInstanceUserInput)
    pub fn builder() -> crate::input::list_channels_moderated_by_app_instance_user_input::Builder {
        crate::input::list_channels_moderated_by_app_instance_user_input::Builder::default()
    }
    /// Creates a new `ListChannelsModeratedByAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannelsModeratedByAppInstanceUser {
    type Output = std::result::Result<
        crate::output::ListChannelsModeratedByAppInstanceUserOutput,
        crate::error::ListChannelsModeratedByAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channels_moderated_by_app_instance_user_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_channels_moderated_by_app_instance_user_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListMediaCapturePipelines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_media_capture_pipelines`](crate::client::Client::list_media_capture_pipelines).
///
/// See [`crate::client::fluent_builders::ListMediaCapturePipelines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMediaCapturePipelines {
    _private: (),
}
impl ListMediaCapturePipelines {
    /// Creates a new builder-style object to manufacture [`ListMediaCapturePipelinesInput`](crate::input::ListMediaCapturePipelinesInput)
    pub fn builder() -> crate::input::list_media_capture_pipelines_input::Builder {
        crate::input::list_media_capture_pipelines_input::Builder::default()
    }
    /// Creates a new `ListMediaCapturePipelines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMediaCapturePipelines {
    type Output = std::result::Result<
        crate::output::ListMediaCapturePipelinesOutput,
        crate::error::ListMediaCapturePipelinesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_media_capture_pipelines_error(response)
        } else {
            crate::operation_deser::parse_list_media_capture_pipelines_response(response)
        }
    }
}

/// Operation shape for `ListMeetings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_meetings`](crate::client::Client::list_meetings).
///
/// See [`crate::client::fluent_builders::ListMeetings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMeetings {
    _private: (),
}
impl ListMeetings {
    /// Creates a new builder-style object to manufacture [`ListMeetingsInput`](crate::input::ListMeetingsInput)
    pub fn builder() -> crate::input::list_meetings_input::Builder {
        crate::input::list_meetings_input::Builder::default()
    }
    /// Creates a new `ListMeetings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMeetings {
    type Output =
        std::result::Result<crate::output::ListMeetingsOutput, crate::error::ListMeetingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_meetings_error(response)
        } else {
            crate::operation_deser::parse_list_meetings_response(response)
        }
    }
}

/// Operation shape for `ListMeetingTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_meeting_tags`](crate::client::Client::list_meeting_tags).
///
/// See [`crate::client::fluent_builders::ListMeetingTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMeetingTags {
    _private: (),
}
impl ListMeetingTags {
    /// Creates a new builder-style object to manufacture [`ListMeetingTagsInput`](crate::input::ListMeetingTagsInput)
    pub fn builder() -> crate::input::list_meeting_tags_input::Builder {
        crate::input::list_meeting_tags_input::Builder::default()
    }
    /// Creates a new `ListMeetingTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMeetingTags {
    type Output = std::result::Result<
        crate::output::ListMeetingTagsOutput,
        crate::error::ListMeetingTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_meeting_tags_error(response)
        } else {
            crate::operation_deser::parse_list_meeting_tags_response(response)
        }
    }
}

/// Operation shape for `ListPhoneNumberOrders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_phone_number_orders`](crate::client::Client::list_phone_number_orders).
///
/// See [`crate::client::fluent_builders::ListPhoneNumberOrders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPhoneNumberOrders {
    _private: (),
}
impl ListPhoneNumberOrders {
    /// Creates a new builder-style object to manufacture [`ListPhoneNumberOrdersInput`](crate::input::ListPhoneNumberOrdersInput)
    pub fn builder() -> crate::input::list_phone_number_orders_input::Builder {
        crate::input::list_phone_number_orders_input::Builder::default()
    }
    /// Creates a new `ListPhoneNumberOrders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPhoneNumberOrders {
    type Output = std::result::Result<
        crate::output::ListPhoneNumberOrdersOutput,
        crate::error::ListPhoneNumberOrdersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_phone_number_orders_error(response)
        } else {
            crate::operation_deser::parse_list_phone_number_orders_response(response)
        }
    }
}

/// Operation shape for `ListPhoneNumbers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_phone_numbers`](crate::client::Client::list_phone_numbers).
///
/// See [`crate::client::fluent_builders::ListPhoneNumbers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPhoneNumbers {
    _private: (),
}
impl ListPhoneNumbers {
    /// Creates a new builder-style object to manufacture [`ListPhoneNumbersInput`](crate::input::ListPhoneNumbersInput)
    pub fn builder() -> crate::input::list_phone_numbers_input::Builder {
        crate::input::list_phone_numbers_input::Builder::default()
    }
    /// Creates a new `ListPhoneNumbers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPhoneNumbers {
    type Output = std::result::Result<
        crate::output::ListPhoneNumbersOutput,
        crate::error::ListPhoneNumbersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_phone_numbers_error(response)
        } else {
            crate::operation_deser::parse_list_phone_numbers_response(response)
        }
    }
}

/// Operation shape for `ListProxySessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_proxy_sessions`](crate::client::Client::list_proxy_sessions).
///
/// See [`crate::client::fluent_builders::ListProxySessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProxySessions {
    _private: (),
}
impl ListProxySessions {
    /// Creates a new builder-style object to manufacture [`ListProxySessionsInput`](crate::input::ListProxySessionsInput)
    pub fn builder() -> crate::input::list_proxy_sessions_input::Builder {
        crate::input::list_proxy_sessions_input::Builder::default()
    }
    /// Creates a new `ListProxySessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProxySessions {
    type Output = std::result::Result<
        crate::output::ListProxySessionsOutput,
        crate::error::ListProxySessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_proxy_sessions_error(response)
        } else {
            crate::operation_deser::parse_list_proxy_sessions_response(response)
        }
    }
}

/// Operation shape for `ListRoomMemberships`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_room_memberships`](crate::client::Client::list_room_memberships).
///
/// See [`crate::client::fluent_builders::ListRoomMemberships`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRoomMemberships {
    _private: (),
}
impl ListRoomMemberships {
    /// Creates a new builder-style object to manufacture [`ListRoomMembershipsInput`](crate::input::ListRoomMembershipsInput)
    pub fn builder() -> crate::input::list_room_memberships_input::Builder {
        crate::input::list_room_memberships_input::Builder::default()
    }
    /// Creates a new `ListRoomMemberships` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRoomMemberships {
    type Output = std::result::Result<
        crate::output::ListRoomMembershipsOutput,
        crate::error::ListRoomMembershipsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_room_memberships_error(response)
        } else {
            crate::operation_deser::parse_list_room_memberships_response(response)
        }
    }
}

/// Operation shape for `ListRooms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rooms`](crate::client::Client::list_rooms).
///
/// See [`crate::client::fluent_builders::ListRooms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRooms {
    _private: (),
}
impl ListRooms {
    /// Creates a new builder-style object to manufacture [`ListRoomsInput`](crate::input::ListRoomsInput)
    pub fn builder() -> crate::input::list_rooms_input::Builder {
        crate::input::list_rooms_input::Builder::default()
    }
    /// Creates a new `ListRooms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRooms {
    type Output = std::result::Result<crate::output::ListRoomsOutput, crate::error::ListRoomsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rooms_error(response)
        } else {
            crate::operation_deser::parse_list_rooms_response(response)
        }
    }
}

/// Operation shape for `ListSipMediaApplications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sip_media_applications`](crate::client::Client::list_sip_media_applications).
///
/// See [`crate::client::fluent_builders::ListSipMediaApplications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSipMediaApplications {
    _private: (),
}
impl ListSipMediaApplications {
    /// Creates a new builder-style object to manufacture [`ListSipMediaApplicationsInput`](crate::input::ListSipMediaApplicationsInput)
    pub fn builder() -> crate::input::list_sip_media_applications_input::Builder {
        crate::input::list_sip_media_applications_input::Builder::default()
    }
    /// Creates a new `ListSipMediaApplications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSipMediaApplications {
    type Output = std::result::Result<
        crate::output::ListSipMediaApplicationsOutput,
        crate::error::ListSipMediaApplicationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sip_media_applications_error(response)
        } else {
            crate::operation_deser::parse_list_sip_media_applications_response(response)
        }
    }
}

/// Operation shape for `ListSipRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sip_rules`](crate::client::Client::list_sip_rules).
///
/// See [`crate::client::fluent_builders::ListSipRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSipRules {
    _private: (),
}
impl ListSipRules {
    /// Creates a new builder-style object to manufacture [`ListSipRulesInput`](crate::input::ListSipRulesInput)
    pub fn builder() -> crate::input::list_sip_rules_input::Builder {
        crate::input::list_sip_rules_input::Builder::default()
    }
    /// Creates a new `ListSipRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSipRules {
    type Output =
        std::result::Result<crate::output::ListSipRulesOutput, crate::error::ListSipRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sip_rules_error(response)
        } else {
            crate::operation_deser::parse_list_sip_rules_response(response)
        }
    }
}

/// Operation shape for `ListSupportedPhoneNumberCountries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_supported_phone_number_countries`](crate::client::Client::list_supported_phone_number_countries).
///
/// See [`crate::client::fluent_builders::ListSupportedPhoneNumberCountries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSupportedPhoneNumberCountries {
    _private: (),
}
impl ListSupportedPhoneNumberCountries {
    /// Creates a new builder-style object to manufacture [`ListSupportedPhoneNumberCountriesInput`](crate::input::ListSupportedPhoneNumberCountriesInput)
    pub fn builder() -> crate::input::list_supported_phone_number_countries_input::Builder {
        crate::input::list_supported_phone_number_countries_input::Builder::default()
    }
    /// Creates a new `ListSupportedPhoneNumberCountries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSupportedPhoneNumberCountries {
    type Output = std::result::Result<
        crate::output::ListSupportedPhoneNumberCountriesOutput,
        crate::error::ListSupportedPhoneNumberCountriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_supported_phone_number_countries_error(response)
        } else {
            crate::operation_deser::parse_list_supported_phone_number_countries_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users`](crate::client::Client::list_users).
///
/// See [`crate::client::fluent_builders::ListUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsers {
    _private: (),
}
impl ListUsers {
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
    /// Creates a new `ListUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsers {
    type Output = std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_error(response)
        } else {
            crate::operation_deser::parse_list_users_response(response)
        }
    }
}

/// Operation shape for `ListVoiceConnectorGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_voice_connector_groups`](crate::client::Client::list_voice_connector_groups).
///
/// See [`crate::client::fluent_builders::ListVoiceConnectorGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVoiceConnectorGroups {
    _private: (),
}
impl ListVoiceConnectorGroups {
    /// Creates a new builder-style object to manufacture [`ListVoiceConnectorGroupsInput`](crate::input::ListVoiceConnectorGroupsInput)
    pub fn builder() -> crate::input::list_voice_connector_groups_input::Builder {
        crate::input::list_voice_connector_groups_input::Builder::default()
    }
    /// Creates a new `ListVoiceConnectorGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVoiceConnectorGroups {
    type Output = std::result::Result<
        crate::output::ListVoiceConnectorGroupsOutput,
        crate::error::ListVoiceConnectorGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_voice_connector_groups_error(response)
        } else {
            crate::operation_deser::parse_list_voice_connector_groups_response(response)
        }
    }
}

/// Operation shape for `ListVoiceConnectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_voice_connectors`](crate::client::Client::list_voice_connectors).
///
/// See [`crate::client::fluent_builders::ListVoiceConnectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVoiceConnectors {
    _private: (),
}
impl ListVoiceConnectors {
    /// Creates a new builder-style object to manufacture [`ListVoiceConnectorsInput`](crate::input::ListVoiceConnectorsInput)
    pub fn builder() -> crate::input::list_voice_connectors_input::Builder {
        crate::input::list_voice_connectors_input::Builder::default()
    }
    /// Creates a new `ListVoiceConnectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVoiceConnectors {
    type Output = std::result::Result<
        crate::output::ListVoiceConnectorsOutput,
        crate::error::ListVoiceConnectorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_voice_connectors_error(response)
        } else {
            crate::operation_deser::parse_list_voice_connectors_response(response)
        }
    }
}

/// Operation shape for `ListVoiceConnectorTerminationCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_voice_connector_termination_credentials`](crate::client::Client::list_voice_connector_termination_credentials).
///
/// See [`crate::client::fluent_builders::ListVoiceConnectorTerminationCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVoiceConnectorTerminationCredentials {
    _private: (),
}
impl ListVoiceConnectorTerminationCredentials {
    /// Creates a new builder-style object to manufacture [`ListVoiceConnectorTerminationCredentialsInput`](crate::input::ListVoiceConnectorTerminationCredentialsInput)
    pub fn builder() -> crate::input::list_voice_connector_termination_credentials_input::Builder {
        crate::input::list_voice_connector_termination_credentials_input::Builder::default()
    }
    /// Creates a new `ListVoiceConnectorTerminationCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVoiceConnectorTerminationCredentials {
    type Output = std::result::Result<
        crate::output::ListVoiceConnectorTerminationCredentialsOutput,
        crate::error::ListVoiceConnectorTerminationCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_voice_connector_termination_credentials_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_voice_connector_termination_credentials_response(
                response,
            )
        }
    }
}

/// Operation shape for `LogoutUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`logout_user`](crate::client::Client::logout_user).
///
/// See [`crate::client::fluent_builders::LogoutUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct LogoutUser {
    _private: (),
}
impl LogoutUser {
    /// Creates a new builder-style object to manufacture [`LogoutUserInput`](crate::input::LogoutUserInput)
    pub fn builder() -> crate::input::logout_user_input::Builder {
        crate::input::logout_user_input::Builder::default()
    }
    /// Creates a new `LogoutUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for LogoutUser {
    type Output =
        std::result::Result<crate::output::LogoutUserOutput, crate::error::LogoutUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_logout_user_error(response)
        } else {
            crate::operation_deser::parse_logout_user_response(response)
        }
    }
}

/// Operation shape for `PutAppInstanceRetentionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_app_instance_retention_settings`](crate::client::Client::put_app_instance_retention_settings).
///
/// See [`crate::client::fluent_builders::PutAppInstanceRetentionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAppInstanceRetentionSettings {
    _private: (),
}
impl PutAppInstanceRetentionSettings {
    /// Creates a new builder-style object to manufacture [`PutAppInstanceRetentionSettingsInput`](crate::input::PutAppInstanceRetentionSettingsInput)
    pub fn builder() -> crate::input::put_app_instance_retention_settings_input::Builder {
        crate::input::put_app_instance_retention_settings_input::Builder::default()
    }
    /// Creates a new `PutAppInstanceRetentionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAppInstanceRetentionSettings {
    type Output = std::result::Result<
        crate::output::PutAppInstanceRetentionSettingsOutput,
        crate::error::PutAppInstanceRetentionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_app_instance_retention_settings_error(response)
        } else {
            crate::operation_deser::parse_put_app_instance_retention_settings_response(response)
        }
    }
}

/// Operation shape for `PutAppInstanceStreamingConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_app_instance_streaming_configurations`](crate::client::Client::put_app_instance_streaming_configurations).
///
/// See [`crate::client::fluent_builders::PutAppInstanceStreamingConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAppInstanceStreamingConfigurations {
    _private: (),
}
impl PutAppInstanceStreamingConfigurations {
    /// Creates a new builder-style object to manufacture [`PutAppInstanceStreamingConfigurationsInput`](crate::input::PutAppInstanceStreamingConfigurationsInput)
    pub fn builder() -> crate::input::put_app_instance_streaming_configurations_input::Builder {
        crate::input::put_app_instance_streaming_configurations_input::Builder::default()
    }
    /// Creates a new `PutAppInstanceStreamingConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAppInstanceStreamingConfigurations {
    type Output = std::result::Result<
        crate::output::PutAppInstanceStreamingConfigurationsOutput,
        crate::error::PutAppInstanceStreamingConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_app_instance_streaming_configurations_error(response)
        } else {
            crate::operation_deser::parse_put_app_instance_streaming_configurations_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutEventsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_events_configuration`](crate::client::Client::put_events_configuration).
///
/// See [`crate::client::fluent_builders::PutEventsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEventsConfiguration {
    _private: (),
}
impl PutEventsConfiguration {
    /// Creates a new builder-style object to manufacture [`PutEventsConfigurationInput`](crate::input::PutEventsConfigurationInput)
    pub fn builder() -> crate::input::put_events_configuration_input::Builder {
        crate::input::put_events_configuration_input::Builder::default()
    }
    /// Creates a new `PutEventsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEventsConfiguration {
    type Output = std::result::Result<
        crate::output::PutEventsConfigurationOutput,
        crate::error::PutEventsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_put_events_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_events_configuration_response(response)
        }
    }
}

/// Operation shape for `PutRetentionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_retention_settings`](crate::client::Client::put_retention_settings).
///
/// See [`crate::client::fluent_builders::PutRetentionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRetentionSettings {
    _private: (),
}
impl PutRetentionSettings {
    /// Creates a new builder-style object to manufacture [`PutRetentionSettingsInput`](crate::input::PutRetentionSettingsInput)
    pub fn builder() -> crate::input::put_retention_settings_input::Builder {
        crate::input::put_retention_settings_input::Builder::default()
    }
    /// Creates a new `PutRetentionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRetentionSettings {
    type Output = std::result::Result<
        crate::output::PutRetentionSettingsOutput,
        crate::error::PutRetentionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_put_retention_settings_error(response)
        } else {
            crate::operation_deser::parse_put_retention_settings_response(response)
        }
    }
}

/// Operation shape for `PutSipMediaApplicationLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_sip_media_application_logging_configuration`](crate::client::Client::put_sip_media_application_logging_configuration).
///
/// See [`crate::client::fluent_builders::PutSipMediaApplicationLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutSipMediaApplicationLoggingConfiguration {
    _private: (),
}
impl PutSipMediaApplicationLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`PutSipMediaApplicationLoggingConfigurationInput`](crate::input::PutSipMediaApplicationLoggingConfigurationInput)
    pub fn builder() -> crate::input::put_sip_media_application_logging_configuration_input::Builder
    {
        crate::input::put_sip_media_application_logging_configuration_input::Builder::default()
    }
    /// Creates a new `PutSipMediaApplicationLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutSipMediaApplicationLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::PutSipMediaApplicationLoggingConfigurationOutput,
        crate::error::PutSipMediaApplicationLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_sip_media_application_logging_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_put_sip_media_application_logging_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutVoiceConnectorEmergencyCallingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_voice_connector_emergency_calling_configuration`](crate::client::Client::put_voice_connector_emergency_calling_configuration).
///
/// See [`crate::client::fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVoiceConnectorEmergencyCallingConfiguration {
    _private: (),
}
impl PutVoiceConnectorEmergencyCallingConfiguration {
    /// Creates a new builder-style object to manufacture [`PutVoiceConnectorEmergencyCallingConfigurationInput`](crate::input::PutVoiceConnectorEmergencyCallingConfigurationInput)
    pub fn builder(
    ) -> crate::input::put_voice_connector_emergency_calling_configuration_input::Builder {
        crate::input::put_voice_connector_emergency_calling_configuration_input::Builder::default()
    }
    /// Creates a new `PutVoiceConnectorEmergencyCallingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for PutVoiceConnectorEmergencyCallingConfiguration
{
    type Output = std::result::Result<
        crate::output::PutVoiceConnectorEmergencyCallingConfigurationOutput,
        crate::error::PutVoiceConnectorEmergencyCallingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_voice_connector_emergency_calling_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_put_voice_connector_emergency_calling_configuration_response(response)
        }
    }
}

/// Operation shape for `PutVoiceConnectorLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_voice_connector_logging_configuration`](crate::client::Client::put_voice_connector_logging_configuration).
///
/// See [`crate::client::fluent_builders::PutVoiceConnectorLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVoiceConnectorLoggingConfiguration {
    _private: (),
}
impl PutVoiceConnectorLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`PutVoiceConnectorLoggingConfigurationInput`](crate::input::PutVoiceConnectorLoggingConfigurationInput)
    pub fn builder() -> crate::input::put_voice_connector_logging_configuration_input::Builder {
        crate::input::put_voice_connector_logging_configuration_input::Builder::default()
    }
    /// Creates a new `PutVoiceConnectorLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutVoiceConnectorLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::PutVoiceConnectorLoggingConfigurationOutput,
        crate::error::PutVoiceConnectorLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_voice_connector_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_voice_connector_logging_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutVoiceConnectorOrigination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_voice_connector_origination`](crate::client::Client::put_voice_connector_origination).
///
/// See [`crate::client::fluent_builders::PutVoiceConnectorOrigination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVoiceConnectorOrigination {
    _private: (),
}
impl PutVoiceConnectorOrigination {
    /// Creates a new builder-style object to manufacture [`PutVoiceConnectorOriginationInput`](crate::input::PutVoiceConnectorOriginationInput)
    pub fn builder() -> crate::input::put_voice_connector_origination_input::Builder {
        crate::input::put_voice_connector_origination_input::Builder::default()
    }
    /// Creates a new `PutVoiceConnectorOrigination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutVoiceConnectorOrigination {
    type Output = std::result::Result<
        crate::output::PutVoiceConnectorOriginationOutput,
        crate::error::PutVoiceConnectorOriginationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_voice_connector_origination_error(response)
        } else {
            crate::operation_deser::parse_put_voice_connector_origination_response(response)
        }
    }
}

/// Operation shape for `PutVoiceConnectorProxy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_voice_connector_proxy`](crate::client::Client::put_voice_connector_proxy).
///
/// See [`crate::client::fluent_builders::PutVoiceConnectorProxy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVoiceConnectorProxy {
    _private: (),
}
impl PutVoiceConnectorProxy {
    /// Creates a new builder-style object to manufacture [`PutVoiceConnectorProxyInput`](crate::input::PutVoiceConnectorProxyInput)
    pub fn builder() -> crate::input::put_voice_connector_proxy_input::Builder {
        crate::input::put_voice_connector_proxy_input::Builder::default()
    }
    /// Creates a new `PutVoiceConnectorProxy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutVoiceConnectorProxy {
    type Output = std::result::Result<
        crate::output::PutVoiceConnectorProxyOutput,
        crate::error::PutVoiceConnectorProxyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_voice_connector_proxy_error(response)
        } else {
            crate::operation_deser::parse_put_voice_connector_proxy_response(response)
        }
    }
}

/// Operation shape for `PutVoiceConnectorStreamingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_voice_connector_streaming_configuration`](crate::client::Client::put_voice_connector_streaming_configuration).
///
/// See [`crate::client::fluent_builders::PutVoiceConnectorStreamingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVoiceConnectorStreamingConfiguration {
    _private: (),
}
impl PutVoiceConnectorStreamingConfiguration {
    /// Creates a new builder-style object to manufacture [`PutVoiceConnectorStreamingConfigurationInput`](crate::input::PutVoiceConnectorStreamingConfigurationInput)
    pub fn builder() -> crate::input::put_voice_connector_streaming_configuration_input::Builder {
        crate::input::put_voice_connector_streaming_configuration_input::Builder::default()
    }
    /// Creates a new `PutVoiceConnectorStreamingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutVoiceConnectorStreamingConfiguration {
    type Output = std::result::Result<
        crate::output::PutVoiceConnectorStreamingConfigurationOutput,
        crate::error::PutVoiceConnectorStreamingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_voice_connector_streaming_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_put_voice_connector_streaming_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutVoiceConnectorTermination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_voice_connector_termination`](crate::client::Client::put_voice_connector_termination).
///
/// See [`crate::client::fluent_builders::PutVoiceConnectorTermination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVoiceConnectorTermination {
    _private: (),
}
impl PutVoiceConnectorTermination {
    /// Creates a new builder-style object to manufacture [`PutVoiceConnectorTerminationInput`](crate::input::PutVoiceConnectorTerminationInput)
    pub fn builder() -> crate::input::put_voice_connector_termination_input::Builder {
        crate::input::put_voice_connector_termination_input::Builder::default()
    }
    /// Creates a new `PutVoiceConnectorTermination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutVoiceConnectorTermination {
    type Output = std::result::Result<
        crate::output::PutVoiceConnectorTerminationOutput,
        crate::error::PutVoiceConnectorTerminationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_voice_connector_termination_error(response)
        } else {
            crate::operation_deser::parse_put_voice_connector_termination_response(response)
        }
    }
}

/// Operation shape for `PutVoiceConnectorTerminationCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_voice_connector_termination_credentials`](crate::client::Client::put_voice_connector_termination_credentials).
///
/// See [`crate::client::fluent_builders::PutVoiceConnectorTerminationCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVoiceConnectorTerminationCredentials {
    _private: (),
}
impl PutVoiceConnectorTerminationCredentials {
    /// Creates a new builder-style object to manufacture [`PutVoiceConnectorTerminationCredentialsInput`](crate::input::PutVoiceConnectorTerminationCredentialsInput)
    pub fn builder() -> crate::input::put_voice_connector_termination_credentials_input::Builder {
        crate::input::put_voice_connector_termination_credentials_input::Builder::default()
    }
    /// Creates a new `PutVoiceConnectorTerminationCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutVoiceConnectorTerminationCredentials {
    type Output = std::result::Result<
        crate::output::PutVoiceConnectorTerminationCredentialsOutput,
        crate::error::PutVoiceConnectorTerminationCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_put_voice_connector_termination_credentials_error(
                response,
            )
        } else {
            crate::operation_deser::parse_put_voice_connector_termination_credentials_response(
                response,
            )
        }
    }
}

/// Operation shape for `RedactChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`redact_channel_message`](crate::client::Client::redact_channel_message).
///
/// See [`crate::client::fluent_builders::RedactChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RedactChannelMessage {
    _private: (),
}
impl RedactChannelMessage {
    /// Creates a new builder-style object to manufacture [`RedactChannelMessageInput`](crate::input::RedactChannelMessageInput)
    pub fn builder() -> crate::input::redact_channel_message_input::Builder {
        crate::input::redact_channel_message_input::Builder::default()
    }
    /// Creates a new `RedactChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RedactChannelMessage {
    type Output = std::result::Result<
        crate::output::RedactChannelMessageOutput,
        crate::error::RedactChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_redact_channel_message_error(response)
        } else {
            crate::operation_deser::parse_redact_channel_message_response(response)
        }
    }
}

/// Operation shape for `RedactConversationMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`redact_conversation_message`](crate::client::Client::redact_conversation_message).
///
/// See [`crate::client::fluent_builders::RedactConversationMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RedactConversationMessage {
    _private: (),
}
impl RedactConversationMessage {
    /// Creates a new builder-style object to manufacture [`RedactConversationMessageInput`](crate::input::RedactConversationMessageInput)
    pub fn builder() -> crate::input::redact_conversation_message_input::Builder {
        crate::input::redact_conversation_message_input::Builder::default()
    }
    /// Creates a new `RedactConversationMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RedactConversationMessage {
    type Output = std::result::Result<
        crate::output::RedactConversationMessageOutput,
        crate::error::RedactConversationMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_redact_conversation_message_error(response)
        } else {
            crate::operation_deser::parse_redact_conversation_message_response(response)
        }
    }
}

/// Operation shape for `RedactRoomMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`redact_room_message`](crate::client::Client::redact_room_message).
///
/// See [`crate::client::fluent_builders::RedactRoomMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RedactRoomMessage {
    _private: (),
}
impl RedactRoomMessage {
    /// Creates a new builder-style object to manufacture [`RedactRoomMessageInput`](crate::input::RedactRoomMessageInput)
    pub fn builder() -> crate::input::redact_room_message_input::Builder {
        crate::input::redact_room_message_input::Builder::default()
    }
    /// Creates a new `RedactRoomMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RedactRoomMessage {
    type Output = std::result::Result<
        crate::output::RedactRoomMessageOutput,
        crate::error::RedactRoomMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_redact_room_message_error(response)
        } else {
            crate::operation_deser::parse_redact_room_message_response(response)
        }
    }
}

/// Operation shape for `RegenerateSecurityToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`regenerate_security_token`](crate::client::Client::regenerate_security_token).
///
/// See [`crate::client::fluent_builders::RegenerateSecurityToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegenerateSecurityToken {
    _private: (),
}
impl RegenerateSecurityToken {
    /// Creates a new builder-style object to manufacture [`RegenerateSecurityTokenInput`](crate::input::RegenerateSecurityTokenInput)
    pub fn builder() -> crate::input::regenerate_security_token_input::Builder {
        crate::input::regenerate_security_token_input::Builder::default()
    }
    /// Creates a new `RegenerateSecurityToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegenerateSecurityToken {
    type Output = std::result::Result<
        crate::output::RegenerateSecurityTokenOutput,
        crate::error::RegenerateSecurityTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_regenerate_security_token_error(response)
        } else {
            crate::operation_deser::parse_regenerate_security_token_response(response)
        }
    }
}

/// Operation shape for `ResetPersonalPIN`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_personal_pin`](crate::client::Client::reset_personal_pin).
///
/// See [`crate::client::fluent_builders::ResetPersonalPIN`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetPersonalPIN {
    _private: (),
}
impl ResetPersonalPIN {
    /// Creates a new builder-style object to manufacture [`ResetPersonalPinInput`](crate::input::ResetPersonalPinInput)
    pub fn builder() -> crate::input::reset_personal_pin_input::Builder {
        crate::input::reset_personal_pin_input::Builder::default()
    }
    /// Creates a new `ResetPersonalPIN` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetPersonalPIN {
    type Output = std::result::Result<
        crate::output::ResetPersonalPinOutput,
        crate::error::ResetPersonalPINError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_personal_pin_error(response)
        } else {
            crate::operation_deser::parse_reset_personal_pin_response(response)
        }
    }
}

/// Operation shape for `RestorePhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_phone_number`](crate::client::Client::restore_phone_number).
///
/// See [`crate::client::fluent_builders::RestorePhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestorePhoneNumber {
    _private: (),
}
impl RestorePhoneNumber {
    /// Creates a new builder-style object to manufacture [`RestorePhoneNumberInput`](crate::input::RestorePhoneNumberInput)
    pub fn builder() -> crate::input::restore_phone_number_input::Builder {
        crate::input::restore_phone_number_input::Builder::default()
    }
    /// Creates a new `RestorePhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestorePhoneNumber {
    type Output = std::result::Result<
        crate::output::RestorePhoneNumberOutput,
        crate::error::RestorePhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_phone_number_error(response)
        } else {
            crate::operation_deser::parse_restore_phone_number_response(response)
        }
    }
}

/// Operation shape for `SearchAvailablePhoneNumbers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_available_phone_numbers`](crate::client::Client::search_available_phone_numbers).
///
/// See [`crate::client::fluent_builders::SearchAvailablePhoneNumbers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchAvailablePhoneNumbers {
    _private: (),
}
impl SearchAvailablePhoneNumbers {
    /// Creates a new builder-style object to manufacture [`SearchAvailablePhoneNumbersInput`](crate::input::SearchAvailablePhoneNumbersInput)
    pub fn builder() -> crate::input::search_available_phone_numbers_input::Builder {
        crate::input::search_available_phone_numbers_input::Builder::default()
    }
    /// Creates a new `SearchAvailablePhoneNumbers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchAvailablePhoneNumbers {
    type Output = std::result::Result<
        crate::output::SearchAvailablePhoneNumbersOutput,
        crate::error::SearchAvailablePhoneNumbersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_available_phone_numbers_error(response)
        } else {
            crate::operation_deser::parse_search_available_phone_numbers_response(response)
        }
    }
}

/// Operation shape for `SendChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_channel_message`](crate::client::Client::send_channel_message).
///
/// See [`crate::client::fluent_builders::SendChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendChannelMessage {
    _private: (),
}
impl SendChannelMessage {
    /// Creates a new builder-style object to manufacture [`SendChannelMessageInput`](crate::input::SendChannelMessageInput)
    pub fn builder() -> crate::input::send_channel_message_input::Builder {
        crate::input::send_channel_message_input::Builder::default()
    }
    /// Creates a new `SendChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendChannelMessage {
    type Output = std::result::Result<
        crate::output::SendChannelMessageOutput,
        crate::error::SendChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_send_channel_message_error(response)
        } else {
            crate::operation_deser::parse_send_channel_message_response(response)
        }
    }
}

/// Operation shape for `StartMeetingTranscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_meeting_transcription`](crate::client::Client::start_meeting_transcription).
///
/// See [`crate::client::fluent_builders::StartMeetingTranscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMeetingTranscription {
    _private: (),
}
impl StartMeetingTranscription {
    /// Creates a new builder-style object to manufacture [`StartMeetingTranscriptionInput`](crate::input::StartMeetingTranscriptionInput)
    pub fn builder() -> crate::input::start_meeting_transcription_input::Builder {
        crate::input::start_meeting_transcription_input::Builder::default()
    }
    /// Creates a new `StartMeetingTranscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMeetingTranscription {
    type Output = std::result::Result<
        crate::output::StartMeetingTranscriptionOutput,
        crate::error::StartMeetingTranscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_meeting_transcription_error(response)
        } else {
            crate::operation_deser::parse_start_meeting_transcription_response(response)
        }
    }
}

/// Operation shape for `StopMeetingTranscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_meeting_transcription`](crate::client::Client::stop_meeting_transcription).
///
/// See [`crate::client::fluent_builders::StopMeetingTranscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopMeetingTranscription {
    _private: (),
}
impl StopMeetingTranscription {
    /// Creates a new builder-style object to manufacture [`StopMeetingTranscriptionInput`](crate::input::StopMeetingTranscriptionInput)
    pub fn builder() -> crate::input::stop_meeting_transcription_input::Builder {
        crate::input::stop_meeting_transcription_input::Builder::default()
    }
    /// Creates a new `StopMeetingTranscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopMeetingTranscription {
    type Output = std::result::Result<
        crate::output::StopMeetingTranscriptionOutput,
        crate::error::StopMeetingTranscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_meeting_transcription_error(response)
        } else {
            crate::operation_deser::parse_stop_meeting_transcription_response(response)
        }
    }
}

/// Operation shape for `TagAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_attendee`](crate::client::Client::tag_attendee).
///
/// See [`crate::client::fluent_builders::TagAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagAttendee {
    _private: (),
}
impl TagAttendee {
    /// Creates a new builder-style object to manufacture [`TagAttendeeInput`](crate::input::TagAttendeeInput)
    pub fn builder() -> crate::input::tag_attendee_input::Builder {
        crate::input::tag_attendee_input::Builder::default()
    }
    /// Creates a new `TagAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagAttendee {
    type Output =
        std::result::Result<crate::output::TagAttendeeOutput, crate::error::TagAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_attendee_error(response)
        } else {
            crate::operation_deser::parse_tag_attendee_response(response)
        }
    }
}

/// Operation shape for `TagMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_meeting`](crate::client::Client::tag_meeting).
///
/// See [`crate::client::fluent_builders::TagMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagMeeting {
    _private: (),
}
impl TagMeeting {
    /// Creates a new builder-style object to manufacture [`TagMeetingInput`](crate::input::TagMeetingInput)
    pub fn builder() -> crate::input::tag_meeting_input::Builder {
        crate::input::tag_meeting_input::Builder::default()
    }
    /// Creates a new `TagMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagMeeting {
    type Output =
        std::result::Result<crate::output::TagMeetingOutput, crate::error::TagMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_meeting_error(response)
        } else {
            crate::operation_deser::parse_tag_meeting_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagAttendee`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_attendee`](crate::client::Client::untag_attendee).
///
/// See [`crate::client::fluent_builders::UntagAttendee`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagAttendee {
    _private: (),
}
impl UntagAttendee {
    /// Creates a new builder-style object to manufacture [`UntagAttendeeInput`](crate::input::UntagAttendeeInput)
    pub fn builder() -> crate::input::untag_attendee_input::Builder {
        crate::input::untag_attendee_input::Builder::default()
    }
    /// Creates a new `UntagAttendee` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagAttendee {
    type Output =
        std::result::Result<crate::output::UntagAttendeeOutput, crate::error::UntagAttendeeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_attendee_error(response)
        } else {
            crate::operation_deser::parse_untag_attendee_response(response)
        }
    }
}

/// Operation shape for `UntagMeeting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_meeting`](crate::client::Client::untag_meeting).
///
/// See [`crate::client::fluent_builders::UntagMeeting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagMeeting {
    _private: (),
}
impl UntagMeeting {
    /// Creates a new builder-style object to manufacture [`UntagMeetingInput`](crate::input::UntagMeetingInput)
    pub fn builder() -> crate::input::untag_meeting_input::Builder {
        crate::input::untag_meeting_input::Builder::default()
    }
    /// Creates a new `UntagMeeting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagMeeting {
    type Output =
        std::result::Result<crate::output::UntagMeetingOutput, crate::error::UntagMeetingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_meeting_error(response)
        } else {
            crate::operation_deser::parse_untag_meeting_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account`](crate::client::Client::update_account).
///
/// See [`crate::client::fluent_builders::UpdateAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccount {
    _private: (),
}
impl UpdateAccount {
    /// Creates a new builder-style object to manufacture [`UpdateAccountInput`](crate::input::UpdateAccountInput)
    pub fn builder() -> crate::input::update_account_input::Builder {
        crate::input::update_account_input::Builder::default()
    }
    /// Creates a new `UpdateAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccount {
    type Output =
        std::result::Result<crate::output::UpdateAccountOutput, crate::error::UpdateAccountError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_account_error(response)
        } else {
            crate::operation_deser::parse_update_account_response(response)
        }
    }
}

/// Operation shape for `UpdateAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account_settings`](crate::client::Client::update_account_settings).
///
/// See [`crate::client::fluent_builders::UpdateAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccountSettings {
    _private: (),
}
impl UpdateAccountSettings {
    /// Creates a new builder-style object to manufacture [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
    pub fn builder() -> crate::input::update_account_settings_input::Builder {
        crate::input::update_account_settings_input::Builder::default()
    }
    /// Creates a new `UpdateAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccountSettings {
    type Output = std::result::Result<
        crate::output::UpdateAccountSettingsOutput,
        crate::error::UpdateAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_account_settings_error(response)
        } else {
            crate::operation_deser::parse_update_account_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateAppInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_app_instance`](crate::client::Client::update_app_instance).
///
/// See [`crate::client::fluent_builders::UpdateAppInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAppInstance {
    _private: (),
}
impl UpdateAppInstance {
    /// Creates a new builder-style object to manufacture [`UpdateAppInstanceInput`](crate::input::UpdateAppInstanceInput)
    pub fn builder() -> crate::input::update_app_instance_input::Builder {
        crate::input::update_app_instance_input::Builder::default()
    }
    /// Creates a new `UpdateAppInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAppInstance {
    type Output = std::result::Result<
        crate::output::UpdateAppInstanceOutput,
        crate::error::UpdateAppInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_app_instance_error(response)
        } else {
            crate::operation_deser::parse_update_app_instance_response(response)
        }
    }
}

/// Operation shape for `UpdateAppInstanceUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_app_instance_user`](crate::client::Client::update_app_instance_user).
///
/// See [`crate::client::fluent_builders::UpdateAppInstanceUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAppInstanceUser {
    _private: (),
}
impl UpdateAppInstanceUser {
    /// Creates a new builder-style object to manufacture [`UpdateAppInstanceUserInput`](crate::input::UpdateAppInstanceUserInput)
    pub fn builder() -> crate::input::update_app_instance_user_input::Builder {
        crate::input::update_app_instance_user_input::Builder::default()
    }
    /// Creates a new `UpdateAppInstanceUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAppInstanceUser {
    type Output = std::result::Result<
        crate::output::UpdateAppInstanceUserOutput,
        crate::error::UpdateAppInstanceUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_app_instance_user_error(response)
        } else {
            crate::operation_deser::parse_update_app_instance_user_response(response)
        }
    }
}

/// Operation shape for `UpdateBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bot`](crate::client::Client::update_bot).
///
/// See [`crate::client::fluent_builders::UpdateBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBot {
    _private: (),
}
impl UpdateBot {
    /// Creates a new builder-style object to manufacture [`UpdateBotInput`](crate::input::UpdateBotInput)
    pub fn builder() -> crate::input::update_bot_input::Builder {
        crate::input::update_bot_input::Builder::default()
    }
    /// Creates a new `UpdateBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBot {
    type Output = std::result::Result<crate::output::UpdateBotOutput, crate::error::UpdateBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_bot_error(response)
        } else {
            crate::operation_deser::parse_update_bot_response(response)
        }
    }
}

/// Operation shape for `UpdateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel`](crate::client::Client::update_channel).
///
/// See [`crate::client::fluent_builders::UpdateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannel {
    _private: (),
}
impl UpdateChannel {
    /// Creates a new builder-style object to manufacture [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    pub fn builder() -> crate::input::update_channel_input::Builder {
        crate::input::update_channel_input::Builder::default()
    }
    /// Creates a new `UpdateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannel {
    type Output =
        std::result::Result<crate::output::UpdateChannelOutput, crate::error::UpdateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_error(response)
        } else {
            crate::operation_deser::parse_update_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateChannelMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel_message`](crate::client::Client::update_channel_message).
///
/// See [`crate::client::fluent_builders::UpdateChannelMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannelMessage {
    _private: (),
}
impl UpdateChannelMessage {
    /// Creates a new builder-style object to manufacture [`UpdateChannelMessageInput`](crate::input::UpdateChannelMessageInput)
    pub fn builder() -> crate::input::update_channel_message_input::Builder {
        crate::input::update_channel_message_input::Builder::default()
    }
    /// Creates a new `UpdateChannelMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannelMessage {
    type Output = std::result::Result<
        crate::output::UpdateChannelMessageOutput,
        crate::error::UpdateChannelMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_message_error(response)
        } else {
            crate::operation_deser::parse_update_channel_message_response(response)
        }
    }
}

/// Operation shape for `UpdateChannelReadMarker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel_read_marker`](crate::client::Client::update_channel_read_marker).
///
/// See [`crate::client::fluent_builders::UpdateChannelReadMarker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannelReadMarker {
    _private: (),
}
impl UpdateChannelReadMarker {
    /// Creates a new builder-style object to manufacture [`UpdateChannelReadMarkerInput`](crate::input::UpdateChannelReadMarkerInput)
    pub fn builder() -> crate::input::update_channel_read_marker_input::Builder {
        crate::input::update_channel_read_marker_input::Builder::default()
    }
    /// Creates a new `UpdateChannelReadMarker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannelReadMarker {
    type Output = std::result::Result<
        crate::output::UpdateChannelReadMarkerOutput,
        crate::error::UpdateChannelReadMarkerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_read_marker_error(response)
        } else {
            crate::operation_deser::parse_update_channel_read_marker_response(response)
        }
    }
}

/// Operation shape for `UpdateGlobalSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_global_settings`](crate::client::Client::update_global_settings).
///
/// See [`crate::client::fluent_builders::UpdateGlobalSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGlobalSettings {
    _private: (),
}
impl UpdateGlobalSettings {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalSettingsInput`](crate::input::UpdateGlobalSettingsInput)
    pub fn builder() -> crate::input::update_global_settings_input::Builder {
        crate::input::update_global_settings_input::Builder::default()
    }
    /// Creates a new `UpdateGlobalSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGlobalSettings {
    type Output = std::result::Result<
        crate::output::UpdateGlobalSettingsOutput,
        crate::error::UpdateGlobalSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_global_settings_error(response)
        } else {
            crate::operation_deser::parse_update_global_settings_response(response)
        }
    }
}

/// Operation shape for `UpdatePhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_phone_number`](crate::client::Client::update_phone_number).
///
/// See [`crate::client::fluent_builders::UpdatePhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePhoneNumber {
    _private: (),
}
impl UpdatePhoneNumber {
    /// Creates a new builder-style object to manufacture [`UpdatePhoneNumberInput`](crate::input::UpdatePhoneNumberInput)
    pub fn builder() -> crate::input::update_phone_number_input::Builder {
        crate::input::update_phone_number_input::Builder::default()
    }
    /// Creates a new `UpdatePhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePhoneNumber {
    type Output = std::result::Result<
        crate::output::UpdatePhoneNumberOutput,
        crate::error::UpdatePhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_phone_number_error(response)
        } else {
            crate::operation_deser::parse_update_phone_number_response(response)
        }
    }
}

/// Operation shape for `UpdatePhoneNumberSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_phone_number_settings`](crate::client::Client::update_phone_number_settings).
///
/// See [`crate::client::fluent_builders::UpdatePhoneNumberSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePhoneNumberSettings {
    _private: (),
}
impl UpdatePhoneNumberSettings {
    /// Creates a new builder-style object to manufacture [`UpdatePhoneNumberSettingsInput`](crate::input::UpdatePhoneNumberSettingsInput)
    pub fn builder() -> crate::input::update_phone_number_settings_input::Builder {
        crate::input::update_phone_number_settings_input::Builder::default()
    }
    /// Creates a new `UpdatePhoneNumberSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePhoneNumberSettings {
    type Output = std::result::Result<
        crate::output::UpdatePhoneNumberSettingsOutput,
        crate::error::UpdatePhoneNumberSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_phone_number_settings_error(response)
        } else {
            crate::operation_deser::parse_update_phone_number_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateProxySession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_proxy_session`](crate::client::Client::update_proxy_session).
///
/// See [`crate::client::fluent_builders::UpdateProxySession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProxySession {
    _private: (),
}
impl UpdateProxySession {
    /// Creates a new builder-style object to manufacture [`UpdateProxySessionInput`](crate::input::UpdateProxySessionInput)
    pub fn builder() -> crate::input::update_proxy_session_input::Builder {
        crate::input::update_proxy_session_input::Builder::default()
    }
    /// Creates a new `UpdateProxySession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProxySession {
    type Output = std::result::Result<
        crate::output::UpdateProxySessionOutput,
        crate::error::UpdateProxySessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_update_proxy_session_error(response)
        } else {
            crate::operation_deser::parse_update_proxy_session_response(response)
        }
    }
}

/// Operation shape for `UpdateRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_room`](crate::client::Client::update_room).
///
/// See [`crate::client::fluent_builders::UpdateRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoom {
    _private: (),
}
impl UpdateRoom {
    /// Creates a new builder-style object to manufacture [`UpdateRoomInput`](crate::input::UpdateRoomInput)
    pub fn builder() -> crate::input::update_room_input::Builder {
        crate::input::update_room_input::Builder::default()
    }
    /// Creates a new `UpdateRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoom {
    type Output =
        std::result::Result<crate::output::UpdateRoomOutput, crate::error::UpdateRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_room_error(response)
        } else {
            crate::operation_deser::parse_update_room_response(response)
        }
    }
}

/// Operation shape for `UpdateRoomMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_room_membership`](crate::client::Client::update_room_membership).
///
/// See [`crate::client::fluent_builders::UpdateRoomMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoomMembership {
    _private: (),
}
impl UpdateRoomMembership {
    /// Creates a new builder-style object to manufacture [`UpdateRoomMembershipInput`](crate::input::UpdateRoomMembershipInput)
    pub fn builder() -> crate::input::update_room_membership_input::Builder {
        crate::input::update_room_membership_input::Builder::default()
    }
    /// Creates a new `UpdateRoomMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoomMembership {
    type Output = std::result::Result<
        crate::output::UpdateRoomMembershipOutput,
        crate::error::UpdateRoomMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_room_membership_error(response)
        } else {
            crate::operation_deser::parse_update_room_membership_response(response)
        }
    }
}

/// Operation shape for `UpdateSipMediaApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_sip_media_application`](crate::client::Client::update_sip_media_application).
///
/// See [`crate::client::fluent_builders::UpdateSipMediaApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSipMediaApplication {
    _private: (),
}
impl UpdateSipMediaApplication {
    /// Creates a new builder-style object to manufacture [`UpdateSipMediaApplicationInput`](crate::input::UpdateSipMediaApplicationInput)
    pub fn builder() -> crate::input::update_sip_media_application_input::Builder {
        crate::input::update_sip_media_application_input::Builder::default()
    }
    /// Creates a new `UpdateSipMediaApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSipMediaApplication {
    type Output = std::result::Result<
        crate::output::UpdateSipMediaApplicationOutput,
        crate::error::UpdateSipMediaApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_sip_media_application_error(response)
        } else {
            crate::operation_deser::parse_update_sip_media_application_response(response)
        }
    }
}

/// Operation shape for `UpdateSipMediaApplicationCall`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_sip_media_application_call`](crate::client::Client::update_sip_media_application_call).
///
/// See [`crate::client::fluent_builders::UpdateSipMediaApplicationCall`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSipMediaApplicationCall {
    _private: (),
}
impl UpdateSipMediaApplicationCall {
    /// Creates a new builder-style object to manufacture [`UpdateSipMediaApplicationCallInput`](crate::input::UpdateSipMediaApplicationCallInput)
    pub fn builder() -> crate::input::update_sip_media_application_call_input::Builder {
        crate::input::update_sip_media_application_call_input::Builder::default()
    }
    /// Creates a new `UpdateSipMediaApplicationCall` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSipMediaApplicationCall {
    type Output = std::result::Result<
        crate::output::UpdateSipMediaApplicationCallOutput,
        crate::error::UpdateSipMediaApplicationCallError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_sip_media_application_call_error(response)
        } else {
            crate::operation_deser::parse_update_sip_media_application_call_response(response)
        }
    }
}

/// Operation shape for `UpdateSipRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_sip_rule`](crate::client::Client::update_sip_rule).
///
/// See [`crate::client::fluent_builders::UpdateSipRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSipRule {
    _private: (),
}
impl UpdateSipRule {
    /// Creates a new builder-style object to manufacture [`UpdateSipRuleInput`](crate::input::UpdateSipRuleInput)
    pub fn builder() -> crate::input::update_sip_rule_input::Builder {
        crate::input::update_sip_rule_input::Builder::default()
    }
    /// Creates a new `UpdateSipRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSipRule {
    type Output =
        std::result::Result<crate::output::UpdateSipRuleOutput, crate::error::UpdateSipRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_sip_rule_error(response)
        } else {
            crate::operation_deser::parse_update_sip_rule_response(response)
        }
    }
}

/// Operation shape for `UpdateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user`](crate::client::Client::update_user).
///
/// See [`crate::client::fluent_builders::UpdateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUser {
    _private: (),
}
impl UpdateUser {
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
    /// Creates a new `UpdateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUser {
    type Output =
        std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_error(response)
        } else {
            crate::operation_deser::parse_update_user_response(response)
        }
    }
}

/// Operation shape for `UpdateUserSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_settings`](crate::client::Client::update_user_settings).
///
/// See [`crate::client::fluent_builders::UpdateUserSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserSettings {
    _private: (),
}
impl UpdateUserSettings {
    /// Creates a new builder-style object to manufacture [`UpdateUserSettingsInput`](crate::input::UpdateUserSettingsInput)
    pub fn builder() -> crate::input::update_user_settings_input::Builder {
        crate::input::update_user_settings_input::Builder::default()
    }
    /// Creates a new `UpdateUserSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserSettings {
    type Output = std::result::Result<
        crate::output::UpdateUserSettingsOutput,
        crate::error::UpdateUserSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_user_settings_error(response)
        } else {
            crate::operation_deser::parse_update_user_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateVoiceConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_voice_connector`](crate::client::Client::update_voice_connector).
///
/// See [`crate::client::fluent_builders::UpdateVoiceConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVoiceConnector {
    _private: (),
}
impl UpdateVoiceConnector {
    /// Creates a new builder-style object to manufacture [`UpdateVoiceConnectorInput`](crate::input::UpdateVoiceConnectorInput)
    pub fn builder() -> crate::input::update_voice_connector_input::Builder {
        crate::input::update_voice_connector_input::Builder::default()
    }
    /// Creates a new `UpdateVoiceConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVoiceConnector {
    type Output = std::result::Result<
        crate::output::UpdateVoiceConnectorOutput,
        crate::error::UpdateVoiceConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_voice_connector_error(response)
        } else {
            crate::operation_deser::parse_update_voice_connector_response(response)
        }
    }
}

/// Operation shape for `UpdateVoiceConnectorGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_voice_connector_group`](crate::client::Client::update_voice_connector_group).
///
/// See [`crate::client::fluent_builders::UpdateVoiceConnectorGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVoiceConnectorGroup {
    _private: (),
}
impl UpdateVoiceConnectorGroup {
    /// Creates a new builder-style object to manufacture [`UpdateVoiceConnectorGroupInput`](crate::input::UpdateVoiceConnectorGroupInput)
    pub fn builder() -> crate::input::update_voice_connector_group_input::Builder {
        crate::input::update_voice_connector_group_input::Builder::default()
    }
    /// Creates a new `UpdateVoiceConnectorGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVoiceConnectorGroup {
    type Output = std::result::Result<
        crate::output::UpdateVoiceConnectorGroupOutput,
        crate::error::UpdateVoiceConnectorGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_voice_connector_group_error(response)
        } else {
            crate::operation_deser::parse_update_voice_connector_group_response(response)
        }
    }
}
