// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    BadRequest,
    #[allow(missing_docs)] // documentation missing in model
    Conflict,
    #[allow(missing_docs)] // documentation missing in model
    Forbidden,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumberAssociationsExist,
    #[allow(missing_docs)] // documentation missing in model
    PreconditionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ResourceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ServiceFailure,
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    Throttled,
    #[allow(missing_docs)] // documentation missing in model
    Throttling,
    #[allow(missing_docs)] // documentation missing in model
    Unauthorized,
    #[allow(missing_docs)] // documentation missing in model
    Unprocessable,
    #[allow(missing_docs)] // documentation missing in model
    VoiceConnectorGroupAssociationsExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => ErrorCode::AccessDenied,
            "BadRequest" => ErrorCode::BadRequest,
            "Conflict" => ErrorCode::Conflict,
            "Forbidden" => ErrorCode::Forbidden,
            "NotFound" => ErrorCode::NotFound,
            "PhoneNumberAssociationsExist" => ErrorCode::PhoneNumberAssociationsExist,
            "PreconditionFailed" => ErrorCode::PreconditionFailed,
            "ResourceLimitExceeded" => ErrorCode::ResourceLimitExceeded,
            "ServiceFailure" => ErrorCode::ServiceFailure,
            "ServiceUnavailable" => ErrorCode::ServiceUnavailable,
            "Throttled" => ErrorCode::Throttled,
            "Throttling" => ErrorCode::Throttling,
            "Unauthorized" => ErrorCode::Unauthorized,
            "Unprocessable" => ErrorCode::Unprocessable,
            "VoiceConnectorGroupAssociationsExist" => {
                ErrorCode::VoiceConnectorGroupAssociationsExist
            }
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::AccessDenied => "AccessDenied",
            ErrorCode::BadRequest => "BadRequest",
            ErrorCode::Conflict => "Conflict",
            ErrorCode::Forbidden => "Forbidden",
            ErrorCode::NotFound => "NotFound",
            ErrorCode::PhoneNumberAssociationsExist => "PhoneNumberAssociationsExist",
            ErrorCode::PreconditionFailed => "PreconditionFailed",
            ErrorCode::ResourceLimitExceeded => "ResourceLimitExceeded",
            ErrorCode::ServiceFailure => "ServiceFailure",
            ErrorCode::ServiceUnavailable => "ServiceUnavailable",
            ErrorCode::Throttled => "Throttled",
            ErrorCode::Throttling => "Throttling",
            ErrorCode::Unauthorized => "Unauthorized",
            ErrorCode::Unprocessable => "Unprocessable",
            ErrorCode::VoiceConnectorGroupAssociationsExist => {
                "VoiceConnectorGroupAssociationsExist"
            }
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "BadRequest",
            "Conflict",
            "Forbidden",
            "NotFound",
            "PhoneNumberAssociationsExist",
            "PreconditionFailed",
            "ResourceLimitExceeded",
            "ServiceFailure",
            "ServiceUnavailable",
            "Throttled",
            "Throttling",
            "Unauthorized",
            "Unprocessable",
            "VoiceConnectorGroupAssociationsExist",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Amazon Chime Voice Connector group configuration, including associated Amazon Chime Voice
/// Connectors. You can include Amazon Chime Voice Connectors from different AWS Regions in
/// your group. This creates a fault tolerant mechanism for fallback in case of availability
/// events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceConnectorGroup {
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    pub voice_connector_group_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Chime Voice Connector group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime Voice Connectors to which to route inbound calls.</p>
    pub voice_connector_items: std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
    /// <p>The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the specified Amazon Chime Voice Connector group.</p>
    pub voice_connector_group_arn: std::option::Option<std::string::String>,
}
impl VoiceConnectorGroup {
    /// <p>The Amazon Chime Voice Connector group ID.</p>
    pub fn voice_connector_group_id(&self) -> std::option::Option<&str> {
        self.voice_connector_group_id.as_deref()
    }
    /// <p>The name of the Amazon Chime Voice Connector group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Chime Voice Connectors to which to route inbound calls.</p>
    pub fn voice_connector_items(
        &self,
    ) -> std::option::Option<&[crate::model::VoiceConnectorItem]> {
        self.voice_connector_items.as_deref()
    }
    /// <p>The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
    /// <p>The ARN of the specified Amazon Chime Voice Connector group.</p>
    pub fn voice_connector_group_arn(&self) -> std::option::Option<&str> {
        self.voice_connector_group_arn.as_deref()
    }
}
impl std::fmt::Debug for VoiceConnectorGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceConnectorGroup");
        formatter.field("voice_connector_group_id", &self.voice_connector_group_id);
        formatter.field("name", &self.name);
        formatter.field("voice_connector_items", &self.voice_connector_items);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.field("voice_connector_group_arn", &self.voice_connector_group_arn);
        formatter.finish()
    }
}
/// See [`VoiceConnectorGroup`](crate::model::VoiceConnectorGroup)
pub mod voice_connector_group {
    /// A builder for [`VoiceConnectorGroup`](crate::model::VoiceConnectorGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) voice_connector_items:
            std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) voice_connector_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_group_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_group_id = input;
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `voice_connector_items`.
        ///
        /// To override the contents of this collection use [`set_voice_connector_items`](Self::set_voice_connector_items).
        ///
        /// <p>The Amazon Chime Voice Connectors to which to route inbound calls.</p>
        pub fn voice_connector_items(
            mut self,
            input: impl Into<crate::model::VoiceConnectorItem>,
        ) -> Self {
            let mut v = self.voice_connector_items.unwrap_or_default();
            v.push(input.into());
            self.voice_connector_items = Some(v);
            self
        }
        /// <p>The Amazon Chime Voice Connectors to which to route inbound calls.</p>
        pub fn set_voice_connector_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
        ) -> Self {
            self.voice_connector_items = input;
            self
        }
        /// <p>The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// <p>The ARN of the specified Amazon Chime Voice Connector group.</p>
        pub fn voice_connector_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the specified Amazon Chime Voice Connector group.</p>
        pub fn set_voice_connector_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceConnectorGroup`](crate::model::VoiceConnectorGroup)
        pub fn build(self) -> crate::model::VoiceConnectorGroup {
            crate::model::VoiceConnectorGroup {
                voice_connector_group_id: self.voice_connector_group_id,
                name: self.name,
                voice_connector_items: self.voice_connector_items,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
                voice_connector_group_arn: self.voice_connector_group_arn,
            }
        }
    }
}
impl VoiceConnectorGroup {
    /// Creates a new builder-style object to manufacture [`VoiceConnectorGroup`](crate::model::VoiceConnectorGroup)
    pub fn builder() -> crate::model::voice_connector_group::Builder {
        crate::model::voice_connector_group::Builder::default()
    }
}

/// <p>For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors to which to route inbound calls. Includes priority configuration settings. Limit: 3
/// <code>VoiceConnectorItems</code>
/// per Amazon Chime Voice Connector group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceConnectorItem {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    pub voice_connector_id: std::option::Option<std::string::String>,
    /// <p>The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.</p>
    pub priority: std::option::Option<i32>,
}
impl VoiceConnectorItem {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    pub fn voice_connector_id(&self) -> std::option::Option<&str> {
        self.voice_connector_id.as_deref()
    }
    /// <p>The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
}
impl std::fmt::Debug for VoiceConnectorItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceConnectorItem");
        formatter.field("voice_connector_id", &self.voice_connector_id);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`VoiceConnectorItem`](crate::model::VoiceConnectorItem)
pub mod voice_connector_item {
    /// A builder for [`VoiceConnectorItem`](crate::model::VoiceConnectorItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// <p>The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceConnectorItem`](crate::model::VoiceConnectorItem)
        pub fn build(self) -> crate::model::VoiceConnectorItem {
            crate::model::VoiceConnectorItem {
                voice_connector_id: self.voice_connector_id,
                priority: self.priority,
            }
        }
    }
}
impl VoiceConnectorItem {
    /// Creates a new builder-style object to manufacture [`VoiceConnectorItem`](crate::model::VoiceConnectorItem)
    pub fn builder() -> crate::model::voice_connector_item::Builder {
        crate::model::voice_connector_item::Builder::default()
    }
}

/// <p>The Amazon Chime Voice Connector configuration, including outbound host name and encryption
/// settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceConnector {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    pub voice_connector_id: std::option::Option<std::string::String>,
    /// <p>
    /// The AWS Region in which the Amazon Chime Voice Connector is created. Default:
    /// <code>us-east-1</code>.
    /// </p>
    pub aws_region: std::option::Option<crate::model::VoiceConnectorAwsRegion>,
    /// <p>The name of the Amazon Chime Voice Connector.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The outbound host name for the Amazon Chime Voice Connector.</p>
    pub outbound_host_name: std::option::Option<std::string::String>,
    /// <p>Designates whether encryption is required for the Amazon Chime Voice Connector.</p>
    pub require_encryption: std::option::Option<bool>,
    /// <p>The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the specified Amazon Chime Voice Connector.</p>
    pub voice_connector_arn: std::option::Option<std::string::String>,
}
impl VoiceConnector {
    /// <p>The Amazon Chime Voice Connector ID.</p>
    pub fn voice_connector_id(&self) -> std::option::Option<&str> {
        self.voice_connector_id.as_deref()
    }
    /// <p>
    /// The AWS Region in which the Amazon Chime Voice Connector is created. Default:
    /// <code>us-east-1</code>.
    /// </p>
    pub fn aws_region(&self) -> std::option::Option<&crate::model::VoiceConnectorAwsRegion> {
        self.aws_region.as_ref()
    }
    /// <p>The name of the Amazon Chime Voice Connector.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The outbound host name for the Amazon Chime Voice Connector.</p>
    pub fn outbound_host_name(&self) -> std::option::Option<&str> {
        self.outbound_host_name.as_deref()
    }
    /// <p>Designates whether encryption is required for the Amazon Chime Voice Connector.</p>
    pub fn require_encryption(&self) -> std::option::Option<bool> {
        self.require_encryption
    }
    /// <p>The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
    /// <p>The ARN of the specified Amazon Chime Voice Connector.</p>
    pub fn voice_connector_arn(&self) -> std::option::Option<&str> {
        self.voice_connector_arn.as_deref()
    }
}
impl std::fmt::Debug for VoiceConnector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceConnector");
        formatter.field("voice_connector_id", &self.voice_connector_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("name", &self.name);
        formatter.field("outbound_host_name", &self.outbound_host_name);
        formatter.field("require_encryption", &self.require_encryption);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.field("voice_connector_arn", &self.voice_connector_arn);
        formatter.finish()
    }
}
/// See [`VoiceConnector`](crate::model::VoiceConnector)
pub mod voice_connector {
    /// A builder for [`VoiceConnector`](crate::model::VoiceConnector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<crate::model::VoiceConnectorAwsRegion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) outbound_host_name: std::option::Option<std::string::String>,
        pub(crate) require_encryption: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) voice_connector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// <p>
        /// The AWS Region in which the Amazon Chime Voice Connector is created. Default:
        /// <code>us-east-1</code>.
        /// </p>
        pub fn aws_region(mut self, input: crate::model::VoiceConnectorAwsRegion) -> Self {
            self.aws_region = Some(input);
            self
        }
        /// <p>
        /// The AWS Region in which the Amazon Chime Voice Connector is created. Default:
        /// <code>us-east-1</code>.
        /// </p>
        pub fn set_aws_region(
            mut self,
            input: std::option::Option<crate::model::VoiceConnectorAwsRegion>,
        ) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The outbound host name for the Amazon Chime Voice Connector.</p>
        pub fn outbound_host_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.outbound_host_name = Some(input.into());
            self
        }
        /// <p>The outbound host name for the Amazon Chime Voice Connector.</p>
        pub fn set_outbound_host_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outbound_host_name = input;
            self
        }
        /// <p>Designates whether encryption is required for the Amazon Chime Voice Connector.</p>
        pub fn require_encryption(mut self, input: bool) -> Self {
            self.require_encryption = Some(input);
            self
        }
        /// <p>Designates whether encryption is required for the Amazon Chime Voice Connector.</p>
        pub fn set_require_encryption(mut self, input: std::option::Option<bool>) -> Self {
            self.require_encryption = input;
            self
        }
        /// <p>The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// <p>The ARN of the specified Amazon Chime Voice Connector.</p>
        pub fn voice_connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the specified Amazon Chime Voice Connector.</p>
        pub fn set_voice_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceConnector`](crate::model::VoiceConnector)
        pub fn build(self) -> crate::model::VoiceConnector {
            crate::model::VoiceConnector {
                voice_connector_id: self.voice_connector_id,
                aws_region: self.aws_region,
                name: self.name,
                outbound_host_name: self.outbound_host_name,
                require_encryption: self.require_encryption,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
                voice_connector_arn: self.voice_connector_arn,
            }
        }
    }
}
impl VoiceConnector {
    /// Creates a new builder-style object to manufacture [`VoiceConnector`](crate::model::VoiceConnector)
    pub fn builder() -> crate::model::voice_connector::Builder {
        crate::model::voice_connector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VoiceConnectorAwsRegion {
    #[allow(missing_docs)] // documentation missing in model
    UsEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VoiceConnectorAwsRegion {
    fn from(s: &str) -> Self {
        match s {
            "us-east-1" => VoiceConnectorAwsRegion::UsEast1,
            "us-west-2" => VoiceConnectorAwsRegion::UsWest2,
            other => VoiceConnectorAwsRegion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VoiceConnectorAwsRegion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VoiceConnectorAwsRegion::from(s))
    }
}
impl VoiceConnectorAwsRegion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VoiceConnectorAwsRegion::UsEast1 => "us-east-1",
            VoiceConnectorAwsRegion::UsWest2 => "us-west-2",
            VoiceConnectorAwsRegion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["us-east-1", "us-west-2"]
    }
}
impl AsRef<str> for VoiceConnectorAwsRegion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings associated with an Amazon Chime user, including inbound and outbound calling and text
/// messaging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserSettings {
    /// <p>The telephony settings associated with the user.</p>
    pub telephony: std::option::Option<crate::model::TelephonySettings>,
}
impl UserSettings {
    /// <p>The telephony settings associated with the user.</p>
    pub fn telephony(&self) -> std::option::Option<&crate::model::TelephonySettings> {
        self.telephony.as_ref()
    }
}
impl std::fmt::Debug for UserSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserSettings");
        formatter.field("telephony", &self.telephony);
        formatter.finish()
    }
}
/// See [`UserSettings`](crate::model::UserSettings)
pub mod user_settings {
    /// A builder for [`UserSettings`](crate::model::UserSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) telephony: std::option::Option<crate::model::TelephonySettings>,
    }
    impl Builder {
        /// <p>The telephony settings associated with the user.</p>
        pub fn telephony(mut self, input: crate::model::TelephonySettings) -> Self {
            self.telephony = Some(input);
            self
        }
        /// <p>The telephony settings associated with the user.</p>
        pub fn set_telephony(
            mut self,
            input: std::option::Option<crate::model::TelephonySettings>,
        ) -> Self {
            self.telephony = input;
            self
        }
        /// Consumes the builder and constructs a [`UserSettings`](crate::model::UserSettings)
        pub fn build(self) -> crate::model::UserSettings {
            crate::model::UserSettings {
                telephony: self.telephony,
            }
        }
    }
}
impl UserSettings {
    /// Creates a new builder-style object to manufacture [`UserSettings`](crate::model::UserSettings)
    pub fn builder() -> crate::model::user_settings::Builder {
        crate::model::user_settings::Builder::default()
    }
}

/// <p>Settings that allow management of telephony permissions for an Amazon Chime user, such as
/// inbound and outbound calling and text messaging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TelephonySettings {
    /// <p>Allows or denies inbound calling.</p>
    pub inbound_calling: std::option::Option<bool>,
    /// <p>Allows or denies outbound calling.</p>
    pub outbound_calling: std::option::Option<bool>,
    /// <p>Allows or denies SMS messaging.</p>
    pub sms: std::option::Option<bool>,
}
impl TelephonySettings {
    /// <p>Allows or denies inbound calling.</p>
    pub fn inbound_calling(&self) -> std::option::Option<bool> {
        self.inbound_calling
    }
    /// <p>Allows or denies outbound calling.</p>
    pub fn outbound_calling(&self) -> std::option::Option<bool> {
        self.outbound_calling
    }
    /// <p>Allows or denies SMS messaging.</p>
    pub fn sms(&self) -> std::option::Option<bool> {
        self.sms
    }
}
impl std::fmt::Debug for TelephonySettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TelephonySettings");
        formatter.field("inbound_calling", &self.inbound_calling);
        formatter.field("outbound_calling", &self.outbound_calling);
        formatter.field("sms", &self.sms);
        formatter.finish()
    }
}
/// See [`TelephonySettings`](crate::model::TelephonySettings)
pub mod telephony_settings {
    /// A builder for [`TelephonySettings`](crate::model::TelephonySettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inbound_calling: std::option::Option<bool>,
        pub(crate) outbound_calling: std::option::Option<bool>,
        pub(crate) sms: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Allows or denies inbound calling.</p>
        pub fn inbound_calling(mut self, input: bool) -> Self {
            self.inbound_calling = Some(input);
            self
        }
        /// <p>Allows or denies inbound calling.</p>
        pub fn set_inbound_calling(mut self, input: std::option::Option<bool>) -> Self {
            self.inbound_calling = input;
            self
        }
        /// <p>Allows or denies outbound calling.</p>
        pub fn outbound_calling(mut self, input: bool) -> Self {
            self.outbound_calling = Some(input);
            self
        }
        /// <p>Allows or denies outbound calling.</p>
        pub fn set_outbound_calling(mut self, input: std::option::Option<bool>) -> Self {
            self.outbound_calling = input;
            self
        }
        /// <p>Allows or denies SMS messaging.</p>
        pub fn sms(mut self, input: bool) -> Self {
            self.sms = Some(input);
            self
        }
        /// <p>Allows or denies SMS messaging.</p>
        pub fn set_sms(mut self, input: std::option::Option<bool>) -> Self {
            self.sms = input;
            self
        }
        /// Consumes the builder and constructs a [`TelephonySettings`](crate::model::TelephonySettings)
        pub fn build(self) -> crate::model::TelephonySettings {
            crate::model::TelephonySettings {
                inbound_calling: self.inbound_calling,
                outbound_calling: self.outbound_calling,
                sms: self.sms,
            }
        }
    }
}
impl TelephonySettings {
    /// Creates a new builder-style object to manufacture [`TelephonySettings`](crate::model::TelephonySettings)
    pub fn builder() -> crate::model::telephony_settings::Builder {
        crate::model::telephony_settings::Builder::default()
    }
}

/// <p>The user on the Amazon Chime account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The user ID.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The primary email address of the user.</p>
    pub primary_email: std::option::Option<std::string::String>,
    /// <p>The primary phone number associated with the user.</p>
    pub primary_provisioned_number: std::option::Option<std::string::String>,
    /// <p>The display name of the user.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The license type for the user.</p>
    pub license_type: std::option::Option<crate::model::License>,
    /// <p>The user type.</p>
    pub user_type: std::option::Option<crate::model::UserType>,
    /// <p>The user registration status.</p>
    pub user_registration_status: std::option::Option<crate::model::RegistrationStatus>,
    /// <p>The user invite status.</p>
    pub user_invitation_status: std::option::Option<crate::model::InviteStatus>,
    /// <p>Date and time when the user is registered, in ISO 8601 format.</p>
    pub registered_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.</p>
    pub invited_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Alexa for Business metadata.</p>
    pub alexa_for_business_metadata: std::option::Option<crate::model::AlexaForBusinessMetadata>,
    /// <p>The user's personal meeting PIN.</p>
    pub personal_pin: std::option::Option<std::string::String>,
}
impl User {
    /// <p>The user ID.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The Amazon Chime account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The primary email address of the user.</p>
    pub fn primary_email(&self) -> std::option::Option<&str> {
        self.primary_email.as_deref()
    }
    /// <p>The primary phone number associated with the user.</p>
    pub fn primary_provisioned_number(&self) -> std::option::Option<&str> {
        self.primary_provisioned_number.as_deref()
    }
    /// <p>The display name of the user.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The license type for the user.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::License> {
        self.license_type.as_ref()
    }
    /// <p>The user type.</p>
    pub fn user_type(&self) -> std::option::Option<&crate::model::UserType> {
        self.user_type.as_ref()
    }
    /// <p>The user registration status.</p>
    pub fn user_registration_status(
        &self,
    ) -> std::option::Option<&crate::model::RegistrationStatus> {
        self.user_registration_status.as_ref()
    }
    /// <p>The user invite status.</p>
    pub fn user_invitation_status(&self) -> std::option::Option<&crate::model::InviteStatus> {
        self.user_invitation_status.as_ref()
    }
    /// <p>Date and time when the user is registered, in ISO 8601 format.</p>
    pub fn registered_on(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.registered_on.as_ref()
    }
    /// <p>Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.</p>
    pub fn invited_on(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.invited_on.as_ref()
    }
    /// <p>The Alexa for Business metadata.</p>
    pub fn alexa_for_business_metadata(
        &self,
    ) -> std::option::Option<&crate::model::AlexaForBusinessMetadata> {
        self.alexa_for_business_metadata.as_ref()
    }
    /// <p>The user's personal meeting PIN.</p>
    pub fn personal_pin(&self) -> std::option::Option<&str> {
        self.personal_pin.as_deref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("user_id", &self.user_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("primary_email", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "primary_provisioned_number",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("license_type", &self.license_type);
        formatter.field("user_type", &self.user_type);
        formatter.field("user_registration_status", &self.user_registration_status);
        formatter.field("user_invitation_status", &self.user_invitation_status);
        formatter.field("registered_on", &self.registered_on);
        formatter.field("invited_on", &self.invited_on);
        formatter.field(
            "alexa_for_business_metadata",
            &self.alexa_for_business_metadata,
        );
        formatter.field("personal_pin", &self.personal_pin);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) primary_email: std::option::Option<std::string::String>,
        pub(crate) primary_provisioned_number: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) license_type: std::option::Option<crate::model::License>,
        pub(crate) user_type: std::option::Option<crate::model::UserType>,
        pub(crate) user_registration_status: std::option::Option<crate::model::RegistrationStatus>,
        pub(crate) user_invitation_status: std::option::Option<crate::model::InviteStatus>,
        pub(crate) registered_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) invited_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) alexa_for_business_metadata:
            std::option::Option<crate::model::AlexaForBusinessMetadata>,
        pub(crate) personal_pin: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The primary email address of the user.</p>
        pub fn primary_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_email = Some(input.into());
            self
        }
        /// <p>The primary email address of the user.</p>
        pub fn set_primary_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_email = input;
            self
        }
        /// <p>The primary phone number associated with the user.</p>
        pub fn primary_provisioned_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_provisioned_number = Some(input.into());
            self
        }
        /// <p>The primary phone number associated with the user.</p>
        pub fn set_primary_provisioned_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_provisioned_number = input;
            self
        }
        /// <p>The display name of the user.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the user.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The license type for the user.</p>
        pub fn license_type(mut self, input: crate::model::License) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The license type for the user.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::License>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.user_type = Some(input);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.user_type = input;
            self
        }
        /// <p>The user registration status.</p>
        pub fn user_registration_status(mut self, input: crate::model::RegistrationStatus) -> Self {
            self.user_registration_status = Some(input);
            self
        }
        /// <p>The user registration status.</p>
        pub fn set_user_registration_status(
            mut self,
            input: std::option::Option<crate::model::RegistrationStatus>,
        ) -> Self {
            self.user_registration_status = input;
            self
        }
        /// <p>The user invite status.</p>
        pub fn user_invitation_status(mut self, input: crate::model::InviteStatus) -> Self {
            self.user_invitation_status = Some(input);
            self
        }
        /// <p>The user invite status.</p>
        pub fn set_user_invitation_status(
            mut self,
            input: std::option::Option<crate::model::InviteStatus>,
        ) -> Self {
            self.user_invitation_status = input;
            self
        }
        /// <p>Date and time when the user is registered, in ISO 8601 format.</p>
        pub fn registered_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.registered_on = Some(input);
            self
        }
        /// <p>Date and time when the user is registered, in ISO 8601 format.</p>
        pub fn set_registered_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.registered_on = input;
            self
        }
        /// <p>Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.</p>
        pub fn invited_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.invited_on = Some(input);
            self
        }
        /// <p>Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.</p>
        pub fn set_invited_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.invited_on = input;
            self
        }
        /// <p>The Alexa for Business metadata.</p>
        pub fn alexa_for_business_metadata(
            mut self,
            input: crate::model::AlexaForBusinessMetadata,
        ) -> Self {
            self.alexa_for_business_metadata = Some(input);
            self
        }
        /// <p>The Alexa for Business metadata.</p>
        pub fn set_alexa_for_business_metadata(
            mut self,
            input: std::option::Option<crate::model::AlexaForBusinessMetadata>,
        ) -> Self {
            self.alexa_for_business_metadata = input;
            self
        }
        /// <p>The user's personal meeting PIN.</p>
        pub fn personal_pin(mut self, input: impl Into<std::string::String>) -> Self {
            self.personal_pin = Some(input.into());
            self
        }
        /// <p>The user's personal meeting PIN.</p>
        pub fn set_personal_pin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.personal_pin = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                user_id: self.user_id,
                account_id: self.account_id,
                primary_email: self.primary_email,
                primary_provisioned_number: self.primary_provisioned_number,
                display_name: self.display_name,
                license_type: self.license_type,
                user_type: self.user_type,
                user_registration_status: self.user_registration_status,
                user_invitation_status: self.user_invitation_status,
                registered_on: self.registered_on,
                invited_on: self.invited_on,
                alexa_for_business_metadata: self.alexa_for_business_metadata,
                personal_pin: self.personal_pin,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

/// <p>The Alexa for Business metadata associated with an Amazon Chime user, used to integrate Alexa for Business with a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlexaForBusinessMetadata {
    /// <p>Starts or stops Alexa for Business.</p>
    pub is_alexa_for_business_enabled: std::option::Option<bool>,
    /// <p>The ARN of the room resource.</p>
    pub alexa_for_business_room_arn: std::option::Option<std::string::String>,
}
impl AlexaForBusinessMetadata {
    /// <p>Starts or stops Alexa for Business.</p>
    pub fn is_alexa_for_business_enabled(&self) -> std::option::Option<bool> {
        self.is_alexa_for_business_enabled
    }
    /// <p>The ARN of the room resource.</p>
    pub fn alexa_for_business_room_arn(&self) -> std::option::Option<&str> {
        self.alexa_for_business_room_arn.as_deref()
    }
}
impl std::fmt::Debug for AlexaForBusinessMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlexaForBusinessMetadata");
        formatter.field(
            "is_alexa_for_business_enabled",
            &self.is_alexa_for_business_enabled,
        );
        formatter.field(
            "alexa_for_business_room_arn",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.finish()
    }
}
/// See [`AlexaForBusinessMetadata`](crate::model::AlexaForBusinessMetadata)
pub mod alexa_for_business_metadata {
    /// A builder for [`AlexaForBusinessMetadata`](crate::model::AlexaForBusinessMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_alexa_for_business_enabled: std::option::Option<bool>,
        pub(crate) alexa_for_business_room_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Starts or stops Alexa for Business.</p>
        pub fn is_alexa_for_business_enabled(mut self, input: bool) -> Self {
            self.is_alexa_for_business_enabled = Some(input);
            self
        }
        /// <p>Starts or stops Alexa for Business.</p>
        pub fn set_is_alexa_for_business_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_alexa_for_business_enabled = input;
            self
        }
        /// <p>The ARN of the room resource.</p>
        pub fn alexa_for_business_room_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.alexa_for_business_room_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the room resource.</p>
        pub fn set_alexa_for_business_room_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alexa_for_business_room_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AlexaForBusinessMetadata`](crate::model::AlexaForBusinessMetadata)
        pub fn build(self) -> crate::model::AlexaForBusinessMetadata {
            crate::model::AlexaForBusinessMetadata {
                is_alexa_for_business_enabled: self.is_alexa_for_business_enabled,
                alexa_for_business_room_arn: self.alexa_for_business_room_arn,
            }
        }
    }
}
impl AlexaForBusinessMetadata {
    /// Creates a new builder-style object to manufacture [`AlexaForBusinessMetadata`](crate::model::AlexaForBusinessMetadata)
    pub fn builder() -> crate::model::alexa_for_business_metadata::Builder {
        crate::model::alexa_for_business_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InviteStatus {
    #[allow(missing_docs)] // documentation missing in model
    Accepted,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InviteStatus {
    fn from(s: &str) -> Self {
        match s {
            "Accepted" => InviteStatus::Accepted,
            "Failed" => InviteStatus::Failed,
            "Pending" => InviteStatus::Pending,
            other => InviteStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InviteStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InviteStatus::from(s))
    }
}
impl InviteStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InviteStatus::Accepted => "Accepted",
            InviteStatus::Failed => "Failed",
            InviteStatus::Pending => "Pending",
            InviteStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Accepted", "Failed", "Pending"]
    }
}
impl AsRef<str> for InviteStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegistrationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    #[allow(missing_docs)] // documentation missing in model
    Unregistered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegistrationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Registered" => RegistrationStatus::Registered,
            "Suspended" => RegistrationStatus::Suspended,
            "Unregistered" => RegistrationStatus::Unregistered,
            other => RegistrationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegistrationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegistrationStatus::from(s))
    }
}
impl RegistrationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegistrationStatus::Registered => "Registered",
            RegistrationStatus::Suspended => "Suspended",
            RegistrationStatus::Unregistered => "Unregistered",
            RegistrationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Registered", "Suspended", "Unregistered"]
    }
}
impl AsRef<str> for RegistrationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserType {
    #[allow(missing_docs)] // documentation missing in model
    PrivateUser,
    #[allow(missing_docs)] // documentation missing in model
    SharedDevice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserType {
    fn from(s: &str) -> Self {
        match s {
            "PrivateUser" => UserType::PrivateUser,
            "SharedDevice" => UserType::SharedDevice,
            other => UserType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserType::from(s))
    }
}
impl UserType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserType::PrivateUser => "PrivateUser",
            UserType::SharedDevice => "SharedDevice",
            UserType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PrivateUser", "SharedDevice"]
    }
}
impl AsRef<str> for UserType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum License {
    #[allow(missing_docs)] // documentation missing in model
    Basic,
    #[allow(missing_docs)] // documentation missing in model
    Plus,
    #[allow(missing_docs)] // documentation missing in model
    Pro,
    #[allow(missing_docs)] // documentation missing in model
    ProTrial,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for License {
    fn from(s: &str) -> Self {
        match s {
            "Basic" => License::Basic,
            "Plus" => License::Plus,
            "Pro" => License::Pro,
            "ProTrial" => License::ProTrial,
            other => License::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for License {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(License::from(s))
    }
}
impl License {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            License::Basic => "Basic",
            License::Plus => "Plus",
            License::Pro => "Pro",
            License::ProTrial => "ProTrial",
            License::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Basic", "Plus", "Pro", "ProTrial"]
    }
}
impl AsRef<str> for License {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The SIP rule details, including name, triggers, and target applications. An AWS account can have multiple SIP rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SipRule {
    /// <p>The SIP rule ID.</p>
    pub sip_rule_id: std::option::Option<std::string::String>,
    /// <p>The name of the SIP rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.</p>
    pub disabled: std::option::Option<bool>,
    /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or
    /// <code>ToPhoneNumber</code>.</p>
    pub trigger_type: std::option::Option<crate::model::SipRuleTriggerType>,
    /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, then the value can be the
    /// outbound host name of the Amazon Chime Voice Connector. If <code>TriggerType</code> is
    /// <code>ToPhoneNumber</code>, then the value can be a customer-owned phone number in
    /// E164 format. <code>SipRule</code> is triggered when a SIP rule requests host name or
    /// <code>ToPhoneNumber</code> matches in the incoming SIP request.</p>
    pub trigger_value: std::option::Option<std::string::String>,
    /// <p>Target SIP media application and other details, such as priority and AWS Region, to be
    /// specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>
    pub target_applications:
        std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
    /// <p>The time at which the SIP rule was created, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the SIP rule was last updated, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl SipRule {
    /// <p>The SIP rule ID.</p>
    pub fn sip_rule_id(&self) -> std::option::Option<&str> {
        self.sip_rule_id.as_deref()
    }
    /// <p>The name of the SIP rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.</p>
    pub fn disabled(&self) -> std::option::Option<bool> {
        self.disabled
    }
    /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or
    /// <code>ToPhoneNumber</code>.</p>
    pub fn trigger_type(&self) -> std::option::Option<&crate::model::SipRuleTriggerType> {
        self.trigger_type.as_ref()
    }
    /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, then the value can be the
    /// outbound host name of the Amazon Chime Voice Connector. If <code>TriggerType</code> is
    /// <code>ToPhoneNumber</code>, then the value can be a customer-owned phone number in
    /// E164 format. <code>SipRule</code> is triggered when a SIP rule requests host name or
    /// <code>ToPhoneNumber</code> matches in the incoming SIP request.</p>
    pub fn trigger_value(&self) -> std::option::Option<&str> {
        self.trigger_value.as_deref()
    }
    /// <p>Target SIP media application and other details, such as priority and AWS Region, to be
    /// specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>
    pub fn target_applications(
        &self,
    ) -> std::option::Option<&[crate::model::SipRuleTargetApplication]> {
        self.target_applications.as_deref()
    }
    /// <p>The time at which the SIP rule was created, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which the SIP rule was last updated, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for SipRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SipRule");
        formatter.field("sip_rule_id", &self.sip_rule_id);
        formatter.field("name", &self.name);
        formatter.field("disabled", &self.disabled);
        formatter.field("trigger_type", &self.trigger_type);
        formatter.field("trigger_value", &self.trigger_value);
        formatter.field("target_applications", &self.target_applications);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`SipRule`](crate::model::SipRule)
pub mod sip_rule {
    /// A builder for [`SipRule`](crate::model::SipRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) disabled: std::option::Option<bool>,
        pub(crate) trigger_type: std::option::Option<crate::model::SipRuleTriggerType>,
        pub(crate) trigger_value: std::option::Option<std::string::String>,
        pub(crate) target_applications:
            std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_rule_id = Some(input.into());
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sip_rule_id = input;
            self
        }
        /// <p>The name of the SIP rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SIP rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or
        /// <code>ToPhoneNumber</code>.</p>
        pub fn trigger_type(mut self, input: crate::model::SipRuleTriggerType) -> Self {
            self.trigger_type = Some(input);
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or
        /// <code>ToPhoneNumber</code>.</p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::SipRuleTriggerType>,
        ) -> Self {
            self.trigger_type = input;
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, then the value can be the
        /// outbound host name of the Amazon Chime Voice Connector. If <code>TriggerType</code> is
        /// <code>ToPhoneNumber</code>, then the value can be a customer-owned phone number in
        /// E164 format. <code>SipRule</code> is triggered when a SIP rule requests host name or
        /// <code>ToPhoneNumber</code> matches in the incoming SIP request.</p>
        pub fn trigger_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger_value = Some(input.into());
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, then the value can be the
        /// outbound host name of the Amazon Chime Voice Connector. If <code>TriggerType</code> is
        /// <code>ToPhoneNumber</code>, then the value can be a customer-owned phone number in
        /// E164 format. <code>SipRule</code> is triggered when a SIP rule requests host name or
        /// <code>ToPhoneNumber</code> matches in the incoming SIP request.</p>
        pub fn set_trigger_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trigger_value = input;
            self
        }
        /// Appends an item to `target_applications`.
        ///
        /// To override the contents of this collection use [`set_target_applications`](Self::set_target_applications).
        ///
        /// <p>Target SIP media application and other details, such as priority and AWS Region, to be
        /// specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>
        pub fn target_applications(
            mut self,
            input: impl Into<crate::model::SipRuleTargetApplication>,
        ) -> Self {
            let mut v = self.target_applications.unwrap_or_default();
            v.push(input.into());
            self.target_applications = Some(v);
            self
        }
        /// <p>Target SIP media application and other details, such as priority and AWS Region, to be
        /// specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>
        pub fn set_target_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
        ) -> Self {
            self.target_applications = input;
            self
        }
        /// <p>The time at which the SIP rule was created, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the SIP rule was created, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which the SIP rule was last updated, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which the SIP rule was last updated, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`SipRule`](crate::model::SipRule)
        pub fn build(self) -> crate::model::SipRule {
            crate::model::SipRule {
                sip_rule_id: self.sip_rule_id,
                name: self.name,
                disabled: self.disabled,
                trigger_type: self.trigger_type,
                trigger_value: self.trigger_value,
                target_applications: self.target_applications,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl SipRule {
    /// Creates a new builder-style object to manufacture [`SipRule`](crate::model::SipRule)
    pub fn builder() -> crate::model::sip_rule::Builder {
        crate::model::sip_rule::Builder::default()
    }
}

/// <p>Target SIP media application and other details, such as priority and AWS Region, to be
/// specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SipRuleTargetApplication {
    /// <p>The SIP media application ID.</p>
    pub sip_media_application_id: std::option::Option<std::string::String>,
    /// <p>Priority of the SIP media application in the target list.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The AWS Region of the target application.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl SipRuleTargetApplication {
    /// <p>The SIP media application ID.</p>
    pub fn sip_media_application_id(&self) -> std::option::Option<&str> {
        self.sip_media_application_id.as_deref()
    }
    /// <p>Priority of the SIP media application in the target list.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The AWS Region of the target application.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for SipRuleTargetApplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SipRuleTargetApplication");
        formatter.field("sip_media_application_id", &self.sip_media_application_id);
        formatter.field("priority", &self.priority);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`SipRuleTargetApplication`](crate::model::SipRuleTargetApplication)
pub mod sip_rule_target_application {
    /// A builder for [`SipRuleTargetApplication`](crate::model::SipRuleTargetApplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_media_application_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_media_application_id = Some(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sip_media_application_id = input;
            self
        }
        /// <p>Priority of the SIP media application in the target list.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>Priority of the SIP media application in the target list.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The AWS Region of the target application.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The AWS Region of the target application.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`SipRuleTargetApplication`](crate::model::SipRuleTargetApplication)
        pub fn build(self) -> crate::model::SipRuleTargetApplication {
            crate::model::SipRuleTargetApplication {
                sip_media_application_id: self.sip_media_application_id,
                priority: self.priority,
                aws_region: self.aws_region,
            }
        }
    }
}
impl SipRuleTargetApplication {
    /// Creates a new builder-style object to manufacture [`SipRuleTargetApplication`](crate::model::SipRuleTargetApplication)
    pub fn builder() -> crate::model::sip_rule_target_application::Builder {
        crate::model::sip_rule_target_application::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SipRuleTriggerType {
    #[allow(missing_docs)] // documentation missing in model
    RequestUriHostname,
    #[allow(missing_docs)] // documentation missing in model
    ToPhoneNumber,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SipRuleTriggerType {
    fn from(s: &str) -> Self {
        match s {
            "RequestUriHostname" => SipRuleTriggerType::RequestUriHostname,
            "ToPhoneNumber" => SipRuleTriggerType::ToPhoneNumber,
            other => SipRuleTriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SipRuleTriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SipRuleTriggerType::from(s))
    }
}
impl SipRuleTriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SipRuleTriggerType::RequestUriHostname => "RequestUriHostname",
            SipRuleTriggerType::ToPhoneNumber => "ToPhoneNumber",
            SipRuleTriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RequestUriHostname", "ToPhoneNumber"]
    }
}
impl AsRef<str> for SipRuleTriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A <code>Call</code> instance for a SIP media application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SipMediaApplicationCall {
    /// <p>The transaction ID of a call.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl SipMediaApplicationCall {
    /// <p>The transaction ID of a call.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for SipMediaApplicationCall {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SipMediaApplicationCall");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}
/// See [`SipMediaApplicationCall`](crate::model::SipMediaApplicationCall)
pub mod sip_media_application_call {
    /// A builder for [`SipMediaApplicationCall`](crate::model::SipMediaApplicationCall)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The transaction ID of a call.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction ID of a call.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SipMediaApplicationCall`](crate::model::SipMediaApplicationCall)
        pub fn build(self) -> crate::model::SipMediaApplicationCall {
            crate::model::SipMediaApplicationCall {
                transaction_id: self.transaction_id,
            }
        }
    }
}
impl SipMediaApplicationCall {
    /// Creates a new builder-style object to manufacture [`SipMediaApplicationCall`](crate::model::SipMediaApplicationCall)
    pub fn builder() -> crate::model::sip_media_application_call::Builder {
        crate::model::sip_media_application_call::Builder::default()
    }
}

/// <p>The details of the SIP media application, including name and endpoints. An AWS account can have multiple SIP media applications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SipMediaApplication {
    /// <p>The SIP media application ID.</p>
    pub sip_media_application_id: std::option::Option<std::string::String>,
    /// <p>The AWS Region in which the SIP media application is created.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The name of the SIP media application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.</p>
    pub endpoints: std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
    /// <p>The SIP media application creation timestamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The SIP media application updated timestamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl SipMediaApplication {
    /// <p>The SIP media application ID.</p>
    pub fn sip_media_application_id(&self) -> std::option::Option<&str> {
        self.sip_media_application_id.as_deref()
    }
    /// <p>The AWS Region in which the SIP media application is created.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The name of the SIP media application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.</p>
    pub fn endpoints(&self) -> std::option::Option<&[crate::model::SipMediaApplicationEndpoint]> {
        self.endpoints.as_deref()
    }
    /// <p>The SIP media application creation timestamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The SIP media application updated timestamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for SipMediaApplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SipMediaApplication");
        formatter.field("sip_media_application_id", &self.sip_media_application_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("name", &self.name);
        formatter.field("endpoints", &self.endpoints);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`SipMediaApplication`](crate::model::SipMediaApplication)
pub mod sip_media_application {
    /// A builder for [`SipMediaApplication`](crate::model::SipMediaApplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sip_media_application_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) endpoints:
            std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sip_media_application_id = Some(input.into());
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sip_media_application_id = input;
            self
        }
        /// <p>The AWS Region in which the SIP media application is created.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The AWS Region in which the SIP media application is created.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The name of the SIP media application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SIP media application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.</p>
        pub fn endpoints(
            mut self,
            input: impl Into<crate::model::SipMediaApplicationEndpoint>,
        ) -> Self {
            let mut v = self.endpoints.unwrap_or_default();
            v.push(input.into());
            self.endpoints = Some(v);
            self
        }
        /// <p>List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// <p>The SIP media application creation timestamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The SIP media application creation timestamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The SIP media application updated timestamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The SIP media application updated timestamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`SipMediaApplication`](crate::model::SipMediaApplication)
        pub fn build(self) -> crate::model::SipMediaApplication {
            crate::model::SipMediaApplication {
                sip_media_application_id: self.sip_media_application_id,
                aws_region: self.aws_region,
                name: self.name,
                endpoints: self.endpoints,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl SipMediaApplication {
    /// Creates a new builder-style object to manufacture [`SipMediaApplication`](crate::model::SipMediaApplication)
    pub fn builder() -> crate::model::sip_media_application::Builder {
        crate::model::sip_media_application::Builder::default()
    }
}

/// <p>The endpoint assigned to the SIP media application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SipMediaApplicationEndpoint {
    /// <p>Valid Amazon Resource Name (ARN) of the Lambda function. The function must be created in the same AWS Region as the SIP media application.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
}
impl SipMediaApplicationEndpoint {
    /// <p>Valid Amazon Resource Name (ARN) of the Lambda function. The function must be created in the same AWS Region as the SIP media application.</p>
    pub fn lambda_arn(&self) -> std::option::Option<&str> {
        self.lambda_arn.as_deref()
    }
}
impl std::fmt::Debug for SipMediaApplicationEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SipMediaApplicationEndpoint");
        formatter.field("lambda_arn", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SipMediaApplicationEndpoint`](crate::model::SipMediaApplicationEndpoint)
pub mod sip_media_application_endpoint {
    /// A builder for [`SipMediaApplicationEndpoint`](crate::model::SipMediaApplicationEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Valid Amazon Resource Name (ARN) of the Lambda function. The function must be created in the same AWS Region as the SIP media application.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>Valid Amazon Resource Name (ARN) of the Lambda function. The function must be created in the same AWS Region as the SIP media application.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SipMediaApplicationEndpoint`](crate::model::SipMediaApplicationEndpoint)
        pub fn build(self) -> crate::model::SipMediaApplicationEndpoint {
            crate::model::SipMediaApplicationEndpoint {
                lambda_arn: self.lambda_arn,
            }
        }
    }
}
impl SipMediaApplicationEndpoint {
    /// Creates a new builder-style object to manufacture [`SipMediaApplicationEndpoint`](crate::model::SipMediaApplicationEndpoint)
    pub fn builder() -> crate::model::sip_media_application_endpoint::Builder {
        crate::model::sip_media_application_endpoint::Builder::default()
    }
}

/// <p>The room membership details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoomMembership {
    /// <p>The room ID.</p>
    pub room_id: std::option::Option<std::string::String>,
    /// <p>The member details, such as email address, name, member ID, and member type.</p>
    pub member: std::option::Option<crate::model::Member>,
    /// <p>The membership role.</p>
    pub role: std::option::Option<crate::model::RoomMembershipRole>,
    /// <p>The identifier of the user that invited the room member.</p>
    pub invited_by: std::option::Option<std::string::String>,
    /// <p>The room membership update timestamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl RoomMembership {
    /// <p>The room ID.</p>
    pub fn room_id(&self) -> std::option::Option<&str> {
        self.room_id.as_deref()
    }
    /// <p>The member details, such as email address, name, member ID, and member type.</p>
    pub fn member(&self) -> std::option::Option<&crate::model::Member> {
        self.member.as_ref()
    }
    /// <p>The membership role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::RoomMembershipRole> {
        self.role.as_ref()
    }
    /// <p>The identifier of the user that invited the room member.</p>
    pub fn invited_by(&self) -> std::option::Option<&str> {
        self.invited_by.as_deref()
    }
    /// <p>The room membership update timestamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for RoomMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoomMembership");
        formatter.field("room_id", &self.room_id);
        formatter.field("member", &self.member);
        formatter.field("role", &self.role);
        formatter.field("invited_by", &self.invited_by);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`RoomMembership`](crate::model::RoomMembership)
pub mod room_membership {
    /// A builder for [`RoomMembership`](crate::model::RoomMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_id: std::option::Option<std::string::String>,
        pub(crate) member: std::option::Option<crate::model::Member>,
        pub(crate) role: std::option::Option<crate::model::RoomMembershipRole>,
        pub(crate) invited_by: std::option::Option<std::string::String>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_id = Some(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_id = input;
            self
        }
        /// <p>The member details, such as email address, name, member ID, and member type.</p>
        pub fn member(mut self, input: crate::model::Member) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The member details, such as email address, name, member ID, and member type.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Member>) -> Self {
            self.member = input;
            self
        }
        /// <p>The membership role.</p>
        pub fn role(mut self, input: crate::model::RoomMembershipRole) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The membership role.</p>
        pub fn set_role(
            mut self,
            input: std::option::Option<crate::model::RoomMembershipRole>,
        ) -> Self {
            self.role = input;
            self
        }
        /// <p>The identifier of the user that invited the room member.</p>
        pub fn invited_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.invited_by = Some(input.into());
            self
        }
        /// <p>The identifier of the user that invited the room member.</p>
        pub fn set_invited_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invited_by = input;
            self
        }
        /// <p>The room membership update timestamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The room membership update timestamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`RoomMembership`](crate::model::RoomMembership)
        pub fn build(self) -> crate::model::RoomMembership {
            crate::model::RoomMembership {
                room_id: self.room_id,
                member: self.member,
                role: self.role,
                invited_by: self.invited_by,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl RoomMembership {
    /// Creates a new builder-style object to manufacture [`RoomMembership`](crate::model::RoomMembership)
    pub fn builder() -> crate::model::room_membership::Builder {
        crate::model::room_membership::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RoomMembershipRole {
    #[allow(missing_docs)] // documentation missing in model
    Administrator,
    #[allow(missing_docs)] // documentation missing in model
    Member,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RoomMembershipRole {
    fn from(s: &str) -> Self {
        match s {
            "Administrator" => RoomMembershipRole::Administrator,
            "Member" => RoomMembershipRole::Member,
            other => RoomMembershipRole::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RoomMembershipRole {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RoomMembershipRole::from(s))
    }
}
impl RoomMembershipRole {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RoomMembershipRole::Administrator => "Administrator",
            RoomMembershipRole::Member => "Member",
            RoomMembershipRole::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Administrator", "Member"]
    }
}
impl AsRef<str> for RoomMembershipRole {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The member details, such as email address, name, member ID, and member type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Member {
    /// <p>The member ID (user ID or bot ID).</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The member type.</p>
    pub member_type: std::option::Option<crate::model::MemberType>,
    /// <p>The member email address.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The member name.</p>
    pub full_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl Member {
    /// <p>The member ID (user ID or bot ID).</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The member type.</p>
    pub fn member_type(&self) -> std::option::Option<&crate::model::MemberType> {
        self.member_type.as_ref()
    }
    /// <p>The member email address.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The member name.</p>
    pub fn full_name(&self) -> std::option::Option<&str> {
        self.full_name.as_deref()
    }
    /// <p>The Amazon Chime account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for Member {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Member");
        formatter.field("member_id", &self.member_id);
        formatter.field("member_type", &self.member_type);
        formatter.field("email", &"*** Sensitive Data Redacted ***");
        formatter.field("full_name", &"*** Sensitive Data Redacted ***");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`Member`](crate::model::Member)
pub mod member {
    /// A builder for [`Member`](crate::model::Member)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) member_type: std::option::Option<crate::model::MemberType>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) full_name: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The member type.</p>
        pub fn member_type(mut self, input: crate::model::MemberType) -> Self {
            self.member_type = Some(input);
            self
        }
        /// <p>The member type.</p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.member_type = input;
            self
        }
        /// <p>The member email address.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The member email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The member name.</p>
        pub fn full_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.full_name = Some(input.into());
            self
        }
        /// <p>The member name.</p>
        pub fn set_full_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.full_name = input;
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Member`](crate::model::Member)
        pub fn build(self) -> crate::model::Member {
            crate::model::Member {
                member_id: self.member_id,
                member_type: self.member_type,
                email: self.email,
                full_name: self.full_name,
                account_id: self.account_id,
            }
        }
    }
}
impl Member {
    /// Creates a new builder-style object to manufacture [`Member`](crate::model::Member)
    pub fn builder() -> crate::model::member::Builder {
        crate::model::member::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MemberType {
    #[allow(missing_docs)] // documentation missing in model
    Bot,
    #[allow(missing_docs)] // documentation missing in model
    User,
    #[allow(missing_docs)] // documentation missing in model
    Webhook,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MemberType {
    fn from(s: &str) -> Self {
        match s {
            "Bot" => MemberType::Bot,
            "User" => MemberType::User,
            "Webhook" => MemberType::Webhook,
            other => MemberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MemberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MemberType::from(s))
    }
}
impl MemberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MemberType::Bot => "Bot",
            MemberType::User => "User",
            MemberType::Webhook => "Webhook",
            MemberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Bot", "User", "Webhook"]
    }
}
impl AsRef<str> for MemberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Amazon Chime chat room details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Room {
    /// <p>The room ID.</p>
    pub room_id: std::option::Option<std::string::String>,
    /// <p>The room name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the room creator.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The room creation timestamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The room update timestamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl Room {
    /// <p>The room ID.</p>
    pub fn room_id(&self) -> std::option::Option<&str> {
        self.room_id.as_deref()
    }
    /// <p>The room name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Chime account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The identifier of the room creator.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The room creation timestamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The room update timestamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for Room {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Room");
        formatter.field("room_id", &self.room_id);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("account_id", &self.account_id);
        formatter.field("created_by", &self.created_by);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`Room`](crate::model::Room)
pub mod room {
    /// A builder for [`Room`](crate::model::Room)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The room ID.</p>
        pub fn room_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_id = Some(input.into());
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.room_id = input;
            self
        }
        /// <p>The room name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The room name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The identifier of the room creator.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The identifier of the room creator.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The room creation timestamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The room creation timestamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The room update timestamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The room update timestamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Room`](crate::model::Room)
        pub fn build(self) -> crate::model::Room {
            crate::model::Room {
                room_id: self.room_id,
                name: self.name,
                account_id: self.account_id,
                created_by: self.created_by,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl Room {
    /// Creates a new builder-style object to manufacture [`Room`](crate::model::Room)
    pub fn builder() -> crate::model::room::Builder {
        crate::model::room::Builder::default()
    }
}

/// <p>The proxy session for an Amazon Chime Voice Connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProxySession {
    /// <p>The Amazon Chime voice connector ID.</p>
    pub voice_connector_id: std::option::Option<std::string::String>,
    /// <p>The proxy session ID.</p>
    pub proxy_session_id: std::option::Option<std::string::String>,
    /// <p>The name of the proxy session.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the proxy session.</p>
    pub status: std::option::Option<crate::model::ProxySessionStatus>,
    /// <p>The number of minutes allowed for the proxy session.</p>
    pub expiry_minutes: std::option::Option<i32>,
    /// <p>The proxy session capabilities.</p>
    pub capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
    /// <p>The created time stamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The updated time stamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ended time stamp, in ISO 8601 format.</p>
    pub ended_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The proxy session participants.</p>
    pub participants: std::option::Option<std::vec::Vec<crate::model::Participant>>,
    /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
    pub number_selection_behavior: std::option::Option<crate::model::NumberSelectionBehavior>,
    /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
    pub geo_match_level: std::option::Option<crate::model::GeoMatchLevel>,
    /// <p>The country and area code for the proxy phone number.</p>
    pub geo_match_params: std::option::Option<crate::model::GeoMatchParams>,
}
impl ProxySession {
    /// <p>The Amazon Chime voice connector ID.</p>
    pub fn voice_connector_id(&self) -> std::option::Option<&str> {
        self.voice_connector_id.as_deref()
    }
    /// <p>The proxy session ID.</p>
    pub fn proxy_session_id(&self) -> std::option::Option<&str> {
        self.proxy_session_id.as_deref()
    }
    /// <p>The name of the proxy session.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the proxy session.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProxySessionStatus> {
        self.status.as_ref()
    }
    /// <p>The number of minutes allowed for the proxy session.</p>
    pub fn expiry_minutes(&self) -> std::option::Option<i32> {
        self.expiry_minutes
    }
    /// <p>The proxy session capabilities.</p>
    pub fn capabilities(&self) -> std::option::Option<&[crate::model::Capability]> {
        self.capabilities.as_deref()
    }
    /// <p>The created time stamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The updated time stamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
    /// <p>The ended time stamp, in ISO 8601 format.</p>
    pub fn ended_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.ended_timestamp.as_ref()
    }
    /// <p>The proxy session participants.</p>
    pub fn participants(&self) -> std::option::Option<&[crate::model::Participant]> {
        self.participants.as_deref()
    }
    /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
    pub fn number_selection_behavior(
        &self,
    ) -> std::option::Option<&crate::model::NumberSelectionBehavior> {
        self.number_selection_behavior.as_ref()
    }
    /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
    pub fn geo_match_level(&self) -> std::option::Option<&crate::model::GeoMatchLevel> {
        self.geo_match_level.as_ref()
    }
    /// <p>The country and area code for the proxy phone number.</p>
    pub fn geo_match_params(&self) -> std::option::Option<&crate::model::GeoMatchParams> {
        self.geo_match_params.as_ref()
    }
}
impl std::fmt::Debug for ProxySession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProxySession");
        formatter.field("voice_connector_id", &self.voice_connector_id);
        formatter.field("proxy_session_id", &self.proxy_session_id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("expiry_minutes", &self.expiry_minutes);
        formatter.field("capabilities", &self.capabilities);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.field("ended_timestamp", &self.ended_timestamp);
        formatter.field("participants", &self.participants);
        formatter.field("number_selection_behavior", &self.number_selection_behavior);
        formatter.field("geo_match_level", &self.geo_match_level);
        formatter.field("geo_match_params", &self.geo_match_params);
        formatter.finish()
    }
}
/// See [`ProxySession`](crate::model::ProxySession)
pub mod proxy_session {
    /// A builder for [`ProxySession`](crate::model::ProxySession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_connector_id: std::option::Option<std::string::String>,
        pub(crate) proxy_session_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProxySessionStatus>,
        pub(crate) expiry_minutes: std::option::Option<i32>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ended_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) participants: std::option::Option<std::vec::Vec<crate::model::Participant>>,
        pub(crate) number_selection_behavior:
            std::option::Option<crate::model::NumberSelectionBehavior>,
        pub(crate) geo_match_level: std::option::Option<crate::model::GeoMatchLevel>,
        pub(crate) geo_match_params: std::option::Option<crate::model::GeoMatchParams>,
    }
    impl Builder {
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_connector_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voice_connector_id = input;
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proxy_session_id = Some(input.into());
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proxy_session_id = input;
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the proxy session.</p>
        pub fn status(mut self, input: crate::model::ProxySessionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the proxy session.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProxySessionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn expiry_minutes(mut self, input: i32) -> Self {
            self.expiry_minutes = Some(input);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn set_expiry_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.expiry_minutes = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>The proxy session capabilities.</p>
        pub fn capabilities(mut self, input: impl Into<crate::model::Capability>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>The proxy session capabilities.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// <p>The created time stamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The created time stamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The updated time stamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The updated time stamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// <p>The ended time stamp, in ISO 8601 format.</p>
        pub fn ended_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ended_timestamp = Some(input);
            self
        }
        /// <p>The ended time stamp, in ISO 8601 format.</p>
        pub fn set_ended_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ended_timestamp = input;
            self
        }
        /// Appends an item to `participants`.
        ///
        /// To override the contents of this collection use [`set_participants`](Self::set_participants).
        ///
        /// <p>The proxy session participants.</p>
        pub fn participants(mut self, input: impl Into<crate::model::Participant>) -> Self {
            let mut v = self.participants.unwrap_or_default();
            v.push(input.into());
            self.participants = Some(v);
            self
        }
        /// <p>The proxy session participants.</p>
        pub fn set_participants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Participant>>,
        ) -> Self {
            self.participants = input;
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn number_selection_behavior(
            mut self,
            input: crate::model::NumberSelectionBehavior,
        ) -> Self {
            self.number_selection_behavior = Some(input);
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn set_number_selection_behavior(
            mut self,
            input: std::option::Option<crate::model::NumberSelectionBehavior>,
        ) -> Self {
            self.number_selection_behavior = input;
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn geo_match_level(mut self, input: crate::model::GeoMatchLevel) -> Self {
            self.geo_match_level = Some(input);
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn set_geo_match_level(
            mut self,
            input: std::option::Option<crate::model::GeoMatchLevel>,
        ) -> Self {
            self.geo_match_level = input;
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn geo_match_params(mut self, input: crate::model::GeoMatchParams) -> Self {
            self.geo_match_params = Some(input);
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn set_geo_match_params(
            mut self,
            input: std::option::Option<crate::model::GeoMatchParams>,
        ) -> Self {
            self.geo_match_params = input;
            self
        }
        /// Consumes the builder and constructs a [`ProxySession`](crate::model::ProxySession)
        pub fn build(self) -> crate::model::ProxySession {
            crate::model::ProxySession {
                voice_connector_id: self.voice_connector_id,
                proxy_session_id: self.proxy_session_id,
                name: self.name,
                status: self.status,
                expiry_minutes: self.expiry_minutes,
                capabilities: self.capabilities,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
                ended_timestamp: self.ended_timestamp,
                participants: self.participants,
                number_selection_behavior: self.number_selection_behavior,
                geo_match_level: self.geo_match_level,
                geo_match_params: self.geo_match_params,
            }
        }
    }
}
impl ProxySession {
    /// Creates a new builder-style object to manufacture [`ProxySession`](crate::model::ProxySession)
    pub fn builder() -> crate::model::proxy_session::Builder {
        crate::model::proxy_session::Builder::default()
    }
}

/// <p>The country and area code for a proxy phone number in a proxy phone session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoMatchParams {
    /// <p>The country.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The area code.</p>
    pub area_code: std::option::Option<std::string::String>,
}
impl GeoMatchParams {
    /// <p>The country.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>The area code.</p>
    pub fn area_code(&self) -> std::option::Option<&str> {
        self.area_code.as_deref()
    }
}
impl std::fmt::Debug for GeoMatchParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoMatchParams");
        formatter.field("country", &self.country);
        formatter.field("area_code", &self.area_code);
        formatter.finish()
    }
}
/// See [`GeoMatchParams`](crate::model::GeoMatchParams)
pub mod geo_match_params {
    /// A builder for [`GeoMatchParams`](crate::model::GeoMatchParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) area_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The country.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The country.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The area code.</p>
        pub fn area_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.area_code = Some(input.into());
            self
        }
        /// <p>The area code.</p>
        pub fn set_area_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.area_code = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoMatchParams`](crate::model::GeoMatchParams)
        pub fn build(self) -> crate::model::GeoMatchParams {
            crate::model::GeoMatchParams {
                country: self.country,
                area_code: self.area_code,
            }
        }
    }
}
impl GeoMatchParams {
    /// Creates a new builder-style object to manufacture [`GeoMatchParams`](crate::model::GeoMatchParams)
    pub fn builder() -> crate::model::geo_match_params::Builder {
        crate::model::geo_match_params::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeoMatchLevel {
    #[allow(missing_docs)] // documentation missing in model
    AreaCode,
    #[allow(missing_docs)] // documentation missing in model
    Country,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeoMatchLevel {
    fn from(s: &str) -> Self {
        match s {
            "AreaCode" => GeoMatchLevel::AreaCode,
            "Country" => GeoMatchLevel::Country,
            other => GeoMatchLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeoMatchLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeoMatchLevel::from(s))
    }
}
impl GeoMatchLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeoMatchLevel::AreaCode => "AreaCode",
            GeoMatchLevel::Country => "Country",
            GeoMatchLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AreaCode", "Country"]
    }
}
impl AsRef<str> for GeoMatchLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NumberSelectionBehavior {
    #[allow(missing_docs)] // documentation missing in model
    AvoidSticky,
    #[allow(missing_docs)] // documentation missing in model
    PreferSticky,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NumberSelectionBehavior {
    fn from(s: &str) -> Self {
        match s {
            "AvoidSticky" => NumberSelectionBehavior::AvoidSticky,
            "PreferSticky" => NumberSelectionBehavior::PreferSticky,
            other => NumberSelectionBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NumberSelectionBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NumberSelectionBehavior::from(s))
    }
}
impl NumberSelectionBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NumberSelectionBehavior::AvoidSticky => "AvoidSticky",
            NumberSelectionBehavior::PreferSticky => "PreferSticky",
            NumberSelectionBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AvoidSticky", "PreferSticky"]
    }
}
impl AsRef<str> for NumberSelectionBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The phone number and proxy phone number for a participant in an Amazon Chime Voice Connector proxy session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Participant {
    /// <p>The participant's phone number.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The participant's proxy phone number.</p>
    pub proxy_phone_number: std::option::Option<std::string::String>,
}
impl Participant {
    /// <p>The participant's phone number.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The participant's proxy phone number.</p>
    pub fn proxy_phone_number(&self) -> std::option::Option<&str> {
        self.proxy_phone_number.as_deref()
    }
}
impl std::fmt::Debug for Participant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Participant");
        formatter.field("phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("proxy_phone_number", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Participant`](crate::model::Participant)
pub mod participant {
    /// A builder for [`Participant`](crate::model::Participant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) proxy_phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The participant's phone number.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The participant's phone number.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The participant's proxy phone number.</p>
        pub fn proxy_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.proxy_phone_number = Some(input.into());
            self
        }
        /// <p>The participant's proxy phone number.</p>
        pub fn set_proxy_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proxy_phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`Participant`](crate::model::Participant)
        pub fn build(self) -> crate::model::Participant {
            crate::model::Participant {
                phone_number: self.phone_number,
                proxy_phone_number: self.proxy_phone_number,
            }
        }
    }
}
impl Participant {
    /// Creates a new builder-style object to manufacture [`Participant`](crate::model::Participant)
    pub fn builder() -> crate::model::participant::Builder {
        crate::model::participant::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Capability {
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Capability {
    fn from(s: &str) -> Self {
        match s {
            "SMS" => Capability::Sms,
            "Voice" => Capability::Voice,
            other => Capability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Capability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Capability::from(s))
    }
}
impl Capability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Capability::Sms => "SMS",
            Capability::Voice => "Voice",
            Capability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SMS", "Voice"]
    }
}
impl AsRef<str> for Capability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProxySessionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProxySessionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Closed" => ProxySessionStatus::Closed,
            "InProgress" => ProxySessionStatus::InProgress,
            "Open" => ProxySessionStatus::Open,
            other => ProxySessionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProxySessionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProxySessionStatus::from(s))
    }
}
impl ProxySessionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProxySessionStatus::Closed => "Closed",
            ProxySessionStatus::InProgress => "InProgress",
            ProxySessionStatus::Open => "Open",
            ProxySessionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Closed", "InProgress", "Open"]
    }
}
impl AsRef<str> for ProxySessionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A phone number used for Amazon Chime Business Calling or an Amazon Chime Voice
/// Connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumber {
    /// <p>The phone number ID.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>The phone number, in E.164 format.</p>
    pub e164_phone_number: std::option::Option<std::string::String>,
    /// <p>The phone number country. Format: ISO 3166-1 alpha-2.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The phone number type.</p>
    pub r#type: std::option::Option<crate::model::PhoneNumberType>,
    /// <p>The phone number product type.</p>
    pub product_type: std::option::Option<crate::model::PhoneNumberProductType>,
    /// <p>The phone number status.</p>
    pub status: std::option::Option<crate::model::PhoneNumberStatus>,
    /// <p>The phone number capabilities.</p>
    pub capabilities: std::option::Option<crate::model::PhoneNumberCapabilities>,
    /// <p>The phone number associations.</p>
    pub associations: std::option::Option<std::vec::Vec<crate::model::PhoneNumberAssociation>>,
    /// <p>The outbound calling name associated with the phone number.</p>
    pub calling_name: std::option::Option<std::string::String>,
    /// <p>The outbound calling name status.</p>
    pub calling_name_status: std::option::Option<crate::model::CallingNameStatus>,
    /// <p>The phone number creation timestamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The updated phone number timestamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The deleted phone number timestamp, in ISO 8601 format.</p>
    pub deletion_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl PhoneNumber {
    /// <p>The phone number ID.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>The phone number, in E.164 format.</p>
    pub fn e164_phone_number(&self) -> std::option::Option<&str> {
        self.e164_phone_number.as_deref()
    }
    /// <p>The phone number country. Format: ISO 3166-1 alpha-2.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>The phone number type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PhoneNumberType> {
        self.r#type.as_ref()
    }
    /// <p>The phone number product type.</p>
    pub fn product_type(&self) -> std::option::Option<&crate::model::PhoneNumberProductType> {
        self.product_type.as_ref()
    }
    /// <p>The phone number status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PhoneNumberStatus> {
        self.status.as_ref()
    }
    /// <p>The phone number capabilities.</p>
    pub fn capabilities(&self) -> std::option::Option<&crate::model::PhoneNumberCapabilities> {
        self.capabilities.as_ref()
    }
    /// <p>The phone number associations.</p>
    pub fn associations(&self) -> std::option::Option<&[crate::model::PhoneNumberAssociation]> {
        self.associations.as_deref()
    }
    /// <p>The outbound calling name associated with the phone number.</p>
    pub fn calling_name(&self) -> std::option::Option<&str> {
        self.calling_name.as_deref()
    }
    /// <p>The outbound calling name status.</p>
    pub fn calling_name_status(&self) -> std::option::Option<&crate::model::CallingNameStatus> {
        self.calling_name_status.as_ref()
    }
    /// <p>The phone number creation timestamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The updated phone number timestamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
    /// <p>The deleted phone number timestamp, in ISO 8601 format.</p>
    pub fn deletion_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.deletion_timestamp.as_ref()
    }
}
impl std::fmt::Debug for PhoneNumber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumber");
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("e164_phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("country", &self.country);
        formatter.field("r#type", &self.r#type);
        formatter.field("product_type", &self.product_type);
        formatter.field("status", &self.status);
        formatter.field("capabilities", &self.capabilities);
        formatter.field("associations", &self.associations);
        formatter.field("calling_name", &"*** Sensitive Data Redacted ***");
        formatter.field("calling_name_status", &self.calling_name_status);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.field("deletion_timestamp", &self.deletion_timestamp);
        formatter.finish()
    }
}
/// See [`PhoneNumber`](crate::model::PhoneNumber)
pub mod phone_number {
    /// A builder for [`PhoneNumber`](crate::model::PhoneNumber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) e164_phone_number: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PhoneNumberType>,
        pub(crate) product_type: std::option::Option<crate::model::PhoneNumberProductType>,
        pub(crate) status: std::option::Option<crate::model::PhoneNumberStatus>,
        pub(crate) capabilities: std::option::Option<crate::model::PhoneNumberCapabilities>,
        pub(crate) associations:
            std::option::Option<std::vec::Vec<crate::model::PhoneNumberAssociation>>,
        pub(crate) calling_name: std::option::Option<std::string::String>,
        pub(crate) calling_name_status: std::option::Option<crate::model::CallingNameStatus>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deletion_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn e164_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.e164_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn set_e164_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.e164_phone_number = input;
            self
        }
        /// <p>The phone number country. Format: ISO 3166-1 alpha-2.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The phone number country. Format: ISO 3166-1 alpha-2.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The phone number type.</p>
        pub fn r#type(mut self, input: crate::model::PhoneNumberType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The phone number type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, input: crate::model::PhoneNumberProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// <p>The phone number status.</p>
        pub fn status(mut self, input: crate::model::PhoneNumberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The phone number status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The phone number capabilities.</p>
        pub fn capabilities(mut self, input: crate::model::PhoneNumberCapabilities) -> Self {
            self.capabilities = Some(input);
            self
        }
        /// <p>The phone number capabilities.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberCapabilities>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `associations`.
        ///
        /// To override the contents of this collection use [`set_associations`](Self::set_associations).
        ///
        /// <p>The phone number associations.</p>
        pub fn associations(
            mut self,
            input: impl Into<crate::model::PhoneNumberAssociation>,
        ) -> Self {
            let mut v = self.associations.unwrap_or_default();
            v.push(input.into());
            self.associations = Some(v);
            self
        }
        /// <p>The phone number associations.</p>
        pub fn set_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberAssociation>>,
        ) -> Self {
            self.associations = input;
            self
        }
        /// <p>The outbound calling name associated with the phone number.</p>
        pub fn calling_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calling_name = Some(input.into());
            self
        }
        /// <p>The outbound calling name associated with the phone number.</p>
        pub fn set_calling_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.calling_name = input;
            self
        }
        /// <p>The outbound calling name status.</p>
        pub fn calling_name_status(mut self, input: crate::model::CallingNameStatus) -> Self {
            self.calling_name_status = Some(input);
            self
        }
        /// <p>The outbound calling name status.</p>
        pub fn set_calling_name_status(
            mut self,
            input: std::option::Option<crate::model::CallingNameStatus>,
        ) -> Self {
            self.calling_name_status = input;
            self
        }
        /// <p>The phone number creation timestamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The phone number creation timestamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The updated phone number timestamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The updated phone number timestamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// <p>The deleted phone number timestamp, in ISO 8601 format.</p>
        pub fn deletion_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deletion_timestamp = Some(input);
            self
        }
        /// <p>The deleted phone number timestamp, in ISO 8601 format.</p>
        pub fn set_deletion_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deletion_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumber`](crate::model::PhoneNumber)
        pub fn build(self) -> crate::model::PhoneNumber {
            crate::model::PhoneNumber {
                phone_number_id: self.phone_number_id,
                e164_phone_number: self.e164_phone_number,
                country: self.country,
                r#type: self.r#type,
                product_type: self.product_type,
                status: self.status,
                capabilities: self.capabilities,
                associations: self.associations,
                calling_name: self.calling_name,
                calling_name_status: self.calling_name_status,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
                deletion_timestamp: self.deletion_timestamp,
            }
        }
    }
}
impl PhoneNumber {
    /// Creates a new builder-style object to manufacture [`PhoneNumber`](crate::model::PhoneNumber)
    pub fn builder() -> crate::model::phone_number::Builder {
        crate::model::phone_number::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CallingNameStatus {
    #[allow(missing_docs)] // documentation missing in model
    Unassigned,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateSucceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CallingNameStatus {
    fn from(s: &str) -> Self {
        match s {
            "Unassigned" => CallingNameStatus::Unassigned,
            "UpdateFailed" => CallingNameStatus::UpdateFailed,
            "UpdateInProgress" => CallingNameStatus::UpdateInProgress,
            "UpdateSucceeded" => CallingNameStatus::UpdateSucceeded,
            other => CallingNameStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CallingNameStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CallingNameStatus::from(s))
    }
}
impl CallingNameStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CallingNameStatus::Unassigned => "Unassigned",
            CallingNameStatus::UpdateFailed => "UpdateFailed",
            CallingNameStatus::UpdateInProgress => "UpdateInProgress",
            CallingNameStatus::UpdateSucceeded => "UpdateSucceeded",
            CallingNameStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Unassigned",
            "UpdateFailed",
            "UpdateInProgress",
            "UpdateSucceeded",
        ]
    }
}
impl AsRef<str> for CallingNameStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The phone number associations, such as Amazon Chime account ID, Amazon Chime user ID, Amazon
/// Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberAssociation {
    /// <p>Contains the ID for the entity specified in Name.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector
    /// ID, or Amazon Chime Voice Connector group ID.</p>
    pub name: std::option::Option<crate::model::PhoneNumberAssociationName>,
    /// <p>The timestamp of the phone number association, in ISO 8601 format.</p>
    pub associated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl PhoneNumberAssociation {
    /// <p>Contains the ID for the entity specified in Name.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector
    /// ID, or Amazon Chime Voice Connector group ID.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::PhoneNumberAssociationName> {
        self.name.as_ref()
    }
    /// <p>The timestamp of the phone number association, in ISO 8601 format.</p>
    pub fn associated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.associated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for PhoneNumberAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberAssociation");
        formatter.field("value", &self.value);
        formatter.field("name", &self.name);
        formatter.field("associated_timestamp", &self.associated_timestamp);
        formatter.finish()
    }
}
/// See [`PhoneNumberAssociation`](crate::model::PhoneNumberAssociation)
pub mod phone_number_association {
    /// A builder for [`PhoneNumberAssociation`](crate::model::PhoneNumberAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<crate::model::PhoneNumberAssociationName>,
        pub(crate) associated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Contains the ID for the entity specified in Name.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Contains the ID for the entity specified in Name.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector
        /// ID, or Amazon Chime Voice Connector group ID.</p>
        pub fn name(mut self, input: crate::model::PhoneNumberAssociationName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector
        /// ID, or Amazon Chime Voice Connector group ID.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberAssociationName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The timestamp of the phone number association, in ISO 8601 format.</p>
        pub fn associated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.associated_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the phone number association, in ISO 8601 format.</p>
        pub fn set_associated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.associated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberAssociation`](crate::model::PhoneNumberAssociation)
        pub fn build(self) -> crate::model::PhoneNumberAssociation {
            crate::model::PhoneNumberAssociation {
                value: self.value,
                name: self.name,
                associated_timestamp: self.associated_timestamp,
            }
        }
    }
}
impl PhoneNumberAssociation {
    /// Creates a new builder-style object to manufacture [`PhoneNumberAssociation`](crate::model::PhoneNumberAssociation)
    pub fn builder() -> crate::model::phone_number_association::Builder {
        crate::model::phone_number_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberAssociationName {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    SipRuleId,
    #[allow(missing_docs)] // documentation missing in model
    UserId,
    #[allow(missing_docs)] // documentation missing in model
    VoiceConnectorGroupId,
    #[allow(missing_docs)] // documentation missing in model
    VoiceConnectorId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberAssociationName {
    fn from(s: &str) -> Self {
        match s {
            "AccountId" => PhoneNumberAssociationName::AccountId,
            "SipRuleId" => PhoneNumberAssociationName::SipRuleId,
            "UserId" => PhoneNumberAssociationName::UserId,
            "VoiceConnectorGroupId" => PhoneNumberAssociationName::VoiceConnectorGroupId,
            "VoiceConnectorId" => PhoneNumberAssociationName::VoiceConnectorId,
            other => PhoneNumberAssociationName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberAssociationName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberAssociationName::from(s))
    }
}
impl PhoneNumberAssociationName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberAssociationName::AccountId => "AccountId",
            PhoneNumberAssociationName::SipRuleId => "SipRuleId",
            PhoneNumberAssociationName::UserId => "UserId",
            PhoneNumberAssociationName::VoiceConnectorGroupId => "VoiceConnectorGroupId",
            PhoneNumberAssociationName::VoiceConnectorId => "VoiceConnectorId",
            PhoneNumberAssociationName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccountId",
            "SipRuleId",
            "UserId",
            "VoiceConnectorGroupId",
            "VoiceConnectorId",
        ]
    }
}
impl AsRef<str> for PhoneNumberAssociationName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The phone number capabilities for Amazon Chime Business Calling phone numbers, such as enabled
/// inbound and outbound calling and text messaging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberCapabilities {
    /// <p>Allows or denies inbound calling for the specified phone number.</p>
    pub inbound_call: std::option::Option<bool>,
    /// <p>Allows or denies outbound calling for the specified phone number.</p>
    pub outbound_call: std::option::Option<bool>,
    /// <p>Allows or denies inbound SMS messaging for the specified phone number.</p>
    pub inbound_sms: std::option::Option<bool>,
    /// <p>Allows or denies outbound SMS messaging for the specified phone number.</p>
    pub outbound_sms: std::option::Option<bool>,
    /// <p>Allows or denies inbound MMS messaging for the specified phone number.</p>
    pub inbound_mms: std::option::Option<bool>,
    /// <p>Allows or denies outbound MMS messaging for the specified phone number.</p>
    pub outbound_mms: std::option::Option<bool>,
}
impl PhoneNumberCapabilities {
    /// <p>Allows or denies inbound calling for the specified phone number.</p>
    pub fn inbound_call(&self) -> std::option::Option<bool> {
        self.inbound_call
    }
    /// <p>Allows or denies outbound calling for the specified phone number.</p>
    pub fn outbound_call(&self) -> std::option::Option<bool> {
        self.outbound_call
    }
    /// <p>Allows or denies inbound SMS messaging for the specified phone number.</p>
    pub fn inbound_sms(&self) -> std::option::Option<bool> {
        self.inbound_sms
    }
    /// <p>Allows or denies outbound SMS messaging for the specified phone number.</p>
    pub fn outbound_sms(&self) -> std::option::Option<bool> {
        self.outbound_sms
    }
    /// <p>Allows or denies inbound MMS messaging for the specified phone number.</p>
    pub fn inbound_mms(&self) -> std::option::Option<bool> {
        self.inbound_mms
    }
    /// <p>Allows or denies outbound MMS messaging for the specified phone number.</p>
    pub fn outbound_mms(&self) -> std::option::Option<bool> {
        self.outbound_mms
    }
}
impl std::fmt::Debug for PhoneNumberCapabilities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberCapabilities");
        formatter.field("inbound_call", &self.inbound_call);
        formatter.field("outbound_call", &self.outbound_call);
        formatter.field("inbound_sms", &self.inbound_sms);
        formatter.field("outbound_sms", &self.outbound_sms);
        formatter.field("inbound_mms", &self.inbound_mms);
        formatter.field("outbound_mms", &self.outbound_mms);
        formatter.finish()
    }
}
/// See [`PhoneNumberCapabilities`](crate::model::PhoneNumberCapabilities)
pub mod phone_number_capabilities {
    /// A builder for [`PhoneNumberCapabilities`](crate::model::PhoneNumberCapabilities)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inbound_call: std::option::Option<bool>,
        pub(crate) outbound_call: std::option::Option<bool>,
        pub(crate) inbound_sms: std::option::Option<bool>,
        pub(crate) outbound_sms: std::option::Option<bool>,
        pub(crate) inbound_mms: std::option::Option<bool>,
        pub(crate) outbound_mms: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Allows or denies inbound calling for the specified phone number.</p>
        pub fn inbound_call(mut self, input: bool) -> Self {
            self.inbound_call = Some(input);
            self
        }
        /// <p>Allows or denies inbound calling for the specified phone number.</p>
        pub fn set_inbound_call(mut self, input: std::option::Option<bool>) -> Self {
            self.inbound_call = input;
            self
        }
        /// <p>Allows or denies outbound calling for the specified phone number.</p>
        pub fn outbound_call(mut self, input: bool) -> Self {
            self.outbound_call = Some(input);
            self
        }
        /// <p>Allows or denies outbound calling for the specified phone number.</p>
        pub fn set_outbound_call(mut self, input: std::option::Option<bool>) -> Self {
            self.outbound_call = input;
            self
        }
        /// <p>Allows or denies inbound SMS messaging for the specified phone number.</p>
        pub fn inbound_sms(mut self, input: bool) -> Self {
            self.inbound_sms = Some(input);
            self
        }
        /// <p>Allows or denies inbound SMS messaging for the specified phone number.</p>
        pub fn set_inbound_sms(mut self, input: std::option::Option<bool>) -> Self {
            self.inbound_sms = input;
            self
        }
        /// <p>Allows or denies outbound SMS messaging for the specified phone number.</p>
        pub fn outbound_sms(mut self, input: bool) -> Self {
            self.outbound_sms = Some(input);
            self
        }
        /// <p>Allows or denies outbound SMS messaging for the specified phone number.</p>
        pub fn set_outbound_sms(mut self, input: std::option::Option<bool>) -> Self {
            self.outbound_sms = input;
            self
        }
        /// <p>Allows or denies inbound MMS messaging for the specified phone number.</p>
        pub fn inbound_mms(mut self, input: bool) -> Self {
            self.inbound_mms = Some(input);
            self
        }
        /// <p>Allows or denies inbound MMS messaging for the specified phone number.</p>
        pub fn set_inbound_mms(mut self, input: std::option::Option<bool>) -> Self {
            self.inbound_mms = input;
            self
        }
        /// <p>Allows or denies outbound MMS messaging for the specified phone number.</p>
        pub fn outbound_mms(mut self, input: bool) -> Self {
            self.outbound_mms = Some(input);
            self
        }
        /// <p>Allows or denies outbound MMS messaging for the specified phone number.</p>
        pub fn set_outbound_mms(mut self, input: std::option::Option<bool>) -> Self {
            self.outbound_mms = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberCapabilities`](crate::model::PhoneNumberCapabilities)
        pub fn build(self) -> crate::model::PhoneNumberCapabilities {
            crate::model::PhoneNumberCapabilities {
                inbound_call: self.inbound_call,
                outbound_call: self.outbound_call,
                inbound_sms: self.inbound_sms,
                outbound_sms: self.outbound_sms,
                inbound_mms: self.inbound_mms,
                outbound_mms: self.outbound_mms,
            }
        }
    }
}
impl PhoneNumberCapabilities {
    /// Creates a new builder-style object to manufacture [`PhoneNumberCapabilities`](crate::model::PhoneNumberCapabilities)
    pub fn builder() -> crate::model::phone_number_capabilities::Builder {
        crate::model::phone_number_capabilities::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberStatus {
    #[allow(missing_docs)] // documentation missing in model
    AcquireFailed,
    #[allow(missing_docs)] // documentation missing in model
    AcquireInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Assigned,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ReleaseFailed,
    #[allow(missing_docs)] // documentation missing in model
    ReleaseInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Unassigned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberStatus {
    fn from(s: &str) -> Self {
        match s {
            "AcquireFailed" => PhoneNumberStatus::AcquireFailed,
            "AcquireInProgress" => PhoneNumberStatus::AcquireInProgress,
            "Assigned" => PhoneNumberStatus::Assigned,
            "DeleteFailed" => PhoneNumberStatus::DeleteFailed,
            "DeleteInProgress" => PhoneNumberStatus::DeleteInProgress,
            "ReleaseFailed" => PhoneNumberStatus::ReleaseFailed,
            "ReleaseInProgress" => PhoneNumberStatus::ReleaseInProgress,
            "Unassigned" => PhoneNumberStatus::Unassigned,
            other => PhoneNumberStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberStatus::from(s))
    }
}
impl PhoneNumberStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberStatus::AcquireFailed => "AcquireFailed",
            PhoneNumberStatus::AcquireInProgress => "AcquireInProgress",
            PhoneNumberStatus::Assigned => "Assigned",
            PhoneNumberStatus::DeleteFailed => "DeleteFailed",
            PhoneNumberStatus::DeleteInProgress => "DeleteInProgress",
            PhoneNumberStatus::ReleaseFailed => "ReleaseFailed",
            PhoneNumberStatus::ReleaseInProgress => "ReleaseInProgress",
            PhoneNumberStatus::Unassigned => "Unassigned",
            PhoneNumberStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AcquireFailed",
            "AcquireInProgress",
            "Assigned",
            "DeleteFailed",
            "DeleteInProgress",
            "ReleaseFailed",
            "ReleaseInProgress",
            "Unassigned",
        ]
    }
}
impl AsRef<str> for PhoneNumberStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberProductType {
    #[allow(missing_docs)] // documentation missing in model
    BusinessCalling,
    #[allow(missing_docs)] // documentation missing in model
    SipMediaApplicationDialIn,
    #[allow(missing_docs)] // documentation missing in model
    VoiceConnector,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberProductType {
    fn from(s: &str) -> Self {
        match s {
            "BusinessCalling" => PhoneNumberProductType::BusinessCalling,
            "SipMediaApplicationDialIn" => PhoneNumberProductType::SipMediaApplicationDialIn,
            "VoiceConnector" => PhoneNumberProductType::VoiceConnector,
            other => PhoneNumberProductType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberProductType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberProductType::from(s))
    }
}
impl PhoneNumberProductType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberProductType::BusinessCalling => "BusinessCalling",
            PhoneNumberProductType::SipMediaApplicationDialIn => "SipMediaApplicationDialIn",
            PhoneNumberProductType::VoiceConnector => "VoiceConnector",
            PhoneNumberProductType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BusinessCalling",
            "SipMediaApplicationDialIn",
            "VoiceConnector",
        ]
    }
}
impl AsRef<str> for PhoneNumberProductType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberType {
    #[allow(missing_docs)] // documentation missing in model
    Local,
    #[allow(missing_docs)] // documentation missing in model
    TollFree,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberType {
    fn from(s: &str) -> Self {
        match s {
            "Local" => PhoneNumberType::Local,
            "TollFree" => PhoneNumberType::TollFree,
            other => PhoneNumberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberType::from(s))
    }
}
impl PhoneNumberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberType::Local => "Local",
            PhoneNumberType::TollFree => "TollFree",
            PhoneNumberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Local", "TollFree"]
    }
}
impl AsRef<str> for PhoneNumberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets designated for
/// storing call detail records.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceConnectorSettings {
    /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
    pub cdr_bucket: std::option::Option<std::string::String>,
}
impl VoiceConnectorSettings {
    /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
    pub fn cdr_bucket(&self) -> std::option::Option<&str> {
        self.cdr_bucket.as_deref()
    }
}
impl std::fmt::Debug for VoiceConnectorSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceConnectorSettings");
        formatter.field("cdr_bucket", &self.cdr_bucket);
        formatter.finish()
    }
}
/// See [`VoiceConnectorSettings`](crate::model::VoiceConnectorSettings)
pub mod voice_connector_settings {
    /// A builder for [`VoiceConnectorSettings`](crate::model::VoiceConnectorSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cdr_bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
        pub fn cdr_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdr_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
        pub fn set_cdr_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cdr_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceConnectorSettings`](crate::model::VoiceConnectorSettings)
        pub fn build(self) -> crate::model::VoiceConnectorSettings {
            crate::model::VoiceConnectorSettings {
                cdr_bucket: self.cdr_bucket,
            }
        }
    }
}
impl VoiceConnectorSettings {
    /// Creates a new builder-style object to manufacture [`VoiceConnectorSettings`](crate::model::VoiceConnectorSettings)
    pub fn builder() -> crate::model::voice_connector_settings::Builder {
        crate::model::voice_connector_settings::Builder::default()
    }
}

/// <p>The Amazon Chime Business Calling settings for the administrator's AWS account. Includes any
/// Amazon S3 buckets designated for storing call detail records.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BusinessCallingSettings {
    /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
    pub cdr_bucket: std::option::Option<std::string::String>,
}
impl BusinessCallingSettings {
    /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
    pub fn cdr_bucket(&self) -> std::option::Option<&str> {
        self.cdr_bucket.as_deref()
    }
}
impl std::fmt::Debug for BusinessCallingSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BusinessCallingSettings");
        formatter.field("cdr_bucket", &self.cdr_bucket);
        formatter.finish()
    }
}
/// See [`BusinessCallingSettings`](crate::model::BusinessCallingSettings)
pub mod business_calling_settings {
    /// A builder for [`BusinessCallingSettings`](crate::model::BusinessCallingSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cdr_bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
        pub fn cdr_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdr_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket designated for call detail record storage.</p>
        pub fn set_cdr_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cdr_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`BusinessCallingSettings`](crate::model::BusinessCallingSettings)
        pub fn build(self) -> crate::model::BusinessCallingSettings {
            crate::model::BusinessCallingSettings {
                cdr_bucket: self.cdr_bucket,
            }
        }
    }
}
impl BusinessCallingSettings {
    /// Creates a new builder-style object to manufacture [`BusinessCallingSettings`](crate::model::BusinessCallingSettings)
    pub fn builder() -> crate::model::business_calling_settings::Builder {
        crate::model::business_calling_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMode {
    #[allow(missing_docs)] // documentation missing in model
    Restricted,
    #[allow(missing_docs)] // documentation missing in model
    Unrestricted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMode {
    fn from(s: &str) -> Self {
        match s {
            "RESTRICTED" => ChannelMode::Restricted,
            "UNRESTRICTED" => ChannelMode::Unrestricted,
            other => ChannelMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMode::from(s))
    }
}
impl ChannelMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMode::Restricted => "RESTRICTED",
            ChannelMode::Unrestricted => "UNRESTRICTED",
            ChannelMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RESTRICTED", "UNRESTRICTED"]
    }
}
impl AsRef<str> for ChannelMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A resource that allows Enterprise account administrators to configure an interface to receive events from Amazon Chime.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bot {
    /// <p>The bot ID.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The unique ID for the bot user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The bot display name.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The bot type.</p>
    pub bot_type: std::option::Option<crate::model::BotType>,
    /// <p>When true, the bot is stopped from running in your account.</p>
    pub disabled: std::option::Option<bool>,
    /// <p>The bot creation timestamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The updated bot timestamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The bot email address.</p>
    pub bot_email: std::option::Option<std::string::String>,
    /// <p>The security token used to authenticate Amazon Chime with the outgoing event endpoint.</p>
    pub security_token: std::option::Option<std::string::String>,
}
impl Bot {
    /// <p>The bot ID.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The unique ID for the bot user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The bot display name.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The bot type.</p>
    pub fn bot_type(&self) -> std::option::Option<&crate::model::BotType> {
        self.bot_type.as_ref()
    }
    /// <p>When true, the bot is stopped from running in your account.</p>
    pub fn disabled(&self) -> std::option::Option<bool> {
        self.disabled
    }
    /// <p>The bot creation timestamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The updated bot timestamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
    /// <p>The bot email address.</p>
    pub fn bot_email(&self) -> std::option::Option<&str> {
        self.bot_email.as_deref()
    }
    /// <p>The security token used to authenticate Amazon Chime with the outgoing event endpoint.</p>
    pub fn security_token(&self) -> std::option::Option<&str> {
        self.security_token.as_deref()
    }
}
impl std::fmt::Debug for Bot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bot");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("user_id", &self.user_id);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("bot_type", &self.bot_type);
        formatter.field("disabled", &self.disabled);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.field("bot_email", &"*** Sensitive Data Redacted ***");
        formatter.field("security_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Bot`](crate::model::Bot)
pub mod bot {
    /// A builder for [`Bot`](crate::model::Bot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) bot_type: std::option::Option<crate::model::BotType>,
        pub(crate) disabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) bot_email: std::option::Option<std::string::String>,
        pub(crate) security_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The unique ID for the bot user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the bot user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The bot display name.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The bot display name.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The bot type.</p>
        pub fn bot_type(mut self, input: crate::model::BotType) -> Self {
            self.bot_type = Some(input);
            self
        }
        /// <p>The bot type.</p>
        pub fn set_bot_type(mut self, input: std::option::Option<crate::model::BotType>) -> Self {
            self.bot_type = input;
            self
        }
        /// <p>When true, the bot is stopped from running in your account.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>When true, the bot is stopped from running in your account.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// <p>The bot creation timestamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The bot creation timestamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The updated bot timestamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The updated bot timestamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// <p>The bot email address.</p>
        pub fn bot_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_email = Some(input.into());
            self
        }
        /// <p>The bot email address.</p>
        pub fn set_bot_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_email = input;
            self
        }
        /// <p>The security token used to authenticate Amazon Chime with the outgoing event endpoint.</p>
        pub fn security_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_token = Some(input.into());
            self
        }
        /// <p>The security token used to authenticate Amazon Chime with the outgoing event endpoint.</p>
        pub fn set_security_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_token = input;
            self
        }
        /// Consumes the builder and constructs a [`Bot`](crate::model::Bot)
        pub fn build(self) -> crate::model::Bot {
            crate::model::Bot {
                bot_id: self.bot_id,
                user_id: self.user_id,
                display_name: self.display_name,
                bot_type: self.bot_type,
                disabled: self.disabled,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
                bot_email: self.bot_email,
                security_token: self.security_token,
            }
        }
    }
}
impl Bot {
    /// Creates a new builder-style object to manufacture [`Bot`](crate::model::Bot)
    pub fn builder() -> crate::model::bot::Builder {
        crate::model::bot::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotType {
    #[allow(missing_docs)] // documentation missing in model
    ChatBot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotType {
    fn from(s: &str) -> Self {
        match s {
            "ChatBot" => BotType::ChatBot,
            other => BotType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotType::from(s))
    }
}
impl BotType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotType::ChatBot => "ChatBot",
            BotType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ChatBot"]
    }
}
impl AsRef<str> for BotType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings related to the Amazon Chime account. This includes settings that start or stop
/// remote control of shared screens, or start or stop the dial-out option in the Amazon Chime web application. For more information about these settings, see
/// <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountSettings {
    /// <p>Setting that stops or starts remote control of shared screens during meetings.</p>
    pub disable_remote_control: std::option::Option<bool>,
    /// <p>Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more information, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App</a>.</p>
    pub enable_dial_out: std::option::Option<bool>,
}
impl AccountSettings {
    /// <p>Setting that stops or starts remote control of shared screens during meetings.</p>
    pub fn disable_remote_control(&self) -> std::option::Option<bool> {
        self.disable_remote_control
    }
    /// <p>Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more information, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App</a>.</p>
    pub fn enable_dial_out(&self) -> std::option::Option<bool> {
        self.enable_dial_out
    }
}
impl std::fmt::Debug for AccountSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountSettings");
        formatter.field("disable_remote_control", &self.disable_remote_control);
        formatter.field("enable_dial_out", &self.enable_dial_out);
        formatter.finish()
    }
}
/// See [`AccountSettings`](crate::model::AccountSettings)
pub mod account_settings {
    /// A builder for [`AccountSettings`](crate::model::AccountSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disable_remote_control: std::option::Option<bool>,
        pub(crate) enable_dial_out: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Setting that stops or starts remote control of shared screens during meetings.</p>
        pub fn disable_remote_control(mut self, input: bool) -> Self {
            self.disable_remote_control = Some(input);
            self
        }
        /// <p>Setting that stops or starts remote control of shared screens during meetings.</p>
        pub fn set_disable_remote_control(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_remote_control = input;
            self
        }
        /// <p>Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more information, see
        /// <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App</a>.</p>
        pub fn enable_dial_out(mut self, input: bool) -> Self {
            self.enable_dial_out = Some(input);
            self
        }
        /// <p>Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more information, see
        /// <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App</a>.</p>
        pub fn set_enable_dial_out(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_dial_out = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountSettings`](crate::model::AccountSettings)
        pub fn build(self) -> crate::model::AccountSettings {
            crate::model::AccountSettings {
                disable_remote_control: self.disable_remote_control,
                enable_dial_out: self.enable_dial_out,
            }
        }
    }
}
impl AccountSettings {
    /// Creates a new builder-style object to manufacture [`AccountSettings`](crate::model::AccountSettings)
    pub fn builder() -> crate::model::account_settings::Builder {
        crate::model::account_settings::Builder::default()
    }
}

/// <p>The Amazon Chime account details. An AWS account can have multiple Amazon Chime accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Account {
    /// <p>The AWS account ID.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime account name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime account type. For more information about different account types, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration
    /// Guide</i>.</p>
    pub account_type: std::option::Option<crate::model::AccountType>,
    /// <p>The Amazon Chime account creation timestamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The default license for the Amazon Chime account.</p>
    pub default_license: std::option::Option<crate::model::License>,
    /// <p>Supported licenses for the Amazon Chime account.</p>
    pub supported_licenses: std::option::Option<std::vec::Vec<crate::model::License>>,
    /// <p>The status of the account.</p>
    pub account_status: std::option::Option<crate::model::AccountStatus>,
    /// <p>The sign-in delegate groups associated with the account.</p>
    pub signin_delegate_groups:
        std::option::Option<std::vec::Vec<crate::model::SigninDelegateGroup>>,
}
impl Account {
    /// <p>The AWS account ID.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The Amazon Chime account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Chime account name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Chime account type. For more information about different account types, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration
    /// Guide</i>.</p>
    pub fn account_type(&self) -> std::option::Option<&crate::model::AccountType> {
        self.account_type.as_ref()
    }
    /// <p>The Amazon Chime account creation timestamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The default license for the Amazon Chime account.</p>
    pub fn default_license(&self) -> std::option::Option<&crate::model::License> {
        self.default_license.as_ref()
    }
    /// <p>Supported licenses for the Amazon Chime account.</p>
    pub fn supported_licenses(&self) -> std::option::Option<&[crate::model::License]> {
        self.supported_licenses.as_deref()
    }
    /// <p>The status of the account.</p>
    pub fn account_status(&self) -> std::option::Option<&crate::model::AccountStatus> {
        self.account_status.as_ref()
    }
    /// <p>The sign-in delegate groups associated with the account.</p>
    pub fn signin_delegate_groups(
        &self,
    ) -> std::option::Option<&[crate::model::SigninDelegateGroup]> {
        self.signin_delegate_groups.as_deref()
    }
}
impl std::fmt::Debug for Account {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Account");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("account_type", &self.account_type);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("default_license", &self.default_license);
        formatter.field("supported_licenses", &self.supported_licenses);
        formatter.field("account_status", &self.account_status);
        formatter.field("signin_delegate_groups", &self.signin_delegate_groups);
        formatter.finish()
    }
}
/// See [`Account`](crate::model::Account)
pub mod account {
    /// A builder for [`Account`](crate::model::Account)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) account_type: std::option::Option<crate::model::AccountType>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) default_license: std::option::Option<crate::model::License>,
        pub(crate) supported_licenses: std::option::Option<std::vec::Vec<crate::model::License>>,
        pub(crate) account_status: std::option::Option<crate::model::AccountStatus>,
        pub(crate) signin_delegate_groups:
            std::option::Option<std::vec::Vec<crate::model::SigninDelegateGroup>>,
    }
    impl Builder {
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Chime account name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The Amazon Chime account name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Chime account type. For more information about different account types, see
        /// <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration
        /// Guide</i>.</p>
        pub fn account_type(mut self, input: crate::model::AccountType) -> Self {
            self.account_type = Some(input);
            self
        }
        /// <p>The Amazon Chime account type. For more information about different account types, see
        /// <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration
        /// Guide</i>.</p>
        pub fn set_account_type(
            mut self,
            input: std::option::Option<crate::model::AccountType>,
        ) -> Self {
            self.account_type = input;
            self
        }
        /// <p>The Amazon Chime account creation timestamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The Amazon Chime account creation timestamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The default license for the Amazon Chime account.</p>
        pub fn default_license(mut self, input: crate::model::License) -> Self {
            self.default_license = Some(input);
            self
        }
        /// <p>The default license for the Amazon Chime account.</p>
        pub fn set_default_license(
            mut self,
            input: std::option::Option<crate::model::License>,
        ) -> Self {
            self.default_license = input;
            self
        }
        /// Appends an item to `supported_licenses`.
        ///
        /// To override the contents of this collection use [`set_supported_licenses`](Self::set_supported_licenses).
        ///
        /// <p>Supported licenses for the Amazon Chime account.</p>
        pub fn supported_licenses(mut self, input: impl Into<crate::model::License>) -> Self {
            let mut v = self.supported_licenses.unwrap_or_default();
            v.push(input.into());
            self.supported_licenses = Some(v);
            self
        }
        /// <p>Supported licenses for the Amazon Chime account.</p>
        pub fn set_supported_licenses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::License>>,
        ) -> Self {
            self.supported_licenses = input;
            self
        }
        /// <p>The status of the account.</p>
        pub fn account_status(mut self, input: crate::model::AccountStatus) -> Self {
            self.account_status = Some(input);
            self
        }
        /// <p>The status of the account.</p>
        pub fn set_account_status(
            mut self,
            input: std::option::Option<crate::model::AccountStatus>,
        ) -> Self {
            self.account_status = input;
            self
        }
        /// Appends an item to `signin_delegate_groups`.
        ///
        /// To override the contents of this collection use [`set_signin_delegate_groups`](Self::set_signin_delegate_groups).
        ///
        /// <p>The sign-in delegate groups associated with the account.</p>
        pub fn signin_delegate_groups(
            mut self,
            input: impl Into<crate::model::SigninDelegateGroup>,
        ) -> Self {
            let mut v = self.signin_delegate_groups.unwrap_or_default();
            v.push(input.into());
            self.signin_delegate_groups = Some(v);
            self
        }
        /// <p>The sign-in delegate groups associated with the account.</p>
        pub fn set_signin_delegate_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigninDelegateGroup>>,
        ) -> Self {
            self.signin_delegate_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`Account`](crate::model::Account)
        pub fn build(self) -> crate::model::Account {
            crate::model::Account {
                aws_account_id: self.aws_account_id,
                account_id: self.account_id,
                name: self.name,
                account_type: self.account_type,
                created_timestamp: self.created_timestamp,
                default_license: self.default_license,
                supported_licenses: self.supported_licenses,
                account_status: self.account_status,
                signin_delegate_groups: self.signin_delegate_groups,
            }
        }
    }
}
impl Account {
    /// Creates a new builder-style object to manufacture [`Account`](crate::model::Account)
    pub fn builder() -> crate::model::account::Builder {
        crate::model::account::Builder::default()
    }
}

/// <p>An Active Directory (AD) group whose members are granted permission to act as delegates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigninDelegateGroup {
    /// <p>The group name.</p>
    pub group_name: std::option::Option<std::string::String>,
}
impl SigninDelegateGroup {
    /// <p>The group name.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
}
impl std::fmt::Debug for SigninDelegateGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigninDelegateGroup");
        formatter.field("group_name", &self.group_name);
        formatter.finish()
    }
}
/// See [`SigninDelegateGroup`](crate::model::SigninDelegateGroup)
pub mod signin_delegate_group {
    /// A builder for [`SigninDelegateGroup`](crate::model::SigninDelegateGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The group name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The group name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SigninDelegateGroup`](crate::model::SigninDelegateGroup)
        pub fn build(self) -> crate::model::SigninDelegateGroup {
            crate::model::SigninDelegateGroup {
                group_name: self.group_name,
            }
        }
    }
}
impl SigninDelegateGroup {
    /// Creates a new builder-style object to manufacture [`SigninDelegateGroup`](crate::model::SigninDelegateGroup)
    pub fn builder() -> crate::model::signin_delegate_group::Builder {
        crate::model::signin_delegate_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => AccountStatus::Active,
            "Suspended" => AccountStatus::Suspended,
            other => AccountStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountStatus::from(s))
    }
}
impl AccountStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountStatus::Active => "Active",
            AccountStatus::Suspended => "Suspended",
            AccountStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Suspended"]
    }
}
impl AsRef<str> for AccountStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountType {
    #[allow(missing_docs)] // documentation missing in model
    EnterpriseDirectory,
    #[allow(missing_docs)] // documentation missing in model
    EnterpriseLwa,
    #[allow(missing_docs)] // documentation missing in model
    EnterpriseOidc,
    #[allow(missing_docs)] // documentation missing in model
    Team,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountType {
    fn from(s: &str) -> Self {
        match s {
            "EnterpriseDirectory" => AccountType::EnterpriseDirectory,
            "EnterpriseLWA" => AccountType::EnterpriseLwa,
            "EnterpriseOIDC" => AccountType::EnterpriseOidc,
            "Team" => AccountType::Team,
            other => AccountType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountType::from(s))
    }
}
impl AccountType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountType::EnterpriseDirectory => "EnterpriseDirectory",
            AccountType::EnterpriseLwa => "EnterpriseLWA",
            AccountType::EnterpriseOidc => "EnterpriseOIDC",
            AccountType::Team => "Team",
            AccountType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EnterpriseDirectory",
            "EnterpriseLWA",
            "EnterpriseOIDC",
            "Team",
        ]
    }
}
impl AsRef<str> for AccountType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a tag applied to a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &"*** Sensitive Data Redacted ***");
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TranscriptionConfiguration {
    /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
    pub engine_transcribe_settings: std::option::Option<crate::model::EngineTranscribeSettings>,
    /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
    pub engine_transcribe_medical_settings:
        std::option::Option<crate::model::EngineTranscribeMedicalSettings>,
}
impl TranscriptionConfiguration {
    /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
    pub fn engine_transcribe_settings(
        &self,
    ) -> std::option::Option<&crate::model::EngineTranscribeSettings> {
        self.engine_transcribe_settings.as_ref()
    }
    /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
    pub fn engine_transcribe_medical_settings(
        &self,
    ) -> std::option::Option<&crate::model::EngineTranscribeMedicalSettings> {
        self.engine_transcribe_medical_settings.as_ref()
    }
}
impl std::fmt::Debug for TranscriptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TranscriptionConfiguration");
        formatter.field(
            "engine_transcribe_settings",
            &self.engine_transcribe_settings,
        );
        formatter.field(
            "engine_transcribe_medical_settings",
            &self.engine_transcribe_medical_settings,
        );
        formatter.finish()
    }
}
/// See [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
pub mod transcription_configuration {
    /// A builder for [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_transcribe_settings:
            std::option::Option<crate::model::EngineTranscribeSettings>,
        pub(crate) engine_transcribe_medical_settings:
            std::option::Option<crate::model::EngineTranscribeMedicalSettings>,
    }
    impl Builder {
        /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
        pub fn engine_transcribe_settings(
            mut self,
            input: crate::model::EngineTranscribeSettings,
        ) -> Self {
            self.engine_transcribe_settings = Some(input);
            self
        }
        /// <p>The transcription configuration settings passed to Amazon Transcribe.</p>
        pub fn set_engine_transcribe_settings(
            mut self,
            input: std::option::Option<crate::model::EngineTranscribeSettings>,
        ) -> Self {
            self.engine_transcribe_settings = input;
            self
        }
        /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
        pub fn engine_transcribe_medical_settings(
            mut self,
            input: crate::model::EngineTranscribeMedicalSettings,
        ) -> Self {
            self.engine_transcribe_medical_settings = Some(input);
            self
        }
        /// <p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>
        pub fn set_engine_transcribe_medical_settings(
            mut self,
            input: std::option::Option<crate::model::EngineTranscribeMedicalSettings>,
        ) -> Self {
            self.engine_transcribe_medical_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
        pub fn build(self) -> crate::model::TranscriptionConfiguration {
            crate::model::TranscriptionConfiguration {
                engine_transcribe_settings: self.engine_transcribe_settings,
                engine_transcribe_medical_settings: self.engine_transcribe_medical_settings,
            }
        }
    }
}
impl TranscriptionConfiguration {
    /// Creates a new builder-style object to manufacture [`TranscriptionConfiguration`](crate::model::TranscriptionConfiguration)
    pub fn builder() -> crate::model::transcription_configuration::Builder {
        crate::model::transcription_configuration::Builder::default()
    }
}

/// <p>Settings specific to the Amazon Transcribe Medical engine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineTranscribeMedicalSettings {
    /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
    pub language_code: std::option::Option<crate::model::TranscribeMedicalLanguageCode>,
    /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
    pub specialty: std::option::Option<crate::model::TranscribeMedicalSpecialty>,
    /// <p>The type of transcription.</p>
    pub r#type: std::option::Option<crate::model::TranscribeMedicalType>,
    /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub region: std::option::Option<crate::model::TranscribeMedicalRegion>,
}
impl EngineTranscribeMedicalSettings {
    /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
    pub fn language_code(
        &self,
    ) -> std::option::Option<&crate::model::TranscribeMedicalLanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
    pub fn specialty(&self) -> std::option::Option<&crate::model::TranscribeMedicalSpecialty> {
        self.specialty.as_ref()
    }
    /// <p>The type of transcription.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TranscribeMedicalType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
    pub fn vocabulary_name(&self) -> std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub fn region(&self) -> std::option::Option<&crate::model::TranscribeMedicalRegion> {
        self.region.as_ref()
    }
}
impl std::fmt::Debug for EngineTranscribeMedicalSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineTranscribeMedicalSettings");
        formatter.field("language_code", &self.language_code);
        formatter.field("specialty", &self.specialty);
        formatter.field("r#type", &self.r#type);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
pub mod engine_transcribe_medical_settings {
    /// A builder for [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<crate::model::TranscribeMedicalLanguageCode>,
        pub(crate) specialty: std::option::Option<crate::model::TranscribeMedicalSpecialty>,
        pub(crate) r#type: std::option::Option<crate::model::TranscribeMedicalType>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<crate::model::TranscribeMedicalRegion>,
    }
    impl Builder {
        /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
        pub fn language_code(mut self, input: crate::model::TranscribeMedicalLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code specified for the Amazon Transcribe Medical engine.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
        pub fn specialty(mut self, input: crate::model::TranscribeMedicalSpecialty) -> Self {
            self.specialty = Some(input);
            self
        }
        /// <p>The specialty specified for the Amazon Transcribe Medical engine.</p>
        pub fn set_specialty(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalSpecialty>,
        ) -> Self {
            self.specialty = input;
            self
        }
        /// <p>The type of transcription.</p>
        pub fn r#type(mut self, input: crate::model::TranscribeMedicalType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of transcription.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn region(mut self, input: crate::model::TranscribeMedicalRegion) -> Self {
            self.region = Some(input);
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn set_region(
            mut self,
            input: std::option::Option<crate::model::TranscribeMedicalRegion>,
        ) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
        pub fn build(self) -> crate::model::EngineTranscribeMedicalSettings {
            crate::model::EngineTranscribeMedicalSettings {
                language_code: self.language_code,
                specialty: self.specialty,
                r#type: self.r#type,
                vocabulary_name: self.vocabulary_name,
                region: self.region,
            }
        }
    }
}
impl EngineTranscribeMedicalSettings {
    /// Creates a new builder-style object to manufacture [`EngineTranscribeMedicalSettings`](crate::model::EngineTranscribeMedicalSettings)
    pub fn builder() -> crate::model::engine_transcribe_medical_settings::Builder {
        crate::model::engine_transcribe_medical_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalRegion {
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    CaCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast2,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalRegion {
    fn from(s: &str) -> Self {
        match s {
            "ap-southeast-2" => TranscribeMedicalRegion::ApSoutheast2,
            "auto" => TranscribeMedicalRegion::Auto,
            "ca-central-1" => TranscribeMedicalRegion::CaCentral1,
            "eu-west-1" => TranscribeMedicalRegion::EuWest1,
            "us-east-1" => TranscribeMedicalRegion::UsEast1,
            "us-east-2" => TranscribeMedicalRegion::UsEast2,
            "us-west-2" => TranscribeMedicalRegion::UsWest2,
            other => TranscribeMedicalRegion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalRegion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalRegion::from(s))
    }
}
impl TranscribeMedicalRegion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalRegion::ApSoutheast2 => "ap-southeast-2",
            TranscribeMedicalRegion::Auto => "auto",
            TranscribeMedicalRegion::CaCentral1 => "ca-central-1",
            TranscribeMedicalRegion::EuWest1 => "eu-west-1",
            TranscribeMedicalRegion::UsEast1 => "us-east-1",
            TranscribeMedicalRegion::UsEast2 => "us-east-2",
            TranscribeMedicalRegion::UsWest2 => "us-west-2",
            TranscribeMedicalRegion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ap-southeast-2",
            "auto",
            "ca-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
        ]
    }
}
impl AsRef<str> for TranscribeMedicalRegion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalType {
    #[allow(missing_docs)] // documentation missing in model
    Conversation,
    #[allow(missing_docs)] // documentation missing in model
    Dictation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalType {
    fn from(s: &str) -> Self {
        match s {
            "CONVERSATION" => TranscribeMedicalType::Conversation,
            "DICTATION" => TranscribeMedicalType::Dictation,
            other => TranscribeMedicalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalType::from(s))
    }
}
impl TranscribeMedicalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalType::Conversation => "CONVERSATION",
            TranscribeMedicalType::Dictation => "DICTATION",
            TranscribeMedicalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONVERSATION", "DICTATION"]
    }
}
impl AsRef<str> for TranscribeMedicalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalSpecialty {
    #[allow(missing_docs)] // documentation missing in model
    Cardiology,
    #[allow(missing_docs)] // documentation missing in model
    Neurology,
    #[allow(missing_docs)] // documentation missing in model
    Oncology,
    #[allow(missing_docs)] // documentation missing in model
    PrimaryCare,
    #[allow(missing_docs)] // documentation missing in model
    Radiology,
    #[allow(missing_docs)] // documentation missing in model
    Urology,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalSpecialty {
    fn from(s: &str) -> Self {
        match s {
            "CARDIOLOGY" => TranscribeMedicalSpecialty::Cardiology,
            "NEUROLOGY" => TranscribeMedicalSpecialty::Neurology,
            "ONCOLOGY" => TranscribeMedicalSpecialty::Oncology,
            "PRIMARYCARE" => TranscribeMedicalSpecialty::PrimaryCare,
            "RADIOLOGY" => TranscribeMedicalSpecialty::Radiology,
            "UROLOGY" => TranscribeMedicalSpecialty::Urology,
            other => TranscribeMedicalSpecialty::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalSpecialty {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalSpecialty::from(s))
    }
}
impl TranscribeMedicalSpecialty {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalSpecialty::Cardiology => "CARDIOLOGY",
            TranscribeMedicalSpecialty::Neurology => "NEUROLOGY",
            TranscribeMedicalSpecialty::Oncology => "ONCOLOGY",
            TranscribeMedicalSpecialty::PrimaryCare => "PRIMARYCARE",
            TranscribeMedicalSpecialty::Radiology => "RADIOLOGY",
            TranscribeMedicalSpecialty::Urology => "UROLOGY",
            TranscribeMedicalSpecialty::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CARDIOLOGY",
            "NEUROLOGY",
            "ONCOLOGY",
            "PRIMARYCARE",
            "RADIOLOGY",
            "UROLOGY",
        ]
    }
}
impl AsRef<str> for TranscribeMedicalSpecialty {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeMedicalLanguageCode {
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeMedicalLanguageCode {
    fn from(s: &str) -> Self {
        match s {
            "en-US" => TranscribeMedicalLanguageCode::EnUs,
            other => TranscribeMedicalLanguageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeMedicalLanguageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeMedicalLanguageCode::from(s))
    }
}
impl TranscribeMedicalLanguageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeMedicalLanguageCode::EnUs => "en-US",
            TranscribeMedicalLanguageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["en-US"]
    }
}
impl AsRef<str> for TranscribeMedicalLanguageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings specific to the Amazon Transcribe engine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineTranscribeSettings {
    /// <p>The language code specified for the Amazon Transcribe engine.</p>
    pub language_code: std::option::Option<crate::model::TranscribeLanguageCode>,
    /// <p>The filtering method passed to Amazon Transcribe.</p>
    pub vocabulary_filter_method:
        std::option::Option<crate::model::TranscribeVocabularyFilterMethod>,
    /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
    pub vocabulary_filter_name: std::option::Option<std::string::String>,
    /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub region: std::option::Option<crate::model::TranscribeRegion>,
}
impl EngineTranscribeSettings {
    /// <p>The language code specified for the Amazon Transcribe engine.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::TranscribeLanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The filtering method passed to Amazon Transcribe.</p>
    pub fn vocabulary_filter_method(
        &self,
    ) -> std::option::Option<&crate::model::TranscribeVocabularyFilterMethod> {
        self.vocabulary_filter_method.as_ref()
    }
    /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
    pub fn vocabulary_filter_name(&self) -> std::option::Option<&str> {
        self.vocabulary_filter_name.as_deref()
    }
    /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
    pub fn vocabulary_name(&self) -> std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
    pub fn region(&self) -> std::option::Option<&crate::model::TranscribeRegion> {
        self.region.as_ref()
    }
}
impl std::fmt::Debug for EngineTranscribeSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineTranscribeSettings");
        formatter.field("language_code", &self.language_code);
        formatter.field("vocabulary_filter_method", &self.vocabulary_filter_method);
        formatter.field("vocabulary_filter_name", &self.vocabulary_filter_name);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
pub mod engine_transcribe_settings {
    /// A builder for [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<crate::model::TranscribeLanguageCode>,
        pub(crate) vocabulary_filter_method:
            std::option::Option<crate::model::TranscribeVocabularyFilterMethod>,
        pub(crate) vocabulary_filter_name: std::option::Option<std::string::String>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<crate::model::TranscribeRegion>,
    }
    impl Builder {
        /// <p>The language code specified for the Amazon Transcribe engine.</p>
        pub fn language_code(mut self, input: crate::model::TranscribeLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code specified for the Amazon Transcribe engine.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::TranscribeLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The filtering method passed to Amazon Transcribe.</p>
        pub fn vocabulary_filter_method(
            mut self,
            input: crate::model::TranscribeVocabularyFilterMethod,
        ) -> Self {
            self.vocabulary_filter_method = Some(input);
            self
        }
        /// <p>The filtering method passed to Amazon Transcribe.</p>
        pub fn set_vocabulary_filter_method(
            mut self,
            input: std::option::Option<crate::model::TranscribeVocabularyFilterMethod>,
        ) -> Self {
            self.vocabulary_filter_method = input;
            self
        }
        /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
        pub fn vocabulary_filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_filter_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary filter passed to Amazon Transcribe.</p>
        pub fn set_vocabulary_filter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_filter_name = input;
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary passed to Amazon Transcribe.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn region(mut self, input: crate::model::TranscribeRegion) -> Self {
            self.region = Some(input);
            self
        }
        /// <p>The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.</p>
        pub fn set_region(
            mut self,
            input: std::option::Option<crate::model::TranscribeRegion>,
        ) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
        pub fn build(self) -> crate::model::EngineTranscribeSettings {
            crate::model::EngineTranscribeSettings {
                language_code: self.language_code,
                vocabulary_filter_method: self.vocabulary_filter_method,
                vocabulary_filter_name: self.vocabulary_filter_name,
                vocabulary_name: self.vocabulary_name,
                region: self.region,
            }
        }
    }
}
impl EngineTranscribeSettings {
    /// Creates a new builder-style object to manufacture [`EngineTranscribeSettings`](crate::model::EngineTranscribeSettings)
    pub fn builder() -> crate::model::engine_transcribe_settings::Builder {
        crate::model::engine_transcribe_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeRegion {
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast2,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    CaCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest2,
    #[allow(missing_docs)] // documentation missing in model
    SaEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast2,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeRegion {
    fn from(s: &str) -> Self {
        match s {
            "ap-northeast-1" => TranscribeRegion::ApNortheast1,
            "ap-northeast-2" => TranscribeRegion::ApNortheast2,
            "ap-southeast-2" => TranscribeRegion::ApSoutheast2,
            "auto" => TranscribeRegion::Auto,
            "ca-central-1" => TranscribeRegion::CaCentral1,
            "eu-central-1" => TranscribeRegion::EuCentral1,
            "eu-west-1" => TranscribeRegion::EuWest1,
            "eu-west-2" => TranscribeRegion::EuWest2,
            "sa-east-1" => TranscribeRegion::SaEast1,
            "us-east-1" => TranscribeRegion::UsEast1,
            "us-east-2" => TranscribeRegion::UsEast2,
            "us-west-2" => TranscribeRegion::UsWest2,
            other => TranscribeRegion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeRegion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeRegion::from(s))
    }
}
impl TranscribeRegion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeRegion::ApNortheast1 => "ap-northeast-1",
            TranscribeRegion::ApNortheast2 => "ap-northeast-2",
            TranscribeRegion::ApSoutheast2 => "ap-southeast-2",
            TranscribeRegion::Auto => "auto",
            TranscribeRegion::CaCentral1 => "ca-central-1",
            TranscribeRegion::EuCentral1 => "eu-central-1",
            TranscribeRegion::EuWest1 => "eu-west-1",
            TranscribeRegion::EuWest2 => "eu-west-2",
            TranscribeRegion::SaEast1 => "sa-east-1",
            TranscribeRegion::UsEast1 => "us-east-1",
            TranscribeRegion::UsEast2 => "us-east-2",
            TranscribeRegion::UsWest2 => "us-west-2",
            TranscribeRegion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-2",
            "auto",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
        ]
    }
}
impl AsRef<str> for TranscribeRegion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeVocabularyFilterMethod {
    #[allow(missing_docs)] // documentation missing in model
    Mask,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    #[allow(missing_docs)] // documentation missing in model
    Tag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeVocabularyFilterMethod {
    fn from(s: &str) -> Self {
        match s {
            "mask" => TranscribeVocabularyFilterMethod::Mask,
            "remove" => TranscribeVocabularyFilterMethod::Remove,
            "tag" => TranscribeVocabularyFilterMethod::Tag,
            other => TranscribeVocabularyFilterMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeVocabularyFilterMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeVocabularyFilterMethod::from(s))
    }
}
impl TranscribeVocabularyFilterMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeVocabularyFilterMethod::Mask => "mask",
            TranscribeVocabularyFilterMethod::Remove => "remove",
            TranscribeVocabularyFilterMethod::Tag => "tag",
            TranscribeVocabularyFilterMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["mask", "remove", "tag"]
    }
}
impl AsRef<str> for TranscribeVocabularyFilterMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TranscribeLanguageCode {
    #[allow(missing_docs)] // documentation missing in model
    DeDe,
    #[allow(missing_docs)] // documentation missing in model
    EnAu,
    #[allow(missing_docs)] // documentation missing in model
    EnGb,
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    #[allow(missing_docs)] // documentation missing in model
    EsUs,
    #[allow(missing_docs)] // documentation missing in model
    FrCa,
    #[allow(missing_docs)] // documentation missing in model
    FrFr,
    #[allow(missing_docs)] // documentation missing in model
    ItIt,
    #[allow(missing_docs)] // documentation missing in model
    JaJp,
    #[allow(missing_docs)] // documentation missing in model
    KoKr,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TranscribeLanguageCode {
    fn from(s: &str) -> Self {
        match s {
            "de-DE" => TranscribeLanguageCode::DeDe,
            "en-AU" => TranscribeLanguageCode::EnAu,
            "en-GB" => TranscribeLanguageCode::EnGb,
            "en-US" => TranscribeLanguageCode::EnUs,
            "es-US" => TranscribeLanguageCode::EsUs,
            "fr-CA" => TranscribeLanguageCode::FrCa,
            "fr-FR" => TranscribeLanguageCode::FrFr,
            "it-IT" => TranscribeLanguageCode::ItIt,
            "ja-JP" => TranscribeLanguageCode::JaJp,
            "ko-KR" => TranscribeLanguageCode::KoKr,
            "pt-BR" => TranscribeLanguageCode::PtBr,
            "zh-CN" => TranscribeLanguageCode::ZhCn,
            other => TranscribeLanguageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TranscribeLanguageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TranscribeLanguageCode::from(s))
    }
}
impl TranscribeLanguageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TranscribeLanguageCode::DeDe => "de-DE",
            TranscribeLanguageCode::EnAu => "en-AU",
            TranscribeLanguageCode::EnGb => "en-GB",
            TranscribeLanguageCode::EnUs => "en-US",
            TranscribeLanguageCode::EsUs => "es-US",
            TranscribeLanguageCode::FrCa => "fr-CA",
            TranscribeLanguageCode::FrFr => "fr-FR",
            TranscribeLanguageCode::ItIt => "it-IT",
            TranscribeLanguageCode::JaJp => "ja-JP",
            TranscribeLanguageCode::KoKr => "ko-KR",
            TranscribeLanguageCode::PtBr => "pt-BR",
            TranscribeLanguageCode::ZhCn => "zh-CN",
            TranscribeLanguageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "de-DE", "en-AU", "en-GB", "en-US", "es-US", "fr-CA", "fr-FR", "it-IT", "ja-JP",
            "ko-KR", "pt-BR", "zh-CN",
        ]
    }
}
impl AsRef<str> for TranscribeLanguageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMessagePersistenceType {
    #[allow(missing_docs)] // documentation missing in model
    NonPersistent,
    #[allow(missing_docs)] // documentation missing in model
    Persistent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMessagePersistenceType {
    fn from(s: &str) -> Self {
        match s {
            "NON_PERSISTENT" => ChannelMessagePersistenceType::NonPersistent,
            "PERSISTENT" => ChannelMessagePersistenceType::Persistent,
            other => ChannelMessagePersistenceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMessagePersistenceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMessagePersistenceType::from(s))
    }
}
impl ChannelMessagePersistenceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMessagePersistenceType::NonPersistent => "NON_PERSISTENT",
            ChannelMessagePersistenceType::Persistent => "PERSISTENT",
            ChannelMessagePersistenceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NON_PERSISTENT", "PERSISTENT"]
    }
}
impl AsRef<str> for ChannelMessagePersistenceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMessageType {
    #[allow(missing_docs)] // documentation missing in model
    Control,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMessageType {
    fn from(s: &str) -> Self {
        match s {
            "CONTROL" => ChannelMessageType::Control,
            "STANDARD" => ChannelMessageType::Standard,
            other => ChannelMessageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMessageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMessageType::from(s))
    }
}
impl ChannelMessageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMessageType::Control => "CONTROL",
            ChannelMessageType::Standard => "STANDARD",
            ChannelMessageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTROL", "STANDARD"]
    }
}
impl AsRef<str> for ChannelMessageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The SIP credentials used to authenticate requests to your Amazon Chime Voice Connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Credential {
    /// <p>The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII
    /// format.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The RFC2617 compliant password associated with the SIP credentials, in US-ASCII format.</p>
    pub password: std::option::Option<std::string::String>,
}
impl Credential {
    /// <p>The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII
    /// format.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The RFC2617 compliant password associated with the SIP credentials, in US-ASCII format.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for Credential {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Credential");
        formatter.field("username", &"*** Sensitive Data Redacted ***");
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Credential`](crate::model::Credential)
pub mod credential {
    /// A builder for [`Credential`](crate::model::Credential)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII
        /// format.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII
        /// format.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The RFC2617 compliant password associated with the SIP credentials, in US-ASCII format.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The RFC2617 compliant password associated with the SIP credentials, in US-ASCII format.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`Credential`](crate::model::Credential)
        pub fn build(self) -> crate::model::Credential {
            crate::model::Credential {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl Credential {
    /// Creates a new builder-style object to manufacture [`Credential`](crate::model::Credential)
    pub fn builder() -> crate::model::credential::Builder {
        crate::model::credential::Builder::default()
    }
}

/// <p>Termination settings enable your SIP hosts to make outbound calls using your Amazon Chime
/// Voice Connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Termination {
    /// <p>The limit on calls per second. Max value based on account service quota. Default value of
    /// 1.</p>
    pub cps_limit: std::option::Option<i32>,
    /// <p>The default caller ID phone number.</p>
    pub default_phone_number: std::option::Option<std::string::String>,
    /// <p>The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.</p>
    pub calling_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IP addresses allowed to make calls, in CIDR format. Required.</p>
    pub cidr_allowed_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When termination settings are disabled, outbound calls can not be made.</p>
    pub disabled: std::option::Option<bool>,
}
impl Termination {
    /// <p>The limit on calls per second. Max value based on account service quota. Default value of
    /// 1.</p>
    pub fn cps_limit(&self) -> std::option::Option<i32> {
        self.cps_limit
    }
    /// <p>The default caller ID phone number.</p>
    pub fn default_phone_number(&self) -> std::option::Option<&str> {
        self.default_phone_number.as_deref()
    }
    /// <p>The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.</p>
    pub fn calling_regions(&self) -> std::option::Option<&[std::string::String]> {
        self.calling_regions.as_deref()
    }
    /// <p>The IP addresses allowed to make calls, in CIDR format. Required.</p>
    pub fn cidr_allowed_list(&self) -> std::option::Option<&[std::string::String]> {
        self.cidr_allowed_list.as_deref()
    }
    /// <p>When termination settings are disabled, outbound calls can not be made.</p>
    pub fn disabled(&self) -> std::option::Option<bool> {
        self.disabled
    }
}
impl std::fmt::Debug for Termination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Termination");
        formatter.field("cps_limit", &self.cps_limit);
        formatter.field("default_phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("calling_regions", &self.calling_regions);
        formatter.field("cidr_allowed_list", &self.cidr_allowed_list);
        formatter.field("disabled", &self.disabled);
        formatter.finish()
    }
}
/// See [`Termination`](crate::model::Termination)
pub mod termination {
    /// A builder for [`Termination`](crate::model::Termination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cps_limit: std::option::Option<i32>,
        pub(crate) default_phone_number: std::option::Option<std::string::String>,
        pub(crate) calling_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cidr_allowed_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The limit on calls per second. Max value based on account service quota. Default value of
        /// 1.</p>
        pub fn cps_limit(mut self, input: i32) -> Self {
            self.cps_limit = Some(input);
            self
        }
        /// <p>The limit on calls per second. Max value based on account service quota. Default value of
        /// 1.</p>
        pub fn set_cps_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.cps_limit = input;
            self
        }
        /// <p>The default caller ID phone number.</p>
        pub fn default_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_phone_number = Some(input.into());
            self
        }
        /// <p>The default caller ID phone number.</p>
        pub fn set_default_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_phone_number = input;
            self
        }
        /// Appends an item to `calling_regions`.
        ///
        /// To override the contents of this collection use [`set_calling_regions`](Self::set_calling_regions).
        ///
        /// <p>The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.</p>
        pub fn calling_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.calling_regions.unwrap_or_default();
            v.push(input.into());
            self.calling_regions = Some(v);
            self
        }
        /// <p>The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.</p>
        pub fn set_calling_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.calling_regions = input;
            self
        }
        /// Appends an item to `cidr_allowed_list`.
        ///
        /// To override the contents of this collection use [`set_cidr_allowed_list`](Self::set_cidr_allowed_list).
        ///
        /// <p>The IP addresses allowed to make calls, in CIDR format. Required.</p>
        pub fn cidr_allowed_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_allowed_list.unwrap_or_default();
            v.push(input.into());
            self.cidr_allowed_list = Some(v);
            self
        }
        /// <p>The IP addresses allowed to make calls, in CIDR format. Required.</p>
        pub fn set_cidr_allowed_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_allowed_list = input;
            self
        }
        /// <p>When termination settings are disabled, outbound calls can not be made.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>When termination settings are disabled, outbound calls can not be made.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// Consumes the builder and constructs a [`Termination`](crate::model::Termination)
        pub fn build(self) -> crate::model::Termination {
            crate::model::Termination {
                cps_limit: self.cps_limit,
                default_phone_number: self.default_phone_number,
                calling_regions: self.calling_regions,
                cidr_allowed_list: self.cidr_allowed_list,
                disabled: self.disabled,
            }
        }
    }
}
impl Termination {
    /// Creates a new builder-style object to manufacture [`Termination`](crate::model::Termination)
    pub fn builder() -> crate::model::termination::Builder {
        crate::model::termination::Builder::default()
    }
}

/// <p>The streaming configuration associated with an Amazon Chime Voice Connector. Specifies whether
/// media streaming is enabled for sending to Amazon Kinesis, and shows the retention period
/// for the Amazon Kinesis data, in hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingConfiguration {
    /// <p>The retention period, in hours, for the Amazon Kinesis data.</p>
    pub data_retention_in_hours: std::option::Option<i32>,
    /// <p>When true, media streaming to Amazon Kinesis is turned off.</p>
    pub disabled: std::option::Option<bool>,
    /// <p>The streaming notification targets.</p>
    pub streaming_notification_targets:
        std::option::Option<std::vec::Vec<crate::model::StreamingNotificationTarget>>,
}
impl StreamingConfiguration {
    /// <p>The retention period, in hours, for the Amazon Kinesis data.</p>
    pub fn data_retention_in_hours(&self) -> std::option::Option<i32> {
        self.data_retention_in_hours
    }
    /// <p>When true, media streaming to Amazon Kinesis is turned off.</p>
    pub fn disabled(&self) -> std::option::Option<bool> {
        self.disabled
    }
    /// <p>The streaming notification targets.</p>
    pub fn streaming_notification_targets(
        &self,
    ) -> std::option::Option<&[crate::model::StreamingNotificationTarget]> {
        self.streaming_notification_targets.as_deref()
    }
}
impl std::fmt::Debug for StreamingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingConfiguration");
        formatter.field("data_retention_in_hours", &self.data_retention_in_hours);
        formatter.field("disabled", &self.disabled);
        formatter.field(
            "streaming_notification_targets",
            &self.streaming_notification_targets,
        );
        formatter.finish()
    }
}
/// See [`StreamingConfiguration`](crate::model::StreamingConfiguration)
pub mod streaming_configuration {
    /// A builder for [`StreamingConfiguration`](crate::model::StreamingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_retention_in_hours: std::option::Option<i32>,
        pub(crate) disabled: std::option::Option<bool>,
        pub(crate) streaming_notification_targets:
            std::option::Option<std::vec::Vec<crate::model::StreamingNotificationTarget>>,
    }
    impl Builder {
        /// <p>The retention period, in hours, for the Amazon Kinesis data.</p>
        pub fn data_retention_in_hours(mut self, input: i32) -> Self {
            self.data_retention_in_hours = Some(input);
            self
        }
        /// <p>The retention period, in hours, for the Amazon Kinesis data.</p>
        pub fn set_data_retention_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.data_retention_in_hours = input;
            self
        }
        /// <p>When true, media streaming to Amazon Kinesis is turned off.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>When true, media streaming to Amazon Kinesis is turned off.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// Appends an item to `streaming_notification_targets`.
        ///
        /// To override the contents of this collection use [`set_streaming_notification_targets`](Self::set_streaming_notification_targets).
        ///
        /// <p>The streaming notification targets.</p>
        pub fn streaming_notification_targets(
            mut self,
            input: impl Into<crate::model::StreamingNotificationTarget>,
        ) -> Self {
            let mut v = self.streaming_notification_targets.unwrap_or_default();
            v.push(input.into());
            self.streaming_notification_targets = Some(v);
            self
        }
        /// <p>The streaming notification targets.</p>
        pub fn set_streaming_notification_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamingNotificationTarget>>,
        ) -> Self {
            self.streaming_notification_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingConfiguration`](crate::model::StreamingConfiguration)
        pub fn build(self) -> crate::model::StreamingConfiguration {
            crate::model::StreamingConfiguration {
                data_retention_in_hours: self.data_retention_in_hours,
                disabled: self.disabled,
                streaming_notification_targets: self.streaming_notification_targets,
            }
        }
    }
}
impl StreamingConfiguration {
    /// Creates a new builder-style object to manufacture [`StreamingConfiguration`](crate::model::StreamingConfiguration)
    pub fn builder() -> crate::model::streaming_configuration::Builder {
        crate::model::streaming_configuration::Builder::default()
    }
}

/// <p>The targeted recipient for a streaming configuration notification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingNotificationTarget {
    /// <p>The streaming notification target.</p>
    pub notification_target: std::option::Option<crate::model::NotificationTarget>,
}
impl StreamingNotificationTarget {
    /// <p>The streaming notification target.</p>
    pub fn notification_target(&self) -> std::option::Option<&crate::model::NotificationTarget> {
        self.notification_target.as_ref()
    }
}
impl std::fmt::Debug for StreamingNotificationTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingNotificationTarget");
        formatter.field("notification_target", &self.notification_target);
        formatter.finish()
    }
}
/// See [`StreamingNotificationTarget`](crate::model::StreamingNotificationTarget)
pub mod streaming_notification_target {
    /// A builder for [`StreamingNotificationTarget`](crate::model::StreamingNotificationTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_target: std::option::Option<crate::model::NotificationTarget>,
    }
    impl Builder {
        /// <p>The streaming notification target.</p>
        pub fn notification_target(mut self, input: crate::model::NotificationTarget) -> Self {
            self.notification_target = Some(input);
            self
        }
        /// <p>The streaming notification target.</p>
        pub fn set_notification_target(
            mut self,
            input: std::option::Option<crate::model::NotificationTarget>,
        ) -> Self {
            self.notification_target = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingNotificationTarget`](crate::model::StreamingNotificationTarget)
        pub fn build(self) -> crate::model::StreamingNotificationTarget {
            crate::model::StreamingNotificationTarget {
                notification_target: self.notification_target,
            }
        }
    }
}
impl StreamingNotificationTarget {
    /// Creates a new builder-style object to manufacture [`StreamingNotificationTarget`](crate::model::StreamingNotificationTarget)
    pub fn builder() -> crate::model::streaming_notification_target::Builder {
        crate::model::streaming_notification_target::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationTarget {
    #[allow(missing_docs)] // documentation missing in model
    EventBridge,
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    #[allow(missing_docs)] // documentation missing in model
    Sqs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationTarget {
    fn from(s: &str) -> Self {
        match s {
            "EventBridge" => NotificationTarget::EventBridge,
            "SNS" => NotificationTarget::Sns,
            "SQS" => NotificationTarget::Sqs,
            other => NotificationTarget::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationTarget {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationTarget::from(s))
    }
}
impl NotificationTarget {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationTarget::EventBridge => "EventBridge",
            NotificationTarget::Sns => "SNS",
            NotificationTarget::Sqs => "SQS",
            NotificationTarget::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EventBridge", "SNS", "SQS"]
    }
}
impl AsRef<str> for NotificationTarget {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The proxy configuration for an Amazon Chime Voice Connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Proxy {
    /// <p>The default number of minutes allowed for proxy sessions.</p>
    pub default_session_expiry_minutes: std::option::Option<i32>,
    /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
    pub disabled: std::option::Option<bool>,
    /// <p>The phone number to route calls to after a proxy session expires.</p>
    pub fall_back_phone_number: std::option::Option<std::string::String>,
    /// <p>The countries for proxy phone numbers to be selected from.</p>
    pub phone_number_countries: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Proxy {
    /// <p>The default number of minutes allowed for proxy sessions.</p>
    pub fn default_session_expiry_minutes(&self) -> std::option::Option<i32> {
        self.default_session_expiry_minutes
    }
    /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
    pub fn disabled(&self) -> std::option::Option<bool> {
        self.disabled
    }
    /// <p>The phone number to route calls to after a proxy session expires.</p>
    pub fn fall_back_phone_number(&self) -> std::option::Option<&str> {
        self.fall_back_phone_number.as_deref()
    }
    /// <p>The countries for proxy phone numbers to be selected from.</p>
    pub fn phone_number_countries(&self) -> std::option::Option<&[std::string::String]> {
        self.phone_number_countries.as_deref()
    }
}
impl std::fmt::Debug for Proxy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Proxy");
        formatter.field(
            "default_session_expiry_minutes",
            &self.default_session_expiry_minutes,
        );
        formatter.field("disabled", &self.disabled);
        formatter.field("fall_back_phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("phone_number_countries", &self.phone_number_countries);
        formatter.finish()
    }
}
/// See [`Proxy`](crate::model::Proxy)
pub mod proxy {
    /// A builder for [`Proxy`](crate::model::Proxy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_session_expiry_minutes: std::option::Option<i32>,
        pub(crate) disabled: std::option::Option<bool>,
        pub(crate) fall_back_phone_number: std::option::Option<std::string::String>,
        pub(crate) phone_number_countries: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The default number of minutes allowed for proxy sessions.</p>
        pub fn default_session_expiry_minutes(mut self, input: i32) -> Self {
            self.default_session_expiry_minutes = Some(input);
            self
        }
        /// <p>The default number of minutes allowed for proxy sessions.</p>
        pub fn set_default_session_expiry_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.default_session_expiry_minutes = input;
            self
        }
        /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// <p>The phone number to route calls to after a proxy session expires.</p>
        pub fn fall_back_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.fall_back_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number to route calls to after a proxy session expires.</p>
        pub fn set_fall_back_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fall_back_phone_number = input;
            self
        }
        /// Appends an item to `phone_number_countries`.
        ///
        /// To override the contents of this collection use [`set_phone_number_countries`](Self::set_phone_number_countries).
        ///
        /// <p>The countries for proxy phone numbers to be selected from.</p>
        pub fn phone_number_countries(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.phone_number_countries.unwrap_or_default();
            v.push(input.into());
            self.phone_number_countries = Some(v);
            self
        }
        /// <p>The countries for proxy phone numbers to be selected from.</p>
        pub fn set_phone_number_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.phone_number_countries = input;
            self
        }
        /// Consumes the builder and constructs a [`Proxy`](crate::model::Proxy)
        pub fn build(self) -> crate::model::Proxy {
            crate::model::Proxy {
                default_session_expiry_minutes: self.default_session_expiry_minutes,
                disabled: self.disabled,
                fall_back_phone_number: self.fall_back_phone_number,
                phone_number_countries: self.phone_number_countries,
            }
        }
    }
}
impl Proxy {
    /// Creates a new builder-style object to manufacture [`Proxy`](crate::model::Proxy)
    pub fn builder() -> crate::model::proxy::Builder {
        crate::model::proxy::Builder::default()
    }
}

/// <p>Origination settings enable your SIP hosts to receive inbound calls using your Amazon Chime
/// Voice Connector.</p>
/// <note>
/// <p>The parameters listed below are not required, but you must use at least one. </p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Origination {
    /// <p>The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1.
    /// Maximum value of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.</p>
    pub routes: std::option::Option<std::vec::Vec<crate::model::OriginationRoute>>,
    /// <p>When origination settings are disabled, inbound calls are not enabled for your Amazon Chime
    /// Voice Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.</p>
    pub disabled: std::option::Option<bool>,
}
impl Origination {
    /// <p>The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1.
    /// Maximum value of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.</p>
    pub fn routes(&self) -> std::option::Option<&[crate::model::OriginationRoute]> {
        self.routes.as_deref()
    }
    /// <p>When origination settings are disabled, inbound calls are not enabled for your Amazon Chime
    /// Voice Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.</p>
    pub fn disabled(&self) -> std::option::Option<bool> {
        self.disabled
    }
}
impl std::fmt::Debug for Origination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Origination");
        formatter.field("routes", &self.routes);
        formatter.field("disabled", &self.disabled);
        formatter.finish()
    }
}
/// See [`Origination`](crate::model::Origination)
pub mod origination {
    /// A builder for [`Origination`](crate::model::Origination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routes: std::option::Option<std::vec::Vec<crate::model::OriginationRoute>>,
        pub(crate) disabled: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `routes`.
        ///
        /// To override the contents of this collection use [`set_routes`](Self::set_routes).
        ///
        /// <p>The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1.
        /// Maximum value of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.</p>
        pub fn routes(mut self, input: impl Into<crate::model::OriginationRoute>) -> Self {
            let mut v = self.routes.unwrap_or_default();
            v.push(input.into());
            self.routes = Some(v);
            self
        }
        /// <p>The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1.
        /// Maximum value of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.</p>
        pub fn set_routes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OriginationRoute>>,
        ) -> Self {
            self.routes = input;
            self
        }
        /// <p>When origination settings are disabled, inbound calls are not enabled for your Amazon Chime
        /// Voice Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>When origination settings are disabled, inbound calls are not enabled for your Amazon Chime
        /// Voice Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// Consumes the builder and constructs a [`Origination`](crate::model::Origination)
        pub fn build(self) -> crate::model::Origination {
            crate::model::Origination {
                routes: self.routes,
                disabled: self.disabled,
            }
        }
    }
}
impl Origination {
    /// Creates a new builder-style object to manufacture [`Origination`](crate::model::Origination)
    pub fn builder() -> crate::model::origination::Builder {
        crate::model::origination::Builder::default()
    }
}

/// <p>Origination routes define call distribution properties for your SIP hosts to receive inbound
/// calls using your Amazon Chime Voice Connector. Limit: Ten origination routes for each
/// Amazon Chime Voice Connector.</p>
/// <note>
/// <p>The parameters listed below are not required, but you must use at least one. </p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginationRoute {
    /// <p>The FQDN or IP address to contact for origination traffic.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>The designated origination route port. Defaults to 5060.</p>
    pub port: std::option::Option<i32>,
    /// <p>The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.</p>
    pub protocol: std::option::Option<crate::model::OriginationRouteProtocol>,
    /// <p>The priority associated with the host, with 1 being the highest priority. Higher priority
    /// hosts are attempted first.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The weight associated with the host. If hosts are equal in priority, calls are redistributed among
    /// them based on their relative weight.</p>
    pub weight: std::option::Option<i32>,
}
impl OriginationRoute {
    /// <p>The FQDN or IP address to contact for origination traffic.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>The designated origination route port. Defaults to 5060.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::OriginationRouteProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The priority associated with the host, with 1 being the highest priority. Higher priority
    /// hosts are attempted first.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The weight associated with the host. If hosts are equal in priority, calls are redistributed among
    /// them based on their relative weight.</p>
    pub fn weight(&self) -> std::option::Option<i32> {
        self.weight
    }
}
impl std::fmt::Debug for OriginationRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginationRoute");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("protocol", &self.protocol);
        formatter.field("priority", &self.priority);
        formatter.field("weight", &self.weight);
        formatter.finish()
    }
}
/// See [`OriginationRoute`](crate::model::OriginationRoute)
pub mod origination_route {
    /// A builder for [`OriginationRoute`](crate::model::OriginationRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::OriginationRouteProtocol>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) weight: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The FQDN or IP address to contact for origination traffic.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>The FQDN or IP address to contact for origination traffic.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>The designated origination route port. Defaults to 5060.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The designated origination route port. Defaults to 5060.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.</p>
        pub fn protocol(mut self, input: crate::model::OriginationRouteProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::OriginationRouteProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The priority associated with the host, with 1 being the highest priority. Higher priority
        /// hosts are attempted first.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority associated with the host, with 1 being the highest priority. Higher priority
        /// hosts are attempted first.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The weight associated with the host. If hosts are equal in priority, calls are redistributed among
        /// them based on their relative weight.</p>
        pub fn weight(mut self, input: i32) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>The weight associated with the host. If hosts are equal in priority, calls are redistributed among
        /// them based on their relative weight.</p>
        pub fn set_weight(mut self, input: std::option::Option<i32>) -> Self {
            self.weight = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginationRoute`](crate::model::OriginationRoute)
        pub fn build(self) -> crate::model::OriginationRoute {
            crate::model::OriginationRoute {
                host: self.host,
                port: self.port,
                protocol: self.protocol,
                priority: self.priority,
                weight: self.weight,
            }
        }
    }
}
impl OriginationRoute {
    /// Creates a new builder-style object to manufacture [`OriginationRoute`](crate::model::OriginationRoute)
    pub fn builder() -> crate::model::origination_route::Builder {
        crate::model::origination_route::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OriginationRouteProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OriginationRouteProtocol {
    fn from(s: &str) -> Self {
        match s {
            "TCP" => OriginationRouteProtocol::Tcp,
            "UDP" => OriginationRouteProtocol::Udp,
            other => OriginationRouteProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OriginationRouteProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OriginationRouteProtocol::from(s))
    }
}
impl OriginationRouteProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OriginationRouteProtocol::Tcp => "TCP",
            OriginationRouteProtocol::Udp => "UDP",
            OriginationRouteProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TCP", "UDP"]
    }
}
impl AsRef<str> for OriginationRouteProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The logging configuration associated with an Amazon Chime Voice Connector. Specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfiguration {
    /// <p>When true, enables SIP message logs for sending to Amazon CloudWatch Logs.</p>
    pub enable_sip_logs: std::option::Option<bool>,
}
impl LoggingConfiguration {
    /// <p>When true, enables SIP message logs for sending to Amazon CloudWatch Logs.</p>
    pub fn enable_sip_logs(&self) -> std::option::Option<bool> {
        self.enable_sip_logs
    }
}
impl std::fmt::Debug for LoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfiguration");
        formatter.field("enable_sip_logs", &self.enable_sip_logs);
        formatter.finish()
    }
}
/// See [`LoggingConfiguration`](crate::model::LoggingConfiguration)
pub mod logging_configuration {
    /// A builder for [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_sip_logs: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>When true, enables SIP message logs for sending to Amazon CloudWatch Logs.</p>
        pub fn enable_sip_logs(mut self, input: bool) -> Self {
            self.enable_sip_logs = Some(input);
            self
        }
        /// <p>When true, enables SIP message logs for sending to Amazon CloudWatch Logs.</p>
        pub fn set_enable_sip_logs(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_sip_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfiguration`](crate::model::LoggingConfiguration)
        pub fn build(self) -> crate::model::LoggingConfiguration {
            crate::model::LoggingConfiguration {
                enable_sip_logs: self.enable_sip_logs,
            }
        }
    }
}
impl LoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    pub fn builder() -> crate::model::logging_configuration::Builder {
        crate::model::logging_configuration::Builder::default()
    }
}

/// <p>The emergency calling configuration details associated with an Amazon Chime Voice Connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmergencyCallingConfiguration {
    /// <p>The Dialed Number Identification Service (DNIS) emergency calling configuration details.</p>
    pub dnis: std::option::Option<std::vec::Vec<crate::model::DnisEmergencyCallingConfiguration>>,
}
impl EmergencyCallingConfiguration {
    /// <p>The Dialed Number Identification Service (DNIS) emergency calling configuration details.</p>
    pub fn dnis(&self) -> std::option::Option<&[crate::model::DnisEmergencyCallingConfiguration]> {
        self.dnis.as_deref()
    }
}
impl std::fmt::Debug for EmergencyCallingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmergencyCallingConfiguration");
        formatter.field("dnis", &self.dnis);
        formatter.finish()
    }
}
/// See [`EmergencyCallingConfiguration`](crate::model::EmergencyCallingConfiguration)
pub mod emergency_calling_configuration {
    /// A builder for [`EmergencyCallingConfiguration`](crate::model::EmergencyCallingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dnis:
            std::option::Option<std::vec::Vec<crate::model::DnisEmergencyCallingConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `dnis`.
        ///
        /// To override the contents of this collection use [`set_dnis`](Self::set_dnis).
        ///
        /// <p>The Dialed Number Identification Service (DNIS) emergency calling configuration details.</p>
        pub fn dnis(
            mut self,
            input: impl Into<crate::model::DnisEmergencyCallingConfiguration>,
        ) -> Self {
            let mut v = self.dnis.unwrap_or_default();
            v.push(input.into());
            self.dnis = Some(v);
            self
        }
        /// <p>The Dialed Number Identification Service (DNIS) emergency calling configuration details.</p>
        pub fn set_dnis(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DnisEmergencyCallingConfiguration>,
            >,
        ) -> Self {
            self.dnis = input;
            self
        }
        /// Consumes the builder and constructs a [`EmergencyCallingConfiguration`](crate::model::EmergencyCallingConfiguration)
        pub fn build(self) -> crate::model::EmergencyCallingConfiguration {
            crate::model::EmergencyCallingConfiguration { dnis: self.dnis }
        }
    }
}
impl EmergencyCallingConfiguration {
    /// Creates a new builder-style object to manufacture [`EmergencyCallingConfiguration`](crate::model::EmergencyCallingConfiguration)
    pub fn builder() -> crate::model::emergency_calling_configuration::Builder {
        crate::model::emergency_calling_configuration::Builder::default()
    }
}

/// <p>The Dialed Number Identification Service (DNIS) emergency calling configuration details associated with an Amazon Chime Voice Connector's emergency calling configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnisEmergencyCallingConfiguration {
    /// <p>The DNIS phone number to route emergency calls to, in E.164 format.</p>
    pub emergency_phone_number: std::option::Option<std::string::String>,
    /// <p>The DNIS phone number to route test emergency calls to, in E.164 format.</p>
    pub test_phone_number: std::option::Option<std::string::String>,
    /// <p>The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.</p>
    pub calling_country: std::option::Option<std::string::String>,
}
impl DnisEmergencyCallingConfiguration {
    /// <p>The DNIS phone number to route emergency calls to, in E.164 format.</p>
    pub fn emergency_phone_number(&self) -> std::option::Option<&str> {
        self.emergency_phone_number.as_deref()
    }
    /// <p>The DNIS phone number to route test emergency calls to, in E.164 format.</p>
    pub fn test_phone_number(&self) -> std::option::Option<&str> {
        self.test_phone_number.as_deref()
    }
    /// <p>The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.</p>
    pub fn calling_country(&self) -> std::option::Option<&str> {
        self.calling_country.as_deref()
    }
}
impl std::fmt::Debug for DnisEmergencyCallingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnisEmergencyCallingConfiguration");
        formatter.field("emergency_phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("test_phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("calling_country", &self.calling_country);
        formatter.finish()
    }
}
/// See [`DnisEmergencyCallingConfiguration`](crate::model::DnisEmergencyCallingConfiguration)
pub mod dnis_emergency_calling_configuration {
    /// A builder for [`DnisEmergencyCallingConfiguration`](crate::model::DnisEmergencyCallingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) emergency_phone_number: std::option::Option<std::string::String>,
        pub(crate) test_phone_number: std::option::Option<std::string::String>,
        pub(crate) calling_country: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DNIS phone number to route emergency calls to, in E.164 format.</p>
        pub fn emergency_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.emergency_phone_number = Some(input.into());
            self
        }
        /// <p>The DNIS phone number to route emergency calls to, in E.164 format.</p>
        pub fn set_emergency_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.emergency_phone_number = input;
            self
        }
        /// <p>The DNIS phone number to route test emergency calls to, in E.164 format.</p>
        pub fn test_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_phone_number = Some(input.into());
            self
        }
        /// <p>The DNIS phone number to route test emergency calls to, in E.164 format.</p>
        pub fn set_test_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_phone_number = input;
            self
        }
        /// <p>The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.</p>
        pub fn calling_country(mut self, input: impl Into<std::string::String>) -> Self {
            self.calling_country = Some(input.into());
            self
        }
        /// <p>The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.</p>
        pub fn set_calling_country(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calling_country = input;
            self
        }
        /// Consumes the builder and constructs a [`DnisEmergencyCallingConfiguration`](crate::model::DnisEmergencyCallingConfiguration)
        pub fn build(self) -> crate::model::DnisEmergencyCallingConfiguration {
            crate::model::DnisEmergencyCallingConfiguration {
                emergency_phone_number: self.emergency_phone_number,
                test_phone_number: self.test_phone_number,
                calling_country: self.calling_country,
            }
        }
    }
}
impl DnisEmergencyCallingConfiguration {
    /// Creates a new builder-style object to manufacture [`DnisEmergencyCallingConfiguration`](crate::model::DnisEmergencyCallingConfiguration)
    pub fn builder() -> crate::model::dnis_emergency_calling_configuration::Builder {
        crate::model::dnis_emergency_calling_configuration::Builder::default()
    }
}

/// <p>Logging configuration of the SIP media application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SipMediaApplicationLoggingConfiguration {
    /// <p>Enables application message logs for the SIP media application.</p>
    pub enable_sip_media_application_message_logs: std::option::Option<bool>,
}
impl SipMediaApplicationLoggingConfiguration {
    /// <p>Enables application message logs for the SIP media application.</p>
    pub fn enable_sip_media_application_message_logs(&self) -> std::option::Option<bool> {
        self.enable_sip_media_application_message_logs
    }
}
impl std::fmt::Debug for SipMediaApplicationLoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SipMediaApplicationLoggingConfiguration");
        formatter.field(
            "enable_sip_media_application_message_logs",
            &self.enable_sip_media_application_message_logs,
        );
        formatter.finish()
    }
}
/// See [`SipMediaApplicationLoggingConfiguration`](crate::model::SipMediaApplicationLoggingConfiguration)
pub mod sip_media_application_logging_configuration {
    /// A builder for [`SipMediaApplicationLoggingConfiguration`](crate::model::SipMediaApplicationLoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_sip_media_application_message_logs: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables application message logs for the SIP media application.</p>
        pub fn enable_sip_media_application_message_logs(mut self, input: bool) -> Self {
            self.enable_sip_media_application_message_logs = Some(input);
            self
        }
        /// <p>Enables application message logs for the SIP media application.</p>
        pub fn set_enable_sip_media_application_message_logs(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_sip_media_application_message_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`SipMediaApplicationLoggingConfiguration`](crate::model::SipMediaApplicationLoggingConfiguration)
        pub fn build(self) -> crate::model::SipMediaApplicationLoggingConfiguration {
            crate::model::SipMediaApplicationLoggingConfiguration {
                enable_sip_media_application_message_logs: self
                    .enable_sip_media_application_message_logs,
            }
        }
    }
}
impl SipMediaApplicationLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`SipMediaApplicationLoggingConfiguration`](crate::model::SipMediaApplicationLoggingConfiguration)
    pub fn builder() -> crate::model::sip_media_application_logging_configuration::Builder {
        crate::model::sip_media_application_logging_configuration::Builder::default()
    }
}

/// <p>The retention settings for an Amazon Chime Enterprise account that determine how long to retain items such as chat-room messages and chat-conversation messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetentionSettings {
    /// <p>The chat room retention settings.</p>
    pub room_retention_settings: std::option::Option<crate::model::RoomRetentionSettings>,
    /// <p>The chat conversation retention settings.</p>
    pub conversation_retention_settings:
        std::option::Option<crate::model::ConversationRetentionSettings>,
}
impl RetentionSettings {
    /// <p>The chat room retention settings.</p>
    pub fn room_retention_settings(
        &self,
    ) -> std::option::Option<&crate::model::RoomRetentionSettings> {
        self.room_retention_settings.as_ref()
    }
    /// <p>The chat conversation retention settings.</p>
    pub fn conversation_retention_settings(
        &self,
    ) -> std::option::Option<&crate::model::ConversationRetentionSettings> {
        self.conversation_retention_settings.as_ref()
    }
}
impl std::fmt::Debug for RetentionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetentionSettings");
        formatter.field("room_retention_settings", &self.room_retention_settings);
        formatter.field(
            "conversation_retention_settings",
            &self.conversation_retention_settings,
        );
        formatter.finish()
    }
}
/// See [`RetentionSettings`](crate::model::RetentionSettings)
pub mod retention_settings {
    /// A builder for [`RetentionSettings`](crate::model::RetentionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_retention_settings:
            std::option::Option<crate::model::RoomRetentionSettings>,
        pub(crate) conversation_retention_settings:
            std::option::Option<crate::model::ConversationRetentionSettings>,
    }
    impl Builder {
        /// <p>The chat room retention settings.</p>
        pub fn room_retention_settings(
            mut self,
            input: crate::model::RoomRetentionSettings,
        ) -> Self {
            self.room_retention_settings = Some(input);
            self
        }
        /// <p>The chat room retention settings.</p>
        pub fn set_room_retention_settings(
            mut self,
            input: std::option::Option<crate::model::RoomRetentionSettings>,
        ) -> Self {
            self.room_retention_settings = input;
            self
        }
        /// <p>The chat conversation retention settings.</p>
        pub fn conversation_retention_settings(
            mut self,
            input: crate::model::ConversationRetentionSettings,
        ) -> Self {
            self.conversation_retention_settings = Some(input);
            self
        }
        /// <p>The chat conversation retention settings.</p>
        pub fn set_conversation_retention_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationRetentionSettings>,
        ) -> Self {
            self.conversation_retention_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`RetentionSettings`](crate::model::RetentionSettings)
        pub fn build(self) -> crate::model::RetentionSettings {
            crate::model::RetentionSettings {
                room_retention_settings: self.room_retention_settings,
                conversation_retention_settings: self.conversation_retention_settings,
            }
        }
    }
}
impl RetentionSettings {
    /// Creates a new builder-style object to manufacture [`RetentionSettings`](crate::model::RetentionSettings)
    pub fn builder() -> crate::model::retention_settings::Builder {
        crate::model::retention_settings::Builder::default()
    }
}

/// <p>The retention settings that determine how long to retain conversation messages for an Amazon Chime Enterprise account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConversationRetentionSettings {
    /// <p>The number of days for which to retain conversation messages.</p>
    pub retention_days: std::option::Option<i32>,
}
impl ConversationRetentionSettings {
    /// <p>The number of days for which to retain conversation messages.</p>
    pub fn retention_days(&self) -> std::option::Option<i32> {
        self.retention_days
    }
}
impl std::fmt::Debug for ConversationRetentionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConversationRetentionSettings");
        formatter.field("retention_days", &self.retention_days);
        formatter.finish()
    }
}
/// See [`ConversationRetentionSettings`](crate::model::ConversationRetentionSettings)
pub mod conversation_retention_settings {
    /// A builder for [`ConversationRetentionSettings`](crate::model::ConversationRetentionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of days for which to retain conversation messages.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The number of days for which to retain conversation messages.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// Consumes the builder and constructs a [`ConversationRetentionSettings`](crate::model::ConversationRetentionSettings)
        pub fn build(self) -> crate::model::ConversationRetentionSettings {
            crate::model::ConversationRetentionSettings {
                retention_days: self.retention_days,
            }
        }
    }
}
impl ConversationRetentionSettings {
    /// Creates a new builder-style object to manufacture [`ConversationRetentionSettings`](crate::model::ConversationRetentionSettings)
    pub fn builder() -> crate::model::conversation_retention_settings::Builder {
        crate::model::conversation_retention_settings::Builder::default()
    }
}

/// <p>The retention settings that determine how long to retain chat-room messages for an Amazon Chime Enterprise account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoomRetentionSettings {
    /// <p>The number of days for which to retain chat-room messages.</p>
    pub retention_days: std::option::Option<i32>,
}
impl RoomRetentionSettings {
    /// <p>The number of days for which to retain chat-room messages.</p>
    pub fn retention_days(&self) -> std::option::Option<i32> {
        self.retention_days
    }
}
impl std::fmt::Debug for RoomRetentionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoomRetentionSettings");
        formatter.field("retention_days", &self.retention_days);
        formatter.finish()
    }
}
/// See [`RoomRetentionSettings`](crate::model::RoomRetentionSettings)
pub mod room_retention_settings {
    /// A builder for [`RoomRetentionSettings`](crate::model::RoomRetentionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of days for which to retain chat-room messages.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The number of days for which to retain chat-room messages.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// Consumes the builder and constructs a [`RoomRetentionSettings`](crate::model::RoomRetentionSettings)
        pub fn build(self) -> crate::model::RoomRetentionSettings {
            crate::model::RoomRetentionSettings {
                retention_days: self.retention_days,
            }
        }
    }
}
impl RoomRetentionSettings {
    /// Creates a new builder-style object to manufacture [`RoomRetentionSettings`](crate::model::RoomRetentionSettings)
    pub fn builder() -> crate::model::room_retention_settings::Builder {
        crate::model::room_retention_settings::Builder::default()
    }
}

/// <p>The configuration that allows a bot to receive outgoing events. Can be either an HTTPS endpoint or a Lambda function ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventsConfiguration {
    /// <p>The bot ID.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>HTTPS endpoint that allows a bot to receive outgoing events.</p>
    pub outbound_events_https_endpoint: std::option::Option<std::string::String>,
    /// <p>Lambda function ARN that allows a bot to receive outgoing events.</p>
    pub lambda_function_arn: std::option::Option<std::string::String>,
}
impl EventsConfiguration {
    /// <p>The bot ID.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>HTTPS endpoint that allows a bot to receive outgoing events.</p>
    pub fn outbound_events_https_endpoint(&self) -> std::option::Option<&str> {
        self.outbound_events_https_endpoint.as_deref()
    }
    /// <p>Lambda function ARN that allows a bot to receive outgoing events.</p>
    pub fn lambda_function_arn(&self) -> std::option::Option<&str> {
        self.lambda_function_arn.as_deref()
    }
}
impl std::fmt::Debug for EventsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventsConfiguration");
        formatter.field("bot_id", &self.bot_id);
        formatter.field(
            "outbound_events_https_endpoint",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("lambda_function_arn", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`EventsConfiguration`](crate::model::EventsConfiguration)
pub mod events_configuration {
    /// A builder for [`EventsConfiguration`](crate::model::EventsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) outbound_events_https_endpoint: std::option::Option<std::string::String>,
        pub(crate) lambda_function_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>HTTPS endpoint that allows a bot to receive outgoing events.</p>
        pub fn outbound_events_https_endpoint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.outbound_events_https_endpoint = Some(input.into());
            self
        }
        /// <p>HTTPS endpoint that allows a bot to receive outgoing events.</p>
        pub fn set_outbound_events_https_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outbound_events_https_endpoint = input;
            self
        }
        /// <p>Lambda function ARN that allows a bot to receive outgoing events.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_arn = Some(input.into());
            self
        }
        /// <p>Lambda function ARN that allows a bot to receive outgoing events.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventsConfiguration`](crate::model::EventsConfiguration)
        pub fn build(self) -> crate::model::EventsConfiguration {
            crate::model::EventsConfiguration {
                bot_id: self.bot_id,
                outbound_events_https_endpoint: self.outbound_events_https_endpoint,
                lambda_function_arn: self.lambda_function_arn,
            }
        }
    }
}
impl EventsConfiguration {
    /// Creates a new builder-style object to manufacture [`EventsConfiguration`](crate::model::EventsConfiguration)
    pub fn builder() -> crate::model::events_configuration::Builder {
        crate::model::events_configuration::Builder::default()
    }
}

/// <p>The details of the streaming configuration of an <code>AppInstance</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceStreamingConfiguration {
    /// <p>The type of data to be streamed.</p>
    pub app_instance_data_type: std::option::Option<crate::model::AppInstanceDataType>,
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl AppInstanceStreamingConfiguration {
    /// <p>The type of data to be streamed.</p>
    pub fn app_instance_data_type(
        &self,
    ) -> std::option::Option<&crate::model::AppInstanceDataType> {
        self.app_instance_data_type.as_ref()
    }
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for AppInstanceStreamingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceStreamingConfiguration");
        formatter.field("app_instance_data_type", &self.app_instance_data_type);
        formatter.field("resource_arn", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AppInstanceStreamingConfiguration`](crate::model::AppInstanceStreamingConfiguration)
pub mod app_instance_streaming_configuration {
    /// A builder for [`AppInstanceStreamingConfiguration`](crate::model::AppInstanceStreamingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_data_type: std::option::Option<crate::model::AppInstanceDataType>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of data to be streamed.</p>
        pub fn app_instance_data_type(mut self, input: crate::model::AppInstanceDataType) -> Self {
            self.app_instance_data_type = Some(input);
            self
        }
        /// <p>The type of data to be streamed.</p>
        pub fn set_app_instance_data_type(
            mut self,
            input: std::option::Option<crate::model::AppInstanceDataType>,
        ) -> Self {
            self.app_instance_data_type = input;
            self
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceStreamingConfiguration`](crate::model::AppInstanceStreamingConfiguration)
        pub fn build(self) -> crate::model::AppInstanceStreamingConfiguration {
            crate::model::AppInstanceStreamingConfiguration {
                app_instance_data_type: self.app_instance_data_type,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl AppInstanceStreamingConfiguration {
    /// Creates a new builder-style object to manufacture [`AppInstanceStreamingConfiguration`](crate::model::AppInstanceStreamingConfiguration)
    pub fn builder() -> crate::model::app_instance_streaming_configuration::Builder {
        crate::model::app_instance_streaming_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppInstanceDataType {
    #[allow(missing_docs)] // documentation missing in model
    Channel,
    #[allow(missing_docs)] // documentation missing in model
    ChannelMessage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppInstanceDataType {
    fn from(s: &str) -> Self {
        match s {
            "Channel" => AppInstanceDataType::Channel,
            "ChannelMessage" => AppInstanceDataType::ChannelMessage,
            other => AppInstanceDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppInstanceDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppInstanceDataType::from(s))
    }
}
impl AppInstanceDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppInstanceDataType::Channel => "Channel",
            AppInstanceDataType::ChannelMessage => "ChannelMessage",
            AppInstanceDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Channel", "ChannelMessage"]
    }
}
impl AsRef<str> for AppInstanceDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of the data-retention settings for an <code>AppInstance</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceRetentionSettings {
    /// <p>The length of time in days to retain the messages in a channel.</p>
    pub channel_retention_settings: std::option::Option<crate::model::ChannelRetentionSettings>,
}
impl AppInstanceRetentionSettings {
    /// <p>The length of time in days to retain the messages in a channel.</p>
    pub fn channel_retention_settings(
        &self,
    ) -> std::option::Option<&crate::model::ChannelRetentionSettings> {
        self.channel_retention_settings.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceRetentionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceRetentionSettings");
        formatter.field(
            "channel_retention_settings",
            &self.channel_retention_settings,
        );
        formatter.finish()
    }
}
/// See [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
pub mod app_instance_retention_settings {
    /// A builder for [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_retention_settings:
            std::option::Option<crate::model::ChannelRetentionSettings>,
    }
    impl Builder {
        /// <p>The length of time in days to retain the messages in a channel.</p>
        pub fn channel_retention_settings(
            mut self,
            input: crate::model::ChannelRetentionSettings,
        ) -> Self {
            self.channel_retention_settings = Some(input);
            self
        }
        /// <p>The length of time in days to retain the messages in a channel.</p>
        pub fn set_channel_retention_settings(
            mut self,
            input: std::option::Option<crate::model::ChannelRetentionSettings>,
        ) -> Self {
            self.channel_retention_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
        pub fn build(self) -> crate::model::AppInstanceRetentionSettings {
            crate::model::AppInstanceRetentionSettings {
                channel_retention_settings: self.channel_retention_settings,
            }
        }
    }
}
impl AppInstanceRetentionSettings {
    /// Creates a new builder-style object to manufacture [`AppInstanceRetentionSettings`](crate::model::AppInstanceRetentionSettings)
    pub fn builder() -> crate::model::app_instance_retention_settings::Builder {
        crate::model::app_instance_retention_settings::Builder::default()
    }
}

/// <p>The details of the retention settings for a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelRetentionSettings {
    /// <p>The time in days to retain the messages in a channel.</p>
    pub retention_days: std::option::Option<i32>,
}
impl ChannelRetentionSettings {
    /// <p>The time in days to retain the messages in a channel.</p>
    pub fn retention_days(&self) -> std::option::Option<i32> {
        self.retention_days
    }
}
impl std::fmt::Debug for ChannelRetentionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelRetentionSettings");
        formatter.field("retention_days", &self.retention_days);
        formatter.finish()
    }
}
/// See [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
pub mod channel_retention_settings {
    /// A builder for [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The time in days to retain the messages in a channel.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The time in days to retain the messages in a channel.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
        pub fn build(self) -> crate::model::ChannelRetentionSettings {
            crate::model::ChannelRetentionSettings {
                retention_days: self.retention_days,
            }
        }
    }
}
impl ChannelRetentionSettings {
    /// Creates a new builder-style object to manufacture [`ChannelRetentionSettings`](crate::model::ChannelRetentionSettings)
    pub fn builder() -> crate::model::channel_retention_settings::Builder {
        crate::model::channel_retention_settings::Builder::default()
    }
}

/// <p>The phone number country.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberCountry {
    /// <p>The phone number country code. Format: ISO 3166-1 alpha-2.</p>
    pub country_code: std::option::Option<std::string::String>,
    /// <p>The supported phone number types. </p>
    pub supported_phone_number_types:
        std::option::Option<std::vec::Vec<crate::model::PhoneNumberType>>,
}
impl PhoneNumberCountry {
    /// <p>The phone number country code. Format: ISO 3166-1 alpha-2.</p>
    pub fn country_code(&self) -> std::option::Option<&str> {
        self.country_code.as_deref()
    }
    /// <p>The supported phone number types. </p>
    pub fn supported_phone_number_types(
        &self,
    ) -> std::option::Option<&[crate::model::PhoneNumberType]> {
        self.supported_phone_number_types.as_deref()
    }
}
impl std::fmt::Debug for PhoneNumberCountry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberCountry");
        formatter.field("country_code", &self.country_code);
        formatter.field(
            "supported_phone_number_types",
            &self.supported_phone_number_types,
        );
        formatter.finish()
    }
}
/// See [`PhoneNumberCountry`](crate::model::PhoneNumberCountry)
pub mod phone_number_country {
    /// A builder for [`PhoneNumberCountry`](crate::model::PhoneNumberCountry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country_code: std::option::Option<std::string::String>,
        pub(crate) supported_phone_number_types:
            std::option::Option<std::vec::Vec<crate::model::PhoneNumberType>>,
    }
    impl Builder {
        /// <p>The phone number country code. Format: ISO 3166-1 alpha-2.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_code = Some(input.into());
            self
        }
        /// <p>The phone number country code. Format: ISO 3166-1 alpha-2.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_code = input;
            self
        }
        /// Appends an item to `supported_phone_number_types`.
        ///
        /// To override the contents of this collection use [`set_supported_phone_number_types`](Self::set_supported_phone_number_types).
        ///
        /// <p>The supported phone number types. </p>
        pub fn supported_phone_number_types(
            mut self,
            input: impl Into<crate::model::PhoneNumberType>,
        ) -> Self {
            let mut v = self.supported_phone_number_types.unwrap_or_default();
            v.push(input.into());
            self.supported_phone_number_types = Some(v);
            self
        }
        /// <p>The supported phone number types. </p>
        pub fn set_supported_phone_number_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberType>>,
        ) -> Self {
            self.supported_phone_number_types = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberCountry`](crate::model::PhoneNumberCountry)
        pub fn build(self) -> crate::model::PhoneNumberCountry {
            crate::model::PhoneNumberCountry {
                country_code: self.country_code,
                supported_phone_number_types: self.supported_phone_number_types,
            }
        }
    }
}
impl PhoneNumberCountry {
    /// Creates a new builder-style object to manufacture [`PhoneNumberCountry`](crate::model::PhoneNumberCountry)
    pub fn builder() -> crate::model::phone_number_country::Builder {
        crate::model::phone_number_country::Builder::default()
    }
}

/// <p>The details of a phone number order created for Amazon Chime.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberOrder {
    /// <p>The phone number order ID.</p>
    pub phone_number_order_id: std::option::Option<std::string::String>,
    /// <p>The phone number order product type.</p>
    pub product_type: std::option::Option<crate::model::PhoneNumberProductType>,
    /// <p>The status of the phone number order.</p>
    pub status: std::option::Option<crate::model::PhoneNumberOrderStatus>,
    /// <p>The ordered phone number details, such as the phone number in E.164 format and the phone
    /// number status.</p>
    pub ordered_phone_numbers: std::option::Option<std::vec::Vec<crate::model::OrderedPhoneNumber>>,
    /// <p>The phone number order creation time stamp, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The updated phone number order time stamp, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl PhoneNumberOrder {
    /// <p>The phone number order ID.</p>
    pub fn phone_number_order_id(&self) -> std::option::Option<&str> {
        self.phone_number_order_id.as_deref()
    }
    /// <p>The phone number order product type.</p>
    pub fn product_type(&self) -> std::option::Option<&crate::model::PhoneNumberProductType> {
        self.product_type.as_ref()
    }
    /// <p>The status of the phone number order.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PhoneNumberOrderStatus> {
        self.status.as_ref()
    }
    /// <p>The ordered phone number details, such as the phone number in E.164 format and the phone
    /// number status.</p>
    pub fn ordered_phone_numbers(
        &self,
    ) -> std::option::Option<&[crate::model::OrderedPhoneNumber]> {
        self.ordered_phone_numbers.as_deref()
    }
    /// <p>The phone number order creation time stamp, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The updated phone number order time stamp, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for PhoneNumberOrder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberOrder");
        formatter.field("phone_number_order_id", &self.phone_number_order_id);
        formatter.field("product_type", &self.product_type);
        formatter.field("status", &self.status);
        formatter.field("ordered_phone_numbers", &self.ordered_phone_numbers);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`PhoneNumberOrder`](crate::model::PhoneNumberOrder)
pub mod phone_number_order {
    /// A builder for [`PhoneNumberOrder`](crate::model::PhoneNumberOrder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_order_id: std::option::Option<std::string::String>,
        pub(crate) product_type: std::option::Option<crate::model::PhoneNumberProductType>,
        pub(crate) status: std::option::Option<crate::model::PhoneNumberOrderStatus>,
        pub(crate) ordered_phone_numbers:
            std::option::Option<std::vec::Vec<crate::model::OrderedPhoneNumber>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The phone number order ID.</p>
        pub fn phone_number_order_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_order_id = Some(input.into());
            self
        }
        /// <p>The phone number order ID.</p>
        pub fn set_phone_number_order_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_order_id = input;
            self
        }
        /// <p>The phone number order product type.</p>
        pub fn product_type(mut self, input: crate::model::PhoneNumberProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The phone number order product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// <p>The status of the phone number order.</p>
        pub fn status(mut self, input: crate::model::PhoneNumberOrderStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the phone number order.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberOrderStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `ordered_phone_numbers`.
        ///
        /// To override the contents of this collection use [`set_ordered_phone_numbers`](Self::set_ordered_phone_numbers).
        ///
        /// <p>The ordered phone number details, such as the phone number in E.164 format and the phone
        /// number status.</p>
        pub fn ordered_phone_numbers(
            mut self,
            input: impl Into<crate::model::OrderedPhoneNumber>,
        ) -> Self {
            let mut v = self.ordered_phone_numbers.unwrap_or_default();
            v.push(input.into());
            self.ordered_phone_numbers = Some(v);
            self
        }
        /// <p>The ordered phone number details, such as the phone number in E.164 format and the phone
        /// number status.</p>
        pub fn set_ordered_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrderedPhoneNumber>>,
        ) -> Self {
            self.ordered_phone_numbers = input;
            self
        }
        /// <p>The phone number order creation time stamp, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The phone number order creation time stamp, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The updated phone number order time stamp, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The updated phone number order time stamp, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberOrder`](crate::model::PhoneNumberOrder)
        pub fn build(self) -> crate::model::PhoneNumberOrder {
            crate::model::PhoneNumberOrder {
                phone_number_order_id: self.phone_number_order_id,
                product_type: self.product_type,
                status: self.status,
                ordered_phone_numbers: self.ordered_phone_numbers,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl PhoneNumberOrder {
    /// Creates a new builder-style object to manufacture [`PhoneNumberOrder`](crate::model::PhoneNumberOrder)
    pub fn builder() -> crate::model::phone_number_order::Builder {
        crate::model::phone_number_order::Builder::default()
    }
}

/// <p>A phone number for which an order has been placed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderedPhoneNumber {
    /// <p>The phone number, in E.164 format.</p>
    pub e164_phone_number: std::option::Option<std::string::String>,
    /// <p>The phone number status.</p>
    pub status: std::option::Option<crate::model::OrderedPhoneNumberStatus>,
}
impl OrderedPhoneNumber {
    /// <p>The phone number, in E.164 format.</p>
    pub fn e164_phone_number(&self) -> std::option::Option<&str> {
        self.e164_phone_number.as_deref()
    }
    /// <p>The phone number status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OrderedPhoneNumberStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for OrderedPhoneNumber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderedPhoneNumber");
        formatter.field("e164_phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`OrderedPhoneNumber`](crate::model::OrderedPhoneNumber)
pub mod ordered_phone_number {
    /// A builder for [`OrderedPhoneNumber`](crate::model::OrderedPhoneNumber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) e164_phone_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OrderedPhoneNumberStatus>,
    }
    impl Builder {
        /// <p>The phone number, in E.164 format.</p>
        pub fn e164_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.e164_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn set_e164_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.e164_phone_number = input;
            self
        }
        /// <p>The phone number status.</p>
        pub fn status(mut self, input: crate::model::OrderedPhoneNumberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The phone number status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OrderedPhoneNumberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderedPhoneNumber`](crate::model::OrderedPhoneNumber)
        pub fn build(self) -> crate::model::OrderedPhoneNumber {
            crate::model::OrderedPhoneNumber {
                e164_phone_number: self.e164_phone_number,
                status: self.status,
            }
        }
    }
}
impl OrderedPhoneNumber {
    /// Creates a new builder-style object to manufacture [`OrderedPhoneNumber`](crate::model::OrderedPhoneNumber)
    pub fn builder() -> crate::model::ordered_phone_number::Builder {
        crate::model::ordered_phone_number::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderedPhoneNumberStatus {
    #[allow(missing_docs)] // documentation missing in model
    Acquired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderedPhoneNumberStatus {
    fn from(s: &str) -> Self {
        match s {
            "Acquired" => OrderedPhoneNumberStatus::Acquired,
            "Failed" => OrderedPhoneNumberStatus::Failed,
            "Processing" => OrderedPhoneNumberStatus::Processing,
            other => OrderedPhoneNumberStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderedPhoneNumberStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderedPhoneNumberStatus::from(s))
    }
}
impl OrderedPhoneNumberStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderedPhoneNumberStatus::Acquired => "Acquired",
            OrderedPhoneNumberStatus::Failed => "Failed",
            OrderedPhoneNumberStatus::Processing => "Processing",
            OrderedPhoneNumberStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Acquired", "Failed", "Processing"]
    }
}
impl AsRef<str> for OrderedPhoneNumberStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhoneNumberOrderStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Partial,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhoneNumberOrderStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => PhoneNumberOrderStatus::Failed,
            "Partial" => PhoneNumberOrderStatus::Partial,
            "Processing" => PhoneNumberOrderStatus::Processing,
            "Successful" => PhoneNumberOrderStatus::Successful,
            other => PhoneNumberOrderStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhoneNumberOrderStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhoneNumberOrderStatus::from(s))
    }
}
impl PhoneNumberOrderStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhoneNumberOrderStatus::Failed => "Failed",
            PhoneNumberOrderStatus::Partial => "Partial",
            PhoneNumberOrderStatus::Processing => "Processing",
            PhoneNumberOrderStatus::Successful => "Successful",
            PhoneNumberOrderStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "Partial", "Processing", "Successful"]
    }
}
impl AsRef<str> for PhoneNumberOrderStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A meeting created using the Amazon Chime SDK.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Meeting {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub meeting_id: std::option::Option<std::string::String>,
    /// <p>The external meeting ID.</p>
    pub external_meeting_id: std::option::Option<std::string::String>,
    /// <p>The media placement for the meeting.</p>
    pub media_placement: std::option::Option<crate::model::MediaPlacement>,
    /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>,
    /// <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
    /// <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>,
    /// <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>,
    /// <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
    /// <code>us-west-1</code>, <code>us-west-2</code>.</p>
    pub media_region: std::option::Option<std::string::String>,
}
impl Meeting {
    /// <p>The Amazon Chime SDK meeting ID.</p>
    pub fn meeting_id(&self) -> std::option::Option<&str> {
        self.meeting_id.as_deref()
    }
    /// <p>The external meeting ID.</p>
    pub fn external_meeting_id(&self) -> std::option::Option<&str> {
        self.external_meeting_id.as_deref()
    }
    /// <p>The media placement for the meeting.</p>
    pub fn media_placement(&self) -> std::option::Option<&crate::model::MediaPlacement> {
        self.media_placement.as_ref()
    }
    /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>,
    /// <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
    /// <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>,
    /// <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>,
    /// <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
    /// <code>us-west-1</code>, <code>us-west-2</code>.</p>
    pub fn media_region(&self) -> std::option::Option<&str> {
        self.media_region.as_deref()
    }
}
impl std::fmt::Debug for Meeting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Meeting");
        formatter.field("meeting_id", &self.meeting_id);
        formatter.field("external_meeting_id", &"*** Sensitive Data Redacted ***");
        formatter.field("media_placement", &self.media_placement);
        formatter.field("media_region", &self.media_region);
        formatter.finish()
    }
}
/// See [`Meeting`](crate::model::Meeting)
pub mod meeting {
    /// A builder for [`Meeting`](crate::model::Meeting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) meeting_id: std::option::Option<std::string::String>,
        pub(crate) external_meeting_id: std::option::Option<std::string::String>,
        pub(crate) media_placement: std::option::Option<crate::model::MediaPlacement>,
        pub(crate) media_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.meeting_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.meeting_id = input;
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_meeting_id = Some(input.into());
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_meeting_id = input;
            self
        }
        /// <p>The media placement for the meeting.</p>
        pub fn media_placement(mut self, input: crate::model::MediaPlacement) -> Self {
            self.media_placement = Some(input);
            self
        }
        /// <p>The media placement for the meeting.</p>
        pub fn set_media_placement(
            mut self,
            input: std::option::Option<crate::model::MediaPlacement>,
        ) -> Self {
            self.media_placement = input;
            self
        }
        /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>,
        /// <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
        /// <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>,
        /// <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>,
        /// <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
        /// <code>us-west-1</code>, <code>us-west-2</code>.</p>
        pub fn media_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_region = Some(input.into());
            self
        }
        /// <p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>,
        /// <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
        /// <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>,
        /// <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>,
        /// <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
        /// <code>us-west-1</code>, <code>us-west-2</code>.</p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_region = input;
            self
        }
        /// Consumes the builder and constructs a [`Meeting`](crate::model::Meeting)
        pub fn build(self) -> crate::model::Meeting {
            crate::model::Meeting {
                meeting_id: self.meeting_id,
                external_meeting_id: self.external_meeting_id,
                media_placement: self.media_placement,
                media_region: self.media_region,
            }
        }
    }
}
impl Meeting {
    /// Creates a new builder-style object to manufacture [`Meeting`](crate::model::Meeting)
    pub fn builder() -> crate::model::meeting::Builder {
        crate::model::meeting::Builder::default()
    }
}

/// <p>A set of endpoints used by clients to connect to the media service group for an Amazon Chime SDK meeting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaPlacement {
    /// <p>The audio host URL.</p>
    pub audio_host_url: std::option::Option<std::string::String>,
    /// <p>The audio fallback URL.</p>
    pub audio_fallback_url: std::option::Option<std::string::String>,
    /// <p>The screen data URL.</p>
    pub screen_data_url: std::option::Option<std::string::String>,
    /// <p>The screen sharing URL.</p>
    pub screen_sharing_url: std::option::Option<std::string::String>,
    /// <p>The screen viewing URL.</p>
    pub screen_viewing_url: std::option::Option<std::string::String>,
    /// <p>The signaling URL.</p>
    pub signaling_url: std::option::Option<std::string::String>,
    /// <p>The turn control URL.</p>
    pub turn_control_url: std::option::Option<std::string::String>,
    /// <p>The event ingestion URL.</p>
    pub event_ingestion_url: std::option::Option<std::string::String>,
}
impl MediaPlacement {
    /// <p>The audio host URL.</p>
    pub fn audio_host_url(&self) -> std::option::Option<&str> {
        self.audio_host_url.as_deref()
    }
    /// <p>The audio fallback URL.</p>
    pub fn audio_fallback_url(&self) -> std::option::Option<&str> {
        self.audio_fallback_url.as_deref()
    }
    /// <p>The screen data URL.</p>
    pub fn screen_data_url(&self) -> std::option::Option<&str> {
        self.screen_data_url.as_deref()
    }
    /// <p>The screen sharing URL.</p>
    pub fn screen_sharing_url(&self) -> std::option::Option<&str> {
        self.screen_sharing_url.as_deref()
    }
    /// <p>The screen viewing URL.</p>
    pub fn screen_viewing_url(&self) -> std::option::Option<&str> {
        self.screen_viewing_url.as_deref()
    }
    /// <p>The signaling URL.</p>
    pub fn signaling_url(&self) -> std::option::Option<&str> {
        self.signaling_url.as_deref()
    }
    /// <p>The turn control URL.</p>
    pub fn turn_control_url(&self) -> std::option::Option<&str> {
        self.turn_control_url.as_deref()
    }
    /// <p>The event ingestion URL.</p>
    pub fn event_ingestion_url(&self) -> std::option::Option<&str> {
        self.event_ingestion_url.as_deref()
    }
}
impl std::fmt::Debug for MediaPlacement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaPlacement");
        formatter.field("audio_host_url", &self.audio_host_url);
        formatter.field("audio_fallback_url", &self.audio_fallback_url);
        formatter.field("screen_data_url", &self.screen_data_url);
        formatter.field("screen_sharing_url", &self.screen_sharing_url);
        formatter.field("screen_viewing_url", &self.screen_viewing_url);
        formatter.field("signaling_url", &self.signaling_url);
        formatter.field("turn_control_url", &self.turn_control_url);
        formatter.field("event_ingestion_url", &self.event_ingestion_url);
        formatter.finish()
    }
}
/// See [`MediaPlacement`](crate::model::MediaPlacement)
pub mod media_placement {
    /// A builder for [`MediaPlacement`](crate::model::MediaPlacement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_host_url: std::option::Option<std::string::String>,
        pub(crate) audio_fallback_url: std::option::Option<std::string::String>,
        pub(crate) screen_data_url: std::option::Option<std::string::String>,
        pub(crate) screen_sharing_url: std::option::Option<std::string::String>,
        pub(crate) screen_viewing_url: std::option::Option<std::string::String>,
        pub(crate) signaling_url: std::option::Option<std::string::String>,
        pub(crate) turn_control_url: std::option::Option<std::string::String>,
        pub(crate) event_ingestion_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The audio host URL.</p>
        pub fn audio_host_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_host_url = Some(input.into());
            self
        }
        /// <p>The audio host URL.</p>
        pub fn set_audio_host_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_host_url = input;
            self
        }
        /// <p>The audio fallback URL.</p>
        pub fn audio_fallback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_fallback_url = Some(input.into());
            self
        }
        /// <p>The audio fallback URL.</p>
        pub fn set_audio_fallback_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_fallback_url = input;
            self
        }
        /// <p>The screen data URL.</p>
        pub fn screen_data_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_data_url = Some(input.into());
            self
        }
        /// <p>The screen data URL.</p>
        pub fn set_screen_data_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screen_data_url = input;
            self
        }
        /// <p>The screen sharing URL.</p>
        pub fn screen_sharing_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_sharing_url = Some(input.into());
            self
        }
        /// <p>The screen sharing URL.</p>
        pub fn set_screen_sharing_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screen_sharing_url = input;
            self
        }
        /// <p>The screen viewing URL.</p>
        pub fn screen_viewing_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_viewing_url = Some(input.into());
            self
        }
        /// <p>The screen viewing URL.</p>
        pub fn set_screen_viewing_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screen_viewing_url = input;
            self
        }
        /// <p>The signaling URL.</p>
        pub fn signaling_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.signaling_url = Some(input.into());
            self
        }
        /// <p>The signaling URL.</p>
        pub fn set_signaling_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signaling_url = input;
            self
        }
        /// <p>The turn control URL.</p>
        pub fn turn_control_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.turn_control_url = Some(input.into());
            self
        }
        /// <p>The turn control URL.</p>
        pub fn set_turn_control_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.turn_control_url = input;
            self
        }
        /// <p>The event ingestion URL.</p>
        pub fn event_ingestion_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_ingestion_url = Some(input.into());
            self
        }
        /// <p>The event ingestion URL.</p>
        pub fn set_event_ingestion_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_ingestion_url = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaPlacement`](crate::model::MediaPlacement)
        pub fn build(self) -> crate::model::MediaPlacement {
            crate::model::MediaPlacement {
                audio_host_url: self.audio_host_url,
                audio_fallback_url: self.audio_fallback_url,
                screen_data_url: self.screen_data_url,
                screen_sharing_url: self.screen_sharing_url,
                screen_viewing_url: self.screen_viewing_url,
                signaling_url: self.signaling_url,
                turn_control_url: self.turn_control_url,
                event_ingestion_url: self.event_ingestion_url,
            }
        }
    }
}
impl MediaPlacement {
    /// Creates a new builder-style object to manufacture [`MediaPlacement`](crate::model::MediaPlacement)
    pub fn builder() -> crate::model::media_placement::Builder {
        crate::model::media_placement::Builder::default()
    }
}

/// <p>A media capture pipeline object consisting of an ID, source type, source ARN, a sink type, a sink ARN, and a configuration object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaCapturePipeline {
    /// <p>The ID of a media capture pipeline.</p>
    pub media_pipeline_id: std::option::Option<std::string::String>,
    /// <p>Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.</p>
    pub source_type: std::option::Option<crate::model::MediaPipelineSourceType>,
    /// <p>ARN of the source from which the media artifacts will be saved.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The status of the media capture pipeline.</p>
    pub status: std::option::Option<crate::model::MediaPipelineStatus>,
    /// <p>Destination type to which the media artifacts are saved. You must use an S3 Bucket.</p>
    pub sink_type: std::option::Option<crate::model::MediaPipelineSinkType>,
    /// <p>ARN of the destination to which the media artifacts are saved.</p>
    pub sink_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the capture pipeline was created, in ISO 8601 format.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the capture pipeline was updated, in ISO 8601 format.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
    pub chime_sdk_meeting_configuration:
        std::option::Option<crate::model::ChimeSdkMeetingConfiguration>,
}
impl MediaCapturePipeline {
    /// <p>The ID of a media capture pipeline.</p>
    pub fn media_pipeline_id(&self) -> std::option::Option<&str> {
        self.media_pipeline_id.as_deref()
    }
    /// <p>Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::MediaPipelineSourceType> {
        self.source_type.as_ref()
    }
    /// <p>ARN of the source from which the media artifacts will be saved.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The status of the media capture pipeline.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MediaPipelineStatus> {
        self.status.as_ref()
    }
    /// <p>Destination type to which the media artifacts are saved. You must use an S3 Bucket.</p>
    pub fn sink_type(&self) -> std::option::Option<&crate::model::MediaPipelineSinkType> {
        self.sink_type.as_ref()
    }
    /// <p>ARN of the destination to which the media artifacts are saved.</p>
    pub fn sink_arn(&self) -> std::option::Option<&str> {
        self.sink_arn.as_deref()
    }
    /// <p>The time at which the capture pipeline was created, in ISO 8601 format.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which the capture pipeline was updated, in ISO 8601 format.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_timestamp.as_ref()
    }
    /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
    pub fn chime_sdk_meeting_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ChimeSdkMeetingConfiguration> {
        self.chime_sdk_meeting_configuration.as_ref()
    }
}
impl std::fmt::Debug for MediaCapturePipeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaCapturePipeline");
        formatter.field("media_pipeline_id", &self.media_pipeline_id);
        formatter.field("source_type", &self.source_type);
        formatter.field("source_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("sink_type", &self.sink_type);
        formatter.field("sink_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.field(
            "chime_sdk_meeting_configuration",
            &self.chime_sdk_meeting_configuration,
        );
        formatter.finish()
    }
}
/// See [`MediaCapturePipeline`](crate::model::MediaCapturePipeline)
pub mod media_capture_pipeline {
    /// A builder for [`MediaCapturePipeline`](crate::model::MediaCapturePipeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) media_pipeline_id: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::MediaPipelineSourceType>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::MediaPipelineStatus>,
        pub(crate) sink_type: std::option::Option<crate::model::MediaPipelineSinkType>,
        pub(crate) sink_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) chime_sdk_meeting_configuration:
            std::option::Option<crate::model::ChimeSdkMeetingConfiguration>,
    }
    impl Builder {
        /// <p>The ID of a media capture pipeline.</p>
        pub fn media_pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_pipeline_id = Some(input.into());
            self
        }
        /// <p>The ID of a media capture pipeline.</p>
        pub fn set_media_pipeline_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_pipeline_id = input;
            self
        }
        /// <p>Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.</p>
        pub fn source_type(mut self, input: crate::model::MediaPipelineSourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>ARN of the source from which the media artifacts will be saved.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>ARN of the source from which the media artifacts will be saved.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The status of the media capture pipeline.</p>
        pub fn status(mut self, input: crate::model::MediaPipelineStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the media capture pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 Bucket.</p>
        pub fn sink_type(mut self, input: crate::model::MediaPipelineSinkType) -> Self {
            self.sink_type = Some(input);
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 Bucket.</p>
        pub fn set_sink_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSinkType>,
        ) -> Self {
            self.sink_type = input;
            self
        }
        /// <p>ARN of the destination to which the media artifacts are saved.</p>
        pub fn sink_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sink_arn = Some(input.into());
            self
        }
        /// <p>ARN of the destination to which the media artifacts are saved.</p>
        pub fn set_sink_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sink_arn = input;
            self
        }
        /// <p>The time at which the capture pipeline was created, in ISO 8601 format.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the capture pipeline was created, in ISO 8601 format.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which the capture pipeline was updated, in ISO 8601 format.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which the capture pipeline was updated, in ISO 8601 format.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn chime_sdk_meeting_configuration(
            mut self,
            input: crate::model::ChimeSdkMeetingConfiguration,
        ) -> Self {
            self.chime_sdk_meeting_configuration = Some(input);
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn set_chime_sdk_meeting_configuration(
            mut self,
            input: std::option::Option<crate::model::ChimeSdkMeetingConfiguration>,
        ) -> Self {
            self.chime_sdk_meeting_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaCapturePipeline`](crate::model::MediaCapturePipeline)
        pub fn build(self) -> crate::model::MediaCapturePipeline {
            crate::model::MediaCapturePipeline {
                media_pipeline_id: self.media_pipeline_id,
                source_type: self.source_type,
                source_arn: self.source_arn,
                status: self.status,
                sink_type: self.sink_type,
                sink_arn: self.sink_arn,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
                chime_sdk_meeting_configuration: self.chime_sdk_meeting_configuration,
            }
        }
    }
}
impl MediaCapturePipeline {
    /// Creates a new builder-style object to manufacture [`MediaCapturePipeline`](crate::model::MediaCapturePipeline)
    pub fn builder() -> crate::model::media_capture_pipeline::Builder {
        crate::model::media_capture_pipeline::Builder::default()
    }
}

/// <p>The configuration object of the Amazon Chime SDK meeting for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChimeSdkMeetingConfiguration {
    /// <p>The source configuration for a specified media capture pipline.</p>
    pub source_configuration: std::option::Option<crate::model::SourceConfiguration>,
    /// <p>The configuration for the artifacts in an Amazon Chime SDK meeting.</p>
    pub artifacts_configuration: std::option::Option<crate::model::ArtifactsConfiguration>,
}
impl ChimeSdkMeetingConfiguration {
    /// <p>The source configuration for a specified media capture pipline.</p>
    pub fn source_configuration(&self) -> std::option::Option<&crate::model::SourceConfiguration> {
        self.source_configuration.as_ref()
    }
    /// <p>The configuration for the artifacts in an Amazon Chime SDK meeting.</p>
    pub fn artifacts_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ArtifactsConfiguration> {
        self.artifacts_configuration.as_ref()
    }
}
impl std::fmt::Debug for ChimeSdkMeetingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChimeSdkMeetingConfiguration");
        formatter.field("source_configuration", &self.source_configuration);
        formatter.field("artifacts_configuration", &self.artifacts_configuration);
        formatter.finish()
    }
}
/// See [`ChimeSdkMeetingConfiguration`](crate::model::ChimeSdkMeetingConfiguration)
pub mod chime_sdk_meeting_configuration {
    /// A builder for [`ChimeSdkMeetingConfiguration`](crate::model::ChimeSdkMeetingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_configuration: std::option::Option<crate::model::SourceConfiguration>,
        pub(crate) artifacts_configuration:
            std::option::Option<crate::model::ArtifactsConfiguration>,
    }
    impl Builder {
        /// <p>The source configuration for a specified media capture pipline.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.source_configuration = Some(input);
            self
        }
        /// <p>The source configuration for a specified media capture pipline.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.source_configuration = input;
            self
        }
        /// <p>The configuration for the artifacts in an Amazon Chime SDK meeting.</p>
        pub fn artifacts_configuration(
            mut self,
            input: crate::model::ArtifactsConfiguration,
        ) -> Self {
            self.artifacts_configuration = Some(input);
            self
        }
        /// <p>The configuration for the artifacts in an Amazon Chime SDK meeting.</p>
        pub fn set_artifacts_configuration(
            mut self,
            input: std::option::Option<crate::model::ArtifactsConfiguration>,
        ) -> Self {
            self.artifacts_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ChimeSdkMeetingConfiguration`](crate::model::ChimeSdkMeetingConfiguration)
        pub fn build(self) -> crate::model::ChimeSdkMeetingConfiguration {
            crate::model::ChimeSdkMeetingConfiguration {
                source_configuration: self.source_configuration,
                artifacts_configuration: self.artifacts_configuration,
            }
        }
    }
}
impl ChimeSdkMeetingConfiguration {
    /// Creates a new builder-style object to manufacture [`ChimeSdkMeetingConfiguration`](crate::model::ChimeSdkMeetingConfiguration)
    pub fn builder() -> crate::model::chime_sdk_meeting_configuration::Builder {
        crate::model::chime_sdk_meeting_configuration::Builder::default()
    }
}

/// <p>The configuration for the artifacts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArtifactsConfiguration {
    /// <p>The configuration for the audio artifacts.</p>
    pub audio: std::option::Option<crate::model::AudioArtifactsConfiguration>,
    /// <p>The configuration for the video artifacts.</p>
    pub video: std::option::Option<crate::model::VideoArtifactsConfiguration>,
    /// <p>The configuration for the content artifacts.</p>
    pub content: std::option::Option<crate::model::ContentArtifactsConfiguration>,
}
impl ArtifactsConfiguration {
    /// <p>The configuration for the audio artifacts.</p>
    pub fn audio(&self) -> std::option::Option<&crate::model::AudioArtifactsConfiguration> {
        self.audio.as_ref()
    }
    /// <p>The configuration for the video artifacts.</p>
    pub fn video(&self) -> std::option::Option<&crate::model::VideoArtifactsConfiguration> {
        self.video.as_ref()
    }
    /// <p>The configuration for the content artifacts.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::ContentArtifactsConfiguration> {
        self.content.as_ref()
    }
}
impl std::fmt::Debug for ArtifactsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArtifactsConfiguration");
        formatter.field("audio", &self.audio);
        formatter.field("video", &self.video);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`ArtifactsConfiguration`](crate::model::ArtifactsConfiguration)
pub mod artifacts_configuration {
    /// A builder for [`ArtifactsConfiguration`](crate::model::ArtifactsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio: std::option::Option<crate::model::AudioArtifactsConfiguration>,
        pub(crate) video: std::option::Option<crate::model::VideoArtifactsConfiguration>,
        pub(crate) content: std::option::Option<crate::model::ContentArtifactsConfiguration>,
    }
    impl Builder {
        /// <p>The configuration for the audio artifacts.</p>
        pub fn audio(mut self, input: crate::model::AudioArtifactsConfiguration) -> Self {
            self.audio = Some(input);
            self
        }
        /// <p>The configuration for the audio artifacts.</p>
        pub fn set_audio(
            mut self,
            input: std::option::Option<crate::model::AudioArtifactsConfiguration>,
        ) -> Self {
            self.audio = input;
            self
        }
        /// <p>The configuration for the video artifacts.</p>
        pub fn video(mut self, input: crate::model::VideoArtifactsConfiguration) -> Self {
            self.video = Some(input);
            self
        }
        /// <p>The configuration for the video artifacts.</p>
        pub fn set_video(
            mut self,
            input: std::option::Option<crate::model::VideoArtifactsConfiguration>,
        ) -> Self {
            self.video = input;
            self
        }
        /// <p>The configuration for the content artifacts.</p>
        pub fn content(mut self, input: crate::model::ContentArtifactsConfiguration) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The configuration for the content artifacts.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::ContentArtifactsConfiguration>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`ArtifactsConfiguration`](crate::model::ArtifactsConfiguration)
        pub fn build(self) -> crate::model::ArtifactsConfiguration {
            crate::model::ArtifactsConfiguration {
                audio: self.audio,
                video: self.video,
                content: self.content,
            }
        }
    }
}
impl ArtifactsConfiguration {
    /// Creates a new builder-style object to manufacture [`ArtifactsConfiguration`](crate::model::ArtifactsConfiguration)
    pub fn builder() -> crate::model::artifacts_configuration::Builder {
        crate::model::artifacts_configuration::Builder::default()
    }
}

/// <p>The content artifact object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentArtifactsConfiguration {
    /// <p>Indicates whether the content artifact is enabled or disabled.</p>
    pub state: std::option::Option<crate::model::ArtifactsState>,
    /// <p>The MUX type of the artifact configuration.</p>
    pub mux_type: std::option::Option<crate::model::ContentMuxType>,
}
impl ContentArtifactsConfiguration {
    /// <p>Indicates whether the content artifact is enabled or disabled.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ArtifactsState> {
        self.state.as_ref()
    }
    /// <p>The MUX type of the artifact configuration.</p>
    pub fn mux_type(&self) -> std::option::Option<&crate::model::ContentMuxType> {
        self.mux_type.as_ref()
    }
}
impl std::fmt::Debug for ContentArtifactsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentArtifactsConfiguration");
        formatter.field("state", &self.state);
        formatter.field("mux_type", &self.mux_type);
        formatter.finish()
    }
}
/// See [`ContentArtifactsConfiguration`](crate::model::ContentArtifactsConfiguration)
pub mod content_artifacts_configuration {
    /// A builder for [`ContentArtifactsConfiguration`](crate::model::ContentArtifactsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::ArtifactsState>,
        pub(crate) mux_type: std::option::Option<crate::model::ContentMuxType>,
    }
    impl Builder {
        /// <p>Indicates whether the content artifact is enabled or disabled.</p>
        pub fn state(mut self, input: crate::model::ArtifactsState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates whether the content artifact is enabled or disabled.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ArtifactsState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The MUX type of the artifact configuration.</p>
        pub fn mux_type(mut self, input: crate::model::ContentMuxType) -> Self {
            self.mux_type = Some(input);
            self
        }
        /// <p>The MUX type of the artifact configuration.</p>
        pub fn set_mux_type(
            mut self,
            input: std::option::Option<crate::model::ContentMuxType>,
        ) -> Self {
            self.mux_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentArtifactsConfiguration`](crate::model::ContentArtifactsConfiguration)
        pub fn build(self) -> crate::model::ContentArtifactsConfiguration {
            crate::model::ContentArtifactsConfiguration {
                state: self.state,
                mux_type: self.mux_type,
            }
        }
    }
}
impl ContentArtifactsConfiguration {
    /// Creates a new builder-style object to manufacture [`ContentArtifactsConfiguration`](crate::model::ContentArtifactsConfiguration)
    pub fn builder() -> crate::model::content_artifacts_configuration::Builder {
        crate::model::content_artifacts_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentMuxType {
    #[allow(missing_docs)] // documentation missing in model
    ContentOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentMuxType {
    fn from(s: &str) -> Self {
        match s {
            "ContentOnly" => ContentMuxType::ContentOnly,
            other => ContentMuxType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentMuxType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentMuxType::from(s))
    }
}
impl ContentMuxType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentMuxType::ContentOnly => "ContentOnly",
            ContentMuxType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ContentOnly"]
    }
}
impl AsRef<str> for ContentMuxType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactsState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactsState {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ArtifactsState::Disabled,
            "Enabled" => ArtifactsState::Enabled,
            other => ArtifactsState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactsState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactsState::from(s))
    }
}
impl ArtifactsState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactsState::Disabled => "Disabled",
            ArtifactsState::Enabled => "Enabled",
            ArtifactsState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ArtifactsState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The video artifact configuration object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoArtifactsConfiguration {
    /// <p>Indicates whether the video artifact is enabled or disabled.</p>
    pub state: std::option::Option<crate::model::ArtifactsState>,
    /// <p>The MUX type of the video artifact configuration object.</p>
    pub mux_type: std::option::Option<crate::model::VideoMuxType>,
}
impl VideoArtifactsConfiguration {
    /// <p>Indicates whether the video artifact is enabled or disabled.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ArtifactsState> {
        self.state.as_ref()
    }
    /// <p>The MUX type of the video artifact configuration object.</p>
    pub fn mux_type(&self) -> std::option::Option<&crate::model::VideoMuxType> {
        self.mux_type.as_ref()
    }
}
impl std::fmt::Debug for VideoArtifactsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoArtifactsConfiguration");
        formatter.field("state", &self.state);
        formatter.field("mux_type", &self.mux_type);
        formatter.finish()
    }
}
/// See [`VideoArtifactsConfiguration`](crate::model::VideoArtifactsConfiguration)
pub mod video_artifacts_configuration {
    /// A builder for [`VideoArtifactsConfiguration`](crate::model::VideoArtifactsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::ArtifactsState>,
        pub(crate) mux_type: std::option::Option<crate::model::VideoMuxType>,
    }
    impl Builder {
        /// <p>Indicates whether the video artifact is enabled or disabled.</p>
        pub fn state(mut self, input: crate::model::ArtifactsState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates whether the video artifact is enabled or disabled.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ArtifactsState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The MUX type of the video artifact configuration object.</p>
        pub fn mux_type(mut self, input: crate::model::VideoMuxType) -> Self {
            self.mux_type = Some(input);
            self
        }
        /// <p>The MUX type of the video artifact configuration object.</p>
        pub fn set_mux_type(
            mut self,
            input: std::option::Option<crate::model::VideoMuxType>,
        ) -> Self {
            self.mux_type = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoArtifactsConfiguration`](crate::model::VideoArtifactsConfiguration)
        pub fn build(self) -> crate::model::VideoArtifactsConfiguration {
            crate::model::VideoArtifactsConfiguration {
                state: self.state,
                mux_type: self.mux_type,
            }
        }
    }
}
impl VideoArtifactsConfiguration {
    /// Creates a new builder-style object to manufacture [`VideoArtifactsConfiguration`](crate::model::VideoArtifactsConfiguration)
    pub fn builder() -> crate::model::video_artifacts_configuration::Builder {
        crate::model::video_artifacts_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoMuxType {
    #[allow(missing_docs)] // documentation missing in model
    VideoOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoMuxType {
    fn from(s: &str) -> Self {
        match s {
            "VideoOnly" => VideoMuxType::VideoOnly,
            other => VideoMuxType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoMuxType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoMuxType::from(s))
    }
}
impl VideoMuxType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoMuxType::VideoOnly => "VideoOnly",
            VideoMuxType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VideoOnly"]
    }
}
impl AsRef<str> for VideoMuxType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The audio artifact configuration object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioArtifactsConfiguration {
    /// <p>The MUX type of the audio artifact configuration object.</p>
    pub mux_type: std::option::Option<crate::model::AudioMuxType>,
}
impl AudioArtifactsConfiguration {
    /// <p>The MUX type of the audio artifact configuration object.</p>
    pub fn mux_type(&self) -> std::option::Option<&crate::model::AudioMuxType> {
        self.mux_type.as_ref()
    }
}
impl std::fmt::Debug for AudioArtifactsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioArtifactsConfiguration");
        formatter.field("mux_type", &self.mux_type);
        formatter.finish()
    }
}
/// See [`AudioArtifactsConfiguration`](crate::model::AudioArtifactsConfiguration)
pub mod audio_artifacts_configuration {
    /// A builder for [`AudioArtifactsConfiguration`](crate::model::AudioArtifactsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mux_type: std::option::Option<crate::model::AudioMuxType>,
    }
    impl Builder {
        /// <p>The MUX type of the audio artifact configuration object.</p>
        pub fn mux_type(mut self, input: crate::model::AudioMuxType) -> Self {
            self.mux_type = Some(input);
            self
        }
        /// <p>The MUX type of the audio artifact configuration object.</p>
        pub fn set_mux_type(
            mut self,
            input: std::option::Option<crate::model::AudioMuxType>,
        ) -> Self {
            self.mux_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioArtifactsConfiguration`](crate::model::AudioArtifactsConfiguration)
        pub fn build(self) -> crate::model::AudioArtifactsConfiguration {
            crate::model::AudioArtifactsConfiguration {
                mux_type: self.mux_type,
            }
        }
    }
}
impl AudioArtifactsConfiguration {
    /// Creates a new builder-style object to manufacture [`AudioArtifactsConfiguration`](crate::model::AudioArtifactsConfiguration)
    pub fn builder() -> crate::model::audio_artifacts_configuration::Builder {
        crate::model::audio_artifacts_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AudioMuxType {
    #[allow(missing_docs)] // documentation missing in model
    AudioOnly,
    #[allow(missing_docs)] // documentation missing in model
    AudioWithActiveSpeakerVideo,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AudioMuxType {
    fn from(s: &str) -> Self {
        match s {
            "AudioOnly" => AudioMuxType::AudioOnly,
            "AudioWithActiveSpeakerVideo" => AudioMuxType::AudioWithActiveSpeakerVideo,
            other => AudioMuxType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AudioMuxType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AudioMuxType::from(s))
    }
}
impl AudioMuxType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AudioMuxType::AudioOnly => "AudioOnly",
            AudioMuxType::AudioWithActiveSpeakerVideo => "AudioWithActiveSpeakerVideo",
            AudioMuxType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AudioOnly", "AudioWithActiveSpeakerVideo"]
    }
}
impl AsRef<str> for AudioMuxType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Source configuration for a specified media capture pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceConfiguration {
    /// <p>The selected video streams to capture for a specified media capture pipeline. The number of video streams can't exceed 25.</p>
    pub selected_video_streams: std::option::Option<crate::model::SelectedVideoStreams>,
}
impl SourceConfiguration {
    /// <p>The selected video streams to capture for a specified media capture pipeline. The number of video streams can't exceed 25.</p>
    pub fn selected_video_streams(
        &self,
    ) -> std::option::Option<&crate::model::SelectedVideoStreams> {
        self.selected_video_streams.as_ref()
    }
}
impl std::fmt::Debug for SourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceConfiguration");
        formatter.field("selected_video_streams", &self.selected_video_streams);
        formatter.finish()
    }
}
/// See [`SourceConfiguration`](crate::model::SourceConfiguration)
pub mod source_configuration {
    /// A builder for [`SourceConfiguration`](crate::model::SourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selected_video_streams: std::option::Option<crate::model::SelectedVideoStreams>,
    }
    impl Builder {
        /// <p>The selected video streams to capture for a specified media capture pipeline. The number of video streams can't exceed 25.</p>
        pub fn selected_video_streams(mut self, input: crate::model::SelectedVideoStreams) -> Self {
            self.selected_video_streams = Some(input);
            self
        }
        /// <p>The selected video streams to capture for a specified media capture pipeline. The number of video streams can't exceed 25.</p>
        pub fn set_selected_video_streams(
            mut self,
            input: std::option::Option<crate::model::SelectedVideoStreams>,
        ) -> Self {
            self.selected_video_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceConfiguration`](crate::model::SourceConfiguration)
        pub fn build(self) -> crate::model::SourceConfiguration {
            crate::model::SourceConfiguration {
                selected_video_streams: self.selected_video_streams,
            }
        }
    }
}
impl SourceConfiguration {
    /// Creates a new builder-style object to manufacture [`SourceConfiguration`](crate::model::SourceConfiguration)
    pub fn builder() -> crate::model::source_configuration::Builder {
        crate::model::source_configuration::Builder::default()
    }
}

/// <p>The video streams to capture for a specified media capture pipeline. The total number of video streams can't exceed 25.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelectedVideoStreams {
    /// <p>The attendee IDs of the streams selected for a media capture pipeline. </p>
    pub attendee_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The external user IDs of the streams selected for a media capture pipeline.</p>
    pub external_user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SelectedVideoStreams {
    /// <p>The attendee IDs of the streams selected for a media capture pipeline. </p>
    pub fn attendee_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.attendee_ids.as_deref()
    }
    /// <p>The external user IDs of the streams selected for a media capture pipeline.</p>
    pub fn external_user_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.external_user_ids.as_deref()
    }
}
impl std::fmt::Debug for SelectedVideoStreams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectedVideoStreams");
        formatter.field("attendee_ids", &self.attendee_ids);
        formatter.field("external_user_ids", &self.external_user_ids);
        formatter.finish()
    }
}
/// See [`SelectedVideoStreams`](crate::model::SelectedVideoStreams)
pub mod selected_video_streams {
    /// A builder for [`SelectedVideoStreams`](crate::model::SelectedVideoStreams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attendee_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) external_user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `attendee_ids`.
        ///
        /// To override the contents of this collection use [`set_attendee_ids`](Self::set_attendee_ids).
        ///
        /// <p>The attendee IDs of the streams selected for a media capture pipeline. </p>
        pub fn attendee_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attendee_ids.unwrap_or_default();
            v.push(input.into());
            self.attendee_ids = Some(v);
            self
        }
        /// <p>The attendee IDs of the streams selected for a media capture pipeline. </p>
        pub fn set_attendee_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attendee_ids = input;
            self
        }
        /// Appends an item to `external_user_ids`.
        ///
        /// To override the contents of this collection use [`set_external_user_ids`](Self::set_external_user_ids).
        ///
        /// <p>The external user IDs of the streams selected for a media capture pipeline.</p>
        pub fn external_user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.external_user_ids.unwrap_or_default();
            v.push(input.into());
            self.external_user_ids = Some(v);
            self
        }
        /// <p>The external user IDs of the streams selected for a media capture pipeline.</p>
        pub fn set_external_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.external_user_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectedVideoStreams`](crate::model::SelectedVideoStreams)
        pub fn build(self) -> crate::model::SelectedVideoStreams {
            crate::model::SelectedVideoStreams {
                attendee_ids: self.attendee_ids,
                external_user_ids: self.external_user_ids,
            }
        }
    }
}
impl SelectedVideoStreams {
    /// Creates a new builder-style object to manufacture [`SelectedVideoStreams`](crate::model::SelectedVideoStreams)
    pub fn builder() -> crate::model::selected_video_streams::Builder {
        crate::model::selected_video_streams::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MediaPipelineSinkType {
    #[allow(missing_docs)] // documentation missing in model
    S3Bucket,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MediaPipelineSinkType {
    fn from(s: &str) -> Self {
        match s {
            "S3Bucket" => MediaPipelineSinkType::S3Bucket,
            other => MediaPipelineSinkType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MediaPipelineSinkType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MediaPipelineSinkType::from(s))
    }
}
impl MediaPipelineSinkType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MediaPipelineSinkType::S3Bucket => "S3Bucket",
            MediaPipelineSinkType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3Bucket"]
    }
}
impl AsRef<str> for MediaPipelineSinkType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MediaPipelineStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Initializing,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MediaPipelineStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => MediaPipelineStatus::Failed,
            "InProgress" => MediaPipelineStatus::InProgress,
            "Initializing" => MediaPipelineStatus::Initializing,
            "Stopped" => MediaPipelineStatus::Stopped,
            "Stopping" => MediaPipelineStatus::Stopping,
            other => MediaPipelineStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MediaPipelineStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MediaPipelineStatus::from(s))
    }
}
impl MediaPipelineStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MediaPipelineStatus::Failed => "Failed",
            MediaPipelineStatus::InProgress => "InProgress",
            MediaPipelineStatus::Initializing => "Initializing",
            MediaPipelineStatus::Stopped => "Stopped",
            MediaPipelineStatus::Stopping => "Stopping",
            MediaPipelineStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "InProgress",
            "Initializing",
            "Stopped",
            "Stopping",
        ]
    }
}
impl AsRef<str> for MediaPipelineStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MediaPipelineSourceType {
    #[allow(missing_docs)] // documentation missing in model
    ChimeSdkMeeting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MediaPipelineSourceType {
    fn from(s: &str) -> Self {
        match s {
            "ChimeSdkMeeting" => MediaPipelineSourceType::ChimeSdkMeeting,
            other => MediaPipelineSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MediaPipelineSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MediaPipelineSourceType::from(s))
    }
}
impl MediaPipelineSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MediaPipelineSourceType::ChimeSdkMeeting => "ChimeSdkMeeting",
            MediaPipelineSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ChimeSdkMeeting"]
    }
}
impl AsRef<str> for MediaPipelineSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the details of a moderated channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelModeratedByAppInstanceUserSummary {
    /// <p>Summary of the details of a <code>Channel</code>.</p>
    pub channel_summary: std::option::Option<crate::model::ChannelSummary>,
}
impl ChannelModeratedByAppInstanceUserSummary {
    /// <p>Summary of the details of a <code>Channel</code>.</p>
    pub fn channel_summary(&self) -> std::option::Option<&crate::model::ChannelSummary> {
        self.channel_summary.as_ref()
    }
}
impl std::fmt::Debug for ChannelModeratedByAppInstanceUserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelModeratedByAppInstanceUserSummary");
        formatter.field("channel_summary", &self.channel_summary);
        formatter.finish()
    }
}
/// See [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
pub mod channel_moderated_by_app_instance_user_summary {
    /// A builder for [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_summary: std::option::Option<crate::model::ChannelSummary>,
    }
    impl Builder {
        /// <p>Summary of the details of a <code>Channel</code>.</p>
        pub fn channel_summary(mut self, input: crate::model::ChannelSummary) -> Self {
            self.channel_summary = Some(input);
            self
        }
        /// <p>Summary of the details of a <code>Channel</code>.</p>
        pub fn set_channel_summary(
            mut self,
            input: std::option::Option<crate::model::ChannelSummary>,
        ) -> Self {
            self.channel_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
        pub fn build(self) -> crate::model::ChannelModeratedByAppInstanceUserSummary {
            crate::model::ChannelModeratedByAppInstanceUserSummary {
                channel_summary: self.channel_summary,
            }
        }
    }
}
impl ChannelModeratedByAppInstanceUserSummary {
    /// Creates a new builder-style object to manufacture [`ChannelModeratedByAppInstanceUserSummary`](crate::model::ChannelModeratedByAppInstanceUserSummary)
    pub fn builder() -> crate::model::channel_moderated_by_app_instance_user_summary::Builder {
        crate::model::channel_moderated_by_app_instance_user_summary::Builder::default()
    }
}

/// <p>Summary of the details of a <code>Channel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelSummary {
    /// <p>The name of the channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The mode of the channel.</p>
    pub mode: std::option::Option<crate::model::ChannelMode>,
    /// <p>The privacy setting of the channel.</p>
    pub privacy: std::option::Option<crate::model::ChannelPrivacy>,
    /// <p>The metadata of the channel.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The time at which the last message in a channel was sent.</p>
    pub last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl ChannelSummary {
    /// <p>The name of the channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The mode of the channel.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::ChannelMode> {
        self.mode.as_ref()
    }
    /// <p>The privacy setting of the channel.</p>
    pub fn privacy(&self) -> std::option::Option<&crate::model::ChannelPrivacy> {
        self.privacy.as_ref()
    }
    /// <p>The metadata of the channel.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The time at which the last message in a channel was sent.</p>
    pub fn last_message_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_message_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ChannelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelSummary");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("mode", &self.mode);
        formatter.field("privacy", &self.privacy);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("last_message_timestamp", &self.last_message_timestamp);
        formatter.finish()
    }
}
/// See [`ChannelSummary`](crate::model::ChannelSummary)
pub mod channel_summary {
    /// A builder for [`ChannelSummary`](crate::model::ChannelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The privacy setting of the channel.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The privacy setting of the channel.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The metadata of the channel.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the channel.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The time at which the last message in a channel was sent.</p>
        pub fn last_message_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_message_timestamp = Some(input);
            self
        }
        /// <p>The time at which the last message in a channel was sent.</p>
        pub fn set_last_message_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_message_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelSummary`](crate::model::ChannelSummary)
        pub fn build(self) -> crate::model::ChannelSummary {
            crate::model::ChannelSummary {
                name: self.name,
                channel_arn: self.channel_arn,
                mode: self.mode,
                privacy: self.privacy,
                metadata: self.metadata,
                last_message_timestamp: self.last_message_timestamp,
            }
        }
    }
}
impl ChannelSummary {
    /// Creates a new builder-style object to manufacture [`ChannelSummary`](crate::model::ChannelSummary)
    pub fn builder() -> crate::model::channel_summary::Builder {
        crate::model::channel_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelPrivacy {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelPrivacy {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => ChannelPrivacy::Private,
            "PUBLIC" => ChannelPrivacy::Public,
            other => ChannelPrivacy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelPrivacy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelPrivacy::from(s))
    }
}
impl ChannelPrivacy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelPrivacy::Private => "PRIVATE",
            ChannelPrivacy::Public => "PUBLIC",
            ChannelPrivacy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC"]
    }
}
impl AsRef<str> for ChannelPrivacy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the details of a <code>ChannelModerator</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelModeratorSummary {
    /// <p>The data for a moderator.</p>
    pub moderator: std::option::Option<crate::model::Identity>,
}
impl ChannelModeratorSummary {
    /// <p>The data for a moderator.</p>
    pub fn moderator(&self) -> std::option::Option<&crate::model::Identity> {
        self.moderator.as_ref()
    }
}
impl std::fmt::Debug for ChannelModeratorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelModeratorSummary");
        formatter.field("moderator", &self.moderator);
        formatter.finish()
    }
}
/// See [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
pub mod channel_moderator_summary {
    /// A builder for [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) moderator: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The data for a moderator.</p>
        pub fn moderator(mut self, input: crate::model::Identity) -> Self {
            self.moderator = Some(input);
            self
        }
        /// <p>The data for a moderator.</p>
        pub fn set_moderator(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.moderator = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
        pub fn build(self) -> crate::model::ChannelModeratorSummary {
            crate::model::ChannelModeratorSummary {
                moderator: self.moderator,
            }
        }
    }
}
impl ChannelModeratorSummary {
    /// Creates a new builder-style object to manufacture [`ChannelModeratorSummary`](crate::model::ChannelModeratorSummary)
    pub fn builder() -> crate::model::channel_moderator_summary::Builder {
        crate::model::channel_moderator_summary::Builder::default()
    }
}

/// <p>The details of a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Identity {
    /// <p>The ARN in an Identity.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name in an Identity.</p>
    pub name: std::option::Option<std::string::String>,
}
impl Identity {
    /// <p>The ARN in an Identity.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name in an Identity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for Identity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Identity");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Identity`](crate::model::Identity)
pub mod identity {
    /// A builder for [`Identity`](crate::model::Identity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN in an Identity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN in an Identity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name in an Identity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name in an Identity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Identity`](crate::model::Identity)
        pub fn build(self) -> crate::model::Identity {
            crate::model::Identity {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl Identity {
    /// Creates a new builder-style object to manufacture [`Identity`](crate::model::Identity)
    pub fn builder() -> crate::model::identity::Builder {
        crate::model::identity::Builder::default()
    }
}

/// <p>Summary of the messages in a <code>Channel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMessageSummary {
    /// <p>The ID of the message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The content of the message.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The metadata of the message.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The type of message.</p>
    pub r#type: std::option::Option<crate::model::ChannelMessageType>,
    /// <p>The time at which the message summary was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was last edited.</p>
    pub last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The message sender.</p>
    pub sender: std::option::Option<crate::model::Identity>,
    /// <p>Indicates whether a message was redacted.</p>
    pub redacted: bool,
}
impl ChannelMessageSummary {
    /// <p>The ID of the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The content of the message.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The metadata of the message.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The type of message.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMessageType> {
        self.r#type.as_ref()
    }
    /// <p>The time at which the message summary was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which a message was last updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>The time at which a message was last edited.</p>
    pub fn last_edited_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_edited_timestamp.as_ref()
    }
    /// <p>The message sender.</p>
    pub fn sender(&self) -> std::option::Option<&crate::model::Identity> {
        self.sender.as_ref()
    }
    /// <p>Indicates whether a message was redacted.</p>
    pub fn redacted(&self) -> bool {
        self.redacted
    }
}
impl std::fmt::Debug for ChannelMessageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMessageSummary");
        formatter.field("message_id", &self.message_id);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("last_edited_timestamp", &self.last_edited_timestamp);
        formatter.field("sender", &self.sender);
        formatter.field("redacted", &self.redacted);
        formatter.finish()
    }
}
/// See [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
pub mod channel_message_summary {
    /// A builder for [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMessageType>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) sender: std::option::Option<crate::model::Identity>,
        pub(crate) redacted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The metadata of the message.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the message.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The type of message.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMessageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of message.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time at which the message summary was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the message summary was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a message was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The time at which a message was last edited.</p>
        pub fn last_edited_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_edited_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was last edited.</p>
        pub fn set_last_edited_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_edited_timestamp = input;
            self
        }
        /// <p>The message sender.</p>
        pub fn sender(mut self, input: crate::model::Identity) -> Self {
            self.sender = Some(input);
            self
        }
        /// <p>The message sender.</p>
        pub fn set_sender(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.sender = input;
            self
        }
        /// <p>Indicates whether a message was redacted.</p>
        pub fn redacted(mut self, input: bool) -> Self {
            self.redacted = Some(input);
            self
        }
        /// <p>Indicates whether a message was redacted.</p>
        pub fn set_redacted(mut self, input: std::option::Option<bool>) -> Self {
            self.redacted = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
        pub fn build(self) -> crate::model::ChannelMessageSummary {
            crate::model::ChannelMessageSummary {
                message_id: self.message_id,
                content: self.content,
                metadata: self.metadata,
                r#type: self.r#type,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                last_edited_timestamp: self.last_edited_timestamp,
                sender: self.sender,
                redacted: self.redacted.unwrap_or_default(),
            }
        }
    }
}
impl ChannelMessageSummary {
    /// Creates a new builder-style object to manufacture [`ChannelMessageSummary`](crate::model::ChannelMessageSummary)
    pub fn builder() -> crate::model::channel_message_summary::Builder {
        crate::model::channel_message_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the channel membership details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMembershipForAppInstanceUserSummary {
    /// <p>Summary of the details of a <code>Channel</code>.</p>
    pub channel_summary: std::option::Option<crate::model::ChannelSummary>,
    /// <p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>
    pub app_instance_user_membership_summary:
        std::option::Option<crate::model::AppInstanceUserMembershipSummary>,
}
impl ChannelMembershipForAppInstanceUserSummary {
    /// <p>Summary of the details of a <code>Channel</code>.</p>
    pub fn channel_summary(&self) -> std::option::Option<&crate::model::ChannelSummary> {
        self.channel_summary.as_ref()
    }
    /// <p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_membership_summary(
        &self,
    ) -> std::option::Option<&crate::model::AppInstanceUserMembershipSummary> {
        self.app_instance_user_membership_summary.as_ref()
    }
}
impl std::fmt::Debug for ChannelMembershipForAppInstanceUserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMembershipForAppInstanceUserSummary");
        formatter.field("channel_summary", &self.channel_summary);
        formatter.field(
            "app_instance_user_membership_summary",
            &self.app_instance_user_membership_summary,
        );
        formatter.finish()
    }
}
/// See [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
pub mod channel_membership_for_app_instance_user_summary {
    /// A builder for [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_summary: std::option::Option<crate::model::ChannelSummary>,
        pub(crate) app_instance_user_membership_summary:
            std::option::Option<crate::model::AppInstanceUserMembershipSummary>,
    }
    impl Builder {
        /// <p>Summary of the details of a <code>Channel</code>.</p>
        pub fn channel_summary(mut self, input: crate::model::ChannelSummary) -> Self {
            self.channel_summary = Some(input);
            self
        }
        /// <p>Summary of the details of a <code>Channel</code>.</p>
        pub fn set_channel_summary(
            mut self,
            input: std::option::Option<crate::model::ChannelSummary>,
        ) -> Self {
            self.channel_summary = input;
            self
        }
        /// <p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_membership_summary(
            mut self,
            input: crate::model::AppInstanceUserMembershipSummary,
        ) -> Self {
            self.app_instance_user_membership_summary = Some(input);
            self
        }
        /// <p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_membership_summary(
            mut self,
            input: std::option::Option<crate::model::AppInstanceUserMembershipSummary>,
        ) -> Self {
            self.app_instance_user_membership_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
        pub fn build(self) -> crate::model::ChannelMembershipForAppInstanceUserSummary {
            crate::model::ChannelMembershipForAppInstanceUserSummary {
                channel_summary: self.channel_summary,
                app_instance_user_membership_summary: self.app_instance_user_membership_summary,
            }
        }
    }
}
impl ChannelMembershipForAppInstanceUserSummary {
    /// Creates a new builder-style object to manufacture [`ChannelMembershipForAppInstanceUserSummary`](crate::model::ChannelMembershipForAppInstanceUserSummary)
    pub fn builder() -> crate::model::channel_membership_for_app_instance_user_summary::Builder {
        crate::model::channel_membership_for_app_instance_user_summary::Builder::default()
    }
}

/// <p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUserMembershipSummary {
    /// <p>The type of <code>ChannelMembership</code>.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The time at which a message was last read.</p>
    pub read_marker_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl AppInstanceUserMembershipSummary {
    /// <p>The type of <code>ChannelMembership</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMembershipType> {
        self.r#type.as_ref()
    }
    /// <p>The time at which a message was last read.</p>
    pub fn read_marker_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.read_marker_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceUserMembershipSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUserMembershipSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("read_marker_timestamp", &self.read_marker_timestamp);
        formatter.finish()
    }
}
/// See [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
pub mod app_instance_user_membership_summary {
    /// A builder for [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) read_marker_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The type of <code>ChannelMembership</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of <code>ChannelMembership</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time at which a message was last read.</p>
        pub fn read_marker_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.read_marker_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was last read.</p>
        pub fn set_read_marker_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.read_marker_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
        pub fn build(self) -> crate::model::AppInstanceUserMembershipSummary {
            crate::model::AppInstanceUserMembershipSummary {
                r#type: self.r#type,
                read_marker_timestamp: self.read_marker_timestamp,
            }
        }
    }
}
impl AppInstanceUserMembershipSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceUserMembershipSummary`](crate::model::AppInstanceUserMembershipSummary)
    pub fn builder() -> crate::model::app_instance_user_membership_summary::Builder {
        crate::model::app_instance_user_membership_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelMembershipType {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Hidden,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelMembershipType {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => ChannelMembershipType::Default,
            "HIDDEN" => ChannelMembershipType::Hidden,
            other => ChannelMembershipType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelMembershipType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelMembershipType::from(s))
    }
}
impl ChannelMembershipType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelMembershipType::Default => "DEFAULT",
            ChannelMembershipType::Hidden => "HIDDEN",
            ChannelMembershipType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "HIDDEN"]
    }
}
impl AsRef<str> for ChannelMembershipType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of the details of a <code>ChannelMembership</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMembershipSummary {
    /// <p>A member's summary data.</p>
    pub member: std::option::Option<crate::model::Identity>,
}
impl ChannelMembershipSummary {
    /// <p>A member's summary data.</p>
    pub fn member(&self) -> std::option::Option<&crate::model::Identity> {
        self.member.as_ref()
    }
}
impl std::fmt::Debug for ChannelMembershipSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMembershipSummary");
        formatter.field("member", &self.member);
        formatter.finish()
    }
}
/// See [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
pub mod channel_membership_summary {
    /// A builder for [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>A member's summary data.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>A member's summary data.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
        pub fn build(self) -> crate::model::ChannelMembershipSummary {
            crate::model::ChannelMembershipSummary {
                member: self.member,
            }
        }
    }
}
impl ChannelMembershipSummary {
    /// Creates a new builder-style object to manufacture [`ChannelMembershipSummary`](crate::model::ChannelMembershipSummary)
    pub fn builder() -> crate::model::channel_membership_summary::Builder {
        crate::model::channel_membership_summary::Builder::default()
    }
}

/// <p>Summary of the details of a <code>ChannelBan</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelBanSummary {
    /// <p>The member being banned from a channel.</p>
    pub member: std::option::Option<crate::model::Identity>,
}
impl ChannelBanSummary {
    /// <p>The member being banned from a channel.</p>
    pub fn member(&self) -> std::option::Option<&crate::model::Identity> {
        self.member.as_ref()
    }
}
impl std::fmt::Debug for ChannelBanSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelBanSummary");
        formatter.field("member", &self.member);
        formatter.finish()
    }
}
/// See [`ChannelBanSummary`](crate::model::ChannelBanSummary)
pub mod channel_ban_summary {
    /// A builder for [`ChannelBanSummary`](crate::model::ChannelBanSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The member being banned from a channel.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The member being banned from a channel.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelBanSummary`](crate::model::ChannelBanSummary)
        pub fn build(self) -> crate::model::ChannelBanSummary {
            crate::model::ChannelBanSummary {
                member: self.member,
            }
        }
    }
}
impl ChannelBanSummary {
    /// Creates a new builder-style object to manufacture [`ChannelBanSummary`](crate::model::ChannelBanSummary)
    pub fn builder() -> crate::model::channel_ban_summary::Builder {
        crate::model::channel_ban_summary::Builder::default()
    }
}

/// <p>
/// An Amazon Chime SDK meeting attendee. Includes a unique
/// <code>AttendeeId</code>
/// and
/// <code>JoinToken</code>
/// . The
/// <code>JoinToken</code>
/// allows a client to authenticate and join as the specified attendee. The
/// <code>JoinToken</code>
/// expires when the meeting ends or when
/// <a>DeleteAttendee</a>
/// is called. After that, the attendee is unable to join the meeting.
/// </p>
///
/// <p>We recommend securely transferring each <code>JoinToken</code> from your server application
/// to the client so that no other client has access to the token except for the one
/// authorized to represent the attendee.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attendee {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub external_user_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub attendee_id: std::option::Option<std::string::String>,
    /// <p>The join token used by the Amazon Chime SDK attendee.</p>
    pub join_token: std::option::Option<std::string::String>,
}
impl Attendee {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub fn external_user_id(&self) -> std::option::Option<&str> {
        self.external_user_id.as_deref()
    }
    /// <p>The Amazon Chime SDK attendee ID.</p>
    pub fn attendee_id(&self) -> std::option::Option<&str> {
        self.attendee_id.as_deref()
    }
    /// <p>The join token used by the Amazon Chime SDK attendee.</p>
    pub fn join_token(&self) -> std::option::Option<&str> {
        self.join_token.as_deref()
    }
}
impl std::fmt::Debug for Attendee {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attendee");
        formatter.field("external_user_id", &"*** Sensitive Data Redacted ***");
        formatter.field("attendee_id", &self.attendee_id);
        formatter.field("join_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Attendee`](crate::model::Attendee)
pub mod attendee {
    /// A builder for [`Attendee`](crate::model::Attendee)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_user_id: std::option::Option<std::string::String>,
        pub(crate) attendee_id: std::option::Option<std::string::String>,
        pub(crate) join_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attendee_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attendee_id = input;
            self
        }
        /// <p>The join token used by the Amazon Chime SDK attendee.</p>
        pub fn join_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.join_token = Some(input.into());
            self
        }
        /// <p>The join token used by the Amazon Chime SDK attendee.</p>
        pub fn set_join_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.join_token = input;
            self
        }
        /// Consumes the builder and constructs a [`Attendee`](crate::model::Attendee)
        pub fn build(self) -> crate::model::Attendee {
            crate::model::Attendee {
                external_user_id: self.external_user_id,
                attendee_id: self.attendee_id,
                join_token: self.join_token,
            }
        }
    }
}
impl Attendee {
    /// Creates a new builder-style object to manufacture [`Attendee`](crate::model::Attendee)
    pub fn builder() -> crate::model::attendee::Builder {
        crate::model::attendee::Builder::default()
    }
}

/// <p>Summary of the details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUserSummary {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The name of an <code>AppInstanceUser</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
}
impl AppInstanceUserSummary {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The name of an <code>AppInstanceUser</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for AppInstanceUserSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUserSummary");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
pub mod app_instance_user_summary {
    /// A builder for [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The name of an <code>AppInstanceUser</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an <code>AppInstanceUser</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
        pub fn build(self) -> crate::model::AppInstanceUserSummary {
            crate::model::AppInstanceUserSummary {
                app_instance_user_arn: self.app_instance_user_arn,
                name: self.name,
                metadata: self.metadata,
            }
        }
    }
}
impl AppInstanceUserSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceUserSummary`](crate::model::AppInstanceUserSummary)
    pub fn builder() -> crate::model::app_instance_user_summary::Builder {
        crate::model::app_instance_user_summary::Builder::default()
    }
}

/// <p>Summary of the data for an <code>AppInstance</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceSummary {
    /// <p>The <code>AppInstance</code> ARN.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>AppInstance</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The metadata of the <code>AppInstance</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
}
impl AppInstanceSummary {
    /// <p>The <code>AppInstance</code> ARN.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The name of the <code>AppInstance</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The metadata of the <code>AppInstance</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
}
impl std::fmt::Debug for AppInstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceSummary");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AppInstanceSummary`](crate::model::AppInstanceSummary)
pub mod app_instance_summary {
    /// A builder for [`AppInstanceSummary`](crate::model::AppInstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AppInstance</code> ARN.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The <code>AppInstance</code> ARN.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceSummary`](crate::model::AppInstanceSummary)
        pub fn build(self) -> crate::model::AppInstanceSummary {
            crate::model::AppInstanceSummary {
                app_instance_arn: self.app_instance_arn,
                name: self.name,
                metadata: self.metadata,
            }
        }
    }
}
impl AppInstanceSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceSummary`](crate::model::AppInstanceSummary)
    pub fn builder() -> crate::model::app_instance_summary::Builder {
        crate::model::app_instance_summary::Builder::default()
    }
}

/// <p>Summary of the details of an <code>AppInstanceAdmin</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceAdminSummary {
    /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
    pub admin: std::option::Option<crate::model::Identity>,
}
impl AppInstanceAdminSummary {
    /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
    pub fn admin(&self) -> std::option::Option<&crate::model::Identity> {
        self.admin.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceAdminSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceAdminSummary");
        formatter.field("admin", &self.admin);
        formatter.finish()
    }
}
/// See [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
pub mod app_instance_admin_summary {
    /// A builder for [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
        pub fn admin(mut self, input: crate::model::Identity) -> Self {
            self.admin = Some(input);
            self
        }
        /// <p>The details of the <code>AppInstanceAdmin</code>.</p>
        pub fn set_admin(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.admin = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
        pub fn build(self) -> crate::model::AppInstanceAdminSummary {
            crate::model::AppInstanceAdminSummary { admin: self.admin }
        }
    }
}
impl AppInstanceAdminSummary {
    /// Creates a new builder-style object to manufacture [`AppInstanceAdminSummary`](crate::model::AppInstanceAdminSummary)
    pub fn builder() -> crate::model::app_instance_admin_summary::Builder {
        crate::model::app_instance_admin_summary::Builder::default()
    }
}

/// <p>Invitation object returned after emailing users to invite them to join the Amazon Chime
/// <code>Team</code> account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Invite {
    /// <p>The invite ID.</p>
    pub invite_id: std::option::Option<std::string::String>,
    /// <p>The status of the invite.</p>
    pub status: std::option::Option<crate::model::InviteStatus>,
    /// <p>The email address to which the invite is sent.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The status of the invite email.</p>
    pub email_status: std::option::Option<crate::model::EmailStatus>,
}
impl Invite {
    /// <p>The invite ID.</p>
    pub fn invite_id(&self) -> std::option::Option<&str> {
        self.invite_id.as_deref()
    }
    /// <p>The status of the invite.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::InviteStatus> {
        self.status.as_ref()
    }
    /// <p>The email address to which the invite is sent.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The status of the invite email.</p>
    pub fn email_status(&self) -> std::option::Option<&crate::model::EmailStatus> {
        self.email_status.as_ref()
    }
}
impl std::fmt::Debug for Invite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Invite");
        formatter.field("invite_id", &self.invite_id);
        formatter.field("status", &self.status);
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("email_status", &self.email_status);
        formatter.finish()
    }
}
/// See [`Invite`](crate::model::Invite)
pub mod invite {
    /// A builder for [`Invite`](crate::model::Invite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invite_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::InviteStatus>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) email_status: std::option::Option<crate::model::EmailStatus>,
    }
    impl Builder {
        /// <p>The invite ID.</p>
        pub fn invite_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invite_id = Some(input.into());
            self
        }
        /// <p>The invite ID.</p>
        pub fn set_invite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invite_id = input;
            self
        }
        /// <p>The status of the invite.</p>
        pub fn status(mut self, input: crate::model::InviteStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the invite.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InviteStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The email address to which the invite is sent.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address to which the invite is sent.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The status of the invite email.</p>
        pub fn email_status(mut self, input: crate::model::EmailStatus) -> Self {
            self.email_status = Some(input);
            self
        }
        /// <p>The status of the invite email.</p>
        pub fn set_email_status(
            mut self,
            input: std::option::Option<crate::model::EmailStatus>,
        ) -> Self {
            self.email_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Invite`](crate::model::Invite)
        pub fn build(self) -> crate::model::Invite {
            crate::model::Invite {
                invite_id: self.invite_id,
                status: self.status,
                email_address: self.email_address,
                email_status: self.email_status,
            }
        }
    }
}
impl Invite {
    /// Creates a new builder-style object to manufacture [`Invite`](crate::model::Invite)
    pub fn builder() -> crate::model::invite::Builder {
        crate::model::invite::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EmailStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotSent,
    #[allow(missing_docs)] // documentation missing in model
    Sent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EmailStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => EmailStatus::Failed,
            "NotSent" => EmailStatus::NotSent,
            "Sent" => EmailStatus::Sent,
            other => EmailStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EmailStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EmailStatus::from(s))
    }
}
impl EmailStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EmailStatus::Failed => "Failed",
            EmailStatus::NotSent => "NotSent",
            EmailStatus::Sent => "Sent",
            EmailStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "NotSent", "Sent"]
    }
}
impl AsRef<str> for EmailStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The termination health details, including the source IP address and timestamp of the last
/// successful SIP <code>OPTIONS</code> message from your SIP infrastructure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminationHealth {
    /// <p>The timestamp, in ISO 8601 format.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The source IP address.</p>
    pub source: std::option::Option<std::string::String>,
}
impl TerminationHealth {
    /// <p>The timestamp, in ISO 8601 format.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The source IP address.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
}
impl std::fmt::Debug for TerminationHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminationHealth");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`TerminationHealth`](crate::model::TerminationHealth)
pub mod termination_health {
    /// A builder for [`TerminationHealth`](crate::model::TerminationHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) source: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The timestamp, in ISO 8601 format.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp, in ISO 8601 format.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The source IP address.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source IP address.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminationHealth`](crate::model::TerminationHealth)
        pub fn build(self) -> crate::model::TerminationHealth {
            crate::model::TerminationHealth {
                timestamp: self.timestamp,
                source: self.source,
            }
        }
    }
}
impl TerminationHealth {
    /// Creates a new builder-style object to manufacture [`TerminationHealth`](crate::model::TerminationHealth)
    pub fn builder() -> crate::model::termination_health::Builder {
        crate::model::termination_health::Builder::default()
    }
}

/// <p>The websocket endpoint used to connect to Amazon Chime SDK messaging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessagingSessionEndpoint {
    /// <p>The endpoint to which you establish a websocket connection.</p>
    pub url: std::option::Option<std::string::String>,
}
impl MessagingSessionEndpoint {
    /// <p>The endpoint to which you establish a websocket connection.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for MessagingSessionEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessagingSessionEndpoint");
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
pub mod messaging_session_endpoint {
    /// A builder for [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint to which you establish a websocket connection.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The endpoint to which you establish a websocket connection.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
        pub fn build(self) -> crate::model::MessagingSessionEndpoint {
            crate::model::MessagingSessionEndpoint { url: self.url }
        }
    }
}
impl MessagingSessionEndpoint {
    /// Creates a new builder-style object to manufacture [`MessagingSessionEndpoint`](crate::model::MessagingSessionEndpoint)
    pub fn builder() -> crate::model::messaging_session_endpoint::Builder {
        crate::model::messaging_session_endpoint::Builder::default()
    }
}

/// <p>The details of a message in a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMessage {
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The ID of a message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The message content.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The message metadata.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The message type.</p>
    pub r#type: std::option::Option<crate::model::ChannelMessageType>,
    /// <p>The time at which the message was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was edited.</p>
    pub last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a message was updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The message sender.</p>
    pub sender: std::option::Option<crate::model::Identity>,
    /// <p>Hides the content of a message.</p>
    pub redacted: bool,
    /// <p>The persistence setting for a channel message.</p>
    pub persistence: std::option::Option<crate::model::ChannelMessagePersistenceType>,
}
impl ChannelMessage {
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The ID of a message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The message content.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The message metadata.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The message type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMessageType> {
        self.r#type.as_ref()
    }
    /// <p>The time at which the message was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which a message was edited.</p>
    pub fn last_edited_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_edited_timestamp.as_ref()
    }
    /// <p>The time at which a message was updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>The message sender.</p>
    pub fn sender(&self) -> std::option::Option<&crate::model::Identity> {
        self.sender.as_ref()
    }
    /// <p>Hides the content of a message.</p>
    pub fn redacted(&self) -> bool {
        self.redacted
    }
    /// <p>The persistence setting for a channel message.</p>
    pub fn persistence(&self) -> std::option::Option<&crate::model::ChannelMessagePersistenceType> {
        self.persistence.as_ref()
    }
}
impl std::fmt::Debug for ChannelMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMessage");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("message_id", &self.message_id);
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_edited_timestamp", &self.last_edited_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("sender", &self.sender);
        formatter.field("redacted", &self.redacted);
        formatter.field("persistence", &self.persistence);
        formatter.finish()
    }
}
/// See [`ChannelMessage`](crate::model::ChannelMessage)
pub mod channel_message {
    /// A builder for [`ChannelMessage`](crate::model::ChannelMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMessageType>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_edited_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) sender: std::option::Option<crate::model::Identity>,
        pub(crate) redacted: std::option::Option<bool>,
        pub(crate) persistence: std::option::Option<crate::model::ChannelMessagePersistenceType>,
    }
    impl Builder {
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The ID of a message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of a message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The message content.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The message content.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The message metadata.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The message metadata.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The message type.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMessageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The message type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time at which the message was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the message was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a message was edited.</p>
        pub fn last_edited_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_edited_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was edited.</p>
        pub fn set_last_edited_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_edited_timestamp = input;
            self
        }
        /// <p>The time at which a message was updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a message was updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>The message sender.</p>
        pub fn sender(mut self, input: crate::model::Identity) -> Self {
            self.sender = Some(input);
            self
        }
        /// <p>The message sender.</p>
        pub fn set_sender(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.sender = input;
            self
        }
        /// <p>Hides the content of a message.</p>
        pub fn redacted(mut self, input: bool) -> Self {
            self.redacted = Some(input);
            self
        }
        /// <p>Hides the content of a message.</p>
        pub fn set_redacted(mut self, input: std::option::Option<bool>) -> Self {
            self.redacted = input;
            self
        }
        /// <p>The persistence setting for a channel message.</p>
        pub fn persistence(mut self, input: crate::model::ChannelMessagePersistenceType) -> Self {
            self.persistence = Some(input);
            self
        }
        /// <p>The persistence setting for a channel message.</p>
        pub fn set_persistence(
            mut self,
            input: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        ) -> Self {
            self.persistence = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMessage`](crate::model::ChannelMessage)
        pub fn build(self) -> crate::model::ChannelMessage {
            crate::model::ChannelMessage {
                channel_arn: self.channel_arn,
                message_id: self.message_id,
                content: self.content,
                metadata: self.metadata,
                r#type: self.r#type,
                created_timestamp: self.created_timestamp,
                last_edited_timestamp: self.last_edited_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                sender: self.sender,
                redacted: self.redacted.unwrap_or_default(),
                persistence: self.persistence,
            }
        }
    }
}
impl ChannelMessage {
    /// Creates a new builder-style object to manufacture [`ChannelMessage`](crate::model::ChannelMessage)
    pub fn builder() -> crate::model::channel_message::Builder {
        crate::model::channel_message::Builder::default()
    }
}

/// <p>If the phone number action fails for one or more of the phone numbers in the request, a list of
/// the phone numbers is returned, along with error codes and error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberError {
    /// <p>The phone number ID for which the action failed.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl PhoneNumberError {
    /// <p>The phone number ID for which the action failed.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for PhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberError");
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PhoneNumberError`](crate::model::PhoneNumberError)
pub mod phone_number_error {
    /// A builder for [`PhoneNumberError`](crate::model::PhoneNumberError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone number ID for which the action failed.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The phone number ID for which the action failed.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberError`](crate::model::PhoneNumberError)
        pub fn build(self) -> crate::model::PhoneNumberError {
            crate::model::PhoneNumberError {
                phone_number_id: self.phone_number_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PhoneNumberError {
    /// Creates a new builder-style object to manufacture [`PhoneNumberError`](crate::model::PhoneNumberError)
    pub fn builder() -> crate::model::phone_number_error::Builder {
        crate::model::phone_number_error::Builder::default()
    }
}

/// <p>The details of a channel moderator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelModerator {
    /// <p>The moderator's data.</p>
    pub moderator: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the moderator's channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the moderator was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
    pub created_by: std::option::Option<crate::model::Identity>,
}
impl ChannelModerator {
    /// <p>The moderator's data.</p>
    pub fn moderator(&self) -> std::option::Option<&crate::model::Identity> {
        self.moderator.as_ref()
    }
    /// <p>The ARN of the moderator's channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The time at which the moderator was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::Identity> {
        self.created_by.as_ref()
    }
}
impl std::fmt::Debug for ChannelModerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelModerator");
        formatter.field("moderator", &self.moderator);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ChannelModerator`](crate::model::ChannelModerator)
pub mod channel_moderator {
    /// A builder for [`ChannelModerator`](crate::model::ChannelModerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) moderator: std::option::Option<crate::model::Identity>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The moderator's data.</p>
        pub fn moderator(mut self, input: crate::model::Identity) -> Self {
            self.moderator = Some(input);
            self
        }
        /// <p>The moderator's data.</p>
        pub fn set_moderator(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.moderator = input;
            self
        }
        /// <p>The ARN of the moderator's channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the moderator's channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The time at which the moderator was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the moderator was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
        pub fn created_by(mut self, input: crate::model::Identity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the moderator.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelModerator`](crate::model::ChannelModerator)
        pub fn build(self) -> crate::model::ChannelModerator {
            crate::model::ChannelModerator {
                moderator: self.moderator,
                channel_arn: self.channel_arn,
                created_timestamp: self.created_timestamp,
                created_by: self.created_by,
            }
        }
    }
}
impl ChannelModerator {
    /// Creates a new builder-style object to manufacture [`ChannelModerator`](crate::model::ChannelModerator)
    pub fn builder() -> crate::model::channel_moderator::Builder {
        crate::model::channel_moderator::Builder::default()
    }
}

/// <p>The details of a channel member.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMembership {
    /// <p>The identifier of the member who invited another member.</p>
    pub invited_by: std::option::Option<crate::model::Identity>,
    /// <p>The membership type set for the channel member.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The data of the channel member.</p>
    pub member: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the member's channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the channel membership was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a channel membership was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl ChannelMembership {
    /// <p>The identifier of the member who invited another member.</p>
    pub fn invited_by(&self) -> std::option::Option<&crate::model::Identity> {
        self.invited_by.as_ref()
    }
    /// <p>The membership type set for the channel member.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMembershipType> {
        self.r#type.as_ref()
    }
    /// <p>The data of the channel member.</p>
    pub fn member(&self) -> std::option::Option<&crate::model::Identity> {
        self.member.as_ref()
    }
    /// <p>The ARN of the member's channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The time at which the channel membership was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which a channel membership was last updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ChannelMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMembership");
        formatter.field("invited_by", &self.invited_by);
        formatter.field("r#type", &self.r#type);
        formatter.field("member", &self.member);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`ChannelMembership`](crate::model::ChannelMembership)
pub mod channel_membership {
    /// A builder for [`ChannelMembership`](crate::model::ChannelMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invited_by: std::option::Option<crate::model::Identity>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) member: std::option::Option<crate::model::Identity>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the member who invited another member.</p>
        pub fn invited_by(mut self, input: crate::model::Identity) -> Self {
            self.invited_by = Some(input);
            self
        }
        /// <p>The identifier of the member who invited another member.</p>
        pub fn set_invited_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.invited_by = input;
            self
        }
        /// <p>The membership type set for the channel member.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership type set for the channel member.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The data of the channel member.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The data of the channel member.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// <p>The ARN of the member's channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member's channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The time at which the channel membership was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the channel membership was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a channel membership was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a channel membership was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMembership`](crate::model::ChannelMembership)
        pub fn build(self) -> crate::model::ChannelMembership {
            crate::model::ChannelMembership {
                invited_by: self.invited_by,
                r#type: self.r#type,
                member: self.member,
                channel_arn: self.channel_arn,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl ChannelMembership {
    /// Creates a new builder-style object to manufacture [`ChannelMembership`](crate::model::ChannelMembership)
    pub fn builder() -> crate::model::channel_membership::Builder {
        crate::model::channel_membership::Builder::default()
    }
}

/// <p>The details of a channel ban.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelBan {
    /// <p>The member being banned from the channel.</p>
    pub member: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the channel from which a member is being banned.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the ban was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
    pub created_by: std::option::Option<crate::model::Identity>,
}
impl ChannelBan {
    /// <p>The member being banned from the channel.</p>
    pub fn member(&self) -> std::option::Option<&crate::model::Identity> {
        self.member.as_ref()
    }
    /// <p>The ARN of the channel from which a member is being banned.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The time at which the ban was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::Identity> {
        self.created_by.as_ref()
    }
}
impl std::fmt::Debug for ChannelBan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelBan");
        formatter.field("member", &self.member);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ChannelBan`](crate::model::ChannelBan)
pub mod channel_ban {
    /// A builder for [`ChannelBan`](crate::model::ChannelBan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member: std::option::Option<crate::model::Identity>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<crate::model::Identity>,
    }
    impl Builder {
        /// <p>The member being banned from the channel.</p>
        pub fn member(mut self, input: crate::model::Identity) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>The member being banned from the channel.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.member = input;
            self
        }
        /// <p>The ARN of the channel from which a member is being banned.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel from which a member is being banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The time at which the ban was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the ban was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
        pub fn created_by(mut self, input: crate::model::Identity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the ban.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelBan`](crate::model::ChannelBan)
        pub fn build(self) -> crate::model::ChannelBan {
            crate::model::ChannelBan {
                member: self.member,
                channel_arn: self.channel_arn,
                created_timestamp: self.created_timestamp,
                created_by: self.created_by,
            }
        }
    }
}
impl ChannelBan {
    /// Creates a new builder-style object to manufacture [`ChannelBan`](crate::model::ChannelBan)
    pub fn builder() -> crate::model::channel_ban::Builder {
        crate::model::channel_ban::Builder::default()
    }
}

/// <p>The details of a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Channel {
    /// <p>The name of the channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The mode of the channel.</p>
    pub mode: std::option::Option<crate::model::ChannelMode>,
    /// <p>The channel's privacy setting.</p>
    pub privacy: std::option::Option<crate::model::ChannelPrivacy>,
    /// <p>The channel's metadata.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
    pub created_by: std::option::Option<crate::model::Identity>,
    /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a member sent the last message in the channel.</p>
    pub last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which a channel was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl Channel {
    /// <p>The name of the channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the channel.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The mode of the channel.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::ChannelMode> {
        self.mode.as_ref()
    }
    /// <p>The channel's privacy setting.</p>
    pub fn privacy(&self) -> std::option::Option<&crate::model::ChannelPrivacy> {
        self.privacy.as_ref()
    }
    /// <p>The channel's metadata.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::Identity> {
        self.created_by.as_ref()
    }
    /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time at which a member sent the last message in the channel.</p>
    pub fn last_message_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_message_timestamp.as_ref()
    }
    /// <p>The time at which a channel was last updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for Channel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Channel");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("mode", &self.mode);
        formatter.field("privacy", &self.privacy);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("created_by", &self.created_by);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_message_timestamp", &self.last_message_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`Channel`](crate::model::Channel)
pub mod channel {
    /// A builder for [`Channel`](crate::model::Channel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ChannelMode>,
        pub(crate) privacy: std::option::Option<crate::model::ChannelPrivacy>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::Identity>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_message_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn mode(mut self, input: crate::model::ChannelMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode of the channel.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The channel's privacy setting.</p>
        pub fn privacy(mut self, input: crate::model::ChannelPrivacy) -> Self {
            self.privacy = Some(input);
            self
        }
        /// <p>The channel's privacy setting.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.privacy = input;
            self
        }
        /// <p>The channel's metadata.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The channel's metadata.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
        pub fn created_by(mut self, input: crate::model::Identity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>The <code>AppInstanceUser</code> who created the channel.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> created the channel.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time at which a member sent the last message in the channel.</p>
        pub fn last_message_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_message_timestamp = Some(input);
            self
        }
        /// <p>The time at which a member sent the last message in the channel.</p>
        pub fn set_last_message_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_message_timestamp = input;
            self
        }
        /// <p>The time at which a channel was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which a channel was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Channel`](crate::model::Channel)
        pub fn build(self) -> crate::model::Channel {
            crate::model::Channel {
                name: self.name,
                channel_arn: self.channel_arn,
                mode: self.mode,
                privacy: self.privacy,
                metadata: self.metadata,
                created_by: self.created_by,
                created_timestamp: self.created_timestamp,
                last_message_timestamp: self.last_message_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl Channel {
    /// Creates a new builder-style object to manufacture [`Channel`](crate::model::Channel)
    pub fn builder() -> crate::model::channel::Builder {
        crate::model::channel::Builder::default()
    }
}

/// <p>The details of an <code>AppInstanceUser</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceUser {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub app_instance_user_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl AppInstanceUser {
    /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
    pub fn app_instance_user_arn(&self) -> std::option::Option<&str> {
        self.app_instance_user_arn.as_deref()
    }
    /// <p>The name of the <code>AppInstanceUser</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceUser");
        formatter.field("app_instance_user_arn", &self.app_instance_user_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`AppInstanceUser`](crate::model::AppInstanceUser)
pub mod app_instance_user {
    /// A builder for [`AppInstanceUser`](crate::model::AppInstanceUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_user_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_user_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_user_arn = input;
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time at which the <code>AppInstanceUser</code> was last updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceUser`](crate::model::AppInstanceUser)
        pub fn build(self) -> crate::model::AppInstanceUser {
            crate::model::AppInstanceUser {
                app_instance_user_arn: self.app_instance_user_arn,
                name: self.name,
                created_timestamp: self.created_timestamp,
                metadata: self.metadata,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl AppInstanceUser {
    /// Creates a new builder-style object to manufacture [`AppInstanceUser`](crate::model::AppInstanceUser)
    pub fn builder() -> crate::model::app_instance_user::Builder {
        crate::model::app_instance_user::Builder::default()
    }
}

/// <p>The details of an <code>AppInstanceAdmin</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstanceAdmin {
    /// <p>The <code>AppInstanceAdmin</code> data.</p>
    pub admin: std::option::Option<crate::model::Identity>,
    /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The time at which an administrator was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl AppInstanceAdmin {
    /// <p>The <code>AppInstanceAdmin</code> data.</p>
    pub fn admin(&self) -> std::option::Option<&crate::model::Identity> {
        self.admin.as_ref()
    }
    /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The time at which an administrator was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AppInstanceAdmin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstanceAdmin");
        formatter.field("admin", &self.admin);
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
pub mod app_instance_admin {
    /// A builder for [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin: std::option::Option<crate::model::Identity>,
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The <code>AppInstanceAdmin</code> data.</p>
        pub fn admin(mut self, input: crate::model::Identity) -> Self {
            self.admin = Some(input);
            self
        }
        /// <p>The <code>AppInstanceAdmin</code> data.</p>
        pub fn set_admin(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.admin = input;
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The time at which an administrator was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which an administrator was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
        pub fn build(self) -> crate::model::AppInstanceAdmin {
            crate::model::AppInstanceAdmin {
                admin: self.admin,
                app_instance_arn: self.app_instance_arn,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl AppInstanceAdmin {
    /// Creates a new builder-style object to manufacture [`AppInstanceAdmin`](crate::model::AppInstanceAdmin)
    pub fn builder() -> crate::model::app_instance_admin::Builder {
        crate::model::app_instance_admin::Builder::default()
    }
}

/// <p>The details of an <code>AppInstance</code>, an instance of an Amazon Chime SDK messaging application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppInstance {
    /// <p>The ARN of the messaging instance.</p>
    pub app_instance_arn: std::option::Option<std::string::String>,
    /// <p>The name of an <code>AppInstance</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The metadata of an <code>AppInstance</code>.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl AppInstance {
    /// <p>The ARN of the messaging instance.</p>
    pub fn app_instance_arn(&self) -> std::option::Option<&str> {
        self.app_instance_arn.as_deref()
    }
    /// <p>The name of an <code>AppInstance</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The metadata of an <code>AppInstance</code>.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_timestamp.as_ref()
    }
    /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for AppInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppInstance");
        formatter.field("app_instance_arn", &self.app_instance_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`AppInstance`](crate::model::AppInstance)
pub mod app_instance {
    /// A builder for [`AppInstance`](crate::model::AppInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_instance_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the messaging instance.</p>
        pub fn app_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the messaging instance.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_instance_arn = input;
            self
        }
        /// <p>The name of an <code>AppInstance</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The metadata of an <code>AppInstance</code>.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The metadata of an <code>AppInstance</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AppInstance`](crate::model::AppInstance)
        pub fn build(self) -> crate::model::AppInstance {
            crate::model::AppInstance {
                app_instance_arn: self.app_instance_arn,
                name: self.name,
                metadata: self.metadata,
                created_timestamp: self.created_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl AppInstance {
    /// Creates a new builder-style object to manufacture [`AppInstance`](crate::model::AppInstance)
    pub fn builder() -> crate::model::app_instance::Builder {
        crate::model::app_instance::Builder::default()
    }
}

/// <p>The list of errors returned when errors are encountered during the BatchCreateAttendee and CreateAttendee actions. This includes external user IDs, error codes, and error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAttendeeError {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub external_user_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl CreateAttendeeError {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub fn external_user_id(&self) -> std::option::Option<&str> {
        self.external_user_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for CreateAttendeeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAttendeeError");
        formatter.field("external_user_id", &"*** Sensitive Data Redacted ***");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`CreateAttendeeError`](crate::model::CreateAttendeeError)
pub mod create_attendee_error {
    /// A builder for [`CreateAttendeeError`](crate::model::CreateAttendeeError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_user_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAttendeeError`](crate::model::CreateAttendeeError)
        pub fn build(self) -> crate::model::CreateAttendeeError {
            crate::model::CreateAttendeeError {
                external_user_id: self.external_user_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl CreateAttendeeError {
    /// Creates a new builder-style object to manufacture [`CreateAttendeeError`](crate::model::CreateAttendeeError)
    pub fn builder() -> crate::model::create_attendee_error::Builder {
        crate::model::create_attendee_error::Builder::default()
    }
}

/// <p>The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAttendeeRequestItem {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub external_user_id: std::option::Option<std::string::String>,
    /// <p>The tag key-value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateAttendeeRequestItem {
    /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
    pub fn external_user_id(&self) -> std::option::Option<&str> {
        self.external_user_id.as_deref()
    }
    /// <p>The tag key-value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateAttendeeRequestItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAttendeeRequestItem");
        formatter.field("external_user_id", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
pub mod create_attendee_request_item {
    /// A builder for [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_user_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_user_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
        pub fn build(self) -> crate::model::CreateAttendeeRequestItem {
            crate::model::CreateAttendeeRequestItem {
                external_user_id: self.external_user_id,
                tags: self.tags,
            }
        }
    }
}
impl CreateAttendeeRequestItem {
    /// Creates a new builder-style object to manufacture [`CreateAttendeeRequestItem`](crate::model::CreateAttendeeRequestItem)
    pub fn builder() -> crate::model::create_attendee_request_item::Builder {
        crate::model::create_attendee_request_item::Builder::default()
    }
}

/// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event
/// notifications. The Amazon Chime SDK supports resource targets located in the US East (N.
/// Virginia) AWS Region (<code>us-east-1</code>). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeetingNotificationConfiguration {
    /// <p>The SNS topic ARN.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The SQS queue ARN.</p>
    pub sqs_queue_arn: std::option::Option<std::string::String>,
}
impl MeetingNotificationConfiguration {
    /// <p>The SNS topic ARN.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The SQS queue ARN.</p>
    pub fn sqs_queue_arn(&self) -> std::option::Option<&str> {
        self.sqs_queue_arn.as_deref()
    }
}
impl std::fmt::Debug for MeetingNotificationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeetingNotificationConfiguration");
        formatter.field("sns_topic_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("sqs_queue_arn", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`MeetingNotificationConfiguration`](crate::model::MeetingNotificationConfiguration)
pub mod meeting_notification_configuration {
    /// A builder for [`MeetingNotificationConfiguration`](crate::model::MeetingNotificationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) sqs_queue_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SNS topic ARN.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The SNS topic ARN.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The SQS queue ARN.</p>
        pub fn sqs_queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sqs_queue_arn = Some(input.into());
            self
        }
        /// <p>The SQS queue ARN.</p>
        pub fn set_sqs_queue_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sqs_queue_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MeetingNotificationConfiguration`](crate::model::MeetingNotificationConfiguration)
        pub fn build(self) -> crate::model::MeetingNotificationConfiguration {
            crate::model::MeetingNotificationConfiguration {
                sns_topic_arn: self.sns_topic_arn,
                sqs_queue_arn: self.sqs_queue_arn,
            }
        }
    }
}
impl MeetingNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`MeetingNotificationConfiguration`](crate::model::MeetingNotificationConfiguration)
    pub fn builder() -> crate::model::meeting_notification_configuration::Builder {
        crate::model::meeting_notification_configuration::Builder::default()
    }
}

/// <p>The list of errors returned when errors are encountered during the <a>BatchSuspendUser</a>, <a>BatchUnsuspendUser</a>, or
/// <a>BatchUpdateUser</a> actions. This includes user IDs, error codes, and error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserError {
    /// <p>The user ID for which the action failed.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl UserError {
    /// <p>The user ID for which the action failed.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for UserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserError");
        formatter.field("user_id", &self.user_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UserError`](crate::model::UserError)
pub mod user_error {
    /// A builder for [`UserError`](crate::model::UserError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user ID for which the action failed.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID for which the action failed.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserError`](crate::model::UserError)
        pub fn build(self) -> crate::model::UserError {
            crate::model::UserError {
                user_id: self.user_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl UserError {
    /// Creates a new builder-style object to manufacture [`UserError`](crate::model::UserError)
    pub fn builder() -> crate::model::user_error::Builder {
        crate::model::user_error::Builder::default()
    }
}

/// <p>The user ID and user fields to update, used with the
/// <a>BatchUpdateUser</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserRequestItem {
    /// <p>The user ID.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The user license type.</p>
    pub license_type: std::option::Option<crate::model::License>,
    /// <p>The user type.</p>
    pub user_type: std::option::Option<crate::model::UserType>,
    /// <p>The Alexa for Business metadata.</p>
    pub alexa_for_business_metadata: std::option::Option<crate::model::AlexaForBusinessMetadata>,
}
impl UpdateUserRequestItem {
    /// <p>The user ID.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The user license type.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::License> {
        self.license_type.as_ref()
    }
    /// <p>The user type.</p>
    pub fn user_type(&self) -> std::option::Option<&crate::model::UserType> {
        self.user_type.as_ref()
    }
    /// <p>The Alexa for Business metadata.</p>
    pub fn alexa_for_business_metadata(
        &self,
    ) -> std::option::Option<&crate::model::AlexaForBusinessMetadata> {
        self.alexa_for_business_metadata.as_ref()
    }
}
impl std::fmt::Debug for UpdateUserRequestItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserRequestItem");
        formatter.field("user_id", &self.user_id);
        formatter.field("license_type", &self.license_type);
        formatter.field("user_type", &self.user_type);
        formatter.field(
            "alexa_for_business_metadata",
            &self.alexa_for_business_metadata,
        );
        formatter.finish()
    }
}
/// See [`UpdateUserRequestItem`](crate::model::UpdateUserRequestItem)
pub mod update_user_request_item {
    /// A builder for [`UpdateUserRequestItem`](crate::model::UpdateUserRequestItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) license_type: std::option::Option<crate::model::License>,
        pub(crate) user_type: std::option::Option<crate::model::UserType>,
        pub(crate) alexa_for_business_metadata:
            std::option::Option<crate::model::AlexaForBusinessMetadata>,
    }
    impl Builder {
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The user license type.</p>
        pub fn license_type(mut self, input: crate::model::License) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The user license type.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::License>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.user_type = Some(input);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.user_type = input;
            self
        }
        /// <p>The Alexa for Business metadata.</p>
        pub fn alexa_for_business_metadata(
            mut self,
            input: crate::model::AlexaForBusinessMetadata,
        ) -> Self {
            self.alexa_for_business_metadata = Some(input);
            self
        }
        /// <p>The Alexa for Business metadata.</p>
        pub fn set_alexa_for_business_metadata(
            mut self,
            input: std::option::Option<crate::model::AlexaForBusinessMetadata>,
        ) -> Self {
            self.alexa_for_business_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserRequestItem`](crate::model::UpdateUserRequestItem)
        pub fn build(self) -> crate::model::UpdateUserRequestItem {
            crate::model::UpdateUserRequestItem {
                user_id: self.user_id,
                license_type: self.license_type,
                user_type: self.user_type,
                alexa_for_business_metadata: self.alexa_for_business_metadata,
            }
        }
    }
}
impl UpdateUserRequestItem {
    /// Creates a new builder-style object to manufacture [`UpdateUserRequestItem`](crate::model::UpdateUserRequestItem)
    pub fn builder() -> crate::model::update_user_request_item::Builder {
        crate::model::update_user_request_item::Builder::default()
    }
}

/// <p>The phone number ID, product type, or calling name fields to update, used with the
/// <a>BatchUpdatePhoneNumber</a> and <a>UpdatePhoneNumber</a> actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePhoneNumberRequestItem {
    /// <p>The phone number ID to update.</p>
    pub phone_number_id: std::option::Option<std::string::String>,
    /// <p>The product type to update.</p>
    pub product_type: std::option::Option<crate::model::PhoneNumberProductType>,
    /// <p>The outbound calling name to update.</p>
    pub calling_name: std::option::Option<std::string::String>,
}
impl UpdatePhoneNumberRequestItem {
    /// <p>The phone number ID to update.</p>
    pub fn phone_number_id(&self) -> std::option::Option<&str> {
        self.phone_number_id.as_deref()
    }
    /// <p>The product type to update.</p>
    pub fn product_type(&self) -> std::option::Option<&crate::model::PhoneNumberProductType> {
        self.product_type.as_ref()
    }
    /// <p>The outbound calling name to update.</p>
    pub fn calling_name(&self) -> std::option::Option<&str> {
        self.calling_name.as_deref()
    }
}
impl std::fmt::Debug for UpdatePhoneNumberRequestItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePhoneNumberRequestItem");
        formatter.field("phone_number_id", &self.phone_number_id);
        formatter.field("product_type", &self.product_type);
        formatter.field("calling_name", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`UpdatePhoneNumberRequestItem`](crate::model::UpdatePhoneNumberRequestItem)
pub mod update_phone_number_request_item {
    /// A builder for [`UpdatePhoneNumberRequestItem`](crate::model::UpdatePhoneNumberRequestItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number_id: std::option::Option<std::string::String>,
        pub(crate) product_type: std::option::Option<crate::model::PhoneNumberProductType>,
        pub(crate) calling_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone number ID to update.</p>
        pub fn phone_number_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number_id = Some(input.into());
            self
        }
        /// <p>The phone number ID to update.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.phone_number_id = input;
            self
        }
        /// <p>The product type to update.</p>
        pub fn product_type(mut self, input: crate::model::PhoneNumberProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The product type to update.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// <p>The outbound calling name to update.</p>
        pub fn calling_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calling_name = Some(input.into());
            self
        }
        /// <p>The outbound calling name to update.</p>
        pub fn set_calling_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.calling_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePhoneNumberRequestItem`](crate::model::UpdatePhoneNumberRequestItem)
        pub fn build(self) -> crate::model::UpdatePhoneNumberRequestItem {
            crate::model::UpdatePhoneNumberRequestItem {
                phone_number_id: self.phone_number_id,
                product_type: self.product_type,
                calling_name: self.calling_name,
            }
        }
    }
}
impl UpdatePhoneNumberRequestItem {
    /// Creates a new builder-style object to manufacture [`UpdatePhoneNumberRequestItem`](crate::model::UpdatePhoneNumberRequestItem)
    pub fn builder() -> crate::model::update_phone_number_request_item::Builder {
        crate::model::update_phone_number_request_item::Builder::default()
    }
}

/// <p>The list of errors returned when a member action results in an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberError {
    /// <p>The member ID.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl MemberError {
    /// <p>The member ID.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for MemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberError");
        formatter.field("member_id", &self.member_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`MemberError`](crate::model::MemberError)
pub mod member_error {
    /// A builder for [`MemberError`](crate::model::MemberError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The member ID.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The member ID.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberError`](crate::model::MemberError)
        pub fn build(self) -> crate::model::MemberError {
            crate::model::MemberError {
                member_id: self.member_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl MemberError {
    /// Creates a new builder-style object to manufacture [`MemberError`](crate::model::MemberError)
    pub fn builder() -> crate::model::member_error::Builder {
        crate::model::member_error::Builder::default()
    }
}

/// <p>Membership details, such as member ID and member role.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MembershipItem {
    /// <p>The member ID.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The member role.</p>
    pub role: std::option::Option<crate::model::RoomMembershipRole>,
}
impl MembershipItem {
    /// <p>The member ID.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The member role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::RoomMembershipRole> {
        self.role.as_ref()
    }
}
impl std::fmt::Debug for MembershipItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MembershipItem");
        formatter.field("member_id", &self.member_id);
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`MembershipItem`](crate::model::MembershipItem)
pub mod membership_item {
    /// A builder for [`MembershipItem`](crate::model::MembershipItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<crate::model::RoomMembershipRole>,
    }
    impl Builder {
        /// <p>The member ID.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The member ID.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The member role.</p>
        pub fn role(mut self, input: crate::model::RoomMembershipRole) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The member role.</p>
        pub fn set_role(
            mut self,
            input: std::option::Option<crate::model::RoomMembershipRole>,
        ) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`MembershipItem`](crate::model::MembershipItem)
        pub fn build(self) -> crate::model::MembershipItem {
            crate::model::MembershipItem {
                member_id: self.member_id,
                role: self.role,
            }
        }
    }
}
impl MembershipItem {
    /// Creates a new builder-style object to manufacture [`MembershipItem`](crate::model::MembershipItem)
    pub fn builder() -> crate::model::membership_item::Builder {
        crate::model::membership_item::Builder::default()
    }
}

/// <p>A list of failed member ARNs, error codes, and error messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateChannelMembershipError {
    /// <p>The ARN of the member that the service couldn't add.</p>
    pub member_arn: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchCreateChannelMembershipError {
    /// <p>The ARN of the member that the service couldn't add.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateChannelMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateChannelMembershipError");
        formatter.field("member_arn", &self.member_arn);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
pub mod batch_create_channel_membership_error {
    /// A builder for [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_arn: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the member that the service couldn't add.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the member that the service couldn't add.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
        pub fn build(self) -> crate::model::BatchCreateChannelMembershipError {
            crate::model::BatchCreateChannelMembershipError {
                member_arn: self.member_arn,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchCreateChannelMembershipError {
    /// Creates a new builder-style object to manufacture [`BatchCreateChannelMembershipError`](crate::model::BatchCreateChannelMembershipError)
    pub fn builder() -> crate::model::batch_create_channel_membership_error::Builder {
        crate::model::batch_create_channel_membership_error::Builder::default()
    }
}

/// <p>The membership information, including member ARNs, the channel ARN, and membership
/// types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchChannelMemberships {
    /// <p>The identifier of the member who invited another member.</p>
    pub invited_by: std::option::Option<crate::model::Identity>,
    /// <p>The membership types set for the channel users.</p>
    pub r#type: std::option::Option<crate::model::ChannelMembershipType>,
    /// <p>The users successfully added to the request.</p>
    pub members: std::option::Option<std::vec::Vec<crate::model::Identity>>,
    /// <p>The ARN of the channel to which you're adding users.</p>
    pub channel_arn: std::option::Option<std::string::String>,
}
impl BatchChannelMemberships {
    /// <p>The identifier of the member who invited another member.</p>
    pub fn invited_by(&self) -> std::option::Option<&crate::model::Identity> {
        self.invited_by.as_ref()
    }
    /// <p>The membership types set for the channel users.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelMembershipType> {
        self.r#type.as_ref()
    }
    /// <p>The users successfully added to the request.</p>
    pub fn members(&self) -> std::option::Option<&[crate::model::Identity]> {
        self.members.as_deref()
    }
    /// <p>The ARN of the channel to which you're adding users.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
}
impl std::fmt::Debug for BatchChannelMemberships {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchChannelMemberships");
        formatter.field("invited_by", &self.invited_by);
        formatter.field("r#type", &self.r#type);
        formatter.field("members", &self.members);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.finish()
    }
}
/// See [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
pub mod batch_channel_memberships {
    /// A builder for [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invited_by: std::option::Option<crate::model::Identity>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelMembershipType>,
        pub(crate) members: std::option::Option<std::vec::Vec<crate::model::Identity>>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the member who invited another member.</p>
        pub fn invited_by(mut self, input: crate::model::Identity) -> Self {
            self.invited_by = Some(input);
            self
        }
        /// <p>The identifier of the member who invited another member.</p>
        pub fn set_invited_by(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.invited_by = input;
            self
        }
        /// <p>The membership types set for the channel users.</p>
        pub fn r#type(mut self, input: crate::model::ChannelMembershipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The membership types set for the channel users.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The users successfully added to the request.</p>
        pub fn members(mut self, input: impl Into<crate::model::Identity>) -> Self {
            let mut v = self.members.unwrap_or_default();
            v.push(input.into());
            self.members = Some(v);
            self
        }
        /// <p>The users successfully added to the request.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Identity>>,
        ) -> Self {
            self.members = input;
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
        pub fn build(self) -> crate::model::BatchChannelMemberships {
            crate::model::BatchChannelMemberships {
                invited_by: self.invited_by,
                r#type: self.r#type,
                members: self.members,
                channel_arn: self.channel_arn,
            }
        }
    }
}
impl BatchChannelMemberships {
    /// Creates a new builder-style object to manufacture [`BatchChannelMemberships`](crate::model::BatchChannelMemberships)
    pub fn builder() -> crate::model::batch_channel_memberships::Builder {
        crate::model::batch_channel_memberships::Builder::default()
    }
}
