// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `UCBuzzConsoleService`.
///
/// This client allows ergonomic access to a `UCBuzzConsoleService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociatePhoneNumbersWithVoiceConnector` operation.
    ///
    /// See [`AssociatePhoneNumbersWithVoiceConnector`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnector) for more information about the
    /// operation and its arguments.
    pub fn associate_phone_numbers_with_voice_connector(
        &self,
    ) -> fluent_builders::AssociatePhoneNumbersWithVoiceConnector<C, M, R> {
        fluent_builders::AssociatePhoneNumbersWithVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociatePhoneNumbersWithVoiceConnectorGroup` operation.
    ///
    /// See [`AssociatePhoneNumbersWithVoiceConnectorGroup`](crate::client::fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup) for more information about the
    /// operation and its arguments.
    pub fn associate_phone_numbers_with_voice_connector_group(
        &self,
    ) -> fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup<C, M, R> {
        fluent_builders::AssociatePhoneNumbersWithVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociatePhoneNumberWithUser` operation.
    ///
    /// See [`AssociatePhoneNumberWithUser`](crate::client::fluent_builders::AssociatePhoneNumberWithUser) for more information about the
    /// operation and its arguments.
    pub fn associate_phone_number_with_user(
        &self,
    ) -> fluent_builders::AssociatePhoneNumberWithUser<C, M, R> {
        fluent_builders::AssociatePhoneNumberWithUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateSigninDelegateGroupsWithAccount` operation.
    ///
    /// See [`AssociateSigninDelegateGroupsWithAccount`](crate::client::fluent_builders::AssociateSigninDelegateGroupsWithAccount) for more information about the
    /// operation and its arguments.
    pub fn associate_signin_delegate_groups_with_account(
        &self,
    ) -> fluent_builders::AssociateSigninDelegateGroupsWithAccount<C, M, R> {
        fluent_builders::AssociateSigninDelegateGroupsWithAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchCreateAttendee` operation.
    ///
    /// See [`BatchCreateAttendee`](crate::client::fluent_builders::BatchCreateAttendee) for more information about the
    /// operation and its arguments.
    pub fn batch_create_attendee(&self) -> fluent_builders::BatchCreateAttendee<C, M, R> {
        fluent_builders::BatchCreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchCreateChannelMembership` operation.
    ///
    /// See [`BatchCreateChannelMembership`](crate::client::fluent_builders::BatchCreateChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn batch_create_channel_membership(
        &self,
    ) -> fluent_builders::BatchCreateChannelMembership<C, M, R> {
        fluent_builders::BatchCreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchCreateRoomMembership` operation.
    ///
    /// See [`BatchCreateRoomMembership`](crate::client::fluent_builders::BatchCreateRoomMembership) for more information about the
    /// operation and its arguments.
    pub fn batch_create_room_membership(
        &self,
    ) -> fluent_builders::BatchCreateRoomMembership<C, M, R> {
        fluent_builders::BatchCreateRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeletePhoneNumber` operation.
    ///
    /// See [`BatchDeletePhoneNumber`](crate::client::fluent_builders::BatchDeletePhoneNumber) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_phone_number(&self) -> fluent_builders::BatchDeletePhoneNumber<C, M, R> {
        fluent_builders::BatchDeletePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchSuspendUser` operation.
    ///
    /// See [`BatchSuspendUser`](crate::client::fluent_builders::BatchSuspendUser) for more information about the
    /// operation and its arguments.
    pub fn batch_suspend_user(&self) -> fluent_builders::BatchSuspendUser<C, M, R> {
        fluent_builders::BatchSuspendUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUnsuspendUser` operation.
    ///
    /// See [`BatchUnsuspendUser`](crate::client::fluent_builders::BatchUnsuspendUser) for more information about the
    /// operation and its arguments.
    pub fn batch_unsuspend_user(&self) -> fluent_builders::BatchUnsuspendUser<C, M, R> {
        fluent_builders::BatchUnsuspendUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUpdatePhoneNumber` operation.
    ///
    /// See [`BatchUpdatePhoneNumber`](crate::client::fluent_builders::BatchUpdatePhoneNumber) for more information about the
    /// operation and its arguments.
    pub fn batch_update_phone_number(&self) -> fluent_builders::BatchUpdatePhoneNumber<C, M, R> {
        fluent_builders::BatchUpdatePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUpdateUser` operation.
    ///
    /// See [`BatchUpdateUser`](crate::client::fluent_builders::BatchUpdateUser) for more information about the
    /// operation and its arguments.
    pub fn batch_update_user(&self) -> fluent_builders::BatchUpdateUser<C, M, R> {
        fluent_builders::BatchUpdateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccount` operation.
    ///
    /// See [`CreateAccount`](crate::client::fluent_builders::CreateAccount) for more information about the
    /// operation and its arguments.
    pub fn create_account(&self) -> fluent_builders::CreateAccount<C, M, R> {
        fluent_builders::CreateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAppInstance` operation.
    ///
    /// See [`CreateAppInstance`](crate::client::fluent_builders::CreateAppInstance) for more information about the
    /// operation and its arguments.
    pub fn create_app_instance(&self) -> fluent_builders::CreateAppInstance<C, M, R> {
        fluent_builders::CreateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAppInstanceAdmin` operation.
    ///
    /// See [`CreateAppInstanceAdmin`](crate::client::fluent_builders::CreateAppInstanceAdmin) for more information about the
    /// operation and its arguments.
    pub fn create_app_instance_admin(&self) -> fluent_builders::CreateAppInstanceAdmin<C, M, R> {
        fluent_builders::CreateAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAppInstanceUser` operation.
    ///
    /// See [`CreateAppInstanceUser`](crate::client::fluent_builders::CreateAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn create_app_instance_user(&self) -> fluent_builders::CreateAppInstanceUser<C, M, R> {
        fluent_builders::CreateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAttendee` operation.
    ///
    /// See [`CreateAttendee`](crate::client::fluent_builders::CreateAttendee) for more information about the
    /// operation and its arguments.
    pub fn create_attendee(&self) -> fluent_builders::CreateAttendee<C, M, R> {
        fluent_builders::CreateAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBot` operation.
    ///
    /// See [`CreateBot`](crate::client::fluent_builders::CreateBot) for more information about the
    /// operation and its arguments.
    pub fn create_bot(&self) -> fluent_builders::CreateBot<C, M, R> {
        fluent_builders::CreateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannel` operation.
    ///
    /// See [`CreateChannel`](crate::client::fluent_builders::CreateChannel) for more information about the
    /// operation and its arguments.
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannelBan` operation.
    ///
    /// See [`CreateChannelBan`](crate::client::fluent_builders::CreateChannelBan) for more information about the
    /// operation and its arguments.
    pub fn create_channel_ban(&self) -> fluent_builders::CreateChannelBan<C, M, R> {
        fluent_builders::CreateChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannelMembership` operation.
    ///
    /// See [`CreateChannelMembership`](crate::client::fluent_builders::CreateChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn create_channel_membership(&self) -> fluent_builders::CreateChannelMembership<C, M, R> {
        fluent_builders::CreateChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannelModerator` operation.
    ///
    /// See [`CreateChannelModerator`](crate::client::fluent_builders::CreateChannelModerator) for more information about the
    /// operation and its arguments.
    pub fn create_channel_moderator(&self) -> fluent_builders::CreateChannelModerator<C, M, R> {
        fluent_builders::CreateChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMediaCapturePipeline` operation.
    ///
    /// See [`CreateMediaCapturePipeline`](crate::client::fluent_builders::CreateMediaCapturePipeline) for more information about the
    /// operation and its arguments.
    pub fn create_media_capture_pipeline(
        &self,
    ) -> fluent_builders::CreateMediaCapturePipeline<C, M, R> {
        fluent_builders::CreateMediaCapturePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMeeting` operation.
    ///
    /// See [`CreateMeeting`](crate::client::fluent_builders::CreateMeeting) for more information about the
    /// operation and its arguments.
    pub fn create_meeting(&self) -> fluent_builders::CreateMeeting<C, M, R> {
        fluent_builders::CreateMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMeetingDialOut` operation.
    ///
    /// See [`CreateMeetingDialOut`](crate::client::fluent_builders::CreateMeetingDialOut) for more information about the
    /// operation and its arguments.
    pub fn create_meeting_dial_out(&self) -> fluent_builders::CreateMeetingDialOut<C, M, R> {
        fluent_builders::CreateMeetingDialOut::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMeetingWithAttendees` operation.
    ///
    /// See [`CreateMeetingWithAttendees`](crate::client::fluent_builders::CreateMeetingWithAttendees) for more information about the
    /// operation and its arguments.
    pub fn create_meeting_with_attendees(
        &self,
    ) -> fluent_builders::CreateMeetingWithAttendees<C, M, R> {
        fluent_builders::CreateMeetingWithAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePhoneNumberOrder` operation.
    ///
    /// See [`CreatePhoneNumberOrder`](crate::client::fluent_builders::CreatePhoneNumberOrder) for more information about the
    /// operation and its arguments.
    pub fn create_phone_number_order(&self) -> fluent_builders::CreatePhoneNumberOrder<C, M, R> {
        fluent_builders::CreatePhoneNumberOrder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProxySession` operation.
    ///
    /// See [`CreateProxySession`](crate::client::fluent_builders::CreateProxySession) for more information about the
    /// operation and its arguments.
    pub fn create_proxy_session(&self) -> fluent_builders::CreateProxySession<C, M, R> {
        fluent_builders::CreateProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoom` operation.
    ///
    /// See [`CreateRoom`](crate::client::fluent_builders::CreateRoom) for more information about the
    /// operation and its arguments.
    pub fn create_room(&self) -> fluent_builders::CreateRoom<C, M, R> {
        fluent_builders::CreateRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoomMembership` operation.
    ///
    /// See [`CreateRoomMembership`](crate::client::fluent_builders::CreateRoomMembership) for more information about the
    /// operation and its arguments.
    pub fn create_room_membership(&self) -> fluent_builders::CreateRoomMembership<C, M, R> {
        fluent_builders::CreateRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSipMediaApplication` operation.
    ///
    /// See [`CreateSipMediaApplication`](crate::client::fluent_builders::CreateSipMediaApplication) for more information about the
    /// operation and its arguments.
    pub fn create_sip_media_application(
        &self,
    ) -> fluent_builders::CreateSipMediaApplication<C, M, R> {
        fluent_builders::CreateSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSipMediaApplicationCall` operation.
    ///
    /// See [`CreateSipMediaApplicationCall`](crate::client::fluent_builders::CreateSipMediaApplicationCall) for more information about the
    /// operation and its arguments.
    pub fn create_sip_media_application_call(
        &self,
    ) -> fluent_builders::CreateSipMediaApplicationCall<C, M, R> {
        fluent_builders::CreateSipMediaApplicationCall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSipRule` operation.
    ///
    /// See [`CreateSipRule`](crate::client::fluent_builders::CreateSipRule) for more information about the
    /// operation and its arguments.
    pub fn create_sip_rule(&self) -> fluent_builders::CreateSipRule<C, M, R> {
        fluent_builders::CreateSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVoiceConnector` operation.
    ///
    /// See [`CreateVoiceConnector`](crate::client::fluent_builders::CreateVoiceConnector) for more information about the
    /// operation and its arguments.
    pub fn create_voice_connector(&self) -> fluent_builders::CreateVoiceConnector<C, M, R> {
        fluent_builders::CreateVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVoiceConnectorGroup` operation.
    ///
    /// See [`CreateVoiceConnectorGroup`](crate::client::fluent_builders::CreateVoiceConnectorGroup) for more information about the
    /// operation and its arguments.
    pub fn create_voice_connector_group(
        &self,
    ) -> fluent_builders::CreateVoiceConnectorGroup<C, M, R> {
        fluent_builders::CreateVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccount` operation.
    ///
    /// See [`DeleteAccount`](crate::client::fluent_builders::DeleteAccount) for more information about the
    /// operation and its arguments.
    pub fn delete_account(&self) -> fluent_builders::DeleteAccount<C, M, R> {
        fluent_builders::DeleteAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppInstance` operation.
    ///
    /// See [`DeleteAppInstance`](crate::client::fluent_builders::DeleteAppInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_app_instance(&self) -> fluent_builders::DeleteAppInstance<C, M, R> {
        fluent_builders::DeleteAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppInstanceAdmin` operation.
    ///
    /// See [`DeleteAppInstanceAdmin`](crate::client::fluent_builders::DeleteAppInstanceAdmin) for more information about the
    /// operation and its arguments.
    pub fn delete_app_instance_admin(&self) -> fluent_builders::DeleteAppInstanceAdmin<C, M, R> {
        fluent_builders::DeleteAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppInstanceStreamingConfigurations` operation.
    ///
    /// See [`DeleteAppInstanceStreamingConfigurations`](crate::client::fluent_builders::DeleteAppInstanceStreamingConfigurations) for more information about the
    /// operation and its arguments.
    pub fn delete_app_instance_streaming_configurations(
        &self,
    ) -> fluent_builders::DeleteAppInstanceStreamingConfigurations<C, M, R> {
        fluent_builders::DeleteAppInstanceStreamingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppInstanceUser` operation.
    ///
    /// See [`DeleteAppInstanceUser`](crate::client::fluent_builders::DeleteAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn delete_app_instance_user(&self) -> fluent_builders::DeleteAppInstanceUser<C, M, R> {
        fluent_builders::DeleteAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAttendee` operation.
    ///
    /// See [`DeleteAttendee`](crate::client::fluent_builders::DeleteAttendee) for more information about the
    /// operation and its arguments.
    pub fn delete_attendee(&self) -> fluent_builders::DeleteAttendee<C, M, R> {
        fluent_builders::DeleteAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannel` operation.
    ///
    /// See [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelBan` operation.
    ///
    /// See [`DeleteChannelBan`](crate::client::fluent_builders::DeleteChannelBan) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_ban(&self) -> fluent_builders::DeleteChannelBan<C, M, R> {
        fluent_builders::DeleteChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelMembership` operation.
    ///
    /// See [`DeleteChannelMembership`](crate::client::fluent_builders::DeleteChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_membership(&self) -> fluent_builders::DeleteChannelMembership<C, M, R> {
        fluent_builders::DeleteChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelMessage` operation.
    ///
    /// See [`DeleteChannelMessage`](crate::client::fluent_builders::DeleteChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_message(&self) -> fluent_builders::DeleteChannelMessage<C, M, R> {
        fluent_builders::DeleteChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannelModerator` operation.
    ///
    /// See [`DeleteChannelModerator`](crate::client::fluent_builders::DeleteChannelModerator) for more information about the
    /// operation and its arguments.
    pub fn delete_channel_moderator(&self) -> fluent_builders::DeleteChannelModerator<C, M, R> {
        fluent_builders::DeleteChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventsConfiguration` operation.
    ///
    /// See [`DeleteEventsConfiguration`](crate::client::fluent_builders::DeleteEventsConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_events_configuration(
        &self,
    ) -> fluent_builders::DeleteEventsConfiguration<C, M, R> {
        fluent_builders::DeleteEventsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMediaCapturePipeline` operation.
    ///
    /// See [`DeleteMediaCapturePipeline`](crate::client::fluent_builders::DeleteMediaCapturePipeline) for more information about the
    /// operation and its arguments.
    pub fn delete_media_capture_pipeline(
        &self,
    ) -> fluent_builders::DeleteMediaCapturePipeline<C, M, R> {
        fluent_builders::DeleteMediaCapturePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMeeting` operation.
    ///
    /// See [`DeleteMeeting`](crate::client::fluent_builders::DeleteMeeting) for more information about the
    /// operation and its arguments.
    pub fn delete_meeting(&self) -> fluent_builders::DeleteMeeting<C, M, R> {
        fluent_builders::DeleteMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePhoneNumber` operation.
    ///
    /// See [`DeletePhoneNumber`](crate::client::fluent_builders::DeletePhoneNumber) for more information about the
    /// operation and its arguments.
    pub fn delete_phone_number(&self) -> fluent_builders::DeletePhoneNumber<C, M, R> {
        fluent_builders::DeletePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProxySession` operation.
    ///
    /// See [`DeleteProxySession`](crate::client::fluent_builders::DeleteProxySession) for more information about the
    /// operation and its arguments.
    pub fn delete_proxy_session(&self) -> fluent_builders::DeleteProxySession<C, M, R> {
        fluent_builders::DeleteProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoom` operation.
    ///
    /// See [`DeleteRoom`](crate::client::fluent_builders::DeleteRoom) for more information about the
    /// operation and its arguments.
    pub fn delete_room(&self) -> fluent_builders::DeleteRoom<C, M, R> {
        fluent_builders::DeleteRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoomMembership` operation.
    ///
    /// See [`DeleteRoomMembership`](crate::client::fluent_builders::DeleteRoomMembership) for more information about the
    /// operation and its arguments.
    pub fn delete_room_membership(&self) -> fluent_builders::DeleteRoomMembership<C, M, R> {
        fluent_builders::DeleteRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSipMediaApplication` operation.
    ///
    /// See [`DeleteSipMediaApplication`](crate::client::fluent_builders::DeleteSipMediaApplication) for more information about the
    /// operation and its arguments.
    pub fn delete_sip_media_application(
        &self,
    ) -> fluent_builders::DeleteSipMediaApplication<C, M, R> {
        fluent_builders::DeleteSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSipRule` operation.
    ///
    /// See [`DeleteSipRule`](crate::client::fluent_builders::DeleteSipRule) for more information about the
    /// operation and its arguments.
    pub fn delete_sip_rule(&self) -> fluent_builders::DeleteSipRule<C, M, R> {
        fluent_builders::DeleteSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnector` operation.
    ///
    /// See [`DeleteVoiceConnector`](crate::client::fluent_builders::DeleteVoiceConnector) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector(&self) -> fluent_builders::DeleteVoiceConnector<C, M, R> {
        fluent_builders::DeleteVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnectorEmergencyCallingConfiguration` operation.
    ///
    /// See [`DeleteVoiceConnectorEmergencyCallingConfiguration`](crate::client::fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector_emergency_calling_configuration(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration<C, M, R> {
        fluent_builders::DeleteVoiceConnectorEmergencyCallingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnectorGroup` operation.
    ///
    /// See [`DeleteVoiceConnectorGroup`](crate::client::fluent_builders::DeleteVoiceConnectorGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector_group(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorGroup<C, M, R> {
        fluent_builders::DeleteVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnectorOrigination` operation.
    ///
    /// See [`DeleteVoiceConnectorOrigination`](crate::client::fluent_builders::DeleteVoiceConnectorOrigination) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector_origination(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorOrigination<C, M, R> {
        fluent_builders::DeleteVoiceConnectorOrigination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnectorProxy` operation.
    ///
    /// See [`DeleteVoiceConnectorProxy`](crate::client::fluent_builders::DeleteVoiceConnectorProxy) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector_proxy(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorProxy<C, M, R> {
        fluent_builders::DeleteVoiceConnectorProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnectorStreamingConfiguration` operation.
    ///
    /// See [`DeleteVoiceConnectorStreamingConfiguration`](crate::client::fluent_builders::DeleteVoiceConnectorStreamingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector_streaming_configuration(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorStreamingConfiguration<C, M, R> {
        fluent_builders::DeleteVoiceConnectorStreamingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnectorTermination` operation.
    ///
    /// See [`DeleteVoiceConnectorTermination`](crate::client::fluent_builders::DeleteVoiceConnectorTermination) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector_termination(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorTermination<C, M, R> {
        fluent_builders::DeleteVoiceConnectorTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVoiceConnectorTerminationCredentials` operation.
    ///
    /// See [`DeleteVoiceConnectorTerminationCredentials`](crate::client::fluent_builders::DeleteVoiceConnectorTerminationCredentials) for more information about the
    /// operation and its arguments.
    pub fn delete_voice_connector_termination_credentials(
        &self,
    ) -> fluent_builders::DeleteVoiceConnectorTerminationCredentials<C, M, R> {
        fluent_builders::DeleteVoiceConnectorTerminationCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppInstance` operation.
    ///
    /// See [`DescribeAppInstance`](crate::client::fluent_builders::DescribeAppInstance) for more information about the
    /// operation and its arguments.
    pub fn describe_app_instance(&self) -> fluent_builders::DescribeAppInstance<C, M, R> {
        fluent_builders::DescribeAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppInstanceAdmin` operation.
    ///
    /// See [`DescribeAppInstanceAdmin`](crate::client::fluent_builders::DescribeAppInstanceAdmin) for more information about the
    /// operation and its arguments.
    pub fn describe_app_instance_admin(
        &self,
    ) -> fluent_builders::DescribeAppInstanceAdmin<C, M, R> {
        fluent_builders::DescribeAppInstanceAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppInstanceUser` operation.
    ///
    /// See [`DescribeAppInstanceUser`](crate::client::fluent_builders::DescribeAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn describe_app_instance_user(&self) -> fluent_builders::DescribeAppInstanceUser<C, M, R> {
        fluent_builders::DescribeAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannel` operation.
    ///
    /// See [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) for more information about the
    /// operation and its arguments.
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel<C, M, R> {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelBan` operation.
    ///
    /// See [`DescribeChannelBan`](crate::client::fluent_builders::DescribeChannelBan) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_ban(&self) -> fluent_builders::DescribeChannelBan<C, M, R> {
        fluent_builders::DescribeChannelBan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelMembership` operation.
    ///
    /// See [`DescribeChannelMembership`](crate::client::fluent_builders::DescribeChannelMembership) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_membership(
        &self,
    ) -> fluent_builders::DescribeChannelMembership<C, M, R> {
        fluent_builders::DescribeChannelMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelMembershipForAppInstanceUser` operation.
    ///
    /// See [`DescribeChannelMembershipForAppInstanceUser`](crate::client::fluent_builders::DescribeChannelMembershipForAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_membership_for_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelMembershipForAppInstanceUser<C, M, R> {
        fluent_builders::DescribeChannelMembershipForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelModeratedByAppInstanceUser` operation.
    ///
    /// See [`DescribeChannelModeratedByAppInstanceUser`](crate::client::fluent_builders::DescribeChannelModeratedByAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::DescribeChannelModeratedByAppInstanceUser<C, M, R> {
        fluent_builders::DescribeChannelModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannelModerator` operation.
    ///
    /// See [`DescribeChannelModerator`](crate::client::fluent_builders::DescribeChannelModerator) for more information about the
    /// operation and its arguments.
    pub fn describe_channel_moderator(&self) -> fluent_builders::DescribeChannelModerator<C, M, R> {
        fluent_builders::DescribeChannelModerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociatePhoneNumberFromUser` operation.
    ///
    /// See [`DisassociatePhoneNumberFromUser`](crate::client::fluent_builders::DisassociatePhoneNumberFromUser) for more information about the
    /// operation and its arguments.
    pub fn disassociate_phone_number_from_user(
        &self,
    ) -> fluent_builders::DisassociatePhoneNumberFromUser<C, M, R> {
        fluent_builders::DisassociatePhoneNumberFromUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociatePhoneNumbersFromVoiceConnector` operation.
    ///
    /// See [`DisassociatePhoneNumbersFromVoiceConnector`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnector) for more information about the
    /// operation and its arguments.
    pub fn disassociate_phone_numbers_from_voice_connector(
        &self,
    ) -> fluent_builders::DisassociatePhoneNumbersFromVoiceConnector<C, M, R> {
        fluent_builders::DisassociatePhoneNumbersFromVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociatePhoneNumbersFromVoiceConnectorGroup` operation.
    ///
    /// See [`DisassociatePhoneNumbersFromVoiceConnectorGroup`](crate::client::fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup) for more information about the
    /// operation and its arguments.
    pub fn disassociate_phone_numbers_from_voice_connector_group(
        &self,
    ) -> fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup<C, M, R> {
        fluent_builders::DisassociatePhoneNumbersFromVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateSigninDelegateGroupsFromAccount` operation.
    ///
    /// See [`DisassociateSigninDelegateGroupsFromAccount`](crate::client::fluent_builders::DisassociateSigninDelegateGroupsFromAccount) for more information about the
    /// operation and its arguments.
    pub fn disassociate_signin_delegate_groups_from_account(
        &self,
    ) -> fluent_builders::DisassociateSigninDelegateGroupsFromAccount<C, M, R> {
        fluent_builders::DisassociateSigninDelegateGroupsFromAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccount` operation.
    ///
    /// See [`GetAccount`](crate::client::fluent_builders::GetAccount) for more information about the
    /// operation and its arguments.
    pub fn get_account(&self) -> fluent_builders::GetAccount<C, M, R> {
        fluent_builders::GetAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountSettings` operation.
    ///
    /// See [`GetAccountSettings`](crate::client::fluent_builders::GetAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn get_account_settings(&self) -> fluent_builders::GetAccountSettings<C, M, R> {
        fluent_builders::GetAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppInstanceRetentionSettings` operation.
    ///
    /// See [`GetAppInstanceRetentionSettings`](crate::client::fluent_builders::GetAppInstanceRetentionSettings) for more information about the
    /// operation and its arguments.
    pub fn get_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::GetAppInstanceRetentionSettings<C, M, R> {
        fluent_builders::GetAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppInstanceStreamingConfigurations` operation.
    ///
    /// See [`GetAppInstanceStreamingConfigurations`](crate::client::fluent_builders::GetAppInstanceStreamingConfigurations) for more information about the
    /// operation and its arguments.
    pub fn get_app_instance_streaming_configurations(
        &self,
    ) -> fluent_builders::GetAppInstanceStreamingConfigurations<C, M, R> {
        fluent_builders::GetAppInstanceStreamingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAttendee` operation.
    ///
    /// See [`GetAttendee`](crate::client::fluent_builders::GetAttendee) for more information about the
    /// operation and its arguments.
    pub fn get_attendee(&self) -> fluent_builders::GetAttendee<C, M, R> {
        fluent_builders::GetAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBot` operation.
    ///
    /// See [`GetBot`](crate::client::fluent_builders::GetBot) for more information about the
    /// operation and its arguments.
    pub fn get_bot(&self) -> fluent_builders::GetBot<C, M, R> {
        fluent_builders::GetBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChannelMessage` operation.
    ///
    /// See [`GetChannelMessage`](crate::client::fluent_builders::GetChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn get_channel_message(&self) -> fluent_builders::GetChannelMessage<C, M, R> {
        fluent_builders::GetChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEventsConfiguration` operation.
    ///
    /// See [`GetEventsConfiguration`](crate::client::fluent_builders::GetEventsConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_events_configuration(&self) -> fluent_builders::GetEventsConfiguration<C, M, R> {
        fluent_builders::GetEventsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGlobalSettings` operation.
    ///
    /// See [`GetGlobalSettings`](crate::client::fluent_builders::GetGlobalSettings) for more information about the
    /// operation and its arguments.
    pub fn get_global_settings(&self) -> fluent_builders::GetGlobalSettings<C, M, R> {
        fluent_builders::GetGlobalSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMediaCapturePipeline` operation.
    ///
    /// See [`GetMediaCapturePipeline`](crate::client::fluent_builders::GetMediaCapturePipeline) for more information about the
    /// operation and its arguments.
    pub fn get_media_capture_pipeline(&self) -> fluent_builders::GetMediaCapturePipeline<C, M, R> {
        fluent_builders::GetMediaCapturePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMeeting` operation.
    ///
    /// See [`GetMeeting`](crate::client::fluent_builders::GetMeeting) for more information about the
    /// operation and its arguments.
    pub fn get_meeting(&self) -> fluent_builders::GetMeeting<C, M, R> {
        fluent_builders::GetMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMessagingSessionEndpoint` operation.
    ///
    /// See [`GetMessagingSessionEndpoint`](crate::client::fluent_builders::GetMessagingSessionEndpoint) for more information about the
    /// operation and its arguments.
    pub fn get_messaging_session_endpoint(
        &self,
    ) -> fluent_builders::GetMessagingSessionEndpoint<C, M, R> {
        fluent_builders::GetMessagingSessionEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPhoneNumber` operation.
    ///
    /// See [`GetPhoneNumber`](crate::client::fluent_builders::GetPhoneNumber) for more information about the
    /// operation and its arguments.
    pub fn get_phone_number(&self) -> fluent_builders::GetPhoneNumber<C, M, R> {
        fluent_builders::GetPhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPhoneNumberOrder` operation.
    ///
    /// See [`GetPhoneNumberOrder`](crate::client::fluent_builders::GetPhoneNumberOrder) for more information about the
    /// operation and its arguments.
    pub fn get_phone_number_order(&self) -> fluent_builders::GetPhoneNumberOrder<C, M, R> {
        fluent_builders::GetPhoneNumberOrder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPhoneNumberSettings` operation.
    ///
    /// See [`GetPhoneNumberSettings`](crate::client::fluent_builders::GetPhoneNumberSettings) for more information about the
    /// operation and its arguments.
    pub fn get_phone_number_settings(&self) -> fluent_builders::GetPhoneNumberSettings<C, M, R> {
        fluent_builders::GetPhoneNumberSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProxySession` operation.
    ///
    /// See [`GetProxySession`](crate::client::fluent_builders::GetProxySession) for more information about the
    /// operation and its arguments.
    pub fn get_proxy_session(&self) -> fluent_builders::GetProxySession<C, M, R> {
        fluent_builders::GetProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRetentionSettings` operation.
    ///
    /// See [`GetRetentionSettings`](crate::client::fluent_builders::GetRetentionSettings) for more information about the
    /// operation and its arguments.
    pub fn get_retention_settings(&self) -> fluent_builders::GetRetentionSettings<C, M, R> {
        fluent_builders::GetRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRoom` operation.
    ///
    /// See [`GetRoom`](crate::client::fluent_builders::GetRoom) for more information about the
    /// operation and its arguments.
    pub fn get_room(&self) -> fluent_builders::GetRoom<C, M, R> {
        fluent_builders::GetRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSipMediaApplication` operation.
    ///
    /// See [`GetSipMediaApplication`](crate::client::fluent_builders::GetSipMediaApplication) for more information about the
    /// operation and its arguments.
    pub fn get_sip_media_application(&self) -> fluent_builders::GetSipMediaApplication<C, M, R> {
        fluent_builders::GetSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSipMediaApplicationLoggingConfiguration` operation.
    ///
    /// See [`GetSipMediaApplicationLoggingConfiguration`](crate::client::fluent_builders::GetSipMediaApplicationLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_sip_media_application_logging_configuration(
        &self,
    ) -> fluent_builders::GetSipMediaApplicationLoggingConfiguration<C, M, R> {
        fluent_builders::GetSipMediaApplicationLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSipRule` operation.
    ///
    /// See [`GetSipRule`](crate::client::fluent_builders::GetSipRule) for more information about the
    /// operation and its arguments.
    pub fn get_sip_rule(&self) -> fluent_builders::GetSipRule<C, M, R> {
        fluent_builders::GetSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUser` operation.
    ///
    /// See [`GetUser`](crate::client::fluent_builders::GetUser) for more information about the
    /// operation and its arguments.
    pub fn get_user(&self) -> fluent_builders::GetUser<C, M, R> {
        fluent_builders::GetUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUserSettings` operation.
    ///
    /// See [`GetUserSettings`](crate::client::fluent_builders::GetUserSettings) for more information about the
    /// operation and its arguments.
    pub fn get_user_settings(&self) -> fluent_builders::GetUserSettings<C, M, R> {
        fluent_builders::GetUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnector` operation.
    ///
    /// See [`GetVoiceConnector`](crate::client::fluent_builders::GetVoiceConnector) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector(&self) -> fluent_builders::GetVoiceConnector<C, M, R> {
        fluent_builders::GetVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorEmergencyCallingConfiguration` operation.
    ///
    /// See [`GetVoiceConnectorEmergencyCallingConfiguration`](crate::client::fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_emergency_calling_configuration(
        &self,
    ) -> fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration<C, M, R> {
        fluent_builders::GetVoiceConnectorEmergencyCallingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorGroup` operation.
    ///
    /// See [`GetVoiceConnectorGroup`](crate::client::fluent_builders::GetVoiceConnectorGroup) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_group(&self) -> fluent_builders::GetVoiceConnectorGroup<C, M, R> {
        fluent_builders::GetVoiceConnectorGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorLoggingConfiguration` operation.
    ///
    /// See [`GetVoiceConnectorLoggingConfiguration`](crate::client::fluent_builders::GetVoiceConnectorLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_logging_configuration(
        &self,
    ) -> fluent_builders::GetVoiceConnectorLoggingConfiguration<C, M, R> {
        fluent_builders::GetVoiceConnectorLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorOrigination` operation.
    ///
    /// See [`GetVoiceConnectorOrigination`](crate::client::fluent_builders::GetVoiceConnectorOrigination) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_origination(
        &self,
    ) -> fluent_builders::GetVoiceConnectorOrigination<C, M, R> {
        fluent_builders::GetVoiceConnectorOrigination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorProxy` operation.
    ///
    /// See [`GetVoiceConnectorProxy`](crate::client::fluent_builders::GetVoiceConnectorProxy) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_proxy(&self) -> fluent_builders::GetVoiceConnectorProxy<C, M, R> {
        fluent_builders::GetVoiceConnectorProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorStreamingConfiguration` operation.
    ///
    /// See [`GetVoiceConnectorStreamingConfiguration`](crate::client::fluent_builders::GetVoiceConnectorStreamingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_streaming_configuration(
        &self,
    ) -> fluent_builders::GetVoiceConnectorStreamingConfiguration<C, M, R> {
        fluent_builders::GetVoiceConnectorStreamingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorTermination` operation.
    ///
    /// See [`GetVoiceConnectorTermination`](crate::client::fluent_builders::GetVoiceConnectorTermination) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_termination(
        &self,
    ) -> fluent_builders::GetVoiceConnectorTermination<C, M, R> {
        fluent_builders::GetVoiceConnectorTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVoiceConnectorTerminationHealth` operation.
    ///
    /// See [`GetVoiceConnectorTerminationHealth`](crate::client::fluent_builders::GetVoiceConnectorTerminationHealth) for more information about the
    /// operation and its arguments.
    pub fn get_voice_connector_termination_health(
        &self,
    ) -> fluent_builders::GetVoiceConnectorTerminationHealth<C, M, R> {
        fluent_builders::GetVoiceConnectorTerminationHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InviteUsers` operation.
    ///
    /// See [`InviteUsers`](crate::client::fluent_builders::InviteUsers) for more information about the
    /// operation and its arguments.
    pub fn invite_users(&self) -> fluent_builders::InviteUsers<C, M, R> {
        fluent_builders::InviteUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccounts` operation.
    ///
    /// See [`ListAccounts`](crate::client::fluent_builders::ListAccounts) for more information about the
    /// operation and its arguments.
    pub fn list_accounts(&self) -> fluent_builders::ListAccounts<C, M, R> {
        fluent_builders::ListAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppInstanceAdmins` operation.
    ///
    /// See [`ListAppInstanceAdmins`](crate::client::fluent_builders::ListAppInstanceAdmins) for more information about the
    /// operation and its arguments.
    pub fn list_app_instance_admins(&self) -> fluent_builders::ListAppInstanceAdmins<C, M, R> {
        fluent_builders::ListAppInstanceAdmins::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppInstances` operation.
    ///
    /// See [`ListAppInstances`](crate::client::fluent_builders::ListAppInstances) for more information about the
    /// operation and its arguments.
    pub fn list_app_instances(&self) -> fluent_builders::ListAppInstances<C, M, R> {
        fluent_builders::ListAppInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppInstanceUsers` operation.
    ///
    /// See [`ListAppInstanceUsers`](crate::client::fluent_builders::ListAppInstanceUsers) for more information about the
    /// operation and its arguments.
    pub fn list_app_instance_users(&self) -> fluent_builders::ListAppInstanceUsers<C, M, R> {
        fluent_builders::ListAppInstanceUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttendees` operation.
    ///
    /// See [`ListAttendees`](crate::client::fluent_builders::ListAttendees) for more information about the
    /// operation and its arguments.
    pub fn list_attendees(&self) -> fluent_builders::ListAttendees<C, M, R> {
        fluent_builders::ListAttendees::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttendeeTags` operation.
    ///
    /// See [`ListAttendeeTags`](crate::client::fluent_builders::ListAttendeeTags) for more information about the
    /// operation and its arguments.
    pub fn list_attendee_tags(&self) -> fluent_builders::ListAttendeeTags<C, M, R> {
        fluent_builders::ListAttendeeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBots` operation.
    ///
    /// See [`ListBots`](crate::client::fluent_builders::ListBots) for more information about the
    /// operation and its arguments.
    pub fn list_bots(&self) -> fluent_builders::ListBots<C, M, R> {
        fluent_builders::ListBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelBans` operation.
    ///
    /// See [`ListChannelBans`](crate::client::fluent_builders::ListChannelBans) for more information about the
    /// operation and its arguments.
    pub fn list_channel_bans(&self) -> fluent_builders::ListChannelBans<C, M, R> {
        fluent_builders::ListChannelBans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelMemberships` operation.
    ///
    /// See [`ListChannelMemberships`](crate::client::fluent_builders::ListChannelMemberships) for more information about the
    /// operation and its arguments.
    pub fn list_channel_memberships(&self) -> fluent_builders::ListChannelMemberships<C, M, R> {
        fluent_builders::ListChannelMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelMembershipsForAppInstanceUser` operation.
    ///
    /// See [`ListChannelMembershipsForAppInstanceUser`](crate::client::fluent_builders::ListChannelMembershipsForAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn list_channel_memberships_for_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelMembershipsForAppInstanceUser<C, M, R> {
        fluent_builders::ListChannelMembershipsForAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelMessages` operation.
    ///
    /// See [`ListChannelMessages`](crate::client::fluent_builders::ListChannelMessages) for more information about the
    /// operation and its arguments.
    pub fn list_channel_messages(&self) -> fluent_builders::ListChannelMessages<C, M, R> {
        fluent_builders::ListChannelMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelModerators` operation.
    ///
    /// See [`ListChannelModerators`](crate::client::fluent_builders::ListChannelModerators) for more information about the
    /// operation and its arguments.
    pub fn list_channel_moderators(&self) -> fluent_builders::ListChannelModerators<C, M, R> {
        fluent_builders::ListChannelModerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannels` operation.
    ///
    /// See [`ListChannels`](crate::client::fluent_builders::ListChannels) for more information about the
    /// operation and its arguments.
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannelsModeratedByAppInstanceUser` operation.
    ///
    /// See [`ListChannelsModeratedByAppInstanceUser`](crate::client::fluent_builders::ListChannelsModeratedByAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn list_channels_moderated_by_app_instance_user(
        &self,
    ) -> fluent_builders::ListChannelsModeratedByAppInstanceUser<C, M, R> {
        fluent_builders::ListChannelsModeratedByAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMediaCapturePipelines` operation.
    ///
    /// See [`ListMediaCapturePipelines`](crate::client::fluent_builders::ListMediaCapturePipelines) for more information about the
    /// operation and its arguments.
    pub fn list_media_capture_pipelines(
        &self,
    ) -> fluent_builders::ListMediaCapturePipelines<C, M, R> {
        fluent_builders::ListMediaCapturePipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMeetings` operation.
    ///
    /// See [`ListMeetings`](crate::client::fluent_builders::ListMeetings) for more information about the
    /// operation and its arguments.
    pub fn list_meetings(&self) -> fluent_builders::ListMeetings<C, M, R> {
        fluent_builders::ListMeetings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMeetingTags` operation.
    ///
    /// See [`ListMeetingTags`](crate::client::fluent_builders::ListMeetingTags) for more information about the
    /// operation and its arguments.
    pub fn list_meeting_tags(&self) -> fluent_builders::ListMeetingTags<C, M, R> {
        fluent_builders::ListMeetingTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPhoneNumberOrders` operation.
    ///
    /// See [`ListPhoneNumberOrders`](crate::client::fluent_builders::ListPhoneNumberOrders) for more information about the
    /// operation and its arguments.
    pub fn list_phone_number_orders(&self) -> fluent_builders::ListPhoneNumberOrders<C, M, R> {
        fluent_builders::ListPhoneNumberOrders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPhoneNumbers` operation.
    ///
    /// See [`ListPhoneNumbers`](crate::client::fluent_builders::ListPhoneNumbers) for more information about the
    /// operation and its arguments.
    pub fn list_phone_numbers(&self) -> fluent_builders::ListPhoneNumbers<C, M, R> {
        fluent_builders::ListPhoneNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProxySessions` operation.
    ///
    /// See [`ListProxySessions`](crate::client::fluent_builders::ListProxySessions) for more information about the
    /// operation and its arguments.
    pub fn list_proxy_sessions(&self) -> fluent_builders::ListProxySessions<C, M, R> {
        fluent_builders::ListProxySessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoomMemberships` operation.
    ///
    /// See [`ListRoomMemberships`](crate::client::fluent_builders::ListRoomMemberships) for more information about the
    /// operation and its arguments.
    pub fn list_room_memberships(&self) -> fluent_builders::ListRoomMemberships<C, M, R> {
        fluent_builders::ListRoomMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRooms` operation.
    ///
    /// See [`ListRooms`](crate::client::fluent_builders::ListRooms) for more information about the
    /// operation and its arguments.
    pub fn list_rooms(&self) -> fluent_builders::ListRooms<C, M, R> {
        fluent_builders::ListRooms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSipMediaApplications` operation.
    ///
    /// See [`ListSipMediaApplications`](crate::client::fluent_builders::ListSipMediaApplications) for more information about the
    /// operation and its arguments.
    pub fn list_sip_media_applications(
        &self,
    ) -> fluent_builders::ListSipMediaApplications<C, M, R> {
        fluent_builders::ListSipMediaApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSipRules` operation.
    ///
    /// See [`ListSipRules`](crate::client::fluent_builders::ListSipRules) for more information about the
    /// operation and its arguments.
    pub fn list_sip_rules(&self) -> fluent_builders::ListSipRules<C, M, R> {
        fluent_builders::ListSipRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSupportedPhoneNumberCountries` operation.
    ///
    /// See [`ListSupportedPhoneNumberCountries`](crate::client::fluent_builders::ListSupportedPhoneNumberCountries) for more information about the
    /// operation and its arguments.
    pub fn list_supported_phone_number_countries(
        &self,
    ) -> fluent_builders::ListSupportedPhoneNumberCountries<C, M, R> {
        fluent_builders::ListSupportedPhoneNumberCountries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsers` operation.
    ///
    /// See [`ListUsers`](crate::client::fluent_builders::ListUsers) for more information about the
    /// operation and its arguments.
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVoiceConnectorGroups` operation.
    ///
    /// See [`ListVoiceConnectorGroups`](crate::client::fluent_builders::ListVoiceConnectorGroups) for more information about the
    /// operation and its arguments.
    pub fn list_voice_connector_groups(
        &self,
    ) -> fluent_builders::ListVoiceConnectorGroups<C, M, R> {
        fluent_builders::ListVoiceConnectorGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVoiceConnectors` operation.
    ///
    /// See [`ListVoiceConnectors`](crate::client::fluent_builders::ListVoiceConnectors) for more information about the
    /// operation and its arguments.
    pub fn list_voice_connectors(&self) -> fluent_builders::ListVoiceConnectors<C, M, R> {
        fluent_builders::ListVoiceConnectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVoiceConnectorTerminationCredentials` operation.
    ///
    /// See [`ListVoiceConnectorTerminationCredentials`](crate::client::fluent_builders::ListVoiceConnectorTerminationCredentials) for more information about the
    /// operation and its arguments.
    pub fn list_voice_connector_termination_credentials(
        &self,
    ) -> fluent_builders::ListVoiceConnectorTerminationCredentials<C, M, R> {
        fluent_builders::ListVoiceConnectorTerminationCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `LogoutUser` operation.
    ///
    /// See [`LogoutUser`](crate::client::fluent_builders::LogoutUser) for more information about the
    /// operation and its arguments.
    pub fn logout_user(&self) -> fluent_builders::LogoutUser<C, M, R> {
        fluent_builders::LogoutUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAppInstanceRetentionSettings` operation.
    ///
    /// See [`PutAppInstanceRetentionSettings`](crate::client::fluent_builders::PutAppInstanceRetentionSettings) for more information about the
    /// operation and its arguments.
    pub fn put_app_instance_retention_settings(
        &self,
    ) -> fluent_builders::PutAppInstanceRetentionSettings<C, M, R> {
        fluent_builders::PutAppInstanceRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAppInstanceStreamingConfigurations` operation.
    ///
    /// See [`PutAppInstanceStreamingConfigurations`](crate::client::fluent_builders::PutAppInstanceStreamingConfigurations) for more information about the
    /// operation and its arguments.
    pub fn put_app_instance_streaming_configurations(
        &self,
    ) -> fluent_builders::PutAppInstanceStreamingConfigurations<C, M, R> {
        fluent_builders::PutAppInstanceStreamingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEventsConfiguration` operation.
    ///
    /// See [`PutEventsConfiguration`](crate::client::fluent_builders::PutEventsConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_events_configuration(&self) -> fluent_builders::PutEventsConfiguration<C, M, R> {
        fluent_builders::PutEventsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRetentionSettings` operation.
    ///
    /// See [`PutRetentionSettings`](crate::client::fluent_builders::PutRetentionSettings) for more information about the
    /// operation and its arguments.
    pub fn put_retention_settings(&self) -> fluent_builders::PutRetentionSettings<C, M, R> {
        fluent_builders::PutRetentionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSipMediaApplicationLoggingConfiguration` operation.
    ///
    /// See [`PutSipMediaApplicationLoggingConfiguration`](crate::client::fluent_builders::PutSipMediaApplicationLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_sip_media_application_logging_configuration(
        &self,
    ) -> fluent_builders::PutSipMediaApplicationLoggingConfiguration<C, M, R> {
        fluent_builders::PutSipMediaApplicationLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVoiceConnectorEmergencyCallingConfiguration` operation.
    ///
    /// See [`PutVoiceConnectorEmergencyCallingConfiguration`](crate::client::fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_voice_connector_emergency_calling_configuration(
        &self,
    ) -> fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration<C, M, R> {
        fluent_builders::PutVoiceConnectorEmergencyCallingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVoiceConnectorLoggingConfiguration` operation.
    ///
    /// See [`PutVoiceConnectorLoggingConfiguration`](crate::client::fluent_builders::PutVoiceConnectorLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_voice_connector_logging_configuration(
        &self,
    ) -> fluent_builders::PutVoiceConnectorLoggingConfiguration<C, M, R> {
        fluent_builders::PutVoiceConnectorLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVoiceConnectorOrigination` operation.
    ///
    /// See [`PutVoiceConnectorOrigination`](crate::client::fluent_builders::PutVoiceConnectorOrigination) for more information about the
    /// operation and its arguments.
    pub fn put_voice_connector_origination(
        &self,
    ) -> fluent_builders::PutVoiceConnectorOrigination<C, M, R> {
        fluent_builders::PutVoiceConnectorOrigination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVoiceConnectorProxy` operation.
    ///
    /// See [`PutVoiceConnectorProxy`](crate::client::fluent_builders::PutVoiceConnectorProxy) for more information about the
    /// operation and its arguments.
    pub fn put_voice_connector_proxy(&self) -> fluent_builders::PutVoiceConnectorProxy<C, M, R> {
        fluent_builders::PutVoiceConnectorProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVoiceConnectorStreamingConfiguration` operation.
    ///
    /// See [`PutVoiceConnectorStreamingConfiguration`](crate::client::fluent_builders::PutVoiceConnectorStreamingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_voice_connector_streaming_configuration(
        &self,
    ) -> fluent_builders::PutVoiceConnectorStreamingConfiguration<C, M, R> {
        fluent_builders::PutVoiceConnectorStreamingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVoiceConnectorTermination` operation.
    ///
    /// See [`PutVoiceConnectorTermination`](crate::client::fluent_builders::PutVoiceConnectorTermination) for more information about the
    /// operation and its arguments.
    pub fn put_voice_connector_termination(
        &self,
    ) -> fluent_builders::PutVoiceConnectorTermination<C, M, R> {
        fluent_builders::PutVoiceConnectorTermination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVoiceConnectorTerminationCredentials` operation.
    ///
    /// See [`PutVoiceConnectorTerminationCredentials`](crate::client::fluent_builders::PutVoiceConnectorTerminationCredentials) for more information about the
    /// operation and its arguments.
    pub fn put_voice_connector_termination_credentials(
        &self,
    ) -> fluent_builders::PutVoiceConnectorTerminationCredentials<C, M, R> {
        fluent_builders::PutVoiceConnectorTerminationCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RedactChannelMessage` operation.
    ///
    /// See [`RedactChannelMessage`](crate::client::fluent_builders::RedactChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn redact_channel_message(&self) -> fluent_builders::RedactChannelMessage<C, M, R> {
        fluent_builders::RedactChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RedactConversationMessage` operation.
    ///
    /// See [`RedactConversationMessage`](crate::client::fluent_builders::RedactConversationMessage) for more information about the
    /// operation and its arguments.
    pub fn redact_conversation_message(
        &self,
    ) -> fluent_builders::RedactConversationMessage<C, M, R> {
        fluent_builders::RedactConversationMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RedactRoomMessage` operation.
    ///
    /// See [`RedactRoomMessage`](crate::client::fluent_builders::RedactRoomMessage) for more information about the
    /// operation and its arguments.
    pub fn redact_room_message(&self) -> fluent_builders::RedactRoomMessage<C, M, R> {
        fluent_builders::RedactRoomMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegenerateSecurityToken` operation.
    ///
    /// See [`RegenerateSecurityToken`](crate::client::fluent_builders::RegenerateSecurityToken) for more information about the
    /// operation and its arguments.
    pub fn regenerate_security_token(&self) -> fluent_builders::RegenerateSecurityToken<C, M, R> {
        fluent_builders::RegenerateSecurityToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetPersonalPIN` operation.
    ///
    /// See [`ResetPersonalPIN`](crate::client::fluent_builders::ResetPersonalPIN) for more information about the
    /// operation and its arguments.
    pub fn reset_personal_pin(&self) -> fluent_builders::ResetPersonalPIN<C, M, R> {
        fluent_builders::ResetPersonalPIN::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestorePhoneNumber` operation.
    ///
    /// See [`RestorePhoneNumber`](crate::client::fluent_builders::RestorePhoneNumber) for more information about the
    /// operation and its arguments.
    pub fn restore_phone_number(&self) -> fluent_builders::RestorePhoneNumber<C, M, R> {
        fluent_builders::RestorePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchAvailablePhoneNumbers` operation.
    ///
    /// See [`SearchAvailablePhoneNumbers`](crate::client::fluent_builders::SearchAvailablePhoneNumbers) for more information about the
    /// operation and its arguments.
    pub fn search_available_phone_numbers(
        &self,
    ) -> fluent_builders::SearchAvailablePhoneNumbers<C, M, R> {
        fluent_builders::SearchAvailablePhoneNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendChannelMessage` operation.
    ///
    /// See [`SendChannelMessage`](crate::client::fluent_builders::SendChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn send_channel_message(&self) -> fluent_builders::SendChannelMessage<C, M, R> {
        fluent_builders::SendChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMeetingTranscription` operation.
    ///
    /// See [`StartMeetingTranscription`](crate::client::fluent_builders::StartMeetingTranscription) for more information about the
    /// operation and its arguments.
    pub fn start_meeting_transcription(
        &self,
    ) -> fluent_builders::StartMeetingTranscription<C, M, R> {
        fluent_builders::StartMeetingTranscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopMeetingTranscription` operation.
    ///
    /// See [`StopMeetingTranscription`](crate::client::fluent_builders::StopMeetingTranscription) for more information about the
    /// operation and its arguments.
    pub fn stop_meeting_transcription(&self) -> fluent_builders::StopMeetingTranscription<C, M, R> {
        fluent_builders::StopMeetingTranscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagAttendee` operation.
    ///
    /// See [`TagAttendee`](crate::client::fluent_builders::TagAttendee) for more information about the
    /// operation and its arguments.
    pub fn tag_attendee(&self) -> fluent_builders::TagAttendee<C, M, R> {
        fluent_builders::TagAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagMeeting` operation.
    ///
    /// See [`TagMeeting`](crate::client::fluent_builders::TagMeeting) for more information about the
    /// operation and its arguments.
    pub fn tag_meeting(&self) -> fluent_builders::TagMeeting<C, M, R> {
        fluent_builders::TagMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagAttendee` operation.
    ///
    /// See [`UntagAttendee`](crate::client::fluent_builders::UntagAttendee) for more information about the
    /// operation and its arguments.
    pub fn untag_attendee(&self) -> fluent_builders::UntagAttendee<C, M, R> {
        fluent_builders::UntagAttendee::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagMeeting` operation.
    ///
    /// See [`UntagMeeting`](crate::client::fluent_builders::UntagMeeting) for more information about the
    /// operation and its arguments.
    pub fn untag_meeting(&self) -> fluent_builders::UntagMeeting<C, M, R> {
        fluent_builders::UntagMeeting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccount` operation.
    ///
    /// See [`UpdateAccount`](crate::client::fluent_builders::UpdateAccount) for more information about the
    /// operation and its arguments.
    pub fn update_account(&self) -> fluent_builders::UpdateAccount<C, M, R> {
        fluent_builders::UpdateAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccountSettings` operation.
    ///
    /// See [`UpdateAccountSettings`](crate::client::fluent_builders::UpdateAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn update_account_settings(&self) -> fluent_builders::UpdateAccountSettings<C, M, R> {
        fluent_builders::UpdateAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAppInstance` operation.
    ///
    /// See [`UpdateAppInstance`](crate::client::fluent_builders::UpdateAppInstance) for more information about the
    /// operation and its arguments.
    pub fn update_app_instance(&self) -> fluent_builders::UpdateAppInstance<C, M, R> {
        fluent_builders::UpdateAppInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAppInstanceUser` operation.
    ///
    /// See [`UpdateAppInstanceUser`](crate::client::fluent_builders::UpdateAppInstanceUser) for more information about the
    /// operation and its arguments.
    pub fn update_app_instance_user(&self) -> fluent_builders::UpdateAppInstanceUser<C, M, R> {
        fluent_builders::UpdateAppInstanceUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBot` operation.
    ///
    /// See [`UpdateBot`](crate::client::fluent_builders::UpdateBot) for more information about the
    /// operation and its arguments.
    pub fn update_bot(&self) -> fluent_builders::UpdateBot<C, M, R> {
        fluent_builders::UpdateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannel` operation.
    ///
    /// See [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) for more information about the
    /// operation and its arguments.
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannelMessage` operation.
    ///
    /// See [`UpdateChannelMessage`](crate::client::fluent_builders::UpdateChannelMessage) for more information about the
    /// operation and its arguments.
    pub fn update_channel_message(&self) -> fluent_builders::UpdateChannelMessage<C, M, R> {
        fluent_builders::UpdateChannelMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannelReadMarker` operation.
    ///
    /// See [`UpdateChannelReadMarker`](crate::client::fluent_builders::UpdateChannelReadMarker) for more information about the
    /// operation and its arguments.
    pub fn update_channel_read_marker(&self) -> fluent_builders::UpdateChannelReadMarker<C, M, R> {
        fluent_builders::UpdateChannelReadMarker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGlobalSettings` operation.
    ///
    /// See [`UpdateGlobalSettings`](crate::client::fluent_builders::UpdateGlobalSettings) for more information about the
    /// operation and its arguments.
    pub fn update_global_settings(&self) -> fluent_builders::UpdateGlobalSettings<C, M, R> {
        fluent_builders::UpdateGlobalSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePhoneNumber` operation.
    ///
    /// See [`UpdatePhoneNumber`](crate::client::fluent_builders::UpdatePhoneNumber) for more information about the
    /// operation and its arguments.
    pub fn update_phone_number(&self) -> fluent_builders::UpdatePhoneNumber<C, M, R> {
        fluent_builders::UpdatePhoneNumber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePhoneNumberSettings` operation.
    ///
    /// See [`UpdatePhoneNumberSettings`](crate::client::fluent_builders::UpdatePhoneNumberSettings) for more information about the
    /// operation and its arguments.
    pub fn update_phone_number_settings(
        &self,
    ) -> fluent_builders::UpdatePhoneNumberSettings<C, M, R> {
        fluent_builders::UpdatePhoneNumberSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProxySession` operation.
    ///
    /// See [`UpdateProxySession`](crate::client::fluent_builders::UpdateProxySession) for more information about the
    /// operation and its arguments.
    pub fn update_proxy_session(&self) -> fluent_builders::UpdateProxySession<C, M, R> {
        fluent_builders::UpdateProxySession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoom` operation.
    ///
    /// See [`UpdateRoom`](crate::client::fluent_builders::UpdateRoom) for more information about the
    /// operation and its arguments.
    pub fn update_room(&self) -> fluent_builders::UpdateRoom<C, M, R> {
        fluent_builders::UpdateRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoomMembership` operation.
    ///
    /// See [`UpdateRoomMembership`](crate::client::fluent_builders::UpdateRoomMembership) for more information about the
    /// operation and its arguments.
    pub fn update_room_membership(&self) -> fluent_builders::UpdateRoomMembership<C, M, R> {
        fluent_builders::UpdateRoomMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSipMediaApplication` operation.
    ///
    /// See [`UpdateSipMediaApplication`](crate::client::fluent_builders::UpdateSipMediaApplication) for more information about the
    /// operation and its arguments.
    pub fn update_sip_media_application(
        &self,
    ) -> fluent_builders::UpdateSipMediaApplication<C, M, R> {
        fluent_builders::UpdateSipMediaApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSipMediaApplicationCall` operation.
    ///
    /// See [`UpdateSipMediaApplicationCall`](crate::client::fluent_builders::UpdateSipMediaApplicationCall) for more information about the
    /// operation and its arguments.
    pub fn update_sip_media_application_call(
        &self,
    ) -> fluent_builders::UpdateSipMediaApplicationCall<C, M, R> {
        fluent_builders::UpdateSipMediaApplicationCall::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSipRule` operation.
    ///
    /// See [`UpdateSipRule`](crate::client::fluent_builders::UpdateSipRule) for more information about the
    /// operation and its arguments.
    pub fn update_sip_rule(&self) -> fluent_builders::UpdateSipRule<C, M, R> {
        fluent_builders::UpdateSipRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUser` operation.
    ///
    /// See [`UpdateUser`](crate::client::fluent_builders::UpdateUser) for more information about the
    /// operation and its arguments.
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserSettings` operation.
    ///
    /// See [`UpdateUserSettings`](crate::client::fluent_builders::UpdateUserSettings) for more information about the
    /// operation and its arguments.
    pub fn update_user_settings(&self) -> fluent_builders::UpdateUserSettings<C, M, R> {
        fluent_builders::UpdateUserSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVoiceConnector` operation.
    ///
    /// See [`UpdateVoiceConnector`](crate::client::fluent_builders::UpdateVoiceConnector) for more information about the
    /// operation and its arguments.
    pub fn update_voice_connector(&self) -> fluent_builders::UpdateVoiceConnector<C, M, R> {
        fluent_builders::UpdateVoiceConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVoiceConnectorGroup` operation.
    ///
    /// See [`UpdateVoiceConnectorGroup`](crate::client::fluent_builders::UpdateVoiceConnectorGroup) for more information about the
    /// operation and its arguments.
    pub fn update_voice_connector_group(
        &self,
    ) -> fluent_builders::UpdateVoiceConnectorGroup<C, M, R> {
        fluent_builders::UpdateVoiceConnectorGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociatePhoneNumbersWithVoiceConnector`.
    ///
    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociatePhoneNumbersWithVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_phone_numbers_with_voice_connector_input::Builder,
    }
    impl<C, M, R> AssociatePhoneNumbersWithVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePhoneNumbersWithVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePhoneNumbersWithVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociatePhoneNumbersWithVoiceConnectorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePhoneNumbersWithVoiceConnectorInputOperationOutputAlias,
                crate::output::AssociatePhoneNumbersWithVoiceConnectorOutput,
                crate::error::AssociatePhoneNumbersWithVoiceConnectorError,
                crate::input::AssociatePhoneNumbersWithVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(inp);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn force_associate(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_associate(inp);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn set_force_associate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_associate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePhoneNumbersWithVoiceConnectorGroup`.
    ///
    /// <p>Associates phone numbers with the specified Amazon Chime Voice Connector group.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociatePhoneNumbersWithVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_phone_numbers_with_voice_connector_group_input::Builder,
    }
    impl<C, M, R> AssociatePhoneNumbersWithVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePhoneNumbersWithVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePhoneNumbersWithVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociatePhoneNumbersWithVoiceConnectorGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::AssociatePhoneNumbersWithVoiceConnectorGroupOutput,
                crate::error::AssociatePhoneNumbersWithVoiceConnectorGroupError,
                crate::input::AssociatePhoneNumbersWithVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(inp);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn force_associate(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_associate(inp);
            self
        }
        /// <p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>
        pub fn set_force_associate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_associate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePhoneNumberWithUser`.
    ///
    /// <p>Associates a phone number with the specified Amazon Chime user.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociatePhoneNumberWithUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_phone_number_with_user_input::Builder,
    }
    impl<C, M, R> AssociatePhoneNumberWithUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePhoneNumberWithUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePhoneNumberWithUserOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePhoneNumberWithUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePhoneNumberWithUserInputOperationOutputAlias,
                crate::output::AssociatePhoneNumberWithUserOutput,
                crate::error::AssociatePhoneNumberWithUserError,
                crate::input::AssociatePhoneNumberWithUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn e164_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_number(inp);
            self
        }
        /// <p>The phone number, in E.164 format.</p>
        pub fn set_e164_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSigninDelegateGroupsWithAccount`.
    ///
    /// <p>Associates the specified sign-in delegate groups with the specified Amazon Chime account.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateSigninDelegateGroupsWithAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_signin_delegate_groups_with_account_input::Builder,
    }
    impl<C, M, R> AssociateSigninDelegateGroupsWithAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSigninDelegateGroupsWithAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSigninDelegateGroupsWithAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateSigninDelegateGroupsWithAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSigninDelegateGroupsWithAccountInputOperationOutputAlias,
                crate::output::AssociateSigninDelegateGroupsWithAccountOutput,
                crate::error::AssociateSigninDelegateGroupsWithAccountError,
                crate::input::AssociateSigninDelegateGroupsWithAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `SigninDelegateGroups`.
        ///
        /// To override the contents of this collection use [`set_signin_delegate_groups`](Self::set_signin_delegate_groups).
        ///
        /// <p>The sign-in delegate groups.</p>
        pub fn signin_delegate_groups(
            mut self,
            inp: impl Into<crate::model::SigninDelegateGroup>,
        ) -> Self {
            self.inner = self.inner.signin_delegate_groups(inp);
            self
        }
        /// <p>The sign-in delegate groups.</p>
        pub fn set_signin_delegate_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigninDelegateGroup>>,
        ) -> Self {
            self.inner = self.inner.set_signin_delegate_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateAttendee`.
    ///
    /// <p>
    /// Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreateAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_attendee_input::Builder,
    }
    impl<C, M, R> BatchCreateAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateAttendeeInputOperationOutputAlias,
                crate::output::BatchCreateAttendeeOutput,
                crate::error::BatchCreateAttendeeError,
                crate::input::BatchCreateAttendeeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The request containing the attendees to create.</p>
        pub fn attendees(
            mut self,
            inp: impl Into<crate::model::CreateAttendeeRequestItem>,
        ) -> Self {
            self.inner = self.inner.attendees(inp);
            self
        }
        /// <p>The request containing the attendees to create.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateChannelMembership`.
    ///
    /// <p>Adds a specified number of users to a channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreateChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_channel_membership_input::Builder,
    }
    impl<C, M, R> BatchCreateChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateChannelMembershipInputOperationOutputAlias,
                crate::output::BatchCreateChannelMembershipOutput,
                crate::error::BatchCreateChannelMembershipError,
                crate::input::BatchCreateChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `MemberArns`.
        ///
        /// To override the contents of this collection use [`set_member_arns`](Self::set_member_arns).
        ///
        /// <p>The ARNs of the members you want to add to the channel.</p>
        pub fn member_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arns(inp);
            self
        }
        /// <p>The ARNs of the members you want to add to the channel.</p>
        pub fn set_member_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_member_arns(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateRoomMembership`.
    ///
    /// <p>Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreateRoomMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_room_membership_input::Builder,
    }
    impl<C, M, R> BatchCreateRoomMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateRoomMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateRoomMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateRoomMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateRoomMembershipInputOperationOutputAlias,
                crate::output::BatchCreateRoomMembershipOutput,
                crate::error::BatchCreateRoomMembershipError,
                crate::input::BatchCreateRoomMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// Appends an item to `MembershipItemList`.
        ///
        /// To override the contents of this collection use [`set_membership_item_list`](Self::set_membership_item_list).
        ///
        /// <p>The list of membership items.</p>
        pub fn membership_item_list(
            mut self,
            inp: impl Into<crate::model::MembershipItem>,
        ) -> Self {
            self.inner = self.inner.membership_item_list(inp);
            self
        }
        /// <p>The list of membership items.</p>
        pub fn set_membership_item_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MembershipItem>>,
        ) -> Self {
            self.inner = self.inner.set_membership_item_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeletePhoneNumber`.
    ///
    /// <p>
    /// Moves phone numbers into the
    /// <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
    /// </p>
    ///
    /// <p>
    /// Phone numbers remain in the
    /// <b>Deletion queue</b> for 7 days before they are deleted permanently.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeletePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_phone_number_input::Builder,
    }
    impl<C, M, R> BatchDeletePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeletePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeletePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeletePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeletePhoneNumberInputOperationOutputAlias,
                crate::output::BatchDeletePhoneNumberOutput,
                crate::error::BatchDeletePhoneNumberError,
                crate::input::BatchDeletePhoneNumberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `PhoneNumberIds`.
        ///
        /// To override the contents of this collection use [`set_phone_number_ids`](Self::set_phone_number_ids).
        ///
        /// <p>List of phone number IDs.</p>
        pub fn phone_number_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_ids(inp);
            self
        }
        /// <p>List of phone number IDs.</p>
        pub fn set_phone_number_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchSuspendUser`.
    ///
    /// <p>Suspends up to 50 users from a <code>Team</code> or <code>EnterpriseLWA</code> Amazon Chime
    /// account. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration
    /// Guide</i>.</p>
    ///
    /// <p>Users suspended from a <code>Team</code> account are disassociated from the account,but they
    /// can continue to use Amazon Chime as free users. To remove the suspension from suspended
    /// <code>Team</code> account users, invite them to the <code>Team</code> account again.
    /// You can use the <a>InviteUsers</a> action to do so.</p>
    ///
    /// <p>Users suspended from an <code>EnterpriseLWA</code> account are immediately signed out of
    /// Amazon Chime and can no longer sign in. To remove the suspension from suspended <code>EnterpriseLWA</code> account users, use the <a>BatchUnsuspendUser</a> action.</p>
    ///
    /// <p>
    /// To sign out users without suspending them, use the
    /// <a>LogoutUser</a>
    /// action.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchSuspendUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_suspend_user_input::Builder,
    }
    impl<C, M, R> BatchSuspendUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchSuspendUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchSuspendUserOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchSuspendUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchSuspendUserInputOperationOutputAlias,
                crate::output::BatchSuspendUserOutput,
                crate::error::BatchSuspendUserError,
                crate::input::BatchSuspendUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UserIdList`.
        ///
        /// To override the contents of this collection use [`set_user_id_list`](Self::set_user_id_list).
        ///
        /// <p>The request containing the user IDs to suspend.</p>
        pub fn user_id_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id_list(inp);
            self
        }
        /// <p>The request containing the user IDs to suspend.</p>
        pub fn set_user_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_id_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUnsuspendUser`.
    ///
    /// <p>Removes the suspension from up to 50 previously suspended users for the specified Amazon
    /// Chime <code>EnterpriseLWA</code> account. Only users on <code>EnterpriseLWA</code>
    /// accounts can be unsuspended using this action. For more information about different account types, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">
    /// Managing Your Amazon Chime Accounts
    /// </a> in the account types, in the <i>Amazon Chime Administration Guide</i>.
    /// </p>
    ///
    /// <p>
    /// Previously suspended users who are unsuspended using this action are returned to
    /// <code>Registered</code>
    /// status. Users who are not previously suspended are ignored.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchUnsuspendUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_unsuspend_user_input::Builder,
    }
    impl<C, M, R> BatchUnsuspendUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUnsuspendUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUnsuspendUserOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUnsuspendUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUnsuspendUserInputOperationOutputAlias,
                crate::output::BatchUnsuspendUserOutput,
                crate::error::BatchUnsuspendUserError,
                crate::input::BatchUnsuspendUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UserIdList`.
        ///
        /// To override the contents of this collection use [`set_user_id_list`](Self::set_user_id_list).
        ///
        /// <p>The request containing the user IDs to unsuspend.</p>
        pub fn user_id_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id_list(inp);
            self
        }
        /// <p>The request containing the user IDs to unsuspend.</p>
        pub fn set_user_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_id_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdatePhoneNumber`.
    ///
    /// <p>Updates phone number product types or calling names. You can update one attribute at a time for each <code>UpdatePhoneNumberRequestItem</code>. For example, you can update the product type or the calling name.</p>
    /// <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p>
    /// <p>Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchUpdatePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_phone_number_input::Builder,
    }
    impl<C, M, R> BatchUpdatePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdatePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdatePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdatePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdatePhoneNumberInputOperationOutputAlias,
                crate::output::BatchUpdatePhoneNumberOutput,
                crate::error::BatchUpdatePhoneNumberError,
                crate::input::BatchUpdatePhoneNumberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UpdatePhoneNumberRequestItems`.
        ///
        /// To override the contents of this collection use [`set_update_phone_number_request_items`](Self::set_update_phone_number_request_items).
        ///
        /// <p>The request containing the phone number IDs and product types or calling names to update.</p>
        pub fn update_phone_number_request_items(
            mut self,
            inp: impl Into<crate::model::UpdatePhoneNumberRequestItem>,
        ) -> Self {
            self.inner = self.inner.update_phone_number_request_items(inp);
            self
        }
        /// <p>The request containing the phone number IDs and product types or calling names to update.</p>
        pub fn set_update_phone_number_request_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdatePhoneNumberRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_update_phone_number_request_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdateUser`.
    ///
    /// <p>Updates user details within the <a>UpdateUserRequestItem</a> object for up to 20 users for the specified Amazon Chime account. Currently, only <code>LicenseType</code> updates are supported for this action.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchUpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_user_input::Builder,
    }
    impl<C, M, R> BatchUpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdateUserInputOperationOutputAlias,
                crate::output::BatchUpdateUserOutput,
                crate::error::BatchUpdateUserError,
                crate::input::BatchUpdateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UpdateUserRequestItems`.
        ///
        /// To override the contents of this collection use [`set_update_user_request_items`](Self::set_update_user_request_items).
        ///
        /// <p>The request containing the user IDs and details to update.</p>
        pub fn update_user_request_items(
            mut self,
            inp: impl Into<crate::model::UpdateUserRequestItem>,
        ) -> Self {
            self.inner = self.inner.update_user_request_items(inp);
            self
        }
        /// <p>The request containing the user IDs and details to update.</p>
        pub fn set_update_user_request_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateUserRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_update_user_request_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccount`.
    ///
    /// <p>Creates an Amazon Chime account under the administrator's AWS account. Only <code>Team</code>
    /// account types are currently supported for this action. For more information about different account types, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_account_input::Builder,
    }
    impl<C, M, R> CreateAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccountInputOperationOutputAlias,
                crate::output::CreateAccountOutput,
                crate::error::CreateAccountError,
                crate::input::CreateAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Chime account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Amazon Chime account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstance`.
    ///
    /// <p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API.
    /// <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_input::Builder,
    }
    impl<C, M, R> CreateAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceInputOperationOutputAlias,
                crate::output::CreateAppInstanceOutput,
                crate::error::CreateAppInstanceError,
                crate::input::CreateAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <code>AppInstance</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceAdmin`.
    ///
    /// <p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the following actions.
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DeleteChannelMessage</code> actions.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_admin_input::Builder,
    }
    impl<C, M, R> CreateAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceAdminInputOperationOutputAlias,
                crate::output::CreateAppInstanceAdminOutput,
                crate::error::CreateAppInstanceAdminError,
                crate::input::CreateAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn app_instance_admin_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(inp);
            self
        }
        /// <p>The ARN of the administrator of the current <code>AppInstance</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppInstanceUser`.
    ///
    /// <p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and
    /// <code>Name</code> for that user.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_instance_user_input::Builder,
    }
    impl<C, M, R> CreateAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInstanceUserInputOperationOutputAlias,
                crate::output::CreateAppInstanceUserOutput,
                crate::error::CreateAppInstanceUserError,
                crate::input::CreateAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code> request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn app_instance_user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_id(inp);
            self
        }
        /// <p>The user ID of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_id(input);
            self
        }
        /// <p>The user's name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The user's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The request's metadata. Limited to a 1KB string in UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The token assigned to the user requesting an <code>AppInstance</code>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags assigned to the <code>AppInstanceUser</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAttendee`.
    ///
    /// <p>
    /// Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_attendee_input::Builder,
    }
    impl<C, M, R> CreateAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAttendeeInputOperationOutputAlias,
                crate::output::CreateAttendeeOutput,
                crate::error::CreateAttendeeError,
                crate::input::CreateAttendeeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn external_user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_user_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>
        pub fn set_external_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_user_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBot`.
    ///
    /// <p>Creates a bot for an Amazon Chime Enterprise account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bot_input::Builder,
    }
    impl<C, M, R> CreateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBotInputOperationOutputAlias,
                crate::output::CreateBotOutput,
                crate::error::CreateBotError,
                crate::input::CreateBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot display name.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The bot display name.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The domain of the Amazon Chime Enterprise account.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain of the Amazon Chime Enterprise account.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Creates a channel to which you can add users and send messages.</p>
    ///
    /// <p>
    /// <b>Restriction</b>: You can't change a channel's
    /// privacy.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel request.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the channel request.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators,
        /// moderators, and channel members can add themselves and other members to unrestricted
        /// channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn mode(mut self, inp: crate::model::ChannelMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators,
        /// moderators, and channel members can add themselves and other members to unrestricted
        /// channels. Only administrators and moderators can add members to restricted channels.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private
        /// channels aren't discoverable by users outside the channel. Public channels are discoverable
        /// by anyone in the <code>AppInstance</code>.</p>
        pub fn privacy(mut self, inp: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(inp);
            self
        }
        /// <p>The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private
        /// channels aren't discoverable by users outside the channel. Public channels are discoverable
        /// by anyone in the <code>AppInstance</code>.</p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The client token for the request. An <code>Idempotency</code> token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the creation request.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the creation request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelBan`.
    ///
    /// <p>Permanently bans a member from a channel. Moderators can't add banned members to a
    /// channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then
    /// <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or
    /// channels.</p>
    /// <p>If you ban a user who is already part of a channel, that user is automatically kicked
    /// from the channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_ban_input::Builder,
    }
    impl<C, M, R> CreateChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelBanInputOperationOutputAlias,
                crate::output::CreateChannelBanOutput,
                crate::error::CreateChannelBanError,
                crate::input::CreateChannelBanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the ban request.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the ban request.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelMembership`.
    ///
    /// <p>Adds a user to a channel. The <code>InvitedBy</code> response field is derived from the
    /// request header. A channel member can:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>List messages</p>
    /// </li>
    /// <li>
    /// <p>Send messages</p>
    /// </li>
    /// <li>
    /// <p>Receive messages</p>
    /// </li>
    /// <li>
    /// <p>Edit their own messages</p>
    /// </li>
    /// <li>
    /// <p>Leave the channel</p>
    /// </li>
    /// </ul>
    ///
    /// <p>Privacy settings impact this action as follows:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Public Channels: You do not need to be a member to list messages, but you must be
    /// a member to send messages.</p>
    /// </li>
    /// <li>
    /// <p>Private Channels: You must be a member to list or send messages.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_membership_input::Builder,
    }
    impl<C, M, R> CreateChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelMembershipInputOperationOutputAlias,
                crate::output::CreateChannelMembershipOutput,
                crate::error::CreateChannelMembershipError,
                crate::input::CreateChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel to which you're adding users.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member you want to add to the channel.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The ARN of the member you want to add to the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported
        /// by moderators.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannelModerator`.
    ///
    /// <p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Add and remove other members of the channel.</p>
    /// </li>
    /// <li>
    /// <p>Add and remove other moderators of the channel.</p>
    /// </li>
    /// <li>
    /// <p>Add and remove user bans for the channel.</p>
    /// </li>
    /// <li>
    /// <p>Redact messages in the channel.</p>
    /// </li>
    /// <li>
    /// <p>List messages in the channel.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_moderator_input::Builder,
    }
    impl<C, M, R> CreateChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelModeratorInputOperationOutputAlias,
                crate::output::CreateChannelModeratorOutput,
                crate::error::CreateChannelModeratorError,
                crate::input::CreateChannelModeratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the moderator.</p>
        pub fn channel_moderator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(inp);
            self
        }
        /// <p>The ARN of the moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMediaCapturePipeline`.
    ///
    /// <p>Creates a media capture pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMediaCapturePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_media_capture_pipeline_input::Builder,
    }
    impl<C, M, R> CreateMediaCapturePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMediaCapturePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMediaCapturePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMediaCapturePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMediaCapturePipelineInputOperationOutputAlias,
                crate::output::CreateMediaCapturePipelineOutput,
                crate::error::CreateMediaCapturePipelineError,
                crate::input::CreateMediaCapturePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Source type from which the media artifacts will be captured. A Chime SDK Meeting
        /// is the only supported source.</p>
        pub fn source_type(mut self, inp: crate::model::MediaPipelineSourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>Source type from which the media artifacts will be captured. A Chime SDK Meeting
        /// is the only supported source.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>ARN of the source from which the media artifacts are captured.</p>
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// <p>ARN of the source from which the media artifacts are captured.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>
        pub fn sink_type(mut self, inp: crate::model::MediaPipelineSinkType) -> Self {
            self.inner = self.inner.sink_type(inp);
            self
        }
        /// <p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>
        pub fn set_sink_type(
            mut self,
            input: std::option::Option<crate::model::MediaPipelineSinkType>,
        ) -> Self {
            self.inner = self.inner.set_sink_type(input);
            self
        }
        /// <p>The ARN of the sink type.</p>
        pub fn sink_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sink_arn(inp);
            self
        }
        /// <p>The ARN of the sink type.</p>
        pub fn set_sink_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sink_arn(input);
            self
        }
        /// <p>The token assigned to the client making the pipeline request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The token assigned to the client making the pipeline request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn chime_sdk_meeting_configuration(
            mut self,
            inp: crate::model::ChimeSdkMeetingConfiguration,
        ) -> Self {
            self.inner = self.inner.chime_sdk_meeting_configuration(inp);
            self
        }
        /// <p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>
        pub fn set_chime_sdk_meeting_configuration(
            mut self,
            input: std::option::Option<crate::model::ChimeSdkMeetingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_chime_sdk_meeting_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeeting`.
    ///
    /// <p>
    /// Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>
    /// . For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>
    /// .
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_input::Builder,
    }
    impl<C, M, R> CreateMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingInputOperationOutputAlias,
                crate::output::CreateMeetingOutput,
                crate::error::CreateMeetingError,
                crate::input::CreateMeetingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(inp);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(inp);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p>
        /// The Region in which to create the meeting. Default: <code>us-east-1</code>.
        /// </p>
        ///
        /// <p>
        /// Available values:
        /// <code>af-south-1</code>
        /// ,
        /// <code>ap-northeast-1</code>
        /// ,
        /// <code>ap-northeast-2</code>
        /// ,
        /// <code>ap-south-1</code>
        /// ,
        /// <code>ap-southeast-1</code>
        /// ,
        /// <code>ap-southeast-2</code>
        /// ,
        /// <code>ca-central-1</code>
        /// ,
        /// <code>eu-central-1</code>
        /// ,
        /// <code>eu-north-1</code>
        /// ,
        /// <code>eu-south-1</code>
        /// ,
        /// <code>eu-west-1</code>
        /// ,
        /// <code>eu-west-2</code>
        /// ,
        /// <code>eu-west-3</code>
        /// ,
        /// <code>sa-east-1</code>
        /// ,
        /// <code>us-east-1</code>
        /// ,
        /// <code>us-east-2</code>
        /// ,
        /// <code>us-west-1</code>
        /// ,
        /// <code>us-west-2</code>
        /// .
        /// </p>
        pub fn media_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(inp);
            self
        }
        /// <p>
        /// The Region in which to create the meeting. Default: <code>us-east-1</code>.
        /// </p>
        ///
        /// <p>
        /// Available values:
        /// <code>af-south-1</code>
        /// ,
        /// <code>ap-northeast-1</code>
        /// ,
        /// <code>ap-northeast-2</code>
        /// ,
        /// <code>ap-south-1</code>
        /// ,
        /// <code>ap-southeast-1</code>
        /// ,
        /// <code>ap-southeast-2</code>
        /// ,
        /// <code>ca-central-1</code>
        /// ,
        /// <code>eu-central-1</code>
        /// ,
        /// <code>eu-north-1</code>
        /// ,
        /// <code>eu-south-1</code>
        /// ,
        /// <code>eu-west-1</code>
        /// ,
        /// <code>eu-west-2</code>
        /// ,
        /// <code>eu-west-3</code>
        /// ,
        /// <code>sa-east-1</code>
        /// ,
        /// <code>us-east-1</code>
        /// ,
        /// <code>us-east-2</code>
        /// ,
        /// <code>us-west-1</code>
        /// ,
        /// <code>us-west-2</code>
        /// .
        /// </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn notifications_configuration(
            mut self,
            inp: crate::model::MeetingNotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(inp);
            self
        }
        /// <p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::MeetingNotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeetingDialOut`.
    ///
    /// <p>Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public
    /// switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.</p>
    ///
    /// <p>To play welcome audio or implement an interactive voice response (IVR), use the
    /// <code>CreateSipMediaApplicationCall</code> action with the corresponding SIP media application ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMeetingDialOut<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_dial_out_input::Builder,
    }
    impl<C, M, R> CreateMeetingDialOut<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeetingDialOut`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingDialOutOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingDialOutError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingDialOutInputOperationOutputAlias,
                crate::output::CreateMeetingDialOutOutput,
                crate::error::CreateMeetingDialOutError,
                crate::input::CreateMeetingDialOutInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>Phone number used as the caller ID when the remote party receives a call.</p>
        pub fn from_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_phone_number(inp);
            self
        }
        /// <p>Phone number used as the caller ID when the remote party receives a call.</p>
        pub fn set_from_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_phone_number(input);
            self
        }
        /// <p>Phone number called when inviting someone to a meeting.</p>
        pub fn to_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.to_phone_number(inp);
            self
        }
        /// <p>Phone number called when inviting someone to a meeting.</p>
        pub fn set_to_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_to_phone_number(input);
            self
        }
        /// <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
        pub fn join_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.join_token(inp);
            self
        }
        /// <p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>
        pub fn set_join_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_join_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMeetingWithAttendees`.
    ///
    /// <p>
    /// Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>
    /// . For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>
    /// .
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMeetingWithAttendees<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_meeting_with_attendees_input::Builder,
    }
    impl<C, M, R> CreateMeetingWithAttendees<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMeetingWithAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeetingWithAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeetingWithAttendeesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMeetingWithAttendeesInputOperationOutputAlias,
                crate::output::CreateMeetingWithAttendeesOutput,
                crate::error::CreateMeetingWithAttendeesError,
                crate::input::CreateMeetingWithAttendeesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The unique identifier for the client request. Use a different token for different meetings.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn external_meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_meeting_id(inp);
            self
        }
        /// <p>The external meeting ID.</p>
        pub fn set_external_meeting_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_meeting_id(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn meeting_host_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_host_id(inp);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_meeting_host_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_meeting_host_id(input);
            self
        }
        /// <p>
        /// The Region in which to create the meeting. Default: <code>us-east-1</code>
        /// .
        /// </p>
        ///
        /// <p>
        /// Available values:
        /// <code>af-south-1</code>
        /// ,
        /// <code>ap-northeast-1</code>
        /// ,
        /// <code>ap-northeast-2</code>
        /// ,
        /// <code>ap-south-1</code>
        /// ,
        /// <code>ap-southeast-1</code>
        /// ,
        /// <code>ap-southeast-2</code>
        /// ,
        /// <code>ca-central-1</code>
        /// ,
        /// <code>eu-central-1</code>
        /// ,
        /// <code>eu-north-1</code>
        /// ,
        /// <code>eu-south-1</code>
        /// ,
        /// <code>eu-west-1</code>
        /// ,
        /// <code>eu-west-2</code>
        /// ,
        /// <code>eu-west-3</code>
        /// ,
        /// <code>sa-east-1</code>
        /// ,
        /// <code>us-east-1</code>
        /// ,
        /// <code>us-east-2</code>
        /// ,
        /// <code>us-west-1</code>
        /// ,
        /// <code>us-west-2</code>
        /// .
        /// </p>
        pub fn media_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_region(inp);
            self
        }
        /// <p>
        /// The Region in which to create the meeting. Default: <code>us-east-1</code>
        /// .
        /// </p>
        ///
        /// <p>
        /// Available values:
        /// <code>af-south-1</code>
        /// ,
        /// <code>ap-northeast-1</code>
        /// ,
        /// <code>ap-northeast-2</code>
        /// ,
        /// <code>ap-south-1</code>
        /// ,
        /// <code>ap-southeast-1</code>
        /// ,
        /// <code>ap-southeast-2</code>
        /// ,
        /// <code>ca-central-1</code>
        /// ,
        /// <code>eu-central-1</code>
        /// ,
        /// <code>eu-north-1</code>
        /// ,
        /// <code>eu-south-1</code>
        /// ,
        /// <code>eu-west-1</code>
        /// ,
        /// <code>eu-west-2</code>
        /// ,
        /// <code>eu-west-3</code>
        /// ,
        /// <code>sa-east-1</code>
        /// ,
        /// <code>us-east-1</code>
        /// ,
        /// <code>us-east-2</code>
        /// ,
        /// <code>us-west-1</code>
        /// ,
        /// <code>us-west-2</code>
        /// .
        /// </p>
        pub fn set_media_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_region(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event
        /// notifications. The Amazon Chime SDK supports resource targets located in the US East (N.
        /// Virginia) AWS Region (<code>us-east-1</code>). </p>
        pub fn notifications_configuration(
            mut self,
            inp: crate::model::MeetingNotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.notifications_configuration(inp);
            self
        }
        /// <p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event
        /// notifications. The Amazon Chime SDK supports resource targets located in the US East (N.
        /// Virginia) AWS Region (<code>us-east-1</code>). </p>
        pub fn set_notifications_configuration(
            mut self,
            input: std::option::Option<crate::model::MeetingNotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notifications_configuration(input);
            self
        }
        /// Appends an item to `Attendees`.
        ///
        /// To override the contents of this collection use [`set_attendees`](Self::set_attendees).
        ///
        /// <p>The request containing the attendees to create.</p>
        pub fn attendees(
            mut self,
            inp: impl Into<crate::model::CreateAttendeeRequestItem>,
        ) -> Self {
            self.inner = self.inner.attendees(inp);
            self
        }
        /// <p>The request containing the attendees to create.</p>
        pub fn set_attendees(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateAttendeeRequestItem>>,
        ) -> Self {
            self.inner = self.inner.set_attendees(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePhoneNumberOrder`.
    ///
    /// <p>Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type.
    /// For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePhoneNumberOrder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_phone_number_order_input::Builder,
    }
    impl<C, M, R> CreatePhoneNumberOrder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePhoneNumberOrder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePhoneNumberOrderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePhoneNumberOrderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePhoneNumberOrderInputOperationOutputAlias,
                crate::output::CreatePhoneNumberOrderOutput,
                crate::error::CreatePhoneNumberOrderError,
                crate::input::CreatePhoneNumberOrderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, inp: crate::model::PhoneNumberProductType) -> Self {
            self.inner = self.inner.product_type(inp);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(inp);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProxySession`.
    ///
    /// <p>Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProxySession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_proxy_session_input::Builder,
    }
    impl<C, M, R> CreateProxySession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProxySession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProxySessionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProxySessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProxySessionInputOperationOutputAlias,
                crate::output::CreateProxySessionOutput,
                crate::error::CreateProxySessionError,
                crate::input::CreateProxySessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `ParticipantPhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_participant_phone_numbers`](Self::set_participant_phone_numbers).
        ///
        /// <p>The participant phone numbers.</p>
        pub fn participant_phone_numbers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.participant_phone_numbers(inp);
            self
        }
        /// <p>The participant phone numbers.</p>
        pub fn set_participant_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_participant_phone_numbers(input);
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the proxy session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn expiry_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.expiry_minutes(inp);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn set_expiry_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiry_minutes(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>The proxy session capabilities.</p>
        pub fn capabilities(mut self, inp: impl Into<crate::model::Capability>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>The proxy session capabilities.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn number_selection_behavior(
            mut self,
            inp: crate::model::NumberSelectionBehavior,
        ) -> Self {
            self.inner = self.inner.number_selection_behavior(inp);
            self
        }
        /// <p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>
        pub fn set_number_selection_behavior(
            mut self,
            input: std::option::Option<crate::model::NumberSelectionBehavior>,
        ) -> Self {
            self.inner = self.inner.set_number_selection_behavior(input);
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn geo_match_level(mut self, inp: crate::model::GeoMatchLevel) -> Self {
            self.inner = self.inner.geo_match_level(inp);
            self
        }
        /// <p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>
        pub fn set_geo_match_level(
            mut self,
            input: std::option::Option<crate::model::GeoMatchLevel>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_level(input);
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn geo_match_params(mut self, inp: crate::model::GeoMatchParams) -> Self {
            self.inner = self.inner.geo_match_params(inp);
            self
        }
        /// <p>The country and area code for the proxy phone number.</p>
        pub fn set_geo_match_params(
            mut self,
            input: std::option::Option<crate::model::GeoMatchParams>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_params(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoom`.
    ///
    /// <p>Creates a chat room for the specified Amazon Chime Enterprise account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_room_input::Builder,
    }
    impl<C, M, R> CreateRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoomInputOperationOutputAlias,
                crate::output::CreateRoomOutput,
                crate::error::CreateRoomError,
                crate::input::CreateRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The room name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoomMembership`.
    ///
    /// <p>Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRoomMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_room_membership_input::Builder,
    }
    impl<C, M, R> CreateRoomMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoomMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoomMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoomMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoomMembershipInputOperationOutputAlias,
                crate::output::CreateRoomMembershipOutput,
                crate::error::CreateRoomMembershipError,
                crate::input::CreateRoomMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The Amazon Chime member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The Amazon Chime member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The role of the member.</p>
        pub fn role(mut self, inp: crate::model::RoomMembershipRole) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The role of the member.</p>
        pub fn set_role(
            mut self,
            input: std::option::Option<crate::model::RoomMembershipRole>,
        ) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSipMediaApplication`.
    ///
    /// <p>Creates a SIP media application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSipMediaApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sip_media_application_input::Builder,
    }
    impl<C, M, R> CreateSipMediaApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSipMediaApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSipMediaApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSipMediaApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSipMediaApplicationInputOperationOutputAlias,
                crate::output::CreateSipMediaApplicationOutput,
                crate::error::CreateSipMediaApplicationError,
                crate::input::CreateSipMediaApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Region assigned to the SIP media application.</p>
        pub fn aws_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(inp);
            self
        }
        /// <p>The AWS Region assigned to the SIP media application.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The SIP media application name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The SIP media application name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
        pub fn endpoints(
            mut self,
            inp: impl Into<crate::model::SipMediaApplicationEndpoint>,
        ) -> Self {
            self.inner = self.inner.endpoints(inp);
            self
        }
        /// <p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_endpoints(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSipMediaApplicationCall`.
    ///
    /// <p>Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified
    /// <code>sipMediaApplicationId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSipMediaApplicationCall<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sip_media_application_call_input::Builder,
    }
    impl<C, M, R> CreateSipMediaApplicationCall<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSipMediaApplicationCall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSipMediaApplicationCallOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSipMediaApplicationCallError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSipMediaApplicationCallInputOperationOutputAlias,
                crate::output::CreateSipMediaApplicationCallOutput,
                crate::error::CreateSipMediaApplicationCallError,
                crate::input::CreateSipMediaApplicationCallInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
        pub fn from_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_phone_number(inp);
            self
        }
        /// <p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>
        pub fn set_from_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_phone_number(input);
            self
        }
        /// <p>The phone number that the service should call.</p>
        pub fn to_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.to_phone_number(inp);
            self
        }
        /// <p>The phone number that the service should call.</p>
        pub fn set_to_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_to_phone_number(input);
            self
        }
        /// <p>The ID of the SIP media application.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The ID of the SIP media application.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// Adds a key-value pair to `SipHeaders`.
        ///
        /// To override the contents of this collection use [`set_sip_headers`](Self::set_sip_headers).
        ///
        /// <p>The SIP headers added to an outbound call leg.</p>
        pub fn sip_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.sip_headers(k, v);
            self
        }
        /// <p>The SIP headers added to an outbound call leg.</p>
        pub fn set_sip_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_sip_headers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSipRule`.
    ///
    /// <p>Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSipRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sip_rule_input::Builder,
    }
    impl<C, M, R> CreateSipRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSipRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSipRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSipRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSipRuleInputOperationOutputAlias,
                crate::output::CreateSipRuleOutput,
                crate::error::CreateSipRuleError,
                crate::input::CreateSipRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SIP rule.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SIP rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
        pub fn trigger_type(mut self, inp: crate::model::SipRuleTriggerType) -> Self {
            self.inner = self.inner.trigger_type(inp);
            self
        }
        /// <p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::SipRuleTriggerType>,
        ) -> Self {
            self.inner = self.inner.set_trigger_type(input);
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound
        /// host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is
        /// <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the
        /// E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP
        /// request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the
        /// <code>ToPhoneNumber</code> value.</p>
        pub fn trigger_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trigger_value(inp);
            self
        }
        /// <p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound
        /// host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is
        /// <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the
        /// E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP
        /// request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the
        /// <code>ToPhoneNumber</code> value.</p>
        pub fn set_trigger_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trigger_value(input);
            self
        }
        /// <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
        pub fn disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.disabled(inp);
            self
        }
        /// <p>Enables or disables a rule. You must disable rules before you can delete them.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
        /// Appends an item to `TargetApplications`.
        ///
        /// To override the contents of this collection use [`set_target_applications`](Self::set_target_applications).
        ///
        /// <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
        pub fn target_applications(
            mut self,
            inp: impl Into<crate::model::SipRuleTargetApplication>,
        ) -> Self {
            self.inner = self.inner.target_applications(inp);
            self
        }
        /// <p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>
        pub fn set_target_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
        ) -> Self {
            self.inner = self.inner.set_target_applications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user under the specified Amazon Chime account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user name.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The user's email address.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The user's email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, inp: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(inp);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVoiceConnector`.
    ///
    /// <p>Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.</p>
    ///
    /// <p>
    /// Enabling
    /// <a>CreateVoiceConnectorRequest$RequireEncryption</a>
    /// configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_voice_connector_input::Builder,
    }
    impl<C, M, R> CreateVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVoiceConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVoiceConnectorInputOperationOutputAlias,
                crate::output::CreateVoiceConnectorOutput,
                crate::error::CreateVoiceConnectorError,
                crate::input::CreateVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The AWS Region in which the Amazon Chime Voice Connector is created. Default value:
        /// <code>us-east-1</code>
        /// .
        /// </p>
        pub fn aws_region(mut self, inp: crate::model::VoiceConnectorAwsRegion) -> Self {
            self.inner = self.inner.aws_region(inp);
            self
        }
        /// <p>
        /// The AWS Region in which the Amazon Chime Voice Connector is created. Default value:
        /// <code>us-east-1</code>
        /// .
        /// </p>
        pub fn set_aws_region(
            mut self,
            input: std::option::Option<crate::model::VoiceConnectorAwsRegion>,
        ) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn require_encryption(mut self, inp: bool) -> Self {
            self.inner = self.inner.require_encryption(inp);
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn set_require_encryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_encryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVoiceConnectorGroup`.
    ///
    /// <p>Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can
    /// associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by
    /// including <code>VoiceConnectorItems</code> in the request.</p>
    /// <p>You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This
    /// creates a fault tolerant mechanism for fallback in case of availability events.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_voice_connector_group_input::Builder,
    }
    impl<C, M, R> CreateVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVoiceConnectorGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::CreateVoiceConnectorGroupOutput,
                crate::error::CreateVoiceConnectorGroupError,
                crate::input::CreateVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `VoiceConnectorItems`.
        ///
        /// To override the contents of this collection use [`set_voice_connector_items`](Self::set_voice_connector_items).
        ///
        /// <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
        pub fn voice_connector_items(
            mut self,
            inp: impl Into<crate::model::VoiceConnectorItem>,
        ) -> Self {
            self.inner = self.inner.voice_connector_items(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connectors to route inbound calls to.</p>
        pub fn set_voice_connector_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccount`.
    ///
    /// <p>Deletes the specified Amazon Chime account. You must suspend all users before deleting
    /// <code>Team</code> account. You can use the <a>BatchSuspendUser</a> action
    /// to dodo.</p>
    ///
    /// <p>For <code>EnterpriseLWA</code> and <code>EnterpriseAD</code> accounts, you must release the
    /// claimed domains for your Amazon Chime account before deletion. As soon as you release
    /// the domain, all users under that account are suspended.</p>
    ///
    /// <p>Deleted accounts appear in your <code>Disabled</code> accounts list for 90 days. To restore
    /// deleted account from your <code>Disabled</code> accounts list, you must contact AWS
    /// Support.</p>
    ///
    /// <p>After 90 days, deleted accounts are permanently removed from your
    /// <code>Disabled</code> accounts list.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_input::Builder,
    }
    impl<C, M, R> DeleteAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountInputOperationOutputAlias,
                crate::output::DeleteAccountOutput,
                crate::error::DeleteAccountError,
                crate::input::DeleteAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstance`.
    ///
    /// <p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_input::Builder,
    }
    impl<C, M, R> DeleteAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceInputOperationOutputAlias,
                crate::output::DeleteAppInstanceOutput,
                crate::error::DeleteAppInstanceError,
                crate::input::DeleteAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceAdmin`.
    ///
    /// <p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_admin_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceAdminInputOperationOutputAlias,
                crate::output::DeleteAppInstanceAdminOutput,
                crate::error::DeleteAppInstanceAdminError,
                crate::input::DeleteAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn app_instance_admin_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>'s administrator.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceStreamingConfigurations`.
    ///
    /// <p>Deletes the streaming configurations of an <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppInstanceStreamingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_streaming_configurations_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceStreamingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceStreamingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceStreamingConfigurationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteAppInstanceStreamingConfigurationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceStreamingConfigurationsInputOperationOutputAlias,
                crate::output::DeleteAppInstanceStreamingConfigurationsOutput,
                crate::error::DeleteAppInstanceStreamingConfigurationsError,
                crate::input::DeleteAppInstanceStreamingConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the streaming configurations being deleted.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the streaming configurations being deleted.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppInstanceUser`.
    ///
    /// <p>Deletes an <code>AppInstanceUser</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_instance_user_input::Builder,
    }
    impl<C, M, R> DeleteAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInstanceUserInputOperationOutputAlias,
                crate::output::DeleteAppInstanceUserOutput,
                crate::error::DeleteAppInstanceUserError,
                crate::input::DeleteAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the user request being deleted.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttendee`.
    ///
    /// <p>Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their
    /// <code>JoinToken</code>. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_attendee_input::Builder,
    }
    impl<C, M, R> DeleteAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAttendeeInputOperationOutputAlias,
                crate::output::DeleteAttendeeOutput,
                crate::error::DeleteAttendeeError,
                crate::input::DeleteAttendeeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Immediately makes a channel and its memberships inaccessible and marks them for
    /// deletion. This is an irreversible process.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel being deleted.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelBan`.
    ///
    /// <p>Removes a user from a channel's ban list.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_ban_input::Builder,
    }
    impl<C, M, R> DeleteChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelBanInputOperationOutputAlias,
                crate::output::DeleteChannelBanOutput,
                crate::error::DeleteChannelBanError,
                crate::input::DeleteChannelBanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMembership`.
    ///
    /// <p>Removes a member from a channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_membership_input::Builder,
    }
    impl<C, M, R> DeleteChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelMembershipInputOperationOutputAlias,
                crate::output::DeleteChannelMembershipOutput,
                crate::error::DeleteChannelMembershipError,
                crate::input::DeleteChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel from which you want to remove the user.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member that you're removing from the channel.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The ARN of the member that you're removing from the channel.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelMessage`.
    ///
    /// <p>Deletes a channel message. Only admins can perform this action. Deletion makes messages
    /// inaccessible immediately. A background process deletes any revisions created by
    /// <code>UpdateChannelMessage</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_message_input::Builder,
    }
    impl<C, M, R> DeleteChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelMessageInputOperationOutputAlias,
                crate::output::DeleteChannelMessageOutput,
                crate::error::DeleteChannelMessageError,
                crate::input::DeleteChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID of the message being deleted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannelModerator`.
    ///
    /// <p>Deletes a channel moderator.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_moderator_input::Builder,
    }
    impl<C, M, R> DeleteChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelModeratorInputOperationOutputAlias,
                crate::output::DeleteChannelModeratorOutput,
                crate::error::DeleteChannelModeratorError,
                crate::input::DeleteChannelModeratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the moderator being deleted.</p>
        pub fn channel_moderator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(inp);
            self
        }
        /// <p>The ARN of the moderator being deleted.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventsConfiguration`.
    ///
    /// <p>Deletes the events configuration that allows a bot to receive outgoing events.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventsConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_events_configuration_input::Builder,
    }
    impl<C, M, R> DeleteEventsConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventsConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventsConfigurationInputOperationOutputAlias,
                crate::output::DeleteEventsConfigurationOutput,
                crate::error::DeleteEventsConfigurationError,
                crate::input::DeleteEventsConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMediaCapturePipeline`.
    ///
    /// <p>Deletes the media capture pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMediaCapturePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_media_capture_pipeline_input::Builder,
    }
    impl<C, M, R> DeleteMediaCapturePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMediaCapturePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMediaCapturePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMediaCapturePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMediaCapturePipelineInputOperationOutputAlias,
                crate::output::DeleteMediaCapturePipelineOutput,
                crate::error::DeleteMediaCapturePipelineError,
                crate::input::DeleteMediaCapturePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the media capture pipeline being deleted. </p>
        pub fn media_pipeline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_pipeline_id(inp);
            self
        }
        /// <p>The ID of the media capture pipeline being deleted. </p>
        pub fn set_media_pipeline_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_pipeline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMeeting`.
    ///
    /// <p>Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from
    /// joining the meeting. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
    /// <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_meeting_input::Builder,
    }
    impl<C, M, R> DeleteMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMeetingInputOperationOutputAlias,
                crate::output::DeleteMeetingOutput,
                crate::error::DeleteMeetingError,
                crate::input::DeleteMeetingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePhoneNumber`.
    ///
    /// <p>Moves the specified phone number into the <b>Deletion queue</b>. A
    /// phone number must be disassociated from any users or Amazon Chime Voice Connectors
    /// before it can be deleted.</p>
    ///
    /// <p>Deleted phone numbers remain in the
    /// <b>Deletion queue</b>
    /// for 7 days before they are deleted permanently.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_phone_number_input::Builder,
    }
    impl<C, M, R> DeletePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePhoneNumberInputOperationOutputAlias,
                crate::output::DeletePhoneNumberOutput,
                crate::error::DeletePhoneNumberError,
                crate::input::DeletePhoneNumberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(inp);
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProxySession`.
    ///
    /// <p>Deletes the specified proxy session from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProxySession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_proxy_session_input::Builder,
    }
    impl<C, M, R> DeleteProxySession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProxySession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProxySessionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProxySessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProxySessionInputOperationOutputAlias,
                crate::output::DeleteProxySessionOutput,
                crate::error::DeleteProxySessionError,
                crate::input::DeleteProxySessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proxy_session_id(inp);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proxy_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoom`.
    ///
    /// <p>Deletes a chat room in an Amazon Chime Enterprise account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_room_input::Builder,
    }
    impl<C, M, R> DeleteRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoomInputOperationOutputAlias,
                crate::output::DeleteRoomOutput,
                crate::error::DeleteRoomError,
                crate::input::DeleteRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The chat room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The chat room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoomMembership`.
    ///
    /// <p>Removes a member from a chat room in an Amazon Chime Enterprise account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRoomMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_room_membership_input::Builder,
    }
    impl<C, M, R> DeleteRoomMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoomMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoomMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoomMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoomMembershipInputOperationOutputAlias,
                crate::output::DeleteRoomMembershipOutput,
                crate::error::DeleteRoomMembershipError,
                crate::input::DeleteRoomMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSipMediaApplication`.
    ///
    /// <p>Deletes a SIP media application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSipMediaApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sip_media_application_input::Builder,
    }
    impl<C, M, R> DeleteSipMediaApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSipMediaApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSipMediaApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSipMediaApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSipMediaApplicationInputOperationOutputAlias,
                crate::output::DeleteSipMediaApplicationOutput,
                crate::error::DeleteSipMediaApplicationError,
                crate::input::DeleteSipMediaApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSipRule`.
    ///
    /// <p>Deletes a SIP rule. You must disable a SIP rule before you can delete it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSipRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sip_rule_input::Builder,
    }
    impl<C, M, R> DeleteSipRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSipRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSipRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSipRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSipRuleInputOperationOutputAlias,
                crate::output::DeleteSipRuleOutput,
                crate::error::DeleteSipRuleError,
                crate::input::DeleteSipRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_rule_id(inp);
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sip_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnector`.
    ///
    /// <p>Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the
    /// Amazon Chime Voice Connector must be disassociated from it before it can be
    /// deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorOutput,
                crate::error::DeleteVoiceConnectorError,
                crate::input::DeleteVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorEmergencyCallingConfiguration`.
    ///
    /// <p>Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnectorEmergencyCallingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_emergency_calling_configuration_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorEmergencyCallingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorEmergencyCallingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DeleteVoiceConnectorEmergencyCallingConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorEmergencyCallingConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias,
                                    crate::output::DeleteVoiceConnectorEmergencyCallingConfigurationOutput,
                                    crate::error::DeleteVoiceConnectorEmergencyCallingConfigurationError,
                                    crate::input::DeleteVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorGroup`.
    ///
    /// <p>Deletes the specified Amazon Chime Voice Connector group. Any
    /// <code>VoiceConnectorItems</code>
    /// and phone numbers associated with the group must be removed before it can be deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_group_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorGroupOutput,
                crate::error::DeleteVoiceConnectorGroupError,
                crate::input::DeleteVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorOrigination`.
    ///
    /// <p>Deletes the origination settings for the specified Amazon Chime Voice Connector.</p>
    ///
    /// <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnectorOrigination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_origination_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorOrigination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorOrigination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorOriginationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorOriginationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorOriginationInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorOriginationOutput,
                crate::error::DeleteVoiceConnectorOriginationError,
                crate::input::DeleteVoiceConnectorOriginationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorProxy`.
    ///
    /// <p>Deletes the proxy configuration from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnectorProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_proxy_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorProxyInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorProxyOutput,
                crate::error::DeleteVoiceConnectorProxyError,
                crate::input::DeleteVoiceConnectorProxyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorStreamingConfiguration`.
    ///
    /// <p>Deletes the streaming configuration for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnectorStreamingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_streaming_configuration_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorStreamingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorStreamingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorStreamingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteVoiceConnectorStreamingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorStreamingConfigurationInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorStreamingConfigurationOutput,
                crate::error::DeleteVoiceConnectorStreamingConfigurationError,
                crate::input::DeleteVoiceConnectorStreamingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorTermination`.
    ///
    /// <p>Deletes the termination settings for the specified Amazon Chime Voice Connector.</p>
    ///
    /// <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnectorTermination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_termination_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorTermination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorTerminationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVoiceConnectorTerminationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorTerminationInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorTerminationOutput,
                crate::error::DeleteVoiceConnectorTerminationError,
                crate::input::DeleteVoiceConnectorTerminationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVoiceConnectorTerminationCredentials`.
    ///
    /// <p>Deletes the specified SIP credentials used by your equipment to authenticate during call termination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVoiceConnectorTerminationCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_voice_connector_termination_credentials_input::Builder,
    }
    impl<C, M, R> DeleteVoiceConnectorTerminationCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVoiceConnectorTerminationCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVoiceConnectorTerminationCredentialsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteVoiceConnectorTerminationCredentialsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVoiceConnectorTerminationCredentialsInputOperationOutputAlias,
                crate::output::DeleteVoiceConnectorTerminationCredentialsOutput,
                crate::error::DeleteVoiceConnectorTerminationCredentialsError,
                crate::input::DeleteVoiceConnectorTerminationCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `Usernames`.
        ///
        /// To override the contents of this collection use [`set_usernames`](Self::set_usernames).
        ///
        /// <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
        pub fn usernames(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usernames(inp);
            self
        }
        /// <p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>
        pub fn set_usernames(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usernames(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstance`.
    ///
    /// <p>Returns the full details of an <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_input::Builder,
    }
    impl<C, M, R> DescribeAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceInputOperationOutputAlias,
                crate::output::DescribeAppInstanceOutput,
                crate::error::DescribeAppInstanceError,
                crate::input::DescribeAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceAdmin`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAppInstanceAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_admin_input::Builder,
    }
    impl<C, M, R> DescribeAppInstanceAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstanceAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceAdminInputOperationOutputAlias,
                crate::output::DescribeAppInstanceAdminOutput,
                crate::error::DescribeAppInstanceAdminError,
                crate::input::DescribeAppInstanceAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn app_instance_admin_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_admin_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceAdmin</code>.</p>
        pub fn set_app_instance_admin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_admin_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppInstanceUser`.
    ///
    /// <p>Returns the full details of an <code>AppInstanceUser</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeAppInstanceUserOutput,
                crate::error::DescribeAppInstanceUserError,
                crate::input::DescribeAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// <p>Returns the full details of a channel in an Amazon Chime
    /// <code>AppInstance</code>.</p>
    ///
    /// <note>
    ///
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl<C, M, R> DescribeChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelInputOperationOutputAlias,
                crate::output::DescribeChannelOutput,
                crate::error::DescribeChannelError,
                crate::input::DescribeChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelBan`.
    ///
    /// <p>Returns the full details of a channel ban.</p>
    ///
    /// <note>
    ///
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelBan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_ban_input::Builder,
    }
    impl<C, M, R> DescribeChannelBan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelBan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelBanOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelBanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelBanInputOperationOutputAlias,
                crate::output::DescribeChannelBanOutput,
                crate::error::DescribeChannelBanError,
                crate::input::DescribeChannelBanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel from which the user is banned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The ARN of the member being banned.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembership`.
    ///
    /// <p>Returns the full details of a user's channel membership.</p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_membership_input::Builder,
    }
    impl<C, M, R> DescribeChannelMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelMembershipInputOperationOutputAlias,
                crate::output::DescribeChannelMembershipOutput,
                crate::error::DescribeChannelMembershipError,
                crate::input::DescribeChannelMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the member.</p>
        pub fn member_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_arn(inp);
            self
        }
        /// <p>The ARN of the member.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelMembershipForAppInstanceUser`.
    ///
    /// <p> Returns the details of a channel based on the membership of the specified
    /// <code>AppInstanceUser</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelMembershipForAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_membership_for_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeChannelMembershipForAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelMembershipForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelMembershipForAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelMembershipForAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeChannelMembershipForAppInstanceUserOutput,
                crate::error::DescribeChannelMembershipForAppInstanceUserError,
                crate::input::DescribeChannelMembershipForAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel to which the user belongs.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the user in a channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModeratedByAppInstanceUser`.
    ///
    /// <p>Returns the full details of a channel moderated by the specified
    /// <code>AppInstanceUser</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelModeratedByAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_moderated_by_app_instance_user_input::Builder,
    }
    impl<C, M, R> DescribeChannelModeratedByAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeChannelModeratedByAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelModeratedByAppInstanceUserInputOperationOutputAlias,
                crate::output::DescribeChannelModeratedByAppInstanceUserOutput,
                crate::error::DescribeChannelModeratedByAppInstanceUserError,
                crate::input::DescribeChannelModeratedByAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the moderated channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannelModerator`.
    ///
    /// <p>Returns the full details of a single ChannelModerator.</p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannelModerator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_moderator_input::Builder,
    }
    impl<C, M, R> DescribeChannelModerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannelModerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelModeratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelModeratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelModeratorInputOperationOutputAlias,
                crate::output::DescribeChannelModeratorOutput,
                crate::error::DescribeChannelModeratorError,
                crate::input::DescribeChannelModeratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ARN of the channel moderator.</p>
        pub fn channel_moderator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_moderator_arn(inp);
            self
        }
        /// <p>The ARN of the channel moderator.</p>
        pub fn set_channel_moderator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_channel_moderator_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePhoneNumberFromUser`.
    ///
    /// <p>Disassociates the primary provisioned phone number from the specified Amazon Chime user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociatePhoneNumberFromUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_phone_number_from_user_input::Builder,
    }
    impl<C, M, R> DisassociatePhoneNumberFromUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociatePhoneNumberFromUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociatePhoneNumberFromUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociatePhoneNumberFromUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociatePhoneNumberFromUserInputOperationOutputAlias,
                crate::output::DisassociatePhoneNumberFromUserOutput,
                crate::error::DisassociatePhoneNumberFromUserError,
                crate::input::DisassociatePhoneNumberFromUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePhoneNumbersFromVoiceConnector`.
    ///
    /// <p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociatePhoneNumbersFromVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_phone_numbers_from_voice_connector_input::Builder,
    }
    impl<C, M, R> DisassociatePhoneNumbersFromVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociatePhoneNumbersFromVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociatePhoneNumbersFromVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociatePhoneNumbersFromVoiceConnectorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociatePhoneNumbersFromVoiceConnectorInputOperationOutputAlias,
                crate::output::DisassociatePhoneNumbersFromVoiceConnectorOutput,
                crate::error::DisassociatePhoneNumbersFromVoiceConnectorError,
                crate::input::DisassociatePhoneNumbersFromVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(inp);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePhoneNumbersFromVoiceConnectorGroup`.
    ///
    /// <p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociatePhoneNumbersFromVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_phone_numbers_from_voice_connector_group_input::Builder,
    }
    impl<C, M, R> DisassociatePhoneNumbersFromVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociatePhoneNumbersFromVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, aws_smithy_http::result::SdkError<crate::error::DisassociatePhoneNumbersFromVoiceConnectorGroupError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInputOperationOutputAlias,
                                    crate::output::DisassociatePhoneNumbersFromVoiceConnectorGroupOutput,
                                    crate::error::DisassociatePhoneNumbersFromVoiceConnectorGroupError,
                                    crate::input::DisassociatePhoneNumbersFromVoiceConnectorGroupInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
        /// Appends an item to `E164PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_e164_phone_numbers`](Self::set_e164_phone_numbers).
        ///
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn e164_phone_numbers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.e164_phone_numbers(inp);
            self
        }
        /// <p>List of phone numbers, in E.164 format.</p>
        pub fn set_e164_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_e164_phone_numbers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSigninDelegateGroupsFromAccount`.
    ///
    /// <p>Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateSigninDelegateGroupsFromAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_signin_delegate_groups_from_account_input::Builder,
    }
    impl<C, M, R> DisassociateSigninDelegateGroupsFromAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSigninDelegateGroupsFromAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSigninDelegateGroupsFromAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateSigninDelegateGroupsFromAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSigninDelegateGroupsFromAccountInputOperationOutputAlias,
                crate::output::DisassociateSigninDelegateGroupsFromAccountOutput,
                crate::error::DisassociateSigninDelegateGroupsFromAccountError,
                crate::input::DisassociateSigninDelegateGroupsFromAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `GroupNames`.
        ///
        /// To override the contents of this collection use [`set_group_names`](Self::set_group_names).
        ///
        /// <p>The sign-in delegate group names.</p>
        pub fn group_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_names(inp);
            self
        }
        /// <p>The sign-in delegate group names.</p>
        pub fn set_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_group_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccount`.
    ///
    /// <p>Retrieves details for the specified Amazon Chime account, such as account type and supported
    /// licenses.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_input::Builder,
    }
    impl<C, M, R> GetAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountInputOperationOutputAlias,
                crate::output::GetAccountOutput,
                crate::error::GetAccountError,
                crate::input::GetAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSettings`.
    ///
    /// <p>Retrieves account settings for the specified Amazon Chime account ID, such as remote control
    /// and dialout settings. For more information about these settings, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_settings_input::Builder,
    }
    impl<C, M, R> GetAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountSettingsInputOperationOutputAlias,
                crate::output::GetAccountSettingsOutput,
                crate::error::GetAccountSettingsError,
                crate::input::GetAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppInstanceRetentionSettings`.
    ///
    /// <p>Gets the retention settings for an <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppInstanceRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_instance_retention_settings_input::Builder,
    }
    impl<C, M, R> GetAppInstanceRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppInstanceRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInstanceRetentionSettingsInputOperationOutputAlias,
                crate::output::GetAppInstanceRetentionSettingsOutput,
                crate::error::GetAppInstanceRetentionSettingsError,
                crate::input::GetAppInstanceRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppInstanceStreamingConfigurations`.
    ///
    /// <p>Gets the streaming settings for an <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppInstanceStreamingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_instance_streaming_configurations_input::Builder,
    }
    impl<C, M, R> GetAppInstanceStreamingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppInstanceStreamingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppInstanceStreamingConfigurationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAppInstanceStreamingConfigurationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInstanceStreamingConfigurationsInputOperationOutputAlias,
                crate::output::GetAppInstanceStreamingConfigurationsOutput,
                crate::error::GetAppInstanceStreamingConfigurationsError,
                crate::input::GetAppInstanceStreamingConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAttendee`.
    ///
    /// <p>
    /// Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>
    /// .
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_attendee_input::Builder,
    }
    impl<C, M, R> GetAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAttendeeInputOperationOutputAlias,
                crate::output::GetAttendeeOutput,
                crate::error::GetAttendeeError,
                crate::input::GetAttendeeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBot`.
    ///
    /// <p>Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_input::Builder,
    }
    impl<C, M, R> GetBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotInputOperationOutputAlias,
                crate::output::GetBotOutput,
                crate::error::GetBotError,
                crate::input::GetBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannelMessage`.
    ///
    /// <p>Gets the full details of a channel message.</p>
    ///
    /// <note>
    /// <p>The x-amz-chime-bearer request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channel_message_input::Builder,
    }
    impl<C, M, R> GetChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelMessageInputOperationOutputAlias,
                crate::output::GetChannelMessageOutput,
                crate::error::GetChannelMessageError,
                crate::input::GetChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventsConfiguration`.
    ///
    /// <p>Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEventsConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_events_configuration_input::Builder,
    }
    impl<C, M, R> GetEventsConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventsConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventsConfigurationInputOperationOutputAlias,
                crate::output::GetEventsConfigurationOutput,
                crate::error::GetEventsConfigurationError,
                crate::input::GetEventsConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGlobalSettings`.
    ///
    /// <p>Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business
    /// Calling and Amazon Chime Voice Connector settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGlobalSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_global_settings_input::Builder,
    }
    impl<C, M, R> GetGlobalSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGlobalSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGlobalSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGlobalSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGlobalSettingsInputOperationOutputAlias,
                crate::output::GetGlobalSettingsOutput,
                crate::error::GetGlobalSettingsError,
                crate::input::GetGlobalSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMediaCapturePipeline`.
    ///
    /// <p>Gets an existing media capture pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMediaCapturePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_media_capture_pipeline_input::Builder,
    }
    impl<C, M, R> GetMediaCapturePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMediaCapturePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMediaCapturePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMediaCapturePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMediaCapturePipelineInputOperationOutputAlias,
                crate::output::GetMediaCapturePipelineOutput,
                crate::error::GetMediaCapturePipelineError,
                crate::input::GetMediaCapturePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline that you want to get.</p>
        pub fn media_pipeline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_pipeline_id(inp);
            self
        }
        /// <p>The ID of the pipeline that you want to get.</p>
        pub fn set_media_pipeline_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_pipeline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMeeting`.
    ///
    /// <p>
    /// Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the
    /// <i>Amazon Chime Developer Guide</i>
    /// .
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_meeting_input::Builder,
    }
    impl<C, M, R> GetMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMeetingInputOperationOutputAlias,
                crate::output::GetMeetingOutput,
                crate::error::GetMeetingError,
                crate::input::GetMeetingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMessagingSessionEndpoint`.
    ///
    /// <p>The details of the endpoint for the messaging session.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMessagingSessionEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_messaging_session_endpoint_input::Builder,
    }
    impl<C, M, R> GetMessagingSessionEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMessagingSessionEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMessagingSessionEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMessagingSessionEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMessagingSessionEndpointInputOperationOutputAlias,
                crate::output::GetMessagingSessionEndpointOutput,
                crate::error::GetMessagingSessionEndpointError,
                crate::input::GetMessagingSessionEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPhoneNumber`.
    ///
    /// <p>Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_phone_number_input::Builder,
    }
    impl<C, M, R> GetPhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPhoneNumberInputOperationOutputAlias,
                crate::output::GetPhoneNumberOutput,
                crate::error::GetPhoneNumberError,
                crate::input::GetPhoneNumberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(inp);
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPhoneNumberOrder`.
    ///
    /// <p>Retrieves details for the specified phone number order, such as the order creation timestamp, phone
    /// numbers in E.164 format, product type, and order status.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPhoneNumberOrder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_phone_number_order_input::Builder,
    }
    impl<C, M, R> GetPhoneNumberOrder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPhoneNumberOrder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPhoneNumberOrderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPhoneNumberOrderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPhoneNumberOrderInputOperationOutputAlias,
                crate::output::GetPhoneNumberOrderOutput,
                crate::error::GetPhoneNumberOrderError,
                crate::input::GetPhoneNumberOrderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the phone number order.</p>
        pub fn phone_number_order_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_order_id(inp);
            self
        }
        /// <p>The ID for the phone number order.</p>
        pub fn set_phone_number_order_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_order_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPhoneNumberSettings`.
    ///
    /// <p>Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPhoneNumberSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_phone_number_settings_input::Builder,
    }
    impl<C, M, R> GetPhoneNumberSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPhoneNumberSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPhoneNumberSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPhoneNumberSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPhoneNumberSettingsInputOperationOutputAlias,
                crate::output::GetPhoneNumberSettingsOutput,
                crate::error::GetPhoneNumberSettingsError,
                crate::input::GetPhoneNumberSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetProxySession`.
    ///
    /// <p>Gets the specified proxy session details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProxySession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_proxy_session_input::Builder,
    }
    impl<C, M, R> GetProxySession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProxySession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProxySessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProxySessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProxySessionInputOperationOutputAlias,
                crate::output::GetProxySessionOutput,
                crate::error::GetProxySessionError,
                crate::input::GetProxySessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proxy_session_id(inp);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proxy_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRetentionSettings`.
    ///
    /// <p>
    /// Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_retention_settings_input::Builder,
    }
    impl<C, M, R> GetRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRetentionSettingsInputOperationOutputAlias,
                crate::output::GetRetentionSettingsOutput,
                crate::error::GetRetentionSettingsError,
                crate::input::GetRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoom`.
    ///
    /// <p>Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_room_input::Builder,
    }
    impl<C, M, R> GetRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRoomInputOperationOutputAlias,
                crate::output::GetRoomOutput,
                crate::error::GetRoomError,
                crate::input::GetRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSipMediaApplication`.
    ///
    /// <p>Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSipMediaApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sip_media_application_input::Builder,
    }
    impl<C, M, R> GetSipMediaApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSipMediaApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSipMediaApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSipMediaApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSipMediaApplicationInputOperationOutputAlias,
                crate::output::GetSipMediaApplicationOutput,
                crate::error::GetSipMediaApplicationError,
                crate::input::GetSipMediaApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSipMediaApplicationLoggingConfiguration`.
    ///
    /// <p>Returns the logging configuration for the specified SIP media application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSipMediaApplicationLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sip_media_application_logging_configuration_input::Builder,
    }
    impl<C, M, R> GetSipMediaApplicationLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSipMediaApplicationLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSipMediaApplicationLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetSipMediaApplicationLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSipMediaApplicationLoggingConfigurationInputOperationOutputAlias,
                crate::output::GetSipMediaApplicationLoggingConfigurationOutput,
                crate::error::GetSipMediaApplicationLoggingConfigurationError,
                crate::input::GetSipMediaApplicationLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSipRule`.
    ///
    /// <p>Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSipRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sip_rule_input::Builder,
    }
    impl<C, M, R> GetSipRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSipRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSipRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSipRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSipRuleInputOperationOutputAlias,
                crate::output::GetSipRuleOutput,
                crate::error::GetSipRuleError,
                crate::input::GetSipRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_rule_id(inp);
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sip_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUser`.
    ///
    /// <p>Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.</p>
    ///
    /// <p>
    /// To retrieve user details with an email address instead of a user ID, use the
    /// <a>ListUsers</a> action, and then filter by email address.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_input::Builder,
    }
    impl<C, M, R> GetUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserInputOperationOutputAlias,
                crate::output::GetUserOutput,
                crate::error::GetUserError,
                crate::input::GetUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserSettings`.
    ///
    /// <p>Retrieves settings for the specified user ID, such as any associated phone number settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_settings_input::Builder,
    }
    impl<C, M, R> GetUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserSettingsInputOperationOutputAlias,
                crate::output::GetUserSettingsOutput,
                crate::error::GetUserSettingsError,
                crate::input::GetUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnector`.
    ///
    /// <p>Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_input::Builder,
    }
    impl<C, M, R> GetVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorInputOperationOutputAlias,
                crate::output::GetVoiceConnectorOutput,
                crate::error::GetVoiceConnectorError,
                crate::input::GetVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorEmergencyCallingConfiguration`.
    ///
    /// <p>Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorEmergencyCallingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_emergency_calling_configuration_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorEmergencyCallingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorEmergencyCallingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::GetVoiceConnectorEmergencyCallingConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorEmergencyCallingConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::GetVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias,
                                    crate::output::GetVoiceConnectorEmergencyCallingConfigurationOutput,
                                    crate::error::GetVoiceConnectorEmergencyCallingConfigurationError,
                                    crate::input::GetVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorGroup`.
    ///
    /// <p>
    /// Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated <code>VoiceConnectorItems</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_group_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::GetVoiceConnectorGroupOutput,
                crate::error::GetVoiceConnectorGroupError,
                crate::input::GetVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorLoggingConfiguration`.
    ///
    /// <p>Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_logging_configuration_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetVoiceConnectorLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorLoggingConfigurationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorLoggingConfigurationOutput,
                crate::error::GetVoiceConnectorLoggingConfigurationError,
                crate::input::GetVoiceConnectorLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorOrigination`.
    ///
    /// <p>Retrieves origination setting details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorOrigination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_origination_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorOrigination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorOrigination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorOriginationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorOriginationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorOriginationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorOriginationOutput,
                crate::error::GetVoiceConnectorOriginationError,
                crate::input::GetVoiceConnectorOriginationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorProxy`.
    ///
    /// <p>Gets the proxy configuration details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_proxy_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorProxyInputOperationOutputAlias,
                crate::output::GetVoiceConnectorProxyOutput,
                crate::error::GetVoiceConnectorProxyError,
                crate::input::GetVoiceConnectorProxyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorStreamingConfiguration`.
    ///
    /// <p>Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector.
    /// Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows
    /// the retention period, in hours, for the Amazon Kinesis data.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorStreamingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_streaming_configuration_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorStreamingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorStreamingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorStreamingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetVoiceConnectorStreamingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorStreamingConfigurationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorStreamingConfigurationOutput,
                crate::error::GetVoiceConnectorStreamingConfigurationError,
                crate::input::GetVoiceConnectorStreamingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorTermination`.
    ///
    /// <p>Retrieves termination setting details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorTermination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_termination_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorTermination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorTerminationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVoiceConnectorTerminationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorTerminationInputOperationOutputAlias,
                crate::output::GetVoiceConnectorTerminationOutput,
                crate::error::GetVoiceConnectorTerminationError,
                crate::input::GetVoiceConnectorTerminationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVoiceConnectorTerminationHealth`.
    ///
    /// <p>Retrieves information about the last time a SIP <code>OPTIONS</code> ping was received from
    /// your SIP infrastructure for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVoiceConnectorTerminationHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_voice_connector_termination_health_input::Builder,
    }
    impl<C, M, R> GetVoiceConnectorTerminationHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVoiceConnectorTerminationHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVoiceConnectorTerminationHealthOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetVoiceConnectorTerminationHealthError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVoiceConnectorTerminationHealthInputOperationOutputAlias,
                crate::output::GetVoiceConnectorTerminationHealthOutput,
                crate::error::GetVoiceConnectorTerminationHealthError,
                crate::input::GetVoiceConnectorTerminationHealthInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InviteUsers`.
    ///
    /// <p>Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime
    /// <code>Team</code> account. Only <code>Team</code> account types are currently
    /// supported for this action.</p>
    #[derive(std::fmt::Debug)]
    pub struct InviteUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invite_users_input::Builder,
    }
    impl<C, M, R> InviteUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InviteUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InviteUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::InviteUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InviteUsersInputOperationOutputAlias,
                crate::output::InviteUsersOutput,
                crate::error::InviteUsersError,
                crate::input::InviteUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `UserEmailList`.
        ///
        /// To override the contents of this collection use [`set_user_email_list`](Self::set_user_email_list).
        ///
        /// <p>The user email addresses to which to send the email invitation.</p>
        pub fn user_email_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_email_list(inp);
            self
        }
        /// <p>The user email addresses to which to send the email invitation.</p>
        pub fn set_user_email_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_email_list(input);
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, inp: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(inp);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccounts`.
    ///
    /// <p>Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts
    /// by account name prefix. To find out which Amazon Chime account a user belongs to, you can
    /// filter by the user's email address, which returns one account result.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_accounts_input::Builder,
    }
    impl<C, M, R> ListAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountsInputOperationOutputAlias,
                crate::output::ListAccountsOutput,
                crate::error::ListAccountsError,
                crate::input::ListAccountsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Chime account name prefix with which to filter results.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Amazon Chime account name prefix with which to filter results.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>User email address with which to filter results.</p>
        pub fn user_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_email(inp);
            self
        }
        /// <p>User email address with which to filter results.</p>
        pub fn set_user_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_email(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceAdmins`.
    ///
    /// <p>Returns a list of the administrators in the <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppInstanceAdmins<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instance_admins_input::Builder,
    }
    impl<C, M, R> ListAppInstanceAdmins<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstanceAdmins`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceAdminsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceAdminsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstanceAdminsInputOperationOutputAlias,
                crate::output::ListAppInstanceAdminsOutput,
                crate::error::ListAppInstanceAdminsError,
                crate::input::ListAppInstanceAdminsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of administrators that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned from previous API requests until the number of administrators is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstances`.
    ///
    /// <p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instances_input::Builder,
    }
    impl<C, M, R> ListAppInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstancesInputOperationOutputAlias,
                crate::output::ListAppInstancesOutput,
                crate::error::ListAppInstancesError,
                crate::input::ListAppInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of <code>AppInstance</code>s that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppInstanceUsers`.
    ///
    /// <p>List all <code>AppInstanceUsers</code>
    /// created under a single <code>AppInstance</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAppInstanceUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_instance_users_input::Builder,
    }
    impl<C, M, R> ListAppInstanceUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppInstanceUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppInstanceUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppInstanceUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppInstanceUsersInputOperationOutputAlias,
                crate::output::ListAppInstanceUsersOutput,
                crate::error::ListAppInstanceUsersError,
                crate::input::ListAppInstanceUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of requests that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested users are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttendees`.
    ///
    /// <p>
    /// Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the <i>Amazon Chime Developer Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAttendees<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attendees_input::Builder,
    }
    impl<C, M, R> ListAttendees<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttendees`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttendeesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttendeesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttendeesInputOperationOutputAlias,
                crate::output::ListAttendeesOutput,
                crate::error::ListAttendeesError,
                crate::input::ListAttendeesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttendeeTags`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK attendee resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAttendeeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attendee_tags_input::Builder,
    }
    impl<C, M, R> ListAttendeeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttendeeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttendeeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttendeeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttendeeTagsInputOperationOutputAlias,
                crate::output::ListAttendeeTagsOutput,
                crate::error::ListAttendeeTagsError,
                crate::input::ListAttendeeTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBots`.
    ///
    /// <p>Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bots_input::Builder,
    }
    impl<C, M, R> ListBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotsInputOperationOutputAlias,
                crate::output::ListBotsOutput,
                crate::error::ListBotsError,
                crate::input::ListBotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelBans`.
    ///
    /// <p>Lists all the users banned from a particular channel.</p>
    ///
    /// <note>
    ///
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelBans<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_bans_input::Builder,
    }
    impl<C, M, R> ListChannelBans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelBans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelBansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelBansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelBansInputOperationOutputAlias,
                crate::output::ListChannelBansOutput,
                crate::error::ListChannelBansError,
                crate::input::ListChannelBansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of bans that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested bans are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMemberships`.
    ///
    /// <p>Lists all channel memberships in a channel.</p>
    ///
    /// <note>
    ///
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_memberships_input::Builder,
    }
    impl<C, M, R> ListChannelMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMembershipsInputOperationOutputAlias,
                crate::output::ListChannelMembershipsOutput,
                crate::error::ListChannelMembershipsError,
                crate::input::ListChannelMembershipsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMembershipType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default
        /// members are always returned as part of <code>ListChannelMemberships</code>. Hidden members
        /// are only returned if the type filter in <code>ListChannelMemberships</code> equals
        /// <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMembershipType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channel memberships that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are
        /// returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested channel memberships are
        /// returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMembershipsForAppInstanceUser`.
    ///
    /// <p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an
    /// <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelMembershipsForAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_memberships_for_app_instance_user_input::Builder,
    }
    impl<C, M, R> ListChannelMembershipsForAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMembershipsForAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMembershipsForAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelMembershipsForAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMembershipsForAppInstanceUserInputOperationOutputAlias,
                crate::output::ListChannelMembershipsForAppInstanceUserOutput,
                crate::error::ListChannelMembershipsForAppInstanceUserError,
                crate::input::ListChannelMembershipsForAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>s</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of users that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned from previous API requests until the number of channel memberships is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelMessages`.
    ///
    /// <p>List all the messages in a channel. Returns a paginated list of
    /// <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending
    /// order.</p>
    /// <note>
    /// <p>Redacted messages appear in the results as empty, since they are only redacted, not
    /// deleted. Deleted messages do not appear in the results. This action always returns the
    /// latest version of an edited message.</p>
    /// <p>Also, the x-amz-chime-bearer request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_messages_input::Builder,
    }
    impl<C, M, R> ListChannelMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelMessagesInputOperationOutputAlias,
                crate::output::ListChannelMessagesOutput,
                crate::error::ListChannelMessagesError,
                crate::input::ListChannelMessagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time
        /// created.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The order in which you want messages sorted. Default is Descending, based on time
        /// created.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn not_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.not_before(inp);
            self
        }
        /// <p>The initial or starting time stamp for your requested messages.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_not_before(input);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn not_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.not_after(inp);
            self
        }
        /// <p>The final or ending time stamp for your requested messages.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_not_after(input);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of messages that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested messages are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelModerators`.
    ///
    /// <p>Lists all the moderators for a channel.</p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelModerators<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channel_moderators_input::Builder,
    }
    impl<C, M, R> ListChannelModerators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelModerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelModeratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelModeratorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelModeratorsInputOperationOutputAlias,
                crate::output::ListChannelModeratorsOutput,
                crate::error::ListChannelModeratorsError,
                crate::input::ListChannelModeratorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of moderators that you want returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are
        /// returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested moderators are
        /// returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Lists all Channels created under a single Chime App as a paginated list. You can specify
    /// filters to narrow results.</p>
    ///
    /// <p class="title">
    /// <b>Functionality & restrictions</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the
    /// account.</p>
    /// </li>
    /// <li>
    /// <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to
    /// list the private channels in an account.</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels.
        /// <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code>
        /// can retrieve private channels. </p>
        pub fn privacy(mut self, inp: crate::model::ChannelPrivacy) -> Self {
            self.inner = self.inner.privacy(inp);
            self
        }
        /// <p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels.
        /// <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code>
        /// can retrieve private channels. </p>
        pub fn set_privacy(
            mut self,
            input: std::option::Option<crate::model::ChannelPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_privacy(input);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channels that you want to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token passed by previous API calls until all requested channels are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannelsModeratedByAppInstanceUser`.
    ///
    /// <p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListChannelsModeratedByAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_moderated_by_app_instance_user_input::Builder,
    }
    impl<C, M, R> ListChannelsModeratedByAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannelsModeratedByAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsModeratedByAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListChannelsModeratedByAppInstanceUserError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsModeratedByAppInstanceUserInputOperationOutputAlias,
                crate::output::ListChannelsModeratedByAppInstanceUserOutput,
                crate::error::ListChannelsModeratedByAppInstanceUserError,
                crate::input::ListChannelsModeratedByAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the user in the moderated channel.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of channels in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by
        /// the user is reached.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned from previous API requests until the number of channels moderated by
        /// the user is reached.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMediaCapturePipelines`.
    ///
    /// <p>Returns a list of media capture pipelines.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMediaCapturePipelines<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_media_capture_pipelines_input::Builder,
    }
    impl<C, M, R> ListMediaCapturePipelines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMediaCapturePipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMediaCapturePipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMediaCapturePipelinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMediaCapturePipelinesInputOperationOutputAlias,
                crate::output::ListMediaCapturePipelinesOutput,
                crate::error::ListMediaCapturePipelinesError,
                crate::input::ListMediaCapturePipelinesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMeetings`.
    ///
    /// <p>
    /// Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a>
    /// in the <i>Amazon Chime Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMeetings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_meetings_input::Builder,
    }
    impl<C, M, R> ListMeetings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMeetings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMeetingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMeetingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMeetingsInputOperationOutputAlias,
                crate::output::ListMeetingsOutput,
                crate::error::ListMeetingsError,
                crate::input::ListMeetingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMeetingTags`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMeetingTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_meeting_tags_input::Builder,
    }
    impl<C, M, R> ListMeetingTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMeetingTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMeetingTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMeetingTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMeetingTagsInputOperationOutputAlias,
                crate::output::ListMeetingTagsOutput,
                crate::error::ListMeetingTagsError,
                crate::input::ListMeetingTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPhoneNumberOrders`.
    ///
    /// <p>Lists the phone number orders for the administrator's Amazon Chime account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPhoneNumberOrders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_phone_number_orders_input::Builder,
    }
    impl<C, M, R> ListPhoneNumberOrders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPhoneNumberOrders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPhoneNumberOrdersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPhoneNumberOrdersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPhoneNumberOrdersInputOperationOutputAlias,
                crate::output::ListPhoneNumberOrdersOutput,
                crate::error::ListPhoneNumberOrdersError,
                crate::input::ListPhoneNumberOrdersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPhoneNumbers`.
    ///
    /// <p>Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPhoneNumbers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_phone_numbers_input::Builder,
    }
    impl<C, M, R> ListPhoneNumbers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPhoneNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPhoneNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPhoneNumbersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPhoneNumbersInputOperationOutputAlias,
                crate::output::ListPhoneNumbersOutput,
                crate::error::ListPhoneNumbersError,
                crate::input::ListPhoneNumbersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number status.</p>
        pub fn status(mut self, inp: crate::model::PhoneNumberStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The phone number status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, inp: crate::model::PhoneNumberProductType) -> Self {
            self.inner = self.inner.product_type(inp);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// <p>The filter to use to limit the number of results.</p>
        pub fn filter_name(mut self, inp: crate::model::PhoneNumberAssociationName) -> Self {
            self.inner = self.inner.filter_name(inp);
            self
        }
        /// <p>The filter to use to limit the number of results.</p>
        pub fn set_filter_name(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberAssociationName>,
        ) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
        /// <p>The value to use for the filter.</p>
        pub fn filter_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_value(inp);
            self
        }
        /// <p>The value to use for the filter.</p>
        pub fn set_filter_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_value(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProxySessions`.
    ///
    /// <p>Lists the proxy sessions for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProxySessions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_proxy_sessions_input::Builder,
    }
    impl<C, M, R> ListProxySessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProxySessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProxySessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProxySessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProxySessionsInputOperationOutputAlias,
                crate::output::ListProxySessionsOutput,
                crate::error::ListProxySessionsError,
                crate::input::ListProxySessionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The proxy session status.</p>
        pub fn status(mut self, inp: crate::model::ProxySessionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The proxy session status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProxySessionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoomMemberships`.
    ///
    /// <p>Lists the membership details for the specified room in an Amazon Chime Enterprise account,
    /// such as the members' IDs, email addresses, and names.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRoomMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_room_memberships_input::Builder,
    }
    impl<C, M, R> ListRoomMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoomMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoomMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoomMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoomMembershipsInputOperationOutputAlias,
                crate::output::ListRoomMembershipsOutput,
                crate::error::ListRoomMembershipsError,
                crate::input::ListRoomMembershipsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRooms`.
    ///
    /// <p>Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRooms<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rooms_input::Builder,
    }
    impl<C, M, R> ListRooms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRooms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoomsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoomsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoomsInputOperationOutputAlias,
                crate::output::ListRoomsOutput,
                crate::error::ListRoomsError,
                crate::input::ListRoomsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The member ID (user ID or bot ID).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSipMediaApplications`.
    ///
    /// <p>Lists the SIP media applications under the administrator's AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSipMediaApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_sip_media_applications_input::Builder,
    }
    impl<C, M, R> ListSipMediaApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSipMediaApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSipMediaApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSipMediaApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSipMediaApplicationsInputOperationOutputAlias,
                crate::output::ListSipMediaApplicationsOutput,
                crate::error::ListSipMediaApplicationsError,
                crate::input::ListSipMediaApplicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSipRules`.
    ///
    /// <p>Lists the SIP rules under the administrator's AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSipRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_sip_rules_input::Builder,
    }
    impl<C, M, R> ListSipRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSipRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSipRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSipRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSipRulesInputOperationOutputAlias,
                crate::output::ListSipRulesOutput,
                crate::error::ListSipRulesError,
                crate::input::ListSipRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSupportedPhoneNumberCountries`.
    ///
    /// <p>Lists supported phone number countries.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSupportedPhoneNumberCountries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_supported_phone_number_countries_input::Builder,
    }
    impl<C, M, R> ListSupportedPhoneNumberCountries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSupportedPhoneNumberCountries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSupportedPhoneNumberCountriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSupportedPhoneNumberCountriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSupportedPhoneNumberCountriesInputOperationOutputAlias,
                crate::output::ListSupportedPhoneNumberCountriesOutput,
                crate::error::ListSupportedPhoneNumberCountriesError,
                crate::input::ListSupportedPhoneNumberCountriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number product type.</p>
        pub fn product_type(mut self, inp: crate::model::PhoneNumberProductType) -> Self {
            self.inner = self.inner.product_type(inp);
            self
        }
        /// <p>The phone number product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Lists the users that belong to the specified Amazon Chime account. You can specify an email
    /// address to list only the user that the email address belongs to.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Optional. The user email address used to filter results. Maximum 1.</p>
        pub fn user_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_email(inp);
            self
        }
        /// <p>Optional. The user email address used to filter results. Maximum 1.</p>
        pub fn set_user_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_email(input);
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, inp: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(inp);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. Defaults to 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVoiceConnectorGroups`.
    ///
    /// <p>Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVoiceConnectorGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_voice_connector_groups_input::Builder,
    }
    impl<C, M, R> ListVoiceConnectorGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVoiceConnectorGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVoiceConnectorGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVoiceConnectorGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVoiceConnectorGroupsInputOperationOutputAlias,
                crate::output::ListVoiceConnectorGroupsOutput,
                crate::error::ListVoiceConnectorGroupsError,
                crate::input::ListVoiceConnectorGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVoiceConnectors`.
    ///
    /// <p>Lists the Amazon Chime Voice Connectors for the administrator's AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVoiceConnectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_voice_connectors_input::Builder,
    }
    impl<C, M, R> ListVoiceConnectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVoiceConnectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVoiceConnectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVoiceConnectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVoiceConnectorsInputOperationOutputAlias,
                crate::output::ListVoiceConnectorsOutput,
                crate::error::ListVoiceConnectorsError,
                crate::input::ListVoiceConnectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVoiceConnectorTerminationCredentials`.
    ///
    /// <p>Lists the SIP credentials for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVoiceConnectorTerminationCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_voice_connector_termination_credentials_input::Builder,
    }
    impl<C, M, R> ListVoiceConnectorTerminationCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVoiceConnectorTerminationCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVoiceConnectorTerminationCredentialsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListVoiceConnectorTerminationCredentialsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVoiceConnectorTerminationCredentialsInputOperationOutputAlias,
                crate::output::ListVoiceConnectorTerminationCredentialsOutput,
                crate::error::ListVoiceConnectorTerminationCredentialsError,
                crate::input::ListVoiceConnectorTerminationCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LogoutUser`.
    ///
    /// <p>Logs out the specified user from all of the devices they are currently logged into.</p>
    #[derive(std::fmt::Debug)]
    pub struct LogoutUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::logout_user_input::Builder,
    }
    impl<C, M, R> LogoutUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LogoutUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LogoutUserOutput,
            aws_smithy_http::result::SdkError<crate::error::LogoutUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LogoutUserInputOperationOutputAlias,
                crate::output::LogoutUserOutput,
                crate::error::LogoutUserError,
                crate::input::LogoutUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppInstanceRetentionSettings`.
    ///
    /// <p>Sets the amount of time in days that a given <code>AppInstance</code> retains data.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAppInstanceRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_instance_retention_settings_input::Builder,
    }
    impl<C, M, R> PutAppInstanceRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppInstanceRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppInstanceRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppInstanceRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppInstanceRetentionSettingsInputOperationOutputAlias,
                crate::output::PutAppInstanceRetentionSettingsOutput,
                crate::error::PutAppInstanceRetentionSettingsError,
                crate::input::PutAppInstanceRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn app_instance_retention_settings(
            mut self,
            inp: crate::model::AppInstanceRetentionSettings,
        ) -> Self {
            self.inner = self.inner.app_instance_retention_settings(inp);
            self
        }
        /// <p>The time in days to retain data. Data type: number.</p>
        pub fn set_app_instance_retention_settings(
            mut self,
            input: std::option::Option<crate::model::AppInstanceRetentionSettings>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_retention_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppInstanceStreamingConfigurations`.
    ///
    /// <p>The data streaming configurations of an <code>AppInstance</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAppInstanceStreamingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_instance_streaming_configurations_input::Builder,
    }
    impl<C, M, R> PutAppInstanceStreamingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppInstanceStreamingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppInstanceStreamingConfigurationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAppInstanceStreamingConfigurationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppInstanceStreamingConfigurationsInputOperationOutputAlias,
                crate::output::PutAppInstanceStreamingConfigurationsOutput,
                crate::error::PutAppInstanceStreamingConfigurationsError,
                crate::input::PutAppInstanceStreamingConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// Appends an item to `AppInstanceStreamingConfigurations`.
        ///
        /// To override the contents of this collection use [`set_app_instance_streaming_configurations`](Self::set_app_instance_streaming_configurations).
        ///
        /// <p>The streaming configurations set for an <code>AppInstance</code>.</p>
        pub fn app_instance_streaming_configurations(
            mut self,
            inp: impl Into<crate::model::AppInstanceStreamingConfiguration>,
        ) -> Self {
            self.inner = self.inner.app_instance_streaming_configurations(inp);
            self
        }
        /// <p>The streaming configurations set for an <code>AppInstance</code>.</p>
        pub fn set_app_instance_streaming_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AppInstanceStreamingConfiguration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_app_instance_streaming_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEventsConfiguration`.
    ///
    /// <p>Creates an events configuration that allows a bot to receive outgoing events sent by Amazon
    /// Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information,
    /// see <a>Bot</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEventsConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_events_configuration_input::Builder,
    }
    impl<C, M, R> PutEventsConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEventsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventsConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventsConfigurationInputOperationOutputAlias,
                crate::output::PutEventsConfigurationOutput,
                crate::error::PutEventsConfigurationError,
                crate::input::PutEventsConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>HTTPS endpoint that allows the bot to receive outgoing events.</p>
        pub fn outbound_events_https_endpoint(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.outbound_events_https_endpoint(inp);
            self
        }
        /// <p>HTTPS endpoint that allows the bot to receive outgoing events.</p>
        pub fn set_outbound_events_https_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_outbound_events_https_endpoint(input);
            self
        }
        /// <p>Lambda function ARN that allows the bot to receive outgoing events.</p>
        pub fn lambda_function_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lambda_function_arn(inp);
            self
        }
        /// <p>Lambda function ARN that allows the bot to receive outgoing events.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lambda_function_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRetentionSettings`.
    ///
    /// <p>
    /// Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS CloudTrail</a>
    /// in the <i>Amazon Chime Administration Guide</i>.</p>
    ///
    /// <p>
    /// To turn off existing retention settings, remove the number of days from the corresponding
    /// <b>RetentionDays</b>
    /// field in the
    /// <b>RetentionSettings</b>
    /// object. For more information about retention settings, see
    /// <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a>
    /// in the <i>Amazon Chime Administration Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRetentionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_retention_settings_input::Builder,
    }
    impl<C, M, R> PutRetentionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRetentionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRetentionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRetentionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRetentionSettingsInputOperationOutputAlias,
                crate::output::PutRetentionSettingsOutput,
                crate::error::PutRetentionSettingsError,
                crate::input::PutRetentionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The retention settings.</p>
        pub fn retention_settings(mut self, inp: crate::model::RetentionSettings) -> Self {
            self.inner = self.inner.retention_settings(inp);
            self
        }
        /// <p>The retention settings.</p>
        pub fn set_retention_settings(
            mut self,
            input: std::option::Option<crate::model::RetentionSettings>,
        ) -> Self {
            self.inner = self.inner.set_retention_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSipMediaApplicationLoggingConfiguration`.
    ///
    /// <p>Updates the logging configuration for the specified SIP media application.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutSipMediaApplicationLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_sip_media_application_logging_configuration_input::Builder,
    }
    impl<C, M, R> PutSipMediaApplicationLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSipMediaApplicationLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSipMediaApplicationLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutSipMediaApplicationLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSipMediaApplicationLoggingConfigurationInputOperationOutputAlias,
                crate::output::PutSipMediaApplicationLoggingConfigurationOutput,
                crate::error::PutSipMediaApplicationLoggingConfigurationError,
                crate::input::PutSipMediaApplicationLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// <p>The actual logging configuration.</p>
        pub fn sip_media_application_logging_configuration(
            mut self,
            inp: crate::model::SipMediaApplicationLoggingConfiguration,
        ) -> Self {
            self.inner = self.inner.sip_media_application_logging_configuration(inp);
            self
        }
        /// <p>The actual logging configuration.</p>
        pub fn set_sip_media_application_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::SipMediaApplicationLoggingConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_sip_media_application_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorEmergencyCallingConfiguration`.
    ///
    /// <p>Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for
    /// the Amazon Chime Voice Connector before emergency calling can be configured.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutVoiceConnectorEmergencyCallingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_emergency_calling_configuration_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorEmergencyCallingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorEmergencyCallingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::PutVoiceConnectorEmergencyCallingConfigurationOutput, aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorEmergencyCallingConfigurationError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::PutVoiceConnectorEmergencyCallingConfigurationInputOperationOutputAlias,
                                    crate::output::PutVoiceConnectorEmergencyCallingConfigurationOutput,
                                    crate::error::PutVoiceConnectorEmergencyCallingConfigurationError,
                                    crate::input::PutVoiceConnectorEmergencyCallingConfigurationInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The emergency calling configuration details.</p>
        pub fn emergency_calling_configuration(
            mut self,
            inp: crate::model::EmergencyCallingConfiguration,
        ) -> Self {
            self.inner = self.inner.emergency_calling_configuration(inp);
            self
        }
        /// <p>The emergency calling configuration details.</p>
        pub fn set_emergency_calling_configuration(
            mut self,
            input: std::option::Option<crate::model::EmergencyCallingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_emergency_calling_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorLoggingConfiguration`.
    ///
    /// <p>Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutVoiceConnectorLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_logging_configuration_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutVoiceConnectorLoggingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorLoggingConfigurationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorLoggingConfigurationOutput,
                crate::error::PutVoiceConnectorLoggingConfigurationError,
                crate::input::PutVoiceConnectorLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The logging configuration details to add.</p>
        pub fn logging_configuration(mut self, inp: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(inp);
            self
        }
        /// <p>The logging configuration details to add.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorOrigination`.
    ///
    /// <p>Adds origination settings for the specified Amazon Chime Voice Connector.</p>
    ///
    /// <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutVoiceConnectorOrigination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_origination_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorOrigination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorOrigination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorOriginationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorOriginationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorOriginationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorOriginationOutput,
                crate::error::PutVoiceConnectorOriginationError,
                crate::input::PutVoiceConnectorOriginationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The origination setting details to add.</p>
        pub fn origination(mut self, inp: crate::model::Origination) -> Self {
            self.inner = self.inner.origination(inp);
            self
        }
        /// <p>The origination setting details to add.</p>
        pub fn set_origination(
            mut self,
            input: std::option::Option<crate::model::Origination>,
        ) -> Self {
            self.inner = self.inner.set_origination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorProxy`.
    ///
    /// <p>Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutVoiceConnectorProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_proxy_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorProxyInputOperationOutputAlias,
                crate::output::PutVoiceConnectorProxyOutput,
                crate::error::PutVoiceConnectorProxyError,
                crate::input::PutVoiceConnectorProxyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The default number of minutes allowed for proxy sessions.</p>
        pub fn default_session_expiry_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.default_session_expiry_minutes(inp);
            self
        }
        /// <p>The default number of minutes allowed for proxy sessions.</p>
        pub fn set_default_session_expiry_minutes(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_default_session_expiry_minutes(input);
            self
        }
        /// Appends an item to `PhoneNumberPoolCountries`.
        ///
        /// To override the contents of this collection use [`set_phone_number_pool_countries`](Self::set_phone_number_pool_countries).
        ///
        /// <p>The countries for proxy phone numbers to be selected from.</p>
        pub fn phone_number_pool_countries(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_pool_countries(inp);
            self
        }
        /// <p>The countries for proxy phone numbers to be selected from.</p>
        pub fn set_phone_number_pool_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_pool_countries(input);
            self
        }
        /// <p>The phone number to route calls to after a proxy session expires.</p>
        pub fn fall_back_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fall_back_phone_number(inp);
            self
        }
        /// <p>The phone number to route calls to after a proxy session expires.</p>
        pub fn set_fall_back_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fall_back_phone_number(input);
            self
        }
        /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
        pub fn disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.disabled(inp);
            self
        }
        /// <p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorStreamingConfiguration`.
    ///
    /// <p>Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming
    /// configuration specifies whether media streaming is enabled for sending to Indonesians.
    /// It also sets the retention period, in hours, for the Amazon Kinesis data.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutVoiceConnectorStreamingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_streaming_configuration_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorStreamingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorStreamingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorStreamingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutVoiceConnectorStreamingConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorStreamingConfigurationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorStreamingConfigurationOutput,
                crate::error::PutVoiceConnectorStreamingConfigurationError,
                crate::input::PutVoiceConnectorStreamingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The streaming configuration details to add.</p>
        pub fn streaming_configuration(
            mut self,
            inp: crate::model::StreamingConfiguration,
        ) -> Self {
            self.inner = self.inner.streaming_configuration(inp);
            self
        }
        /// <p>The streaming configuration details to add.</p>
        pub fn set_streaming_configuration(
            mut self,
            input: std::option::Option<crate::model::StreamingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_streaming_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorTermination`.
    ///
    /// <p>Adds termination settings for the specified Amazon Chime Voice Connector.</p>
    ///
    /// <note>
    /// <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutVoiceConnectorTermination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_termination_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorTermination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorTermination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorTerminationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutVoiceConnectorTerminationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorTerminationInputOperationOutputAlias,
                crate::output::PutVoiceConnectorTerminationOutput,
                crate::error::PutVoiceConnectorTerminationError,
                crate::input::PutVoiceConnectorTerminationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The termination setting details to add.</p>
        pub fn termination(mut self, inp: crate::model::Termination) -> Self {
            self.inner = self.inner.termination(inp);
            self
        }
        /// <p>The termination setting details to add.</p>
        pub fn set_termination(
            mut self,
            input: std::option::Option<crate::model::Termination>,
        ) -> Self {
            self.inner = self.inner.set_termination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVoiceConnectorTerminationCredentials`.
    ///
    /// <p>Adds termination SIP credentials for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutVoiceConnectorTerminationCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_voice_connector_termination_credentials_input::Builder,
    }
    impl<C, M, R> PutVoiceConnectorTerminationCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVoiceConnectorTerminationCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVoiceConnectorTerminationCredentialsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutVoiceConnectorTerminationCredentialsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVoiceConnectorTerminationCredentialsInputOperationOutputAlias,
                crate::output::PutVoiceConnectorTerminationCredentialsOutput,
                crate::error::PutVoiceConnectorTerminationCredentialsError,
                crate::input::PutVoiceConnectorTerminationCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// Appends an item to `Credentials`.
        ///
        /// To override the contents of this collection use [`set_credentials`](Self::set_credentials).
        ///
        /// <p>The termination SIP credentials.</p>
        pub fn credentials(mut self, inp: impl Into<crate::model::Credential>) -> Self {
            self.inner = self.inner.credentials(inp);
            self
        }
        /// <p>The termination SIP credentials.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Credential>>,
        ) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactChannelMessage`.
    ///
    /// <p>Redacts message content, but not metadata. The message exists in the back end, but the
    /// action returns null content, and the state shows as redacted.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RedactChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::redact_channel_message_input::Builder,
    }
    impl<C, M, R> RedactChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RedactChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RedactChannelMessageInputOperationOutputAlias,
                crate::output::RedactChannelMessageOutput,
                crate::error::RedactChannelMessageError,
                crate::input::RedactChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel containing the messages that you want to redact.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID of the message being redacted.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactConversationMessage`.
    ///
    /// <p>Redacts the specified message from the specified Amazon Chime conversation.</p>
    #[derive(std::fmt::Debug)]
    pub struct RedactConversationMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::redact_conversation_message_input::Builder,
    }
    impl<C, M, R> RedactConversationMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RedactConversationMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactConversationMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactConversationMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RedactConversationMessageInputOperationOutputAlias,
                crate::output::RedactConversationMessageOutput,
                crate::error::RedactConversationMessageError,
                crate::input::RedactConversationMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The conversation ID.</p>
        pub fn conversation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conversation_id(inp);
            self
        }
        /// <p>The conversation ID.</p>
        pub fn set_conversation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conversation_id(input);
            self
        }
        /// <p>The message ID.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The message ID.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RedactRoomMessage`.
    ///
    /// <p>Redacts the specified message from the specified Amazon Chime channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct RedactRoomMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::redact_room_message_input::Builder,
    }
    impl<C, M, R> RedactRoomMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RedactRoomMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RedactRoomMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::RedactRoomMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RedactRoomMessageInputOperationOutputAlias,
                crate::output::RedactRoomMessageOutput,
                crate::error::RedactRoomMessageError,
                crate::input::RedactRoomMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The message ID.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The message ID.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegenerateSecurityToken`.
    ///
    /// <p>Regenerates the security token for a bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegenerateSecurityToken<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::regenerate_security_token_input::Builder,
    }
    impl<C, M, R> RegenerateSecurityToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegenerateSecurityToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegenerateSecurityTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::RegenerateSecurityTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegenerateSecurityTokenInputOperationOutputAlias,
                crate::output::RegenerateSecurityTokenOutput,
                crate::error::RegenerateSecurityTokenError,
                crate::input::RegenerateSecurityTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetPersonalPIN`.
    ///
    /// <p>Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns
    /// the <a>User</a> object with the updated personal meeting PIN.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetPersonalPIN<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_personal_pin_input::Builder,
    }
    impl<C, M, R> ResetPersonalPIN<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetPersonalPIN`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetPersonalPinOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetPersonalPINError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetPersonalPinInputOperationOutputAlias,
                crate::output::ResetPersonalPinOutput,
                crate::error::ResetPersonalPINError,
                crate::input::ResetPersonalPinInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestorePhoneNumber`.
    ///
    /// <p>Moves a phone number from the <b>Deletion queue</b> back into the
    /// phone number <b>Inventory</b>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestorePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_phone_number_input::Builder,
    }
    impl<C, M, R> RestorePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestorePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestorePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::RestorePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestorePhoneNumberInputOperationOutputAlias,
                crate::output::RestorePhoneNumberOutput,
                crate::error::RestorePhoneNumberError,
                crate::input::RestorePhoneNumberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number.</p>
        pub fn phone_number_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(inp);
            self
        }
        /// <p>The phone number.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchAvailablePhoneNumbers`.
    ///
    /// <p>Searches for phone numbers that can be ordered. For US numbers, provide at least one of
    /// the following search filters: <code>AreaCode</code>, <code>City</code>,
    /// <code>State</code>, or <code>TollFreePrefix</code>. If you provide
    /// <code>City</code>, you must also provide <code>State</code>. Numbers outside the US only
    /// support the <code>PhoneNumberType</code> filter, which you must use.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchAvailablePhoneNumbers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_available_phone_numbers_input::Builder,
    }
    impl<C, M, R> SearchAvailablePhoneNumbers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchAvailablePhoneNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchAvailablePhoneNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchAvailablePhoneNumbersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchAvailablePhoneNumbersInputOperationOutputAlias,
                crate::output::SearchAvailablePhoneNumbersOutput,
                crate::error::SearchAvailablePhoneNumbersError,
                crate::input::SearchAvailablePhoneNumbersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The area code used to filter results. Only applies to the US.</p>
        pub fn area_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.area_code(inp);
            self
        }
        /// <p>The area code used to filter results. Only applies to the US.</p>
        pub fn set_area_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_area_code(input);
            self
        }
        /// <p>The city used to filter results. Only applies to the US.</p>
        pub fn city(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.city(inp);
            self
        }
        /// <p>The city used to filter results. Only applies to the US.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_city(input);
            self
        }
        /// <p>The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.</p>
        pub fn country(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.country(inp);
            self
        }
        /// <p>The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_country(input);
            self
        }
        /// <p>The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.</p>
        pub fn state(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The toll-free prefix that you use to filter results. Only applies to the US.</p>
        pub fn toll_free_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.toll_free_prefix(inp);
            self
        }
        /// <p>The toll-free prefix that you use to filter results. Only applies to the US.</p>
        pub fn set_toll_free_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_toll_free_prefix(input);
            self
        }
        /// <p>The phone number type used to filter results. Required for non-US numbers.</p>
        pub fn phone_number_type(mut self, inp: crate::model::PhoneNumberType) -> Self {
            self.inner = self.inner.phone_number_type(inp);
            self
        }
        /// <p>The phone number type used to filter results. Required for non-US numbers.</p>
        pub fn set_phone_number_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberType>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_type(input);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token used to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendChannelMessage`.
    ///
    /// <p>Sends a message to a particular channel that the member is a part of.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    ///
    /// <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata.
    /// <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SendChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_channel_message_input::Builder,
    }
    impl<C, M, R> SendChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendChannelMessageInputOperationOutputAlias,
                crate::output::SendChannelMessageOutput,
                crate::error::SendChannelMessageError,
                crate::input::SendChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ChannelMessageType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ChannelMessageType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn persistence(mut self, inp: crate::model::ChannelMessagePersistenceType) -> Self {
            self.inner = self.inner.persistence(inp);
            self
        }
        /// <p>Boolean that controls whether the message is persisted on the back end. Required.</p>
        pub fn set_persistence(
            mut self,
            input: std::option::Option<crate::model::ChannelMessagePersistenceType>,
        ) -> Self {
            self.inner = self.inner.set_persistence(input);
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The optional metadata for each message.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The <code>Idempotency</code> token for each client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMeetingTranscription`.
    ///
    /// <p>Starts transcription for the specified <code>meetingId</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartMeetingTranscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_meeting_transcription_input::Builder,
    }
    impl<C, M, R> StartMeetingTranscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMeetingTranscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMeetingTranscriptionInputOperationOutputAlias,
                crate::output::StartMeetingTranscriptionOutput,
                crate::error::StartMeetingTranscriptionError,
                crate::input::StartMeetingTranscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The unique ID of the meeting being transcribed.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn transcription_configuration(
            mut self,
            inp: crate::model::TranscriptionConfiguration,
        ) -> Self {
            self.inner = self.inner.transcription_configuration(inp);
            self
        }
        /// <p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>
        pub fn set_transcription_configuration(
            mut self,
            input: std::option::Option<crate::model::TranscriptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_transcription_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopMeetingTranscription`.
    ///
    /// <p>Stops transcription for the specified <code>meetingId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopMeetingTranscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_meeting_transcription_input::Builder,
    }
    impl<C, M, R> StopMeetingTranscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopMeetingTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopMeetingTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopMeetingTranscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopMeetingTranscriptionInputOperationOutputAlias,
                crate::output::StopMeetingTranscriptionOutput,
                crate::error::StopMeetingTranscriptionError,
                crate::input::StopMeetingTranscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The unique ID of the meeting for which you stop transcription.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagAttendee`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK attendee.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_attendee_input::Builder,
    }
    impl<C, M, R> TagAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::TagAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagAttendeeInputOperationOutputAlias,
                crate::output::TagAttendeeOutput,
                crate::error::TagAttendeeError,
                crate::input::TagAttendeeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagMeeting`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK meeting.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_meeting_input::Builder,
    }
    impl<C, M, R> TagMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::TagMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagMeetingInputOperationOutputAlias,
                crate::output::TagMeetingOutput,
                crate::error::TagMeetingError,
                crate::input::TagMeetingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies the specified tags to the specified Amazon Chime SDK meeting resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key-value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagAttendee`.
    ///
    /// <p>Untags the specified tags from the specified Amazon Chime SDK attendee.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagAttendee<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_attendee_input::Builder,
    }
    impl<C, M, R> UntagAttendee<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagAttendee`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagAttendeeOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagAttendeeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagAttendeeInputOperationOutputAlias,
                crate::output::UntagAttendeeOutput,
                crate::error::UntagAttendeeError,
                crate::input::UntagAttendeeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn attendee_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attendee_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK attendee ID.</p>
        pub fn set_attendee_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attendee_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagMeeting`.
    ///
    /// <p>Untags the specified tags from the specified Amazon Chime SDK meeting.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagMeeting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_meeting_input::Builder,
    }
    impl<C, M, R> UntagMeeting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagMeeting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagMeetingOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagMeetingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagMeetingInputOperationOutputAlias,
                crate::output::UntagMeetingOutput,
                crate::error::UntagMeetingError,
                crate::input::UntagMeetingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn meeting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.meeting_id(inp);
            self
        }
        /// <p>The Amazon Chime SDK meeting ID.</p>
        pub fn set_meeting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_meeting_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Untags the specified tags from the specified Amazon Chime SDK meeting resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccount`.
    ///
    /// <p>Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_input::Builder,
    }
    impl<C, M, R> UpdateAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountInputOperationOutputAlias,
                crate::output::UpdateAccountOutput,
                crate::error::UpdateAccountError,
                crate::input::UpdateAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The new name for the specified Amazon Chime account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name for the specified Amazon Chime account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The default license applied when you add users to an Amazon Chime account.</p>
        pub fn default_license(mut self, inp: crate::model::License) -> Self {
            self.inner = self.inner.default_license(inp);
            self
        }
        /// <p>The default license applied when you add users to an Amazon Chime account.</p>
        pub fn set_default_license(
            mut self,
            input: std::option::Option<crate::model::License>,
        ) -> Self {
            self.inner = self.inner.set_default_license(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountSettings`.
    ///
    /// <p>Updates the settings for the specified Amazon Chime account. You can update settings for
    /// remote control of shared screens, or for the dial-out option. For more information about
    /// these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use
    /// the Policies Page</a> in the <i>Amazon Chime Administration
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_settings_input::Builder,
    }
    impl<C, M, R> UpdateAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountSettingsInputOperationOutputAlias,
                crate::output::UpdateAccountSettingsOutput,
                crate::error::UpdateAccountSettingsError,
                crate::input::UpdateAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The Amazon Chime account settings to update.</p>
        pub fn account_settings(mut self, inp: crate::model::AccountSettings) -> Self {
            self.inner = self.inner.account_settings(inp);
            self
        }
        /// <p>The Amazon Chime account settings to update.</p>
        pub fn set_account_settings(
            mut self,
            input: std::option::Option<crate::model::AccountSettings>,
        ) -> Self {
            self.inner = self.inner.set_account_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstance`.
    ///
    /// <p>Updates <code>AppInstance</code> metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAppInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_instance_input::Builder,
    }
    impl<C, M, R> UpdateAppInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAppInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInstanceInputOperationOutputAlias,
                crate::output::UpdateAppInstanceOutput,
                crate::error::UpdateAppInstanceError,
                crate::input::UpdateAppInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn app_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstance</code>.</p>
        pub fn set_app_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_arn(input);
            self
        }
        /// <p>The name that you want to change.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name that you want to change.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata that you want to change.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata that you want to change.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppInstanceUser`.
    ///
    /// <p>Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAppInstanceUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_instance_user_input::Builder,
    }
    impl<C, M, R> UpdateAppInstanceUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAppInstanceUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppInstanceUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppInstanceUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInstanceUserInputOperationOutputAlias,
                crate::output::UpdateAppInstanceUserOutput,
                crate::error::UpdateAppInstanceUserError,
                crate::input::UpdateAppInstanceUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn app_instance_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_instance_user_arn(inp);
            self
        }
        /// <p>The ARN of the <code>AppInstanceUser</code>.</p>
        pub fn set_app_instance_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_instance_user_arn(input);
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the <code>AppInstanceUser</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the <code>AppInstanceUser</code>.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBot`.
    ///
    /// <p>Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bot_input::Builder,
    }
    impl<C, M, R> UpdateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBotInputOperationOutputAlias,
                crate::output::UpdateBotOutput,
                crate::error::UpdateBotError,
                crate::input::UpdateBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bot ID.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The bot ID.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>When true, stops the specified bot from running in your account.</p>
        pub fn disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.disabled(inp);
            self
        }
        /// <p>When true, stops the specified bot from running in your account.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// <p>Update a channel's attributes.</p>
    /// <p>
    /// <b>Restriction</b>: You can't change a channel's privacy. </p>
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl<C, M, R> UpdateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelInputOperationOutputAlias,
                crate::output::UpdateChannelOutput,
                crate::error::UpdateChannelError,
                crate::input::UpdateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn mode(mut self, inp: crate::model::ChannelMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>The mode of the update request.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ChannelMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata for the update request.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelMessage`.
    ///
    /// <p>Updates the content of a message.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannelMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_message_input::Builder,
    }
    impl<C, M, R> UpdateChannelMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannelMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelMessageInputOperationOutputAlias,
                crate::output::UpdateChannelMessageOutput,
                crate::error::UpdateChannelMessageError,
                crate::input::UpdateChannelMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(inp);
            self
        }
        /// <p>The ID string of the message being updated.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the message being updated.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The metadata of the message being updated.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannelReadMarker`.
    ///
    /// <p>The details of the time when a user last read messages in a channel.</p>
    ///
    /// <note>
    /// <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
    /// <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
    /// the header.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannelReadMarker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_read_marker_input::Builder,
    }
    impl<C, M, R> UpdateChannelReadMarker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannelReadMarker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelReadMarkerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelReadMarkerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelReadMarkerInputOperationOutputAlias,
                crate::output::UpdateChannelReadMarkerOutput,
                crate::error::UpdateChannelReadMarkerError,
                crate::input::UpdateChannelReadMarkerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the channel.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn chime_bearer(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.chime_bearer(inp);
            self
        }
        /// <p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>
        pub fn set_chime_bearer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_chime_bearer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalSettings`.
    ///
    /// <p>Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGlobalSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_global_settings_input::Builder,
    }
    impl<C, M, R> UpdateGlobalSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGlobalSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGlobalSettingsInputOperationOutputAlias,
                crate::output::UpdateGlobalSettingsOutput,
                crate::error::UpdateGlobalSettingsError,
                crate::input::UpdateGlobalSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Business Calling settings.</p>
        pub fn business_calling(mut self, inp: crate::model::BusinessCallingSettings) -> Self {
            self.inner = self.inner.business_calling(inp);
            self
        }
        /// <p>The Amazon Chime Business Calling settings.</p>
        pub fn set_business_calling(
            mut self,
            input: std::option::Option<crate::model::BusinessCallingSettings>,
        ) -> Self {
            self.inner = self.inner.set_business_calling(input);
            self
        }
        /// <p>The Amazon Chime Voice Connector settings.</p>
        pub fn voice_connector(mut self, inp: crate::model::VoiceConnectorSettings) -> Self {
            self.inner = self.inner.voice_connector(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector settings.</p>
        pub fn set_voice_connector(
            mut self,
            input: std::option::Option<crate::model::VoiceConnectorSettings>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePhoneNumber`.
    ///
    /// <p>Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.</p>
    /// <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p>
    /// <p>Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePhoneNumber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_phone_number_input::Builder,
    }
    impl<C, M, R> UpdatePhoneNumber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePhoneNumber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePhoneNumberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePhoneNumberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePhoneNumberInputOperationOutputAlias,
                crate::output::UpdatePhoneNumberOutput,
                crate::error::UpdatePhoneNumberError,
                crate::input::UpdatePhoneNumberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number ID.</p>
        pub fn phone_number_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number_id(inp);
            self
        }
        /// <p>The phone number ID.</p>
        pub fn set_phone_number_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_id(input);
            self
        }
        /// <p>The product type.</p>
        pub fn product_type(mut self, inp: crate::model::PhoneNumberProductType) -> Self {
            self.inner = self.inner.product_type(inp);
            self
        }
        /// <p>The product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::PhoneNumberProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// <p>The outbound calling name associated with the phone number.</p>
        pub fn calling_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calling_name(inp);
            self
        }
        /// <p>The outbound calling name associated with the phone number.</p>
        pub fn set_calling_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_calling_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePhoneNumberSettings`.
    ///
    /// <p>Updates the phone number settings for the administrator's AWS account, such as the default
    /// outbound calling name. You can update the default outbound calling name once every seven
    /// days. Outbound calling names can take up to 72 hours to update.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePhoneNumberSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_phone_number_settings_input::Builder,
    }
    impl<C, M, R> UpdatePhoneNumberSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePhoneNumberSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePhoneNumberSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePhoneNumberSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePhoneNumberSettingsInputOperationOutputAlias,
                crate::output::UpdatePhoneNumberSettingsOutput,
                crate::error::UpdatePhoneNumberSettingsError,
                crate::input::UpdatePhoneNumberSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The default outbound calling name for the account.</p>
        pub fn calling_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calling_name(inp);
            self
        }
        /// <p>The default outbound calling name for the account.</p>
        pub fn set_calling_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_calling_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProxySession`.
    ///
    /// <p>Updates the specified proxy session details, such as voice or SMS capabilities.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProxySession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_proxy_session_input::Builder,
    }
    impl<C, M, R> UpdateProxySession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProxySession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProxySessionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProxySessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProxySessionInputOperationOutputAlias,
                crate::output::UpdateProxySessionOutput,
                crate::error::UpdateProxySessionError,
                crate::input::UpdateProxySessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime voice connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn proxy_session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proxy_session_id(inp);
            self
        }
        /// <p>The proxy session ID.</p>
        pub fn set_proxy_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proxy_session_id(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>The proxy session capabilities.</p>
        pub fn capabilities(mut self, inp: impl Into<crate::model::Capability>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>The proxy session capabilities.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn expiry_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.expiry_minutes(inp);
            self
        }
        /// <p>The number of minutes allowed for the proxy session.</p>
        pub fn set_expiry_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiry_minutes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoom`.
    ///
    /// <p>Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_room_input::Builder,
    }
    impl<C, M, R> UpdateRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoomInputOperationOutputAlias,
                crate::output::UpdateRoomOutput,
                crate::error::UpdateRoomError,
                crate::input::UpdateRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The room name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The room name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoomMembership`.
    ///
    /// <p>Updates room membership details, such as the member role, for a room in an Amazon Chime
    /// Enterprise account. The member role designates whether the member is a chat room
    /// administrator or a general chat room member. The member role can be updated only for
    /// user IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoomMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_room_membership_input::Builder,
    }
    impl<C, M, R> UpdateRoomMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoomMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoomMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoomMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoomMembershipInputOperationOutputAlias,
                crate::output::UpdateRoomMembershipOutput,
                crate::error::UpdateRoomMembershipError,
                crate::input::UpdateRoomMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The room ID.</p>
        pub fn room_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_id(inp);
            self
        }
        /// <p>The room ID.</p>
        pub fn set_room_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_id(input);
            self
        }
        /// <p>The member ID.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The member ID.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The role of the member.</p>
        pub fn role(mut self, inp: crate::model::RoomMembershipRole) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The role of the member.</p>
        pub fn set_role(
            mut self,
            input: std::option::Option<crate::model::RoomMembershipRole>,
        ) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSipMediaApplication`.
    ///
    /// <p>Updates the details of the specified SIP media application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSipMediaApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sip_media_application_input::Builder,
    }
    impl<C, M, R> UpdateSipMediaApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSipMediaApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSipMediaApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSipMediaApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSipMediaApplicationInputOperationOutputAlias,
                crate::output::UpdateSipMediaApplicationOutput,
                crate::error::UpdateSipMediaApplicationError,
                crate::input::UpdateSipMediaApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP media application ID.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The SIP media application ID.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// <p>The new name for the specified SIP media application.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name for the specified SIP media application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>The new set of endpoints for the specified SIP media application.</p>
        pub fn endpoints(
            mut self,
            inp: impl Into<crate::model::SipMediaApplicationEndpoint>,
        ) -> Self {
            self.inner = self.inner.endpoints(inp);
            self
        }
        /// <p>The new set of endpoints for the specified SIP media application.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipMediaApplicationEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_endpoints(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSipMediaApplicationCall`.
    ///
    /// <p>Allows you to trigger a Lambda function at any time while a call is active, and replace the current actions with new actions returned by the invocation.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSipMediaApplicationCall<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sip_media_application_call_input::Builder,
    }
    impl<C, M, R> UpdateSipMediaApplicationCall<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSipMediaApplicationCall`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSipMediaApplicationCallOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSipMediaApplicationCallError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSipMediaApplicationCallInputOperationOutputAlias,
                crate::output::UpdateSipMediaApplicationCallOutput,
                crate::error::UpdateSipMediaApplicationCallError,
                crate::input::UpdateSipMediaApplicationCallInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the SIP media application handling the call.</p>
        pub fn sip_media_application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_media_application_id(inp);
            self
        }
        /// <p>The ID of the SIP media application handling the call.</p>
        pub fn set_sip_media_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sip_media_application_id(input);
            self
        }
        /// <p>The ID of the call transaction.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The ID of the call transaction.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// Adds a key-value pair to `Arguments`.
        ///
        /// To override the contents of this collection use [`set_arguments`](Self::set_arguments).
        ///
        /// <p>Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can contain 0-20 key-value pairs.</p>
        pub fn arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.arguments(k, v);
            self
        }
        /// <p>Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can contain 0-20 key-value pairs.</p>
        pub fn set_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_arguments(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSipRule`.
    ///
    /// <p>Updates the details of the specified SIP rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSipRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sip_rule_input::Builder,
    }
    impl<C, M, R> UpdateSipRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSipRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSipRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSipRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSipRuleInputOperationOutputAlias,
                crate::output::UpdateSipRuleOutput,
                crate::error::UpdateSipRuleError,
                crate::input::UpdateSipRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SIP rule ID.</p>
        pub fn sip_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sip_rule_id(inp);
            self
        }
        /// <p>The SIP rule ID.</p>
        pub fn set_sip_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sip_rule_id(input);
            self
        }
        /// <p>The new name for the specified SIP rule.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name for the specified SIP rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new value specified to indicate whether the rule is disabled.</p>
        pub fn disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.disabled(inp);
            self
        }
        /// <p>The new value specified to indicate whether the rule is disabled.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
        /// Appends an item to `TargetApplications`.
        ///
        /// To override the contents of this collection use [`set_target_applications`](Self::set_target_applications).
        ///
        /// <p>The new value of the list of target applications.</p>
        pub fn target_applications(
            mut self,
            inp: impl Into<crate::model::SipRuleTargetApplication>,
        ) -> Self {
            self.inner = self.inner.target_applications(inp);
            self
        }
        /// <p>The new value of the list of target applications.</p>
        pub fn set_target_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipRuleTargetApplication>>,
        ) -> Self {
            self.inner = self.inner.set_target_applications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Updates user details for a specified user ID. Currently, only <code>LicenseType</code> updates are supported for this action.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_input::Builder,
    }
    impl<C, M, R> UpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserInputOperationOutputAlias,
                crate::output::UpdateUserOutput,
                crate::error::UpdateUserError,
                crate::input::UpdateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The user license type to update. This must be a supported license type for the Amazon Chime
        /// account that the user belongs to.</p>
        pub fn license_type(mut self, inp: crate::model::License) -> Self {
            self.inner = self.inner.license_type(inp);
            self
        }
        /// <p>The user license type to update. This must be a supported license type for the Amazon Chime
        /// account that the user belongs to.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::License>,
        ) -> Self {
            self.inner = self.inner.set_license_type(input);
            self
        }
        /// <p>The user type.</p>
        pub fn user_type(mut self, inp: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(inp);
            self
        }
        /// <p>The user type.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
        /// <p>The Alexa for Business metadata.</p>
        pub fn alexa_for_business_metadata(
            mut self,
            inp: crate::model::AlexaForBusinessMetadata,
        ) -> Self {
            self.inner = self.inner.alexa_for_business_metadata(inp);
            self
        }
        /// <p>The Alexa for Business metadata.</p>
        pub fn set_alexa_for_business_metadata(
            mut self,
            input: std::option::Option<crate::model::AlexaForBusinessMetadata>,
        ) -> Self {
            self.inner = self.inner.set_alexa_for_business_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserSettings`.
    ///
    /// <p>Updates the settings for the specified user, such as phone number settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_settings_input::Builder,
    }
    impl<C, M, R> UpdateUserSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserSettingsInputOperationOutputAlias,
                crate::output::UpdateUserSettingsOutput,
                crate::error::UpdateUserSettingsError,
                crate::input::UpdateUserSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Chime account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The user settings to update.</p>
        pub fn user_settings(mut self, inp: crate::model::UserSettings) -> Self {
            self.inner = self.inner.user_settings(inp);
            self
        }
        /// <p>The user settings to update.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<crate::model::UserSettings>,
        ) -> Self {
            self.inner = self.inner.set_user_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVoiceConnector`.
    ///
    /// <p>Updates details for the specified Amazon Chime Voice Connector.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVoiceConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_voice_connector_input::Builder,
    }
    impl<C, M, R> UpdateVoiceConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVoiceConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVoiceConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVoiceConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVoiceConnectorInputOperationOutputAlias,
                crate::output::UpdateVoiceConnectorOutput,
                crate::error::UpdateVoiceConnectorError,
                crate::input::UpdateVoiceConnectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn voice_connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector ID.</p>
        pub fn set_voice_connector_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_id(input);
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn require_encryption(mut self, inp: bool) -> Self {
            self.inner = self.inner.require_encryption(inp);
            self
        }
        /// <p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>
        pub fn set_require_encryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_encryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVoiceConnectorGroup`.
    ///
    /// <p>Updates details of the specified Amazon Chime Voice Connector group, such as the name and
    /// Amazon Chime Voice Connector priority ranking.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVoiceConnectorGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_voice_connector_group_input::Builder,
    }
    impl<C, M, R> UpdateVoiceConnectorGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVoiceConnectorGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVoiceConnectorGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVoiceConnectorGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVoiceConnectorGroupInputOperationOutputAlias,
                crate::output::UpdateVoiceConnectorGroupOutput,
                crate::error::UpdateVoiceConnectorGroupError,
                crate::input::UpdateVoiceConnectorGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn voice_connector_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_connector_group_id(inp);
            self
        }
        /// <p>The Amazon Chime Voice Connector group ID.</p>
        pub fn set_voice_connector_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_group_id(input);
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Amazon Chime Voice Connector group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `VoiceConnectorItems`.
        ///
        /// To override the contents of this collection use [`set_voice_connector_items`](Self::set_voice_connector_items).
        ///
        /// <p>The <code>VoiceConnectorItems</code> to associate with the group.</p>
        pub fn voice_connector_items(
            mut self,
            inp: impl Into<crate::model::VoiceConnectorItem>,
        ) -> Self {
            self.inner = self.inner.voice_connector_items(inp);
            self
        }
        /// <p>The <code>VoiceConnectorItems</code> to associate with the group.</p>
        pub fn set_voice_connector_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VoiceConnectorItem>>,
        ) -> Self {
            self.inner = self.inner.set_voice_connector_items(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
