// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Budgets
///
/// Client for invoking operations on AWS Budgets. Each operation on AWS Budgets is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_budgets::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_budgets::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_budgets::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateBudget`](crate::client::fluent_builders::CreateBudget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateBudget::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateBudget::set_account_id): <p>The <code>accountId</code> that is associated with the budget.</p>
    ///   - [`budget(Budget)`](crate::client::fluent_builders::CreateBudget::budget) / [`set_budget(Option<Budget>)`](crate::client::fluent_builders::CreateBudget::set_budget): <p>The budget object that you want to create.</p>
    ///   - [`notifications_with_subscribers(Vec<NotificationWithSubscribers>)`](crate::client::fluent_builders::CreateBudget::notifications_with_subscribers) / [`set_notifications_with_subscribers(Option<Vec<NotificationWithSubscribers>>)`](crate::client::fluent_builders::CreateBudget::set_notifications_with_subscribers): <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the notifications and subscribers for you.</p>
    /// - On success, responds with [`CreateBudgetOutput`](crate::output::CreateBudgetOutput)

    /// - On failure, responds with [`SdkError<CreateBudgetError>`](crate::error::CreateBudgetError)
    pub fn create_budget(&self) -> fluent_builders::CreateBudget {
        fluent_builders::CreateBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBudgetAction`](crate::client::fluent_builders::CreateBudgetAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateBudgetAction::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateBudgetAction::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::CreateBudgetAction::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::CreateBudgetAction::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`notification_type(NotificationType)`](crate::client::fluent_builders::CreateBudgetAction::notification_type) / [`set_notification_type(Option<NotificationType>)`](crate::client::fluent_builders::CreateBudgetAction::set_notification_type): <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
    ///   - [`action_type(ActionType)`](crate::client::fluent_builders::CreateBudgetAction::action_type) / [`set_action_type(Option<ActionType>)`](crate::client::fluent_builders::CreateBudgetAction::set_action_type): <p> The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
    ///   - [`action_threshold(ActionThreshold)`](crate::client::fluent_builders::CreateBudgetAction::action_threshold) / [`set_action_threshold(Option<ActionThreshold>)`](crate::client::fluent_builders::CreateBudgetAction::set_action_threshold): <p>The trigger threshold of the action. </p>
    ///   - [`definition(Definition)`](crate::client::fluent_builders::CreateBudgetAction::definition) / [`set_definition(Option<Definition>)`](crate::client::fluent_builders::CreateBudgetAction::set_definition): <p>Specifies all of the type-specific parameters. </p>
    ///   - [`execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateBudgetAction::execution_role_arn) / [`set_execution_role_arn(Option<String>)`](crate::client::fluent_builders::CreateBudgetAction::set_execution_role_arn): <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
    ///   - [`approval_model(ApprovalModel)`](crate::client::fluent_builders::CreateBudgetAction::approval_model) / [`set_approval_model(Option<ApprovalModel>)`](crate::client::fluent_builders::CreateBudgetAction::set_approval_model): <p> This specifies if the action needs manual or automatic approval. </p>
    ///   - [`subscribers(Vec<Subscriber>)`](crate::client::fluent_builders::CreateBudgetAction::subscribers) / [`set_subscribers(Option<Vec<Subscriber>>)`](crate::client::fluent_builders::CreateBudgetAction::set_subscribers): <p> A list of subscribers.</p>
    /// - On success, responds with [`CreateBudgetActionOutput`](crate::output::CreateBudgetActionOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::CreateBudgetActionOutput::account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(Option<String>)`](crate::output::CreateBudgetActionOutput::budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action_id(Option<String>)`](crate::output::CreateBudgetActionOutput::action_id): <p> A system-generated universally unique identifier (UUID) for the action. </p>
    /// - On failure, responds with [`SdkError<CreateBudgetActionError>`](crate::error::CreateBudgetActionError)
    pub fn create_budget_action(&self) -> fluent_builders::CreateBudgetAction {
        fluent_builders::CreateBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNotification`](crate::client::fluent_builders::CreateNotification) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateNotification::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateNotification::set_account_id): <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::CreateNotification::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::CreateNotification::set_budget_name): <p>The name of the budget that you want Amazon Web Services to notify you about. Budget names must be unique within an account.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::CreateNotification::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::CreateNotification::set_notification): <p>The notification that you want to create.</p>
    ///   - [`subscribers(Vec<Subscriber>)`](crate::client::fluent_builders::CreateNotification::subscribers) / [`set_subscribers(Option<Vec<Subscriber>>)`](crate::client::fluent_builders::CreateNotification::set_subscribers): <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
    /// - On success, responds with [`CreateNotificationOutput`](crate::output::CreateNotificationOutput)

    /// - On failure, responds with [`SdkError<CreateNotificationError>`](crate::error::CreateNotificationError)
    pub fn create_notification(&self) -> fluent_builders::CreateNotification {
        fluent_builders::CreateNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSubscriber`](crate::client::fluent_builders::CreateSubscriber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateSubscriber::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateSubscriber::set_account_id): <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::CreateSubscriber::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::CreateSubscriber::set_budget_name): <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::CreateSubscriber::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::CreateSubscriber::set_notification): <p>The notification that you want to create a subscriber for.</p>
    ///   - [`subscriber(Subscriber)`](crate::client::fluent_builders::CreateSubscriber::subscriber) / [`set_subscriber(Option<Subscriber>)`](crate::client::fluent_builders::CreateSubscriber::set_subscriber): <p>The subscriber that you want to associate with a budget notification.</p>
    /// - On success, responds with [`CreateSubscriberOutput`](crate::output::CreateSubscriberOutput)

    /// - On failure, responds with [`SdkError<CreateSubscriberError>`](crate::error::CreateSubscriberError)
    pub fn create_subscriber(&self) -> fluent_builders::CreateSubscriber {
        fluent_builders::CreateSubscriber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBudget`](crate::client::fluent_builders::DeleteBudget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBudget::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteBudget::set_account_id): <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBudget::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DeleteBudget::set_budget_name): <p>The name of the budget that you want to delete.</p>
    /// - On success, responds with [`DeleteBudgetOutput`](crate::output::DeleteBudgetOutput)

    /// - On failure, responds with [`SdkError<DeleteBudgetError>`](crate::error::DeleteBudgetError)
    pub fn delete_budget(&self) -> fluent_builders::DeleteBudget {
        fluent_builders::DeleteBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBudgetAction`](crate::client::fluent_builders::DeleteBudgetAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBudgetAction::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteBudgetAction::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBudgetAction::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DeleteBudgetAction::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBudgetAction::action_id) / [`set_action_id(Option<String>)`](crate::client::fluent_builders::DeleteBudgetAction::set_action_id): <p> A system-generated universally unique identifier (UUID) for the action. </p>
    /// - On success, responds with [`DeleteBudgetActionOutput`](crate::output::DeleteBudgetActionOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::DeleteBudgetActionOutput::account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(Option<String>)`](crate::output::DeleteBudgetActionOutput::budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action(Option<Action>)`](crate::output::DeleteBudgetActionOutput::action): <p>A budget action resource. </p>
    /// - On failure, responds with [`SdkError<DeleteBudgetActionError>`](crate::error::DeleteBudgetActionError)
    pub fn delete_budget_action(&self) -> fluent_builders::DeleteBudgetAction {
        fluent_builders::DeleteBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNotification`](crate::client::fluent_builders::DeleteNotification) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNotification::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteNotification::set_account_id): <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DeleteNotification::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DeleteNotification::set_budget_name): <p>The name of the budget whose notification you want to delete.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::DeleteNotification::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::DeleteNotification::set_notification): <p>The notification that you want to delete.</p>
    /// - On success, responds with [`DeleteNotificationOutput`](crate::output::DeleteNotificationOutput)

    /// - On failure, responds with [`SdkError<DeleteNotificationError>`](crate::error::DeleteNotificationError)
    pub fn delete_notification(&self) -> fluent_builders::DeleteNotification {
        fluent_builders::DeleteNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSubscriber`](crate::client::fluent_builders::DeleteSubscriber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSubscriber::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteSubscriber::set_account_id): <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSubscriber::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DeleteSubscriber::set_budget_name): <p>The name of the budget whose subscriber you want to delete.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::DeleteSubscriber::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::DeleteSubscriber::set_notification): <p>The notification whose subscriber you want to delete.</p>
    ///   - [`subscriber(Subscriber)`](crate::client::fluent_builders::DeleteSubscriber::subscriber) / [`set_subscriber(Option<Subscriber>)`](crate::client::fluent_builders::DeleteSubscriber::set_subscriber): <p>The subscriber that you want to delete.</p>
    /// - On success, responds with [`DeleteSubscriberOutput`](crate::output::DeleteSubscriberOutput)

    /// - On failure, responds with [`SdkError<DeleteSubscriberError>`](crate::error::DeleteSubscriberError)
    pub fn delete_subscriber(&self) -> fluent_builders::DeleteSubscriber {
        fluent_builders::DeleteSubscriber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudget`](crate::client::fluent_builders::DescribeBudget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudget::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudget::set_account_id): <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DescribeBudget::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DescribeBudget::set_budget_name): <p>The name of the budget that you want a description of.</p>
    /// - On success, responds with [`DescribeBudgetOutput`](crate::output::DescribeBudgetOutput) with field(s):
    ///   - [`budget(Option<Budget>)`](crate::output::DescribeBudgetOutput::budget): <p>The description of the budget.</p>
    /// - On failure, responds with [`SdkError<DescribeBudgetError>`](crate::error::DescribeBudgetError)
    pub fn describe_budget(&self) -> fluent_builders::DescribeBudget {
        fluent_builders::DescribeBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudgetAction`](crate::client::fluent_builders::DescribeBudgetAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetAction::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetAction::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetAction::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DescribeBudgetAction::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetAction::action_id) / [`set_action_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetAction::set_action_id): <p> A system-generated universally unique identifier (UUID) for the action. </p>
    /// - On success, responds with [`DescribeBudgetActionOutput`](crate::output::DescribeBudgetActionOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::DescribeBudgetActionOutput::account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(Option<String>)`](crate::output::DescribeBudgetActionOutput::budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action(Option<Action>)`](crate::output::DescribeBudgetActionOutput::action): <p> A budget action resource. </p>
    /// - On failure, responds with [`SdkError<DescribeBudgetActionError>`](crate::error::DescribeBudgetActionError)
    pub fn describe_budget_action(&self) -> fluent_builders::DescribeBudgetAction {
        fluent_builders::DescribeBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudgetActionHistories`](crate::client::fluent_builders::DescribeBudgetActionHistories) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBudgetActionHistories::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::action_id) / [`set_action_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::set_action_id): <p> A system-generated universally unique identifier (UUID) for the action. </p>
    ///   - [`time_period(TimePeriod)`](crate::client::fluent_builders::DescribeBudgetActionHistories::time_period) / [`set_time_period(Option<TimePeriod>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::set_time_period): <p>The period of time that's covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBudgetActionHistories::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::set_max_results): <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionHistories::set_next_token): <p> A generic string.</p>
    /// - On success, responds with [`DescribeBudgetActionHistoriesOutput`](crate::output::DescribeBudgetActionHistoriesOutput) with field(s):
    ///   - [`action_histories(Option<Vec<ActionHistory>>)`](crate::output::DescribeBudgetActionHistoriesOutput::action_histories): <p> The historical record of the budget action resource. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBudgetActionHistoriesOutput::next_token): <p> A generic string.</p>
    /// - On failure, responds with [`SdkError<DescribeBudgetActionHistoriesError>`](crate::error::DescribeBudgetActionHistoriesError)
    pub fn describe_budget_action_histories(
        &self,
    ) -> fluent_builders::DescribeBudgetActionHistories {
        fluent_builders::DescribeBudgetActionHistories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudgetActionsForAccount`](crate::client::fluent_builders::DescribeBudgetActionsForAccount) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBudgetActionsForAccount::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForAccount::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBudgetActionsForAccount::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBudgetActionsForAccount::set_max_results): <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForAccount::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForAccount::set_next_token): <p> A generic string.</p>
    /// - On success, responds with [`DescribeBudgetActionsForAccountOutput`](crate::output::DescribeBudgetActionsForAccountOutput) with field(s):
    ///   - [`actions(Option<Vec<Action>>)`](crate::output::DescribeBudgetActionsForAccountOutput::actions): <p> A list of the budget action resources information. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBudgetActionsForAccountOutput::next_token): <p> A generic string.</p>
    /// - On failure, responds with [`SdkError<DescribeBudgetActionsForAccountError>`](crate::error::DescribeBudgetActionsForAccountError)
    pub fn describe_budget_actions_for_account(
        &self,
    ) -> fluent_builders::DescribeBudgetActionsForAccount {
        fluent_builders::DescribeBudgetActionsForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudgetActionsForBudget`](crate::client::fluent_builders::DescribeBudgetActionsForBudget) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::set_max_results): <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBudgetActionsForBudget::set_next_token): <p> A generic string.</p>
    /// - On success, responds with [`DescribeBudgetActionsForBudgetOutput`](crate::output::DescribeBudgetActionsForBudgetOutput) with field(s):
    ///   - [`actions(Option<Vec<Action>>)`](crate::output::DescribeBudgetActionsForBudgetOutput::actions): <p> A list of the budget action resources information. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBudgetActionsForBudgetOutput::next_token): <p> A generic string.</p>
    /// - On failure, responds with [`SdkError<DescribeBudgetActionsForBudgetError>`](crate::error::DescribeBudgetActionsForBudgetError)
    pub fn describe_budget_actions_for_budget(
        &self,
    ) -> fluent_builders::DescribeBudgetActionsForBudget {
        fluent_builders::DescribeBudgetActionsForBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudgetNotificationsForAccount`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount::set_max_results): <p> An integer that shows how many budget name entries a paginated response contains. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBudgetNotificationsForAccount::set_next_token): <p> A generic string.</p>
    /// - On success, responds with [`DescribeBudgetNotificationsForAccountOutput`](crate::output::DescribeBudgetNotificationsForAccountOutput) with field(s):
    ///   - [`budget_notifications_for_account(Option<Vec<BudgetNotificationsForAccount>>)`](crate::output::DescribeBudgetNotificationsForAccountOutput::budget_notifications_for_account): <p> A list of budget names and associated notifications for an account. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBudgetNotificationsForAccountOutput::next_token): <p> A generic string.</p>
    /// - On failure, responds with [`SdkError<DescribeBudgetNotificationsForAccountError>`](crate::error::DescribeBudgetNotificationsForAccountError)
    pub fn describe_budget_notifications_for_account(
        &self,
    ) -> fluent_builders::DescribeBudgetNotificationsForAccount {
        fluent_builders::DescribeBudgetNotificationsForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudgetPerformanceHistory`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`time_period(TimePeriod)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::time_period) / [`set_time_period(Option<TimePeriod>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::set_time_period): <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::set_max_results): <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory::set_next_token): <p> A generic string.</p>
    /// - On success, responds with [`DescribeBudgetPerformanceHistoryOutput`](crate::output::DescribeBudgetPerformanceHistoryOutput) with field(s):
    ///   - [`budget_performance_history(Option<BudgetPerformanceHistory>)`](crate::output::DescribeBudgetPerformanceHistoryOutput::budget_performance_history): <p>The history of how often the budget has gone into an <code>ALARM</code> state.</p>  <p>For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four quarters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBudgetPerformanceHistoryOutput::next_token): <p> A generic string.</p>
    /// - On failure, responds with [`SdkError<DescribeBudgetPerformanceHistoryError>`](crate::error::DescribeBudgetPerformanceHistoryError)
    pub fn describe_budget_performance_history(
        &self,
    ) -> fluent_builders::DescribeBudgetPerformanceHistory {
        fluent_builders::DescribeBudgetPerformanceHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBudgets`](crate::client::fluent_builders::DescribeBudgets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBudgets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgets::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeBudgets::set_account_id): <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBudgets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBudgets::set_max_results): <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBudgets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBudgets::set_next_token): <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    /// - On success, responds with [`DescribeBudgetsOutput`](crate::output::DescribeBudgetsOutput) with field(s):
    ///   - [`budgets(Option<Vec<Budget>>)`](crate::output::DescribeBudgetsOutput::budgets): <p>A list of budgets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBudgetsOutput::next_token): <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeBudgetsError>`](crate::error::DescribeBudgetsError)
    pub fn describe_budgets(&self) -> fluent_builders::DescribeBudgets {
        fluent_builders::DescribeBudgets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNotificationsForBudget`](crate::client::fluent_builders::DescribeNotificationsForBudget) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNotificationsForBudget::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeNotificationsForBudget::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeNotificationsForBudget::set_account_id): <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DescribeNotificationsForBudget::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DescribeNotificationsForBudget::set_budget_name): <p>The name of the budget whose notifications you want descriptions of.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNotificationsForBudget::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNotificationsForBudget::set_max_results): <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNotificationsForBudget::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNotificationsForBudget::set_next_token): <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    /// - On success, responds with [`DescribeNotificationsForBudgetOutput`](crate::output::DescribeNotificationsForBudgetOutput) with field(s):
    ///   - [`notifications(Option<Vec<Notification>>)`](crate::output::DescribeNotificationsForBudgetOutput::notifications): <p>A list of notifications that are associated with a budget.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNotificationsForBudgetOutput::next_token): <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeNotificationsForBudgetError>`](crate::error::DescribeNotificationsForBudgetError)
    pub fn describe_notifications_for_budget(
        &self,
    ) -> fluent_builders::DescribeNotificationsForBudget {
        fluent_builders::DescribeNotificationsForBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSubscribersForNotification`](crate::client::fluent_builders::DescribeSubscribersForNotification) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSubscribersForNotification::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::set_account_id): <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::set_budget_name): <p>The name of the budget whose subscribers you want descriptions of.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::DescribeSubscribersForNotification::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::set_notification): <p>The notification whose subscribers you want to list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSubscribersForNotification::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::set_max_results): <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSubscribersForNotification::set_next_token): <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    /// - On success, responds with [`DescribeSubscribersForNotificationOutput`](crate::output::DescribeSubscribersForNotificationOutput) with field(s):
    ///   - [`subscribers(Option<Vec<Subscriber>>)`](crate::output::DescribeSubscribersForNotificationOutput::subscribers): <p>A list of subscribers that are associated with a notification.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSubscribersForNotificationOutput::next_token): <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    /// - On failure, responds with [`SdkError<DescribeSubscribersForNotificationError>`](crate::error::DescribeSubscribersForNotificationError)
    pub fn describe_subscribers_for_notification(
        &self,
    ) -> fluent_builders::DescribeSubscribersForNotification {
        fluent_builders::DescribeSubscribersForNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteBudgetAction`](crate::client::fluent_builders::ExecuteBudgetAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ExecuteBudgetAction::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ExecuteBudgetAction::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::ExecuteBudgetAction::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::ExecuteBudgetAction::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action_id(impl Into<String>)`](crate::client::fluent_builders::ExecuteBudgetAction::action_id) / [`set_action_id(Option<String>)`](crate::client::fluent_builders::ExecuteBudgetAction::set_action_id): <p> A system-generated universally unique identifier (UUID) for the action. </p>
    ///   - [`execution_type(ExecutionType)`](crate::client::fluent_builders::ExecuteBudgetAction::execution_type) / [`set_execution_type(Option<ExecutionType>)`](crate::client::fluent_builders::ExecuteBudgetAction::set_execution_type): <p> The type of execution. </p>
    /// - On success, responds with [`ExecuteBudgetActionOutput`](crate::output::ExecuteBudgetActionOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::ExecuteBudgetActionOutput::account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(Option<String>)`](crate::output::ExecuteBudgetActionOutput::budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action_id(Option<String>)`](crate::output::ExecuteBudgetActionOutput::action_id): <p> A system-generated universally unique identifier (UUID) for the action. </p>
    ///   - [`execution_type(Option<ExecutionType>)`](crate::output::ExecuteBudgetActionOutput::execution_type): <p> The type of execution. </p>
    /// - On failure, responds with [`SdkError<ExecuteBudgetActionError>`](crate::error::ExecuteBudgetActionError)
    pub fn execute_budget_action(&self) -> fluent_builders::ExecuteBudgetAction {
        fluent_builders::ExecuteBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBudget`](crate::client::fluent_builders::UpdateBudget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBudget::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateBudget::set_account_id): <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
    ///   - [`new_budget(Budget)`](crate::client::fluent_builders::UpdateBudget::new_budget) / [`set_new_budget(Option<Budget>)`](crate::client::fluent_builders::UpdateBudget::set_new_budget): <p>The budget that you want to update your budget to.</p>
    /// - On success, responds with [`UpdateBudgetOutput`](crate::output::UpdateBudgetOutput)

    /// - On failure, responds with [`SdkError<UpdateBudgetError>`](crate::error::UpdateBudgetError)
    pub fn update_budget(&self) -> fluent_builders::UpdateBudget {
        fluent_builders::UpdateBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBudgetAction`](crate::client::fluent_builders::UpdateBudgetAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBudgetAction::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateBudgetAction::set_account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBudgetAction::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::UpdateBudgetAction::set_budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`action_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBudgetAction::action_id) / [`set_action_id(Option<String>)`](crate::client::fluent_builders::UpdateBudgetAction::set_action_id): <p> A system-generated universally unique identifier (UUID) for the action. </p>
    ///   - [`notification_type(NotificationType)`](crate::client::fluent_builders::UpdateBudgetAction::notification_type) / [`set_notification_type(Option<NotificationType>)`](crate::client::fluent_builders::UpdateBudgetAction::set_notification_type): <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
    ///   - [`action_threshold(ActionThreshold)`](crate::client::fluent_builders::UpdateBudgetAction::action_threshold) / [`set_action_threshold(Option<ActionThreshold>)`](crate::client::fluent_builders::UpdateBudgetAction::set_action_threshold): <p>The trigger threshold of the action. </p>
    ///   - [`definition(Definition)`](crate::client::fluent_builders::UpdateBudgetAction::definition) / [`set_definition(Option<Definition>)`](crate::client::fluent_builders::UpdateBudgetAction::set_definition): <p>Specifies all of the type-specific parameters. </p>
    ///   - [`execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateBudgetAction::execution_role_arn) / [`set_execution_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateBudgetAction::set_execution_role_arn): <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
    ///   - [`approval_model(ApprovalModel)`](crate::client::fluent_builders::UpdateBudgetAction::approval_model) / [`set_approval_model(Option<ApprovalModel>)`](crate::client::fluent_builders::UpdateBudgetAction::set_approval_model): <p> This specifies if the action needs manual or automatic approval. </p>
    ///   - [`subscribers(Vec<Subscriber>)`](crate::client::fluent_builders::UpdateBudgetAction::subscribers) / [`set_subscribers(Option<Vec<Subscriber>>)`](crate::client::fluent_builders::UpdateBudgetAction::set_subscribers): <p> A list of subscribers.</p>
    /// - On success, responds with [`UpdateBudgetActionOutput`](crate::output::UpdateBudgetActionOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::UpdateBudgetActionOutput::account_id): <p>The account ID of the user. It's a 12-digit number.</p>
    ///   - [`budget_name(Option<String>)`](crate::output::UpdateBudgetActionOutput::budget_name): <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    ///   - [`old_action(Option<Action>)`](crate::output::UpdateBudgetActionOutput::old_action): <p> The previous action resource information. </p>
    ///   - [`new_action(Option<Action>)`](crate::output::UpdateBudgetActionOutput::new_action): <p> The updated action resource information. </p>
    /// - On failure, responds with [`SdkError<UpdateBudgetActionError>`](crate::error::UpdateBudgetActionError)
    pub fn update_budget_action(&self) -> fluent_builders::UpdateBudgetAction {
        fluent_builders::UpdateBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNotification`](crate::client::fluent_builders::UpdateNotification) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNotification::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateNotification::set_account_id): <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::UpdateNotification::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::UpdateNotification::set_budget_name): <p>The name of the budget whose notification you want to update.</p>
    ///   - [`old_notification(Notification)`](crate::client::fluent_builders::UpdateNotification::old_notification) / [`set_old_notification(Option<Notification>)`](crate::client::fluent_builders::UpdateNotification::set_old_notification): <p>The previous notification that is associated with a budget.</p>
    ///   - [`new_notification(Notification)`](crate::client::fluent_builders::UpdateNotification::new_notification) / [`set_new_notification(Option<Notification>)`](crate::client::fluent_builders::UpdateNotification::set_new_notification): <p>The updated notification to be associated with a budget.</p>
    /// - On success, responds with [`UpdateNotificationOutput`](crate::output::UpdateNotificationOutput)

    /// - On failure, responds with [`SdkError<UpdateNotificationError>`](crate::error::UpdateNotificationError)
    pub fn update_notification(&self) -> fluent_builders::UpdateNotification {
        fluent_builders::UpdateNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSubscriber`](crate::client::fluent_builders::UpdateSubscriber) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSubscriber::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateSubscriber::set_account_id): <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSubscriber::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::UpdateSubscriber::set_budget_name): <p>The name of the budget whose subscriber you want to update.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::UpdateSubscriber::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::UpdateSubscriber::set_notification): <p>The notification whose subscriber you want to update.</p>
    ///   - [`old_subscriber(Subscriber)`](crate::client::fluent_builders::UpdateSubscriber::old_subscriber) / [`set_old_subscriber(Option<Subscriber>)`](crate::client::fluent_builders::UpdateSubscriber::set_old_subscriber): <p>The previous subscriber that is associated with a budget notification.</p>
    ///   - [`new_subscriber(Subscriber)`](crate::client::fluent_builders::UpdateSubscriber::new_subscriber) / [`set_new_subscriber(Option<Subscriber>)`](crate::client::fluent_builders::UpdateSubscriber::set_new_subscriber): <p>The updated subscriber that is associated with a budget notification.</p>
    /// - On success, responds with [`UpdateSubscriberOutput`](crate::output::UpdateSubscriberOutput)

    /// - On failure, responds with [`SdkError<UpdateSubscriberError>`](crate::error::UpdateSubscriberError)
    pub fn update_subscriber(&self) -> fluent_builders::UpdateSubscriber {
        fluent_builders::UpdateSubscriber::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateBudget`.
    ///
    /// <p>Creates a budget and, if included, notifications and subscribers. </p> <important>
    /// <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBudget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_budget_input::Builder,
    }
    impl CreateBudget {
        /// Creates a new `CreateBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBudgetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The budget object that you want to create.</p>
        pub fn budget(mut self, input: crate::model::Budget) -> Self {
            self.inner = self.inner.budget(input);
            self
        }
        /// <p>The budget object that you want to create.</p>
        pub fn set_budget(mut self, input: std::option::Option<crate::model::Budget>) -> Self {
            self.inner = self.inner.set_budget(input);
            self
        }
        /// Appends an item to `NotificationsWithSubscribers`.
        ///
        /// To override the contents of this collection use [`set_notifications_with_subscribers`](Self::set_notifications_with_subscribers).
        ///
        /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the notifications and subscribers for you.</p>
        pub fn notifications_with_subscribers(
            mut self,
            input: crate::model::NotificationWithSubscribers,
        ) -> Self {
            self.inner = self.inner.notifications_with_subscribers(input);
            self
        }
        /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, Amazon Web Services creates the notifications and subscribers for you.</p>
        pub fn set_notifications_with_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationWithSubscribers>>,
        ) -> Self {
            self.inner = self.inner.set_notifications_with_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBudgetAction`.
    ///
    /// <p> Creates a budget action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBudgetAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_budget_action_input::Builder,
    }
    impl CreateBudgetAction {
        /// Creates a new `CreateBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBudgetActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p> The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.inner = self.inner.action_type(input);
            self
        }
        /// <p> The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>The trigger threshold of the action. </p>
        pub fn action_threshold(mut self, input: crate::model::ActionThreshold) -> Self {
            self.inner = self.inner.action_threshold(input);
            self
        }
        /// <p>The trigger threshold of the action. </p>
        pub fn set_action_threshold(
            mut self,
            input: std::option::Option<crate::model::ActionThreshold>,
        ) -> Self {
            self.inner = self.inner.set_action_threshold(input);
            self
        }
        /// <p>Specifies all of the type-specific parameters. </p>
        pub fn definition(mut self, input: crate::model::Definition) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>Specifies all of the type-specific parameters. </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::Definition>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p> This specifies if the action needs manual or automatic approval. </p>
        pub fn approval_model(mut self, input: crate::model::ApprovalModel) -> Self {
            self.inner = self.inner.approval_model(input);
            self
        }
        /// <p> This specifies if the action needs manual or automatic approval. </p>
        pub fn set_approval_model(
            mut self,
            input: std::option::Option<crate::model::ApprovalModel>,
        ) -> Self {
            self.inner = self.inner.set_approval_model(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p> A list of subscribers.</p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscribers(input);
            self
        }
        /// <p> A list of subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNotification`.
    ///
    /// <p>Creates a notification. You must create the budget before you create the associated notification.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNotification {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_notification_input::Builder,
    }
    impl CreateNotification {
        /// Creates a new `CreateNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNotificationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want Amazon Web Services to notify you about. Budget names must be unique within an account.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget that you want Amazon Web Services to notify you about. Budget names must be unique within an account.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification that you want to create.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The notification that you want to create.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscribers(input);
            self
        }
        /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubscriber`.
    ///
    /// <p>Creates a subscriber. You must create the associated budget and notification before you create the subscriber.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSubscriber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_subscriber_input::Builder,
    }
    impl CreateSubscriber {
        /// Creates a new `CreateSubscriber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubscriberOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubscriberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification that you want to create a subscriber for.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The notification that you want to create a subscriber for.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The subscriber that you want to associate with a budget notification.</p>
        pub fn subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscriber(input);
            self
        }
        /// <p>The subscriber that you want to associate with a budget notification.</p>
        pub fn set_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_subscriber(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBudget`.
    ///
    /// <p>Deletes a budget. You can delete your budget at any time.</p> <important>
    /// <p>Deleting a budget also deletes the notifications and subscribers that are associated with that budget.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBudget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_budget_input::Builder,
    }
    impl DeleteBudget {
        /// Creates a new `DeleteBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBudgetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want to delete.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget that you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBudgetAction`.
    ///
    /// <p> Deletes a budget action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBudgetAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_budget_action_input::Builder,
    }
    impl DeleteBudgetAction {
        /// Creates a new `DeleteBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBudgetActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(input.into());
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotification`.
    ///
    /// <p>Deletes a notification.</p> <important>
    /// <p>Deleting a notification also deletes the subscribers that are associated with the notification.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNotification {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_notification_input::Builder,
    }
    impl DeleteNotification {
        /// Creates a new `DeleteNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNotificationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose notification you want to delete.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget whose notification you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification that you want to delete.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The notification that you want to delete.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubscriber`.
    ///
    /// <p>Deletes a subscriber.</p> <important>
    /// <p>Deleting the last subscriber to a notification also deletes the notification.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSubscriber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_subscriber_input::Builder,
    }
    impl DeleteSubscriber {
        /// Creates a new `DeleteSubscriber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubscriberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubscriberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose subscriber you want to delete.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget whose subscriber you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification whose subscriber you want to delete.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The notification whose subscriber you want to delete.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The subscriber that you want to delete.</p>
        pub fn subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscriber(input);
            self
        }
        /// <p>The subscriber that you want to delete.</p>
        pub fn set_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_subscriber(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudget`.
    ///
    /// <p>Describes a budget.</p> <important>
    /// <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budget_input::Builder,
    }
    impl DescribeBudget {
        /// Creates a new `DescribeBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want a description of.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget that you want a description of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetAction`.
    ///
    /// <p> Describes a budget action detail. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudgetAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budget_action_input::Builder,
    }
    impl DescribeBudgetAction {
        /// Creates a new `DescribeBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(input.into());
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetActionHistories`.
    ///
    /// <p> Describes a budget action history detail. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudgetActionHistories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budget_action_histories_input::Builder,
    }
    impl DescribeBudgetActionHistories {
        /// Creates a new `DescribeBudgetActionHistories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionHistoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionHistoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBudgetActionHistoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBudgetActionHistoriesPaginator {
            crate::paginator::DescribeBudgetActionHistoriesPaginator::new(self.handle, self.inner)
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(input.into());
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
        /// <p>The period of time that's covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
        pub fn time_period(mut self, input: crate::model::TimePeriod) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The period of time that's covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetActionsForAccount`.
    ///
    /// <p> Describes all of the budget actions for an account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudgetActionsForAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budget_actions_for_account_input::Builder,
    }
    impl DescribeBudgetActionsForAccount {
        /// Creates a new `DescribeBudgetActionsForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionsForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionsForAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBudgetActionsForAccountPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBudgetActionsForAccountPaginator {
            crate::paginator::DescribeBudgetActionsForAccountPaginator::new(self.handle, self.inner)
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetActionsForBudget`.
    ///
    /// <p> Describes all of the budget actions for a budget. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudgetActionsForBudget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budget_actions_for_budget_input::Builder,
    }
    impl DescribeBudgetActionsForBudget {
        /// Creates a new `DescribeBudgetActionsForBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionsForBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionsForBudgetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBudgetActionsForBudgetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBudgetActionsForBudgetPaginator {
            crate::paginator::DescribeBudgetActionsForBudgetPaginator::new(self.handle, self.inner)
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetNotificationsForAccount`.
    ///
    /// <p> Lists the budget names and notifications that are associated with an account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudgetNotificationsForAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budget_notifications_for_account_input::Builder,
    }
    impl DescribeBudgetNotificationsForAccount {
        /// Creates a new `DescribeBudgetNotificationsForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetNotificationsForAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeBudgetNotificationsForAccountError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBudgetNotificationsForAccountPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeBudgetNotificationsForAccountPaginator {
            crate::paginator::DescribeBudgetNotificationsForAccountPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> An integer that shows how many budget name entries a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> An integer that shows how many budget name entries a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetPerformanceHistory`.
    ///
    /// <p>Describes the history for <code>DAILY</code>, <code>MONTHLY</code>, and <code>QUARTERLY</code> budgets. Budget history isn't available for <code>ANNUAL</code> budgets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudgetPerformanceHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budget_performance_history_input::Builder,
    }
    impl DescribeBudgetPerformanceHistory {
        /// Creates a new `DescribeBudgetPerformanceHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetPerformanceHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetPerformanceHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBudgetPerformanceHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBudgetPerformanceHistoryPaginator {
            crate::paginator::DescribeBudgetPerformanceHistoryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
        pub fn time_period(mut self, input: crate::model::TimePeriod) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgets`.
    ///
    /// <p>Lists the budgets that are associated with an account.</p> <important>
    /// <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBudgets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_budgets_input::Builder,
    }
    impl DescribeBudgets {
        /// Creates a new `DescribeBudgets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBudgetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBudgetsPaginator {
            crate::paginator::DescribeBudgetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotificationsForBudget`.
    ///
    /// <p>Lists the notifications that are associated with a budget.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNotificationsForBudget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_notifications_for_budget_input::Builder,
    }
    impl DescribeNotificationsForBudget {
        /// Creates a new `DescribeNotificationsForBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotificationsForBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNotificationsForBudgetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeNotificationsForBudgetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeNotificationsForBudgetPaginator {
            crate::paginator::DescribeNotificationsForBudgetPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose notifications you want descriptions of.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget whose notifications you want descriptions of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubscribersForNotification`.
    ///
    /// <p>Lists the subscribers that are associated with a notification.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSubscribersForNotification {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_subscribers_for_notification_input::Builder,
    }
    impl DescribeSubscribersForNotification {
        /// Creates a new `DescribeSubscribersForNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubscribersForNotificationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeSubscribersForNotificationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSubscribersForNotificationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeSubscribersForNotificationPaginator {
            crate::paginator::DescribeSubscribersForNotificationPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose subscribers you want descriptions of.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget whose subscribers you want descriptions of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification whose subscribers you want to list.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The notification whose subscribers you want to list.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteBudgetAction`.
    ///
    /// <p> Executes a budget action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteBudgetAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_budget_action_input::Builder,
    }
    impl ExecuteBudgetAction {
        /// Creates a new `ExecuteBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteBudgetActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(input.into());
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
        /// <p> The type of execution. </p>
        pub fn execution_type(mut self, input: crate::model::ExecutionType) -> Self {
            self.inner = self.inner.execution_type(input);
            self
        }
        /// <p> The type of execution. </p>
        pub fn set_execution_type(
            mut self,
            input: std::option::Option<crate::model::ExecutionType>,
        ) -> Self {
            self.inner = self.inner.set_execution_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBudget`.
    ///
    /// <p>Updates a budget. You can change every part of a budget except for the <code>budgetName</code> and the <code>calculatedSpend</code>. When you modify a budget, the <code>calculatedSpend</code> drops to zero until Amazon Web Services has new usage data to use for forecasting.</p> <important>
    /// <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBudget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_budget_input::Builder,
    }
    impl UpdateBudget {
        /// Creates a new `UpdateBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBudgetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The budget that you want to update your budget to.</p>
        pub fn new_budget(mut self, input: crate::model::Budget) -> Self {
            self.inner = self.inner.new_budget(input);
            self
        }
        /// <p>The budget that you want to update your budget to.</p>
        pub fn set_new_budget(mut self, input: std::option::Option<crate::model::Budget>) -> Self {
            self.inner = self.inner.set_new_budget(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBudgetAction`.
    ///
    /// <p> Updates a budget action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBudgetAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_budget_action_input::Builder,
    }
    impl UpdateBudgetAction {
        /// Creates a new `UpdateBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBudgetActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(input.into());
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p>The trigger threshold of the action. </p>
        pub fn action_threshold(mut self, input: crate::model::ActionThreshold) -> Self {
            self.inner = self.inner.action_threshold(input);
            self
        }
        /// <p>The trigger threshold of the action. </p>
        pub fn set_action_threshold(
            mut self,
            input: std::option::Option<crate::model::ActionThreshold>,
        ) -> Self {
            self.inner = self.inner.set_action_threshold(input);
            self
        }
        /// <p>Specifies all of the type-specific parameters. </p>
        pub fn definition(mut self, input: crate::model::Definition) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>Specifies all of the type-specific parameters. </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::Definition>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p> The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p> This specifies if the action needs manual or automatic approval. </p>
        pub fn approval_model(mut self, input: crate::model::ApprovalModel) -> Self {
            self.inner = self.inner.approval_model(input);
            self
        }
        /// <p> This specifies if the action needs manual or automatic approval. </p>
        pub fn set_approval_model(
            mut self,
            input: std::option::Option<crate::model::ApprovalModel>,
        ) -> Self {
            self.inner = self.inner.set_approval_model(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p> A list of subscribers.</p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscribers(input);
            self
        }
        /// <p> A list of subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNotification`.
    ///
    /// <p>Updates a notification.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNotification {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_notification_input::Builder,
    }
    impl UpdateNotification {
        /// Creates a new `UpdateNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNotificationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose notification you want to update.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget whose notification you want to update.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The previous notification that is associated with a budget.</p>
        pub fn old_notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.old_notification(input);
            self
        }
        /// <p>The previous notification that is associated with a budget.</p>
        pub fn set_old_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_old_notification(input);
            self
        }
        /// <p>The updated notification to be associated with a budget.</p>
        pub fn new_notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.new_notification(input);
            self
        }
        /// <p>The updated notification to be associated with a budget.</p>
        pub fn set_new_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_new_notification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubscriber`.
    ///
    /// <p>Updates a subscriber.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSubscriber {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_subscriber_input::Builder,
    }
    impl UpdateSubscriber {
        /// Creates a new `UpdateSubscriber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubscriberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubscriberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose subscriber you want to update.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget whose subscriber you want to update.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification whose subscriber you want to update.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The notification whose subscriber you want to update.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The previous subscriber that is associated with a budget notification.</p>
        pub fn old_subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.old_subscriber(input);
            self
        }
        /// <p>The previous subscriber that is associated with a budget notification.</p>
        pub fn set_old_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_old_subscriber(input);
            self
        }
        /// <p>The updated subscriber that is associated with a budget notification.</p>
        pub fn new_subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.new_subscriber(input);
            self
        }
        /// <p>The updated subscriber that is associated with a budget notification.</p>
        pub fn set_new_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_new_subscriber(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
