// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The subscriber to a budget notification. The subscriber consists of a subscription type and either an Amazon SNS topic or an email address.</p>
/// <p>For example, an email subscriber has the following parameters:</p>
/// <ul>
/// <li> <p>A <code>subscriptionType</code> of <code>EMAIL</code> </p> </li>
/// <li> <p>An <code>address</code> of <code>example@example.com</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subscriber {
    /// <p>The type of notification that Amazon Web Services sends to a subscriber.</p>
    pub subscription_type: std::option::Option<crate::model::SubscriptionType>,
    /// <p>The address that Amazon Web Services sends budget notifications to, either an SNS topic or an email.</p>
    /// <p>When you create a subscriber, the value of <code>Address</code> can't contain line breaks.</p>
    pub address: std::option::Option<std::string::String>,
}
impl Subscriber {
    /// <p>The type of notification that Amazon Web Services sends to a subscriber.</p>
    pub fn subscription_type(&self) -> std::option::Option<&crate::model::SubscriptionType> {
        self.subscription_type.as_ref()
    }
    /// <p>The address that Amazon Web Services sends budget notifications to, either an SNS topic or an email.</p>
    /// <p>When you create a subscriber, the value of <code>Address</code> can't contain line breaks.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
}
impl std::fmt::Debug for Subscriber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subscriber");
        formatter.field("subscription_type", &self.subscription_type);
        formatter.field("address", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Subscriber`](crate::model::Subscriber)
pub mod subscriber {
    /// A builder for [`Subscriber`](crate::model::Subscriber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_type: std::option::Option<crate::model::SubscriptionType>,
        pub(crate) address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of notification that Amazon Web Services sends to a subscriber.</p>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.subscription_type = Some(input);
            self
        }
        /// <p>The type of notification that Amazon Web Services sends to a subscriber.</p>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.subscription_type = input;
            self
        }
        /// <p>The address that Amazon Web Services sends budget notifications to, either an SNS topic or an email.</p>
        /// <p>When you create a subscriber, the value of <code>Address</code> can't contain line breaks.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The address that Amazon Web Services sends budget notifications to, either an SNS topic or an email.</p>
        /// <p>When you create a subscriber, the value of <code>Address</code> can't contain line breaks.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Consumes the builder and constructs a [`Subscriber`](crate::model::Subscriber)
        pub fn build(self) -> crate::model::Subscriber {
            crate::model::Subscriber {
                subscription_type: self.subscription_type,
                address: self.address,
            }
        }
    }
}
impl Subscriber {
    /// Creates a new builder-style object to manufacture [`Subscriber`](crate::model::Subscriber)
    pub fn builder() -> crate::model::subscriber::Builder {
        crate::model::subscriber::Builder::default()
    }
}

/// <p> The subscription type of the subscriber. It can be SMS or EMAIL.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubscriptionType {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubscriptionType {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL" => SubscriptionType::Email,
            "SNS" => SubscriptionType::Sns,
            other => SubscriptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubscriptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubscriptionType::from(s))
    }
}
impl SubscriptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubscriptionType::Email => "EMAIL",
            SubscriptionType::Sns => "SNS",
            SubscriptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMAIL", "SNS"]
    }
}
impl AsRef<str> for SubscriptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A notification that's associated with a budget. A budget can have up to ten notifications. </p>
/// <p>Each notification must have at least one subscriber. A notification can have one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.</p>
/// <p>For example, if you have a budget for 200 dollars and you want to be notified when you go over 160 dollars, create a notification with the following parameters:</p>
/// <ul>
/// <li> <p>A notificationType of <code>ACTUAL</code> </p> </li>
/// <li> <p>A <code>thresholdType</code> of <code>PERCENTAGE</code> </p> </li>
/// <li> <p>A <code>comparisonOperator</code> of <code>GREATER_THAN</code> </p> </li>
/// <li> <p>A notification <code>threshold</code> of <code>80</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Notification {
    /// <p>Specifies whether the notification is for how much you have spent (<code>ACTUAL</code>) or for how much that you're forecasted to spend (<code>FORECASTED</code>).</p>
    pub notification_type: std::option::Option<crate::model::NotificationType>,
    /// <p>The comparison that's used for this notification.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>The threshold that's associated with a notification. Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.</p>
    pub threshold: f64,
    /// <p>The type of threshold for a notification. For <code>ABSOLUTE_VALUE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over your total cost threshold. For <code>PERCENTAGE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a <code>PERCENTAGE</code> threshold of 80%, Amazon Web Services notifies you when you go over 160 dollars.</p>
    pub threshold_type: std::option::Option<crate::model::ThresholdType>,
    /// <p>Specifies whether this notification is in alarm. If a budget notification is in the <code>ALARM</code> state, you passed the set threshold for the budget.</p>
    pub notification_state: std::option::Option<crate::model::NotificationState>,
}
impl Notification {
    /// <p>Specifies whether the notification is for how much you have spent (<code>ACTUAL</code>) or for how much that you're forecasted to spend (<code>FORECASTED</code>).</p>
    pub fn notification_type(&self) -> std::option::Option<&crate::model::NotificationType> {
        self.notification_type.as_ref()
    }
    /// <p>The comparison that's used for this notification.</p>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>The threshold that's associated with a notification. Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.</p>
    pub fn threshold(&self) -> f64 {
        self.threshold
    }
    /// <p>The type of threshold for a notification. For <code>ABSOLUTE_VALUE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over your total cost threshold. For <code>PERCENTAGE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a <code>PERCENTAGE</code> threshold of 80%, Amazon Web Services notifies you when you go over 160 dollars.</p>
    pub fn threshold_type(&self) -> std::option::Option<&crate::model::ThresholdType> {
        self.threshold_type.as_ref()
    }
    /// <p>Specifies whether this notification is in alarm. If a budget notification is in the <code>ALARM</code> state, you passed the set threshold for the budget.</p>
    pub fn notification_state(&self) -> std::option::Option<&crate::model::NotificationState> {
        self.notification_state.as_ref()
    }
}
impl std::fmt::Debug for Notification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Notification");
        formatter.field("notification_type", &self.notification_type);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("threshold", &self.threshold);
        formatter.field("threshold_type", &self.threshold_type);
        formatter.field("notification_state", &self.notification_state);
        formatter.finish()
    }
}
/// See [`Notification`](crate::model::Notification)
pub mod notification {
    /// A builder for [`Notification`](crate::model::Notification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_type: std::option::Option<crate::model::NotificationType>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) threshold: std::option::Option<f64>,
        pub(crate) threshold_type: std::option::Option<crate::model::ThresholdType>,
        pub(crate) notification_state: std::option::Option<crate::model::NotificationState>,
    }
    impl Builder {
        /// <p>Specifies whether the notification is for how much you have spent (<code>ACTUAL</code>) or for how much that you're forecasted to spend (<code>FORECASTED</code>).</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.notification_type = Some(input);
            self
        }
        /// <p>Specifies whether the notification is for how much you have spent (<code>ACTUAL</code>) or for how much that you're forecasted to spend (<code>FORECASTED</code>).</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// <p>The comparison that's used for this notification.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>The comparison that's used for this notification.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>The threshold that's associated with a notification. Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.</p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The threshold that's associated with a notification. Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.</p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>The type of threshold for a notification. For <code>ABSOLUTE_VALUE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over your total cost threshold. For <code>PERCENTAGE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a <code>PERCENTAGE</code> threshold of 80%, Amazon Web Services notifies you when you go over 160 dollars.</p>
        pub fn threshold_type(mut self, input: crate::model::ThresholdType) -> Self {
            self.threshold_type = Some(input);
            self
        }
        /// <p>The type of threshold for a notification. For <code>ABSOLUTE_VALUE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over your total cost threshold. For <code>PERCENTAGE</code> thresholds, Amazon Web Services notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a <code>PERCENTAGE</code> threshold of 80%, Amazon Web Services notifies you when you go over 160 dollars.</p>
        pub fn set_threshold_type(
            mut self,
            input: std::option::Option<crate::model::ThresholdType>,
        ) -> Self {
            self.threshold_type = input;
            self
        }
        /// <p>Specifies whether this notification is in alarm. If a budget notification is in the <code>ALARM</code> state, you passed the set threshold for the budget.</p>
        pub fn notification_state(mut self, input: crate::model::NotificationState) -> Self {
            self.notification_state = Some(input);
            self
        }
        /// <p>Specifies whether this notification is in alarm. If a budget notification is in the <code>ALARM</code> state, you passed the set threshold for the budget.</p>
        pub fn set_notification_state(
            mut self,
            input: std::option::Option<crate::model::NotificationState>,
        ) -> Self {
            self.notification_state = input;
            self
        }
        /// Consumes the builder and constructs a [`Notification`](crate::model::Notification)
        pub fn build(self) -> crate::model::Notification {
            crate::model::Notification {
                notification_type: self.notification_type,
                comparison_operator: self.comparison_operator,
                threshold: self.threshold.unwrap_or_default(),
                threshold_type: self.threshold_type,
                notification_state: self.notification_state,
            }
        }
    }
}
impl Notification {
    /// Creates a new builder-style object to manufacture [`Notification`](crate::model::Notification)
    pub fn builder() -> crate::model::notification::Builder {
        crate::model::notification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationState {
    #[allow(missing_docs)] // documentation missing in model
    Alarm,
    #[allow(missing_docs)] // documentation missing in model
    Ok,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationState {
    fn from(s: &str) -> Self {
        match s {
            "ALARM" => NotificationState::Alarm,
            "OK" => NotificationState::Ok,
            other => NotificationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationState::from(s))
    }
}
impl NotificationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationState::Alarm => "ALARM",
            NotificationState::Ok => "OK",
            NotificationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALARM", "OK"]
    }
}
impl AsRef<str> for NotificationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The type of threshold for a notification.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThresholdType {
    #[allow(missing_docs)] // documentation missing in model
    AbsoluteValue,
    #[allow(missing_docs)] // documentation missing in model
    Percentage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThresholdType {
    fn from(s: &str) -> Self {
        match s {
            "ABSOLUTE_VALUE" => ThresholdType::AbsoluteValue,
            "PERCENTAGE" => ThresholdType::Percentage,
            other => ThresholdType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThresholdType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThresholdType::from(s))
    }
}
impl ThresholdType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThresholdType::AbsoluteValue => "ABSOLUTE_VALUE",
            ThresholdType::Percentage => "PERCENTAGE",
            ThresholdType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABSOLUTE_VALUE", "PERCENTAGE"]
    }
}
impl AsRef<str> for ThresholdType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The comparison operator of a notification. Currently, the service supports the following
/// operators:</p>
/// <p>
/// <code>GREATER_THAN</code>, <code>LESS_THAN</code>, <code>EQUAL_TO</code>
/// </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "EQUAL_TO" => ComparisonOperator::EqualTo,
            "GREATER_THAN" => ComparisonOperator::GreaterThan,
            "LESS_THAN" => ComparisonOperator::LessThan,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::EqualTo => "EQUAL_TO",
            ComparisonOperator::GreaterThan => "GREATER_THAN",
            ComparisonOperator::LessThan => "LESS_THAN",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUAL_TO", "GREATER_THAN", "LESS_THAN"]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationType {
    #[allow(missing_docs)] // documentation missing in model
    Actual,
    #[allow(missing_docs)] // documentation missing in model
    Forecasted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationType {
    fn from(s: &str) -> Self {
        match s {
            "ACTUAL" => NotificationType::Actual,
            "FORECASTED" => NotificationType::Forecasted,
            other => NotificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationType::from(s))
    }
}
impl NotificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationType::Actual => "ACTUAL",
            NotificationType::Forecasted => "FORECASTED",
            NotificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTUAL", "FORECASTED"]
    }
}
impl AsRef<str> for NotificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A budget action resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>A system-generated universally unique identifier (UUID) for the action. </p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
    pub notification_type: std::option::Option<crate::model::NotificationType>,
    /// <p>The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>The trigger threshold of the action. </p>
    pub action_threshold: std::option::Option<crate::model::ActionThreshold>,
    /// <p>Where you specify all of the type-specific parameters. </p>
    pub definition: std::option::Option<crate::model::Definition>,
    /// <p>The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>This specifies if the action needs manual or automatic approval. </p>
    pub approval_model: std::option::Option<crate::model::ApprovalModel>,
    /// <p>The status of the action. </p>
    pub status: std::option::Option<crate::model::ActionStatus>,
    /// <p> A list of subscribers.</p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
}
impl Action {
    /// <p>A system-generated universally unique identifier (UUID) for the action. </p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
    pub fn notification_type(&self) -> std::option::Option<&crate::model::NotificationType> {
        self.notification_type.as_ref()
    }
    /// <p>The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ActionType> {
        self.action_type.as_ref()
    }
    /// <p>The trigger threshold of the action. </p>
    pub fn action_threshold(&self) -> std::option::Option<&crate::model::ActionThreshold> {
        self.action_threshold.as_ref()
    }
    /// <p>Where you specify all of the type-specific parameters. </p>
    pub fn definition(&self) -> std::option::Option<&crate::model::Definition> {
        self.definition.as_ref()
    }
    /// <p>The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>This specifies if the action needs manual or automatic approval. </p>
    pub fn approval_model(&self) -> std::option::Option<&crate::model::ApprovalModel> {
        self.approval_model.as_ref()
    }
    /// <p>The status of the action. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ActionStatus> {
        self.status.as_ref()
    }
    /// <p> A list of subscribers.</p>
    pub fn subscribers(&self) -> std::option::Option<&[crate::model::Subscriber]> {
        self.subscribers.as_deref()
    }
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("action_id", &self.action_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification_type", &self.notification_type);
        formatter.field("action_type", &self.action_type);
        formatter.field("action_threshold", &self.action_threshold);
        formatter.field("definition", &self.definition);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("approval_model", &self.approval_model);
        formatter.field("status", &self.status);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification_type: std::option::Option<crate::model::NotificationType>,
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) action_threshold: std::option::Option<crate::model::ActionThreshold>,
        pub(crate) definition: std::option::Option<crate::model::Definition>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) approval_model: std::option::Option<crate::model::ApprovalModel>,
        pub(crate) status: std::option::Option<crate::model::ActionStatus>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    }
    impl Builder {
        /// <p>A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.notification_type = Some(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// <p>The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>The trigger threshold of the action. </p>
        pub fn action_threshold(mut self, input: crate::model::ActionThreshold) -> Self {
            self.action_threshold = Some(input);
            self
        }
        /// <p>The trigger threshold of the action. </p>
        pub fn set_action_threshold(
            mut self,
            input: std::option::Option<crate::model::ActionThreshold>,
        ) -> Self {
            self.action_threshold = input;
            self
        }
        /// <p>Where you specify all of the type-specific parameters. </p>
        pub fn definition(mut self, input: crate::model::Definition) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>Where you specify all of the type-specific parameters. </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::Definition>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The role passed for action execution and reversion. Roles and actions must be in the same account. </p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>This specifies if the action needs manual or automatic approval. </p>
        pub fn approval_model(mut self, input: crate::model::ApprovalModel) -> Self {
            self.approval_model = Some(input);
            self
        }
        /// <p>This specifies if the action needs manual or automatic approval. </p>
        pub fn set_approval_model(
            mut self,
            input: std::option::Option<crate::model::ApprovalModel>,
        ) -> Self {
            self.approval_model = input;
            self
        }
        /// <p>The status of the action. </p>
        pub fn status(mut self, input: crate::model::ActionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p> A list of subscribers.</p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input);
            self.subscribers = Some(v);
            self
        }
        /// <p> A list of subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                action_id: self.action_id,
                budget_name: self.budget_name,
                notification_type: self.notification_type,
                action_type: self.action_type,
                action_threshold: self.action_threshold,
                definition: self.definition,
                execution_role_arn: self.execution_role_arn,
                approval_model: self.approval_model,
                status: self.status,
                subscribers: self.subscribers,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionStatus {
    #[allow(missing_docs)] // documentation missing in model
    ExecutionFailure,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionSuccess,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    ResetFailure,
    #[allow(missing_docs)] // documentation missing in model
    ResetInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ReverseFailure,
    #[allow(missing_docs)] // documentation missing in model
    ReverseInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ReverseSuccess,
    #[allow(missing_docs)] // documentation missing in model
    Standby,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionStatus {
    fn from(s: &str) -> Self {
        match s {
            "EXECUTION_FAILURE" => ActionStatus::ExecutionFailure,
            "EXECUTION_IN_PROGRESS" => ActionStatus::ExecutionInProgress,
            "EXECUTION_SUCCESS" => ActionStatus::ExecutionSuccess,
            "PENDING" => ActionStatus::Pending,
            "RESET_FAILURE" => ActionStatus::ResetFailure,
            "RESET_IN_PROGRESS" => ActionStatus::ResetInProgress,
            "REVERSE_FAILURE" => ActionStatus::ReverseFailure,
            "REVERSE_IN_PROGRESS" => ActionStatus::ReverseInProgress,
            "REVERSE_SUCCESS" => ActionStatus::ReverseSuccess,
            "STANDBY" => ActionStatus::Standby,
            other => ActionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionStatus::from(s))
    }
}
impl ActionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionStatus::ExecutionFailure => "EXECUTION_FAILURE",
            ActionStatus::ExecutionInProgress => "EXECUTION_IN_PROGRESS",
            ActionStatus::ExecutionSuccess => "EXECUTION_SUCCESS",
            ActionStatus::Pending => "PENDING",
            ActionStatus::ResetFailure => "RESET_FAILURE",
            ActionStatus::ResetInProgress => "RESET_IN_PROGRESS",
            ActionStatus::ReverseFailure => "REVERSE_FAILURE",
            ActionStatus::ReverseInProgress => "REVERSE_IN_PROGRESS",
            ActionStatus::ReverseSuccess => "REVERSE_SUCCESS",
            ActionStatus::Standby => "STANDBY",
            ActionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXECUTION_FAILURE",
            "EXECUTION_IN_PROGRESS",
            "EXECUTION_SUCCESS",
            "PENDING",
            "RESET_FAILURE",
            "RESET_IN_PROGRESS",
            "REVERSE_FAILURE",
            "REVERSE_IN_PROGRESS",
            "REVERSE_SUCCESS",
            "STANDBY",
        ]
    }
}
impl AsRef<str> for ActionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApprovalModel {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApprovalModel {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC" => ApprovalModel::Auto,
            "MANUAL" => ApprovalModel::Manual,
            other => ApprovalModel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApprovalModel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApprovalModel::from(s))
    }
}
impl ApprovalModel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApprovalModel::Auto => "AUTOMATIC",
            ApprovalModel::Manual => "MANUAL",
            ApprovalModel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC", "MANUAL"]
    }
}
impl AsRef<str> for ApprovalModel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies all of the type-specific parameters. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Definition {
    /// <p>The Identity and Access Management (IAM) action definition details. </p>
    pub iam_action_definition: std::option::Option<crate::model::IamActionDefinition>,
    /// <p>The service control policies (SCPs) action definition details. </p>
    pub scp_action_definition: std::option::Option<crate::model::ScpActionDefinition>,
    /// <p>The Amazon Web Services Systems Manager (SSM) action definition details. </p>
    pub ssm_action_definition: std::option::Option<crate::model::SsmActionDefinition>,
}
impl Definition {
    /// <p>The Identity and Access Management (IAM) action definition details. </p>
    pub fn iam_action_definition(&self) -> std::option::Option<&crate::model::IamActionDefinition> {
        self.iam_action_definition.as_ref()
    }
    /// <p>The service control policies (SCPs) action definition details. </p>
    pub fn scp_action_definition(&self) -> std::option::Option<&crate::model::ScpActionDefinition> {
        self.scp_action_definition.as_ref()
    }
    /// <p>The Amazon Web Services Systems Manager (SSM) action definition details. </p>
    pub fn ssm_action_definition(&self) -> std::option::Option<&crate::model::SsmActionDefinition> {
        self.ssm_action_definition.as_ref()
    }
}
impl std::fmt::Debug for Definition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Definition");
        formatter.field("iam_action_definition", &self.iam_action_definition);
        formatter.field("scp_action_definition", &self.scp_action_definition);
        formatter.field("ssm_action_definition", &self.ssm_action_definition);
        formatter.finish()
    }
}
/// See [`Definition`](crate::model::Definition)
pub mod definition {
    /// A builder for [`Definition`](crate::model::Definition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_action_definition: std::option::Option<crate::model::IamActionDefinition>,
        pub(crate) scp_action_definition: std::option::Option<crate::model::ScpActionDefinition>,
        pub(crate) ssm_action_definition: std::option::Option<crate::model::SsmActionDefinition>,
    }
    impl Builder {
        /// <p>The Identity and Access Management (IAM) action definition details. </p>
        pub fn iam_action_definition(mut self, input: crate::model::IamActionDefinition) -> Self {
            self.iam_action_definition = Some(input);
            self
        }
        /// <p>The Identity and Access Management (IAM) action definition details. </p>
        pub fn set_iam_action_definition(
            mut self,
            input: std::option::Option<crate::model::IamActionDefinition>,
        ) -> Self {
            self.iam_action_definition = input;
            self
        }
        /// <p>The service control policies (SCPs) action definition details. </p>
        pub fn scp_action_definition(mut self, input: crate::model::ScpActionDefinition) -> Self {
            self.scp_action_definition = Some(input);
            self
        }
        /// <p>The service control policies (SCPs) action definition details. </p>
        pub fn set_scp_action_definition(
            mut self,
            input: std::option::Option<crate::model::ScpActionDefinition>,
        ) -> Self {
            self.scp_action_definition = input;
            self
        }
        /// <p>The Amazon Web Services Systems Manager (SSM) action definition details. </p>
        pub fn ssm_action_definition(mut self, input: crate::model::SsmActionDefinition) -> Self {
            self.ssm_action_definition = Some(input);
            self
        }
        /// <p>The Amazon Web Services Systems Manager (SSM) action definition details. </p>
        pub fn set_ssm_action_definition(
            mut self,
            input: std::option::Option<crate::model::SsmActionDefinition>,
        ) -> Self {
            self.ssm_action_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`Definition`](crate::model::Definition)
        pub fn build(self) -> crate::model::Definition {
            crate::model::Definition {
                iam_action_definition: self.iam_action_definition,
                scp_action_definition: self.scp_action_definition,
                ssm_action_definition: self.ssm_action_definition,
            }
        }
    }
}
impl Definition {
    /// Creates a new builder-style object to manufacture [`Definition`](crate::model::Definition)
    pub fn builder() -> crate::model::definition::Builder {
        crate::model::definition::Builder::default()
    }
}

/// <p>The Amazon Web Services Systems Manager (SSM) action definition details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmActionDefinition {
    /// <p>The action subType. </p>
    pub action_sub_type: std::option::Option<crate::model::ActionSubType>,
    /// <p>The Region to run the SSM document. </p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The EC2 and RDS instance IDs. </p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SsmActionDefinition {
    /// <p>The action subType. </p>
    pub fn action_sub_type(&self) -> std::option::Option<&crate::model::ActionSubType> {
        self.action_sub_type.as_ref()
    }
    /// <p>The Region to run the SSM document. </p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The EC2 and RDS instance IDs. </p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
}
impl std::fmt::Debug for SsmActionDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmActionDefinition");
        formatter.field("action_sub_type", &self.action_sub_type);
        formatter.field("region", &self.region);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.finish()
    }
}
/// See [`SsmActionDefinition`](crate::model::SsmActionDefinition)
pub mod ssm_action_definition {
    /// A builder for [`SsmActionDefinition`](crate::model::SsmActionDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_sub_type: std::option::Option<crate::model::ActionSubType>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The action subType. </p>
        pub fn action_sub_type(mut self, input: crate::model::ActionSubType) -> Self {
            self.action_sub_type = Some(input);
            self
        }
        /// <p>The action subType. </p>
        pub fn set_action_sub_type(
            mut self,
            input: std::option::Option<crate::model::ActionSubType>,
        ) -> Self {
            self.action_sub_type = input;
            self
        }
        /// <p>The Region to run the SSM document. </p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region to run the SSM document. </p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The EC2 and RDS instance IDs. </p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The EC2 and RDS instance IDs. </p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmActionDefinition`](crate::model::SsmActionDefinition)
        pub fn build(self) -> crate::model::SsmActionDefinition {
            crate::model::SsmActionDefinition {
                action_sub_type: self.action_sub_type,
                region: self.region,
                instance_ids: self.instance_ids,
            }
        }
    }
}
impl SsmActionDefinition {
    /// Creates a new builder-style object to manufacture [`SsmActionDefinition`](crate::model::SsmActionDefinition)
    pub fn builder() -> crate::model::ssm_action_definition::Builder {
        crate::model::ssm_action_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionSubType {
    #[allow(missing_docs)] // documentation missing in model
    StopEc2,
    #[allow(missing_docs)] // documentation missing in model
    StopRds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionSubType {
    fn from(s: &str) -> Self {
        match s {
            "STOP_EC2_INSTANCES" => ActionSubType::StopEc2,
            "STOP_RDS_INSTANCES" => ActionSubType::StopRds,
            other => ActionSubType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionSubType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionSubType::from(s))
    }
}
impl ActionSubType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionSubType::StopEc2 => "STOP_EC2_INSTANCES",
            ActionSubType::StopRds => "STOP_RDS_INSTANCES",
            ActionSubType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STOP_EC2_INSTANCES", "STOP_RDS_INSTANCES"]
    }
}
impl AsRef<str> for ActionSubType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The service control policies (SCP) action definition details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScpActionDefinition {
    /// <p>The policy ID attached. </p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>A list of target IDs. </p>
    pub target_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ScpActionDefinition {
    /// <p>The policy ID attached. </p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>A list of target IDs. </p>
    pub fn target_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.target_ids.as_deref()
    }
}
impl std::fmt::Debug for ScpActionDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScpActionDefinition");
        formatter.field("policy_id", &self.policy_id);
        formatter.field("target_ids", &self.target_ids);
        formatter.finish()
    }
}
/// See [`ScpActionDefinition`](crate::model::ScpActionDefinition)
pub mod scp_action_definition {
    /// A builder for [`ScpActionDefinition`](crate::model::ScpActionDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) target_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The policy ID attached. </p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The policy ID attached. </p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// Appends an item to `target_ids`.
        ///
        /// To override the contents of this collection use [`set_target_ids`](Self::set_target_ids).
        ///
        /// <p>A list of target IDs. </p>
        pub fn target_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_ids.unwrap_or_default();
            v.push(input.into());
            self.target_ids = Some(v);
            self
        }
        /// <p>A list of target IDs. </p>
        pub fn set_target_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ScpActionDefinition`](crate::model::ScpActionDefinition)
        pub fn build(self) -> crate::model::ScpActionDefinition {
            crate::model::ScpActionDefinition {
                policy_id: self.policy_id,
                target_ids: self.target_ids,
            }
        }
    }
}
impl ScpActionDefinition {
    /// Creates a new builder-style object to manufacture [`ScpActionDefinition`](crate::model::ScpActionDefinition)
    pub fn builder() -> crate::model::scp_action_definition::Builder {
        crate::model::scp_action_definition::Builder::default()
    }
}

/// <p>The Identity and Access Management (IAM) action definition details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamActionDefinition {
    /// <p>The Amazon Resource Name (ARN) of the policy to be attached. </p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>A list of roles to be attached. There must be at least one role. </p>
    pub roles: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of groups to be attached. There must be at least one group. </p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of users to be attached. There must be at least one user. </p>
    pub users: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl IamActionDefinition {
    /// <p>The Amazon Resource Name (ARN) of the policy to be attached. </p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>A list of roles to be attached. There must be at least one role. </p>
    pub fn roles(&self) -> std::option::Option<&[std::string::String]> {
        self.roles.as_deref()
    }
    /// <p>A list of groups to be attached. There must be at least one group. </p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>A list of users to be attached. There must be at least one user. </p>
    pub fn users(&self) -> std::option::Option<&[std::string::String]> {
        self.users.as_deref()
    }
}
impl std::fmt::Debug for IamActionDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamActionDefinition");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("roles", &self.roles);
        formatter.field("groups", &self.groups);
        formatter.field("users", &self.users);
        formatter.finish()
    }
}
/// See [`IamActionDefinition`](crate::model::IamActionDefinition)
pub mod iam_action_definition {
    /// A builder for [`IamActionDefinition`](crate::model::IamActionDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) roles: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) users: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the policy to be attached. </p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy to be attached. </p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>A list of roles to be attached. There must be at least one role. </p>
        pub fn roles(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p>A list of roles to be attached. There must be at least one role. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>A list of groups to be attached. There must be at least one group. </p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>A list of groups to be attached. There must be at least one group. </p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>A list of users to be attached. There must be at least one user. </p>
        pub fn users(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>A list of users to be attached. There must be at least one user. </p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Consumes the builder and constructs a [`IamActionDefinition`](crate::model::IamActionDefinition)
        pub fn build(self) -> crate::model::IamActionDefinition {
            crate::model::IamActionDefinition {
                policy_arn: self.policy_arn,
                roles: self.roles,
                groups: self.groups,
                users: self.users,
            }
        }
    }
}
impl IamActionDefinition {
    /// Creates a new builder-style object to manufacture [`IamActionDefinition`](crate::model::IamActionDefinition)
    pub fn builder() -> crate::model::iam_action_definition::Builder {
        crate::model::iam_action_definition::Builder::default()
    }
}

/// <p>The trigger threshold of the action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionThreshold {
    /// <p> The threshold of a notification.</p>
    pub action_threshold_value: f64,
    /// <p> The type of threshold for a notification.</p>
    pub action_threshold_type: std::option::Option<crate::model::ThresholdType>,
}
impl ActionThreshold {
    /// <p> The threshold of a notification.</p>
    pub fn action_threshold_value(&self) -> f64 {
        self.action_threshold_value
    }
    /// <p> The type of threshold for a notification.</p>
    pub fn action_threshold_type(&self) -> std::option::Option<&crate::model::ThresholdType> {
        self.action_threshold_type.as_ref()
    }
}
impl std::fmt::Debug for ActionThreshold {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionThreshold");
        formatter.field("action_threshold_value", &self.action_threshold_value);
        formatter.field("action_threshold_type", &self.action_threshold_type);
        formatter.finish()
    }
}
/// See [`ActionThreshold`](crate::model::ActionThreshold)
pub mod action_threshold {
    /// A builder for [`ActionThreshold`](crate::model::ActionThreshold)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_threshold_value: std::option::Option<f64>,
        pub(crate) action_threshold_type: std::option::Option<crate::model::ThresholdType>,
    }
    impl Builder {
        /// <p> The threshold of a notification.</p>
        pub fn action_threshold_value(mut self, input: f64) -> Self {
            self.action_threshold_value = Some(input);
            self
        }
        /// <p> The threshold of a notification.</p>
        pub fn set_action_threshold_value(mut self, input: std::option::Option<f64>) -> Self {
            self.action_threshold_value = input;
            self
        }
        /// <p> The type of threshold for a notification.</p>
        pub fn action_threshold_type(mut self, input: crate::model::ThresholdType) -> Self {
            self.action_threshold_type = Some(input);
            self
        }
        /// <p> The type of threshold for a notification.</p>
        pub fn set_action_threshold_type(
            mut self,
            input: std::option::Option<crate::model::ThresholdType>,
        ) -> Self {
            self.action_threshold_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionThreshold`](crate::model::ActionThreshold)
        pub fn build(self) -> crate::model::ActionThreshold {
            crate::model::ActionThreshold {
                action_threshold_value: self.action_threshold_value.unwrap_or_default(),
                action_threshold_type: self.action_threshold_type,
            }
        }
    }
}
impl ActionThreshold {
    /// Creates a new builder-style object to manufacture [`ActionThreshold`](crate::model::ActionThreshold)
    pub fn builder() -> crate::model::action_threshold::Builder {
        crate::model::action_threshold::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionType {
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    #[allow(missing_docs)] // documentation missing in model
    Scp,
    #[allow(missing_docs)] // documentation missing in model
    Ssm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionType {
    fn from(s: &str) -> Self {
        match s {
            "APPLY_IAM_POLICY" => ActionType::Iam,
            "APPLY_SCP_POLICY" => ActionType::Scp,
            "RUN_SSM_DOCUMENTS" => ActionType::Ssm,
            other => ActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionType::from(s))
    }
}
impl ActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionType::Iam => "APPLY_IAM_POLICY",
            ActionType::Scp => "APPLY_SCP_POLICY",
            ActionType::Ssm => "RUN_SSM_DOCUMENTS",
            ActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLY_IAM_POLICY", "APPLY_SCP_POLICY", "RUN_SSM_DOCUMENTS"]
    }
}
impl AsRef<str> for ActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the output of the <code>CreateBudget</code> operation. The content consists of the detailed metadata and data file information, and the current status of the <code>budget</code> object.</p>
/// <p>This is the Amazon Resource Name (ARN) pattern for a budget: </p>
/// <p> <code>arn:aws:budgets::AccountId:budget/budgetName</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Budget {
    /// <p>The name of a budget. The name must be unique within an account. The <code>:</code> and <code>\</code> characters aren't allowed in <code>BudgetName</code>.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.</p>
    /// <p> <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code>. This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions. </p>
    pub budget_limit: std::option::Option<crate::model::Spend>,
    /// <p>A map containing multiple <code>BudgetLimit</code>, including current or future limits.</p>
    /// <p> <code>PlannedBudgetLimits</code> is available for cost or usage budget and supports both monthly and quarterly <code>TimeUnit</code>. </p>
    /// <p>For monthly budgets, provide 12 months of <code>PlannedBudgetLimits</code> values. This must start from the current month and include the next 11 months. The <code>key</code> is the start of the month, <code>UTC</code> in epoch seconds. </p>
    /// <p>For quarterly budgets, provide four quarters of <code>PlannedBudgetLimits</code> value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The <code>key</code> is the start of the quarter, <code>UTC</code> in epoch seconds. </p>
    /// <p>If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the <code>PlannedBudgetLimits</code> values only for the remaining periods.</p>
    /// <p>If the budget begins at a date in the future, provide <code>PlannedBudgetLimits</code> values from the start date of the budget. </p>
    /// <p>After all of the <code>BudgetLimit</code> values in <code>PlannedBudgetLimits</code> are used, the budget continues to use the last limit as the <code>BudgetLimit</code>. At that point, the planned budget provides the same experience as a fixed budget. </p>
    /// <p> <code>DescribeBudget</code> and <code>DescribeBudgets</code> response along with <code>PlannedBudgetLimits</code> also contain <code>BudgetLimit</code> representing the current month or quarter limit present in <code>PlannedBudgetLimits</code>. This only applies to budgets that are created with <code>PlannedBudgetLimits</code>. Budgets that are created without <code>PlannedBudgetLimits</code> only contain <code>BudgetLimit</code>. They don't contain <code>PlannedBudgetLimits</code>.</p>
    pub planned_budget_limits:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Spend>>,
    /// <p>The cost filters, such as <code>Region</code>, <code>Service</code>, <code>member account</code>, <code>Tag</code>, or <code>Cost Category</code>, that are applied to a budget.</p>
    /// <p>Amazon Web Services Budgets supports the following services as a <code>Service</code> filter for RI budgets:</p>
    /// <ul>
    /// <li> <p>Amazon EC2</p> </li>
    /// <li> <p>Amazon Redshift</p> </li>
    /// <li> <p>Amazon Relational Database Service</p> </li>
    /// <li> <p>Amazon ElastiCache</p> </li>
    /// <li> <p>Amazon OpenSearch Service</p> </li>
    /// </ul>
    pub cost_filters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The types of costs that are included in this <code>COST</code> budget.</p>
    /// <p> <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code>.</p>
    pub cost_types: std::option::Option<crate::model::CostTypes>,
    /// <p>The length of time until a budget resets the actual and forecasted spend.</p>
    pub time_unit: std::option::Option<crate::model::TimeUnit>,
    /// <p>The period of time that's covered by a budget. You setthe start date and end date. The start date must come before the end date. The end date must come before <code>06/15/87 00:00 UTC</code>. </p>
    /// <p>If you create your budget and don't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API. </p>
    /// <p>You can change either date with the <code>UpdateBudget</code> operation.</p>
    /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers.</p>
    pub time_period: std::option::Option<crate::model::TimePeriod>,
    /// <p>The actual and forecasted cost or usage that the budget tracks.</p>
    pub calculated_spend: std::option::Option<crate::model::CalculatedSpend>,
    /// <p>Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.</p>
    pub budget_type: std::option::Option<crate::model::BudgetType>,
    /// <p>The last time that you updated this budget.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The parameters that determine the budget amount for an auto-adjusting budget.</p>
    pub auto_adjust_data: std::option::Option<crate::model::AutoAdjustData>,
}
impl Budget {
    /// <p>The name of a budget. The name must be unique within an account. The <code>:</code> and <code>\</code> characters aren't allowed in <code>BudgetName</code>.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p>The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.</p>
    /// <p> <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code>. This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions. </p>
    pub fn budget_limit(&self) -> std::option::Option<&crate::model::Spend> {
        self.budget_limit.as_ref()
    }
    /// <p>A map containing multiple <code>BudgetLimit</code>, including current or future limits.</p>
    /// <p> <code>PlannedBudgetLimits</code> is available for cost or usage budget and supports both monthly and quarterly <code>TimeUnit</code>. </p>
    /// <p>For monthly budgets, provide 12 months of <code>PlannedBudgetLimits</code> values. This must start from the current month and include the next 11 months. The <code>key</code> is the start of the month, <code>UTC</code> in epoch seconds. </p>
    /// <p>For quarterly budgets, provide four quarters of <code>PlannedBudgetLimits</code> value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The <code>key</code> is the start of the quarter, <code>UTC</code> in epoch seconds. </p>
    /// <p>If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the <code>PlannedBudgetLimits</code> values only for the remaining periods.</p>
    /// <p>If the budget begins at a date in the future, provide <code>PlannedBudgetLimits</code> values from the start date of the budget. </p>
    /// <p>After all of the <code>BudgetLimit</code> values in <code>PlannedBudgetLimits</code> are used, the budget continues to use the last limit as the <code>BudgetLimit</code>. At that point, the planned budget provides the same experience as a fixed budget. </p>
    /// <p> <code>DescribeBudget</code> and <code>DescribeBudgets</code> response along with <code>PlannedBudgetLimits</code> also contain <code>BudgetLimit</code> representing the current month or quarter limit present in <code>PlannedBudgetLimits</code>. This only applies to budgets that are created with <code>PlannedBudgetLimits</code>. Budgets that are created without <code>PlannedBudgetLimits</code> only contain <code>BudgetLimit</code>. They don't contain <code>PlannedBudgetLimits</code>.</p>
    pub fn planned_budget_limits(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Spend>>
    {
        self.planned_budget_limits.as_ref()
    }
    /// <p>The cost filters, such as <code>Region</code>, <code>Service</code>, <code>member account</code>, <code>Tag</code>, or <code>Cost Category</code>, that are applied to a budget.</p>
    /// <p>Amazon Web Services Budgets supports the following services as a <code>Service</code> filter for RI budgets:</p>
    /// <ul>
    /// <li> <p>Amazon EC2</p> </li>
    /// <li> <p>Amazon Redshift</p> </li>
    /// <li> <p>Amazon Relational Database Service</p> </li>
    /// <li> <p>Amazon ElastiCache</p> </li>
    /// <li> <p>Amazon OpenSearch Service</p> </li>
    /// </ul>
    pub fn cost_filters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.cost_filters.as_ref()
    }
    /// <p>The types of costs that are included in this <code>COST</code> budget.</p>
    /// <p> <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code>.</p>
    pub fn cost_types(&self) -> std::option::Option<&crate::model::CostTypes> {
        self.cost_types.as_ref()
    }
    /// <p>The length of time until a budget resets the actual and forecasted spend.</p>
    pub fn time_unit(&self) -> std::option::Option<&crate::model::TimeUnit> {
        self.time_unit.as_ref()
    }
    /// <p>The period of time that's covered by a budget. You setthe start date and end date. The start date must come before the end date. The end date must come before <code>06/15/87 00:00 UTC</code>. </p>
    /// <p>If you create your budget and don't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API. </p>
    /// <p>You can change either date with the <code>UpdateBudget</code> operation.</p>
    /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::TimePeriod> {
        self.time_period.as_ref()
    }
    /// <p>The actual and forecasted cost or usage that the budget tracks.</p>
    pub fn calculated_spend(&self) -> std::option::Option<&crate::model::CalculatedSpend> {
        self.calculated_spend.as_ref()
    }
    /// <p>Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.</p>
    pub fn budget_type(&self) -> std::option::Option<&crate::model::BudgetType> {
        self.budget_type.as_ref()
    }
    /// <p>The last time that you updated this budget.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The parameters that determine the budget amount for an auto-adjusting budget.</p>
    pub fn auto_adjust_data(&self) -> std::option::Option<&crate::model::AutoAdjustData> {
        self.auto_adjust_data.as_ref()
    }
}
impl std::fmt::Debug for Budget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Budget");
        formatter.field("budget_name", &self.budget_name);
        formatter.field("budget_limit", &self.budget_limit);
        formatter.field("planned_budget_limits", &self.planned_budget_limits);
        formatter.field("cost_filters", &self.cost_filters);
        formatter.field("cost_types", &self.cost_types);
        formatter.field("time_unit", &self.time_unit);
        formatter.field("time_period", &self.time_period);
        formatter.field("calculated_spend", &self.calculated_spend);
        formatter.field("budget_type", &self.budget_type);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("auto_adjust_data", &self.auto_adjust_data);
        formatter.finish()
    }
}
/// See [`Budget`](crate::model::Budget)
pub mod budget {
    /// A builder for [`Budget`](crate::model::Budget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) budget_limit: std::option::Option<crate::model::Spend>,
        pub(crate) planned_budget_limits: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Spend>,
        >,
        pub(crate) cost_filters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) cost_types: std::option::Option<crate::model::CostTypes>,
        pub(crate) time_unit: std::option::Option<crate::model::TimeUnit>,
        pub(crate) time_period: std::option::Option<crate::model::TimePeriod>,
        pub(crate) calculated_spend: std::option::Option<crate::model::CalculatedSpend>,
        pub(crate) budget_type: std::option::Option<crate::model::BudgetType>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) auto_adjust_data: std::option::Option<crate::model::AutoAdjustData>,
    }
    impl Builder {
        /// <p>The name of a budget. The name must be unique within an account. The <code>:</code> and <code>\</code> characters aren't allowed in <code>BudgetName</code>.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of a budget. The name must be unique within an account. The <code>:</code> and <code>\</code> characters aren't allowed in <code>BudgetName</code>.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.</p>
        /// <p> <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code>. This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions. </p>
        pub fn budget_limit(mut self, input: crate::model::Spend) -> Self {
            self.budget_limit = Some(input);
            self
        }
        /// <p>The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.</p>
        /// <p> <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code>. This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions. </p>
        pub fn set_budget_limit(mut self, input: std::option::Option<crate::model::Spend>) -> Self {
            self.budget_limit = input;
            self
        }
        /// Adds a key-value pair to `planned_budget_limits`.
        ///
        /// To override the contents of this collection use [`set_planned_budget_limits`](Self::set_planned_budget_limits).
        ///
        /// <p>A map containing multiple <code>BudgetLimit</code>, including current or future limits.</p>
        /// <p> <code>PlannedBudgetLimits</code> is available for cost or usage budget and supports both monthly and quarterly <code>TimeUnit</code>. </p>
        /// <p>For monthly budgets, provide 12 months of <code>PlannedBudgetLimits</code> values. This must start from the current month and include the next 11 months. The <code>key</code> is the start of the month, <code>UTC</code> in epoch seconds. </p>
        /// <p>For quarterly budgets, provide four quarters of <code>PlannedBudgetLimits</code> value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The <code>key</code> is the start of the quarter, <code>UTC</code> in epoch seconds. </p>
        /// <p>If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the <code>PlannedBudgetLimits</code> values only for the remaining periods.</p>
        /// <p>If the budget begins at a date in the future, provide <code>PlannedBudgetLimits</code> values from the start date of the budget. </p>
        /// <p>After all of the <code>BudgetLimit</code> values in <code>PlannedBudgetLimits</code> are used, the budget continues to use the last limit as the <code>BudgetLimit</code>. At that point, the planned budget provides the same experience as a fixed budget. </p>
        /// <p> <code>DescribeBudget</code> and <code>DescribeBudgets</code> response along with <code>PlannedBudgetLimits</code> also contain <code>BudgetLimit</code> representing the current month or quarter limit present in <code>PlannedBudgetLimits</code>. This only applies to budgets that are created with <code>PlannedBudgetLimits</code>. Budgets that are created without <code>PlannedBudgetLimits</code> only contain <code>BudgetLimit</code>. They don't contain <code>PlannedBudgetLimits</code>.</p>
        pub fn planned_budget_limits(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Spend,
        ) -> Self {
            let mut hash_map = self.planned_budget_limits.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.planned_budget_limits = Some(hash_map);
            self
        }
        /// <p>A map containing multiple <code>BudgetLimit</code>, including current or future limits.</p>
        /// <p> <code>PlannedBudgetLimits</code> is available for cost or usage budget and supports both monthly and quarterly <code>TimeUnit</code>. </p>
        /// <p>For monthly budgets, provide 12 months of <code>PlannedBudgetLimits</code> values. This must start from the current month and include the next 11 months. The <code>key</code> is the start of the month, <code>UTC</code> in epoch seconds. </p>
        /// <p>For quarterly budgets, provide four quarters of <code>PlannedBudgetLimits</code> value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The <code>key</code> is the start of the quarter, <code>UTC</code> in epoch seconds. </p>
        /// <p>If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the <code>PlannedBudgetLimits</code> values only for the remaining periods.</p>
        /// <p>If the budget begins at a date in the future, provide <code>PlannedBudgetLimits</code> values from the start date of the budget. </p>
        /// <p>After all of the <code>BudgetLimit</code> values in <code>PlannedBudgetLimits</code> are used, the budget continues to use the last limit as the <code>BudgetLimit</code>. At that point, the planned budget provides the same experience as a fixed budget. </p>
        /// <p> <code>DescribeBudget</code> and <code>DescribeBudgets</code> response along with <code>PlannedBudgetLimits</code> also contain <code>BudgetLimit</code> representing the current month or quarter limit present in <code>PlannedBudgetLimits</code>. This only applies to budgets that are created with <code>PlannedBudgetLimits</code>. Budgets that are created without <code>PlannedBudgetLimits</code> only contain <code>BudgetLimit</code>. They don't contain <code>PlannedBudgetLimits</code>.</p>
        pub fn set_planned_budget_limits(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Spend>,
            >,
        ) -> Self {
            self.planned_budget_limits = input;
            self
        }
        /// Adds a key-value pair to `cost_filters`.
        ///
        /// To override the contents of this collection use [`set_cost_filters`](Self::set_cost_filters).
        ///
        /// <p>The cost filters, such as <code>Region</code>, <code>Service</code>, <code>member account</code>, <code>Tag</code>, or <code>Cost Category</code>, that are applied to a budget.</p>
        /// <p>Amazon Web Services Budgets supports the following services as a <code>Service</code> filter for RI budgets:</p>
        /// <ul>
        /// <li> <p>Amazon EC2</p> </li>
        /// <li> <p>Amazon Redshift</p> </li>
        /// <li> <p>Amazon Relational Database Service</p> </li>
        /// <li> <p>Amazon ElastiCache</p> </li>
        /// <li> <p>Amazon OpenSearch Service</p> </li>
        /// </ul>
        pub fn cost_filters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.cost_filters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.cost_filters = Some(hash_map);
            self
        }
        /// <p>The cost filters, such as <code>Region</code>, <code>Service</code>, <code>member account</code>, <code>Tag</code>, or <code>Cost Category</code>, that are applied to a budget.</p>
        /// <p>Amazon Web Services Budgets supports the following services as a <code>Service</code> filter for RI budgets:</p>
        /// <ul>
        /// <li> <p>Amazon EC2</p> </li>
        /// <li> <p>Amazon Redshift</p> </li>
        /// <li> <p>Amazon Relational Database Service</p> </li>
        /// <li> <p>Amazon ElastiCache</p> </li>
        /// <li> <p>Amazon OpenSearch Service</p> </li>
        /// </ul>
        pub fn set_cost_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.cost_filters = input;
            self
        }
        /// <p>The types of costs that are included in this <code>COST</code> budget.</p>
        /// <p> <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code>.</p>
        pub fn cost_types(mut self, input: crate::model::CostTypes) -> Self {
            self.cost_types = Some(input);
            self
        }
        /// <p>The types of costs that are included in this <code>COST</code> budget.</p>
        /// <p> <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code>.</p>
        pub fn set_cost_types(
            mut self,
            input: std::option::Option<crate::model::CostTypes>,
        ) -> Self {
            self.cost_types = input;
            self
        }
        /// <p>The length of time until a budget resets the actual and forecasted spend.</p>
        pub fn time_unit(mut self, input: crate::model::TimeUnit) -> Self {
            self.time_unit = Some(input);
            self
        }
        /// <p>The length of time until a budget resets the actual and forecasted spend.</p>
        pub fn set_time_unit(mut self, input: std::option::Option<crate::model::TimeUnit>) -> Self {
            self.time_unit = input;
            self
        }
        /// <p>The period of time that's covered by a budget. You setthe start date and end date. The start date must come before the end date. The end date must come before <code>06/15/87 00:00 UTC</code>. </p>
        /// <p>If you create your budget and don't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API. </p>
        /// <p>You can change either date with the <code>UpdateBudget</code> operation.</p>
        /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers.</p>
        pub fn time_period(mut self, input: crate::model::TimePeriod) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The period of time that's covered by a budget. You setthe start date and end date. The start date must come before the end date. The end date must come before <code>06/15/87 00:00 UTC</code>. </p>
        /// <p>If you create your budget and don't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API. </p>
        /// <p>You can change either date with the <code>UpdateBudget</code> operation.</p>
        /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>The actual and forecasted cost or usage that the budget tracks.</p>
        pub fn calculated_spend(mut self, input: crate::model::CalculatedSpend) -> Self {
            self.calculated_spend = Some(input);
            self
        }
        /// <p>The actual and forecasted cost or usage that the budget tracks.</p>
        pub fn set_calculated_spend(
            mut self,
            input: std::option::Option<crate::model::CalculatedSpend>,
        ) -> Self {
            self.calculated_spend = input;
            self
        }
        /// <p>Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.</p>
        pub fn budget_type(mut self, input: crate::model::BudgetType) -> Self {
            self.budget_type = Some(input);
            self
        }
        /// <p>Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.</p>
        pub fn set_budget_type(
            mut self,
            input: std::option::Option<crate::model::BudgetType>,
        ) -> Self {
            self.budget_type = input;
            self
        }
        /// <p>The last time that you updated this budget.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that you updated this budget.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The parameters that determine the budget amount for an auto-adjusting budget.</p>
        pub fn auto_adjust_data(mut self, input: crate::model::AutoAdjustData) -> Self {
            self.auto_adjust_data = Some(input);
            self
        }
        /// <p>The parameters that determine the budget amount for an auto-adjusting budget.</p>
        pub fn set_auto_adjust_data(
            mut self,
            input: std::option::Option<crate::model::AutoAdjustData>,
        ) -> Self {
            self.auto_adjust_data = input;
            self
        }
        /// Consumes the builder and constructs a [`Budget`](crate::model::Budget)
        pub fn build(self) -> crate::model::Budget {
            crate::model::Budget {
                budget_name: self.budget_name,
                budget_limit: self.budget_limit,
                planned_budget_limits: self.planned_budget_limits,
                cost_filters: self.cost_filters,
                cost_types: self.cost_types,
                time_unit: self.time_unit,
                time_period: self.time_period,
                calculated_spend: self.calculated_spend,
                budget_type: self.budget_type,
                last_updated_time: self.last_updated_time,
                auto_adjust_data: self.auto_adjust_data,
            }
        }
    }
}
impl Budget {
    /// Creates a new builder-style object to manufacture [`Budget`](crate::model::Budget)
    pub fn builder() -> crate::model::budget::Builder {
        crate::model::budget::Builder::default()
    }
}

/// <p>The parameters that determine the budget amount for an auto-adjusting budget.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoAdjustData {
    /// <p>The string that defines whether your budget auto-adjusts based on historical or forecasted data.</p>
    pub auto_adjust_type: std::option::Option<crate::model::AutoAdjustType>,
    /// <p>The parameters that define or describe the historical data that your auto-adjusting budget is based on.</p>
    pub historical_options: std::option::Option<crate::model::HistoricalOptions>,
    /// <p>The last time that your budget was auto-adjusted.</p>
    pub last_auto_adjust_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl AutoAdjustData {
    /// <p>The string that defines whether your budget auto-adjusts based on historical or forecasted data.</p>
    pub fn auto_adjust_type(&self) -> std::option::Option<&crate::model::AutoAdjustType> {
        self.auto_adjust_type.as_ref()
    }
    /// <p>The parameters that define or describe the historical data that your auto-adjusting budget is based on.</p>
    pub fn historical_options(&self) -> std::option::Option<&crate::model::HistoricalOptions> {
        self.historical_options.as_ref()
    }
    /// <p>The last time that your budget was auto-adjusted.</p>
    pub fn last_auto_adjust_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_auto_adjust_time.as_ref()
    }
}
impl std::fmt::Debug for AutoAdjustData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoAdjustData");
        formatter.field("auto_adjust_type", &self.auto_adjust_type);
        formatter.field("historical_options", &self.historical_options);
        formatter.field("last_auto_adjust_time", &self.last_auto_adjust_time);
        formatter.finish()
    }
}
/// See [`AutoAdjustData`](crate::model::AutoAdjustData)
pub mod auto_adjust_data {
    /// A builder for [`AutoAdjustData`](crate::model::AutoAdjustData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_adjust_type: std::option::Option<crate::model::AutoAdjustType>,
        pub(crate) historical_options: std::option::Option<crate::model::HistoricalOptions>,
        pub(crate) last_auto_adjust_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The string that defines whether your budget auto-adjusts based on historical or forecasted data.</p>
        pub fn auto_adjust_type(mut self, input: crate::model::AutoAdjustType) -> Self {
            self.auto_adjust_type = Some(input);
            self
        }
        /// <p>The string that defines whether your budget auto-adjusts based on historical or forecasted data.</p>
        pub fn set_auto_adjust_type(
            mut self,
            input: std::option::Option<crate::model::AutoAdjustType>,
        ) -> Self {
            self.auto_adjust_type = input;
            self
        }
        /// <p>The parameters that define or describe the historical data that your auto-adjusting budget is based on.</p>
        pub fn historical_options(mut self, input: crate::model::HistoricalOptions) -> Self {
            self.historical_options = Some(input);
            self
        }
        /// <p>The parameters that define or describe the historical data that your auto-adjusting budget is based on.</p>
        pub fn set_historical_options(
            mut self,
            input: std::option::Option<crate::model::HistoricalOptions>,
        ) -> Self {
            self.historical_options = input;
            self
        }
        /// <p>The last time that your budget was auto-adjusted.</p>
        pub fn last_auto_adjust_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_auto_adjust_time = Some(input);
            self
        }
        /// <p>The last time that your budget was auto-adjusted.</p>
        pub fn set_last_auto_adjust_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_auto_adjust_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoAdjustData`](crate::model::AutoAdjustData)
        pub fn build(self) -> crate::model::AutoAdjustData {
            crate::model::AutoAdjustData {
                auto_adjust_type: self.auto_adjust_type,
                historical_options: self.historical_options,
                last_auto_adjust_time: self.last_auto_adjust_time,
            }
        }
    }
}
impl AutoAdjustData {
    /// Creates a new builder-style object to manufacture [`AutoAdjustData`](crate::model::AutoAdjustData)
    pub fn builder() -> crate::model::auto_adjust_data::Builder {
        crate::model::auto_adjust_data::Builder::default()
    }
}

/// <p>The parameters that define or describe the historical data that your auto-adjusting budget is based on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistoricalOptions {
    /// <p>The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount. The maximum value depends on the <code>TimeUnit</code> granularity of the budget:</p>
    /// <ul>
    /// <li> <p>For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.</p> </li>
    /// <li> <p>For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.</p> </li>
    /// <li> <p>For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.</p> </li>
    /// <li> <p>For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.</p> </li>
    /// </ul>
    pub budget_adjustment_period: std::option::Option<i32>,
    /// <p>The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are included in the calculation of your current <code>BudgetLimit</code>. If the first budget period in your <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in the average that determines your budget limit. </p>
    /// <p>For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your account had no cost data in the first quarter, then only the last three quarters are included in the calculation. In this scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>. </p>
    /// <p>You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated from the <code>BudgetAdjustmentPeriod</code> and your historical cost data.</p>
    pub look_back_available_periods: std::option::Option<i32>,
}
impl HistoricalOptions {
    /// <p>The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount. The maximum value depends on the <code>TimeUnit</code> granularity of the budget:</p>
    /// <ul>
    /// <li> <p>For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.</p> </li>
    /// <li> <p>For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.</p> </li>
    /// <li> <p>For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.</p> </li>
    /// <li> <p>For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.</p> </li>
    /// </ul>
    pub fn budget_adjustment_period(&self) -> std::option::Option<i32> {
        self.budget_adjustment_period
    }
    /// <p>The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are included in the calculation of your current <code>BudgetLimit</code>. If the first budget period in your <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in the average that determines your budget limit. </p>
    /// <p>For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your account had no cost data in the first quarter, then only the last three quarters are included in the calculation. In this scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>. </p>
    /// <p>You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated from the <code>BudgetAdjustmentPeriod</code> and your historical cost data.</p>
    pub fn look_back_available_periods(&self) -> std::option::Option<i32> {
        self.look_back_available_periods
    }
}
impl std::fmt::Debug for HistoricalOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistoricalOptions");
        formatter.field("budget_adjustment_period", &self.budget_adjustment_period);
        formatter.field(
            "look_back_available_periods",
            &self.look_back_available_periods,
        );
        formatter.finish()
    }
}
/// See [`HistoricalOptions`](crate::model::HistoricalOptions)
pub mod historical_options {
    /// A builder for [`HistoricalOptions`](crate::model::HistoricalOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_adjustment_period: std::option::Option<i32>,
        pub(crate) look_back_available_periods: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount. The maximum value depends on the <code>TimeUnit</code> granularity of the budget:</p>
        /// <ul>
        /// <li> <p>For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.</p> </li>
        /// <li> <p>For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.</p> </li>
        /// <li> <p>For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.</p> </li>
        /// <li> <p>For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.</p> </li>
        /// </ul>
        pub fn budget_adjustment_period(mut self, input: i32) -> Self {
            self.budget_adjustment_period = Some(input);
            self
        }
        /// <p>The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount. The maximum value depends on the <code>TimeUnit</code> granularity of the budget:</p>
        /// <ul>
        /// <li> <p>For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.</p> </li>
        /// <li> <p>For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.</p> </li>
        /// <li> <p>For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.</p> </li>
        /// <li> <p>For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.</p> </li>
        /// </ul>
        pub fn set_budget_adjustment_period(mut self, input: std::option::Option<i32>) -> Self {
            self.budget_adjustment_period = input;
            self
        }
        /// <p>The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are included in the calculation of your current <code>BudgetLimit</code>. If the first budget period in your <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in the average that determines your budget limit. </p>
        /// <p>For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your account had no cost data in the first quarter, then only the last three quarters are included in the calculation. In this scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>. </p>
        /// <p>You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated from the <code>BudgetAdjustmentPeriod</code> and your historical cost data.</p>
        pub fn look_back_available_periods(mut self, input: i32) -> Self {
            self.look_back_available_periods = Some(input);
            self
        }
        /// <p>The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are included in the calculation of your current <code>BudgetLimit</code>. If the first budget period in your <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in the average that determines your budget limit. </p>
        /// <p>For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your account had no cost data in the first quarter, then only the last three quarters are included in the calculation. In this scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>. </p>
        /// <p>You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated from the <code>BudgetAdjustmentPeriod</code> and your historical cost data.</p>
        pub fn set_look_back_available_periods(mut self, input: std::option::Option<i32>) -> Self {
            self.look_back_available_periods = input;
            self
        }
        /// Consumes the builder and constructs a [`HistoricalOptions`](crate::model::HistoricalOptions)
        pub fn build(self) -> crate::model::HistoricalOptions {
            crate::model::HistoricalOptions {
                budget_adjustment_period: self.budget_adjustment_period,
                look_back_available_periods: self.look_back_available_periods,
            }
        }
    }
}
impl HistoricalOptions {
    /// Creates a new builder-style object to manufacture [`HistoricalOptions`](crate::model::HistoricalOptions)
    pub fn builder() -> crate::model::historical_options::Builder {
        crate::model::historical_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoAdjustType {
    #[allow(missing_docs)] // documentation missing in model
    Forecast,
    #[allow(missing_docs)] // documentation missing in model
    Historical,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoAdjustType {
    fn from(s: &str) -> Self {
        match s {
            "FORECAST" => AutoAdjustType::Forecast,
            "HISTORICAL" => AutoAdjustType::Historical,
            other => AutoAdjustType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoAdjustType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoAdjustType::from(s))
    }
}
impl AutoAdjustType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoAdjustType::Forecast => "FORECAST",
            AutoAdjustType::Historical => "HISTORICAL",
            AutoAdjustType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FORECAST", "HISTORICAL"]
    }
}
impl AsRef<str> for AutoAdjustType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The type of a budget. It must be one of the following types: </p>
/// <p>
/// <code>COST</code>, <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, or <code>SAVINGS_PLANS_COVERAGE</code>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BudgetType {
    #[allow(missing_docs)] // documentation missing in model
    Cost,
    #[allow(missing_docs)] // documentation missing in model
    RiCoverage,
    #[allow(missing_docs)] // documentation missing in model
    RiUtilization,
    #[allow(missing_docs)] // documentation missing in model
    SpCoverage,
    #[allow(missing_docs)] // documentation missing in model
    SpUtilization,
    #[allow(missing_docs)] // documentation missing in model
    Usage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BudgetType {
    fn from(s: &str) -> Self {
        match s {
            "COST" => BudgetType::Cost,
            "RI_COVERAGE" => BudgetType::RiCoverage,
            "RI_UTILIZATION" => BudgetType::RiUtilization,
            "SAVINGS_PLANS_COVERAGE" => BudgetType::SpCoverage,
            "SAVINGS_PLANS_UTILIZATION" => BudgetType::SpUtilization,
            "USAGE" => BudgetType::Usage,
            other => BudgetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BudgetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BudgetType::from(s))
    }
}
impl BudgetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BudgetType::Cost => "COST",
            BudgetType::RiCoverage => "RI_COVERAGE",
            BudgetType::RiUtilization => "RI_UTILIZATION",
            BudgetType::SpCoverage => "SAVINGS_PLANS_COVERAGE",
            BudgetType::SpUtilization => "SAVINGS_PLANS_UTILIZATION",
            BudgetType::Usage => "USAGE",
            BudgetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COST",
            "RI_COVERAGE",
            "RI_UTILIZATION",
            "SAVINGS_PLANS_COVERAGE",
            "SAVINGS_PLANS_UTILIZATION",
            "USAGE",
        ]
    }
}
impl AsRef<str> for BudgetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The spend objects that are associated with this budget. The <code>actualSpend</code> tracks how much you've used, cost, usage, RI units, or Savings Plans units and the <code>forecastedSpend</code> tracks how much that you're predicted to spend based on your historical usage profile.</p>
/// <p>For example, if it's the 20th of the month and you have spent <code>50</code> dollars on Amazon EC2, your <code>actualSpend</code> is <code>50 USD</code>, and your <code>forecastedSpend</code> is <code>75 USD</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculatedSpend {
    /// <p>The amount of cost, usage, RI units, or Savings Plans units that you used.</p>
    pub actual_spend: std::option::Option<crate::model::Spend>,
    /// <p>The amount of cost, usage, RI units, or Savings Plans units that you're forecasted to use.</p>
    pub forecasted_spend: std::option::Option<crate::model::Spend>,
}
impl CalculatedSpend {
    /// <p>The amount of cost, usage, RI units, or Savings Plans units that you used.</p>
    pub fn actual_spend(&self) -> std::option::Option<&crate::model::Spend> {
        self.actual_spend.as_ref()
    }
    /// <p>The amount of cost, usage, RI units, or Savings Plans units that you're forecasted to use.</p>
    pub fn forecasted_spend(&self) -> std::option::Option<&crate::model::Spend> {
        self.forecasted_spend.as_ref()
    }
}
impl std::fmt::Debug for CalculatedSpend {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculatedSpend");
        formatter.field("actual_spend", &self.actual_spend);
        formatter.field("forecasted_spend", &self.forecasted_spend);
        formatter.finish()
    }
}
/// See [`CalculatedSpend`](crate::model::CalculatedSpend)
pub mod calculated_spend {
    /// A builder for [`CalculatedSpend`](crate::model::CalculatedSpend)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actual_spend: std::option::Option<crate::model::Spend>,
        pub(crate) forecasted_spend: std::option::Option<crate::model::Spend>,
    }
    impl Builder {
        /// <p>The amount of cost, usage, RI units, or Savings Plans units that you used.</p>
        pub fn actual_spend(mut self, input: crate::model::Spend) -> Self {
            self.actual_spend = Some(input);
            self
        }
        /// <p>The amount of cost, usage, RI units, or Savings Plans units that you used.</p>
        pub fn set_actual_spend(mut self, input: std::option::Option<crate::model::Spend>) -> Self {
            self.actual_spend = input;
            self
        }
        /// <p>The amount of cost, usage, RI units, or Savings Plans units that you're forecasted to use.</p>
        pub fn forecasted_spend(mut self, input: crate::model::Spend) -> Self {
            self.forecasted_spend = Some(input);
            self
        }
        /// <p>The amount of cost, usage, RI units, or Savings Plans units that you're forecasted to use.</p>
        pub fn set_forecasted_spend(
            mut self,
            input: std::option::Option<crate::model::Spend>,
        ) -> Self {
            self.forecasted_spend = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculatedSpend`](crate::model::CalculatedSpend)
        pub fn build(self) -> crate::model::CalculatedSpend {
            crate::model::CalculatedSpend {
                actual_spend: self.actual_spend,
                forecasted_spend: self.forecasted_spend,
            }
        }
    }
}
impl CalculatedSpend {
    /// Creates a new builder-style object to manufacture [`CalculatedSpend`](crate::model::CalculatedSpend)
    pub fn builder() -> crate::model::calculated_spend::Builder {
        crate::model::calculated_spend::Builder::default()
    }
}

/// <p>The amount of cost or usage that's measured for a budget.</p>
/// <p>For example, a <code>Spend</code> for <code>3 GB</code> of S3 usage has the following parameters:</p>
/// <ul>
/// <li> <p>An <code>Amount</code> of <code>3</code> </p> </li>
/// <li> <p>A <code>unit</code> of <code>GB</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Spend {
    /// <p>The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold.</p>
    pub amount: std::option::Option<std::string::String>,
    /// <p>The unit of measurement that's used for the budget forecast, actual spend, or budget threshold, such as USD or GBP.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl Spend {
    /// <p>The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold.</p>
    pub fn amount(&self) -> std::option::Option<&str> {
        self.amount.as_deref()
    }
    /// <p>The unit of measurement that's used for the budget forecast, actual spend, or budget threshold, such as USD or GBP.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for Spend {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Spend");
        formatter.field("amount", &self.amount);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`Spend`](crate::model::Spend)
pub mod spend {
    /// A builder for [`Spend`](crate::model::Spend)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amount: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold.</p>
        pub fn amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.amount = Some(input.into());
            self
        }
        /// <p>The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold.</p>
        pub fn set_amount(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The unit of measurement that's used for the budget forecast, actual spend, or budget threshold, such as USD or GBP.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of measurement that's used for the budget forecast, actual spend, or budget threshold, such as USD or GBP.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`Spend`](crate::model::Spend)
        pub fn build(self) -> crate::model::Spend {
            crate::model::Spend {
                amount: self.amount,
                unit: self.unit,
            }
        }
    }
}
impl Spend {
    /// Creates a new builder-style object to manufacture [`Spend`](crate::model::Spend)
    pub fn builder() -> crate::model::spend::Builder {
        crate::model::spend::Builder::default()
    }
}

/// <p>The period of time that's covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimePeriod {
    /// <p>The start date for a budget. If you created your budget and didn't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
    /// <p>You can change your start date with the <code>UpdateBudget</code> operation.</p>
    pub start: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end date for a budget. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
    /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers. You can change your end date with the <code>UpdateBudget</code> operation.</p>
    pub end: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimePeriod {
    /// <p>The start date for a budget. If you created your budget and didn't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
    /// <p>You can change your start date with the <code>UpdateBudget</code> operation.</p>
    pub fn start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start.as_ref()
    }
    /// <p>The end date for a budget. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
    /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers. You can change your end date with the <code>UpdateBudget</code> operation.</p>
    pub fn end(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end.as_ref()
    }
}
impl std::fmt::Debug for TimePeriod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimePeriod");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`TimePeriod`](crate::model::TimePeriod)
pub mod time_period {
    /// A builder for [`TimePeriod`](crate::model::TimePeriod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start date for a budget. If you created your budget and didn't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
        /// <p>You can change your start date with the <code>UpdateBudget</code> operation.</p>
        pub fn start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The start date for a budget. If you created your budget and didn't specify a start date, Amazon Web Services defaults to the start of your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you created your budget on January 24, 2018, chose <code>DAILY</code>, and didn't set a start date, Amazon Web Services set your start date to <code>01/24/18 00:00 UTC</code>. If you chose <code>MONTHLY</code>, Amazon Web Services set your start date to <code>01/01/18 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
        /// <p>You can change your start date with the <code>UpdateBudget</code> operation.</p>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.start = input;
            self
        }
        /// <p>The end date for a budget. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
        /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers. You can change your end date with the <code>UpdateBudget</code> operation.</p>
        pub fn end(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The end date for a budget. If you didn't specify an end date, Amazon Web Services set your end date to <code>06/15/87 00:00 UTC</code>. The defaults are the same for the Billing and Cost Management console and the API.</p>
        /// <p>After the end date, Amazon Web Services deletes the budget and all the associated notifications and subscribers. You can change your end date with the <code>UpdateBudget</code> operation.</p>
        pub fn set_end(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`TimePeriod`](crate::model::TimePeriod)
        pub fn build(self) -> crate::model::TimePeriod {
            crate::model::TimePeriod {
                start: self.start,
                end: self.end,
            }
        }
    }
}
impl TimePeriod {
    /// Creates a new builder-style object to manufacture [`TimePeriod`](crate::model::TimePeriod)
    pub fn builder() -> crate::model::time_period::Builder {
        crate::model::time_period::Builder::default()
    }
}

/// <p> The time unit of the budget, such as MONTHLY or QUARTERLY.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeUnit {
    #[allow(missing_docs)] // documentation missing in model
    Annually,
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    Quarterly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeUnit {
    fn from(s: &str) -> Self {
        match s {
            "ANNUALLY" => TimeUnit::Annually,
            "DAILY" => TimeUnit::Daily,
            "MONTHLY" => TimeUnit::Monthly,
            "QUARTERLY" => TimeUnit::Quarterly,
            other => TimeUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeUnit::from(s))
    }
}
impl TimeUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeUnit::Annually => "ANNUALLY",
            TimeUnit::Daily => "DAILY",
            TimeUnit::Monthly => "MONTHLY",
            TimeUnit::Quarterly => "QUARTERLY",
            TimeUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ANNUALLY", "DAILY", "MONTHLY", "QUARTERLY"]
    }
}
impl AsRef<str> for TimeUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The types of cost that are included in a <code>COST</code> budget, such as tax and subscriptions.</p>
/// <p> <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, and <code>SAVINGS_PLANS_COVERAGE</code> budgets don't have <code>CostTypes</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostTypes {
    /// <p>Specifies whether a budget includes taxes.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_tax: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes subscriptions.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_subscription: std::option::Option<bool>,
    /// <p>Specifies whether a budget uses a blended rate.</p>
    /// <p>The default value is <code>false</code>.</p>
    pub use_blended: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes refunds.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_refund: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes credits.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_credit: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes upfront RI costs.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_upfront: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_recurring: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes non-RI subscription costs.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_other_subscription: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes support subscription fees.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_support: std::option::Option<bool>,
    /// <p>Specifies whether a budget includes discounts.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub include_discount: std::option::Option<bool>,
    /// <p>Specifies whether a budget uses the amortized rate.</p>
    /// <p>The default value is <code>false</code>.</p>
    pub use_amortized: std::option::Option<bool>,
}
impl CostTypes {
    /// <p>Specifies whether a budget includes taxes.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_tax(&self) -> std::option::Option<bool> {
        self.include_tax
    }
    /// <p>Specifies whether a budget includes subscriptions.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_subscription(&self) -> std::option::Option<bool> {
        self.include_subscription
    }
    /// <p>Specifies whether a budget uses a blended rate.</p>
    /// <p>The default value is <code>false</code>.</p>
    pub fn use_blended(&self) -> std::option::Option<bool> {
        self.use_blended
    }
    /// <p>Specifies whether a budget includes refunds.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_refund(&self) -> std::option::Option<bool> {
        self.include_refund
    }
    /// <p>Specifies whether a budget includes credits.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_credit(&self) -> std::option::Option<bool> {
        self.include_credit
    }
    /// <p>Specifies whether a budget includes upfront RI costs.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_upfront(&self) -> std::option::Option<bool> {
        self.include_upfront
    }
    /// <p>Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_recurring(&self) -> std::option::Option<bool> {
        self.include_recurring
    }
    /// <p>Specifies whether a budget includes non-RI subscription costs.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_other_subscription(&self) -> std::option::Option<bool> {
        self.include_other_subscription
    }
    /// <p>Specifies whether a budget includes support subscription fees.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_support(&self) -> std::option::Option<bool> {
        self.include_support
    }
    /// <p>Specifies whether a budget includes discounts.</p>
    /// <p>The default value is <code>true</code>.</p>
    pub fn include_discount(&self) -> std::option::Option<bool> {
        self.include_discount
    }
    /// <p>Specifies whether a budget uses the amortized rate.</p>
    /// <p>The default value is <code>false</code>.</p>
    pub fn use_amortized(&self) -> std::option::Option<bool> {
        self.use_amortized
    }
}
impl std::fmt::Debug for CostTypes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostTypes");
        formatter.field("include_tax", &self.include_tax);
        formatter.field("include_subscription", &self.include_subscription);
        formatter.field("use_blended", &self.use_blended);
        formatter.field("include_refund", &self.include_refund);
        formatter.field("include_credit", &self.include_credit);
        formatter.field("include_upfront", &self.include_upfront);
        formatter.field("include_recurring", &self.include_recurring);
        formatter.field(
            "include_other_subscription",
            &self.include_other_subscription,
        );
        formatter.field("include_support", &self.include_support);
        formatter.field("include_discount", &self.include_discount);
        formatter.field("use_amortized", &self.use_amortized);
        formatter.finish()
    }
}
/// See [`CostTypes`](crate::model::CostTypes)
pub mod cost_types {
    /// A builder for [`CostTypes`](crate::model::CostTypes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) include_tax: std::option::Option<bool>,
        pub(crate) include_subscription: std::option::Option<bool>,
        pub(crate) use_blended: std::option::Option<bool>,
        pub(crate) include_refund: std::option::Option<bool>,
        pub(crate) include_credit: std::option::Option<bool>,
        pub(crate) include_upfront: std::option::Option<bool>,
        pub(crate) include_recurring: std::option::Option<bool>,
        pub(crate) include_other_subscription: std::option::Option<bool>,
        pub(crate) include_support: std::option::Option<bool>,
        pub(crate) include_discount: std::option::Option<bool>,
        pub(crate) use_amortized: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether a budget includes taxes.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_tax(mut self, input: bool) -> Self {
            self.include_tax = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes taxes.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_tax(mut self, input: std::option::Option<bool>) -> Self {
            self.include_tax = input;
            self
        }
        /// <p>Specifies whether a budget includes subscriptions.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_subscription(mut self, input: bool) -> Self {
            self.include_subscription = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes subscriptions.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_subscription(mut self, input: std::option::Option<bool>) -> Self {
            self.include_subscription = input;
            self
        }
        /// <p>Specifies whether a budget uses a blended rate.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn use_blended(mut self, input: bool) -> Self {
            self.use_blended = Some(input);
            self
        }
        /// <p>Specifies whether a budget uses a blended rate.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_use_blended(mut self, input: std::option::Option<bool>) -> Self {
            self.use_blended = input;
            self
        }
        /// <p>Specifies whether a budget includes refunds.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_refund(mut self, input: bool) -> Self {
            self.include_refund = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes refunds.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_refund(mut self, input: std::option::Option<bool>) -> Self {
            self.include_refund = input;
            self
        }
        /// <p>Specifies whether a budget includes credits.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_credit(mut self, input: bool) -> Self {
            self.include_credit = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes credits.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_credit(mut self, input: std::option::Option<bool>) -> Self {
            self.include_credit = input;
            self
        }
        /// <p>Specifies whether a budget includes upfront RI costs.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_upfront(mut self, input: bool) -> Self {
            self.include_upfront = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes upfront RI costs.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_upfront(mut self, input: std::option::Option<bool>) -> Self {
            self.include_upfront = input;
            self
        }
        /// <p>Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_recurring(mut self, input: bool) -> Self {
            self.include_recurring = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes recurring fees such as monthly RI fees.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_recurring(mut self, input: std::option::Option<bool>) -> Self {
            self.include_recurring = input;
            self
        }
        /// <p>Specifies whether a budget includes non-RI subscription costs.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_other_subscription(mut self, input: bool) -> Self {
            self.include_other_subscription = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes non-RI subscription costs.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_other_subscription(mut self, input: std::option::Option<bool>) -> Self {
            self.include_other_subscription = input;
            self
        }
        /// <p>Specifies whether a budget includes support subscription fees.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_support(mut self, input: bool) -> Self {
            self.include_support = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes support subscription fees.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_support(mut self, input: std::option::Option<bool>) -> Self {
            self.include_support = input;
            self
        }
        /// <p>Specifies whether a budget includes discounts.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn include_discount(mut self, input: bool) -> Self {
            self.include_discount = Some(input);
            self
        }
        /// <p>Specifies whether a budget includes discounts.</p>
        /// <p>The default value is <code>true</code>.</p>
        pub fn set_include_discount(mut self, input: std::option::Option<bool>) -> Self {
            self.include_discount = input;
            self
        }
        /// <p>Specifies whether a budget uses the amortized rate.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn use_amortized(mut self, input: bool) -> Self {
            self.use_amortized = Some(input);
            self
        }
        /// <p>Specifies whether a budget uses the amortized rate.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_use_amortized(mut self, input: std::option::Option<bool>) -> Self {
            self.use_amortized = input;
            self
        }
        /// Consumes the builder and constructs a [`CostTypes`](crate::model::CostTypes)
        pub fn build(self) -> crate::model::CostTypes {
            crate::model::CostTypes {
                include_tax: self.include_tax,
                include_subscription: self.include_subscription,
                use_blended: self.use_blended,
                include_refund: self.include_refund,
                include_credit: self.include_credit,
                include_upfront: self.include_upfront,
                include_recurring: self.include_recurring,
                include_other_subscription: self.include_other_subscription,
                include_support: self.include_support,
                include_discount: self.include_discount,
                use_amortized: self.use_amortized,
            }
        }
    }
}
impl CostTypes {
    /// Creates a new builder-style object to manufacture [`CostTypes`](crate::model::CostTypes)
    pub fn builder() -> crate::model::cost_types::Builder {
        crate::model::cost_types::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionType {
    #[allow(missing_docs)] // documentation missing in model
    ApproveBudgetAction,
    #[allow(missing_docs)] // documentation missing in model
    ResetBudgetAction,
    #[allow(missing_docs)] // documentation missing in model
    RetryBudgetAction,
    #[allow(missing_docs)] // documentation missing in model
    ReverseBudgetAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionType {
    fn from(s: &str) -> Self {
        match s {
            "APPROVE_BUDGET_ACTION" => ExecutionType::ApproveBudgetAction,
            "RESET_BUDGET_ACTION" => ExecutionType::ResetBudgetAction,
            "RETRY_BUDGET_ACTION" => ExecutionType::RetryBudgetAction,
            "REVERSE_BUDGET_ACTION" => ExecutionType::ReverseBudgetAction,
            other => ExecutionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionType::from(s))
    }
}
impl ExecutionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionType::ApproveBudgetAction => "APPROVE_BUDGET_ACTION",
            ExecutionType::ResetBudgetAction => "RESET_BUDGET_ACTION",
            ExecutionType::RetryBudgetAction => "RETRY_BUDGET_ACTION",
            ExecutionType::ReverseBudgetAction => "REVERSE_BUDGET_ACTION",
            ExecutionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPROVE_BUDGET_ACTION",
            "RESET_BUDGET_ACTION",
            "RETRY_BUDGET_ACTION",
            "REVERSE_BUDGET_ACTION",
        ]
    }
}
impl AsRef<str> for ExecutionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A history of the state of a budget at the end of the budget's specified time period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BudgetPerformanceHistory {
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> The type of a budget. It must be one of the following types: </p>
    /// <p> <code>COST</code>, <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, or <code>SAVINGS_PLANS_COVERAGE</code>.</p>
    pub budget_type: std::option::Option<crate::model::BudgetType>,
    /// <p>The history of the cost filters for a budget during the specified time period.</p>
    pub cost_filters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The history of the cost types for a budget during the specified time period.</p>
    pub cost_types: std::option::Option<crate::model::CostTypes>,
    /// <p> The time unit of the budget, such as MONTHLY or QUARTERLY.</p>
    pub time_unit: std::option::Option<crate::model::TimeUnit>,
    /// <p>A list of amounts of cost or usage that you created budgets for, which are compared to your actual costs or usage.</p>
    pub budgeted_and_actual_amounts_list:
        std::option::Option<std::vec::Vec<crate::model::BudgetedAndActualAmounts>>,
}
impl BudgetPerformanceHistory {
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p> The type of a budget. It must be one of the following types: </p>
    /// <p> <code>COST</code>, <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, or <code>SAVINGS_PLANS_COVERAGE</code>.</p>
    pub fn budget_type(&self) -> std::option::Option<&crate::model::BudgetType> {
        self.budget_type.as_ref()
    }
    /// <p>The history of the cost filters for a budget during the specified time period.</p>
    pub fn cost_filters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.cost_filters.as_ref()
    }
    /// <p>The history of the cost types for a budget during the specified time period.</p>
    pub fn cost_types(&self) -> std::option::Option<&crate::model::CostTypes> {
        self.cost_types.as_ref()
    }
    /// <p> The time unit of the budget, such as MONTHLY or QUARTERLY.</p>
    pub fn time_unit(&self) -> std::option::Option<&crate::model::TimeUnit> {
        self.time_unit.as_ref()
    }
    /// <p>A list of amounts of cost or usage that you created budgets for, which are compared to your actual costs or usage.</p>
    pub fn budgeted_and_actual_amounts_list(
        &self,
    ) -> std::option::Option<&[crate::model::BudgetedAndActualAmounts]> {
        self.budgeted_and_actual_amounts_list.as_deref()
    }
}
impl std::fmt::Debug for BudgetPerformanceHistory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BudgetPerformanceHistory");
        formatter.field("budget_name", &self.budget_name);
        formatter.field("budget_type", &self.budget_type);
        formatter.field("cost_filters", &self.cost_filters);
        formatter.field("cost_types", &self.cost_types);
        formatter.field("time_unit", &self.time_unit);
        formatter.field(
            "budgeted_and_actual_amounts_list",
            &self.budgeted_and_actual_amounts_list,
        );
        formatter.finish()
    }
}
/// See [`BudgetPerformanceHistory`](crate::model::BudgetPerformanceHistory)
pub mod budget_performance_history {
    /// A builder for [`BudgetPerformanceHistory`](crate::model::BudgetPerformanceHistory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) budget_type: std::option::Option<crate::model::BudgetType>,
        pub(crate) cost_filters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) cost_types: std::option::Option<crate::model::CostTypes>,
        pub(crate) time_unit: std::option::Option<crate::model::TimeUnit>,
        pub(crate) budgeted_and_actual_amounts_list:
            std::option::Option<std::vec::Vec<crate::model::BudgetedAndActualAmounts>>,
    }
    impl Builder {
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> The type of a budget. It must be one of the following types: </p>
        /// <p> <code>COST</code>, <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, or <code>SAVINGS_PLANS_COVERAGE</code>.</p>
        pub fn budget_type(mut self, input: crate::model::BudgetType) -> Self {
            self.budget_type = Some(input);
            self
        }
        /// <p> The type of a budget. It must be one of the following types: </p>
        /// <p> <code>COST</code>, <code>USAGE</code>, <code>RI_UTILIZATION</code>, <code>RI_COVERAGE</code>, <code>SAVINGS_PLANS_UTILIZATION</code>, or <code>SAVINGS_PLANS_COVERAGE</code>.</p>
        pub fn set_budget_type(
            mut self,
            input: std::option::Option<crate::model::BudgetType>,
        ) -> Self {
            self.budget_type = input;
            self
        }
        /// Adds a key-value pair to `cost_filters`.
        ///
        /// To override the contents of this collection use [`set_cost_filters`](Self::set_cost_filters).
        ///
        /// <p>The history of the cost filters for a budget during the specified time period.</p>
        pub fn cost_filters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.cost_filters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.cost_filters = Some(hash_map);
            self
        }
        /// <p>The history of the cost filters for a budget during the specified time period.</p>
        pub fn set_cost_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.cost_filters = input;
            self
        }
        /// <p>The history of the cost types for a budget during the specified time period.</p>
        pub fn cost_types(mut self, input: crate::model::CostTypes) -> Self {
            self.cost_types = Some(input);
            self
        }
        /// <p>The history of the cost types for a budget during the specified time period.</p>
        pub fn set_cost_types(
            mut self,
            input: std::option::Option<crate::model::CostTypes>,
        ) -> Self {
            self.cost_types = input;
            self
        }
        /// <p> The time unit of the budget, such as MONTHLY or QUARTERLY.</p>
        pub fn time_unit(mut self, input: crate::model::TimeUnit) -> Self {
            self.time_unit = Some(input);
            self
        }
        /// <p> The time unit of the budget, such as MONTHLY or QUARTERLY.</p>
        pub fn set_time_unit(mut self, input: std::option::Option<crate::model::TimeUnit>) -> Self {
            self.time_unit = input;
            self
        }
        /// Appends an item to `budgeted_and_actual_amounts_list`.
        ///
        /// To override the contents of this collection use [`set_budgeted_and_actual_amounts_list`](Self::set_budgeted_and_actual_amounts_list).
        ///
        /// <p>A list of amounts of cost or usage that you created budgets for, which are compared to your actual costs or usage.</p>
        pub fn budgeted_and_actual_amounts_list(
            mut self,
            input: crate::model::BudgetedAndActualAmounts,
        ) -> Self {
            let mut v = self.budgeted_and_actual_amounts_list.unwrap_or_default();
            v.push(input);
            self.budgeted_and_actual_amounts_list = Some(v);
            self
        }
        /// <p>A list of amounts of cost or usage that you created budgets for, which are compared to your actual costs or usage.</p>
        pub fn set_budgeted_and_actual_amounts_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BudgetedAndActualAmounts>>,
        ) -> Self {
            self.budgeted_and_actual_amounts_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BudgetPerformanceHistory`](crate::model::BudgetPerformanceHistory)
        pub fn build(self) -> crate::model::BudgetPerformanceHistory {
            crate::model::BudgetPerformanceHistory {
                budget_name: self.budget_name,
                budget_type: self.budget_type,
                cost_filters: self.cost_filters,
                cost_types: self.cost_types,
                time_unit: self.time_unit,
                budgeted_and_actual_amounts_list: self.budgeted_and_actual_amounts_list,
            }
        }
    }
}
impl BudgetPerformanceHistory {
    /// Creates a new builder-style object to manufacture [`BudgetPerformanceHistory`](crate::model::BudgetPerformanceHistory)
    pub fn builder() -> crate::model::budget_performance_history::Builder {
        crate::model::budget_performance_history::Builder::default()
    }
}

/// <p>The amount of cost or usage that you created the budget for, compared to your actual costs or usage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BudgetedAndActualAmounts {
    /// <p>The amount of cost or usage that you created the budget for.</p>
    pub budgeted_amount: std::option::Option<crate::model::Spend>,
    /// <p>Your actual costs or usage for a budget period.</p>
    pub actual_amount: std::option::Option<crate::model::Spend>,
    /// <p>The time period that's covered by this budget comparison.</p>
    pub time_period: std::option::Option<crate::model::TimePeriod>,
}
impl BudgetedAndActualAmounts {
    /// <p>The amount of cost or usage that you created the budget for.</p>
    pub fn budgeted_amount(&self) -> std::option::Option<&crate::model::Spend> {
        self.budgeted_amount.as_ref()
    }
    /// <p>Your actual costs or usage for a budget period.</p>
    pub fn actual_amount(&self) -> std::option::Option<&crate::model::Spend> {
        self.actual_amount.as_ref()
    }
    /// <p>The time period that's covered by this budget comparison.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::TimePeriod> {
        self.time_period.as_ref()
    }
}
impl std::fmt::Debug for BudgetedAndActualAmounts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BudgetedAndActualAmounts");
        formatter.field("budgeted_amount", &self.budgeted_amount);
        formatter.field("actual_amount", &self.actual_amount);
        formatter.field("time_period", &self.time_period);
        formatter.finish()
    }
}
/// See [`BudgetedAndActualAmounts`](crate::model::BudgetedAndActualAmounts)
pub mod budgeted_and_actual_amounts {
    /// A builder for [`BudgetedAndActualAmounts`](crate::model::BudgetedAndActualAmounts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budgeted_amount: std::option::Option<crate::model::Spend>,
        pub(crate) actual_amount: std::option::Option<crate::model::Spend>,
        pub(crate) time_period: std::option::Option<crate::model::TimePeriod>,
    }
    impl Builder {
        /// <p>The amount of cost or usage that you created the budget for.</p>
        pub fn budgeted_amount(mut self, input: crate::model::Spend) -> Self {
            self.budgeted_amount = Some(input);
            self
        }
        /// <p>The amount of cost or usage that you created the budget for.</p>
        pub fn set_budgeted_amount(
            mut self,
            input: std::option::Option<crate::model::Spend>,
        ) -> Self {
            self.budgeted_amount = input;
            self
        }
        /// <p>Your actual costs or usage for a budget period.</p>
        pub fn actual_amount(mut self, input: crate::model::Spend) -> Self {
            self.actual_amount = Some(input);
            self
        }
        /// <p>Your actual costs or usage for a budget period.</p>
        pub fn set_actual_amount(
            mut self,
            input: std::option::Option<crate::model::Spend>,
        ) -> Self {
            self.actual_amount = input;
            self
        }
        /// <p>The time period that's covered by this budget comparison.</p>
        pub fn time_period(mut self, input: crate::model::TimePeriod) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period that's covered by this budget comparison.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Consumes the builder and constructs a [`BudgetedAndActualAmounts`](crate::model::BudgetedAndActualAmounts)
        pub fn build(self) -> crate::model::BudgetedAndActualAmounts {
            crate::model::BudgetedAndActualAmounts {
                budgeted_amount: self.budgeted_amount,
                actual_amount: self.actual_amount,
                time_period: self.time_period,
            }
        }
    }
}
impl BudgetedAndActualAmounts {
    /// Creates a new builder-style object to manufacture [`BudgetedAndActualAmounts`](crate::model::BudgetedAndActualAmounts)
    pub fn builder() -> crate::model::budgeted_and_actual_amounts::Builder {
        crate::model::budgeted_and_actual_amounts::Builder::default()
    }
}

/// <p>The historical records for a budget action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionHistory {
    /// <p> A generic time stamp. In Java, it's transformed to a <code>Date</code> object.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of action at the time of the event. </p>
    pub status: std::option::Option<crate::model::ActionStatus>,
    /// <p>This distinguishes between whether the events are triggered by the user or are generated by the system. </p>
    pub event_type: std::option::Option<crate::model::EventType>,
    /// <p>The description of the details for the event. </p>
    pub action_history_details: std::option::Option<crate::model::ActionHistoryDetails>,
}
impl ActionHistory {
    /// <p> A generic time stamp. In Java, it's transformed to a <code>Date</code> object.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>The status of action at the time of the event. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ActionStatus> {
        self.status.as_ref()
    }
    /// <p>This distinguishes between whether the events are triggered by the user or are generated by the system. </p>
    pub fn event_type(&self) -> std::option::Option<&crate::model::EventType> {
        self.event_type.as_ref()
    }
    /// <p>The description of the details for the event. </p>
    pub fn action_history_details(
        &self,
    ) -> std::option::Option<&crate::model::ActionHistoryDetails> {
        self.action_history_details.as_ref()
    }
}
impl std::fmt::Debug for ActionHistory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionHistory");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("status", &self.status);
        formatter.field("event_type", &self.event_type);
        formatter.field("action_history_details", &self.action_history_details);
        formatter.finish()
    }
}
/// See [`ActionHistory`](crate::model::ActionHistory)
pub mod action_history {
    /// A builder for [`ActionHistory`](crate::model::ActionHistory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ActionStatus>,
        pub(crate) event_type: std::option::Option<crate::model::EventType>,
        pub(crate) action_history_details: std::option::Option<crate::model::ActionHistoryDetails>,
    }
    impl Builder {
        /// <p> A generic time stamp. In Java, it's transformed to a <code>Date</code> object.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p> A generic time stamp. In Java, it's transformed to a <code>Date</code> object.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The status of action at the time of the event. </p>
        pub fn status(mut self, input: crate::model::ActionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of action at the time of the event. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>This distinguishes between whether the events are triggered by the user or are generated by the system. </p>
        pub fn event_type(mut self, input: crate::model::EventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>This distinguishes between whether the events are triggered by the user or are generated by the system. </p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>The description of the details for the event. </p>
        pub fn action_history_details(mut self, input: crate::model::ActionHistoryDetails) -> Self {
            self.action_history_details = Some(input);
            self
        }
        /// <p>The description of the details for the event. </p>
        pub fn set_action_history_details(
            mut self,
            input: std::option::Option<crate::model::ActionHistoryDetails>,
        ) -> Self {
            self.action_history_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionHistory`](crate::model::ActionHistory)
        pub fn build(self) -> crate::model::ActionHistory {
            crate::model::ActionHistory {
                timestamp: self.timestamp,
                status: self.status,
                event_type: self.event_type,
                action_history_details: self.action_history_details,
            }
        }
    }
}
impl ActionHistory {
    /// Creates a new builder-style object to manufacture [`ActionHistory`](crate::model::ActionHistory)
    pub fn builder() -> crate::model::action_history::Builder {
        crate::model::action_history::Builder::default()
    }
}

/// <p>The description of the details for the event. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionHistoryDetails {
    /// <p> A generic string.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The budget action resource. </p>
    pub action: std::option::Option<crate::model::Action>,
}
impl ActionHistoryDetails {
    /// <p> A generic string.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The budget action resource. </p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for ActionHistoryDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionHistoryDetails");
        formatter.field("message", &self.message);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`ActionHistoryDetails`](crate::model::ActionHistoryDetails)
pub mod action_history_details {
    /// A builder for [`ActionHistoryDetails`](crate::model::ActionHistoryDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::Action>,
    }
    impl Builder {
        /// <p> A generic string.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The budget action resource. </p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The budget action resource. </p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionHistoryDetails`](crate::model::ActionHistoryDetails)
        pub fn build(self) -> crate::model::ActionHistoryDetails {
            crate::model::ActionHistoryDetails {
                message: self.message,
                action: self.action,
            }
        }
    }
}
impl ActionHistoryDetails {
    /// Creates a new builder-style object to manufacture [`ActionHistoryDetails`](crate::model::ActionHistoryDetails)
    pub fn builder() -> crate::model::action_history_details::Builder {
        crate::model::action_history_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    CreateAction,
    #[allow(missing_docs)] // documentation missing in model
    DeleteAction,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteAction,
    #[allow(missing_docs)] // documentation missing in model
    System,
    #[allow(missing_docs)] // documentation missing in model
    UpdateAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_ACTION" => EventType::CreateAction,
            "DELETE_ACTION" => EventType::DeleteAction,
            "EXECUTE_ACTION" => EventType::ExecuteAction,
            "SYSTEM" => EventType::System,
            "UPDATE_ACTION" => EventType::UpdateAction,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::CreateAction => "CREATE_ACTION",
            EventType::DeleteAction => "DELETE_ACTION",
            EventType::ExecuteAction => "EXECUTE_ACTION",
            EventType::System => "SYSTEM",
            EventType::UpdateAction => "UPDATE_ACTION",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_ACTION",
            "DELETE_ACTION",
            "EXECUTE_ACTION",
            "SYSTEM",
            "UPDATE_ACTION",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A notification with subscribers. A notification can have one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationWithSubscribers {
    /// <p>The notification that's associated with a budget.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>A list of subscribers who are subscribed to this notification.</p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
}
impl NotificationWithSubscribers {
    /// <p>The notification that's associated with a budget.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::Notification> {
        self.notification.as_ref()
    }
    /// <p>A list of subscribers who are subscribed to this notification.</p>
    pub fn subscribers(&self) -> std::option::Option<&[crate::model::Subscriber]> {
        self.subscribers.as_deref()
    }
}
impl std::fmt::Debug for NotificationWithSubscribers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationWithSubscribers");
        formatter.field("notification", &self.notification);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}
/// See [`NotificationWithSubscribers`](crate::model::NotificationWithSubscribers)
pub mod notification_with_subscribers {
    /// A builder for [`NotificationWithSubscribers`](crate::model::NotificationWithSubscribers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    }
    impl Builder {
        /// <p>The notification that's associated with a budget.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The notification that's associated with a budget.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>A list of subscribers who are subscribed to this notification.</p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input);
            self.subscribers = Some(v);
            self
        }
        /// <p>A list of subscribers who are subscribed to this notification.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationWithSubscribers`](crate::model::NotificationWithSubscribers)
        pub fn build(self) -> crate::model::NotificationWithSubscribers {
            crate::model::NotificationWithSubscribers {
                notification: self.notification,
                subscribers: self.subscribers,
            }
        }
    }
}
impl NotificationWithSubscribers {
    /// Creates a new builder-style object to manufacture [`NotificationWithSubscribers`](crate::model::NotificationWithSubscribers)
    pub fn builder() -> crate::model::notification_with_subscribers::Builder {
        crate::model::notification_with_subscribers::Builder::default()
    }
}
