// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p> Response of UpdateSubscriber </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSubscriberOutput {}
impl std::fmt::Debug for UpdateSubscriberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSubscriberOutput");
        formatter.finish()
    }
}
/// See [`UpdateSubscriberOutput`](crate::output::UpdateSubscriberOutput)
pub mod update_subscriber_output {
    /// A builder for [`UpdateSubscriberOutput`](crate::output::UpdateSubscriberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateSubscriberOutput`](crate::output::UpdateSubscriberOutput)
        pub fn build(self) -> crate::output::UpdateSubscriberOutput {
            crate::output::UpdateSubscriberOutput {}
        }
    }
}
impl UpdateSubscriberOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSubscriberOutput`](crate::output::UpdateSubscriberOutput)
    pub fn builder() -> crate::output::update_subscriber_output::Builder {
        crate::output::update_subscriber_output::Builder::default()
    }
}

/// <p> Response of UpdateNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNotificationOutput {}
impl std::fmt::Debug for UpdateNotificationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNotificationOutput");
        formatter.finish()
    }
}
/// See [`UpdateNotificationOutput`](crate::output::UpdateNotificationOutput)
pub mod update_notification_output {
    /// A builder for [`UpdateNotificationOutput`](crate::output::UpdateNotificationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateNotificationOutput`](crate::output::UpdateNotificationOutput)
        pub fn build(self) -> crate::output::UpdateNotificationOutput {
            crate::output::UpdateNotificationOutput {}
        }
    }
}
impl UpdateNotificationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNotificationOutput`](crate::output::UpdateNotificationOutput)
    pub fn builder() -> crate::output::update_notification_output::Builder {
        crate::output::update_notification_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> The previous action resource information. </p>
    pub old_action: std::option::Option<crate::model::Action>,
    /// <p> The updated action resource information. </p>
    pub new_action: std::option::Option<crate::model::Action>,
}
impl UpdateBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p> The previous action resource information. </p>
    pub fn old_action(&self) -> std::option::Option<&crate::model::Action> {
        self.old_action.as_ref()
    }
    /// <p> The updated action resource information. </p>
    pub fn new_action(&self) -> std::option::Option<&crate::model::Action> {
        self.new_action.as_ref()
    }
}
impl std::fmt::Debug for UpdateBudgetActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBudgetActionOutput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("old_action", &self.old_action);
        formatter.field("new_action", &self.new_action);
        formatter.finish()
    }
}
/// See [`UpdateBudgetActionOutput`](crate::output::UpdateBudgetActionOutput)
pub mod update_budget_action_output {
    /// A builder for [`UpdateBudgetActionOutput`](crate::output::UpdateBudgetActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) old_action: std::option::Option<crate::model::Action>,
        pub(crate) new_action: std::option::Option<crate::model::Action>,
    }
    impl Builder {
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> The previous action resource information. </p>
        pub fn old_action(mut self, input: crate::model::Action) -> Self {
            self.old_action = Some(input);
            self
        }
        /// <p> The previous action resource information. </p>
        pub fn set_old_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.old_action = input;
            self
        }
        /// <p> The updated action resource information. </p>
        pub fn new_action(mut self, input: crate::model::Action) -> Self {
            self.new_action = Some(input);
            self
        }
        /// <p> The updated action resource information. </p>
        pub fn set_new_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.new_action = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBudgetActionOutput`](crate::output::UpdateBudgetActionOutput)
        pub fn build(self) -> crate::output::UpdateBudgetActionOutput {
            crate::output::UpdateBudgetActionOutput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                old_action: self.old_action,
                new_action: self.new_action,
            }
        }
    }
}
impl UpdateBudgetActionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBudgetActionOutput`](crate::output::UpdateBudgetActionOutput)
    pub fn builder() -> crate::output::update_budget_action_output::Builder {
        crate::output::update_budget_action_output::Builder::default()
    }
}

/// <p> Response of UpdateBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBudgetOutput {}
impl std::fmt::Debug for UpdateBudgetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBudgetOutput");
        formatter.finish()
    }
}
/// See [`UpdateBudgetOutput`](crate::output::UpdateBudgetOutput)
pub mod update_budget_output {
    /// A builder for [`UpdateBudgetOutput`](crate::output::UpdateBudgetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateBudgetOutput`](crate::output::UpdateBudgetOutput)
        pub fn build(self) -> crate::output::UpdateBudgetOutput {
            crate::output::UpdateBudgetOutput {}
        }
    }
}
impl UpdateBudgetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBudgetOutput`](crate::output::UpdateBudgetOutput)
    pub fn builder() -> crate::output::update_budget_output::Builder {
        crate::output::update_budget_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p> The type of execution. </p>
    pub execution_type: std::option::Option<crate::model::ExecutionType>,
}
impl ExecuteBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p> The type of execution. </p>
    pub fn execution_type(&self) -> std::option::Option<&crate::model::ExecutionType> {
        self.execution_type.as_ref()
    }
}
impl std::fmt::Debug for ExecuteBudgetActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteBudgetActionOutput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action_id", &self.action_id);
        formatter.field("execution_type", &self.execution_type);
        formatter.finish()
    }
}
/// See [`ExecuteBudgetActionOutput`](crate::output::ExecuteBudgetActionOutput)
pub mod execute_budget_action_output {
    /// A builder for [`ExecuteBudgetActionOutput`](crate::output::ExecuteBudgetActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) execution_type: std::option::Option<crate::model::ExecutionType>,
    }
    impl Builder {
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p> The type of execution. </p>
        pub fn execution_type(mut self, input: crate::model::ExecutionType) -> Self {
            self.execution_type = Some(input);
            self
        }
        /// <p> The type of execution. </p>
        pub fn set_execution_type(
            mut self,
            input: std::option::Option<crate::model::ExecutionType>,
        ) -> Self {
            self.execution_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteBudgetActionOutput`](crate::output::ExecuteBudgetActionOutput)
        pub fn build(self) -> crate::output::ExecuteBudgetActionOutput {
            crate::output::ExecuteBudgetActionOutput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action_id: self.action_id,
                execution_type: self.execution_type,
            }
        }
    }
}
impl ExecuteBudgetActionOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteBudgetActionOutput`](crate::output::ExecuteBudgetActionOutput)
    pub fn builder() -> crate::output::execute_budget_action_output::Builder {
        crate::output::execute_budget_action_output::Builder::default()
    }
}

/// <p> Response of DescribeSubscribersForNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSubscribersForNotificationOutput {
    /// <p>A list of subscribers that are associated with a notification.</p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSubscribersForNotificationOutput {
    /// <p>A list of subscribers that are associated with a notification.</p>
    pub fn subscribers(&self) -> std::option::Option<&[crate::model::Subscriber]> {
        self.subscribers.as_deref()
    }
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSubscribersForNotificationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSubscribersForNotificationOutput");
        formatter.field("subscribers", &self.subscribers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSubscribersForNotificationOutput`](crate::output::DescribeSubscribersForNotificationOutput)
pub mod describe_subscribers_for_notification_output {
    /// A builder for [`DescribeSubscribersForNotificationOutput`](crate::output::DescribeSubscribersForNotificationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>A list of subscribers that are associated with a notification.</p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input);
            self.subscribers = Some(v);
            self
        }
        /// <p>A list of subscribers that are associated with a notification.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSubscribersForNotificationOutput`](crate::output::DescribeSubscribersForNotificationOutput)
        pub fn build(self) -> crate::output::DescribeSubscribersForNotificationOutput {
            crate::output::DescribeSubscribersForNotificationOutput {
                subscribers: self.subscribers,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSubscribersForNotificationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSubscribersForNotificationOutput`](crate::output::DescribeSubscribersForNotificationOutput)
    pub fn builder() -> crate::output::describe_subscribers_for_notification_output::Builder {
        crate::output::describe_subscribers_for_notification_output::Builder::default()
    }
}

/// <p> Response of GetNotificationsForBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationsForBudgetOutput {
    /// <p>A list of notifications that are associated with a budget.</p>
    pub notifications: std::option::Option<std::vec::Vec<crate::model::Notification>>,
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeNotificationsForBudgetOutput {
    /// <p>A list of notifications that are associated with a budget.</p>
    pub fn notifications(&self) -> std::option::Option<&[crate::model::Notification]> {
        self.notifications.as_deref()
    }
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeNotificationsForBudgetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationsForBudgetOutput");
        formatter.field("notifications", &self.notifications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeNotificationsForBudgetOutput`](crate::output::DescribeNotificationsForBudgetOutput)
pub mod describe_notifications_for_budget_output {
    /// A builder for [`DescribeNotificationsForBudgetOutput`](crate::output::DescribeNotificationsForBudgetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notifications: std::option::Option<std::vec::Vec<crate::model::Notification>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p>A list of notifications that are associated with a budget.</p>
        pub fn notifications(mut self, input: crate::model::Notification) -> Self {
            let mut v = self.notifications.unwrap_or_default();
            v.push(input);
            self.notifications = Some(v);
            self
        }
        /// <p>A list of notifications that are associated with a budget.</p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Notification>>,
        ) -> Self {
            self.notifications = input;
            self
        }
        /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationsForBudgetOutput`](crate::output::DescribeNotificationsForBudgetOutput)
        pub fn build(self) -> crate::output::DescribeNotificationsForBudgetOutput {
            crate::output::DescribeNotificationsForBudgetOutput {
                notifications: self.notifications,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeNotificationsForBudgetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNotificationsForBudgetOutput`](crate::output::DescribeNotificationsForBudgetOutput)
    pub fn builder() -> crate::output::describe_notifications_for_budget_output::Builder {
        crate::output::describe_notifications_for_budget_output::Builder::default()
    }
}

/// <p> Response of DescribeBudgets </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetsOutput {
    /// <p>A list of budgets.</p>
    pub budgets: std::option::Option<std::vec::Vec<crate::model::Budget>>,
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBudgetsOutput {
    /// <p>A list of budgets.</p>
    pub fn budgets(&self) -> std::option::Option<&[crate::model::Budget]> {
        self.budgets.as_deref()
    }
    /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBudgetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetsOutput");
        formatter.field("budgets", &self.budgets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBudgetsOutput`](crate::output::DescribeBudgetsOutput)
pub mod describe_budgets_output {
    /// A builder for [`DescribeBudgetsOutput`](crate::output::DescribeBudgetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budgets: std::option::Option<std::vec::Vec<crate::model::Budget>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `budgets`.
        ///
        /// To override the contents of this collection use [`set_budgets`](Self::set_budgets).
        ///
        /// <p>A list of budgets.</p>
        pub fn budgets(mut self, input: crate::model::Budget) -> Self {
            let mut v = self.budgets.unwrap_or_default();
            v.push(input);
            self.budgets = Some(v);
            self
        }
        /// <p>A list of budgets.</p>
        pub fn set_budgets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Budget>>,
        ) -> Self {
            self.budgets = input;
            self
        }
        /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token in the service response that indicates the next set of results that you can retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetsOutput`](crate::output::DescribeBudgetsOutput)
        pub fn build(self) -> crate::output::DescribeBudgetsOutput {
            crate::output::DescribeBudgetsOutput {
                budgets: self.budgets,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBudgetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetsOutput`](crate::output::DescribeBudgetsOutput)
    pub fn builder() -> crate::output::describe_budgets_output::Builder {
        crate::output::describe_budgets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetPerformanceHistoryOutput {
    /// <p>The history of how often the budget has gone into an <code>ALARM</code> state.</p>
    /// <p>For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four quarters.</p>
    pub budget_performance_history: std::option::Option<crate::model::BudgetPerformanceHistory>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBudgetPerformanceHistoryOutput {
    /// <p>The history of how often the budget has gone into an <code>ALARM</code> state.</p>
    /// <p>For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four quarters.</p>
    pub fn budget_performance_history(
        &self,
    ) -> std::option::Option<&crate::model::BudgetPerformanceHistory> {
        self.budget_performance_history.as_ref()
    }
    /// <p> A generic string.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBudgetPerformanceHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetPerformanceHistoryOutput");
        formatter.field(
            "budget_performance_history",
            &self.budget_performance_history,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBudgetPerformanceHistoryOutput`](crate::output::DescribeBudgetPerformanceHistoryOutput)
pub mod describe_budget_performance_history_output {
    /// A builder for [`DescribeBudgetPerformanceHistoryOutput`](crate::output::DescribeBudgetPerformanceHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_performance_history:
            std::option::Option<crate::model::BudgetPerformanceHistory>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The history of how often the budget has gone into an <code>ALARM</code> state.</p>
        /// <p>For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four quarters.</p>
        pub fn budget_performance_history(
            mut self,
            input: crate::model::BudgetPerformanceHistory,
        ) -> Self {
            self.budget_performance_history = Some(input);
            self
        }
        /// <p>The history of how often the budget has gone into an <code>ALARM</code> state.</p>
        /// <p>For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four quarters.</p>
        pub fn set_budget_performance_history(
            mut self,
            input: std::option::Option<crate::model::BudgetPerformanceHistory>,
        ) -> Self {
            self.budget_performance_history = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetPerformanceHistoryOutput`](crate::output::DescribeBudgetPerformanceHistoryOutput)
        pub fn build(self) -> crate::output::DescribeBudgetPerformanceHistoryOutput {
            crate::output::DescribeBudgetPerformanceHistoryOutput {
                budget_performance_history: self.budget_performance_history,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBudgetPerformanceHistoryOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetPerformanceHistoryOutput`](crate::output::DescribeBudgetPerformanceHistoryOutput)
    pub fn builder() -> crate::output::describe_budget_performance_history_output::Builder {
        crate::output::describe_budget_performance_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetNotificationsForAccountOutput {
    /// <p> A list of budget names and associated notifications for an account. </p>
    pub budget_notifications_for_account:
        std::option::Option<std::vec::Vec<crate::model::BudgetNotificationsForAccount>>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBudgetNotificationsForAccountOutput {
    /// <p> A list of budget names and associated notifications for an account. </p>
    pub fn budget_notifications_for_account(
        &self,
    ) -> std::option::Option<&[crate::model::BudgetNotificationsForAccount]> {
        self.budget_notifications_for_account.as_deref()
    }
    /// <p> A generic string.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBudgetNotificationsForAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetNotificationsForAccountOutput");
        formatter.field(
            "budget_notifications_for_account",
            &self.budget_notifications_for_account,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBudgetNotificationsForAccountOutput`](crate::output::DescribeBudgetNotificationsForAccountOutput)
pub mod describe_budget_notifications_for_account_output {
    /// A builder for [`DescribeBudgetNotificationsForAccountOutput`](crate::output::DescribeBudgetNotificationsForAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_notifications_for_account:
            std::option::Option<std::vec::Vec<crate::model::BudgetNotificationsForAccount>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `budget_notifications_for_account`.
        ///
        /// To override the contents of this collection use [`set_budget_notifications_for_account`](Self::set_budget_notifications_for_account).
        ///
        /// <p> A list of budget names and associated notifications for an account. </p>
        pub fn budget_notifications_for_account(
            mut self,
            input: crate::model::BudgetNotificationsForAccount,
        ) -> Self {
            let mut v = self.budget_notifications_for_account.unwrap_or_default();
            v.push(input);
            self.budget_notifications_for_account = Some(v);
            self
        }
        /// <p> A list of budget names and associated notifications for an account. </p>
        pub fn set_budget_notifications_for_account(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BudgetNotificationsForAccount>>,
        ) -> Self {
            self.budget_notifications_for_account = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetNotificationsForAccountOutput`](crate::output::DescribeBudgetNotificationsForAccountOutput)
        pub fn build(self) -> crate::output::DescribeBudgetNotificationsForAccountOutput {
            crate::output::DescribeBudgetNotificationsForAccountOutput {
                budget_notifications_for_account: self.budget_notifications_for_account,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBudgetNotificationsForAccountOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetNotificationsForAccountOutput`](crate::output::DescribeBudgetNotificationsForAccountOutput)
    pub fn builder() -> crate::output::describe_budget_notifications_for_account_output::Builder {
        crate::output::describe_budget_notifications_for_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionsForBudgetOutput {
    /// <p> A list of the budget action resources information. </p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBudgetActionsForBudgetOutput {
    /// <p> A list of the budget action resources information. </p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::Action]> {
        self.actions.as_deref()
    }
    /// <p> A generic string.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBudgetActionsForBudgetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionsForBudgetOutput");
        formatter.field("actions", &self.actions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBudgetActionsForBudgetOutput`](crate::output::DescribeBudgetActionsForBudgetOutput)
pub mod describe_budget_actions_for_budget_output {
    /// A builder for [`DescribeBudgetActionsForBudgetOutput`](crate::output::DescribeBudgetActionsForBudgetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p> A list of the budget action resources information. </p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p> A list of the budget action resources information. </p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionsForBudgetOutput`](crate::output::DescribeBudgetActionsForBudgetOutput)
        pub fn build(self) -> crate::output::DescribeBudgetActionsForBudgetOutput {
            crate::output::DescribeBudgetActionsForBudgetOutput {
                actions: self.actions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBudgetActionsForBudgetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionsForBudgetOutput`](crate::output::DescribeBudgetActionsForBudgetOutput)
    pub fn builder() -> crate::output::describe_budget_actions_for_budget_output::Builder {
        crate::output::describe_budget_actions_for_budget_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionsForAccountOutput {
    /// <p> A list of the budget action resources information. </p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBudgetActionsForAccountOutput {
    /// <p> A list of the budget action resources information. </p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::Action]> {
        self.actions.as_deref()
    }
    /// <p> A generic string.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBudgetActionsForAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionsForAccountOutput");
        formatter.field("actions", &self.actions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBudgetActionsForAccountOutput`](crate::output::DescribeBudgetActionsForAccountOutput)
pub mod describe_budget_actions_for_account_output {
    /// A builder for [`DescribeBudgetActionsForAccountOutput`](crate::output::DescribeBudgetActionsForAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p> A list of the budget action resources information. </p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p> A list of the budget action resources information. </p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionsForAccountOutput`](crate::output::DescribeBudgetActionsForAccountOutput)
        pub fn build(self) -> crate::output::DescribeBudgetActionsForAccountOutput {
            crate::output::DescribeBudgetActionsForAccountOutput {
                actions: self.actions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBudgetActionsForAccountOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionsForAccountOutput`](crate::output::DescribeBudgetActionsForAccountOutput)
    pub fn builder() -> crate::output::describe_budget_actions_for_account_output::Builder {
        crate::output::describe_budget_actions_for_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionHistoriesOutput {
    /// <p> The historical record of the budget action resource. </p>
    pub action_histories: std::option::Option<std::vec::Vec<crate::model::ActionHistory>>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBudgetActionHistoriesOutput {
    /// <p> The historical record of the budget action resource. </p>
    pub fn action_histories(&self) -> std::option::Option<&[crate::model::ActionHistory]> {
        self.action_histories.as_deref()
    }
    /// <p> A generic string.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBudgetActionHistoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionHistoriesOutput");
        formatter.field("action_histories", &self.action_histories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBudgetActionHistoriesOutput`](crate::output::DescribeBudgetActionHistoriesOutput)
pub mod describe_budget_action_histories_output {
    /// A builder for [`DescribeBudgetActionHistoriesOutput`](crate::output::DescribeBudgetActionHistoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_histories:
            std::option::Option<std::vec::Vec<crate::model::ActionHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `action_histories`.
        ///
        /// To override the contents of this collection use [`set_action_histories`](Self::set_action_histories).
        ///
        /// <p> The historical record of the budget action resource. </p>
        pub fn action_histories(mut self, input: crate::model::ActionHistory) -> Self {
            let mut v = self.action_histories.unwrap_or_default();
            v.push(input);
            self.action_histories = Some(v);
            self
        }
        /// <p> The historical record of the budget action resource. </p>
        pub fn set_action_histories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionHistory>>,
        ) -> Self {
            self.action_histories = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionHistoriesOutput`](crate::output::DescribeBudgetActionHistoriesOutput)
        pub fn build(self) -> crate::output::DescribeBudgetActionHistoriesOutput {
            crate::output::DescribeBudgetActionHistoriesOutput {
                action_histories: self.action_histories,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBudgetActionHistoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionHistoriesOutput`](crate::output::DescribeBudgetActionHistoriesOutput)
    pub fn builder() -> crate::output::describe_budget_action_histories_output::Builder {
        crate::output::describe_budget_action_histories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> A budget action resource. </p>
    pub action: std::option::Option<crate::model::Action>,
}
impl DescribeBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p> A budget action resource. </p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for DescribeBudgetActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionOutput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`DescribeBudgetActionOutput`](crate::output::DescribeBudgetActionOutput)
pub mod describe_budget_action_output {
    /// A builder for [`DescribeBudgetActionOutput`](crate::output::DescribeBudgetActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::Action>,
    }
    impl Builder {
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> A budget action resource. </p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p> A budget action resource. </p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionOutput`](crate::output::DescribeBudgetActionOutput)
        pub fn build(self) -> crate::output::DescribeBudgetActionOutput {
            crate::output::DescribeBudgetActionOutput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action: self.action,
            }
        }
    }
}
impl DescribeBudgetActionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionOutput`](crate::output::DescribeBudgetActionOutput)
    pub fn builder() -> crate::output::describe_budget_action_output::Builder {
        crate::output::describe_budget_action_output::Builder::default()
    }
}

/// <p> Response of DescribeBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetOutput {
    /// <p>The description of the budget.</p>
    pub budget: std::option::Option<crate::model::Budget>,
}
impl DescribeBudgetOutput {
    /// <p>The description of the budget.</p>
    pub fn budget(&self) -> std::option::Option<&crate::model::Budget> {
        self.budget.as_ref()
    }
}
impl std::fmt::Debug for DescribeBudgetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetOutput");
        formatter.field("budget", &self.budget);
        formatter.finish()
    }
}
/// See [`DescribeBudgetOutput`](crate::output::DescribeBudgetOutput)
pub mod describe_budget_output {
    /// A builder for [`DescribeBudgetOutput`](crate::output::DescribeBudgetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget: std::option::Option<crate::model::Budget>,
    }
    impl Builder {
        /// <p>The description of the budget.</p>
        pub fn budget(mut self, input: crate::model::Budget) -> Self {
            self.budget = Some(input);
            self
        }
        /// <p>The description of the budget.</p>
        pub fn set_budget(mut self, input: std::option::Option<crate::model::Budget>) -> Self {
            self.budget = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetOutput`](crate::output::DescribeBudgetOutput)
        pub fn build(self) -> crate::output::DescribeBudgetOutput {
            crate::output::DescribeBudgetOutput {
                budget: self.budget,
            }
        }
    }
}
impl DescribeBudgetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBudgetOutput`](crate::output::DescribeBudgetOutput)
    pub fn builder() -> crate::output::describe_budget_output::Builder {
        crate::output::describe_budget_output::Builder::default()
    }
}

/// <p> Response of DeleteSubscriber </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSubscriberOutput {}
impl std::fmt::Debug for DeleteSubscriberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSubscriberOutput");
        formatter.finish()
    }
}
/// See [`DeleteSubscriberOutput`](crate::output::DeleteSubscriberOutput)
pub mod delete_subscriber_output {
    /// A builder for [`DeleteSubscriberOutput`](crate::output::DeleteSubscriberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSubscriberOutput`](crate::output::DeleteSubscriberOutput)
        pub fn build(self) -> crate::output::DeleteSubscriberOutput {
            crate::output::DeleteSubscriberOutput {}
        }
    }
}
impl DeleteSubscriberOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSubscriberOutput`](crate::output::DeleteSubscriberOutput)
    pub fn builder() -> crate::output::delete_subscriber_output::Builder {
        crate::output::delete_subscriber_output::Builder::default()
    }
}

/// <p> Response of DeleteNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationOutput {}
impl std::fmt::Debug for DeleteNotificationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationOutput");
        formatter.finish()
    }
}
/// See [`DeleteNotificationOutput`](crate::output::DeleteNotificationOutput)
pub mod delete_notification_output {
    /// A builder for [`DeleteNotificationOutput`](crate::output::DeleteNotificationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteNotificationOutput`](crate::output::DeleteNotificationOutput)
        pub fn build(self) -> crate::output::DeleteNotificationOutput {
            crate::output::DeleteNotificationOutput {}
        }
    }
}
impl DeleteNotificationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteNotificationOutput`](crate::output::DeleteNotificationOutput)
    pub fn builder() -> crate::output::delete_notification_output::Builder {
        crate::output::delete_notification_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>A budget action resource. </p>
    pub action: std::option::Option<crate::model::Action>,
}
impl DeleteBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p>A budget action resource. </p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for DeleteBudgetActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBudgetActionOutput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`DeleteBudgetActionOutput`](crate::output::DeleteBudgetActionOutput)
pub mod delete_budget_action_output {
    /// A builder for [`DeleteBudgetActionOutput`](crate::output::DeleteBudgetActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::Action>,
    }
    impl Builder {
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>A budget action resource. </p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>A budget action resource. </p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBudgetActionOutput`](crate::output::DeleteBudgetActionOutput)
        pub fn build(self) -> crate::output::DeleteBudgetActionOutput {
            crate::output::DeleteBudgetActionOutput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action: self.action,
            }
        }
    }
}
impl DeleteBudgetActionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBudgetActionOutput`](crate::output::DeleteBudgetActionOutput)
    pub fn builder() -> crate::output::delete_budget_action_output::Builder {
        crate::output::delete_budget_action_output::Builder::default()
    }
}

/// <p> Response of DeleteBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBudgetOutput {}
impl std::fmt::Debug for DeleteBudgetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBudgetOutput");
        formatter.finish()
    }
}
/// See [`DeleteBudgetOutput`](crate::output::DeleteBudgetOutput)
pub mod delete_budget_output {
    /// A builder for [`DeleteBudgetOutput`](crate::output::DeleteBudgetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBudgetOutput`](crate::output::DeleteBudgetOutput)
        pub fn build(self) -> crate::output::DeleteBudgetOutput {
            crate::output::DeleteBudgetOutput {}
        }
    }
}
impl DeleteBudgetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBudgetOutput`](crate::output::DeleteBudgetOutput)
    pub fn builder() -> crate::output::delete_budget_output::Builder {
        crate::output::delete_budget_output::Builder::default()
    }
}

/// <p> Response of CreateSubscriber </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSubscriberOutput {}
impl std::fmt::Debug for CreateSubscriberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSubscriberOutput");
        formatter.finish()
    }
}
/// See [`CreateSubscriberOutput`](crate::output::CreateSubscriberOutput)
pub mod create_subscriber_output {
    /// A builder for [`CreateSubscriberOutput`](crate::output::CreateSubscriberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateSubscriberOutput`](crate::output::CreateSubscriberOutput)
        pub fn build(self) -> crate::output::CreateSubscriberOutput {
            crate::output::CreateSubscriberOutput {}
        }
    }
}
impl CreateSubscriberOutput {
    /// Creates a new builder-style object to manufacture [`CreateSubscriberOutput`](crate::output::CreateSubscriberOutput)
    pub fn builder() -> crate::output::create_subscriber_output::Builder {
        crate::output::create_subscriber_output::Builder::default()
    }
}

/// <p> Response of CreateNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNotificationOutput {}
impl std::fmt::Debug for CreateNotificationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNotificationOutput");
        formatter.finish()
    }
}
/// See [`CreateNotificationOutput`](crate::output::CreateNotificationOutput)
pub mod create_notification_output {
    /// A builder for [`CreateNotificationOutput`](crate::output::CreateNotificationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateNotificationOutput`](crate::output::CreateNotificationOutput)
        pub fn build(self) -> crate::output::CreateNotificationOutput {
            crate::output::CreateNotificationOutput {}
        }
    }
}
impl CreateNotificationOutput {
    /// Creates a new builder-style object to manufacture [`CreateNotificationOutput`](crate::output::CreateNotificationOutput)
    pub fn builder() -> crate::output::create_notification_output::Builder {
        crate::output::create_notification_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    pub action_id: std::option::Option<std::string::String>,
}
impl CreateBudgetActionOutput {
    /// <p>The account ID of the user. It's a 12-digit number.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBudgetActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBudgetActionOutput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action_id", &self.action_id);
        formatter.finish()
    }
}
/// See [`CreateBudgetActionOutput`](crate::output::CreateBudgetActionOutput)
pub mod create_budget_action_output {
    /// A builder for [`CreateBudgetActionOutput`](crate::output::CreateBudgetActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It's a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p> A system-generated universally unique identifier (UUID) for the action. </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBudgetActionOutput`](crate::output::CreateBudgetActionOutput)
        pub fn build(self) -> crate::output::CreateBudgetActionOutput {
            crate::output::CreateBudgetActionOutput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action_id: self.action_id,
            }
        }
    }
}
impl CreateBudgetActionOutput {
    /// Creates a new builder-style object to manufacture [`CreateBudgetActionOutput`](crate::output::CreateBudgetActionOutput)
    pub fn builder() -> crate::output::create_budget_action_output::Builder {
        crate::output::create_budget_action_output::Builder::default()
    }
}

/// <p> Response of CreateBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBudgetOutput {}
impl std::fmt::Debug for CreateBudgetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBudgetOutput");
        formatter.finish()
    }
}
/// See [`CreateBudgetOutput`](crate::output::CreateBudgetOutput)
pub mod create_budget_output {
    /// A builder for [`CreateBudgetOutput`](crate::output::CreateBudgetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateBudgetOutput`](crate::output::CreateBudgetOutput)
        pub fn build(self) -> crate::output::CreateBudgetOutput {
            crate::output::CreateBudgetOutput {}
        }
    }
}
impl CreateBudgetOutput {
    /// Creates a new builder-style object to manufacture [`CreateBudgetOutput`](crate::output::CreateBudgetOutput)
    pub fn builder() -> crate::output::create_budget_output::Builder {
        crate::output::create_budget_output::Builder::default()
    }
}
