// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBudgetError {
    /// Kind of error that occurred.
    pub kind: CreateBudgetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBudgetErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceededException(crate::error::CreationLimitExceededException),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecordException(crate::error::DuplicateRecordException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBudgetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBudgetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBudgetErrorKind::CreationLimitExceededException(_inner) => _inner.fmt(f),
            CreateBudgetErrorKind::DuplicateRecordException(_inner) => _inner.fmt(f),
            CreateBudgetErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateBudgetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateBudgetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBudgetError {
    fn code(&self) -> Option<&str> {
        CreateBudgetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBudgetError {
    /// Creates a new `CreateBudgetError`.
    pub fn new(kind: CreateBudgetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBudgetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBudgetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBudgetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBudgetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBudgetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateBudgetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateBudgetErrorKind::CreationLimitExceededException`.
    pub fn is_creation_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetErrorKind::CreationLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBudgetErrorKind::DuplicateRecordException`.
    pub fn is_duplicate_record_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetErrorKind::DuplicateRecordException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBudgetErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, CreateBudgetErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `CreateBudgetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for CreateBudgetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBudgetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBudgetErrorKind::CreationLimitExceededException(_inner) => Some(_inner),
            CreateBudgetErrorKind::DuplicateRecordException(_inner) => Some(_inner),
            CreateBudgetErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateBudgetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateBudgetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBudgetActionError {
    /// Kind of error that occurred.
    pub kind: CreateBudgetActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBudgetActionErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceededException(crate::error::CreationLimitExceededException),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecordException(crate::error::DuplicateRecordException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBudgetActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBudgetActionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBudgetActionErrorKind::CreationLimitExceededException(_inner) => _inner.fmt(f),
            CreateBudgetActionErrorKind::DuplicateRecordException(_inner) => _inner.fmt(f),
            CreateBudgetActionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateBudgetActionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateBudgetActionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBudgetActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBudgetActionError {
    fn code(&self) -> Option<&str> {
        CreateBudgetActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBudgetActionError {
    /// Creates a new `CreateBudgetActionError`.
    pub fn new(kind: CreateBudgetActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBudgetActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBudgetActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBudgetActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBudgetActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBudgetActionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetActionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBudgetActionErrorKind::CreationLimitExceededException`.
    pub fn is_creation_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetActionErrorKind::CreationLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBudgetActionErrorKind::DuplicateRecordException`.
    pub fn is_duplicate_record_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetActionErrorKind::DuplicateRecordException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBudgetActionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetActionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBudgetActionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetActionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBudgetActionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBudgetActionErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for CreateBudgetActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBudgetActionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBudgetActionErrorKind::CreationLimitExceededException(_inner) => Some(_inner),
            CreateBudgetActionErrorKind::DuplicateRecordException(_inner) => Some(_inner),
            CreateBudgetActionErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateBudgetActionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateBudgetActionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBudgetActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNotificationError {
    /// Kind of error that occurred.
    pub kind: CreateNotificationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNotificationErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceededException(crate::error::CreationLimitExceededException),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecordException(crate::error::DuplicateRecordException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNotificationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNotificationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateNotificationErrorKind::CreationLimitExceededException(_inner) => _inner.fmt(f),
            CreateNotificationErrorKind::DuplicateRecordException(_inner) => _inner.fmt(f),
            CreateNotificationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateNotificationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateNotificationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateNotificationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNotificationError {
    fn code(&self) -> Option<&str> {
        CreateNotificationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNotificationError {
    /// Creates a new `CreateNotificationError`.
    pub fn new(kind: CreateNotificationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNotificationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNotificationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNotificationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNotificationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNotificationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNotificationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNotificationErrorKind::CreationLimitExceededException`.
    pub fn is_creation_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNotificationErrorKind::CreationLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNotificationErrorKind::DuplicateRecordException`.
    pub fn is_duplicate_record_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNotificationErrorKind::DuplicateRecordException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNotificationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNotificationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNotificationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNotificationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNotificationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNotificationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for CreateNotificationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNotificationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateNotificationErrorKind::CreationLimitExceededException(_inner) => Some(_inner),
            CreateNotificationErrorKind::DuplicateRecordException(_inner) => Some(_inner),
            CreateNotificationErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateNotificationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateNotificationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateNotificationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSubscriber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSubscriberError {
    /// Kind of error that occurred.
    pub kind: CreateSubscriberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSubscriber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSubscriberErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You've exceeded the notification or subscriber limit.</p>
    CreationLimitExceededException(crate::error::CreationLimitExceededException),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecordException(crate::error::DuplicateRecordException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSubscriberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSubscriberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSubscriberErrorKind::CreationLimitExceededException(_inner) => _inner.fmt(f),
            CreateSubscriberErrorKind::DuplicateRecordException(_inner) => _inner.fmt(f),
            CreateSubscriberErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateSubscriberErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateSubscriberErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateSubscriberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSubscriberError {
    fn code(&self) -> Option<&str> {
        CreateSubscriberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSubscriberError {
    /// Creates a new `CreateSubscriberError`.
    pub fn new(kind: CreateSubscriberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSubscriberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSubscriberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSubscriberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSubscriberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSubscriberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubscriberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubscriberErrorKind::CreationLimitExceededException`.
    pub fn is_creation_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubscriberErrorKind::CreationLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubscriberErrorKind::DuplicateRecordException`.
    pub fn is_duplicate_record_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubscriberErrorKind::DuplicateRecordException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubscriberErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubscriberErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubscriberErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubscriberErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubscriberErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateSubscriberErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CreateSubscriberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSubscriberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSubscriberErrorKind::CreationLimitExceededException(_inner) => Some(_inner),
            CreateSubscriberErrorKind::DuplicateRecordException(_inner) => Some(_inner),
            CreateSubscriberErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateSubscriberErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateSubscriberErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateSubscriberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBudgetError {
    /// Kind of error that occurred.
    pub kind: DeleteBudgetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBudgetErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBudgetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBudgetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBudgetErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteBudgetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteBudgetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBudgetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBudgetError {
    fn code(&self) -> Option<&str> {
        DeleteBudgetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBudgetError {
    /// Creates a new `DeleteBudgetError`.
    pub fn new(kind: DeleteBudgetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBudgetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBudgetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBudgetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBudgetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBudgetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteBudgetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteBudgetErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, DeleteBudgetErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `DeleteBudgetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBudgetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBudgetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBudgetErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteBudgetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBudgetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBudgetErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteBudgetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteBudgetErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBudgetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBudgetActionError {
    /// Kind of error that occurred.
    pub kind: DeleteBudgetActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBudgetActionErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The request was received and recognized by the server, but the server rejected that particular method for the requested resource. </p>
    ResourceLockedException(crate::error::ResourceLockedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBudgetActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBudgetActionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBudgetActionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteBudgetActionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteBudgetActionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBudgetActionErrorKind::ResourceLockedException(_inner) => _inner.fmt(f),
            DeleteBudgetActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBudgetActionError {
    fn code(&self) -> Option<&str> {
        DeleteBudgetActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBudgetActionError {
    /// Creates a new `DeleteBudgetActionError`.
    pub fn new(kind: DeleteBudgetActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBudgetActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBudgetActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBudgetActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBudgetActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBudgetActionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBudgetActionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBudgetActionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBudgetActionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBudgetActionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBudgetActionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBudgetActionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBudgetActionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBudgetActionErrorKind::ResourceLockedException`.
    pub fn is_resource_locked_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBudgetActionErrorKind::ResourceLockedException(_)
        )
    }
}
impl std::error::Error for DeleteBudgetActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBudgetActionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBudgetActionErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteBudgetActionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteBudgetActionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBudgetActionErrorKind::ResourceLockedException(_inner) => Some(_inner),
            DeleteBudgetActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNotificationError {
    /// Kind of error that occurred.
    pub kind: DeleteNotificationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNotificationErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNotificationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNotificationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteNotificationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteNotificationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteNotificationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteNotificationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNotificationError {
    fn code(&self) -> Option<&str> {
        DeleteNotificationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNotificationError {
    /// Creates a new `DeleteNotificationError`.
    pub fn new(kind: DeleteNotificationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNotificationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNotificationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNotificationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNotificationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNotificationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNotificationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNotificationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNotificationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteNotificationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNotificationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteNotificationErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteNotificationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteNotificationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteNotificationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSubscriber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSubscriberError {
    /// Kind of error that occurred.
    pub kind: DeleteSubscriberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSubscriber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSubscriberErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSubscriberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSubscriberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSubscriberErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteSubscriberErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteSubscriberErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSubscriberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSubscriberError {
    fn code(&self) -> Option<&str> {
        DeleteSubscriberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSubscriberError {
    /// Creates a new `DeleteSubscriberError`.
    pub fn new(kind: DeleteSubscriberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSubscriberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSubscriberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSubscriberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSubscriberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSubscriberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriberErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriberErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriberErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriberErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriberErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSubscriberErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteSubscriberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSubscriberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSubscriberErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteSubscriberErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteSubscriberErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSubscriberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeBudgetErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeBudgetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeBudgetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBudgetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetError {
    /// Creates a new `DescribeBudgetError`.
    pub fn new(kind: DescribeBudgetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeBudgetErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DescribeBudgetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeBudgetErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeBudgetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeBudgetErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBudgetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetActionError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetActionErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetActionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeBudgetActionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeBudgetActionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeBudgetActionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBudgetActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetActionError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetActionError {
    /// Creates a new `DescribeBudgetActionError`.
    pub fn new(kind: DescribeBudgetActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeBudgetActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetActionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeBudgetActionErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeBudgetActionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeBudgetActionErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBudgetActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBudgetActionHistories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetActionHistoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetActionHistoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudgetActionHistories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetActionHistoriesErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetActionHistoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetActionHistoriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeBudgetActionHistoriesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeBudgetActionHistoriesErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionHistoriesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionHistoriesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBudgetActionHistoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetActionHistoriesError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetActionHistoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetActionHistoriesError {
    /// Creates a new `DescribeBudgetActionHistoriesError`.
    pub fn new(
        kind: DescribeBudgetActionHistoriesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetActionHistoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetActionHistoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetActionHistoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetActionHistoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionHistoriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionHistoriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionHistoriesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionHistoriesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionHistoriesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionHistoriesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionHistoriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionHistoriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionHistoriesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionHistoriesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeBudgetActionHistoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetActionHistoriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeBudgetActionHistoriesErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeBudgetActionHistoriesErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetActionHistoriesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetActionHistoriesErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBudgetActionHistoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBudgetActionsForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetActionsForAccountError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetActionsForAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudgetActionsForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetActionsForAccountErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetActionsForAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetActionsForAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionsForAccountErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionsForAccountErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionsForAccountErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionsForAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetActionsForAccountError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetActionsForAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetActionsForAccountError {
    /// Creates a new `DescribeBudgetActionsForAccountError`.
    pub fn new(
        kind: DescribeBudgetActionsForAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetActionsForAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetActionsForAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetActionsForAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetActionsForAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForAccountErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForAccountErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForAccountErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForAccountErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForAccountErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForAccountErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for DescribeBudgetActionsForAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetActionsForAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeBudgetActionsForAccountErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetActionsForAccountErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetActionsForAccountErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetActionsForAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBudgetActionsForBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetActionsForBudgetError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetActionsForBudgetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudgetActionsForBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetActionsForBudgetErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetActionsForBudgetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetActionsForBudgetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeBudgetActionsForBudgetErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionsForBudgetErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionsForBudgetErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetActionsForBudgetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBudgetActionsForBudgetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetActionsForBudgetError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetActionsForBudgetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetActionsForBudgetError {
    /// Creates a new `DescribeBudgetActionsForBudgetError`.
    pub fn new(
        kind: DescribeBudgetActionsForBudgetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetActionsForBudgetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetActionsForBudgetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetActionsForBudgetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetActionsForBudgetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForBudgetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForBudgetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForBudgetErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForBudgetErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForBudgetErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForBudgetErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForBudgetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForBudgetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetActionsForBudgetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetActionsForBudgetErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeBudgetActionsForBudgetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetActionsForBudgetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeBudgetActionsForBudgetErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeBudgetActionsForBudgetErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetActionsForBudgetErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetActionsForBudgetErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBudgetActionsForBudgetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBudgetNotificationsForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetNotificationsForAccountError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetNotificationsForAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudgetNotificationsForAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetNotificationsForAccountErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The pagination token expired.</p>
    ExpiredNextTokenException(crate::error::ExpiredNextTokenException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetNotificationsForAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetNotificationsForAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetNotificationsForAccountErrorKind::ExpiredNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetNotificationsForAccountErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetNotificationsForAccountErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetNotificationsForAccountErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetNotificationsForAccountErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetNotificationsForAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetNotificationsForAccountError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetNotificationsForAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetNotificationsForAccountError {
    /// Creates a new `DescribeBudgetNotificationsForAccountError`.
    pub fn new(
        kind: DescribeBudgetNotificationsForAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetNotificationsForAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetNotificationsForAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetNotificationsForAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetNotificationsForAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetNotificationsForAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetNotificationsForAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetNotificationsForAccountErrorKind::ExpiredNextTokenException`.
    pub fn is_expired_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetNotificationsForAccountErrorKind::ExpiredNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetNotificationsForAccountErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetNotificationsForAccountErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetNotificationsForAccountErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetNotificationsForAccountErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetNotificationsForAccountErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetNotificationsForAccountErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetNotificationsForAccountErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetNotificationsForAccountErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeBudgetNotificationsForAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetNotificationsForAccountErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetNotificationsForAccountErrorKind::ExpiredNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetNotificationsForAccountErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetNotificationsForAccountErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetNotificationsForAccountErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetNotificationsForAccountErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetNotificationsForAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeBudgetPerformanceHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetPerformanceHistoryError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetPerformanceHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudgetPerformanceHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetPerformanceHistoryErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The pagination token expired.</p>
    ExpiredNextTokenException(crate::error::ExpiredNextTokenException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetPerformanceHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetPerformanceHistoryErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetPerformanceHistoryErrorKind::ExpiredNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetPerformanceHistoryErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetPerformanceHistoryErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetPerformanceHistoryErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeBudgetPerformanceHistoryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBudgetPerformanceHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetPerformanceHistoryError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetPerformanceHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetPerformanceHistoryError {
    /// Creates a new `DescribeBudgetPerformanceHistoryError`.
    pub fn new(
        kind: DescribeBudgetPerformanceHistoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetPerformanceHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetPerformanceHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetPerformanceHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetPerformanceHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetPerformanceHistoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetPerformanceHistoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetPerformanceHistoryErrorKind::ExpiredNextTokenException`.
    pub fn is_expired_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetPerformanceHistoryErrorKind::ExpiredNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetPerformanceHistoryErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetPerformanceHistoryErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetPerformanceHistoryErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetPerformanceHistoryErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetPerformanceHistoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetPerformanceHistoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetPerformanceHistoryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetPerformanceHistoryErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeBudgetPerformanceHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetPerformanceHistoryErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetPerformanceHistoryErrorKind::ExpiredNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetPerformanceHistoryErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetPerformanceHistoryErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetPerformanceHistoryErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeBudgetPerformanceHistoryErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBudgetPerformanceHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBudgets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBudgetsError {
    /// Kind of error that occurred.
    pub kind: DescribeBudgetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBudgets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBudgetsErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The pagination token expired.</p>
    ExpiredNextTokenException(crate::error::ExpiredNextTokenException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBudgetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBudgetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeBudgetsErrorKind::ExpiredNextTokenException(_inner) => _inner.fmt(f),
            DescribeBudgetsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeBudgetsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeBudgetsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeBudgetsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBudgetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBudgetsError {
    fn code(&self) -> Option<&str> {
        DescribeBudgetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBudgetsError {
    /// Creates a new `DescribeBudgetsError`.
    pub fn new(kind: DescribeBudgetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBudgetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBudgetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBudgetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBudgetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBudgetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetsErrorKind::ExpiredNextTokenException`.
    pub fn is_expired_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetsErrorKind::ExpiredNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBudgetsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBudgetsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeBudgetsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DescribeBudgetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBudgetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeBudgetsErrorKind::ExpiredNextTokenException(_inner) => Some(_inner),
            DescribeBudgetsErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeBudgetsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeBudgetsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeBudgetsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBudgetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNotificationsForBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNotificationsForBudgetError {
    /// Kind of error that occurred.
    pub kind: DescribeNotificationsForBudgetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNotificationsForBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNotificationsForBudgetErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The pagination token expired.</p>
    ExpiredNextTokenException(crate::error::ExpiredNextTokenException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNotificationsForBudgetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNotificationsForBudgetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeNotificationsForBudgetErrorKind::ExpiredNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeNotificationsForBudgetErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeNotificationsForBudgetErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeNotificationsForBudgetErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeNotificationsForBudgetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeNotificationsForBudgetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNotificationsForBudgetError {
    fn code(&self) -> Option<&str> {
        DescribeNotificationsForBudgetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNotificationsForBudgetError {
    /// Creates a new `DescribeNotificationsForBudgetError`.
    pub fn new(
        kind: DescribeNotificationsForBudgetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNotificationsForBudgetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNotificationsForBudgetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNotificationsForBudgetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNotificationsForBudgetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNotificationsForBudgetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationsForBudgetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNotificationsForBudgetErrorKind::ExpiredNextTokenException`.
    pub fn is_expired_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationsForBudgetErrorKind::ExpiredNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNotificationsForBudgetErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationsForBudgetErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNotificationsForBudgetErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationsForBudgetErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNotificationsForBudgetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationsForBudgetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNotificationsForBudgetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationsForBudgetErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeNotificationsForBudgetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNotificationsForBudgetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeNotificationsForBudgetErrorKind::ExpiredNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeNotificationsForBudgetErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeNotificationsForBudgetErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeNotificationsForBudgetErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeNotificationsForBudgetErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeNotificationsForBudgetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSubscribersForNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSubscribersForNotificationError {
    /// Kind of error that occurred.
    pub kind: DescribeSubscribersForNotificationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSubscribersForNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSubscribersForNotificationErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The pagination token expired.</p>
    ExpiredNextTokenException(crate::error::ExpiredNextTokenException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The pagination token is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSubscribersForNotificationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSubscribersForNotificationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscribersForNotificationErrorKind::ExpiredNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscribersForNotificationErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscribersForNotificationErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscribersForNotificationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscribersForNotificationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeSubscribersForNotificationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSubscribersForNotificationError {
    fn code(&self) -> Option<&str> {
        DescribeSubscribersForNotificationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSubscribersForNotificationError {
    /// Creates a new `DescribeSubscribersForNotificationError`.
    pub fn new(
        kind: DescribeSubscribersForNotificationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSubscribersForNotificationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSubscribersForNotificationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSubscribersForNotificationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSubscribersForNotificationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSubscribersForNotificationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscribersForNotificationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscribersForNotificationErrorKind::ExpiredNextTokenException`.
    pub fn is_expired_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscribersForNotificationErrorKind::ExpiredNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscribersForNotificationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscribersForNotificationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscribersForNotificationErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscribersForNotificationErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscribersForNotificationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscribersForNotificationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscribersForNotificationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscribersForNotificationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSubscribersForNotificationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSubscribersForNotificationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeSubscribersForNotificationErrorKind::ExpiredNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeSubscribersForNotificationErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            DescribeSubscribersForNotificationErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeSubscribersForNotificationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeSubscribersForNotificationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeSubscribersForNotificationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteBudgetActionError {
    /// Kind of error that occurred.
    pub kind: ExecuteBudgetActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteBudgetActionErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The request was received and recognized by the server, but the server rejected that particular method for the requested resource. </p>
    ResourceLockedException(crate::error::ResourceLockedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteBudgetActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteBudgetActionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ExecuteBudgetActionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ExecuteBudgetActionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ExecuteBudgetActionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ExecuteBudgetActionErrorKind::ResourceLockedException(_inner) => _inner.fmt(f),
            ExecuteBudgetActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteBudgetActionError {
    fn code(&self) -> Option<&str> {
        ExecuteBudgetActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteBudgetActionError {
    /// Creates a new `ExecuteBudgetActionError`.
    pub fn new(kind: ExecuteBudgetActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteBudgetActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteBudgetActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteBudgetActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteBudgetActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteBudgetActionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteBudgetActionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteBudgetActionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteBudgetActionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteBudgetActionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteBudgetActionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteBudgetActionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteBudgetActionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteBudgetActionErrorKind::ResourceLockedException`.
    pub fn is_resource_locked_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteBudgetActionErrorKind::ResourceLockedException(_)
        )
    }
}
impl std::error::Error for ExecuteBudgetActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteBudgetActionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ExecuteBudgetActionErrorKind::InternalErrorException(_inner) => Some(_inner),
            ExecuteBudgetActionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ExecuteBudgetActionErrorKind::NotFoundException(_inner) => Some(_inner),
            ExecuteBudgetActionErrorKind::ResourceLockedException(_inner) => Some(_inner),
            ExecuteBudgetActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBudgetError {
    /// Kind of error that occurred.
    pub kind: UpdateBudgetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBudget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBudgetErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBudgetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBudgetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateBudgetErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateBudgetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateBudgetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBudgetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBudgetError {
    fn code(&self) -> Option<&str> {
        UpdateBudgetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBudgetError {
    /// Creates a new `UpdateBudgetError`.
    pub fn new(kind: UpdateBudgetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBudgetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBudgetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBudgetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBudgetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBudgetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateBudgetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateBudgetErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, UpdateBudgetErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `UpdateBudgetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBudgetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBudgetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateBudgetErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateBudgetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBudgetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateBudgetErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateBudgetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateBudgetErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBudgetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBudgetActionError {
    /// Kind of error that occurred.
    pub kind: UpdateBudgetActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBudgetAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBudgetActionErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The request was received and recognized by the server, but the server rejected that particular method for the requested resource. </p>
    ResourceLockedException(crate::error::ResourceLockedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBudgetActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBudgetActionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateBudgetActionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateBudgetActionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateBudgetActionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBudgetActionErrorKind::ResourceLockedException(_inner) => _inner.fmt(f),
            UpdateBudgetActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBudgetActionError {
    fn code(&self) -> Option<&str> {
        UpdateBudgetActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBudgetActionError {
    /// Creates a new `UpdateBudgetActionError`.
    pub fn new(kind: UpdateBudgetActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBudgetActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBudgetActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBudgetActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBudgetActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBudgetActionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBudgetActionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBudgetActionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBudgetActionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBudgetActionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBudgetActionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBudgetActionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBudgetActionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBudgetActionErrorKind::ResourceLockedException`.
    pub fn is_resource_locked_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBudgetActionErrorKind::ResourceLockedException(_)
        )
    }
}
impl std::error::Error for UpdateBudgetActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBudgetActionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateBudgetActionErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateBudgetActionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateBudgetActionErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBudgetActionErrorKind::ResourceLockedException(_inner) => Some(_inner),
            UpdateBudgetActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNotificationError {
    /// Kind of error that occurred.
    pub kind: UpdateNotificationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNotification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNotificationErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecordException(crate::error::DuplicateRecordException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNotificationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNotificationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateNotificationErrorKind::DuplicateRecordException(_inner) => _inner.fmt(f),
            UpdateNotificationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateNotificationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateNotificationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateNotificationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNotificationError {
    fn code(&self) -> Option<&str> {
        UpdateNotificationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNotificationError {
    /// Creates a new `UpdateNotificationError`.
    pub fn new(kind: UpdateNotificationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNotificationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNotificationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNotificationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNotificationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNotificationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNotificationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNotificationErrorKind::DuplicateRecordException`.
    pub fn is_duplicate_record_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNotificationErrorKind::DuplicateRecordException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNotificationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNotificationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNotificationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNotificationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNotificationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNotificationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateNotificationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNotificationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateNotificationErrorKind::DuplicateRecordException(_inner) => Some(_inner),
            UpdateNotificationErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateNotificationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateNotificationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateNotificationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSubscriber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSubscriberError {
    /// Kind of error that occurred.
    pub kind: UpdateSubscriberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSubscriber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSubscriberErrorKind {
    /// <p>You are not authorized to use this operation with the given parameters.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The budget name already exists. Budget names must be unique within an account.</p>
    DuplicateRecordException(crate::error::DuplicateRecordException),
    /// <p>An error on the server occurred during the processing of your request. Try again later.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>We can’t locate the resource that you specified.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSubscriberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSubscriberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSubscriberErrorKind::DuplicateRecordException(_inner) => _inner.fmt(f),
            UpdateSubscriberErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateSubscriberErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateSubscriberErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateSubscriberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSubscriberError {
    fn code(&self) -> Option<&str> {
        UpdateSubscriberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSubscriberError {
    /// Creates a new `UpdateSubscriberError`.
    pub fn new(kind: UpdateSubscriberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSubscriberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSubscriberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSubscriberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSubscriberErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSubscriberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriberErrorKind::DuplicateRecordException`.
    pub fn is_duplicate_record_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriberErrorKind::DuplicateRecordException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriberErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriberErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriberErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriberErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriberErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateSubscriberErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateSubscriberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSubscriberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSubscriberErrorKind::DuplicateRecordException(_inner) => Some(_inner),
            UpdateSubscriberErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateSubscriberErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateSubscriberErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateSubscriberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>We can’t locate the resource that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>An error on the server occurred during the processing of your request. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalErrorException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalErrorException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalErrorException {}
/// See [`InternalErrorException`](crate::error::InternalErrorException)
pub mod internal_error_exception {
    /// A builder for [`InternalErrorException`](crate::error::InternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalErrorException`](crate::error::InternalErrorException)
        pub fn build(self) -> crate::error::InternalErrorException {
            crate::error::InternalErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalErrorException {
    /// Creates a new builder-style object to manufacture [`InternalErrorException`](crate::error::InternalErrorException)
    pub fn builder() -> crate::error::internal_error_exception::Builder {
        crate::error::internal_error_exception::Builder::default()
    }
}

/// <p>The budget name already exists. Budget names must be unique within an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateRecordException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateRecordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateRecordException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateRecordException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateRecordException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateRecordException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateRecordException {}
/// See [`DuplicateRecordException`](crate::error::DuplicateRecordException)
pub mod duplicate_record_exception {
    /// A builder for [`DuplicateRecordException`](crate::error::DuplicateRecordException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateRecordException`](crate::error::DuplicateRecordException)
        pub fn build(self) -> crate::error::DuplicateRecordException {
            crate::error::DuplicateRecordException {
                message: self.message,
            }
        }
    }
}
impl DuplicateRecordException {
    /// Creates a new builder-style object to manufacture [`DuplicateRecordException`](crate::error::DuplicateRecordException)
    pub fn builder() -> crate::error::duplicate_record_exception::Builder {
        crate::error::duplicate_record_exception::Builder::default()
    }
}

/// <p>You are not authorized to use this operation with the given parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p> The request was received and recognized by the server, but the server rejected that particular method for the requested resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLockedException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLockedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLockedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLockedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLockedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLockedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLockedException {}
/// See [`ResourceLockedException`](crate::error::ResourceLockedException)
pub mod resource_locked_exception {
    /// A builder for [`ResourceLockedException`](crate::error::ResourceLockedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLockedException`](crate::error::ResourceLockedException)
        pub fn build(self) -> crate::error::ResourceLockedException {
            crate::error::ResourceLockedException {
                message: self.message,
            }
        }
    }
}
impl ResourceLockedException {
    /// Creates a new builder-style object to manufacture [`ResourceLockedException`](crate::error::ResourceLockedException)
    pub fn builder() -> crate::error::resource_locked_exception::Builder {
        crate::error::resource_locked_exception::Builder::default()
    }
}

/// <p>The pagination token is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The pagination token expired.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiredNextTokenException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExpiredNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiredNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExpiredNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExpiredNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExpiredNextTokenException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExpiredNextTokenException {}
/// See [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
pub mod expired_next_token_exception {
    /// A builder for [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
        pub fn build(self) -> crate::error::ExpiredNextTokenException {
            crate::error::ExpiredNextTokenException {
                message: self.message,
            }
        }
    }
}
impl ExpiredNextTokenException {
    /// Creates a new builder-style object to manufacture [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
    pub fn builder() -> crate::error::expired_next_token_exception::Builder {
        crate::error::expired_next_token_exception::Builder::default()
    }
}

/// <p>You've exceeded the notification or subscriber limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreationLimitExceededException {
    /// <p>The error message the exception carries.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreationLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreationLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CreationLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CreationLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CreationLimitExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for CreationLimitExceededException {}
/// See [`CreationLimitExceededException`](crate::error::CreationLimitExceededException)
pub mod creation_limit_exceeded_exception {
    /// A builder for [`CreationLimitExceededException`](crate::error::CreationLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message the exception carries.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message the exception carries.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CreationLimitExceededException`](crate::error::CreationLimitExceededException)
        pub fn build(self) -> crate::error::CreationLimitExceededException {
            crate::error::CreationLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl CreationLimitExceededException {
    /// Creates a new builder-style object to manufacture [`CreationLimitExceededException`](crate::error::CreationLimitExceededException)
    pub fn builder() -> crate::error::creation_limit_exceeded_exception::Builder {
        crate::error::creation_limit_exceeded_exception::Builder::default()
    }
}
