// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSBudgetServiceGateway`.
///
/// This client allows ergonomic access to a `AWSBudgetServiceGateway`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateBudget` operation.
    ///
    /// See [`CreateBudget`](crate::client::fluent_builders::CreateBudget) for more information about the
    /// operation and its arguments.
    pub fn create_budget(&self) -> fluent_builders::CreateBudget<C, M, R> {
        fluent_builders::CreateBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBudgetAction` operation.
    ///
    /// See [`CreateBudgetAction`](crate::client::fluent_builders::CreateBudgetAction) for more information about the
    /// operation and its arguments.
    pub fn create_budget_action(&self) -> fluent_builders::CreateBudgetAction<C, M, R> {
        fluent_builders::CreateBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNotification` operation.
    ///
    /// See [`CreateNotification`](crate::client::fluent_builders::CreateNotification) for more information about the
    /// operation and its arguments.
    pub fn create_notification(&self) -> fluent_builders::CreateNotification<C, M, R> {
        fluent_builders::CreateNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubscriber` operation.
    ///
    /// See [`CreateSubscriber`](crate::client::fluent_builders::CreateSubscriber) for more information about the
    /// operation and its arguments.
    pub fn create_subscriber(&self) -> fluent_builders::CreateSubscriber<C, M, R> {
        fluent_builders::CreateSubscriber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBudget` operation.
    ///
    /// See [`DeleteBudget`](crate::client::fluent_builders::DeleteBudget) for more information about the
    /// operation and its arguments.
    pub fn delete_budget(&self) -> fluent_builders::DeleteBudget<C, M, R> {
        fluent_builders::DeleteBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBudgetAction` operation.
    ///
    /// See [`DeleteBudgetAction`](crate::client::fluent_builders::DeleteBudgetAction) for more information about the
    /// operation and its arguments.
    pub fn delete_budget_action(&self) -> fluent_builders::DeleteBudgetAction<C, M, R> {
        fluent_builders::DeleteBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNotification` operation.
    ///
    /// See [`DeleteNotification`](crate::client::fluent_builders::DeleteNotification) for more information about the
    /// operation and its arguments.
    pub fn delete_notification(&self) -> fluent_builders::DeleteNotification<C, M, R> {
        fluent_builders::DeleteNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSubscriber` operation.
    ///
    /// See [`DeleteSubscriber`](crate::client::fluent_builders::DeleteSubscriber) for more information about the
    /// operation and its arguments.
    pub fn delete_subscriber(&self) -> fluent_builders::DeleteSubscriber<C, M, R> {
        fluent_builders::DeleteSubscriber::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBudget` operation.
    ///
    /// See [`DescribeBudget`](crate::client::fluent_builders::DescribeBudget) for more information about the
    /// operation and its arguments.
    pub fn describe_budget(&self) -> fluent_builders::DescribeBudget<C, M, R> {
        fluent_builders::DescribeBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBudgetAction` operation.
    ///
    /// See [`DescribeBudgetAction`](crate::client::fluent_builders::DescribeBudgetAction) for more information about the
    /// operation and its arguments.
    pub fn describe_budget_action(&self) -> fluent_builders::DescribeBudgetAction<C, M, R> {
        fluent_builders::DescribeBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBudgetActionHistories` operation.
    ///
    /// See [`DescribeBudgetActionHistories`](crate::client::fluent_builders::DescribeBudgetActionHistories) for more information about the
    /// operation and its arguments.
    pub fn describe_budget_action_histories(
        &self,
    ) -> fluent_builders::DescribeBudgetActionHistories<C, M, R> {
        fluent_builders::DescribeBudgetActionHistories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBudgetActionsForAccount` operation.
    ///
    /// See [`DescribeBudgetActionsForAccount`](crate::client::fluent_builders::DescribeBudgetActionsForAccount) for more information about the
    /// operation and its arguments.
    pub fn describe_budget_actions_for_account(
        &self,
    ) -> fluent_builders::DescribeBudgetActionsForAccount<C, M, R> {
        fluent_builders::DescribeBudgetActionsForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBudgetActionsForBudget` operation.
    ///
    /// See [`DescribeBudgetActionsForBudget`](crate::client::fluent_builders::DescribeBudgetActionsForBudget) for more information about the
    /// operation and its arguments.
    pub fn describe_budget_actions_for_budget(
        &self,
    ) -> fluent_builders::DescribeBudgetActionsForBudget<C, M, R> {
        fluent_builders::DescribeBudgetActionsForBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBudgetPerformanceHistory` operation.
    ///
    /// See [`DescribeBudgetPerformanceHistory`](crate::client::fluent_builders::DescribeBudgetPerformanceHistory) for more information about the
    /// operation and its arguments.
    pub fn describe_budget_performance_history(
        &self,
    ) -> fluent_builders::DescribeBudgetPerformanceHistory<C, M, R> {
        fluent_builders::DescribeBudgetPerformanceHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBudgets` operation.
    ///
    /// See [`DescribeBudgets`](crate::client::fluent_builders::DescribeBudgets) for more information about the
    /// operation and its arguments.
    pub fn describe_budgets(&self) -> fluent_builders::DescribeBudgets<C, M, R> {
        fluent_builders::DescribeBudgets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNotificationsForBudget` operation.
    ///
    /// See [`DescribeNotificationsForBudget`](crate::client::fluent_builders::DescribeNotificationsForBudget) for more information about the
    /// operation and its arguments.
    pub fn describe_notifications_for_budget(
        &self,
    ) -> fluent_builders::DescribeNotificationsForBudget<C, M, R> {
        fluent_builders::DescribeNotificationsForBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSubscribersForNotification` operation.
    ///
    /// See [`DescribeSubscribersForNotification`](crate::client::fluent_builders::DescribeSubscribersForNotification) for more information about the
    /// operation and its arguments.
    pub fn describe_subscribers_for_notification(
        &self,
    ) -> fluent_builders::DescribeSubscribersForNotification<C, M, R> {
        fluent_builders::DescribeSubscribersForNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteBudgetAction` operation.
    ///
    /// See [`ExecuteBudgetAction`](crate::client::fluent_builders::ExecuteBudgetAction) for more information about the
    /// operation and its arguments.
    pub fn execute_budget_action(&self) -> fluent_builders::ExecuteBudgetAction<C, M, R> {
        fluent_builders::ExecuteBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBudget` operation.
    ///
    /// See [`UpdateBudget`](crate::client::fluent_builders::UpdateBudget) for more information about the
    /// operation and its arguments.
    pub fn update_budget(&self) -> fluent_builders::UpdateBudget<C, M, R> {
        fluent_builders::UpdateBudget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBudgetAction` operation.
    ///
    /// See [`UpdateBudgetAction`](crate::client::fluent_builders::UpdateBudgetAction) for more information about the
    /// operation and its arguments.
    pub fn update_budget_action(&self) -> fluent_builders::UpdateBudgetAction<C, M, R> {
        fluent_builders::UpdateBudgetAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNotification` operation.
    ///
    /// See [`UpdateNotification`](crate::client::fluent_builders::UpdateNotification) for more information about the
    /// operation and its arguments.
    pub fn update_notification(&self) -> fluent_builders::UpdateNotification<C, M, R> {
        fluent_builders::UpdateNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSubscriber` operation.
    ///
    /// See [`UpdateSubscriber`](crate::client::fluent_builders::UpdateSubscriber) for more information about the
    /// operation and its arguments.
    pub fn update_subscriber(&self) -> fluent_builders::UpdateSubscriber<C, M, R> {
        fluent_builders::UpdateSubscriber::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateBudget`.
    ///
    /// <p>Creates a budget and, if included, notifications and subscribers. </p>
    /// <important>
    /// <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateBudget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_budget_input::Builder,
    }
    impl<C, M, R> CreateBudget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBudgetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBudgetInputOperationOutputAlias,
                crate::output::CreateBudgetOutput,
                crate::error::CreateBudgetError,
                crate::input::CreateBudgetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The budget object that you want to create.</p>
        pub fn budget(mut self, inp: crate::model::Budget) -> Self {
            self.inner = self.inner.budget(inp);
            self
        }
        /// <p>The budget object that you want to create.</p>
        pub fn set_budget(mut self, input: std::option::Option<crate::model::Budget>) -> Self {
            self.inner = self.inner.set_budget(input);
            self
        }
        /// Appends an item to `NotificationsWithSubscribers`.
        ///
        /// To override the contents of this collection use [`set_notifications_with_subscribers`](Self::set_notifications_with_subscribers).
        ///
        /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.</p>
        pub fn notifications_with_subscribers(
            mut self,
            inp: impl Into<crate::model::NotificationWithSubscribers>,
        ) -> Self {
            self.inner = self.inner.notifications_with_subscribers(inp);
            self
        }
        /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.</p>
        pub fn set_notifications_with_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationWithSubscribers>>,
        ) -> Self {
            self.inner = self.inner.set_notifications_with_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBudgetAction`.
    ///
    /// <p>
    /// Creates a budget action.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBudgetAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_budget_action_input::Builder,
    }
    impl<C, M, R> CreateBudgetAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBudgetActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBudgetActionInputOperationOutputAlias,
                crate::output::CreateBudgetActionOutput,
                crate::error::CreateBudgetActionError,
                crate::input::CreateBudgetActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn notification_type(mut self, inp: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(inp);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p>
        /// The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
        /// </p>
        pub fn action_type(mut self, inp: crate::model::ActionType) -> Self {
            self.inner = self.inner.action_type(inp);
            self
        }
        /// <p>
        /// The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
        /// </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn action_threshold(mut self, inp: crate::model::ActionThreshold) -> Self {
            self.inner = self.inner.action_threshold(inp);
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn set_action_threshold(
            mut self,
            input: std::option::Option<crate::model::ActionThreshold>,
        ) -> Self {
            self.inner = self.inner.set_action_threshold(input);
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn definition(mut self, inp: crate::model::Definition) -> Self {
            self.inner = self.inner.definition(inp);
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::Definition>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn execution_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(inp);
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn approval_model(mut self, inp: crate::model::ApprovalModel) -> Self {
            self.inner = self.inner.approval_model(inp);
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn set_approval_model(
            mut self,
            input: std::option::Option<crate::model::ApprovalModel>,
        ) -> Self {
            self.inner = self.inner.set_approval_model(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p> A list of subscribers.</p>
        pub fn subscribers(mut self, inp: impl Into<crate::model::Subscriber>) -> Self {
            self.inner = self.inner.subscribers(inp);
            self
        }
        /// <p> A list of subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNotification`.
    ///
    /// <p>Creates a notification. You must create the budget before you create the associated notification.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNotification<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_notification_input::Builder,
    }
    impl<C, M, R> CreateNotification<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNotificationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNotificationInputOperationOutputAlias,
                crate::output::CreateNotificationOutput,
                crate::error::CreateNotificationError,
                crate::input::CreateNotificationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want AWS to notify you about. Budget names must be unique within an account.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget that you want AWS to notify you about. Budget names must be unique within an account.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification that you want to create.</p>
        pub fn notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>The notification that you want to create.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
        pub fn subscribers(mut self, inp: impl Into<crate::model::Subscriber>) -> Self {
            self.inner = self.inner.subscribers(inp);
            self
        }
        /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubscriber`.
    ///
    /// <p>Creates a subscriber. You must create the associated budget and notification before you create the subscriber.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSubscriber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subscriber_input::Builder,
    }
    impl<C, M, R> CreateSubscriber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubscriber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubscriberOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubscriberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubscriberInputOperationOutputAlias,
                crate::output::CreateSubscriberOutput,
                crate::error::CreateSubscriberError,
                crate::input::CreateSubscriberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification that you want to create a subscriber for.</p>
        pub fn notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>The notification that you want to create a subscriber for.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The subscriber that you want to associate with a budget notification.</p>
        pub fn subscriber(mut self, inp: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscriber(inp);
            self
        }
        /// <p>The subscriber that you want to associate with a budget notification.</p>
        pub fn set_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_subscriber(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBudget`.
    ///
    /// <p>Deletes a budget. You can delete your budget at any time.</p>
    /// <important>
    /// <p>Deleting a budget also deletes the notifications and subscribers that are associated with that budget.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBudget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_budget_input::Builder,
    }
    impl<C, M, R> DeleteBudget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBudgetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBudgetInputOperationOutputAlias,
                crate::output::DeleteBudgetOutput,
                crate::error::DeleteBudgetError,
                crate::input::DeleteBudgetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want to delete.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget that you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBudgetAction`.
    ///
    /// <p>
    /// Deletes a budget action.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBudgetAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_budget_action_input::Builder,
    }
    impl<C, M, R> DeleteBudgetAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBudgetActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBudgetActionInputOperationOutputAlias,
                crate::output::DeleteBudgetActionOutput,
                crate::error::DeleteBudgetActionError,
                crate::input::DeleteBudgetActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(inp);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotification`.
    ///
    /// <p>Deletes a notification.</p>
    /// <important>
    /// <p>Deleting a notification also deletes the subscribers that are associated with the notification.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNotification<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_notification_input::Builder,
    }
    impl<C, M, R> DeleteNotification<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNotificationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNotificationInputOperationOutputAlias,
                crate::output::DeleteNotificationOutput,
                crate::error::DeleteNotificationError,
                crate::input::DeleteNotificationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose notification you want to delete.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget whose notification you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification that you want to delete.</p>
        pub fn notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>The notification that you want to delete.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubscriber`.
    ///
    /// <p>Deletes a subscriber.</p>
    /// <important>
    /// <p>Deleting the last subscriber to a notification also deletes the notification.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSubscriber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_subscriber_input::Builder,
    }
    impl<C, M, R> DeleteSubscriber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSubscriber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubscriberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubscriberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSubscriberInputOperationOutputAlias,
                crate::output::DeleteSubscriberOutput,
                crate::error::DeleteSubscriberError,
                crate::input::DeleteSubscriberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose subscriber you want to delete.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget whose subscriber you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification whose subscriber you want to delete.</p>
        pub fn notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>The notification whose subscriber you want to delete.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The subscriber that you want to delete.</p>
        pub fn subscriber(mut self, inp: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscriber(inp);
            self
        }
        /// <p>The subscriber that you want to delete.</p>
        pub fn set_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_subscriber(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudget`.
    ///
    /// <p>Describes a budget.</p>
    /// <important>
    /// <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBudget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_budget_input::Builder,
    }
    impl<C, M, R> DescribeBudget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBudgetInputOperationOutputAlias,
                crate::output::DescribeBudgetOutput,
                crate::error::DescribeBudgetError,
                crate::input::DescribeBudgetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget that you want a description of.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget that you want a description of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetAction`.
    ///
    /// <p>
    /// Describes a budget action detail.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBudgetAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_budget_action_input::Builder,
    }
    impl<C, M, R> DescribeBudgetAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBudgetActionInputOperationOutputAlias,
                crate::output::DescribeBudgetActionOutput,
                crate::error::DescribeBudgetActionError,
                crate::input::DescribeBudgetActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(inp);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetActionHistories`.
    ///
    /// <p>
    /// Describes a budget action history detail.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBudgetActionHistories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_budget_action_histories_input::Builder,
    }
    impl<C, M, R> DescribeBudgetActionHistories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBudgetActionHistories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionHistoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionHistoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBudgetActionHistoriesInputOperationOutputAlias,
                crate::output::DescribeBudgetActionHistoriesOutput,
                crate::error::DescribeBudgetActionHistoriesError,
                crate::input::DescribeBudgetActionHistoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(inp);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
        /// <p>The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
        pub fn time_period(mut self, inp: crate::model::TimePeriod) -> Self {
            self.inner = self.inner.time_period(inp);
            self
        }
        /// <p>The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetActionsForAccount`.
    ///
    /// <p>
    /// Describes all of the budget actions for an account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBudgetActionsForAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_budget_actions_for_account_input::Builder,
    }
    impl<C, M, R> DescribeBudgetActionsForAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBudgetActionsForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionsForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionsForAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBudgetActionsForAccountInputOperationOutputAlias,
                crate::output::DescribeBudgetActionsForAccountOutput,
                crate::error::DescribeBudgetActionsForAccountError,
                crate::input::DescribeBudgetActionsForAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetActionsForBudget`.
    ///
    /// <p>
    /// Describes all of the budget actions for a budget.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBudgetActionsForBudget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_budget_actions_for_budget_input::Builder,
    }
    impl<C, M, R> DescribeBudgetActionsForBudget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBudgetActionsForBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetActionsForBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetActionsForBudgetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBudgetActionsForBudgetInputOperationOutputAlias,
                crate::output::DescribeBudgetActionsForBudgetOutput,
                crate::error::DescribeBudgetActionsForBudgetError,
                crate::input::DescribeBudgetActionsForBudgetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgetPerformanceHistory`.
    ///
    /// <p>Describes the history for <code>DAILY</code>, <code>MONTHLY</code>, and <code>QUARTERLY</code> budgets. Budget history isn't available for <code>ANNUAL</code> budgets.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBudgetPerformanceHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_budget_performance_history_input::Builder,
    }
    impl<C, M, R> DescribeBudgetPerformanceHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBudgetPerformanceHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetPerformanceHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetPerformanceHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBudgetPerformanceHistoryInputOperationOutputAlias,
                crate::output::DescribeBudgetPerformanceHistoryOutput,
                crate::error::DescribeBudgetPerformanceHistoryError,
                crate::input::DescribeBudgetPerformanceHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
        pub fn time_period(mut self, inp: crate::model::TimePeriod) -> Self {
            self.inner = self.inner.time_period(inp);
            self
        }
        /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBudgets`.
    ///
    /// <p>Lists the budgets that are associated with an account.</p>
    /// <important>
    /// <p>The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBudgets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_budgets_input::Builder,
    }
    impl<C, M, R> DescribeBudgets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBudgets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBudgetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBudgetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBudgetsInputOperationOutputAlias,
                crate::output::DescribeBudgetsOutput,
                crate::error::DescribeBudgetsError,
                crate::input::DescribeBudgetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotificationsForBudget`.
    ///
    /// <p>Lists the notifications that are associated with a budget.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeNotificationsForBudget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_notifications_for_budget_input::Builder,
    }
    impl<C, M, R> DescribeNotificationsForBudget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNotificationsForBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotificationsForBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNotificationsForBudgetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNotificationsForBudgetInputOperationOutputAlias,
                crate::output::DescribeNotificationsForBudgetOutput,
                crate::error::DescribeNotificationsForBudgetError,
                crate::input::DescribeNotificationsForBudgetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose notifications you want descriptions of.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget whose notifications you want descriptions of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubscribersForNotification`.
    ///
    /// <p>Lists the subscribers that are associated with a notification.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSubscribersForNotification<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_subscribers_for_notification_input::Builder,
    }
    impl<C, M, R> DescribeSubscribersForNotification<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSubscribersForNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubscribersForNotificationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeSubscribersForNotificationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSubscribersForNotificationInputOperationOutputAlias,
                crate::output::DescribeSubscribersForNotificationOutput,
                crate::error::DescribeSubscribersForNotificationError,
                crate::input::DescribeSubscribersForNotificationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose subscribers you want descriptions of.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget whose subscribers you want descriptions of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification whose subscribers you want to list.</p>
        pub fn notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>The notification whose subscribers you want to list.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteBudgetAction`.
    ///
    /// <p>
    /// Executes a budget action.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteBudgetAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_budget_action_input::Builder,
    }
    impl<C, M, R> ExecuteBudgetAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteBudgetActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteBudgetActionInputOperationOutputAlias,
                crate::output::ExecuteBudgetActionOutput,
                crate::error::ExecuteBudgetActionError,
                crate::input::ExecuteBudgetActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(inp);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
        /// <p>
        /// The type of execution.
        /// </p>
        pub fn execution_type(mut self, inp: crate::model::ExecutionType) -> Self {
            self.inner = self.inner.execution_type(inp);
            self
        }
        /// <p>
        /// The type of execution.
        /// </p>
        pub fn set_execution_type(
            mut self,
            input: std::option::Option<crate::model::ExecutionType>,
        ) -> Self {
            self.inner = self.inner.set_execution_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBudget`.
    ///
    /// <p>Updates a budget. You can change every part of a budget except for the <code>budgetName</code> and the <code>calculatedSpend</code>. When you modify a budget, the <code>calculatedSpend</code> drops to zero until AWS has new usage data to use for forecasting.</p>
    /// <important>
    /// <p>Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples">Examples</a> section. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBudget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_budget_input::Builder,
    }
    impl<C, M, R> UpdateBudget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBudget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBudgetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBudgetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBudgetInputOperationOutputAlias,
                crate::output::UpdateBudgetOutput,
                crate::error::UpdateBudgetError,
                crate::input::UpdateBudgetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The budget that you want to update your budget to.</p>
        pub fn new_budget(mut self, inp: crate::model::Budget) -> Self {
            self.inner = self.inner.new_budget(inp);
            self
        }
        /// <p>The budget that you want to update your budget to.</p>
        pub fn set_new_budget(mut self, input: std::option::Option<crate::model::Budget>) -> Self {
            self.inner = self.inner.set_new_budget(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBudgetAction`.
    ///
    /// <p>
    /// Updates a budget action.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBudgetAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_budget_action_input::Builder,
    }
    impl<C, M, R> UpdateBudgetAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBudgetAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBudgetActionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBudgetActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBudgetActionInputOperationOutputAlias,
                crate::output::UpdateBudgetActionOutput,
                crate::error::UpdateBudgetActionError,
                crate::input::UpdateBudgetActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_id(inp);
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_id(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn notification_type(mut self, inp: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(inp);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn action_threshold(mut self, inp: crate::model::ActionThreshold) -> Self {
            self.inner = self.inner.action_threshold(inp);
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn set_action_threshold(
            mut self,
            input: std::option::Option<crate::model::ActionThreshold>,
        ) -> Self {
            self.inner = self.inner.set_action_threshold(input);
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn definition(mut self, inp: crate::model::Definition) -> Self {
            self.inner = self.inner.definition(inp);
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::Definition>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn execution_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(inp);
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn approval_model(mut self, inp: crate::model::ApprovalModel) -> Self {
            self.inner = self.inner.approval_model(inp);
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn set_approval_model(
            mut self,
            input: std::option::Option<crate::model::ApprovalModel>,
        ) -> Self {
            self.inner = self.inner.set_approval_model(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p> A list of subscribers.</p>
        pub fn subscribers(mut self, inp: impl Into<crate::model::Subscriber>) -> Self {
            self.inner = self.inner.subscribers(inp);
            self
        }
        /// <p> A list of subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNotification`.
    ///
    /// <p>Updates a notification.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNotification<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_notification_input::Builder,
    }
    impl<C, M, R> UpdateNotification<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNotification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNotificationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNotificationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNotificationInputOperationOutputAlias,
                crate::output::UpdateNotificationOutput,
                crate::error::UpdateNotificationError,
                crate::input::UpdateNotificationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose notification you want to update.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget whose notification you want to update.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The previous notification that is associated with a budget.</p>
        pub fn old_notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.old_notification(inp);
            self
        }
        /// <p>The previous notification that is associated with a budget.</p>
        pub fn set_old_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_old_notification(input);
            self
        }
        /// <p>The updated notification to be associated with a budget.</p>
        pub fn new_notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.new_notification(inp);
            self
        }
        /// <p>The updated notification to be associated with a budget.</p>
        pub fn set_new_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_new_notification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubscriber`.
    ///
    /// <p>Updates a subscriber.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSubscriber<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_subscriber_input::Builder,
    }
    impl<C, M, R> UpdateSubscriber<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSubscriber`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubscriberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubscriberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSubscriberInputOperationOutputAlias,
                crate::output::UpdateSubscriberOutput,
                crate::error::UpdateSubscriberError,
                crate::input::UpdateSubscriberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the budget whose subscriber you want to update.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget whose subscriber you want to update.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The notification whose subscriber you want to update.</p>
        pub fn notification(mut self, inp: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(inp);
            self
        }
        /// <p>The notification whose subscriber you want to update.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The previous subscriber that is associated with a budget notification.</p>
        pub fn old_subscriber(mut self, inp: crate::model::Subscriber) -> Self {
            self.inner = self.inner.old_subscriber(inp);
            self
        }
        /// <p>The previous subscriber that is associated with a budget notification.</p>
        pub fn set_old_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_old_subscriber(input);
            self
        }
        /// <p>The updated subscriber that is associated with a budget notification.</p>
        pub fn new_subscriber(mut self, inp: crate::model::Subscriber) -> Self {
            self.inner = self.inner.new_subscriber(inp);
            self
        }
        /// <p>The updated subscriber that is associated with a budget notification.</p>
        pub fn set_new_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.inner = self.inner.set_new_subscriber(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
