// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_budget_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBudgetOutput, crate::error::CreateBudgetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBudgetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBudgetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateBudgetError {
            meta: generic,
            kind: crate::error::CreateBudgetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CreationLimitExceededException" => crate::error::CreateBudgetError {
            meta: generic,
            kind: crate::error::CreateBudgetErrorKind::CreationLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::creation_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_creation_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateRecordException" => crate::error::CreateBudgetError {
            meta: generic,
            kind: crate::error::CreateBudgetErrorKind::DuplicateRecordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_record_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_record_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::CreateBudgetError {
            meta: generic,
            kind: crate::error::CreateBudgetErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateBudgetError {
            meta: generic,
            kind: crate::error::CreateBudgetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBudgetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_budget_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBudgetOutput, crate::error::CreateBudgetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_budget_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_budget_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBudgetActionOutput,
    crate::error::CreateBudgetActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBudgetActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBudgetActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateBudgetActionError {
            meta: generic,
            kind: crate::error::CreateBudgetActionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CreationLimitExceededException" => crate::error::CreateBudgetActionError {
            meta: generic,
            kind: crate::error::CreateBudgetActionErrorKind::CreationLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::creation_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_creation_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateRecordException" => crate::error::CreateBudgetActionError {
            meta: generic,
            kind: crate::error::CreateBudgetActionErrorKind::DuplicateRecordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_record_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_record_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::CreateBudgetActionError {
            meta: generic,
            kind: crate::error::CreateBudgetActionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateBudgetActionError {
            meta: generic,
            kind: crate::error::CreateBudgetActionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateBudgetActionError {
            meta: generic,
            kind: crate::error::CreateBudgetActionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBudgetActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_budget_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBudgetActionOutput,
    crate::error::CreateBudgetActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_budget_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_budget_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBudgetActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_notification_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNotificationOutput,
    crate::error::CreateNotificationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateNotificationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateNotificationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateNotificationError {
            meta: generic,
            kind: crate::error::CreateNotificationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CreationLimitExceededException" => crate::error::CreateNotificationError {
            meta: generic,
            kind: crate::error::CreateNotificationErrorKind::CreationLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::creation_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_creation_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateRecordException" => crate::error::CreateNotificationError {
            meta: generic,
            kind: crate::error::CreateNotificationErrorKind::DuplicateRecordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_record_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_record_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::CreateNotificationError {
            meta: generic,
            kind: crate::error::CreateNotificationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateNotificationError {
            meta: generic,
            kind: crate::error::CreateNotificationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateNotificationError {
            meta: generic,
            kind: crate::error::CreateNotificationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateNotificationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_notification_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNotificationOutput,
    crate::error::CreateNotificationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_notification_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_subscriber_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSubscriberOutput, crate::error::CreateSubscriberError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSubscriberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSubscriberError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateSubscriberError {
            meta: generic,
            kind: crate::error::CreateSubscriberErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CreationLimitExceededException" => crate::error::CreateSubscriberError {
            meta: generic,
            kind: crate::error::CreateSubscriberErrorKind::CreationLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::creation_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_creation_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateRecordException" => crate::error::CreateSubscriberError {
            meta: generic,
            kind: crate::error::CreateSubscriberErrorKind::DuplicateRecordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_record_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_record_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::CreateSubscriberError {
            meta: generic,
            kind: crate::error::CreateSubscriberErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateSubscriberError {
            meta: generic,
            kind: crate::error::CreateSubscriberErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateSubscriberError {
            meta: generic,
            kind: crate::error::CreateSubscriberErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSubscriberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_subscriber_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSubscriberOutput, crate::error::CreateSubscriberError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_subscriber_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_budget_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBudgetOutput, crate::error::DeleteBudgetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBudgetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBudgetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteBudgetError {
            meta: generic,
            kind: crate::error::DeleteBudgetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DeleteBudgetError {
            meta: generic,
            kind: crate::error::DeleteBudgetErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteBudgetError {
            meta: generic,
            kind: crate::error::DeleteBudgetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteBudgetError {
            meta: generic,
            kind: crate::error::DeleteBudgetErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBudgetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_budget_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBudgetOutput, crate::error::DeleteBudgetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_budget_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_budget_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBudgetActionOutput,
    crate::error::DeleteBudgetActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBudgetActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBudgetActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteBudgetActionError {
            meta: generic,
            kind: crate::error::DeleteBudgetActionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DeleteBudgetActionError {
            meta: generic,
            kind: crate::error::DeleteBudgetActionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteBudgetActionError {
            meta: generic,
            kind: crate::error::DeleteBudgetActionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteBudgetActionError {
            meta: generic,
            kind: crate::error::DeleteBudgetActionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLockedException" => crate::error::DeleteBudgetActionError {
            meta: generic,
            kind: crate::error::DeleteBudgetActionErrorKind::ResourceLockedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_locked_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_locked_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBudgetActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_budget_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBudgetActionOutput,
    crate::error::DeleteBudgetActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_budget_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_budget_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBudgetActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notification_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotificationOutput,
    crate::error::DeleteNotificationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteNotificationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteNotificationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteNotificationError {
            meta: generic,
            kind: crate::error::DeleteNotificationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DeleteNotificationError {
            meta: generic,
            kind: crate::error::DeleteNotificationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteNotificationError {
            meta: generic,
            kind: crate::error::DeleteNotificationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteNotificationError {
            meta: generic,
            kind: crate::error::DeleteNotificationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteNotificationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notification_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotificationOutput,
    crate::error::DeleteNotificationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_notification_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_subscriber_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSubscriberOutput, crate::error::DeleteSubscriberError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSubscriberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSubscriberError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteSubscriberError {
            meta: generic,
            kind: crate::error::DeleteSubscriberErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DeleteSubscriberError {
            meta: generic,
            kind: crate::error::DeleteSubscriberErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteSubscriberError {
            meta: generic,
            kind: crate::error::DeleteSubscriberErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteSubscriberError {
            meta: generic,
            kind: crate::error::DeleteSubscriberErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSubscriberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_subscriber_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSubscriberOutput, crate::error::DeleteSubscriberError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_subscriber_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBudgetOutput, crate::error::DescribeBudgetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBudgetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBudgetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DescribeBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DescribeBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBudgetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBudgetOutput, crate::error::DescribeBudgetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_budget_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_budget(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBudgetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionOutput,
    crate::error::DescribeBudgetActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBudgetActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBudgetActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeBudgetActionError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DescribeBudgetActionError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeBudgetActionError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DescribeBudgetActionError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBudgetActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionOutput,
    crate::error::DescribeBudgetActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_budget_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_budget_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBudgetActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_action_histories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionHistoriesOutput,
    crate::error::DescribeBudgetActionHistoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBudgetActionHistoriesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeBudgetActionHistoriesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeBudgetActionHistoriesError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionHistoriesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionHistoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DescribeBudgetActionHistoriesError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionHistoriesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionHistoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeBudgetActionHistoriesError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionHistoriesErrorKind::InvalidNextTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_next_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionHistoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterException" => crate::error::DescribeBudgetActionHistoriesError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionHistoriesErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionHistoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::DescribeBudgetActionHistoriesError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionHistoriesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionHistoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBudgetActionHistoriesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_action_histories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionHistoriesOutput,
    crate::error::DescribeBudgetActionHistoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_budget_action_histories_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_budget_action_histories(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeBudgetActionHistoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_actions_for_account_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionsForAccountOutput,
    crate::error::DescribeBudgetActionsForAccountError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBudgetActionsForAccountError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBudgetActionsForAccountError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeBudgetActionsForAccountError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForAccountErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DescribeBudgetActionsForAccountError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForAccountErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForAccountError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeBudgetActionsForAccountError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForAccountErrorKind::InvalidNextTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_next_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterException" => crate::error::DescribeBudgetActionsForAccountError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForAccountErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForAccountError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeBudgetActionsForAccountError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_actions_for_account_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionsForAccountOutput,
    crate::error::DescribeBudgetActionsForAccountError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_budget_actions_for_account_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_budget_actions_for_account(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeBudgetActionsForAccountError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_actions_for_budget_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionsForBudgetOutput,
    crate::error::DescribeBudgetActionsForBudgetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBudgetActionsForBudgetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBudgetActionsForBudgetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeBudgetActionsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForBudgetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DescribeBudgetActionsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForBudgetErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeBudgetActionsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForBudgetErrorKind::InvalidNextTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_next_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForBudgetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterException" => crate::error::DescribeBudgetActionsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForBudgetErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForBudgetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::DescribeBudgetActionsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeBudgetActionsForBudgetErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetActionsForBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBudgetActionsForBudgetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_actions_for_budget_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetActionsForBudgetOutput,
    crate::error::DescribeBudgetActionsForBudgetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_budget_actions_for_budget_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_budget_actions_for_budget(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeBudgetActionsForBudgetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_performance_history_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetPerformanceHistoryOutput,
    crate::error::DescribeBudgetPerformanceHistoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeBudgetPerformanceHistoryError {
            meta: generic,
            kind: crate::error::DescribeBudgetPerformanceHistoryErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredNextTokenException" => crate::error::DescribeBudgetPerformanceHistoryError {
            meta: generic,
            kind:
                crate::error::DescribeBudgetPerformanceHistoryErrorKind::ExpiredNextTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::expired_next_token_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_expired_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalErrorException" => crate::error::DescribeBudgetPerformanceHistoryError {
            meta: generic,
            kind: crate::error::DescribeBudgetPerformanceHistoryErrorKind::InternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidNextTokenException" => crate::error::DescribeBudgetPerformanceHistoryError {
            meta: generic,
            kind:
                crate::error::DescribeBudgetPerformanceHistoryErrorKind::InvalidNextTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_next_token_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterException" => crate::error::DescribeBudgetPerformanceHistoryError {
            meta: generic,
            kind:
                crate::error::DescribeBudgetPerformanceHistoryErrorKind::InvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFoundException" => crate::error::DescribeBudgetPerformanceHistoryError {
            meta: generic,
            kind: crate::error::DescribeBudgetPerformanceHistoryErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBudgetPerformanceHistoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budget_performance_history_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBudgetPerformanceHistoryOutput,
    crate::error::DescribeBudgetPerformanceHistoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_budget_performance_history_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_budget_performance_history(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeBudgetPerformanceHistoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budgets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBudgetsOutput, crate::error::DescribeBudgetsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBudgetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBudgetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeBudgetsError {
            meta: generic,
            kind: crate::error::DescribeBudgetsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredNextTokenException" => crate::error::DescribeBudgetsError {
            meta: generic,
            kind: crate::error::DescribeBudgetsErrorKind::ExpiredNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::DescribeBudgetsError {
            meta: generic,
            kind: crate::error::DescribeBudgetsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeBudgetsError {
            meta: generic,
            kind: crate::error::DescribeBudgetsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeBudgetsError {
            meta: generic,
            kind: crate::error::DescribeBudgetsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DescribeBudgetsError {
            meta: generic,
            kind: crate::error::DescribeBudgetsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBudgetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBudgetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_budgets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBudgetsOutput, crate::error::DescribeBudgetsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_budgets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_budgets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBudgetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notifications_for_budget_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotificationsForBudgetOutput,
    crate::error::DescribeNotificationsForBudgetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeNotificationsForBudgetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeNotificationsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeNotificationsForBudgetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredNextTokenException" => crate::error::DescribeNotificationsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeNotificationsForBudgetErrorKind::ExpiredNextTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::expired_next_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_expired_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalErrorException" => crate::error::DescribeNotificationsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeNotificationsForBudgetErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::DescribeNotificationsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeNotificationsForBudgetErrorKind::InvalidNextTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_next_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameterException" => crate::error::DescribeNotificationsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeNotificationsForBudgetErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::DescribeNotificationsForBudgetError {
            meta: generic,
            kind: crate::error::DescribeNotificationsForBudgetErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeNotificationsForBudgetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notifications_for_budget_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotificationsForBudgetOutput,
    crate::error::DescribeNotificationsForBudgetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_notifications_for_budget_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_notifications_for_budget(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeNotificationsForBudgetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_subscribers_for_notification_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSubscribersForNotificationOutput,
    crate::error::DescribeSubscribersForNotificationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeSubscribersForNotificationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeSubscribersForNotificationError {
            meta: generic,
            kind: crate::error::DescribeSubscribersForNotificationErrorKind::AccessDeniedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::access_denied_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ExpiredNextTokenException" => crate::error::DescribeSubscribersForNotificationError {
            meta: generic,
            kind:
                crate::error::DescribeSubscribersForNotificationErrorKind::ExpiredNextTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::expired_next_token_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_expired_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalErrorException" => crate::error::DescribeSubscribersForNotificationError {
            meta: generic,
            kind: crate::error::DescribeSubscribersForNotificationErrorKind::InternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidNextTokenException" => crate::error::DescribeSubscribersForNotificationError {
            meta: generic,
            kind:
                crate::error::DescribeSubscribersForNotificationErrorKind::InvalidNextTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_next_token_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterException" => crate::error::DescribeSubscribersForNotificationError {
            meta: generic,
            kind:
                crate::error::DescribeSubscribersForNotificationErrorKind::InvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFoundException" => crate::error::DescribeSubscribersForNotificationError {
            meta: generic,
            kind: crate::error::DescribeSubscribersForNotificationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSubscribersForNotificationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_subscribers_for_notification_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSubscribersForNotificationOutput,
    crate::error::DescribeSubscribersForNotificationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_subscribers_for_notification_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_subscribers_for_notification(response.body().as_ref(), output).map_err(crate::error::DescribeSubscribersForNotificationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_budget_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteBudgetActionOutput,
    crate::error::ExecuteBudgetActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecuteBudgetActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExecuteBudgetActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ExecuteBudgetActionError {
            meta: generic,
            kind: crate::error::ExecuteBudgetActionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::ExecuteBudgetActionError {
            meta: generic,
            kind: crate::error::ExecuteBudgetActionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ExecuteBudgetActionError {
            meta: generic,
            kind: crate::error::ExecuteBudgetActionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ExecuteBudgetActionError {
            meta: generic,
            kind: crate::error::ExecuteBudgetActionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLockedException" => crate::error::ExecuteBudgetActionError {
            meta: generic,
            kind: crate::error::ExecuteBudgetActionErrorKind::ResourceLockedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_locked_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_locked_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExecuteBudgetActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_budget_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteBudgetActionOutput,
    crate::error::ExecuteBudgetActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::execute_budget_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_execute_budget_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExecuteBudgetActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_budget_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateBudgetOutput, crate::error::UpdateBudgetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBudgetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateBudgetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateBudgetError {
            meta: generic,
            kind: crate::error::UpdateBudgetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::UpdateBudgetError {
            meta: generic,
            kind: crate::error::UpdateBudgetErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateBudgetError {
            meta: generic,
            kind: crate::error::UpdateBudgetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateBudgetError {
            meta: generic,
            kind: crate::error::UpdateBudgetErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateBudgetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_budget_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateBudgetOutput, crate::error::UpdateBudgetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_budget_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_budget_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBudgetActionOutput,
    crate::error::UpdateBudgetActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBudgetActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateBudgetActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateBudgetActionError {
            meta: generic,
            kind: crate::error::UpdateBudgetActionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::UpdateBudgetActionError {
            meta: generic,
            kind: crate::error::UpdateBudgetActionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateBudgetActionError {
            meta: generic,
            kind: crate::error::UpdateBudgetActionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateBudgetActionError {
            meta: generic,
            kind: crate::error::UpdateBudgetActionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLockedException" => crate::error::UpdateBudgetActionError {
            meta: generic,
            kind: crate::error::UpdateBudgetActionErrorKind::ResourceLockedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_locked_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_locked_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBudgetActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateBudgetActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_budget_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBudgetActionOutput,
    crate::error::UpdateBudgetActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_budget_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_budget_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateBudgetActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notification_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotificationOutput,
    crate::error::UpdateNotificationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNotificationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateNotificationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateNotificationError {
            meta: generic,
            kind: crate::error::UpdateNotificationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateRecordException" => crate::error::UpdateNotificationError {
            meta: generic,
            kind: crate::error::UpdateNotificationErrorKind::DuplicateRecordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_record_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_record_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::UpdateNotificationError {
            meta: generic,
            kind: crate::error::UpdateNotificationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateNotificationError {
            meta: generic,
            kind: crate::error::UpdateNotificationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateNotificationError {
            meta: generic,
            kind: crate::error::UpdateNotificationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNotificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateNotificationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notification_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotificationOutput,
    crate::error::UpdateNotificationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_notification_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_subscriber_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateSubscriberOutput, crate::error::UpdateSubscriberError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSubscriberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateSubscriberError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateSubscriberError {
            meta: generic,
            kind: crate::error::UpdateSubscriberErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateRecordException" => crate::error::UpdateSubscriberError {
            meta: generic,
            kind: crate::error::UpdateSubscriberErrorKind::DuplicateRecordException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_record_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_record_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalErrorException" => crate::error::UpdateSubscriberError {
            meta: generic,
            kind: crate::error::UpdateSubscriberErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateSubscriberError {
            meta: generic,
            kind: crate::error::UpdateSubscriberErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateSubscriberError {
            meta: generic,
            kind: crate::error::UpdateSubscriberErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSubscriberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSubscriberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_subscriber_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateSubscriberOutput, crate::error::UpdateSubscriberError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_subscriber_output::Builder::default();
        let _ = response;
        output.build()
    })
}
