// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateBudgetInput`](crate::input::CreateBudgetInput)
pub mod create_budget_input {
    /// A builder for [`CreateBudgetInput`](crate::input::CreateBudgetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget: std::option::Option<crate::model::Budget>,
        pub(crate) notifications_with_subscribers:
            std::option::Option<std::vec::Vec<crate::model::NotificationWithSubscribers>>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The budget object that you want to create.</p>
        pub fn budget(mut self, input: crate::model::Budget) -> Self {
            self.budget = Some(input);
            self
        }
        /// <p>The budget object that you want to create.</p>
        pub fn set_budget(mut self, input: std::option::Option<crate::model::Budget>) -> Self {
            self.budget = input;
            self
        }
        /// Appends an item to `notifications_with_subscribers`.
        ///
        /// To override the contents of this collection use [`set_notifications_with_subscribers`](Self::set_notifications_with_subscribers).
        ///
        /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.</p>
        pub fn notifications_with_subscribers(
            mut self,
            input: impl Into<crate::model::NotificationWithSubscribers>,
        ) -> Self {
            let mut v = self.notifications_with_subscribers.unwrap_or_default();
            v.push(input.into());
            self.notifications_with_subscribers = Some(v);
            self
        }
        /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.</p>
        pub fn set_notifications_with_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationWithSubscribers>>,
        ) -> Self {
            self.notifications_with_subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBudgetInput`](crate::input::CreateBudgetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBudgetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBudgetInput {
                account_id: self.account_id,
                budget: self.budget,
                notifications_with_subscribers: self.notifications_with_subscribers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBudgetInputOperationOutputAlias = crate::operation::CreateBudget;
#[doc(hidden)]
pub type CreateBudgetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBudgetInput {
    /// Consumes the builder and constructs an Operation<[`CreateBudget`](crate::operation::CreateBudget)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBudget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBudgetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBudgetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBudgetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.CreateBudget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_budget(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBudget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBudget",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBudgetInput`](crate::input::CreateBudgetInput)
    pub fn builder() -> crate::input::create_budget_input::Builder {
        crate::input::create_budget_input::Builder::default()
    }
}

/// See [`CreateBudgetActionInput`](crate::input::CreateBudgetActionInput)
pub mod create_budget_action_input {
    /// A builder for [`CreateBudgetActionInput`](crate::input::CreateBudgetActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification_type: std::option::Option<crate::model::NotificationType>,
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) action_threshold: std::option::Option<crate::model::ActionThreshold>,
        pub(crate) definition: std::option::Option<crate::model::Definition>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) approval_model: std::option::Option<crate::model::ApprovalModel>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.notification_type = Some(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// <p>
        /// The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
        /// </p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>
        /// The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
        /// </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn action_threshold(mut self, input: crate::model::ActionThreshold) -> Self {
            self.action_threshold = Some(input);
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn set_action_threshold(
            mut self,
            input: std::option::Option<crate::model::ActionThreshold>,
        ) -> Self {
            self.action_threshold = input;
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn definition(mut self, input: crate::model::Definition) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::Definition>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn approval_model(mut self, input: crate::model::ApprovalModel) -> Self {
            self.approval_model = Some(input);
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn set_approval_model(
            mut self,
            input: std::option::Option<crate::model::ApprovalModel>,
        ) -> Self {
            self.approval_model = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p> A list of subscribers.</p>
        pub fn subscribers(mut self, input: impl Into<crate::model::Subscriber>) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input.into());
            self.subscribers = Some(v);
            self
        }
        /// <p> A list of subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBudgetActionInput`](crate::input::CreateBudgetActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBudgetActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBudgetActionInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                notification_type: self.notification_type,
                action_type: self.action_type,
                action_threshold: self.action_threshold,
                definition: self.definition,
                execution_role_arn: self.execution_role_arn,
                approval_model: self.approval_model,
                subscribers: self.subscribers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBudgetActionInputOperationOutputAlias = crate::operation::CreateBudgetAction;
#[doc(hidden)]
pub type CreateBudgetActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBudgetActionInput {
    /// Consumes the builder and constructs an Operation<[`CreateBudgetAction`](crate::operation::CreateBudgetAction)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBudgetAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBudgetActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBudgetActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBudgetActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.CreateBudgetAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_budget_action(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBudgetAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBudgetAction",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBudgetActionInput`](crate::input::CreateBudgetActionInput)
    pub fn builder() -> crate::input::create_budget_action_input::Builder {
        crate::input::create_budget_action_input::Builder::default()
    }
}

/// See [`CreateNotificationInput`](crate::input::CreateNotificationInput)
pub mod create_notification_input {
    /// A builder for [`CreateNotificationInput`](crate::input::CreateNotificationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget that you want AWS to notify you about. Budget names must be unique within an account.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget that you want AWS to notify you about. Budget names must be unique within an account.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The notification that you want to create.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The notification that you want to create.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
        pub fn subscribers(mut self, input: impl Into<crate::model::Subscriber>) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input.into());
            self.subscribers = Some(v);
            self
        }
        /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotificationInput`](crate::input::CreateNotificationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNotificationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNotificationInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                notification: self.notification,
                subscribers: self.subscribers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNotificationInputOperationOutputAlias = crate::operation::CreateNotification;
#[doc(hidden)]
pub type CreateNotificationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNotificationInput {
    /// Consumes the builder and constructs an Operation<[`CreateNotification`](crate::operation::CreateNotification)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNotification,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNotificationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNotificationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNotificationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.CreateNotification",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_notification(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNotification::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNotification",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNotificationInput`](crate::input::CreateNotificationInput)
    pub fn builder() -> crate::input::create_notification_input::Builder {
        crate::input::create_notification_input::Builder::default()
    }
}

/// See [`CreateSubscriberInput`](crate::input::CreateSubscriberInput)
pub mod create_subscriber_input {
    /// A builder for [`CreateSubscriberInput`](crate::input::CreateSubscriberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) subscriber: std::option::Option<crate::model::Subscriber>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The notification that you want to create a subscriber for.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The notification that you want to create a subscriber for.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The subscriber that you want to associate with a budget notification.</p>
        pub fn subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.subscriber = Some(input);
            self
        }
        /// <p>The subscriber that you want to associate with a budget notification.</p>
        pub fn set_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.subscriber = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSubscriberInput`](crate::input::CreateSubscriberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSubscriberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSubscriberInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                notification: self.notification,
                subscriber: self.subscriber,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSubscriberInputOperationOutputAlias = crate::operation::CreateSubscriber;
#[doc(hidden)]
pub type CreateSubscriberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSubscriberInput {
    /// Consumes the builder and constructs an Operation<[`CreateSubscriber`](crate::operation::CreateSubscriber)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSubscriber,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSubscriberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSubscriberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSubscriberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.CreateSubscriber",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_subscriber(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSubscriber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSubscriber",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSubscriberInput`](crate::input::CreateSubscriberInput)
    pub fn builder() -> crate::input::create_subscriber_input::Builder {
        crate::input::create_subscriber_input::Builder::default()
    }
}

/// See [`DeleteBudgetInput`](crate::input::DeleteBudgetInput)
pub mod delete_budget_input {
    /// A builder for [`DeleteBudgetInput`](crate::input::DeleteBudgetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget that you want to delete.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget that you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBudgetInput`](crate::input::DeleteBudgetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBudgetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBudgetInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBudgetInputOperationOutputAlias = crate::operation::DeleteBudget;
#[doc(hidden)]
pub type DeleteBudgetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBudgetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBudget`](crate::operation::DeleteBudget)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBudget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBudgetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBudgetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBudgetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DeleteBudget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_budget(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBudget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBudget",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBudgetInput`](crate::input::DeleteBudgetInput)
    pub fn builder() -> crate::input::delete_budget_input::Builder {
        crate::input::delete_budget_input::Builder::default()
    }
}

/// See [`DeleteBudgetActionInput`](crate::input::DeleteBudgetActionInput)
pub mod delete_budget_action_input {
    /// A builder for [`DeleteBudgetActionInput`](crate::input::DeleteBudgetActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBudgetActionInput`](crate::input::DeleteBudgetActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBudgetActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBudgetActionInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action_id: self.action_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBudgetActionInputOperationOutputAlias = crate::operation::DeleteBudgetAction;
#[doc(hidden)]
pub type DeleteBudgetActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBudgetActionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBudgetAction`](crate::operation::DeleteBudgetAction)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBudgetAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBudgetActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBudgetActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBudgetActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DeleteBudgetAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_budget_action(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBudgetAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBudgetAction",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBudgetActionInput`](crate::input::DeleteBudgetActionInput)
    pub fn builder() -> crate::input::delete_budget_action_input::Builder {
        crate::input::delete_budget_action_input::Builder::default()
    }
}

/// See [`DeleteNotificationInput`](crate::input::DeleteNotificationInput)
pub mod delete_notification_input {
    /// A builder for [`DeleteNotificationInput`](crate::input::DeleteNotificationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget whose notification you want to delete.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget whose notification you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The notification that you want to delete.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The notification that you want to delete.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotificationInput`](crate::input::DeleteNotificationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNotificationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNotificationInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                notification: self.notification,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNotificationInputOperationOutputAlias = crate::operation::DeleteNotification;
#[doc(hidden)]
pub type DeleteNotificationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteNotificationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNotification`](crate::operation::DeleteNotification)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNotification,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNotificationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNotificationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNotificationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DeleteNotification",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_notification(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNotification::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNotification",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNotificationInput`](crate::input::DeleteNotificationInput)
    pub fn builder() -> crate::input::delete_notification_input::Builder {
        crate::input::delete_notification_input::Builder::default()
    }
}

/// See [`DeleteSubscriberInput`](crate::input::DeleteSubscriberInput)
pub mod delete_subscriber_input {
    /// A builder for [`DeleteSubscriberInput`](crate::input::DeleteSubscriberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) subscriber: std::option::Option<crate::model::Subscriber>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget whose subscriber you want to delete.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget whose subscriber you want to delete.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The notification whose subscriber you want to delete.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The notification whose subscriber you want to delete.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The subscriber that you want to delete.</p>
        pub fn subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.subscriber = Some(input);
            self
        }
        /// <p>The subscriber that you want to delete.</p>
        pub fn set_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.subscriber = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSubscriberInput`](crate::input::DeleteSubscriberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSubscriberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSubscriberInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                notification: self.notification,
                subscriber: self.subscriber,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSubscriberInputOperationOutputAlias = crate::operation::DeleteSubscriber;
#[doc(hidden)]
pub type DeleteSubscriberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSubscriberInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSubscriber`](crate::operation::DeleteSubscriber)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSubscriber,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSubscriberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSubscriberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSubscriberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DeleteSubscriber",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_subscriber(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSubscriber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSubscriber",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSubscriberInput`](crate::input::DeleteSubscriberInput)
    pub fn builder() -> crate::input::delete_subscriber_input::Builder {
        crate::input::delete_subscriber_input::Builder::default()
    }
}

/// See [`DescribeBudgetInput`](crate::input::DescribeBudgetInput)
pub mod describe_budget_input {
    /// A builder for [`DescribeBudgetInput`](crate::input::DescribeBudgetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget that you want a description of.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget that you want a description of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetInput`](crate::input::DescribeBudgetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBudgetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBudgetInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBudgetInputOperationOutputAlias = crate::operation::DescribeBudget;
#[doc(hidden)]
pub type DescribeBudgetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBudgetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBudget`](crate::operation::DescribeBudget)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBudget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBudgetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBudgetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBudgetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeBudget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_budget(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBudget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBudget",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBudgetInput`](crate::input::DescribeBudgetInput)
    pub fn builder() -> crate::input::describe_budget_input::Builder {
        crate::input::describe_budget_input::Builder::default()
    }
}

/// See [`DescribeBudgetActionInput`](crate::input::DescribeBudgetActionInput)
pub mod describe_budget_action_input {
    /// A builder for [`DescribeBudgetActionInput`](crate::input::DescribeBudgetActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionInput`](crate::input::DescribeBudgetActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBudgetActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBudgetActionInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action_id: self.action_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBudgetActionInputOperationOutputAlias = crate::operation::DescribeBudgetAction;
#[doc(hidden)]
pub type DescribeBudgetActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBudgetActionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBudgetAction`](crate::operation::DescribeBudgetAction)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBudgetAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBudgetActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBudgetActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBudgetActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeBudgetAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_budget_action(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBudgetAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBudgetAction",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionInput`](crate::input::DescribeBudgetActionInput)
    pub fn builder() -> crate::input::describe_budget_action_input::Builder {
        crate::input::describe_budget_action_input::Builder::default()
    }
}

/// See [`DescribeBudgetActionHistoriesInput`](crate::input::DescribeBudgetActionHistoriesInput)
pub mod describe_budget_action_histories_input {
    /// A builder for [`DescribeBudgetActionHistoriesInput`](crate::input::DescribeBudgetActionHistoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) time_period: std::option::Option<crate::model::TimePeriod>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
        pub fn time_period(mut self, input: crate::model::TimePeriod) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionHistoriesInput`](crate::input::DescribeBudgetActionHistoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBudgetActionHistoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBudgetActionHistoriesInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action_id: self.action_id,
                time_period: self.time_period,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBudgetActionHistoriesInputOperationOutputAlias =
    crate::operation::DescribeBudgetActionHistories;
#[doc(hidden)]
pub type DescribeBudgetActionHistoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBudgetActionHistoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBudgetActionHistories`](crate::operation::DescribeBudgetActionHistories)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBudgetActionHistories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBudgetActionHistoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBudgetActionHistoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBudgetActionHistoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeBudgetActionHistories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_budget_action_histories(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBudgetActionHistories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBudgetActionHistories",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionHistoriesInput`](crate::input::DescribeBudgetActionHistoriesInput)
    pub fn builder() -> crate::input::describe_budget_action_histories_input::Builder {
        crate::input::describe_budget_action_histories_input::Builder::default()
    }
}

/// See [`DescribeBudgetActionsForAccountInput`](crate::input::DescribeBudgetActionsForAccountInput)
pub mod describe_budget_actions_for_account_input {
    /// A builder for [`DescribeBudgetActionsForAccountInput`](crate::input::DescribeBudgetActionsForAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionsForAccountInput`](crate::input::DescribeBudgetActionsForAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBudgetActionsForAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBudgetActionsForAccountInput {
                account_id: self.account_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBudgetActionsForAccountInputOperationOutputAlias =
    crate::operation::DescribeBudgetActionsForAccount;
#[doc(hidden)]
pub type DescribeBudgetActionsForAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBudgetActionsForAccountInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBudgetActionsForAccount`](crate::operation::DescribeBudgetActionsForAccount)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBudgetActionsForAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBudgetActionsForAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBudgetActionsForAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBudgetActionsForAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeBudgetActionsForAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_budget_actions_for_account(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBudgetActionsForAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBudgetActionsForAccount",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionsForAccountInput`](crate::input::DescribeBudgetActionsForAccountInput)
    pub fn builder() -> crate::input::describe_budget_actions_for_account_input::Builder {
        crate::input::describe_budget_actions_for_account_input::Builder::default()
    }
}

/// See [`DescribeBudgetActionsForBudgetInput`](crate::input::DescribeBudgetActionsForBudgetInput)
pub mod describe_budget_actions_for_budget_input {
    /// A builder for [`DescribeBudgetActionsForBudgetInput`](crate::input::DescribeBudgetActionsForBudgetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetActionsForBudgetInput`](crate::input::DescribeBudgetActionsForBudgetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBudgetActionsForBudgetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBudgetActionsForBudgetInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBudgetActionsForBudgetInputOperationOutputAlias =
    crate::operation::DescribeBudgetActionsForBudget;
#[doc(hidden)]
pub type DescribeBudgetActionsForBudgetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBudgetActionsForBudgetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBudgetActionsForBudget`](crate::operation::DescribeBudgetActionsForBudget)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBudgetActionsForBudget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBudgetActionsForBudgetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBudgetActionsForBudgetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBudgetActionsForBudgetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeBudgetActionsForBudget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_budget_actions_for_budget(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBudgetActionsForBudget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBudgetActionsForBudget",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBudgetActionsForBudgetInput`](crate::input::DescribeBudgetActionsForBudgetInput)
    pub fn builder() -> crate::input::describe_budget_actions_for_budget_input::Builder {
        crate::input::describe_budget_actions_for_budget_input::Builder::default()
    }
}

/// See [`DescribeBudgetPerformanceHistoryInput`](crate::input::DescribeBudgetPerformanceHistoryInput)
pub mod describe_budget_performance_history_input {
    /// A builder for [`DescribeBudgetPerformanceHistoryInput`](crate::input::DescribeBudgetPerformanceHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) time_period: std::option::Option<crate::model::TimePeriod>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
        pub fn time_period(mut self, input: crate::model::TimePeriod) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::TimePeriod>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> A generic string.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A generic string.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetPerformanceHistoryInput`](crate::input::DescribeBudgetPerformanceHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBudgetPerformanceHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBudgetPerformanceHistoryInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                time_period: self.time_period,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBudgetPerformanceHistoryInputOperationOutputAlias =
    crate::operation::DescribeBudgetPerformanceHistory;
#[doc(hidden)]
pub type DescribeBudgetPerformanceHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBudgetPerformanceHistoryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBudgetPerformanceHistory`](crate::operation::DescribeBudgetPerformanceHistory)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBudgetPerformanceHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBudgetPerformanceHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBudgetPerformanceHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBudgetPerformanceHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeBudgetPerformanceHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_budget_performance_history(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBudgetPerformanceHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBudgetPerformanceHistory",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBudgetPerformanceHistoryInput`](crate::input::DescribeBudgetPerformanceHistoryInput)
    pub fn builder() -> crate::input::describe_budget_performance_history_input::Builder {
        crate::input::describe_budget_performance_history_input::Builder::default()
    }
}

/// See [`DescribeBudgetsInput`](crate::input::DescribeBudgetsInput)
pub mod describe_budgets_input {
    /// A builder for [`DescribeBudgetsInput`](crate::input::DescribeBudgetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBudgetsInput`](crate::input::DescribeBudgetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBudgetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBudgetsInput {
                account_id: self.account_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBudgetsInputOperationOutputAlias = crate::operation::DescribeBudgets;
#[doc(hidden)]
pub type DescribeBudgetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBudgetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBudgets`](crate::operation::DescribeBudgets)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBudgets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBudgetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBudgetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBudgetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeBudgets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_budgets(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBudgets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBudgets",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBudgetsInput`](crate::input::DescribeBudgetsInput)
    pub fn builder() -> crate::input::describe_budgets_input::Builder {
        crate::input::describe_budgets_input::Builder::default()
    }
}

/// See [`DescribeNotificationsForBudgetInput`](crate::input::DescribeNotificationsForBudgetInput)
pub mod describe_notifications_for_budget_input {
    /// A builder for [`DescribeNotificationsForBudgetInput`](crate::input::DescribeNotificationsForBudgetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget whose notifications you want descriptions of.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget whose notifications you want descriptions of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationsForBudgetInput`](crate::input::DescribeNotificationsForBudgetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNotificationsForBudgetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNotificationsForBudgetInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNotificationsForBudgetInputOperationOutputAlias =
    crate::operation::DescribeNotificationsForBudget;
#[doc(hidden)]
pub type DescribeNotificationsForBudgetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNotificationsForBudgetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNotificationsForBudget`](crate::operation::DescribeNotificationsForBudget)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNotificationsForBudget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNotificationsForBudgetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNotificationsForBudgetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNotificationsForBudgetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeNotificationsForBudget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_notifications_for_budget(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNotificationsForBudget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNotificationsForBudget",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNotificationsForBudgetInput`](crate::input::DescribeNotificationsForBudgetInput)
    pub fn builder() -> crate::input::describe_notifications_for_budget_input::Builder {
        crate::input::describe_notifications_for_budget_input::Builder::default()
    }
}

/// See [`DescribeSubscribersForNotificationInput`](crate::input::DescribeSubscribersForNotificationInput)
pub mod describe_subscribers_for_notification_input {
    /// A builder for [`DescribeSubscribersForNotificationInput`](crate::input::DescribeSubscribersForNotificationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget whose subscribers you want descriptions of.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget whose subscribers you want descriptions of.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The notification whose subscribers you want to list.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The notification whose subscribers you want to list.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSubscribersForNotificationInput`](crate::input::DescribeSubscribersForNotificationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSubscribersForNotificationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSubscribersForNotificationInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                notification: self.notification,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSubscribersForNotificationInputOperationOutputAlias =
    crate::operation::DescribeSubscribersForNotification;
#[doc(hidden)]
pub type DescribeSubscribersForNotificationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSubscribersForNotificationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSubscribersForNotification`](crate::operation::DescribeSubscribersForNotification)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSubscribersForNotification,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSubscribersForNotificationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSubscribersForNotificationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSubscribersForNotificationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.DescribeSubscribersForNotification",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_subscribers_for_notification(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSubscribersForNotification::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSubscribersForNotification",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSubscribersForNotificationInput`](crate::input::DescribeSubscribersForNotificationInput)
    pub fn builder() -> crate::input::describe_subscribers_for_notification_input::Builder {
        crate::input::describe_subscribers_for_notification_input::Builder::default()
    }
}

/// See [`ExecuteBudgetActionInput`](crate::input::ExecuteBudgetActionInput)
pub mod execute_budget_action_input {
    /// A builder for [`ExecuteBudgetActionInput`](crate::input::ExecuteBudgetActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) execution_type: std::option::Option<crate::model::ExecutionType>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>
        /// The type of execution.
        /// </p>
        pub fn execution_type(mut self, input: crate::model::ExecutionType) -> Self {
            self.execution_type = Some(input);
            self
        }
        /// <p>
        /// The type of execution.
        /// </p>
        pub fn set_execution_type(
            mut self,
            input: std::option::Option<crate::model::ExecutionType>,
        ) -> Self {
            self.execution_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteBudgetActionInput`](crate::input::ExecuteBudgetActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteBudgetActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteBudgetActionInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action_id: self.action_id,
                execution_type: self.execution_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteBudgetActionInputOperationOutputAlias = crate::operation::ExecuteBudgetAction;
#[doc(hidden)]
pub type ExecuteBudgetActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExecuteBudgetActionInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteBudgetAction`](crate::operation::ExecuteBudgetAction)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteBudgetAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteBudgetActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteBudgetActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteBudgetActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.ExecuteBudgetAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_execute_budget_action(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteBudgetAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteBudgetAction",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteBudgetActionInput`](crate::input::ExecuteBudgetActionInput)
    pub fn builder() -> crate::input::execute_budget_action_input::Builder {
        crate::input::execute_budget_action_input::Builder::default()
    }
}

/// See [`UpdateBudgetInput`](crate::input::UpdateBudgetInput)
pub mod update_budget_input {
    /// A builder for [`UpdateBudgetInput`](crate::input::UpdateBudgetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) new_budget: std::option::Option<crate::model::Budget>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The budget that you want to update your budget to.</p>
        pub fn new_budget(mut self, input: crate::model::Budget) -> Self {
            self.new_budget = Some(input);
            self
        }
        /// <p>The budget that you want to update your budget to.</p>
        pub fn set_new_budget(mut self, input: std::option::Option<crate::model::Budget>) -> Self {
            self.new_budget = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBudgetInput`](crate::input::UpdateBudgetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBudgetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBudgetInput {
                account_id: self.account_id,
                new_budget: self.new_budget,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBudgetInputOperationOutputAlias = crate::operation::UpdateBudget;
#[doc(hidden)]
pub type UpdateBudgetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBudgetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBudget`](crate::operation::UpdateBudget)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBudget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBudgetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBudgetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBudgetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.UpdateBudget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_budget(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBudget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBudget",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBudgetInput`](crate::input::UpdateBudgetInput)
    pub fn builder() -> crate::input::update_budget_input::Builder {
        crate::input::update_budget_input::Builder::default()
    }
}

/// See [`UpdateBudgetActionInput`](crate::input::UpdateBudgetActionInput)
pub mod update_budget_action_input {
    /// A builder for [`UpdateBudgetActionInput`](crate::input::UpdateBudgetActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) notification_type: std::option::Option<crate::model::NotificationType>,
        pub(crate) action_threshold: std::option::Option<crate::model::ActionThreshold>,
        pub(crate) definition: std::option::Option<crate::model::Definition>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) approval_model: std::option::Option<crate::model::ApprovalModel>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    }
    impl Builder {
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the user. It should be a 12-digit number.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>
        /// A system-generated universally unique identifier (UUID) for the action.
        /// </p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.notification_type = Some(input);
            self
        }
        /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn action_threshold(mut self, input: crate::model::ActionThreshold) -> Self {
            self.action_threshold = Some(input);
            self
        }
        /// <p>
        /// The trigger threshold of the action.
        /// </p>
        pub fn set_action_threshold(
            mut self,
            input: std::option::Option<crate::model::ActionThreshold>,
        ) -> Self {
            self.action_threshold = input;
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn definition(mut self, input: crate::model::Definition) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>
        /// Specifies all of the type-specific parameters.
        /// </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::Definition>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>
        /// The role passed for action execution and reversion. Roles and actions must be in the same account.
        /// </p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn approval_model(mut self, input: crate::model::ApprovalModel) -> Self {
            self.approval_model = Some(input);
            self
        }
        /// <p>
        /// This specifies if the action needs manual or automatic approval.
        /// </p>
        pub fn set_approval_model(
            mut self,
            input: std::option::Option<crate::model::ApprovalModel>,
        ) -> Self {
            self.approval_model = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p> A list of subscribers.</p>
        pub fn subscribers(mut self, input: impl Into<crate::model::Subscriber>) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input.into());
            self.subscribers = Some(v);
            self
        }
        /// <p> A list of subscribers.</p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBudgetActionInput`](crate::input::UpdateBudgetActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBudgetActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBudgetActionInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                action_id: self.action_id,
                notification_type: self.notification_type,
                action_threshold: self.action_threshold,
                definition: self.definition,
                execution_role_arn: self.execution_role_arn,
                approval_model: self.approval_model,
                subscribers: self.subscribers,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBudgetActionInputOperationOutputAlias = crate::operation::UpdateBudgetAction;
#[doc(hidden)]
pub type UpdateBudgetActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBudgetActionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBudgetAction`](crate::operation::UpdateBudgetAction)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBudgetAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBudgetActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBudgetActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBudgetActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.UpdateBudgetAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_budget_action(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBudgetAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBudgetAction",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBudgetActionInput`](crate::input::UpdateBudgetActionInput)
    pub fn builder() -> crate::input::update_budget_action_input::Builder {
        crate::input::update_budget_action_input::Builder::default()
    }
}

/// See [`UpdateNotificationInput`](crate::input::UpdateNotificationInput)
pub mod update_notification_input {
    /// A builder for [`UpdateNotificationInput`](crate::input::UpdateNotificationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) old_notification: std::option::Option<crate::model::Notification>,
        pub(crate) new_notification: std::option::Option<crate::model::Notification>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget whose notification you want to update.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget whose notification you want to update.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The previous notification that is associated with a budget.</p>
        pub fn old_notification(mut self, input: crate::model::Notification) -> Self {
            self.old_notification = Some(input);
            self
        }
        /// <p>The previous notification that is associated with a budget.</p>
        pub fn set_old_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.old_notification = input;
            self
        }
        /// <p>The updated notification to be associated with a budget.</p>
        pub fn new_notification(mut self, input: crate::model::Notification) -> Self {
            self.new_notification = Some(input);
            self
        }
        /// <p>The updated notification to be associated with a budget.</p>
        pub fn set_new_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.new_notification = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNotificationInput`](crate::input::UpdateNotificationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNotificationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNotificationInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                old_notification: self.old_notification,
                new_notification: self.new_notification,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNotificationInputOperationOutputAlias = crate::operation::UpdateNotification;
#[doc(hidden)]
pub type UpdateNotificationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateNotificationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNotification`](crate::operation::UpdateNotification)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNotification,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNotificationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNotificationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNotificationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.UpdateNotification",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_notification(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNotification::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNotification",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNotificationInput`](crate::input::UpdateNotificationInput)
    pub fn builder() -> crate::input::update_notification_input::Builder {
        crate::input::update_notification_input::Builder::default()
    }
}

/// See [`UpdateSubscriberInput`](crate::input::UpdateSubscriberInput)
pub mod update_subscriber_input {
    /// A builder for [`UpdateSubscriberInput`](crate::input::UpdateSubscriberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) old_subscriber: std::option::Option<crate::model::Subscriber>,
        pub(crate) new_subscriber: std::option::Option<crate::model::Subscriber>,
    }
    impl Builder {
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the budget whose subscriber you want to update.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget whose subscriber you want to update.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The notification whose subscriber you want to update.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The notification whose subscriber you want to update.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The previous subscriber that is associated with a budget notification.</p>
        pub fn old_subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.old_subscriber = Some(input);
            self
        }
        /// <p>The previous subscriber that is associated with a budget notification.</p>
        pub fn set_old_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.old_subscriber = input;
            self
        }
        /// <p>The updated subscriber that is associated with a budget notification.</p>
        pub fn new_subscriber(mut self, input: crate::model::Subscriber) -> Self {
            self.new_subscriber = Some(input);
            self
        }
        /// <p>The updated subscriber that is associated with a budget notification.</p>
        pub fn set_new_subscriber(
            mut self,
            input: std::option::Option<crate::model::Subscriber>,
        ) -> Self {
            self.new_subscriber = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSubscriberInput`](crate::input::UpdateSubscriberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSubscriberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSubscriberInput {
                account_id: self.account_id,
                budget_name: self.budget_name,
                notification: self.notification,
                old_subscriber: self.old_subscriber,
                new_subscriber: self.new_subscriber,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSubscriberInputOperationOutputAlias = crate::operation::UpdateSubscriber;
#[doc(hidden)]
pub type UpdateSubscriberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSubscriberInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSubscriber`](crate::operation::UpdateSubscriber)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSubscriber,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSubscriberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSubscriberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSubscriberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSBudgetServiceGateway.UpdateSubscriber",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_subscriber(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSubscriber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSubscriber",
            "budgets",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSubscriberInput`](crate::input::UpdateSubscriberInput)
    pub fn builder() -> crate::input::update_subscriber_input::Builder {
        crate::input::update_subscriber_input::Builder::default()
    }
}

/// <p> Request of UpdateSubscriber </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSubscriberInput {
    /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to update.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget whose subscriber you want to update.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The notification whose subscriber you want to update.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The previous subscriber that is associated with a budget notification.</p>
    pub old_subscriber: std::option::Option<crate::model::Subscriber>,
    /// <p>The updated subscriber that is associated with a budget notification.</p>
    pub new_subscriber: std::option::Option<crate::model::Subscriber>,
}
impl std::fmt::Debug for UpdateSubscriberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSubscriberInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification", &self.notification);
        formatter.field("old_subscriber", &self.old_subscriber);
        formatter.field("new_subscriber", &self.new_subscriber);
        formatter.finish()
    }
}

/// <p> Request of UpdateNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNotificationInput {
    /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to update.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget whose notification you want to update.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The previous notification that is associated with a budget.</p>
    pub old_notification: std::option::Option<crate::model::Notification>,
    /// <p>The updated notification to be associated with a budget.</p>
    pub new_notification: std::option::Option<crate::model::Notification>,
}
impl std::fmt::Debug for UpdateNotificationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNotificationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("old_notification", &self.old_notification);
        formatter.field("new_notification", &self.new_notification);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBudgetActionInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>
    /// A system-generated universally unique identifier (UUID) for the action.
    /// </p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
    pub notification_type: std::option::Option<crate::model::NotificationType>,
    /// <p>
    /// The trigger threshold of the action.
    /// </p>
    pub action_threshold: std::option::Option<crate::model::ActionThreshold>,
    /// <p>
    /// Specifies all of the type-specific parameters.
    /// </p>
    pub definition: std::option::Option<crate::model::Definition>,
    /// <p>
    /// The role passed for action execution and reversion. Roles and actions must be in the same account.
    /// </p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>
    /// This specifies if the action needs manual or automatic approval.
    /// </p>
    pub approval_model: std::option::Option<crate::model::ApprovalModel>,
    /// <p> A list of subscribers.</p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
}
impl std::fmt::Debug for UpdateBudgetActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBudgetActionInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action_id", &self.action_id);
        formatter.field("notification_type", &self.notification_type);
        formatter.field("action_threshold", &self.action_threshold);
        formatter.field("definition", &self.definition);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("approval_model", &self.approval_model);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}

/// <p> Request of UpdateBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBudgetInput {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to update.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The budget that you want to update your budget to.</p>
    pub new_budget: std::option::Option<crate::model::Budget>,
}
impl std::fmt::Debug for UpdateBudgetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBudgetInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("new_budget", &self.new_budget);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteBudgetActionInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>
    /// A system-generated universally unique identifier (UUID) for the action.
    /// </p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>
    /// The type of execution.
    /// </p>
    pub execution_type: std::option::Option<crate::model::ExecutionType>,
}
impl std::fmt::Debug for ExecuteBudgetActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteBudgetActionInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action_id", &self.action_id);
        formatter.field("execution_type", &self.execution_type);
        formatter.finish()
    }
}

/// <p> Request of DescribeSubscribersForNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSubscribersForNotificationInput {
    /// <p>The <code>accountId</code> that is associated with the budget whose subscribers you want descriptions of.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget whose subscribers you want descriptions of.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The notification whose subscribers you want to list.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeSubscribersForNotificationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSubscribersForNotificationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification", &self.notification);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Request of DescribeNotificationsForBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationsForBudgetInput {
    /// <p>The <code>accountId</code> that is associated with the budget whose notifications you want descriptions of.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget whose notifications you want descriptions of.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeNotificationsForBudgetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationsForBudgetInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p> Request of DescribeBudgets </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetsInput {
    /// <p>The <code>accountId</code> that is associated with the budgets that you want descriptions of.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An optional integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token that you include in your request to indicate the next set of results that you want to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeBudgetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetPerformanceHistoryInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>Retrieves how often the budget went into an <code>ALARM</code> state for the specified time period.</p>
    pub time_period: std::option::Option<crate::model::TimePeriod>,
    /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeBudgetPerformanceHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetPerformanceHistoryInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("time_period", &self.time_period);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionsForBudgetInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeBudgetActionsForBudgetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionsForBudgetInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionsForAccountInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeBudgetActionsForAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionsForAccountInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionHistoriesInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>
    /// A system-generated universally unique identifier (UUID) for the action.
    /// </p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. </p>
    pub time_period: std::option::Option<crate::model::TimePeriod>,
    /// <p> An integer that represents how many entries a paginated response contains. The maximum is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> A generic string.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeBudgetActionHistoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionHistoriesInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action_id", &self.action_id);
        formatter.field("time_period", &self.time_period);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetActionInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>
    /// A system-generated universally unique identifier (UUID) for the action.
    /// </p>
    pub action_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeBudgetActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetActionInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action_id", &self.action_id);
        formatter.finish()
    }
}

/// <p> Request of DescribeBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBudgetInput {
    /// <p>The <code>accountId</code> that is associated with the budget that you want a description of.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget that you want a description of.</p>
    pub budget_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeBudgetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBudgetInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.finish()
    }
}

/// <p> Request of DeleteSubscriber </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSubscriberInput {
    /// <p>The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget whose subscriber you want to delete.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The notification whose subscriber you want to delete.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The subscriber that you want to delete.</p>
    pub subscriber: std::option::Option<crate::model::Subscriber>,
}
impl std::fmt::Debug for DeleteSubscriberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSubscriberInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification", &self.notification);
        formatter.field("subscriber", &self.subscriber);
        formatter.finish()
    }
}

/// <p> Request of DeleteNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationInput {
    /// <p>The <code>accountId</code> that is associated with the budget whose notification you want to delete.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget whose notification you want to delete.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The notification that you want to delete.</p>
    pub notification: std::option::Option<crate::model::Notification>,
}
impl std::fmt::Debug for DeleteNotificationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification", &self.notification);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBudgetActionInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>
    /// A system-generated universally unique identifier (UUID) for the action.
    /// </p>
    pub action_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBudgetActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBudgetActionInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("action_id", &self.action_id);
        formatter.finish()
    }
}

/// <p> Request of DeleteBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBudgetInput {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to delete.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget that you want to delete.</p>
    pub budget_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBudgetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBudgetInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.finish()
    }
}

/// <p> Request of CreateSubscriber </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSubscriberInput {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to create a subscriber for.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget that you want to subscribe to. Budget names must be unique within an account.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The notification that you want to create a subscriber for.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The subscriber that you want to associate with a budget notification.</p>
    pub subscriber: std::option::Option<crate::model::Subscriber>,
}
impl std::fmt::Debug for CreateSubscriberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSubscriberInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification", &self.notification);
        formatter.field("subscriber", &self.subscriber);
        formatter.finish()
    }
}

/// <p> Request of CreateNotification </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNotificationInput {
    /// <p>The <code>accountId</code> that is associated with the budget that you want to create a notification for.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the budget that you want AWS to notify you about. Budget names must be unique within an account.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The notification that you want to create.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.</p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
}
impl std::fmt::Debug for CreateNotificationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNotificationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification", &self.notification);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBudgetActionInput {
    /// <p>The account ID of the user. It should be a 12-digit number.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> A string that represents the budget name. The ":" and "\" characters aren't allowed.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p> The type of a notification. It must be ACTUAL or FORECASTED.</p>
    pub notification_type: std::option::Option<crate::model::NotificationType>,
    /// <p>
    /// The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
    /// </p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>
    /// The trigger threshold of the action.
    /// </p>
    pub action_threshold: std::option::Option<crate::model::ActionThreshold>,
    /// <p>
    /// Specifies all of the type-specific parameters.
    /// </p>
    pub definition: std::option::Option<crate::model::Definition>,
    /// <p>
    /// The role passed for action execution and reversion. Roles and actions must be in the same account.
    /// </p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>
    /// This specifies if the action needs manual or automatic approval.
    /// </p>
    pub approval_model: std::option::Option<crate::model::ApprovalModel>,
    /// <p> A list of subscribers.</p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
}
impl std::fmt::Debug for CreateBudgetActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBudgetActionInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget_name", &self.budget_name);
        formatter.field("notification_type", &self.notification_type);
        formatter.field("action_type", &self.action_type);
        formatter.field("action_threshold", &self.action_threshold);
        formatter.field("definition", &self.definition);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("approval_model", &self.approval_model);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}

/// <p> Request of CreateBudget </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBudgetInput {
    /// <p>The <code>accountId</code> that is associated with the budget.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The budget object that you want to create.</p>
    pub budget: std::option::Option<crate::model::Budget>,
    /// <p>A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.</p>
    pub notifications_with_subscribers:
        std::option::Option<std::vec::Vec<crate::model::NotificationWithSubscribers>>,
}
impl std::fmt::Debug for CreateBudgetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBudgetInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("budget", &self.budget);
        formatter.field(
            "notifications_with_subscribers",
            &self.notifications_with_subscribers,
        );
        formatter.finish()
    }
}
