// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Braket
///
/// Client for invoking operations on Braket. Each operation on Braket is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_braket::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_braket::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_braket::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CancelJob`](crate::client::fluent_builders::CancelJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_arn(impl Into<String>)`](crate::client::fluent_builders::CancelJob::job_arn) / [`set_job_arn(Option<String>)`](crate::client::fluent_builders::CancelJob::set_job_arn): <p>The ARN of the Amazon Braket job to cancel.</p>
    /// - On success, responds with [`CancelJobOutput`](crate::output::CancelJobOutput) with field(s):
    ///   - [`job_arn(Option<String>)`](crate::output::CancelJobOutput::job_arn): <p>The ARN of the Amazon Braket job.</p>
    ///   - [`cancellation_status(Option<CancellationStatus>)`](crate::output::CancelJobOutput::cancellation_status): <p>The status of the job cancellation request.</p>
    /// - On failure, responds with [`SdkError<CancelJobError>`](crate::error::CancelJobError)
    pub fn cancel_job(&self) -> fluent_builders::CancelJob<C, M, R> {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelQuantumTask`](crate::client::fluent_builders::CancelQuantumTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`quantum_task_arn(impl Into<String>)`](crate::client::fluent_builders::CancelQuantumTask::quantum_task_arn) / [`set_quantum_task_arn(Option<String>)`](crate::client::fluent_builders::CancelQuantumTask::set_quantum_task_arn): <p>The ARN of the task to cancel.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CancelQuantumTask::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CancelQuantumTask::set_client_token): <p>The client token associated with the request.</p>
    /// - On success, responds with [`CancelQuantumTaskOutput`](crate::output::CancelQuantumTaskOutput) with field(s):
    ///   - [`quantum_task_arn(Option<String>)`](crate::output::CancelQuantumTaskOutput::quantum_task_arn): <p>The ARN of the task.</p>
    ///   - [`cancellation_status(Option<CancellationStatus>)`](crate::output::CancelQuantumTaskOutput::cancellation_status): <p>The status of the cancellation request.</p>
    /// - On failure, responds with [`SdkError<CancelQuantumTaskError>`](crate::error::CancelQuantumTaskError)
    pub fn cancel_quantum_task(&self) -> fluent_builders::CancelQuantumTask<C, M, R> {
        fluent_builders::CancelQuantumTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJob`](crate::client::fluent_builders::CreateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateJob::set_client_token): <p>A unique token that guarantees that the call to this API is idempotent.</p>
    ///   - [`algorithm_specification(AlgorithmSpecification)`](crate::client::fluent_builders::CreateJob::algorithm_specification) / [`set_algorithm_specification(Option<AlgorithmSpecification>)`](crate::client::fluent_builders::CreateJob::set_algorithm_specification): <p>Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information about the Python scripts used for entry and training.</p>
    ///   - [`input_data_config(Vec<InputFileConfig>)`](crate::client::fluent_builders::CreateJob::input_data_config) / [`set_input_data_config(Option<Vec<InputFileConfig>>)`](crate::client::fluent_builders::CreateJob::set_input_data_config): <p>A list of parameters that specify the name and type of input data and where it is located.</p>
    ///   - [`output_data_config(JobOutputDataConfig)`](crate::client::fluent_builders::CreateJob::output_data_config) / [`set_output_data_config(Option<JobOutputDataConfig>)`](crate::client::fluent_builders::CreateJob::set_output_data_config): <p>The path to the S3 location where you want to store job artifacts and the encryption key used to store them.</p>
    ///   - [`checkpoint_config(JobCheckpointConfig)`](crate::client::fluent_builders::CreateJob::checkpoint_config) / [`set_checkpoint_config(Option<JobCheckpointConfig>)`](crate::client::fluent_builders::CreateJob::set_checkpoint_config): <p>Information about the output locations for job checkpoint data.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::CreateJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::CreateJob::set_job_name): <p>The name of the Amazon Braket job.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateJob::set_role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the users' s3 buckets.</p>
    ///   - [`stopping_condition(JobStoppingCondition)`](crate::client::fluent_builders::CreateJob::stopping_condition) / [`set_stopping_condition(Option<JobStoppingCondition>)`](crate::client::fluent_builders::CreateJob::set_stopping_condition): <p> The user-defined criteria that specifies when a job stops running.</p>
    ///   - [`instance_config(InstanceConfig)`](crate::client::fluent_builders::CreateJob::instance_config) / [`set_instance_config(Option<InstanceConfig>)`](crate::client::fluent_builders::CreateJob::set_instance_config): <p>Configuration of the resource instances to use while running the hybrid job on Amazon Braket.</p>
    ///   - [`hyper_parameters(HashMap<String, String>)`](crate::client::fluent_builders::CreateJob::hyper_parameters) / [`set_hyper_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateJob::set_hyper_parameters): <p>Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.</p>
    ///   - [`device_config(DeviceConfig)`](crate::client::fluent_builders::CreateJob::device_config) / [`set_device_config(Option<DeviceConfig>)`](crate::client::fluent_builders::CreateJob::set_device_config): <p>The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateJob::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateJob::set_tags): <p>A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.</p>
    /// - On success, responds with [`CreateJobOutput`](crate::output::CreateJobOutput) with field(s):
    ///   - [`job_arn(Option<String>)`](crate::output::CreateJobOutput::job_arn): <p>The ARN of the Amazon Braket job created.</p>
    /// - On failure, responds with [`SdkError<CreateJobError>`](crate::error::CreateJobError)
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateQuantumTask`](crate::client::fluent_builders::CreateQuantumTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateQuantumTask::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateQuantumTask::set_client_token): <p>The client token associated with the request.</p>
    ///   - [`device_arn(impl Into<String>)`](crate::client::fluent_builders::CreateQuantumTask::device_arn) / [`set_device_arn(Option<String>)`](crate::client::fluent_builders::CreateQuantumTask::set_device_arn): <p>The ARN of the device to run the task on.</p>
    ///   - [`device_parameters(impl Into<String>)`](crate::client::fluent_builders::CreateQuantumTask::device_parameters) / [`set_device_parameters(Option<String>)`](crate::client::fluent_builders::CreateQuantumTask::set_device_parameters): <p>The parameters for the device to run the task on.</p>
    ///   - [`shots(i64)`](crate::client::fluent_builders::CreateQuantumTask::shots) / [`set_shots(Option<i64>)`](crate::client::fluent_builders::CreateQuantumTask::set_shots): <p>The number of shots to use for the task.</p>
    ///   - [`output_s3_bucket(impl Into<String>)`](crate::client::fluent_builders::CreateQuantumTask::output_s3_bucket) / [`set_output_s3_bucket(Option<String>)`](crate::client::fluent_builders::CreateQuantumTask::set_output_s3_bucket): <p>The S3 bucket to store task result files in.</p>
    ///   - [`output_s3_key_prefix(impl Into<String>)`](crate::client::fluent_builders::CreateQuantumTask::output_s3_key_prefix) / [`set_output_s3_key_prefix(Option<String>)`](crate::client::fluent_builders::CreateQuantumTask::set_output_s3_key_prefix): <p>The key prefix for the location in the S3 bucket to store task results in.</p>
    ///   - [`action(impl Into<String>)`](crate::client::fluent_builders::CreateQuantumTask::action) / [`set_action(Option<String>)`](crate::client::fluent_builders::CreateQuantumTask::set_action): <p>The action associated with the task.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateQuantumTask::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateQuantumTask::set_tags): <p>Tags to be added to the quantum task you're creating.</p>
    ///   - [`job_token(impl Into<String>)`](crate::client::fluent_builders::CreateQuantumTask::job_token) / [`set_job_token(Option<String>)`](crate::client::fluent_builders::CreateQuantumTask::set_job_token): <p>The token for an Amazon Braket job that associates it with the quantum task.</p>
    /// - On success, responds with [`CreateQuantumTaskOutput`](crate::output::CreateQuantumTaskOutput) with field(s):
    ///   - [`quantum_task_arn(Option<String>)`](crate::output::CreateQuantumTaskOutput::quantum_task_arn): <p>The ARN of the task created by the request.</p>
    /// - On failure, responds with [`SdkError<CreateQuantumTaskError>`](crate::error::CreateQuantumTaskError)
    pub fn create_quantum_task(&self) -> fluent_builders::CreateQuantumTask<C, M, R> {
        fluent_builders::CreateQuantumTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDevice`](crate::client::fluent_builders::GetDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`device_arn(impl Into<String>)`](crate::client::fluent_builders::GetDevice::device_arn) / [`set_device_arn(Option<String>)`](crate::client::fluent_builders::GetDevice::set_device_arn): <p>The ARN of the device to retrieve.</p>
    /// - On success, responds with [`GetDeviceOutput`](crate::output::GetDeviceOutput) with field(s):
    ///   - [`device_arn(Option<String>)`](crate::output::GetDeviceOutput::device_arn): <p>The ARN of the device.</p>
    ///   - [`device_name(Option<String>)`](crate::output::GetDeviceOutput::device_name): <p>The name of the device.</p>
    ///   - [`provider_name(Option<String>)`](crate::output::GetDeviceOutput::provider_name): <p>The name of the partner company for the device.</p>
    ///   - [`device_type(Option<DeviceType>)`](crate::output::GetDeviceOutput::device_type): <p>The type of the device.</p>
    ///   - [`device_status(Option<DeviceStatus>)`](crate::output::GetDeviceOutput::device_status): <p>The status of the device.</p>
    ///   - [`device_capabilities(Option<String>)`](crate::output::GetDeviceOutput::device_capabilities): <p>Details about the capabilities of the device.</p>
    /// - On failure, responds with [`SdkError<GetDeviceError>`](crate::error::GetDeviceError)
    pub fn get_device(&self) -> fluent_builders::GetDevice<C, M, R> {
        fluent_builders::GetDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJob`](crate::client::fluent_builders::GetJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_arn(impl Into<String>)`](crate::client::fluent_builders::GetJob::job_arn) / [`set_job_arn(Option<String>)`](crate::client::fluent_builders::GetJob::set_job_arn): <p>The ARN of the job to retrieve.</p>
    /// - On success, responds with [`GetJobOutput`](crate::output::GetJobOutput) with field(s):
    ///   - [`status(Option<JobPrimaryStatus>)`](crate::output::GetJobOutput::status): <p>The status of the Amazon Braket job.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::GetJobOutput::job_arn): <p>The ARN of the Amazon Braket job.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::GetJobOutput::role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the s3 buckets of a user.</p>
    ///   - [`failure_reason(Option<String>)`](crate::output::GetJobOutput::failure_reason): <p>A description of the reason why an Amazon Braket job failed, if it failed.</p>
    ///   - [`job_name(Option<String>)`](crate::output::GetJobOutput::job_name): <p>The name of the Amazon Braket job.</p>
    ///   - [`hyper_parameters(Option<HashMap<String, String>>)`](crate::output::GetJobOutput::hyper_parameters): <p>Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the traiing job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.</p>
    ///   - [`input_data_config(Option<Vec<InputFileConfig>>)`](crate::output::GetJobOutput::input_data_config): <p>A list of parameters that specify the name and type of input data and where it is located.</p>
    ///   - [`output_data_config(Option<JobOutputDataConfig>)`](crate::output::GetJobOutput::output_data_config): <p>The path to the S3 location where job artifacts are stored and the encryption key used to store them there.</p>
    ///   - [`stopping_condition(Option<JobStoppingCondition>)`](crate::output::GetJobOutput::stopping_condition): <p>The user-defined criteria that specifies when to stop a job running.</p>
    ///   - [`checkpoint_config(Option<JobCheckpointConfig>)`](crate::output::GetJobOutput::checkpoint_config): <p>Information about the output locations for job checkpoint data.</p>
    ///   - [`algorithm_specification(Option<AlgorithmSpecification>)`](crate::output::GetJobOutput::algorithm_specification): <p>Definition of the Amazon Braket job created. Specifies the container image the job uses, information about the Python scripts used for entry and training, and the user-defined metrics used to evaluation the job.</p>
    ///   - [`instance_config(Option<InstanceConfig>)`](crate::output::GetJobOutput::instance_config): <p>The resource instances to use while running the hybrid job on Amazon Braket.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetJobOutput::created_at): <p>The date and time that the Amazon Braket job was created.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::GetJobOutput::started_at): <p>The date and time that the Amazon Braket job was started.</p>
    ///   - [`ended_at(Option<DateTime>)`](crate::output::GetJobOutput::ended_at): <p>The date and time that the Amazon Braket job ended.</p>
    ///   - [`billable_duration(Option<i32>)`](crate::output::GetJobOutput::billable_duration): <p>The billable time the Amazon Braket job used to complete.</p>
    ///   - [`device_config(Option<DeviceConfig>)`](crate::output::GetJobOutput::device_config): <p>The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.</p>
    ///   - [`events(Option<Vec<JobEventDetails>>)`](crate::output::GetJobOutput::events): <p>Details about the type and time events occurred related to the Amazon Braket job.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetJobOutput::tags): <p>A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.</p>
    /// - On failure, responds with [`SdkError<GetJobError>`](crate::error::GetJobError)
    pub fn get_job(&self) -> fluent_builders::GetJob<C, M, R> {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetQuantumTask`](crate::client::fluent_builders::GetQuantumTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`quantum_task_arn(impl Into<String>)`](crate::client::fluent_builders::GetQuantumTask::quantum_task_arn) / [`set_quantum_task_arn(Option<String>)`](crate::client::fluent_builders::GetQuantumTask::set_quantum_task_arn): <p>the ARN of the task to retrieve.</p>
    /// - On success, responds with [`GetQuantumTaskOutput`](crate::output::GetQuantumTaskOutput) with field(s):
    ///   - [`quantum_task_arn(Option<String>)`](crate::output::GetQuantumTaskOutput::quantum_task_arn): <p>The ARN of the task.</p>
    ///   - [`status(Option<QuantumTaskStatus>)`](crate::output::GetQuantumTaskOutput::status): <p>The status of the task.</p>
    ///   - [`failure_reason(Option<String>)`](crate::output::GetQuantumTaskOutput::failure_reason): <p>The reason that a task failed.</p>
    ///   - [`device_arn(Option<String>)`](crate::output::GetQuantumTaskOutput::device_arn): <p>The ARN of the device the task was run on.</p>
    ///   - [`device_parameters(Option<String>)`](crate::output::GetQuantumTaskOutput::device_parameters): <p>The parameters for the device on which the task ran.</p>
    ///   - [`shots(Option<i64>)`](crate::output::GetQuantumTaskOutput::shots): <p>The number of shots used in the task.</p>
    ///   - [`output_s3_bucket(Option<String>)`](crate::output::GetQuantumTaskOutput::output_s3_bucket): <p>The S3 bucket where task results are stored.</p>
    ///   - [`output_s3_directory(Option<String>)`](crate::output::GetQuantumTaskOutput::output_s3_directory): <p>The folder in the S3 bucket where task results are stored.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetQuantumTaskOutput::created_at): <p>The time at which the task was created.</p>
    ///   - [`ended_at(Option<DateTime>)`](crate::output::GetQuantumTaskOutput::ended_at): <p>The time at which the task ended.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetQuantumTaskOutput::tags): <p>The tags that belong to this task.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::GetQuantumTaskOutput::job_arn): <p>The ARN of the Amazon Braket job associated with the quantum task.</p>
    /// - On failure, responds with [`SdkError<GetQuantumTaskError>`](crate::error::GetQuantumTaskError)
    pub fn get_quantum_task(&self) -> fluent_builders::GetQuantumTask<C, M, R> {
        fluent_builders::GetQuantumTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>Specify the <code>resourceArn</code> for the resource whose tags to display.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Displays the key, value pairs of tags associated with this resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchDevices`](crate::client::fluent_builders::SearchDevices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchDevices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchDevices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchDevices::set_next_token): <p>A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchDevices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchDevices::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`filters(Vec<SearchDevicesFilter>)`](crate::client::fluent_builders::SearchDevices::filters) / [`set_filters(Option<Vec<SearchDevicesFilter>>)`](crate::client::fluent_builders::SearchDevices::set_filters): <p>The filter values to use to search for a device.</p>
    /// - On success, responds with [`SearchDevicesOutput`](crate::output::SearchDevicesOutput) with field(s):
    ///   - [`devices(Option<Vec<DeviceSummary>>)`](crate::output::SearchDevicesOutput::devices): <p>An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchDevicesOutput::next_token): <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
    /// - On failure, responds with [`SdkError<SearchDevicesError>`](crate::error::SearchDevicesError)
    pub fn search_devices(&self) -> fluent_builders::SearchDevices<C, M, R> {
        fluent_builders::SearchDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchJobs`](crate::client::fluent_builders::SearchJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchJobs::set_next_token): <p>A token used for pagination of results returned in the response. Use the token returned from the previous request to continue results where the previous request ended.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchJobs::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`filters(Vec<SearchJobsFilter>)`](crate::client::fluent_builders::SearchJobs::filters) / [`set_filters(Option<Vec<SearchJobsFilter>>)`](crate::client::fluent_builders::SearchJobs::set_filters): <p>The filter values to use when searching for a job.</p>
    /// - On success, responds with [`SearchJobsOutput`](crate::output::SearchJobsOutput) with field(s):
    ///   - [`jobs(Option<Vec<JobSummary>>)`](crate::output::SearchJobsOutput::jobs): <p>An array of <code>JobSummary</code> objects for devices that match the specified filter values.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchJobsOutput::next_token): <p>A token used for pagination of results, or <code>null</code> if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
    /// - On failure, responds with [`SdkError<SearchJobsError>`](crate::error::SearchJobsError)
    pub fn search_jobs(&self) -> fluent_builders::SearchJobs<C, M, R> {
        fluent_builders::SearchJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchQuantumTasks`](crate::client::fluent_builders::SearchQuantumTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchQuantumTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchQuantumTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchQuantumTasks::set_next_token): <p>A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchQuantumTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchQuantumTasks::set_max_results): <p>Maximum number of results to return in the response.</p>
    ///   - [`filters(Vec<SearchQuantumTasksFilter>)`](crate::client::fluent_builders::SearchQuantumTasks::filters) / [`set_filters(Option<Vec<SearchQuantumTasksFilter>>)`](crate::client::fluent_builders::SearchQuantumTasks::set_filters): <p>Array of <code>SearchQuantumTasksFilter</code> objects.</p>
    /// - On success, responds with [`SearchQuantumTasksOutput`](crate::output::SearchQuantumTasksOutput) with field(s):
    ///   - [`quantum_tasks(Option<Vec<QuantumTaskSummary>>)`](crate::output::SearchQuantumTasksOutput::quantum_tasks): <p>An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchQuantumTasksOutput::next_token): <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
    /// - On failure, responds with [`SdkError<SearchQuantumTasksError>`](crate::error::SearchQuantumTasksError)
    pub fn search_quantum_tasks(&self) -> fluent_builders::SearchQuantumTasks<C, M, R> {
        fluent_builders::SearchQuantumTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>Specify the <code>resourceArn</code> of the resource to which a tag will be added.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Specify the tags to add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>Specify the <code>resourceArn</code> for the resource from which to remove the tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Specify the keys for the tags to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// <p>Cancels an Amazon Braket job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl<C, M, R> CancelJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobInputOperationOutputAlias,
                crate::output::CancelJobOutput,
                crate::error::CancelJobError,
                crate::input::CancelJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Amazon Braket job to cancel.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon Braket job to cancel.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelQuantumTask`.
    ///
    /// <p>Cancels the specified task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelQuantumTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_quantum_task_input::Builder,
    }
    impl<C, M, R> CancelQuantumTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelQuantumTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelQuantumTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelQuantumTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelQuantumTaskInputOperationOutputAlias,
                crate::output::CancelQuantumTaskOutput,
                crate::error::CancelQuantumTaskError,
                crate::input::CancelQuantumTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the task to cancel.</p>
        pub fn quantum_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quantum_task_arn(input.into());
            self
        }
        /// <p>The ARN of the task to cancel.</p>
        pub fn set_quantum_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quantum_task_arn(input);
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>Creates an Amazon Braket job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique token that guarantees that the call to this API is idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique token that guarantees that the call to this API is idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information about the Python scripts used for entry and training.</p>
        pub fn algorithm_specification(
            mut self,
            input: crate::model::AlgorithmSpecification,
        ) -> Self {
            self.inner = self.inner.algorithm_specification(input);
            self
        }
        /// <p>Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information about the Python scripts used for entry and training.</p>
        pub fn set_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::AlgorithmSpecification>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_specification(input);
            self
        }
        /// Appends an item to `inputDataConfig`.
        ///
        /// To override the contents of this collection use [`set_input_data_config`](Self::set_input_data_config).
        ///
        /// <p>A list of parameters that specify the name and type of input data and where it is located.</p>
        pub fn input_data_config(mut self, input: crate::model::InputFileConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>A list of parameters that specify the name and type of input data and where it is located.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputFileConfig>>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The path to the S3 location where you want to store job artifacts and the encryption key used to store them.</p>
        pub fn output_data_config(mut self, input: crate::model::JobOutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>The path to the S3 location where you want to store job artifacts and the encryption key used to store them.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::JobOutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>Information about the output locations for job checkpoint data.</p>
        pub fn checkpoint_config(mut self, input: crate::model::JobCheckpointConfig) -> Self {
            self.inner = self.inner.checkpoint_config(input);
            self
        }
        /// <p>Information about the output locations for job checkpoint data.</p>
        pub fn set_checkpoint_config(
            mut self,
            input: std::option::Option<crate::model::JobCheckpointConfig>,
        ) -> Self {
            self.inner = self.inner.set_checkpoint_config(input);
            self
        }
        /// <p>The name of the Amazon Braket job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The name of the Amazon Braket job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the users' s3 buckets.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the users' s3 buckets.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p> The user-defined criteria that specifies when a job stops running.</p>
        pub fn stopping_condition(mut self, input: crate::model::JobStoppingCondition) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p> The user-defined criteria that specifies when a job stops running.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::JobStoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// <p>Configuration of the resource instances to use while running the hybrid job on Amazon Braket.</p>
        pub fn instance_config(mut self, input: crate::model::InstanceConfig) -> Self {
            self.inner = self.inner.instance_config(input);
            self
        }
        /// <p>Configuration of the resource instances to use while running the hybrid job on Amazon Braket.</p>
        pub fn set_instance_config(
            mut self,
            input: std::option::Option<crate::model::InstanceConfig>,
        ) -> Self {
            self.inner = self.inner.set_instance_config(input);
            self
        }
        /// Adds a key-value pair to `hyperParameters`.
        ///
        /// To override the contents of this collection use [`set_hyper_parameters`](Self::set_hyper_parameters).
        ///
        /// <p>Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.</p>
        pub fn hyper_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hyper_parameters(k.into(), v.into());
            self
        }
        /// <p>Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.</p>
        pub fn set_hyper_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_hyper_parameters(input);
            self
        }
        /// <p>The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.</p>
        pub fn device_config(mut self, input: crate::model::DeviceConfig) -> Self {
            self.inner = self.inner.device_config(input);
            self
        }
        /// <p>The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.</p>
        pub fn set_device_config(
            mut self,
            input: std::option::Option<crate::model::DeviceConfig>,
        ) -> Self {
            self.inner = self.inner.set_device_config(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQuantumTask`.
    ///
    /// <p>Creates a quantum task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateQuantumTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_quantum_task_input::Builder,
    }
    impl<C, M, R> CreateQuantumTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQuantumTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQuantumTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQuantumTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQuantumTaskInputOperationOutputAlias,
                crate::output::CreateQuantumTaskOutput,
                crate::error::CreateQuantumTaskError,
                crate::input::CreateQuantumTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The client token associated with the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token associated with the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ARN of the device to run the task on.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(input.into());
            self
        }
        /// <p>The ARN of the device to run the task on.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// <p>The parameters for the device to run the task on.</p>
        pub fn device_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_parameters(input.into());
            self
        }
        /// <p>The parameters for the device to run the task on.</p>
        pub fn set_device_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_parameters(input);
            self
        }
        /// <p>The number of shots to use for the task.</p>
        pub fn shots(mut self, input: i64) -> Self {
            self.inner = self.inner.shots(input);
            self
        }
        /// <p>The number of shots to use for the task.</p>
        pub fn set_shots(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_shots(input);
            self
        }
        /// <p>The S3 bucket to store task result files in.</p>
        pub fn output_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_bucket(input.into());
            self
        }
        /// <p>The S3 bucket to store task result files in.</p>
        pub fn set_output_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_bucket(input);
            self
        }
        /// <p>The key prefix for the location in the S3 bucket to store task results in.</p>
        pub fn output_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_key_prefix(input.into());
            self
        }
        /// <p>The key prefix for the location in the S3 bucket to store task results in.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_key_prefix(input);
            self
        }
        /// <p>The action associated with the task.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The action associated with the task.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be added to the quantum task you're creating.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to be added to the quantum task you're creating.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The token for an Amazon Braket job that associates it with the quantum task.</p>
        pub fn job_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_token(input.into());
            self
        }
        /// <p>The token for an Amazon Braket job that associates it with the quantum task.</p>
        pub fn set_job_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevice`.
    ///
    /// <p>Retrieves the devices available in Amazon Braket.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_input::Builder,
    }
    impl<C, M, R> GetDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceInputOperationOutputAlias,
                crate::output::GetDeviceOutput,
                crate::error::GetDeviceError,
                crate::input::GetDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the device to retrieve.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(input.into());
            self
        }
        /// <p>The ARN of the device to retrieve.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// <p>Retrieves the specified Amazon Braket job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_input::Builder,
    }
    impl<C, M, R> GetJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobInputOperationOutputAlias,
                crate::output::GetJobOutput,
                crate::error::GetJobError,
                crate::input::GetJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the job to retrieve.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_arn(input.into());
            self
        }
        /// <p>The ARN of the job to retrieve.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQuantumTask`.
    ///
    /// <p>Retrieves the specified quantum task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQuantumTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_quantum_task_input::Builder,
    }
    impl<C, M, R> GetQuantumTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQuantumTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQuantumTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQuantumTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQuantumTaskInputOperationOutputAlias,
                crate::output::GetQuantumTaskOutput,
                crate::error::GetQuantumTaskError,
                crate::input::GetQuantumTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>the ARN of the task to retrieve.</p>
        pub fn quantum_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quantum_task_arn(input.into());
            self
        }
        /// <p>the ARN of the task to retrieve.</p>
        pub fn set_quantum_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quantum_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Shows the tags associated with this resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the <code>resourceArn</code> for the resource whose tags to display.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Specify the <code>resourceArn</code> for the resource whose tags to display.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchDevices`.
    ///
    /// <p>Searches for devices using the specified filters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_devices_input::Builder,
    }
    impl<C, M, R> SearchDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchDevicesInputOperationOutputAlias,
                crate::output::SearchDevicesOutput,
                crate::error::SearchDevicesError,
                crate::input::SearchDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchDevicesPaginator<C, M, R> {
            crate::paginator::SearchDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filter values to use to search for a device.</p>
        pub fn filters(mut self, input: crate::model::SearchDevicesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filter values to use to search for a device.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchDevicesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchJobs`.
    ///
    /// <p>Searches for Amazon Braket jobs that match the specified filter values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_jobs_input::Builder,
    }
    impl<C, M, R> SearchJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchJobsInputOperationOutputAlias,
                crate::output::SearchJobsOutput,
                crate::error::SearchJobsError,
                crate::input::SearchJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchJobsPaginator<C, M, R> {
            crate::paginator::SearchJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>A token used for pagination of results returned in the response. Use the token returned from the previous request to continue results where the previous request ended.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned in the response. Use the token returned from the previous request to continue results where the previous request ended.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filter values to use when searching for a job.</p>
        pub fn filters(mut self, input: crate::model::SearchJobsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filter values to use when searching for a job.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchJobsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchQuantumTasks`.
    ///
    /// <p>Searches for tasks that match the specified filter values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchQuantumTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_quantum_tasks_input::Builder,
    }
    impl<C, M, R> SearchQuantumTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchQuantumTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchQuantumTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchQuantumTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchQuantumTasksInputOperationOutputAlias,
                crate::output::SearchQuantumTasksOutput,
                crate::error::SearchQuantumTasksError,
                crate::input::SearchQuantumTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchQuantumTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchQuantumTasksPaginator<C, M, R> {
            crate::paginator::SearchQuantumTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned in the response. Use the token returned from the previous request continue results where the previous request ended.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Array of <code>SearchQuantumTasksFilter</code> objects.</p>
        pub fn filters(mut self, input: crate::model::SearchQuantumTasksFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Array of <code>SearchQuantumTasksFilter</code> objects.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchQuantumTasksFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add a tag to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the <code>resourceArn</code> of the resource to which a tag will be added.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Specify the <code>resourceArn</code> of the resource to which a tag will be added.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specify the tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Specify the tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the <code>resourceArn</code> for the resource from which to remove the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Specify the <code>resourceArn</code> for the resource from which to remove the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Specify the keys for the tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Specify the keys for the tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
