// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchQuantumTasksOutput {
    /// <p>An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.</p>
    pub quantum_tasks: std::option::Option<std::vec::Vec<crate::model::QuantumTaskSummary>>,
    /// <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SearchQuantumTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchQuantumTasksOutput");
        formatter.field("quantum_tasks", &self.quantum_tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchQuantumTasksOutput`](crate::output::SearchQuantumTasksOutput)
pub mod search_quantum_tasks_output {
    /// A builder for [`SearchQuantumTasksOutput`](crate::output::SearchQuantumTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantum_tasks:
            std::option::Option<std::vec::Vec<crate::model::QuantumTaskSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `quantum_tasks`.
        ///
        /// To override the contents of this collection use [`set_quantum_tasks`](Self::set_quantum_tasks).
        ///
        /// <p>An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.</p>
        pub fn quantum_tasks(mut self, input: impl Into<crate::model::QuantumTaskSummary>) -> Self {
            let mut v = self.quantum_tasks.unwrap_or_default();
            v.push(input.into());
            self.quantum_tasks = Some(v);
            self
        }
        /// <p>An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.</p>
        pub fn set_quantum_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QuantumTaskSummary>>,
        ) -> Self {
            self.quantum_tasks = input;
            self
        }
        /// <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchQuantumTasksOutput`](crate::output::SearchQuantumTasksOutput)
        pub fn build(self) -> crate::output::SearchQuantumTasksOutput {
            crate::output::SearchQuantumTasksOutput {
                quantum_tasks: self.quantum_tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchQuantumTasksOutput {
    /// Creates a new builder-style object to manufacture [`SearchQuantumTasksOutput`](crate::output::SearchQuantumTasksOutput)
    pub fn builder() -> crate::output::search_quantum_tasks_output::Builder {
        crate::output::search_quantum_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateQuantumTaskOutput {
    /// <p>The ARN of the task created by the request.</p>
    pub quantum_task_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateQuantumTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateQuantumTaskOutput");
        formatter.field("quantum_task_arn", &self.quantum_task_arn);
        formatter.finish()
    }
}
/// See [`CreateQuantumTaskOutput`](crate::output::CreateQuantumTaskOutput)
pub mod create_quantum_task_output {
    /// A builder for [`CreateQuantumTaskOutput`](crate::output::CreateQuantumTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantum_task_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the task created by the request.</p>
        pub fn quantum_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.quantum_task_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the task created by the request.</p>
        pub fn set_quantum_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quantum_task_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQuantumTaskOutput`](crate::output::CreateQuantumTaskOutput)
        pub fn build(self) -> crate::output::CreateQuantumTaskOutput {
            crate::output::CreateQuantumTaskOutput {
                quantum_task_arn: self.quantum_task_arn,
            }
        }
    }
}
impl CreateQuantumTaskOutput {
    /// Creates a new builder-style object to manufacture [`CreateQuantumTaskOutput`](crate::output::CreateQuantumTaskOutput)
    pub fn builder() -> crate::output::create_quantum_task_output::Builder {
        crate::output::create_quantum_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelQuantumTaskOutput {
    /// <p>The ARN of the task.</p>
    pub quantum_task_arn: std::option::Option<std::string::String>,
    /// <p>The status of the cancellation request.</p>
    pub cancellation_status: std::option::Option<crate::model::CancellationStatus>,
}
impl std::fmt::Debug for CancelQuantumTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelQuantumTaskOutput");
        formatter.field("quantum_task_arn", &self.quantum_task_arn);
        formatter.field("cancellation_status", &self.cancellation_status);
        formatter.finish()
    }
}
/// See [`CancelQuantumTaskOutput`](crate::output::CancelQuantumTaskOutput)
pub mod cancel_quantum_task_output {
    /// A builder for [`CancelQuantumTaskOutput`](crate::output::CancelQuantumTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantum_task_arn: std::option::Option<std::string::String>,
        pub(crate) cancellation_status: std::option::Option<crate::model::CancellationStatus>,
    }
    impl Builder {
        /// <p>The ARN of the task.</p>
        pub fn quantum_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.quantum_task_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the task.</p>
        pub fn set_quantum_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quantum_task_arn = input;
            self
        }
        /// <p>The status of the cancellation request.</p>
        pub fn cancellation_status(mut self, input: crate::model::CancellationStatus) -> Self {
            self.cancellation_status = Some(input);
            self
        }
        /// <p>The status of the cancellation request.</p>
        pub fn set_cancellation_status(
            mut self,
            input: std::option::Option<crate::model::CancellationStatus>,
        ) -> Self {
            self.cancellation_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelQuantumTaskOutput`](crate::output::CancelQuantumTaskOutput)
        pub fn build(self) -> crate::output::CancelQuantumTaskOutput {
            crate::output::CancelQuantumTaskOutput {
                quantum_task_arn: self.quantum_task_arn,
                cancellation_status: self.cancellation_status,
            }
        }
    }
}
impl CancelQuantumTaskOutput {
    /// Creates a new builder-style object to manufacture [`CancelQuantumTaskOutput`](crate::output::CancelQuantumTaskOutput)
    pub fn builder() -> crate::output::cancel_quantum_task_output::Builder {
        crate::output::cancel_quantum_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQuantumTaskOutput {
    /// <p>The ARN of the task.</p>
    pub quantum_task_arn: std::option::Option<std::string::String>,
    /// <p>The status of the task.</p>
    pub status: std::option::Option<crate::model::QuantumTaskStatus>,
    /// <p>The reason that a task failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The ARN of the device the task was run on.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The parameters for the device on which the task ran.</p>
    pub device_parameters: std::option::Option<std::string::String>,
    /// <p>The number of shots used in the task.</p>
    pub shots: std::option::Option<i64>,
    /// <p>The S3 bucket where task results are stored.</p>
    pub output_s3_bucket: std::option::Option<std::string::String>,
    /// <p>The folder in the S3 bucket where task results are stored.</p>
    pub output_s3_directory: std::option::Option<std::string::String>,
    /// <p>The time at which the task was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the task ended.</p>
    pub ended_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags that belong to this task.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetQuantumTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQuantumTaskOutput");
        formatter.field("quantum_task_arn", &self.quantum_task_arn);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("device_arn", &self.device_arn);
        formatter.field("device_parameters", &self.device_parameters);
        formatter.field("shots", &self.shots);
        formatter.field("output_s3_bucket", &self.output_s3_bucket);
        formatter.field("output_s3_directory", &self.output_s3_directory);
        formatter.field("created_at", &self.created_at);
        formatter.field("ended_at", &self.ended_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetQuantumTaskOutput`](crate::output::GetQuantumTaskOutput)
pub mod get_quantum_task_output {
    /// A builder for [`GetQuantumTaskOutput`](crate::output::GetQuantumTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantum_task_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::QuantumTaskStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) device_parameters: std::option::Option<std::string::String>,
        pub(crate) shots: std::option::Option<i64>,
        pub(crate) output_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) output_s3_directory: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ended_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the task.</p>
        pub fn quantum_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.quantum_task_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the task.</p>
        pub fn set_quantum_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quantum_task_arn = input;
            self
        }
        /// <p>The status of the task.</p>
        pub fn status(mut self, input: crate::model::QuantumTaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the task.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::QuantumTaskStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason that a task failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason that a task failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The ARN of the device the task was run on.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device the task was run on.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The parameters for the device on which the task ran.</p>
        pub fn device_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_parameters = Some(input.into());
            self
        }
        /// <p>The parameters for the device on which the task ran.</p>
        pub fn set_device_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_parameters = input;
            self
        }
        /// <p>The number of shots used in the task.</p>
        pub fn shots(mut self, input: i64) -> Self {
            self.shots = Some(input);
            self
        }
        /// <p>The number of shots used in the task.</p>
        pub fn set_shots(mut self, input: std::option::Option<i64>) -> Self {
            self.shots = input;
            self
        }
        /// <p>The S3 bucket where task results are stored.</p>
        pub fn output_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket where task results are stored.</p>
        pub fn set_output_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_bucket = input;
            self
        }
        /// <p>The folder in the S3 bucket where task results are stored.</p>
        pub fn output_s3_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_directory = Some(input.into());
            self
        }
        /// <p>The folder in the S3 bucket where task results are stored.</p>
        pub fn set_output_s3_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_directory = input;
            self
        }
        /// <p>The time at which the task was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the task was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the task ended.</p>
        pub fn ended_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ended_at = Some(input);
            self
        }
        /// <p>The time at which the task ended.</p>
        pub fn set_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ended_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that belong to this task.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags that belong to this task.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQuantumTaskOutput`](crate::output::GetQuantumTaskOutput)
        pub fn build(self) -> crate::output::GetQuantumTaskOutput {
            crate::output::GetQuantumTaskOutput {
                quantum_task_arn: self.quantum_task_arn,
                status: self.status,
                failure_reason: self.failure_reason,
                device_arn: self.device_arn,
                device_parameters: self.device_parameters,
                shots: self.shots,
                output_s3_bucket: self.output_s3_bucket,
                output_s3_directory: self.output_s3_directory,
                created_at: self.created_at,
                ended_at: self.ended_at,
                tags: self.tags,
            }
        }
    }
}
impl GetQuantumTaskOutput {
    /// Creates a new builder-style object to manufacture [`GetQuantumTaskOutput`](crate::output::GetQuantumTaskOutput)
    pub fn builder() -> crate::output::get_quantum_task_output::Builder {
        crate::output::get_quantum_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchDevicesOutput {
    /// <p>An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
    /// <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SearchDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchDevicesOutput`](crate::output::SearchDevicesOutput)
pub mod search_devices_output {
    /// A builder for [`SearchDevicesOutput`](crate::output::SearchDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.</p>
        pub fn devices(mut self, input: impl Into<crate::model::DeviceSummary>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results, or null if there are no additional results. Use the token value in a subsequent request to continue results where the previous request ended.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchDevicesOutput`](crate::output::SearchDevicesOutput)
        pub fn build(self) -> crate::output::SearchDevicesOutput {
            crate::output::SearchDevicesOutput {
                devices: self.devices,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchDevicesOutput {
    /// Creates a new builder-style object to manufacture [`SearchDevicesOutput`](crate::output::SearchDevicesOutput)
    pub fn builder() -> crate::output::search_devices_output::Builder {
        crate::output::search_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceOutput {
    /// <p>The ARN of the device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The name of the device.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The name of the partner company for the device.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The type of the device.</p>
    pub device_type: std::option::Option<crate::model::DeviceType>,
    /// <p>The status of the device.</p>
    pub device_status: std::option::Option<crate::model::DeviceStatus>,
    /// <p>Details about the capabilities of the device.</p>
    pub device_capabilities: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceOutput");
        formatter.field("device_arn", &self.device_arn);
        formatter.field("device_name", &self.device_name);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("device_type", &self.device_type);
        formatter.field("device_status", &self.device_status);
        formatter.field("device_capabilities", &self.device_capabilities);
        formatter.finish()
    }
}
/// See [`GetDeviceOutput`](crate::output::GetDeviceOutput)
pub mod get_device_output {
    /// A builder for [`GetDeviceOutput`](crate::output::GetDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<crate::model::DeviceType>,
        pub(crate) device_status: std::option::Option<crate::model::DeviceStatus>,
        pub(crate) device_capabilities: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The name of the device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The name of the partner company for the device.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the partner company for the device.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// <p>The type of the device.</p>
        pub fn device_type(mut self, input: crate::model::DeviceType) -> Self {
            self.device_type = Some(input);
            self
        }
        /// <p>The type of the device.</p>
        pub fn set_device_type(
            mut self,
            input: std::option::Option<crate::model::DeviceType>,
        ) -> Self {
            self.device_type = input;
            self
        }
        /// <p>The status of the device.</p>
        pub fn device_status(mut self, input: crate::model::DeviceStatus) -> Self {
            self.device_status = Some(input);
            self
        }
        /// <p>The status of the device.</p>
        pub fn set_device_status(
            mut self,
            input: std::option::Option<crate::model::DeviceStatus>,
        ) -> Self {
            self.device_status = input;
            self
        }
        /// <p>Details about the capabilities of the device.</p>
        pub fn device_capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_capabilities = Some(input.into());
            self
        }
        /// <p>Details about the capabilities of the device.</p>
        pub fn set_device_capabilities(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceOutput`](crate::output::GetDeviceOutput)
        pub fn build(self) -> crate::output::GetDeviceOutput {
            crate::output::GetDeviceOutput {
                device_arn: self.device_arn,
                device_name: self.device_name,
                provider_name: self.provider_name,
                device_type: self.device_type,
                device_status: self.device_status,
                device_capabilities: self.device_capabilities,
            }
        }
    }
}
impl GetDeviceOutput {
    /// Creates a new builder-style object to manufacture [`GetDeviceOutput`](crate::output::GetDeviceOutput)
    pub fn builder() -> crate::output::get_device_output::Builder {
        crate::output::get_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Displays the key, value pairs of tags associated with this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Displays the key, value pairs of tags associated with this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Displays the key, value pairs of tags associated with this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
