// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_accounts`](crate::client::Client::associate_accounts).
///
/// See [`crate::client::fluent_builders::AssociateAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateAccounts {
    _private: (),
}
impl AssociateAccounts {
    /// Creates a new builder-style object to manufacture [`AssociateAccountsInput`](crate::input::AssociateAccountsInput)
    pub fn builder() -> crate::input::associate_accounts_input::Builder {
        crate::input::associate_accounts_input::Builder::default()
    }
    /// Creates a new `AssociateAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateAccounts {
    type Output = std::result::Result<
        crate::output::AssociateAccountsOutput,
        crate::error::AssociateAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_accounts_error(response)
        } else {
            crate::operation_deser::parse_associate_accounts_response(response)
        }
    }
}

/// Operation shape for `AssociatePricingRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_pricing_rules`](crate::client::Client::associate_pricing_rules).
///
/// See [`crate::client::fluent_builders::AssociatePricingRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePricingRules {
    _private: (),
}
impl AssociatePricingRules {
    /// Creates a new builder-style object to manufacture [`AssociatePricingRulesInput`](crate::input::AssociatePricingRulesInput)
    pub fn builder() -> crate::input::associate_pricing_rules_input::Builder {
        crate::input::associate_pricing_rules_input::Builder::default()
    }
    /// Creates a new `AssociatePricingRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociatePricingRules {
    type Output = std::result::Result<
        crate::output::AssociatePricingRulesOutput,
        crate::error::AssociatePricingRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_pricing_rules_error(response)
        } else {
            crate::operation_deser::parse_associate_pricing_rules_response(response)
        }
    }
}

/// Operation shape for `BatchAssociateResourcesToCustomLineItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_associate_resources_to_custom_line_item`](crate::client::Client::batch_associate_resources_to_custom_line_item).
///
/// See [`crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchAssociateResourcesToCustomLineItem {
    _private: (),
}
impl BatchAssociateResourcesToCustomLineItem {
    /// Creates a new builder-style object to manufacture [`BatchAssociateResourcesToCustomLineItemInput`](crate::input::BatchAssociateResourcesToCustomLineItemInput)
    pub fn builder() -> crate::input::batch_associate_resources_to_custom_line_item_input::Builder {
        crate::input::batch_associate_resources_to_custom_line_item_input::Builder::default()
    }
    /// Creates a new `BatchAssociateResourcesToCustomLineItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchAssociateResourcesToCustomLineItem {
    type Output = std::result::Result<
        crate::output::BatchAssociateResourcesToCustomLineItemOutput,
        crate::error::BatchAssociateResourcesToCustomLineItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_associate_resources_to_custom_line_item_error(
                response,
            )
        } else {
            crate::operation_deser::parse_batch_associate_resources_to_custom_line_item_response(
                response,
            )
        }
    }
}

/// Operation shape for `BatchDisassociateResourcesFromCustomLineItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_disassociate_resources_from_custom_line_item`](crate::client::Client::batch_disassociate_resources_from_custom_line_item).
///
/// See [`crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDisassociateResourcesFromCustomLineItem {
    _private: (),
}
impl BatchDisassociateResourcesFromCustomLineItem {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateResourcesFromCustomLineItemInput`](crate::input::BatchDisassociateResourcesFromCustomLineItemInput)
    pub fn builder(
    ) -> crate::input::batch_disassociate_resources_from_custom_line_item_input::Builder {
        crate::input::batch_disassociate_resources_from_custom_line_item_input::Builder::default()
    }
    /// Creates a new `BatchDisassociateResourcesFromCustomLineItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for BatchDisassociateResourcesFromCustomLineItem
{
    type Output = std::result::Result<
        crate::output::BatchDisassociateResourcesFromCustomLineItemOutput,
        crate::error::BatchDisassociateResourcesFromCustomLineItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_disassociate_resources_from_custom_line_item_error(
                response,
            )
        } else {
            crate::operation_deser::parse_batch_disassociate_resources_from_custom_line_item_response(response)
        }
    }
}

/// Operation shape for `CreateBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_billing_group`](crate::client::Client::create_billing_group).
///
/// See [`crate::client::fluent_builders::CreateBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBillingGroup {
    _private: (),
}
impl CreateBillingGroup {
    /// Creates a new builder-style object to manufacture [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
    pub fn builder() -> crate::input::create_billing_group_input::Builder {
        crate::input::create_billing_group_input::Builder::default()
    }
    /// Creates a new `CreateBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBillingGroup {
    type Output = std::result::Result<
        crate::output::CreateBillingGroupOutput,
        crate::error::CreateBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_billing_group_error(response)
        } else {
            crate::operation_deser::parse_create_billing_group_response(response)
        }
    }
}

/// Operation shape for `CreateCustomLineItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_line_item`](crate::client::Client::create_custom_line_item).
///
/// See [`crate::client::fluent_builders::CreateCustomLineItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomLineItem {
    _private: (),
}
impl CreateCustomLineItem {
    /// Creates a new builder-style object to manufacture [`CreateCustomLineItemInput`](crate::input::CreateCustomLineItemInput)
    pub fn builder() -> crate::input::create_custom_line_item_input::Builder {
        crate::input::create_custom_line_item_input::Builder::default()
    }
    /// Creates a new `CreateCustomLineItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomLineItem {
    type Output = std::result::Result<
        crate::output::CreateCustomLineItemOutput,
        crate::error::CreateCustomLineItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_line_item_error(response)
        } else {
            crate::operation_deser::parse_create_custom_line_item_response(response)
        }
    }
}

/// Operation shape for `CreatePricingPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pricing_plan`](crate::client::Client::create_pricing_plan).
///
/// See [`crate::client::fluent_builders::CreatePricingPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePricingPlan {
    _private: (),
}
impl CreatePricingPlan {
    /// Creates a new builder-style object to manufacture [`CreatePricingPlanInput`](crate::input::CreatePricingPlanInput)
    pub fn builder() -> crate::input::create_pricing_plan_input::Builder {
        crate::input::create_pricing_plan_input::Builder::default()
    }
    /// Creates a new `CreatePricingPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePricingPlan {
    type Output = std::result::Result<
        crate::output::CreatePricingPlanOutput,
        crate::error::CreatePricingPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_pricing_plan_error(response)
        } else {
            crate::operation_deser::parse_create_pricing_plan_response(response)
        }
    }
}

/// Operation shape for `CreatePricingRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pricing_rule`](crate::client::Client::create_pricing_rule).
///
/// See [`crate::client::fluent_builders::CreatePricingRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePricingRule {
    _private: (),
}
impl CreatePricingRule {
    /// Creates a new builder-style object to manufacture [`CreatePricingRuleInput`](crate::input::CreatePricingRuleInput)
    pub fn builder() -> crate::input::create_pricing_rule_input::Builder {
        crate::input::create_pricing_rule_input::Builder::default()
    }
    /// Creates a new `CreatePricingRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePricingRule {
    type Output = std::result::Result<
        crate::output::CreatePricingRuleOutput,
        crate::error::CreatePricingRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_pricing_rule_error(response)
        } else {
            crate::operation_deser::parse_create_pricing_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_billing_group`](crate::client::Client::delete_billing_group).
///
/// See [`crate::client::fluent_builders::DeleteBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBillingGroup {
    _private: (),
}
impl DeleteBillingGroup {
    /// Creates a new builder-style object to manufacture [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
    pub fn builder() -> crate::input::delete_billing_group_input::Builder {
        crate::input::delete_billing_group_input::Builder::default()
    }
    /// Creates a new `DeleteBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBillingGroup {
    type Output = std::result::Result<
        crate::output::DeleteBillingGroupOutput,
        crate::error::DeleteBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_billing_group_error(response)
        } else {
            crate::operation_deser::parse_delete_billing_group_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomLineItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_line_item`](crate::client::Client::delete_custom_line_item).
///
/// See [`crate::client::fluent_builders::DeleteCustomLineItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomLineItem {
    _private: (),
}
impl DeleteCustomLineItem {
    /// Creates a new builder-style object to manufacture [`DeleteCustomLineItemInput`](crate::input::DeleteCustomLineItemInput)
    pub fn builder() -> crate::input::delete_custom_line_item_input::Builder {
        crate::input::delete_custom_line_item_input::Builder::default()
    }
    /// Creates a new `DeleteCustomLineItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomLineItem {
    type Output = std::result::Result<
        crate::output::DeleteCustomLineItemOutput,
        crate::error::DeleteCustomLineItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_line_item_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_line_item_response(response)
        }
    }
}

/// Operation shape for `DeletePricingPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pricing_plan`](crate::client::Client::delete_pricing_plan).
///
/// See [`crate::client::fluent_builders::DeletePricingPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePricingPlan {
    _private: (),
}
impl DeletePricingPlan {
    /// Creates a new builder-style object to manufacture [`DeletePricingPlanInput`](crate::input::DeletePricingPlanInput)
    pub fn builder() -> crate::input::delete_pricing_plan_input::Builder {
        crate::input::delete_pricing_plan_input::Builder::default()
    }
    /// Creates a new `DeletePricingPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePricingPlan {
    type Output = std::result::Result<
        crate::output::DeletePricingPlanOutput,
        crate::error::DeletePricingPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_pricing_plan_error(response)
        } else {
            crate::operation_deser::parse_delete_pricing_plan_response(response)
        }
    }
}

/// Operation shape for `DeletePricingRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pricing_rule`](crate::client::Client::delete_pricing_rule).
///
/// See [`crate::client::fluent_builders::DeletePricingRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePricingRule {
    _private: (),
}
impl DeletePricingRule {
    /// Creates a new builder-style object to manufacture [`DeletePricingRuleInput`](crate::input::DeletePricingRuleInput)
    pub fn builder() -> crate::input::delete_pricing_rule_input::Builder {
        crate::input::delete_pricing_rule_input::Builder::default()
    }
    /// Creates a new `DeletePricingRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePricingRule {
    type Output = std::result::Result<
        crate::output::DeletePricingRuleOutput,
        crate::error::DeletePricingRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_pricing_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_pricing_rule_response(response)
        }
    }
}

/// Operation shape for `DisassociateAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_accounts`](crate::client::Client::disassociate_accounts).
///
/// See [`crate::client::fluent_builders::DisassociateAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateAccounts {
    _private: (),
}
impl DisassociateAccounts {
    /// Creates a new builder-style object to manufacture [`DisassociateAccountsInput`](crate::input::DisassociateAccountsInput)
    pub fn builder() -> crate::input::disassociate_accounts_input::Builder {
        crate::input::disassociate_accounts_input::Builder::default()
    }
    /// Creates a new `DisassociateAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateAccounts {
    type Output = std::result::Result<
        crate::output::DisassociateAccountsOutput,
        crate::error::DisassociateAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_accounts_error(response)
        } else {
            crate::operation_deser::parse_disassociate_accounts_response(response)
        }
    }
}

/// Operation shape for `DisassociatePricingRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_pricing_rules`](crate::client::Client::disassociate_pricing_rules).
///
/// See [`crate::client::fluent_builders::DisassociatePricingRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociatePricingRules {
    _private: (),
}
impl DisassociatePricingRules {
    /// Creates a new builder-style object to manufacture [`DisassociatePricingRulesInput`](crate::input::DisassociatePricingRulesInput)
    pub fn builder() -> crate::input::disassociate_pricing_rules_input::Builder {
        crate::input::disassociate_pricing_rules_input::Builder::default()
    }
    /// Creates a new `DisassociatePricingRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociatePricingRules {
    type Output = std::result::Result<
        crate::output::DisassociatePricingRulesOutput,
        crate::error::DisassociatePricingRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_pricing_rules_error(response)
        } else {
            crate::operation_deser::parse_disassociate_pricing_rules_response(response)
        }
    }
}

/// Operation shape for `ListAccountAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_account_associations`](crate::client::Client::list_account_associations).
///
/// See [`crate::client::fluent_builders::ListAccountAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountAssociations {
    _private: (),
}
impl ListAccountAssociations {
    /// Creates a new builder-style object to manufacture [`ListAccountAssociationsInput`](crate::input::ListAccountAssociationsInput)
    pub fn builder() -> crate::input::list_account_associations_input::Builder {
        crate::input::list_account_associations_input::Builder::default()
    }
    /// Creates a new `ListAccountAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountAssociations {
    type Output = std::result::Result<
        crate::output::ListAccountAssociationsOutput,
        crate::error::ListAccountAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_account_associations_error(response)
        } else {
            crate::operation_deser::parse_list_account_associations_response(response)
        }
    }
}

/// Operation shape for `ListBillingGroupCostReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_billing_group_cost_reports`](crate::client::Client::list_billing_group_cost_reports).
///
/// See [`crate::client::fluent_builders::ListBillingGroupCostReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBillingGroupCostReports {
    _private: (),
}
impl ListBillingGroupCostReports {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupCostReportsInput`](crate::input::ListBillingGroupCostReportsInput)
    pub fn builder() -> crate::input::list_billing_group_cost_reports_input::Builder {
        crate::input::list_billing_group_cost_reports_input::Builder::default()
    }
    /// Creates a new `ListBillingGroupCostReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBillingGroupCostReports {
    type Output = std::result::Result<
        crate::output::ListBillingGroupCostReportsOutput,
        crate::error::ListBillingGroupCostReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_billing_group_cost_reports_error(response)
        } else {
            crate::operation_deser::parse_list_billing_group_cost_reports_response(response)
        }
    }
}

/// Operation shape for `ListBillingGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_billing_groups`](crate::client::Client::list_billing_groups).
///
/// See [`crate::client::fluent_builders::ListBillingGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBillingGroups {
    _private: (),
}
impl ListBillingGroups {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupsInput`](crate::input::ListBillingGroupsInput)
    pub fn builder() -> crate::input::list_billing_groups_input::Builder {
        crate::input::list_billing_groups_input::Builder::default()
    }
    /// Creates a new `ListBillingGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBillingGroups {
    type Output = std::result::Result<
        crate::output::ListBillingGroupsOutput,
        crate::error::ListBillingGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_billing_groups_error(response)
        } else {
            crate::operation_deser::parse_list_billing_groups_response(response)
        }
    }
}

/// Operation shape for `ListCustomLineItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_line_items`](crate::client::Client::list_custom_line_items).
///
/// See [`crate::client::fluent_builders::ListCustomLineItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomLineItems {
    _private: (),
}
impl ListCustomLineItems {
    /// Creates a new builder-style object to manufacture [`ListCustomLineItemsInput`](crate::input::ListCustomLineItemsInput)
    pub fn builder() -> crate::input::list_custom_line_items_input::Builder {
        crate::input::list_custom_line_items_input::Builder::default()
    }
    /// Creates a new `ListCustomLineItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomLineItems {
    type Output = std::result::Result<
        crate::output::ListCustomLineItemsOutput,
        crate::error::ListCustomLineItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_line_items_error(response)
        } else {
            crate::operation_deser::parse_list_custom_line_items_response(response)
        }
    }
}

/// Operation shape for `ListPricingPlans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pricing_plans`](crate::client::Client::list_pricing_plans).
///
/// See [`crate::client::fluent_builders::ListPricingPlans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPricingPlans {
    _private: (),
}
impl ListPricingPlans {
    /// Creates a new builder-style object to manufacture [`ListPricingPlansInput`](crate::input::ListPricingPlansInput)
    pub fn builder() -> crate::input::list_pricing_plans_input::Builder {
        crate::input::list_pricing_plans_input::Builder::default()
    }
    /// Creates a new `ListPricingPlans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPricingPlans {
    type Output = std::result::Result<
        crate::output::ListPricingPlansOutput,
        crate::error::ListPricingPlansError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pricing_plans_error(response)
        } else {
            crate::operation_deser::parse_list_pricing_plans_response(response)
        }
    }
}

/// Operation shape for `ListPricingPlansAssociatedWithPricingRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pricing_plans_associated_with_pricing_rule`](crate::client::Client::list_pricing_plans_associated_with_pricing_rule).
///
/// See [`crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPricingPlansAssociatedWithPricingRule {
    _private: (),
}
impl ListPricingPlansAssociatedWithPricingRule {
    /// Creates a new builder-style object to manufacture [`ListPricingPlansAssociatedWithPricingRuleInput`](crate::input::ListPricingPlansAssociatedWithPricingRuleInput)
    pub fn builder() -> crate::input::list_pricing_plans_associated_with_pricing_rule_input::Builder
    {
        crate::input::list_pricing_plans_associated_with_pricing_rule_input::Builder::default()
    }
    /// Creates a new `ListPricingPlansAssociatedWithPricingRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPricingPlansAssociatedWithPricingRule {
    type Output = std::result::Result<
        crate::output::ListPricingPlansAssociatedWithPricingRuleOutput,
        crate::error::ListPricingPlansAssociatedWithPricingRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pricing_plans_associated_with_pricing_rule_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_pricing_plans_associated_with_pricing_rule_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListPricingRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pricing_rules`](crate::client::Client::list_pricing_rules).
///
/// See [`crate::client::fluent_builders::ListPricingRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPricingRules {
    _private: (),
}
impl ListPricingRules {
    /// Creates a new builder-style object to manufacture [`ListPricingRulesInput`](crate::input::ListPricingRulesInput)
    pub fn builder() -> crate::input::list_pricing_rules_input::Builder {
        crate::input::list_pricing_rules_input::Builder::default()
    }
    /// Creates a new `ListPricingRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPricingRules {
    type Output = std::result::Result<
        crate::output::ListPricingRulesOutput,
        crate::error::ListPricingRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pricing_rules_error(response)
        } else {
            crate::operation_deser::parse_list_pricing_rules_response(response)
        }
    }
}

/// Operation shape for `ListPricingRulesAssociatedToPricingPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pricing_rules_associated_to_pricing_plan`](crate::client::Client::list_pricing_rules_associated_to_pricing_plan).
///
/// See [`crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPricingRulesAssociatedToPricingPlan {
    _private: (),
}
impl ListPricingRulesAssociatedToPricingPlan {
    /// Creates a new builder-style object to manufacture [`ListPricingRulesAssociatedToPricingPlanInput`](crate::input::ListPricingRulesAssociatedToPricingPlanInput)
    pub fn builder() -> crate::input::list_pricing_rules_associated_to_pricing_plan_input::Builder {
        crate::input::list_pricing_rules_associated_to_pricing_plan_input::Builder::default()
    }
    /// Creates a new `ListPricingRulesAssociatedToPricingPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPricingRulesAssociatedToPricingPlan {
    type Output = std::result::Result<
        crate::output::ListPricingRulesAssociatedToPricingPlanOutput,
        crate::error::ListPricingRulesAssociatedToPricingPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pricing_rules_associated_to_pricing_plan_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_pricing_rules_associated_to_pricing_plan_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListResourcesAssociatedToCustomLineItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resources_associated_to_custom_line_item`](crate::client::Client::list_resources_associated_to_custom_line_item).
///
/// See [`crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourcesAssociatedToCustomLineItem {
    _private: (),
}
impl ListResourcesAssociatedToCustomLineItem {
    /// Creates a new builder-style object to manufacture [`ListResourcesAssociatedToCustomLineItemInput`](crate::input::ListResourcesAssociatedToCustomLineItemInput)
    pub fn builder() -> crate::input::list_resources_associated_to_custom_line_item_input::Builder {
        crate::input::list_resources_associated_to_custom_line_item_input::Builder::default()
    }
    /// Creates a new `ListResourcesAssociatedToCustomLineItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourcesAssociatedToCustomLineItem {
    type Output = std::result::Result<
        crate::output::ListResourcesAssociatedToCustomLineItemOutput,
        crate::error::ListResourcesAssociatedToCustomLineItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resources_associated_to_custom_line_item_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_resources_associated_to_custom_line_item_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_billing_group`](crate::client::Client::update_billing_group).
///
/// See [`crate::client::fluent_builders::UpdateBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBillingGroup {
    _private: (),
}
impl UpdateBillingGroup {
    /// Creates a new builder-style object to manufacture [`UpdateBillingGroupInput`](crate::input::UpdateBillingGroupInput)
    pub fn builder() -> crate::input::update_billing_group_input::Builder {
        crate::input::update_billing_group_input::Builder::default()
    }
    /// Creates a new `UpdateBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBillingGroup {
    type Output = std::result::Result<
        crate::output::UpdateBillingGroupOutput,
        crate::error::UpdateBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_billing_group_error(response)
        } else {
            crate::operation_deser::parse_update_billing_group_response(response)
        }
    }
}

/// Operation shape for `UpdateCustomLineItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_custom_line_item`](crate::client::Client::update_custom_line_item).
///
/// See [`crate::client::fluent_builders::UpdateCustomLineItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCustomLineItem {
    _private: (),
}
impl UpdateCustomLineItem {
    /// Creates a new builder-style object to manufacture [`UpdateCustomLineItemInput`](crate::input::UpdateCustomLineItemInput)
    pub fn builder() -> crate::input::update_custom_line_item_input::Builder {
        crate::input::update_custom_line_item_input::Builder::default()
    }
    /// Creates a new `UpdateCustomLineItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCustomLineItem {
    type Output = std::result::Result<
        crate::output::UpdateCustomLineItemOutput,
        crate::error::UpdateCustomLineItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_custom_line_item_error(response)
        } else {
            crate::operation_deser::parse_update_custom_line_item_response(response)
        }
    }
}

/// Operation shape for `UpdatePricingPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pricing_plan`](crate::client::Client::update_pricing_plan).
///
/// See [`crate::client::fluent_builders::UpdatePricingPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePricingPlan {
    _private: (),
}
impl UpdatePricingPlan {
    /// Creates a new builder-style object to manufacture [`UpdatePricingPlanInput`](crate::input::UpdatePricingPlanInput)
    pub fn builder() -> crate::input::update_pricing_plan_input::Builder {
        crate::input::update_pricing_plan_input::Builder::default()
    }
    /// Creates a new `UpdatePricingPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePricingPlan {
    type Output = std::result::Result<
        crate::output::UpdatePricingPlanOutput,
        crate::error::UpdatePricingPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pricing_plan_error(response)
        } else {
            crate::operation_deser::parse_update_pricing_plan_response(response)
        }
    }
}

/// Operation shape for `UpdatePricingRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pricing_rule`](crate::client::Client::update_pricing_rule).
///
/// See [`crate::client::fluent_builders::UpdatePricingRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePricingRule {
    _private: (),
}
impl UpdatePricingRule {
    /// Creates a new builder-style object to manufacture [`UpdatePricingRuleInput`](crate::input::UpdatePricingRuleInput)
    pub fn builder() -> crate::input::update_pricing_rule_input::Builder {
        crate::input::update_pricing_rule_input::Builder::default()
    }
    /// Creates a new `UpdatePricingRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePricingRule {
    type Output = std::result::Result<
        crate::output::UpdatePricingRuleOutput,
        crate::error::UpdatePricingRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pricing_rule_error(response)
        } else {
            crate::operation_deser::parse_update_pricing_rule_response(response)
        }
    }
}
