// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateAccountsInput`](crate::input::AssociateAccountsInput)
pub mod associate_accounts_input {
    /// A builder for [`AssociateAccountsInput`](crate::input::AssociateAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p> The associating array of account IDs. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p> The associating array of account IDs. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAccountsInput`](crate::input::AssociateAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateAccountsInput {
                arn: self.arn,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateAccountsInputOperationOutputAlias = crate::operation::AssociateAccounts;
#[doc(hidden)]
pub type AssociateAccountsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateAccountsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateAccounts`](crate::operation::AssociateAccounts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateAccounts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateAccountsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/associate-accounts").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateAccountsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_accounts(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateAccounts",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateAccountsInput`](crate::input::AssociateAccountsInput)
    pub fn builder() -> crate::input::associate_accounts_input::Builder {
        crate::input::associate_accounts_input::Builder::default()
    }
}

/// See [`AssociatePricingRulesInput`](crate::input::AssociatePricingRulesInput)
pub mod associate_pricing_rules_input {
    /// A builder for [`AssociatePricingRulesInput`](crate::input::AssociatePricingRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `pricing_rule_arns`.
        ///
        /// To override the contents of this collection use [`set_pricing_rule_arns`](Self::set_pricing_rule_arns).
        ///
        /// <p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>
        pub fn pricing_rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pricing_rule_arns.unwrap_or_default();
            v.push(input.into());
            self.pricing_rule_arns = Some(v);
            self
        }
        /// <p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>
        pub fn set_pricing_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pricing_rule_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePricingRulesInput`](crate::input::AssociatePricingRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePricingRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociatePricingRulesInput {
                arn: self.arn,
                pricing_rule_arns: self.pricing_rule_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociatePricingRulesInputOperationOutputAlias = crate::operation::AssociatePricingRules;
#[doc(hidden)]
pub type AssociatePricingRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePricingRulesInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePricingRules`](crate::operation::AssociatePricingRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePricingRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociatePricingRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/associate-pricing-rules").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociatePricingRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_pricing_rules(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePricingRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePricingRules",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociatePricingRulesInput`](crate::input::AssociatePricingRulesInput)
    pub fn builder() -> crate::input::associate_pricing_rules_input::Builder {
        crate::input::associate_pricing_rules_input::Builder::default()
    }
}

/// See [`BatchAssociateResourcesToCustomLineItemInput`](crate::input::BatchAssociateResourcesToCustomLineItemInput)
pub mod batch_associate_resources_to_custom_line_item_input {
    /// A builder for [`BatchAssociateResourcesToCustomLineItemInput`](crate::input::BatchAssociateResourcesToCustomLineItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) billing_period_range:
            std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
    }
    impl Builder {
        /// <p> A percentage custom line item ARN to associate the resources to. </p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p> A percentage custom line item ARN to associate the resources to. </p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p> A list containing the ARNs of the resources to be associated. </p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p> A list containing the ARNs of the resources to be associated. </p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.billing_period_range = Some(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.billing_period_range = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateResourcesToCustomLineItemInput`](crate::input::BatchAssociateResourcesToCustomLineItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAssociateResourcesToCustomLineItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchAssociateResourcesToCustomLineItemInput {
                target_arn: self.target_arn,
                resource_arns: self.resource_arns,
                billing_period_range: self.billing_period_range,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchAssociateResourcesToCustomLineItemInputOperationOutputAlias =
    crate::operation::BatchAssociateResourcesToCustomLineItem;
#[doc(hidden)]
pub type BatchAssociateResourcesToCustomLineItemInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchAssociateResourcesToCustomLineItemInput {
    /// Consumes the builder and constructs an Operation<[`BatchAssociateResourcesToCustomLineItem`](crate::operation::BatchAssociateResourcesToCustomLineItem)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAssociateResourcesToCustomLineItem,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchAssociateResourcesToCustomLineItemInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/batch-associate-resources-to-custom-line-item")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchAssociateResourcesToCustomLineItemInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_associate_resources_to_custom_line_item(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAssociateResourcesToCustomLineItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAssociateResourcesToCustomLineItem",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchAssociateResourcesToCustomLineItemInput`](crate::input::BatchAssociateResourcesToCustomLineItemInput)
    pub fn builder() -> crate::input::batch_associate_resources_to_custom_line_item_input::Builder {
        crate::input::batch_associate_resources_to_custom_line_item_input::Builder::default()
    }
}

/// See [`BatchDisassociateResourcesFromCustomLineItemInput`](crate::input::BatchDisassociateResourcesFromCustomLineItemInput)
pub mod batch_disassociate_resources_from_custom_line_item_input {
    /// A builder for [`BatchDisassociateResourcesFromCustomLineItemInput`](crate::input::BatchDisassociateResourcesFromCustomLineItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) billing_period_range:
            std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
    }
    impl Builder {
        /// <p> A percentage custom line item ARN to disassociate the resources from. </p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p> A percentage custom line item ARN to disassociate the resources from. </p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p> A list containing the ARNs of resources to be disassociated. </p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p> A list containing the ARNs of resources to be disassociated. </p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.billing_period_range = Some(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.billing_period_range = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateResourcesFromCustomLineItemInput`](crate::input::BatchDisassociateResourcesFromCustomLineItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisassociateResourcesFromCustomLineItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchDisassociateResourcesFromCustomLineItemInput {
                    target_arn: self.target_arn,
                    resource_arns: self.resource_arns,
                    billing_period_range: self.billing_period_range,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchDisassociateResourcesFromCustomLineItemInputOperationOutputAlias =
    crate::operation::BatchDisassociateResourcesFromCustomLineItem;
#[doc(hidden)]
pub type BatchDisassociateResourcesFromCustomLineItemInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchDisassociateResourcesFromCustomLineItemInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisassociateResourcesFromCustomLineItem`](crate::operation::BatchDisassociateResourcesFromCustomLineItem)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisassociateResourcesFromCustomLineItem,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchDisassociateResourcesFromCustomLineItemInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(
                    output,
                    "/batch-disassociate-resources-from-custom-line-item"
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchDisassociateResourcesFromCustomLineItemInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_disassociate_resources_from_custom_line_item(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisassociateResourcesFromCustomLineItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisassociateResourcesFromCustomLineItem",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchDisassociateResourcesFromCustomLineItemInput`](crate::input::BatchDisassociateResourcesFromCustomLineItemInput)
    pub fn builder(
    ) -> crate::input::batch_disassociate_resources_from_custom_line_item_input::Builder {
        crate::input::batch_disassociate_resources_from_custom_line_item_input::Builder::default()
    }
}

/// See [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
pub mod create_billing_group_input {
    /// A builder for [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) account_grouping: std::option::Option<crate::model::AccountGrouping>,
        pub(crate) computation_preference: std::option::Option<crate::model::ComputationPreference>,
        pub(crate) primary_account_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p> The billing group name. The names must be unique. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The billing group name. The names must be unique. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
        pub fn account_grouping(mut self, input: crate::model::AccountGrouping) -> Self {
            self.account_grouping = Some(input);
            self
        }
        /// <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
        pub fn set_account_grouping(
            mut self,
            input: std::option::Option<crate::model::AccountGrouping>,
        ) -> Self {
            self.account_grouping = input;
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn computation_preference(
            mut self,
            input: crate::model::ComputationPreference,
        ) -> Self {
            self.computation_preference = Some(input);
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn set_computation_preference(
            mut self,
            input: std::option::Option<crate::model::ComputationPreference>,
        ) -> Self {
            self.computation_preference = input;
            self
        }
        /// <p> The account ID that serves as the main account in a billing group. </p>
        pub fn primary_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_account_id = Some(input.into());
            self
        }
        /// <p> The account ID that serves as the main account in a billing group. </p>
        pub fn set_primary_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_account_id = input;
            self
        }
        /// <p>The billing group description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The billing group description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBillingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBillingGroupInput {
                client_token: self.client_token,
                name: self.name,
                account_grouping: self.account_grouping,
                computation_preference: self.computation_preference,
                primary_account_id: self.primary_account_id,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBillingGroupInputOperationOutputAlias = crate::operation::CreateBillingGroup;
#[doc(hidden)]
pub type CreateBillingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBillingGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateBillingGroup`](crate::operation::CreateBillingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBillingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBillingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/create-billing-group").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBillingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_billing_group(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_billing_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBillingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBillingGroup",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
    pub fn builder() -> crate::input::create_billing_group_input::Builder {
        crate::input::create_billing_group_input::Builder::default()
    }
}

/// See [`CreateCustomLineItemInput`](crate::input::CreateCustomLineItemInput)
pub mod create_custom_line_item_input {
    /// A builder for [`CreateCustomLineItemInput`](crate::input::CreateCustomLineItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) billing_group_arn: std::option::Option<std::string::String>,
        pub(crate) billing_period_range:
            std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) charge_details: std::option::Option<crate::model::CustomLineItemChargeDetails>,
    }
    impl Builder {
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p> The name of the custom line item. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the custom line item. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_arn = input;
            self
        }
        /// <p> A time range for which the custom line item is effective. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.billing_period_range = Some(input);
            self
        }
        /// <p> A time range for which the custom line item is effective. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.billing_period_range = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a custom line item. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a custom line item. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>
        pub fn charge_details(mut self, input: crate::model::CustomLineItemChargeDetails) -> Self {
            self.charge_details = Some(input);
            self
        }
        /// <p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>
        pub fn set_charge_details(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemChargeDetails>,
        ) -> Self {
            self.charge_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomLineItemInput`](crate::input::CreateCustomLineItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomLineItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomLineItemInput {
                client_token: self.client_token,
                name: self.name,
                description: self.description,
                billing_group_arn: self.billing_group_arn,
                billing_period_range: self.billing_period_range,
                tags: self.tags,
                charge_details: self.charge_details,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomLineItemInputOperationOutputAlias = crate::operation::CreateCustomLineItem;
#[doc(hidden)]
pub type CreateCustomLineItemInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCustomLineItemInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomLineItem`](crate::operation::CreateCustomLineItem)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomLineItem,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCustomLineItemInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/create-custom-line-item").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCustomLineItemInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_create_custom_line_item(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_custom_line_item(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomLineItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomLineItem",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomLineItemInput`](crate::input::CreateCustomLineItemInput)
    pub fn builder() -> crate::input::create_custom_line_item_input::Builder {
        crate::input::create_custom_line_item_input::Builder::default()
    }
}

/// See [`CreatePricingPlanInput`](crate::input::CreatePricingPlanInput)
pub mod create_pricing_plan_input {
    /// A builder for [`CreatePricingPlanInput`](crate::input::CreatePricingPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The pricing plan name. The names must be unique to each pricing plan. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The pricing plan name. The names must be unique to each pricing plan. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `pricing_rule_arns`.
        ///
        /// To override the contents of this collection use [`set_pricing_rule_arns`](Self::set_pricing_rule_arns).
        ///
        /// <p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>
        pub fn pricing_rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pricing_rule_arns.unwrap_or_default();
            v.push(input.into());
            self.pricing_rule_arns = Some(v);
            self
        }
        /// <p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>
        pub fn set_pricing_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pricing_rule_arns = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePricingPlanInput`](crate::input::CreatePricingPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePricingPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePricingPlanInput {
                client_token: self.client_token,
                name: self.name,
                description: self.description,
                pricing_rule_arns: self.pricing_rule_arns,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePricingPlanInputOperationOutputAlias = crate::operation::CreatePricingPlan;
#[doc(hidden)]
pub type CreatePricingPlanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePricingPlanInput {
    /// Consumes the builder and constructs an Operation<[`CreatePricingPlan`](crate::operation::CreatePricingPlan)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePricingPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePricingPlanInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/create-pricing-plan").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePricingPlanInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_pricing_plan(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_pricing_plan(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePricingPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePricingPlan",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePricingPlanInput`](crate::input::CreatePricingPlanInput)
    pub fn builder() -> crate::input::create_pricing_plan_input::Builder {
        crate::input::create_pricing_plan_input::Builder::default()
    }
}

/// See [`CreatePricingRuleInput`](crate::input::CreatePricingRuleInput)
pub mod create_pricing_rule_input {
    /// A builder for [`CreatePricingRuleInput`](crate::input::CreatePricingRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) scope: std::option::Option<crate::model::PricingRuleScope>,
        pub(crate) r#type: std::option::Option<crate::model::PricingRuleType>,
        pub(crate) modifier_percentage: std::option::Option<f64>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p> The pricing rule name. The names must be unique to each pricing rule. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The pricing rule name. The names must be unique to each pricing rule. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The pricing rule description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The pricing rule description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
        pub fn scope(mut self, input: crate::model::PricingRuleScope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::PricingRuleScope>,
        ) -> Self {
            self.scope = input;
            self
        }
        /// <p> The type of pricing rule. </p>
        pub fn r#type(mut self, input: crate::model::PricingRuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of pricing rule. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PricingRuleType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p> A percentage modifier applied on the public pricing rates. </p>
        pub fn modifier_percentage(mut self, input: f64) -> Self {
            self.modifier_percentage = Some(input);
            self
        }
        /// <p> A percentage modifier applied on the public pricing rates. </p>
        pub fn set_modifier_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.modifier_percentage = input;
            self
        }
        /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePricingRuleInput`](crate::input::CreatePricingRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePricingRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePricingRuleInput {
                client_token: self.client_token,
                name: self.name,
                description: self.description,
                scope: self.scope,
                r#type: self.r#type,
                modifier_percentage: self.modifier_percentage,
                service: self.service,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePricingRuleInputOperationOutputAlias = crate::operation::CreatePricingRule;
#[doc(hidden)]
pub type CreatePricingRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePricingRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreatePricingRule`](crate::operation::CreatePricingRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePricingRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePricingRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/create-pricing-rule").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePricingRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_pricing_rule(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_pricing_rule(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePricingRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePricingRule",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePricingRuleInput`](crate::input::CreatePricingRuleInput)
    pub fn builder() -> crate::input::create_pricing_rule_input::Builder {
        crate::input::create_pricing_rule_input::Builder::default()
    }
}

/// See [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
pub mod delete_billing_group_input {
    /// A builder for [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the billing group you're deleting.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group you're deleting.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBillingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBillingGroupInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteBillingGroupInputOperationOutputAlias = crate::operation::DeleteBillingGroup;
#[doc(hidden)]
pub type DeleteBillingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBillingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBillingGroup`](crate::operation::DeleteBillingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBillingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBillingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/delete-billing-group").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBillingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_billing_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBillingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBillingGroup",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
    pub fn builder() -> crate::input::delete_billing_group_input::Builder {
        crate::input::delete_billing_group_input::Builder::default()
    }
}

/// See [`DeleteCustomLineItemInput`](crate::input::DeleteCustomLineItemInput)
pub mod delete_custom_line_item_input {
    /// A builder for [`DeleteCustomLineItemInput`](crate::input::DeleteCustomLineItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) billing_period_range:
            std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
    }
    impl Builder {
        /// <p> The ARN of the custom line item to be deleted. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the custom line item to be deleted. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.billing_period_range = Some(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.billing_period_range = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomLineItemInput`](crate::input::DeleteCustomLineItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomLineItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomLineItemInput {
                arn: self.arn,
                billing_period_range: self.billing_period_range,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomLineItemInputOperationOutputAlias = crate::operation::DeleteCustomLineItem;
#[doc(hidden)]
pub type DeleteCustomLineItemInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCustomLineItemInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomLineItem`](crate::operation::DeleteCustomLineItem)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomLineItem,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCustomLineItemInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/delete-custom-line-item").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCustomLineItemInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_custom_line_item(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomLineItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomLineItem",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomLineItemInput`](crate::input::DeleteCustomLineItemInput)
    pub fn builder() -> crate::input::delete_custom_line_item_input::Builder {
        crate::input::delete_custom_line_item_input::Builder::default()
    }
}

/// See [`DeletePricingPlanInput`](crate::input::DeletePricingPlanInput)
pub mod delete_pricing_plan_input {
    /// A builder for [`DeletePricingPlanInput`](crate::input::DeletePricingPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're deleting. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're deleting. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePricingPlanInput`](crate::input::DeletePricingPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePricingPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePricingPlanInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeletePricingPlanInputOperationOutputAlias = crate::operation::DeletePricingPlan;
#[doc(hidden)]
pub type DeletePricingPlanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePricingPlanInput {
    /// Consumes the builder and constructs an Operation<[`DeletePricingPlan`](crate::operation::DeletePricingPlan)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePricingPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePricingPlanInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/delete-pricing-plan").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePricingPlanInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_pricing_plan(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePricingPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePricingPlan",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePricingPlanInput`](crate::input::DeletePricingPlanInput)
    pub fn builder() -> crate::input::delete_pricing_plan_input::Builder {
        crate::input::delete_pricing_plan_input::Builder::default()
    }
}

/// See [`DeletePricingRuleInput`](crate::input::DeletePricingRuleInput)
pub mod delete_pricing_rule_input {
    /// A builder for [`DeletePricingRuleInput`](crate::input::DeletePricingRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePricingRuleInput`](crate::input::DeletePricingRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePricingRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePricingRuleInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeletePricingRuleInputOperationOutputAlias = crate::operation::DeletePricingRule;
#[doc(hidden)]
pub type DeletePricingRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePricingRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeletePricingRule`](crate::operation::DeletePricingRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePricingRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePricingRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/delete-pricing-rule").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePricingRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_pricing_rule(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePricingRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePricingRule",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePricingRuleInput`](crate::input::DeletePricingRuleInput)
    pub fn builder() -> crate::input::delete_pricing_rule_input::Builder {
        crate::input::delete_pricing_rule_input::Builder::default()
    }
}

/// See [`DisassociateAccountsInput`](crate::input::DisassociateAccountsInput)
pub mod disassociate_accounts_input {
    /// A builder for [`DisassociateAccountsInput`](crate::input::DisassociateAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The array of account IDs to disassociate. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The array of account IDs to disassociate. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateAccountsInput`](crate::input::DisassociateAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateAccountsInput {
                arn: self.arn,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateAccountsInputOperationOutputAlias = crate::operation::DisassociateAccounts;
#[doc(hidden)]
pub type DisassociateAccountsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateAccountsInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateAccounts`](crate::operation::DisassociateAccounts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateAccounts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateAccountsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/disassociate-accounts").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateAccountsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_accounts(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateAccounts",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateAccountsInput`](crate::input::DisassociateAccountsInput)
    pub fn builder() -> crate::input::disassociate_accounts_input::Builder {
        crate::input::disassociate_accounts_input::Builder::default()
    }
}

/// See [`DisassociatePricingRulesInput`](crate::input::DisassociatePricingRulesInput)
pub mod disassociate_pricing_rules_input {
    /// A builder for [`DisassociatePricingRulesInput`](crate::input::DisassociatePricingRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `pricing_rule_arns`.
        ///
        /// To override the contents of this collection use [`set_pricing_rule_arns`](Self::set_pricing_rule_arns).
        ///
        /// <p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>
        pub fn pricing_rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pricing_rule_arns.unwrap_or_default();
            v.push(input.into());
            self.pricing_rule_arns = Some(v);
            self
        }
        /// <p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>
        pub fn set_pricing_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pricing_rule_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociatePricingRulesInput`](crate::input::DisassociatePricingRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociatePricingRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociatePricingRulesInput {
                arn: self.arn,
                pricing_rule_arns: self.pricing_rule_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociatePricingRulesInputOperationOutputAlias =
    crate::operation::DisassociatePricingRules;
#[doc(hidden)]
pub type DisassociatePricingRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociatePricingRulesInput {
    /// Consumes the builder and constructs an Operation<[`DisassociatePricingRules`](crate::operation::DisassociatePricingRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociatePricingRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociatePricingRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/disassociate-pricing-rules").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociatePricingRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_pricing_rules(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociatePricingRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociatePricingRules",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociatePricingRulesInput`](crate::input::DisassociatePricingRulesInput)
    pub fn builder() -> crate::input::disassociate_pricing_rules_input::Builder {
        crate::input::disassociate_pricing_rules_input::Builder::default()
    }
}

/// See [`ListAccountAssociationsInput`](crate::input::ListAccountAssociationsInput)
pub mod list_account_associations_input {
    /// A builder for [`ListAccountAssociationsInput`](crate::input::ListAccountAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ListAccountAssociationsFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The preferred billing period to get account associations. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The preferred billing period to get account associations. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p>The filter on the account ID of the linked account, or any of the following:</p>
        /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
        /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
        /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>
        pub fn filters(mut self, input: crate::model::ListAccountAssociationsFilter) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>The filter on the account ID of the linked account, or any of the following:</p>
        /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
        /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
        /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListAccountAssociationsFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The pagination token used on subsequent calls to retrieve accounts. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token used on subsequent calls to retrieve accounts. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAssociationsInput`](crate::input::ListAccountAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountAssociationsInput {
                billing_period: self.billing_period,
                filters: self.filters,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountAssociationsInputOperationOutputAlias =
    crate::operation::ListAccountAssociations;
#[doc(hidden)]
pub type ListAccountAssociationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccountAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountAssociations`](crate::operation::ListAccountAssociations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAccountAssociationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-account-associations").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAccountAssociationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_account_associations(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountAssociations",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAccountAssociationsInput`](crate::input::ListAccountAssociationsInput)
    pub fn builder() -> crate::input::list_account_associations_input::Builder {
        crate::input::list_account_associations_input::Builder::default()
    }
}

/// See [`ListBillingGroupCostReportsInput`](crate::input::ListBillingGroupCostReportsInput)
pub mod list_billing_group_cost_reports_input {
    /// A builder for [`ListBillingGroupCostReportsInput`](crate::input::ListBillingGroupCostReportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ListBillingGroupCostReportsFilter>,
    }
    impl Builder {
        /// <p>The preferred billing period for your report. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p>The preferred billing period for your report. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p>The maximum number of reports to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of reports to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token used on subsequent calls to get reports. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used on subsequent calls to get reports. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>
        pub fn filters(mut self, input: crate::model::ListBillingGroupCostReportsFilter) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListBillingGroupCostReportsFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBillingGroupCostReportsInput`](crate::input::ListBillingGroupCostReportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBillingGroupCostReportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBillingGroupCostReportsInput {
                billing_period: self.billing_period,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBillingGroupCostReportsInputOperationOutputAlias =
    crate::operation::ListBillingGroupCostReports;
#[doc(hidden)]
pub type ListBillingGroupCostReportsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBillingGroupCostReportsInput {
    /// Consumes the builder and constructs an Operation<[`ListBillingGroupCostReports`](crate::operation::ListBillingGroupCostReports)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBillingGroupCostReports,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBillingGroupCostReportsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-billing-group-cost-reports")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBillingGroupCostReportsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_billing_group_cost_reports(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBillingGroupCostReports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBillingGroupCostReports",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBillingGroupCostReportsInput`](crate::input::ListBillingGroupCostReportsInput)
    pub fn builder() -> crate::input::list_billing_group_cost_reports_input::Builder {
        crate::input::list_billing_group_cost_reports_input::Builder::default()
    }
}

/// See [`ListBillingGroupsInput`](crate::input::ListBillingGroupsInput)
pub mod list_billing_groups_input {
    /// A builder for [`ListBillingGroupsInput`](crate::input::ListBillingGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ListBillingGroupsFilter>,
    }
    impl Builder {
        /// <p>The preferred billing period to get billing groups. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p>The preferred billing period to get billing groups. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p>The maximum number of billing groups to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of billing groups to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token used on subsequent calls to get billing groups. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used on subsequent calls to get billing groups. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>
        pub fn filters(mut self, input: crate::model::ListBillingGroupsFilter) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListBillingGroupsFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBillingGroupsInput`](crate::input::ListBillingGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBillingGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBillingGroupsInput {
                billing_period: self.billing_period,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBillingGroupsInputOperationOutputAlias = crate::operation::ListBillingGroups;
#[doc(hidden)]
pub type ListBillingGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBillingGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListBillingGroups`](crate::operation::ListBillingGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBillingGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBillingGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-billing-groups").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBillingGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_billing_groups(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBillingGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBillingGroups",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBillingGroupsInput`](crate::input::ListBillingGroupsInput)
    pub fn builder() -> crate::input::list_billing_groups_input::Builder {
        crate::input::list_billing_groups_input::Builder::default()
    }
}

/// See [`ListCustomLineItemsInput`](crate::input::ListCustomLineItemsInput)
pub mod list_custom_line_items_input {
    /// A builder for [`ListCustomLineItemsInput`](crate::input::ListCustomLineItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ListCustomLineItemsFilter>,
    }
    impl Builder {
        /// <p> The preferred billing period to get custom line items (FFLIs). </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The preferred billing period to get custom line items (FFLIs). </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p> The maximum number of billing groups to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of billing groups to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>
        pub fn filters(mut self, input: crate::model::ListCustomLineItemsFilter) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListCustomLineItemsFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomLineItemsInput`](crate::input::ListCustomLineItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomLineItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomLineItemsInput {
                billing_period: self.billing_period,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomLineItemsInputOperationOutputAlias = crate::operation::ListCustomLineItems;
#[doc(hidden)]
pub type ListCustomLineItemsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListCustomLineItemsInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomLineItems`](crate::operation::ListCustomLineItems)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomLineItems,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListCustomLineItemsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-custom-line-items").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListCustomLineItemsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_custom_line_items(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomLineItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomLineItems",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListCustomLineItemsInput`](crate::input::ListCustomLineItemsInput)
    pub fn builder() -> crate::input::list_custom_line_items_input::Builder {
        crate::input::list_custom_line_items_input::Builder::default()
    }
}

/// See [`ListPricingPlansInput`](crate::input::ListPricingPlansInput)
pub mod list_pricing_plans_input {
    /// A builder for [`ListPricingPlansInput`](crate::input::ListPricingPlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ListPricingPlansFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The preferred billing period to get pricing plan. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p>The preferred billing period to get pricing plan. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>
        pub fn filters(mut self, input: crate::model::ListPricingPlansFilter) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListPricingPlansFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of pricing plans to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of pricing plans to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token used on subsequent call to get pricing plans. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used on subsequent call to get pricing plans. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingPlansInput`](crate::input::ListPricingPlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPricingPlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPricingPlansInput {
                billing_period: self.billing_period,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPricingPlansInputOperationOutputAlias = crate::operation::ListPricingPlans;
#[doc(hidden)]
pub type ListPricingPlansInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPricingPlansInput {
    /// Consumes the builder and constructs an Operation<[`ListPricingPlans`](crate::operation::ListPricingPlans)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPricingPlans,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPricingPlansInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-pricing-plans").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPricingPlansInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pricing_plans(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPricingPlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPricingPlans",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPricingPlansInput`](crate::input::ListPricingPlansInput)
    pub fn builder() -> crate::input::list_pricing_plans_input::Builder {
        crate::input::list_pricing_plans_input::Builder::default()
    }
}

/// See [`ListPricingPlansAssociatedWithPricingRuleInput`](crate::input::ListPricingPlansAssociatedWithPricingRuleInput)
pub mod list_pricing_plans_associated_with_pricing_rule_input {
    /// A builder for [`ListPricingPlansAssociatedWithPricingRuleInput`](crate::input::ListPricingPlansAssociatedWithPricingRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) pricing_rule_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The pricing plan billing period for which associations will be listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The pricing plan billing period for which associations will be listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
        pub fn pricing_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_rule_arn = Some(input.into());
            self
        }
        /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
        pub fn set_pricing_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_rule_arn = input;
            self
        }
        /// <p> The optional maximum number of pricing rule associations to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The optional maximum number of pricing rule associations to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingPlansAssociatedWithPricingRuleInput`](crate::input::ListPricingPlansAssociatedWithPricingRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPricingPlansAssociatedWithPricingRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListPricingPlansAssociatedWithPricingRuleInput {
                    billing_period: self.billing_period,
                    pricing_rule_arn: self.pricing_rule_arn,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListPricingPlansAssociatedWithPricingRuleInputOperationOutputAlias =
    crate::operation::ListPricingPlansAssociatedWithPricingRule;
#[doc(hidden)]
pub type ListPricingPlansAssociatedWithPricingRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListPricingPlansAssociatedWithPricingRuleInput {
    /// Consumes the builder and constructs an Operation<[`ListPricingPlansAssociatedWithPricingRule`](crate::operation::ListPricingPlansAssociatedWithPricingRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPricingPlansAssociatedWithPricingRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPricingPlansAssociatedWithPricingRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-pricing-plans-associated-with-pricing-rule")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPricingPlansAssociatedWithPricingRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pricing_plans_associated_with_pricing_rule(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPricingPlansAssociatedWithPricingRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPricingPlansAssociatedWithPricingRule",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPricingPlansAssociatedWithPricingRuleInput`](crate::input::ListPricingPlansAssociatedWithPricingRuleInput)
    pub fn builder() -> crate::input::list_pricing_plans_associated_with_pricing_rule_input::Builder
    {
        crate::input::list_pricing_plans_associated_with_pricing_rule_input::Builder::default()
    }
}

/// See [`ListPricingRulesInput`](crate::input::ListPricingRulesInput)
pub mod list_pricing_rules_input {
    /// A builder for [`ListPricingRulesInput`](crate::input::ListPricingRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::ListPricingRulesFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The preferred billing period to get the pricing plan. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The preferred billing period to get the pricing plan. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>
        pub fn filters(mut self, input: crate::model::ListPricingRulesFilter) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListPricingRulesFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of pricing rules to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of pricing rules to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The pagination token used on subsequent call to get pricing rules. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token used on subsequent call to get pricing rules. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingRulesInput`](crate::input::ListPricingRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPricingRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPricingRulesInput {
                billing_period: self.billing_period,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPricingRulesInputOperationOutputAlias = crate::operation::ListPricingRules;
#[doc(hidden)]
pub type ListPricingRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPricingRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListPricingRules`](crate::operation::ListPricingRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPricingRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPricingRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-pricing-rules").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPricingRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pricing_rules(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPricingRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPricingRules",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPricingRulesInput`](crate::input::ListPricingRulesInput)
    pub fn builder() -> crate::input::list_pricing_rules_input::Builder {
        crate::input::list_pricing_rules_input::Builder::default()
    }
}

/// See [`ListPricingRulesAssociatedToPricingPlanInput`](crate::input::ListPricingRulesAssociatedToPricingPlanInput)
pub mod list_pricing_rules_associated_to_pricing_plan_input {
    /// A builder for [`ListPricingRulesAssociatedToPricingPlanInput`](crate::input::ListPricingRulesAssociatedToPricingPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) pricing_plan_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The billing period for which the pricing rule associations are to be listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The billing period for which the pricing rule associations are to be listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>
        pub fn pricing_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>
        pub fn set_pricing_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_arn = input;
            self
        }
        /// <p>The optional maximum number of pricing rule associations to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The optional maximum number of pricing rule associations to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingRulesAssociatedToPricingPlanInput`](crate::input::ListPricingRulesAssociatedToPricingPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPricingRulesAssociatedToPricingPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPricingRulesAssociatedToPricingPlanInput {
                billing_period: self.billing_period,
                pricing_plan_arn: self.pricing_plan_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPricingRulesAssociatedToPricingPlanInputOperationOutputAlias =
    crate::operation::ListPricingRulesAssociatedToPricingPlan;
#[doc(hidden)]
pub type ListPricingRulesAssociatedToPricingPlanInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListPricingRulesAssociatedToPricingPlanInput {
    /// Consumes the builder and constructs an Operation<[`ListPricingRulesAssociatedToPricingPlan`](crate::operation::ListPricingRulesAssociatedToPricingPlan)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPricingRulesAssociatedToPricingPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPricingRulesAssociatedToPricingPlanInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-pricing-rules-associated-to-pricing-plan")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPricingRulesAssociatedToPricingPlanInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pricing_rules_associated_to_pricing_plan(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPricingRulesAssociatedToPricingPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPricingRulesAssociatedToPricingPlan",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPricingRulesAssociatedToPricingPlanInput`](crate::input::ListPricingRulesAssociatedToPricingPlanInput)
    pub fn builder() -> crate::input::list_pricing_rules_associated_to_pricing_plan_input::Builder {
        crate::input::list_pricing_rules_associated_to_pricing_plan_input::Builder::default()
    }
}

/// See [`ListResourcesAssociatedToCustomLineItemInput`](crate::input::ListResourcesAssociatedToCustomLineItemInput)
pub mod list_resources_associated_to_custom_line_item_input {
    /// A builder for [`ListResourcesAssociatedToCustomLineItemInput`](crate::input::ListResourcesAssociatedToCustomLineItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<crate::model::ListResourcesAssociatedToCustomLineItemFilter>,
    }
    impl Builder {
        /// <p> The billing period for which the resource associations will be listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The billing period for which the resource associations will be listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p> The ARN of the custom line item for which the resource associations will be listed. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the custom line item for which the resource associations will be listed. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> (Optional) The maximum number of resource associations to be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> (Optional) The maximum number of resource associations to be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> (Optional) The pagination token returned by a previous request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> (Optional) The pagination token returned by a previous request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>
        pub fn filters(
            mut self,
            input: crate::model::ListResourcesAssociatedToCustomLineItemFilter,
        ) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListResourcesAssociatedToCustomLineItemFilter>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesAssociatedToCustomLineItemInput`](crate::input::ListResourcesAssociatedToCustomLineItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourcesAssociatedToCustomLineItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourcesAssociatedToCustomLineItemInput {
                billing_period: self.billing_period,
                arn: self.arn,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourcesAssociatedToCustomLineItemInputOperationOutputAlias =
    crate::operation::ListResourcesAssociatedToCustomLineItem;
#[doc(hidden)]
pub type ListResourcesAssociatedToCustomLineItemInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListResourcesAssociatedToCustomLineItemInput {
    /// Consumes the builder and constructs an Operation<[`ListResourcesAssociatedToCustomLineItem`](crate::operation::ListResourcesAssociatedToCustomLineItem)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourcesAssociatedToCustomLineItem,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListResourcesAssociatedToCustomLineItemInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/list-resources-associated-to-custom-line-item")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListResourcesAssociatedToCustomLineItemInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_resources_associated_to_custom_line_item(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourcesAssociatedToCustomLineItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourcesAssociatedToCustomLineItem",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListResourcesAssociatedToCustomLineItemInput`](crate::input::ListResourcesAssociatedToCustomLineItemInput)
    pub fn builder() -> crate::input::list_resources_associated_to_custom_line_item_input::Builder {
        crate::input::list_resources_associated_to_custom_line_item_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.resource_arn;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_1, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags to add to the resource as a list of key-value pairs. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags to add to the resource as a list of key-value pairs. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.resource_arn;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_2, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tags to delete from the resource as a list of key-value pairs. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p> The tags to delete from the resource as a list of key-value pairs. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.resource_arn;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_3, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_4) = &_input.tag_keys {
                    for inner_5 in inner_4 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_5));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateBillingGroupInput`](crate::input::UpdateBillingGroupInput)
pub mod update_billing_group_input {
    /// A builder for [`UpdateBillingGroupInput`](crate::input::UpdateBillingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::BillingGroupStatus>,
        pub(crate) computation_preference: std::option::Option<crate::model::ComputationPreference>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the billing group being updated. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group being updated. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the billing group. The names must be unique to each billing group. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the billing group. The names must be unique to each billing group. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the billing group. Only one of the valid values can be used. </p>
        pub fn status(mut self, input: crate::model::BillingGroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the billing group. Only one of the valid values can be used. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BillingGroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn computation_preference(
            mut self,
            input: crate::model::ComputationPreference,
        ) -> Self {
            self.computation_preference = Some(input);
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn set_computation_preference(
            mut self,
            input: std::option::Option<crate::model::ComputationPreference>,
        ) -> Self {
            self.computation_preference = input;
            self
        }
        /// <p>A description of the billing group. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the billing group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBillingGroupInput`](crate::input::UpdateBillingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBillingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBillingGroupInput {
                arn: self.arn,
                name: self.name,
                status: self.status,
                computation_preference: self.computation_preference,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBillingGroupInputOperationOutputAlias = crate::operation::UpdateBillingGroup;
#[doc(hidden)]
pub type UpdateBillingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBillingGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBillingGroup`](crate::operation::UpdateBillingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBillingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateBillingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/update-billing-group").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateBillingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_billing_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBillingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBillingGroup",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateBillingGroupInput`](crate::input::UpdateBillingGroupInput)
    pub fn builder() -> crate::input::update_billing_group_input::Builder {
        crate::input::update_billing_group_input::Builder::default()
    }
}

/// See [`UpdateCustomLineItemInput`](crate::input::UpdateCustomLineItemInput)
pub mod update_custom_line_item_input {
    /// A builder for [`UpdateCustomLineItemInput`](crate::input::UpdateCustomLineItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) charge_details:
            std::option::Option<crate::model::UpdateCustomLineItemChargeDetails>,
        pub(crate) billing_period_range:
            std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
    }
    impl Builder {
        /// <p> The ARN of the custom line item to be updated. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the custom line item to be updated. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The new name for the custom line item. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The new name for the custom line item. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The new line item description of the custom line item. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The new line item description of the custom line item. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>
        pub fn charge_details(
            mut self,
            input: crate::model::UpdateCustomLineItemChargeDetails,
        ) -> Self {
            self.charge_details = Some(input);
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>
        pub fn set_charge_details(
            mut self,
            input: std::option::Option<crate::model::UpdateCustomLineItemChargeDetails>,
        ) -> Self {
            self.charge_details = input;
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.billing_period_range = Some(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.billing_period_range = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomLineItemInput`](crate::input::UpdateCustomLineItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCustomLineItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCustomLineItemInput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                charge_details: self.charge_details,
                billing_period_range: self.billing_period_range,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCustomLineItemInputOperationOutputAlias = crate::operation::UpdateCustomLineItem;
#[doc(hidden)]
pub type UpdateCustomLineItemInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCustomLineItemInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCustomLineItem`](crate::operation::UpdateCustomLineItem)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCustomLineItem,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateCustomLineItemInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/update-custom-line-item").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateCustomLineItemInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_custom_line_item(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCustomLineItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCustomLineItem",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateCustomLineItemInput`](crate::input::UpdateCustomLineItemInput)
    pub fn builder() -> crate::input::update_custom_line_item_input::Builder {
        crate::input::update_custom_line_item_input::Builder::default()
    }
}

/// See [`UpdatePricingPlanInput`](crate::input::UpdatePricingPlanInput)
pub mod update_pricing_plan_input {
    /// A builder for [`UpdatePricingPlanInput`](crate::input::UpdatePricingPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're updating. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're updating. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the pricing plan. The name must be unique to each pricing plan. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pricing plan. The name must be unique to each pricing plan. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePricingPlanInput`](crate::input::UpdatePricingPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePricingPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePricingPlanInput {
                arn: self.arn,
                name: self.name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePricingPlanInputOperationOutputAlias = crate::operation::UpdatePricingPlan;
#[doc(hidden)]
pub type UpdatePricingPlanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePricingPlanInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePricingPlan`](crate::operation::UpdatePricingPlan)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePricingPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePricingPlanInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/update-pricing-plan").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePricingPlanInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pricing_plan(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePricingPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePricingPlan",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePricingPlanInput`](crate::input::UpdatePricingPlanInput)
    pub fn builder() -> crate::input::update_pricing_plan_input::Builder {
        crate::input::update_pricing_plan_input::Builder::default()
    }
}

/// See [`UpdatePricingRuleInput`](crate::input::UpdatePricingRuleInput)
pub mod update_pricing_rule_input {
    /// A builder for [`UpdatePricingRuleInput`](crate::input::UpdatePricingRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PricingRuleType>,
        pub(crate) modifier_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The new pricing rule type. </p>
        pub fn r#type(mut self, input: crate::model::PricingRuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The new pricing rule type. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PricingRuleType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The new modifier to show pricing plan rates as a percentage. </p>
        pub fn modifier_percentage(mut self, input: f64) -> Self {
            self.modifier_percentage = Some(input);
            self
        }
        /// <p> The new modifier to show pricing plan rates as a percentage. </p>
        pub fn set_modifier_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.modifier_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePricingRuleInput`](crate::input::UpdatePricingRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePricingRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePricingRuleInput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                modifier_percentage: self.modifier_percentage,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePricingRuleInputOperationOutputAlias = crate::operation::UpdatePricingRule;
#[doc(hidden)]
pub type UpdatePricingRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePricingRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePricingRule`](crate::operation::UpdatePricingRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePricingRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePricingRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/update-pricing-rule").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePricingRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pricing_rule(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePricingRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePricingRule",
            "billingconductor",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePricingRuleInput`](crate::input::UpdatePricingRuleInput)
    pub fn builder() -> crate::input::update_pricing_rule_input::Builder {
        crate::input::update_pricing_rule_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingRulesAssociatedToPricingPlanInput {
    /// <p> The billing period for which the pricing rule associations are to be listed. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>
    pub pricing_plan_arn: std::option::Option<std::string::String>,
    /// <p>The optional maximum number of pricing rule associations to retrieve.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> The optional pagination token returned by a previous call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingRulesAssociatedToPricingPlanInput {
    /// <p> The billing period for which the pricing rule associations are to be listed. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>
    pub fn pricing_plan_arn(&self) -> std::option::Option<&str> {
        self.pricing_plan_arn.as_deref()
    }
    /// <p>The optional maximum number of pricing rule associations to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The optional pagination token returned by a previous call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingRulesAssociatedToPricingPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingRulesAssociatedToPricingPlanInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("pricing_plan_arn", &self.pricing_plan_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingRulesInput {
    /// <p> The preferred billing period to get the pricing plan. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>
    pub filters: std::option::Option<crate::model::ListPricingRulesFilter>,
    /// <p> The maximum number of pricing rules to retrieve. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The pagination token used on subsequent call to get pricing rules. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingRulesInput {
    /// <p> The preferred billing period to get the pricing plan. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListPricingRulesFilter> {
        self.filters.as_ref()
    }
    /// <p> The maximum number of pricing rules to retrieve. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The pagination token used on subsequent call to get pricing rules. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingRulesInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePricingRuleInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p> The pricing rule name. The names must be unique to each pricing rule. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The pricing rule description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
    pub scope: std::option::Option<crate::model::PricingRuleScope>,
    /// <p> The type of pricing rule. </p>
    pub r#type: std::option::Option<crate::model::PricingRuleType>,
    /// <p> A percentage modifier applied on the public pricing rates. </p>
    pub modifier_percentage: std::option::Option<f64>,
    /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    pub service: std::option::Option<std::string::String>,
    /// <p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePricingRuleInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p> The pricing rule name. The names must be unique to each pricing rule. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The pricing rule description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
    pub fn scope(&self) -> std::option::Option<&crate::model::PricingRuleScope> {
        self.scope.as_ref()
    }
    /// <p> The type of pricing rule. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PricingRuleType> {
        self.r#type.as_ref()
    }
    /// <p> A percentage modifier applied on the public pricing rates. </p>
    pub fn modifier_percentage(&self) -> std::option::Option<f64> {
        self.modifier_percentage
    }
    /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreatePricingRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePricingRuleInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("scope", &self.scope);
        formatter.field("r#type", &self.r#type);
        formatter.field("modifier_percentage", &self.modifier_percentage);
        formatter.field("service", &self.service);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePricingRuleInput {
    /// <p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeletePricingRuleInput {
    /// <p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePricingRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePricingRuleInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePricingRuleInput {
    /// <p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The new description for the pricing rule. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The new pricing rule type. </p>
    pub r#type: std::option::Option<crate::model::PricingRuleType>,
    /// <p> The new modifier to show pricing plan rates as a percentage. </p>
    pub modifier_percentage: std::option::Option<f64>,
}
impl UpdatePricingRuleInput {
    /// <p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The new description for the pricing rule. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The new pricing rule type. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PricingRuleType> {
        self.r#type.as_ref()
    }
    /// <p> The new modifier to show pricing plan rates as a percentage. </p>
    pub fn modifier_percentage(&self) -> std::option::Option<f64> {
        self.modifier_percentage
    }
}
impl std::fmt::Debug for UpdatePricingRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePricingRuleInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("r#type", &self.r#type);
        formatter.field("modifier_percentage", &self.modifier_percentage);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociatePricingRulesInput {
    /// <p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>
    pub pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisassociatePricingRulesInput {
    /// <p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>
    pub fn pricing_rule_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.pricing_rule_arns.as_deref()
    }
}
impl std::fmt::Debug for DisassociatePricingRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociatePricingRulesInput");
        formatter.field("arn", &self.arn);
        formatter.field("pricing_rule_arns", &self.pricing_rule_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePricingRulesInput {
    /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>
    pub pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AssociatePricingRulesInput {
    /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>
    pub fn pricing_rule_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.pricing_rule_arns.as_deref()
    }
}
impl std::fmt::Debug for AssociatePricingRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePricingRulesInput");
        formatter.field("arn", &self.arn);
        formatter.field("pricing_rule_arns", &self.pricing_rule_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingPlansAssociatedWithPricingRuleInput {
    /// <p> The pricing plan billing period for which associations will be listed. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
    pub pricing_rule_arn: std::option::Option<std::string::String>,
    /// <p> The optional maximum number of pricing rule associations to retrieve. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The optional pagination token returned by a previous call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingPlansAssociatedWithPricingRuleInput {
    /// <p> The pricing plan billing period for which associations will be listed. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
    pub fn pricing_rule_arn(&self) -> std::option::Option<&str> {
        self.pricing_rule_arn.as_deref()
    }
    /// <p> The optional maximum number of pricing rule associations to retrieve. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The optional pagination token returned by a previous call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingPlansAssociatedWithPricingRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingPlansAssociatedWithPricingRuleInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("pricing_rule_arn", &self.pricing_rule_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingPlansInput {
    /// <p>The preferred billing period to get pricing plan. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>
    pub filters: std::option::Option<crate::model::ListPricingPlansFilter>,
    /// <p>The maximum number of pricing plans to retrieve.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token used on subsequent call to get pricing plans. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingPlansInput {
    /// <p>The preferred billing period to get pricing plan. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListPricingPlansFilter> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of pricing plans to retrieve.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token used on subsequent call to get pricing plans. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingPlansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingPlansInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePricingPlanInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The pricing plan name. The names must be unique to each pricing plan. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The pricing plan description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>
    pub pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePricingPlanInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The pricing plan name. The names must be unique to each pricing plan. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The pricing plan description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>
    pub fn pricing_rule_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.pricing_rule_arns.as_deref()
    }
    /// <p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreatePricingPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePricingPlanInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("pricing_rule_arns", &self.pricing_rule_arns);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePricingPlanInput {
    /// <p>The Amazon Resource Name (ARN) of the pricing plan you're deleting. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeletePricingPlanInput {
    /// <p>The Amazon Resource Name (ARN) of the pricing plan you're deleting. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePricingPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePricingPlanInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePricingPlanInput {
    /// <p>The Amazon Resource Name (ARN) of the pricing plan you're updating. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the pricing plan. The name must be unique to each pricing plan. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The pricing plan description. </p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdatePricingPlanInput {
    /// <p>The Amazon Resource Name (ARN) of the pricing plan you're updating. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the pricing plan. The name must be unique to each pricing plan. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The pricing plan description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdatePricingPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePricingPlanInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesAssociatedToCustomLineItemInput {
    /// <p> The billing period for which the resource associations will be listed. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> The ARN of the custom line item for which the resource associations will be listed. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> (Optional) The maximum number of resource associations to be retrieved. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> (Optional) The pagination token returned by a previous request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>
    pub filters: std::option::Option<crate::model::ListResourcesAssociatedToCustomLineItemFilter>,
}
impl ListResourcesAssociatedToCustomLineItemInput {
    /// <p> The billing period for which the resource associations will be listed. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> The ARN of the custom line item for which the resource associations will be listed. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> (Optional) The maximum number of resource associations to be retrieved. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> (Optional) The pagination token returned by a previous request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&crate::model::ListResourcesAssociatedToCustomLineItemFilter> {
        self.filters.as_ref()
    }
}
impl std::fmt::Debug for ListResourcesAssociatedToCustomLineItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesAssociatedToCustomLineItemInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("arn", &self.arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateResourcesFromCustomLineItemInput {
    /// <p> A percentage custom line item ARN to disassociate the resources from. </p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p> A list containing the ARNs of resources to be disassociated. </p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub billing_period_range: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
}
impl BatchDisassociateResourcesFromCustomLineItemInput {
    /// <p> A percentage custom line item ARN to disassociate the resources from. </p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p> A list containing the ARNs of resources to be disassociated. </p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub fn billing_period_range(
        &self,
    ) -> std::option::Option<&crate::model::CustomLineItemBillingPeriodRange> {
        self.billing_period_range.as_ref()
    }
}
impl std::fmt::Debug for BatchDisassociateResourcesFromCustomLineItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateResourcesFromCustomLineItemInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("billing_period_range", &self.billing_period_range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateResourcesToCustomLineItemInput {
    /// <p> A percentage custom line item ARN to associate the resources to. </p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p> A list containing the ARNs of the resources to be associated. </p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub billing_period_range: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
}
impl BatchAssociateResourcesToCustomLineItemInput {
    /// <p> A percentage custom line item ARN to associate the resources to. </p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p> A list containing the ARNs of the resources to be associated. </p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub fn billing_period_range(
        &self,
    ) -> std::option::Option<&crate::model::CustomLineItemBillingPeriodRange> {
        self.billing_period_range.as_ref()
    }
}
impl std::fmt::Debug for BatchAssociateResourcesToCustomLineItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateResourcesToCustomLineItemInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("billing_period_range", &self.billing_period_range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomLineItemsInput {
    /// <p> The preferred billing period to get custom line items (FFLIs). </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> The maximum number of billing groups to retrieve. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>
    pub filters: std::option::Option<crate::model::ListCustomLineItemsFilter>,
}
impl ListCustomLineItemsInput {
    /// <p> The preferred billing period to get custom line items (FFLIs). </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> The maximum number of billing groups to retrieve. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListCustomLineItemsFilter> {
        self.filters.as_ref()
    }
}
impl std::fmt::Debug for ListCustomLineItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomLineItemsInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomLineItemInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p> The name of the custom line item. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
    pub billing_group_arn: std::option::Option<std::string::String>,
    /// <p> A time range for which the custom line item is effective. </p>
    pub billing_period_range: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
    /// <p> A map that contains tag keys and tag values that are attached to a custom line item. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>
    pub charge_details: std::option::Option<crate::model::CustomLineItemChargeDetails>,
}
impl CreateCustomLineItemInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p> The name of the custom line item. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
    pub fn billing_group_arn(&self) -> std::option::Option<&str> {
        self.billing_group_arn.as_deref()
    }
    /// <p> A time range for which the custom line item is effective. </p>
    pub fn billing_period_range(
        &self,
    ) -> std::option::Option<&crate::model::CustomLineItemBillingPeriodRange> {
        self.billing_period_range.as_ref()
    }
    /// <p> A map that contains tag keys and tag values that are attached to a custom line item. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>
    pub fn charge_details(
        &self,
    ) -> std::option::Option<&crate::model::CustomLineItemChargeDetails> {
        self.charge_details.as_ref()
    }
}
impl std::fmt::Debug for CreateCustomLineItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomLineItemInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("billing_group_arn", &self.billing_group_arn);
        formatter.field("billing_period_range", &self.billing_period_range);
        formatter.field("tags", &self.tags);
        formatter.field("charge_details", &self.charge_details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomLineItemInput {
    /// <p> The ARN of the custom line item to be deleted. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub billing_period_range: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
}
impl DeleteCustomLineItemInput {
    /// <p> The ARN of the custom line item to be deleted. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub fn billing_period_range(
        &self,
    ) -> std::option::Option<&crate::model::CustomLineItemBillingPeriodRange> {
        self.billing_period_range.as_ref()
    }
}
impl std::fmt::Debug for DeleteCustomLineItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomLineItemInput");
        formatter.field("arn", &self.arn);
        formatter.field("billing_period_range", &self.billing_period_range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomLineItemInput {
    /// <p> The ARN of the custom line item to be updated. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The new name for the custom line item. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The new line item description of the custom line item. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>
    pub charge_details: std::option::Option<crate::model::UpdateCustomLineItemChargeDetails>,
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub billing_period_range: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
}
impl UpdateCustomLineItemInput {
    /// <p> The ARN of the custom line item to be updated. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The new name for the custom line item. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The new line item description of the custom line item. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>
    pub fn charge_details(
        &self,
    ) -> std::option::Option<&crate::model::UpdateCustomLineItemChargeDetails> {
        self.charge_details.as_ref()
    }
    /// <p> The billing period range in which the custom line item request will be applied. </p>
    pub fn billing_period_range(
        &self,
    ) -> std::option::Option<&crate::model::CustomLineItemBillingPeriodRange> {
        self.billing_period_range.as_ref()
    }
}
impl std::fmt::Debug for UpdateCustomLineItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomLineItemInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("charge_details", &self.charge_details);
        formatter.field("billing_period_range", &self.billing_period_range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAccountsInput {
    /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The array of account IDs to disassociate. </p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisassociateAccountsInput {
    /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The array of account IDs to disassociate. </p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DisassociateAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAccountsInput");
        formatter.field("arn", &self.arn);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAccountsInput {
    /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The associating array of account IDs. </p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AssociateAccountsInput {
    /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The associating array of account IDs. </p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for AssociateAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAccountsInput");
        formatter.field("arn", &self.arn);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBillingGroupsInput {
    /// <p>The preferred billing period to get billing groups. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p>The maximum number of billing groups to retrieve. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token used on subsequent calls to get billing groups. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>
    pub filters: std::option::Option<crate::model::ListBillingGroupsFilter>,
}
impl ListBillingGroupsInput {
    /// <p>The preferred billing period to get billing groups. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p>The maximum number of billing groups to retrieve. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token used on subsequent calls to get billing groups. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListBillingGroupsFilter> {
        self.filters.as_ref()
    }
}
impl std::fmt::Debug for ListBillingGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBillingGroupsInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBillingGroupInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p> The billing group name. The names must be unique. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
    pub account_grouping: std::option::Option<crate::model::AccountGrouping>,
    /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    pub computation_preference: std::option::Option<crate::model::ComputationPreference>,
    /// <p> The account ID that serves as the main account in a billing group. </p>
    pub primary_account_id: std::option::Option<std::string::String>,
    /// <p>The billing group description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateBillingGroupInput {
    /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p> The billing group name. The names must be unique. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
    pub fn account_grouping(&self) -> std::option::Option<&crate::model::AccountGrouping> {
        self.account_grouping.as_ref()
    }
    /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    pub fn computation_preference(
        &self,
    ) -> std::option::Option<&crate::model::ComputationPreference> {
        self.computation_preference.as_ref()
    }
    /// <p> The account ID that serves as the main account in a billing group. </p>
    pub fn primary_account_id(&self) -> std::option::Option<&str> {
        self.primary_account_id.as_deref()
    }
    /// <p>The billing group description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateBillingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBillingGroupInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("account_grouping", &self.account_grouping);
        formatter.field("computation_preference", &self.computation_preference);
        formatter.field("primary_account_id", &self.primary_account_id);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBillingGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the billing group you're deleting.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteBillingGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the billing group you're deleting.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteBillingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBillingGroupInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBillingGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the billing group being updated. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the billing group. The names must be unique to each billing group. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the billing group. Only one of the valid values can be used. </p>
    pub status: std::option::Option<crate::model::BillingGroupStatus>,
    /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    pub computation_preference: std::option::Option<crate::model::ComputationPreference>,
    /// <p>A description of the billing group. </p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateBillingGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the billing group being updated. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the billing group. The names must be unique to each billing group. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the billing group. Only one of the valid values can be used. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::BillingGroupStatus> {
        self.status.as_ref()
    }
    /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    pub fn computation_preference(
        &self,
    ) -> std::option::Option<&crate::model::ComputationPreference> {
        self.computation_preference.as_ref()
    }
    /// <p>A description of the billing group. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateBillingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBillingGroupInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("computation_preference", &self.computation_preference);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The tags to delete from the resource as a list of key-value pairs. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The tags to delete from the resource as a list of key-value pairs. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The tags to add to the resource as a list of key-value pairs. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The tags to add to the resource as a list of key-value pairs. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBillingGroupCostReportsInput {
    /// <p>The preferred billing period for your report. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p>The maximum number of reports to retrieve. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token used on subsequent calls to get reports. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>
    pub filters: std::option::Option<crate::model::ListBillingGroupCostReportsFilter>,
}
impl ListBillingGroupCostReportsInput {
    /// <p>The preferred billing period for your report. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p>The maximum number of reports to retrieve. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token used on subsequent calls to get reports. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListBillingGroupCostReportsFilter> {
        self.filters.as_ref()
    }
}
impl std::fmt::Debug for ListBillingGroupCostReportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBillingGroupCostReportsInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountAssociationsInput {
    /// <p> The preferred billing period to get account associations. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p>The filter on the account ID of the linked account, or any of the following:</p>
    /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
    /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
    /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>
    pub filters: std::option::Option<crate::model::ListAccountAssociationsFilter>,
    /// <p> The pagination token used on subsequent calls to retrieve accounts. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountAssociationsInput {
    /// <p> The preferred billing period to get account associations. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p>The filter on the account ID of the linked account, or any of the following:</p>
    /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
    /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
    /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListAccountAssociationsFilter> {
        self.filters.as_ref()
    }
    /// <p> The pagination token used on subsequent calls to retrieve accounts. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountAssociationsInput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
