// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateAccountsError {
    /// Kind of error that occurred.
    pub kind: AssociateAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateAccountsErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service limit to exceed. </p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateAccountsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateAccountsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateAccountsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateAccountsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateAccountsErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            AssociateAccountsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateAccountsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateAccountsError {
    fn code(&self) -> Option<&str> {
        AssociateAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateAccountsError {
    /// Creates a new `AssociateAccountsError`.
    pub fn new(kind: AssociateAccountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateAccountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateAccountsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAccountsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAccountsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AssociateAccountsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `AssociateAccountsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAccountsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAccountsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAccountsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAccountsErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAccountsErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAccountsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAccountsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAccountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAccountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateAccountsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateAccountsErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateAccountsErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateAccountsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateAccountsErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            AssociateAccountsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateAccountsErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociatePricingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePricingRulesError {
    /// Kind of error that occurred.
    pub kind: AssociatePricingRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePricingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePricingRulesErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service limit to exceed. </p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePricingRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePricingRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociatePricingRulesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociatePricingRulesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociatePricingRulesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociatePricingRulesErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            AssociatePricingRulesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociatePricingRulesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociatePricingRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociatePricingRulesError {
    fn code(&self) -> Option<&str> {
        AssociatePricingRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePricingRulesError {
    /// Creates a new `AssociatePricingRulesError`.
    pub fn new(kind: AssociatePricingRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePricingRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePricingRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePricingRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePricingRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociatePricingRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePricingRulesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePricingRulesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePricingRulesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePricingRulesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePricingRulesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePricingRulesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePricingRulesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePricingRulesErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePricingRulesErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePricingRulesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePricingRulesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePricingRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePricingRulesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociatePricingRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePricingRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociatePricingRulesErrorKind::ConflictException(_inner) => Some(_inner),
            AssociatePricingRulesErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociatePricingRulesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociatePricingRulesErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            AssociatePricingRulesErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociatePricingRulesErrorKind::ValidationException(_inner) => Some(_inner),
            AssociatePricingRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchAssociateResourcesToCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAssociateResourcesToCustomLineItemError {
    /// Kind of error that occurred.
    pub kind: BatchAssociateResourcesToCustomLineItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAssociateResourcesToCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAssociateResourcesToCustomLineItemErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service limit to exceed. </p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAssociateResourcesToCustomLineItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAssociateResourcesToCustomLineItemErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ServiceLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            BatchAssociateResourcesToCustomLineItemErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchAssociateResourcesToCustomLineItemError {
    fn code(&self) -> Option<&str> {
        BatchAssociateResourcesToCustomLineItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAssociateResourcesToCustomLineItemError {
    /// Creates a new `BatchAssociateResourcesToCustomLineItemError`.
    pub fn new(
        kind: BatchAssociateResourcesToCustomLineItemErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAssociateResourcesToCustomLineItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAssociateResourcesToCustomLineItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAssociateResourcesToCustomLineItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAssociateResourcesToCustomLineItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchAssociateResourcesToCustomLineItemErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateResourcesToCustomLineItemErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateResourcesToCustomLineItemErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateResourcesToCustomLineItemErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateResourcesToCustomLineItemErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateResourcesToCustomLineItemErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateResourcesToCustomLineItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateResourcesToCustomLineItemErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateResourcesToCustomLineItemErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateResourcesToCustomLineItemErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateResourcesToCustomLineItemErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateResourcesToCustomLineItemErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateResourcesToCustomLineItemErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateResourcesToCustomLineItemErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchAssociateResourcesToCustomLineItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAssociateResourcesToCustomLineItemErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ServiceLimitExceededException(
                _inner,
            ) => Some(_inner),
            BatchAssociateResourcesToCustomLineItemErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchAssociateResourcesToCustomLineItemErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchDisassociateResourcesFromCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisassociateResourcesFromCustomLineItemError {
    /// Kind of error that occurred.
    pub kind: BatchDisassociateResourcesFromCustomLineItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisassociateResourcesFromCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisassociateResourcesFromCustomLineItemErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisassociateResourcesFromCustomLineItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisassociateResourcesFromCustomLineItemErrorKind::AccessDeniedException(
                _inner,
            ) => _inner.fmt(f),
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateResourcesFromCustomLineItemErrorKind::InternalServerException(
                _inner,
            ) => _inner.fmt(f),
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateResourcesFromCustomLineItemErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for BatchDisassociateResourcesFromCustomLineItemError
{
    fn code(&self) -> Option<&str> {
        BatchDisassociateResourcesFromCustomLineItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisassociateResourcesFromCustomLineItemError {
    /// Creates a new `BatchDisassociateResourcesFromCustomLineItemError`.
    pub fn new(
        kind: BatchDisassociateResourcesFromCustomLineItemErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisassociateResourcesFromCustomLineItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisassociateResourcesFromCustomLineItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisassociateResourcesFromCustomLineItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisassociateResourcesFromCustomLineItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDisassociateResourcesFromCustomLineItemErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateResourcesFromCustomLineItemErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateResourcesFromCustomLineItemErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateResourcesFromCustomLineItemErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateResourcesFromCustomLineItemErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateResourcesFromCustomLineItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateResourcesFromCustomLineItemErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateResourcesFromCustomLineItemErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchDisassociateResourcesFromCustomLineItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisassociateResourcesFromCustomLineItemErrorKind::AccessDeniedException(
                _inner,
            ) => Some(_inner),
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateResourcesFromCustomLineItemErrorKind::InternalServerException(
                _inner,
            ) => Some(_inner),
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateResourcesFromCustomLineItemErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateResourcesFromCustomLineItemErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBillingGroupError {
    /// Kind of error that occurred.
    pub kind: CreateBillingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBillingGroupErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a service limit to exceed. </p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBillingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBillingGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBillingGroupError {
    fn code(&self) -> Option<&str> {
        CreateBillingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBillingGroupError {
    /// Creates a new `CreateBillingGroupError`.
    pub fn new(kind: CreateBillingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBillingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBillingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBillingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBillingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateBillingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBillingGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomLineItemError {
    /// Kind of error that occurred.
    pub kind: CreateCustomLineItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomLineItemErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a service limit to exceed. </p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomLineItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomLineItemErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateCustomLineItemErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateCustomLineItemErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateCustomLineItemErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            CreateCustomLineItemErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateCustomLineItemErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateCustomLineItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomLineItemError {
    fn code(&self) -> Option<&str> {
        CreateCustomLineItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomLineItemError {
    /// Creates a new `CreateCustomLineItemError`.
    pub fn new(kind: CreateCustomLineItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomLineItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomLineItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomLineItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomLineItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomLineItemErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomLineItemErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomLineItemErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomLineItemErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomLineItemErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomLineItemErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomLineItemErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomLineItemErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomLineItemErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomLineItemErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomLineItemErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomLineItemErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateCustomLineItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomLineItemErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCustomLineItemErrorKind::ConflictException(_inner) => Some(_inner),
            CreateCustomLineItemErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateCustomLineItemErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            CreateCustomLineItemErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateCustomLineItemErrorKind::ValidationException(_inner) => Some(_inner),
            CreateCustomLineItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePricingPlanError {
    /// Kind of error that occurred.
    pub kind: CreatePricingPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePricingPlanErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would cause a service limit to exceed. </p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePricingPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePricingPlanErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePricingPlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePricingPlanErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePricingPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePricingPlanErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            CreatePricingPlanErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePricingPlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePricingPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePricingPlanError {
    fn code(&self) -> Option<&str> {
        CreatePricingPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePricingPlanError {
    /// Creates a new `CreatePricingPlanError`.
    pub fn new(kind: CreatePricingPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePricingPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePricingPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePricingPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePricingPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePricingPlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingPlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingPlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreatePricingPlanErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreatePricingPlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingPlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingPlanErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingPlanErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingPlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingPlanErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingPlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingPlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreatePricingPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePricingPlanErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePricingPlanErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePricingPlanErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePricingPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePricingPlanErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            CreatePricingPlanErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePricingPlanErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePricingPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePricingRuleError {
    /// Kind of error that occurred.
    pub kind: CreatePricingRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePricingRuleErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a service limit to exceed. </p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePricingRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePricingRuleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreatePricingRuleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePricingRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePricingRuleErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            CreatePricingRuleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePricingRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePricingRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePricingRuleError {
    fn code(&self) -> Option<&str> {
        CreatePricingRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePricingRuleError {
    /// Creates a new `CreatePricingRuleError`.
    pub fn new(kind: CreatePricingRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePricingRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePricingRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePricingRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePricingRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePricingRuleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingRuleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingRuleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreatePricingRuleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreatePricingRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingRuleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingRuleErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingRuleErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingRuleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingRuleErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePricingRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePricingRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreatePricingRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePricingRuleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreatePricingRuleErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePricingRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePricingRuleErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            CreatePricingRuleErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePricingRuleErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePricingRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBillingGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteBillingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBillingGroupErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBillingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBillingGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBillingGroupError {
    fn code(&self) -> Option<&str> {
        DeleteBillingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBillingGroupError {
    /// Creates a new `DeleteBillingGroupError`.
    pub fn new(kind: DeleteBillingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBillingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBillingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBillingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBillingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteBillingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBillingGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomLineItemError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomLineItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomLineItemErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomLineItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomLineItemErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteCustomLineItemErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteCustomLineItemErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteCustomLineItemErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCustomLineItemErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCustomLineItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomLineItemError {
    fn code(&self) -> Option<&str> {
        DeleteCustomLineItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomLineItemError {
    /// Creates a new `DeleteCustomLineItemError`.
    pub fn new(kind: DeleteCustomLineItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomLineItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomLineItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomLineItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomLineItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomLineItemErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomLineItemErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomLineItemErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomLineItemErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomLineItemErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomLineItemErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomLineItemErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomLineItemErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomLineItemErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomLineItemErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteCustomLineItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomLineItemErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCustomLineItemErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteCustomLineItemErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteCustomLineItemErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCustomLineItemErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCustomLineItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePricingPlanError {
    /// Kind of error that occurred.
    pub kind: DeletePricingPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePricingPlanErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePricingPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePricingPlanErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePricingPlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePricingPlanErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePricingPlanErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePricingPlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePricingPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePricingPlanError {
    fn code(&self) -> Option<&str> {
        DeletePricingPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePricingPlanError {
    /// Creates a new `DeletePricingPlanError`.
    pub fn new(kind: DeletePricingPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePricingPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePricingPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePricingPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePricingPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePricingPlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingPlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePricingPlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePricingPlanErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePricingPlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingPlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePricingPlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingPlanErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePricingPlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingPlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePricingPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePricingPlanErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePricingPlanErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePricingPlanErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePricingPlanErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePricingPlanErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePricingPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePricingRuleError {
    /// Kind of error that occurred.
    pub kind: DeletePricingRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePricingRuleErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePricingRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePricingRuleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePricingRuleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePricingRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePricingRuleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePricingRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePricingRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePricingRuleError {
    fn code(&self) -> Option<&str> {
        DeletePricingRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePricingRuleError {
    /// Creates a new `DeletePricingRuleError`.
    pub fn new(kind: DeletePricingRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePricingRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePricingRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePricingRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePricingRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePricingRuleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingRuleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePricingRuleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePricingRuleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePricingRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingRuleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePricingRuleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingRuleErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePricingRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePricingRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePricingRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePricingRuleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePricingRuleErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePricingRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePricingRuleErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePricingRuleErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePricingRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateAccountsError {
    /// Kind of error that occurred.
    pub kind: DisassociateAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateAccountsErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateAccountsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateAccountsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateAccountsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateAccountsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateAccountsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateAccountsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateAccountsError {
    fn code(&self) -> Option<&str> {
        DisassociateAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateAccountsError {
    /// Creates a new `DisassociateAccountsError`.
    pub fn new(kind: DisassociateAccountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateAccountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateAccountsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAccountsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAccountsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAccountsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAccountsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAccountsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAccountsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAccountsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAccountsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAccountsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAccountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAccountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateAccountsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateAccountsErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateAccountsErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateAccountsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateAccountsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateAccountsErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociatePricingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociatePricingRulesError {
    /// Kind of error that occurred.
    pub kind: DisassociatePricingRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociatePricingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociatePricingRulesErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociatePricingRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociatePricingRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociatePricingRulesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociatePricingRulesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociatePricingRulesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociatePricingRulesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociatePricingRulesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociatePricingRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociatePricingRulesError {
    fn code(&self) -> Option<&str> {
        DisassociatePricingRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociatePricingRulesError {
    /// Creates a new `DisassociatePricingRulesError`.
    pub fn new(kind: DisassociatePricingRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociatePricingRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociatePricingRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociatePricingRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociatePricingRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociatePricingRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePricingRulesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePricingRulesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePricingRulesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePricingRulesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePricingRulesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePricingRulesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePricingRulesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePricingRulesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePricingRulesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePricingRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePricingRulesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociatePricingRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociatePricingRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociatePricingRulesErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociatePricingRulesErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociatePricingRulesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociatePricingRulesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociatePricingRulesErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociatePricingRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountAssociationsError {
    /// Kind of error that occurred.
    pub kind: ListAccountAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountAssociationsErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountAssociationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAccountAssociationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAccountAssociationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAccountAssociationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAccountAssociationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAccountAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountAssociationsError {
    fn code(&self) -> Option<&str> {
        ListAccountAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountAssociationsError {
    /// Creates a new `ListAccountAssociationsError`.
    pub fn new(kind: ListAccountAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountAssociationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssociationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssociationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssociationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssociationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountAssociationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAssociationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAccountAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountAssociationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAccountAssociationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAccountAssociationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAccountAssociationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAccountAssociationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAccountAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBillingGroupCostReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBillingGroupCostReportsError {
    /// Kind of error that occurred.
    pub kind: ListBillingGroupCostReportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBillingGroupCostReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBillingGroupCostReportsErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBillingGroupCostReportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBillingGroupCostReportsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListBillingGroupCostReportsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBillingGroupCostReportsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListBillingGroupCostReportsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBillingGroupCostReportsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBillingGroupCostReportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBillingGroupCostReportsError {
    fn code(&self) -> Option<&str> {
        ListBillingGroupCostReportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBillingGroupCostReportsError {
    /// Creates a new `ListBillingGroupCostReportsError`.
    pub fn new(kind: ListBillingGroupCostReportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBillingGroupCostReportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBillingGroupCostReportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBillingGroupCostReportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBillingGroupCostReportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBillingGroupCostReportsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupCostReportsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupCostReportsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupCostReportsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupCostReportsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupCostReportsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupCostReportsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupCostReportsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupCostReportsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupCostReportsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListBillingGroupCostReportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBillingGroupCostReportsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListBillingGroupCostReportsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBillingGroupCostReportsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBillingGroupCostReportsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBillingGroupCostReportsErrorKind::ValidationException(_inner) => Some(_inner),
            ListBillingGroupCostReportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBillingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBillingGroupsError {
    /// Kind of error that occurred.
    pub kind: ListBillingGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBillingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBillingGroupsErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBillingGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBillingGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBillingGroupsError {
    fn code(&self) -> Option<&str> {
        ListBillingGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBillingGroupsError {
    /// Creates a new `ListBillingGroupsError`.
    pub fn new(kind: ListBillingGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBillingGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBillingGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBillingGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBillingGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListBillingGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBillingGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::ValidationException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomLineItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomLineItemsError {
    /// Kind of error that occurred.
    pub kind: ListCustomLineItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomLineItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomLineItemsErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomLineItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomLineItemsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCustomLineItemsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCustomLineItemsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListCustomLineItemsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCustomLineItemsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCustomLineItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomLineItemsError {
    fn code(&self) -> Option<&str> {
        ListCustomLineItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomLineItemsError {
    /// Creates a new `ListCustomLineItemsError`.
    pub fn new(kind: ListCustomLineItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomLineItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomLineItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomLineItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomLineItemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCustomLineItemsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomLineItemsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomLineItemsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomLineItemsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomLineItemsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomLineItemsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomLineItemsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomLineItemsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomLineItemsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomLineItemsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListCustomLineItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomLineItemsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCustomLineItemsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCustomLineItemsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListCustomLineItemsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCustomLineItemsErrorKind::ValidationException(_inner) => Some(_inner),
            ListCustomLineItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPricingPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPricingPlansError {
    /// Kind of error that occurred.
    pub kind: ListPricingPlansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPricingPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPricingPlansErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPricingPlansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPricingPlansErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPricingPlansErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPricingPlansErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPricingPlansErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPricingPlansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPricingPlansError {
    fn code(&self) -> Option<&str> {
        ListPricingPlansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPricingPlansError {
    /// Creates a new `ListPricingPlansError`.
    pub fn new(kind: ListPricingPlansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPricingPlansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPricingPlansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPricingPlansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPricingPlansErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPricingPlansErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingPlansErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingPlansErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingPlansErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPricingPlansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPricingPlansErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPricingPlansErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPricingPlansErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPricingPlansErrorKind::ValidationException(_inner) => Some(_inner),
            ListPricingPlansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPricingPlansAssociatedWithPricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPricingPlansAssociatedWithPricingRuleError {
    /// Kind of error that occurred.
    pub kind: ListPricingPlansAssociatedWithPricingRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPricingPlansAssociatedWithPricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPricingPlansAssociatedWithPricingRuleErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPricingPlansAssociatedWithPricingRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPricingPlansAssociatedWithPricingRuleErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPricingPlansAssociatedWithPricingRuleError {
    fn code(&self) -> Option<&str> {
        ListPricingPlansAssociatedWithPricingRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPricingPlansAssociatedWithPricingRuleError {
    /// Creates a new `ListPricingPlansAssociatedWithPricingRuleError`.
    pub fn new(
        kind: ListPricingPlansAssociatedWithPricingRuleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPricingPlansAssociatedWithPricingRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPricingPlansAssociatedWithPricingRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPricingPlansAssociatedWithPricingRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPricingPlansAssociatedWithPricingRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPricingPlansAssociatedWithPricingRuleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansAssociatedWithPricingRuleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingPlansAssociatedWithPricingRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansAssociatedWithPricingRuleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingPlansAssociatedWithPricingRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingPlansAssociatedWithPricingRuleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingPlansAssociatedWithPricingRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPricingPlansAssociatedWithPricingRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPricingPlansAssociatedWithPricingRuleErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListPricingPlansAssociatedWithPricingRuleErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListPricingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPricingRulesError {
    /// Kind of error that occurred.
    pub kind: ListPricingRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPricingRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPricingRulesErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPricingRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPricingRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPricingRulesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPricingRulesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPricingRulesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPricingRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPricingRulesError {
    fn code(&self) -> Option<&str> {
        ListPricingRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPricingRulesError {
    /// Creates a new `ListPricingRulesError`.
    pub fn new(kind: ListPricingRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPricingRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPricingRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPricingRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPricingRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPricingRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingRulesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingRulesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPricingRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPricingRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPricingRulesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPricingRulesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPricingRulesErrorKind::ValidationException(_inner) => Some(_inner),
            ListPricingRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPricingRulesAssociatedToPricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPricingRulesAssociatedToPricingPlanError {
    /// Kind of error that occurred.
    pub kind: ListPricingRulesAssociatedToPricingPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPricingRulesAssociatedToPricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPricingRulesAssociatedToPricingPlanErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPricingRulesAssociatedToPricingPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPricingRulesAssociatedToPricingPlanErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPricingRulesAssociatedToPricingPlanError {
    fn code(&self) -> Option<&str> {
        ListPricingRulesAssociatedToPricingPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPricingRulesAssociatedToPricingPlanError {
    /// Creates a new `ListPricingRulesAssociatedToPricingPlanError`.
    pub fn new(
        kind: ListPricingRulesAssociatedToPricingPlanErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPricingRulesAssociatedToPricingPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPricingRulesAssociatedToPricingPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPricingRulesAssociatedToPricingPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPricingRulesAssociatedToPricingPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPricingRulesAssociatedToPricingPlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesAssociatedToPricingPlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingRulesAssociatedToPricingPlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesAssociatedToPricingPlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingRulesAssociatedToPricingPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesAssociatedToPricingPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingRulesAssociatedToPricingPlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesAssociatedToPricingPlanErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPricingRulesAssociatedToPricingPlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPricingRulesAssociatedToPricingPlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPricingRulesAssociatedToPricingPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPricingRulesAssociatedToPricingPlanErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListPricingRulesAssociatedToPricingPlanErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListResourcesAssociatedToCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesAssociatedToCustomLineItemError {
    /// Kind of error that occurred.
    pub kind: ListResourcesAssociatedToCustomLineItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourcesAssociatedToCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesAssociatedToCustomLineItemErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesAssociatedToCustomLineItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesAssociatedToCustomLineItemErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesAssociatedToCustomLineItemError {
    fn code(&self) -> Option<&str> {
        ListResourcesAssociatedToCustomLineItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesAssociatedToCustomLineItemError {
    /// Creates a new `ListResourcesAssociatedToCustomLineItemError`.
    pub fn new(
        kind: ListResourcesAssociatedToCustomLineItemErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesAssociatedToCustomLineItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesAssociatedToCustomLineItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesAssociatedToCustomLineItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesAssociatedToCustomLineItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourcesAssociatedToCustomLineItemErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesAssociatedToCustomLineItemErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesAssociatedToCustomLineItemErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesAssociatedToCustomLineItemErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesAssociatedToCustomLineItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesAssociatedToCustomLineItemErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesAssociatedToCustomLineItemErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesAssociatedToCustomLineItemErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesAssociatedToCustomLineItemErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesAssociatedToCustomLineItemErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListResourcesAssociatedToCustomLineItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesAssociatedToCustomLineItemErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListResourcesAssociatedToCustomLineItemErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBillingGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateBillingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBillingGroupErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBillingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBillingGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateBillingGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateBillingGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateBillingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateBillingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateBillingGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateBillingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBillingGroupError {
    fn code(&self) -> Option<&str> {
        UpdateBillingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBillingGroupError {
    /// Creates a new `UpdateBillingGroupError`.
    pub fn new(kind: UpdateBillingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBillingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBillingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBillingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBillingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBillingGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBillingGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBillingGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBillingGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBillingGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBillingGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBillingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBillingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBillingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBillingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBillingGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBillingGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateBillingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBillingGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateBillingGroupErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateBillingGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateBillingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateBillingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateBillingGroupErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateBillingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCustomLineItemError {
    /// Kind of error that occurred.
    pub kind: UpdateCustomLineItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCustomLineItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCustomLineItemErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCustomLineItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCustomLineItemErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateCustomLineItemErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateCustomLineItemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateCustomLineItemErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateCustomLineItemErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateCustomLineItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCustomLineItemError {
    fn code(&self) -> Option<&str> {
        UpdateCustomLineItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCustomLineItemError {
    /// Creates a new `UpdateCustomLineItemError`.
    pub fn new(kind: UpdateCustomLineItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCustomLineItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCustomLineItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCustomLineItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCustomLineItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCustomLineItemErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomLineItemErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomLineItemErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomLineItemErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomLineItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomLineItemErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomLineItemErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomLineItemErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomLineItemErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomLineItemErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateCustomLineItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCustomLineItemErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateCustomLineItemErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateCustomLineItemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateCustomLineItemErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateCustomLineItemErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateCustomLineItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePricingPlanError {
    /// Kind of error that occurred.
    pub kind: UpdatePricingPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePricingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePricingPlanErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePricingPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePricingPlanErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePricingPlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePricingPlanErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePricingPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePricingPlanErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePricingPlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePricingPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePricingPlanError {
    fn code(&self) -> Option<&str> {
        UpdatePricingPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePricingPlanError {
    /// Creates a new `UpdatePricingPlanError`.
    pub fn new(kind: UpdatePricingPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePricingPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePricingPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePricingPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePricingPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePricingPlanErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingPlanErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingPlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdatePricingPlanErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdatePricingPlanErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingPlanErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingPlanErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingPlanErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingPlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingPlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePricingPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePricingPlanErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePricingPlanErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePricingPlanErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePricingPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePricingPlanErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePricingPlanErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePricingPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePricingRuleError {
    /// Kind of error that occurred.
    pub kind: UpdatePricingRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePricingRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePricingRuleErrorKind {
    /// <p>You do not have sufficient access to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePricingRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePricingRuleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePricingRuleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePricingRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePricingRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePricingRuleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePricingRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePricingRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePricingRuleError {
    fn code(&self) -> Option<&str> {
        UpdatePricingRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePricingRuleError {
    /// Creates a new `UpdatePricingRuleError`.
    pub fn new(kind: UpdatePricingRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePricingRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePricingRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePricingRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePricingRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePricingRuleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingRuleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingRuleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdatePricingRuleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdatePricingRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingRuleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingRuleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingRuleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingRuleErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePricingRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePricingRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePricingRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePricingRuleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePricingRuleErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePricingRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePricingRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePricingRuleErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePricingRuleErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePricingRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input doesn't match with the constraints specified by Amazon Web Services services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason the request's validation failed. </p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The fields that caused the error, if applicable. </p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason the request's validation failed. </p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The fields that caused the error, if applicable. </p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason the request's validation failed. </p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason the request's validation failed. </p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>The fields that caused the error, if applicable. </p>
        pub fn fields(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input);
            self.fields = Some(v);
            self
        }
        /// <p>The fields that caused the error, if applicable. </p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Number of seconds you can safely retry after the call. </p>
    pub retry_after_seconds: i32,
}
impl ThrottlingException {
    /// <p>Number of seconds you can safely retry after the call. </p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Number of seconds you can safely retry after the call. </p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>Number of seconds you can safely retry after the call. </p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The request references a resource that doesn't exist. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Resource identifier that was not found. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Resource type that was not found. </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>Resource identifier that was not found. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Resource type that was not found. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Resource identifier that was not found. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Resource identifier that was not found. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Resource type that was not found. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Resource type that was not found. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An unexpected error occurred while processing a request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Number of seconds you can retry after the call. </p>
    pub retry_after_seconds: i32,
}
impl InternalServerException {
    /// <p>Number of seconds you can retry after the call. </p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Number of seconds you can retry after the call. </p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>Number of seconds you can retry after the call. </p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request would cause a service limit to exceed. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Identifier of the resource affected. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the resource affected. </p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The unique code identifier of the service limit that is being exceeded. </p>
    pub limit_code: std::option::Option<std::string::String>,
    /// <p>The unique code for the service of the limit that is being exceeded. </p>
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceLimitExceededException {
    /// <p>Identifier of the resource affected. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Type of the resource affected. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The unique code identifier of the service limit that is being exceeded. </p>
    pub fn limit_code(&self) -> std::option::Option<&str> {
        self.limit_code.as_deref()
    }
    /// <p>The unique code for the service of the limit that is being exceeded. </p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("limit_code", &self.limit_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLimitExceededException {}
/// See [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
pub mod service_limit_exceeded_exception {
    /// A builder for [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) limit_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Identifier of the resource affected. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier of the resource affected. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the resource affected. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the resource affected. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The unique code identifier of the service limit that is being exceeded. </p>
        pub fn limit_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_code = Some(input.into());
            self
        }
        /// <p>The unique code identifier of the service limit that is being exceeded. </p>
        pub fn set_limit_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_code = input;
            self
        }
        /// <p>The unique code for the service of the limit that is being exceeded. </p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The unique code for the service of the limit that is being exceeded. </p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
        pub fn build(self) -> crate::error::ServiceLimitExceededException {
            crate::error::ServiceLimitExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                limit_code: self.limit_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    pub fn builder() -> crate::error::service_limit_exceeded_exception::Builder {
        crate::error::service_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You can cause an inconsistent state by updating or deleting a resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Identifier of the resource in use. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the resource in use. </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>Identifier of the resource in use. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Type of the resource in use. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Identifier of the resource in use. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier of the resource in use. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the resource in use. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the resource in use. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
