// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWSBillingConductor
///
/// Client for invoking operations on AWSBillingConductor. Each operation on AWSBillingConductor is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_billingconductor::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_billingconductor::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_billingconductor::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateAccounts`](crate::client::fluent_builders::AssociateAccounts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::AssociateAccounts::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::AssociateAccounts::set_arn): <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::AssociateAccounts::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateAccounts::set_account_ids): <p> The associating array of account IDs. </p>
    /// - On success, responds with [`AssociateAccountsOutput`](crate::output::AssociateAccountsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::AssociateAccountsOutput::arn): <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
    /// - On failure, responds with [`SdkError<AssociateAccountsError>`](crate::error::AssociateAccountsError)
    pub fn associate_accounts(&self) -> fluent_builders::AssociateAccounts {
        fluent_builders::AssociateAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociatePricingRules`](crate::client::fluent_builders::AssociatePricingRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::AssociatePricingRules::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::AssociatePricingRules::set_arn): <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
    ///   - [`pricing_rule_arns(Vec<String>)`](crate::client::fluent_builders::AssociatePricingRules::pricing_rule_arns) / [`set_pricing_rule_arns(Option<Vec<String>>)`](crate::client::fluent_builders::AssociatePricingRules::set_pricing_rule_arns): <p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>
    /// - On success, responds with [`AssociatePricingRulesOutput`](crate::output::AssociatePricingRulesOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::AssociatePricingRulesOutput::arn): <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
    /// - On failure, responds with [`SdkError<AssociatePricingRulesError>`](crate::error::AssociatePricingRulesError)
    pub fn associate_pricing_rules(&self) -> fluent_builders::AssociatePricingRules {
        fluent_builders::AssociatePricingRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchAssociateResourcesToCustomLineItem`](crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem::set_target_arn): <p> A percentage custom line item ARN to associate the resources to. </p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem::set_resource_arns): <p> A list containing the ARNs of the resources to be associated. </p>
    ///   - [`billing_period_range(CustomLineItemBillingPeriodRange)`](crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem::billing_period_range) / [`set_billing_period_range(Option<CustomLineItemBillingPeriodRange>)`](crate::client::fluent_builders::BatchAssociateResourcesToCustomLineItem::set_billing_period_range): <p> The billing period range in which the custom line item request will be applied. </p>
    /// - On success, responds with [`BatchAssociateResourcesToCustomLineItemOutput`](crate::output::BatchAssociateResourcesToCustomLineItemOutput) with field(s):
    ///   - [`successfully_associated_resources(Option<Vec<AssociateResourceResponseElement>>)`](crate::output::BatchAssociateResourcesToCustomLineItemOutput::successfully_associated_resources): <p> A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a percentage custom line item successfully. </p>
    ///   - [`failed_associated_resources(Option<Vec<AssociateResourceResponseElement>>)`](crate::output::BatchAssociateResourcesToCustomLineItemOutput::failed_associated_resources): <p> A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a percentage custom line item. </p>
    /// - On failure, responds with [`SdkError<BatchAssociateResourcesToCustomLineItemError>`](crate::error::BatchAssociateResourcesToCustomLineItemError)
    pub fn batch_associate_resources_to_custom_line_item(
        &self,
    ) -> fluent_builders::BatchAssociateResourcesToCustomLineItem {
        fluent_builders::BatchAssociateResourcesToCustomLineItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDisassociateResourcesFromCustomLineItem`](crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem::set_target_arn): <p> A percentage custom line item ARN to disassociate the resources from. </p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem::set_resource_arns): <p> A list containing the ARNs of resources to be disassociated. </p>
    ///   - [`billing_period_range(CustomLineItemBillingPeriodRange)`](crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem::billing_period_range) / [`set_billing_period_range(Option<CustomLineItemBillingPeriodRange>)`](crate::client::fluent_builders::BatchDisassociateResourcesFromCustomLineItem::set_billing_period_range): <p> The billing period range in which the custom line item request will be applied. </p>
    /// - On success, responds with [`BatchDisassociateResourcesFromCustomLineItemOutput`](crate::output::BatchDisassociateResourcesFromCustomLineItemOutput) with field(s):
    ///   - [`successfully_disassociated_resources(Option<Vec<DisassociateResourceResponseElement>>)`](crate::output::BatchDisassociateResourcesFromCustomLineItemOutput::successfully_disassociated_resources): <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a percentage custom line item successfully. </p>
    ///   - [`failed_disassociated_resources(Option<Vec<DisassociateResourceResponseElement>>)`](crate::output::BatchDisassociateResourcesFromCustomLineItemOutput::failed_disassociated_resources): <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from a percentage custom line item. </p>
    /// - On failure, responds with [`SdkError<BatchDisassociateResourcesFromCustomLineItemError>`](crate::error::BatchDisassociateResourcesFromCustomLineItemError)
    pub fn batch_disassociate_resources_from_custom_line_item(
        &self,
    ) -> fluent_builders::BatchDisassociateResourcesFromCustomLineItem {
        fluent_builders::BatchDisassociateResourcesFromCustomLineItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBillingGroup`](crate::client::fluent_builders::CreateBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateBillingGroup::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateBillingGroup::set_client_token): <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateBillingGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateBillingGroup::set_name): <p> The billing group name. The names must be unique. </p>
    ///   - [`account_grouping(AccountGrouping)`](crate::client::fluent_builders::CreateBillingGroup::account_grouping) / [`set_account_grouping(Option<AccountGrouping>)`](crate::client::fluent_builders::CreateBillingGroup::set_account_grouping): <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
    ///   - [`computation_preference(ComputationPreference)`](crate::client::fluent_builders::CreateBillingGroup::computation_preference) / [`set_computation_preference(Option<ComputationPreference>)`](crate::client::fluent_builders::CreateBillingGroup::set_computation_preference): <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    ///   - [`primary_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateBillingGroup::primary_account_id) / [`set_primary_account_id(Option<String>)`](crate::client::fluent_builders::CreateBillingGroup::set_primary_account_id): <p> The account ID that serves as the main account in a billing group. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateBillingGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateBillingGroup::set_description): <p>The billing group description. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateBillingGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBillingGroup::set_tags): <p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta. </p>
    /// - On success, responds with [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateBillingGroupOutput::arn): <p>The Amazon Resource Name (ARN) of the created billing group. </p>
    /// - On failure, responds with [`SdkError<CreateBillingGroupError>`](crate::error::CreateBillingGroupError)
    pub fn create_billing_group(&self) -> fluent_builders::CreateBillingGroup {
        fluent_builders::CreateBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomLineItem`](crate::client::fluent_builders::CreateCustomLineItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCustomLineItem::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCustomLineItem::set_client_token): <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomLineItem::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateCustomLineItem::set_name): <p> The name of the custom line item. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCustomLineItem::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCustomLineItem::set_description): <p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>
    ///   - [`billing_group_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCustomLineItem::billing_group_arn) / [`set_billing_group_arn(Option<String>)`](crate::client::fluent_builders::CreateCustomLineItem::set_billing_group_arn): <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
    ///   - [`billing_period_range(CustomLineItemBillingPeriodRange)`](crate::client::fluent_builders::CreateCustomLineItem::billing_period_range) / [`set_billing_period_range(Option<CustomLineItemBillingPeriodRange>)`](crate::client::fluent_builders::CreateCustomLineItem::set_billing_period_range): <p> A time range for which the custom line item is effective. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateCustomLineItem::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateCustomLineItem::set_tags): <p> A map that contains tag keys and tag values that are attached to a custom line item. </p>
    ///   - [`charge_details(CustomLineItemChargeDetails)`](crate::client::fluent_builders::CreateCustomLineItem::charge_details) / [`set_charge_details(Option<CustomLineItemChargeDetails>)`](crate::client::fluent_builders::CreateCustomLineItem::set_charge_details): <p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>
    /// - On success, responds with [`CreateCustomLineItemOutput`](crate::output::CreateCustomLineItemOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateCustomLineItemOutput::arn): <p> The Amazon Resource Name (ARN) of the created custom line item. </p>
    /// - On failure, responds with [`SdkError<CreateCustomLineItemError>`](crate::error::CreateCustomLineItemError)
    pub fn create_custom_line_item(&self) -> fluent_builders::CreateCustomLineItem {
        fluent_builders::CreateCustomLineItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePricingPlan`](crate::client::fluent_builders::CreatePricingPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreatePricingPlan::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreatePricingPlan::set_client_token): <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePricingPlan::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePricingPlan::set_name): <p>The pricing plan name. The names must be unique to each pricing plan. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePricingPlan::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePricingPlan::set_description): <p>The pricing plan description. </p>
    ///   - [`pricing_rule_arns(Vec<String>)`](crate::client::fluent_builders::CreatePricingPlan::pricing_rule_arns) / [`set_pricing_rule_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreatePricingPlan::set_pricing_rule_arns): <p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreatePricingPlan::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreatePricingPlan::set_tags): <p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>
    /// - On success, responds with [`CreatePricingPlanOutput`](crate::output::CreatePricingPlanOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreatePricingPlanOutput::arn): <p>The Amazon Resource Name (ARN) of the created pricing plan.</p>
    /// - On failure, responds with [`SdkError<CreatePricingPlanError>`](crate::error::CreatePricingPlanError)
    pub fn create_pricing_plan(&self) -> fluent_builders::CreatePricingPlan {
        fluent_builders::CreatePricingPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePricingRule`](crate::client::fluent_builders::CreatePricingRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreatePricingRule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreatePricingRule::set_client_token): <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePricingRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePricingRule::set_name): <p> The pricing rule name. The names must be unique to each pricing rule. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePricingRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePricingRule::set_description): <p> The pricing rule description. </p>
    ///   - [`scope(PricingRuleScope)`](crate::client::fluent_builders::CreatePricingRule::scope) / [`set_scope(Option<PricingRuleScope>)`](crate::client::fluent_builders::CreatePricingRule::set_scope): <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
    ///   - [`r#type(PricingRuleType)`](crate::client::fluent_builders::CreatePricingRule::type) / [`set_type(Option<PricingRuleType>)`](crate::client::fluent_builders::CreatePricingRule::set_type): <p> The type of pricing rule. </p>
    ///   - [`modifier_percentage(f64)`](crate::client::fluent_builders::CreatePricingRule::modifier_percentage) / [`set_modifier_percentage(Option<f64>)`](crate::client::fluent_builders::CreatePricingRule::set_modifier_percentage): <p> A percentage modifier applied on the public pricing rates. </p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::CreatePricingRule::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::CreatePricingRule::set_service): <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreatePricingRule::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreatePricingRule::set_tags): <p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>
    /// - On success, responds with [`CreatePricingRuleOutput`](crate::output::CreatePricingRuleOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreatePricingRuleOutput::arn): <p> The Amazon Resource Name (ARN) of the created pricing rule. </p>
    /// - On failure, responds with [`SdkError<CreatePricingRuleError>`](crate::error::CreatePricingRuleError)
    pub fn create_pricing_rule(&self) -> fluent_builders::CreatePricingRule {
        fluent_builders::CreatePricingRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBillingGroup`](crate::client::fluent_builders::DeleteBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteBillingGroup::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteBillingGroup::set_arn): <p>The Amazon Resource Name (ARN) of the billing group you're deleting.</p>
    /// - On success, responds with [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteBillingGroupOutput::arn): <p>The Amazon Resource Name (ARN) of the deleted billing group.</p>
    /// - On failure, responds with [`SdkError<DeleteBillingGroupError>`](crate::error::DeleteBillingGroupError)
    pub fn delete_billing_group(&self) -> fluent_builders::DeleteBillingGroup {
        fluent_builders::DeleteBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomLineItem`](crate::client::fluent_builders::DeleteCustomLineItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomLineItem::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteCustomLineItem::set_arn): <p> The ARN of the custom line item to be deleted. </p>
    ///   - [`billing_period_range(CustomLineItemBillingPeriodRange)`](crate::client::fluent_builders::DeleteCustomLineItem::billing_period_range) / [`set_billing_period_range(Option<CustomLineItemBillingPeriodRange>)`](crate::client::fluent_builders::DeleteCustomLineItem::set_billing_period_range): <p> The billing period range in which the custom line item request will be applied. </p>
    /// - On success, responds with [`DeleteCustomLineItemOutput`](crate::output::DeleteCustomLineItemOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteCustomLineItemOutput::arn): <p> Then ARN of the deleted custom line item. </p>
    /// - On failure, responds with [`SdkError<DeleteCustomLineItemError>`](crate::error::DeleteCustomLineItemError)
    pub fn delete_custom_line_item(&self) -> fluent_builders::DeleteCustomLineItem {
        fluent_builders::DeleteCustomLineItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePricingPlan`](crate::client::fluent_builders::DeletePricingPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeletePricingPlan::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeletePricingPlan::set_arn): <p>The Amazon Resource Name (ARN) of the pricing plan you're deleting. </p>
    /// - On success, responds with [`DeletePricingPlanOutput`](crate::output::DeletePricingPlanOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeletePricingPlanOutput::arn): <p> The Amazon Resource Name (ARN) of the deleted pricing plan. </p>
    /// - On failure, responds with [`SdkError<DeletePricingPlanError>`](crate::error::DeletePricingPlanError)
    pub fn delete_pricing_plan(&self) -> fluent_builders::DeletePricingPlan {
        fluent_builders::DeletePricingPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePricingRule`](crate::client::fluent_builders::DeletePricingRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeletePricingRule::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeletePricingRule::set_arn): <p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>
    /// - On success, responds with [`DeletePricingRuleOutput`](crate::output::DeletePricingRuleOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeletePricingRuleOutput::arn): <p> The Amazon Resource Name (ARN) of the deleted pricing rule. </p>
    /// - On failure, responds with [`SdkError<DeletePricingRuleError>`](crate::error::DeletePricingRuleError)
    pub fn delete_pricing_rule(&self) -> fluent_builders::DeletePricingRule {
        fluent_builders::DeletePricingRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateAccounts`](crate::client::fluent_builders::DisassociateAccounts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateAccounts::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DisassociateAccounts::set_arn): <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DisassociateAccounts::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateAccounts::set_account_ids): <p>The array of account IDs to disassociate. </p>
    /// - On success, responds with [`DisassociateAccountsOutput`](crate::output::DisassociateAccountsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DisassociateAccountsOutput::arn): <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs is disassociated from. </p>
    /// - On failure, responds with [`SdkError<DisassociateAccountsError>`](crate::error::DisassociateAccountsError)
    pub fn disassociate_accounts(&self) -> fluent_builders::DisassociateAccounts {
        fluent_builders::DisassociateAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociatePricingRules`](crate::client::fluent_builders::DisassociatePricingRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DisassociatePricingRules::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DisassociatePricingRules::set_arn): <p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>
    ///   - [`pricing_rule_arns(Vec<String>)`](crate::client::fluent_builders::DisassociatePricingRules::pricing_rule_arns) / [`set_pricing_rule_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociatePricingRules::set_pricing_rule_arns): <p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>
    /// - On success, responds with [`DisassociatePricingRulesOutput`](crate::output::DisassociatePricingRulesOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DisassociatePricingRulesOutput::arn): <p> The Amazon Resource Name (ARN) of the pricing plan that the pricing rules successfully disassociated from. </p>
    /// - On failure, responds with [`SdkError<DisassociatePricingRulesError>`](crate::error::DisassociatePricingRulesError)
    pub fn disassociate_pricing_rules(&self) -> fluent_builders::DisassociatePricingRules {
        fluent_builders::DisassociatePricingRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountAssociations`](crate::client::fluent_builders::ListAccountAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssociations::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListAccountAssociations::set_billing_period): <p> The preferred billing period to get account associations. </p>
    ///   - [`filters(ListAccountAssociationsFilter)`](crate::client::fluent_builders::ListAccountAssociations::filters) / [`set_filters(Option<ListAccountAssociationsFilter>)`](crate::client::fluent_builders::ListAccountAssociations::set_filters): <p>The filter on the account ID of the linked account, or any of the following:</p>  <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>  <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>  <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountAssociations::set_next_token): <p> The pagination token used on subsequent calls to retrieve accounts. </p>
    /// - On success, responds with [`ListAccountAssociationsOutput`](crate::output::ListAccountAssociationsOutput) with field(s):
    ///   - [`linked_accounts(Option<Vec<AccountAssociationsListElement>>)`](crate::output::ListAccountAssociationsOutput::linked_accounts): <p> The list of linked accounts in the payer account. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountAssociationsOutput::next_token): <p> The pagination token used on subsequent calls to get accounts. </p>
    /// - On failure, responds with [`SdkError<ListAccountAssociationsError>`](crate::error::ListAccountAssociationsError)
    pub fn list_account_associations(&self) -> fluent_builders::ListAccountAssociations {
        fluent_builders::ListAccountAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBillingGroupCostReports`](crate::client::fluent_builders::ListBillingGroupCostReports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBillingGroupCostReports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListBillingGroupCostReports::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListBillingGroupCostReports::set_billing_period): <p>The preferred billing period for your report. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBillingGroupCostReports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBillingGroupCostReports::set_max_results): <p>The maximum number of reports to retrieve. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBillingGroupCostReports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBillingGroupCostReports::set_next_token): <p>The pagination token used on subsequent calls to get reports. </p>
    ///   - [`filters(ListBillingGroupCostReportsFilter)`](crate::client::fluent_builders::ListBillingGroupCostReports::filters) / [`set_filters(Option<ListBillingGroupCostReportsFilter>)`](crate::client::fluent_builders::ListBillingGroupCostReports::set_filters): <p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>
    /// - On success, responds with [`ListBillingGroupCostReportsOutput`](crate::output::ListBillingGroupCostReportsOutput) with field(s):
    ///   - [`billing_group_cost_reports(Option<Vec<BillingGroupCostReportElement>>)`](crate::output::ListBillingGroupCostReportsOutput::billing_group_cost_reports): <p>A list of <code>BillingGroupCostReportElement</code> retrieved. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBillingGroupCostReportsOutput::next_token): <p>The pagination token used on subsequent calls to get reports. </p>
    /// - On failure, responds with [`SdkError<ListBillingGroupCostReportsError>`](crate::error::ListBillingGroupCostReportsError)
    pub fn list_billing_group_cost_reports(&self) -> fluent_builders::ListBillingGroupCostReports {
        fluent_builders::ListBillingGroupCostReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBillingGroups`](crate::client::fluent_builders::ListBillingGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBillingGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListBillingGroups::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListBillingGroups::set_billing_period): <p>The preferred billing period to get billing groups. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBillingGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBillingGroups::set_max_results): <p>The maximum number of billing groups to retrieve. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBillingGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBillingGroups::set_next_token): <p>The pagination token used on subsequent calls to get billing groups. </p>
    ///   - [`filters(ListBillingGroupsFilter)`](crate::client::fluent_builders::ListBillingGroups::filters) / [`set_filters(Option<ListBillingGroupsFilter>)`](crate::client::fluent_builders::ListBillingGroups::set_filters): <p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>
    /// - On success, responds with [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput) with field(s):
    ///   - [`billing_groups(Option<Vec<BillingGroupListElement>>)`](crate::output::ListBillingGroupsOutput::billing_groups): <p>A list of <code>BillingGroupListElement</code> retrieved. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBillingGroupsOutput::next_token): <p>The pagination token used on subsequent calls to get billing groups. </p>
    /// - On failure, responds with [`SdkError<ListBillingGroupsError>`](crate::error::ListBillingGroupsError)
    pub fn list_billing_groups(&self) -> fluent_builders::ListBillingGroups {
        fluent_builders::ListBillingGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomLineItems`](crate::client::fluent_builders::ListCustomLineItems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomLineItems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListCustomLineItems::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListCustomLineItems::set_billing_period): <p> The preferred billing period to get custom line items (FFLIs). </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomLineItems::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomLineItems::set_max_results): <p> The maximum number of billing groups to retrieve. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomLineItems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomLineItems::set_next_token): <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
    ///   - [`filters(ListCustomLineItemsFilter)`](crate::client::fluent_builders::ListCustomLineItems::filters) / [`set_filters(Option<ListCustomLineItemsFilter>)`](crate::client::fluent_builders::ListCustomLineItems::set_filters): <p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>
    /// - On success, responds with [`ListCustomLineItemsOutput`](crate::output::ListCustomLineItemsOutput) with field(s):
    ///   - [`custom_line_items(Option<Vec<CustomLineItemListElement>>)`](crate::output::ListCustomLineItemsOutput::custom_line_items): <p> A list of <code>FreeFormLineItemListElements</code> received. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomLineItemsOutput::next_token): <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
    /// - On failure, responds with [`SdkError<ListCustomLineItemsError>`](crate::error::ListCustomLineItemsError)
    pub fn list_custom_line_items(&self) -> fluent_builders::ListCustomLineItems {
        fluent_builders::ListCustomLineItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPricingPlans`](crate::client::fluent_builders::ListPricingPlans) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPricingPlans::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListPricingPlans::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListPricingPlans::set_billing_period): <p>The preferred billing period to get pricing plan. </p>
    ///   - [`filters(ListPricingPlansFilter)`](crate::client::fluent_builders::ListPricingPlans::filters) / [`set_filters(Option<ListPricingPlansFilter>)`](crate::client::fluent_builders::ListPricingPlans::set_filters): <p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPricingPlans::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPricingPlans::set_max_results): <p>The maximum number of pricing plans to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPricingPlans::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPricingPlans::set_next_token): <p>The pagination token used on subsequent call to get pricing plans. </p>
    /// - On success, responds with [`ListPricingPlansOutput`](crate::output::ListPricingPlansOutput) with field(s):
    ///   - [`billing_period(Option<String>)`](crate::output::ListPricingPlansOutput::billing_period): <p> The billing period for which the described pricing plans are applicable. </p>
    ///   - [`pricing_plans(Option<Vec<PricingPlanListElement>>)`](crate::output::ListPricingPlansOutput::pricing_plans): <p>A list of <code>PricingPlanListElement</code> retrieved. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPricingPlansOutput::next_token): <p>The pagination token used on subsequent calls to get pricing plans. </p>
    /// - On failure, responds with [`SdkError<ListPricingPlansError>`](crate::error::ListPricingPlansError)
    pub fn list_pricing_plans(&self) -> fluent_builders::ListPricingPlans {
        fluent_builders::ListPricingPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPricingPlansAssociatedWithPricingRule`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::set_billing_period): <p> The pricing plan billing period for which associations will be listed. </p>
    ///   - [`pricing_rule_arn(impl Into<String>)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::pricing_rule_arn) / [`set_pricing_rule_arn(Option<String>)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::set_pricing_rule_arn): <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::set_max_results): <p> The optional maximum number of pricing rule associations to retrieve. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPricingPlansAssociatedWithPricingRule::set_next_token): <p> The optional pagination token returned by a previous call. </p>
    /// - On success, responds with [`ListPricingPlansAssociatedWithPricingRuleOutput`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput) with field(s):
    ///   - [`billing_period(Option<String>)`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput::billing_period): <p> The pricing plan billing period for which associations will be listed. </p>
    ///   - [`pricing_rule_arn(Option<String>)`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput::pricing_rule_arn): <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
    ///   - [`pricing_plan_arns(Option<Vec<String>>)`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput::pricing_plan_arns): <p> The list containing pricing plans associated with the requested pricing rule. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput::next_token): <p> The pagination token to be used on subsequent calls. </p>
    /// - On failure, responds with [`SdkError<ListPricingPlansAssociatedWithPricingRuleError>`](crate::error::ListPricingPlansAssociatedWithPricingRuleError)
    pub fn list_pricing_plans_associated_with_pricing_rule(
        &self,
    ) -> fluent_builders::ListPricingPlansAssociatedWithPricingRule {
        fluent_builders::ListPricingPlansAssociatedWithPricingRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPricingRules`](crate::client::fluent_builders::ListPricingRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPricingRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListPricingRules::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListPricingRules::set_billing_period): <p> The preferred billing period to get the pricing plan. </p>
    ///   - [`filters(ListPricingRulesFilter)`](crate::client::fluent_builders::ListPricingRules::filters) / [`set_filters(Option<ListPricingRulesFilter>)`](crate::client::fluent_builders::ListPricingRules::set_filters): <p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPricingRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPricingRules::set_max_results): <p> The maximum number of pricing rules to retrieve. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPricingRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPricingRules::set_next_token): <p> The pagination token used on subsequent call to get pricing rules. </p>
    /// - On success, responds with [`ListPricingRulesOutput`](crate::output::ListPricingRulesOutput) with field(s):
    ///   - [`billing_period(Option<String>)`](crate::output::ListPricingRulesOutput::billing_period): <p> The billing period for which the described pricing rules are applicable. </p>
    ///   - [`pricing_rules(Option<Vec<PricingRuleListElement>>)`](crate::output::ListPricingRulesOutput::pricing_rules): <p> A list containing the described pricing rules. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPricingRulesOutput::next_token): <p> The pagination token used on subsequent calls to get pricing rules. </p>
    /// - On failure, responds with [`SdkError<ListPricingRulesError>`](crate::error::ListPricingRulesError)
    pub fn list_pricing_rules(&self) -> fluent_builders::ListPricingRules {
        fluent_builders::ListPricingRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPricingRulesAssociatedToPricingPlan`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::set_billing_period): <p> The billing period for which the pricing rule associations are to be listed. </p>
    ///   - [`pricing_plan_arn(impl Into<String>)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::pricing_plan_arn) / [`set_pricing_plan_arn(Option<String>)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::set_pricing_plan_arn): <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::set_max_results): <p>The optional maximum number of pricing rule associations to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPricingRulesAssociatedToPricingPlan::set_next_token): <p> The optional pagination token returned by a previous call. </p>
    /// - On success, responds with [`ListPricingRulesAssociatedToPricingPlanOutput`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput) with field(s):
    ///   - [`billing_period(Option<String>)`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput::billing_period): <p> The billing period for which the pricing rule associations are listed. </p>
    ///   - [`pricing_plan_arn(Option<String>)`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput::pricing_plan_arn): <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.</p>
    ///   - [`pricing_rule_arns(Option<Vec<String>>)`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput::pricing_rule_arns): <p> A list containing pricing rules associated with the requested pricing plan. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput::next_token): <p> The pagination token to be used on subsequent calls. </p>
    /// - On failure, responds with [`SdkError<ListPricingRulesAssociatedToPricingPlanError>`](crate::error::ListPricingRulesAssociatedToPricingPlanError)
    pub fn list_pricing_rules_associated_to_pricing_plan(
        &self,
    ) -> fluent_builders::ListPricingRulesAssociatedToPricingPlan {
        fluent_builders::ListPricingRulesAssociatedToPricingPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourcesAssociatedToCustomLineItem`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_period(impl Into<String>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::billing_period) / [`set_billing_period(Option<String>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::set_billing_period): <p> The billing period for which the resource associations will be listed. </p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::set_arn): <p> The ARN of the custom line item for which the resource associations will be listed. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::set_max_results): <p> (Optional) The maximum number of resource associations to be retrieved. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::set_next_token): <p> (Optional) The pagination token returned by a previous request. </p>
    ///   - [`filters(ListResourcesAssociatedToCustomLineItemFilter)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::filters) / [`set_filters(Option<ListResourcesAssociatedToCustomLineItemFilter>)`](crate::client::fluent_builders::ListResourcesAssociatedToCustomLineItem::set_filters): <p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>
    /// - On success, responds with [`ListResourcesAssociatedToCustomLineItemOutput`](crate::output::ListResourcesAssociatedToCustomLineItemOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::ListResourcesAssociatedToCustomLineItemOutput::arn): <p> The custom line item ARN for which the resource associations are listed. </p>
    ///   - [`associated_resources(Option<Vec<ListResourcesAssociatedToCustomLineItemResponseElement>>)`](crate::output::ListResourcesAssociatedToCustomLineItemOutput::associated_resources): <p> A list of <code>ListResourcesAssociatedToCustomLineItemResponseElement</code> for each resource association retrieved. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourcesAssociatedToCustomLineItemOutput::next_token): <p> The pagination token to be used in subsequent requests to retrieve additional results. </p>
    /// - On failure, responds with [`SdkError<ListResourcesAssociatedToCustomLineItemError>`](crate::error::ListResourcesAssociatedToCustomLineItemError)
    pub fn list_resources_associated_to_custom_line_item(
        &self,
    ) -> fluent_builders::ListResourcesAssociatedToCustomLineItem {
        fluent_builders::ListResourcesAssociatedToCustomLineItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p> The tags for the resource. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p> The tags to add to the resource as a list of key-value pairs. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> The tags to delete from the resource as a list of key-value pairs. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBillingGroup`](crate::client::fluent_builders::UpdateBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateBillingGroup::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateBillingGroup::set_arn): <p>The Amazon Resource Name (ARN) of the billing group being updated. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateBillingGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateBillingGroup::set_name): <p>The name of the billing group. The names must be unique to each billing group. </p>
    ///   - [`status(BillingGroupStatus)`](crate::client::fluent_builders::UpdateBillingGroup::status) / [`set_status(Option<BillingGroupStatus>)`](crate::client::fluent_builders::UpdateBillingGroup::set_status): <p>The status of the billing group. Only one of the valid values can be used. </p>
    ///   - [`computation_preference(ComputationPreference)`](crate::client::fluent_builders::UpdateBillingGroup::computation_preference) / [`set_computation_preference(Option<ComputationPreference>)`](crate::client::fluent_builders::UpdateBillingGroup::set_computation_preference): <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateBillingGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateBillingGroup::set_description): <p>A description of the billing group. </p>
    /// - On success, responds with [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateBillingGroupOutput::arn): <p>The Amazon Resource Name (ARN) of the billing group that was updated. </p>
    ///   - [`name(Option<String>)`](crate::output::UpdateBillingGroupOutput::name): <p> The name of the billing group. The names must be unique to each billing group. </p>
    ///   - [`description(Option<String>)`](crate::output::UpdateBillingGroupOutput::description): <p> A description of the billing group. </p>
    ///   - [`primary_account_id(Option<String>)`](crate::output::UpdateBillingGroupOutput::primary_account_id): <p> The account ID that serves as the main account in a billing group. </p>
    ///   - [`pricing_plan_arn(Option<String>)`](crate::output::UpdateBillingGroupOutput::pricing_plan_arn): <p> The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing group. </p>
    ///   - [`size(i64)`](crate::output::UpdateBillingGroupOutput::size): <p> The number of accounts in the particular billing group. </p>
    ///   - [`last_modified_time(i64)`](crate::output::UpdateBillingGroupOutput::last_modified_time): <p> The most recent time the billing group was modified. </p>
    ///   - [`status(Option<BillingGroupStatus>)`](crate::output::UpdateBillingGroupOutput::status): <p> The status of the billing group. Only one of the valid values can be used. </p>
    ///   - [`status_reason(Option<String>)`](crate::output::UpdateBillingGroupOutput::status_reason): <p> The reason why the billing group is in its current status. </p>
    /// - On failure, responds with [`SdkError<UpdateBillingGroupError>`](crate::error::UpdateBillingGroupError)
    pub fn update_billing_group(&self) -> fluent_builders::UpdateBillingGroup {
        fluent_builders::UpdateBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomLineItem`](crate::client::fluent_builders::UpdateCustomLineItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomLineItem::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateCustomLineItem::set_arn): <p> The ARN of the custom line item to be updated. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomLineItem::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateCustomLineItem::set_name): <p> The new name for the custom line item. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomLineItem::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateCustomLineItem::set_description): <p> The new line item description of the custom line item. </p>
    ///   - [`charge_details(UpdateCustomLineItemChargeDetails)`](crate::client::fluent_builders::UpdateCustomLineItem::charge_details) / [`set_charge_details(Option<UpdateCustomLineItemChargeDetails>)`](crate::client::fluent_builders::UpdateCustomLineItem::set_charge_details): <p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>
    ///   - [`billing_period_range(CustomLineItemBillingPeriodRange)`](crate::client::fluent_builders::UpdateCustomLineItem::billing_period_range) / [`set_billing_period_range(Option<CustomLineItemBillingPeriodRange>)`](crate::client::fluent_builders::UpdateCustomLineItem::set_billing_period_range): <p> The billing period range in which the custom line item request will be applied. </p>
    /// - On success, responds with [`UpdateCustomLineItemOutput`](crate::output::UpdateCustomLineItemOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateCustomLineItemOutput::arn): <p> The ARN of the successfully updated custom line item. </p>
    ///   - [`billing_group_arn(Option<String>)`](crate::output::UpdateCustomLineItemOutput::billing_group_arn): <p> The ARN of the billing group that the custom line item is applied to. </p>
    ///   - [`name(Option<String>)`](crate::output::UpdateCustomLineItemOutput::name): <p> The name of the successfully updated custom line item. </p>
    ///   - [`description(Option<String>)`](crate::output::UpdateCustomLineItemOutput::description): <p> The description of the successfully updated custom line item. </p>
    ///   - [`charge_details(Option<ListCustomLineItemChargeDetails>)`](crate::output::UpdateCustomLineItemOutput::charge_details): <p> A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated custom line item. </p>
    ///   - [`last_modified_time(i64)`](crate::output::UpdateCustomLineItemOutput::last_modified_time): <p> The most recent time the custom line item was modified. </p>
    ///   - [`association_size(i64)`](crate::output::UpdateCustomLineItemOutput::association_size): <p> The number of resources that are associated to the custom line item. </p>
    /// - On failure, responds with [`SdkError<UpdateCustomLineItemError>`](crate::error::UpdateCustomLineItemError)
    pub fn update_custom_line_item(&self) -> fluent_builders::UpdateCustomLineItem {
        fluent_builders::UpdateCustomLineItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePricingPlan`](crate::client::fluent_builders::UpdatePricingPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePricingPlan::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdatePricingPlan::set_arn): <p>The Amazon Resource Name (ARN) of the pricing plan you're updating. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdatePricingPlan::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdatePricingPlan::set_name): <p>The name of the pricing plan. The name must be unique to each pricing plan. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePricingPlan::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePricingPlan::set_description): <p>The pricing plan description. </p>
    /// - On success, responds with [`UpdatePricingPlanOutput`](crate::output::UpdatePricingPlanOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdatePricingPlanOutput::arn): <p>The Amazon Resource Name (ARN) of the updated pricing plan. </p>
    ///   - [`name(Option<String>)`](crate::output::UpdatePricingPlanOutput::name): <p> The name of the pricing plan. The name must be unique to each pricing plan. </p>
    ///   - [`description(Option<String>)`](crate::output::UpdatePricingPlanOutput::description): <p> The new description for the pricing rule. </p>
    ///   - [`size(i64)`](crate::output::UpdatePricingPlanOutput::size): <p> The pricing rules count currently associated with this pricing plan list. </p>
    ///   - [`last_modified_time(i64)`](crate::output::UpdatePricingPlanOutput::last_modified_time): <p> The most recent time the pricing plan was modified. </p>
    /// - On failure, responds with [`SdkError<UpdatePricingPlanError>`](crate::error::UpdatePricingPlanError)
    pub fn update_pricing_plan(&self) -> fluent_builders::UpdatePricingPlan {
        fluent_builders::UpdatePricingPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePricingRule`](crate::client::fluent_builders::UpdatePricingRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePricingRule::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdatePricingRule::set_arn): <p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdatePricingRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdatePricingRule::set_name): <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePricingRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePricingRule::set_description): <p> The new description for the pricing rule. </p>
    ///   - [`r#type(PricingRuleType)`](crate::client::fluent_builders::UpdatePricingRule::type) / [`set_type(Option<PricingRuleType>)`](crate::client::fluent_builders::UpdatePricingRule::set_type): <p> The new pricing rule type. </p>
    ///   - [`modifier_percentage(f64)`](crate::client::fluent_builders::UpdatePricingRule::modifier_percentage) / [`set_modifier_percentage(Option<f64>)`](crate::client::fluent_builders::UpdatePricingRule::set_modifier_percentage): <p> The new modifier to show pricing plan rates as a percentage. </p>
    /// - On success, responds with [`UpdatePricingRuleOutput`](crate::output::UpdatePricingRuleOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdatePricingRuleOutput::arn): <p> The Amazon Resource Name (ARN) of the successfully updated pricing rule. </p>
    ///   - [`name(Option<String>)`](crate::output::UpdatePricingRuleOutput::name): <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
    ///   - [`description(Option<String>)`](crate::output::UpdatePricingRuleOutput::description): <p> The new description for the pricing rule. </p>
    ///   - [`scope(Option<PricingRuleScope>)`](crate::output::UpdatePricingRuleOutput::scope): <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
    ///   - [`r#type(Option<PricingRuleType>)`](crate::output::UpdatePricingRuleOutput::type): <p> The new pricing rule type. </p>
    ///   - [`modifier_percentage(Option<f64>)`](crate::output::UpdatePricingRuleOutput::modifier_percentage): <p> The new modifier to show pricing plan rates as a percentage. </p>
    ///   - [`service(Option<String>)`](crate::output::UpdatePricingRuleOutput::service): <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    ///   - [`associated_pricing_plan_count(i64)`](crate::output::UpdatePricingRuleOutput::associated_pricing_plan_count): <p> The pricing plans count that this pricing rule is associated with. </p>
    ///   - [`last_modified_time(i64)`](crate::output::UpdatePricingRuleOutput::last_modified_time): <p> The most recent time the pricing rule was modified. </p>
    /// - On failure, responds with [`SdkError<UpdatePricingRuleError>`](crate::error::UpdatePricingRuleError)
    pub fn update_pricing_rule(&self) -> fluent_builders::UpdatePricingRule {
        fluent_builders::UpdatePricingRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAccounts`.
    ///
    /// <p>Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAccounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_accounts_input::Builder,
    }
    impl AssociateAccounts {
        /// Creates a new `AssociateAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAccountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p> The associating array of account IDs. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p> The associating array of account IDs. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePricingRules`.
    ///
    /// <p>Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number <code>PricingRuleArn</code> that can be associated in one call is 30. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePricingRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_pricing_rules_input::Builder,
    }
    impl AssociatePricingRules {
        /// Creates a new `AssociatePricingRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePricingRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePricingRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `PricingRuleArns`.
        ///
        /// To override the contents of this collection use [`set_pricing_rule_arns`](Self::set_pricing_rule_arns).
        ///
        /// <p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>
        pub fn pricing_rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_rule_arns(input.into());
            self
        }
        /// <p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>
        pub fn set_pricing_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pricing_rule_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateResourcesToCustomLineItem`.
    ///
    /// <p> Associates a batch of resources to a percentage custom line item. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchAssociateResourcesToCustomLineItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_associate_resources_to_custom_line_item_input::Builder,
    }
    impl BatchAssociateResourcesToCustomLineItem {
        /// Creates a new `BatchAssociateResourcesToCustomLineItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateResourcesToCustomLineItemOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchAssociateResourcesToCustomLineItemError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A percentage custom line item ARN to associate the resources to. </p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p> A percentage custom line item ARN to associate the resources to. </p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p> A list containing the ARNs of the resources to be associated. </p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p> A list containing the ARNs of the resources to be associated. </p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.inner = self.inner.billing_period_range(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.inner = self.inner.set_billing_period_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateResourcesFromCustomLineItem`.
    ///
    /// <p> Disassociates a batch of resources from a percentage custom line item. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisassociateResourcesFromCustomLineItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_disassociate_resources_from_custom_line_item_input::Builder,
    }
    impl BatchDisassociateResourcesFromCustomLineItem {
        /// Creates a new `BatchDisassociateResourcesFromCustomLineItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateResourcesFromCustomLineItemOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchDisassociateResourcesFromCustomLineItemError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A percentage custom line item ARN to disassociate the resources from. </p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p> A percentage custom line item ARN to disassociate the resources from. </p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p> A list containing the ARNs of resources to be disassociated. </p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p> A list containing the ARNs of resources to be disassociated. </p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.inner = self.inner.billing_period_range(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.inner = self.inner.set_billing_period_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBillingGroup`.
    ///
    /// <p> Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBillingGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_billing_group_input::Builder,
    }
    impl CreateBillingGroup {
        /// Creates a new `CreateBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBillingGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p> The billing group name. The names must be unique. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The billing group name. The names must be unique. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
        pub fn account_grouping(mut self, input: crate::model::AccountGrouping) -> Self {
            self.inner = self.inner.account_grouping(input);
            self
        }
        /// <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
        pub fn set_account_grouping(
            mut self,
            input: std::option::Option<crate::model::AccountGrouping>,
        ) -> Self {
            self.inner = self.inner.set_account_grouping(input);
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn computation_preference(
            mut self,
            input: crate::model::ComputationPreference,
        ) -> Self {
            self.inner = self.inner.computation_preference(input);
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn set_computation_preference(
            mut self,
            input: std::option::Option<crate::model::ComputationPreference>,
        ) -> Self {
            self.inner = self.inner.set_computation_preference(input);
            self
        }
        /// <p> The account ID that serves as the main account in a billing group. </p>
        pub fn primary_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.primary_account_id(input.into());
            self
        }
        /// <p> The account ID that serves as the main account in a billing group. </p>
        pub fn set_primary_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_account_id(input);
            self
        }
        /// <p>The billing group description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The billing group description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomLineItem`.
    ///
    /// <p> Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomLineItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_line_item_input::Builder,
    }
    impl CreateCustomLineItem {
        /// Creates a new `CreateCustomLineItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomLineItemOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomLineItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p> The name of the custom line item. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the custom line item. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_arn(input);
            self
        }
        /// <p> A time range for which the custom line item is effective. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.inner = self.inner.billing_period_range(input);
            self
        }
        /// <p> A time range for which the custom line item is effective. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.inner = self.inner.set_billing_period_range(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a custom line item. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a custom line item. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>
        pub fn charge_details(mut self, input: crate::model::CustomLineItemChargeDetails) -> Self {
            self.inner = self.inner.charge_details(input);
            self
        }
        /// <p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>
        pub fn set_charge_details(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemChargeDetails>,
        ) -> Self {
            self.inner = self.inner.set_charge_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePricingPlan`.
    ///
    /// <p>Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePricingPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pricing_plan_input::Builder,
    }
    impl CreatePricingPlan {
        /// Creates a new `CreatePricingPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePricingPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePricingPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The pricing plan name. The names must be unique to each pricing plan. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The pricing plan name. The names must be unique to each pricing plan. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `PricingRuleArns`.
        ///
        /// To override the contents of this collection use [`set_pricing_rule_arns`](Self::set_pricing_rule_arns).
        ///
        /// <p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>
        pub fn pricing_rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_rule_arns(input.into());
            self
        }
        /// <p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>
        pub fn set_pricing_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pricing_rule_arns(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePricingRule`.
    ///
    /// <p> Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePricingRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pricing_rule_input::Builder,
    }
    impl CreatePricingRule {
        /// Creates a new `CreatePricingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePricingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePricingRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p> The pricing rule name. The names must be unique to each pricing rule. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The pricing rule name. The names must be unique to each pricing rule. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The pricing rule description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The pricing rule description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
        pub fn scope(mut self, input: crate::model::PricingRuleScope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::PricingRuleScope>,
        ) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p> The type of pricing rule. </p>
        pub fn r#type(mut self, input: crate::model::PricingRuleType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p> The type of pricing rule. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PricingRuleType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p> A percentage modifier applied on the public pricing rates. </p>
        pub fn modifier_percentage(mut self, input: f64) -> Self {
            self.inner = self.inner.modifier_percentage(input);
            self
        }
        /// <p> A percentage modifier applied on the public pricing rates. </p>
        pub fn set_modifier_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_modifier_percentage(input);
            self
        }
        /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBillingGroup`.
    ///
    /// <p> Deletes a billing group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBillingGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_billing_group_input::Builder,
    }
    impl DeleteBillingGroup {
        /// Creates a new `DeleteBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBillingGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group you're deleting.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group you're deleting.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomLineItem`.
    ///
    /// <p> Deletes the custom line item identified by the given ARN in the current, or previous billing period. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomLineItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_line_item_input::Builder,
    }
    impl DeleteCustomLineItem {
        /// Creates a new `DeleteCustomLineItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomLineItemOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomLineItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the custom line item to be deleted. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The ARN of the custom line item to be deleted. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.inner = self.inner.billing_period_range(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.inner = self.inner.set_billing_period_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePricingPlan`.
    ///
    /// <p>Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePricingPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_pricing_plan_input::Builder,
    }
    impl DeletePricingPlan {
        /// Creates a new `DeletePricingPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePricingPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePricingPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're deleting. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're deleting. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePricingRule`.
    ///
    /// <p> Deletes the pricing rule identified by the input Amazon Resource Name (ARN). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePricingRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_pricing_rule_input::Builder,
    }
    impl DeletePricingRule {
        /// Creates a new `DeletePricingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePricingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePricingRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAccounts`.
    ///
    /// <p>Removes the specified list of account IDs from the given billing group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateAccounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_accounts_input::Builder,
    }
    impl DisassociateAccounts {
        /// Creates a new `DisassociateAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateAccountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The array of account IDs to disassociate. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The array of account IDs to disassociate. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePricingRules`.
    ///
    /// <p> Disassociates a list of pricing rules from a pricing plan. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociatePricingRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_pricing_rules_input::Builder,
    }
    impl DisassociatePricingRules {
        /// Creates a new `DisassociatePricingRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociatePricingRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociatePricingRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `PricingRuleArns`.
        ///
        /// To override the contents of this collection use [`set_pricing_rule_arns`](Self::set_pricing_rule_arns).
        ///
        /// <p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>
        pub fn pricing_rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_rule_arns(input.into());
            self
        }
        /// <p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>
        pub fn set_pricing_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pricing_rule_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAssociations`.
    ///
    /// <p> <i> <b>Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web Services Billing Conductor is subject to the Beta Service Participation terms of the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i> </p>
    /// <p> This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group associated with the linked account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_account_associations_input::Builder,
    }
    impl ListAccountAssociations {
        /// Creates a new `ListAccountAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountAssociationsPaginator {
            crate::paginator::ListAccountAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p> The preferred billing period to get account associations. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p> The preferred billing period to get account associations. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p>The filter on the account ID of the linked account, or any of the following:</p>
        /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
        /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
        /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>
        pub fn filters(mut self, input: crate::model::ListAccountAssociationsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filter on the account ID of the linked account, or any of the following:</p>
        /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
        /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
        /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListAccountAssociationsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The pagination token used on subsequent calls to retrieve accounts. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token used on subsequent calls to retrieve accounts. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBillingGroupCostReports`.
    ///
    /// <p>A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBillingGroupCostReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_billing_group_cost_reports_input::Builder,
    }
    impl ListBillingGroupCostReports {
        /// Creates a new `ListBillingGroupCostReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBillingGroupCostReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBillingGroupCostReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBillingGroupCostReportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBillingGroupCostReportsPaginator {
            crate::paginator::ListBillingGroupCostReportsPaginator::new(self.handle, self.inner)
        }
        /// <p>The preferred billing period for your report. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p>The preferred billing period for your report. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p>The maximum number of reports to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of reports to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token used on subsequent calls to get reports. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used on subsequent calls to get reports. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>
        pub fn filters(mut self, input: crate::model::ListBillingGroupCostReportsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListBillingGroupCostReportsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBillingGroups`.
    ///
    /// <p>A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a billing group, the current billing period is used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBillingGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_billing_groups_input::Builder,
    }
    impl ListBillingGroups {
        /// Creates a new `ListBillingGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBillingGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBillingGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBillingGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBillingGroupsPaginator {
            crate::paginator::ListBillingGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The preferred billing period to get billing groups. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p>The preferred billing period to get billing groups. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p>The maximum number of billing groups to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of billing groups to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token used on subsequent calls to get billing groups. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used on subsequent calls to get billing groups. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>
        pub fn filters(mut self, input: crate::model::ListBillingGroupsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListBillingGroupsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomLineItems`.
    ///
    /// <p> A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomLineItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_line_items_input::Builder,
    }
    impl ListCustomLineItems {
        /// Creates a new `ListCustomLineItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomLineItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomLineItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomLineItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCustomLineItemsPaginator {
            crate::paginator::ListCustomLineItemsPaginator::new(self.handle, self.inner)
        }
        /// <p> The preferred billing period to get custom line items (FFLIs). </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p> The preferred billing period to get custom line items (FFLIs). </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p> The maximum number of billing groups to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of billing groups to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>
        pub fn filters(mut self, input: crate::model::ListCustomLineItemsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListCustomLineItemsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPricingPlans`.
    ///
    /// <p>A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPricingPlans {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pricing_plans_input::Builder,
    }
    impl ListPricingPlans {
        /// Creates a new `ListPricingPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPricingPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPricingPlansError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPricingPlansPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPricingPlansPaginator {
            crate::paginator::ListPricingPlansPaginator::new(self.handle, self.inner)
        }
        /// <p>The preferred billing period to get pricing plan. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p>The preferred billing period to get pricing plan. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>
        pub fn filters(mut self, input: crate::model::ListPricingPlansFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListPricingPlansFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of pricing plans to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of pricing plans to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token used on subsequent call to get pricing plans. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used on subsequent call to get pricing plans. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPricingPlansAssociatedWithPricingRule`.
    ///
    /// <p> A list of the pricing plans associated with a pricing rule. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPricingPlansAssociatedWithPricingRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pricing_plans_associated_with_pricing_rule_input::Builder,
    }
    impl ListPricingPlansAssociatedWithPricingRule {
        /// Creates a new `ListPricingPlansAssociatedWithPricingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPricingPlansAssociatedWithPricingRuleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListPricingPlansAssociatedWithPricingRuleError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPricingPlansAssociatedWithPricingRulePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListPricingPlansAssociatedWithPricingRulePaginator {
            crate::paginator::ListPricingPlansAssociatedWithPricingRulePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The pricing plan billing period for which associations will be listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p> The pricing plan billing period for which associations will be listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
        pub fn pricing_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_rule_arn(input.into());
            self
        }
        /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
        pub fn set_pricing_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_rule_arn(input);
            self
        }
        /// <p> The optional maximum number of pricing rule associations to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The optional maximum number of pricing rule associations to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPricingRules`.
    ///
    /// <p> Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPricingRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pricing_rules_input::Builder,
    }
    impl ListPricingRules {
        /// Creates a new `ListPricingRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPricingRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPricingRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPricingRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPricingRulesPaginator {
            crate::paginator::ListPricingRulesPaginator::new(self.handle, self.inner)
        }
        /// <p> The preferred billing period to get the pricing plan. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p> The preferred billing period to get the pricing plan. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>
        pub fn filters(mut self, input: crate::model::ListPricingRulesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListPricingRulesFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of pricing rules to retrieve. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of pricing rules to retrieve. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token used on subsequent call to get pricing rules. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token used on subsequent call to get pricing rules. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPricingRulesAssociatedToPricingPlan`.
    ///
    /// <p> Lists the pricing rules associated with a pricing plan. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPricingRulesAssociatedToPricingPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pricing_rules_associated_to_pricing_plan_input::Builder,
    }
    impl ListPricingRulesAssociatedToPricingPlan {
        /// Creates a new `ListPricingRulesAssociatedToPricingPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPricingRulesAssociatedToPricingPlanOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListPricingRulesAssociatedToPricingPlanError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPricingRulesAssociatedToPricingPlanPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListPricingRulesAssociatedToPricingPlanPaginator {
            crate::paginator::ListPricingRulesAssociatedToPricingPlanPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The billing period for which the pricing rule associations are to be listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p> The billing period for which the pricing rule associations are to be listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>
        pub fn pricing_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>
        pub fn set_pricing_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_arn(input);
            self
        }
        /// <p>The optional maximum number of pricing rule associations to retrieve.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The optional maximum number of pricing rule associations to retrieve.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The optional pagination token returned by a previous call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourcesAssociatedToCustomLineItem`.
    ///
    /// <p> List the resources associated to a custom line item. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourcesAssociatedToCustomLineItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resources_associated_to_custom_line_item_input::Builder,
    }
    impl ListResourcesAssociatedToCustomLineItem {
        /// Creates a new `ListResourcesAssociatedToCustomLineItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesAssociatedToCustomLineItemOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListResourcesAssociatedToCustomLineItemError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourcesAssociatedToCustomLineItemPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListResourcesAssociatedToCustomLineItemPaginator {
            crate::paginator::ListResourcesAssociatedToCustomLineItemPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The billing period for which the resource associations will be listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_period(input.into());
            self
        }
        /// <p> The billing period for which the resource associations will be listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_period(input);
            self
        }
        /// <p> The ARN of the custom line item for which the resource associations will be listed. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The ARN of the custom line item for which the resource associations will be listed. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p> (Optional) The maximum number of resource associations to be retrieved. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> (Optional) The maximum number of resource associations to be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> (Optional) The pagination token returned by a previous request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> (Optional) The pagination token returned by a previous request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>
        pub fn filters(
            mut self,
            input: crate::model::ListResourcesAssociatedToCustomLineItemFilter,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListResourcesAssociatedToCustomLineItemFilter>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> A list the tags for a resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource are not specified in the request parameters, they are not changed. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags to add to the resource as a list of key-value pairs. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags to add to the resource as a list of key-value pairs. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Deletes specified tags from a resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The tags to delete from the resource as a list of key-value pairs. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> The tags to delete from the resource as a list of key-value pairs. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBillingGroup`.
    ///
    /// <p>This updates an existing billing group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBillingGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_billing_group_input::Builder,
    }
    impl UpdateBillingGroup {
        /// Creates a new `UpdateBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBillingGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group being updated. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group being updated. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The name of the billing group. The names must be unique to each billing group. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the billing group. The names must be unique to each billing group. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The status of the billing group. Only one of the valid values can be used. </p>
        pub fn status(mut self, input: crate::model::BillingGroupStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the billing group. Only one of the valid values can be used. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BillingGroupStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn computation_preference(
            mut self,
            input: crate::model::ComputationPreference,
        ) -> Self {
            self.inner = self.inner.computation_preference(input);
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn set_computation_preference(
            mut self,
            input: std::option::Option<crate::model::ComputationPreference>,
        ) -> Self {
            self.inner = self.inner.set_computation_preference(input);
            self
        }
        /// <p>A description of the billing group. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the billing group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomLineItem`.
    ///
    /// <p> Update an existing custom line item in the current or previous billing period. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCustomLineItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_custom_line_item_input::Builder,
    }
    impl UpdateCustomLineItem {
        /// Creates a new `UpdateCustomLineItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomLineItemOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCustomLineItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the custom line item to be updated. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The ARN of the custom line item to be updated. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p> The new name for the custom line item. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The new name for the custom line item. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The new line item description of the custom line item. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The new line item description of the custom line item. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>
        pub fn charge_details(
            mut self,
            input: crate::model::UpdateCustomLineItemChargeDetails,
        ) -> Self {
            self.inner = self.inner.charge_details(input);
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>
        pub fn set_charge_details(
            mut self,
            input: std::option::Option<crate::model::UpdateCustomLineItemChargeDetails>,
        ) -> Self {
            self.inner = self.inner.set_charge_details(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn billing_period_range(
            mut self,
            input: crate::model::CustomLineItemBillingPeriodRange,
        ) -> Self {
            self.inner = self.inner.billing_period_range(input);
            self
        }
        /// <p> The billing period range in which the custom line item request will be applied. </p>
        pub fn set_billing_period_range(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemBillingPeriodRange>,
        ) -> Self {
            self.inner = self.inner.set_billing_period_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePricingPlan`.
    ///
    /// <p>This updates an existing pricing plan. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePricingPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pricing_plan_input::Builder,
    }
    impl UpdatePricingPlan {
        /// Creates a new `UpdatePricingPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePricingPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePricingPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're updating. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pricing plan you're updating. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The name of the pricing plan. The name must be unique to each pricing plan. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the pricing plan. The name must be unique to each pricing plan. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePricingRule`.
    ///
    /// <p> Updates an existing pricing rule. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePricingRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pricing_rule_input::Builder,
    }
    impl UpdatePricingRule {
        /// Creates a new `UpdatePricingRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePricingRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePricingRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The new pricing rule type. </p>
        pub fn r#type(mut self, input: crate::model::PricingRuleType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p> The new pricing rule type. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PricingRuleType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p> The new modifier to show pricing plan rates as a percentage. </p>
        pub fn modifier_percentage(mut self, input: f64) -> Self {
            self.inner = self.inner.modifier_percentage(input);
            self
        }
        /// <p> The new modifier to show pricing plan rates as a percentage. </p>
        pub fn set_modifier_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_modifier_percentage(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
