// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingRulesAssociatedToPricingPlanOutput {
    /// <p> The billing period for which the pricing rule associations are listed. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.</p>
    pub pricing_plan_arn: std::option::Option<std::string::String>,
    /// <p> A list containing pricing rules associated with the requested pricing plan. </p>
    pub pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The pagination token to be used on subsequent calls. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingRulesAssociatedToPricingPlanOutput {
    /// <p> The billing period for which the pricing rule associations are listed. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.</p>
    pub fn pricing_plan_arn(&self) -> std::option::Option<&str> {
        self.pricing_plan_arn.as_deref()
    }
    /// <p> A list containing pricing rules associated with the requested pricing plan. </p>
    pub fn pricing_rule_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.pricing_rule_arns.as_deref()
    }
    /// <p> The pagination token to be used on subsequent calls. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingRulesAssociatedToPricingPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingRulesAssociatedToPricingPlanOutput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("pricing_plan_arn", &self.pricing_plan_arn);
        formatter.field("pricing_rule_arns", &self.pricing_rule_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPricingRulesAssociatedToPricingPlanOutput`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput)
pub mod list_pricing_rules_associated_to_pricing_plan_output {
    /// A builder for [`ListPricingRulesAssociatedToPricingPlanOutput`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) pricing_plan_arn: std::option::Option<std::string::String>,
        pub(crate) pricing_rule_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The billing period for which the pricing rule associations are listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The billing period for which the pricing rule associations are listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.</p>
        pub fn pricing_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.</p>
        pub fn set_pricing_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_arn = input;
            self
        }
        /// Appends an item to `pricing_rule_arns`.
        ///
        /// To override the contents of this collection use [`set_pricing_rule_arns`](Self::set_pricing_rule_arns).
        ///
        /// <p> A list containing pricing rules associated with the requested pricing plan. </p>
        pub fn pricing_rule_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pricing_rule_arns.unwrap_or_default();
            v.push(input.into());
            self.pricing_rule_arns = Some(v);
            self
        }
        /// <p> A list containing pricing rules associated with the requested pricing plan. </p>
        pub fn set_pricing_rule_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pricing_rule_arns = input;
            self
        }
        /// <p> The pagination token to be used on subsequent calls. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token to be used on subsequent calls. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingRulesAssociatedToPricingPlanOutput`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput)
        pub fn build(self) -> crate::output::ListPricingRulesAssociatedToPricingPlanOutput {
            crate::output::ListPricingRulesAssociatedToPricingPlanOutput {
                billing_period: self.billing_period,
                pricing_plan_arn: self.pricing_plan_arn,
                pricing_rule_arns: self.pricing_rule_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPricingRulesAssociatedToPricingPlanOutput {
    /// Creates a new builder-style object to manufacture [`ListPricingRulesAssociatedToPricingPlanOutput`](crate::output::ListPricingRulesAssociatedToPricingPlanOutput)
    pub fn builder() -> crate::output::list_pricing_rules_associated_to_pricing_plan_output::Builder
    {
        crate::output::list_pricing_rules_associated_to_pricing_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingRulesOutput {
    /// <p> The billing period for which the described pricing rules are applicable. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> A list containing the described pricing rules. </p>
    pub pricing_rules: std::option::Option<std::vec::Vec<crate::model::PricingRuleListElement>>,
    /// <p> The pagination token used on subsequent calls to get pricing rules. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingRulesOutput {
    /// <p> The billing period for which the described pricing rules are applicable. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> A list containing the described pricing rules. </p>
    pub fn pricing_rules(&self) -> std::option::Option<&[crate::model::PricingRuleListElement]> {
        self.pricing_rules.as_deref()
    }
    /// <p> The pagination token used on subsequent calls to get pricing rules. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingRulesOutput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("pricing_rules", &self.pricing_rules);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPricingRulesOutput`](crate::output::ListPricingRulesOutput)
pub mod list_pricing_rules_output {
    /// A builder for [`ListPricingRulesOutput`](crate::output::ListPricingRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) pricing_rules:
            std::option::Option<std::vec::Vec<crate::model::PricingRuleListElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The billing period for which the described pricing rules are applicable. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The billing period for which the described pricing rules are applicable. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// Appends an item to `pricing_rules`.
        ///
        /// To override the contents of this collection use [`set_pricing_rules`](Self::set_pricing_rules).
        ///
        /// <p> A list containing the described pricing rules. </p>
        pub fn pricing_rules(mut self, input: crate::model::PricingRuleListElement) -> Self {
            let mut v = self.pricing_rules.unwrap_or_default();
            v.push(input);
            self.pricing_rules = Some(v);
            self
        }
        /// <p> A list containing the described pricing rules. </p>
        pub fn set_pricing_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PricingRuleListElement>>,
        ) -> Self {
            self.pricing_rules = input;
            self
        }
        /// <p> The pagination token used on subsequent calls to get pricing rules. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token used on subsequent calls to get pricing rules. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingRulesOutput`](crate::output::ListPricingRulesOutput)
        pub fn build(self) -> crate::output::ListPricingRulesOutput {
            crate::output::ListPricingRulesOutput {
                billing_period: self.billing_period,
                pricing_rules: self.pricing_rules,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPricingRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListPricingRulesOutput`](crate::output::ListPricingRulesOutput)
    pub fn builder() -> crate::output::list_pricing_rules_output::Builder {
        crate::output::list_pricing_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePricingRuleOutput {
    /// <p> The Amazon Resource Name (ARN) of the created pricing rule. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreatePricingRuleOutput {
    /// <p> The Amazon Resource Name (ARN) of the created pricing rule. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreatePricingRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePricingRuleOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreatePricingRuleOutput`](crate::output::CreatePricingRuleOutput)
pub mod create_pricing_rule_output {
    /// A builder for [`CreatePricingRuleOutput`](crate::output::CreatePricingRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the created pricing rule. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the created pricing rule. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePricingRuleOutput`](crate::output::CreatePricingRuleOutput)
        pub fn build(self) -> crate::output::CreatePricingRuleOutput {
            crate::output::CreatePricingRuleOutput { arn: self.arn }
        }
    }
}
impl CreatePricingRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreatePricingRuleOutput`](crate::output::CreatePricingRuleOutput)
    pub fn builder() -> crate::output::create_pricing_rule_output::Builder {
        crate::output::create_pricing_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePricingRuleOutput {
    /// <p> The Amazon Resource Name (ARN) of the deleted pricing rule. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeletePricingRuleOutput {
    /// <p> The Amazon Resource Name (ARN) of the deleted pricing rule. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePricingRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePricingRuleOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeletePricingRuleOutput`](crate::output::DeletePricingRuleOutput)
pub mod delete_pricing_rule_output {
    /// A builder for [`DeletePricingRuleOutput`](crate::output::DeletePricingRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the deleted pricing rule. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the deleted pricing rule. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePricingRuleOutput`](crate::output::DeletePricingRuleOutput)
        pub fn build(self) -> crate::output::DeletePricingRuleOutput {
            crate::output::DeletePricingRuleOutput { arn: self.arn }
        }
    }
}
impl DeletePricingRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeletePricingRuleOutput`](crate::output::DeletePricingRuleOutput)
    pub fn builder() -> crate::output::delete_pricing_rule_output::Builder {
        crate::output::delete_pricing_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePricingRuleOutput {
    /// <p> The Amazon Resource Name (ARN) of the successfully updated pricing rule. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The new description for the pricing rule. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
    pub scope: std::option::Option<crate::model::PricingRuleScope>,
    /// <p> The new pricing rule type. </p>
    pub r#type: std::option::Option<crate::model::PricingRuleType>,
    /// <p> The new modifier to show pricing plan rates as a percentage. </p>
    pub modifier_percentage: std::option::Option<f64>,
    /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    pub service: std::option::Option<std::string::String>,
    /// <p> The pricing plans count that this pricing rule is associated with. </p>
    pub associated_pricing_plan_count: i64,
    /// <p> The most recent time the pricing rule was modified. </p>
    pub last_modified_time: i64,
}
impl UpdatePricingRuleOutput {
    /// <p> The Amazon Resource Name (ARN) of the successfully updated pricing rule. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The new description for the pricing rule. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
    pub fn scope(&self) -> std::option::Option<&crate::model::PricingRuleScope> {
        self.scope.as_ref()
    }
    /// <p> The new pricing rule type. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PricingRuleType> {
        self.r#type.as_ref()
    }
    /// <p> The new modifier to show pricing plan rates as a percentage. </p>
    pub fn modifier_percentage(&self) -> std::option::Option<f64> {
        self.modifier_percentage
    }
    /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p> The pricing plans count that this pricing rule is associated with. </p>
    pub fn associated_pricing_plan_count(&self) -> i64 {
        self.associated_pricing_plan_count
    }
    /// <p> The most recent time the pricing rule was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
}
impl std::fmt::Debug for UpdatePricingRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePricingRuleOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("scope", &self.scope);
        formatter.field("r#type", &self.r#type);
        formatter.field("modifier_percentage", &self.modifier_percentage);
        formatter.field("service", &self.service);
        formatter.field(
            "associated_pricing_plan_count",
            &self.associated_pricing_plan_count,
        );
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`UpdatePricingRuleOutput`](crate::output::UpdatePricingRuleOutput)
pub mod update_pricing_rule_output {
    /// A builder for [`UpdatePricingRuleOutput`](crate::output::UpdatePricingRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) scope: std::option::Option<crate::model::PricingRuleScope>,
        pub(crate) r#type: std::option::Option<crate::model::PricingRuleType>,
        pub(crate) modifier_percentage: std::option::Option<f64>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) associated_pricing_plan_count: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the successfully updated pricing rule. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the successfully updated pricing rule. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
        pub fn scope(mut self, input: crate::model::PricingRuleScope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::PricingRuleScope>,
        ) -> Self {
            self.scope = input;
            self
        }
        /// <p> The new pricing rule type. </p>
        pub fn r#type(mut self, input: crate::model::PricingRuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The new pricing rule type. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PricingRuleType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The new modifier to show pricing plan rates as a percentage. </p>
        pub fn modifier_percentage(mut self, input: f64) -> Self {
            self.modifier_percentage = Some(input);
            self
        }
        /// <p> The new modifier to show pricing plan rates as a percentage. </p>
        pub fn set_modifier_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.modifier_percentage = input;
            self
        }
        /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p> The pricing plans count that this pricing rule is associated with. </p>
        pub fn associated_pricing_plan_count(mut self, input: i64) -> Self {
            self.associated_pricing_plan_count = Some(input);
            self
        }
        /// <p> The pricing plans count that this pricing rule is associated with. </p>
        pub fn set_associated_pricing_plan_count(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.associated_pricing_plan_count = input;
            self
        }
        /// <p> The most recent time the pricing rule was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the pricing rule was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePricingRuleOutput`](crate::output::UpdatePricingRuleOutput)
        pub fn build(self) -> crate::output::UpdatePricingRuleOutput {
            crate::output::UpdatePricingRuleOutput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                scope: self.scope,
                r#type: self.r#type,
                modifier_percentage: self.modifier_percentage,
                service: self.service,
                associated_pricing_plan_count: self
                    .associated_pricing_plan_count
                    .unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
            }
        }
    }
}
impl UpdatePricingRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePricingRuleOutput`](crate::output::UpdatePricingRuleOutput)
    pub fn builder() -> crate::output::update_pricing_rule_output::Builder {
        crate::output::update_pricing_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociatePricingRulesOutput {
    /// <p> The Amazon Resource Name (ARN) of the pricing plan that the pricing rules successfully disassociated from. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DisassociatePricingRulesOutput {
    /// <p> The Amazon Resource Name (ARN) of the pricing plan that the pricing rules successfully disassociated from. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociatePricingRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociatePricingRulesOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DisassociatePricingRulesOutput`](crate::output::DisassociatePricingRulesOutput)
pub mod disassociate_pricing_rules_output {
    /// A builder for [`DisassociatePricingRulesOutput`](crate::output::DisassociatePricingRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the pricing plan that the pricing rules successfully disassociated from. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan that the pricing rules successfully disassociated from. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociatePricingRulesOutput`](crate::output::DisassociatePricingRulesOutput)
        pub fn build(self) -> crate::output::DisassociatePricingRulesOutput {
            crate::output::DisassociatePricingRulesOutput { arn: self.arn }
        }
    }
}
impl DisassociatePricingRulesOutput {
    /// Creates a new builder-style object to manufacture [`DisassociatePricingRulesOutput`](crate::output::DisassociatePricingRulesOutput)
    pub fn builder() -> crate::output::disassociate_pricing_rules_output::Builder {
        crate::output::disassociate_pricing_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePricingRulesOutput {
    /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl AssociatePricingRulesOutput {
    /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for AssociatePricingRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePricingRulesOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`AssociatePricingRulesOutput`](crate::output::AssociatePricingRulesOutput)
pub mod associate_pricing_rules_output {
    /// A builder for [`AssociatePricingRulesOutput`](crate::output::AssociatePricingRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePricingRulesOutput`](crate::output::AssociatePricingRulesOutput)
        pub fn build(self) -> crate::output::AssociatePricingRulesOutput {
            crate::output::AssociatePricingRulesOutput { arn: self.arn }
        }
    }
}
impl AssociatePricingRulesOutput {
    /// Creates a new builder-style object to manufacture [`AssociatePricingRulesOutput`](crate::output::AssociatePricingRulesOutput)
    pub fn builder() -> crate::output::associate_pricing_rules_output::Builder {
        crate::output::associate_pricing_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingPlansAssociatedWithPricingRuleOutput {
    /// <p> The pricing plan billing period for which associations will be listed. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
    pub pricing_rule_arn: std::option::Option<std::string::String>,
    /// <p> The list containing pricing plans associated with the requested pricing rule. </p>
    pub pricing_plan_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The pagination token to be used on subsequent calls. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingPlansAssociatedWithPricingRuleOutput {
    /// <p> The pricing plan billing period for which associations will be listed. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
    pub fn pricing_rule_arn(&self) -> std::option::Option<&str> {
        self.pricing_rule_arn.as_deref()
    }
    /// <p> The list containing pricing plans associated with the requested pricing rule. </p>
    pub fn pricing_plan_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.pricing_plan_arns.as_deref()
    }
    /// <p> The pagination token to be used on subsequent calls. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingPlansAssociatedWithPricingRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingPlansAssociatedWithPricingRuleOutput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("pricing_rule_arn", &self.pricing_rule_arn);
        formatter.field("pricing_plan_arns", &self.pricing_plan_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPricingPlansAssociatedWithPricingRuleOutput`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput)
pub mod list_pricing_plans_associated_with_pricing_rule_output {
    /// A builder for [`ListPricingPlansAssociatedWithPricingRuleOutput`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) pricing_rule_arn: std::option::Option<std::string::String>,
        pub(crate) pricing_plan_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The pricing plan billing period for which associations will be listed. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The pricing plan billing period for which associations will be listed. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
        pub fn pricing_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_rule_arn = Some(input.into());
            self
        }
        /// <p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>
        pub fn set_pricing_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_rule_arn = input;
            self
        }
        /// Appends an item to `pricing_plan_arns`.
        ///
        /// To override the contents of this collection use [`set_pricing_plan_arns`](Self::set_pricing_plan_arns).
        ///
        /// <p> The list containing pricing plans associated with the requested pricing rule. </p>
        pub fn pricing_plan_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pricing_plan_arns.unwrap_or_default();
            v.push(input.into());
            self.pricing_plan_arns = Some(v);
            self
        }
        /// <p> The list containing pricing plans associated with the requested pricing rule. </p>
        pub fn set_pricing_plan_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pricing_plan_arns = input;
            self
        }
        /// <p> The pagination token to be used on subsequent calls. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token to be used on subsequent calls. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingPlansAssociatedWithPricingRuleOutput`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput)
        pub fn build(self) -> crate::output::ListPricingPlansAssociatedWithPricingRuleOutput {
            crate::output::ListPricingPlansAssociatedWithPricingRuleOutput {
                billing_period: self.billing_period,
                pricing_rule_arn: self.pricing_rule_arn,
                pricing_plan_arns: self.pricing_plan_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPricingPlansAssociatedWithPricingRuleOutput {
    /// Creates a new builder-style object to manufacture [`ListPricingPlansAssociatedWithPricingRuleOutput`](crate::output::ListPricingPlansAssociatedWithPricingRuleOutput)
    pub fn builder(
    ) -> crate::output::list_pricing_plans_associated_with_pricing_rule_output::Builder {
        crate::output::list_pricing_plans_associated_with_pricing_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingPlansOutput {
    /// <p> The billing period for which the described pricing plans are applicable. </p>
    pub billing_period: std::option::Option<std::string::String>,
    /// <p>A list of <code>PricingPlanListElement</code> retrieved. </p>
    pub pricing_plans: std::option::Option<std::vec::Vec<crate::model::PricingPlanListElement>>,
    /// <p>The pagination token used on subsequent calls to get pricing plans. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPricingPlansOutput {
    /// <p> The billing period for which the described pricing plans are applicable. </p>
    pub fn billing_period(&self) -> std::option::Option<&str> {
        self.billing_period.as_deref()
    }
    /// <p>A list of <code>PricingPlanListElement</code> retrieved. </p>
    pub fn pricing_plans(&self) -> std::option::Option<&[crate::model::PricingPlanListElement]> {
        self.pricing_plans.as_deref()
    }
    /// <p>The pagination token used on subsequent calls to get pricing plans. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPricingPlansOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingPlansOutput");
        formatter.field("billing_period", &self.billing_period);
        formatter.field("pricing_plans", &self.pricing_plans);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPricingPlansOutput`](crate::output::ListPricingPlansOutput)
pub mod list_pricing_plans_output {
    /// A builder for [`ListPricingPlansOutput`](crate::output::ListPricingPlansOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_period: std::option::Option<std::string::String>,
        pub(crate) pricing_plans:
            std::option::Option<std::vec::Vec<crate::model::PricingPlanListElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The billing period for which the described pricing plans are applicable. </p>
        pub fn billing_period(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_period = Some(input.into());
            self
        }
        /// <p> The billing period for which the described pricing plans are applicable. </p>
        pub fn set_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_period = input;
            self
        }
        /// Appends an item to `pricing_plans`.
        ///
        /// To override the contents of this collection use [`set_pricing_plans`](Self::set_pricing_plans).
        ///
        /// <p>A list of <code>PricingPlanListElement</code> retrieved. </p>
        pub fn pricing_plans(mut self, input: crate::model::PricingPlanListElement) -> Self {
            let mut v = self.pricing_plans.unwrap_or_default();
            v.push(input);
            self.pricing_plans = Some(v);
            self
        }
        /// <p>A list of <code>PricingPlanListElement</code> retrieved. </p>
        pub fn set_pricing_plans(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PricingPlanListElement>>,
        ) -> Self {
            self.pricing_plans = input;
            self
        }
        /// <p>The pagination token used on subsequent calls to get pricing plans. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used on subsequent calls to get pricing plans. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingPlansOutput`](crate::output::ListPricingPlansOutput)
        pub fn build(self) -> crate::output::ListPricingPlansOutput {
            crate::output::ListPricingPlansOutput {
                billing_period: self.billing_period,
                pricing_plans: self.pricing_plans,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPricingPlansOutput {
    /// Creates a new builder-style object to manufacture [`ListPricingPlansOutput`](crate::output::ListPricingPlansOutput)
    pub fn builder() -> crate::output::list_pricing_plans_output::Builder {
        crate::output::list_pricing_plans_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePricingPlanOutput {
    /// <p>The Amazon Resource Name (ARN) of the created pricing plan.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreatePricingPlanOutput {
    /// <p>The Amazon Resource Name (ARN) of the created pricing plan.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreatePricingPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePricingPlanOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreatePricingPlanOutput`](crate::output::CreatePricingPlanOutput)
pub mod create_pricing_plan_output {
    /// A builder for [`CreatePricingPlanOutput`](crate::output::CreatePricingPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the created pricing plan.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created pricing plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePricingPlanOutput`](crate::output::CreatePricingPlanOutput)
        pub fn build(self) -> crate::output::CreatePricingPlanOutput {
            crate::output::CreatePricingPlanOutput { arn: self.arn }
        }
    }
}
impl CreatePricingPlanOutput {
    /// Creates a new builder-style object to manufacture [`CreatePricingPlanOutput`](crate::output::CreatePricingPlanOutput)
    pub fn builder() -> crate::output::create_pricing_plan_output::Builder {
        crate::output::create_pricing_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePricingPlanOutput {
    /// <p> The Amazon Resource Name (ARN) of the deleted pricing plan. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeletePricingPlanOutput {
    /// <p> The Amazon Resource Name (ARN) of the deleted pricing plan. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePricingPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePricingPlanOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeletePricingPlanOutput`](crate::output::DeletePricingPlanOutput)
pub mod delete_pricing_plan_output {
    /// A builder for [`DeletePricingPlanOutput`](crate::output::DeletePricingPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the deleted pricing plan. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the deleted pricing plan. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePricingPlanOutput`](crate::output::DeletePricingPlanOutput)
        pub fn build(self) -> crate::output::DeletePricingPlanOutput {
            crate::output::DeletePricingPlanOutput { arn: self.arn }
        }
    }
}
impl DeletePricingPlanOutput {
    /// Creates a new builder-style object to manufacture [`DeletePricingPlanOutput`](crate::output::DeletePricingPlanOutput)
    pub fn builder() -> crate::output::delete_pricing_plan_output::Builder {
        crate::output::delete_pricing_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePricingPlanOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated pricing plan. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The name of the pricing plan. The name must be unique to each pricing plan. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The new description for the pricing rule. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The pricing rules count currently associated with this pricing plan list. </p>
    pub size: i64,
    /// <p> The most recent time the pricing plan was modified. </p>
    pub last_modified_time: i64,
}
impl UpdatePricingPlanOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated pricing plan. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The name of the pricing plan. The name must be unique to each pricing plan. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The new description for the pricing rule. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The pricing rules count currently associated with this pricing plan list. </p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p> The most recent time the pricing plan was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
}
impl std::fmt::Debug for UpdatePricingPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePricingPlanOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("size", &self.size);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`UpdatePricingPlanOutput`](crate::output::UpdatePricingPlanOutput)
pub mod update_pricing_plan_output {
    /// A builder for [`UpdatePricingPlanOutput`](crate::output::UpdatePricingPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated pricing plan. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated pricing plan. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The name of the pricing plan. The name must be unique to each pricing plan. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the pricing plan. The name must be unique to each pricing plan. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The new description for the pricing rule. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The pricing rules count currently associated with this pricing plan list. </p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p> The pricing rules count currently associated with this pricing plan list. </p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p> The most recent time the pricing plan was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the pricing plan was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePricingPlanOutput`](crate::output::UpdatePricingPlanOutput)
        pub fn build(self) -> crate::output::UpdatePricingPlanOutput {
            crate::output::UpdatePricingPlanOutput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                size: self.size.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
            }
        }
    }
}
impl UpdatePricingPlanOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePricingPlanOutput`](crate::output::UpdatePricingPlanOutput)
    pub fn builder() -> crate::output::update_pricing_plan_output::Builder {
        crate::output::update_pricing_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesAssociatedToCustomLineItemOutput {
    /// <p> The custom line item ARN for which the resource associations are listed. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> A list of <code>ListResourcesAssociatedToCustomLineItemResponseElement</code> for each resource association retrieved. </p>
    pub associated_resources: std::option::Option<
        std::vec::Vec<crate::model::ListResourcesAssociatedToCustomLineItemResponseElement>,
    >,
    /// <p> The pagination token to be used in subsequent requests to retrieve additional results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourcesAssociatedToCustomLineItemOutput {
    /// <p> The custom line item ARN for which the resource associations are listed. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> A list of <code>ListResourcesAssociatedToCustomLineItemResponseElement</code> for each resource association retrieved. </p>
    pub fn associated_resources(
        &self,
    ) -> std::option::Option<&[crate::model::ListResourcesAssociatedToCustomLineItemResponseElement]>
    {
        self.associated_resources.as_deref()
    }
    /// <p> The pagination token to be used in subsequent requests to retrieve additional results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourcesAssociatedToCustomLineItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesAssociatedToCustomLineItemOutput");
        formatter.field("arn", &self.arn);
        formatter.field("associated_resources", &self.associated_resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourcesAssociatedToCustomLineItemOutput`](crate::output::ListResourcesAssociatedToCustomLineItemOutput)
pub mod list_resources_associated_to_custom_line_item_output {
    /// A builder for [`ListResourcesAssociatedToCustomLineItemOutput`](crate::output::ListResourcesAssociatedToCustomLineItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) associated_resources: std::option::Option<
            std::vec::Vec<crate::model::ListResourcesAssociatedToCustomLineItemResponseElement>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The custom line item ARN for which the resource associations are listed. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The custom line item ARN for which the resource associations are listed. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `associated_resources`.
        ///
        /// To override the contents of this collection use [`set_associated_resources`](Self::set_associated_resources).
        ///
        /// <p> A list of <code>ListResourcesAssociatedToCustomLineItemResponseElement</code> for each resource association retrieved. </p>
        pub fn associated_resources(
            mut self,
            input: crate::model::ListResourcesAssociatedToCustomLineItemResponseElement,
        ) -> Self {
            let mut v = self.associated_resources.unwrap_or_default();
            v.push(input);
            self.associated_resources = Some(v);
            self
        }
        /// <p> A list of <code>ListResourcesAssociatedToCustomLineItemResponseElement</code> for each resource association retrieved. </p>
        pub fn set_associated_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ListResourcesAssociatedToCustomLineItemResponseElement>,
            >,
        ) -> Self {
            self.associated_resources = input;
            self
        }
        /// <p> The pagination token to be used in subsequent requests to retrieve additional results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token to be used in subsequent requests to retrieve additional results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesAssociatedToCustomLineItemOutput`](crate::output::ListResourcesAssociatedToCustomLineItemOutput)
        pub fn build(self) -> crate::output::ListResourcesAssociatedToCustomLineItemOutput {
            crate::output::ListResourcesAssociatedToCustomLineItemOutput {
                arn: self.arn,
                associated_resources: self.associated_resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourcesAssociatedToCustomLineItemOutput {
    /// Creates a new builder-style object to manufacture [`ListResourcesAssociatedToCustomLineItemOutput`](crate::output::ListResourcesAssociatedToCustomLineItemOutput)
    pub fn builder() -> crate::output::list_resources_associated_to_custom_line_item_output::Builder
    {
        crate::output::list_resources_associated_to_custom_line_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateResourcesFromCustomLineItemOutput {
    /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a percentage custom line item successfully. </p>
    pub successfully_disassociated_resources:
        std::option::Option<std::vec::Vec<crate::model::DisassociateResourceResponseElement>>,
    /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from a percentage custom line item. </p>
    pub failed_disassociated_resources:
        std::option::Option<std::vec::Vec<crate::model::DisassociateResourceResponseElement>>,
}
impl BatchDisassociateResourcesFromCustomLineItemOutput {
    /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a percentage custom line item successfully. </p>
    pub fn successfully_disassociated_resources(
        &self,
    ) -> std::option::Option<&[crate::model::DisassociateResourceResponseElement]> {
        self.successfully_disassociated_resources.as_deref()
    }
    /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from a percentage custom line item. </p>
    pub fn failed_disassociated_resources(
        &self,
    ) -> std::option::Option<&[crate::model::DisassociateResourceResponseElement]> {
        self.failed_disassociated_resources.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateResourcesFromCustomLineItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateResourcesFromCustomLineItemOutput");
        formatter.field(
            "successfully_disassociated_resources",
            &self.successfully_disassociated_resources,
        );
        formatter.field(
            "failed_disassociated_resources",
            &self.failed_disassociated_resources,
        );
        formatter.finish()
    }
}
/// See [`BatchDisassociateResourcesFromCustomLineItemOutput`](crate::output::BatchDisassociateResourcesFromCustomLineItemOutput)
pub mod batch_disassociate_resources_from_custom_line_item_output {
    /// A builder for [`BatchDisassociateResourcesFromCustomLineItemOutput`](crate::output::BatchDisassociateResourcesFromCustomLineItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successfully_disassociated_resources:
            std::option::Option<std::vec::Vec<crate::model::DisassociateResourceResponseElement>>,
        pub(crate) failed_disassociated_resources:
            std::option::Option<std::vec::Vec<crate::model::DisassociateResourceResponseElement>>,
    }
    impl Builder {
        /// Appends an item to `successfully_disassociated_resources`.
        ///
        /// To override the contents of this collection use [`set_successfully_disassociated_resources`](Self::set_successfully_disassociated_resources).
        ///
        /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a percentage custom line item successfully. </p>
        pub fn successfully_disassociated_resources(
            mut self,
            input: crate::model::DisassociateResourceResponseElement,
        ) -> Self {
            let mut v = self
                .successfully_disassociated_resources
                .unwrap_or_default();
            v.push(input);
            self.successfully_disassociated_resources = Some(v);
            self
        }
        /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a percentage custom line item successfully. </p>
        pub fn set_successfully_disassociated_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DisassociateResourceResponseElement>,
            >,
        ) -> Self {
            self.successfully_disassociated_resources = input;
            self
        }
        /// Appends an item to `failed_disassociated_resources`.
        ///
        /// To override the contents of this collection use [`set_failed_disassociated_resources`](Self::set_failed_disassociated_resources).
        ///
        /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from a percentage custom line item. </p>
        pub fn failed_disassociated_resources(
            mut self,
            input: crate::model::DisassociateResourceResponseElement,
        ) -> Self {
            let mut v = self.failed_disassociated_resources.unwrap_or_default();
            v.push(input);
            self.failed_disassociated_resources = Some(v);
            self
        }
        /// <p> A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from a percentage custom line item. </p>
        pub fn set_failed_disassociated_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DisassociateResourceResponseElement>,
            >,
        ) -> Self {
            self.failed_disassociated_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateResourcesFromCustomLineItemOutput`](crate::output::BatchDisassociateResourcesFromCustomLineItemOutput)
        pub fn build(self) -> crate::output::BatchDisassociateResourcesFromCustomLineItemOutput {
            crate::output::BatchDisassociateResourcesFromCustomLineItemOutput {
                successfully_disassociated_resources: self.successfully_disassociated_resources,
                failed_disassociated_resources: self.failed_disassociated_resources,
            }
        }
    }
}
impl BatchDisassociateResourcesFromCustomLineItemOutput {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateResourcesFromCustomLineItemOutput`](crate::output::BatchDisassociateResourcesFromCustomLineItemOutput)
    pub fn builder(
    ) -> crate::output::batch_disassociate_resources_from_custom_line_item_output::Builder {
        crate::output::batch_disassociate_resources_from_custom_line_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateResourcesToCustomLineItemOutput {
    /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a percentage custom line item successfully. </p>
    pub successfully_associated_resources:
        std::option::Option<std::vec::Vec<crate::model::AssociateResourceResponseElement>>,
    /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a percentage custom line item. </p>
    pub failed_associated_resources:
        std::option::Option<std::vec::Vec<crate::model::AssociateResourceResponseElement>>,
}
impl BatchAssociateResourcesToCustomLineItemOutput {
    /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a percentage custom line item successfully. </p>
    pub fn successfully_associated_resources(
        &self,
    ) -> std::option::Option<&[crate::model::AssociateResourceResponseElement]> {
        self.successfully_associated_resources.as_deref()
    }
    /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a percentage custom line item. </p>
    pub fn failed_associated_resources(
        &self,
    ) -> std::option::Option<&[crate::model::AssociateResourceResponseElement]> {
        self.failed_associated_resources.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateResourcesToCustomLineItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateResourcesToCustomLineItemOutput");
        formatter.field(
            "successfully_associated_resources",
            &self.successfully_associated_resources,
        );
        formatter.field(
            "failed_associated_resources",
            &self.failed_associated_resources,
        );
        formatter.finish()
    }
}
/// See [`BatchAssociateResourcesToCustomLineItemOutput`](crate::output::BatchAssociateResourcesToCustomLineItemOutput)
pub mod batch_associate_resources_to_custom_line_item_output {
    /// A builder for [`BatchAssociateResourcesToCustomLineItemOutput`](crate::output::BatchAssociateResourcesToCustomLineItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successfully_associated_resources:
            std::option::Option<std::vec::Vec<crate::model::AssociateResourceResponseElement>>,
        pub(crate) failed_associated_resources:
            std::option::Option<std::vec::Vec<crate::model::AssociateResourceResponseElement>>,
    }
    impl Builder {
        /// Appends an item to `successfully_associated_resources`.
        ///
        /// To override the contents of this collection use [`set_successfully_associated_resources`](Self::set_successfully_associated_resources).
        ///
        /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a percentage custom line item successfully. </p>
        pub fn successfully_associated_resources(
            mut self,
            input: crate::model::AssociateResourceResponseElement,
        ) -> Self {
            let mut v = self.successfully_associated_resources.unwrap_or_default();
            v.push(input);
            self.successfully_associated_resources = Some(v);
            self
        }
        /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a percentage custom line item successfully. </p>
        pub fn set_successfully_associated_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociateResourceResponseElement>,
            >,
        ) -> Self {
            self.successfully_associated_resources = input;
            self
        }
        /// Appends an item to `failed_associated_resources`.
        ///
        /// To override the contents of this collection use [`set_failed_associated_resources`](Self::set_failed_associated_resources).
        ///
        /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a percentage custom line item. </p>
        pub fn failed_associated_resources(
            mut self,
            input: crate::model::AssociateResourceResponseElement,
        ) -> Self {
            let mut v = self.failed_associated_resources.unwrap_or_default();
            v.push(input);
            self.failed_associated_resources = Some(v);
            self
        }
        /// <p> A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a percentage custom line item. </p>
        pub fn set_failed_associated_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociateResourceResponseElement>,
            >,
        ) -> Self {
            self.failed_associated_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateResourcesToCustomLineItemOutput`](crate::output::BatchAssociateResourcesToCustomLineItemOutput)
        pub fn build(self) -> crate::output::BatchAssociateResourcesToCustomLineItemOutput {
            crate::output::BatchAssociateResourcesToCustomLineItemOutput {
                successfully_associated_resources: self.successfully_associated_resources,
                failed_associated_resources: self.failed_associated_resources,
            }
        }
    }
}
impl BatchAssociateResourcesToCustomLineItemOutput {
    /// Creates a new builder-style object to manufacture [`BatchAssociateResourcesToCustomLineItemOutput`](crate::output::BatchAssociateResourcesToCustomLineItemOutput)
    pub fn builder() -> crate::output::batch_associate_resources_to_custom_line_item_output::Builder
    {
        crate::output::batch_associate_resources_to_custom_line_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomLineItemsOutput {
    /// <p> A list of <code>FreeFormLineItemListElements</code> received. </p>
    pub custom_line_items:
        std::option::Option<std::vec::Vec<crate::model::CustomLineItemListElement>>,
    /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomLineItemsOutput {
    /// <p> A list of <code>FreeFormLineItemListElements</code> received. </p>
    pub fn custom_line_items(
        &self,
    ) -> std::option::Option<&[crate::model::CustomLineItemListElement]> {
        self.custom_line_items.as_deref()
    }
    /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomLineItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomLineItemsOutput");
        formatter.field("custom_line_items", &self.custom_line_items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCustomLineItemsOutput`](crate::output::ListCustomLineItemsOutput)
pub mod list_custom_line_items_output {
    /// A builder for [`ListCustomLineItemsOutput`](crate::output::ListCustomLineItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_line_items:
            std::option::Option<std::vec::Vec<crate::model::CustomLineItemListElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `custom_line_items`.
        ///
        /// To override the contents of this collection use [`set_custom_line_items`](Self::set_custom_line_items).
        ///
        /// <p> A list of <code>FreeFormLineItemListElements</code> received. </p>
        pub fn custom_line_items(mut self, input: crate::model::CustomLineItemListElement) -> Self {
            let mut v = self.custom_line_items.unwrap_or_default();
            v.push(input);
            self.custom_line_items = Some(v);
            self
        }
        /// <p> A list of <code>FreeFormLineItemListElements</code> received. </p>
        pub fn set_custom_line_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomLineItemListElement>>,
        ) -> Self {
            self.custom_line_items = input;
            self
        }
        /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomLineItemsOutput`](crate::output::ListCustomLineItemsOutput)
        pub fn build(self) -> crate::output::ListCustomLineItemsOutput {
            crate::output::ListCustomLineItemsOutput {
                custom_line_items: self.custom_line_items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCustomLineItemsOutput {
    /// Creates a new builder-style object to manufacture [`ListCustomLineItemsOutput`](crate::output::ListCustomLineItemsOutput)
    pub fn builder() -> crate::output::list_custom_line_items_output::Builder {
        crate::output::list_custom_line_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomLineItemOutput {
    /// <p> The Amazon Resource Name (ARN) of the created custom line item. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreateCustomLineItemOutput {
    /// <p> The Amazon Resource Name (ARN) of the created custom line item. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomLineItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomLineItemOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateCustomLineItemOutput`](crate::output::CreateCustomLineItemOutput)
pub mod create_custom_line_item_output {
    /// A builder for [`CreateCustomLineItemOutput`](crate::output::CreateCustomLineItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the created custom line item. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the created custom line item. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomLineItemOutput`](crate::output::CreateCustomLineItemOutput)
        pub fn build(self) -> crate::output::CreateCustomLineItemOutput {
            crate::output::CreateCustomLineItemOutput { arn: self.arn }
        }
    }
}
impl CreateCustomLineItemOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomLineItemOutput`](crate::output::CreateCustomLineItemOutput)
    pub fn builder() -> crate::output::create_custom_line_item_output::Builder {
        crate::output::create_custom_line_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomLineItemOutput {
    /// <p> Then ARN of the deleted custom line item. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteCustomLineItemOutput {
    /// <p> Then ARN of the deleted custom line item. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomLineItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomLineItemOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeleteCustomLineItemOutput`](crate::output::DeleteCustomLineItemOutput)
pub mod delete_custom_line_item_output {
    /// A builder for [`DeleteCustomLineItemOutput`](crate::output::DeleteCustomLineItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Then ARN of the deleted custom line item. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> Then ARN of the deleted custom line item. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomLineItemOutput`](crate::output::DeleteCustomLineItemOutput)
        pub fn build(self) -> crate::output::DeleteCustomLineItemOutput {
            crate::output::DeleteCustomLineItemOutput { arn: self.arn }
        }
    }
}
impl DeleteCustomLineItemOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomLineItemOutput`](crate::output::DeleteCustomLineItemOutput)
    pub fn builder() -> crate::output::delete_custom_line_item_output::Builder {
        crate::output::delete_custom_line_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomLineItemOutput {
    /// <p> The ARN of the successfully updated custom line item. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The ARN of the billing group that the custom line item is applied to. </p>
    pub billing_group_arn: std::option::Option<std::string::String>,
    /// <p> The name of the successfully updated custom line item. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the successfully updated custom line item. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated custom line item. </p>
    pub charge_details: std::option::Option<crate::model::ListCustomLineItemChargeDetails>,
    /// <p> The most recent time the custom line item was modified. </p>
    pub last_modified_time: i64,
    /// <p> The number of resources that are associated to the custom line item. </p>
    pub association_size: i64,
}
impl UpdateCustomLineItemOutput {
    /// <p> The ARN of the successfully updated custom line item. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The ARN of the billing group that the custom line item is applied to. </p>
    pub fn billing_group_arn(&self) -> std::option::Option<&str> {
        self.billing_group_arn.as_deref()
    }
    /// <p> The name of the successfully updated custom line item. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The description of the successfully updated custom line item. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated custom line item. </p>
    pub fn charge_details(
        &self,
    ) -> std::option::Option<&crate::model::ListCustomLineItemChargeDetails> {
        self.charge_details.as_ref()
    }
    /// <p> The most recent time the custom line item was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p> The number of resources that are associated to the custom line item. </p>
    pub fn association_size(&self) -> i64 {
        self.association_size
    }
}
impl std::fmt::Debug for UpdateCustomLineItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomLineItemOutput");
        formatter.field("arn", &self.arn);
        formatter.field("billing_group_arn", &self.billing_group_arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("charge_details", &self.charge_details);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("association_size", &self.association_size);
        formatter.finish()
    }
}
/// See [`UpdateCustomLineItemOutput`](crate::output::UpdateCustomLineItemOutput)
pub mod update_custom_line_item_output {
    /// A builder for [`UpdateCustomLineItemOutput`](crate::output::UpdateCustomLineItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) billing_group_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) charge_details:
            std::option::Option<crate::model::ListCustomLineItemChargeDetails>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) association_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> The ARN of the successfully updated custom line item. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the successfully updated custom line item. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The ARN of the billing group that the custom line item is applied to. </p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_arn = Some(input.into());
            self
        }
        /// <p> The ARN of the billing group that the custom line item is applied to. </p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_arn = input;
            self
        }
        /// <p> The name of the successfully updated custom line item. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the successfully updated custom line item. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the successfully updated custom line item. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the successfully updated custom line item. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated custom line item. </p>
        pub fn charge_details(
            mut self,
            input: crate::model::ListCustomLineItemChargeDetails,
        ) -> Self {
            self.charge_details = Some(input);
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated custom line item. </p>
        pub fn set_charge_details(
            mut self,
            input: std::option::Option<crate::model::ListCustomLineItemChargeDetails>,
        ) -> Self {
            self.charge_details = input;
            self
        }
        /// <p> The most recent time the custom line item was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the custom line item was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p> The number of resources that are associated to the custom line item. </p>
        pub fn association_size(mut self, input: i64) -> Self {
            self.association_size = Some(input);
            self
        }
        /// <p> The number of resources that are associated to the custom line item. </p>
        pub fn set_association_size(mut self, input: std::option::Option<i64>) -> Self {
            self.association_size = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomLineItemOutput`](crate::output::UpdateCustomLineItemOutput)
        pub fn build(self) -> crate::output::UpdateCustomLineItemOutput {
            crate::output::UpdateCustomLineItemOutput {
                arn: self.arn,
                billing_group_arn: self.billing_group_arn,
                name: self.name,
                description: self.description,
                charge_details: self.charge_details,
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                association_size: self.association_size.unwrap_or_default(),
            }
        }
    }
}
impl UpdateCustomLineItemOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCustomLineItemOutput`](crate::output::UpdateCustomLineItemOutput)
    pub fn builder() -> crate::output::update_custom_line_item_output::Builder {
        crate::output::update_custom_line_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAccountsOutput {
    /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs is disassociated from. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DisassociateAccountsOutput {
    /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs is disassociated from. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateAccountsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAccountsOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DisassociateAccountsOutput`](crate::output::DisassociateAccountsOutput)
pub mod disassociate_accounts_output {
    /// A builder for [`DisassociateAccountsOutput`](crate::output::DisassociateAccountsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs is disassociated from. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs is disassociated from. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateAccountsOutput`](crate::output::DisassociateAccountsOutput)
        pub fn build(self) -> crate::output::DisassociateAccountsOutput {
            crate::output::DisassociateAccountsOutput { arn: self.arn }
        }
    }
}
impl DisassociateAccountsOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateAccountsOutput`](crate::output::DisassociateAccountsOutput)
    pub fn builder() -> crate::output::disassociate_accounts_output::Builder {
        crate::output::disassociate_accounts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAccountsOutput {
    /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl AssociateAccountsOutput {
    /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateAccountsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAccountsOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`AssociateAccountsOutput`](crate::output::AssociateAccountsOutput)
pub mod associate_accounts_output {
    /// A builder for [`AssociateAccountsOutput`](crate::output::AssociateAccountsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAccountsOutput`](crate::output::AssociateAccountsOutput)
        pub fn build(self) -> crate::output::AssociateAccountsOutput {
            crate::output::AssociateAccountsOutput { arn: self.arn }
        }
    }
}
impl AssociateAccountsOutput {
    /// Creates a new builder-style object to manufacture [`AssociateAccountsOutput`](crate::output::AssociateAccountsOutput)
    pub fn builder() -> crate::output::associate_accounts_output::Builder {
        crate::output::associate_accounts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBillingGroupsOutput {
    /// <p>A list of <code>BillingGroupListElement</code> retrieved. </p>
    pub billing_groups: std::option::Option<std::vec::Vec<crate::model::BillingGroupListElement>>,
    /// <p>The pagination token used on subsequent calls to get billing groups. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBillingGroupsOutput {
    /// <p>A list of <code>BillingGroupListElement</code> retrieved. </p>
    pub fn billing_groups(&self) -> std::option::Option<&[crate::model::BillingGroupListElement]> {
        self.billing_groups.as_deref()
    }
    /// <p>The pagination token used on subsequent calls to get billing groups. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBillingGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBillingGroupsOutput");
        formatter.field("billing_groups", &self.billing_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
pub mod list_billing_groups_output {
    /// A builder for [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_groups:
            std::option::Option<std::vec::Vec<crate::model::BillingGroupListElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `billing_groups`.
        ///
        /// To override the contents of this collection use [`set_billing_groups`](Self::set_billing_groups).
        ///
        /// <p>A list of <code>BillingGroupListElement</code> retrieved. </p>
        pub fn billing_groups(mut self, input: crate::model::BillingGroupListElement) -> Self {
            let mut v = self.billing_groups.unwrap_or_default();
            v.push(input);
            self.billing_groups = Some(v);
            self
        }
        /// <p>A list of <code>BillingGroupListElement</code> retrieved. </p>
        pub fn set_billing_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BillingGroupListElement>>,
        ) -> Self {
            self.billing_groups = input;
            self
        }
        /// <p>The pagination token used on subsequent calls to get billing groups. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used on subsequent calls to get billing groups. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
        pub fn build(self) -> crate::output::ListBillingGroupsOutput {
            crate::output::ListBillingGroupsOutput {
                billing_groups: self.billing_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBillingGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
    pub fn builder() -> crate::output::list_billing_groups_output::Builder {
        crate::output::list_billing_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBillingGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the created billing group. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreateBillingGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the created billing group. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreateBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBillingGroupOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
pub mod create_billing_group_output {
    /// A builder for [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the created billing group. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created billing group. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
        pub fn build(self) -> crate::output::CreateBillingGroupOutput {
            crate::output::CreateBillingGroupOutput { arn: self.arn }
        }
    }
}
impl CreateBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
    pub fn builder() -> crate::output::create_billing_group_output::Builder {
        crate::output::create_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBillingGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted billing group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteBillingGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the deleted billing group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBillingGroupOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
pub mod delete_billing_group_output {
    /// A builder for [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deleted billing group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted billing group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
        pub fn build(self) -> crate::output::DeleteBillingGroupOutput {
            crate::output::DeleteBillingGroupOutput { arn: self.arn }
        }
    }
}
impl DeleteBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
    pub fn builder() -> crate::output::delete_billing_group_output::Builder {
        crate::output::delete_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBillingGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the billing group that was updated. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The name of the billing group. The names must be unique to each billing group. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> A description of the billing group. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The account ID that serves as the main account in a billing group. </p>
    pub primary_account_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing group. </p>
    pub pricing_plan_arn: std::option::Option<std::string::String>,
    /// <p> The number of accounts in the particular billing group. </p>
    pub size: i64,
    /// <p> The most recent time the billing group was modified. </p>
    pub last_modified_time: i64,
    /// <p> The status of the billing group. Only one of the valid values can be used. </p>
    pub status: std::option::Option<crate::model::BillingGroupStatus>,
    /// <p> The reason why the billing group is in its current status. </p>
    pub status_reason: std::option::Option<std::string::String>,
}
impl UpdateBillingGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the billing group that was updated. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The name of the billing group. The names must be unique to each billing group. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> A description of the billing group. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The account ID that serves as the main account in a billing group. </p>
    pub fn primary_account_id(&self) -> std::option::Option<&str> {
        self.primary_account_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing group. </p>
    pub fn pricing_plan_arn(&self) -> std::option::Option<&str> {
        self.pricing_plan_arn.as_deref()
    }
    /// <p> The number of accounts in the particular billing group. </p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p> The most recent time the billing group was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p> The status of the billing group. Only one of the valid values can be used. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::BillingGroupStatus> {
        self.status.as_ref()
    }
    /// <p> The reason why the billing group is in its current status. </p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
}
impl std::fmt::Debug for UpdateBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBillingGroupOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("primary_account_id", &self.primary_account_id);
        formatter.field("pricing_plan_arn", &self.pricing_plan_arn);
        formatter.field("size", &self.size);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
pub mod update_billing_group_output {
    /// A builder for [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) primary_account_id: std::option::Option<std::string::String>,
        pub(crate) pricing_plan_arn: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::BillingGroupStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the billing group that was updated. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the billing group that was updated. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The name of the billing group. The names must be unique to each billing group. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the billing group. The names must be unique to each billing group. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> A description of the billing group. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A description of the billing group. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The account ID that serves as the main account in a billing group. </p>
        pub fn primary_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_account_id = Some(input.into());
            self
        }
        /// <p> The account ID that serves as the main account in a billing group. </p>
        pub fn set_primary_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_account_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing group. </p>
        pub fn pricing_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing group. </p>
        pub fn set_pricing_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_arn = input;
            self
        }
        /// <p> The number of accounts in the particular billing group. </p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p> The number of accounts in the particular billing group. </p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p> The most recent time the billing group was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the billing group was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p> The status of the billing group. Only one of the valid values can be used. </p>
        pub fn status(mut self, input: crate::model::BillingGroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the billing group. Only one of the valid values can be used. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BillingGroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The reason why the billing group is in its current status. </p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p> The reason why the billing group is in its current status. </p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
        pub fn build(self) -> crate::output::UpdateBillingGroupOutput {
            crate::output::UpdateBillingGroupOutput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                primary_account_id: self.primary_account_id,
                pricing_plan_arn: self.pricing_plan_arn,
                size: self.size.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl UpdateBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
    pub fn builder() -> crate::output::update_billing_group_output::Builder {
        crate::output::update_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p> The tags for the resource. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p> The tags for the resource. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags for the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags for the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBillingGroupCostReportsOutput {
    /// <p>A list of <code>BillingGroupCostReportElement</code> retrieved. </p>
    pub billing_group_cost_reports:
        std::option::Option<std::vec::Vec<crate::model::BillingGroupCostReportElement>>,
    /// <p>The pagination token used on subsequent calls to get reports. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBillingGroupCostReportsOutput {
    /// <p>A list of <code>BillingGroupCostReportElement</code> retrieved. </p>
    pub fn billing_group_cost_reports(
        &self,
    ) -> std::option::Option<&[crate::model::BillingGroupCostReportElement]> {
        self.billing_group_cost_reports.as_deref()
    }
    /// <p>The pagination token used on subsequent calls to get reports. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBillingGroupCostReportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBillingGroupCostReportsOutput");
        formatter.field(
            "billing_group_cost_reports",
            &self.billing_group_cost_reports,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBillingGroupCostReportsOutput`](crate::output::ListBillingGroupCostReportsOutput)
pub mod list_billing_group_cost_reports_output {
    /// A builder for [`ListBillingGroupCostReportsOutput`](crate::output::ListBillingGroupCostReportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_cost_reports:
            std::option::Option<std::vec::Vec<crate::model::BillingGroupCostReportElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `billing_group_cost_reports`.
        ///
        /// To override the contents of this collection use [`set_billing_group_cost_reports`](Self::set_billing_group_cost_reports).
        ///
        /// <p>A list of <code>BillingGroupCostReportElement</code> retrieved. </p>
        pub fn billing_group_cost_reports(
            mut self,
            input: crate::model::BillingGroupCostReportElement,
        ) -> Self {
            let mut v = self.billing_group_cost_reports.unwrap_or_default();
            v.push(input);
            self.billing_group_cost_reports = Some(v);
            self
        }
        /// <p>A list of <code>BillingGroupCostReportElement</code> retrieved. </p>
        pub fn set_billing_group_cost_reports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BillingGroupCostReportElement>>,
        ) -> Self {
            self.billing_group_cost_reports = input;
            self
        }
        /// <p>The pagination token used on subsequent calls to get reports. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used on subsequent calls to get reports. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBillingGroupCostReportsOutput`](crate::output::ListBillingGroupCostReportsOutput)
        pub fn build(self) -> crate::output::ListBillingGroupCostReportsOutput {
            crate::output::ListBillingGroupCostReportsOutput {
                billing_group_cost_reports: self.billing_group_cost_reports,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBillingGroupCostReportsOutput {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupCostReportsOutput`](crate::output::ListBillingGroupCostReportsOutput)
    pub fn builder() -> crate::output::list_billing_group_cost_reports_output::Builder {
        crate::output::list_billing_group_cost_reports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountAssociationsOutput {
    /// <p> The list of linked accounts in the payer account. </p>
    pub linked_accounts:
        std::option::Option<std::vec::Vec<crate::model::AccountAssociationsListElement>>,
    /// <p> The pagination token used on subsequent calls to get accounts. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountAssociationsOutput {
    /// <p> The list of linked accounts in the payer account. </p>
    pub fn linked_accounts(
        &self,
    ) -> std::option::Option<&[crate::model::AccountAssociationsListElement]> {
        self.linked_accounts.as_deref()
    }
    /// <p> The pagination token used on subsequent calls to get accounts. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountAssociationsOutput");
        formatter.field("linked_accounts", &self.linked_accounts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccountAssociationsOutput`](crate::output::ListAccountAssociationsOutput)
pub mod list_account_associations_output {
    /// A builder for [`ListAccountAssociationsOutput`](crate::output::ListAccountAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) linked_accounts:
            std::option::Option<std::vec::Vec<crate::model::AccountAssociationsListElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `linked_accounts`.
        ///
        /// To override the contents of this collection use [`set_linked_accounts`](Self::set_linked_accounts).
        ///
        /// <p> The list of linked accounts in the payer account. </p>
        pub fn linked_accounts(
            mut self,
            input: crate::model::AccountAssociationsListElement,
        ) -> Self {
            let mut v = self.linked_accounts.unwrap_or_default();
            v.push(input);
            self.linked_accounts = Some(v);
            self
        }
        /// <p> The list of linked accounts in the payer account. </p>
        pub fn set_linked_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountAssociationsListElement>>,
        ) -> Self {
            self.linked_accounts = input;
            self
        }
        /// <p> The pagination token used on subsequent calls to get accounts. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token used on subsequent calls to get accounts. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAssociationsOutput`](crate::output::ListAccountAssociationsOutput)
        pub fn build(self) -> crate::output::ListAccountAssociationsOutput {
            crate::output::ListAccountAssociationsOutput {
                linked_accounts: self.linked_accounts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccountAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccountAssociationsOutput`](crate::output::ListAccountAssociationsOutput)
    pub fn builder() -> crate::output::list_account_associations_output::Builder {
        crate::output::list_account_associations_output::Builder::default()
    }
}
