// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_accounts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateAccountsOutput, crate::error::AssociateAccountsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateAccountsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateAccountsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociateAccountsError {
            meta: generic,
            kind: crate::error::AssociateAccountsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AssociateAccountsError {
                meta: generic,
                kind: crate::error::AssociateAccountsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateAccountsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::AssociateAccountsError {
            meta: generic,
            kind: crate::error::AssociateAccountsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateAccountsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_accounts_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateAccountsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateAccountsError {
            meta: generic,
            kind: crate::error::AssociateAccountsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceededException" => crate::error::AssociateAccountsError {
            meta: generic,
            kind: crate::error::AssociateAccountsErrorKind::ServiceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::AssociateAccountsError {
            meta: generic,
            kind: crate::error::AssociateAccountsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateAccountsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_accounts_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociateAccountsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AssociateAccountsError {
            meta: generic,
            kind: crate::error::AssociateAccountsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateAccountsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_accounts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateAccountsOutput, crate::error::AssociateAccountsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_accounts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_accounts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateAccountsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_pricing_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociatePricingRulesOutput,
    crate::error::AssociatePricingRulesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociatePricingRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociatePricingRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AssociatePricingRulesError {
            meta: generic,
            kind: crate::error::AssociatePricingRulesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AssociatePricingRulesError {
                meta: generic,
                kind: crate::error::AssociatePricingRulesErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePricingRulesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::AssociatePricingRulesError {
            meta: generic,
            kind: crate::error::AssociatePricingRulesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePricingRulesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_pricing_rules_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociatePricingRulesError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociatePricingRulesError {
            meta: generic,
            kind: crate::error::AssociatePricingRulesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceededException" => crate::error::AssociatePricingRulesError {
            meta: generic,
            kind: crate::error::AssociatePricingRulesErrorKind::ServiceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::AssociatePricingRulesError {
            meta: generic,
            kind: crate::error::AssociatePricingRulesErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePricingRulesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_associate_pricing_rules_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AssociatePricingRulesError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::AssociatePricingRulesError {
            meta: generic,
            kind: crate::error::AssociatePricingRulesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociatePricingRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_pricing_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociatePricingRulesOutput,
    crate::error::AssociatePricingRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_pricing_rules_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_pricing_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociatePricingRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_associate_resources_to_custom_line_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchAssociateResourcesToCustomLineItemOutput,
    crate::error::BatchAssociateResourcesToCustomLineItemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::BatchAssociateResourcesToCustomLineItemError { meta: generic, kind: crate::error::BatchAssociateResourcesToCustomLineItemErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConflictException" => crate::error::BatchAssociateResourcesToCustomLineItemError { meta: generic, kind: crate::error::BatchAssociateResourcesToCustomLineItemErrorKind::ConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerException" => crate::error::BatchAssociateResourcesToCustomLineItemError { meta: generic, kind: crate::error::BatchAssociateResourcesToCustomLineItemErrorKind::InternalServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_batch_associate_resources_to_custom_line_item_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::BatchAssociateResourcesToCustomLineItemError { meta: generic, kind: crate::error::BatchAssociateResourcesToCustomLineItemErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceLimitExceededException" => crate::error::BatchAssociateResourcesToCustomLineItemError { meta: generic, kind: crate::error::BatchAssociateResourcesToCustomLineItemErrorKind::ServiceLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottlingException" => crate::error::BatchAssociateResourcesToCustomLineItemError { meta: generic, kind: crate::error::BatchAssociateResourcesToCustomLineItemErrorKind::ThrottlingException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_batch_associate_resources_to_custom_line_item_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::BatchAssociateResourcesToCustomLineItemError { meta: generic, kind: crate::error::BatchAssociateResourcesToCustomLineItemErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchAssociateResourcesToCustomLineItemError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_associate_resources_to_custom_line_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchAssociateResourcesToCustomLineItemOutput,
    crate::error::BatchAssociateResourcesToCustomLineItemError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::batch_associate_resources_to_custom_line_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_associate_resources_to_custom_line_item(response.body().as_ref(), output).map_err(crate::error::BatchAssociateResourcesToCustomLineItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_disassociate_resources_from_custom_line_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDisassociateResourcesFromCustomLineItemOutput,
    crate::error::BatchDisassociateResourcesFromCustomLineItemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::BatchDisassociateResourcesFromCustomLineItemError { meta: generic, kind: crate::error::BatchDisassociateResourcesFromCustomLineItemErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConflictException" => crate::error::BatchDisassociateResourcesFromCustomLineItemError { meta: generic, kind: crate::error::BatchDisassociateResourcesFromCustomLineItemErrorKind::ConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerException" => crate::error::BatchDisassociateResourcesFromCustomLineItemError { meta: generic, kind: crate::error::BatchDisassociateResourcesFromCustomLineItemErrorKind::InternalServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_batch_disassociate_resources_from_custom_line_item_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::BatchDisassociateResourcesFromCustomLineItemError { meta: generic, kind: crate::error::BatchDisassociateResourcesFromCustomLineItemErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottlingException" => crate::error::BatchDisassociateResourcesFromCustomLineItemError { meta: generic, kind: crate::error::BatchDisassociateResourcesFromCustomLineItemErrorKind::ThrottlingException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_batch_disassociate_resources_from_custom_line_item_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::BatchDisassociateResourcesFromCustomLineItemError { meta: generic, kind: crate::error::BatchDisassociateResourcesFromCustomLineItemErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchDisassociateResourcesFromCustomLineItemError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_disassociate_resources_from_custom_line_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDisassociateResourcesFromCustomLineItemOutput,
    crate::error::BatchDisassociateResourcesFromCustomLineItemError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::batch_disassociate_resources_from_custom_line_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_disassociate_resources_from_custom_line_item(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateResourcesFromCustomLineItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_billing_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBillingGroupOutput,
    crate::error::CreateBillingGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBillingGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBillingGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateBillingGroupError {
            meta: generic,
            kind: crate::error::CreateBillingGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateBillingGroupError {
                meta: generic,
                kind: crate::error::CreateBillingGroupErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBillingGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreateBillingGroupError {
            meta: generic,
            kind: crate::error::CreateBillingGroupErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBillingGroupError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_billing_group_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateBillingGroupError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceededException" => crate::error::CreateBillingGroupError {
            meta: generic,
            kind: crate::error::CreateBillingGroupErrorKind::ServiceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateBillingGroupError {
            meta: generic,
            kind: crate::error::CreateBillingGroupErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBillingGroupError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_billing_group_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateBillingGroupError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateBillingGroupError {
            meta: generic,
            kind: crate::error::CreateBillingGroupErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBillingGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_billing_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBillingGroupOutput,
    crate::error::CreateBillingGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_billing_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_billing_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBillingGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_line_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomLineItemOutput,
    crate::error::CreateCustomLineItemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomLineItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateCustomLineItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateCustomLineItemError {
            meta: generic,
            kind: crate::error::CreateCustomLineItemErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreateCustomLineItemError {
                meta: generic,
                kind: crate::error::CreateCustomLineItemErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomLineItemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreateCustomLineItemError {
            meta: generic,
            kind: crate::error::CreateCustomLineItemErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_custom_line_item_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceededException" => crate::error::CreateCustomLineItemError {
            meta: generic,
            kind: crate::error::CreateCustomLineItemErrorKind::ServiceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateCustomLineItemError {
            meta: generic,
            kind: crate::error::CreateCustomLineItemErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_custom_line_item_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateCustomLineItemError {
            meta: generic,
            kind: crate::error::CreateCustomLineItemErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCustomLineItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_line_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomLineItemOutput,
    crate::error::CreateCustomLineItemError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_custom_line_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_custom_line_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCustomLineItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pricing_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePricingPlanOutput, crate::error::CreatePricingPlanError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePricingPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePricingPlanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreatePricingPlanError {
            meta: generic,
            kind: crate::error::CreatePricingPlanErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreatePricingPlanError {
                meta: generic,
                kind: crate::error::CreatePricingPlanErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreatePricingPlanError {
            meta: generic,
            kind: crate::error::CreatePricingPlanErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_pricing_plan_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreatePricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreatePricingPlanError {
            meta: generic,
            kind: crate::error::CreatePricingPlanErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceededException" => crate::error::CreatePricingPlanError {
            meta: generic,
            kind: crate::error::CreatePricingPlanErrorKind::ServiceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreatePricingPlanError {
            meta: generic,
            kind: crate::error::CreatePricingPlanErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_pricing_plan_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreatePricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreatePricingPlanError {
            meta: generic,
            kind: crate::error::CreatePricingPlanErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePricingPlanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pricing_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePricingPlanOutput, crate::error::CreatePricingPlanError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_pricing_plan_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_pricing_plan(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePricingPlanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pricing_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePricingRuleOutput, crate::error::CreatePricingRuleError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePricingRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePricingRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreatePricingRuleError {
            meta: generic,
            kind: crate::error::CreatePricingRuleErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CreatePricingRuleError {
                meta: generic,
                kind: crate::error::CreatePricingRuleErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CreatePricingRuleError {
            meta: generic,
            kind: crate::error::CreatePricingRuleErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_pricing_rule_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreatePricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceededException" => crate::error::CreatePricingRuleError {
            meta: generic,
            kind: crate::error::CreatePricingRuleErrorKind::ServiceLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreatePricingRuleError {
            meta: generic,
            kind: crate::error::CreatePricingRuleErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_pricing_rule_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreatePricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreatePricingRuleError {
            meta: generic,
            kind: crate::error::CreatePricingRuleErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePricingRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pricing_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePricingRuleOutput, crate::error::CreatePricingRuleError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_pricing_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_pricing_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePricingRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_billing_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBillingGroupOutput,
    crate::error::DeleteBillingGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBillingGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBillingGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteBillingGroupError {
            meta: generic,
            kind: crate::error::DeleteBillingGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::DeleteBillingGroupError {
            meta: generic,
            kind: crate::error::DeleteBillingGroupErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBillingGroupError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_billing_group_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteBillingGroupError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteBillingGroupError {
            meta: generic,
            kind: crate::error::DeleteBillingGroupErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBillingGroupError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_billing_group_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteBillingGroupError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteBillingGroupError {
            meta: generic,
            kind: crate::error::DeleteBillingGroupErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBillingGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_billing_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBillingGroupOutput,
    crate::error::DeleteBillingGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_billing_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_billing_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBillingGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_line_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomLineItemOutput,
    crate::error::DeleteCustomLineItemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomLineItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteCustomLineItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteCustomLineItemError {
            meta: generic,
            kind: crate::error::DeleteCustomLineItemErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteCustomLineItemError {
                meta: generic,
                kind: crate::error::DeleteCustomLineItemErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomLineItemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeleteCustomLineItemError {
            meta: generic,
            kind: crate::error::DeleteCustomLineItemErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_custom_line_item_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteCustomLineItemError {
            meta: generic,
            kind: crate::error::DeleteCustomLineItemErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_custom_line_item_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteCustomLineItemError {
            meta: generic,
            kind: crate::error::DeleteCustomLineItemErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCustomLineItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_line_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomLineItemOutput,
    crate::error::DeleteCustomLineItemError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_custom_line_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_custom_line_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteCustomLineItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pricing_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePricingPlanOutput, crate::error::DeletePricingPlanError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePricingPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePricingPlanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeletePricingPlanError {
            meta: generic,
            kind: crate::error::DeletePricingPlanErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeletePricingPlanError {
                meta: generic,
                kind: crate::error::DeletePricingPlanErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeletePricingPlanError {
            meta: generic,
            kind: crate::error::DeletePricingPlanErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_pricing_plan_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeletePricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeletePricingPlanError {
            meta: generic,
            kind: crate::error::DeletePricingPlanErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_pricing_plan_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeletePricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeletePricingPlanError {
            meta: generic,
            kind: crate::error::DeletePricingPlanErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePricingPlanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pricing_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePricingPlanOutput, crate::error::DeletePricingPlanError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_pricing_plan_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_pricing_plan(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePricingPlanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pricing_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePricingRuleOutput, crate::error::DeletePricingRuleError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePricingRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePricingRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeletePricingRuleError {
            meta: generic,
            kind: crate::error::DeletePricingRuleErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeletePricingRuleError {
                meta: generic,
                kind: crate::error::DeletePricingRuleErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DeletePricingRuleError {
            meta: generic,
            kind: crate::error::DeletePricingRuleErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_pricing_rule_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeletePricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeletePricingRuleError {
            meta: generic,
            kind: crate::error::DeletePricingRuleErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_pricing_rule_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeletePricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeletePricingRuleError {
            meta: generic,
            kind: crate::error::DeletePricingRuleErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePricingRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pricing_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePricingRuleOutput, crate::error::DeletePricingRuleError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_pricing_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_pricing_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePricingRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_accounts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateAccountsOutput,
    crate::error::DisassociateAccountsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateAccountsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateAccountsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociateAccountsError {
            meta: generic,
            kind: crate::error::DisassociateAccountsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DisassociateAccountsError {
                meta: generic,
                kind: crate::error::DisassociateAccountsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateAccountsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DisassociateAccountsError {
            meta: generic,
            kind: crate::error::DisassociateAccountsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateAccountsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_accounts_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateAccountsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DisassociateAccountsError {
            meta: generic,
            kind: crate::error::DisassociateAccountsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DisassociateAccountsError {
            meta: generic,
            kind: crate::error::DisassociateAccountsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateAccountsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_accounts_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociateAccountsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisassociateAccountsError {
            meta: generic,
            kind: crate::error::DisassociateAccountsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateAccountsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateAccountsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_accounts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateAccountsOutput,
    crate::error::DisassociateAccountsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_accounts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disassociate_accounts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisassociateAccountsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_pricing_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociatePricingRulesOutput,
    crate::error::DisassociatePricingRulesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociatePricingRulesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisassociatePricingRulesError {
            meta: generic,
            kind: crate::error::DisassociatePricingRulesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DisassociatePricingRulesError {
                meta: generic,
                kind: crate::error::DisassociatePricingRulesErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::DisassociatePricingRulesError {
            meta: generic,
            kind: crate::error::DisassociatePricingRulesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_pricing_rules_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociatePricingRulesError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DisassociatePricingRulesError {
            meta: generic,
            kind: crate::error::DisassociatePricingRulesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DisassociatePricingRulesError {
            meta: generic,
            kind: crate::error::DisassociatePricingRulesErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_disassociate_pricing_rules_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DisassociatePricingRulesError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisassociatePricingRulesError {
            meta: generic,
            kind: crate::error::DisassociatePricingRulesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociatePricingRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_pricing_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociatePricingRulesOutput,
    crate::error::DisassociatePricingRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_pricing_rules_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disassociate_pricing_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisassociatePricingRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_account_associations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountAssociationsOutput,
    crate::error::ListAccountAssociationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccountAssociationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAccountAssociationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListAccountAssociationsError {
            meta: generic,
            kind: crate::error::ListAccountAssociationsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountAssociationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListAccountAssociationsError {
            meta: generic,
            kind: crate::error::ListAccountAssociationsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountAssociationsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_account_associations_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListAccountAssociationsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListAccountAssociationsError {
            meta: generic,
            kind: crate::error::ListAccountAssociationsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountAssociationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListAccountAssociationsError {
            meta: generic,
            kind: crate::error::ListAccountAssociationsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountAssociationsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_account_associations_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListAccountAssociationsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListAccountAssociationsError {
            meta: generic,
            kind: crate::error::ListAccountAssociationsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountAssociationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAccountAssociationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_account_associations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountAssociationsOutput,
    crate::error::ListAccountAssociationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_account_associations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_account_associations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAccountAssociationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_billing_group_cost_reports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBillingGroupCostReportsOutput,
    crate::error::ListBillingGroupCostReportsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBillingGroupCostReportsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListBillingGroupCostReportsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListBillingGroupCostReportsError {
            meta: generic,
            kind: crate::error::ListBillingGroupCostReportsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupCostReportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListBillingGroupCostReportsError {
            meta: generic,
            kind: crate::error::ListBillingGroupCostReportsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupCostReportsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_billing_group_cost_reports_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListBillingGroupCostReportsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListBillingGroupCostReportsError {
            meta: generic,
            kind: crate::error::ListBillingGroupCostReportsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupCostReportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListBillingGroupCostReportsError {
            meta: generic,
            kind: crate::error::ListBillingGroupCostReportsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupCostReportsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_billing_group_cost_reports_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListBillingGroupCostReportsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListBillingGroupCostReportsError {
            meta: generic,
            kind: crate::error::ListBillingGroupCostReportsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupCostReportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListBillingGroupCostReportsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_billing_group_cost_reports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBillingGroupCostReportsOutput,
    crate::error::ListBillingGroupCostReportsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_billing_group_cost_reports_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_billing_group_cost_reports(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListBillingGroupCostReportsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_billing_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBillingGroupsOutput, crate::error::ListBillingGroupsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBillingGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListBillingGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListBillingGroupsError {
            meta: generic,
            kind: crate::error::ListBillingGroupsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListBillingGroupsError {
            meta: generic,
            kind: crate::error::ListBillingGroupsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_billing_groups_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListBillingGroupsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListBillingGroupsError {
            meta: generic,
            kind: crate::error::ListBillingGroupsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListBillingGroupsError {
            meta: generic,
            kind: crate::error::ListBillingGroupsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_billing_groups_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListBillingGroupsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListBillingGroupsError {
            meta: generic,
            kind: crate::error::ListBillingGroupsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBillingGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListBillingGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_billing_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBillingGroupsOutput, crate::error::ListBillingGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_billing_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_billing_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListBillingGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_line_items_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomLineItemsOutput,
    crate::error::ListCustomLineItemsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCustomLineItemsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListCustomLineItemsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListCustomLineItemsError {
            meta: generic,
            kind: crate::error::ListCustomLineItemsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomLineItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListCustomLineItemsError {
            meta: generic,
            kind: crate::error::ListCustomLineItemsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomLineItemsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_custom_line_items_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListCustomLineItemsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListCustomLineItemsError {
            meta: generic,
            kind: crate::error::ListCustomLineItemsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomLineItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListCustomLineItemsError {
            meta: generic,
            kind: crate::error::ListCustomLineItemsErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomLineItemsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_custom_line_items_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListCustomLineItemsError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListCustomLineItemsError {
            meta: generic,
            kind: crate::error::ListCustomLineItemsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomLineItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListCustomLineItemsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_line_items_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomLineItemsOutput,
    crate::error::ListCustomLineItemsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_custom_line_items_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_custom_line_items(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCustomLineItemsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_plans_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPricingPlansOutput, crate::error::ListPricingPlansError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPricingPlansError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPricingPlansError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPricingPlansError {
            meta: generic,
            kind: crate::error::ListPricingPlansErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListPricingPlansError {
            meta: generic,
            kind: crate::error::ListPricingPlansErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_plans_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingPlansError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListPricingPlansError {
            meta: generic,
            kind: crate::error::ListPricingPlansErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_plans_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingPlansError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListPricingPlansError {
            meta: generic,
            kind: crate::error::ListPricingPlansErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPricingPlansError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_plans_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPricingPlansOutput, crate::error::ListPricingPlansError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pricing_plans_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pricing_plans(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPricingPlansError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_plans_associated_with_pricing_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPricingPlansAssociatedWithPricingRuleOutput,
    crate::error::ListPricingPlansAssociatedWithPricingRuleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPricingPlansAssociatedWithPricingRuleError { meta: generic, kind: crate::error::ListPricingPlansAssociatedWithPricingRuleErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerException" => crate::error::ListPricingPlansAssociatedWithPricingRuleError { meta: generic, kind: crate::error::ListPricingPlansAssociatedWithPricingRuleErrorKind::InternalServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_plans_associated_with_pricing_rule_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListPricingPlansAssociatedWithPricingRuleError { meta: generic, kind: crate::error::ListPricingPlansAssociatedWithPricingRuleErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottlingException" => crate::error::ListPricingPlansAssociatedWithPricingRuleError { meta: generic, kind: crate::error::ListPricingPlansAssociatedWithPricingRuleErrorKind::ThrottlingException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_plans_associated_with_pricing_rule_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::ListPricingPlansAssociatedWithPricingRuleError { meta: generic, kind: crate::error::ListPricingPlansAssociatedWithPricingRuleErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListPricingPlansAssociatedWithPricingRuleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_plans_associated_with_pricing_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPricingPlansAssociatedWithPricingRuleOutput,
    crate::error::ListPricingPlansAssociatedWithPricingRuleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_pricing_plans_associated_with_pricing_rule_output::Builder::default(
            );
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pricing_plans_associated_with_pricing_rule(response.body().as_ref(), output).map_err(crate::error::ListPricingPlansAssociatedWithPricingRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPricingRulesOutput, crate::error::ListPricingRulesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPricingRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPricingRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPricingRulesError {
            meta: generic,
            kind: crate::error::ListPricingRulesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListPricingRulesError {
            meta: generic,
            kind: crate::error::ListPricingRulesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_rules_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingRulesError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListPricingRulesError {
            meta: generic,
            kind: crate::error::ListPricingRulesErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_rules_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingRulesError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListPricingRulesError {
            meta: generic,
            kind: crate::error::ListPricingRulesErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPricingRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPricingRulesOutput, crate::error::ListPricingRulesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pricing_rules_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pricing_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPricingRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_rules_associated_to_pricing_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPricingRulesAssociatedToPricingPlanOutput,
    crate::error::ListPricingRulesAssociatedToPricingPlanError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListPricingRulesAssociatedToPricingPlanError { meta: generic, kind: crate::error::ListPricingRulesAssociatedToPricingPlanErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerException" => crate::error::ListPricingRulesAssociatedToPricingPlanError { meta: generic, kind: crate::error::ListPricingRulesAssociatedToPricingPlanErrorKind::InternalServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_rules_associated_to_pricing_plan_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListPricingRulesAssociatedToPricingPlanError { meta: generic, kind: crate::error::ListPricingRulesAssociatedToPricingPlanErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottlingException" => crate::error::ListPricingRulesAssociatedToPricingPlanError { meta: generic, kind: crate::error::ListPricingRulesAssociatedToPricingPlanErrorKind::ThrottlingException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_pricing_rules_associated_to_pricing_plan_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::ListPricingRulesAssociatedToPricingPlanError { meta: generic, kind: crate::error::ListPricingRulesAssociatedToPricingPlanErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListPricingRulesAssociatedToPricingPlanError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pricing_rules_associated_to_pricing_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPricingRulesAssociatedToPricingPlanOutput,
    crate::error::ListPricingRulesAssociatedToPricingPlanError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_pricing_rules_associated_to_pricing_plan_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pricing_rules_associated_to_pricing_plan(response.body().as_ref(), output).map_err(crate::error::ListPricingRulesAssociatedToPricingPlanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_associated_to_custom_line_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesAssociatedToCustomLineItemOutput,
    crate::error::ListResourcesAssociatedToCustomLineItemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListResourcesAssociatedToCustomLineItemError { meta: generic, kind: crate::error::ListResourcesAssociatedToCustomLineItemErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerException" => crate::error::ListResourcesAssociatedToCustomLineItemError { meta: generic, kind: crate::error::ListResourcesAssociatedToCustomLineItemErrorKind::InternalServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_resources_associated_to_custom_line_item_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListResourcesAssociatedToCustomLineItemError { meta: generic, kind: crate::error::ListResourcesAssociatedToCustomLineItemErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ThrottlingException" => crate::error::ListResourcesAssociatedToCustomLineItemError { meta: generic, kind: crate::error::ListResourcesAssociatedToCustomLineItemErrorKind::ThrottlingException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_resources_associated_to_custom_line_item_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::ListResourcesAssociatedToCustomLineItemError { meta: generic, kind: crate::error::ListResourcesAssociatedToCustomLineItemErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListResourcesAssociatedToCustomLineItemError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_associated_to_custom_line_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesAssociatedToCustomLineItemOutput,
    crate::error::ListResourcesAssociatedToCustomLineItemError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_resources_associated_to_custom_line_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_resources_associated_to_custom_line_item(response.body().as_ref(), output).map_err(crate::error::ListResourcesAssociatedToCustomLineItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_tags_for_resource_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTagsForResourceError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_tags_for_resource_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTagsForResourceError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_tag_resource_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::TagResourceError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_tag_resource_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::TagResourceError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_untag_resource_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UntagResourceError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_untag_resource_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UntagResourceError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_billing_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBillingGroupOutput,
    crate::error::UpdateBillingGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBillingGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateBillingGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateBillingGroupError {
            meta: generic,
            kind: crate::error::UpdateBillingGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdateBillingGroupError {
                meta: generic,
                kind: crate::error::UpdateBillingGroupErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBillingGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::UpdateBillingGroupError {
            meta: generic,
            kind: crate::error::UpdateBillingGroupErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBillingGroupError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_billing_group_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateBillingGroupError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateBillingGroupError {
            meta: generic,
            kind: crate::error::UpdateBillingGroupErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdateBillingGroupError {
            meta: generic,
            kind: crate::error::UpdateBillingGroupErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBillingGroupError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_billing_group_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateBillingGroupError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateBillingGroupError {
            meta: generic,
            kind: crate::error::UpdateBillingGroupErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBillingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateBillingGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_billing_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBillingGroupOutput,
    crate::error::UpdateBillingGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_billing_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_billing_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateBillingGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_line_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomLineItemOutput,
    crate::error::UpdateCustomLineItemError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCustomLineItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateCustomLineItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateCustomLineItemError {
            meta: generic,
            kind: crate::error::UpdateCustomLineItemErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::UpdateCustomLineItemError {
            meta: generic,
            kind: crate::error::UpdateCustomLineItemErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_custom_line_item_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateCustomLineItemError {
            meta: generic,
            kind: crate::error::UpdateCustomLineItemErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdateCustomLineItemError {
            meta: generic,
            kind: crate::error::UpdateCustomLineItemErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomLineItemError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_custom_line_item_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateCustomLineItemError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdateCustomLineItemError {
            meta: generic,
            kind: crate::error::UpdateCustomLineItemErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomLineItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateCustomLineItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_line_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomLineItemOutput,
    crate::error::UpdateCustomLineItemError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_custom_line_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_custom_line_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateCustomLineItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pricing_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePricingPlanOutput, crate::error::UpdatePricingPlanError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePricingPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePricingPlanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdatePricingPlanError {
            meta: generic,
            kind: crate::error::UpdatePricingPlanErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdatePricingPlanError {
                meta: generic,
                kind: crate::error::UpdatePricingPlanErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::UpdatePricingPlanError {
            meta: generic,
            kind: crate::error::UpdatePricingPlanErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_pricing_plan_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdatePricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdatePricingPlanError {
            meta: generic,
            kind: crate::error::UpdatePricingPlanErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdatePricingPlanError {
            meta: generic,
            kind: crate::error::UpdatePricingPlanErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingPlanError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_pricing_plan_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdatePricingPlanError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdatePricingPlanError {
            meta: generic,
            kind: crate::error::UpdatePricingPlanErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePricingPlanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pricing_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePricingPlanOutput, crate::error::UpdatePricingPlanError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_pricing_plan_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_pricing_plan(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePricingPlanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pricing_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePricingRuleOutput, crate::error::UpdatePricingRuleError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePricingRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePricingRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdatePricingRuleError {
            meta: generic,
            kind: crate::error::UpdatePricingRuleErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::UpdatePricingRuleError {
                meta: generic,
                kind: crate::error::UpdatePricingRuleErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::UpdatePricingRuleError {
            meta: generic,
            kind: crate::error::UpdatePricingRuleErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_pricing_rule_internal_server_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdatePricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdatePricingRuleError {
            meta: generic,
            kind: crate::error::UpdatePricingRuleErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::UpdatePricingRuleError {
            meta: generic,
            kind: crate::error::UpdatePricingRuleErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingRuleError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_pricing_rule_throttling_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdatePricingRuleError::unhandled("Failed to parse RetryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::UpdatePricingRuleError {
            meta: generic,
            kind: crate::error::UpdatePricingRuleErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePricingRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePricingRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pricing_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePricingRuleOutput, crate::error::UpdatePricingRuleError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_pricing_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_pricing_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePricingRuleError::unhandled)?;
        output.build()
    })
}
