// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The field's information of a request that resulted in an exception. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The field name. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message describing why the field failed validation. </p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The field name. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The message describing why the field failed validation. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field name. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The field name. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message describing why the field failed validation. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message describing why the field failed validation. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    AccountsAlreadyAssociated,
    #[allow(missing_docs)] // documentation missing in model
    AccountsNotAssociated,
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    DuplicateAccount,
    #[allow(missing_docs)] // documentation missing in model
    DuplicatePricingruleArns,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    IllegalAccounts,
    #[allow(missing_docs)] // documentation missing in model
    IllegalBillingPeriod,
    #[allow(missing_docs)] // documentation missing in model
    IllegalBillingPeriodRange,
    #[allow(missing_docs)] // documentation missing in model
    IllegalChargeDetails,
    #[allow(missing_docs)] // documentation missing in model
    IllegalCustomlineitem,
    #[allow(missing_docs)] // documentation missing in model
    IllegalCustomlineitemModification,
    #[allow(missing_docs)] // documentation missing in model
    IllegalCustomlineitemUpdate,
    #[allow(missing_docs)] // documentation missing in model
    IllegalExpression,
    #[allow(missing_docs)] // documentation missing in model
    IllegalPrimaryAccount,
    #[allow(missing_docs)] // documentation missing in model
    IllegalResourceArns,
    #[allow(missing_docs)] // documentation missing in model
    IllegalScope,
    #[allow(missing_docs)] // documentation missing in model
    IllegalService,
    #[allow(missing_docs)] // documentation missing in model
    IllegalUpdateChargeDetails,
    #[allow(missing_docs)] // documentation missing in model
    InvalidArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidBillingviewArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidBillingGroupStatus,
    #[allow(missing_docs)] // documentation missing in model
    InvalidTimeRange,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedBillinggroupArn,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedBillingviewArn,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedCustomlineitemArn,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedPricingplanArn,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedPricingruleArn,
    #[allow(missing_docs)] // documentation missing in model
    MissingBillinggroup,
    #[allow(missing_docs)] // documentation missing in model
    MissingCustomlineitem,
    #[allow(missing_docs)] // documentation missing in model
    MissingLinkedAccountIds,
    #[allow(missing_docs)] // documentation missing in model
    MissingPricingplan,
    #[allow(missing_docs)] // documentation missing in model
    MissingPricingPlanArn,
    #[allow(missing_docs)] // documentation missing in model
    MultipleLinkedAccountIds,
    #[allow(missing_docs)] // documentation missing in model
    MultiplePricingPlanArn,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    PricingrulesAlreadyAssociated,
    #[allow(missing_docs)] // documentation missing in model
    PricingrulesNotAssociated,
    #[allow(missing_docs)] // documentation missing in model
    PricingrulesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    PrimaryCannotDisassociate,
    #[allow(missing_docs)] // documentation missing in model
    PrimaryNotAssociated,
    #[allow(missing_docs)] // documentation missing in model
    TooManyAccountsInRequest,
    #[allow(missing_docs)] // documentation missing in model
    TooManyCustomlineitemsInRequest,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNTS_ALREADY_ASSOCIATED" => ValidationExceptionReason::AccountsAlreadyAssociated,
            "ACCOUNTS_NOT_ASSOCIATED" => ValidationExceptionReason::AccountsNotAssociated,
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "DUPLICATE_ACCOUNT" => ValidationExceptionReason::DuplicateAccount,
            "DUPLICATE_PRICINGRULE_ARNS" => ValidationExceptionReason::DuplicatePricingruleArns,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "ILLEGAL_ACCOUNTS" => ValidationExceptionReason::IllegalAccounts,
            "ILLEGAL_BILLING_PERIOD" => ValidationExceptionReason::IllegalBillingPeriod,
            "ILLEGAL_BILLING_PERIOD_RANGE" => ValidationExceptionReason::IllegalBillingPeriodRange,
            "ILLEGAL_CHARGE_DETAILS" => ValidationExceptionReason::IllegalChargeDetails,
            "ILLEGAL_CUSTOMLINEITEM" => ValidationExceptionReason::IllegalCustomlineitem,
            "ILLEGAL_CUSTOMLINEITEM_MODIFICATION" => {
                ValidationExceptionReason::IllegalCustomlineitemModification
            }
            "ILLEGAL_CUSTOMLINEITEM_UPDATE" => {
                ValidationExceptionReason::IllegalCustomlineitemUpdate
            }
            "ILLEGAL_EXPRESSION" => ValidationExceptionReason::IllegalExpression,
            "ILLEGAL_PRIMARY_ACCOUNT" => ValidationExceptionReason::IllegalPrimaryAccount,
            "ILLEGAL_RESOURCE_ARNS" => ValidationExceptionReason::IllegalResourceArns,
            "ILLEGAL_SCOPE" => ValidationExceptionReason::IllegalScope,
            "ILLEGAL_SERVICE" => ValidationExceptionReason::IllegalService,
            "ILLEGAL_UPDATE_CHARGE_DETAILS" => {
                ValidationExceptionReason::IllegalUpdateChargeDetails
            }
            "INVALID_ARN" => ValidationExceptionReason::InvalidArn,
            "INVALID_BILLINGVIEW_ARN" => ValidationExceptionReason::InvalidBillingviewArn,
            "INVALID_BILLING_GROUP_STATUS" => ValidationExceptionReason::InvalidBillingGroupStatus,
            "INVALID_TIME_RANGE" => ValidationExceptionReason::InvalidTimeRange,
            "MISMATCHED_BILLINGGROUP_ARN" => ValidationExceptionReason::MismatchedBillinggroupArn,
            "MISMATCHED_BILLINGVIEW_ARN" => ValidationExceptionReason::MismatchedBillingviewArn,
            "MISMATCHED_CUSTOMLINEITEM_ARN" => {
                ValidationExceptionReason::MismatchedCustomlineitemArn
            }
            "MISMATCHED_PRICINGPLAN_ARN" => ValidationExceptionReason::MismatchedPricingplanArn,
            "MISMATCHED_PRICINGRULE_ARN" => ValidationExceptionReason::MismatchedPricingruleArn,
            "MISSING_BILLINGGROUP" => ValidationExceptionReason::MissingBillinggroup,
            "MISSING_CUSTOMLINEITEM" => ValidationExceptionReason::MissingCustomlineitem,
            "MISSING_LINKED_ACCOUNT_IDS" => ValidationExceptionReason::MissingLinkedAccountIds,
            "MISSING_PRICINGPLAN" => ValidationExceptionReason::MissingPricingplan,
            "MISSING_PRICING_PLAN_ARN" => ValidationExceptionReason::MissingPricingPlanArn,
            "MULTIPLE_LINKED_ACCOUNT_IDS" => ValidationExceptionReason::MultipleLinkedAccountIds,
            "MULTIPLE_PRICING_PLAN_ARN" => ValidationExceptionReason::MultiplePricingPlanArn,
            "OTHER" => ValidationExceptionReason::Other,
            "PRICINGRULES_ALREADY_ASSOCIATED" => {
                ValidationExceptionReason::PricingrulesAlreadyAssociated
            }
            "PRICINGRULES_NOT_ASSOCIATED" => ValidationExceptionReason::PricingrulesNotAssociated,
            "PRICINGRULES_NOT_EXIST" => ValidationExceptionReason::PricingrulesNotExist,
            "PRIMARY_CANNOT_DISASSOCIATE" => ValidationExceptionReason::PrimaryCannotDisassociate,
            "PRIMARY_NOT_ASSOCIATED" => ValidationExceptionReason::PrimaryNotAssociated,
            "TOO_MANY_ACCOUNTS_IN_REQUEST" => ValidationExceptionReason::TooManyAccountsInRequest,
            "TOO_MANY_CUSTOMLINEITEMS_IN_REQUEST" => {
                ValidationExceptionReason::TooManyCustomlineitemsInRequest
            }
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::AccountsAlreadyAssociated => "ACCOUNTS_ALREADY_ASSOCIATED",
            ValidationExceptionReason::AccountsNotAssociated => "ACCOUNTS_NOT_ASSOCIATED",
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::DuplicateAccount => "DUPLICATE_ACCOUNT",
            ValidationExceptionReason::DuplicatePricingruleArns => "DUPLICATE_PRICINGRULE_ARNS",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::IllegalAccounts => "ILLEGAL_ACCOUNTS",
            ValidationExceptionReason::IllegalBillingPeriod => "ILLEGAL_BILLING_PERIOD",
            ValidationExceptionReason::IllegalBillingPeriodRange => "ILLEGAL_BILLING_PERIOD_RANGE",
            ValidationExceptionReason::IllegalChargeDetails => "ILLEGAL_CHARGE_DETAILS",
            ValidationExceptionReason::IllegalCustomlineitem => "ILLEGAL_CUSTOMLINEITEM",
            ValidationExceptionReason::IllegalCustomlineitemModification => {
                "ILLEGAL_CUSTOMLINEITEM_MODIFICATION"
            }
            ValidationExceptionReason::IllegalCustomlineitemUpdate => {
                "ILLEGAL_CUSTOMLINEITEM_UPDATE"
            }
            ValidationExceptionReason::IllegalExpression => "ILLEGAL_EXPRESSION",
            ValidationExceptionReason::IllegalPrimaryAccount => "ILLEGAL_PRIMARY_ACCOUNT",
            ValidationExceptionReason::IllegalResourceArns => "ILLEGAL_RESOURCE_ARNS",
            ValidationExceptionReason::IllegalScope => "ILLEGAL_SCOPE",
            ValidationExceptionReason::IllegalService => "ILLEGAL_SERVICE",
            ValidationExceptionReason::IllegalUpdateChargeDetails => {
                "ILLEGAL_UPDATE_CHARGE_DETAILS"
            }
            ValidationExceptionReason::InvalidArn => "INVALID_ARN",
            ValidationExceptionReason::InvalidBillingviewArn => "INVALID_BILLINGVIEW_ARN",
            ValidationExceptionReason::InvalidBillingGroupStatus => "INVALID_BILLING_GROUP_STATUS",
            ValidationExceptionReason::InvalidTimeRange => "INVALID_TIME_RANGE",
            ValidationExceptionReason::MismatchedBillinggroupArn => "MISMATCHED_BILLINGGROUP_ARN",
            ValidationExceptionReason::MismatchedBillingviewArn => "MISMATCHED_BILLINGVIEW_ARN",
            ValidationExceptionReason::MismatchedCustomlineitemArn => {
                "MISMATCHED_CUSTOMLINEITEM_ARN"
            }
            ValidationExceptionReason::MismatchedPricingplanArn => "MISMATCHED_PRICINGPLAN_ARN",
            ValidationExceptionReason::MismatchedPricingruleArn => "MISMATCHED_PRICINGRULE_ARN",
            ValidationExceptionReason::MissingBillinggroup => "MISSING_BILLINGGROUP",
            ValidationExceptionReason::MissingCustomlineitem => "MISSING_CUSTOMLINEITEM",
            ValidationExceptionReason::MissingLinkedAccountIds => "MISSING_LINKED_ACCOUNT_IDS",
            ValidationExceptionReason::MissingPricingplan => "MISSING_PRICINGPLAN",
            ValidationExceptionReason::MissingPricingPlanArn => "MISSING_PRICING_PLAN_ARN",
            ValidationExceptionReason::MultipleLinkedAccountIds => "MULTIPLE_LINKED_ACCOUNT_IDS",
            ValidationExceptionReason::MultiplePricingPlanArn => "MULTIPLE_PRICING_PLAN_ARN",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::PricingrulesAlreadyAssociated => {
                "PRICINGRULES_ALREADY_ASSOCIATED"
            }
            ValidationExceptionReason::PricingrulesNotAssociated => "PRICINGRULES_NOT_ASSOCIATED",
            ValidationExceptionReason::PricingrulesNotExist => "PRICINGRULES_NOT_EXIST",
            ValidationExceptionReason::PrimaryCannotDisassociate => "PRIMARY_CANNOT_DISASSOCIATE",
            ValidationExceptionReason::PrimaryNotAssociated => "PRIMARY_NOT_ASSOCIATED",
            ValidationExceptionReason::TooManyAccountsInRequest => "TOO_MANY_ACCOUNTS_IN_REQUEST",
            ValidationExceptionReason::TooManyCustomlineitemsInRequest => {
                "TOO_MANY_CUSTOMLINEITEMS_IN_REQUEST"
            }
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNTS_ALREADY_ASSOCIATED",
            "ACCOUNTS_NOT_ASSOCIATED",
            "CANNOT_PARSE",
            "DUPLICATE_ACCOUNT",
            "DUPLICATE_PRICINGRULE_ARNS",
            "FIELD_VALIDATION_FAILED",
            "ILLEGAL_ACCOUNTS",
            "ILLEGAL_BILLING_PERIOD",
            "ILLEGAL_BILLING_PERIOD_RANGE",
            "ILLEGAL_CHARGE_DETAILS",
            "ILLEGAL_CUSTOMLINEITEM",
            "ILLEGAL_CUSTOMLINEITEM_MODIFICATION",
            "ILLEGAL_CUSTOMLINEITEM_UPDATE",
            "ILLEGAL_EXPRESSION",
            "ILLEGAL_PRIMARY_ACCOUNT",
            "ILLEGAL_RESOURCE_ARNS",
            "ILLEGAL_SCOPE",
            "ILLEGAL_SERVICE",
            "ILLEGAL_UPDATE_CHARGE_DETAILS",
            "INVALID_ARN",
            "INVALID_BILLINGVIEW_ARN",
            "INVALID_BILLING_GROUP_STATUS",
            "INVALID_TIME_RANGE",
            "MISMATCHED_BILLINGGROUP_ARN",
            "MISMATCHED_BILLINGVIEW_ARN",
            "MISMATCHED_CUSTOMLINEITEM_ARN",
            "MISMATCHED_PRICINGPLAN_ARN",
            "MISMATCHED_PRICINGRULE_ARN",
            "MISSING_BILLINGGROUP",
            "MISSING_CUSTOMLINEITEM",
            "MISSING_LINKED_ACCOUNT_IDS",
            "MISSING_PRICINGPLAN",
            "MISSING_PRICING_PLAN_ARN",
            "MULTIPLE_LINKED_ACCOUNT_IDS",
            "MULTIPLE_PRICING_PLAN_ARN",
            "OTHER",
            "PRICINGRULES_ALREADY_ASSOCIATED",
            "PRICINGRULES_NOT_ASSOCIATED",
            "PRICINGRULES_NOT_EXIST",
            "PRIMARY_CANNOT_DISASSOCIATE",
            "PRIMARY_NOT_ASSOCIATED",
            "TOO_MANY_ACCOUNTS_IN_REQUEST",
            "TOO_MANY_CUSTOMLINEITEMS_IN_REQUEST",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A representation of a pricing rule. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PricingRuleListElement {
    /// <p> The name of a pricing rule. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) used to uniquely identify a pricing rule. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The pricing rule description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific. </p>
    pub scope: std::option::Option<crate::model::PricingRuleScope>,
    /// <p> The type of pricing rule. </p>
    pub r#type: std::option::Option<crate::model::PricingRuleType>,
    /// <p> A percentage modifier applied on the public pricing rates. </p>
    pub modifier_percentage: std::option::Option<f64>,
    /// <p> If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    pub service: std::option::Option<std::string::String>,
    /// <p> The pricing plans count that this pricing rule is associated with. </p>
    pub associated_pricing_plan_count: i64,
    /// <p> The time the pricing rule was created. </p>
    pub creation_time: i64,
    /// <p> The most recent time the pricing rule was modified. </p>
    pub last_modified_time: i64,
}
impl PricingRuleListElement {
    /// <p> The name of a pricing rule. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) used to uniquely identify a pricing rule. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The pricing rule description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific. </p>
    pub fn scope(&self) -> std::option::Option<&crate::model::PricingRuleScope> {
        self.scope.as_ref()
    }
    /// <p> The type of pricing rule. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PricingRuleType> {
        self.r#type.as_ref()
    }
    /// <p> A percentage modifier applied on the public pricing rates. </p>
    pub fn modifier_percentage(&self) -> std::option::Option<f64> {
        self.modifier_percentage
    }
    /// <p> If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p> The pricing plans count that this pricing rule is associated with. </p>
    pub fn associated_pricing_plan_count(&self) -> i64 {
        self.associated_pricing_plan_count
    }
    /// <p> The time the pricing rule was created. </p>
    pub fn creation_time(&self) -> i64 {
        self.creation_time
    }
    /// <p> The most recent time the pricing rule was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
}
impl std::fmt::Debug for PricingRuleListElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PricingRuleListElement");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("scope", &self.scope);
        formatter.field("r#type", &self.r#type);
        formatter.field("modifier_percentage", &self.modifier_percentage);
        formatter.field("service", &self.service);
        formatter.field(
            "associated_pricing_plan_count",
            &self.associated_pricing_plan_count,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`PricingRuleListElement`](crate::model::PricingRuleListElement)
pub mod pricing_rule_list_element {
    /// A builder for [`PricingRuleListElement`](crate::model::PricingRuleListElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) scope: std::option::Option<crate::model::PricingRuleScope>,
        pub(crate) r#type: std::option::Option<crate::model::PricingRuleType>,
        pub(crate) modifier_percentage: std::option::Option<f64>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) associated_pricing_plan_count: std::option::Option<i64>,
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> The name of a pricing rule. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of a pricing rule. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) used to uniquely identify a pricing rule. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) used to uniquely identify a pricing rule. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The pricing rule description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The pricing rule description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific. </p>
        pub fn scope(mut self, input: crate::model::PricingRuleScope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p> The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific. </p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::PricingRuleScope>,
        ) -> Self {
            self.scope = input;
            self
        }
        /// <p> The type of pricing rule. </p>
        pub fn r#type(mut self, input: crate::model::PricingRuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of pricing rule. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PricingRuleType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p> A percentage modifier applied on the public pricing rates. </p>
        pub fn modifier_percentage(mut self, input: f64) -> Self {
            self.modifier_percentage = Some(input);
            self
        }
        /// <p> A percentage modifier applied on the public pricing rates. </p>
        pub fn set_modifier_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.modifier_percentage = input;
            self
        }
        /// <p> If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p> If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the <code>PricingRule</code> is applicable for. </p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p> The pricing plans count that this pricing rule is associated with. </p>
        pub fn associated_pricing_plan_count(mut self, input: i64) -> Self {
            self.associated_pricing_plan_count = Some(input);
            self
        }
        /// <p> The pricing plans count that this pricing rule is associated with. </p>
        pub fn set_associated_pricing_plan_count(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.associated_pricing_plan_count = input;
            self
        }
        /// <p> The time the pricing rule was created. </p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> The time the pricing rule was created. </p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The most recent time the pricing rule was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the pricing rule was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PricingRuleListElement`](crate::model::PricingRuleListElement)
        pub fn build(self) -> crate::model::PricingRuleListElement {
            crate::model::PricingRuleListElement {
                name: self.name,
                arn: self.arn,
                description: self.description,
                scope: self.scope,
                r#type: self.r#type,
                modifier_percentage: self.modifier_percentage,
                service: self.service,
                associated_pricing_plan_count: self
                    .associated_pricing_plan_count
                    .unwrap_or_default(),
                creation_time: self.creation_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
            }
        }
    }
}
impl PricingRuleListElement {
    /// Creates a new builder-style object to manufacture [`PricingRuleListElement`](crate::model::PricingRuleListElement)
    pub fn builder() -> crate::model::pricing_rule_list_element::Builder {
        crate::model::pricing_rule_list_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PricingRuleType {
    #[allow(missing_docs)] // documentation missing in model
    Discount,
    #[allow(missing_docs)] // documentation missing in model
    Markup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PricingRuleType {
    fn from(s: &str) -> Self {
        match s {
            "DISCOUNT" => PricingRuleType::Discount,
            "MARKUP" => PricingRuleType::Markup,
            other => PricingRuleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PricingRuleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PricingRuleType::from(s))
    }
}
impl PricingRuleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PricingRuleType::Discount => "DISCOUNT",
            PricingRuleType::Markup => "MARKUP",
            PricingRuleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISCOUNT", "MARKUP"]
    }
}
impl AsRef<str> for PricingRuleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PricingRuleScope {
    #[allow(missing_docs)] // documentation missing in model
    Global,
    #[allow(missing_docs)] // documentation missing in model
    Service,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PricingRuleScope {
    fn from(s: &str) -> Self {
        match s {
            "GLOBAL" => PricingRuleScope::Global,
            "SERVICE" => PricingRuleScope::Service,
            other => PricingRuleScope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PricingRuleScope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PricingRuleScope::from(s))
    }
}
impl PricingRuleScope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PricingRuleScope::Global => "GLOBAL",
            PricingRuleScope::Service => "SERVICE",
            PricingRuleScope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GLOBAL", "SERVICE"]
    }
}
impl AsRef<str> for PricingRuleScope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The filter that specifies criteria that the pricing rules returned by the <code>ListPricingRules</code> API will adhere to. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingRulesFilter {
    /// <p> A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response. </p>
    pub arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListPricingRulesFilter {
    /// <p> A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response. </p>
    pub fn arns(&self) -> std::option::Option<&[std::string::String]> {
        self.arns.as_deref()
    }
}
impl std::fmt::Debug for ListPricingRulesFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingRulesFilter");
        formatter.field("arns", &self.arns);
        formatter.finish()
    }
}
/// See [`ListPricingRulesFilter`](crate::model::ListPricingRulesFilter)
pub mod list_pricing_rules_filter {
    /// A builder for [`ListPricingRulesFilter`](crate::model::ListPricingRulesFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p> A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response. </p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.arns.unwrap_or_default();
            v.push(input.into());
            self.arns = Some(v);
            self
        }
        /// <p> A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response. </p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingRulesFilter`](crate::model::ListPricingRulesFilter)
        pub fn build(self) -> crate::model::ListPricingRulesFilter {
            crate::model::ListPricingRulesFilter { arns: self.arns }
        }
    }
}
impl ListPricingRulesFilter {
    /// Creates a new builder-style object to manufacture [`ListPricingRulesFilter`](crate::model::ListPricingRulesFilter)
    pub fn builder() -> crate::model::list_pricing_rules_filter::Builder {
        crate::model::list_pricing_rules_filter::Builder::default()
    }
}

/// <p>A representation of a pricing plan. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PricingPlanListElement {
    /// <p>The name of a pricing plan. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The pricing plan Amazon Resource Names (ARN). This can be used to uniquely identify a pricing plan. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The pricing plan description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The pricing rules count currently associated with this pricing plan list element. </p>
    pub size: i64,
    /// <p> The time the pricing plan was created. </p>
    pub creation_time: i64,
    /// <p> The most recent time the pricing plan was modified. </p>
    pub last_modified_time: i64,
}
impl PricingPlanListElement {
    /// <p>The name of a pricing plan. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The pricing plan Amazon Resource Names (ARN). This can be used to uniquely identify a pricing plan. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The pricing plan description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The pricing rules count currently associated with this pricing plan list element. </p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p> The time the pricing plan was created. </p>
    pub fn creation_time(&self) -> i64 {
        self.creation_time
    }
    /// <p> The most recent time the pricing plan was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
}
impl std::fmt::Debug for PricingPlanListElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PricingPlanListElement");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("size", &self.size);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`PricingPlanListElement`](crate::model::PricingPlanListElement)
pub mod pricing_plan_list_element {
    /// A builder for [`PricingPlanListElement`](crate::model::PricingPlanListElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of a pricing plan. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a pricing plan. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The pricing plan Amazon Resource Names (ARN). This can be used to uniquely identify a pricing plan. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The pricing plan Amazon Resource Names (ARN). This can be used to uniquely identify a pricing plan. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The pricing plan description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The pricing rules count currently associated with this pricing plan list element. </p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p> The pricing rules count currently associated with this pricing plan list element. </p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p> The time the pricing plan was created. </p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> The time the pricing plan was created. </p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The most recent time the pricing plan was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the pricing plan was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PricingPlanListElement`](crate::model::PricingPlanListElement)
        pub fn build(self) -> crate::model::PricingPlanListElement {
            crate::model::PricingPlanListElement {
                name: self.name,
                arn: self.arn,
                description: self.description,
                size: self.size.unwrap_or_default(),
                creation_time: self.creation_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
            }
        }
    }
}
impl PricingPlanListElement {
    /// Creates a new builder-style object to manufacture [`PricingPlanListElement`](crate::model::PricingPlanListElement)
    pub fn builder() -> crate::model::pricing_plan_list_element::Builder {
        crate::model::pricing_plan_list_element::Builder::default()
    }
}

/// <p>The filter that specifies the Amazon Resource Names (ARNs) of pricing plans, to retrieve pricing plan information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricingPlansFilter {
    /// <p>A list of pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
    pub arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListPricingPlansFilter {
    /// <p>A list of pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
    pub fn arns(&self) -> std::option::Option<&[std::string::String]> {
        self.arns.as_deref()
    }
}
impl std::fmt::Debug for ListPricingPlansFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricingPlansFilter");
        formatter.field("arns", &self.arns);
        formatter.finish()
    }
}
/// See [`ListPricingPlansFilter`](crate::model::ListPricingPlansFilter)
pub mod list_pricing_plans_filter {
    /// A builder for [`ListPricingPlansFilter`](crate::model::ListPricingPlansFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>A list of pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.arns.unwrap_or_default();
            v.push(input.into());
            self.arns = Some(v);
            self
        }
        /// <p>A list of pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricingPlansFilter`](crate::model::ListPricingPlansFilter)
        pub fn build(self) -> crate::model::ListPricingPlansFilter {
            crate::model::ListPricingPlansFilter { arns: self.arns }
        }
    }
}
impl ListPricingPlansFilter {
    /// Creates a new builder-style object to manufacture [`ListPricingPlansFilter`](crate::model::ListPricingPlansFilter)
    pub fn builder() -> crate::model::list_pricing_plans_filter::Builder {
        crate::model::list_pricing_plans_filter::Builder::default()
    }
}

/// <p> A representation of a resource association for a custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesAssociatedToCustomLineItemResponseElement {
    /// <p> The ARN of the associated resource. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The type of relationship between the custom line item and the associated resource. </p>
    pub relationship: std::option::Option<crate::model::CustomLineItemRelationship>,
}
impl ListResourcesAssociatedToCustomLineItemResponseElement {
    /// <p> The ARN of the associated resource. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The type of relationship between the custom line item and the associated resource. </p>
    pub fn relationship(&self) -> std::option::Option<&crate::model::CustomLineItemRelationship> {
        self.relationship.as_ref()
    }
}
impl std::fmt::Debug for ListResourcesAssociatedToCustomLineItemResponseElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("ListResourcesAssociatedToCustomLineItemResponseElement");
        formatter.field("arn", &self.arn);
        formatter.field("relationship", &self.relationship);
        formatter.finish()
    }
}
/// See [`ListResourcesAssociatedToCustomLineItemResponseElement`](crate::model::ListResourcesAssociatedToCustomLineItemResponseElement)
pub mod list_resources_associated_to_custom_line_item_response_element {
    /// A builder for [`ListResourcesAssociatedToCustomLineItemResponseElement`](crate::model::ListResourcesAssociatedToCustomLineItemResponseElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) relationship: std::option::Option<crate::model::CustomLineItemRelationship>,
    }
    impl Builder {
        /// <p> The ARN of the associated resource. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the associated resource. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The type of relationship between the custom line item and the associated resource. </p>
        pub fn relationship(mut self, input: crate::model::CustomLineItemRelationship) -> Self {
            self.relationship = Some(input);
            self
        }
        /// <p> The type of relationship between the custom line item and the associated resource. </p>
        pub fn set_relationship(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemRelationship>,
        ) -> Self {
            self.relationship = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesAssociatedToCustomLineItemResponseElement`](crate::model::ListResourcesAssociatedToCustomLineItemResponseElement)
        pub fn build(self) -> crate::model::ListResourcesAssociatedToCustomLineItemResponseElement {
            crate::model::ListResourcesAssociatedToCustomLineItemResponseElement {
                arn: self.arn,
                relationship: self.relationship,
            }
        }
    }
}
impl ListResourcesAssociatedToCustomLineItemResponseElement {
    /// Creates a new builder-style object to manufacture [`ListResourcesAssociatedToCustomLineItemResponseElement`](crate::model::ListResourcesAssociatedToCustomLineItemResponseElement)
    pub fn builder(
    ) -> crate::model::list_resources_associated_to_custom_line_item_response_element::Builder {
        crate::model::list_resources_associated_to_custom_line_item_response_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomLineItemRelationship {
    #[allow(missing_docs)] // documentation missing in model
    Child,
    #[allow(missing_docs)] // documentation missing in model
    Parent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomLineItemRelationship {
    fn from(s: &str) -> Self {
        match s {
            "CHILD" => CustomLineItemRelationship::Child,
            "PARENT" => CustomLineItemRelationship::Parent,
            other => CustomLineItemRelationship::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomLineItemRelationship {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomLineItemRelationship::from(s))
    }
}
impl CustomLineItemRelationship {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomLineItemRelationship::Child => "CHILD",
            CustomLineItemRelationship::Parent => "PARENT",
            CustomLineItemRelationship::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHILD", "PARENT"]
    }
}
impl AsRef<str> for CustomLineItemRelationship {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A filter that specifies the type of resource associations that should be retrieved for a custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesAssociatedToCustomLineItemFilter {
    /// <p> The type of relationship between the custom line item and the associated resource. </p>
    pub relationship: std::option::Option<crate::model::CustomLineItemRelationship>,
}
impl ListResourcesAssociatedToCustomLineItemFilter {
    /// <p> The type of relationship between the custom line item and the associated resource. </p>
    pub fn relationship(&self) -> std::option::Option<&crate::model::CustomLineItemRelationship> {
        self.relationship.as_ref()
    }
}
impl std::fmt::Debug for ListResourcesAssociatedToCustomLineItemFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesAssociatedToCustomLineItemFilter");
        formatter.field("relationship", &self.relationship);
        formatter.finish()
    }
}
/// See [`ListResourcesAssociatedToCustomLineItemFilter`](crate::model::ListResourcesAssociatedToCustomLineItemFilter)
pub mod list_resources_associated_to_custom_line_item_filter {
    /// A builder for [`ListResourcesAssociatedToCustomLineItemFilter`](crate::model::ListResourcesAssociatedToCustomLineItemFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relationship: std::option::Option<crate::model::CustomLineItemRelationship>,
    }
    impl Builder {
        /// <p> The type of relationship between the custom line item and the associated resource. </p>
        pub fn relationship(mut self, input: crate::model::CustomLineItemRelationship) -> Self {
            self.relationship = Some(input);
            self
        }
        /// <p> The type of relationship between the custom line item and the associated resource. </p>
        pub fn set_relationship(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemRelationship>,
        ) -> Self {
            self.relationship = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesAssociatedToCustomLineItemFilter`](crate::model::ListResourcesAssociatedToCustomLineItemFilter)
        pub fn build(self) -> crate::model::ListResourcesAssociatedToCustomLineItemFilter {
            crate::model::ListResourcesAssociatedToCustomLineItemFilter {
                relationship: self.relationship,
            }
        }
    }
}
impl ListResourcesAssociatedToCustomLineItemFilter {
    /// Creates a new builder-style object to manufacture [`ListResourcesAssociatedToCustomLineItemFilter`](crate::model::ListResourcesAssociatedToCustomLineItemFilter)
    pub fn builder() -> crate::model::list_resources_associated_to_custom_line_item_filter::Builder
    {
        crate::model::list_resources_associated_to_custom_line_item_filter::Builder::default()
    }
}

/// <p> A resource disassociation result for a percentage custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResourceResponseElement {
    /// <p> The resource ARN that was disassociated from the custom line item. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> An <code>AssociateResourceError</code> shown if the resource disassociation fails. </p>
    pub error: std::option::Option<crate::model::AssociateResourceError>,
}
impl DisassociateResourceResponseElement {
    /// <p> The resource ARN that was disassociated from the custom line item. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> An <code>AssociateResourceError</code> shown if the resource disassociation fails. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::AssociateResourceError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for DisassociateResourceResponseElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResourceResponseElement");
        formatter.field("arn", &self.arn);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`DisassociateResourceResponseElement`](crate::model::DisassociateResourceResponseElement)
pub mod disassociate_resource_response_element {
    /// A builder for [`DisassociateResourceResponseElement`](crate::model::DisassociateResourceResponseElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::AssociateResourceError>,
    }
    impl Builder {
        /// <p> The resource ARN that was disassociated from the custom line item. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The resource ARN that was disassociated from the custom line item. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> An <code>AssociateResourceError</code> shown if the resource disassociation fails. </p>
        pub fn error(mut self, input: crate::model::AssociateResourceError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p> An <code>AssociateResourceError</code> shown if the resource disassociation fails. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::AssociateResourceError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResourceResponseElement`](crate::model::DisassociateResourceResponseElement)
        pub fn build(self) -> crate::model::DisassociateResourceResponseElement {
            crate::model::DisassociateResourceResponseElement {
                arn: self.arn,
                error: self.error,
            }
        }
    }
}
impl DisassociateResourceResponseElement {
    /// Creates a new builder-style object to manufacture [`DisassociateResourceResponseElement`](crate::model::DisassociateResourceResponseElement)
    pub fn builder() -> crate::model::disassociate_resource_response_element::Builder {
        crate::model::disassociate_resource_response_element::Builder::default()
    }
}

/// <p> A representation of a resource association error. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResourceError {
    /// <p> The reason the resource association failed. </p>
    pub message: std::option::Option<std::string::String>,
    /// <p> A static error code that used to classify the type of failure. </p>
    pub reason: std::option::Option<crate::model::AssociateResourceErrorReason>,
}
impl AssociateResourceError {
    /// <p> The reason the resource association failed. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p> A static error code that used to classify the type of failure. </p>
    pub fn reason(&self) -> std::option::Option<&crate::model::AssociateResourceErrorReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for AssociateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResourceError");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`AssociateResourceError`](crate::model::AssociateResourceError)
pub mod associate_resource_error {
    /// A builder for [`AssociateResourceError`](crate::model::AssociateResourceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::AssociateResourceErrorReason>,
    }
    impl Builder {
        /// <p> The reason the resource association failed. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> The reason the resource association failed. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> A static error code that used to classify the type of failure. </p>
        pub fn reason(mut self, input: crate::model::AssociateResourceErrorReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p> A static error code that used to classify the type of failure. </p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AssociateResourceErrorReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResourceError`](crate::model::AssociateResourceError)
        pub fn build(self) -> crate::model::AssociateResourceError {
            crate::model::AssociateResourceError {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl AssociateResourceError {
    /// Creates a new builder-style object to manufacture [`AssociateResourceError`](crate::model::AssociateResourceError)
    pub fn builder() -> crate::model::associate_resource_error::Builder {
        crate::model::associate_resource_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssociateResourceErrorReason {
    #[allow(missing_docs)] // documentation missing in model
    IllegalCustomlineitem,
    #[allow(missing_docs)] // documentation missing in model
    InternalServerException,
    #[allow(missing_docs)] // documentation missing in model
    InvalidArn,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLimitExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssociateResourceErrorReason {
    fn from(s: &str) -> Self {
        match s {
            "ILLEGAL_CUSTOMLINEITEM" => AssociateResourceErrorReason::IllegalCustomlineitem,
            "INTERNAL_SERVER_EXCEPTION" => AssociateResourceErrorReason::InternalServerException,
            "INVALID_ARN" => AssociateResourceErrorReason::InvalidArn,
            "SERVICE_LIMIT_EXCEEDED" => AssociateResourceErrorReason::ServiceLimitExceeded,
            other => AssociateResourceErrorReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssociateResourceErrorReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssociateResourceErrorReason::from(s))
    }
}
impl AssociateResourceErrorReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssociateResourceErrorReason::IllegalCustomlineitem => "ILLEGAL_CUSTOMLINEITEM",
            AssociateResourceErrorReason::InternalServerException => "INTERNAL_SERVER_EXCEPTION",
            AssociateResourceErrorReason::InvalidArn => "INVALID_ARN",
            AssociateResourceErrorReason::ServiceLimitExceeded => "SERVICE_LIMIT_EXCEEDED",
            AssociateResourceErrorReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ILLEGAL_CUSTOMLINEITEM",
            "INTERNAL_SERVER_EXCEPTION",
            "INVALID_ARN",
            "SERVICE_LIMIT_EXCEEDED",
        ]
    }
}
impl AsRef<str> for AssociateResourceErrorReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The billing period range in which the custom line item request will be applied. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomLineItemBillingPeriodRange {
    /// <p> The inclusive start billing period that defines a billing period range where a custom line is applied. </p>
    pub inclusive_start_billing_period: std::option::Option<std::string::String>,
    /// <p> The inclusive end billing period that defines a billing period range where a custom line is applied. </p>
    pub exclusive_end_billing_period: std::option::Option<std::string::String>,
}
impl CustomLineItemBillingPeriodRange {
    /// <p> The inclusive start billing period that defines a billing period range where a custom line is applied. </p>
    pub fn inclusive_start_billing_period(&self) -> std::option::Option<&str> {
        self.inclusive_start_billing_period.as_deref()
    }
    /// <p> The inclusive end billing period that defines a billing period range where a custom line is applied. </p>
    pub fn exclusive_end_billing_period(&self) -> std::option::Option<&str> {
        self.exclusive_end_billing_period.as_deref()
    }
}
impl std::fmt::Debug for CustomLineItemBillingPeriodRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomLineItemBillingPeriodRange");
        formatter.field(
            "inclusive_start_billing_period",
            &self.inclusive_start_billing_period,
        );
        formatter.field(
            "exclusive_end_billing_period",
            &self.exclusive_end_billing_period,
        );
        formatter.finish()
    }
}
/// See [`CustomLineItemBillingPeriodRange`](crate::model::CustomLineItemBillingPeriodRange)
pub mod custom_line_item_billing_period_range {
    /// A builder for [`CustomLineItemBillingPeriodRange`](crate::model::CustomLineItemBillingPeriodRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inclusive_start_billing_period: std::option::Option<std::string::String>,
        pub(crate) exclusive_end_billing_period: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The inclusive start billing period that defines a billing period range where a custom line is applied. </p>
        pub fn inclusive_start_billing_period(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inclusive_start_billing_period = Some(input.into());
            self
        }
        /// <p> The inclusive start billing period that defines a billing period range where a custom line is applied. </p>
        pub fn set_inclusive_start_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inclusive_start_billing_period = input;
            self
        }
        /// <p> The inclusive end billing period that defines a billing period range where a custom line is applied. </p>
        pub fn exclusive_end_billing_period(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.exclusive_end_billing_period = Some(input.into());
            self
        }
        /// <p> The inclusive end billing period that defines a billing period range where a custom line is applied. </p>
        pub fn set_exclusive_end_billing_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_end_billing_period = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomLineItemBillingPeriodRange`](crate::model::CustomLineItemBillingPeriodRange)
        pub fn build(self) -> crate::model::CustomLineItemBillingPeriodRange {
            crate::model::CustomLineItemBillingPeriodRange {
                inclusive_start_billing_period: self.inclusive_start_billing_period,
                exclusive_end_billing_period: self.exclusive_end_billing_period,
            }
        }
    }
}
impl CustomLineItemBillingPeriodRange {
    /// Creates a new builder-style object to manufacture [`CustomLineItemBillingPeriodRange`](crate::model::CustomLineItemBillingPeriodRange)
    pub fn builder() -> crate::model::custom_line_item_billing_period_range::Builder {
        crate::model::custom_line_item_billing_period_range::Builder::default()
    }
}

/// <p> A resource association result for a percentage custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResourceResponseElement {
    /// <p> The resource ARN that was associated to the custom line item. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> An <code>AssociateResourceError</code> that will populate if the resource association fails. </p>
    pub error: std::option::Option<crate::model::AssociateResourceError>,
}
impl AssociateResourceResponseElement {
    /// <p> The resource ARN that was associated to the custom line item. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> An <code>AssociateResourceError</code> that will populate if the resource association fails. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::AssociateResourceError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for AssociateResourceResponseElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResourceResponseElement");
        formatter.field("arn", &self.arn);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`AssociateResourceResponseElement`](crate::model::AssociateResourceResponseElement)
pub mod associate_resource_response_element {
    /// A builder for [`AssociateResourceResponseElement`](crate::model::AssociateResourceResponseElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::AssociateResourceError>,
    }
    impl Builder {
        /// <p> The resource ARN that was associated to the custom line item. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The resource ARN that was associated to the custom line item. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> An <code>AssociateResourceError</code> that will populate if the resource association fails. </p>
        pub fn error(mut self, input: crate::model::AssociateResourceError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p> An <code>AssociateResourceError</code> that will populate if the resource association fails. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::AssociateResourceError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResourceResponseElement`](crate::model::AssociateResourceResponseElement)
        pub fn build(self) -> crate::model::AssociateResourceResponseElement {
            crate::model::AssociateResourceResponseElement {
                arn: self.arn,
                error: self.error,
            }
        }
    }
}
impl AssociateResourceResponseElement {
    /// Creates a new builder-style object to manufacture [`AssociateResourceResponseElement`](crate::model::AssociateResourceResponseElement)
    pub fn builder() -> crate::model::associate_resource_response_element::Builder {
        crate::model::associate_resource_response_element::Builder::default()
    }
}

/// <p> A representation of a custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomLineItemListElement {
    /// <p> The Amazon Resource Names (ARNs) for custom line items. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The custom line item's name. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item. </p>
    pub charge_details: std::option::Option<crate::model::ListCustomLineItemChargeDetails>,
    /// <p> The custom line item's charge value currency. Only one of the valid values can be used. </p>
    pub currency_code: std::option::Option<crate::model::CurrencyCode>,
    /// <p> The custom line item's description. This is shown on the Bills page in association with the charge value. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The product code associated with the custom line item. </p>
    pub product_code: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
    pub billing_group_arn: std::option::Option<std::string::String>,
    /// <p> The time created. </p>
    pub creation_time: i64,
    /// <p> The most recent time the custom line item was modified. </p>
    pub last_modified_time: i64,
    /// <p> The number of resources that are associated to the custom line item. </p>
    pub association_size: i64,
}
impl CustomLineItemListElement {
    /// <p> The Amazon Resource Names (ARNs) for custom line items. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The custom line item's name. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item. </p>
    pub fn charge_details(
        &self,
    ) -> std::option::Option<&crate::model::ListCustomLineItemChargeDetails> {
        self.charge_details.as_ref()
    }
    /// <p> The custom line item's charge value currency. Only one of the valid values can be used. </p>
    pub fn currency_code(&self) -> std::option::Option<&crate::model::CurrencyCode> {
        self.currency_code.as_ref()
    }
    /// <p> The custom line item's description. This is shown on the Bills page in association with the charge value. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The product code associated with the custom line item. </p>
    pub fn product_code(&self) -> std::option::Option<&str> {
        self.product_code.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
    pub fn billing_group_arn(&self) -> std::option::Option<&str> {
        self.billing_group_arn.as_deref()
    }
    /// <p> The time created. </p>
    pub fn creation_time(&self) -> i64 {
        self.creation_time
    }
    /// <p> The most recent time the custom line item was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p> The number of resources that are associated to the custom line item. </p>
    pub fn association_size(&self) -> i64 {
        self.association_size
    }
}
impl std::fmt::Debug for CustomLineItemListElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomLineItemListElement");
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("charge_details", &self.charge_details);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("product_code", &self.product_code);
        formatter.field("billing_group_arn", &self.billing_group_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("association_size", &self.association_size);
        formatter.finish()
    }
}
/// See [`CustomLineItemListElement`](crate::model::CustomLineItemListElement)
pub mod custom_line_item_list_element {
    /// A builder for [`CustomLineItemListElement`](crate::model::CustomLineItemListElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) charge_details:
            std::option::Option<crate::model::ListCustomLineItemChargeDetails>,
        pub(crate) currency_code: std::option::Option<crate::model::CurrencyCode>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) billing_group_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) association_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> The Amazon Resource Names (ARNs) for custom line items. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Names (ARNs) for custom line items. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The custom line item's name. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The custom line item's name. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item. </p>
        pub fn charge_details(
            mut self,
            input: crate::model::ListCustomLineItemChargeDetails,
        ) -> Self {
            self.charge_details = Some(input);
            self
        }
        /// <p> A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item. </p>
        pub fn set_charge_details(
            mut self,
            input: std::option::Option<crate::model::ListCustomLineItemChargeDetails>,
        ) -> Self {
            self.charge_details = input;
            self
        }
        /// <p> The custom line item's charge value currency. Only one of the valid values can be used. </p>
        pub fn currency_code(mut self, input: crate::model::CurrencyCode) -> Self {
            self.currency_code = Some(input);
            self
        }
        /// <p> The custom line item's charge value currency. Only one of the valid values can be used. </p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<crate::model::CurrencyCode>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p> The custom line item's description. This is shown on the Bills page in association with the charge value. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The custom line item's description. This is shown on the Bills page in association with the charge value. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The product code associated with the custom line item. </p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p> The product code associated with the custom line item. </p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_arn = input;
            self
        }
        /// <p> The time created. </p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> The time created. </p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The most recent time the custom line item was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the custom line item was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p> The number of resources that are associated to the custom line item. </p>
        pub fn association_size(mut self, input: i64) -> Self {
            self.association_size = Some(input);
            self
        }
        /// <p> The number of resources that are associated to the custom line item. </p>
        pub fn set_association_size(mut self, input: std::option::Option<i64>) -> Self {
            self.association_size = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomLineItemListElement`](crate::model::CustomLineItemListElement)
        pub fn build(self) -> crate::model::CustomLineItemListElement {
            crate::model::CustomLineItemListElement {
                arn: self.arn,
                name: self.name,
                charge_details: self.charge_details,
                currency_code: self.currency_code,
                description: self.description,
                product_code: self.product_code,
                billing_group_arn: self.billing_group_arn,
                creation_time: self.creation_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                association_size: self.association_size.unwrap_or_default(),
            }
        }
    }
}
impl CustomLineItemListElement {
    /// Creates a new builder-style object to manufacture [`CustomLineItemListElement`](crate::model::CustomLineItemListElement)
    pub fn builder() -> crate::model::custom_line_item_list_element::Builder {
        crate::model::custom_line_item_list_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CurrencyCode {
    #[allow(missing_docs)] // documentation missing in model
    Cny,
    #[allow(missing_docs)] // documentation missing in model
    Usd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CurrencyCode {
    fn from(s: &str) -> Self {
        match s {
            "CNY" => CurrencyCode::Cny,
            "USD" => CurrencyCode::Usd,
            other => CurrencyCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CurrencyCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CurrencyCode::from(s))
    }
}
impl CurrencyCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CurrencyCode::Cny => "CNY",
            CurrencyCode::Usd => "USD",
            CurrencyCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CNY", "USD"]
    }
}
impl AsRef<str> for CurrencyCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A representation of the charge details of a custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomLineItemChargeDetails {
    /// <p> A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
    pub flat: std::option::Option<crate::model::ListCustomLineItemFlatChargeDetails>,
    /// <p> A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
    pub percentage: std::option::Option<crate::model::ListCustomLineItemPercentageChargeDetails>,
    /// <p> The type of the custom line item that indicates whether the charge is a <code>fee</code> or <code>credit</code>. </p>
    pub r#type: std::option::Option<crate::model::CustomLineItemType>,
}
impl ListCustomLineItemChargeDetails {
    /// <p> A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
    pub fn flat(&self) -> std::option::Option<&crate::model::ListCustomLineItemFlatChargeDetails> {
        self.flat.as_ref()
    }
    /// <p> A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
    pub fn percentage(
        &self,
    ) -> std::option::Option<&crate::model::ListCustomLineItemPercentageChargeDetails> {
        self.percentage.as_ref()
    }
    /// <p> The type of the custom line item that indicates whether the charge is a <code>fee</code> or <code>credit</code>. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CustomLineItemType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ListCustomLineItemChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomLineItemChargeDetails");
        formatter.field("flat", &self.flat);
        formatter.field("percentage", &self.percentage);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ListCustomLineItemChargeDetails`](crate::model::ListCustomLineItemChargeDetails)
pub mod list_custom_line_item_charge_details {
    /// A builder for [`ListCustomLineItemChargeDetails`](crate::model::ListCustomLineItemChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flat: std::option::Option<crate::model::ListCustomLineItemFlatChargeDetails>,
        pub(crate) percentage:
            std::option::Option<crate::model::ListCustomLineItemPercentageChargeDetails>,
        pub(crate) r#type: std::option::Option<crate::model::CustomLineItemType>,
    }
    impl Builder {
        /// <p> A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
        pub fn flat(mut self, input: crate::model::ListCustomLineItemFlatChargeDetails) -> Self {
            self.flat = Some(input);
            self
        }
        /// <p> A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
        pub fn set_flat(
            mut self,
            input: std::option::Option<crate::model::ListCustomLineItemFlatChargeDetails>,
        ) -> Self {
            self.flat = input;
            self
        }
        /// <p> A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
        pub fn percentage(
            mut self,
            input: crate::model::ListCustomLineItemPercentageChargeDetails,
        ) -> Self {
            self.percentage = Some(input);
            self
        }
        /// <p> A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
        pub fn set_percentage(
            mut self,
            input: std::option::Option<crate::model::ListCustomLineItemPercentageChargeDetails>,
        ) -> Self {
            self.percentage = input;
            self
        }
        /// <p> The type of the custom line item that indicates whether the charge is a <code>fee</code> or <code>credit</code>. </p>
        pub fn r#type(mut self, input: crate::model::CustomLineItemType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of the custom line item that indicates whether the charge is a <code>fee</code> or <code>credit</code>. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomLineItemChargeDetails`](crate::model::ListCustomLineItemChargeDetails)
        pub fn build(self) -> crate::model::ListCustomLineItemChargeDetails {
            crate::model::ListCustomLineItemChargeDetails {
                flat: self.flat,
                percentage: self.percentage,
                r#type: self.r#type,
            }
        }
    }
}
impl ListCustomLineItemChargeDetails {
    /// Creates a new builder-style object to manufacture [`ListCustomLineItemChargeDetails`](crate::model::ListCustomLineItemChargeDetails)
    pub fn builder() -> crate::model::list_custom_line_item_charge_details::Builder {
        crate::model::list_custom_line_item_charge_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomLineItemType {
    #[allow(missing_docs)] // documentation missing in model
    Credit,
    #[allow(missing_docs)] // documentation missing in model
    Fee,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomLineItemType {
    fn from(s: &str) -> Self {
        match s {
            "CREDIT" => CustomLineItemType::Credit,
            "FEE" => CustomLineItemType::Fee,
            other => CustomLineItemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomLineItemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomLineItemType::from(s))
    }
}
impl CustomLineItemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomLineItemType::Credit => "CREDIT",
            CustomLineItemType::Fee => "FEE",
            CustomLineItemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREDIT", "FEE"]
    }
}
impl AsRef<str> for CustomLineItemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A representation of the charge details associated with a percentage custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomLineItemPercentageChargeDetails {
    /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
    pub percentage_value: std::option::Option<f64>,
}
impl ListCustomLineItemPercentageChargeDetails {
    /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
    pub fn percentage_value(&self) -> std::option::Option<f64> {
        self.percentage_value
    }
}
impl std::fmt::Debug for ListCustomLineItemPercentageChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomLineItemPercentageChargeDetails");
        formatter.field("percentage_value", &self.percentage_value);
        formatter.finish()
    }
}
/// See [`ListCustomLineItemPercentageChargeDetails`](crate::model::ListCustomLineItemPercentageChargeDetails)
pub mod list_custom_line_item_percentage_charge_details {
    /// A builder for [`ListCustomLineItemPercentageChargeDetails`](crate::model::ListCustomLineItemPercentageChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percentage_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
        pub fn percentage_value(mut self, input: f64) -> Self {
            self.percentage_value = Some(input);
            self
        }
        /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
        pub fn set_percentage_value(mut self, input: std::option::Option<f64>) -> Self {
            self.percentage_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomLineItemPercentageChargeDetails`](crate::model::ListCustomLineItemPercentageChargeDetails)
        pub fn build(self) -> crate::model::ListCustomLineItemPercentageChargeDetails {
            crate::model::ListCustomLineItemPercentageChargeDetails {
                percentage_value: self.percentage_value,
            }
        }
    }
}
impl ListCustomLineItemPercentageChargeDetails {
    /// Creates a new builder-style object to manufacture [`ListCustomLineItemPercentageChargeDetails`](crate::model::ListCustomLineItemPercentageChargeDetails)
    pub fn builder() -> crate::model::list_custom_line_item_percentage_charge_details::Builder {
        crate::model::list_custom_line_item_percentage_charge_details::Builder::default()
    }
}

/// <p> A representation of the charge details associated with a flat custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomLineItemFlatChargeDetails {
    /// <p> The custom line item's fixed charge value in USD. </p>
    pub charge_value: std::option::Option<f64>,
}
impl ListCustomLineItemFlatChargeDetails {
    /// <p> The custom line item's fixed charge value in USD. </p>
    pub fn charge_value(&self) -> std::option::Option<f64> {
        self.charge_value
    }
}
impl std::fmt::Debug for ListCustomLineItemFlatChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomLineItemFlatChargeDetails");
        formatter.field("charge_value", &self.charge_value);
        formatter.finish()
    }
}
/// See [`ListCustomLineItemFlatChargeDetails`](crate::model::ListCustomLineItemFlatChargeDetails)
pub mod list_custom_line_item_flat_charge_details {
    /// A builder for [`ListCustomLineItemFlatChargeDetails`](crate::model::ListCustomLineItemFlatChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) charge_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The custom line item's fixed charge value in USD. </p>
        pub fn charge_value(mut self, input: f64) -> Self {
            self.charge_value = Some(input);
            self
        }
        /// <p> The custom line item's fixed charge value in USD. </p>
        pub fn set_charge_value(mut self, input: std::option::Option<f64>) -> Self {
            self.charge_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomLineItemFlatChargeDetails`](crate::model::ListCustomLineItemFlatChargeDetails)
        pub fn build(self) -> crate::model::ListCustomLineItemFlatChargeDetails {
            crate::model::ListCustomLineItemFlatChargeDetails {
                charge_value: self.charge_value,
            }
        }
    }
}
impl ListCustomLineItemFlatChargeDetails {
    /// Creates a new builder-style object to manufacture [`ListCustomLineItemFlatChargeDetails`](crate::model::ListCustomLineItemFlatChargeDetails)
    pub fn builder() -> crate::model::list_custom_line_item_flat_charge_details::Builder {
        crate::model::list_custom_line_item_flat_charge_details::Builder::default()
    }
}

/// <p> A filter that specifies the custom line items and billing groups to retrieve FFLI information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomLineItemsFilter {
    /// <p> A list of custom line items to retrieve information. </p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The billing group Amazon Resource Names (ARNs) to retrieve information. </p>
    pub billing_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A list of custom line item ARNs to retrieve information. </p>
    pub arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListCustomLineItemsFilter {
    /// <p> A list of custom line items to retrieve information. </p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p> The billing group Amazon Resource Names (ARNs) to retrieve information. </p>
    pub fn billing_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.billing_groups.as_deref()
    }
    /// <p> A list of custom line item ARNs to retrieve information. </p>
    pub fn arns(&self) -> std::option::Option<&[std::string::String]> {
        self.arns.as_deref()
    }
}
impl std::fmt::Debug for ListCustomLineItemsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomLineItemsFilter");
        formatter.field("names", &self.names);
        formatter.field("billing_groups", &self.billing_groups);
        formatter.field("arns", &self.arns);
        formatter.finish()
    }
}
/// See [`ListCustomLineItemsFilter`](crate::model::ListCustomLineItemsFilter)
pub mod list_custom_line_items_filter {
    /// A builder for [`ListCustomLineItemsFilter`](crate::model::ListCustomLineItemsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) billing_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p> A list of custom line items to retrieve information. </p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p> A list of custom line items to retrieve information. </p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// Appends an item to `billing_groups`.
        ///
        /// To override the contents of this collection use [`set_billing_groups`](Self::set_billing_groups).
        ///
        /// <p> The billing group Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn billing_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.billing_groups.unwrap_or_default();
            v.push(input.into());
            self.billing_groups = Some(v);
            self
        }
        /// <p> The billing group Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn set_billing_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.billing_groups = input;
            self
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p> A list of custom line item ARNs to retrieve information. </p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.arns.unwrap_or_default();
            v.push(input.into());
            self.arns = Some(v);
            self
        }
        /// <p> A list of custom line item ARNs to retrieve information. </p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomLineItemsFilter`](crate::model::ListCustomLineItemsFilter)
        pub fn build(self) -> crate::model::ListCustomLineItemsFilter {
            crate::model::ListCustomLineItemsFilter {
                names: self.names,
                billing_groups: self.billing_groups,
                arns: self.arns,
            }
        }
    }
}
impl ListCustomLineItemsFilter {
    /// Creates a new builder-style object to manufacture [`ListCustomLineItemsFilter`](crate::model::ListCustomLineItemsFilter)
    pub fn builder() -> crate::model::list_custom_line_items_filter::Builder {
        crate::model::list_custom_line_items_filter::Builder::default()
    }
}

/// <p> The charge details of a custom line item. It should contain only one of <code>Flat</code> or <code>Percentage</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomLineItemChargeDetails {
    /// <p> A <code>CustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
    pub flat: std::option::Option<crate::model::CustomLineItemFlatChargeDetails>,
    /// <p> A <code>CustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
    pub percentage: std::option::Option<crate::model::CustomLineItemPercentageChargeDetails>,
    /// <p> The type of the custom line item that indicates whether the charge is a fee or credit. </p>
    pub r#type: std::option::Option<crate::model::CustomLineItemType>,
}
impl CustomLineItemChargeDetails {
    /// <p> A <code>CustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
    pub fn flat(&self) -> std::option::Option<&crate::model::CustomLineItemFlatChargeDetails> {
        self.flat.as_ref()
    }
    /// <p> A <code>CustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
    pub fn percentage(
        &self,
    ) -> std::option::Option<&crate::model::CustomLineItemPercentageChargeDetails> {
        self.percentage.as_ref()
    }
    /// <p> The type of the custom line item that indicates whether the charge is a fee or credit. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CustomLineItemType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CustomLineItemChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomLineItemChargeDetails");
        formatter.field("flat", &self.flat);
        formatter.field("percentage", &self.percentage);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`CustomLineItemChargeDetails`](crate::model::CustomLineItemChargeDetails)
pub mod custom_line_item_charge_details {
    /// A builder for [`CustomLineItemChargeDetails`](crate::model::CustomLineItemChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flat: std::option::Option<crate::model::CustomLineItemFlatChargeDetails>,
        pub(crate) percentage:
            std::option::Option<crate::model::CustomLineItemPercentageChargeDetails>,
        pub(crate) r#type: std::option::Option<crate::model::CustomLineItemType>,
    }
    impl Builder {
        /// <p> A <code>CustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
        pub fn flat(mut self, input: crate::model::CustomLineItemFlatChargeDetails) -> Self {
            self.flat = Some(input);
            self
        }
        /// <p> A <code>CustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>
        pub fn set_flat(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemFlatChargeDetails>,
        ) -> Self {
            self.flat = input;
            self
        }
        /// <p> A <code>CustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
        pub fn percentage(
            mut self,
            input: crate::model::CustomLineItemPercentageChargeDetails,
        ) -> Self {
            self.percentage = Some(input);
            self
        }
        /// <p> A <code>CustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>
        pub fn set_percentage(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemPercentageChargeDetails>,
        ) -> Self {
            self.percentage = input;
            self
        }
        /// <p> The type of the custom line item that indicates whether the charge is a fee or credit. </p>
        pub fn r#type(mut self, input: crate::model::CustomLineItemType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of the custom line item that indicates whether the charge is a fee or credit. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CustomLineItemType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomLineItemChargeDetails`](crate::model::CustomLineItemChargeDetails)
        pub fn build(self) -> crate::model::CustomLineItemChargeDetails {
            crate::model::CustomLineItemChargeDetails {
                flat: self.flat,
                percentage: self.percentage,
                r#type: self.r#type,
            }
        }
    }
}
impl CustomLineItemChargeDetails {
    /// Creates a new builder-style object to manufacture [`CustomLineItemChargeDetails`](crate::model::CustomLineItemChargeDetails)
    pub fn builder() -> crate::model::custom_line_item_charge_details::Builder {
        crate::model::custom_line_item_charge_details::Builder::default()
    }
}

/// <p> A representation of the charge details associated with a percentage custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomLineItemPercentageChargeDetails {
    /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
    pub percentage_value: std::option::Option<f64>,
    /// <p> A list of resource ARNs to associate to the percentage custom line item. </p>
    pub associated_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CustomLineItemPercentageChargeDetails {
    /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
    pub fn percentage_value(&self) -> std::option::Option<f64> {
        self.percentage_value
    }
    /// <p> A list of resource ARNs to associate to the percentage custom line item. </p>
    pub fn associated_values(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_values.as_deref()
    }
}
impl std::fmt::Debug for CustomLineItemPercentageChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomLineItemPercentageChargeDetails");
        formatter.field("percentage_value", &self.percentage_value);
        formatter.field("associated_values", &self.associated_values);
        formatter.finish()
    }
}
/// See [`CustomLineItemPercentageChargeDetails`](crate::model::CustomLineItemPercentageChargeDetails)
pub mod custom_line_item_percentage_charge_details {
    /// A builder for [`CustomLineItemPercentageChargeDetails`](crate::model::CustomLineItemPercentageChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percentage_value: std::option::Option<f64>,
        pub(crate) associated_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
        pub fn percentage_value(mut self, input: f64) -> Self {
            self.percentage_value = Some(input);
            self
        }
        /// <p> The custom line item's percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
        pub fn set_percentage_value(mut self, input: std::option::Option<f64>) -> Self {
            self.percentage_value = input;
            self
        }
        /// Appends an item to `associated_values`.
        ///
        /// To override the contents of this collection use [`set_associated_values`](Self::set_associated_values).
        ///
        /// <p> A list of resource ARNs to associate to the percentage custom line item. </p>
        pub fn associated_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.associated_values.unwrap_or_default();
            v.push(input.into());
            self.associated_values = Some(v);
            self
        }
        /// <p> A list of resource ARNs to associate to the percentage custom line item. </p>
        pub fn set_associated_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_values = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomLineItemPercentageChargeDetails`](crate::model::CustomLineItemPercentageChargeDetails)
        pub fn build(self) -> crate::model::CustomLineItemPercentageChargeDetails {
            crate::model::CustomLineItemPercentageChargeDetails {
                percentage_value: self.percentage_value,
                associated_values: self.associated_values,
            }
        }
    }
}
impl CustomLineItemPercentageChargeDetails {
    /// Creates a new builder-style object to manufacture [`CustomLineItemPercentageChargeDetails`](crate::model::CustomLineItemPercentageChargeDetails)
    pub fn builder() -> crate::model::custom_line_item_percentage_charge_details::Builder {
        crate::model::custom_line_item_percentage_charge_details::Builder::default()
    }
}

/// <p> A representation of the charge details associated with a flat custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomLineItemFlatChargeDetails {
    /// <p> The custom line item's fixed charge value in USD. </p>
    pub charge_value: std::option::Option<f64>,
}
impl CustomLineItemFlatChargeDetails {
    /// <p> The custom line item's fixed charge value in USD. </p>
    pub fn charge_value(&self) -> std::option::Option<f64> {
        self.charge_value
    }
}
impl std::fmt::Debug for CustomLineItemFlatChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomLineItemFlatChargeDetails");
        formatter.field("charge_value", &self.charge_value);
        formatter.finish()
    }
}
/// See [`CustomLineItemFlatChargeDetails`](crate::model::CustomLineItemFlatChargeDetails)
pub mod custom_line_item_flat_charge_details {
    /// A builder for [`CustomLineItemFlatChargeDetails`](crate::model::CustomLineItemFlatChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) charge_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The custom line item's fixed charge value in USD. </p>
        pub fn charge_value(mut self, input: f64) -> Self {
            self.charge_value = Some(input);
            self
        }
        /// <p> The custom line item's fixed charge value in USD. </p>
        pub fn set_charge_value(mut self, input: std::option::Option<f64>) -> Self {
            self.charge_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomLineItemFlatChargeDetails`](crate::model::CustomLineItemFlatChargeDetails)
        pub fn build(self) -> crate::model::CustomLineItemFlatChargeDetails {
            crate::model::CustomLineItemFlatChargeDetails {
                charge_value: self.charge_value,
            }
        }
    }
}
impl CustomLineItemFlatChargeDetails {
    /// Creates a new builder-style object to manufacture [`CustomLineItemFlatChargeDetails`](crate::model::CustomLineItemFlatChargeDetails)
    pub fn builder() -> crate::model::custom_line_item_flat_charge_details::Builder {
        crate::model::custom_line_item_flat_charge_details::Builder::default()
    }
}

/// <p> A representation of the new charge details of a custom line item. This should contain only one of <code>Flat</code> or <code>Percentage</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomLineItemChargeDetails {
    /// <p> An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom line item. </p>
    pub flat: std::option::Option<crate::model::UpdateCustomLineItemFlatChargeDetails>,
    /// <p> An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a percentage custom line item. </p>
    pub percentage: std::option::Option<crate::model::UpdateCustomLineItemPercentageChargeDetails>,
}
impl UpdateCustomLineItemChargeDetails {
    /// <p> An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom line item. </p>
    pub fn flat(
        &self,
    ) -> std::option::Option<&crate::model::UpdateCustomLineItemFlatChargeDetails> {
        self.flat.as_ref()
    }
    /// <p> An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a percentage custom line item. </p>
    pub fn percentage(
        &self,
    ) -> std::option::Option<&crate::model::UpdateCustomLineItemPercentageChargeDetails> {
        self.percentage.as_ref()
    }
}
impl std::fmt::Debug for UpdateCustomLineItemChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomLineItemChargeDetails");
        formatter.field("flat", &self.flat);
        formatter.field("percentage", &self.percentage);
        formatter.finish()
    }
}
/// See [`UpdateCustomLineItemChargeDetails`](crate::model::UpdateCustomLineItemChargeDetails)
pub mod update_custom_line_item_charge_details {
    /// A builder for [`UpdateCustomLineItemChargeDetails`](crate::model::UpdateCustomLineItemChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flat: std::option::Option<crate::model::UpdateCustomLineItemFlatChargeDetails>,
        pub(crate) percentage:
            std::option::Option<crate::model::UpdateCustomLineItemPercentageChargeDetails>,
    }
    impl Builder {
        /// <p> An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom line item. </p>
        pub fn flat(mut self, input: crate::model::UpdateCustomLineItemFlatChargeDetails) -> Self {
            self.flat = Some(input);
            self
        }
        /// <p> An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom line item. </p>
        pub fn set_flat(
            mut self,
            input: std::option::Option<crate::model::UpdateCustomLineItemFlatChargeDetails>,
        ) -> Self {
            self.flat = input;
            self
        }
        /// <p> An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a percentage custom line item. </p>
        pub fn percentage(
            mut self,
            input: crate::model::UpdateCustomLineItemPercentageChargeDetails,
        ) -> Self {
            self.percentage = Some(input);
            self
        }
        /// <p> An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a percentage custom line item. </p>
        pub fn set_percentage(
            mut self,
            input: std::option::Option<crate::model::UpdateCustomLineItemPercentageChargeDetails>,
        ) -> Self {
            self.percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomLineItemChargeDetails`](crate::model::UpdateCustomLineItemChargeDetails)
        pub fn build(self) -> crate::model::UpdateCustomLineItemChargeDetails {
            crate::model::UpdateCustomLineItemChargeDetails {
                flat: self.flat,
                percentage: self.percentage,
            }
        }
    }
}
impl UpdateCustomLineItemChargeDetails {
    /// Creates a new builder-style object to manufacture [`UpdateCustomLineItemChargeDetails`](crate::model::UpdateCustomLineItemChargeDetails)
    pub fn builder() -> crate::model::update_custom_line_item_charge_details::Builder {
        crate::model::update_custom_line_item_charge_details::Builder::default()
    }
}

/// <p> A representation of the new charge details associated with a percentage custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomLineItemPercentageChargeDetails {
    /// <p> The custom line item's new percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
    pub percentage_value: std::option::Option<f64>,
}
impl UpdateCustomLineItemPercentageChargeDetails {
    /// <p> The custom line item's new percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
    pub fn percentage_value(&self) -> std::option::Option<f64> {
        self.percentage_value
    }
}
impl std::fmt::Debug for UpdateCustomLineItemPercentageChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomLineItemPercentageChargeDetails");
        formatter.field("percentage_value", &self.percentage_value);
        formatter.finish()
    }
}
/// See [`UpdateCustomLineItemPercentageChargeDetails`](crate::model::UpdateCustomLineItemPercentageChargeDetails)
pub mod update_custom_line_item_percentage_charge_details {
    /// A builder for [`UpdateCustomLineItemPercentageChargeDetails`](crate::model::UpdateCustomLineItemPercentageChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percentage_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The custom line item's new percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
        pub fn percentage_value(mut self, input: f64) -> Self {
            self.percentage_value = Some(input);
            self
        }
        /// <p> The custom line item's new percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>
        pub fn set_percentage_value(mut self, input: std::option::Option<f64>) -> Self {
            self.percentage_value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomLineItemPercentageChargeDetails`](crate::model::UpdateCustomLineItemPercentageChargeDetails)
        pub fn build(self) -> crate::model::UpdateCustomLineItemPercentageChargeDetails {
            crate::model::UpdateCustomLineItemPercentageChargeDetails {
                percentage_value: self.percentage_value,
            }
        }
    }
}
impl UpdateCustomLineItemPercentageChargeDetails {
    /// Creates a new builder-style object to manufacture [`UpdateCustomLineItemPercentageChargeDetails`](crate::model::UpdateCustomLineItemPercentageChargeDetails)
    pub fn builder() -> crate::model::update_custom_line_item_percentage_charge_details::Builder {
        crate::model::update_custom_line_item_percentage_charge_details::Builder::default()
    }
}

/// <p> A representation of the new charge details associated with a flat custom line item. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomLineItemFlatChargeDetails {
    /// <p> The custom line item's new fixed charge value in USD. </p>
    pub charge_value: std::option::Option<f64>,
}
impl UpdateCustomLineItemFlatChargeDetails {
    /// <p> The custom line item's new fixed charge value in USD. </p>
    pub fn charge_value(&self) -> std::option::Option<f64> {
        self.charge_value
    }
}
impl std::fmt::Debug for UpdateCustomLineItemFlatChargeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomLineItemFlatChargeDetails");
        formatter.field("charge_value", &self.charge_value);
        formatter.finish()
    }
}
/// See [`UpdateCustomLineItemFlatChargeDetails`](crate::model::UpdateCustomLineItemFlatChargeDetails)
pub mod update_custom_line_item_flat_charge_details {
    /// A builder for [`UpdateCustomLineItemFlatChargeDetails`](crate::model::UpdateCustomLineItemFlatChargeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) charge_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p> The custom line item's new fixed charge value in USD. </p>
        pub fn charge_value(mut self, input: f64) -> Self {
            self.charge_value = Some(input);
            self
        }
        /// <p> The custom line item's new fixed charge value in USD. </p>
        pub fn set_charge_value(mut self, input: std::option::Option<f64>) -> Self {
            self.charge_value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomLineItemFlatChargeDetails`](crate::model::UpdateCustomLineItemFlatChargeDetails)
        pub fn build(self) -> crate::model::UpdateCustomLineItemFlatChargeDetails {
            crate::model::UpdateCustomLineItemFlatChargeDetails {
                charge_value: self.charge_value,
            }
        }
    }
}
impl UpdateCustomLineItemFlatChargeDetails {
    /// Creates a new builder-style object to manufacture [`UpdateCustomLineItemFlatChargeDetails`](crate::model::UpdateCustomLineItemFlatChargeDetails)
    pub fn builder() -> crate::model::update_custom_line_item_flat_charge_details::Builder {
        crate::model::update_custom_line_item_flat_charge_details::Builder::default()
    }
}

/// <p>A representation of a billing group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BillingGroupListElement {
    /// <p>The billing group's name. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The billing group description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The account ID that serves as the main account in a billing group. </p>
    pub primary_account_id: std::option::Option<std::string::String>,
    /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    pub computation_preference: std::option::Option<crate::model::ComputationPreference>,
    /// <p>The number of accounts in the particular billing group. </p>
    pub size: i64,
    /// <p> The time the billing group was created. </p>
    pub creation_time: i64,
    /// <p> The most recent time the billing group was modified. </p>
    pub last_modified_time: i64,
    /// <p>The billing group status. Only one of the valid values can be used. </p>
    pub status: std::option::Option<crate::model::BillingGroupStatus>,
    /// <p>The reason why the billing group is in its current status. </p>
    pub status_reason: std::option::Option<std::string::String>,
}
impl BillingGroupListElement {
    /// <p>The billing group's name. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The billing group description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The account ID that serves as the main account in a billing group. </p>
    pub fn primary_account_id(&self) -> std::option::Option<&str> {
        self.primary_account_id.as_deref()
    }
    /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
    pub fn computation_preference(
        &self,
    ) -> std::option::Option<&crate::model::ComputationPreference> {
        self.computation_preference.as_ref()
    }
    /// <p>The number of accounts in the particular billing group. </p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p> The time the billing group was created. </p>
    pub fn creation_time(&self) -> i64 {
        self.creation_time
    }
    /// <p> The most recent time the billing group was modified. </p>
    pub fn last_modified_time(&self) -> i64 {
        self.last_modified_time
    }
    /// <p>The billing group status. Only one of the valid values can be used. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::BillingGroupStatus> {
        self.status.as_ref()
    }
    /// <p>The reason why the billing group is in its current status. </p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
}
impl std::fmt::Debug for BillingGroupListElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BillingGroupListElement");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("primary_account_id", &self.primary_account_id);
        formatter.field("computation_preference", &self.computation_preference);
        formatter.field("size", &self.size);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`BillingGroupListElement`](crate::model::BillingGroupListElement)
pub mod billing_group_list_element {
    /// A builder for [`BillingGroupListElement`](crate::model::BillingGroupListElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) primary_account_id: std::option::Option<std::string::String>,
        pub(crate) computation_preference: std::option::Option<crate::model::ComputationPreference>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) last_modified_time: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::BillingGroupStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The billing group's name. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The billing group's name. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The billing group description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The billing group description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The account ID that serves as the main account in a billing group. </p>
        pub fn primary_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_account_id = Some(input.into());
            self
        }
        /// <p>The account ID that serves as the main account in a billing group. </p>
        pub fn set_primary_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_account_id = input;
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn computation_preference(
            mut self,
            input: crate::model::ComputationPreference,
        ) -> Self {
            self.computation_preference = Some(input);
            self
        }
        /// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn set_computation_preference(
            mut self,
            input: std::option::Option<crate::model::ComputationPreference>,
        ) -> Self {
            self.computation_preference = input;
            self
        }
        /// <p>The number of accounts in the particular billing group. </p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The number of accounts in the particular billing group. </p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p> The time the billing group was created. </p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> The time the billing group was created. </p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The most recent time the billing group was modified. </p>
        pub fn last_modified_time(mut self, input: i64) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p> The most recent time the billing group was modified. </p>
        pub fn set_last_modified_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The billing group status. Only one of the valid values can be used. </p>
        pub fn status(mut self, input: crate::model::BillingGroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The billing group status. Only one of the valid values can be used. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BillingGroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason why the billing group is in its current status. </p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason why the billing group is in its current status. </p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`BillingGroupListElement`](crate::model::BillingGroupListElement)
        pub fn build(self) -> crate::model::BillingGroupListElement {
            crate::model::BillingGroupListElement {
                name: self.name,
                arn: self.arn,
                description: self.description,
                primary_account_id: self.primary_account_id,
                computation_preference: self.computation_preference,
                size: self.size.unwrap_or_default(),
                creation_time: self.creation_time.unwrap_or_default(),
                last_modified_time: self.last_modified_time.unwrap_or_default(),
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl BillingGroupListElement {
    /// Creates a new builder-style object to manufacture [`BillingGroupListElement`](crate::model::BillingGroupListElement)
    pub fn builder() -> crate::model::billing_group_list_element::Builder {
        crate::model::billing_group_list_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BillingGroupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    PrimaryAccountMissing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BillingGroupStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => BillingGroupStatus::Active,
            "PRIMARY_ACCOUNT_MISSING" => BillingGroupStatus::PrimaryAccountMissing,
            other => BillingGroupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BillingGroupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BillingGroupStatus::from(s))
    }
}
impl BillingGroupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BillingGroupStatus::Active => "ACTIVE",
            BillingGroupStatus::PrimaryAccountMissing => "PRIMARY_ACCOUNT_MISSING",
            BillingGroupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "PRIMARY_ACCOUNT_MISSING"]
    }
}
impl AsRef<str> for BillingGroupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComputationPreference {
    /// <p> The Amazon Resource Name (ARN) of the pricing plan used to compute the Amazon Web Services charges for a billing group. </p>
    pub pricing_plan_arn: std::option::Option<std::string::String>,
}
impl ComputationPreference {
    /// <p> The Amazon Resource Name (ARN) of the pricing plan used to compute the Amazon Web Services charges for a billing group. </p>
    pub fn pricing_plan_arn(&self) -> std::option::Option<&str> {
        self.pricing_plan_arn.as_deref()
    }
}
impl std::fmt::Debug for ComputationPreference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComputationPreference");
        formatter.field("pricing_plan_arn", &self.pricing_plan_arn);
        formatter.finish()
    }
}
/// See [`ComputationPreference`](crate::model::ComputationPreference)
pub mod computation_preference {
    /// A builder for [`ComputationPreference`](crate::model::ComputationPreference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pricing_plan_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the pricing plan used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn pricing_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the pricing plan used to compute the Amazon Web Services charges for a billing group. </p>
        pub fn set_pricing_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ComputationPreference`](crate::model::ComputationPreference)
        pub fn build(self) -> crate::model::ComputationPreference {
            crate::model::ComputationPreference {
                pricing_plan_arn: self.pricing_plan_arn,
            }
        }
    }
}
impl ComputationPreference {
    /// Creates a new builder-style object to manufacture [`ComputationPreference`](crate::model::ComputationPreference)
    pub fn builder() -> crate::model::computation_preference::Builder {
        crate::model::computation_preference::Builder::default()
    }
}

/// <p>The filter that specifies the billing groups and pricing plans to retrieve billing group information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBillingGroupsFilter {
    /// <p>The list of billing group Amazon Resource Names (ARNs) to retrieve information. </p>
    pub arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
    pub pricing_plan: std::option::Option<std::string::String>,
}
impl ListBillingGroupsFilter {
    /// <p>The list of billing group Amazon Resource Names (ARNs) to retrieve information. </p>
    pub fn arns(&self) -> std::option::Option<&[std::string::String]> {
        self.arns.as_deref()
    }
    /// <p>The pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
    pub fn pricing_plan(&self) -> std::option::Option<&str> {
        self.pricing_plan.as_deref()
    }
}
impl std::fmt::Debug for ListBillingGroupsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBillingGroupsFilter");
        formatter.field("arns", &self.arns);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.finish()
    }
}
/// See [`ListBillingGroupsFilter`](crate::model::ListBillingGroupsFilter)
pub mod list_billing_groups_filter {
    /// A builder for [`ListBillingGroupsFilter`](crate::model::ListBillingGroupsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) pricing_plan: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The list of billing group Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.arns.unwrap_or_default();
            v.push(input.into());
            self.arns = Some(v);
            self
        }
        /// <p>The list of billing group Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.arns = input;
            self
        }
        /// <p>The pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn pricing_plan(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan = Some(input.into());
            self
        }
        /// <p>The pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>
        pub fn set_pricing_plan(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pricing_plan = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBillingGroupsFilter`](crate::model::ListBillingGroupsFilter)
        pub fn build(self) -> crate::model::ListBillingGroupsFilter {
            crate::model::ListBillingGroupsFilter {
                arns: self.arns,
                pricing_plan: self.pricing_plan,
            }
        }
    }
}
impl ListBillingGroupsFilter {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupsFilter`](crate::model::ListBillingGroupsFilter)
    pub fn builder() -> crate::model::list_billing_groups_filter::Builder {
        crate::model::list_billing_groups_filter::Builder::default()
    }
}

/// <p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountGrouping {
    /// <p> The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family, and not associated with another billing group. </p>
    pub linked_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AccountGrouping {
    /// <p> The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family, and not associated with another billing group. </p>
    pub fn linked_account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.linked_account_ids.as_deref()
    }
}
impl std::fmt::Debug for AccountGrouping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountGrouping");
        formatter.field("linked_account_ids", &self.linked_account_ids);
        formatter.finish()
    }
}
/// See [`AccountGrouping`](crate::model::AccountGrouping)
pub mod account_grouping {
    /// A builder for [`AccountGrouping`](crate::model::AccountGrouping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) linked_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `linked_account_ids`.
        ///
        /// To override the contents of this collection use [`set_linked_account_ids`](Self::set_linked_account_ids).
        ///
        /// <p> The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family, and not associated with another billing group. </p>
        pub fn linked_account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.linked_account_ids.unwrap_or_default();
            v.push(input.into());
            self.linked_account_ids = Some(v);
            self
        }
        /// <p> The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family, and not associated with another billing group. </p>
        pub fn set_linked_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.linked_account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountGrouping`](crate::model::AccountGrouping)
        pub fn build(self) -> crate::model::AccountGrouping {
            crate::model::AccountGrouping {
                linked_account_ids: self.linked_account_ids,
            }
        }
    }
}
impl AccountGrouping {
    /// Creates a new builder-style object to manufacture [`AccountGrouping`](crate::model::AccountGrouping)
    pub fn builder() -> crate::model::account_grouping::Builder {
        crate::model::account_grouping::Builder::default()
    }
}

/// <p>A summary report of actual Amazon Web Services charges and calculated Amazon Web Services charges, based on the associated pricing plan of a billing group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BillingGroupCostReportElement {
    /// <p>The Amazon Resource Name (ARN) of a billing group. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The actual Amazon Web Services charges for the billing group. </p>
    pub aws_cost: std::option::Option<std::string::String>,
    /// <p>The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group. </p>
    pub proforma_cost: std::option::Option<std::string::String>,
    /// <p> The billing group margin. </p>
    pub margin: std::option::Option<std::string::String>,
    /// <p> The percentage of billing group margin. </p>
    pub margin_percentage: std::option::Option<std::string::String>,
    /// <p>The displayed currency. </p>
    pub currency: std::option::Option<std::string::String>,
}
impl BillingGroupCostReportElement {
    /// <p>The Amazon Resource Name (ARN) of a billing group. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The actual Amazon Web Services charges for the billing group. </p>
    pub fn aws_cost(&self) -> std::option::Option<&str> {
        self.aws_cost.as_deref()
    }
    /// <p>The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group. </p>
    pub fn proforma_cost(&self) -> std::option::Option<&str> {
        self.proforma_cost.as_deref()
    }
    /// <p> The billing group margin. </p>
    pub fn margin(&self) -> std::option::Option<&str> {
        self.margin.as_deref()
    }
    /// <p> The percentage of billing group margin. </p>
    pub fn margin_percentage(&self) -> std::option::Option<&str> {
        self.margin_percentage.as_deref()
    }
    /// <p>The displayed currency. </p>
    pub fn currency(&self) -> std::option::Option<&str> {
        self.currency.as_deref()
    }
}
impl std::fmt::Debug for BillingGroupCostReportElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BillingGroupCostReportElement");
        formatter.field("arn", &self.arn);
        formatter.field("aws_cost", &self.aws_cost);
        formatter.field("proforma_cost", &self.proforma_cost);
        formatter.field("margin", &self.margin);
        formatter.field("margin_percentage", &self.margin_percentage);
        formatter.field("currency", &self.currency);
        formatter.finish()
    }
}
/// See [`BillingGroupCostReportElement`](crate::model::BillingGroupCostReportElement)
pub mod billing_group_cost_report_element {
    /// A builder for [`BillingGroupCostReportElement`](crate::model::BillingGroupCostReportElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) aws_cost: std::option::Option<std::string::String>,
        pub(crate) proforma_cost: std::option::Option<std::string::String>,
        pub(crate) margin: std::option::Option<std::string::String>,
        pub(crate) margin_percentage: std::option::Option<std::string::String>,
        pub(crate) currency: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a billing group. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a billing group. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The actual Amazon Web Services charges for the billing group. </p>
        pub fn aws_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_cost = Some(input.into());
            self
        }
        /// <p>The actual Amazon Web Services charges for the billing group. </p>
        pub fn set_aws_cost(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_cost = input;
            self
        }
        /// <p>The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group. </p>
        pub fn proforma_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.proforma_cost = Some(input.into());
            self
        }
        /// <p>The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group. </p>
        pub fn set_proforma_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proforma_cost = input;
            self
        }
        /// <p> The billing group margin. </p>
        pub fn margin(mut self, input: impl Into<std::string::String>) -> Self {
            self.margin = Some(input.into());
            self
        }
        /// <p> The billing group margin. </p>
        pub fn set_margin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.margin = input;
            self
        }
        /// <p> The percentage of billing group margin. </p>
        pub fn margin_percentage(mut self, input: impl Into<std::string::String>) -> Self {
            self.margin_percentage = Some(input.into());
            self
        }
        /// <p> The percentage of billing group margin. </p>
        pub fn set_margin_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.margin_percentage = input;
            self
        }
        /// <p>The displayed currency. </p>
        pub fn currency(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency = Some(input.into());
            self
        }
        /// <p>The displayed currency. </p>
        pub fn set_currency(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.currency = input;
            self
        }
        /// Consumes the builder and constructs a [`BillingGroupCostReportElement`](crate::model::BillingGroupCostReportElement)
        pub fn build(self) -> crate::model::BillingGroupCostReportElement {
            crate::model::BillingGroupCostReportElement {
                arn: self.arn,
                aws_cost: self.aws_cost,
                proforma_cost: self.proforma_cost,
                margin: self.margin,
                margin_percentage: self.margin_percentage,
                currency: self.currency,
            }
        }
    }
}
impl BillingGroupCostReportElement {
    /// Creates a new builder-style object to manufacture [`BillingGroupCostReportElement`](crate::model::BillingGroupCostReportElement)
    pub fn builder() -> crate::model::billing_group_cost_report_element::Builder {
        crate::model::billing_group_cost_report_element::Builder::default()
    }
}

/// <p>The filter used to retrieve specific <code>BillingGroupCostReportElements</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBillingGroupCostReportsFilter {
    /// <p>The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports. </p>
    pub billing_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListBillingGroupCostReportsFilter {
    /// <p>The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports. </p>
    pub fn billing_group_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.billing_group_arns.as_deref()
    }
}
impl std::fmt::Debug for ListBillingGroupCostReportsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBillingGroupCostReportsFilter");
        formatter.field("billing_group_arns", &self.billing_group_arns);
        formatter.finish()
    }
}
/// See [`ListBillingGroupCostReportsFilter`](crate::model::ListBillingGroupCostReportsFilter)
pub mod list_billing_group_cost_reports_filter {
    /// A builder for [`ListBillingGroupCostReportsFilter`](crate::model::ListBillingGroupCostReportsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `billing_group_arns`.
        ///
        /// To override the contents of this collection use [`set_billing_group_arns`](Self::set_billing_group_arns).
        ///
        /// <p>The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports. </p>
        pub fn billing_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.billing_group_arns.unwrap_or_default();
            v.push(input.into());
            self.billing_group_arns = Some(v);
            self
        }
        /// <p>The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports. </p>
        pub fn set_billing_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.billing_group_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBillingGroupCostReportsFilter`](crate::model::ListBillingGroupCostReportsFilter)
        pub fn build(self) -> crate::model::ListBillingGroupCostReportsFilter {
            crate::model::ListBillingGroupCostReportsFilter {
                billing_group_arns: self.billing_group_arns,
            }
        }
    }
}
impl ListBillingGroupCostReportsFilter {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupCostReportsFilter`](crate::model::ListBillingGroupCostReportsFilter)
    pub fn builder() -> crate::model::list_billing_group_cost_reports_filter::Builder {
        crate::model::list_billing_group_cost_reports_filter::Builder::default()
    }
}

/// <p> <i> <b>Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web Services Billing Conductor is subject to the Beta Service Participation terms of the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i> </p>
/// <p> A representation of a linked account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAssociationsListElement {
    /// <p> The associating array of account IDs. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p> The Billing Group Arn that the linked account is associated to. </p>
    pub billing_group_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services account name. </p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services account email. </p>
    pub account_email: std::option::Option<std::string::String>,
}
impl AccountAssociationsListElement {
    /// <p> The associating array of account IDs. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p> The Billing Group Arn that the linked account is associated to. </p>
    pub fn billing_group_arn(&self) -> std::option::Option<&str> {
        self.billing_group_arn.as_deref()
    }
    /// <p> The Amazon Web Services account name. </p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p> The Amazon Web Services account email. </p>
    pub fn account_email(&self) -> std::option::Option<&str> {
        self.account_email.as_deref()
    }
}
impl std::fmt::Debug for AccountAssociationsListElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAssociationsListElement");
        formatter.field("account_id", &self.account_id);
        formatter.field("billing_group_arn", &self.billing_group_arn);
        formatter.field("account_name", &"*** Sensitive Data Redacted ***");
        formatter.field("account_email", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AccountAssociationsListElement`](crate::model::AccountAssociationsListElement)
pub mod account_associations_list_element {
    /// A builder for [`AccountAssociationsListElement`](crate::model::AccountAssociationsListElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) billing_group_arn: std::option::Option<std::string::String>,
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) account_email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The associating array of account IDs. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p> The associating array of account IDs. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p> The Billing Group Arn that the linked account is associated to. </p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_arn = Some(input.into());
            self
        }
        /// <p> The Billing Group Arn that the linked account is associated to. </p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_arn = input;
            self
        }
        /// <p> The Amazon Web Services account name. </p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account name. </p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p> The Amazon Web Services account email. </p>
        pub fn account_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_email = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account email. </p>
        pub fn set_account_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_email = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAssociationsListElement`](crate::model::AccountAssociationsListElement)
        pub fn build(self) -> crate::model::AccountAssociationsListElement {
            crate::model::AccountAssociationsListElement {
                account_id: self.account_id,
                billing_group_arn: self.billing_group_arn,
                account_name: self.account_name,
                account_email: self.account_email,
            }
        }
    }
}
impl AccountAssociationsListElement {
    /// Creates a new builder-style object to manufacture [`AccountAssociationsListElement`](crate::model::AccountAssociationsListElement)
    pub fn builder() -> crate::model::account_associations_list_element::Builder {
        crate::model::account_associations_list_element::Builder::default()
    }
}

/// <p>The filter on the account ID of the linked account, or any of the following:</p>
/// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
/// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
/// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountAssociationsFilter {
    /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
    /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
    /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn. </p>
    pub association: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services account ID to filter on. </p>
    pub account_id: std::option::Option<std::string::String>,
}
impl ListAccountAssociationsFilter {
    /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
    /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
    /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn. </p>
    pub fn association(&self) -> std::option::Option<&str> {
        self.association.as_deref()
    }
    /// <p> The Amazon Web Services account ID to filter on. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for ListAccountAssociationsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountAssociationsFilter");
        formatter.field("association", &self.association);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`ListAccountAssociationsFilter`](crate::model::ListAccountAssociationsFilter)
pub mod list_account_associations_filter {
    /// A builder for [`ListAccountAssociationsFilter`](crate::model::ListAccountAssociationsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
        /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
        /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn. </p>
        pub fn association(mut self, input: impl Into<std::string::String>) -> Self {
            self.association = Some(input.into());
            self
        }
        /// <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
        /// <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p>
        /// <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn. </p>
        pub fn set_association(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.association = input;
            self
        }
        /// <p> The Amazon Web Services account ID to filter on. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account ID to filter on. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAssociationsFilter`](crate::model::ListAccountAssociationsFilter)
        pub fn build(self) -> crate::model::ListAccountAssociationsFilter {
            crate::model::ListAccountAssociationsFilter {
                association: self.association,
                account_id: self.account_id,
            }
        }
    }
}
impl ListAccountAssociationsFilter {
    /// Creates a new builder-style object to manufacture [`ListAccountAssociationsFilter`](crate::model::ListAccountAssociationsFilter)
    pub fn builder() -> crate::model::list_account_associations_filter::Builder {
        crate::model::list_account_associations_filter::Builder::default()
    }
}
