// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelJobError {
    /// Kind of error that occurred.
    pub kind: CancelJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelJobErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelJobErrorKind::ClientException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ServerException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelJobError {
    fn code(&self) -> Option<&str> {
        CancelJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelJobError {
    /// Creates a new `CancelJobError`.
    pub fn new(kind: CancelJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ServerException(_))
    }
}
impl std::error::Error for CancelJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelJobErrorKind::ClientException(_inner) => Some(_inner),
            CancelJobErrorKind::ServerException(_inner) => Some(_inner),
            CancelJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateComputeEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateComputeEnvironmentError {
    /// Kind of error that occurred.
    pub kind: CreateComputeEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateComputeEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateComputeEnvironmentErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateComputeEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateComputeEnvironmentErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateComputeEnvironmentErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateComputeEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateComputeEnvironmentError {
    fn code(&self) -> Option<&str> {
        CreateComputeEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateComputeEnvironmentError {
    /// Creates a new `CreateComputeEnvironmentError`.
    pub fn new(kind: CreateComputeEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateComputeEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateComputeEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateComputeEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateComputeEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateComputeEnvironmentErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputeEnvironmentErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComputeEnvironmentErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComputeEnvironmentErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for CreateComputeEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateComputeEnvironmentErrorKind::ClientException(_inner) => Some(_inner),
            CreateComputeEnvironmentErrorKind::ServerException(_inner) => Some(_inner),
            CreateComputeEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJobQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobQueueError {
    /// Kind of error that occurred.
    pub kind: CreateJobQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJobQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobQueueErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobQueueErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateJobQueueErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateJobQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobQueueError {
    fn code(&self) -> Option<&str> {
        CreateJobQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobQueueError {
    /// Creates a new `CreateJobQueueError`.
    pub fn new(kind: CreateJobQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobQueueErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateJobQueueErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateJobQueueErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateJobQueueErrorKind::ServerException(_))
    }
}
impl std::error::Error for CreateJobQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobQueueErrorKind::ClientException(_inner) => Some(_inner),
            CreateJobQueueErrorKind::ServerException(_inner) => Some(_inner),
            CreateJobQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteComputeEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteComputeEnvironmentError {
    /// Kind of error that occurred.
    pub kind: DeleteComputeEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteComputeEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteComputeEnvironmentErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteComputeEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteComputeEnvironmentErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteComputeEnvironmentErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteComputeEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteComputeEnvironmentError {
    fn code(&self) -> Option<&str> {
        DeleteComputeEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteComputeEnvironmentError {
    /// Creates a new `DeleteComputeEnvironmentError`.
    pub fn new(kind: DeleteComputeEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteComputeEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteComputeEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteComputeEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteComputeEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteComputeEnvironmentErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComputeEnvironmentErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComputeEnvironmentErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComputeEnvironmentErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeleteComputeEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteComputeEnvironmentErrorKind::ClientException(_inner) => Some(_inner),
            DeleteComputeEnvironmentErrorKind::ServerException(_inner) => Some(_inner),
            DeleteComputeEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJobQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobQueueError {
    /// Kind of error that occurred.
    pub kind: DeleteJobQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJobQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobQueueErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobQueueErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteJobQueueErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteJobQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobQueueError {
    fn code(&self) -> Option<&str> {
        DeleteJobQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobQueueError {
    /// Creates a new `DeleteJobQueueError`.
    pub fn new(kind: DeleteJobQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobQueueErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobQueueErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobQueueErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobQueueErrorKind::ServerException(_))
    }
}
impl std::error::Error for DeleteJobQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobQueueErrorKind::ClientException(_inner) => Some(_inner),
            DeleteJobQueueErrorKind::ServerException(_inner) => Some(_inner),
            DeleteJobQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterJobDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterJobDefinitionError {
    /// Kind of error that occurred.
    pub kind: DeregisterJobDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterJobDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterJobDefinitionErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterJobDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterJobDefinitionErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeregisterJobDefinitionErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeregisterJobDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterJobDefinitionError {
    fn code(&self) -> Option<&str> {
        DeregisterJobDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterJobDefinitionError {
    /// Creates a new `DeregisterJobDefinitionError`.
    pub fn new(kind: DeregisterJobDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterJobDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterJobDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterJobDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterJobDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterJobDefinitionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterJobDefinitionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterJobDefinitionErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterJobDefinitionErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeregisterJobDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterJobDefinitionErrorKind::ClientException(_inner) => Some(_inner),
            DeregisterJobDefinitionErrorKind::ServerException(_inner) => Some(_inner),
            DeregisterJobDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeComputeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeComputeEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: DescribeComputeEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeComputeEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeComputeEnvironmentsErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeComputeEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeComputeEnvironmentsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeComputeEnvironmentsErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeComputeEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeComputeEnvironmentsError {
    fn code(&self) -> Option<&str> {
        DescribeComputeEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeComputeEnvironmentsError {
    /// Creates a new `DescribeComputeEnvironmentsError`.
    pub fn new(kind: DescribeComputeEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeComputeEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeComputeEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeComputeEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeComputeEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeComputeEnvironmentsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComputeEnvironmentsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComputeEnvironmentsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComputeEnvironmentsErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeComputeEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeComputeEnvironmentsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeComputeEnvironmentsErrorKind::ServerException(_inner) => Some(_inner),
            DescribeComputeEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobDefinitionsError {
    /// Kind of error that occurred.
    pub kind: DescribeJobDefinitionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobDefinitionsErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobDefinitionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobDefinitionsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeJobDefinitionsErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeJobDefinitionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobDefinitionsError {
    fn code(&self) -> Option<&str> {
        DescribeJobDefinitionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobDefinitionsError {
    /// Creates a new `DescribeJobDefinitionsError`.
    pub fn new(kind: DescribeJobDefinitionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobDefinitionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobDefinitionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobDefinitionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobDefinitionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobDefinitionsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobDefinitionsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobDefinitionsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobDefinitionsErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeJobDefinitionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobDefinitionsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeJobDefinitionsErrorKind::ServerException(_inner) => Some(_inner),
            DescribeJobDefinitionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobQueuesError {
    /// Kind of error that occurred.
    pub kind: DescribeJobQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobQueuesErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobQueuesErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeJobQueuesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeJobQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobQueuesError {
    fn code(&self) -> Option<&str> {
        DescribeJobQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobQueuesError {
    /// Creates a new `DescribeJobQueuesError`.
    pub fn new(kind: DescribeJobQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobQueuesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobQueuesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeJobQueuesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobQueuesErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeJobQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobQueuesErrorKind::ClientException(_inner) => Some(_inner),
            DescribeJobQueuesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeJobQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobsError {
    /// Kind of error that occurred.
    pub kind: DescribeJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobsErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobsError {
    fn code(&self) -> Option<&str> {
        DescribeJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobsError {
    /// Creates a new `DescribeJobsError`.
    pub fn new(kind: DescribeJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeJobsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobsErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeJobsErrorKind::ServerException(_inner) => Some(_inner),
            DescribeJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::ClientException(_inner) => Some(_inner),
            ListJobsErrorKind::ServerException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ClientException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterJobDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterJobDefinitionError {
    /// Kind of error that occurred.
    pub kind: RegisterJobDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterJobDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterJobDefinitionErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterJobDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterJobDefinitionErrorKind::ClientException(_inner) => _inner.fmt(f),
            RegisterJobDefinitionErrorKind::ServerException(_inner) => _inner.fmt(f),
            RegisterJobDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterJobDefinitionError {
    fn code(&self) -> Option<&str> {
        RegisterJobDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterJobDefinitionError {
    /// Creates a new `RegisterJobDefinitionError`.
    pub fn new(kind: RegisterJobDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterJobDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterJobDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterJobDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterJobDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterJobDefinitionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterJobDefinitionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterJobDefinitionErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterJobDefinitionErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for RegisterJobDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterJobDefinitionErrorKind::ClientException(_inner) => Some(_inner),
            RegisterJobDefinitionErrorKind::ServerException(_inner) => Some(_inner),
            RegisterJobDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SubmitJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubmitJobError {
    /// Kind of error that occurred.
    pub kind: SubmitJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SubmitJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubmitJobErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubmitJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubmitJobErrorKind::ClientException(_inner) => _inner.fmt(f),
            SubmitJobErrorKind::ServerException(_inner) => _inner.fmt(f),
            SubmitJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubmitJobError {
    fn code(&self) -> Option<&str> {
        SubmitJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SubmitJobError {
    /// Creates a new `SubmitJobError`.
    pub fn new(kind: SubmitJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubmitJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubmitJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubmitJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubmitJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SubmitJobErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, SubmitJobErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `SubmitJobErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, SubmitJobErrorKind::ServerException(_))
    }
}
impl std::error::Error for SubmitJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubmitJobErrorKind::ClientException(_inner) => Some(_inner),
            SubmitJobErrorKind::ServerException(_inner) => Some(_inner),
            SubmitJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ClientException(_inner) => Some(_inner),
            TagResourceErrorKind::ServerException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateJobError {
    /// Kind of error that occurred.
    pub kind: TerminateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateJobErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateJobErrorKind::ClientException(_inner) => _inner.fmt(f),
            TerminateJobErrorKind::ServerException(_inner) => _inner.fmt(f),
            TerminateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateJobError {
    fn code(&self) -> Option<&str> {
        TerminateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateJobError {
    /// Creates a new `TerminateJobError`.
    pub fn new(kind: TerminateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TerminateJobErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, TerminateJobErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `TerminateJobErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, TerminateJobErrorKind::ServerException(_))
    }
}
impl std::error::Error for TerminateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateJobErrorKind::ClientException(_inner) => Some(_inner),
            TerminateJobErrorKind::ServerException(_inner) => Some(_inner),
            TerminateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ClientException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateComputeEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateComputeEnvironmentError {
    /// Kind of error that occurred.
    pub kind: UpdateComputeEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateComputeEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateComputeEnvironmentErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateComputeEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateComputeEnvironmentErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateComputeEnvironmentErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateComputeEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateComputeEnvironmentError {
    fn code(&self) -> Option<&str> {
        UpdateComputeEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateComputeEnvironmentError {
    /// Creates a new `UpdateComputeEnvironmentError`.
    pub fn new(kind: UpdateComputeEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateComputeEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateComputeEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateComputeEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateComputeEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateComputeEnvironmentErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComputeEnvironmentErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComputeEnvironmentErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComputeEnvironmentErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for UpdateComputeEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateComputeEnvironmentErrorKind::ClientException(_inner) => Some(_inner),
            UpdateComputeEnvironmentErrorKind::ServerException(_inner) => Some(_inner),
            UpdateComputeEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJobQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJobQueueError {
    /// Kind of error that occurred.
    pub kind: UpdateJobQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJobQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJobQueueErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
    /// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJobQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJobQueueErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateJobQueueErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateJobQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJobQueueError {
    fn code(&self) -> Option<&str> {
        UpdateJobQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJobQueueError {
    /// Creates a new `UpdateJobQueueError`.
    pub fn new(kind: UpdateJobQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJobQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJobQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJobQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJobQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJobQueueErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobQueueErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobQueueErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobQueueErrorKind::ServerException(_))
    }
}
impl std::error::Error for UpdateJobQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJobQueueErrorKind::ClientException(_inner) => Some(_inner),
            UpdateJobQueueErrorKind::ServerException(_inner) => Some(_inner),
            UpdateJobQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>These errors are usually caused by a server issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerException {}
/// See [`ServerException`](crate::error::ServerException)
pub mod server_exception {
    /// A builder for [`ServerException`](crate::error::ServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerException`](crate::error::ServerException)
        pub fn build(self) -> crate::error::ServerException {
            crate::error::ServerException {
                message: self.message,
            }
        }
    }
}
impl ServerException {
    /// Creates a new builder-style object to manufacture [`ServerException`](crate::error::ServerException)
    pub fn builder() -> crate::error::server_exception::Builder {
        crate::error::server_exception::Builder::default()
    }
}

/// <p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that
/// doesn't have permissions to use the action or resource, or specifying an identifier that's not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClientException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClientException {}
/// See [`ClientException`](crate::error::ClientException)
pub mod client_exception {
    /// A builder for [`ClientException`](crate::error::ClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientException`](crate::error::ClientException)
        pub fn build(self) -> crate::error::ClientException {
            crate::error::ClientException {
                message: self.message,
            }
        }
    }
}
impl ClientException {
    /// Creates a new builder-style object to manufacture [`ClientException`](crate::error::ClientException)
    pub fn builder() -> crate::error::client_exception::Builder {
        crate::error::client_exception::Builder::default()
    }
}
