// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelJobOutput, crate::error::CancelJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CancelJobError {
                meta: generic,
                kind: crate::error::CancelJobErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::CancelJobError {
                meta: generic,
                kind: crate::error::CancelJobErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CancelJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelJobOutput, crate::error::CancelJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_compute_environment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateComputeEnvironmentOutput,
    crate::error::CreateComputeEnvironmentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateComputeEnvironmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateComputeEnvironmentError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateComputeEnvironmentError {
                meta: generic,
                kind: crate::error::CreateComputeEnvironmentErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputeEnvironmentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::CreateComputeEnvironmentError {
                meta: generic,
                kind: crate::error::CreateComputeEnvironmentErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateComputeEnvironmentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateComputeEnvironmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_compute_environment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateComputeEnvironmentOutput,
    crate::error::CreateComputeEnvironmentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_compute_environment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_compute_environment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateComputeEnvironmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_job_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateJobQueueOutput, crate::error::CreateJobQueueError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateJobQueueError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateJobQueueError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateJobQueueError {
                meta: generic,
                kind: crate::error::CreateJobQueueErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateJobQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::CreateJobQueueError {
                meta: generic,
                kind: crate::error::CreateJobQueueErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateJobQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateJobQueueError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_job_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateJobQueueOutput, crate::error::CreateJobQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_job_queue_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_job_queue(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateJobQueueError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_compute_environment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteComputeEnvironmentOutput,
    crate::error::DeleteComputeEnvironmentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteComputeEnvironmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteComputeEnvironmentError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteComputeEnvironmentError {
                meta: generic,
                kind: crate::error::DeleteComputeEnvironmentErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteComputeEnvironmentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DeleteComputeEnvironmentError {
                meta: generic,
                kind: crate::error::DeleteComputeEnvironmentErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteComputeEnvironmentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteComputeEnvironmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_compute_environment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteComputeEnvironmentOutput,
    crate::error::DeleteComputeEnvironmentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_compute_environment_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_job_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteJobQueueOutput, crate::error::DeleteJobQueueError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteJobQueueError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteJobQueueError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteJobQueueError {
                meta: generic,
                kind: crate::error::DeleteJobQueueErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteJobQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DeleteJobQueueError {
                meta: generic,
                kind: crate::error::DeleteJobQueueErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteJobQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteJobQueueError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_job_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteJobQueueOutput, crate::error::DeleteJobQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_job_queue_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterJobDefinitionOutput,
    crate::error::DeregisterJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeregisterJobDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeregisterJobDefinitionError {
                meta: generic,
                kind: crate::error::DeregisterJobDefinitionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DeregisterJobDefinitionError {
                meta: generic,
                kind: crate::error::DeregisterJobDefinitionErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeregisterJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterJobDefinitionOutput,
    crate::error::DeregisterJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_job_definition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_compute_environments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeComputeEnvironmentsOutput,
    crate::error::DescribeComputeEnvironmentsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeComputeEnvironmentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeComputeEnvironmentsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeComputeEnvironmentsError {
                meta: generic,
                kind: crate::error::DescribeComputeEnvironmentsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeComputeEnvironmentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DescribeComputeEnvironmentsError {
                meta: generic,
                kind: crate::error::DescribeComputeEnvironmentsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeComputeEnvironmentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeComputeEnvironmentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_compute_environments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeComputeEnvironmentsOutput,
    crate::error::DescribeComputeEnvironmentsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_compute_environments_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_compute_environments(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeComputeEnvironmentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeJobDefinitionsOutput,
    crate::error::DescribeJobDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeJobDefinitionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeJobDefinitionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeJobDefinitionsError {
                meta: generic,
                kind: crate::error::DescribeJobDefinitionsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobDefinitionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DescribeJobDefinitionsError {
                meta: generic,
                kind: crate::error::DescribeJobDefinitionsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobDefinitionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeJobDefinitionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeJobDefinitionsOutput,
    crate::error::DescribeJobDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_job_definitions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_job_definitions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeJobDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_queues_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobQueuesOutput, crate::error::DescribeJobQueuesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeJobQueuesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeJobQueuesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeJobQueuesError {
                meta: generic,
                kind: crate::error::DescribeJobQueuesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobQueuesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DescribeJobQueuesError {
                meta: generic,
                kind: crate::error::DescribeJobQueuesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobQueuesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeJobQueuesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_queues_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobQueuesOutput, crate::error::DescribeJobQueuesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_job_queues_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_job_queues(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeJobQueuesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobsOutput, crate::error::DescribeJobsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeJobsError {
                meta: generic,
                kind: crate::error::DescribeJobsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DescribeJobsError {
                meta: generic,
                kind: crate::error::DescribeJobsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobsOutput, crate::error::DescribeJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListJobsError {
                meta: generic,
                kind: crate::error::ListJobsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::ListJobsError {
                meta: generic,
                kind: crate::error::ListJobsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterJobDefinitionOutput,
    crate::error::RegisterJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterJobDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RegisterJobDefinitionError {
                meta: generic,
                kind: crate::error::RegisterJobDefinitionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::RegisterJobDefinitionError {
                meta: generic,
                kind: crate::error::RegisterJobDefinitionErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RegisterJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterJobDefinitionOutput,
    crate::error::RegisterJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_job_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_job_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SubmitJobOutput, crate::error::SubmitJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SubmitJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SubmitJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::SubmitJobError {
                meta: generic,
                kind: crate::error::SubmitJobErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::SubmitJobError {
                meta: generic,
                kind: crate::error::SubmitJobErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SubmitJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SubmitJobOutput, crate::error::SubmitJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::submit_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_submit_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SubmitJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TerminateJobOutput, crate::error::TerminateJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TerminateJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TerminateJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::TerminateJobError {
                meta: generic,
                kind: crate::error::TerminateJobErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TerminateJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::TerminateJobError {
                meta: generic,
                kind: crate::error::TerminateJobErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TerminateJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::TerminateJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TerminateJobOutput, crate::error::TerminateJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::terminate_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_compute_environment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateComputeEnvironmentOutput,
    crate::error::UpdateComputeEnvironmentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateComputeEnvironmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateComputeEnvironmentError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateComputeEnvironmentError {
                meta: generic,
                kind: crate::error::UpdateComputeEnvironmentErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateComputeEnvironmentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::UpdateComputeEnvironmentError {
                meta: generic,
                kind: crate::error::UpdateComputeEnvironmentErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateComputeEnvironmentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateComputeEnvironmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_compute_environment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateComputeEnvironmentOutput,
    crate::error::UpdateComputeEnvironmentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_compute_environment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_compute_environment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateComputeEnvironmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobQueueOutput, crate::error::UpdateJobQueueError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateJobQueueError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateJobQueueError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateJobQueueError {
                meta: generic,
                kind: crate::error::UpdateJobQueueErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::UpdateJobQueueError {
                meta: generic,
                kind: crate::error::UpdateJobQueueErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateJobQueueError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobQueueOutput, crate::error::UpdateJobQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_job_queue_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_job_queue(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateJobQueueError::unhandled)?;
        output.build()
    })
}
