// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the hypervisor's permissions to which the gateway will connect.</p>
/// <p>A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hypervisor {
    /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the hypervisor.</p>
    pub hypervisor_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The name of the hypervisor.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the hypervisor.</p>
    pub state: std::option::Option<crate::model::HypervisorState>,
}
impl Hypervisor {
    /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the hypervisor.</p>
    pub fn hypervisor_arn(&self) -> std::option::Option<&str> {
        self.hypervisor_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The name of the hypervisor.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The state of the hypervisor.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::HypervisorState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for Hypervisor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hypervisor");
        formatter.field("host", &self.host);
        formatter.field("hypervisor_arn", &self.hypervisor_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`Hypervisor`](crate::model::Hypervisor)
pub mod hypervisor {
    /// A builder for [`Hypervisor`](crate::model::Hypervisor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) hypervisor_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::HypervisorState>,
    }
    impl Builder {
        /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor.</p>
        pub fn hypervisor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hypervisor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor.</p>
        pub fn set_hypervisor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hypervisor_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The name of the hypervisor.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hypervisor.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the hypervisor.</p>
        pub fn state(mut self, input: crate::model::HypervisorState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the hypervisor.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::HypervisorState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`Hypervisor`](crate::model::Hypervisor)
        pub fn build(self) -> crate::model::Hypervisor {
            crate::model::Hypervisor {
                host: self.host,
                hypervisor_arn: self.hypervisor_arn,
                kms_key_arn: self.kms_key_arn,
                name: self.name,
                state: self.state,
            }
        }
    }
}
impl Hypervisor {
    /// Creates a new builder-style object to manufacture [`Hypervisor`](crate::model::Hypervisor)
    pub fn builder() -> crate::model::hypervisor::Builder {
        crate::model::hypervisor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HypervisorState {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Offline,
    #[allow(missing_docs)] // documentation missing in model
    Online,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HypervisorState {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => HypervisorState::Error,
            "OFFLINE" => HypervisorState::Offline,
            "ONLINE" => HypervisorState::Online,
            "PENDING" => HypervisorState::Pending,
            other => HypervisorState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HypervisorState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HypervisorState::from(s))
    }
}
impl HypervisorState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HypervisorState::Error => "ERROR",
            HypervisorState::Offline => "OFFLINE",
            HypervisorState::Online => "ONLINE",
            HypervisorState::Pending => "PENDING",
            HypervisorState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "OFFLINE", "ONLINE", "PENDING"]
    }
}
impl AsRef<str> for HypervisorState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - = . _ : /.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key part of a tag's key-value pair. The key can't start with <code>aws:</code>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The key part of a value's key-value pair.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key part of a tag's key-value pair. The key can't start with <code>aws:</code>.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The key part of a value's key-value pair.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key part of a tag's key-value pair. The key can't start with <code>aws:</code>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key part of a tag's key-value pair. The key can't start with <code>aws:</code>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The key part of a value's key-value pair.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The key part of a value's key-value pair.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A gateway is an Backup Gateway appliance that runs on the customer's network to provide seamless connectivity to backup storage in the Amazon Web Services Cloud.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Gateway {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The display name of the gateway.</p>
    pub gateway_display_name: std::option::Option<std::string::String>,
    /// <p>The type of the gateway.</p>
    pub gateway_type: std::option::Option<crate::model::GatewayType>,
    /// <p>The hypervisor ID of the gateway.</p>
    pub hypervisor_id: std::option::Option<std::string::String>,
    /// <p>The last time Backup gateway communicated with the gateway, in Unix format and UTC time.</p>
    pub last_seen_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Gateway {
    /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The display name of the gateway.</p>
    pub fn gateway_display_name(&self) -> std::option::Option<&str> {
        self.gateway_display_name.as_deref()
    }
    /// <p>The type of the gateway.</p>
    pub fn gateway_type(&self) -> std::option::Option<&crate::model::GatewayType> {
        self.gateway_type.as_ref()
    }
    /// <p>The hypervisor ID of the gateway.</p>
    pub fn hypervisor_id(&self) -> std::option::Option<&str> {
        self.hypervisor_id.as_deref()
    }
    /// <p>The last time Backup gateway communicated with the gateway, in Unix format and UTC time.</p>
    pub fn last_seen_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_seen_time.as_ref()
    }
}
impl std::fmt::Debug for Gateway {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Gateway");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("gateway_display_name", &self.gateway_display_name);
        formatter.field("gateway_type", &self.gateway_type);
        formatter.field("hypervisor_id", &self.hypervisor_id);
        formatter.field("last_seen_time", &self.last_seen_time);
        formatter.finish()
    }
}
/// See [`Gateway`](crate::model::Gateway)
pub mod gateway {
    /// A builder for [`Gateway`](crate::model::Gateway)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_display_name: std::option::Option<std::string::String>,
        pub(crate) gateway_type: std::option::Option<crate::model::GatewayType>,
        pub(crate) hypervisor_id: std::option::Option<std::string::String>,
        pub(crate) last_seen_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The display name of the gateway.</p>
        pub fn gateway_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_display_name = Some(input.into());
            self
        }
        /// <p>The display name of the gateway.</p>
        pub fn set_gateway_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_display_name = input;
            self
        }
        /// <p>The type of the gateway.</p>
        pub fn gateway_type(mut self, input: crate::model::GatewayType) -> Self {
            self.gateway_type = Some(input);
            self
        }
        /// <p>The type of the gateway.</p>
        pub fn set_gateway_type(
            mut self,
            input: std::option::Option<crate::model::GatewayType>,
        ) -> Self {
            self.gateway_type = input;
            self
        }
        /// <p>The hypervisor ID of the gateway.</p>
        pub fn hypervisor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hypervisor_id = Some(input.into());
            self
        }
        /// <p>The hypervisor ID of the gateway.</p>
        pub fn set_hypervisor_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hypervisor_id = input;
            self
        }
        /// <p>The last time Backup gateway communicated with the gateway, in Unix format and UTC time.</p>
        pub fn last_seen_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_seen_time = Some(input);
            self
        }
        /// <p>The last time Backup gateway communicated with the gateway, in Unix format and UTC time.</p>
        pub fn set_last_seen_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_seen_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Gateway`](crate::model::Gateway)
        pub fn build(self) -> crate::model::Gateway {
            crate::model::Gateway {
                gateway_arn: self.gateway_arn,
                gateway_display_name: self.gateway_display_name,
                gateway_type: self.gateway_type,
                hypervisor_id: self.hypervisor_id,
                last_seen_time: self.last_seen_time,
            }
        }
    }
}
impl Gateway {
    /// Creates a new builder-style object to manufacture [`Gateway`](crate::model::Gateway)
    pub fn builder() -> crate::model::gateway::Builder {
        crate::model::gateway::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GatewayType {
    #[allow(missing_docs)] // documentation missing in model
    BackupVm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GatewayType {
    fn from(s: &str) -> Self {
        match s {
            "BACKUP_VM" => GatewayType::BackupVm,
            other => GatewayType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GatewayType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GatewayType::from(s))
    }
}
impl GatewayType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GatewayType::BackupVm => "BACKUP_VM",
            GatewayType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BACKUP_VM"]
    }
}
impl AsRef<str> for GatewayType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A virtual machine that is on a hypervisor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualMachine {
    /// <p>The host name of the virtual machine.</p>
    pub host_name: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual machine's hypervisor.</p>
    pub hypervisor_id: std::option::Option<std::string::String>,
    /// <p>The name of the virtual machine.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The path of the virtual machine.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the virtual machine.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The most recent date a virtual machine was backed up, in Unix format and UTC time.</p>
    pub last_backup_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl VirtualMachine {
    /// <p>The host name of the virtual machine.</p>
    pub fn host_name(&self) -> std::option::Option<&str> {
        self.host_name.as_deref()
    }
    /// <p>The ID of the virtual machine's hypervisor.</p>
    pub fn hypervisor_id(&self) -> std::option::Option<&str> {
        self.hypervisor_id.as_deref()
    }
    /// <p>The name of the virtual machine.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The path of the virtual machine.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the virtual machine.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The most recent date a virtual machine was backed up, in Unix format and UTC time.</p>
    pub fn last_backup_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_backup_date.as_ref()
    }
}
impl std::fmt::Debug for VirtualMachine {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualMachine");
        formatter.field("host_name", &self.host_name);
        formatter.field("hypervisor_id", &self.hypervisor_id);
        formatter.field("name", &self.name);
        formatter.field("path", &self.path);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("last_backup_date", &self.last_backup_date);
        formatter.finish()
    }
}
/// See [`VirtualMachine`](crate::model::VirtualMachine)
pub mod virtual_machine {
    /// A builder for [`VirtualMachine`](crate::model::VirtualMachine)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host_name: std::option::Option<std::string::String>,
        pub(crate) hypervisor_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) last_backup_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The host name of the virtual machine.</p>
        pub fn host_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_name = Some(input.into());
            self
        }
        /// <p>The host name of the virtual machine.</p>
        pub fn set_host_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_name = input;
            self
        }
        /// <p>The ID of the virtual machine's hypervisor.</p>
        pub fn hypervisor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hypervisor_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual machine's hypervisor.</p>
        pub fn set_hypervisor_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hypervisor_id = input;
            self
        }
        /// <p>The name of the virtual machine.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the virtual machine.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The path of the virtual machine.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path of the virtual machine.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual machine.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the virtual machine.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The most recent date a virtual machine was backed up, in Unix format and UTC time.</p>
        pub fn last_backup_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_backup_date = Some(input);
            self
        }
        /// <p>The most recent date a virtual machine was backed up, in Unix format and UTC time.</p>
        pub fn set_last_backup_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_backup_date = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualMachine`](crate::model::VirtualMachine)
        pub fn build(self) -> crate::model::VirtualMachine {
            crate::model::VirtualMachine {
                host_name: self.host_name,
                hypervisor_id: self.hypervisor_id,
                name: self.name,
                path: self.path,
                resource_arn: self.resource_arn,
                last_backup_date: self.last_backup_date,
            }
        }
    }
}
impl VirtualMachine {
    /// Creates a new builder-style object to manufacture [`VirtualMachine`](crate::model::VirtualMachine)
    pub fn builder() -> crate::model::virtual_machine::Builder {
        crate::model::virtual_machine::Builder::default()
    }
}
