// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHypervisorsOutput {
    /// <p>A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
    pub hypervisors: std::option::Option<std::vec::Vec<crate::model::Hypervisor>>,
    /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHypervisorsOutput {
    /// <p>A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
    pub fn hypervisors(&self) -> std::option::Option<&[crate::model::Hypervisor]> {
        self.hypervisors.as_deref()
    }
    /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHypervisorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHypervisorsOutput");
        formatter.field("hypervisors", &self.hypervisors);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHypervisorsOutput`](crate::output::ListHypervisorsOutput)
pub mod list_hypervisors_output {
    /// A builder for [`ListHypervisorsOutput`](crate::output::ListHypervisorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hypervisors: std::option::Option<std::vec::Vec<crate::model::Hypervisor>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `hypervisors`.
        ///
        /// To override the contents of this collection use [`set_hypervisors`](Self::set_hypervisors).
        ///
        /// <p>A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
        pub fn hypervisors(mut self, input: crate::model::Hypervisor) -> Self {
            let mut v = self.hypervisors.unwrap_or_default();
            v.push(input);
            self.hypervisors = Some(v);
            self
        }
        /// <p>A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
        pub fn set_hypervisors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Hypervisor>>,
        ) -> Self {
            self.hypervisors = input;
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHypervisorsOutput`](crate::output::ListHypervisorsOutput)
        pub fn build(self) -> crate::output::ListHypervisorsOutput {
            crate::output::ListHypervisorsOutput {
                hypervisors: self.hypervisors,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHypervisorsOutput {
    /// Creates a new builder-style object to manufacture [`ListHypervisorsOutput`](crate::output::ListHypervisorsOutput)
    pub fn builder() -> crate::output::list_hypervisors_output::Builder {
        crate::output::list_hypervisors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportHypervisorConfigurationOutput {
    /// <p>The Amazon Resource Name (ARN) of the hypervisor you disassociated.</p>
    pub hypervisor_arn: std::option::Option<std::string::String>,
}
impl ImportHypervisorConfigurationOutput {
    /// <p>The Amazon Resource Name (ARN) of the hypervisor you disassociated.</p>
    pub fn hypervisor_arn(&self) -> std::option::Option<&str> {
        self.hypervisor_arn.as_deref()
    }
}
impl std::fmt::Debug for ImportHypervisorConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportHypervisorConfigurationOutput");
        formatter.field("hypervisor_arn", &self.hypervisor_arn);
        formatter.finish()
    }
}
/// See [`ImportHypervisorConfigurationOutput`](crate::output::ImportHypervisorConfigurationOutput)
pub mod import_hypervisor_configuration_output {
    /// A builder for [`ImportHypervisorConfigurationOutput`](crate::output::ImportHypervisorConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hypervisor_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the hypervisor you disassociated.</p>
        pub fn hypervisor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hypervisor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor you disassociated.</p>
        pub fn set_hypervisor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hypervisor_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportHypervisorConfigurationOutput`](crate::output::ImportHypervisorConfigurationOutput)
        pub fn build(self) -> crate::output::ImportHypervisorConfigurationOutput {
            crate::output::ImportHypervisorConfigurationOutput {
                hypervisor_arn: self.hypervisor_arn,
            }
        }
    }
}
impl ImportHypervisorConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`ImportHypervisorConfigurationOutput`](crate::output::ImportHypervisorConfigurationOutput)
    pub fn builder() -> crate::output::import_hypervisor_configuration_output::Builder {
        crate::output::import_hypervisor_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHypervisorOutput {
    /// <p>The Amazon Resource Name (ARN) of the hypervisor you deleted.</p>
    pub hypervisor_arn: std::option::Option<std::string::String>,
}
impl DeleteHypervisorOutput {
    /// <p>The Amazon Resource Name (ARN) of the hypervisor you deleted.</p>
    pub fn hypervisor_arn(&self) -> std::option::Option<&str> {
        self.hypervisor_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteHypervisorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHypervisorOutput");
        formatter.field("hypervisor_arn", &self.hypervisor_arn);
        formatter.finish()
    }
}
/// See [`DeleteHypervisorOutput`](crate::output::DeleteHypervisorOutput)
pub mod delete_hypervisor_output {
    /// A builder for [`DeleteHypervisorOutput`](crate::output::DeleteHypervisorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hypervisor_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the hypervisor you deleted.</p>
        pub fn hypervisor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hypervisor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor you deleted.</p>
        pub fn set_hypervisor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hypervisor_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHypervisorOutput`](crate::output::DeleteHypervisorOutput)
        pub fn build(self) -> crate::output::DeleteHypervisorOutput {
            crate::output::DeleteHypervisorOutput {
                hypervisor_arn: self.hypervisor_arn,
            }
        }
    }
}
impl DeleteHypervisorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHypervisorOutput`](crate::output::DeleteHypervisorOutput)
    pub fn builder() -> crate::output::delete_hypervisor_output::Builder {
        crate::output::delete_hypervisor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHypervisorOutput {
    /// <p>The Amazon Resource Name (ARN) of the hypervisor you updated.</p>
    pub hypervisor_arn: std::option::Option<std::string::String>,
}
impl UpdateHypervisorOutput {
    /// <p>The Amazon Resource Name (ARN) of the hypervisor you updated.</p>
    pub fn hypervisor_arn(&self) -> std::option::Option<&str> {
        self.hypervisor_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateHypervisorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHypervisorOutput");
        formatter.field("hypervisor_arn", &self.hypervisor_arn);
        formatter.finish()
    }
}
/// See [`UpdateHypervisorOutput`](crate::output::UpdateHypervisorOutput)
pub mod update_hypervisor_output {
    /// A builder for [`UpdateHypervisorOutput`](crate::output::UpdateHypervisorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hypervisor_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the hypervisor you updated.</p>
        pub fn hypervisor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hypervisor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor you updated.</p>
        pub fn set_hypervisor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hypervisor_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHypervisorOutput`](crate::output::UpdateHypervisorOutput)
        pub fn build(self) -> crate::output::UpdateHypervisorOutput {
            crate::output::UpdateHypervisorOutput {
                hypervisor_arn: self.hypervisor_arn,
            }
        }
    }
}
impl UpdateHypervisorOutput {
    /// Creates a new builder-style object to manufacture [`UpdateHypervisorOutput`](crate::output::UpdateHypervisorOutput)
    pub fn builder() -> crate::output::update_hypervisor_output::Builder {
        crate::output::update_hypervisor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestHypervisorConfigurationOutput {}
impl std::fmt::Debug for TestHypervisorConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestHypervisorConfigurationOutput");
        formatter.finish()
    }
}
/// See [`TestHypervisorConfigurationOutput`](crate::output::TestHypervisorConfigurationOutput)
pub mod test_hypervisor_configuration_output {
    /// A builder for [`TestHypervisorConfigurationOutput`](crate::output::TestHypervisorConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TestHypervisorConfigurationOutput`](crate::output::TestHypervisorConfigurationOutput)
        pub fn build(self) -> crate::output::TestHypervisorConfigurationOutput {
            crate::output::TestHypervisorConfigurationOutput {}
        }
    }
}
impl TestHypervisorConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`TestHypervisorConfigurationOutput`](crate::output::TestHypervisorConfigurationOutput)
    pub fn builder() -> crate::output::test_hypervisor_configuration_output::Builder {
        crate::output::test_hypervisor_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMaintenanceStartTimeOutput {
    /// <p>The Amazon Resource Name (ARN) of a gateway for which you set the maintenance start time.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl PutMaintenanceStartTimeOutput {
    /// <p>The Amazon Resource Name (ARN) of a gateway for which you set the maintenance start time.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for PutMaintenanceStartTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMaintenanceStartTimeOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`PutMaintenanceStartTimeOutput`](crate::output::PutMaintenanceStartTimeOutput)
pub mod put_maintenance_start_time_output {
    /// A builder for [`PutMaintenanceStartTimeOutput`](crate::output::PutMaintenanceStartTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a gateway for which you set the maintenance start time.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a gateway for which you set the maintenance start time.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMaintenanceStartTimeOutput`](crate::output::PutMaintenanceStartTimeOutput)
        pub fn build(self) -> crate::output::PutMaintenanceStartTimeOutput {
            crate::output::PutMaintenanceStartTimeOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl PutMaintenanceStartTimeOutput {
    /// Creates a new builder-style object to manufacture [`PutMaintenanceStartTimeOutput`](crate::output::PutMaintenanceStartTimeOutput)
    pub fn builder() -> crate::output::put_maintenance_start_time_output::Builder {
        crate::output::put_maintenance_start_time_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateGatewayFromServerOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you disassociated.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DisassociateGatewayFromServerOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you disassociated.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateGatewayFromServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateGatewayFromServerOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`DisassociateGatewayFromServerOutput`](crate::output::DisassociateGatewayFromServerOutput)
pub mod disassociate_gateway_from_server_output {
    /// A builder for [`DisassociateGatewayFromServerOutput`](crate::output::DisassociateGatewayFromServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway you disassociated.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you disassociated.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateGatewayFromServerOutput`](crate::output::DisassociateGatewayFromServerOutput)
        pub fn build(self) -> crate::output::DisassociateGatewayFromServerOutput {
            crate::output::DisassociateGatewayFromServerOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl DisassociateGatewayFromServerOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateGatewayFromServerOutput`](crate::output::DisassociateGatewayFromServerOutput)
    pub fn builder() -> crate::output::disassociate_gateway_from_server_output::Builder {
        crate::output::disassociate_gateway_from_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateGatewayToServerOutput {
    /// <p>The Amazon Resource Name (ARN) of a gateway.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl AssociateGatewayToServerOutput {
    /// <p>The Amazon Resource Name (ARN) of a gateway.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateGatewayToServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateGatewayToServerOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`AssociateGatewayToServerOutput`](crate::output::AssociateGatewayToServerOutput)
pub mod associate_gateway_to_server_output {
    /// A builder for [`AssociateGatewayToServerOutput`](crate::output::AssociateGatewayToServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a gateway.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a gateway.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateGatewayToServerOutput`](crate::output::AssociateGatewayToServerOutput)
        pub fn build(self) -> crate::output::AssociateGatewayToServerOutput {
            crate::output::AssociateGatewayToServerOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl AssociateGatewayToServerOutput {
    /// Creates a new builder-style object to manufacture [`AssociateGatewayToServerOutput`](crate::output::AssociateGatewayToServerOutput)
    pub fn builder() -> crate::output::associate_gateway_to_server_output::Builder {
        crate::output::associate_gateway_to_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewaysOutput {
    /// <p>A list of your gateways.</p>
    pub gateways: std::option::Option<std::vec::Vec<crate::model::Gateway>>,
    /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGatewaysOutput {
    /// <p>A list of your gateways.</p>
    pub fn gateways(&self) -> std::option::Option<&[crate::model::Gateway]> {
        self.gateways.as_deref()
    }
    /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGatewaysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewaysOutput");
        formatter.field("gateways", &self.gateways);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
pub mod list_gateways_output {
    /// A builder for [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateways: std::option::Option<std::vec::Vec<crate::model::Gateway>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `gateways`.
        ///
        /// To override the contents of this collection use [`set_gateways`](Self::set_gateways).
        ///
        /// <p>A list of your gateways.</p>
        pub fn gateways(mut self, input: crate::model::Gateway) -> Self {
            let mut v = self.gateways.unwrap_or_default();
            v.push(input);
            self.gateways = Some(v);
            self
        }
        /// <p>A list of your gateways.</p>
        pub fn set_gateways(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Gateway>>,
        ) -> Self {
            self.gateways = input;
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
        pub fn build(self) -> crate::output::ListGatewaysOutput {
            crate::output::ListGatewaysOutput {
                gateways: self.gateways,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGatewaysOutput {
    /// Creates a new builder-style object to manufacture [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
    pub fn builder() -> crate::output::list_gateways_output::Builder {
        crate::output::list_gateways_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you create.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl CreateGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you create.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGatewayOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
pub mod create_gateway_output {
    /// A builder for [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway you create.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you create.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
        pub fn build(self) -> crate::output::CreateGatewayOutput {
            crate::output::CreateGatewayOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl CreateGatewayOutput {
    /// Creates a new builder-style object to manufacture [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
    pub fn builder() -> crate::output::create_gateway_output::Builder {
        crate::output::create_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you deleted.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl DeleteGatewayOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you deleted.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
pub mod delete_gateway_output {
    /// A builder for [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway you deleted.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you deleted.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
        pub fn build(self) -> crate::output::DeleteGatewayOutput {
            crate::output::DeleteGatewayOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl DeleteGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
    pub fn builder() -> crate::output::delete_gateway_output::Builder {
        crate::output::delete_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayInformationOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you updated.</p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl UpdateGatewayInformationOutput {
    /// <p>The Amazon Resource Name (ARN) of the gateway you updated.</p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateGatewayInformationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayInformationOutput");
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
pub mod update_gateway_information_output {
    /// A builder for [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the gateway you updated.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway you updated.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
        pub fn build(self) -> crate::output::UpdateGatewayInformationOutput {
            crate::output::UpdateGatewayInformationOutput {
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl UpdateGatewayInformationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput)
    pub fn builder() -> crate::output::update_gateway_information_output::Builder {
        crate::output::update_gateway_information_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which you removed tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl UntagResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which you removed tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource from which you removed tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you removed tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource you tagged.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl TagResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource you tagged.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource you tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualMachinesOutput {
    /// <p>A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
    pub virtual_machines: std::option::Option<std::vec::Vec<crate::model::VirtualMachine>>,
    /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVirtualMachinesOutput {
    /// <p>A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
    pub fn virtual_machines(&self) -> std::option::Option<&[crate::model::VirtualMachine]> {
        self.virtual_machines.as_deref()
    }
    /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualMachinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualMachinesOutput");
        formatter.field("virtual_machines", &self.virtual_machines);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVirtualMachinesOutput`](crate::output::ListVirtualMachinesOutput)
pub mod list_virtual_machines_output {
    /// A builder for [`ListVirtualMachinesOutput`](crate::output::ListVirtualMachinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_machines:
            std::option::Option<std::vec::Vec<crate::model::VirtualMachine>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `virtual_machines`.
        ///
        /// To override the contents of this collection use [`set_virtual_machines`](Self::set_virtual_machines).
        ///
        /// <p>A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
        pub fn virtual_machines(mut self, input: crate::model::VirtualMachine) -> Self {
            let mut v = self.virtual_machines.unwrap_or_default();
            v.push(input);
            self.virtual_machines = Some(v);
            self
        }
        /// <p>A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
        pub fn set_virtual_machines(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualMachine>>,
        ) -> Self {
            self.virtual_machines = input;
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualMachinesOutput`](crate::output::ListVirtualMachinesOutput)
        pub fn build(self) -> crate::output::ListVirtualMachinesOutput {
            crate::output::ListVirtualMachinesOutput {
                virtual_machines: self.virtual_machines,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVirtualMachinesOutput {
    /// Creates a new builder-style object to manufacture [`ListVirtualMachinesOutput`](crate::output::ListVirtualMachinesOutput)
    pub fn builder() -> crate::output::list_virtual_machines_output::Builder {
        crate::output::list_virtual_machines_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource's tags that you listed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the resource's tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource's tags that you listed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the resource's tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource's tags that you listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource's tags that you listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the resource's tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of the resource's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
