// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Backup Gateway
///
/// Client for invoking operations on AWS Backup Gateway. Each operation on AWS Backup Gateway is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_backupgateway::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_backupgateway::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_backupgateway::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateGatewayToServer`](crate::client::fluent_builders::AssociateGatewayToServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateGatewayToServer::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::AssociateGatewayToServer::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
    ///   - [`server_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateGatewayToServer::server_arn) / [`set_server_arn(Option<String>)`](crate::client::fluent_builders::AssociateGatewayToServer::set_server_arn): <p>The Amazon Resource Name (ARN) of the server that hosts your virtual machines.</p>
    /// - On success, responds with [`AssociateGatewayToServerOutput`](crate::output::AssociateGatewayToServerOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::AssociateGatewayToServerOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of a gateway.</p>
    /// - On failure, responds with [`SdkError<AssociateGatewayToServerError>`](crate::error::AssociateGatewayToServerError)
    pub fn associate_gateway_to_server(&self) -> fluent_builders::AssociateGatewayToServer {
        fluent_builders::AssociateGatewayToServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGateway`](crate::client::fluent_builders::CreateGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`activation_key(impl Into<String>)`](crate::client::fluent_builders::CreateGateway::activation_key) / [`set_activation_key(Option<String>)`](crate::client::fluent_builders::CreateGateway::set_activation_key): <p>The activation key of the created gateway.</p>
    ///   - [`gateway_display_name(impl Into<String>)`](crate::client::fluent_builders::CreateGateway::gateway_display_name) / [`set_gateway_display_name(Option<String>)`](crate::client::fluent_builders::CreateGateway::set_gateway_display_name): <p>The display name of the created gateway.</p>
    ///   - [`gateway_type(GatewayType)`](crate::client::fluent_builders::CreateGateway::gateway_type) / [`set_gateway_type(Option<GatewayType>)`](crate::client::fluent_builders::CreateGateway::set_gateway_type): <p>The type of created gateway.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateGateway::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateGateway::set_tags): <p>A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.</p>
    /// - On success, responds with [`CreateGatewayOutput`](crate::output::CreateGatewayOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::CreateGatewayOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway you create.</p>
    /// - On failure, responds with [`SdkError<CreateGatewayError>`](crate::error::CreateGatewayError)
    pub fn create_gateway(&self) -> fluent_builders::CreateGateway {
        fluent_builders::CreateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGateway`](crate::client::fluent_builders::DeleteGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteGateway::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DeleteGateway::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway to delete.</p>
    /// - On success, responds with [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DeleteGatewayOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway you deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteGatewayError>`](crate::error::DeleteGatewayError)
    pub fn delete_gateway(&self) -> fluent_builders::DeleteGateway {
        fluent_builders::DeleteGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHypervisor`](crate::client::fluent_builders::DeleteHypervisor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hypervisor_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteHypervisor::hypervisor_arn) / [`set_hypervisor_arn(Option<String>)`](crate::client::fluent_builders::DeleteHypervisor::set_hypervisor_arn): <p>The Amazon Resource Name (ARN) of the hypervisor to delete.</p>
    /// - On success, responds with [`DeleteHypervisorOutput`](crate::output::DeleteHypervisorOutput) with field(s):
    ///   - [`hypervisor_arn(Option<String>)`](crate::output::DeleteHypervisorOutput::hypervisor_arn): <p>The Amazon Resource Name (ARN) of the hypervisor you deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteHypervisorError>`](crate::error::DeleteHypervisorError)
    pub fn delete_hypervisor(&self) -> fluent_builders::DeleteHypervisor {
        fluent_builders::DeleteHypervisor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateGatewayFromServer`](crate::client::fluent_builders::DisassociateGatewayFromServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateGatewayFromServer::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::DisassociateGatewayFromServer::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway to disassociate.</p>
    /// - On success, responds with [`DisassociateGatewayFromServerOutput`](crate::output::DisassociateGatewayFromServerOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::DisassociateGatewayFromServerOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway you disassociated.</p>
    /// - On failure, responds with [`SdkError<DisassociateGatewayFromServerError>`](crate::error::DisassociateGatewayFromServerError)
    pub fn disassociate_gateway_from_server(
        &self,
    ) -> fluent_builders::DisassociateGatewayFromServer {
        fluent_builders::DisassociateGatewayFromServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportHypervisorConfiguration`](crate::client::fluent_builders::ImportHypervisorConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::set_name): <p>The name of the hypervisor.</p>
    ///   - [`host(impl Into<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::host) / [`set_host(Option<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::set_host): <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::set_username): <p>The username for the hypervisor.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::set_password): <p>The password for the hypervisor.</p>
    ///   - [`kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::kms_key_arn) / [`set_kms_key_arn(Option<String>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::set_kms_key_arn): <p>The Key Management Service for the hypervisor.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ImportHypervisorConfiguration::set_tags): <p>The tags of the hypervisor configuration to import.</p>
    /// - On success, responds with [`ImportHypervisorConfigurationOutput`](crate::output::ImportHypervisorConfigurationOutput) with field(s):
    ///   - [`hypervisor_arn(Option<String>)`](crate::output::ImportHypervisorConfigurationOutput::hypervisor_arn): <p>The Amazon Resource Name (ARN) of the hypervisor you disassociated.</p>
    /// - On failure, responds with [`SdkError<ImportHypervisorConfigurationError>`](crate::error::ImportHypervisorConfigurationError)
    pub fn import_hypervisor_configuration(
        &self,
    ) -> fluent_builders::ImportHypervisorConfiguration {
        fluent_builders::ImportHypervisorConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGateways`](crate::client::fluent_builders::ListGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGateways::set_max_results): <p>The maximum number of gateways to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGateways::set_next_token): <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    /// - On success, responds with [`ListGatewaysOutput`](crate::output::ListGatewaysOutput) with field(s):
    ///   - [`gateways(Option<Vec<Gateway>>)`](crate::output::ListGatewaysOutput::gateways): <p>A list of your gateways.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGatewaysOutput::next_token): <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    /// - On failure, responds with [`SdkError<ListGatewaysError>`](crate::error::ListGatewaysError)
    pub fn list_gateways(&self) -> fluent_builders::ListGateways {
        fluent_builders::ListGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHypervisors`](crate::client::fluent_builders::ListHypervisors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHypervisors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHypervisors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListHypervisors::set_max_results): <p>The maximum number of hypervisors to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHypervisors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHypervisors::set_next_token): <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    /// - On success, responds with [`ListHypervisorsOutput`](crate::output::ListHypervisorsOutput) with field(s):
    ///   - [`hypervisors(Option<Vec<Hypervisor>>)`](crate::output::ListHypervisorsOutput::hypervisors): <p>A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHypervisorsOutput::next_token): <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    /// - On failure, responds with [`SdkError<ListHypervisorsError>`](crate::error::ListHypervisorsError)
    pub fn list_hypervisors(&self) -> fluent_builders::ListHypervisors {
        fluent_builders::ListHypervisors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource's tags to list.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::ListTagsForResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the resource's tags that you listed.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of the resource's tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVirtualMachines`](crate::client::fluent_builders::ListVirtualMachines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVirtualMachines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListVirtualMachines::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListVirtualMachines::set_max_results): <p>The maximum number of virtual machines to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVirtualMachines::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVirtualMachines::set_next_token): <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    /// - On success, responds with [`ListVirtualMachinesOutput`](crate::output::ListVirtualMachinesOutput) with field(s):
    ///   - [`virtual_machines(Option<Vec<VirtualMachine>>)`](crate::output::ListVirtualMachinesOutput::virtual_machines): <p>A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVirtualMachinesOutput::next_token): <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    /// - On failure, responds with [`SdkError<ListVirtualMachinesError>`](crate::error::ListVirtualMachinesError)
    pub fn list_virtual_machines(&self) -> fluent_builders::ListVirtualMachines {
        fluent_builders::ListVirtualMachines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMaintenanceStartTime`](crate::client::fluent_builders::PutMaintenanceStartTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::PutMaintenanceStartTime::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::PutMaintenanceStartTime::set_gateway_arn): <p>The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.</p>
    ///   - [`hour_of_day(i32)`](crate::client::fluent_builders::PutMaintenanceStartTime::hour_of_day) / [`set_hour_of_day(Option<i32>)`](crate::client::fluent_builders::PutMaintenanceStartTime::set_hour_of_day): <p>The hour of the day to start maintenance on a gateway.</p>
    ///   - [`minute_of_hour(i32)`](crate::client::fluent_builders::PutMaintenanceStartTime::minute_of_hour) / [`set_minute_of_hour(Option<i32>)`](crate::client::fluent_builders::PutMaintenanceStartTime::set_minute_of_hour): <p>The minute of the hour to start maintenance on a gateway.</p>
    ///   - [`day_of_week(i32)`](crate::client::fluent_builders::PutMaintenanceStartTime::day_of_week) / [`set_day_of_week(Option<i32>)`](crate::client::fluent_builders::PutMaintenanceStartTime::set_day_of_week): <p>The day of the week to start maintenance on a gateway.</p>
    ///   - [`day_of_month(i32)`](crate::client::fluent_builders::PutMaintenanceStartTime::day_of_month) / [`set_day_of_month(Option<i32>)`](crate::client::fluent_builders::PutMaintenanceStartTime::set_day_of_month): <p>The day of the month start maintenance on a gateway.</p>  <p>Valid values range from <code>Sunday</code> to <code>Saturday</code>.</p>
    /// - On success, responds with [`PutMaintenanceStartTimeOutput`](crate::output::PutMaintenanceStartTimeOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::PutMaintenanceStartTimeOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of a gateway for which you set the maintenance start time.</p>
    /// - On failure, responds with [`SdkError<PutMaintenanceStartTimeError>`](crate::error::PutMaintenanceStartTimeError)
    pub fn put_maintenance_start_time(&self) -> fluent_builders::PutMaintenanceStartTime {
        fluent_builders::PutMaintenanceStartTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to tag.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags to assign to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::TagResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the resource you tagged.</p>
    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestHypervisorConfiguration`](crate::client::fluent_builders::TestHypervisorConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.</p>
    ///   - [`host(impl Into<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::host) / [`set_host(Option<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::set_host): <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::set_username): <p>The username for the hypervisor.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::TestHypervisorConfiguration::set_password): <p>The password for the hypervisor.</p>
    /// - On success, responds with [`TestHypervisorConfigurationOutput`](crate::output::TestHypervisorConfigurationOutput)

    /// - On failure, responds with [`SdkError<TestHypervisorConfigurationError>`](crate::error::TestHypervisorConfigurationError)
    pub fn test_hypervisor_configuration(&self) -> fluent_builders::TestHypervisorConfiguration {
        fluent_builders::TestHypervisorConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource from which to remove tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys specifying which tags to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::UntagResourceOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the resource from which you removed tags.</p>
    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGatewayInformation`](crate::client::fluent_builders::UpdateGatewayInformation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::gateway_arn) / [`set_gateway_arn(Option<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::set_gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway to update.</p>
    ///   - [`gateway_display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::gateway_display_name) / [`set_gateway_display_name(Option<String>)`](crate::client::fluent_builders::UpdateGatewayInformation::set_gateway_display_name): <p>The updated display name of the gateway.</p>
    /// - On success, responds with [`UpdateGatewayInformationOutput`](crate::output::UpdateGatewayInformationOutput) with field(s):
    ///   - [`gateway_arn(Option<String>)`](crate::output::UpdateGatewayInformationOutput::gateway_arn): <p>The Amazon Resource Name (ARN) of the gateway you updated.</p>
    /// - On failure, responds with [`SdkError<UpdateGatewayInformationError>`](crate::error::UpdateGatewayInformationError)
    pub fn update_gateway_information(&self) -> fluent_builders::UpdateGatewayInformation {
        fluent_builders::UpdateGatewayInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateHypervisor`](crate::client::fluent_builders::UpdateHypervisor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hypervisor_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateHypervisor::hypervisor_arn) / [`set_hypervisor_arn(Option<String>)`](crate::client::fluent_builders::UpdateHypervisor::set_hypervisor_arn): <p>The Amazon Resource Name (ARN) of the hypervisor to update.</p>
    ///   - [`host(impl Into<String>)`](crate::client::fluent_builders::UpdateHypervisor::host) / [`set_host(Option<String>)`](crate::client::fluent_builders::UpdateHypervisor::set_host): <p>The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::UpdateHypervisor::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::UpdateHypervisor::set_username): <p>The updated username for the hypervisor.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::UpdateHypervisor::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::UpdateHypervisor::set_password): <p>The updated password for the hypervisor.</p>
    /// - On success, responds with [`UpdateHypervisorOutput`](crate::output::UpdateHypervisorOutput) with field(s):
    ///   - [`hypervisor_arn(Option<String>)`](crate::output::UpdateHypervisorOutput::hypervisor_arn): <p>The Amazon Resource Name (ARN) of the hypervisor you updated.</p>
    /// - On failure, responds with [`SdkError<UpdateHypervisorError>`](crate::error::UpdateHypervisorError)
    pub fn update_hypervisor(&self) -> fluent_builders::UpdateHypervisor {
        fluent_builders::UpdateHypervisor::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateGatewayToServer`.
    ///
    /// <p>Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateGatewayToServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_gateway_to_server_input::Builder,
    }
    impl AssociateGatewayToServer {
        /// Creates a new `AssociateGatewayToServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateGatewayToServerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateGatewayToServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the server that hosts your virtual machines.</p>
        pub fn server_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the server that hosts your virtual machines.</p>
        pub fn set_server_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGateway`.
    ///
    /// <p>Creates a backup gateway. After you create a gateway, you can associate it with a server using the <code>AssociateGatewayToServer</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_gateway_input::Builder,
    }
    impl CreateGateway {
        /// Creates a new `CreateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The activation key of the created gateway.</p>
        pub fn activation_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_key(input.into());
            self
        }
        /// <p>The activation key of the created gateway.</p>
        pub fn set_activation_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_key(input);
            self
        }
        /// <p>The display name of the created gateway.</p>
        pub fn gateway_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_display_name(input.into());
            self
        }
        /// <p>The display name of the created gateway.</p>
        pub fn set_gateway_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_display_name(input);
            self
        }
        /// <p>The type of created gateway.</p>
        pub fn gateway_type(mut self, input: crate::model::GatewayType) -> Self {
            self.inner = self.inner.gateway_type(input);
            self
        }
        /// <p>The type of created gateway.</p>
        pub fn set_gateway_type(
            mut self,
            input: std::option::Option<crate::model::GatewayType>,
        ) -> Self {
            self.inner = self.inner.set_gateway_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGateway`.
    ///
    /// <p>Deletes a backup gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_gateway_input::Builder,
    }
    impl DeleteGateway {
        /// Creates a new `DeleteGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to delete.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to delete.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHypervisor`.
    ///
    /// <p>Deletes a hypervisor.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHypervisor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hypervisor_input::Builder,
    }
    impl DeleteHypervisor {
        /// Creates a new `DeleteHypervisor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHypervisorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHypervisorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor to delete.</p>
        pub fn hypervisor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hypervisor_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor to delete.</p>
        pub fn set_hypervisor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hypervisor_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateGatewayFromServer`.
    ///
    /// <p>Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateGatewayFromServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_gateway_from_server_input::Builder,
    }
    impl DisassociateGatewayFromServer {
        /// Creates a new `DisassociateGatewayFromServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateGatewayFromServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateGatewayFromServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to disassociate.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to disassociate.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportHypervisorConfiguration`.
    ///
    /// <p>Connect to a hypervisor by importing its configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportHypervisorConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_hypervisor_configuration_input::Builder,
    }
    impl ImportHypervisorConfiguration {
        /// Creates a new `ImportHypervisorConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportHypervisorConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportHypervisorConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the hypervisor.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the hypervisor.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host(input.into());
            self
        }
        /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host(input);
            self
        }
        /// <p>The username for the hypervisor.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username for the hypervisor.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password for the hypervisor.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for the hypervisor.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The Key Management Service for the hypervisor.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(input.into());
            self
        }
        /// <p>The Key Management Service for the hypervisor.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the hypervisor configuration to import.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags of the hypervisor configuration to import.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGateways`.
    ///
    /// <p>Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGateways {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_gateways_input::Builder,
    }
    impl ListGateways {
        /// Creates a new `ListGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewaysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGatewaysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGatewaysPaginator {
            crate::paginator::ListGatewaysPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of gateways to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of gateways to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHypervisors`.
    ///
    /// <p>Lists your hypervisors.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHypervisors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hypervisors_input::Builder,
    }
    impl ListHypervisors {
        /// Creates a new `ListHypervisors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHypervisorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHypervisorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHypervisorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHypervisorsPaginator {
            crate::paginator::ListHypervisorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of hypervisors to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of hypervisors to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource's tags to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource's tags to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualMachines`.
    ///
    /// <p>Lists your virtual machines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVirtualMachines {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_virtual_machines_input::Builder,
    }
    impl ListVirtualMachines {
        /// Creates a new `ListVirtualMachines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualMachinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualMachinesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVirtualMachinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVirtualMachinesPaginator {
            crate::paginator::ListVirtualMachinesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of virtual machines to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of virtual machines to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMaintenanceStartTime`.
    ///
    /// <p>Set the maintenance start time for a gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMaintenanceStartTime {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_maintenance_start_time_input::Builder,
    }
    impl PutMaintenanceStartTime {
        /// Creates a new `PutMaintenanceStartTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMaintenanceStartTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMaintenanceStartTimeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The hour of the day to start maintenance on a gateway.</p>
        pub fn hour_of_day(mut self, input: i32) -> Self {
            self.inner = self.inner.hour_of_day(input);
            self
        }
        /// <p>The hour of the day to start maintenance on a gateway.</p>
        pub fn set_hour_of_day(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_hour_of_day(input);
            self
        }
        /// <p>The minute of the hour to start maintenance on a gateway.</p>
        pub fn minute_of_hour(mut self, input: i32) -> Self {
            self.inner = self.inner.minute_of_hour(input);
            self
        }
        /// <p>The minute of the hour to start maintenance on a gateway.</p>
        pub fn set_minute_of_hour(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minute_of_hour(input);
            self
        }
        /// <p>The day of the week to start maintenance on a gateway.</p>
        pub fn day_of_week(mut self, input: i32) -> Self {
            self.inner = self.inner.day_of_week(input);
            self
        }
        /// <p>The day of the week to start maintenance on a gateway.</p>
        pub fn set_day_of_week(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_day_of_week(input);
            self
        }
        /// <p>The day of the month start maintenance on a gateway.</p>
        /// <p>Valid values range from <code>Sunday</code> to <code>Saturday</code>.</p>
        pub fn day_of_month(mut self, input: i32) -> Self {
            self.inner = self.inner.day_of_month(input);
            self
        }
        /// <p>The day of the month start maintenance on a gateway.</p>
        /// <p>Valid values range from <code>Sunday</code> to <code>Saturday</code>.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_day_of_month(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tag the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to assign to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to assign to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestHypervisorConfiguration`.
    ///
    /// <p>Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestHypervisorConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_hypervisor_configuration_input::Builder,
    }
    impl TestHypervisorConfiguration {
        /// Creates a new `TestHypervisorConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestHypervisorConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::TestHypervisorConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host(input.into());
            self
        }
        /// <p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host(input);
            self
        }
        /// <p>The username for the hypervisor.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The username for the hypervisor.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password for the hypervisor.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for the hypervisor.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys specifying which tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys specifying which tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayInformation`.
    ///
    /// <p>Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGatewayInformation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_gateway_information_input::Builder,
    }
    impl UpdateGatewayInformation {
        /// Creates a new `UpdateGatewayInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayInformationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to update.</p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gateway to update.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The updated display name of the gateway.</p>
        pub fn gateway_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_display_name(input.into());
            self
        }
        /// <p>The updated display name of the gateway.</p>
        pub fn set_gateway_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHypervisor`.
    ///
    /// <p>Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHypervisor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_hypervisor_input::Builder,
    }
    impl UpdateHypervisor {
        /// Creates a new `UpdateHypervisor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHypervisorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHypervisorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor to update.</p>
        pub fn hypervisor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hypervisor_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the hypervisor to update.</p>
        pub fn set_hypervisor_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hypervisor_arn(input);
            self
        }
        /// <p>The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host(input.into());
            self
        }
        /// <p>The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host(input);
            self
        }
        /// <p>The updated username for the hypervisor.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The updated username for the hypervisor.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The updated password for the hypervisor.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The updated password for the hypervisor.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
