// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReportPlanOutput {
    /// <p>The unique name of the report plan.</p>
    pub report_plan_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub report_plan_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateReportPlanOutput {
    /// <p>The unique name of the report plan.</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub fn report_plan_arn(&self) -> std::option::Option<&str> {
        self.report_plan_arn.as_deref()
    }
    /// <p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateReportPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReportPlanOutput");
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.field("report_plan_arn", &self.report_plan_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`UpdateReportPlanOutput`](crate::output::UpdateReportPlanOutput)
pub mod update_report_plan_output {
    /// A builder for [`UpdateReportPlanOutput`](crate::output::UpdateReportPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
        pub(crate) report_plan_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique name of the report plan.</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of the report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn report_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn set_report_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_arn = input;
            self
        }
        /// <p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReportPlanOutput`](crate::output::UpdateReportPlanOutput)
        pub fn build(self) -> crate::output::UpdateReportPlanOutput {
            crate::output::UpdateReportPlanOutput {
                report_plan_name: self.report_plan_name,
                report_plan_arn: self.report_plan_arn,
                creation_time: self.creation_time,
            }
        }
    }
}
impl UpdateReportPlanOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReportPlanOutput`](crate::output::UpdateReportPlanOutput)
    pub fn builder() -> crate::output::update_report_plan_output::Builder {
        crate::output::update_report_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRegionSettingsOutput {}
impl std::fmt::Debug for UpdateRegionSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRegionSettingsOutput");
        formatter.finish()
    }
}
/// See [`UpdateRegionSettingsOutput`](crate::output::UpdateRegionSettingsOutput)
pub mod update_region_settings_output {
    /// A builder for [`UpdateRegionSettingsOutput`](crate::output::UpdateRegionSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateRegionSettingsOutput`](crate::output::UpdateRegionSettingsOutput)
        pub fn build(self) -> crate::output::UpdateRegionSettingsOutput {
            crate::output::UpdateRegionSettingsOutput {}
        }
    }
}
impl UpdateRegionSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRegionSettingsOutput`](crate::output::UpdateRegionSettingsOutput)
    pub fn builder() -> crate::output::update_region_settings_output::Builder {
        crate::output::update_region_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecoveryPointLifecycleOutput {
    /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
    /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
    pub calculated_lifecycle: std::option::Option<crate::model::CalculatedLifecycle>,
}
impl UpdateRecoveryPointLifecycleOutput {
    /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
    pub fn calculated_lifecycle(&self) -> std::option::Option<&crate::model::CalculatedLifecycle> {
        self.calculated_lifecycle.as_ref()
    }
}
impl std::fmt::Debug for UpdateRecoveryPointLifecycleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecoveryPointLifecycleOutput");
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("calculated_lifecycle", &self.calculated_lifecycle);
        formatter.finish()
    }
}
/// See [`UpdateRecoveryPointLifecycleOutput`](crate::output::UpdateRecoveryPointLifecycleOutput)
pub mod update_recovery_point_lifecycle_output {
    /// A builder for [`UpdateRecoveryPointLifecycleOutput`](crate::output::UpdateRecoveryPointLifecycleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
        pub(crate) calculated_lifecycle: std::option::Option<crate::model::CalculatedLifecycle>,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
        pub fn calculated_lifecycle(mut self, input: crate::model::CalculatedLifecycle) -> Self {
            self.calculated_lifecycle = Some(input);
            self
        }
        /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
        pub fn set_calculated_lifecycle(
            mut self,
            input: std::option::Option<crate::model::CalculatedLifecycle>,
        ) -> Self {
            self.calculated_lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecoveryPointLifecycleOutput`](crate::output::UpdateRecoveryPointLifecycleOutput)
        pub fn build(self) -> crate::output::UpdateRecoveryPointLifecycleOutput {
            crate::output::UpdateRecoveryPointLifecycleOutput {
                backup_vault_arn: self.backup_vault_arn,
                recovery_point_arn: self.recovery_point_arn,
                lifecycle: self.lifecycle,
                calculated_lifecycle: self.calculated_lifecycle,
            }
        }
    }
}
impl UpdateRecoveryPointLifecycleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRecoveryPointLifecycleOutput`](crate::output::UpdateRecoveryPointLifecycleOutput)
    pub fn builder() -> crate::output::update_recovery_point_lifecycle_output::Builder {
        crate::output::update_recovery_point_lifecycle_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalSettingsOutput {}
impl std::fmt::Debug for UpdateGlobalSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalSettingsOutput");
        formatter.finish()
    }
}
/// See [`UpdateGlobalSettingsOutput`](crate::output::UpdateGlobalSettingsOutput)
pub mod update_global_settings_output {
    /// A builder for [`UpdateGlobalSettingsOutput`](crate::output::UpdateGlobalSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateGlobalSettingsOutput`](crate::output::UpdateGlobalSettingsOutput)
        pub fn build(self) -> crate::output::UpdateGlobalSettingsOutput {
            crate::output::UpdateGlobalSettingsOutput {}
        }
    }
}
impl UpdateGlobalSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalSettingsOutput`](crate::output::UpdateGlobalSettingsOutput)
    pub fn builder() -> crate::output::update_global_settings_output::Builder {
        crate::output::update_global_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFrameworkOutput {
    /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub framework_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub framework_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateFrameworkOutput {
    /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub fn framework_arn(&self) -> std::option::Option<&str> {
        self.framework_arn.as_deref()
    }
    /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFrameworkOutput");
        formatter.field("framework_name", &self.framework_name);
        formatter.field("framework_arn", &self.framework_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`UpdateFrameworkOutput`](crate::output::UpdateFrameworkOutput)
pub mod update_framework_output {
    /// A builder for [`UpdateFrameworkOutput`](crate::output::UpdateFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
        pub(crate) framework_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn framework_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn set_framework_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_arn = input;
            self
        }
        /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFrameworkOutput`](crate::output::UpdateFrameworkOutput)
        pub fn build(self) -> crate::output::UpdateFrameworkOutput {
            crate::output::UpdateFrameworkOutput {
                framework_name: self.framework_name,
                framework_arn: self.framework_arn,
                creation_time: self.creation_time,
            }
        }
    }
}
impl UpdateFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFrameworkOutput`](crate::output::UpdateFrameworkOutput)
    pub fn builder() -> crate::output::update_framework_output::Builder {
        crate::output::update_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackupPlanOutput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub backup_plan_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot be edited.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
    pub advanced_backup_settings:
        std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
}
impl UpdateBackupPlanOutput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub fn backup_plan_arn(&self) -> std::option::Option<&str> {
        self.backup_plan_arn.as_deref()
    }
    /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot be edited.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
    pub fn advanced_backup_settings(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedBackupSetting]> {
        self.advanced_backup_settings.as_deref()
    }
}
impl std::fmt::Debug for UpdateBackupPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackupPlanOutput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("backup_plan_arn", &self.backup_plan_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("version_id", &self.version_id);
        formatter.field("advanced_backup_settings", &self.advanced_backup_settings);
        formatter.finish()
    }
}
/// See [`UpdateBackupPlanOutput`](crate::output::UpdateBackupPlanOutput)
pub mod update_backup_plan_output {
    /// A builder for [`UpdateBackupPlanOutput`](crate::output::UpdateBackupPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) advanced_backup_settings:
            std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn backup_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn set_backup_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_arn = input;
            self
        }
        /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot be edited.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot be edited.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `advanced_backup_settings`.
        ///
        /// To override the contents of this collection use [`set_advanced_backup_settings`](Self::set_advanced_backup_settings).
        ///
        /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
        pub fn advanced_backup_settings(
            mut self,
            input: crate::model::AdvancedBackupSetting,
        ) -> Self {
            let mut v = self.advanced_backup_settings.unwrap_or_default();
            v.push(input);
            self.advanced_backup_settings = Some(v);
            self
        }
        /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
        pub fn set_advanced_backup_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
        ) -> Self {
            self.advanced_backup_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackupPlanOutput`](crate::output::UpdateBackupPlanOutput)
        pub fn build(self) -> crate::output::UpdateBackupPlanOutput {
            crate::output::UpdateBackupPlanOutput {
                backup_plan_id: self.backup_plan_id,
                backup_plan_arn: self.backup_plan_arn,
                creation_date: self.creation_date,
                version_id: self.version_id,
                advanced_backup_settings: self.advanced_backup_settings,
            }
        }
    }
}
impl UpdateBackupPlanOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBackupPlanOutput`](crate::output::UpdateBackupPlanOutput)
    pub fn builder() -> crate::output::update_backup_plan_output::Builder {
        crate::output::update_backup_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopBackupJobOutput {}
impl std::fmt::Debug for StopBackupJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopBackupJobOutput");
        formatter.finish()
    }
}
/// See [`StopBackupJobOutput`](crate::output::StopBackupJobOutput)
pub mod stop_backup_job_output {
    /// A builder for [`StopBackupJobOutput`](crate::output::StopBackupJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopBackupJobOutput`](crate::output::StopBackupJobOutput)
        pub fn build(self) -> crate::output::StopBackupJobOutput {
            crate::output::StopBackupJobOutput {}
        }
    }
}
impl StopBackupJobOutput {
    /// Creates a new builder-style object to manufacture [`StopBackupJobOutput`](crate::output::StopBackupJobOutput)
    pub fn builder() -> crate::output::stop_backup_job_output::Builder {
        crate::output::stop_backup_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRestoreJobOutput {
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub restore_job_id: std::option::Option<std::string::String>,
}
impl StartRestoreJobOutput {
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub fn restore_job_id(&self) -> std::option::Option<&str> {
        self.restore_job_id.as_deref()
    }
}
impl std::fmt::Debug for StartRestoreJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRestoreJobOutput");
        formatter.field("restore_job_id", &self.restore_job_id);
        formatter.finish()
    }
}
/// See [`StartRestoreJobOutput`](crate::output::StartRestoreJobOutput)
pub mod start_restore_job_output {
    /// A builder for [`StartRestoreJobOutput`](crate::output::StartRestoreJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) restore_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn restore_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn set_restore_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.restore_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRestoreJobOutput`](crate::output::StartRestoreJobOutput)
        pub fn build(self) -> crate::output::StartRestoreJobOutput {
            crate::output::StartRestoreJobOutput {
                restore_job_id: self.restore_job_id,
            }
        }
    }
}
impl StartRestoreJobOutput {
    /// Creates a new builder-style object to manufacture [`StartRestoreJobOutput`](crate::output::StartRestoreJobOutput)
    pub fn builder() -> crate::output::start_restore_job_output::Builder {
        crate::output::start_restore_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReportJobOutput {
    /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
    pub report_job_id: std::option::Option<std::string::String>,
}
impl StartReportJobOutput {
    /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
    pub fn report_job_id(&self) -> std::option::Option<&str> {
        self.report_job_id.as_deref()
    }
}
impl std::fmt::Debug for StartReportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReportJobOutput");
        formatter.field("report_job_id", &self.report_job_id);
        formatter.finish()
    }
}
/// See [`StartReportJobOutput`](crate::output::StartReportJobOutput)
pub mod start_report_job_output {
    /// A builder for [`StartReportJobOutput`](crate::output::StartReportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
        pub fn report_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
        pub fn set_report_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReportJobOutput`](crate::output::StartReportJobOutput)
        pub fn build(self) -> crate::output::StartReportJobOutput {
            crate::output::StartReportJobOutput {
                report_job_id: self.report_job_id,
            }
        }
    }
}
impl StartReportJobOutput {
    /// Creates a new builder-style object to manufacture [`StartReportJobOutput`](crate::output::StartReportJobOutput)
    pub fn builder() -> crate::output::start_report_job_output::Builder {
        crate::output::start_report_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCopyJobOutput {
    /// <p>Uniquely identifies a copy job.</p>
    pub copy_job_id: std::option::Option<std::string::String>,
    /// <p>The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartCopyJobOutput {
    /// <p>Uniquely identifies a copy job.</p>
    pub fn copy_job_id(&self) -> std::option::Option<&str> {
        self.copy_job_id.as_deref()
    }
    /// <p>The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for StartCopyJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCopyJobOutput");
        formatter.field("copy_job_id", &self.copy_job_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`StartCopyJobOutput`](crate::output::StartCopyJobOutput)
pub mod start_copy_job_output {
    /// A builder for [`StartCopyJobOutput`](crate::output::StartCopyJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_job_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Uniquely identifies a copy job.</p>
        pub fn copy_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a copy job.</p>
        pub fn set_copy_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.copy_job_id = input;
            self
        }
        /// <p>The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`StartCopyJobOutput`](crate::output::StartCopyJobOutput)
        pub fn build(self) -> crate::output::StartCopyJobOutput {
            crate::output::StartCopyJobOutput {
                copy_job_id: self.copy_job_id,
                creation_date: self.creation_date,
            }
        }
    }
}
impl StartCopyJobOutput {
    /// Creates a new builder-style object to manufacture [`StartCopyJobOutput`](crate::output::StartCopyJobOutput)
    pub fn builder() -> crate::output::start_copy_job_output::Builder {
        crate::output::start_copy_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBackupJobOutput {
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub backup_job_id: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartBackupJobOutput {
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub fn backup_job_id(&self) -> std::option::Option<&str> {
        self.backup_job_id.as_deref()
    }
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for StartBackupJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBackupJobOutput");
        formatter.field("backup_job_id", &self.backup_job_id);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`StartBackupJobOutput`](crate::output::StartBackupJobOutput)
pub mod start_backup_job_output {
    /// A builder for [`StartBackupJobOutput`](crate::output::StartBackupJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_job_id: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn backup_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn set_backup_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_job_id = input;
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBackupJobOutput`](crate::output::StartBackupJobOutput)
        pub fn build(self) -> crate::output::StartBackupJobOutput {
            crate::output::StartBackupJobOutput {
                backup_job_id: self.backup_job_id,
                recovery_point_arn: self.recovery_point_arn,
                creation_date: self.creation_date,
            }
        }
    }
}
impl StartBackupJobOutput {
    /// Creates a new builder-style object to manufacture [`StartBackupJobOutput`](crate::output::StartBackupJobOutput)
    pub fn builder() -> crate::output::start_backup_job_output::Builder {
        crate::output::start_backup_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupVaultNotificationsOutput {}
impl std::fmt::Debug for PutBackupVaultNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupVaultNotificationsOutput");
        formatter.finish()
    }
}
/// See [`PutBackupVaultNotificationsOutput`](crate::output::PutBackupVaultNotificationsOutput)
pub mod put_backup_vault_notifications_output {
    /// A builder for [`PutBackupVaultNotificationsOutput`](crate::output::PutBackupVaultNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBackupVaultNotificationsOutput`](crate::output::PutBackupVaultNotificationsOutput)
        pub fn build(self) -> crate::output::PutBackupVaultNotificationsOutput {
            crate::output::PutBackupVaultNotificationsOutput {}
        }
    }
}
impl PutBackupVaultNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`PutBackupVaultNotificationsOutput`](crate::output::PutBackupVaultNotificationsOutput)
    pub fn builder() -> crate::output::put_backup_vault_notifications_output::Builder {
        crate::output::put_backup_vault_notifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupVaultLockConfigurationOutput {}
impl std::fmt::Debug for PutBackupVaultLockConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupVaultLockConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBackupVaultLockConfigurationOutput`](crate::output::PutBackupVaultLockConfigurationOutput)
pub mod put_backup_vault_lock_configuration_output {
    /// A builder for [`PutBackupVaultLockConfigurationOutput`](crate::output::PutBackupVaultLockConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBackupVaultLockConfigurationOutput`](crate::output::PutBackupVaultLockConfigurationOutput)
        pub fn build(self) -> crate::output::PutBackupVaultLockConfigurationOutput {
            crate::output::PutBackupVaultLockConfigurationOutput {}
        }
    }
}
impl PutBackupVaultLockConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBackupVaultLockConfigurationOutput`](crate::output::PutBackupVaultLockConfigurationOutput)
    pub fn builder() -> crate::output::put_backup_vault_lock_configuration_output::Builder {
        crate::output::put_backup_vault_lock_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupVaultAccessPolicyOutput {}
impl std::fmt::Debug for PutBackupVaultAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupVaultAccessPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutBackupVaultAccessPolicyOutput`](crate::output::PutBackupVaultAccessPolicyOutput)
pub mod put_backup_vault_access_policy_output {
    /// A builder for [`PutBackupVaultAccessPolicyOutput`](crate::output::PutBackupVaultAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBackupVaultAccessPolicyOutput`](crate::output::PutBackupVaultAccessPolicyOutput)
        pub fn build(self) -> crate::output::PutBackupVaultAccessPolicyOutput {
            crate::output::PutBackupVaultAccessPolicyOutput {}
        }
    }
}
impl PutBackupVaultAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutBackupVaultAccessPolicyOutput`](crate::output::PutBackupVaultAccessPolicyOutput)
    pub fn builder() -> crate::output::put_backup_vault_access_policy_output::Builder {
        crate::output::put_backup_vault_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>To help organize your resources, you can assign your own metadata to the resources you create. Each tag is a key-value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>To help organize your resources, you can assign your own metadata to the resources you create. Each tag is a key-value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>To help organize your resources, you can assign your own metadata to the resources you create. Each tag is a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>To help organize your resources, you can assign your own metadata to the resources you create. Each tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput {
                next_token: self.next_token,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRestoreJobsOutput {
    /// <p>An array of objects that contain detailed information about jobs to restore saved resources.</p>
    pub restore_jobs: std::option::Option<std::vec::Vec<crate::model::RestoreJobsListMember>>,
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRestoreJobsOutput {
    /// <p>An array of objects that contain detailed information about jobs to restore saved resources.</p>
    pub fn restore_jobs(&self) -> std::option::Option<&[crate::model::RestoreJobsListMember]> {
        self.restore_jobs.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRestoreJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRestoreJobsOutput");
        formatter.field("restore_jobs", &self.restore_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRestoreJobsOutput`](crate::output::ListRestoreJobsOutput)
pub mod list_restore_jobs_output {
    /// A builder for [`ListRestoreJobsOutput`](crate::output::ListRestoreJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) restore_jobs:
            std::option::Option<std::vec::Vec<crate::model::RestoreJobsListMember>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `restore_jobs`.
        ///
        /// To override the contents of this collection use [`set_restore_jobs`](Self::set_restore_jobs).
        ///
        /// <p>An array of objects that contain detailed information about jobs to restore saved resources.</p>
        pub fn restore_jobs(mut self, input: crate::model::RestoreJobsListMember) -> Self {
            let mut v = self.restore_jobs.unwrap_or_default();
            v.push(input);
            self.restore_jobs = Some(v);
            self
        }
        /// <p>An array of objects that contain detailed information about jobs to restore saved resources.</p>
        pub fn set_restore_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RestoreJobsListMember>>,
        ) -> Self {
            self.restore_jobs = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRestoreJobsOutput`](crate::output::ListRestoreJobsOutput)
        pub fn build(self) -> crate::output::ListRestoreJobsOutput {
            crate::output::ListRestoreJobsOutput {
                restore_jobs: self.restore_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRestoreJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListRestoreJobsOutput`](crate::output::ListRestoreJobsOutput)
    pub fn builder() -> crate::output::list_restore_jobs_output::Builder {
        crate::output::list_restore_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportPlansOutput {
    /// <p>A list of your report plans with detailed information for each plan. This information includes the Amazon Resource Name (ARN), report plan name, description, settings, delivery channel, deployment status, creation time, and last times the report plan attempted to and successfully ran.</p>
    pub report_plans: std::option::Option<std::vec::Vec<crate::model::ReportPlan>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReportPlansOutput {
    /// <p>A list of your report plans with detailed information for each plan. This information includes the Amazon Resource Name (ARN), report plan name, description, settings, delivery channel, deployment status, creation time, and last times the report plan attempted to and successfully ran.</p>
    pub fn report_plans(&self) -> std::option::Option<&[crate::model::ReportPlan]> {
        self.report_plans.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReportPlansOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportPlansOutput");
        formatter.field("report_plans", &self.report_plans);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListReportPlansOutput`](crate::output::ListReportPlansOutput)
pub mod list_report_plans_output {
    /// A builder for [`ListReportPlansOutput`](crate::output::ListReportPlansOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plans: std::option::Option<std::vec::Vec<crate::model::ReportPlan>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `report_plans`.
        ///
        /// To override the contents of this collection use [`set_report_plans`](Self::set_report_plans).
        ///
        /// <p>A list of your report plans with detailed information for each plan. This information includes the Amazon Resource Name (ARN), report plan name, description, settings, delivery channel, deployment status, creation time, and last times the report plan attempted to and successfully ran.</p>
        pub fn report_plans(mut self, input: crate::model::ReportPlan) -> Self {
            let mut v = self.report_plans.unwrap_or_default();
            v.push(input);
            self.report_plans = Some(v);
            self
        }
        /// <p>A list of your report plans with detailed information for each plan. This information includes the Amazon Resource Name (ARN), report plan name, description, settings, delivery channel, deployment status, creation time, and last times the report plan attempted to and successfully ran.</p>
        pub fn set_report_plans(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportPlan>>,
        ) -> Self {
            self.report_plans = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportPlansOutput`](crate::output::ListReportPlansOutput)
        pub fn build(self) -> crate::output::ListReportPlansOutput {
            crate::output::ListReportPlansOutput {
                report_plans: self.report_plans,
                next_token: self.next_token,
            }
        }
    }
}
impl ListReportPlansOutput {
    /// Creates a new builder-style object to manufacture [`ListReportPlansOutput`](crate::output::ListReportPlansOutput)
    pub fn builder() -> crate::output::list_report_plans_output::Builder {
        crate::output::list_report_plans_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportJobsOutput {
    /// <p>Details about your report jobs in JSON format.</p>
    pub report_jobs: std::option::Option<std::vec::Vec<crate::model::ReportJob>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReportJobsOutput {
    /// <p>Details about your report jobs in JSON format.</p>
    pub fn report_jobs(&self) -> std::option::Option<&[crate::model::ReportJob]> {
        self.report_jobs.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportJobsOutput");
        formatter.field("report_jobs", &self.report_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListReportJobsOutput`](crate::output::ListReportJobsOutput)
pub mod list_report_jobs_output {
    /// A builder for [`ListReportJobsOutput`](crate::output::ListReportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_jobs: std::option::Option<std::vec::Vec<crate::model::ReportJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `report_jobs`.
        ///
        /// To override the contents of this collection use [`set_report_jobs`](Self::set_report_jobs).
        ///
        /// <p>Details about your report jobs in JSON format.</p>
        pub fn report_jobs(mut self, input: crate::model::ReportJob) -> Self {
            let mut v = self.report_jobs.unwrap_or_default();
            v.push(input);
            self.report_jobs = Some(v);
            self
        }
        /// <p>Details about your report jobs in JSON format.</p>
        pub fn set_report_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportJob>>,
        ) -> Self {
            self.report_jobs = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportJobsOutput`](crate::output::ListReportJobsOutput)
        pub fn build(self) -> crate::output::ListReportJobsOutput {
            crate::output::ListReportJobsOutput {
                report_jobs: self.report_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListReportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListReportJobsOutput`](crate::output::ListReportJobsOutput)
    pub fn builder() -> crate::output::list_report_jobs_output::Builder {
        crate::output::list_report_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecoveryPointsByResourceOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of objects that contain detailed information about recovery points of the specified resource type.</p> <note>
    /// <p>Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.</p>
    /// </note>
    pub recovery_points: std::option::Option<std::vec::Vec<crate::model::RecoveryPointByResource>>,
}
impl ListRecoveryPointsByResourceOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of objects that contain detailed information about recovery points of the specified resource type.</p> <note>
    /// <p>Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.</p>
    /// </note>
    pub fn recovery_points(&self) -> std::option::Option<&[crate::model::RecoveryPointByResource]> {
        self.recovery_points.as_deref()
    }
}
impl std::fmt::Debug for ListRecoveryPointsByResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecoveryPointsByResourceOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("recovery_points", &self.recovery_points);
        formatter.finish()
    }
}
/// See [`ListRecoveryPointsByResourceOutput`](crate::output::ListRecoveryPointsByResourceOutput)
pub mod list_recovery_points_by_resource_output {
    /// A builder for [`ListRecoveryPointsByResourceOutput`](crate::output::ListRecoveryPointsByResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recovery_points:
            std::option::Option<std::vec::Vec<crate::model::RecoveryPointByResource>>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `recovery_points`.
        ///
        /// To override the contents of this collection use [`set_recovery_points`](Self::set_recovery_points).
        ///
        /// <p>An array of objects that contain detailed information about recovery points of the specified resource type.</p> <note>
        /// <p>Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.</p>
        /// </note>
        pub fn recovery_points(mut self, input: crate::model::RecoveryPointByResource) -> Self {
            let mut v = self.recovery_points.unwrap_or_default();
            v.push(input);
            self.recovery_points = Some(v);
            self
        }
        /// <p>An array of objects that contain detailed information about recovery points of the specified resource type.</p> <note>
        /// <p>Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.</p>
        /// </note>
        pub fn set_recovery_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecoveryPointByResource>>,
        ) -> Self {
            self.recovery_points = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecoveryPointsByResourceOutput`](crate::output::ListRecoveryPointsByResourceOutput)
        pub fn build(self) -> crate::output::ListRecoveryPointsByResourceOutput {
            crate::output::ListRecoveryPointsByResourceOutput {
                next_token: self.next_token,
                recovery_points: self.recovery_points,
            }
        }
    }
}
impl ListRecoveryPointsByResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListRecoveryPointsByResourceOutput`](crate::output::ListRecoveryPointsByResourceOutput)
    pub fn builder() -> crate::output::list_recovery_points_by_resource_output::Builder {
        crate::output::list_recovery_points_by_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecoveryPointsByBackupVaultOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of objects that contain detailed information about recovery points saved in a backup vault.</p>
    pub recovery_points:
        std::option::Option<std::vec::Vec<crate::model::RecoveryPointByBackupVault>>,
}
impl ListRecoveryPointsByBackupVaultOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of objects that contain detailed information about recovery points saved in a backup vault.</p>
    pub fn recovery_points(
        &self,
    ) -> std::option::Option<&[crate::model::RecoveryPointByBackupVault]> {
        self.recovery_points.as_deref()
    }
}
impl std::fmt::Debug for ListRecoveryPointsByBackupVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecoveryPointsByBackupVaultOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("recovery_points", &self.recovery_points);
        formatter.finish()
    }
}
/// See [`ListRecoveryPointsByBackupVaultOutput`](crate::output::ListRecoveryPointsByBackupVaultOutput)
pub mod list_recovery_points_by_backup_vault_output {
    /// A builder for [`ListRecoveryPointsByBackupVaultOutput`](crate::output::ListRecoveryPointsByBackupVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recovery_points:
            std::option::Option<std::vec::Vec<crate::model::RecoveryPointByBackupVault>>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `recovery_points`.
        ///
        /// To override the contents of this collection use [`set_recovery_points`](Self::set_recovery_points).
        ///
        /// <p>An array of objects that contain detailed information about recovery points saved in a backup vault.</p>
        pub fn recovery_points(mut self, input: crate::model::RecoveryPointByBackupVault) -> Self {
            let mut v = self.recovery_points.unwrap_or_default();
            v.push(input);
            self.recovery_points = Some(v);
            self
        }
        /// <p>An array of objects that contain detailed information about recovery points saved in a backup vault.</p>
        pub fn set_recovery_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecoveryPointByBackupVault>>,
        ) -> Self {
            self.recovery_points = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecoveryPointsByBackupVaultOutput`](crate::output::ListRecoveryPointsByBackupVaultOutput)
        pub fn build(self) -> crate::output::ListRecoveryPointsByBackupVaultOutput {
            crate::output::ListRecoveryPointsByBackupVaultOutput {
                next_token: self.next_token,
                recovery_points: self.recovery_points,
            }
        }
    }
}
impl ListRecoveryPointsByBackupVaultOutput {
    /// Creates a new builder-style object to manufacture [`ListRecoveryPointsByBackupVaultOutput`](crate::output::ListRecoveryPointsByBackupVaultOutput)
    pub fn builder() -> crate::output::list_recovery_points_by_backup_vault_output::Builder {
        crate::output::list_recovery_points_by_backup_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProtectedResourcesOutput {
    /// <p>An array of resources successfully backed up by Backup including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::ProtectedResource>>,
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProtectedResourcesOutput {
    /// <p>An array of resources successfully backed up by Backup including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::ProtectedResource]> {
        self.results.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProtectedResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProtectedResourcesOutput");
        formatter.field("results", &self.results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProtectedResourcesOutput`](crate::output::ListProtectedResourcesOutput)
pub mod list_protected_resources_output {
    /// A builder for [`ListProtectedResourcesOutput`](crate::output::ListProtectedResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::ProtectedResource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>An array of resources successfully backed up by Backup including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>
        pub fn results(mut self, input: crate::model::ProtectedResource) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input);
            self.results = Some(v);
            self
        }
        /// <p>An array of resources successfully backed up by Backup including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProtectedResource>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProtectedResourcesOutput`](crate::output::ListProtectedResourcesOutput)
        pub fn build(self) -> crate::output::ListProtectedResourcesOutput {
            crate::output::ListProtectedResourcesOutput {
                results: self.results,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProtectedResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListProtectedResourcesOutput`](crate::output::ListProtectedResourcesOutput)
    pub fn builder() -> crate::output::list_protected_resources_output::Builder {
        crate::output::list_protected_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFrameworksOutput {
    /// <p>A list of frameworks with details for each framework, including the framework name, Amazon Resource Name (ARN), description, number of controls, creation time, and deployment status.</p>
    pub frameworks: std::option::Option<std::vec::Vec<crate::model::Framework>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFrameworksOutput {
    /// <p>A list of frameworks with details for each framework, including the framework name, Amazon Resource Name (ARN), description, number of controls, creation time, and deployment status.</p>
    pub fn frameworks(&self) -> std::option::Option<&[crate::model::Framework]> {
        self.frameworks.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFrameworksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFrameworksOutput");
        formatter.field("frameworks", &self.frameworks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFrameworksOutput`](crate::output::ListFrameworksOutput)
pub mod list_frameworks_output {
    /// A builder for [`ListFrameworksOutput`](crate::output::ListFrameworksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frameworks: std::option::Option<std::vec::Vec<crate::model::Framework>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `frameworks`.
        ///
        /// To override the contents of this collection use [`set_frameworks`](Self::set_frameworks).
        ///
        /// <p>A list of frameworks with details for each framework, including the framework name, Amazon Resource Name (ARN), description, number of controls, creation time, and deployment status.</p>
        pub fn frameworks(mut self, input: crate::model::Framework) -> Self {
            let mut v = self.frameworks.unwrap_or_default();
            v.push(input);
            self.frameworks = Some(v);
            self
        }
        /// <p>A list of frameworks with details for each framework, including the framework name, Amazon Resource Name (ARN), description, number of controls, creation time, and deployment status.</p>
        pub fn set_frameworks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Framework>>,
        ) -> Self {
            self.frameworks = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFrameworksOutput`](crate::output::ListFrameworksOutput)
        pub fn build(self) -> crate::output::ListFrameworksOutput {
            crate::output::ListFrameworksOutput {
                frameworks: self.frameworks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFrameworksOutput {
    /// Creates a new builder-style object to manufacture [`ListFrameworksOutput`](crate::output::ListFrameworksOutput)
    pub fn builder() -> crate::output::list_frameworks_output::Builder {
        crate::output::list_frameworks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCopyJobsOutput {
    /// <p>An array of structures containing metadata about your copy jobs returned in JSON format. </p>
    pub copy_jobs: std::option::Option<std::vec::Vec<crate::model::CopyJob>>,
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCopyJobsOutput {
    /// <p>An array of structures containing metadata about your copy jobs returned in JSON format. </p>
    pub fn copy_jobs(&self) -> std::option::Option<&[crate::model::CopyJob]> {
        self.copy_jobs.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCopyJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCopyJobsOutput");
        formatter.field("copy_jobs", &self.copy_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCopyJobsOutput`](crate::output::ListCopyJobsOutput)
pub mod list_copy_jobs_output {
    /// A builder for [`ListCopyJobsOutput`](crate::output::ListCopyJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_jobs: std::option::Option<std::vec::Vec<crate::model::CopyJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `copy_jobs`.
        ///
        /// To override the contents of this collection use [`set_copy_jobs`](Self::set_copy_jobs).
        ///
        /// <p>An array of structures containing metadata about your copy jobs returned in JSON format. </p>
        pub fn copy_jobs(mut self, input: crate::model::CopyJob) -> Self {
            let mut v = self.copy_jobs.unwrap_or_default();
            v.push(input);
            self.copy_jobs = Some(v);
            self
        }
        /// <p>An array of structures containing metadata about your copy jobs returned in JSON format. </p>
        pub fn set_copy_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CopyJob>>,
        ) -> Self {
            self.copy_jobs = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCopyJobsOutput`](crate::output::ListCopyJobsOutput)
        pub fn build(self) -> crate::output::ListCopyJobsOutput {
            crate::output::ListCopyJobsOutput {
                copy_jobs: self.copy_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCopyJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListCopyJobsOutput`](crate::output::ListCopyJobsOutput)
    pub fn builder() -> crate::output::list_copy_jobs_output::Builder {
        crate::output::list_copy_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupVaultsOutput {
    /// <p>An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN), display name, creation date, number of saved recovery points, and encryption information if the resources saved in the backup vault are encrypted.</p>
    pub backup_vault_list: std::option::Option<std::vec::Vec<crate::model::BackupVaultListMember>>,
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBackupVaultsOutput {
    /// <p>An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN), display name, creation date, number of saved recovery points, and encryption information if the resources saved in the backup vault are encrypted.</p>
    pub fn backup_vault_list(&self) -> std::option::Option<&[crate::model::BackupVaultListMember]> {
        self.backup_vault_list.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBackupVaultsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupVaultsOutput");
        formatter.field("backup_vault_list", &self.backup_vault_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBackupVaultsOutput`](crate::output::ListBackupVaultsOutput)
pub mod list_backup_vaults_output {
    /// A builder for [`ListBackupVaultsOutput`](crate::output::ListBackupVaultsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_list:
            std::option::Option<std::vec::Vec<crate::model::BackupVaultListMember>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `backup_vault_list`.
        ///
        /// To override the contents of this collection use [`set_backup_vault_list`](Self::set_backup_vault_list).
        ///
        /// <p>An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN), display name, creation date, number of saved recovery points, and encryption information if the resources saved in the backup vault are encrypted.</p>
        pub fn backup_vault_list(mut self, input: crate::model::BackupVaultListMember) -> Self {
            let mut v = self.backup_vault_list.unwrap_or_default();
            v.push(input);
            self.backup_vault_list = Some(v);
            self
        }
        /// <p>An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN), display name, creation date, number of saved recovery points, and encryption information if the resources saved in the backup vault are encrypted.</p>
        pub fn set_backup_vault_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupVaultListMember>>,
        ) -> Self {
            self.backup_vault_list = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupVaultsOutput`](crate::output::ListBackupVaultsOutput)
        pub fn build(self) -> crate::output::ListBackupVaultsOutput {
            crate::output::ListBackupVaultsOutput {
                backup_vault_list: self.backup_vault_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBackupVaultsOutput {
    /// Creates a new builder-style object to manufacture [`ListBackupVaultsOutput`](crate::output::ListBackupVaultsOutput)
    pub fn builder() -> crate::output::list_backup_vaults_output::Builder {
        crate::output::list_backup_vaults_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupSelectionsOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of backup selection list items containing metadata about each resource in the list.</p>
    pub backup_selections_list:
        std::option::Option<std::vec::Vec<crate::model::BackupSelectionsListMember>>,
}
impl ListBackupSelectionsOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of backup selection list items containing metadata about each resource in the list.</p>
    pub fn backup_selections_list(
        &self,
    ) -> std::option::Option<&[crate::model::BackupSelectionsListMember]> {
        self.backup_selections_list.as_deref()
    }
}
impl std::fmt::Debug for ListBackupSelectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupSelectionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("backup_selections_list", &self.backup_selections_list);
        formatter.finish()
    }
}
/// See [`ListBackupSelectionsOutput`](crate::output::ListBackupSelectionsOutput)
pub mod list_backup_selections_output {
    /// A builder for [`ListBackupSelectionsOutput`](crate::output::ListBackupSelectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) backup_selections_list:
            std::option::Option<std::vec::Vec<crate::model::BackupSelectionsListMember>>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `backup_selections_list`.
        ///
        /// To override the contents of this collection use [`set_backup_selections_list`](Self::set_backup_selections_list).
        ///
        /// <p>An array of backup selection list items containing metadata about each resource in the list.</p>
        pub fn backup_selections_list(
            mut self,
            input: crate::model::BackupSelectionsListMember,
        ) -> Self {
            let mut v = self.backup_selections_list.unwrap_or_default();
            v.push(input);
            self.backup_selections_list = Some(v);
            self
        }
        /// <p>An array of backup selection list items containing metadata about each resource in the list.</p>
        pub fn set_backup_selections_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupSelectionsListMember>>,
        ) -> Self {
            self.backup_selections_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupSelectionsOutput`](crate::output::ListBackupSelectionsOutput)
        pub fn build(self) -> crate::output::ListBackupSelectionsOutput {
            crate::output::ListBackupSelectionsOutput {
                next_token: self.next_token,
                backup_selections_list: self.backup_selections_list,
            }
        }
    }
}
impl ListBackupSelectionsOutput {
    /// Creates a new builder-style object to manufacture [`ListBackupSelectionsOutput`](crate::output::ListBackupSelectionsOutput)
    pub fn builder() -> crate::output::list_backup_selections_output::Builder {
        crate::output::list_backup_selections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupPlanVersionsOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of version list items containing metadata about your backup plans.</p>
    pub backup_plan_versions_list:
        std::option::Option<std::vec::Vec<crate::model::BackupPlansListMember>>,
}
impl ListBackupPlanVersionsOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of version list items containing metadata about your backup plans.</p>
    pub fn backup_plan_versions_list(
        &self,
    ) -> std::option::Option<&[crate::model::BackupPlansListMember]> {
        self.backup_plan_versions_list.as_deref()
    }
}
impl std::fmt::Debug for ListBackupPlanVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupPlanVersionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("backup_plan_versions_list", &self.backup_plan_versions_list);
        formatter.finish()
    }
}
/// See [`ListBackupPlanVersionsOutput`](crate::output::ListBackupPlanVersionsOutput)
pub mod list_backup_plan_versions_output {
    /// A builder for [`ListBackupPlanVersionsOutput`](crate::output::ListBackupPlanVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) backup_plan_versions_list:
            std::option::Option<std::vec::Vec<crate::model::BackupPlansListMember>>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `backup_plan_versions_list`.
        ///
        /// To override the contents of this collection use [`set_backup_plan_versions_list`](Self::set_backup_plan_versions_list).
        ///
        /// <p>An array of version list items containing metadata about your backup plans.</p>
        pub fn backup_plan_versions_list(
            mut self,
            input: crate::model::BackupPlansListMember,
        ) -> Self {
            let mut v = self.backup_plan_versions_list.unwrap_or_default();
            v.push(input);
            self.backup_plan_versions_list = Some(v);
            self
        }
        /// <p>An array of version list items containing metadata about your backup plans.</p>
        pub fn set_backup_plan_versions_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupPlansListMember>>,
        ) -> Self {
            self.backup_plan_versions_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupPlanVersionsOutput`](crate::output::ListBackupPlanVersionsOutput)
        pub fn build(self) -> crate::output::ListBackupPlanVersionsOutput {
            crate::output::ListBackupPlanVersionsOutput {
                next_token: self.next_token,
                backup_plan_versions_list: self.backup_plan_versions_list,
            }
        }
    }
}
impl ListBackupPlanVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListBackupPlanVersionsOutput`](crate::output::ListBackupPlanVersionsOutput)
    pub fn builder() -> crate::output::list_backup_plan_versions_output::Builder {
        crate::output::list_backup_plan_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupPlanTemplatesOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of template list items containing metadata about your saved templates.</p>
    pub backup_plan_templates_list:
        std::option::Option<std::vec::Vec<crate::model::BackupPlanTemplatesListMember>>,
}
impl ListBackupPlanTemplatesOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of template list items containing metadata about your saved templates.</p>
    pub fn backup_plan_templates_list(
        &self,
    ) -> std::option::Option<&[crate::model::BackupPlanTemplatesListMember]> {
        self.backup_plan_templates_list.as_deref()
    }
}
impl std::fmt::Debug for ListBackupPlanTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupPlanTemplatesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "backup_plan_templates_list",
            &self.backup_plan_templates_list,
        );
        formatter.finish()
    }
}
/// See [`ListBackupPlanTemplatesOutput`](crate::output::ListBackupPlanTemplatesOutput)
pub mod list_backup_plan_templates_output {
    /// A builder for [`ListBackupPlanTemplatesOutput`](crate::output::ListBackupPlanTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) backup_plan_templates_list:
            std::option::Option<std::vec::Vec<crate::model::BackupPlanTemplatesListMember>>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `backup_plan_templates_list`.
        ///
        /// To override the contents of this collection use [`set_backup_plan_templates_list`](Self::set_backup_plan_templates_list).
        ///
        /// <p>An array of template list items containing metadata about your saved templates.</p>
        pub fn backup_plan_templates_list(
            mut self,
            input: crate::model::BackupPlanTemplatesListMember,
        ) -> Self {
            let mut v = self.backup_plan_templates_list.unwrap_or_default();
            v.push(input);
            self.backup_plan_templates_list = Some(v);
            self
        }
        /// <p>An array of template list items containing metadata about your saved templates.</p>
        pub fn set_backup_plan_templates_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupPlanTemplatesListMember>>,
        ) -> Self {
            self.backup_plan_templates_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupPlanTemplatesOutput`](crate::output::ListBackupPlanTemplatesOutput)
        pub fn build(self) -> crate::output::ListBackupPlanTemplatesOutput {
            crate::output::ListBackupPlanTemplatesOutput {
                next_token: self.next_token,
                backup_plan_templates_list: self.backup_plan_templates_list,
            }
        }
    }
}
impl ListBackupPlanTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListBackupPlanTemplatesOutput`](crate::output::ListBackupPlanTemplatesOutput)
    pub fn builder() -> crate::output::list_backup_plan_templates_output::Builder {
        crate::output::list_backup_plan_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupPlansOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of backup plan list items containing metadata about your saved backup plans.</p>
    pub backup_plans_list: std::option::Option<std::vec::Vec<crate::model::BackupPlansListMember>>,
}
impl ListBackupPlansOutput {
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of backup plan list items containing metadata about your saved backup plans.</p>
    pub fn backup_plans_list(&self) -> std::option::Option<&[crate::model::BackupPlansListMember]> {
        self.backup_plans_list.as_deref()
    }
}
impl std::fmt::Debug for ListBackupPlansOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupPlansOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("backup_plans_list", &self.backup_plans_list);
        formatter.finish()
    }
}
/// See [`ListBackupPlansOutput`](crate::output::ListBackupPlansOutput)
pub mod list_backup_plans_output {
    /// A builder for [`ListBackupPlansOutput`](crate::output::ListBackupPlansOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) backup_plans_list:
            std::option::Option<std::vec::Vec<crate::model::BackupPlansListMember>>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `backup_plans_list`.
        ///
        /// To override the contents of this collection use [`set_backup_plans_list`](Self::set_backup_plans_list).
        ///
        /// <p>An array of backup plan list items containing metadata about your saved backup plans.</p>
        pub fn backup_plans_list(mut self, input: crate::model::BackupPlansListMember) -> Self {
            let mut v = self.backup_plans_list.unwrap_or_default();
            v.push(input);
            self.backup_plans_list = Some(v);
            self
        }
        /// <p>An array of backup plan list items containing metadata about your saved backup plans.</p>
        pub fn set_backup_plans_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupPlansListMember>>,
        ) -> Self {
            self.backup_plans_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupPlansOutput`](crate::output::ListBackupPlansOutput)
        pub fn build(self) -> crate::output::ListBackupPlansOutput {
            crate::output::ListBackupPlansOutput {
                next_token: self.next_token,
                backup_plans_list: self.backup_plans_list,
            }
        }
    }
}
impl ListBackupPlansOutput {
    /// Creates a new builder-style object to manufacture [`ListBackupPlansOutput`](crate::output::ListBackupPlansOutput)
    pub fn builder() -> crate::output::list_backup_plans_output::Builder {
        crate::output::list_backup_plans_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupJobsOutput {
    /// <p>An array of structures containing metadata about your backup jobs returned in JSON format.</p>
    pub backup_jobs: std::option::Option<std::vec::Vec<crate::model::BackupJob>>,
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBackupJobsOutput {
    /// <p>An array of structures containing metadata about your backup jobs returned in JSON format.</p>
    pub fn backup_jobs(&self) -> std::option::Option<&[crate::model::BackupJob]> {
        self.backup_jobs.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBackupJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupJobsOutput");
        formatter.field("backup_jobs", &self.backup_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBackupJobsOutput`](crate::output::ListBackupJobsOutput)
pub mod list_backup_jobs_output {
    /// A builder for [`ListBackupJobsOutput`](crate::output::ListBackupJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_jobs: std::option::Option<std::vec::Vec<crate::model::BackupJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `backup_jobs`.
        ///
        /// To override the contents of this collection use [`set_backup_jobs`](Self::set_backup_jobs).
        ///
        /// <p>An array of structures containing metadata about your backup jobs returned in JSON format.</p>
        pub fn backup_jobs(mut self, input: crate::model::BackupJob) -> Self {
            let mut v = self.backup_jobs.unwrap_or_default();
            v.push(input);
            self.backup_jobs = Some(v);
            self
        }
        /// <p>An array of structures containing metadata about your backup jobs returned in JSON format.</p>
        pub fn set_backup_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupJob>>,
        ) -> Self {
            self.backup_jobs = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupJobsOutput`](crate::output::ListBackupJobsOutput)
        pub fn build(self) -> crate::output::ListBackupJobsOutput {
            crate::output::ListBackupJobsOutput {
                backup_jobs: self.backup_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBackupJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListBackupJobsOutput`](crate::output::ListBackupJobsOutput)
    pub fn builder() -> crate::output::list_backup_jobs_output::Builder {
        crate::output::list_backup_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSupportedResourceTypesOutput {
    /// <p>Contains a string with the supported Amazon Web Services resource types:</p>
    /// <ul>
    /// <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li>
    /// <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li>
    /// <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li>
    /// <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li>
    /// <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li>
    /// <li> <p> <code>FSX</code> for Amazon FSx</p> </li>
    /// <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li>
    /// <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li>
    /// </ul>
    pub resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetSupportedResourceTypesOutput {
    /// <p>Contains a string with the supported Amazon Web Services resource types:</p>
    /// <ul>
    /// <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li>
    /// <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li>
    /// <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li>
    /// <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li>
    /// <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li>
    /// <li> <p> <code>FSX</code> for Amazon FSx</p> </li>
    /// <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li>
    /// <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li>
    /// </ul>
    pub fn resource_types(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_types.as_deref()
    }
}
impl std::fmt::Debug for GetSupportedResourceTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSupportedResourceTypesOutput");
        formatter.field("resource_types", &self.resource_types);
        formatter.finish()
    }
}
/// See [`GetSupportedResourceTypesOutput`](crate::output::GetSupportedResourceTypesOutput)
pub mod get_supported_resource_types_output {
    /// A builder for [`GetSupportedResourceTypesOutput`](crate::output::GetSupportedResourceTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>Contains a string with the supported Amazon Web Services resource types:</p>
        /// <ul>
        /// <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li>
        /// <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li>
        /// <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li>
        /// <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li>
        /// <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li>
        /// <li> <p> <code>FSX</code> for Amazon FSx</p> </li>
        /// <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li>
        /// <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li>
        /// </ul>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>Contains a string with the supported Amazon Web Services resource types:</p>
        /// <ul>
        /// <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li>
        /// <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li>
        /// <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li>
        /// <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li>
        /// <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li>
        /// <li> <p> <code>FSX</code> for Amazon FSx</p> </li>
        /// <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li>
        /// <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li>
        /// </ul>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSupportedResourceTypesOutput`](crate::output::GetSupportedResourceTypesOutput)
        pub fn build(self) -> crate::output::GetSupportedResourceTypesOutput {
            crate::output::GetSupportedResourceTypesOutput {
                resource_types: self.resource_types,
            }
        }
    }
}
impl GetSupportedResourceTypesOutput {
    /// Creates a new builder-style object to manufacture [`GetSupportedResourceTypesOutput`](crate::output::GetSupportedResourceTypesOutput)
    pub fn builder() -> crate::output::get_supported_resource_types_output::Builder {
        crate::output::get_supported_resource_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecoveryPointRestoreMetadataOutput {
    /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These values vary depending on the service that is being restored.</p>
    pub restore_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetRecoveryPointRestoreMetadataOutput {
    /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These values vary depending on the service that is being restored.</p>
    pub fn restore_metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.restore_metadata.as_ref()
    }
}
impl std::fmt::Debug for GetRecoveryPointRestoreMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecoveryPointRestoreMetadataOutput");
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("restore_metadata", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GetRecoveryPointRestoreMetadataOutput`](crate::output::GetRecoveryPointRestoreMetadataOutput)
pub mod get_recovery_point_restore_metadata_output {
    /// A builder for [`GetRecoveryPointRestoreMetadataOutput`](crate::output::GetRecoveryPointRestoreMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) restore_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// Adds a key-value pair to `restore_metadata`.
        ///
        /// To override the contents of this collection use [`set_restore_metadata`](Self::set_restore_metadata).
        ///
        /// <p>The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These values vary depending on the service that is being restored.</p>
        pub fn restore_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.restore_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.restore_metadata = Some(hash_map);
            self
        }
        /// <p>The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These values vary depending on the service that is being restored.</p>
        pub fn set_restore_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.restore_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecoveryPointRestoreMetadataOutput`](crate::output::GetRecoveryPointRestoreMetadataOutput)
        pub fn build(self) -> crate::output::GetRecoveryPointRestoreMetadataOutput {
            crate::output::GetRecoveryPointRestoreMetadataOutput {
                backup_vault_arn: self.backup_vault_arn,
                recovery_point_arn: self.recovery_point_arn,
                restore_metadata: self.restore_metadata,
            }
        }
    }
}
impl GetRecoveryPointRestoreMetadataOutput {
    /// Creates a new builder-style object to manufacture [`GetRecoveryPointRestoreMetadataOutput`](crate::output::GetRecoveryPointRestoreMetadataOutput)
    pub fn builder() -> crate::output::get_recovery_point_restore_metadata_output::Builder {
        crate::output::get_recovery_point_restore_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupVaultNotificationsOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p>
    pub backup_vault_events: std::option::Option<std::vec::Vec<crate::model::BackupVaultEvent>>,
}
impl GetBackupVaultNotificationsOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p>
    pub fn backup_vault_events(&self) -> std::option::Option<&[crate::model::BackupVaultEvent]> {
        self.backup_vault_events.as_deref()
    }
}
impl std::fmt::Debug for GetBackupVaultNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupVaultNotificationsOutput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("backup_vault_events", &self.backup_vault_events);
        formatter.finish()
    }
}
/// See [`GetBackupVaultNotificationsOutput`](crate::output::GetBackupVaultNotificationsOutput)
pub mod get_backup_vault_notifications_output {
    /// A builder for [`GetBackupVaultNotificationsOutput`](crate::output::GetBackupVaultNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) backup_vault_events:
            std::option::Option<std::vec::Vec<crate::model::BackupVaultEvent>>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// Appends an item to `backup_vault_events`.
        ///
        /// To override the contents of this collection use [`set_backup_vault_events`](Self::set_backup_vault_events).
        ///
        /// <p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p>
        pub fn backup_vault_events(mut self, input: crate::model::BackupVaultEvent) -> Self {
            let mut v = self.backup_vault_events.unwrap_or_default();
            v.push(input);
            self.backup_vault_events = Some(v);
            self
        }
        /// <p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p>
        pub fn set_backup_vault_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupVaultEvent>>,
        ) -> Self {
            self.backup_vault_events = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupVaultNotificationsOutput`](crate::output::GetBackupVaultNotificationsOutput)
        pub fn build(self) -> crate::output::GetBackupVaultNotificationsOutput {
            crate::output::GetBackupVaultNotificationsOutput {
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                sns_topic_arn: self.sns_topic_arn,
                backup_vault_events: self.backup_vault_events,
            }
        }
    }
}
impl GetBackupVaultNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`GetBackupVaultNotificationsOutput`](crate::output::GetBackupVaultNotificationsOutput)
    pub fn builder() -> crate::output::get_backup_vault_notifications_output::Builder {
        crate::output::get_backup_vault_notifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupVaultAccessPolicyOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>The backup vault access policy document in JSON format.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetBackupVaultAccessPolicyOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>The backup vault access policy document in JSON format.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetBackupVaultAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupVaultAccessPolicyOutput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetBackupVaultAccessPolicyOutput`](crate::output::GetBackupVaultAccessPolicyOutput)
pub mod get_backup_vault_access_policy_output {
    /// A builder for [`GetBackupVaultAccessPolicyOutput`](crate::output::GetBackupVaultAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>The backup vault access policy document in JSON format.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The backup vault access policy document in JSON format.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupVaultAccessPolicyOutput`](crate::output::GetBackupVaultAccessPolicyOutput)
        pub fn build(self) -> crate::output::GetBackupVaultAccessPolicyOutput {
            crate::output::GetBackupVaultAccessPolicyOutput {
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                policy: self.policy,
            }
        }
    }
}
impl GetBackupVaultAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetBackupVaultAccessPolicyOutput`](crate::output::GetBackupVaultAccessPolicyOutput)
    pub fn builder() -> crate::output::get_backup_vault_access_policy_output::Builder {
        crate::output::get_backup_vault_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupSelectionOutput {
    /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
    pub backup_selection: std::option::Option<crate::model::BackupSelection>,
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
    pub selection_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
}
impl GetBackupSelectionOutput {
    /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
    pub fn backup_selection(&self) -> std::option::Option<&crate::model::BackupSelection> {
        self.backup_selection.as_ref()
    }
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
    pub fn selection_id(&self) -> std::option::Option<&str> {
        self.selection_id.as_deref()
    }
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
}
impl std::fmt::Debug for GetBackupSelectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupSelectionOutput");
        formatter.field("backup_selection", &self.backup_selection);
        formatter.field("selection_id", &self.selection_id);
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.finish()
    }
}
/// See [`GetBackupSelectionOutput`](crate::output::GetBackupSelectionOutput)
pub mod get_backup_selection_output {
    /// A builder for [`GetBackupSelectionOutput`](crate::output::GetBackupSelectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_selection: std::option::Option<crate::model::BackupSelection>,
        pub(crate) selection_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn backup_selection(mut self, input: crate::model::BackupSelection) -> Self {
            self.backup_selection = Some(input);
            self
        }
        /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn set_backup_selection(
            mut self,
            input: std::option::Option<crate::model::BackupSelection>,
        ) -> Self {
            self.backup_selection = input;
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn selection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn set_selection_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.selection_id = input;
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupSelectionOutput`](crate::output::GetBackupSelectionOutput)
        pub fn build(self) -> crate::output::GetBackupSelectionOutput {
            crate::output::GetBackupSelectionOutput {
                backup_selection: self.backup_selection,
                selection_id: self.selection_id,
                backup_plan_id: self.backup_plan_id,
                creation_date: self.creation_date,
                creator_request_id: self.creator_request_id,
            }
        }
    }
}
impl GetBackupSelectionOutput {
    /// Creates a new builder-style object to manufacture [`GetBackupSelectionOutput`](crate::output::GetBackupSelectionOutput)
    pub fn builder() -> crate::output::get_backup_selection_output::Builder {
        crate::output::get_backup_selection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupPlanFromTemplateOutput {
    /// <p>Returns the body of a backup plan based on the target template, including the name, rules, and backup vault of the plan.</p>
    pub backup_plan_document: std::option::Option<crate::model::BackupPlan>,
}
impl GetBackupPlanFromTemplateOutput {
    /// <p>Returns the body of a backup plan based on the target template, including the name, rules, and backup vault of the plan.</p>
    pub fn backup_plan_document(&self) -> std::option::Option<&crate::model::BackupPlan> {
        self.backup_plan_document.as_ref()
    }
}
impl std::fmt::Debug for GetBackupPlanFromTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupPlanFromTemplateOutput");
        formatter.field("backup_plan_document", &self.backup_plan_document);
        formatter.finish()
    }
}
/// See [`GetBackupPlanFromTemplateOutput`](crate::output::GetBackupPlanFromTemplateOutput)
pub mod get_backup_plan_from_template_output {
    /// A builder for [`GetBackupPlanFromTemplateOutput`](crate::output::GetBackupPlanFromTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_document: std::option::Option<crate::model::BackupPlan>,
    }
    impl Builder {
        /// <p>Returns the body of a backup plan based on the target template, including the name, rules, and backup vault of the plan.</p>
        pub fn backup_plan_document(mut self, input: crate::model::BackupPlan) -> Self {
            self.backup_plan_document = Some(input);
            self
        }
        /// <p>Returns the body of a backup plan based on the target template, including the name, rules, and backup vault of the plan.</p>
        pub fn set_backup_plan_document(
            mut self,
            input: std::option::Option<crate::model::BackupPlan>,
        ) -> Self {
            self.backup_plan_document = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupPlanFromTemplateOutput`](crate::output::GetBackupPlanFromTemplateOutput)
        pub fn build(self) -> crate::output::GetBackupPlanFromTemplateOutput {
            crate::output::GetBackupPlanFromTemplateOutput {
                backup_plan_document: self.backup_plan_document,
            }
        }
    }
}
impl GetBackupPlanFromTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetBackupPlanFromTemplateOutput`](crate::output::GetBackupPlanFromTemplateOutput)
    pub fn builder() -> crate::output::get_backup_plan_from_template_output::Builder {
        crate::output::get_backup_plan_from_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupPlanFromJsonOutput {
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
    pub backup_plan: std::option::Option<crate::model::BackupPlan>,
}
impl GetBackupPlanFromJsonOutput {
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
    pub fn backup_plan(&self) -> std::option::Option<&crate::model::BackupPlan> {
        self.backup_plan.as_ref()
    }
}
impl std::fmt::Debug for GetBackupPlanFromJsonOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupPlanFromJsonOutput");
        formatter.field("backup_plan", &self.backup_plan);
        formatter.finish()
    }
}
/// See [`GetBackupPlanFromJsonOutput`](crate::output::GetBackupPlanFromJsonOutput)
pub mod get_backup_plan_from_json_output {
    /// A builder for [`GetBackupPlanFromJsonOutput`](crate::output::GetBackupPlanFromJsonOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan: std::option::Option<crate::model::BackupPlan>,
    }
    impl Builder {
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
        pub fn backup_plan(mut self, input: crate::model::BackupPlan) -> Self {
            self.backup_plan = Some(input);
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
        pub fn set_backup_plan(
            mut self,
            input: std::option::Option<crate::model::BackupPlan>,
        ) -> Self {
            self.backup_plan = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupPlanFromJsonOutput`](crate::output::GetBackupPlanFromJsonOutput)
        pub fn build(self) -> crate::output::GetBackupPlanFromJsonOutput {
            crate::output::GetBackupPlanFromJsonOutput {
                backup_plan: self.backup_plan,
            }
        }
    }
}
impl GetBackupPlanFromJsonOutput {
    /// Creates a new builder-style object to manufacture [`GetBackupPlanFromJsonOutput`](crate::output::GetBackupPlanFromJsonOutput)
    pub fn builder() -> crate::output::get_backup_plan_from_json_output::Builder {
        crate::output::get_backup_plan_from_json_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupPlanOutput {
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
    pub backup_plan: std::option::Option<crate::model::BackupPlan>,
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub backup_plan_arn: std::option::Option<std::string::String>,
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub deletion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time a job to back up resources was run with this backup plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub last_execution_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains a list of <code>BackupOptions</code> for each resource type. The list is populated only if the advanced option is set for the backup plan.</p>
    pub advanced_backup_settings:
        std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
}
impl GetBackupPlanOutput {
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
    pub fn backup_plan(&self) -> std::option::Option<&crate::model::BackupPlan> {
        self.backup_plan.as_ref()
    }
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub fn backup_plan_arn(&self) -> std::option::Option<&str> {
        self.backup_plan_arn.as_deref()
    }
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time that a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn deletion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deletion_date.as_ref()
    }
    /// <p>The last time a job to back up resources was run with this backup plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn last_execution_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_execution_date.as_ref()
    }
    /// <p>Contains a list of <code>BackupOptions</code> for each resource type. The list is populated only if the advanced option is set for the backup plan.</p>
    pub fn advanced_backup_settings(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedBackupSetting]> {
        self.advanced_backup_settings.as_deref()
    }
}
impl std::fmt::Debug for GetBackupPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupPlanOutput");
        formatter.field("backup_plan", &self.backup_plan);
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("backup_plan_arn", &self.backup_plan_arn);
        formatter.field("version_id", &self.version_id);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("deletion_date", &self.deletion_date);
        formatter.field("last_execution_date", &self.last_execution_date);
        formatter.field("advanced_backup_settings", &self.advanced_backup_settings);
        formatter.finish()
    }
}
/// See [`GetBackupPlanOutput`](crate::output::GetBackupPlanOutput)
pub mod get_backup_plan_output {
    /// A builder for [`GetBackupPlanOutput`](crate::output::GetBackupPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan: std::option::Option<crate::model::BackupPlan>,
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_arn: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deletion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_execution_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) advanced_backup_settings:
            std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
    }
    impl Builder {
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
        pub fn backup_plan(mut self, input: crate::model::BackupPlan) -> Self {
            self.backup_plan = Some(input);
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>
        pub fn set_backup_plan(
            mut self,
            input: std::option::Option<crate::model::BackupPlan>,
        ) -> Self {
            self.backup_plan = input;
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn backup_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn set_backup_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_arn = input;
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time that a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn deletion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deletion_date = Some(input);
            self
        }
        /// <p>The date and time that a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deletion_date = input;
            self
        }
        /// <p>The last time a job to back up resources was run with this backup plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn last_execution_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_execution_date = Some(input);
            self
        }
        /// <p>The last time a job to back up resources was run with this backup plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_last_execution_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_execution_date = input;
            self
        }
        /// Appends an item to `advanced_backup_settings`.
        ///
        /// To override the contents of this collection use [`set_advanced_backup_settings`](Self::set_advanced_backup_settings).
        ///
        /// <p>Contains a list of <code>BackupOptions</code> for each resource type. The list is populated only if the advanced option is set for the backup plan.</p>
        pub fn advanced_backup_settings(
            mut self,
            input: crate::model::AdvancedBackupSetting,
        ) -> Self {
            let mut v = self.advanced_backup_settings.unwrap_or_default();
            v.push(input);
            self.advanced_backup_settings = Some(v);
            self
        }
        /// <p>Contains a list of <code>BackupOptions</code> for each resource type. The list is populated only if the advanced option is set for the backup plan.</p>
        pub fn set_advanced_backup_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
        ) -> Self {
            self.advanced_backup_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupPlanOutput`](crate::output::GetBackupPlanOutput)
        pub fn build(self) -> crate::output::GetBackupPlanOutput {
            crate::output::GetBackupPlanOutput {
                backup_plan: self.backup_plan,
                backup_plan_id: self.backup_plan_id,
                backup_plan_arn: self.backup_plan_arn,
                version_id: self.version_id,
                creator_request_id: self.creator_request_id,
                creation_date: self.creation_date,
                deletion_date: self.deletion_date,
                last_execution_date: self.last_execution_date,
                advanced_backup_settings: self.advanced_backup_settings,
            }
        }
    }
}
impl GetBackupPlanOutput {
    /// Creates a new builder-style object to manufacture [`GetBackupPlanOutput`](crate::output::GetBackupPlanOutput)
    pub fn builder() -> crate::output::get_backup_plan_output::Builder {
        crate::output::get_backup_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportBackupPlanTemplateOutput {
    /// <p>The body of a backup plan template in JSON format.</p> <note>
    /// <p>This is a signed JSON document that cannot be modified before being passed to <code>GetBackupPlanFromJSON.</code> </p>
    /// </note>
    pub backup_plan_template_json: std::option::Option<std::string::String>,
}
impl ExportBackupPlanTemplateOutput {
    /// <p>The body of a backup plan template in JSON format.</p> <note>
    /// <p>This is a signed JSON document that cannot be modified before being passed to <code>GetBackupPlanFromJSON.</code> </p>
    /// </note>
    pub fn backup_plan_template_json(&self) -> std::option::Option<&str> {
        self.backup_plan_template_json.as_deref()
    }
}
impl std::fmt::Debug for ExportBackupPlanTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportBackupPlanTemplateOutput");
        formatter.field("backup_plan_template_json", &self.backup_plan_template_json);
        formatter.finish()
    }
}
/// See [`ExportBackupPlanTemplateOutput`](crate::output::ExportBackupPlanTemplateOutput)
pub mod export_backup_plan_template_output {
    /// A builder for [`ExportBackupPlanTemplateOutput`](crate::output::ExportBackupPlanTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_template_json: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The body of a backup plan template in JSON format.</p> <note>
        /// <p>This is a signed JSON document that cannot be modified before being passed to <code>GetBackupPlanFromJSON.</code> </p>
        /// </note>
        pub fn backup_plan_template_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_template_json = Some(input.into());
            self
        }
        /// <p>The body of a backup plan template in JSON format.</p> <note>
        /// <p>This is a signed JSON document that cannot be modified before being passed to <code>GetBackupPlanFromJSON.</code> </p>
        /// </note>
        pub fn set_backup_plan_template_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_template_json = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportBackupPlanTemplateOutput`](crate::output::ExportBackupPlanTemplateOutput)
        pub fn build(self) -> crate::output::ExportBackupPlanTemplateOutput {
            crate::output::ExportBackupPlanTemplateOutput {
                backup_plan_template_json: self.backup_plan_template_json,
            }
        }
    }
}
impl ExportBackupPlanTemplateOutput {
    /// Creates a new builder-style object to manufacture [`ExportBackupPlanTemplateOutput`](crate::output::ExportBackupPlanTemplateOutput)
    pub fn builder() -> crate::output::export_backup_plan_template_output::Builder {
        crate::output::export_backup_plan_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateRecoveryPointOutput {}
impl std::fmt::Debug for DisassociateRecoveryPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateRecoveryPointOutput");
        formatter.finish()
    }
}
/// See [`DisassociateRecoveryPointOutput`](crate::output::DisassociateRecoveryPointOutput)
pub mod disassociate_recovery_point_output {
    /// A builder for [`DisassociateRecoveryPointOutput`](crate::output::DisassociateRecoveryPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateRecoveryPointOutput`](crate::output::DisassociateRecoveryPointOutput)
        pub fn build(self) -> crate::output::DisassociateRecoveryPointOutput {
            crate::output::DisassociateRecoveryPointOutput {}
        }
    }
}
impl DisassociateRecoveryPointOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateRecoveryPointOutput`](crate::output::DisassociateRecoveryPointOutput)
    pub fn builder() -> crate::output::disassociate_recovery_point_output::Builder {
        crate::output::disassociate_recovery_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRestoreJobOutput {
    /// <p>Returns the account ID that owns the restore job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub restore_job_id: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Status code specifying the state of the job that is initiated by Backup to restore a recovery point.</p>
    pub status: std::option::Option<crate::model::RestoreJobStatus>,
    /// <p>A message showing the status of a job to restore a recovery point.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
    pub percent_done: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the restored resource.</p>
    pub backup_size_in_bytes: std::option::Option<i64>,
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>
    pub expected_completion_time_minutes: std::option::Option<i64>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.</p>
    pub created_resource_arn: std::option::Option<std::string::String>,
    /// <p>Returns metadata associated with a restore job listed by resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl DescribeRestoreJobOutput {
    /// <p>Returns the account ID that owns the restore job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub fn restore_job_id(&self) -> std::option::Option<&str> {
        self.restore_job_id.as_deref()
    }
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>Status code specifying the state of the job that is initiated by Backup to restore a recovery point.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RestoreJobStatus> {
        self.status.as_ref()
    }
    /// <p>A message showing the status of a job to restore a recovery point.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
    pub fn percent_done(&self) -> std::option::Option<&str> {
        self.percent_done.as_deref()
    }
    /// <p>The size, in bytes, of the restored resource.</p>
    pub fn backup_size_in_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_in_bytes
    }
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>
    pub fn expected_completion_time_minutes(&self) -> std::option::Option<i64> {
        self.expected_completion_time_minutes
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.</p>
    pub fn created_resource_arn(&self) -> std::option::Option<&str> {
        self.created_resource_arn.as_deref()
    }
    /// <p>Returns metadata associated with a restore job listed by resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for DescribeRestoreJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRestoreJobOutput");
        formatter.field("account_id", &self.account_id);
        formatter.field("restore_job_id", &self.restore_job_id);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("percent_done", &self.percent_done);
        formatter.field("backup_size_in_bytes", &self.backup_size_in_bytes);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field(
            "expected_completion_time_minutes",
            &self.expected_completion_time_minutes,
        );
        formatter.field("created_resource_arn", &self.created_resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`DescribeRestoreJobOutput`](crate::output::DescribeRestoreJobOutput)
pub mod describe_restore_job_output {
    /// A builder for [`DescribeRestoreJobOutput`](crate::output::DescribeRestoreJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) restore_job_id: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::RestoreJobStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) percent_done: std::option::Option<std::string::String>,
        pub(crate) backup_size_in_bytes: std::option::Option<i64>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) expected_completion_time_minutes: std::option::Option<i64>,
        pub(crate) created_resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the account ID that owns the restore job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Returns the account ID that owns the restore job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn restore_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn set_restore_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.restore_job_id = input;
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>Status code specifying the state of the job that is initiated by Backup to restore a recovery point.</p>
        pub fn status(mut self, input: crate::model::RestoreJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status code specifying the state of the job that is initiated by Backup to restore a recovery point.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RestoreJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message showing the status of a job to restore a recovery point.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message showing the status of a job to restore a recovery point.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
        pub fn percent_done(mut self, input: impl Into<std::string::String>) -> Self {
            self.percent_done = Some(input.into());
            self
        }
        /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
        pub fn set_percent_done(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.percent_done = input;
            self
        }
        /// <p>The size, in bytes, of the restored resource.</p>
        pub fn backup_size_in_bytes(mut self, input: i64) -> Self {
            self.backup_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the restored resource.</p>
        pub fn set_backup_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_in_bytes = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>
        pub fn expected_completion_time_minutes(mut self, input: i64) -> Self {
            self.expected_completion_time_minutes = Some(input);
            self
        }
        /// <p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>
        pub fn set_expected_completion_time_minutes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.expected_completion_time_minutes = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.</p>
        pub fn created_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.</p>
        pub fn set_created_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_resource_arn = input;
            self
        }
        /// <p>Returns metadata associated with a restore job listed by resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Returns metadata associated with a restore job listed by resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRestoreJobOutput`](crate::output::DescribeRestoreJobOutput)
        pub fn build(self) -> crate::output::DescribeRestoreJobOutput {
            crate::output::DescribeRestoreJobOutput {
                account_id: self.account_id,
                restore_job_id: self.restore_job_id,
                recovery_point_arn: self.recovery_point_arn,
                creation_date: self.creation_date,
                completion_date: self.completion_date,
                status: self.status,
                status_message: self.status_message,
                percent_done: self.percent_done,
                backup_size_in_bytes: self.backup_size_in_bytes,
                iam_role_arn: self.iam_role_arn,
                expected_completion_time_minutes: self.expected_completion_time_minutes,
                created_resource_arn: self.created_resource_arn,
                resource_type: self.resource_type,
            }
        }
    }
}
impl DescribeRestoreJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRestoreJobOutput`](crate::output::DescribeRestoreJobOutput)
    pub fn builder() -> crate::output::describe_restore_job_output::Builder {
        crate::output::describe_restore_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReportPlanOutput {
    /// <p>Returns details about the report plan that is specified by its name. These details include the report plan's Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and last attempted and successful run times.</p>
    pub report_plan: std::option::Option<crate::model::ReportPlan>,
}
impl DescribeReportPlanOutput {
    /// <p>Returns details about the report plan that is specified by its name. These details include the report plan's Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and last attempted and successful run times.</p>
    pub fn report_plan(&self) -> std::option::Option<&crate::model::ReportPlan> {
        self.report_plan.as_ref()
    }
}
impl std::fmt::Debug for DescribeReportPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReportPlanOutput");
        formatter.field("report_plan", &self.report_plan);
        formatter.finish()
    }
}
/// See [`DescribeReportPlanOutput`](crate::output::DescribeReportPlanOutput)
pub mod describe_report_plan_output {
    /// A builder for [`DescribeReportPlanOutput`](crate::output::DescribeReportPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan: std::option::Option<crate::model::ReportPlan>,
    }
    impl Builder {
        /// <p>Returns details about the report plan that is specified by its name. These details include the report plan's Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and last attempted and successful run times.</p>
        pub fn report_plan(mut self, input: crate::model::ReportPlan) -> Self {
            self.report_plan = Some(input);
            self
        }
        /// <p>Returns details about the report plan that is specified by its name. These details include the report plan's Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and last attempted and successful run times.</p>
        pub fn set_report_plan(
            mut self,
            input: std::option::Option<crate::model::ReportPlan>,
        ) -> Self {
            self.report_plan = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReportPlanOutput`](crate::output::DescribeReportPlanOutput)
        pub fn build(self) -> crate::output::DescribeReportPlanOutput {
            crate::output::DescribeReportPlanOutput {
                report_plan: self.report_plan,
            }
        }
    }
}
impl DescribeReportPlanOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReportPlanOutput`](crate::output::DescribeReportPlanOutput)
    pub fn builder() -> crate::output::describe_report_plan_output::Builder {
        crate::output::describe_report_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReportJobOutput {
    /// <p>A list of information about a report job, including its completion and creation times, report destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.</p>
    pub report_job: std::option::Option<crate::model::ReportJob>,
}
impl DescribeReportJobOutput {
    /// <p>A list of information about a report job, including its completion and creation times, report destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.</p>
    pub fn report_job(&self) -> std::option::Option<&crate::model::ReportJob> {
        self.report_job.as_ref()
    }
}
impl std::fmt::Debug for DescribeReportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReportJobOutput");
        formatter.field("report_job", &self.report_job);
        formatter.finish()
    }
}
/// See [`DescribeReportJobOutput`](crate::output::DescribeReportJobOutput)
pub mod describe_report_job_output {
    /// A builder for [`DescribeReportJobOutput`](crate::output::DescribeReportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_job: std::option::Option<crate::model::ReportJob>,
    }
    impl Builder {
        /// <p>A list of information about a report job, including its completion and creation times, report destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.</p>
        pub fn report_job(mut self, input: crate::model::ReportJob) -> Self {
            self.report_job = Some(input);
            self
        }
        /// <p>A list of information about a report job, including its completion and creation times, report destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.</p>
        pub fn set_report_job(
            mut self,
            input: std::option::Option<crate::model::ReportJob>,
        ) -> Self {
            self.report_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReportJobOutput`](crate::output::DescribeReportJobOutput)
        pub fn build(self) -> crate::output::DescribeReportJobOutput {
            crate::output::DescribeReportJobOutput {
                report_job: self.report_job,
            }
        }
    }
}
impl DescribeReportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReportJobOutput`](crate::output::DescribeReportJobOutput)
    pub fn builder() -> crate::output::describe_report_job_output::Builder {
        crate::output::describe_report_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegionSettingsOutput {
    /// <p>Returns a list of all services along with the opt-in preferences in the Region.</p>
    pub resource_type_opt_in_preference:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>Returns whether a DynamoDB recovery point was taken using <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's advanced DynamoDB backup features</a>. </p>
    pub resource_type_management_preference:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
}
impl DescribeRegionSettingsOutput {
    /// <p>Returns a list of all services along with the opt-in preferences in the Region.</p>
    pub fn resource_type_opt_in_preference(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.resource_type_opt_in_preference.as_ref()
    }
    /// <p>Returns whether a DynamoDB recovery point was taken using <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's advanced DynamoDB backup features</a>. </p>
    pub fn resource_type_management_preference(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.resource_type_management_preference.as_ref()
    }
}
impl std::fmt::Debug for DescribeRegionSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegionSettingsOutput");
        formatter.field(
            "resource_type_opt_in_preference",
            &self.resource_type_opt_in_preference,
        );
        formatter.field(
            "resource_type_management_preference",
            &self.resource_type_management_preference,
        );
        formatter.finish()
    }
}
/// See [`DescribeRegionSettingsOutput`](crate::output::DescribeRegionSettingsOutput)
pub mod describe_region_settings_output {
    /// A builder for [`DescribeRegionSettingsOutput`](crate::output::DescribeRegionSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type_opt_in_preference:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) resource_type_management_preference:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    }
    impl Builder {
        /// Adds a key-value pair to `resource_type_opt_in_preference`.
        ///
        /// To override the contents of this collection use [`set_resource_type_opt_in_preference`](Self::set_resource_type_opt_in_preference).
        ///
        /// <p>Returns a list of all services along with the opt-in preferences in the Region.</p>
        pub fn resource_type_opt_in_preference(
            mut self,
            k: impl Into<std::string::String>,
            v: bool,
        ) -> Self {
            let mut hash_map = self.resource_type_opt_in_preference.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.resource_type_opt_in_preference = Some(hash_map);
            self
        }
        /// <p>Returns a list of all services along with the opt-in preferences in the Region.</p>
        pub fn set_resource_type_opt_in_preference(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.resource_type_opt_in_preference = input;
            self
        }
        /// Adds a key-value pair to `resource_type_management_preference`.
        ///
        /// To override the contents of this collection use [`set_resource_type_management_preference`](Self::set_resource_type_management_preference).
        ///
        /// <p>Returns whether a DynamoDB recovery point was taken using <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's advanced DynamoDB backup features</a>. </p>
        pub fn resource_type_management_preference(
            mut self,
            k: impl Into<std::string::String>,
            v: bool,
        ) -> Self {
            let mut hash_map = self.resource_type_management_preference.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.resource_type_management_preference = Some(hash_map);
            self
        }
        /// <p>Returns whether a DynamoDB recovery point was taken using <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's advanced DynamoDB backup features</a>. </p>
        pub fn set_resource_type_management_preference(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.resource_type_management_preference = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegionSettingsOutput`](crate::output::DescribeRegionSettingsOutput)
        pub fn build(self) -> crate::output::DescribeRegionSettingsOutput {
            crate::output::DescribeRegionSettingsOutput {
                resource_type_opt_in_preference: self.resource_type_opt_in_preference,
                resource_type_management_preference: self.resource_type_management_preference,
            }
        }
    }
}
impl DescribeRegionSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRegionSettingsOutput`](crate::output::DescribeRegionSettingsOutput)
    pub fn builder() -> crate::output::describe_region_settings_output::Builder {
        crate::output::describe_region_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoveryPointOutput {
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.</p>
    pub source_backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>
    pub created_by: std::option::Option<crate::model::RecoveryPointCreator>,
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A status code specifying the state of the recovery point.</p>
    /// <p> <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and editing your backup plan.</p>
    /// <p> <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.</p>
    pub status: std::option::Option<crate::model::RecoveryPointStatus>,
    /// <p>A status message explaining the reason for the recovery point deletion failure.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The size, in bytes, of a backup.</p>
    pub backup_size_in_bytes: std::option::Option<i64>,
    /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
    pub calculated_lifecycle: std::option::Option<crate::model::CalculatedLifecycle>,
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
    /// <p>Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
    /// <p>The server-side encryption key used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
    pub is_encrypted: bool,
    /// <p>Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub last_restore_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeRecoveryPointOutput {
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.</p>
    pub fn source_backup_vault_arn(&self) -> std::option::Option<&str> {
        self.source_backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::RecoveryPointCreator> {
        self.created_by.as_ref()
    }
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>A status code specifying the state of the recovery point.</p>
    /// <p> <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and editing your backup plan.</p>
    /// <p> <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RecoveryPointStatus> {
        self.status.as_ref()
    }
    /// <p>A status message explaining the reason for the recovery point deletion failure.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>The size, in bytes, of a backup.</p>
    pub fn backup_size_in_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_in_bytes
    }
    /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
    pub fn calculated_lifecycle(&self) -> std::option::Option<&crate::model::CalculatedLifecycle> {
        self.calculated_lifecycle.as_ref()
    }
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
    /// <p>Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The server-side encryption key used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
    pub fn is_encrypted(&self) -> bool {
        self.is_encrypted
    }
    /// <p>Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn last_restore_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_restore_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeRecoveryPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoveryPointOutput");
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("source_backup_vault_arn", &self.source_backup_vault_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("created_by", &self.created_by);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("backup_size_in_bytes", &self.backup_size_in_bytes);
        formatter.field("calculated_lifecycle", &self.calculated_lifecycle);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("is_encrypted", &self.is_encrypted);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("last_restore_time", &self.last_restore_time);
        formatter.finish()
    }
}
/// See [`DescribeRecoveryPointOutput`](crate::output::DescribeRecoveryPointOutput)
pub mod describe_recovery_point_output {
    /// A builder for [`DescribeRecoveryPointOutput`](crate::output::DescribeRecoveryPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) source_backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::RecoveryPointCreator>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RecoveryPointStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) backup_size_in_bytes: std::option::Option<i64>,
        pub(crate) calculated_lifecycle: std::option::Option<crate::model::CalculatedLifecycle>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) is_encrypted: std::option::Option<bool>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) last_restore_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.</p>
        pub fn source_backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.</p>
        pub fn set_source_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>
        pub fn created_by(mut self, input: crate::model::RecoveryPointCreator) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointCreator>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>A status code specifying the state of the recovery point.</p>
        /// <p> <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and editing your backup plan.</p>
        /// <p> <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.</p>
        pub fn status(mut self, input: crate::model::RecoveryPointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A status code specifying the state of the recovery point.</p>
        /// <p> <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and editing your backup plan.</p>
        /// <p> <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A status message explaining the reason for the recovery point deletion failure.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A status message explaining the reason for the recovery point deletion failure.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn backup_size_in_bytes(mut self, input: i64) -> Self {
            self.backup_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn set_backup_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_in_bytes = input;
            self
        }
        /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
        pub fn calculated_lifecycle(mut self, input: crate::model::CalculatedLifecycle) -> Self {
            self.calculated_lifecycle = Some(input);
            self
        }
        /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>
        pub fn set_calculated_lifecycle(
            mut self,
            input: std::option::Option<crate::model::CalculatedLifecycle>,
        ) -> Self {
            self.calculated_lifecycle = input;
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
        /// <p>Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
        /// <p>Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The server-side encryption key used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The server-side encryption key used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
        pub fn is_encrypted(mut self, input: bool) -> Self {
            self.is_encrypted = Some(input);
            self
        }
        /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
        pub fn set_is_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.is_encrypted = input;
            self
        }
        /// <p>Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn last_restore_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_restore_time = Some(input);
            self
        }
        /// <p>The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_last_restore_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_restore_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoveryPointOutput`](crate::output::DescribeRecoveryPointOutput)
        pub fn build(self) -> crate::output::DescribeRecoveryPointOutput {
            crate::output::DescribeRecoveryPointOutput {
                recovery_point_arn: self.recovery_point_arn,
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                source_backup_vault_arn: self.source_backup_vault_arn,
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                created_by: self.created_by,
                iam_role_arn: self.iam_role_arn,
                status: self.status,
                status_message: self.status_message,
                creation_date: self.creation_date,
                completion_date: self.completion_date,
                backup_size_in_bytes: self.backup_size_in_bytes,
                calculated_lifecycle: self.calculated_lifecycle,
                lifecycle: self.lifecycle,
                encryption_key_arn: self.encryption_key_arn,
                is_encrypted: self.is_encrypted.unwrap_or_default(),
                storage_class: self.storage_class,
                last_restore_time: self.last_restore_time,
            }
        }
    }
}
impl DescribeRecoveryPointOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecoveryPointOutput`](crate::output::DescribeRecoveryPointOutput)
    pub fn builder() -> crate::output::describe_recovery_point_output::Builder {
        crate::output::describe_recovery_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProtectedResourceOutput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an Amazon RDS database.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub last_backup_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeProtectedResourceOutput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an Amazon RDS database.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn last_backup_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_backup_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeProtectedResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProtectedResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("last_backup_time", &self.last_backup_time);
        formatter.finish()
    }
}
/// See [`DescribeProtectedResourceOutput`](crate::output::DescribeProtectedResourceOutput)
pub mod describe_protected_resource_output {
    /// A builder for [`DescribeProtectedResourceOutput`](crate::output::DescribeProtectedResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) last_backup_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an Amazon RDS database.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an Amazon RDS database.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn last_backup_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_backup_time = Some(input);
            self
        }
        /// <p>The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_last_backup_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_backup_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProtectedResourceOutput`](crate::output::DescribeProtectedResourceOutput)
        pub fn build(self) -> crate::output::DescribeProtectedResourceOutput {
            crate::output::DescribeProtectedResourceOutput {
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                last_backup_time: self.last_backup_time,
            }
        }
    }
}
impl DescribeProtectedResourceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProtectedResourceOutput`](crate::output::DescribeProtectedResourceOutput)
    pub fn builder() -> crate::output::describe_protected_resource_output::Builder {
        crate::output::describe_protected_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalSettingsOutput {
    /// <p>The status of the flag <code>isCrossAccountBackupEnabled</code>.</p>
    pub global_settings:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time that the flag <code>isCrossAccountBackupEnabled</code> was last updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeGlobalSettingsOutput {
    /// <p>The status of the flag <code>isCrossAccountBackupEnabled</code>.</p>
    pub fn global_settings(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.global_settings.as_ref()
    }
    /// <p>The date and time that the flag <code>isCrossAccountBackupEnabled</code> was last updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeGlobalSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalSettingsOutput");
        formatter.field("global_settings", &self.global_settings);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`DescribeGlobalSettingsOutput`](crate::output::DescribeGlobalSettingsOutput)
pub mod describe_global_settings_output {
    /// A builder for [`DescribeGlobalSettingsOutput`](crate::output::DescribeGlobalSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_settings: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// Adds a key-value pair to `global_settings`.
        ///
        /// To override the contents of this collection use [`set_global_settings`](Self::set_global_settings).
        ///
        /// <p>The status of the flag <code>isCrossAccountBackupEnabled</code>.</p>
        pub fn global_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.global_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.global_settings = Some(hash_map);
            self
        }
        /// <p>The status of the flag <code>isCrossAccountBackupEnabled</code>.</p>
        pub fn set_global_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.global_settings = input;
            self
        }
        /// <p>The date and time that the flag <code>isCrossAccountBackupEnabled</code> was last updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The date and time that the flag <code>isCrossAccountBackupEnabled</code> was last updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalSettingsOutput`](crate::output::DescribeGlobalSettingsOutput)
        pub fn build(self) -> crate::output::DescribeGlobalSettingsOutput {
            crate::output::DescribeGlobalSettingsOutput {
                global_settings: self.global_settings,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl DescribeGlobalSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalSettingsOutput`](crate::output::DescribeGlobalSettingsOutput)
    pub fn builder() -> crate::output::describe_global_settings_output::Builder {
        crate::output::describe_global_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFrameworkOutput {
    /// <p>The unique name of a framework.</p>
    pub framework_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub framework_arn: std::option::Option<std::string::String>,
    /// <p>An optional description of the framework.</p>
    pub framework_description: std::option::Option<std::string::String>,
    /// <p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>
    pub framework_controls: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
    /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The deployment status of a framework. The statuses are:</p>
    /// <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>
    pub deployment_status: std::option::Option<std::string::String>,
    /// <p>A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for each resource. The statuses are:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.</p> </li>
    /// <li> <p> <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the framework.</p> </li>
    /// <li> <p> <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.</p> </li>
    /// <li> <p> <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.</p> </li>
    /// </ul>
    pub framework_status: std::option::Option<std::string::String>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl DescribeFrameworkOutput {
    /// <p>The unique name of a framework.</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub fn framework_arn(&self) -> std::option::Option<&str> {
        self.framework_arn.as_deref()
    }
    /// <p>An optional description of the framework.</p>
    pub fn framework_description(&self) -> std::option::Option<&str> {
        self.framework_description.as_deref()
    }
    /// <p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>
    pub fn framework_controls(&self) -> std::option::Option<&[crate::model::FrameworkControl]> {
        self.framework_controls.as_deref()
    }
    /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The deployment status of a framework. The statuses are:</p>
    /// <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>
    pub fn deployment_status(&self) -> std::option::Option<&str> {
        self.deployment_status.as_deref()
    }
    /// <p>A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for each resource. The statuses are:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.</p> </li>
    /// <li> <p> <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the framework.</p> </li>
    /// <li> <p> <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.</p> </li>
    /// <li> <p> <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.</p> </li>
    /// </ul>
    pub fn framework_status(&self) -> std::option::Option<&str> {
        self.framework_status.as_deref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFrameworkOutput");
        formatter.field("framework_name", &self.framework_name);
        formatter.field("framework_arn", &self.framework_arn);
        formatter.field("framework_description", &self.framework_description);
        formatter.field("framework_controls", &self.framework_controls);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("framework_status", &self.framework_status);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}
/// See [`DescribeFrameworkOutput`](crate::output::DescribeFrameworkOutput)
pub mod describe_framework_output {
    /// A builder for [`DescribeFrameworkOutput`](crate::output::DescribeFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
        pub(crate) framework_arn: std::option::Option<std::string::String>,
        pub(crate) framework_description: std::option::Option<std::string::String>,
        pub(crate) framework_controls:
            std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_status: std::option::Option<std::string::String>,
        pub(crate) framework_status: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a framework.</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of a framework.</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn framework_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn set_framework_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_arn = input;
            self
        }
        /// <p>An optional description of the framework.</p>
        pub fn framework_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_description = Some(input.into());
            self
        }
        /// <p>An optional description of the framework.</p>
        pub fn set_framework_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_description = input;
            self
        }
        /// Appends an item to `framework_controls`.
        ///
        /// To override the contents of this collection use [`set_framework_controls`](Self::set_framework_controls).
        ///
        /// <p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>
        pub fn framework_controls(mut self, input: crate::model::FrameworkControl) -> Self {
            let mut v = self.framework_controls.unwrap_or_default();
            v.push(input);
            self.framework_controls = Some(v);
            self
        }
        /// <p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>
        pub fn set_framework_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        ) -> Self {
            self.framework_controls = input;
            self
        }
        /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The deployment status of a framework. The statuses are:</p>
        /// <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>
        pub fn deployment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status = Some(input.into());
            self
        }
        /// <p>The deployment status of a framework. The statuses are:</p>
        /// <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for each resource. The statuses are:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.</p> </li>
        /// <li> <p> <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the framework.</p> </li>
        /// <li> <p> <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.</p> </li>
        /// <li> <p> <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.</p> </li>
        /// </ul>
        pub fn framework_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_status = Some(input.into());
            self
        }
        /// <p>A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for each resource. The statuses are:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.</p> </li>
        /// <li> <p> <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the framework.</p> </li>
        /// <li> <p> <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.</p> </li>
        /// <li> <p> <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.</p> </li>
        /// </ul>
        pub fn set_framework_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_status = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFrameworkOutput`](crate::output::DescribeFrameworkOutput)
        pub fn build(self) -> crate::output::DescribeFrameworkOutput {
            crate::output::DescribeFrameworkOutput {
                framework_name: self.framework_name,
                framework_arn: self.framework_arn,
                framework_description: self.framework_description,
                framework_controls: self.framework_controls,
                creation_time: self.creation_time,
                deployment_status: self.deployment_status,
                framework_status: self.framework_status,
                idempotency_token: self.idempotency_token,
            }
        }
    }
}
impl DescribeFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFrameworkOutput`](crate::output::DescribeFrameworkOutput)
    pub fn builder() -> crate::output::describe_framework_output::Builder {
        crate::output::describe_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCopyJobOutput {
    /// <p>Contains detailed information about a copy job.</p>
    pub copy_job: std::option::Option<crate::model::CopyJob>,
}
impl DescribeCopyJobOutput {
    /// <p>Contains detailed information about a copy job.</p>
    pub fn copy_job(&self) -> std::option::Option<&crate::model::CopyJob> {
        self.copy_job.as_ref()
    }
}
impl std::fmt::Debug for DescribeCopyJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCopyJobOutput");
        formatter.field("copy_job", &self.copy_job);
        formatter.finish()
    }
}
/// See [`DescribeCopyJobOutput`](crate::output::DescribeCopyJobOutput)
pub mod describe_copy_job_output {
    /// A builder for [`DescribeCopyJobOutput`](crate::output::DescribeCopyJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_job: std::option::Option<crate::model::CopyJob>,
    }
    impl Builder {
        /// <p>Contains detailed information about a copy job.</p>
        pub fn copy_job(mut self, input: crate::model::CopyJob) -> Self {
            self.copy_job = Some(input);
            self
        }
        /// <p>Contains detailed information about a copy job.</p>
        pub fn set_copy_job(mut self, input: std::option::Option<crate::model::CopyJob>) -> Self {
            self.copy_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCopyJobOutput`](crate::output::DescribeCopyJobOutput)
        pub fn build(self) -> crate::output::DescribeCopyJobOutput {
            crate::output::DescribeCopyJobOutput {
                copy_job: self.copy_job,
            }
        }
    }
}
impl DescribeCopyJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCopyJobOutput`](crate::output::DescribeCopyJobOutput)
    pub fn builder() -> crate::output::describe_copy_job_output::Builder {
        crate::output::describe_copy_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupVaultOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The number of recovery points that are stored in a backup vault.</p>
    pub number_of_recovery_points: i64,
    /// <p>A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. <code>True</code> means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.</p>
    pub locked: std::option::Option<bool>,
    /// <p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
    pub min_retention_days: std::option::Option<i64>,
    /// <p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
    pub max_retention_days: std::option::Option<i64>,
    /// <p>The date and time when Backup Vault Lock configuration cannot be changed or deleted.</p>
    /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
    /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub lock_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeBackupVaultOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The number of recovery points that are stored in a backup vault.</p>
    pub fn number_of_recovery_points(&self) -> i64 {
        self.number_of_recovery_points
    }
    /// <p>A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. <code>True</code> means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.</p>
    pub fn locked(&self) -> std::option::Option<bool> {
        self.locked
    }
    /// <p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
    pub fn min_retention_days(&self) -> std::option::Option<i64> {
        self.min_retention_days
    }
    /// <p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
    pub fn max_retention_days(&self) -> std::option::Option<i64> {
        self.max_retention_days
    }
    /// <p>The date and time when Backup Vault Lock configuration cannot be changed or deleted.</p>
    /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
    /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn lock_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.lock_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeBackupVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupVaultOutput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("number_of_recovery_points", &self.number_of_recovery_points);
        formatter.field("locked", &self.locked);
        formatter.field("min_retention_days", &self.min_retention_days);
        formatter.field("max_retention_days", &self.max_retention_days);
        formatter.field("lock_date", &self.lock_date);
        formatter.finish()
    }
}
/// See [`DescribeBackupVaultOutput`](crate::output::DescribeBackupVaultOutput)
pub mod describe_backup_vault_output {
    /// A builder for [`DescribeBackupVaultOutput`](crate::output::DescribeBackupVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) number_of_recovery_points: std::option::Option<i64>,
        pub(crate) locked: std::option::Option<bool>,
        pub(crate) min_retention_days: std::option::Option<i64>,
        pub(crate) max_retention_days: std::option::Option<i64>,
        pub(crate) lock_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The number of recovery points that are stored in a backup vault.</p>
        pub fn number_of_recovery_points(mut self, input: i64) -> Self {
            self.number_of_recovery_points = Some(input);
            self
        }
        /// <p>The number of recovery points that are stored in a backup vault.</p>
        pub fn set_number_of_recovery_points(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_recovery_points = input;
            self
        }
        /// <p>A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. <code>True</code> means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.</p>
        pub fn locked(mut self, input: bool) -> Self {
            self.locked = Some(input);
            self
        }
        /// <p>A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. <code>True</code> means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.</p>
        pub fn set_locked(mut self, input: std::option::Option<bool>) -> Self {
            self.locked = input;
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
        pub fn min_retention_days(mut self, input: i64) -> Self {
            self.min_retention_days = Some(input);
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
        pub fn set_min_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.min_retention_days = input;
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
        pub fn max_retention_days(mut self, input: i64) -> Self {
            self.max_retention_days = Some(input);
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>
        pub fn set_max_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.max_retention_days = input;
            self
        }
        /// <p>The date and time when Backup Vault Lock configuration cannot be changed or deleted.</p>
        /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
        /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn lock_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.lock_date = Some(input);
            self
        }
        /// <p>The date and time when Backup Vault Lock configuration cannot be changed or deleted.</p>
        /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
        /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_lock_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.lock_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupVaultOutput`](crate::output::DescribeBackupVaultOutput)
        pub fn build(self) -> crate::output::DescribeBackupVaultOutput {
            crate::output::DescribeBackupVaultOutput {
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                encryption_key_arn: self.encryption_key_arn,
                creation_date: self.creation_date,
                creator_request_id: self.creator_request_id,
                number_of_recovery_points: self.number_of_recovery_points.unwrap_or_default(),
                locked: self.locked,
                min_retention_days: self.min_retention_days,
                max_retention_days: self.max_retention_days,
                lock_date: self.lock_date,
            }
        }
    }
}
impl DescribeBackupVaultOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBackupVaultOutput`](crate::output::DescribeBackupVaultOutput)
    pub fn builder() -> crate::output::describe_backup_vault_output::Builder {
        crate::output::describe_backup_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupJobOutput {
    /// <p>Returns the account ID that owns the backup job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub backup_job_id: std::option::Option<std::string::String>,
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of a resource recovery point.</p>
    pub state: std::option::Option<crate::model::BackupJobState>,
    /// <p>A detailed message explaining the status of the job to back up a resource.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
    pub percent_done: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of a backup.</p>
    pub backup_size_in_bytes: std::option::Option<i64>,
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
    pub created_by: std::option::Option<crate::model::RecoveryPointCreator>,
    /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>
    pub bytes_transferred: std::option::Option<i64>,
    /// <p>The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub expected_completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub start_by: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Represents the options specified as part of backup plan or on-demand backup job.</p>
    pub backup_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, <code>BackupType</code> returns <code>"WindowsVSS"</code>. If <code>BackupType</code> is empty, then the backup type was a regular backup.</p>
    pub backup_type: std::option::Option<std::string::String>,
}
impl DescribeBackupJobOutput {
    /// <p>Returns the account ID that owns the backup job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub fn backup_job_id(&self) -> std::option::Option<&str> {
        self.backup_job_id.as_deref()
    }
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>The current state of a resource recovery point.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::BackupJobState> {
        self.state.as_ref()
    }
    /// <p>A detailed message explaining the status of the job to back up a resource.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
    pub fn percent_done(&self) -> std::option::Option<&str> {
        self.percent_done.as_deref()
    }
    /// <p>The size, in bytes, of a backup.</p>
    pub fn backup_size_in_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_in_bytes
    }
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::RecoveryPointCreator> {
        self.created_by.as_ref()
    }
    /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>
    pub fn bytes_transferred(&self) -> std::option::Option<i64> {
        self.bytes_transferred
    }
    /// <p>The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn expected_completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expected_completion_date.as_ref()
    }
    /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn start_by(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_by.as_ref()
    }
    /// <p>Represents the options specified as part of backup plan or on-demand backup job.</p>
    pub fn backup_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.backup_options.as_ref()
    }
    /// <p>Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, <code>BackupType</code> returns <code>"WindowsVSS"</code>. If <code>BackupType</code> is empty, then the backup type was a regular backup.</p>
    pub fn backup_type(&self) -> std::option::Option<&str> {
        self.backup_type.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupJobOutput");
        formatter.field("account_id", &self.account_id);
        formatter.field("backup_job_id", &self.backup_job_id);
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("state", &self.state);
        formatter.field("status_message", &self.status_message);
        formatter.field("percent_done", &self.percent_done);
        formatter.field("backup_size_in_bytes", &self.backup_size_in_bytes);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("created_by", &self.created_by);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("bytes_transferred", &self.bytes_transferred);
        formatter.field("expected_completion_date", &self.expected_completion_date);
        formatter.field("start_by", &self.start_by);
        formatter.field("backup_options", &self.backup_options);
        formatter.field("backup_type", &self.backup_type);
        formatter.finish()
    }
}
/// See [`DescribeBackupJobOutput`](crate::output::DescribeBackupJobOutput)
pub mod describe_backup_job_output {
    /// A builder for [`DescribeBackupJobOutput`](crate::output::DescribeBackupJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) backup_job_id: std::option::Option<std::string::String>,
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::BackupJobState>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) percent_done: std::option::Option<std::string::String>,
        pub(crate) backup_size_in_bytes: std::option::Option<i64>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::RecoveryPointCreator>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) bytes_transferred: std::option::Option<i64>,
        pub(crate) expected_completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_by: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) backup_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) backup_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the account ID that owns the backup job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Returns the account ID that owns the backup job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn backup_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn set_backup_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_job_id = input;
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>The current state of a resource recovery point.</p>
        pub fn state(mut self, input: crate::model::BackupJobState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of a resource recovery point.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::BackupJobState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>A detailed message explaining the status of the job to back up a resource.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A detailed message explaining the status of the job to back up a resource.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
        pub fn percent_done(mut self, input: impl Into<std::string::String>) -> Self {
            self.percent_done = Some(input.into());
            self
        }
        /// <p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>
        pub fn set_percent_done(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.percent_done = input;
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn backup_size_in_bytes(mut self, input: i64) -> Self {
            self.backup_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn set_backup_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_in_bytes = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
        pub fn created_by(mut self, input: crate::model::RecoveryPointCreator) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointCreator>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>
        pub fn bytes_transferred(mut self, input: i64) -> Self {
            self.bytes_transferred = Some(input);
            self
        }
        /// <p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>
        pub fn set_bytes_transferred(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_transferred = input;
            self
        }
        /// <p>The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn expected_completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expected_completion_date = Some(input);
            self
        }
        /// <p>The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_expected_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expected_completion_date = input;
            self
        }
        /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn start_by(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_by = Some(input);
            self
        }
        /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_start_by(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_by = input;
            self
        }
        /// Adds a key-value pair to `backup_options`.
        ///
        /// To override the contents of this collection use [`set_backup_options`](Self::set_backup_options).
        ///
        /// <p>Represents the options specified as part of backup plan or on-demand backup job.</p>
        pub fn backup_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.backup_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.backup_options = Some(hash_map);
            self
        }
        /// <p>Represents the options specified as part of backup plan or on-demand backup job.</p>
        pub fn set_backup_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.backup_options = input;
            self
        }
        /// <p>Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, <code>BackupType</code> returns <code>"WindowsVSS"</code>. If <code>BackupType</code> is empty, then the backup type was a regular backup.</p>
        pub fn backup_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_type = Some(input.into());
            self
        }
        /// <p>Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, <code>BackupType</code> returns <code>"WindowsVSS"</code>. If <code>BackupType</code> is empty, then the backup type was a regular backup.</p>
        pub fn set_backup_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupJobOutput`](crate::output::DescribeBackupJobOutput)
        pub fn build(self) -> crate::output::DescribeBackupJobOutput {
            crate::output::DescribeBackupJobOutput {
                account_id: self.account_id,
                backup_job_id: self.backup_job_id,
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                recovery_point_arn: self.recovery_point_arn,
                resource_arn: self.resource_arn,
                creation_date: self.creation_date,
                completion_date: self.completion_date,
                state: self.state,
                status_message: self.status_message,
                percent_done: self.percent_done,
                backup_size_in_bytes: self.backup_size_in_bytes,
                iam_role_arn: self.iam_role_arn,
                created_by: self.created_by,
                resource_type: self.resource_type,
                bytes_transferred: self.bytes_transferred,
                expected_completion_date: self.expected_completion_date,
                start_by: self.start_by,
                backup_options: self.backup_options,
                backup_type: self.backup_type,
            }
        }
    }
}
impl DescribeBackupJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBackupJobOutput`](crate::output::DescribeBackupJobOutput)
    pub fn builder() -> crate::output::describe_backup_job_output::Builder {
        crate::output::describe_backup_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReportPlanOutput {}
impl std::fmt::Debug for DeleteReportPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReportPlanOutput");
        formatter.finish()
    }
}
/// See [`DeleteReportPlanOutput`](crate::output::DeleteReportPlanOutput)
pub mod delete_report_plan_output {
    /// A builder for [`DeleteReportPlanOutput`](crate::output::DeleteReportPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReportPlanOutput`](crate::output::DeleteReportPlanOutput)
        pub fn build(self) -> crate::output::DeleteReportPlanOutput {
            crate::output::DeleteReportPlanOutput {}
        }
    }
}
impl DeleteReportPlanOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReportPlanOutput`](crate::output::DeleteReportPlanOutput)
    pub fn builder() -> crate::output::delete_report_plan_output::Builder {
        crate::output::delete_report_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecoveryPointOutput {}
impl std::fmt::Debug for DeleteRecoveryPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecoveryPointOutput");
        formatter.finish()
    }
}
/// See [`DeleteRecoveryPointOutput`](crate::output::DeleteRecoveryPointOutput)
pub mod delete_recovery_point_output {
    /// A builder for [`DeleteRecoveryPointOutput`](crate::output::DeleteRecoveryPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRecoveryPointOutput`](crate::output::DeleteRecoveryPointOutput)
        pub fn build(self) -> crate::output::DeleteRecoveryPointOutput {
            crate::output::DeleteRecoveryPointOutput {}
        }
    }
}
impl DeleteRecoveryPointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryPointOutput`](crate::output::DeleteRecoveryPointOutput)
    pub fn builder() -> crate::output::delete_recovery_point_output::Builder {
        crate::output::delete_recovery_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFrameworkOutput {}
impl std::fmt::Debug for DeleteFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFrameworkOutput");
        formatter.finish()
    }
}
/// See [`DeleteFrameworkOutput`](crate::output::DeleteFrameworkOutput)
pub mod delete_framework_output {
    /// A builder for [`DeleteFrameworkOutput`](crate::output::DeleteFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFrameworkOutput`](crate::output::DeleteFrameworkOutput)
        pub fn build(self) -> crate::output::DeleteFrameworkOutput {
            crate::output::DeleteFrameworkOutput {}
        }
    }
}
impl DeleteFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFrameworkOutput`](crate::output::DeleteFrameworkOutput)
    pub fn builder() -> crate::output::delete_framework_output::Builder {
        crate::output::delete_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultNotificationsOutput {}
impl std::fmt::Debug for DeleteBackupVaultNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultNotificationsOutput");
        formatter.finish()
    }
}
/// See [`DeleteBackupVaultNotificationsOutput`](crate::output::DeleteBackupVaultNotificationsOutput)
pub mod delete_backup_vault_notifications_output {
    /// A builder for [`DeleteBackupVaultNotificationsOutput`](crate::output::DeleteBackupVaultNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBackupVaultNotificationsOutput`](crate::output::DeleteBackupVaultNotificationsOutput)
        pub fn build(self) -> crate::output::DeleteBackupVaultNotificationsOutput {
            crate::output::DeleteBackupVaultNotificationsOutput {}
        }
    }
}
impl DeleteBackupVaultNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultNotificationsOutput`](crate::output::DeleteBackupVaultNotificationsOutput)
    pub fn builder() -> crate::output::delete_backup_vault_notifications_output::Builder {
        crate::output::delete_backup_vault_notifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultLockConfigurationOutput {}
impl std::fmt::Debug for DeleteBackupVaultLockConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultLockConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBackupVaultLockConfigurationOutput`](crate::output::DeleteBackupVaultLockConfigurationOutput)
pub mod delete_backup_vault_lock_configuration_output {
    /// A builder for [`DeleteBackupVaultLockConfigurationOutput`](crate::output::DeleteBackupVaultLockConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBackupVaultLockConfigurationOutput`](crate::output::DeleteBackupVaultLockConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteBackupVaultLockConfigurationOutput {
            crate::output::DeleteBackupVaultLockConfigurationOutput {}
        }
    }
}
impl DeleteBackupVaultLockConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultLockConfigurationOutput`](crate::output::DeleteBackupVaultLockConfigurationOutput)
    pub fn builder() -> crate::output::delete_backup_vault_lock_configuration_output::Builder {
        crate::output::delete_backup_vault_lock_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultAccessPolicyOutput {}
impl std::fmt::Debug for DeleteBackupVaultAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultAccessPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteBackupVaultAccessPolicyOutput`](crate::output::DeleteBackupVaultAccessPolicyOutput)
pub mod delete_backup_vault_access_policy_output {
    /// A builder for [`DeleteBackupVaultAccessPolicyOutput`](crate::output::DeleteBackupVaultAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBackupVaultAccessPolicyOutput`](crate::output::DeleteBackupVaultAccessPolicyOutput)
        pub fn build(self) -> crate::output::DeleteBackupVaultAccessPolicyOutput {
            crate::output::DeleteBackupVaultAccessPolicyOutput {}
        }
    }
}
impl DeleteBackupVaultAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultAccessPolicyOutput`](crate::output::DeleteBackupVaultAccessPolicyOutput)
    pub fn builder() -> crate::output::delete_backup_vault_access_policy_output::Builder {
        crate::output::delete_backup_vault_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultOutput {}
impl std::fmt::Debug for DeleteBackupVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultOutput");
        formatter.finish()
    }
}
/// See [`DeleteBackupVaultOutput`](crate::output::DeleteBackupVaultOutput)
pub mod delete_backup_vault_output {
    /// A builder for [`DeleteBackupVaultOutput`](crate::output::DeleteBackupVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBackupVaultOutput`](crate::output::DeleteBackupVaultOutput)
        pub fn build(self) -> crate::output::DeleteBackupVaultOutput {
            crate::output::DeleteBackupVaultOutput {}
        }
    }
}
impl DeleteBackupVaultOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultOutput`](crate::output::DeleteBackupVaultOutput)
    pub fn builder() -> crate::output::delete_backup_vault_output::Builder {
        crate::output::delete_backup_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupSelectionOutput {}
impl std::fmt::Debug for DeleteBackupSelectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupSelectionOutput");
        formatter.finish()
    }
}
/// See [`DeleteBackupSelectionOutput`](crate::output::DeleteBackupSelectionOutput)
pub mod delete_backup_selection_output {
    /// A builder for [`DeleteBackupSelectionOutput`](crate::output::DeleteBackupSelectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBackupSelectionOutput`](crate::output::DeleteBackupSelectionOutput)
        pub fn build(self) -> crate::output::DeleteBackupSelectionOutput {
            crate::output::DeleteBackupSelectionOutput {}
        }
    }
}
impl DeleteBackupSelectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupSelectionOutput`](crate::output::DeleteBackupSelectionOutput)
    pub fn builder() -> crate::output::delete_backup_selection_output::Builder {
        crate::output::delete_backup_selection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupPlanOutput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub backup_plan_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub deletion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl DeleteBackupPlanOutput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub fn backup_plan_arn(&self) -> std::option::Option<&str> {
        self.backup_plan_arn.as_deref()
    }
    /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn deletion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deletion_date.as_ref()
    }
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupPlanOutput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("backup_plan_arn", &self.backup_plan_arn);
        formatter.field("deletion_date", &self.deletion_date);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`DeleteBackupPlanOutput`](crate::output::DeleteBackupPlanOutput)
pub mod delete_backup_plan_output {
    /// A builder for [`DeleteBackupPlanOutput`](crate::output::DeleteBackupPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_arn: std::option::Option<std::string::String>,
        pub(crate) deletion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn backup_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn set_backup_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_arn = input;
            self
        }
        /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn deletion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deletion_date = Some(input);
            self
        }
        /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deletion_date = input;
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupPlanOutput`](crate::output::DeleteBackupPlanOutput)
        pub fn build(self) -> crate::output::DeleteBackupPlanOutput {
            crate::output::DeleteBackupPlanOutput {
                backup_plan_id: self.backup_plan_id,
                backup_plan_arn: self.backup_plan_arn,
                deletion_date: self.deletion_date,
                version_id: self.version_id,
            }
        }
    }
}
impl DeleteBackupPlanOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupPlanOutput`](crate::output::DeleteBackupPlanOutput)
    pub fn builder() -> crate::output::delete_backup_plan_output::Builder {
        crate::output::delete_backup_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReportPlanOutput {
    /// <p>The unique name of the report plan.</p>
    pub report_plan_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub report_plan_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateReportPlanOutput {
    /// <p>The unique name of the report plan.</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub fn report_plan_arn(&self) -> std::option::Option<&str> {
        self.report_plan_arn.as_deref()
    }
    /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for CreateReportPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReportPlanOutput");
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.field("report_plan_arn", &self.report_plan_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`CreateReportPlanOutput`](crate::output::CreateReportPlanOutput)
pub mod create_report_plan_output {
    /// A builder for [`CreateReportPlanOutput`](crate::output::CreateReportPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
        pub(crate) report_plan_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique name of the report plan.</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of the report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn report_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn set_report_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_arn = input;
            self
        }
        /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReportPlanOutput`](crate::output::CreateReportPlanOutput)
        pub fn build(self) -> crate::output::CreateReportPlanOutput {
            crate::output::CreateReportPlanOutput {
                report_plan_name: self.report_plan_name,
                report_plan_arn: self.report_plan_arn,
                creation_time: self.creation_time,
            }
        }
    }
}
impl CreateReportPlanOutput {
    /// Creates a new builder-style object to manufacture [`CreateReportPlanOutput`](crate::output::CreateReportPlanOutput)
    pub fn builder() -> crate::output::create_report_plan_output::Builder {
        crate::output::create_report_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFrameworkOutput {
    /// <p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub framework_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub framework_arn: std::option::Option<std::string::String>,
}
impl CreateFrameworkOutput {
    /// <p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
    pub fn framework_arn(&self) -> std::option::Option<&str> {
        self.framework_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFrameworkOutput");
        formatter.field("framework_name", &self.framework_name);
        formatter.field("framework_arn", &self.framework_arn);
        formatter.finish()
    }
}
/// See [`CreateFrameworkOutput`](crate::output::CreateFrameworkOutput)
pub mod create_framework_output {
    /// A builder for [`CreateFrameworkOutput`](crate::output::CreateFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
        pub(crate) framework_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn framework_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>
        pub fn set_framework_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFrameworkOutput`](crate::output::CreateFrameworkOutput)
        pub fn build(self) -> crate::output::CreateFrameworkOutput {
            crate::output::CreateFrameworkOutput {
                framework_name: self.framework_name,
                framework_arn: self.framework_arn,
            }
        }
    }
}
impl CreateFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`CreateFrameworkOutput`](crate::output::CreateFrameworkOutput)
    pub fn builder() -> crate::output::create_framework_output::Builder {
        crate::output::create_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupVaultOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateBackupVaultOutput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for CreateBackupVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupVaultOutput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`CreateBackupVaultOutput`](crate::output::CreateBackupVaultOutput)
pub mod create_backup_vault_output {
    /// A builder for [`CreateBackupVaultOutput`](crate::output::CreateBackupVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupVaultOutput`](crate::output::CreateBackupVaultOutput)
        pub fn build(self) -> crate::output::CreateBackupVaultOutput {
            crate::output::CreateBackupVaultOutput {
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                creation_date: self.creation_date,
            }
        }
    }
}
impl CreateBackupVaultOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackupVaultOutput`](crate::output::CreateBackupVaultOutput)
    pub fn builder() -> crate::output::create_backup_vault_output::Builder {
        crate::output::create_backup_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupSelectionOutput {
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
    pub selection_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateBackupSelectionOutput {
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
    pub fn selection_id(&self) -> std::option::Option<&str> {
        self.selection_id.as_deref()
    }
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for CreateBackupSelectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupSelectionOutput");
        formatter.field("selection_id", &self.selection_id);
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`CreateBackupSelectionOutput`](crate::output::CreateBackupSelectionOutput)
pub mod create_backup_selection_output {
    /// A builder for [`CreateBackupSelectionOutput`](crate::output::CreateBackupSelectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selection_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn selection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn set_selection_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.selection_id = input;
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupSelectionOutput`](crate::output::CreateBackupSelectionOutput)
        pub fn build(self) -> crate::output::CreateBackupSelectionOutput {
            crate::output::CreateBackupSelectionOutput {
                selection_id: self.selection_id,
                backup_plan_id: self.backup_plan_id,
                creation_date: self.creation_date,
            }
        }
    }
}
impl CreateBackupSelectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackupSelectionOutput`](crate::output::CreateBackupSelectionOutput)
    pub fn builder() -> crate::output::create_backup_selection_output::Builder {
        crate::output::create_backup_selection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupPlanOutput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub backup_plan_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>A list of <code>BackupOptions</code> settings for a resource type. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    pub advanced_backup_settings:
        std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
}
impl CreateBackupPlanOutput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub fn backup_plan_arn(&self) -> std::option::Option<&str> {
        self.backup_plan_arn.as_deref()
    }
    /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>A list of <code>BackupOptions</code> settings for a resource type. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    pub fn advanced_backup_settings(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedBackupSetting]> {
        self.advanced_backup_settings.as_deref()
    }
}
impl std::fmt::Debug for CreateBackupPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupPlanOutput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("backup_plan_arn", &self.backup_plan_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("version_id", &self.version_id);
        formatter.field("advanced_backup_settings", &self.advanced_backup_settings);
        formatter.finish()
    }
}
/// See [`CreateBackupPlanOutput`](crate::output::CreateBackupPlanOutput)
pub mod create_backup_plan_output {
    /// A builder for [`CreateBackupPlanOutput`](crate::output::CreateBackupPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) advanced_backup_settings:
            std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn backup_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn set_backup_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_arn = input;
            self
        }
        /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `advanced_backup_settings`.
        ///
        /// To override the contents of this collection use [`set_advanced_backup_settings`](Self::set_advanced_backup_settings).
        ///
        /// <p>A list of <code>BackupOptions</code> settings for a resource type. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        pub fn advanced_backup_settings(
            mut self,
            input: crate::model::AdvancedBackupSetting,
        ) -> Self {
            let mut v = self.advanced_backup_settings.unwrap_or_default();
            v.push(input);
            self.advanced_backup_settings = Some(v);
            self
        }
        /// <p>A list of <code>BackupOptions</code> settings for a resource type. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        pub fn set_advanced_backup_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
        ) -> Self {
            self.advanced_backup_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupPlanOutput`](crate::output::CreateBackupPlanOutput)
        pub fn build(self) -> crate::output::CreateBackupPlanOutput {
            crate::output::CreateBackupPlanOutput {
                backup_plan_id: self.backup_plan_id,
                backup_plan_arn: self.backup_plan_arn,
                creation_date: self.creation_date,
                version_id: self.version_id,
                advanced_backup_settings: self.advanced_backup_settings,
            }
        }
    }
}
impl CreateBackupPlanOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackupPlanOutput`](crate::output::CreateBackupPlanOutput)
    pub fn builder() -> crate::output::create_backup_plan_output::Builder {
        crate::output::create_backup_plan_output::Builder::default()
    }
}
