// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateBackupPlanInput`](crate::input::CreateBackupPlanInput)
pub mod create_backup_plan_input {
    /// A builder for [`CreateBackupPlanInput`](crate::input::CreateBackupPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan: std::option::Option<crate::model::BackupPlanInput>,
        pub(crate) backup_plan_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn backup_plan(mut self, input: crate::model::BackupPlanInput) -> Self {
            self.backup_plan = Some(input);
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn set_backup_plan(
            mut self,
            input: std::option::Option<crate::model::BackupPlanInput>,
        ) -> Self {
            self.backup_plan = input;
            self
        }
        /// Adds a key-value pair to `backup_plan_tags`.
        ///
        /// To override the contents of this collection use [`set_backup_plan_tags`](Self::set_backup_plan_tags).
        ///
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair. The specified tags are assigned to all backups
        /// created with this plan.</p>
        pub fn backup_plan_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.backup_plan_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.backup_plan_tags = Some(hash_map);
            self
        }
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair. The specified tags are assigned to all backups
        /// created with this plan.</p>
        pub fn set_backup_plan_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.backup_plan_tags = input;
            self
        }
        /// <p>Identifies the request and allows failed requests to be retried without the risk of
        /// running the operation twice. If the request includes a <code>CreatorRequestId</code> that
        /// matches an existing backup plan, that plan is returned. This parameter is optional.</p>
        /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>Identifies the request and allows failed requests to be retried without the risk of
        /// running the operation twice. If the request includes a <code>CreatorRequestId</code> that
        /// matches an existing backup plan, that plan is returned. This parameter is optional.</p>
        /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupPlanInput`](crate::input::CreateBackupPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackupPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackupPlanInput {
                backup_plan: self.backup_plan,
                backup_plan_tags: self.backup_plan_tags,
                creator_request_id: self.creator_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackupPlanInputOperationOutputAlias = crate::operation::CreateBackupPlan;
#[doc(hidden)]
pub type CreateBackupPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBackupPlanInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackupPlan`](crate::operation::CreateBackupPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackupPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBackupPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/backup/plans").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBackupPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBackupPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_backup_plan(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackupPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackupPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBackupPlanInput`](crate::input::CreateBackupPlanInput)
    pub fn builder() -> crate::input::create_backup_plan_input::Builder {
        crate::input::create_backup_plan_input::Builder::default()
    }
}

/// See [`CreateBackupSelectionInput`](crate::input::CreateBackupSelectionInput)
pub mod create_backup_selection_input {
    /// A builder for [`CreateBackupSelectionInput`](crate::input::CreateBackupSelectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) backup_selection: std::option::Option<crate::model::BackupSelection>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies the backup plan to be associated with the selection of
        /// resources.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the backup plan to be associated with the selection of
        /// resources.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn backup_selection(mut self, input: crate::model::BackupSelection) -> Self {
            self.backup_selection = Some(input);
            self
        }
        /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn set_backup_selection(
            mut self,
            input: std::option::Option<crate::model::BackupSelection>,
        ) -> Self {
            self.backup_selection = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice. This parameter is optional.</p>
        /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice. This parameter is optional.</p>
        /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupSelectionInput`](crate::input::CreateBackupSelectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackupSelectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackupSelectionInput {
                backup_plan_id: self.backup_plan_id,
                backup_selection: self.backup_selection,
                creator_request_id: self.creator_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackupSelectionInputOperationOutputAlias = crate::operation::CreateBackupSelection;
#[doc(hidden)]
pub type CreateBackupSelectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBackupSelectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackupSelection`](crate::operation::CreateBackupSelection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackupSelection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBackupSelectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.backup_plan_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_1, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}/selections",
                BackupPlanId = backup_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBackupSelectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBackupSelectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_backup_selection(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackupSelection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackupSelection",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBackupSelectionInput`](crate::input::CreateBackupSelectionInput)
    pub fn builder() -> crate::input::create_backup_selection_input::Builder {
        crate::input::create_backup_selection_input::Builder::default()
    }
}

/// See [`CreateBackupVaultInput`](crate::input::CreateBackupVaultInput)
pub mod create_backup_vault_input {
    /// A builder for [`CreateBackupVaultInput`](crate::input::CreateBackupVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Adds a key-value pair to `backup_vault_tags`.
        ///
        /// To override the contents of this collection use [`set_backup_vault_tags`](Self::set_backup_vault_tags).
        ///
        /// <p>Metadata that you can assign to help organize the resources that you create. Each tag is
        /// a key-value pair.</p>
        pub fn backup_vault_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.backup_vault_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.backup_vault_tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can assign to help organize the resources that you create. Each tag is
        /// a key-value pair.</p>
        pub fn set_backup_vault_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.backup_vault_tags = input;
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice. This parameter is optional.</p>
        /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice. This parameter is optional.</p>
        /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupVaultInput`](crate::input::CreateBackupVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackupVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackupVaultInput {
                backup_vault_name: self.backup_vault_name,
                backup_vault_tags: self.backup_vault_tags,
                encryption_key_arn: self.encryption_key_arn,
                creator_request_id: self.creator_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackupVaultInputOperationOutputAlias = crate::operation::CreateBackupVault;
#[doc(hidden)]
pub type CreateBackupVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBackupVaultInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackupVault`](crate::operation::CreateBackupVault)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackupVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBackupVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.backup_vault_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_2, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBackupVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBackupVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_backup_vault(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackupVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackupVault",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBackupVaultInput`](crate::input::CreateBackupVaultInput)
    pub fn builder() -> crate::input::create_backup_vault_input::Builder {
        crate::input::create_backup_vault_input::Builder::default()
    }
}

/// See [`CreateFrameworkInput`](crate::input::CreateFrameworkInput)
pub mod create_framework_input {
    /// A builder for [`CreateFrameworkInput`](crate::input::CreateFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
        pub(crate) framework_description: std::option::Option<std::string::String>,
        pub(crate) framework_controls:
            std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) framework_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the framework. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of the framework. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// <p>An optional description of the framework with a maximum of 1,024 characters.</p>
        pub fn framework_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_description = Some(input.into());
            self
        }
        /// <p>An optional description of the framework with a maximum of 1,024 characters.</p>
        pub fn set_framework_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_description = input;
            self
        }
        /// Appends an item to `framework_controls`.
        ///
        /// To override the contents of this collection use [`set_framework_controls`](Self::set_framework_controls).
        ///
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn framework_controls(
            mut self,
            input: impl Into<crate::model::FrameworkControl>,
        ) -> Self {
            let mut v = self.framework_controls.unwrap_or_default();
            v.push(input.into());
            self.framework_controls = Some(v);
            self
        }
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn set_framework_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        ) -> Self {
            self.framework_controls = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Adds a key-value pair to `framework_tags`.
        ///
        /// To override the contents of this collection use [`set_framework_tags`](Self::set_framework_tags).
        ///
        /// <p>Metadata that you can assign to help organize the frameworks that you create. Each tag
        /// is a key-value pair.</p>
        pub fn framework_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.framework_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.framework_tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can assign to help organize the frameworks that you create. Each tag
        /// is a key-value pair.</p>
        pub fn set_framework_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.framework_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFrameworkInput`](crate::input::CreateFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFrameworkInput {
                framework_name: self.framework_name,
                framework_description: self.framework_description,
                framework_controls: self.framework_controls,
                idempotency_token: self.idempotency_token,
                framework_tags: self.framework_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFrameworkInputOperationOutputAlias = crate::operation::CreateFramework;
#[doc(hidden)]
pub type CreateFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`CreateFramework`](crate::operation::CreateFramework)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/audit/frameworks").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_framework(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFramework",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFrameworkInput`](crate::input::CreateFrameworkInput)
    pub fn builder() -> crate::input::create_framework_input::Builder {
        crate::input::create_framework_input::Builder::default()
    }
}

/// See [`CreateReportPlanInput`](crate::input::CreateReportPlanInput)
pub mod create_report_plan_input {
    /// A builder for [`CreateReportPlanInput`](crate::input::CreateReportPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
        pub(crate) report_plan_description: std::option::Option<std::string::String>,
        pub(crate) report_delivery_channel:
            std::option::Option<crate::model::ReportDeliveryChannel>,
        pub(crate) report_setting: std::option::Option<crate::model::ReportSetting>,
        pub(crate) report_plan_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the report plan. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of the report plan. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// <p>An optional description of the report plan with a maximum of 1,024 characters.</p>
        pub fn report_plan_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_description = Some(input.into());
            self
        }
        /// <p>An optional description of the report plan with a maximum of 1,024 characters.</p>
        pub fn set_report_plan_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_description = input;
            self
        }
        /// <p>A structure that contains information about where and how to deliver your reports,
        /// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
        /// reports.</p>
        pub fn report_delivery_channel(
            mut self,
            input: crate::model::ReportDeliveryChannel,
        ) -> Self {
            self.report_delivery_channel = Some(input);
            self
        }
        /// <p>A structure that contains information about where and how to deliver your reports,
        /// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
        /// reports.</p>
        pub fn set_report_delivery_channel(
            mut self,
            input: std::option::Option<crate::model::ReportDeliveryChannel>,
        ) -> Self {
            self.report_delivery_channel = input;
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn report_setting(mut self, input: crate::model::ReportSetting) -> Self {
            self.report_setting = Some(input);
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn set_report_setting(
            mut self,
            input: std::option::Option<crate::model::ReportSetting>,
        ) -> Self {
            self.report_setting = input;
            self
        }
        /// Adds a key-value pair to `report_plan_tags`.
        ///
        /// To override the contents of this collection use [`set_report_plan_tags`](Self::set_report_plan_tags).
        ///
        /// <p>Metadata that you can assign to help organize the report plans that you create. Each tag
        /// is a key-value pair.</p>
        pub fn report_plan_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.report_plan_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.report_plan_tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can assign to help organize the report plans that you create. Each tag
        /// is a key-value pair.</p>
        pub fn set_report_plan_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.report_plan_tags = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReportPlanInput`](crate::input::CreateReportPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReportPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReportPlanInput {
                report_plan_name: self.report_plan_name,
                report_plan_description: self.report_plan_description,
                report_delivery_channel: self.report_delivery_channel,
                report_setting: self.report_setting,
                report_plan_tags: self.report_plan_tags,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReportPlanInputOperationOutputAlias = crate::operation::CreateReportPlan;
#[doc(hidden)]
pub type CreateReportPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReportPlanInput {
    /// Consumes the builder and constructs an Operation<[`CreateReportPlan`](crate::operation::CreateReportPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReportPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReportPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/audit/report-plans").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReportPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReportPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_report_plan(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReportPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReportPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReportPlanInput`](crate::input::CreateReportPlanInput)
    pub fn builder() -> crate::input::create_report_plan_input::Builder {
        crate::input::create_report_plan_input::Builder::default()
    }
}

/// See [`DeleteBackupPlanInput`](crate::input::DeleteBackupPlanInput)
pub mod delete_backup_plan_input {
    /// A builder for [`DeleteBackupPlanInput`](crate::input::DeleteBackupPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupPlanInput`](crate::input::DeleteBackupPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupPlanInput {
                backup_plan_id: self.backup_plan_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupPlanInputOperationOutputAlias = crate::operation::DeleteBackupPlan;
#[doc(hidden)]
pub type DeleteBackupPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupPlanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackupPlan`](crate::operation::DeleteBackupPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackupPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.backup_plan_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_3, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}",
                BackupPlanId = backup_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackupPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackupPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupPlanInput`](crate::input::DeleteBackupPlanInput)
    pub fn builder() -> crate::input::delete_backup_plan_input::Builder {
        crate::input::delete_backup_plan_input::Builder::default()
    }
}

/// See [`DeleteBackupSelectionInput`](crate::input::DeleteBackupSelectionInput)
pub mod delete_backup_selection_input {
    /// A builder for [`DeleteBackupSelectionInput`](crate::input::DeleteBackupSelectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) selection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn selection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn set_selection_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.selection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupSelectionInput`](crate::input::DeleteBackupSelectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupSelectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupSelectionInput {
                backup_plan_id: self.backup_plan_id,
                selection_id: self.selection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupSelectionInputOperationOutputAlias = crate::operation::DeleteBackupSelection;
#[doc(hidden)]
pub type DeleteBackupSelectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupSelectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackupSelection`](crate::operation::DeleteBackupSelection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackupSelection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupSelectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.backup_plan_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_4, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.selection_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "selection_id",
                        details: "cannot be empty or unset",
                    })?;
            let selection_id = aws_smithy_http::label::fmt_string(input_5, false);
            if selection_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "selection_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}/selections/{SelectionId}",
                BackupPlanId = backup_plan_id,
                SelectionId = selection_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupSelectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupSelectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackupSelection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackupSelection",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupSelectionInput`](crate::input::DeleteBackupSelectionInput)
    pub fn builder() -> crate::input::delete_backup_selection_input::Builder {
        crate::input::delete_backup_selection_input::Builder::default()
    }
}

/// See [`DeleteBackupVaultInput`](crate::input::DeleteBackupVaultInput)
pub mod delete_backup_vault_input {
    /// A builder for [`DeleteBackupVaultInput`](crate::input::DeleteBackupVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupVaultInput`](crate::input::DeleteBackupVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupVaultInput {
                backup_vault_name: self.backup_vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupVaultInputOperationOutputAlias = crate::operation::DeleteBackupVault;
#[doc(hidden)]
pub type DeleteBackupVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupVaultInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackupVault`](crate::operation::DeleteBackupVault)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackupVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.backup_vault_name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_6, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackupVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackupVault",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultInput`](crate::input::DeleteBackupVaultInput)
    pub fn builder() -> crate::input::delete_backup_vault_input::Builder {
        crate::input::delete_backup_vault_input::Builder::default()
    }
}

/// See [`DeleteBackupVaultAccessPolicyInput`](crate::input::DeleteBackupVaultAccessPolicyInput)
pub mod delete_backup_vault_access_policy_input {
    /// A builder for [`DeleteBackupVaultAccessPolicyInput`](crate::input::DeleteBackupVaultAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupVaultAccessPolicyInput`](crate::input::DeleteBackupVaultAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupVaultAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupVaultAccessPolicyInput {
                backup_vault_name: self.backup_vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupVaultAccessPolicyInputOperationOutputAlias =
    crate::operation::DeleteBackupVaultAccessPolicy;
#[doc(hidden)]
pub type DeleteBackupVaultAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupVaultAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackupVaultAccessPolicy`](crate::operation::DeleteBackupVaultAccessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackupVaultAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupVaultAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.backup_vault_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_7, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/access-policy",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupVaultAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupVaultAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackupVaultAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackupVaultAccessPolicy",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultAccessPolicyInput`](crate::input::DeleteBackupVaultAccessPolicyInput)
    pub fn builder() -> crate::input::delete_backup_vault_access_policy_input::Builder {
        crate::input::delete_backup_vault_access_policy_input::Builder::default()
    }
}

/// See [`DeleteBackupVaultLockConfigurationInput`](crate::input::DeleteBackupVaultLockConfigurationInput)
pub mod delete_backup_vault_lock_configuration_input {
    /// A builder for [`DeleteBackupVaultLockConfigurationInput`](crate::input::DeleteBackupVaultLockConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the backup vault from which to delete Backup Vault Lock.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of the backup vault from which to delete Backup Vault Lock.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupVaultLockConfigurationInput`](crate::input::DeleteBackupVaultLockConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupVaultLockConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupVaultLockConfigurationInput {
                backup_vault_name: self.backup_vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupVaultLockConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBackupVaultLockConfiguration;
#[doc(hidden)]
pub type DeleteBackupVaultLockConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupVaultLockConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackupVaultLockConfiguration`](crate::operation::DeleteBackupVaultLockConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackupVaultLockConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupVaultLockConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.backup_vault_name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_8, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/vault-lock",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupVaultLockConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupVaultLockConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackupVaultLockConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackupVaultLockConfiguration",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultLockConfigurationInput`](crate::input::DeleteBackupVaultLockConfigurationInput)
    pub fn builder() -> crate::input::delete_backup_vault_lock_configuration_input::Builder {
        crate::input::delete_backup_vault_lock_configuration_input::Builder::default()
    }
}

/// See [`DeleteBackupVaultNotificationsInput`](crate::input::DeleteBackupVaultNotificationsInput)
pub mod delete_backup_vault_notifications_input {
    /// A builder for [`DeleteBackupVaultNotificationsInput`](crate::input::DeleteBackupVaultNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Region where they are
        /// created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Region where they are
        /// created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupVaultNotificationsInput`](crate::input::DeleteBackupVaultNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupVaultNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupVaultNotificationsInput {
                backup_vault_name: self.backup_vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupVaultNotificationsInputOperationOutputAlias =
    crate::operation::DeleteBackupVaultNotifications;
#[doc(hidden)]
pub type DeleteBackupVaultNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupVaultNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackupVaultNotifications`](crate::operation::DeleteBackupVaultNotifications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackupVaultNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupVaultNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.backup_vault_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_9, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/notification-configuration",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupVaultNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupVaultNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackupVaultNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackupVaultNotifications",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultNotificationsInput`](crate::input::DeleteBackupVaultNotificationsInput)
    pub fn builder() -> crate::input::delete_backup_vault_notifications_input::Builder {
        crate::input::delete_backup_vault_notifications_input::Builder::default()
    }
}

/// See [`DeleteFrameworkInput`](crate::input::DeleteFrameworkInput)
pub mod delete_framework_input {
    /// A builder for [`DeleteFrameworkInput`](crate::input::DeleteFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a framework.</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of a framework.</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFrameworkInput`](crate::input::DeleteFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFrameworkInput {
                framework_name: self.framework_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFrameworkInputOperationOutputAlias = crate::operation::DeleteFramework;
#[doc(hidden)]
pub type DeleteFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFramework`](crate::operation::DeleteFramework)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.framework_name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "framework_name",
                        details: "cannot be empty or unset",
                    })?;
            let framework_name = aws_smithy_http::label::fmt_string(input_10, false);
            if framework_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "framework_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/frameworks/{FrameworkName}",
                FrameworkName = framework_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFramework",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFrameworkInput`](crate::input::DeleteFrameworkInput)
    pub fn builder() -> crate::input::delete_framework_input::Builder {
        crate::input::delete_framework_input::Builder::default()
    }
}

/// See [`DeleteRecoveryPointInput`](crate::input::DeleteRecoveryPointInput)
pub mod delete_recovery_point_input {
    /// A builder for [`DeleteRecoveryPointInput`](crate::input::DeleteRecoveryPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecoveryPointInput`](crate::input::DeleteRecoveryPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRecoveryPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRecoveryPointInput {
                backup_vault_name: self.backup_vault_name,
                recovery_point_arn: self.recovery_point_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRecoveryPointInputOperationOutputAlias = crate::operation::DeleteRecoveryPoint;
#[doc(hidden)]
pub type DeleteRecoveryPointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRecoveryPointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRecoveryPoint`](crate::operation::DeleteRecoveryPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRecoveryPoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRecoveryPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.backup_vault_name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_11, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.recovery_point_arn;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_point_arn",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_point_arn = aws_smithy_http::label::fmt_string(input_12, false);
            if recovery_point_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_point_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}",
                BackupVaultName = backup_vault_name,
                RecoveryPointArn = recovery_point_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRecoveryPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRecoveryPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRecoveryPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRecoveryPoint",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryPointInput`](crate::input::DeleteRecoveryPointInput)
    pub fn builder() -> crate::input::delete_recovery_point_input::Builder {
        crate::input::delete_recovery_point_input::Builder::default()
    }
}

/// See [`DeleteReportPlanInput`](crate::input::DeleteReportPlanInput)
pub mod delete_report_plan_input {
    /// A builder for [`DeleteReportPlanInput`](crate::input::DeleteReportPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a report plan.</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of a report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReportPlanInput`](crate::input::DeleteReportPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReportPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReportPlanInput {
                report_plan_name: self.report_plan_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReportPlanInputOperationOutputAlias = crate::operation::DeleteReportPlan;
#[doc(hidden)]
pub type DeleteReportPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReportPlanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReportPlan`](crate::operation::DeleteReportPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReportPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReportPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.report_plan_name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_plan_name",
                        details: "cannot be empty or unset",
                    })?;
            let report_plan_name = aws_smithy_http::label::fmt_string(input_13, false);
            if report_plan_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_plan_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/report-plans/{ReportPlanName}",
                ReportPlanName = report_plan_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReportPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReportPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReportPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReportPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReportPlanInput`](crate::input::DeleteReportPlanInput)
    pub fn builder() -> crate::input::delete_report_plan_input::Builder {
        crate::input::delete_report_plan_input::Builder::default()
    }
}

/// See [`DescribeBackupJobInput`](crate::input::DescribeBackupJobInput)
pub mod describe_backup_job_input {
    /// A builder for [`DescribeBackupJobInput`](crate::input::DescribeBackupJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn backup_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn set_backup_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupJobInput`](crate::input::DescribeBackupJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBackupJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBackupJobInput {
                backup_job_id: self.backup_job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBackupJobInputOperationOutputAlias = crate::operation::DescribeBackupJob;
#[doc(hidden)]
pub type DescribeBackupJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBackupJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBackupJob`](crate::operation::DescribeBackupJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBackupJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBackupJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.backup_job_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_job_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_job_id = aws_smithy_http::label::fmt_string(input_14, false);
            if backup_job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-jobs/{BackupJobId}",
                BackupJobId = backup_job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBackupJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBackupJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBackupJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBackupJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBackupJobInput`](crate::input::DescribeBackupJobInput)
    pub fn builder() -> crate::input::describe_backup_job_input::Builder {
        crate::input::describe_backup_job_input::Builder::default()
    }
}

/// See [`DescribeBackupVaultInput`](crate::input::DescribeBackupVaultInput)
pub mod describe_backup_vault_input {
    /// A builder for [`DescribeBackupVaultInput`](crate::input::DescribeBackupVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupVaultInput`](crate::input::DescribeBackupVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBackupVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBackupVaultInput {
                backup_vault_name: self.backup_vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBackupVaultInputOperationOutputAlias = crate::operation::DescribeBackupVault;
#[doc(hidden)]
pub type DescribeBackupVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBackupVaultInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBackupVault`](crate::operation::DescribeBackupVault)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBackupVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBackupVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.backup_vault_name;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_15, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBackupVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBackupVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBackupVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBackupVault",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBackupVaultInput`](crate::input::DescribeBackupVaultInput)
    pub fn builder() -> crate::input::describe_backup_vault_input::Builder {
        crate::input::describe_backup_vault_input::Builder::default()
    }
}

/// See [`DescribeCopyJobInput`](crate::input::DescribeCopyJobInput)
pub mod describe_copy_job_input {
    /// A builder for [`DescribeCopyJobInput`](crate::input::DescribeCopyJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a copy job.</p>
        pub fn copy_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a copy job.</p>
        pub fn set_copy_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.copy_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCopyJobInput`](crate::input::DescribeCopyJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCopyJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCopyJobInput {
                copy_job_id: self.copy_job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCopyJobInputOperationOutputAlias = crate::operation::DescribeCopyJob;
#[doc(hidden)]
pub type DescribeCopyJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCopyJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCopyJob`](crate::operation::DescribeCopyJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCopyJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCopyJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.copy_job_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "copy_job_id",
                        details: "cannot be empty or unset",
                    })?;
            let copy_job_id = aws_smithy_http::label::fmt_string(input_16, false);
            if copy_job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "copy_job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/copy-jobs/{CopyJobId}", CopyJobId = copy_job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCopyJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCopyJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCopyJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCopyJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCopyJobInput`](crate::input::DescribeCopyJobInput)
    pub fn builder() -> crate::input::describe_copy_job_input::Builder {
        crate::input::describe_copy_job_input::Builder::default()
    }
}

/// See [`DescribeFrameworkInput`](crate::input::DescribeFrameworkInput)
pub mod describe_framework_input {
    /// A builder for [`DescribeFrameworkInput`](crate::input::DescribeFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a framework.</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of a framework.</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFrameworkInput`](crate::input::DescribeFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFrameworkInput {
                framework_name: self.framework_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFrameworkInputOperationOutputAlias = crate::operation::DescribeFramework;
#[doc(hidden)]
pub type DescribeFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFramework`](crate::operation::DescribeFramework)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.framework_name;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "framework_name",
                        details: "cannot be empty or unset",
                    })?;
            let framework_name = aws_smithy_http::label::fmt_string(input_17, false);
            if framework_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "framework_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/frameworks/{FrameworkName}",
                FrameworkName = framework_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFramework",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFrameworkInput`](crate::input::DescribeFrameworkInput)
    pub fn builder() -> crate::input::describe_framework_input::Builder {
        crate::input::describe_framework_input::Builder::default()
    }
}

/// See [`DescribeGlobalSettingsInput`](crate::input::DescribeGlobalSettingsInput)
pub mod describe_global_settings_input {
    /// A builder for [`DescribeGlobalSettingsInput`](crate::input::DescribeGlobalSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeGlobalSettingsInput`](crate::input::DescribeGlobalSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGlobalSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGlobalSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeGlobalSettingsInputOperationOutputAlias = crate::operation::DescribeGlobalSettings;
#[doc(hidden)]
pub type DescribeGlobalSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGlobalSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGlobalSettings`](crate::operation::DescribeGlobalSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGlobalSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGlobalSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/global-settings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGlobalSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGlobalSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGlobalSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGlobalSettings",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGlobalSettingsInput`](crate::input::DescribeGlobalSettingsInput)
    pub fn builder() -> crate::input::describe_global_settings_input::Builder {
        crate::input::describe_global_settings_input::Builder::default()
    }
}

/// See [`DescribeProtectedResourceInput`](crate::input::DescribeProtectedResourceInput)
pub mod describe_protected_resource_input {
    /// A builder for [`DescribeProtectedResourceInput`](crate::input::DescribeProtectedResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProtectedResourceInput`](crate::input::DescribeProtectedResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProtectedResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProtectedResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProtectedResourceInputOperationOutputAlias =
    crate::operation::DescribeProtectedResource;
#[doc(hidden)]
pub type DescribeProtectedResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProtectedResourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProtectedResource`](crate::operation::DescribeProtectedResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProtectedResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProtectedResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.resource_arn;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_18, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resources/{ResourceArn}",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProtectedResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProtectedResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProtectedResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProtectedResource",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProtectedResourceInput`](crate::input::DescribeProtectedResourceInput)
    pub fn builder() -> crate::input::describe_protected_resource_input::Builder {
        crate::input::describe_protected_resource_input::Builder::default()
    }
}

/// See [`DescribeRecoveryPointInput`](crate::input::DescribeRecoveryPointInput)
pub mod describe_recovery_point_input {
    /// A builder for [`DescribeRecoveryPointInput`](crate::input::DescribeRecoveryPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecoveryPointInput`](crate::input::DescribeRecoveryPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecoveryPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecoveryPointInput {
                backup_vault_name: self.backup_vault_name,
                recovery_point_arn: self.recovery_point_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecoveryPointInputOperationOutputAlias = crate::operation::DescribeRecoveryPoint;
#[doc(hidden)]
pub type DescribeRecoveryPointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRecoveryPointInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecoveryPoint`](crate::operation::DescribeRecoveryPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecoveryPoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecoveryPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.backup_vault_name;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_19, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_20 = &_input.recovery_point_arn;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_point_arn",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_point_arn = aws_smithy_http::label::fmt_string(input_20, false);
            if recovery_point_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_point_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}",
                BackupVaultName = backup_vault_name,
                RecoveryPointArn = recovery_point_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecoveryPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecoveryPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecoveryPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecoveryPoint",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecoveryPointInput`](crate::input::DescribeRecoveryPointInput)
    pub fn builder() -> crate::input::describe_recovery_point_input::Builder {
        crate::input::describe_recovery_point_input::Builder::default()
    }
}

/// See [`DescribeRegionSettingsInput`](crate::input::DescribeRegionSettingsInput)
pub mod describe_region_settings_input {
    /// A builder for [`DescribeRegionSettingsInput`](crate::input::DescribeRegionSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeRegionSettingsInput`](crate::input::DescribeRegionSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRegionSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRegionSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeRegionSettingsInputOperationOutputAlias = crate::operation::DescribeRegionSettings;
#[doc(hidden)]
pub type DescribeRegionSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRegionSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRegionSettings`](crate::operation::DescribeRegionSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRegionSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRegionSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account-settings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRegionSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRegionSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRegionSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRegionSettings",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRegionSettingsInput`](crate::input::DescribeRegionSettingsInput)
    pub fn builder() -> crate::input::describe_region_settings_input::Builder {
        crate::input::describe_region_settings_input::Builder::default()
    }
}

/// See [`DescribeReportJobInput`](crate::input::DescribeReportJobInput)
pub mod describe_report_job_input {
    /// A builder for [`DescribeReportJobInput`](crate::input::DescribeReportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded
        /// string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
        pub fn report_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded
        /// string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
        pub fn set_report_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReportJobInput`](crate::input::DescribeReportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReportJobInput {
                report_job_id: self.report_job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReportJobInputOperationOutputAlias = crate::operation::DescribeReportJob;
#[doc(hidden)]
pub type DescribeReportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReportJob`](crate::operation::DescribeReportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.report_job_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_job_id",
                        details: "cannot be empty or unset",
                    })?;
            let report_job_id = aws_smithy_http::label::fmt_string(input_21, false);
            if report_job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/report-jobs/{ReportJobId}",
                ReportJobId = report_job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReportJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReportJobInput`](crate::input::DescribeReportJobInput)
    pub fn builder() -> crate::input::describe_report_job_input::Builder {
        crate::input::describe_report_job_input::Builder::default()
    }
}

/// See [`DescribeReportPlanInput`](crate::input::DescribeReportPlanInput)
pub mod describe_report_plan_input {
    /// A builder for [`DescribeReportPlanInput`](crate::input::DescribeReportPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a report plan.</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of a report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReportPlanInput`](crate::input::DescribeReportPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReportPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReportPlanInput {
                report_plan_name: self.report_plan_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReportPlanInputOperationOutputAlias = crate::operation::DescribeReportPlan;
#[doc(hidden)]
pub type DescribeReportPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReportPlanInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReportPlan`](crate::operation::DescribeReportPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReportPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReportPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.report_plan_name;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_plan_name",
                        details: "cannot be empty or unset",
                    })?;
            let report_plan_name = aws_smithy_http::label::fmt_string(input_22, false);
            if report_plan_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_plan_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/report-plans/{ReportPlanName}",
                ReportPlanName = report_plan_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReportPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReportPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReportPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReportPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReportPlanInput`](crate::input::DescribeReportPlanInput)
    pub fn builder() -> crate::input::describe_report_plan_input::Builder {
        crate::input::describe_report_plan_input::Builder::default()
    }
}

/// See [`DescribeRestoreJobInput`](crate::input::DescribeRestoreJobInput)
pub mod describe_restore_job_input {
    /// A builder for [`DescribeRestoreJobInput`](crate::input::DescribeRestoreJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) restore_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn restore_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn set_restore_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.restore_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRestoreJobInput`](crate::input::DescribeRestoreJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRestoreJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRestoreJobInput {
                restore_job_id: self.restore_job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRestoreJobInputOperationOutputAlias = crate::operation::DescribeRestoreJob;
#[doc(hidden)]
pub type DescribeRestoreJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRestoreJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRestoreJob`](crate::operation::DescribeRestoreJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRestoreJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRestoreJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.restore_job_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "restore_job_id",
                        details: "cannot be empty or unset",
                    })?;
            let restore_job_id = aws_smithy_http::label::fmt_string(input_23, false);
            if restore_job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "restore_job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/restore-jobs/{RestoreJobId}",
                RestoreJobId = restore_job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRestoreJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRestoreJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRestoreJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRestoreJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRestoreJobInput`](crate::input::DescribeRestoreJobInput)
    pub fn builder() -> crate::input::describe_restore_job_input::Builder {
        crate::input::describe_restore_job_input::Builder::default()
    }
}

/// See [`DisassociateRecoveryPointInput`](crate::input::DisassociateRecoveryPointInput)
pub mod disassociate_recovery_point_input {
    /// A builder for [`DisassociateRecoveryPointInput`](crate::input::DisassociateRecoveryPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of an Backup vault.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The unique name of an Backup vault.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery
        /// point.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery
        /// point.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateRecoveryPointInput`](crate::input::DisassociateRecoveryPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateRecoveryPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateRecoveryPointInput {
                backup_vault_name: self.backup_vault_name,
                recovery_point_arn: self.recovery_point_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateRecoveryPointInputOperationOutputAlias =
    crate::operation::DisassociateRecoveryPoint;
#[doc(hidden)]
pub type DisassociateRecoveryPointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateRecoveryPointInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateRecoveryPoint`](crate::operation::DisassociateRecoveryPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateRecoveryPoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateRecoveryPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.backup_vault_name;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_24, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_25 = &_input.recovery_point_arn;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_point_arn",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_point_arn = aws_smithy_http::label::fmt_string(input_25, false);
            if recovery_point_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_point_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}/disassociate",
                BackupVaultName = backup_vault_name,
                RecoveryPointArn = recovery_point_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateRecoveryPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateRecoveryPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateRecoveryPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateRecoveryPoint",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateRecoveryPointInput`](crate::input::DisassociateRecoveryPointInput)
    pub fn builder() -> crate::input::disassociate_recovery_point_input::Builder {
        crate::input::disassociate_recovery_point_input::Builder::default()
    }
}

/// See [`ExportBackupPlanTemplateInput`](crate::input::ExportBackupPlanTemplateInput)
pub mod export_backup_plan_template_input {
    /// A builder for [`ExportBackupPlanTemplateInput`](crate::input::ExportBackupPlanTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportBackupPlanTemplateInput`](crate::input::ExportBackupPlanTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportBackupPlanTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportBackupPlanTemplateInput {
                backup_plan_id: self.backup_plan_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportBackupPlanTemplateInputOperationOutputAlias =
    crate::operation::ExportBackupPlanTemplate;
#[doc(hidden)]
pub type ExportBackupPlanTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExportBackupPlanTemplateInput {
    /// Consumes the builder and constructs an Operation<[`ExportBackupPlanTemplate`](crate::operation::ExportBackupPlanTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportBackupPlanTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportBackupPlanTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.backup_plan_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_26, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}/toTemplate",
                BackupPlanId = backup_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportBackupPlanTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportBackupPlanTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportBackupPlanTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportBackupPlanTemplate",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportBackupPlanTemplateInput`](crate::input::ExportBackupPlanTemplateInput)
    pub fn builder() -> crate::input::export_backup_plan_template_input::Builder {
        crate::input::export_backup_plan_template_input::Builder::default()
    }
}

/// See [`GetBackupPlanInput`](crate::input::GetBackupPlanInput)
pub mod get_backup_plan_input {
    /// A builder for [`GetBackupPlanInput`](crate::input::GetBackupPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
        /// long. Version IDs cannot be edited.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
        /// long. Version IDs cannot be edited.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupPlanInput`](crate::input::GetBackupPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackupPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackupPlanInput {
                backup_plan_id: self.backup_plan_id,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackupPlanInputOperationOutputAlias = crate::operation::GetBackupPlan;
#[doc(hidden)]
pub type GetBackupPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBackupPlanInput {
    /// Consumes the builder and constructs an Operation<[`GetBackupPlan`](crate::operation::GetBackupPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackupPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBackupPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.backup_plan_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_27, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}",
                BackupPlanId = backup_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetBackupPlanInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_28) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_28));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBackupPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBackupPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackupPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackupPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBackupPlanInput`](crate::input::GetBackupPlanInput)
    pub fn builder() -> crate::input::get_backup_plan_input::Builder {
        crate::input::get_backup_plan_input::Builder::default()
    }
}

/// See [`GetBackupPlanFromJsonInput`](crate::input::GetBackupPlanFromJsonInput)
pub mod get_backup_plan_from_json_input {
    /// A builder for [`GetBackupPlanFromJsonInput`](crate::input::GetBackupPlanFromJsonInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_template_json: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A customer-supplied backup plan document in JSON format.</p>
        pub fn backup_plan_template_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_template_json = Some(input.into());
            self
        }
        /// <p>A customer-supplied backup plan document in JSON format.</p>
        pub fn set_backup_plan_template_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_template_json = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupPlanFromJsonInput`](crate::input::GetBackupPlanFromJsonInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackupPlanFromJsonInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackupPlanFromJsonInput {
                backup_plan_template_json: self.backup_plan_template_json,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackupPlanFromJsonInputOperationOutputAlias = crate::operation::GetBackupPlanFromJSON;
#[doc(hidden)]
pub type GetBackupPlanFromJsonInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBackupPlanFromJsonInput {
    /// Consumes the builder and constructs an Operation<[`GetBackupPlanFromJSON`](crate::operation::GetBackupPlanFromJSON)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackupPlanFromJSON,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBackupPlanFromJsonInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/backup/template/json/toPlan").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBackupPlanFromJsonInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBackupPlanFromJsonInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_backup_plan_from_json(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackupPlanFromJSON::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackupPlanFromJSON",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBackupPlanFromJsonInput`](crate::input::GetBackupPlanFromJsonInput)
    pub fn builder() -> crate::input::get_backup_plan_from_json_input::Builder {
        crate::input::get_backup_plan_from_json_input::Builder::default()
    }
}

/// See [`GetBackupPlanFromTemplateInput`](crate::input::GetBackupPlanFromTemplateInput)
pub mod get_backup_plan_from_template_input {
    /// A builder for [`GetBackupPlanFromTemplateInput`](crate::input::GetBackupPlanFromTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a stored backup plan template.</p>
        pub fn backup_plan_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_template_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a stored backup plan template.</p>
        pub fn set_backup_plan_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupPlanFromTemplateInput`](crate::input::GetBackupPlanFromTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackupPlanFromTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackupPlanFromTemplateInput {
                backup_plan_template_id: self.backup_plan_template_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackupPlanFromTemplateInputOperationOutputAlias =
    crate::operation::GetBackupPlanFromTemplate;
#[doc(hidden)]
pub type GetBackupPlanFromTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBackupPlanFromTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetBackupPlanFromTemplate`](crate::operation::GetBackupPlanFromTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackupPlanFromTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBackupPlanFromTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.backup_plan_template_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_template_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_template_id = aws_smithy_http::label::fmt_string(input_29, false);
            if backup_plan_template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_template_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/template/plans/{BackupPlanTemplateId}/toPlan",
                BackupPlanTemplateId = backup_plan_template_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBackupPlanFromTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBackupPlanFromTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackupPlanFromTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackupPlanFromTemplate",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBackupPlanFromTemplateInput`](crate::input::GetBackupPlanFromTemplateInput)
    pub fn builder() -> crate::input::get_backup_plan_from_template_input::Builder {
        crate::input::get_backup_plan_from_template_input::Builder::default()
    }
}

/// See [`GetBackupSelectionInput`](crate::input::GetBackupSelectionInput)
pub mod get_backup_selection_input {
    /// A builder for [`GetBackupSelectionInput`](crate::input::GetBackupSelectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) selection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn selection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn set_selection_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.selection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupSelectionInput`](crate::input::GetBackupSelectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackupSelectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackupSelectionInput {
                backup_plan_id: self.backup_plan_id,
                selection_id: self.selection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackupSelectionInputOperationOutputAlias = crate::operation::GetBackupSelection;
#[doc(hidden)]
pub type GetBackupSelectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBackupSelectionInput {
    /// Consumes the builder and constructs an Operation<[`GetBackupSelection`](crate::operation::GetBackupSelection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackupSelection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBackupSelectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.backup_plan_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_30, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.selection_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "selection_id",
                        details: "cannot be empty or unset",
                    })?;
            let selection_id = aws_smithy_http::label::fmt_string(input_31, false);
            if selection_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "selection_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}/selections/{SelectionId}",
                BackupPlanId = backup_plan_id,
                SelectionId = selection_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBackupSelectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBackupSelectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackupSelection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackupSelection",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBackupSelectionInput`](crate::input::GetBackupSelectionInput)
    pub fn builder() -> crate::input::get_backup_selection_input::Builder {
        crate::input::get_backup_selection_input::Builder::default()
    }
}

/// See [`GetBackupVaultAccessPolicyInput`](crate::input::GetBackupVaultAccessPolicyInput)
pub mod get_backup_vault_access_policy_input {
    /// A builder for [`GetBackupVaultAccessPolicyInput`](crate::input::GetBackupVaultAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupVaultAccessPolicyInput`](crate::input::GetBackupVaultAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackupVaultAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackupVaultAccessPolicyInput {
                backup_vault_name: self.backup_vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackupVaultAccessPolicyInputOperationOutputAlias =
    crate::operation::GetBackupVaultAccessPolicy;
#[doc(hidden)]
pub type GetBackupVaultAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBackupVaultAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetBackupVaultAccessPolicy`](crate::operation::GetBackupVaultAccessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackupVaultAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBackupVaultAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.backup_vault_name;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_32, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/access-policy",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBackupVaultAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBackupVaultAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackupVaultAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackupVaultAccessPolicy",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBackupVaultAccessPolicyInput`](crate::input::GetBackupVaultAccessPolicyInput)
    pub fn builder() -> crate::input::get_backup_vault_access_policy_input::Builder {
        crate::input::get_backup_vault_access_policy_input::Builder::default()
    }
}

/// See [`GetBackupVaultNotificationsInput`](crate::input::GetBackupVaultNotificationsInput)
pub mod get_backup_vault_notifications_input {
    /// A builder for [`GetBackupVaultNotificationsInput`](crate::input::GetBackupVaultNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBackupVaultNotificationsInput`](crate::input::GetBackupVaultNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBackupVaultNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBackupVaultNotificationsInput {
                backup_vault_name: self.backup_vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBackupVaultNotificationsInputOperationOutputAlias =
    crate::operation::GetBackupVaultNotifications;
#[doc(hidden)]
pub type GetBackupVaultNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBackupVaultNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`GetBackupVaultNotifications`](crate::operation::GetBackupVaultNotifications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBackupVaultNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBackupVaultNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.backup_vault_name;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_33, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/notification-configuration",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBackupVaultNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBackupVaultNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBackupVaultNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBackupVaultNotifications",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBackupVaultNotificationsInput`](crate::input::GetBackupVaultNotificationsInput)
    pub fn builder() -> crate::input::get_backup_vault_notifications_input::Builder {
        crate::input::get_backup_vault_notifications_input::Builder::default()
    }
}

/// See [`GetRecoveryPointRestoreMetadataInput`](crate::input::GetRecoveryPointRestoreMetadataInput)
pub mod get_recovery_point_restore_metadata_input {
    /// A builder for [`GetRecoveryPointRestoreMetadataInput`](crate::input::GetRecoveryPointRestoreMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecoveryPointRestoreMetadataInput`](crate::input::GetRecoveryPointRestoreMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecoveryPointRestoreMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecoveryPointRestoreMetadataInput {
                backup_vault_name: self.backup_vault_name,
                recovery_point_arn: self.recovery_point_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecoveryPointRestoreMetadataInputOperationOutputAlias =
    crate::operation::GetRecoveryPointRestoreMetadata;
#[doc(hidden)]
pub type GetRecoveryPointRestoreMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRecoveryPointRestoreMetadataInput {
    /// Consumes the builder and constructs an Operation<[`GetRecoveryPointRestoreMetadata`](crate::operation::GetRecoveryPointRestoreMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecoveryPointRestoreMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRecoveryPointRestoreMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.backup_vault_name;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_34, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.recovery_point_arn;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_point_arn",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_point_arn = aws_smithy_http::label::fmt_string(input_35, false);
            if recovery_point_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_point_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}/restore-metadata", BackupVaultName = backup_vault_name, RecoveryPointArn = recovery_point_arn).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRecoveryPointRestoreMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRecoveryPointRestoreMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecoveryPointRestoreMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecoveryPointRestoreMetadata",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRecoveryPointRestoreMetadataInput`](crate::input::GetRecoveryPointRestoreMetadataInput)
    pub fn builder() -> crate::input::get_recovery_point_restore_metadata_input::Builder {
        crate::input::get_recovery_point_restore_metadata_input::Builder::default()
    }
}

/// See [`GetSupportedResourceTypesInput`](crate::input::GetSupportedResourceTypesInput)
pub mod get_supported_resource_types_input {
    /// A builder for [`GetSupportedResourceTypesInput`](crate::input::GetSupportedResourceTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetSupportedResourceTypesInput`](crate::input::GetSupportedResourceTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSupportedResourceTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSupportedResourceTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type GetSupportedResourceTypesInputOperationOutputAlias =
    crate::operation::GetSupportedResourceTypes;
#[doc(hidden)]
pub type GetSupportedResourceTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSupportedResourceTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetSupportedResourceTypes`](crate::operation::GetSupportedResourceTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSupportedResourceTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSupportedResourceTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/supported-resource-types").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSupportedResourceTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSupportedResourceTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSupportedResourceTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSupportedResourceTypes",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSupportedResourceTypesInput`](crate::input::GetSupportedResourceTypesInput)
    pub fn builder() -> crate::input::get_supported_resource_types_input::Builder {
        crate::input::get_supported_resource_types_input::Builder::default()
    }
}

/// See [`ListBackupJobsInput`](crate::input::ListBackupJobsInput)
pub mod list_backup_jobs_input {
    /// A builder for [`ListBackupJobsInput`](crate::input::ListBackupJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) by_resource_arn: std::option::Option<std::string::String>,
        pub(crate) by_state: std::option::Option<crate::model::BackupJobState>,
        pub(crate) by_backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) by_created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_created_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_resource_type: std::option::Option<std::string::String>,
        pub(crate) by_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Returns only backup jobs that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn by_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_resource_arn = Some(input.into());
            self
        }
        /// <p>Returns only backup jobs that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn set_by_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_resource_arn = input;
            self
        }
        /// <p>Returns only backup jobs that are in the specified state.</p>
        pub fn by_state(mut self, input: crate::model::BackupJobState) -> Self {
            self.by_state = Some(input);
            self
        }
        /// <p>Returns only backup jobs that are in the specified state.</p>
        pub fn set_by_state(
            mut self,
            input: std::option::Option<crate::model::BackupJobState>,
        ) -> Self {
            self.by_state = input;
            self
        }
        /// <p>Returns only backup jobs that will be stored in the specified backup vault. Backup
        /// vaults are identified by names that are unique to the account used to create them and the
        /// Amazon Web Services Region where they are created. They consist of lowercase letters,
        /// numbers, and hyphens.</p>
        pub fn by_backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_backup_vault_name = Some(input.into());
            self
        }
        /// <p>Returns only backup jobs that will be stored in the specified backup vault. Backup
        /// vaults are identified by names that are unique to the account used to create them and the
        /// Amazon Web Services Region where they are created. They consist of lowercase letters,
        /// numbers, and hyphens.</p>
        pub fn set_by_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_backup_vault_name = input;
            self
        }
        /// <p>Returns only backup jobs that were created before the specified date.</p>
        pub fn by_created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_before = Some(input);
            self
        }
        /// <p>Returns only backup jobs that were created before the specified date.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_before = input;
            self
        }
        /// <p>Returns only backup jobs that were created after the specified date.</p>
        pub fn by_created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_after = Some(input);
            self
        }
        /// <p>Returns only backup jobs that were created after the specified date.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_after = input;
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn by_resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_resource_type = Some(input.into());
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn set_by_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_resource_type = input;
            self
        }
        /// <p>The account ID to list the jobs from. Returns only backup jobs associated with the
        /// specified account ID.</p>
        /// <p>If used from an Organizations management account, passing <code>*</code> returns
        /// all jobs across the organization.</p>
        pub fn by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_account_id = Some(input.into());
            self
        }
        /// <p>The account ID to list the jobs from. Returns only backup jobs associated with the
        /// specified account ID.</p>
        /// <p>If used from an Organizations management account, passing <code>*</code> returns
        /// all jobs across the organization.</p>
        pub fn set_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupJobsInput`](crate::input::ListBackupJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackupJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackupJobsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                by_resource_arn: self.by_resource_arn,
                by_state: self.by_state,
                by_backup_vault_name: self.by_backup_vault_name,
                by_created_before: self.by_created_before,
                by_created_after: self.by_created_after,
                by_resource_type: self.by_resource_type,
                by_account_id: self.by_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackupJobsInputOperationOutputAlias = crate::operation::ListBackupJobs;
#[doc(hidden)]
pub type ListBackupJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBackupJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListBackupJobs`](crate::operation::ListBackupJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackupJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBackupJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/backup-jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBackupJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            if let Some(inner_37) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_37).encode(),
                );
            }
            if let Some(inner_38) = &_input.by_resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_38),
                );
            }
            if let Some(inner_39) = &_input.by_state {
                query.push_kv("state", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if let Some(inner_40) = &_input.by_backup_vault_name {
                query.push_kv(
                    "backupVaultName",
                    &aws_smithy_http::query::fmt_string(&inner_40),
                );
            }
            if let Some(inner_41) = &_input.by_created_before {
                query.push_kv(
                    "createdBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_41,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_42) = &_input.by_created_after {
                query.push_kv(
                    "createdAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_42,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_43) = &_input.by_resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_43),
                );
            }
            if let Some(inner_44) = &_input.by_account_id {
                query.push_kv("accountId", &aws_smithy_http::query::fmt_string(&inner_44));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBackupJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBackupJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackupJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackupJobs",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBackupJobsInput`](crate::input::ListBackupJobsInput)
    pub fn builder() -> crate::input::list_backup_jobs_input::Builder {
        crate::input::list_backup_jobs_input::Builder::default()
    }
}

/// See [`ListBackupPlansInput`](crate::input::ListBackupPlansInput)
pub mod list_backup_plans_input {
    /// A builder for [`ListBackupPlansInput`](crate::input::ListBackupPlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) include_deleted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup
        /// plans when set to <code>TRUE</code>.</p>
        pub fn include_deleted(mut self, input: bool) -> Self {
            self.include_deleted = Some(input);
            self
        }
        /// <p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup
        /// plans when set to <code>TRUE</code>.</p>
        pub fn set_include_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.include_deleted = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupPlansInput`](crate::input::ListBackupPlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackupPlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackupPlansInput {
                next_token: self.next_token,
                max_results: self.max_results,
                include_deleted: self.include_deleted,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackupPlansInputOperationOutputAlias = crate::operation::ListBackupPlans;
#[doc(hidden)]
pub type ListBackupPlansInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBackupPlansInput {
    /// Consumes the builder and constructs an Operation<[`ListBackupPlans`](crate::operation::ListBackupPlans)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackupPlans,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBackupPlansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/backup/plans").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBackupPlansInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_45) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_45));
            }
            if let Some(inner_46) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_46).encode(),
                );
            }
            if let Some(inner_47) = &_input.include_deleted {
                query.push_kv(
                    "includeDeleted",
                    aws_smithy_types::primitive::Encoder::from(*inner_47).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBackupPlansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBackupPlansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackupPlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackupPlans",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBackupPlansInput`](crate::input::ListBackupPlansInput)
    pub fn builder() -> crate::input::list_backup_plans_input::Builder {
        crate::input::list_backup_plans_input::Builder::default()
    }
}

/// See [`ListBackupPlanTemplatesInput`](crate::input::ListBackupPlanTemplatesInput)
pub mod list_backup_plan_templates_input {
    /// A builder for [`ListBackupPlanTemplatesInput`](crate::input::ListBackupPlanTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupPlanTemplatesInput`](crate::input::ListBackupPlanTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackupPlanTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackupPlanTemplatesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackupPlanTemplatesInputOperationOutputAlias =
    crate::operation::ListBackupPlanTemplates;
#[doc(hidden)]
pub type ListBackupPlanTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBackupPlanTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListBackupPlanTemplates`](crate::operation::ListBackupPlanTemplates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackupPlanTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBackupPlanTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/backup/template/plans").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBackupPlanTemplatesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_48) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_48));
            }
            if let Some(inner_49) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_49).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBackupPlanTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBackupPlanTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackupPlanTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackupPlanTemplates",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBackupPlanTemplatesInput`](crate::input::ListBackupPlanTemplatesInput)
    pub fn builder() -> crate::input::list_backup_plan_templates_input::Builder {
        crate::input::list_backup_plan_templates_input::Builder::default()
    }
}

/// See [`ListBackupPlanVersionsInput`](crate::input::ListBackupPlanVersionsInput)
pub mod list_backup_plan_versions_input {
    /// A builder for [`ListBackupPlanVersionsInput`](crate::input::ListBackupPlanVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupPlanVersionsInput`](crate::input::ListBackupPlanVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackupPlanVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackupPlanVersionsInput {
                backup_plan_id: self.backup_plan_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackupPlanVersionsInputOperationOutputAlias = crate::operation::ListBackupPlanVersions;
#[doc(hidden)]
pub type ListBackupPlanVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBackupPlanVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListBackupPlanVersions`](crate::operation::ListBackupPlanVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackupPlanVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBackupPlanVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.backup_plan_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_50, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}/versions",
                BackupPlanId = backup_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBackupPlanVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_51) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_51));
            }
            if let Some(inner_52) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_52).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBackupPlanVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBackupPlanVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackupPlanVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackupPlanVersions",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBackupPlanVersionsInput`](crate::input::ListBackupPlanVersionsInput)
    pub fn builder() -> crate::input::list_backup_plan_versions_input::Builder {
        crate::input::list_backup_plan_versions_input::Builder::default()
    }
}

/// See [`ListBackupSelectionsInput`](crate::input::ListBackupSelectionsInput)
pub mod list_backup_selections_input {
    /// A builder for [`ListBackupSelectionsInput`](crate::input::ListBackupSelectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupSelectionsInput`](crate::input::ListBackupSelectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackupSelectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackupSelectionsInput {
                backup_plan_id: self.backup_plan_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackupSelectionsInputOperationOutputAlias = crate::operation::ListBackupSelections;
#[doc(hidden)]
pub type ListBackupSelectionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBackupSelectionsInput {
    /// Consumes the builder and constructs an Operation<[`ListBackupSelections`](crate::operation::ListBackupSelections)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackupSelections,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBackupSelectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.backup_plan_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_53, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}/selections",
                BackupPlanId = backup_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBackupSelectionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_54) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_54));
            }
            if let Some(inner_55) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_55).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBackupSelectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBackupSelectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackupSelections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackupSelections",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBackupSelectionsInput`](crate::input::ListBackupSelectionsInput)
    pub fn builder() -> crate::input::list_backup_selections_input::Builder {
        crate::input::list_backup_selections_input::Builder::default()
    }
}

/// See [`ListBackupVaultsInput`](crate::input::ListBackupVaultsInput)
pub mod list_backup_vaults_input {
    /// A builder for [`ListBackupVaultsInput`](crate::input::ListBackupVaultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupVaultsInput`](crate::input::ListBackupVaultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackupVaultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackupVaultsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackupVaultsInputOperationOutputAlias = crate::operation::ListBackupVaults;
#[doc(hidden)]
pub type ListBackupVaultsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBackupVaultsInput {
    /// Consumes the builder and constructs an Operation<[`ListBackupVaults`](crate::operation::ListBackupVaults)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackupVaults,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBackupVaultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/backup-vaults").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBackupVaultsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_56) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_56));
            }
            if let Some(inner_57) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_57).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBackupVaultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBackupVaultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackupVaults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackupVaults",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBackupVaultsInput`](crate::input::ListBackupVaultsInput)
    pub fn builder() -> crate::input::list_backup_vaults_input::Builder {
        crate::input::list_backup_vaults_input::Builder::default()
    }
}

/// See [`ListCopyJobsInput`](crate::input::ListCopyJobsInput)
pub mod list_copy_jobs_input {
    /// A builder for [`ListCopyJobsInput`](crate::input::ListCopyJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) by_resource_arn: std::option::Option<std::string::String>,
        pub(crate) by_state: std::option::Option<crate::model::CopyJobState>,
        pub(crate) by_created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_created_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_resource_type: std::option::Option<std::string::String>,
        pub(crate) by_destination_vault_arn: std::option::Option<std::string::String>,
        pub(crate) by_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return maxResults number of items, NextToken allows you to return more items in
        /// your list starting at the location pointed to by the next token. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return maxResults number of items, NextToken allows you to return more items in
        /// your list starting at the location pointed to by the next token. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN).
        /// </p>
        pub fn by_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_resource_arn = Some(input.into());
            self
        }
        /// <p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN).
        /// </p>
        pub fn set_by_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_resource_arn = input;
            self
        }
        /// <p>Returns only copy jobs that are in the specified state.</p>
        pub fn by_state(mut self, input: crate::model::CopyJobState) -> Self {
            self.by_state = Some(input);
            self
        }
        /// <p>Returns only copy jobs that are in the specified state.</p>
        pub fn set_by_state(
            mut self,
            input: std::option::Option<crate::model::CopyJobState>,
        ) -> Self {
            self.by_state = input;
            self
        }
        /// <p>Returns only copy jobs that were created before the specified date.</p>
        pub fn by_created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_before = Some(input);
            self
        }
        /// <p>Returns only copy jobs that were created before the specified date.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_before = input;
            self
        }
        /// <p>Returns only copy jobs that were created after the specified date.</p>
        pub fn by_created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_after = Some(input);
            self
        }
        /// <p>Returns only copy jobs that were created after the specified date.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_after = input;
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn by_resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_resource_type = Some(input.into());
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn set_by_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_resource_type = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy
        /// from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
        /// </p>
        pub fn by_destination_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_destination_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy
        /// from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
        /// </p>
        pub fn set_by_destination_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_destination_vault_arn = input;
            self
        }
        /// <p>The account ID to list the jobs from. Returns only copy jobs associated with the
        /// specified account ID.</p>
        pub fn by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_account_id = Some(input.into());
            self
        }
        /// <p>The account ID to list the jobs from. Returns only copy jobs associated with the
        /// specified account ID.</p>
        pub fn set_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCopyJobsInput`](crate::input::ListCopyJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCopyJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCopyJobsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                by_resource_arn: self.by_resource_arn,
                by_state: self.by_state,
                by_created_before: self.by_created_before,
                by_created_after: self.by_created_after,
                by_resource_type: self.by_resource_type,
                by_destination_vault_arn: self.by_destination_vault_arn,
                by_account_id: self.by_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCopyJobsInputOperationOutputAlias = crate::operation::ListCopyJobs;
#[doc(hidden)]
pub type ListCopyJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCopyJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListCopyJobs`](crate::operation::ListCopyJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCopyJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCopyJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/copy-jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListCopyJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_58) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_58));
            }
            if let Some(inner_59) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_59).encode(),
                );
            }
            if let Some(inner_60) = &_input.by_resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_60),
                );
            }
            if let Some(inner_61) = &_input.by_state {
                query.push_kv("state", &aws_smithy_http::query::fmt_string(&inner_61));
            }
            if let Some(inner_62) = &_input.by_created_before {
                query.push_kv(
                    "createdBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_62,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_63) = &_input.by_created_after {
                query.push_kv(
                    "createdAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_63,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_64) = &_input.by_resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_64),
                );
            }
            if let Some(inner_65) = &_input.by_destination_vault_arn {
                query.push_kv(
                    "destinationVaultArn",
                    &aws_smithy_http::query::fmt_string(&inner_65),
                );
            }
            if let Some(inner_66) = &_input.by_account_id {
                query.push_kv("accountId", &aws_smithy_http::query::fmt_string(&inner_66));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCopyJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCopyJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCopyJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCopyJobs",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCopyJobsInput`](crate::input::ListCopyJobsInput)
    pub fn builder() -> crate::input::list_copy_jobs_input::Builder {
        crate::input::list_copy_jobs_input::Builder::default()
    }
}

/// See [`ListFrameworksInput`](crate::input::ListFrameworksInput)
pub mod list_frameworks_input {
    /// A builder for [`ListFrameworksInput`](crate::input::ListFrameworksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFrameworksInput`](crate::input::ListFrameworksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFrameworksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFrameworksInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFrameworksInputOperationOutputAlias = crate::operation::ListFrameworks;
#[doc(hidden)]
pub type ListFrameworksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFrameworksInput {
    /// Consumes the builder and constructs an Operation<[`ListFrameworks`](crate::operation::ListFrameworks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFrameworks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFrameworksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/audit/frameworks").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFrameworksInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_67) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_67).encode(),
                );
            }
            if let Some(inner_68) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_68));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFrameworksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFrameworksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFrameworks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFrameworks",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFrameworksInput`](crate::input::ListFrameworksInput)
    pub fn builder() -> crate::input::list_frameworks_input::Builder {
        crate::input::list_frameworks_input::Builder::default()
    }
}

/// See [`ListProtectedResourcesInput`](crate::input::ListProtectedResourcesInput)
pub mod list_protected_resources_input {
    /// A builder for [`ListProtectedResourcesInput`](crate::input::ListProtectedResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProtectedResourcesInput`](crate::input::ListProtectedResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProtectedResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProtectedResourcesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProtectedResourcesInputOperationOutputAlias = crate::operation::ListProtectedResources;
#[doc(hidden)]
pub type ListProtectedResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProtectedResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListProtectedResources`](crate::operation::ListProtectedResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProtectedResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProtectedResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/resources").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListProtectedResourcesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_69) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_69));
            }
            if let Some(inner_70) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_70).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProtectedResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProtectedResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProtectedResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProtectedResources",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProtectedResourcesInput`](crate::input::ListProtectedResourcesInput)
    pub fn builder() -> crate::input::list_protected_resources_input::Builder {
        crate::input::list_protected_resources_input::Builder::default()
    }
}

/// See [`ListRecoveryPointsByBackupVaultInput`](crate::input::ListRecoveryPointsByBackupVaultInput)
pub mod list_recovery_points_by_backup_vault_input {
    /// A builder for [`ListRecoveryPointsByBackupVaultInput`](crate::input::ListRecoveryPointsByBackupVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) by_resource_arn: std::option::Option<std::string::String>,
        pub(crate) by_resource_type: std::option::Option<std::string::String>,
        pub(crate) by_backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) by_created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_created_after: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        /// <note>
        /// <p>Backup vault name might not be available when a supported service creates the
        /// backup.</p>
        /// </note>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        /// <note>
        /// <p>Backup vault name might not be available when a supported service creates the
        /// backup.</p>
        /// </note>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Returns only recovery points that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn by_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_resource_arn = Some(input.into());
            self
        }
        /// <p>Returns only recovery points that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn set_by_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_resource_arn = input;
            self
        }
        /// <p>Returns only recovery points that match the specified resource type.</p>
        pub fn by_resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_resource_type = Some(input.into());
            self
        }
        /// <p>Returns only recovery points that match the specified resource type.</p>
        pub fn set_by_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_resource_type = input;
            self
        }
        /// <p>Returns only recovery points that match the specified backup plan ID.</p>
        pub fn by_backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_backup_plan_id = Some(input.into());
            self
        }
        /// <p>Returns only recovery points that match the specified backup plan ID.</p>
        pub fn set_by_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_backup_plan_id = input;
            self
        }
        /// <p>Returns only recovery points that were created before the specified timestamp.</p>
        pub fn by_created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_before = Some(input);
            self
        }
        /// <p>Returns only recovery points that were created before the specified timestamp.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_before = input;
            self
        }
        /// <p>Returns only recovery points that were created after the specified timestamp.</p>
        pub fn by_created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_after = Some(input);
            self
        }
        /// <p>Returns only recovery points that were created after the specified timestamp.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_after = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecoveryPointsByBackupVaultInput`](crate::input::ListRecoveryPointsByBackupVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecoveryPointsByBackupVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecoveryPointsByBackupVaultInput {
                backup_vault_name: self.backup_vault_name,
                next_token: self.next_token,
                max_results: self.max_results,
                by_resource_arn: self.by_resource_arn,
                by_resource_type: self.by_resource_type,
                by_backup_plan_id: self.by_backup_plan_id,
                by_created_before: self.by_created_before,
                by_created_after: self.by_created_after,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecoveryPointsByBackupVaultInputOperationOutputAlias =
    crate::operation::ListRecoveryPointsByBackupVault;
#[doc(hidden)]
pub type ListRecoveryPointsByBackupVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecoveryPointsByBackupVaultInput {
    /// Consumes the builder and constructs an Operation<[`ListRecoveryPointsByBackupVault`](crate::operation::ListRecoveryPointsByBackupVault)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecoveryPointsByBackupVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecoveryPointsByBackupVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.backup_vault_name;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_71, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/recovery-points",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRecoveryPointsByBackupVaultInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_72) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_72));
            }
            if let Some(inner_73) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_73).encode(),
                );
            }
            if let Some(inner_74) = &_input.by_resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_74),
                );
            }
            if let Some(inner_75) = &_input.by_resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_75),
                );
            }
            if let Some(inner_76) = &_input.by_backup_plan_id {
                query.push_kv(
                    "backupPlanId",
                    &aws_smithy_http::query::fmt_string(&inner_76),
                );
            }
            if let Some(inner_77) = &_input.by_created_before {
                query.push_kv(
                    "createdBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_77,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_78) = &_input.by_created_after {
                query.push_kv(
                    "createdAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_78,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecoveryPointsByBackupVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecoveryPointsByBackupVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecoveryPointsByBackupVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecoveryPointsByBackupVault",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecoveryPointsByBackupVaultInput`](crate::input::ListRecoveryPointsByBackupVaultInput)
    pub fn builder() -> crate::input::list_recovery_points_by_backup_vault_input::Builder {
        crate::input::list_recovery_points_by_backup_vault_input::Builder::default()
    }
}

/// See [`ListRecoveryPointsByResourceInput`](crate::input::ListRecoveryPointsByResourceInput)
pub mod list_recovery_points_by_resource_input {
    /// A builder for [`ListRecoveryPointsByResourceInput`](crate::input::ListRecoveryPointsByResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        /// <note>
        /// <p>Amazon RDS requires a value of at least 20.</p>
        /// </note>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        /// <note>
        /// <p>Amazon RDS requires a value of at least 20.</p>
        /// </note>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecoveryPointsByResourceInput`](crate::input::ListRecoveryPointsByResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecoveryPointsByResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecoveryPointsByResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecoveryPointsByResourceInputOperationOutputAlias =
    crate::operation::ListRecoveryPointsByResource;
#[doc(hidden)]
pub type ListRecoveryPointsByResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecoveryPointsByResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListRecoveryPointsByResource`](crate::operation::ListRecoveryPointsByResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecoveryPointsByResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecoveryPointsByResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.resource_arn;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_79, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resources/{ResourceArn}/recovery-points",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRecoveryPointsByResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_80) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_80));
            }
            if let Some(inner_81) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_81).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecoveryPointsByResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecoveryPointsByResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecoveryPointsByResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecoveryPointsByResource",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecoveryPointsByResourceInput`](crate::input::ListRecoveryPointsByResourceInput)
    pub fn builder() -> crate::input::list_recovery_points_by_resource_input::Builder {
        crate::input::list_recovery_points_by_resource_input::Builder::default()
    }
}

/// See [`ListReportJobsInput`](crate::input::ListReportJobsInput)
pub mod list_report_jobs_input {
    /// A builder for [`ListReportJobsInput`](crate::input::ListReportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) by_report_plan_name: std::option::Option<std::string::String>,
        pub(crate) by_creation_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_creation_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_status: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns only report jobs with the specified report plan name.</p>
        pub fn by_report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_report_plan_name = Some(input.into());
            self
        }
        /// <p>Returns only report jobs with the specified report plan name.</p>
        pub fn set_by_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_report_plan_name = input;
            self
        }
        /// <p>Returns only report jobs that were created before the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn by_creation_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_creation_before = Some(input);
            self
        }
        /// <p>Returns only report jobs that were created before the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn set_by_creation_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_creation_before = input;
            self
        }
        /// <p>Returns only report jobs that were created after the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn by_creation_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_creation_after = Some(input);
            self
        }
        /// <p>Returns only report jobs that were created after the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn set_by_creation_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_creation_after = input;
            self
        }
        /// <p>Returns only report jobs that are in the specified status. The statuses are:</p>
        /// <p>
        /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
        /// </p>
        pub fn by_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_status = Some(input.into());
            self
        }
        /// <p>Returns only report jobs that are in the specified status. The statuses are:</p>
        /// <p>
        /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
        /// </p>
        pub fn set_by_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.by_status = input;
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportJobsInput`](crate::input::ListReportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReportJobsInput {
                by_report_plan_name: self.by_report_plan_name,
                by_creation_before: self.by_creation_before,
                by_creation_after: self.by_creation_after,
                by_status: self.by_status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReportJobsInputOperationOutputAlias = crate::operation::ListReportJobs;
#[doc(hidden)]
pub type ListReportJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListReportJobs`](crate::operation::ListReportJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReportJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/audit/report-jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListReportJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_82) = &_input.by_report_plan_name {
                query.push_kv(
                    "ReportPlanName",
                    &aws_smithy_http::query::fmt_string(&inner_82),
                );
            }
            if let Some(inner_83) = &_input.by_creation_before {
                query.push_kv(
                    "CreationBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_83,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_84) = &_input.by_creation_after {
                query.push_kv(
                    "CreationAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_84,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_85) = &_input.by_status {
                query.push_kv("Status", &aws_smithy_http::query::fmt_string(&inner_85));
            }
            if let Some(inner_86) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_86).encode(),
                );
            }
            if let Some(inner_87) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_87));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReportJobs",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReportJobsInput`](crate::input::ListReportJobsInput)
    pub fn builder() -> crate::input::list_report_jobs_input::Builder {
        crate::input::list_report_jobs_input::Builder::default()
    }
}

/// See [`ListReportPlansInput`](crate::input::ListReportPlansInput)
pub mod list_report_plans_input {
    /// A builder for [`ListReportPlansInput`](crate::input::ListReportPlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportPlansInput`](crate::input::ListReportPlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReportPlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReportPlansInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReportPlansInputOperationOutputAlias = crate::operation::ListReportPlans;
#[doc(hidden)]
pub type ListReportPlansInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReportPlansInput {
    /// Consumes the builder and constructs an Operation<[`ListReportPlans`](crate::operation::ListReportPlans)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReportPlans,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReportPlansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/audit/report-plans").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListReportPlansInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_88) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_88).encode(),
                );
            }
            if let Some(inner_89) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_89));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReportPlansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReportPlansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReportPlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReportPlans",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReportPlansInput`](crate::input::ListReportPlansInput)
    pub fn builder() -> crate::input::list_report_plans_input::Builder {
        crate::input::list_report_plans_input::Builder::default()
    }
}

/// See [`ListRestoreJobsInput`](crate::input::ListRestoreJobsInput)
pub mod list_restore_jobs_input {
    /// A builder for [`ListRestoreJobsInput`](crate::input::ListRestoreJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) by_account_id: std::option::Option<std::string::String>,
        pub(crate) by_created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_created_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) by_status: std::option::Option<crate::model::RestoreJobStatus>,
    }
    impl Builder {
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The account ID to list the jobs from. Returns only restore jobs associated with the
        /// specified account ID.</p>
        pub fn by_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.by_account_id = Some(input.into());
            self
        }
        /// <p>The account ID to list the jobs from. Returns only restore jobs associated with the
        /// specified account ID.</p>
        pub fn set_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.by_account_id = input;
            self
        }
        /// <p>Returns only restore jobs that were created before the specified date.</p>
        pub fn by_created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_before = Some(input);
            self
        }
        /// <p>Returns only restore jobs that were created before the specified date.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_before = input;
            self
        }
        /// <p>Returns only restore jobs that were created after the specified date.</p>
        pub fn by_created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.by_created_after = Some(input);
            self
        }
        /// <p>Returns only restore jobs that were created after the specified date.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.by_created_after = input;
            self
        }
        /// <p>Returns only restore jobs associated with the specified job status.</p>
        pub fn by_status(mut self, input: crate::model::RestoreJobStatus) -> Self {
            self.by_status = Some(input);
            self
        }
        /// <p>Returns only restore jobs associated with the specified job status.</p>
        pub fn set_by_status(
            mut self,
            input: std::option::Option<crate::model::RestoreJobStatus>,
        ) -> Self {
            self.by_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRestoreJobsInput`](crate::input::ListRestoreJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRestoreJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRestoreJobsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                by_account_id: self.by_account_id,
                by_created_before: self.by_created_before,
                by_created_after: self.by_created_after,
                by_status: self.by_status,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRestoreJobsInputOperationOutputAlias = crate::operation::ListRestoreJobs;
#[doc(hidden)]
pub type ListRestoreJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRestoreJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListRestoreJobs`](crate::operation::ListRestoreJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRestoreJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRestoreJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/restore-jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRestoreJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_90) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_90));
            }
            if let Some(inner_91) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_91).encode(),
                );
            }
            if let Some(inner_92) = &_input.by_account_id {
                query.push_kv("accountId", &aws_smithy_http::query::fmt_string(&inner_92));
            }
            if let Some(inner_93) = &_input.by_created_before {
                query.push_kv(
                    "createdBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_93,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_94) = &_input.by_created_after {
                query.push_kv(
                    "createdAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_94,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_95) = &_input.by_status {
                query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_95));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRestoreJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRestoreJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRestoreJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRestoreJobs",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRestoreJobsInput`](crate::input::ListRestoreJobsInput)
    pub fn builder() -> crate::input::list_restore_jobs_input::Builder {
        crate::input::list_restore_jobs_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the type of resource. Valid targets for <code>ListTags</code> are recovery
        /// points, backup plans, and backup vaults.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the type of resource. Valid targets for <code>ListTags</code> are recovery
        /// points, backup plans, and backup vaults.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_96 = &_input.resource_arn;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_96, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTagsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_97) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_97));
            }
            if let Some(inner_98) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_98).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags", "backup",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`PutBackupVaultAccessPolicyInput`](crate::input::PutBackupVaultAccessPolicyInput)
pub mod put_backup_vault_access_policy_input {
    /// A builder for [`PutBackupVaultAccessPolicyInput`](crate::input::PutBackupVaultAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>The backup vault access policy document in JSON format.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The backup vault access policy document in JSON format.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBackupVaultAccessPolicyInput`](crate::input::PutBackupVaultAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBackupVaultAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBackupVaultAccessPolicyInput {
                backup_vault_name: self.backup_vault_name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBackupVaultAccessPolicyInputOperationOutputAlias =
    crate::operation::PutBackupVaultAccessPolicy;
#[doc(hidden)]
pub type PutBackupVaultAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutBackupVaultAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutBackupVaultAccessPolicy`](crate::operation::PutBackupVaultAccessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBackupVaultAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBackupVaultAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_99 = &_input.backup_vault_name;
            let input_99 =
                input_99
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_99, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/access-policy",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBackupVaultAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBackupVaultAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_backup_vault_access_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBackupVaultAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBackupVaultAccessPolicy",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBackupVaultAccessPolicyInput`](crate::input::PutBackupVaultAccessPolicyInput)
    pub fn builder() -> crate::input::put_backup_vault_access_policy_input::Builder {
        crate::input::put_backup_vault_access_policy_input::Builder::default()
    }
}

/// See [`PutBackupVaultLockConfigurationInput`](crate::input::PutBackupVaultLockConfigurationInput)
pub mod put_backup_vault_lock_configuration_input {
    /// A builder for [`PutBackupVaultLockConfigurationInput`](crate::input::PutBackupVaultLockConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) min_retention_days: std::option::Option<i64>,
        pub(crate) max_retention_days: std::option::Option<i64>,
        pub(crate) changeable_for_days: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Backup Vault Lock configuration that specifies the name of the backup
        /// vault it protects.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the name of the backup
        /// vault it protects.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the minimum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to retain certain data for at least seven
        /// years (2555 days).</p>
        /// <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention
        /// period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or longer than the minimum retention
        /// period. If the job's retention period is shorter than that minimum retention period, then
        /// the vault fails that backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn min_retention_days(mut self, input: i64) -> Self {
            self.min_retention_days = Some(input);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the minimum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to retain certain data for at least seven
        /// years (2555 days).</p>
        /// <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention
        /// period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or longer than the minimum retention
        /// period. If the job's retention period is shorter than that minimum retention period, then
        /// the vault fails that backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn set_min_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.min_retention_days = input;
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the maximum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to destroy certain data after retaining
        /// it for four years (1460 days).</p>
        /// <p>If this parameter is not included, Vault Lock does not enforce a maximum retention
        /// period on the recovery points in the vault. If this parameter is included without a value,
        /// Vault Lock will not enforce a maximum retention period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or shorter than the maximum retention
        /// period. If the job's retention period is longer than that maximum retention period, then
        /// the vault fails the backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn max_retention_days(mut self, input: i64) -> Self {
            self.max_retention_days = Some(input);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the maximum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to destroy certain data after retaining
        /// it for four years (1460 days).</p>
        /// <p>If this parameter is not included, Vault Lock does not enforce a maximum retention
        /// period on the recovery points in the vault. If this parameter is included without a value,
        /// Vault Lock will not enforce a maximum retention period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or shorter than the maximum retention
        /// period. If the job's retention period is longer than that maximum retention period, then
        /// the vault fails the backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn set_max_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.max_retention_days = input;
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the number of days before
        /// the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at
        /// 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p>
        /// <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect
        /// and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or
        /// greater.</p>
        /// <p>Before the lock date, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault
        /// Lock becomes immutable and cannot be changed or deleted.</p>
        /// <p>If this parameter is not specified, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code> at any time.</p>
        pub fn changeable_for_days(mut self, input: i64) -> Self {
            self.changeable_for_days = Some(input);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the number of days before
        /// the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at
        /// 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p>
        /// <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect
        /// and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or
        /// greater.</p>
        /// <p>Before the lock date, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault
        /// Lock becomes immutable and cannot be changed or deleted.</p>
        /// <p>If this parameter is not specified, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code> at any time.</p>
        pub fn set_changeable_for_days(mut self, input: std::option::Option<i64>) -> Self {
            self.changeable_for_days = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBackupVaultLockConfigurationInput`](crate::input::PutBackupVaultLockConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBackupVaultLockConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBackupVaultLockConfigurationInput {
                backup_vault_name: self.backup_vault_name,
                min_retention_days: self.min_retention_days,
                max_retention_days: self.max_retention_days,
                changeable_for_days: self.changeable_for_days,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBackupVaultLockConfigurationInputOperationOutputAlias =
    crate::operation::PutBackupVaultLockConfiguration;
#[doc(hidden)]
pub type PutBackupVaultLockConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutBackupVaultLockConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBackupVaultLockConfiguration`](crate::operation::PutBackupVaultLockConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBackupVaultLockConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBackupVaultLockConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_100 = &_input.backup_vault_name;
            let input_100 =
                input_100
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_100, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/vault-lock",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBackupVaultLockConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBackupVaultLockConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_backup_vault_lock_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBackupVaultLockConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBackupVaultLockConfiguration",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBackupVaultLockConfigurationInput`](crate::input::PutBackupVaultLockConfigurationInput)
    pub fn builder() -> crate::input::put_backup_vault_lock_configuration_input::Builder {
        crate::input::put_backup_vault_lock_configuration_input::Builder::default()
    }
}

/// See [`PutBackupVaultNotificationsInput`](crate::input::PutBackupVaultNotificationsInput)
pub mod put_backup_vault_notifications_input {
    /// A builder for [`PutBackupVaultNotificationsInput`](crate::input::PutBackupVaultNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) backup_vault_events:
            std::option::Option<std::vec::Vec<crate::model::BackupVaultEvent>>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for
        /// example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for
        /// example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// Appends an item to `backup_vault_events`.
        ///
        /// To override the contents of this collection use [`set_backup_vault_events`](Self::set_backup_vault_events).
        ///
        /// <p>An array of events that indicate the status of jobs to back up resources to the backup
        /// vault.</p>
        /// <p>For common use cases and code samples, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html">Using Amazon SNS to
        /// track Backup events</a>.</p>
        /// <p>The following events are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BACKUP_JOB_STARTED</code> | <code>BACKUP_JOB_COMPLETED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COPY_JOB_STARTED</code> | <code>COPY_JOB_SUCCESSFUL</code> |
        /// <code>COPY_JOB_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTORE_JOB_STARTED</code> | <code>RESTORE_JOB_COMPLETED</code> |
        /// <code>RECOVERY_POINT_MODIFIED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Ignore the list below because it includes deprecated events. Refer to the list
        /// above.</p>
        /// </note>
        pub fn backup_vault_events(
            mut self,
            input: impl Into<crate::model::BackupVaultEvent>,
        ) -> Self {
            let mut v = self.backup_vault_events.unwrap_or_default();
            v.push(input.into());
            self.backup_vault_events = Some(v);
            self
        }
        /// <p>An array of events that indicate the status of jobs to back up resources to the backup
        /// vault.</p>
        /// <p>For common use cases and code samples, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html">Using Amazon SNS to
        /// track Backup events</a>.</p>
        /// <p>The following events are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BACKUP_JOB_STARTED</code> | <code>BACKUP_JOB_COMPLETED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COPY_JOB_STARTED</code> | <code>COPY_JOB_SUCCESSFUL</code> |
        /// <code>COPY_JOB_FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTORE_JOB_STARTED</code> | <code>RESTORE_JOB_COMPLETED</code> |
        /// <code>RECOVERY_POINT_MODIFIED</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Ignore the list below because it includes deprecated events. Refer to the list
        /// above.</p>
        /// </note>
        pub fn set_backup_vault_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupVaultEvent>>,
        ) -> Self {
            self.backup_vault_events = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBackupVaultNotificationsInput`](crate::input::PutBackupVaultNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBackupVaultNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBackupVaultNotificationsInput {
                backup_vault_name: self.backup_vault_name,
                sns_topic_arn: self.sns_topic_arn,
                backup_vault_events: self.backup_vault_events,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBackupVaultNotificationsInputOperationOutputAlias =
    crate::operation::PutBackupVaultNotifications;
#[doc(hidden)]
pub type PutBackupVaultNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutBackupVaultNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`PutBackupVaultNotifications`](crate::operation::PutBackupVaultNotifications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBackupVaultNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBackupVaultNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_101 = &_input.backup_vault_name;
            let input_101 =
                input_101
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_101, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/notification-configuration",
                BackupVaultName = backup_vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBackupVaultNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBackupVaultNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_backup_vault_notifications(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBackupVaultNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBackupVaultNotifications",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBackupVaultNotificationsInput`](crate::input::PutBackupVaultNotificationsInput)
    pub fn builder() -> crate::input::put_backup_vault_notifications_input::Builder {
        crate::input::put_backup_vault_notifications_input::Builder::default()
    }
}

/// See [`StartBackupJobInput`](crate::input::StartBackupJobInput)
pub mod start_backup_job_input {
    /// A builder for [`StartBackupJobInput`](crate::input::StartBackupJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) start_window_minutes: std::option::Option<i64>,
        pub(crate) complete_window_minutes: std::option::Option<i64>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
        pub(crate) recovery_point_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) backup_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartBackupJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartBackupJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional, and the default is 8 hours.</p>
        pub fn start_window_minutes(mut self, input: i64) -> Self {
            self.start_window_minutes = Some(input);
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional, and the default is 8 hours.</p>
        pub fn set_start_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.start_window_minutes = input;
            self
        }
        /// <p>A value in minutes during which a successfully started backup must complete, or else AWS
        /// Backup will cancel the job. This value is optional. This value begins counting down from
        /// when the backup was scheduled. It does not add additional time for
        /// <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p>
        pub fn complete_window_minutes(mut self, input: i64) -> Self {
            self.complete_window_minutes = Some(input);
            self
        }
        /// <p>A value in minutes during which a successfully started backup must complete, or else AWS
        /// Backup will cancel the job. This value is optional. This value begins counting down from
        /// when the backup was scheduled. It does not add additional time for
        /// <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p>
        pub fn set_complete_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.complete_window_minutes = input;
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup will transition and expire backups automatically according
        /// to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup will transition and expire backups automatically according
        /// to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Adds a key-value pair to `recovery_point_tags`.
        ///
        /// To override the contents of this collection use [`set_recovery_point_tags`](Self::set_recovery_point_tags).
        ///
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair.</p>
        pub fn recovery_point_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.recovery_point_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.recovery_point_tags = Some(hash_map);
            self
        }
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair.</p>
        pub fn set_recovery_point_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.recovery_point_tags = input;
            self
        }
        /// Adds a key-value pair to `backup_options`.
        ///
        /// To override the contents of this collection use [`set_backup_options`](Self::set_backup_options).
        ///
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
        /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
        /// <code>"WindowsVSS""disabled"</code> to create a regular backup. The
        /// <code>WindowsVSS</code> option is not enabled by default.</p>
        pub fn backup_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.backup_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.backup_options = Some(hash_map);
            self
        }
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
        /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
        /// <code>"WindowsVSS""disabled"</code> to create a regular backup. The
        /// <code>WindowsVSS</code> option is not enabled by default.</p>
        pub fn set_backup_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.backup_options = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBackupJobInput`](crate::input::StartBackupJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartBackupJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartBackupJobInput {
                backup_vault_name: self.backup_vault_name,
                resource_arn: self.resource_arn,
                iam_role_arn: self.iam_role_arn,
                idempotency_token: self.idempotency_token,
                start_window_minutes: self.start_window_minutes,
                complete_window_minutes: self.complete_window_minutes,
                lifecycle: self.lifecycle,
                recovery_point_tags: self.recovery_point_tags,
                backup_options: self.backup_options,
            })
        }
    }
}
#[doc(hidden)]
pub type StartBackupJobInputOperationOutputAlias = crate::operation::StartBackupJob;
#[doc(hidden)]
pub type StartBackupJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartBackupJobInput {
    /// Consumes the builder and constructs an Operation<[`StartBackupJob`](crate::operation::StartBackupJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartBackupJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartBackupJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/backup-jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartBackupJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartBackupJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_backup_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartBackupJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartBackupJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartBackupJobInput`](crate::input::StartBackupJobInput)
    pub fn builder() -> crate::input::start_backup_job_input::Builder {
        crate::input::start_backup_job_input::Builder::default()
    }
}

/// See [`StartCopyJobInput`](crate::input::StartCopyJobInput)
pub mod start_copy_job_input {
    /// A builder for [`StartCopyJobInput`](crate::input::StartCopyJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) source_backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) destination_backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a recovery point to use for the copy job; for example,
        /// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
        /// </p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point to use for the copy job; for example,
        /// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
        /// </p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The name of a logical source container where backups are stored. Backup vaults are
        /// identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers,
        /// and hyphens.</p>
        pub fn source_backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical source container where backups are stored. Backup vaults are
        /// identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers,
        /// and hyphens.</p>
        pub fn set_source_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to
        /// copy to; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn destination_backup_vault_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to
        /// copy to; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_destination_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_backup_vault_arn = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency
        /// token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency
        /// token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
        /// a recovery point transitions to cold storage or is deleted.</p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
        /// than the “transition to cold after days” setting. The “transition to cold after days”
        /// setting cannot be changed after a backup has been transitioned to cold.</p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
        /// a recovery point transitions to cold storage or is deleted.</p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
        /// than the “transition to cold after days” setting. The “transition to cold after days”
        /// setting cannot be changed after a backup has been transitioned to cold.</p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`StartCopyJobInput`](crate::input::StartCopyJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartCopyJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartCopyJobInput {
                recovery_point_arn: self.recovery_point_arn,
                source_backup_vault_name: self.source_backup_vault_name,
                destination_backup_vault_arn: self.destination_backup_vault_arn,
                iam_role_arn: self.iam_role_arn,
                idempotency_token: self.idempotency_token,
                lifecycle: self.lifecycle,
            })
        }
    }
}
#[doc(hidden)]
pub type StartCopyJobInputOperationOutputAlias = crate::operation::StartCopyJob;
#[doc(hidden)]
pub type StartCopyJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartCopyJobInput {
    /// Consumes the builder and constructs an Operation<[`StartCopyJob`](crate::operation::StartCopyJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartCopyJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartCopyJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/copy-jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartCopyJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartCopyJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_copy_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartCopyJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartCopyJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartCopyJobInput`](crate::input::StartCopyJobInput)
    pub fn builder() -> crate::input::start_copy_job_input::Builder {
        crate::input::start_copy_job_input::Builder::default()
    }
}

/// See [`StartReportJobInput`](crate::input::StartReportJobInput)
pub mod start_report_job_input {
    /// A builder for [`StartReportJobInput`](crate::input::StartReportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a report plan.</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of a report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartReportJobInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartReportJobInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReportJobInput`](crate::input::StartReportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartReportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartReportJobInput {
                report_plan_name: self.report_plan_name,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartReportJobInputOperationOutputAlias = crate::operation::StartReportJob;
#[doc(hidden)]
pub type StartReportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartReportJobInput {
    /// Consumes the builder and constructs an Operation<[`StartReportJob`](crate::operation::StartReportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartReportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartReportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_102 = &_input.report_plan_name;
            let input_102 =
                input_102
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_plan_name",
                        details: "cannot be empty or unset",
                    })?;
            let report_plan_name = aws_smithy_http::label::fmt_string(input_102, false);
            if report_plan_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_plan_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/report-jobs/{ReportPlanName}",
                ReportPlanName = report_plan_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartReportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartReportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_report_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartReportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartReportJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartReportJobInput`](crate::input::StartReportJobInput)
    pub fn builder() -> crate::input::start_report_job_input::Builder {
        crate::input::start_report_job_input::Builder::default()
    }
}

/// See [`StartRestoreJobInput`](crate::input::StartRestoreJobInput)
pub mod start_restore_job_input {
    /// A builder for [`StartRestoreJobInput`](crate::input::StartRestoreJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A set of metadata key-value pairs. Contains information, such as a resource name,
        /// required to restore a recovery point.</p>
        /// <p> You can get configuration metadata about a resource at the time it was backed up by
        /// calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those
        /// provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a
        /// resource. For example, you might need to provide a new resource name if the original
        /// already exists.</p>
        /// <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>file-system-id</code>: The ID of the Amazon EFS file system that is
        /// backed up by Backup. Returned in
        /// <code>GetRecoveryPointRestoreMetadata</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Encrypted</code>: A Boolean value that, if true, specifies that the file
        /// system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code>
        /// must be set to <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to
        /// encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PerformanceMode</code>: Specifies the throughput mode of the file
        /// system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationToken</code>: A user-supplied value that ensures the uniqueness
        /// (idempotency) of the request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>newFileSystem</code>: A Boolean value that, if true, specifies that the
        /// recovery point is restored to a new Amazon EFS file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ItemsToRestore</code>: An array of one to five strings where each string is
        /// a file path. Use <code>ItemsToRestore</code> to restore specific files or directories
        /// rather than the entire file system. This parameter is optional. For example,
        /// <code>"itemsToRestore":"[\"/my.test\"]"</code>.</p>
        /// </li>
        /// </ul>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A set of metadata key-value pairs. Contains information, such as a resource name,
        /// required to restore a recovery point.</p>
        /// <p> You can get configuration metadata about a resource at the time it was backed up by
        /// calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those
        /// provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a
        /// resource. For example, you might need to provide a new resource name if the original
        /// already exists.</p>
        /// <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>file-system-id</code>: The ID of the Amazon EFS file system that is
        /// backed up by Backup. Returned in
        /// <code>GetRecoveryPointRestoreMetadata</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Encrypted</code>: A Boolean value that, if true, specifies that the file
        /// system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code>
        /// must be set to <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to
        /// encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PerformanceMode</code>: Specifies the throughput mode of the file
        /// system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationToken</code>: A user-supplied value that ensures the uniqueness
        /// (idempotency) of the request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>newFileSystem</code>: A Boolean value that, if true, specifies that the
        /// recovery point is restored to a new Amazon EFS file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ItemsToRestore</code>: An array of one to five strings where each string is
        /// a file path. Use <code>ItemsToRestore</code> to restore specific files or directories
        /// rather than the entire file system. This parameter is optional. For example,
        /// <code>"itemsToRestore":"[\"/my.test\"]"</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
        /// the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
        /// the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartRestoreJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartRestoreJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// <p>Starts a job to restore a recovery point for one of the following resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Starts a job to restore a recovery point for one of the following resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StartRestoreJobInput`](crate::input::StartRestoreJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartRestoreJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartRestoreJobInput {
                recovery_point_arn: self.recovery_point_arn,
                metadata: self.metadata,
                iam_role_arn: self.iam_role_arn,
                idempotency_token: self.idempotency_token,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type StartRestoreJobInputOperationOutputAlias = crate::operation::StartRestoreJob;
#[doc(hidden)]
pub type StartRestoreJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartRestoreJobInput {
    /// Consumes the builder and constructs an Operation<[`StartRestoreJob`](crate::operation::StartRestoreJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartRestoreJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartRestoreJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/restore-jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartRestoreJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartRestoreJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_restore_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartRestoreJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartRestoreJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartRestoreJobInput`](crate::input::StartRestoreJobInput)
    pub fn builder() -> crate::input::start_restore_job_input::Builder {
        crate::input::start_restore_job_input::Builder::default()
    }
}

/// See [`StopBackupJobInput`](crate::input::StopBackupJobInput)
pub mod stop_backup_job_input {
    /// A builder for [`StopBackupJobInput`](crate::input::StopBackupJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn backup_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn set_backup_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopBackupJobInput`](crate::input::StopBackupJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopBackupJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopBackupJobInput {
                backup_job_id: self.backup_job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopBackupJobInputOperationOutputAlias = crate::operation::StopBackupJob;
#[doc(hidden)]
pub type StopBackupJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopBackupJobInput {
    /// Consumes the builder and constructs an Operation<[`StopBackupJob`](crate::operation::StopBackupJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopBackupJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopBackupJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_103 = &_input.backup_job_id;
            let input_103 =
                input_103
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_job_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_job_id = aws_smithy_http::label::fmt_string(input_103, false);
            if backup_job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-jobs/{BackupJobId}",
                BackupJobId = backup_job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopBackupJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopBackupJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopBackupJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopBackupJob",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopBackupJobInput`](crate::input::StopBackupJobInput)
    pub fn builder() -> crate::input::stop_backup_job_input::Builder {
        crate::input::stop_backup_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that are used to help organize your resources. You can assign your own
        /// metadata to the resources you create. For clarity, this is the structure to assign tags:
        /// <code>[{"Key":"string","Value":"string"}]</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs that are used to help organize your resources. You can assign your own
        /// metadata to the resources you create. For clarity, this is the structure to assign tags:
        /// <code>[{"Key":"string","Value":"string"}]</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_104 = &_input.resource_arn;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_104, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_key_list`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of keys to identify which key-value tags to remove from a resource.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_key_list.unwrap_or_default();
            v.push(input.into());
            self.tag_key_list = Some(v);
            self
        }
        /// <p>A list of keys to identify which key-value tags to remove from a resource.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_key_list = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_key_list: self.tag_key_list,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_105 = &_input.resource_arn;
            let input_105 =
                input_105
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_105, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/untag/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateBackupPlanInput`](crate::input::UpdateBackupPlanInput)
pub mod update_backup_plan_input {
    /// A builder for [`UpdateBackupPlanInput`](crate::input::UpdateBackupPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan: std::option::Option<crate::model::BackupPlanInput>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn backup_plan(mut self, input: crate::model::BackupPlanInput) -> Self {
            self.backup_plan = Some(input);
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn set_backup_plan(
            mut self,
            input: std::option::Option<crate::model::BackupPlanInput>,
        ) -> Self {
            self.backup_plan = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBackupPlanInput`](crate::input::UpdateBackupPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBackupPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBackupPlanInput {
                backup_plan_id: self.backup_plan_id,
                backup_plan: self.backup_plan,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBackupPlanInputOperationOutputAlias = crate::operation::UpdateBackupPlan;
#[doc(hidden)]
pub type UpdateBackupPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBackupPlanInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBackupPlan`](crate::operation::UpdateBackupPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBackupPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBackupPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_106 = &_input.backup_plan_id;
            let input_106 =
                input_106
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_plan_id",
                        details: "cannot be empty or unset",
                    })?;
            let backup_plan_id = aws_smithy_http::label::fmt_string(input_106, false);
            if backup_plan_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_plan_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup/plans/{BackupPlanId}",
                BackupPlanId = backup_plan_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBackupPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBackupPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_backup_plan(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBackupPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBackupPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBackupPlanInput`](crate::input::UpdateBackupPlanInput)
    pub fn builder() -> crate::input::update_backup_plan_input::Builder {
        crate::input::update_backup_plan_input::Builder::default()
    }
}

/// See [`UpdateFrameworkInput`](crate::input::UpdateFrameworkInput)
pub mod update_framework_input {
    /// A builder for [`UpdateFrameworkInput`](crate::input::UpdateFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
        pub(crate) framework_description: std::option::Option<std::string::String>,
        pub(crate) framework_controls:
            std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
        /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
        /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
        pub fn framework_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_description = Some(input.into());
            self
        }
        /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
        pub fn set_framework_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_description = input;
            self
        }
        /// Appends an item to `framework_controls`.
        ///
        /// To override the contents of this collection use [`set_framework_controls`](Self::set_framework_controls).
        ///
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn framework_controls(
            mut self,
            input: impl Into<crate::model::FrameworkControl>,
        ) -> Self {
            let mut v = self.framework_controls.unwrap_or_default();
            v.push(input.into());
            self.framework_controls = Some(v);
            self
        }
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn set_framework_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        ) -> Self {
            self.framework_controls = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFrameworkInput`](crate::input::UpdateFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFrameworkInput {
                framework_name: self.framework_name,
                framework_description: self.framework_description,
                framework_controls: self.framework_controls,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFrameworkInputOperationOutputAlias = crate::operation::UpdateFramework;
#[doc(hidden)]
pub type UpdateFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFramework`](crate::operation::UpdateFramework)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_107 = &_input.framework_name;
            let input_107 =
                input_107
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "framework_name",
                        details: "cannot be empty or unset",
                    })?;
            let framework_name = aws_smithy_http::label::fmt_string(input_107, false);
            if framework_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "framework_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/frameworks/{FrameworkName}",
                FrameworkName = framework_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_framework(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFramework",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFrameworkInput`](crate::input::UpdateFrameworkInput)
    pub fn builder() -> crate::input::update_framework_input::Builder {
        crate::input::update_framework_input::Builder::default()
    }
}

/// See [`UpdateGlobalSettingsInput`](crate::input::UpdateGlobalSettingsInput)
pub mod update_global_settings_input {
    /// A builder for [`UpdateGlobalSettingsInput`](crate::input::UpdateGlobalSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_settings: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `global_settings`.
        ///
        /// To override the contents of this collection use [`set_global_settings`](Self::set_global_settings).
        ///
        /// <p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example:
        /// <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false
        /// --region us-west-2</code>.</p>
        pub fn global_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.global_settings.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.global_settings = Some(hash_map);
            self
        }
        /// <p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example:
        /// <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false
        /// --region us-west-2</code>.</p>
        pub fn set_global_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.global_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalSettingsInput`](crate::input::UpdateGlobalSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGlobalSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGlobalSettingsInput {
                global_settings: self.global_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGlobalSettingsInputOperationOutputAlias = crate::operation::UpdateGlobalSettings;
#[doc(hidden)]
pub type UpdateGlobalSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGlobalSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGlobalSettings`](crate::operation::UpdateGlobalSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGlobalSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGlobalSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/global-settings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGlobalSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGlobalSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_global_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGlobalSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGlobalSettings",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGlobalSettingsInput`](crate::input::UpdateGlobalSettingsInput)
    pub fn builder() -> crate::input::update_global_settings_input::Builder {
        crate::input::update_global_settings_input::Builder::default()
    }
}

/// See [`UpdateRecoveryPointLifecycleInput`](crate::input::UpdateRecoveryPointLifecycleInput)
pub mod update_recovery_point_lifecycle_input {
    /// A builder for [`UpdateRecoveryPointLifecycleInput`](crate::input::UpdateRecoveryPointLifecycleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecoveryPointLifecycleInput`](crate::input::UpdateRecoveryPointLifecycleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRecoveryPointLifecycleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRecoveryPointLifecycleInput {
                backup_vault_name: self.backup_vault_name,
                recovery_point_arn: self.recovery_point_arn,
                lifecycle: self.lifecycle,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRecoveryPointLifecycleInputOperationOutputAlias =
    crate::operation::UpdateRecoveryPointLifecycle;
#[doc(hidden)]
pub type UpdateRecoveryPointLifecycleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRecoveryPointLifecycleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRecoveryPointLifecycle`](crate::operation::UpdateRecoveryPointLifecycle)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRecoveryPointLifecycle,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRecoveryPointLifecycleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_108 = &_input.backup_vault_name;
            let input_108 =
                input_108
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "backup_vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let backup_vault_name = aws_smithy_http::label::fmt_string(input_108, false);
            if backup_vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "backup_vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_109 = &_input.recovery_point_arn;
            let input_109 =
                input_109
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_point_arn",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_point_arn = aws_smithy_http::label::fmt_string(input_109, false);
            if recovery_point_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_point_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}",
                BackupVaultName = backup_vault_name,
                RecoveryPointArn = recovery_point_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRecoveryPointLifecycleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRecoveryPointLifecycleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_recovery_point_lifecycle(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRecoveryPointLifecycle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRecoveryPointLifecycle",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRecoveryPointLifecycleInput`](crate::input::UpdateRecoveryPointLifecycleInput)
    pub fn builder() -> crate::input::update_recovery_point_lifecycle_input::Builder {
        crate::input::update_recovery_point_lifecycle_input::Builder::default()
    }
}

/// See [`UpdateRegionSettingsInput`](crate::input::UpdateRegionSettingsInput)
pub mod update_region_settings_input {
    /// A builder for [`UpdateRegionSettingsInput`](crate::input::UpdateRegionSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type_opt_in_preference:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        pub(crate) resource_type_management_preference:
            std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    }
    impl Builder {
        /// Adds a key-value pair to `resource_type_opt_in_preference`.
        ///
        /// To override the contents of this collection use [`set_resource_type_opt_in_preference`](Self::set_resource_type_opt_in_preference).
        ///
        /// <p>Updates the list of services along with the opt-in preferences for the Region.</p>
        pub fn resource_type_opt_in_preference(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.resource_type_opt_in_preference.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_type_opt_in_preference = Some(hash_map);
            self
        }
        /// <p>Updates the list of services along with the opt-in preferences for the Region.</p>
        pub fn set_resource_type_opt_in_preference(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.resource_type_opt_in_preference = input;
            self
        }
        /// Adds a key-value pair to `resource_type_management_preference`.
        ///
        /// To override the contents of this collection use [`set_resource_type_management_preference`](Self::set_resource_type_management_preference).
        ///
        /// <p>Enables or disables
        /// <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html">
        /// Backup's advanced DynamoDB backup features</a> for the
        /// Region.</p>
        pub fn resource_type_management_preference(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            let mut hash_map = self.resource_type_management_preference.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_type_management_preference = Some(hash_map);
            self
        }
        /// <p>Enables or disables
        /// <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html">
        /// Backup's advanced DynamoDB backup features</a> for the
        /// Region.</p>
        pub fn set_resource_type_management_preference(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.resource_type_management_preference = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRegionSettingsInput`](crate::input::UpdateRegionSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRegionSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRegionSettingsInput {
                resource_type_opt_in_preference: self.resource_type_opt_in_preference,
                resource_type_management_preference: self.resource_type_management_preference,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRegionSettingsInputOperationOutputAlias = crate::operation::UpdateRegionSettings;
#[doc(hidden)]
pub type UpdateRegionSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRegionSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRegionSettings`](crate::operation::UpdateRegionSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRegionSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRegionSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account-settings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRegionSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRegionSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_region_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRegionSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRegionSettings",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRegionSettingsInput`](crate::input::UpdateRegionSettingsInput)
    pub fn builder() -> crate::input::update_region_settings_input::Builder {
        crate::input::update_region_settings_input::Builder::default()
    }
}

/// See [`UpdateReportPlanInput`](crate::input::UpdateReportPlanInput)
pub mod update_report_plan_input {
    /// A builder for [`UpdateReportPlanInput`](crate::input::UpdateReportPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
        pub(crate) report_plan_description: std::option::Option<std::string::String>,
        pub(crate) report_delivery_channel:
            std::option::Option<crate::model::ReportDeliveryChannel>,
        pub(crate) report_setting: std::option::Option<crate::model::ReportSetting>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the report plan. This name is between 1 and 256 characters, starting
        /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
        /// (_).</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of the report plan. This name is between 1 and 256 characters, starting
        /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
        /// (_).</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
        pub fn report_plan_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_description = Some(input.into());
            self
        }
        /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
        pub fn set_report_plan_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_description = input;
            self
        }
        /// <p>A structure that contains information about where to deliver your reports, specifically
        /// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
        pub fn report_delivery_channel(
            mut self,
            input: crate::model::ReportDeliveryChannel,
        ) -> Self {
            self.report_delivery_channel = Some(input);
            self
        }
        /// <p>A structure that contains information about where to deliver your reports, specifically
        /// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
        pub fn set_report_delivery_channel(
            mut self,
            input: std::option::Option<crate::model::ReportDeliveryChannel>,
        ) -> Self {
            self.report_delivery_channel = input;
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn report_setting(mut self, input: crate::model::ReportSetting) -> Self {
            self.report_setting = Some(input);
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn set_report_setting(
            mut self,
            input: std::option::Option<crate::model::ReportSetting>,
        ) -> Self {
            self.report_setting = input;
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReportPlanInput`](crate::input::UpdateReportPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReportPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReportPlanInput {
                report_plan_name: self.report_plan_name,
                report_plan_description: self.report_plan_description,
                report_delivery_channel: self.report_delivery_channel,
                report_setting: self.report_setting,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReportPlanInputOperationOutputAlias = crate::operation::UpdateReportPlan;
#[doc(hidden)]
pub type UpdateReportPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateReportPlanInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReportPlan`](crate::operation::UpdateReportPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReportPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReportPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_110 = &_input.report_plan_name;
            let input_110 =
                input_110
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_plan_name",
                        details: "cannot be empty or unset",
                    })?;
            let report_plan_name = aws_smithy_http::label::fmt_string(input_110, false);
            if report_plan_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "report_plan_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/audit/report-plans/{ReportPlanName}",
                ReportPlanName = report_plan_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReportPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReportPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_report_plan(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReportPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReportPlan",
            "backup",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReportPlanInput`](crate::input::UpdateReportPlanInput)
    pub fn builder() -> crate::input::update_report_plan_input::Builder {
        crate::input::update_report_plan_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReportPlanInput {
    /// <p>The unique name of the report plan. This name is between 1 and 256 characters, starting
    /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
    /// (_).</p>
    pub report_plan_name: std::option::Option<std::string::String>,
    /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
    pub report_plan_description: std::option::Option<std::string::String>,
    /// <p>A structure that contains information about where to deliver your reports, specifically
    /// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
    pub report_delivery_channel: std::option::Option<crate::model::ReportDeliveryChannel>,
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
    /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
    /// coverage by Amazon Web Services Regions and frameworks.</p>
    pub report_setting: std::option::Option<crate::model::ReportSetting>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl UpdateReportPlanInput {
    /// <p>The unique name of the report plan. This name is between 1 and 256 characters, starting
    /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
    /// (_).</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
    /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
    pub fn report_plan_description(&self) -> std::option::Option<&str> {
        self.report_plan_description.as_deref()
    }
    /// <p>A structure that contains information about where to deliver your reports, specifically
    /// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
    pub fn report_delivery_channel(
        &self,
    ) -> std::option::Option<&crate::model::ReportDeliveryChannel> {
        self.report_delivery_channel.as_ref()
    }
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
    /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
    /// coverage by Amazon Web Services Regions and frameworks.</p>
    pub fn report_setting(&self) -> std::option::Option<&crate::model::ReportSetting> {
        self.report_setting.as_ref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateReportPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReportPlanInput");
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.field("report_plan_description", &self.report_plan_description);
        formatter.field("report_delivery_channel", &self.report_delivery_channel);
        formatter.field("report_setting", &self.report_setting);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRegionSettingsInput {
    /// <p>Updates the list of services along with the opt-in preferences for the Region.</p>
    pub resource_type_opt_in_preference:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
    /// <p>Enables or disables
    /// <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html">
    /// Backup's advanced DynamoDB backup features</a> for the
    /// Region.</p>
    pub resource_type_management_preference:
        std::option::Option<std::collections::HashMap<std::string::String, bool>>,
}
impl UpdateRegionSettingsInput {
    /// <p>Updates the list of services along with the opt-in preferences for the Region.</p>
    pub fn resource_type_opt_in_preference(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.resource_type_opt_in_preference.as_ref()
    }
    /// <p>Enables or disables
    /// <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html">
    /// Backup's advanced DynamoDB backup features</a> for the
    /// Region.</p>
    pub fn resource_type_management_preference(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, bool>> {
        self.resource_type_management_preference.as_ref()
    }
}
impl std::fmt::Debug for UpdateRegionSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRegionSettingsInput");
        formatter.field(
            "resource_type_opt_in_preference",
            &self.resource_type_opt_in_preference,
        );
        formatter.field(
            "resource_type_management_preference",
            &self.resource_type_management_preference,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecoveryPointLifecycleInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup transitions and expires backups automatically according to
    /// the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
}
impl UpdateRecoveryPointLifecycleInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup transitions and expires backups automatically according to
    /// the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
}
impl std::fmt::Debug for UpdateRecoveryPointLifecycleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecoveryPointLifecycleInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalSettingsInput {
    /// <p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example:
    /// <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false
    /// --region us-west-2</code>.</p>
    pub global_settings:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateGlobalSettingsInput {
    /// <p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example:
    /// <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false
    /// --region us-west-2</code>.</p>
    pub fn global_settings(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.global_settings.as_ref()
    }
}
impl std::fmt::Debug for UpdateGlobalSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalSettingsInput");
        formatter.field("global_settings", &self.global_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFrameworkInput {
    /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
    /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub framework_name: std::option::Option<std::string::String>,
    /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
    pub framework_description: std::option::Option<std::string::String>,
    /// <p>A list of the controls that make up the framework. Each control in the list has a name,
    /// input parameters, and scope.</p>
    pub framework_controls: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl UpdateFrameworkInput {
    /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
    /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
    /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
    pub fn framework_description(&self) -> std::option::Option<&str> {
        self.framework_description.as_deref()
    }
    /// <p>A list of the controls that make up the framework. Each control in the list has a name,
    /// input parameters, and scope.</p>
    pub fn framework_controls(&self) -> std::option::Option<&[crate::model::FrameworkControl]> {
        self.framework_controls.as_deref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFrameworkInput");
        formatter.field("framework_name", &self.framework_name);
        formatter.field("framework_description", &self.framework_description);
        formatter.field("framework_controls", &self.framework_controls);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBackupPlanInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
    /// more sets of <code>Rules</code>.</p>
    pub backup_plan: std::option::Option<crate::model::BackupPlanInput>,
}
impl UpdateBackupPlanInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
    /// more sets of <code>Rules</code>.</p>
    pub fn backup_plan(&self) -> std::option::Option<&crate::model::BackupPlanInput> {
        self.backup_plan.as_ref()
    }
}
impl std::fmt::Debug for UpdateBackupPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBackupPlanInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("backup_plan", &self.backup_plan);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
    /// the tagged resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of keys to identify which key-value tags to remove from a resource.</p>
    pub tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
    /// the tagged resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of keys to identify which key-value tags to remove from a resource.</p>
    pub fn tag_key_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_key_list.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_key_list", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
    /// the tagged resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Key-value pairs that are used to help organize your resources. You can assign your own
    /// metadata to the resources you create. For clarity, this is the structure to assign tags:
    /// <code>[{"Key":"string","Value":"string"}]</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
    /// the tagged resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Key-value pairs that are used to help organize your resources. You can assign your own
    /// metadata to the resources you create. For clarity, this is the structure to assign tags:
    /// <code>[{"Key":"string","Value":"string"}]</code>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopBackupJobInput {
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub backup_job_id: std::option::Option<std::string::String>,
}
impl StopBackupJobInput {
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub fn backup_job_id(&self) -> std::option::Option<&str> {
        self.backup_job_id.as_deref()
    }
}
impl std::fmt::Debug for StopBackupJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopBackupJobInput");
        formatter.field("backup_job_id", &self.backup_job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartRestoreJobInput {
    /// <p>An ARN that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>A set of metadata key-value pairs. Contains information, such as a resource name,
    /// required to restore a recovery point.</p>
    /// <p> You can get configuration metadata about a resource at the time it was backed up by
    /// calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those
    /// provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a
    /// resource. For example, you might need to provide a new resource name if the original
    /// already exists.</p>
    /// <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>file-system-id</code>: The ID of the Amazon EFS file system that is
    /// backed up by Backup. Returned in
    /// <code>GetRecoveryPointRestoreMetadata</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Encrypted</code>: A Boolean value that, if true, specifies that the file
    /// system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code>
    /// must be set to <code>true</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to
    /// encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PerformanceMode</code>: Specifies the throughput mode of the file
    /// system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationToken</code>: A user-supplied value that ensures the uniqueness
    /// (idempotency) of the request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>newFileSystem</code>: A Boolean value that, if true, specifies that the
    /// recovery point is restored to a new Amazon EFS file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ItemsToRestore</code>: An array of one to five strings where each string is
    /// a file path. Use <code>ItemsToRestore</code> to restore specific files or directories
    /// rather than the entire file system. This parameter is optional. For example,
    /// <code>"itemsToRestore":"[\"/my.test\"]"</code>.</p>
    /// </li>
    /// </ul>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
    /// the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartRestoreJob</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>Starts a job to restore a recovery point for one of the following resources:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DynamoDB</code> for Amazon DynamoDB</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS</code> for Amazon Elastic Block Store</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EFS</code> for Amazon Elastic File System</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RDS</code> for Amazon Relational Database Service</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Aurora</code> for Amazon Aurora</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Storage Gateway</code> for Storage Gateway</p>
    /// </li>
    /// </ul>
    pub resource_type: std::option::Option<std::string::String>,
}
impl StartRestoreJobInput {
    /// <p>An ARN that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>A set of metadata key-value pairs. Contains information, such as a resource name,
    /// required to restore a recovery point.</p>
    /// <p> You can get configuration metadata about a resource at the time it was backed up by
    /// calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those
    /// provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a
    /// resource. For example, you might need to provide a new resource name if the original
    /// already exists.</p>
    /// <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>file-system-id</code>: The ID of the Amazon EFS file system that is
    /// backed up by Backup. Returned in
    /// <code>GetRecoveryPointRestoreMetadata</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Encrypted</code>: A Boolean value that, if true, specifies that the file
    /// system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code>
    /// must be set to <code>true</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to
    /// encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PerformanceMode</code>: Specifies the throughput mode of the file
    /// system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationToken</code>: A user-supplied value that ensures the uniqueness
    /// (idempotency) of the request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>newFileSystem</code>: A Boolean value that, if true, specifies that the
    /// recovery point is restored to a new Amazon EFS file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ItemsToRestore</code>: An array of one to five strings where each string is
    /// a file path. Use <code>ItemsToRestore</code> to restore specific files or directories
    /// rather than the entire file system. This parameter is optional. For example,
    /// <code>"itemsToRestore":"[\"/my.test\"]"</code>.</p>
    /// </li>
    /// </ul>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
    /// the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartRestoreJob</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>Starts a job to restore a recovery point for one of the following resources:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DynamoDB</code> for Amazon DynamoDB</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS</code> for Amazon Elastic Block Store</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EFS</code> for Amazon Elastic File System</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RDS</code> for Amazon Relational Database Service</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Aurora</code> for Amazon Aurora</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Storage Gateway</code> for Storage Gateway</p>
    /// </li>
    /// </ul>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for StartRestoreJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartRestoreJobInput");
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("metadata", &"*** Sensitive Data Redacted ***");
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReportJobInput {
    /// <p>The unique name of a report plan.</p>
    pub report_plan_name: std::option::Option<std::string::String>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartReportJobInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl StartReportJobInput {
    /// <p>The unique name of a report plan.</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartReportJobInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for StartReportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReportJobInput");
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCopyJobInput {
    /// <p>An ARN that uniquely identifies a recovery point to use for the copy job; for example,
    /// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
    /// </p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The name of a logical source container where backups are stored. Backup vaults are
    /// identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers,
    /// and hyphens.</p>
    pub source_backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to
    /// copy to; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub destination_backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency
    /// token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
    /// a recovery point transitions to cold storage or is deleted.</p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
    /// than the “transition to cold after days” setting. The “transition to cold after days”
    /// setting cannot be changed after a backup has been transitioned to cold.</p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
}
impl StartCopyJobInput {
    /// <p>An ARN that uniquely identifies a recovery point to use for the copy job; for example,
    /// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
    /// </p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The name of a logical source container where backups are stored. Backup vaults are
    /// identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers,
    /// and hyphens.</p>
    pub fn source_backup_vault_name(&self) -> std::option::Option<&str> {
        self.source_backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to
    /// copy to; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn destination_backup_vault_arn(&self) -> std::option::Option<&str> {
        self.destination_backup_vault_arn.as_deref()
    }
    /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency
    /// token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
    /// a recovery point transitions to cold storage or is deleted.</p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
    /// than the “transition to cold after days” setting. The “transition to cold after days”
    /// setting cannot be changed after a backup has been transitioned to cold.</p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
}
impl std::fmt::Debug for StartCopyJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCopyJobInput");
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("source_backup_vault_name", &self.source_backup_vault_name);
        formatter.field(
            "destination_backup_vault_arn",
            &self.destination_backup_vault_arn,
        );
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBackupJobInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartBackupJob</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
    /// doesn't start successfully. This value is optional, and the default is 8 hours.</p>
    pub start_window_minutes: std::option::Option<i64>,
    /// <p>A value in minutes during which a successfully started backup must complete, or else AWS
    /// Backup will cancel the job. This value is optional. This value begins counting down from
    /// when the backup was scheduled. It does not add additional time for
    /// <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p>
    pub complete_window_minutes: std::option::Option<i64>,
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup will transition and expire backups automatically according
    /// to the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
    /// <p>To help organize your resources, you can assign your own metadata to the resources that
    /// you create. Each tag is a key-value pair.</p>
    pub recovery_point_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the backup option for a selected resource. This option is only available for
    /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
    /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
    /// <code>"WindowsVSS""disabled"</code> to create a regular backup. The
    /// <code>WindowsVSS</code> option is not enabled by default.</p>
    pub backup_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartBackupJobInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>StartBackupJob</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
    /// doesn't start successfully. This value is optional, and the default is 8 hours.</p>
    pub fn start_window_minutes(&self) -> std::option::Option<i64> {
        self.start_window_minutes
    }
    /// <p>A value in minutes during which a successfully started backup must complete, or else AWS
    /// Backup will cancel the job. This value is optional. This value begins counting down from
    /// when the backup was scheduled. It does not add additional time for
    /// <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p>
    pub fn complete_window_minutes(&self) -> std::option::Option<i64> {
        self.complete_window_minutes
    }
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup will transition and expire backups automatically according
    /// to the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>To help organize your resources, you can assign your own metadata to the resources that
    /// you create. Each tag is a key-value pair.</p>
    pub fn recovery_point_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.recovery_point_tags.as_ref()
    }
    /// <p>Specifies the backup option for a selected resource. This option is only available for
    /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
    /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
    /// <code>"WindowsVSS""disabled"</code> to create a regular backup. The
    /// <code>WindowsVSS</code> option is not enabled by default.</p>
    pub fn backup_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.backup_options.as_ref()
    }
}
impl std::fmt::Debug for StartBackupJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBackupJobInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("start_window_minutes", &self.start_window_minutes);
        formatter.field("complete_window_minutes", &self.complete_window_minutes);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("recovery_point_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("backup_options", &self.backup_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupVaultNotificationsInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for
    /// example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>An array of events that indicate the status of jobs to back up resources to the backup
    /// vault.</p>
    /// <p>For common use cases and code samples, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html">Using Amazon SNS to
    /// track Backup events</a>.</p>
    /// <p>The following events are supported:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BACKUP_JOB_STARTED</code> | <code>BACKUP_JOB_COMPLETED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COPY_JOB_STARTED</code> | <code>COPY_JOB_SUCCESSFUL</code> |
    /// <code>COPY_JOB_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESTORE_JOB_STARTED</code> | <code>RESTORE_JOB_COMPLETED</code> |
    /// <code>RECOVERY_POINT_MODIFIED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Ignore the list below because it includes deprecated events. Refer to the list
    /// above.</p>
    /// </note>
    pub backup_vault_events: std::option::Option<std::vec::Vec<crate::model::BackupVaultEvent>>,
}
impl PutBackupVaultNotificationsInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for
    /// example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>An array of events that indicate the status of jobs to back up resources to the backup
    /// vault.</p>
    /// <p>For common use cases and code samples, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html">Using Amazon SNS to
    /// track Backup events</a>.</p>
    /// <p>The following events are supported:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BACKUP_JOB_STARTED</code> | <code>BACKUP_JOB_COMPLETED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COPY_JOB_STARTED</code> | <code>COPY_JOB_SUCCESSFUL</code> |
    /// <code>COPY_JOB_FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESTORE_JOB_STARTED</code> | <code>RESTORE_JOB_COMPLETED</code> |
    /// <code>RECOVERY_POINT_MODIFIED</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Ignore the list below because it includes deprecated events. Refer to the list
    /// above.</p>
    /// </note>
    pub fn backup_vault_events(&self) -> std::option::Option<&[crate::model::BackupVaultEvent]> {
        self.backup_vault_events.as_deref()
    }
}
impl std::fmt::Debug for PutBackupVaultNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupVaultNotificationsInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("backup_vault_events", &self.backup_vault_events);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupVaultLockConfigurationInput {
    /// <p>The Backup Vault Lock configuration that specifies the name of the backup
    /// vault it protects.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>The Backup Vault Lock configuration that specifies the minimum retention
    /// period that the vault retains its recovery points. This setting can be useful if, for
    /// example, your organization's policies require you to retain certain data for at least seven
    /// years (2555 days).</p>
    /// <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention
    /// period.</p>
    /// <p>If this parameter is specified, any backup or copy job to the vault must have a
    /// lifecycle policy with a retention period equal to or longer than the minimum retention
    /// period. If the job's retention period is shorter than that minimum retention period, then
    /// the vault fails that backup or copy job, and you should either modify your lifecycle
    /// settings or use a different vault. Recovery points already saved in the vault prior to
    /// Vault Lock are not affected.</p>
    pub min_retention_days: std::option::Option<i64>,
    /// <p>The Backup Vault Lock configuration that specifies the maximum retention
    /// period that the vault retains its recovery points. This setting can be useful if, for
    /// example, your organization's policies require you to destroy certain data after retaining
    /// it for four years (1460 days).</p>
    /// <p>If this parameter is not included, Vault Lock does not enforce a maximum retention
    /// period on the recovery points in the vault. If this parameter is included without a value,
    /// Vault Lock will not enforce a maximum retention period.</p>
    /// <p>If this parameter is specified, any backup or copy job to the vault must have a
    /// lifecycle policy with a retention period equal to or shorter than the maximum retention
    /// period. If the job's retention period is longer than that maximum retention period, then
    /// the vault fails the backup or copy job, and you should either modify your lifecycle
    /// settings or use a different vault. Recovery points already saved in the vault prior to
    /// Vault Lock are not affected.</p>
    pub max_retention_days: std::option::Option<i64>,
    /// <p>The Backup Vault Lock configuration that specifies the number of days before
    /// the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at
    /// 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p>
    /// <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect
    /// and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or
    /// greater.</p>
    /// <p>Before the lock date, you can delete Vault Lock from the vault using
    /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
    /// using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault
    /// Lock becomes immutable and cannot be changed or deleted.</p>
    /// <p>If this parameter is not specified, you can delete Vault Lock from the vault using
    /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
    /// using <code>PutBackupVaultLockConfiguration</code> at any time.</p>
    pub changeable_for_days: std::option::Option<i64>,
}
impl PutBackupVaultLockConfigurationInput {
    /// <p>The Backup Vault Lock configuration that specifies the name of the backup
    /// vault it protects.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>The Backup Vault Lock configuration that specifies the minimum retention
    /// period that the vault retains its recovery points. This setting can be useful if, for
    /// example, your organization's policies require you to retain certain data for at least seven
    /// years (2555 days).</p>
    /// <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention
    /// period.</p>
    /// <p>If this parameter is specified, any backup or copy job to the vault must have a
    /// lifecycle policy with a retention period equal to or longer than the minimum retention
    /// period. If the job's retention period is shorter than that minimum retention period, then
    /// the vault fails that backup or copy job, and you should either modify your lifecycle
    /// settings or use a different vault. Recovery points already saved in the vault prior to
    /// Vault Lock are not affected.</p>
    pub fn min_retention_days(&self) -> std::option::Option<i64> {
        self.min_retention_days
    }
    /// <p>The Backup Vault Lock configuration that specifies the maximum retention
    /// period that the vault retains its recovery points. This setting can be useful if, for
    /// example, your organization's policies require you to destroy certain data after retaining
    /// it for four years (1460 days).</p>
    /// <p>If this parameter is not included, Vault Lock does not enforce a maximum retention
    /// period on the recovery points in the vault. If this parameter is included without a value,
    /// Vault Lock will not enforce a maximum retention period.</p>
    /// <p>If this parameter is specified, any backup or copy job to the vault must have a
    /// lifecycle policy with a retention period equal to or shorter than the maximum retention
    /// period. If the job's retention period is longer than that maximum retention period, then
    /// the vault fails the backup or copy job, and you should either modify your lifecycle
    /// settings or use a different vault. Recovery points already saved in the vault prior to
    /// Vault Lock are not affected.</p>
    pub fn max_retention_days(&self) -> std::option::Option<i64> {
        self.max_retention_days
    }
    /// <p>The Backup Vault Lock configuration that specifies the number of days before
    /// the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at
    /// 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p>
    /// <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect
    /// and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or
    /// greater.</p>
    /// <p>Before the lock date, you can delete Vault Lock from the vault using
    /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
    /// using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault
    /// Lock becomes immutable and cannot be changed or deleted.</p>
    /// <p>If this parameter is not specified, you can delete Vault Lock from the vault using
    /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
    /// using <code>PutBackupVaultLockConfiguration</code> at any time.</p>
    pub fn changeable_for_days(&self) -> std::option::Option<i64> {
        self.changeable_for_days
    }
}
impl std::fmt::Debug for PutBackupVaultLockConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupVaultLockConfigurationInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("min_retention_days", &self.min_retention_days);
        formatter.field("max_retention_days", &self.max_retention_days);
        formatter.field("changeable_for_days", &self.changeable_for_days);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupVaultAccessPolicyInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>The backup vault access policy document in JSON format.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutBackupVaultAccessPolicyInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>The backup vault access policy document in JSON format.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutBackupVaultAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupVaultAccessPolicyInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the type of resource. Valid targets for <code>ListTags</code> are recovery
    /// points, backup plans, and backup vaults.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTagsInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the type of resource. Valid targets for <code>ListTags</code> are recovery
    /// points, backup plans, and backup vaults.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRestoreJobsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The account ID to list the jobs from. Returns only restore jobs associated with the
    /// specified account ID.</p>
    pub by_account_id: std::option::Option<std::string::String>,
    /// <p>Returns only restore jobs that were created before the specified date.</p>
    pub by_created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only restore jobs that were created after the specified date.</p>
    pub by_created_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only restore jobs associated with the specified job status.</p>
    pub by_status: std::option::Option<crate::model::RestoreJobStatus>,
}
impl ListRestoreJobsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The account ID to list the jobs from. Returns only restore jobs associated with the
    /// specified account ID.</p>
    pub fn by_account_id(&self) -> std::option::Option<&str> {
        self.by_account_id.as_deref()
    }
    /// <p>Returns only restore jobs that were created before the specified date.</p>
    pub fn by_created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_before.as_ref()
    }
    /// <p>Returns only restore jobs that were created after the specified date.</p>
    pub fn by_created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_after.as_ref()
    }
    /// <p>Returns only restore jobs associated with the specified job status.</p>
    pub fn by_status(&self) -> std::option::Option<&crate::model::RestoreJobStatus> {
        self.by_status.as_ref()
    }
}
impl std::fmt::Debug for ListRestoreJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRestoreJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("by_account_id", &self.by_account_id);
        formatter.field("by_created_before", &self.by_created_before);
        formatter.field("by_created_after", &self.by_created_after);
        formatter.field("by_status", &self.by_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportPlansInput {
    /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
    /// return 1 MB of data.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReportPlansInput {
    /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
    /// return 1 MB of data.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReportPlansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportPlansInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportJobsInput {
    /// <p>Returns only report jobs with the specified report plan name.</p>
    pub by_report_plan_name: std::option::Option<std::string::String>,
    /// <p>Returns only report jobs that were created before the date and time specified in Unix
    /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
    /// Friday, January 26, 2018 12:11:30 AM.</p>
    pub by_creation_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only report jobs that were created after the date and time specified in Unix
    /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
    /// Friday, January 26, 2018 12:11:30 AM.</p>
    pub by_creation_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only report jobs that are in the specified status. The statuses are:</p>
    /// <p>
    /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
    /// </p>
    pub by_status: std::option::Option<std::string::String>,
    /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
    /// return 1 MB of data.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReportJobsInput {
    /// <p>Returns only report jobs with the specified report plan name.</p>
    pub fn by_report_plan_name(&self) -> std::option::Option<&str> {
        self.by_report_plan_name.as_deref()
    }
    /// <p>Returns only report jobs that were created before the date and time specified in Unix
    /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
    /// Friday, January 26, 2018 12:11:30 AM.</p>
    pub fn by_creation_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_creation_before.as_ref()
    }
    /// <p>Returns only report jobs that were created after the date and time specified in Unix
    /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
    /// Friday, January 26, 2018 12:11:30 AM.</p>
    pub fn by_creation_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_creation_after.as_ref()
    }
    /// <p>Returns only report jobs that are in the specified status. The statuses are:</p>
    /// <p>
    /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
    /// </p>
    pub fn by_status(&self) -> std::option::Option<&str> {
        self.by_status.as_deref()
    }
    /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
    /// return 1 MB of data.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportJobsInput");
        formatter.field("by_report_plan_name", &self.by_report_plan_name);
        formatter.field("by_creation_before", &self.by_creation_before);
        formatter.field("by_creation_after", &self.by_creation_after);
        formatter.field("by_status", &self.by_status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecoveryPointsByResourceInput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
    /// resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    /// <note>
    /// <p>Amazon RDS requires a value of at least 20.</p>
    /// </note>
    pub max_results: std::option::Option<i32>,
}
impl ListRecoveryPointsByResourceInput {
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
    /// resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    /// <note>
    /// <p>Amazon RDS requires a value of at least 20.</p>
    /// </note>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRecoveryPointsByResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecoveryPointsByResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecoveryPointsByBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    /// <note>
    /// <p>Backup vault name might not be available when a supported service creates the
    /// backup.</p>
    /// </note>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Returns only recovery points that match the specified resource Amazon Resource Name
    /// (ARN).</p>
    pub by_resource_arn: std::option::Option<std::string::String>,
    /// <p>Returns only recovery points that match the specified resource type.</p>
    pub by_resource_type: std::option::Option<std::string::String>,
    /// <p>Returns only recovery points that match the specified backup plan ID.</p>
    pub by_backup_plan_id: std::option::Option<std::string::String>,
    /// <p>Returns only recovery points that were created before the specified timestamp.</p>
    pub by_created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only recovery points that were created after the specified timestamp.</p>
    pub by_created_after: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListRecoveryPointsByBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    /// <note>
    /// <p>Backup vault name might not be available when a supported service creates the
    /// backup.</p>
    /// </note>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Returns only recovery points that match the specified resource Amazon Resource Name
    /// (ARN).</p>
    pub fn by_resource_arn(&self) -> std::option::Option<&str> {
        self.by_resource_arn.as_deref()
    }
    /// <p>Returns only recovery points that match the specified resource type.</p>
    pub fn by_resource_type(&self) -> std::option::Option<&str> {
        self.by_resource_type.as_deref()
    }
    /// <p>Returns only recovery points that match the specified backup plan ID.</p>
    pub fn by_backup_plan_id(&self) -> std::option::Option<&str> {
        self.by_backup_plan_id.as_deref()
    }
    /// <p>Returns only recovery points that were created before the specified timestamp.</p>
    pub fn by_created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_before.as_ref()
    }
    /// <p>Returns only recovery points that were created after the specified timestamp.</p>
    pub fn by_created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_after.as_ref()
    }
}
impl std::fmt::Debug for ListRecoveryPointsByBackupVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecoveryPointsByBackupVaultInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("by_resource_arn", &self.by_resource_arn);
        formatter.field("by_resource_type", &self.by_resource_type);
        formatter.field("by_backup_plan_id", &self.by_backup_plan_id);
        formatter.field("by_created_before", &self.by_created_before);
        formatter.field("by_created_after", &self.by_created_after);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProtectedResourcesInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProtectedResourcesInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProtectedResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProtectedResourcesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFrameworksInput {
    /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
    /// return 1 MB of data.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFrameworksInput {
    /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
    /// return 1 MB of data.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFrameworksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFrameworksInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCopyJobsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return maxResults number of items, NextToken allows you to return more items in
    /// your list starting at the location pointed to by the next token. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN).
    /// </p>
    pub by_resource_arn: std::option::Option<std::string::String>,
    /// <p>Returns only copy jobs that are in the specified state.</p>
    pub by_state: std::option::Option<crate::model::CopyJobState>,
    /// <p>Returns only copy jobs that were created before the specified date.</p>
    pub by_created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only copy jobs that were created after the specified date.</p>
    pub by_created_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only backup jobs for the specified resources:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DynamoDB</code> for Amazon DynamoDB</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS</code> for Amazon Elastic Block Store</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EFS</code> for Amazon Elastic File System</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RDS</code> for Amazon Relational Database Service</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Aurora</code> for Amazon Aurora</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Storage Gateway</code> for Storage Gateway</p>
    /// </li>
    /// </ul>
    pub by_resource_type: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy
    /// from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
    /// </p>
    pub by_destination_vault_arn: std::option::Option<std::string::String>,
    /// <p>The account ID to list the jobs from. Returns only copy jobs associated with the
    /// specified account ID.</p>
    pub by_account_id: std::option::Option<std::string::String>,
}
impl ListCopyJobsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return maxResults number of items, NextToken allows you to return more items in
    /// your list starting at the location pointed to by the next token. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN).
    /// </p>
    pub fn by_resource_arn(&self) -> std::option::Option<&str> {
        self.by_resource_arn.as_deref()
    }
    /// <p>Returns only copy jobs that are in the specified state.</p>
    pub fn by_state(&self) -> std::option::Option<&crate::model::CopyJobState> {
        self.by_state.as_ref()
    }
    /// <p>Returns only copy jobs that were created before the specified date.</p>
    pub fn by_created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_before.as_ref()
    }
    /// <p>Returns only copy jobs that were created after the specified date.</p>
    pub fn by_created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_after.as_ref()
    }
    /// <p>Returns only backup jobs for the specified resources:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DynamoDB</code> for Amazon DynamoDB</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS</code> for Amazon Elastic Block Store</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EFS</code> for Amazon Elastic File System</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RDS</code> for Amazon Relational Database Service</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Aurora</code> for Amazon Aurora</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Storage Gateway</code> for Storage Gateway</p>
    /// </li>
    /// </ul>
    pub fn by_resource_type(&self) -> std::option::Option<&str> {
        self.by_resource_type.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy
    /// from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
    /// </p>
    pub fn by_destination_vault_arn(&self) -> std::option::Option<&str> {
        self.by_destination_vault_arn.as_deref()
    }
    /// <p>The account ID to list the jobs from. Returns only copy jobs associated with the
    /// specified account ID.</p>
    pub fn by_account_id(&self) -> std::option::Option<&str> {
        self.by_account_id.as_deref()
    }
}
impl std::fmt::Debug for ListCopyJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCopyJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("by_resource_arn", &self.by_resource_arn);
        formatter.field("by_state", &self.by_state);
        formatter.field("by_created_before", &self.by_created_before);
        formatter.field("by_created_after", &self.by_created_after);
        formatter.field("by_resource_type", &self.by_resource_type);
        formatter.field("by_destination_vault_arn", &self.by_destination_vault_arn);
        formatter.field("by_account_id", &self.by_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupVaultsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListBackupVaultsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListBackupVaultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupVaultsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupSelectionsInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListBackupSelectionsInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListBackupSelectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupSelectionsInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupPlanVersionsInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListBackupPlanVersionsInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListBackupPlanVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupPlanVersionsInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupPlanTemplatesInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListBackupPlanTemplatesInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListBackupPlanTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupPlanTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupPlansInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup
    /// plans when set to <code>TRUE</code>.</p>
    pub include_deleted: std::option::Option<bool>,
}
impl ListBackupPlansInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup
    /// plans when set to <code>TRUE</code>.</p>
    pub fn include_deleted(&self) -> std::option::Option<bool> {
        self.include_deleted
    }
}
impl std::fmt::Debug for ListBackupPlansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupPlansInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("include_deleted", &self.include_deleted);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupJobsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Returns only backup jobs that match the specified resource Amazon Resource Name
    /// (ARN).</p>
    pub by_resource_arn: std::option::Option<std::string::String>,
    /// <p>Returns only backup jobs that are in the specified state.</p>
    pub by_state: std::option::Option<crate::model::BackupJobState>,
    /// <p>Returns only backup jobs that will be stored in the specified backup vault. Backup
    /// vaults are identified by names that are unique to the account used to create them and the
    /// Amazon Web Services Region where they are created. They consist of lowercase letters,
    /// numbers, and hyphens.</p>
    pub by_backup_vault_name: std::option::Option<std::string::String>,
    /// <p>Returns only backup jobs that were created before the specified date.</p>
    pub by_created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only backup jobs that were created after the specified date.</p>
    pub by_created_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns only backup jobs for the specified resources:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DynamoDB</code> for Amazon DynamoDB</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS</code> for Amazon Elastic Block Store</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EFS</code> for Amazon Elastic File System</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RDS</code> for Amazon Relational Database Service</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Aurora</code> for Amazon Aurora</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Storage Gateway</code> for Storage Gateway</p>
    /// </li>
    /// </ul>
    pub by_resource_type: std::option::Option<std::string::String>,
    /// <p>The account ID to list the jobs from. Returns only backup jobs associated with the
    /// specified account ID.</p>
    /// <p>If used from an Organizations management account, passing <code>*</code> returns
    /// all jobs across the organization.</p>
    pub by_account_id: std::option::Option<std::string::String>,
}
impl ListBackupJobsInput {
    /// <p>The next item following a partial list of returned items. For example, if a request is
    /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
    /// to return more items in your list starting at the location pointed to by the next
    /// token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Returns only backup jobs that match the specified resource Amazon Resource Name
    /// (ARN).</p>
    pub fn by_resource_arn(&self) -> std::option::Option<&str> {
        self.by_resource_arn.as_deref()
    }
    /// <p>Returns only backup jobs that are in the specified state.</p>
    pub fn by_state(&self) -> std::option::Option<&crate::model::BackupJobState> {
        self.by_state.as_ref()
    }
    /// <p>Returns only backup jobs that will be stored in the specified backup vault. Backup
    /// vaults are identified by names that are unique to the account used to create them and the
    /// Amazon Web Services Region where they are created. They consist of lowercase letters,
    /// numbers, and hyphens.</p>
    pub fn by_backup_vault_name(&self) -> std::option::Option<&str> {
        self.by_backup_vault_name.as_deref()
    }
    /// <p>Returns only backup jobs that were created before the specified date.</p>
    pub fn by_created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_before.as_ref()
    }
    /// <p>Returns only backup jobs that were created after the specified date.</p>
    pub fn by_created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.by_created_after.as_ref()
    }
    /// <p>Returns only backup jobs for the specified resources:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DynamoDB</code> for Amazon DynamoDB</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EBS</code> for Amazon Elastic Block Store</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EFS</code> for Amazon Elastic File System</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RDS</code> for Amazon Relational Database Service</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Aurora</code> for Amazon Aurora</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Storage Gateway</code> for Storage Gateway</p>
    /// </li>
    /// </ul>
    pub fn by_resource_type(&self) -> std::option::Option<&str> {
        self.by_resource_type.as_deref()
    }
    /// <p>The account ID to list the jobs from. Returns only backup jobs associated with the
    /// specified account ID.</p>
    /// <p>If used from an Organizations management account, passing <code>*</code> returns
    /// all jobs across the organization.</p>
    pub fn by_account_id(&self) -> std::option::Option<&str> {
        self.by_account_id.as_deref()
    }
}
impl std::fmt::Debug for ListBackupJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("by_resource_arn", &self.by_resource_arn);
        formatter.field("by_state", &self.by_state);
        formatter.field("by_backup_vault_name", &self.by_backup_vault_name);
        formatter.field("by_created_before", &self.by_created_before);
        formatter.field("by_created_after", &self.by_created_after);
        formatter.field("by_resource_type", &self.by_resource_type);
        formatter.field("by_account_id", &self.by_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSupportedResourceTypesInput {}
impl std::fmt::Debug for GetSupportedResourceTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSupportedResourceTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecoveryPointRestoreMetadataInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
}
impl GetRecoveryPointRestoreMetadataInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
}
impl std::fmt::Debug for GetRecoveryPointRestoreMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecoveryPointRestoreMetadataInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupVaultNotificationsInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl GetBackupVaultNotificationsInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackupVaultNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupVaultNotificationsInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupVaultAccessPolicyInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl GetBackupVaultAccessPolicyInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for GetBackupVaultAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupVaultAccessPolicyInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupSelectionInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
    /// plan.</p>
    pub selection_id: std::option::Option<std::string::String>,
}
impl GetBackupSelectionInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
    /// plan.</p>
    pub fn selection_id(&self) -> std::option::Option<&str> {
        self.selection_id.as_deref()
    }
}
impl std::fmt::Debug for GetBackupSelectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupSelectionInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("selection_id", &self.selection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupPlanFromTemplateInput {
    /// <p>Uniquely identifies a stored backup plan template.</p>
    pub backup_plan_template_id: std::option::Option<std::string::String>,
}
impl GetBackupPlanFromTemplateInput {
    /// <p>Uniquely identifies a stored backup plan template.</p>
    pub fn backup_plan_template_id(&self) -> std::option::Option<&str> {
        self.backup_plan_template_id.as_deref()
    }
}
impl std::fmt::Debug for GetBackupPlanFromTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupPlanFromTemplateInput");
        formatter.field("backup_plan_template_id", &self.backup_plan_template_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupPlanFromJsonInput {
    /// <p>A customer-supplied backup plan document in JSON format.</p>
    pub backup_plan_template_json: std::option::Option<std::string::String>,
}
impl GetBackupPlanFromJsonInput {
    /// <p>A customer-supplied backup plan document in JSON format.</p>
    pub fn backup_plan_template_json(&self) -> std::option::Option<&str> {
        self.backup_plan_template_json.as_deref()
    }
}
impl std::fmt::Debug for GetBackupPlanFromJsonInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupPlanFromJsonInput");
        formatter.field("backup_plan_template_json", &self.backup_plan_template_json);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBackupPlanInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
    /// long. Version IDs cannot be edited.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl GetBackupPlanInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
    /// long. Version IDs cannot be edited.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for GetBackupPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBackupPlanInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportBackupPlanTemplateInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
}
impl ExportBackupPlanTemplateInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
}
impl std::fmt::Debug for ExportBackupPlanTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportBackupPlanTemplateInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateRecoveryPointInput {
    /// <p>The unique name of an Backup vault.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery
    /// point.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
}
impl DisassociateRecoveryPointInput {
    /// <p>The unique name of an Backup vault.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery
    /// point.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateRecoveryPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateRecoveryPointInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRestoreJobInput {
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub restore_job_id: std::option::Option<std::string::String>,
}
impl DescribeRestoreJobInput {
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub fn restore_job_id(&self) -> std::option::Option<&str> {
        self.restore_job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeRestoreJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRestoreJobInput");
        formatter.field("restore_job_id", &self.restore_job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReportPlanInput {
    /// <p>The unique name of a report plan.</p>
    pub report_plan_name: std::option::Option<std::string::String>,
}
impl DescribeReportPlanInput {
    /// <p>The unique name of a report plan.</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeReportPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReportPlanInput");
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReportJobInput {
    /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded
    /// string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
    pub report_job_id: std::option::Option<std::string::String>,
}
impl DescribeReportJobInput {
    /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded
    /// string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
    pub fn report_job_id(&self) -> std::option::Option<&str> {
        self.report_job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeReportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReportJobInput");
        formatter.field("report_job_id", &self.report_job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegionSettingsInput {}
impl std::fmt::Debug for DescribeRegionSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegionSettingsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecoveryPointInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
}
impl DescribeRecoveryPointInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecoveryPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecoveryPointInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProtectedResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DescribeProtectedResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeProtectedResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProtectedResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalSettingsInput {}
impl std::fmt::Debug for DescribeGlobalSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalSettingsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFrameworkInput {
    /// <p>The unique name of a framework.</p>
    pub framework_name: std::option::Option<std::string::String>,
}
impl DescribeFrameworkInput {
    /// <p>The unique name of a framework.</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFrameworkInput");
        formatter.field("framework_name", &self.framework_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCopyJobInput {
    /// <p>Uniquely identifies a copy job.</p>
    pub copy_job_id: std::option::Option<std::string::String>,
}
impl DescribeCopyJobInput {
    /// <p>Uniquely identifies a copy job.</p>
    pub fn copy_job_id(&self) -> std::option::Option<&str> {
        self.copy_job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeCopyJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCopyJobInput");
        formatter.field("copy_job_id", &self.copy_job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl DescribeBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupVaultInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupJobInput {
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub backup_job_id: std::option::Option<std::string::String>,
}
impl DescribeBackupJobInput {
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub fn backup_job_id(&self) -> std::option::Option<&str> {
        self.backup_job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupJobInput");
        formatter.field("backup_job_id", &self.backup_job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReportPlanInput {
    /// <p>The unique name of a report plan.</p>
    pub report_plan_name: std::option::Option<std::string::String>,
}
impl DeleteReportPlanInput {
    /// <p>The unique name of a report plan.</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteReportPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReportPlanInput");
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecoveryPointInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
}
impl DeleteRecoveryPointInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteRecoveryPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecoveryPointInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFrameworkInput {
    /// <p>The unique name of a framework.</p>
    pub framework_name: std::option::Option<std::string::String>,
}
impl DeleteFrameworkInput {
    /// <p>The unique name of a framework.</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFrameworkInput");
        formatter.field("framework_name", &self.framework_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultNotificationsInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Region where they are
    /// created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl DeleteBackupVaultNotificationsInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Region where they are
    /// created. They consist of lowercase letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupVaultNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultNotificationsInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultLockConfigurationInput {
    /// <p>The name of the backup vault from which to delete Backup Vault Lock.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl DeleteBackupVaultLockConfigurationInput {
    /// <p>The name of the backup vault from which to delete Backup Vault Lock.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupVaultLockConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultLockConfigurationInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultAccessPolicyInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl DeleteBackupVaultAccessPolicyInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupVaultAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultAccessPolicyInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl DeleteBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupVaultInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupSelectionInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
    /// plan.</p>
    pub selection_id: std::option::Option<std::string::String>,
}
impl DeleteBackupSelectionInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
    /// plan.</p>
    pub fn selection_id(&self) -> std::option::Option<&str> {
        self.selection_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupSelectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupSelectionInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("selection_id", &self.selection_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupPlanInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
}
impl DeleteBackupPlanInput {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupPlanInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReportPlanInput {
    /// <p>The unique name of the report plan. The name must be between 1 and 256 characters,
    /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
    /// underscores (_).</p>
    pub report_plan_name: std::option::Option<std::string::String>,
    /// <p>An optional description of the report plan with a maximum of 1,024 characters.</p>
    pub report_plan_description: std::option::Option<std::string::String>,
    /// <p>A structure that contains information about where and how to deliver your reports,
    /// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
    /// reports.</p>
    pub report_delivery_channel: std::option::Option<crate::model::ReportDeliveryChannel>,
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
    /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
    /// coverage by Amazon Web Services Regions and frameworks.</p>
    pub report_setting: std::option::Option<crate::model::ReportSetting>,
    /// <p>Metadata that you can assign to help organize the report plans that you create. Each tag
    /// is a key-value pair.</p>
    pub report_plan_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl CreateReportPlanInput {
    /// <p>The unique name of the report plan. The name must be between 1 and 256 characters,
    /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
    /// underscores (_).</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
    /// <p>An optional description of the report plan with a maximum of 1,024 characters.</p>
    pub fn report_plan_description(&self) -> std::option::Option<&str> {
        self.report_plan_description.as_deref()
    }
    /// <p>A structure that contains information about where and how to deliver your reports,
    /// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
    /// reports.</p>
    pub fn report_delivery_channel(
        &self,
    ) -> std::option::Option<&crate::model::ReportDeliveryChannel> {
        self.report_delivery_channel.as_ref()
    }
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
    /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
    /// coverage by Amazon Web Services Regions and frameworks.</p>
    pub fn report_setting(&self) -> std::option::Option<&crate::model::ReportSetting> {
        self.report_setting.as_ref()
    }
    /// <p>Metadata that you can assign to help organize the report plans that you create. Each tag
    /// is a key-value pair.</p>
    pub fn report_plan_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.report_plan_tags.as_ref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for CreateReportPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReportPlanInput");
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.field("report_plan_description", &self.report_plan_description);
        formatter.field("report_delivery_channel", &self.report_delivery_channel);
        formatter.field("report_setting", &self.report_setting);
        formatter.field("report_plan_tags", &self.report_plan_tags);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFrameworkInput {
    /// <p>The unique name of the framework. The name must be between 1 and 256 characters,
    /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
    /// underscores (_).</p>
    pub framework_name: std::option::Option<std::string::String>,
    /// <p>An optional description of the framework with a maximum of 1,024 characters.</p>
    pub framework_description: std::option::Option<std::string::String>,
    /// <p>A list of the controls that make up the framework. Each control in the list has a name,
    /// input parameters, and scope.</p>
    pub framework_controls: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>Metadata that you can assign to help organize the frameworks that you create. Each tag
    /// is a key-value pair.</p>
    pub framework_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateFrameworkInput {
    /// <p>The unique name of the framework. The name must be between 1 and 256 characters,
    /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
    /// underscores (_).</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
    /// <p>An optional description of the framework with a maximum of 1,024 characters.</p>
    pub fn framework_description(&self) -> std::option::Option<&str> {
        self.framework_description.as_deref()
    }
    /// <p>A list of the controls that make up the framework. Each control in the list has a name,
    /// input parameters, and scope.</p>
    pub fn framework_controls(&self) -> std::option::Option<&[crate::model::FrameworkControl]> {
        self.framework_controls.as_deref()
    }
    /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
    /// calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same
    /// idempotency token results in a success message with no action taken.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>Metadata that you can assign to help organize the frameworks that you create. Each tag
    /// is a key-value pair.</p>
    pub fn framework_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.framework_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFrameworkInput");
        formatter.field("framework_name", &self.framework_name);
        formatter.field("framework_description", &self.framework_description);
        formatter.field("framework_controls", &self.framework_controls);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("framework_tags", &self.framework_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of letters, numbers, and hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>Metadata that you can assign to help organize the resources that you create. Each tag is
    /// a key-value pair.</p>
    pub backup_vault_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice. This parameter is optional.</p>
    /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
}
impl CreateBackupVaultInput {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of letters, numbers, and hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>Metadata that you can assign to help organize the resources that you create. Each tag is
    /// a key-value pair.</p>
    pub fn backup_vault_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.backup_vault_tags.as_ref()
    }
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice. This parameter is optional.</p>
    /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBackupVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupVaultInput");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupSelectionInput {
    /// <p>Uniquely identifies the backup plan to be associated with the selection of
    /// resources.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
    pub backup_selection: std::option::Option<crate::model::BackupSelection>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice. This parameter is optional.</p>
    /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
}
impl CreateBackupSelectionInput {
    /// <p>Uniquely identifies the backup plan to be associated with the selection of
    /// resources.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
    pub fn backup_selection(&self) -> std::option::Option<&crate::model::BackupSelection> {
        self.backup_selection.as_ref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice. This parameter is optional.</p>
    /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBackupSelectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupSelectionInput");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("backup_selection", &self.backup_selection);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupPlanInput {
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
    /// more sets of <code>Rules</code>.</p>
    pub backup_plan: std::option::Option<crate::model::BackupPlanInput>,
    /// <p>To help organize your resources, you can assign your own metadata to the resources that
    /// you create. Each tag is a key-value pair. The specified tags are assigned to all backups
    /// created with this plan.</p>
    pub backup_plan_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Identifies the request and allows failed requests to be retried without the risk of
    /// running the operation twice. If the request includes a <code>CreatorRequestId</code> that
    /// matches an existing backup plan, that plan is returned. This parameter is optional.</p>
    /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
}
impl CreateBackupPlanInput {
    /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
    /// more sets of <code>Rules</code>.</p>
    pub fn backup_plan(&self) -> std::option::Option<&crate::model::BackupPlanInput> {
        self.backup_plan.as_ref()
    }
    /// <p>To help organize your resources, you can assign your own metadata to the resources that
    /// you create. Each tag is a key-value pair. The specified tags are assigned to all backups
    /// created with this plan.</p>
    pub fn backup_plan_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.backup_plan_tags.as_ref()
    }
    /// <p>Identifies the request and allows failed requests to be retried without the risk of
    /// running the operation twice. If the request includes a <code>CreatorRequestId</code> that
    /// matches an existing backup plan, that plan is returned. This parameter is optional.</p>
    /// <p>If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBackupPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupPlanInput");
        formatter.field("backup_plan", &self.backup_plan);
        formatter.field("backup_plan_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.finish()
    }
}
