// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackupPlanError {
    /// Kind of error that occurred.
    pub kind: CreateBackupPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackupPlanErrorKind {
    /// <p>The required resource already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackupPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackupPlanErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateBackupPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateBackupPlanErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBackupPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            CreateBackupPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateBackupPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackupPlanError {
    fn code(&self) -> Option<&str> {
        CreateBackupPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackupPlanError {
    /// Creates a new `CreateBackupPlanError`.
    pub fn new(kind: CreateBackupPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackupPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackupPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackupPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackupPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackupPlanErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupPlanErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupPlanErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupPlanErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateBackupPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackupPlanErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateBackupPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateBackupPlanErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBackupPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            CreateBackupPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateBackupPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackupSelection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackupSelectionError {
    /// Kind of error that occurred.
    pub kind: CreateBackupSelectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackupSelection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackupSelectionErrorKind {
    /// <p>The required resource already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackupSelectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackupSelectionErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateBackupSelectionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateBackupSelectionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBackupSelectionErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            CreateBackupSelectionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateBackupSelectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackupSelectionError {
    fn code(&self) -> Option<&str> {
        CreateBackupSelectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackupSelectionError {
    /// Creates a new `CreateBackupSelectionError`.
    pub fn new(kind: CreateBackupSelectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackupSelectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackupSelectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackupSelectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackupSelectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackupSelectionErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupSelectionErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupSelectionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupSelectionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupSelectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupSelectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupSelectionErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupSelectionErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupSelectionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupSelectionErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateBackupSelectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackupSelectionErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateBackupSelectionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateBackupSelectionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBackupSelectionErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            CreateBackupSelectionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateBackupSelectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackupVaultError {
    /// Kind of error that occurred.
    pub kind: CreateBackupVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackupVaultErrorKind {
    /// <p>The required resource already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackupVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackupVaultErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateBackupVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateBackupVaultErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBackupVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            CreateBackupVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateBackupVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackupVaultError {
    fn code(&self) -> Option<&str> {
        CreateBackupVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackupVaultError {
    /// Creates a new `CreateBackupVaultError`.
    pub fn new(kind: CreateBackupVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackupVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackupVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackupVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackupVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackupVaultErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupVaultErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupVaultErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupVaultErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateBackupVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackupVaultErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateBackupVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateBackupVaultErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBackupVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            CreateBackupVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateBackupVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFrameworkError {
    /// Kind of error that occurred.
    pub kind: CreateFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFrameworkErrorKind {
    /// <p>The required resource already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFrameworkErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateFrameworkErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateFrameworkErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFrameworkErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            CreateFrameworkErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFrameworkError {
    fn code(&self) -> Option<&str> {
        CreateFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFrameworkError {
    /// Creates a new `CreateFrameworkError`.
    pub fn new(kind: CreateFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFrameworkErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFrameworkErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFrameworkErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFrameworkErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFrameworkErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFrameworkErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFrameworkErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFrameworkErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFrameworkErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFrameworkErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFrameworkErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateFrameworkErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateFrameworkErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFrameworkErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            CreateFrameworkErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReportPlanError {
    /// Kind of error that occurred.
    pub kind: CreateReportPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReportPlanErrorKind {
    /// <p>The required resource already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReportPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReportPlanErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateReportPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateReportPlanErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateReportPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            CreateReportPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateReportPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReportPlanError {
    fn code(&self) -> Option<&str> {
        CreateReportPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReportPlanError {
    /// Creates a new `CreateReportPlanError`.
    pub fn new(kind: CreateReportPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReportPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReportPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReportPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReportPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReportPlanErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportPlanErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReportPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReportPlanErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportPlanErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReportPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReportPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateReportPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReportPlanErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateReportPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateReportPlanErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateReportPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            CreateReportPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateReportPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupPlanError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupPlanErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteBackupPlanErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteBackupPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteBackupPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteBackupPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteBackupPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupPlanError {
    fn code(&self) -> Option<&str> {
        DeleteBackupPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupPlanError {
    /// Creates a new `DeleteBackupPlanError`.
    pub fn new(kind: DeleteBackupPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupPlanErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupPlanErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteBackupPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteBackupPlanErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteBackupPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteBackupPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteBackupPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteBackupPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackupSelection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupSelectionError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupSelectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackupSelection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupSelectionErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupSelectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupSelectionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteBackupSelectionErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteBackupSelectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteBackupSelectionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteBackupSelectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupSelectionError {
    fn code(&self) -> Option<&str> {
        DeleteBackupSelectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupSelectionError {
    /// Creates a new `DeleteBackupSelectionError`.
    pub fn new(kind: DeleteBackupSelectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupSelectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupSelectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupSelectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupSelectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupSelectionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupSelectionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupSelectionErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupSelectionErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupSelectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupSelectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupSelectionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupSelectionErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteBackupSelectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupSelectionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteBackupSelectionErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteBackupSelectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteBackupSelectionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteBackupSelectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupVaultError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupVaultErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteBackupVaultErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteBackupVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteBackupVaultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteBackupVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteBackupVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupVaultError {
    fn code(&self) -> Option<&str> {
        DeleteBackupVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupVaultError {
    /// Creates a new `DeleteBackupVaultError`.
    pub fn new(kind: DeleteBackupVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteBackupVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteBackupVaultErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteBackupVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteBackupVaultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteBackupVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteBackupVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackupVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupVaultAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupVaultAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackupVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupVaultAccessPolicyErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupVaultAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupVaultAccessPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteBackupVaultAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupVaultAccessPolicyError {
    /// Creates a new `DeleteBackupVaultAccessPolicyError`.
    pub fn new(
        kind: DeleteBackupVaultAccessPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupVaultAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupVaultAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupVaultAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupVaultAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultAccessPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultAccessPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultAccessPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteBackupVaultAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackupVaultLockConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupVaultLockConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupVaultLockConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackupVaultLockConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupVaultLockConfigurationErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupVaultLockConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupVaultLockConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultLockConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultLockConfigurationErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultLockConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultLockConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultLockConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupVaultLockConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteBackupVaultLockConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupVaultLockConfigurationError {
    /// Creates a new `DeleteBackupVaultLockConfigurationError`.
    pub fn new(
        kind: DeleteBackupVaultLockConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupVaultLockConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupVaultLockConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupVaultLockConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupVaultLockConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultLockConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultLockConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultLockConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultLockConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultLockConfigurationErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultLockConfigurationErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultLockConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultLockConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultLockConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultLockConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteBackupVaultLockConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupVaultLockConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultLockConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultLockConfigurationErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultLockConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultLockConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultLockConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackupVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupVaultNotificationsError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupVaultNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackupVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupVaultNotificationsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupVaultNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBackupVaultNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupVaultNotificationsError {
    fn code(&self) -> Option<&str> {
        DeleteBackupVaultNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupVaultNotificationsError {
    /// Creates a new `DeleteBackupVaultNotificationsError`.
    pub fn new(
        kind: DeleteBackupVaultNotificationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupVaultNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupVaultNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupVaultNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupVaultNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultNotificationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultNotificationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultNotificationsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultNotificationsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultNotificationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultNotificationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupVaultNotificationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupVaultNotificationsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteBackupVaultNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteBackupVaultNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFrameworkError {
    /// Kind of error that occurred.
    pub kind: DeleteFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFrameworkErrorKind {
    /// <p>Backup can't perform the action that you requested until it finishes
    /// performing a previous action. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFrameworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteFrameworkErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteFrameworkErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteFrameworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFrameworkErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFrameworkError {
    fn code(&self) -> Option<&str> {
        DeleteFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFrameworkError {
    /// Creates a new `DeleteFrameworkError`.
    pub fn new(kind: DeleteFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFrameworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteFrameworkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteFrameworkErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFrameworkErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFrameworkErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFrameworkErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFrameworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFrameworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFrameworkErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFrameworkErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFrameworkErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteFrameworkErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteFrameworkErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteFrameworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFrameworkErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRecoveryPointError {
    /// Kind of error that occurred.
    pub kind: DeleteRecoveryPointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRecoveryPointErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Backup is already performing an action on this recovery point. It can't
    /// perform the action you requested until the first action finishes. Try again later.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRecoveryPointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRecoveryPointErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteRecoveryPointErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteRecoveryPointErrorKind::InvalidResourceStateException(_inner) => _inner.fmt(f),
            DeleteRecoveryPointErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteRecoveryPointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRecoveryPointErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRecoveryPointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRecoveryPointError {
    fn code(&self) -> Option<&str> {
        DeleteRecoveryPointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRecoveryPointError {
    /// Creates a new `DeleteRecoveryPointError`.
    pub fn new(kind: DeleteRecoveryPointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRecoveryPointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRecoveryPointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRecoveryPointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRecoveryPointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRecoveryPointErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryPointErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryPointErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryPointErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryPointErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryPointErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryPointErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryPointErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryPointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryPointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryPointErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryPointErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteRecoveryPointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRecoveryPointErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteRecoveryPointErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteRecoveryPointErrorKind::InvalidResourceStateException(_inner) => Some(_inner),
            DeleteRecoveryPointErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteRecoveryPointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRecoveryPointErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRecoveryPointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReportPlanError {
    /// Kind of error that occurred.
    pub kind: DeleteReportPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReportPlanErrorKind {
    /// <p>Backup can't perform the action that you requested until it finishes
    /// performing a previous action. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReportPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReportPlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteReportPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteReportPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteReportPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteReportPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteReportPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReportPlanError {
    fn code(&self) -> Option<&str> {
        DeleteReportPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReportPlanError {
    /// Creates a new `DeleteReportPlanError`.
    pub fn new(kind: DeleteReportPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReportPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReportPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReportPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReportPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReportPlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteReportPlanErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteReportPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReportPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReportPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReportPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReportPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReportPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReportPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReportPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteReportPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReportPlanErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteReportPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteReportPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteReportPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteReportPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteReportPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBackupJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBackupJobError {
    /// Kind of error that occurred.
    pub kind: DescribeBackupJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBackupJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBackupJobErrorKind {
    /// <p>A dependent Amazon Web Services service or resource returned an error to the Backup service, and the action cannot be completed.</p>
    DependencyFailureException(crate::error::DependencyFailureException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBackupJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBackupJobErrorKind::DependencyFailureException(_inner) => _inner.fmt(f),
            DescribeBackupJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeBackupJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeBackupJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBackupJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeBackupJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBackupJobError {
    fn code(&self) -> Option<&str> {
        DescribeBackupJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBackupJobError {
    /// Creates a new `DescribeBackupJobError`.
    pub fn new(kind: DescribeBackupJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBackupJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBackupJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBackupJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBackupJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBackupJobErrorKind::DependencyFailureException`.
    pub fn is_dependency_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupJobErrorKind::DependencyFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeBackupJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBackupJobErrorKind::DependencyFailureException(_inner) => Some(_inner),
            DescribeBackupJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeBackupJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeBackupJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBackupJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeBackupJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBackupVaultError {
    /// Kind of error that occurred.
    pub kind: DescribeBackupVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBackupVaultErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBackupVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBackupVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeBackupVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeBackupVaultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBackupVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeBackupVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBackupVaultError {
    fn code(&self) -> Option<&str> {
        DescribeBackupVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBackupVaultError {
    /// Creates a new `DescribeBackupVaultError`.
    pub fn new(kind: DescribeBackupVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBackupVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBackupVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBackupVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBackupVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBackupVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeBackupVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBackupVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeBackupVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeBackupVaultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBackupVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeBackupVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCopyJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCopyJobError {
    /// Kind of error that occurred.
    pub kind: DescribeCopyJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCopyJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCopyJobErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCopyJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCopyJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeCopyJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeCopyJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCopyJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeCopyJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCopyJobError {
    fn code(&self) -> Option<&str> {
        DescribeCopyJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCopyJobError {
    /// Creates a new `DescribeCopyJobError`.
    pub fn new(kind: DescribeCopyJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCopyJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCopyJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCopyJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCopyJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCopyJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCopyJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCopyJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCopyJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCopyJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCopyJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCopyJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCopyJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeCopyJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCopyJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeCopyJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeCopyJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCopyJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeCopyJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFrameworkError {
    /// Kind of error that occurred.
    pub kind: DescribeFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFrameworkErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFrameworkErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeFrameworkErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeFrameworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFrameworkErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFrameworkError {
    fn code(&self) -> Option<&str> {
        DescribeFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFrameworkError {
    /// Creates a new `DescribeFrameworkError`.
    pub fn new(kind: DescribeFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFrameworkErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFrameworkErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFrameworkErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFrameworkErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFrameworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFrameworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFrameworkErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFrameworkErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFrameworkErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeFrameworkErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeFrameworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFrameworkErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGlobalSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGlobalSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeGlobalSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGlobalSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGlobalSettingsErrorKind {
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGlobalSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGlobalSettingsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGlobalSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeGlobalSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGlobalSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeGlobalSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGlobalSettingsError {
    /// Creates a new `DescribeGlobalSettingsError`.
    pub fn new(kind: DescribeGlobalSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGlobalSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGlobalSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGlobalSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGlobalSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGlobalSettingsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalSettingsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeGlobalSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGlobalSettingsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGlobalSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeGlobalSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProtectedResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProtectedResourceError {
    /// Kind of error that occurred.
    pub kind: DescribeProtectedResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProtectedResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProtectedResourceErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProtectedResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProtectedResourceErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProtectedResourceErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProtectedResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProtectedResourceErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProtectedResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProtectedResourceError {
    fn code(&self) -> Option<&str> {
        DescribeProtectedResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProtectedResourceError {
    /// Creates a new `DescribeProtectedResourceError`.
    pub fn new(kind: DescribeProtectedResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProtectedResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProtectedResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProtectedResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProtectedResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProtectedResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectedResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProtectedResourceErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectedResourceErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProtectedResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectedResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProtectedResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectedResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeProtectedResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProtectedResourceErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeProtectedResourceErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeProtectedResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProtectedResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeProtectedResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRecoveryPointError {
    /// Kind of error that occurred.
    pub kind: DescribeRecoveryPointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRecoveryPointErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRecoveryPointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRecoveryPointErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeRecoveryPointErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeRecoveryPointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRecoveryPointErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeRecoveryPointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRecoveryPointError {
    fn code(&self) -> Option<&str> {
        DescribeRecoveryPointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRecoveryPointError {
    /// Creates a new `DescribeRecoveryPointError`.
    pub fn new(kind: DescribeRecoveryPointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRecoveryPointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRecoveryPointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRecoveryPointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRecoveryPointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRecoveryPointErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryPointErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoveryPointErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryPointErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoveryPointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryPointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRecoveryPointErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecoveryPointErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeRecoveryPointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRecoveryPointErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeRecoveryPointErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeRecoveryPointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRecoveryPointErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeRecoveryPointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRegionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRegionSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeRegionSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRegionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRegionSettingsErrorKind {
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRegionSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRegionSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeRegionSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRegionSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeRegionSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRegionSettingsError {
    /// Creates a new `DescribeRegionSettingsError`.
    pub fn new(kind: DescribeRegionSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRegionSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRegionSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRegionSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRegionSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRegionSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegionSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeRegionSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRegionSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeRegionSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeReportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReportJobErrorKind {
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReportJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeReportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeReportJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeReportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReportJobError {
    fn code(&self) -> Option<&str> {
        DescribeReportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReportJobError {
    /// Creates a new `DescribeReportJobError`.
    pub fn new(kind: DescribeReportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReportJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReportJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReportJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReportJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeReportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReportJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeReportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeReportJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeReportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReportPlanError {
    /// Kind of error that occurred.
    pub kind: DescribeReportPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReportPlanErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReportPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReportPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeReportPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeReportPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeReportPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeReportPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReportPlanError {
    fn code(&self) -> Option<&str> {
        DescribeReportPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReportPlanError {
    /// Creates a new `DescribeReportPlanError`.
    pub fn new(kind: DescribeReportPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReportPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReportPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReportPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReportPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReportPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReportPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReportPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReportPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReportPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReportPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReportPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReportPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeReportPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReportPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeReportPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeReportPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeReportPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeReportPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRestoreJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRestoreJobError {
    /// Kind of error that occurred.
    pub kind: DescribeRestoreJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRestoreJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRestoreJobErrorKind {
    /// <p>A dependent Amazon Web Services service or resource returned an error to the Backup service, and the action cannot be completed.</p>
    DependencyFailureException(crate::error::DependencyFailureException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRestoreJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRestoreJobErrorKind::DependencyFailureException(_inner) => _inner.fmt(f),
            DescribeRestoreJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeRestoreJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeRestoreJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRestoreJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeRestoreJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRestoreJobError {
    fn code(&self) -> Option<&str> {
        DescribeRestoreJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRestoreJobError {
    /// Creates a new `DescribeRestoreJobError`.
    pub fn new(kind: DescribeRestoreJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRestoreJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRestoreJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRestoreJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRestoreJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRestoreJobErrorKind::DependencyFailureException`.
    pub fn is_dependency_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRestoreJobErrorKind::DependencyFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRestoreJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRestoreJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRestoreJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRestoreJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRestoreJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRestoreJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRestoreJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRestoreJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeRestoreJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRestoreJobErrorKind::DependencyFailureException(_inner) => Some(_inner),
            DescribeRestoreJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeRestoreJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeRestoreJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRestoreJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeRestoreJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateRecoveryPointError {
    /// Kind of error that occurred.
    pub kind: DisassociateRecoveryPointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateRecoveryPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateRecoveryPointErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Backup is already performing an action on this recovery point. It can't
    /// perform the action you requested until the first action finishes. Try again later.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateRecoveryPointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateRecoveryPointErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRecoveryPointErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateRecoveryPointErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRecoveryPointErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRecoveryPointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateRecoveryPointErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRecoveryPointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateRecoveryPointError {
    fn code(&self) -> Option<&str> {
        DisassociateRecoveryPointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateRecoveryPointError {
    /// Creates a new `DisassociateRecoveryPointError`.
    pub fn new(kind: DisassociateRecoveryPointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateRecoveryPointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateRecoveryPointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateRecoveryPointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateRecoveryPointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateRecoveryPointErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRecoveryPointErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRecoveryPointErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRecoveryPointErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRecoveryPointErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRecoveryPointErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRecoveryPointErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRecoveryPointErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRecoveryPointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRecoveryPointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRecoveryPointErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRecoveryPointErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DisassociateRecoveryPointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateRecoveryPointErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DisassociateRecoveryPointErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateRecoveryPointErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            DisassociateRecoveryPointErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            DisassociateRecoveryPointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateRecoveryPointErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DisassociateRecoveryPointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportBackupPlanTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportBackupPlanTemplateError {
    /// Kind of error that occurred.
    pub kind: ExportBackupPlanTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportBackupPlanTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportBackupPlanTemplateErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportBackupPlanTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportBackupPlanTemplateErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ExportBackupPlanTemplateErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ExportBackupPlanTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ExportBackupPlanTemplateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ExportBackupPlanTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportBackupPlanTemplateError {
    fn code(&self) -> Option<&str> {
        ExportBackupPlanTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportBackupPlanTemplateError {
    /// Creates a new `ExportBackupPlanTemplateError`.
    pub fn new(kind: ExportBackupPlanTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportBackupPlanTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportBackupPlanTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportBackupPlanTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportBackupPlanTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExportBackupPlanTemplateErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportBackupPlanTemplateErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportBackupPlanTemplateErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportBackupPlanTemplateErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportBackupPlanTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportBackupPlanTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportBackupPlanTemplateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportBackupPlanTemplateErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ExportBackupPlanTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportBackupPlanTemplateErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ExportBackupPlanTemplateErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            ExportBackupPlanTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExportBackupPlanTemplateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ExportBackupPlanTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackupPlanError {
    /// Kind of error that occurred.
    pub kind: GetBackupPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackupPlanErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackupPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackupPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetBackupPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            GetBackupPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBackupPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetBackupPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackupPlanError {
    fn code(&self) -> Option<&str> {
        GetBackupPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackupPlanError {
    /// Creates a new `GetBackupPlanError`.
    pub fn new(kind: GetBackupPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackupPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackupPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackupPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackupPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackupPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetBackupPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackupPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetBackupPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetBackupPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBackupPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetBackupPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackupPlanFromJSON` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackupPlanFromJSONError {
    /// Kind of error that occurred.
    pub kind: GetBackupPlanFromJSONErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackupPlanFromJSON` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackupPlanFromJSONErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackupPlanFromJSONError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackupPlanFromJSONErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetBackupPlanFromJSONErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetBackupPlanFromJSONErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBackupPlanFromJSONErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            GetBackupPlanFromJSONErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetBackupPlanFromJSONErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackupPlanFromJSONError {
    fn code(&self) -> Option<&str> {
        GetBackupPlanFromJSONError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackupPlanFromJSONError {
    /// Creates a new `GetBackupPlanFromJSONError`.
    pub fn new(kind: GetBackupPlanFromJSONErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackupPlanFromJSONError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackupPlanFromJSONErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackupPlanFromJSONError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackupPlanFromJSONErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromJSONErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromJSONErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromJSONErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromJSONErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromJSONErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromJSONErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromJSONErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromJSONErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromJSONErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromJSONErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetBackupPlanFromJSONError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackupPlanFromJSONErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetBackupPlanFromJSONErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetBackupPlanFromJSONErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBackupPlanFromJSONErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetBackupPlanFromJSONErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetBackupPlanFromJSONErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackupPlanFromTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackupPlanFromTemplateError {
    /// Kind of error that occurred.
    pub kind: GetBackupPlanFromTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackupPlanFromTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackupPlanFromTemplateErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackupPlanFromTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackupPlanFromTemplateErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupPlanFromTemplateErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupPlanFromTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBackupPlanFromTemplateErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupPlanFromTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackupPlanFromTemplateError {
    fn code(&self) -> Option<&str> {
        GetBackupPlanFromTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackupPlanFromTemplateError {
    /// Creates a new `GetBackupPlanFromTemplateError`.
    pub fn new(kind: GetBackupPlanFromTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackupPlanFromTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackupPlanFromTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackupPlanFromTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackupPlanFromTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromTemplateErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromTemplateErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromTemplateErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromTemplateErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupPlanFromTemplateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupPlanFromTemplateErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetBackupPlanFromTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackupPlanFromTemplateErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetBackupPlanFromTemplateErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            GetBackupPlanFromTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBackupPlanFromTemplateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetBackupPlanFromTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackupSelection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackupSelectionError {
    /// Kind of error that occurred.
    pub kind: GetBackupSelectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackupSelection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackupSelectionErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackupSelectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackupSelectionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetBackupSelectionErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            GetBackupSelectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBackupSelectionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetBackupSelectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackupSelectionError {
    fn code(&self) -> Option<&str> {
        GetBackupSelectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackupSelectionError {
    /// Creates a new `GetBackupSelectionError`.
    pub fn new(kind: GetBackupSelectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackupSelectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackupSelectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackupSelectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackupSelectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackupSelectionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupSelectionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupSelectionErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupSelectionErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupSelectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupSelectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupSelectionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupSelectionErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetBackupSelectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackupSelectionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetBackupSelectionErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetBackupSelectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBackupSelectionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetBackupSelectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackupVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackupVaultAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: GetBackupVaultAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackupVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackupVaultAccessPolicyErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackupVaultAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupVaultAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackupVaultAccessPolicyError {
    fn code(&self) -> Option<&str> {
        GetBackupVaultAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackupVaultAccessPolicyError {
    /// Creates a new `GetBackupVaultAccessPolicyError`.
    pub fn new(kind: GetBackupVaultAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackupVaultAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackupVaultAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackupVaultAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackupVaultAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackupVaultAccessPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupVaultAccessPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupVaultAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupVaultAccessPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetBackupVaultAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            GetBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetBackupVaultAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBackupVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBackupVaultNotificationsError {
    /// Kind of error that occurred.
    pub kind: GetBackupVaultNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBackupVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBackupVaultNotificationsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBackupVaultNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBackupVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetBackupVaultNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBackupVaultNotificationsError {
    fn code(&self) -> Option<&str> {
        GetBackupVaultNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBackupVaultNotificationsError {
    /// Creates a new `GetBackupVaultNotificationsError`.
    pub fn new(kind: GetBackupVaultNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBackupVaultNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBackupVaultNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBackupVaultNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBackupVaultNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBackupVaultNotificationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultNotificationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupVaultNotificationsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultNotificationsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupVaultNotificationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultNotificationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBackupVaultNotificationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBackupVaultNotificationsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetBackupVaultNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBackupVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetBackupVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            GetBackupVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBackupVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetBackupVaultNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecoveryPointRestoreMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecoveryPointRestoreMetadataError {
    /// Kind of error that occurred.
    pub kind: GetRecoveryPointRestoreMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecoveryPointRestoreMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecoveryPointRestoreMetadataErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecoveryPointRestoreMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecoveryPointRestoreMetadataErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetRecoveryPointRestoreMetadataErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetRecoveryPointRestoreMetadataErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetRecoveryPointRestoreMetadataErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetRecoveryPointRestoreMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecoveryPointRestoreMetadataError {
    fn code(&self) -> Option<&str> {
        GetRecoveryPointRestoreMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecoveryPointRestoreMetadataError {
    /// Creates a new `GetRecoveryPointRestoreMetadataError`.
    pub fn new(
        kind: GetRecoveryPointRestoreMetadataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecoveryPointRestoreMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecoveryPointRestoreMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecoveryPointRestoreMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecoveryPointRestoreMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecoveryPointRestoreMetadataErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryPointRestoreMetadataErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryPointRestoreMetadataErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryPointRestoreMetadataErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryPointRestoreMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryPointRestoreMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryPointRestoreMetadataErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryPointRestoreMetadataErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetRecoveryPointRestoreMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecoveryPointRestoreMetadataErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetRecoveryPointRestoreMetadataErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            GetRecoveryPointRestoreMetadataErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetRecoveryPointRestoreMetadataErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetRecoveryPointRestoreMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSupportedResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSupportedResourceTypesError {
    /// Kind of error that occurred.
    pub kind: GetSupportedResourceTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSupportedResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSupportedResourceTypesErrorKind {
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSupportedResourceTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSupportedResourceTypesErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetSupportedResourceTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSupportedResourceTypesError {
    fn code(&self) -> Option<&str> {
        GetSupportedResourceTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSupportedResourceTypesError {
    /// Creates a new `GetSupportedResourceTypesError`.
    pub fn new(kind: GetSupportedResourceTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSupportedResourceTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSupportedResourceTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSupportedResourceTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSupportedResourceTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSupportedResourceTypesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSupportedResourceTypesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetSupportedResourceTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSupportedResourceTypesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetSupportedResourceTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackupJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackupJobsError {
    /// Kind of error that occurred.
    pub kind: ListBackupJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackupJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackupJobsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackupJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackupJobsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListBackupJobsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBackupJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackupJobsError {
    fn code(&self) -> Option<&str> {
        ListBackupJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackupJobsError {
    /// Creates a new `ListBackupJobsError`.
    pub fn new(kind: ListBackupJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackupJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackupJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackupJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackupJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackupJobsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupJobsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupJobsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupJobsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListBackupJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackupJobsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListBackupJobsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBackupJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackupPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackupPlansError {
    /// Kind of error that occurred.
    pub kind: ListBackupPlansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackupPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackupPlansErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackupPlansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackupPlansErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListBackupPlansErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListBackupPlansErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBackupPlansErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBackupPlansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackupPlansError {
    fn code(&self) -> Option<&str> {
        ListBackupPlansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackupPlansError {
    /// Creates a new `ListBackupPlansError`.
    pub fn new(kind: ListBackupPlansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackupPlansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackupPlansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackupPlansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackupPlansErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackupPlansErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlansErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlansErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlansErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlansErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlansErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlansErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlansErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListBackupPlansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackupPlansErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListBackupPlansErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListBackupPlansErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBackupPlansErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBackupPlansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackupPlanTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackupPlanTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListBackupPlanTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackupPlanTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackupPlanTemplatesErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackupPlanTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackupPlanTemplatesErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListBackupPlanTemplatesErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListBackupPlanTemplatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBackupPlanTemplatesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBackupPlanTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackupPlanTemplatesError {
    fn code(&self) -> Option<&str> {
        ListBackupPlanTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackupPlanTemplatesError {
    /// Creates a new `ListBackupPlanTemplatesError`.
    pub fn new(kind: ListBackupPlanTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackupPlanTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackupPlanTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackupPlanTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackupPlanTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackupPlanTemplatesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanTemplatesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlanTemplatesErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanTemplatesErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlanTemplatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanTemplatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlanTemplatesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanTemplatesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListBackupPlanTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackupPlanTemplatesErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListBackupPlanTemplatesErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            ListBackupPlanTemplatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBackupPlanTemplatesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBackupPlanTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackupPlanVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackupPlanVersionsError {
    /// Kind of error that occurred.
    pub kind: ListBackupPlanVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackupPlanVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackupPlanVersionsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackupPlanVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackupPlanVersionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListBackupPlanVersionsErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListBackupPlanVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBackupPlanVersionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBackupPlanVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackupPlanVersionsError {
    fn code(&self) -> Option<&str> {
        ListBackupPlanVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackupPlanVersionsError {
    /// Creates a new `ListBackupPlanVersionsError`.
    pub fn new(kind: ListBackupPlanVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackupPlanVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackupPlanVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackupPlanVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackupPlanVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackupPlanVersionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanVersionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlanVersionsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanVersionsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlanVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupPlanVersionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupPlanVersionsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListBackupPlanVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackupPlanVersionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListBackupPlanVersionsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListBackupPlanVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBackupPlanVersionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBackupPlanVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackupSelections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackupSelectionsError {
    /// Kind of error that occurred.
    pub kind: ListBackupSelectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackupSelections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackupSelectionsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackupSelectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackupSelectionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListBackupSelectionsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListBackupSelectionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBackupSelectionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBackupSelectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackupSelectionsError {
    fn code(&self) -> Option<&str> {
        ListBackupSelectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackupSelectionsError {
    /// Creates a new `ListBackupSelectionsError`.
    pub fn new(kind: ListBackupSelectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackupSelectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackupSelectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackupSelectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackupSelectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackupSelectionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupSelectionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupSelectionsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupSelectionsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupSelectionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupSelectionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupSelectionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupSelectionsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListBackupSelectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackupSelectionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListBackupSelectionsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListBackupSelectionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBackupSelectionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBackupSelectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackupVaults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackupVaultsError {
    /// Kind of error that occurred.
    pub kind: ListBackupVaultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackupVaults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackupVaultsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackupVaultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackupVaultsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListBackupVaultsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListBackupVaultsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBackupVaultsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListBackupVaultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackupVaultsError {
    fn code(&self) -> Option<&str> {
        ListBackupVaultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackupVaultsError {
    /// Creates a new `ListBackupVaultsError`.
    pub fn new(kind: ListBackupVaultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackupVaultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackupVaultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackupVaultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackupVaultsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackupVaultsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupVaultsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupVaultsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupVaultsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupVaultsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupVaultsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBackupVaultsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupVaultsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListBackupVaultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackupVaultsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListBackupVaultsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListBackupVaultsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBackupVaultsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListBackupVaultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCopyJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCopyJobsError {
    /// Kind of error that occurred.
    pub kind: ListCopyJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCopyJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCopyJobsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCopyJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCopyJobsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListCopyJobsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListCopyJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCopyJobsError {
    fn code(&self) -> Option<&str> {
        ListCopyJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCopyJobsError {
    /// Creates a new `ListCopyJobsError`.
    pub fn new(kind: ListCopyJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCopyJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCopyJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCopyJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCopyJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCopyJobsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCopyJobsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCopyJobsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCopyJobsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListCopyJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCopyJobsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListCopyJobsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListCopyJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFrameworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFrameworksError {
    /// Kind of error that occurred.
    pub kind: ListFrameworksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFrameworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFrameworksErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFrameworksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFrameworksErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListFrameworksErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListFrameworksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFrameworksError {
    fn code(&self) -> Option<&str> {
        ListFrameworksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFrameworksError {
    /// Creates a new `ListFrameworksError`.
    pub fn new(kind: ListFrameworksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFrameworksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFrameworksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFrameworksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFrameworksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFrameworksErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFrameworksErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFrameworksErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFrameworksErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListFrameworksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFrameworksErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListFrameworksErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListFrameworksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProtectedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProtectedResourcesError {
    /// Kind of error that occurred.
    pub kind: ListProtectedResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProtectedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProtectedResourcesErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProtectedResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProtectedResourcesErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListProtectedResourcesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListProtectedResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProtectedResourcesError {
    fn code(&self) -> Option<&str> {
        ListProtectedResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProtectedResourcesError {
    /// Creates a new `ListProtectedResourcesError`.
    pub fn new(kind: ListProtectedResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProtectedResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProtectedResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProtectedResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProtectedResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProtectedResourcesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectedResourcesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProtectedResourcesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectedResourcesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListProtectedResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProtectedResourcesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListProtectedResourcesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListProtectedResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRecoveryPointsByBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecoveryPointsByBackupVaultError {
    /// Kind of error that occurred.
    pub kind: ListRecoveryPointsByBackupVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecoveryPointsByBackupVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecoveryPointsByBackupVaultErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecoveryPointsByBackupVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecoveryPointsByBackupVaultErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByBackupVaultErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByBackupVaultErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByBackupVaultErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByBackupVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecoveryPointsByBackupVaultError {
    fn code(&self) -> Option<&str> {
        ListRecoveryPointsByBackupVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecoveryPointsByBackupVaultError {
    /// Creates a new `ListRecoveryPointsByBackupVaultError`.
    pub fn new(
        kind: ListRecoveryPointsByBackupVaultErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecoveryPointsByBackupVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecoveryPointsByBackupVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecoveryPointsByBackupVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecoveryPointsByBackupVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByBackupVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByBackupVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByBackupVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByBackupVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByBackupVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByBackupVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByBackupVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByBackupVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListRecoveryPointsByBackupVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecoveryPointsByBackupVaultErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByBackupVaultErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByBackupVaultErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByBackupVaultErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByBackupVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRecoveryPointsByResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecoveryPointsByResourceError {
    /// Kind of error that occurred.
    pub kind: ListRecoveryPointsByResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecoveryPointsByResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecoveryPointsByResourceErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecoveryPointsByResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecoveryPointsByResourceErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByResourceErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByResourceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByResourceErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListRecoveryPointsByResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecoveryPointsByResourceError {
    fn code(&self) -> Option<&str> {
        ListRecoveryPointsByResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecoveryPointsByResourceError {
    /// Creates a new `ListRecoveryPointsByResourceError`.
    pub fn new(kind: ListRecoveryPointsByResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecoveryPointsByResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecoveryPointsByResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecoveryPointsByResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecoveryPointsByResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByResourceErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByResourceErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryPointsByResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryPointsByResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListRecoveryPointsByResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecoveryPointsByResourceErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByResourceErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByResourceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByResourceErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ListRecoveryPointsByResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReportJobsError {
    /// Kind of error that occurred.
    pub kind: ListReportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReportJobsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReportJobsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListReportJobsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListReportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReportJobsError {
    fn code(&self) -> Option<&str> {
        ListReportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReportJobsError {
    /// Creates a new `ListReportJobsError`.
    pub fn new(kind: ListReportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReportJobsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReportJobsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReportJobsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReportJobsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListReportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReportJobsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListReportJobsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListReportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReportPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReportPlansError {
    /// Kind of error that occurred.
    pub kind: ListReportPlansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReportPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReportPlansErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReportPlansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReportPlansErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListReportPlansErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListReportPlansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReportPlansError {
    fn code(&self) -> Option<&str> {
        ListReportPlansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReportPlansError {
    /// Creates a new `ListReportPlansError`.
    pub fn new(kind: ListReportPlansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReportPlansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReportPlansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReportPlansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReportPlansErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReportPlansErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReportPlansErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReportPlansErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReportPlansErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListReportPlansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReportPlansErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListReportPlansErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListReportPlansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRestoreJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRestoreJobsError {
    /// Kind of error that occurred.
    pub kind: ListRestoreJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRestoreJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRestoreJobsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRestoreJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRestoreJobsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListRestoreJobsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListRestoreJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRestoreJobsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListRestoreJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRestoreJobsError {
    fn code(&self) -> Option<&str> {
        ListRestoreJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRestoreJobsError {
    /// Creates a new `ListRestoreJobsError`.
    pub fn new(kind: ListRestoreJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRestoreJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRestoreJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRestoreJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRestoreJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRestoreJobsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRestoreJobsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRestoreJobsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRestoreJobsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRestoreJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRestoreJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRestoreJobsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRestoreJobsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListRestoreJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRestoreJobsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListRestoreJobsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListRestoreJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRestoreJobsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListRestoreJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTagsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutBackupVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutBackupVaultAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: PutBackupVaultAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutBackupVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutBackupVaultAccessPolicyErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutBackupVaultAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutBackupVaultAccessPolicyError {
    fn code(&self) -> Option<&str> {
        PutBackupVaultAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutBackupVaultAccessPolicyError {
    /// Creates a new `PutBackupVaultAccessPolicyError`.
    pub fn new(kind: PutBackupVaultAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutBackupVaultAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutBackupVaultAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutBackupVaultAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutBackupVaultAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutBackupVaultAccessPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultAccessPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultAccessPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutBackupVaultAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutBackupVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutBackupVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutBackupVaultLockConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutBackupVaultLockConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutBackupVaultLockConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutBackupVaultLockConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutBackupVaultLockConfigurationErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutBackupVaultLockConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutBackupVaultLockConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultLockConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultLockConfigurationErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultLockConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultLockConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultLockConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutBackupVaultLockConfigurationError {
    fn code(&self) -> Option<&str> {
        PutBackupVaultLockConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutBackupVaultLockConfigurationError {
    /// Creates a new `PutBackupVaultLockConfigurationError`.
    pub fn new(
        kind: PutBackupVaultLockConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutBackupVaultLockConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutBackupVaultLockConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutBackupVaultLockConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutBackupVaultLockConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutBackupVaultLockConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultLockConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultLockConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultLockConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultLockConfigurationErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultLockConfigurationErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultLockConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultLockConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultLockConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultLockConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutBackupVaultLockConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutBackupVaultLockConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultLockConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultLockConfigurationErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultLockConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultLockConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultLockConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutBackupVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutBackupVaultNotificationsError {
    /// Kind of error that occurred.
    pub kind: PutBackupVaultNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutBackupVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutBackupVaultNotificationsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutBackupVaultNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutBackupVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            PutBackupVaultNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutBackupVaultNotificationsError {
    fn code(&self) -> Option<&str> {
        PutBackupVaultNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutBackupVaultNotificationsError {
    /// Creates a new `PutBackupVaultNotificationsError`.
    pub fn new(kind: PutBackupVaultNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutBackupVaultNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutBackupVaultNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutBackupVaultNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutBackupVaultNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutBackupVaultNotificationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultNotificationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultNotificationsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultNotificationsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultNotificationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultNotificationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupVaultNotificationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupVaultNotificationsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutBackupVaultNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutBackupVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutBackupVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            PutBackupVaultNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartBackupJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartBackupJobError {
    /// Kind of error that occurred.
    pub kind: StartBackupJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartBackupJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartBackupJobErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartBackupJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartBackupJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            StartBackupJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartBackupJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartBackupJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            StartBackupJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartBackupJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartBackupJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartBackupJobError {
    fn code(&self) -> Option<&str> {
        StartBackupJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartBackupJobError {
    /// Creates a new `StartBackupJobError`.
    pub fn new(kind: StartBackupJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartBackupJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartBackupJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartBackupJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartBackupJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartBackupJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBackupJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBackupJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBackupJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBackupJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBackupJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBackupJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBackupJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBackupJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBackupJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBackupJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBackupJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for StartBackupJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartBackupJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            StartBackupJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartBackupJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartBackupJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            StartBackupJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartBackupJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartBackupJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartCopyJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartCopyJobError {
    /// Kind of error that occurred.
    pub kind: StartCopyJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartCopyJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartCopyJobErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartCopyJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartCopyJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            StartCopyJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartCopyJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartCopyJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            StartCopyJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartCopyJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartCopyJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartCopyJobError {
    fn code(&self) -> Option<&str> {
        StartCopyJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartCopyJobError {
    /// Creates a new `StartCopyJobError`.
    pub fn new(kind: StartCopyJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartCopyJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartCopyJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartCopyJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartCopyJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartCopyJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCopyJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCopyJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCopyJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCopyJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StartCopyJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `StartCopyJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCopyJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCopyJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCopyJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCopyJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCopyJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for StartCopyJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartCopyJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            StartCopyJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartCopyJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartCopyJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            StartCopyJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartCopyJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartCopyJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartReportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartReportJobError {
    /// Kind of error that occurred.
    pub kind: StartReportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartReportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartReportJobErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartReportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartReportJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            StartReportJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            StartReportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartReportJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartReportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartReportJobError {
    fn code(&self) -> Option<&str> {
        StartReportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartReportJobError {
    /// Creates a new `StartReportJobError`.
    pub fn new(kind: StartReportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartReportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartReportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartReportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartReportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartReportJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReportJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReportJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReportJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReportJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReportJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for StartReportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartReportJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            StartReportJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            StartReportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartReportJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartReportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartRestoreJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartRestoreJobError {
    /// Kind of error that occurred.
    pub kind: StartRestoreJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartRestoreJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartRestoreJobErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartRestoreJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartRestoreJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            StartRestoreJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            StartRestoreJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartRestoreJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartRestoreJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartRestoreJobError {
    fn code(&self) -> Option<&str> {
        StartRestoreJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartRestoreJobError {
    /// Creates a new `StartRestoreJobError`.
    pub fn new(kind: StartRestoreJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartRestoreJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartRestoreJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartRestoreJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartRestoreJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartRestoreJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRestoreJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRestoreJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRestoreJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRestoreJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRestoreJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartRestoreJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartRestoreJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for StartRestoreJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartRestoreJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            StartRestoreJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            StartRestoreJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartRestoreJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartRestoreJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopBackupJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopBackupJobError {
    /// Kind of error that occurred.
    pub kind: StopBackupJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopBackupJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopBackupJobErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopBackupJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopBackupJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            StopBackupJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopBackupJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            StopBackupJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopBackupJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StopBackupJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopBackupJobError {
    fn code(&self) -> Option<&str> {
        StopBackupJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopBackupJobError {
    /// Creates a new `StopBackupJobError`.
    pub fn new(kind: StopBackupJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopBackupJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopBackupJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopBackupJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopBackupJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopBackupJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBackupJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StopBackupJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBackupJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopBackupJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBackupJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StopBackupJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBackupJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopBackupJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBackupJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for StopBackupJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopBackupJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            StopBackupJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopBackupJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            StopBackupJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopBackupJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StopBackupJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UntagResourceErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBackupPlanError {
    /// Kind of error that occurred.
    pub kind: UpdateBackupPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBackupPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBackupPlanErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBackupPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBackupPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateBackupPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UpdateBackupPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateBackupPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateBackupPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBackupPlanError {
    fn code(&self) -> Option<&str> {
        UpdateBackupPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBackupPlanError {
    /// Creates a new `UpdateBackupPlanError`.
    pub fn new(kind: UpdateBackupPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBackupPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBackupPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBackupPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBackupPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBackupPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackupPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackupPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackupPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackupPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackupPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBackupPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBackupPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateBackupPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBackupPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateBackupPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UpdateBackupPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateBackupPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateBackupPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFrameworkError {
    /// Kind of error that occurred.
    pub kind: UpdateFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFrameworkErrorKind {
    /// <p>The required resource already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Backup can't perform the action that you requested until it finishes
    /// performing a previous action. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
    /// in a request.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFrameworkErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateFrameworkErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFrameworkErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateFrameworkErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateFrameworkErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UpdateFrameworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFrameworkErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFrameworkError {
    fn code(&self) -> Option<&str> {
        UpdateFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFrameworkError {
    /// Creates a new `UpdateFrameworkError`.
    pub fn new(kind: UpdateFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFrameworkErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFrameworkErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFrameworkErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateFrameworkErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateFrameworkErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFrameworkErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFrameworkErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFrameworkErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFrameworkErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFrameworkErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFrameworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFrameworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFrameworkErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFrameworkErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFrameworkErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            UpdateFrameworkErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFrameworkErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateFrameworkErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateFrameworkErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UpdateFrameworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFrameworkErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGlobalSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGlobalSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateGlobalSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGlobalSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGlobalSettingsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGlobalSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGlobalSettingsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateGlobalSettingsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateGlobalSettingsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UpdateGlobalSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateGlobalSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGlobalSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateGlobalSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGlobalSettingsError {
    /// Creates a new `UpdateGlobalSettingsError`.
    pub fn new(kind: UpdateGlobalSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGlobalSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGlobalSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGlobalSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGlobalSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGlobalSettingsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalSettingsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalSettingsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalSettingsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalSettingsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalSettingsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateGlobalSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGlobalSettingsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateGlobalSettingsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateGlobalSettingsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UpdateGlobalSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateGlobalSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRecoveryPointLifecycle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRecoveryPointLifecycleError {
    /// Kind of error that occurred.
    pub kind: UpdateRecoveryPointLifecycleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRecoveryPointLifecycle` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRecoveryPointLifecycleErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// parameter is of the wrong type.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRecoveryPointLifecycleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRecoveryPointLifecycleErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecoveryPointLifecycleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateRecoveryPointLifecycleErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecoveryPointLifecycleErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecoveryPointLifecycleErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRecoveryPointLifecycleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRecoveryPointLifecycleError {
    fn code(&self) -> Option<&str> {
        UpdateRecoveryPointLifecycleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRecoveryPointLifecycleError {
    /// Creates a new `UpdateRecoveryPointLifecycleError`.
    pub fn new(kind: UpdateRecoveryPointLifecycleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRecoveryPointLifecycleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRecoveryPointLifecycleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRecoveryPointLifecycleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRecoveryPointLifecycleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRecoveryPointLifecycleErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryPointLifecycleErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryPointLifecycleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryPointLifecycleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryPointLifecycleErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryPointLifecycleErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryPointLifecycleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryPointLifecycleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryPointLifecycleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryPointLifecycleErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateRecoveryPointLifecycleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRecoveryPointLifecycleErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateRecoveryPointLifecycleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateRecoveryPointLifecycleErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateRecoveryPointLifecycleErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateRecoveryPointLifecycleErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateRecoveryPointLifecycleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRegionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRegionSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateRegionSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRegionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRegionSettingsErrorKind {
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRegionSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRegionSettingsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateRegionSettingsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UpdateRegionSettingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateRegionSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRegionSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateRegionSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRegionSettingsError {
    /// Creates a new `UpdateRegionSettingsError`.
    pub fn new(kind: UpdateRegionSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRegionSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRegionSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRegionSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRegionSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRegionSettingsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegionSettingsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegionSettingsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegionSettingsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegionSettingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegionSettingsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateRegionSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRegionSettingsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateRegionSettingsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UpdateRegionSettingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateRegionSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReportPlanError {
    /// Kind of error that occurred.
    pub kind: UpdateReportPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReportPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReportPlanErrorKind {
    /// <p>Backup can't perform the action that you requested until it finishes
    /// performing a previous action. Try again later.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Indicates that something is wrong with a parameter's value. For example, the value is
    /// out of range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Indicates that a required parameter is missing.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>A resource that is required for the action doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request failed due to a temporary failure of the server.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReportPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReportPlanErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateReportPlanErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateReportPlanErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UpdateReportPlanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateReportPlanErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateReportPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReportPlanError {
    fn code(&self) -> Option<&str> {
        UpdateReportPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReportPlanError {
    /// Creates a new `UpdateReportPlanError`.
    pub fn new(kind: UpdateReportPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReportPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReportPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReportPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReportPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReportPlanErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateReportPlanErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateReportPlanErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReportPlanErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReportPlanErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReportPlanErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReportPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReportPlanErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReportPlanErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReportPlanErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateReportPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReportPlanErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateReportPlanErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateReportPlanErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UpdateReportPlanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateReportPlanErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateReportPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request failed due to a temporary failure of the server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>A resource that is required for the action doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Indicates that a required parameter is missing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl MissingParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for MissingParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingParameterValueException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl MissingParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingParameterValueException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingParameterValueException {}
/// See [`MissingParameterValueException`](crate::error::MissingParameterValueException)
pub mod missing_parameter_value_exception {
    /// A builder for [`MissingParameterValueException`](crate::error::MissingParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingParameterValueException`](crate::error::MissingParameterValueException)
        pub fn build(self) -> crate::error::MissingParameterValueException {
            crate::error::MissingParameterValueException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl MissingParameterValueException {
    /// Creates a new builder-style object to manufacture [`MissingParameterValueException`](crate::error::MissingParameterValueException)
    pub fn builder() -> crate::error::missing_parameter_value_exception::Builder {
        crate::error::missing_parameter_value_exception::Builder::default()
    }
}

/// <p>Indicates that something is wrong with a parameter's value. For example, the value is
/// out of range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl InvalidParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>Backup can't perform the action that you requested until it finishes
/// performing a previous action. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>Indicates that something is wrong with the input to the request. For example, a
/// parameter is of the wrong type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>A limit in the request has been exceeded; for example, a maximum number of items allowed
/// in a request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The required resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p></p>
    pub arn: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p></p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p></p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                code: self.code,
                message: self.message,
                creator_request_id: self.creator_request_id,
                arn: self.arn,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>Backup is already performing an action on this recovery point. It can't
/// perform the action you requested until the first action finishes. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl InvalidResourceStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceStateException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl InvalidResourceStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceStateException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceStateException {}
/// See [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
pub mod invalid_resource_state_exception {
    /// A builder for [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
        pub fn build(self) -> crate::error::InvalidResourceStateException {
            crate::error::InvalidResourceStateException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl InvalidResourceStateException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    pub fn builder() -> crate::error::invalid_resource_state_exception::Builder {
        crate::error::invalid_resource_state_exception::Builder::default()
    }
}

/// <p>A dependent Amazon Web Services service or resource returned an error to the Backup service, and the action cannot be completed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p></p>
    pub context: std::option::Option<std::string::String>,
}
impl DependencyFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p></p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
}
impl std::fmt::Debug for DependencyFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyFailureException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
impl DependencyFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyFailureException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyFailureException {}
/// See [`DependencyFailureException`](crate::error::DependencyFailureException)
pub mod dependency_failure_exception {
    /// A builder for [`DependencyFailureException`](crate::error::DependencyFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p></p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyFailureException`](crate::error::DependencyFailureException)
        pub fn build(self) -> crate::error::DependencyFailureException {
            crate::error::DependencyFailureException {
                code: self.code,
                message: self.message,
                r#type: self.r#type,
                context: self.context,
            }
        }
    }
}
impl DependencyFailureException {
    /// Creates a new builder-style object to manufacture [`DependencyFailureException`](crate::error::DependencyFailureException)
    pub fn builder() -> crate::error::dependency_failure_exception::Builder {
        crate::error::dependency_failure_exception::Builder::default()
    }
}
