// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains detailed information about a report setting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportSetting {
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    pub report_template: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the frameworks a report covers.</p>
    pub framework_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of frameworks a report covers.</p>
    pub number_of_frameworks: i32,
}
impl ReportSetting {
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    pub fn report_template(&self) -> std::option::Option<&str> {
        self.report_template.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the frameworks a report covers.</p>
    pub fn framework_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.framework_arns.as_deref()
    }
    /// <p>The number of frameworks a report covers.</p>
    pub fn number_of_frameworks(&self) -> i32 {
        self.number_of_frameworks
    }
}
impl std::fmt::Debug for ReportSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportSetting");
        formatter.field("report_template", &self.report_template);
        formatter.field("framework_arns", &self.framework_arns);
        formatter.field("number_of_frameworks", &self.number_of_frameworks);
        formatter.finish()
    }
}
/// See [`ReportSetting`](crate::model::ReportSetting)
pub mod report_setting {
    /// A builder for [`ReportSetting`](crate::model::ReportSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_template: std::option::Option<std::string::String>,
        pub(crate) framework_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) number_of_frameworks: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        pub fn report_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_template = Some(input.into());
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        pub fn set_report_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_template = input;
            self
        }
        /// Appends an item to `framework_arns`.
        ///
        /// To override the contents of this collection use [`set_framework_arns`](Self::set_framework_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the frameworks a report covers.</p>
        pub fn framework_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.framework_arns.unwrap_or_default();
            v.push(input.into());
            self.framework_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the frameworks a report covers.</p>
        pub fn set_framework_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.framework_arns = input;
            self
        }
        /// <p>The number of frameworks a report covers.</p>
        pub fn number_of_frameworks(mut self, input: i32) -> Self {
            self.number_of_frameworks = Some(input);
            self
        }
        /// <p>The number of frameworks a report covers.</p>
        pub fn set_number_of_frameworks(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_frameworks = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportSetting`](crate::model::ReportSetting)
        pub fn build(self) -> crate::model::ReportSetting {
            crate::model::ReportSetting {
                report_template: self.report_template,
                framework_arns: self.framework_arns,
                number_of_frameworks: self.number_of_frameworks.unwrap_or_default(),
            }
        }
    }
}
impl ReportSetting {
    /// Creates a new builder-style object to manufacture [`ReportSetting`](crate::model::ReportSetting)
    pub fn builder() -> crate::model::report_setting::Builder {
        crate::model::report_setting::Builder::default()
    }
}

/// <p>Contains information from your report plan about where to deliver your reports,
/// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
/// reports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportDeliveryChannel {
    /// <p>The unique name of the S3 bucket that receives your reports.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path:
    /// s3://your-bucket-name/<code>prefix</code>/Backup/us-west-2/year/month/day/report-name.
    /// If not specified, there is no prefix.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>A list of the format of your reports: <code>CSV</code>, <code>JSON</code>, or both. If
    /// not specified, the default format is <code>CSV</code>.</p>
    pub formats: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReportDeliveryChannel {
    /// <p>The unique name of the S3 bucket that receives your reports.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path:
    /// s3://your-bucket-name/<code>prefix</code>/Backup/us-west-2/year/month/day/report-name.
    /// If not specified, there is no prefix.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>A list of the format of your reports: <code>CSV</code>, <code>JSON</code>, or both. If
    /// not specified, the default format is <code>CSV</code>.</p>
    pub fn formats(&self) -> std::option::Option<&[std::string::String]> {
        self.formats.as_deref()
    }
}
impl std::fmt::Debug for ReportDeliveryChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportDeliveryChannel");
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("formats", &self.formats);
        formatter.finish()
    }
}
/// See [`ReportDeliveryChannel`](crate::model::ReportDeliveryChannel)
pub mod report_delivery_channel {
    /// A builder for [`ReportDeliveryChannel`](crate::model::ReportDeliveryChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) formats: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique name of the S3 bucket that receives your reports.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The unique name of the S3 bucket that receives your reports.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path:
        /// s3://your-bucket-name/<code>prefix</code>/Backup/us-west-2/year/month/day/report-name.
        /// If not specified, there is no prefix.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path:
        /// s3://your-bucket-name/<code>prefix</code>/Backup/us-west-2/year/month/day/report-name.
        /// If not specified, there is no prefix.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// Appends an item to `formats`.
        ///
        /// To override the contents of this collection use [`set_formats`](Self::set_formats).
        ///
        /// <p>A list of the format of your reports: <code>CSV</code>, <code>JSON</code>, or both. If
        /// not specified, the default format is <code>CSV</code>.</p>
        pub fn formats(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.formats.unwrap_or_default();
            v.push(input.into());
            self.formats = Some(v);
            self
        }
        /// <p>A list of the format of your reports: <code>CSV</code>, <code>JSON</code>, or both. If
        /// not specified, the default format is <code>CSV</code>.</p>
        pub fn set_formats(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.formats = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportDeliveryChannel`](crate::model::ReportDeliveryChannel)
        pub fn build(self) -> crate::model::ReportDeliveryChannel {
            crate::model::ReportDeliveryChannel {
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                formats: self.formats,
            }
        }
    }
}
impl ReportDeliveryChannel {
    /// Creates a new builder-style object to manufacture [`ReportDeliveryChannel`](crate::model::ReportDeliveryChannel)
    pub fn builder() -> crate::model::report_delivery_channel::Builder {
        crate::model::report_delivery_channel::Builder::default()
    }
}

/// <p>Contains <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps, which
/// are used to specify a lifecycle for a recovery point.</p>
/// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
/// it expires. Backup transitions and expires backups automatically according to
/// the lifecycle that you define.</p>
/// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
/// days. Therefore, the “expire after days” setting must be 90 days greater than the
/// “transition to cold after days” setting. The “transition to cold after days” setting cannot
/// be changed after a backup has been transitioned to cold.</p>
/// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculatedLifecycle {
    /// <p>A timestamp that specifies when to transition a recovery point to cold storage.</p>
    pub move_to_cold_storage_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that specifies when to delete a recovery point.</p>
    pub delete_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl CalculatedLifecycle {
    /// <p>A timestamp that specifies when to transition a recovery point to cold storage.</p>
    pub fn move_to_cold_storage_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.move_to_cold_storage_at.as_ref()
    }
    /// <p>A timestamp that specifies when to delete a recovery point.</p>
    pub fn delete_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.delete_at.as_ref()
    }
}
impl std::fmt::Debug for CalculatedLifecycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculatedLifecycle");
        formatter.field("move_to_cold_storage_at", &self.move_to_cold_storage_at);
        formatter.field("delete_at", &self.delete_at);
        formatter.finish()
    }
}
/// See [`CalculatedLifecycle`](crate::model::CalculatedLifecycle)
pub mod calculated_lifecycle {
    /// A builder for [`CalculatedLifecycle`](crate::model::CalculatedLifecycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) move_to_cold_storage_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) delete_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A timestamp that specifies when to transition a recovery point to cold storage.</p>
        pub fn move_to_cold_storage_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.move_to_cold_storage_at = Some(input);
            self
        }
        /// <p>A timestamp that specifies when to transition a recovery point to cold storage.</p>
        pub fn set_move_to_cold_storage_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.move_to_cold_storage_at = input;
            self
        }
        /// <p>A timestamp that specifies when to delete a recovery point.</p>
        pub fn delete_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.delete_at = Some(input);
            self
        }
        /// <p>A timestamp that specifies when to delete a recovery point.</p>
        pub fn set_delete_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.delete_at = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculatedLifecycle`](crate::model::CalculatedLifecycle)
        pub fn build(self) -> crate::model::CalculatedLifecycle {
            crate::model::CalculatedLifecycle {
                move_to_cold_storage_at: self.move_to_cold_storage_at,
                delete_at: self.delete_at,
            }
        }
    }
}
impl CalculatedLifecycle {
    /// Creates a new builder-style object to manufacture [`CalculatedLifecycle`](crate::model::CalculatedLifecycle)
    pub fn builder() -> crate::model::calculated_lifecycle::Builder {
        crate::model::calculated_lifecycle::Builder::default()
    }
}

/// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
/// a recovery point transitions to cold storage or is deleted.</p>
/// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
/// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
/// than the “transition to cold after days” setting. The “transition to cold after days”
/// setting cannot be changed after a backup has been transitioned to cold.</p>
/// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Lifecycle {
    /// <p>Specifies the number of days after creation that a recovery point is moved to cold
    /// storage.</p>
    pub move_to_cold_storage_after_days: std::option::Option<i64>,
    /// <p>Specifies the number of days after creation that a recovery point is deleted. Must be
    /// greater than 90 days plus <code>MoveToColdStorageAfterDays</code>.</p>
    pub delete_after_days: std::option::Option<i64>,
}
impl Lifecycle {
    /// <p>Specifies the number of days after creation that a recovery point is moved to cold
    /// storage.</p>
    pub fn move_to_cold_storage_after_days(&self) -> std::option::Option<i64> {
        self.move_to_cold_storage_after_days
    }
    /// <p>Specifies the number of days after creation that a recovery point is deleted. Must be
    /// greater than 90 days plus <code>MoveToColdStorageAfterDays</code>.</p>
    pub fn delete_after_days(&self) -> std::option::Option<i64> {
        self.delete_after_days
    }
}
impl std::fmt::Debug for Lifecycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Lifecycle");
        formatter.field(
            "move_to_cold_storage_after_days",
            &self.move_to_cold_storage_after_days,
        );
        formatter.field("delete_after_days", &self.delete_after_days);
        formatter.finish()
    }
}
/// See [`Lifecycle`](crate::model::Lifecycle)
pub mod lifecycle {
    /// A builder for [`Lifecycle`](crate::model::Lifecycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) move_to_cold_storage_after_days: std::option::Option<i64>,
        pub(crate) delete_after_days: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies the number of days after creation that a recovery point is moved to cold
        /// storage.</p>
        pub fn move_to_cold_storage_after_days(mut self, input: i64) -> Self {
            self.move_to_cold_storage_after_days = Some(input);
            self
        }
        /// <p>Specifies the number of days after creation that a recovery point is moved to cold
        /// storage.</p>
        pub fn set_move_to_cold_storage_after_days(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.move_to_cold_storage_after_days = input;
            self
        }
        /// <p>Specifies the number of days after creation that a recovery point is deleted. Must be
        /// greater than 90 days plus <code>MoveToColdStorageAfterDays</code>.</p>
        pub fn delete_after_days(mut self, input: i64) -> Self {
            self.delete_after_days = Some(input);
            self
        }
        /// <p>Specifies the number of days after creation that a recovery point is deleted. Must be
        /// greater than 90 days plus <code>MoveToColdStorageAfterDays</code>.</p>
        pub fn set_delete_after_days(mut self, input: std::option::Option<i64>) -> Self {
            self.delete_after_days = input;
            self
        }
        /// Consumes the builder and constructs a [`Lifecycle`](crate::model::Lifecycle)
        pub fn build(self) -> crate::model::Lifecycle {
            crate::model::Lifecycle {
                move_to_cold_storage_after_days: self.move_to_cold_storage_after_days,
                delete_after_days: self.delete_after_days,
            }
        }
    }
}
impl Lifecycle {
    /// Creates a new builder-style object to manufacture [`Lifecycle`](crate::model::Lifecycle)
    pub fn builder() -> crate::model::lifecycle::Builder {
        crate::model::lifecycle::Builder::default()
    }
}

/// <p>Contains detailed information about all of the controls of a framework. Each framework
/// must contain at least one control.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrameworkControl {
    /// <p>The name of a control. This name is between 1 and 256 characters.</p>
    pub control_name: std::option::Option<std::string::String>,
    /// <p>A list of <code>ParameterName</code> and <code>ParameterValue</code> pairs.</p>
    pub control_input_parameters:
        std::option::Option<std::vec::Vec<crate::model::ControlInputParameter>>,
    /// <p>The scope of a control. The control scope defines what the control will evaluate. Three
    /// examples of control scopes are: a specific backup plan, all backup plans with a specific
    /// tag, or all backup plans. For more information, see <code>ControlScope</code>.</p>
    pub control_scope: std::option::Option<crate::model::ControlScope>,
}
impl FrameworkControl {
    /// <p>The name of a control. This name is between 1 and 256 characters.</p>
    pub fn control_name(&self) -> std::option::Option<&str> {
        self.control_name.as_deref()
    }
    /// <p>A list of <code>ParameterName</code> and <code>ParameterValue</code> pairs.</p>
    pub fn control_input_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ControlInputParameter]> {
        self.control_input_parameters.as_deref()
    }
    /// <p>The scope of a control. The control scope defines what the control will evaluate. Three
    /// examples of control scopes are: a specific backup plan, all backup plans with a specific
    /// tag, or all backup plans. For more information, see <code>ControlScope</code>.</p>
    pub fn control_scope(&self) -> std::option::Option<&crate::model::ControlScope> {
        self.control_scope.as_ref()
    }
}
impl std::fmt::Debug for FrameworkControl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrameworkControl");
        formatter.field("control_name", &self.control_name);
        formatter.field("control_input_parameters", &self.control_input_parameters);
        formatter.field("control_scope", &self.control_scope);
        formatter.finish()
    }
}
/// See [`FrameworkControl`](crate::model::FrameworkControl)
pub mod framework_control {
    /// A builder for [`FrameworkControl`](crate::model::FrameworkControl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_name: std::option::Option<std::string::String>,
        pub(crate) control_input_parameters:
            std::option::Option<std::vec::Vec<crate::model::ControlInputParameter>>,
        pub(crate) control_scope: std::option::Option<crate::model::ControlScope>,
    }
    impl Builder {
        /// <p>The name of a control. This name is between 1 and 256 characters.</p>
        pub fn control_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_name = Some(input.into());
            self
        }
        /// <p>The name of a control. This name is between 1 and 256 characters.</p>
        pub fn set_control_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_name = input;
            self
        }
        /// Appends an item to `control_input_parameters`.
        ///
        /// To override the contents of this collection use [`set_control_input_parameters`](Self::set_control_input_parameters).
        ///
        /// <p>A list of <code>ParameterName</code> and <code>ParameterValue</code> pairs.</p>
        pub fn control_input_parameters(
            mut self,
            input: impl Into<crate::model::ControlInputParameter>,
        ) -> Self {
            let mut v = self.control_input_parameters.unwrap_or_default();
            v.push(input.into());
            self.control_input_parameters = Some(v);
            self
        }
        /// <p>A list of <code>ParameterName</code> and <code>ParameterValue</code> pairs.</p>
        pub fn set_control_input_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlInputParameter>>,
        ) -> Self {
            self.control_input_parameters = input;
            self
        }
        /// <p>The scope of a control. The control scope defines what the control will evaluate. Three
        /// examples of control scopes are: a specific backup plan, all backup plans with a specific
        /// tag, or all backup plans. For more information, see <code>ControlScope</code>.</p>
        pub fn control_scope(mut self, input: crate::model::ControlScope) -> Self {
            self.control_scope = Some(input);
            self
        }
        /// <p>The scope of a control. The control scope defines what the control will evaluate. Three
        /// examples of control scopes are: a specific backup plan, all backup plans with a specific
        /// tag, or all backup plans. For more information, see <code>ControlScope</code>.</p>
        pub fn set_control_scope(
            mut self,
            input: std::option::Option<crate::model::ControlScope>,
        ) -> Self {
            self.control_scope = input;
            self
        }
        /// Consumes the builder and constructs a [`FrameworkControl`](crate::model::FrameworkControl)
        pub fn build(self) -> crate::model::FrameworkControl {
            crate::model::FrameworkControl {
                control_name: self.control_name,
                control_input_parameters: self.control_input_parameters,
                control_scope: self.control_scope,
            }
        }
    }
}
impl FrameworkControl {
    /// Creates a new builder-style object to manufacture [`FrameworkControl`](crate::model::FrameworkControl)
    pub fn builder() -> crate::model::framework_control::Builder {
        crate::model::framework_control::Builder::default()
    }
}

/// <p>A framework consists of one or more controls. Each control has its own control scope.
/// The control scope defines what the control will evaluate. Three examples of control scopes
/// are: a specific backup plan, all backup plans with a specific tag, or all backup
/// plans.</p>
/// <note>
/// <p>To set a control scope that includes all of a particular resource, leave the
/// <code>ControlScope</code> empty or do not pass it when calling
/// <code>CreateFramework</code>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ControlScope {
    /// <p>The ID of the only Amazon Web Services resource that you want your control scope to
    /// contain.</p>
    pub compliance_resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes whether the control scope includes one or more types of resources, such as
    /// <code>EFS</code> or <code>RDS</code>.</p>
    pub compliance_resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes whether the control scope includes resources with one or more tags. Each tag
    /// is a key-value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ControlScope {
    /// <p>The ID of the only Amazon Web Services resource that you want your control scope to
    /// contain.</p>
    pub fn compliance_resource_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.compliance_resource_ids.as_deref()
    }
    /// <p>Describes whether the control scope includes one or more types of resources, such as
    /// <code>EFS</code> or <code>RDS</code>.</p>
    pub fn compliance_resource_types(&self) -> std::option::Option<&[std::string::String]> {
        self.compliance_resource_types.as_deref()
    }
    /// <p>Describes whether the control scope includes resources with one or more tags. Each tag
    /// is a key-value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ControlScope {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ControlScope");
        formatter.field("compliance_resource_ids", &self.compliance_resource_ids);
        formatter.field("compliance_resource_types", &self.compliance_resource_types);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ControlScope`](crate::model::ControlScope)
pub mod control_scope {
    /// A builder for [`ControlScope`](crate::model::ControlScope)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) compliance_resource_types:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `compliance_resource_ids`.
        ///
        /// To override the contents of this collection use [`set_compliance_resource_ids`](Self::set_compliance_resource_ids).
        ///
        /// <p>The ID of the only Amazon Web Services resource that you want your control scope to
        /// contain.</p>
        pub fn compliance_resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.compliance_resource_ids.unwrap_or_default();
            v.push(input.into());
            self.compliance_resource_ids = Some(v);
            self
        }
        /// <p>The ID of the only Amazon Web Services resource that you want your control scope to
        /// contain.</p>
        pub fn set_compliance_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.compliance_resource_ids = input;
            self
        }
        /// Appends an item to `compliance_resource_types`.
        ///
        /// To override the contents of this collection use [`set_compliance_resource_types`](Self::set_compliance_resource_types).
        ///
        /// <p>Describes whether the control scope includes one or more types of resources, such as
        /// <code>EFS</code> or <code>RDS</code>.</p>
        pub fn compliance_resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.compliance_resource_types.unwrap_or_default();
            v.push(input.into());
            self.compliance_resource_types = Some(v);
            self
        }
        /// <p>Describes whether the control scope includes one or more types of resources, such as
        /// <code>EFS</code> or <code>RDS</code>.</p>
        pub fn set_compliance_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.compliance_resource_types = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Describes whether the control scope includes resources with one or more tags. Each tag
        /// is a key-value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Describes whether the control scope includes resources with one or more tags. Each tag
        /// is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ControlScope`](crate::model::ControlScope)
        pub fn build(self) -> crate::model::ControlScope {
            crate::model::ControlScope {
                compliance_resource_ids: self.compliance_resource_ids,
                compliance_resource_types: self.compliance_resource_types,
                tags: self.tags,
            }
        }
    }
}
impl ControlScope {
    /// Creates a new builder-style object to manufacture [`ControlScope`](crate::model::ControlScope)
    pub fn builder() -> crate::model::control_scope::Builder {
        crate::model::control_scope::Builder::default()
    }
}

/// <p>A list of parameters for a control. A control can have zero, one, or more than one
/// parameter. An example of a control with two parameters is: "backup plan frequency is at
/// least <code>daily</code> and the retention period is at least <code>1 year</code>". The
/// first parameter is <code>daily</code>. The second parameter is <code>1 year</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ControlInputParameter {
    /// <p>The name of a parameter, for example, <code>BackupPlanFrequency</code>.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>The value of parameter, for example, <code>hourly</code>.</p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl ControlInputParameter {
    /// <p>The name of a parameter, for example, <code>BackupPlanFrequency</code>.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>The value of parameter, for example, <code>hourly</code>.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
}
impl std::fmt::Debug for ControlInputParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ControlInputParameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`ControlInputParameter`](crate::model::ControlInputParameter)
pub mod control_input_parameter {
    /// A builder for [`ControlInputParameter`](crate::model::ControlInputParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a parameter, for example, <code>BackupPlanFrequency</code>.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of a parameter, for example, <code>BackupPlanFrequency</code>.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The value of parameter, for example, <code>hourly</code>.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The value of parameter, for example, <code>hourly</code>.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ControlInputParameter`](crate::model::ControlInputParameter)
        pub fn build(self) -> crate::model::ControlInputParameter {
            crate::model::ControlInputParameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl ControlInputParameter {
    /// Creates a new builder-style object to manufacture [`ControlInputParameter`](crate::model::ControlInputParameter)
    pub fn builder() -> crate::model::control_input_parameter::Builder {
        crate::model::control_input_parameter::Builder::default()
    }
}

/// <p>A list of backup options for each resource type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvancedBackupSetting {
    /// <p>Specifies an object containing resource type and backup options. The only supported
    /// resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service
    /// (VSS). For a CloudFormation example, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html">sample
    /// CloudFormation template to enable Windows VSS</a> in the <i>Backup User Guide</i>.</p>
    /// <p>Valid values: <code>EC2</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Specifies the backup option for a selected resource. This option is only available for
    /// Windows VSS backup jobs.</p>
    /// <p>Valid values: </p>
    /// <p>Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup
    /// option and create a Windows VSS backup. </p>
    /// <p>Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. The
    /// <code>WindowsVSS</code> option is not enabled by default.</p>
    /// <p>If you specify an invalid option, you get an <code>InvalidParameterValueException</code>
    /// exception.</p>
    /// <p>For more information about Windows VSS backups, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">Creating a VSS-Enabled Windows
    /// Backup</a>.</p>
    pub backup_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AdvancedBackupSetting {
    /// <p>Specifies an object containing resource type and backup options. The only supported
    /// resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service
    /// (VSS). For a CloudFormation example, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html">sample
    /// CloudFormation template to enable Windows VSS</a> in the <i>Backup User Guide</i>.</p>
    /// <p>Valid values: <code>EC2</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Specifies the backup option for a selected resource. This option is only available for
    /// Windows VSS backup jobs.</p>
    /// <p>Valid values: </p>
    /// <p>Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup
    /// option and create a Windows VSS backup. </p>
    /// <p>Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. The
    /// <code>WindowsVSS</code> option is not enabled by default.</p>
    /// <p>If you specify an invalid option, you get an <code>InvalidParameterValueException</code>
    /// exception.</p>
    /// <p>For more information about Windows VSS backups, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">Creating a VSS-Enabled Windows
    /// Backup</a>.</p>
    pub fn backup_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.backup_options.as_ref()
    }
}
impl std::fmt::Debug for AdvancedBackupSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvancedBackupSetting");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("backup_options", &self.backup_options);
        formatter.finish()
    }
}
/// See [`AdvancedBackupSetting`](crate::model::AdvancedBackupSetting)
pub mod advanced_backup_setting {
    /// A builder for [`AdvancedBackupSetting`](crate::model::AdvancedBackupSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) backup_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Specifies an object containing resource type and backup options. The only supported
        /// resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service
        /// (VSS). For a CloudFormation example, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html">sample
        /// CloudFormation template to enable Windows VSS</a> in the <i>Backup User Guide</i>.</p>
        /// <p>Valid values: <code>EC2</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Specifies an object containing resource type and backup options. The only supported
        /// resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service
        /// (VSS). For a CloudFormation example, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html">sample
        /// CloudFormation template to enable Windows VSS</a> in the <i>Backup User Guide</i>.</p>
        /// <p>Valid values: <code>EC2</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Adds a key-value pair to `backup_options`.
        ///
        /// To override the contents of this collection use [`set_backup_options`](Self::set_backup_options).
        ///
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows VSS backup jobs.</p>
        /// <p>Valid values: </p>
        /// <p>Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup
        /// option and create a Windows VSS backup. </p>
        /// <p>Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. The
        /// <code>WindowsVSS</code> option is not enabled by default.</p>
        /// <p>If you specify an invalid option, you get an <code>InvalidParameterValueException</code>
        /// exception.</p>
        /// <p>For more information about Windows VSS backups, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">Creating a VSS-Enabled Windows
        /// Backup</a>.</p>
        pub fn backup_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.backup_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.backup_options = Some(hash_map);
            self
        }
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows VSS backup jobs.</p>
        /// <p>Valid values: </p>
        /// <p>Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup
        /// option and create a Windows VSS backup. </p>
        /// <p>Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. The
        /// <code>WindowsVSS</code> option is not enabled by default.</p>
        /// <p>If you specify an invalid option, you get an <code>InvalidParameterValueException</code>
        /// exception.</p>
        /// <p>For more information about Windows VSS backups, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">Creating a VSS-Enabled Windows
        /// Backup</a>.</p>
        pub fn set_backup_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.backup_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvancedBackupSetting`](crate::model::AdvancedBackupSetting)
        pub fn build(self) -> crate::model::AdvancedBackupSetting {
            crate::model::AdvancedBackupSetting {
                resource_type: self.resource_type,
                backup_options: self.backup_options,
            }
        }
    }
}
impl AdvancedBackupSetting {
    /// Creates a new builder-style object to manufacture [`AdvancedBackupSetting`](crate::model::AdvancedBackupSetting)
    pub fn builder() -> crate::model::advanced_backup_setting::Builder {
        crate::model::advanced_backup_setting::Builder::default()
    }
}

/// <p>Contains an optional backup plan display name and an array of <code>BackupRule</code>
/// objects, each of which specifies a backup rule. Each rule in a backup plan is a separate
/// scheduled task. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupPlanInput {
    /// <p>The optional display name of a backup plan.</p>
    pub backup_plan_name: std::option::Option<std::string::String>,
    /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
    /// that is used to back up a selection of resources.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::BackupRuleInput>>,
    /// <p>Specifies a list of <code>BackupOptions</code> for each resource type. These settings
    /// are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    pub advanced_backup_settings:
        std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
}
impl BackupPlanInput {
    /// <p>The optional display name of a backup plan.</p>
    pub fn backup_plan_name(&self) -> std::option::Option<&str> {
        self.backup_plan_name.as_deref()
    }
    /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
    /// that is used to back up a selection of resources.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::BackupRuleInput]> {
        self.rules.as_deref()
    }
    /// <p>Specifies a list of <code>BackupOptions</code> for each resource type. These settings
    /// are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    pub fn advanced_backup_settings(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedBackupSetting]> {
        self.advanced_backup_settings.as_deref()
    }
}
impl std::fmt::Debug for BackupPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupPlanInput");
        formatter.field("backup_plan_name", &self.backup_plan_name);
        formatter.field("rules", &self.rules);
        formatter.field("advanced_backup_settings", &self.advanced_backup_settings);
        formatter.finish()
    }
}
/// See [`BackupPlanInput`](crate::model::BackupPlanInput)
pub mod backup_plan_input {
    /// A builder for [`BackupPlanInput`](crate::model::BackupPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_name: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::BackupRuleInput>>,
        pub(crate) advanced_backup_settings:
            std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
    }
    impl Builder {
        /// <p>The optional display name of a backup plan.</p>
        pub fn backup_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_name = Some(input.into());
            self
        }
        /// <p>The optional display name of a backup plan.</p>
        pub fn set_backup_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_name = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
        /// that is used to back up a selection of resources.</p>
        pub fn rules(mut self, input: impl Into<crate::model::BackupRuleInput>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
        /// that is used to back up a selection of resources.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupRuleInput>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Appends an item to `advanced_backup_settings`.
        ///
        /// To override the contents of this collection use [`set_advanced_backup_settings`](Self::set_advanced_backup_settings).
        ///
        /// <p>Specifies a list of <code>BackupOptions</code> for each resource type. These settings
        /// are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        pub fn advanced_backup_settings(
            mut self,
            input: impl Into<crate::model::AdvancedBackupSetting>,
        ) -> Self {
            let mut v = self.advanced_backup_settings.unwrap_or_default();
            v.push(input.into());
            self.advanced_backup_settings = Some(v);
            self
        }
        /// <p>Specifies a list of <code>BackupOptions</code> for each resource type. These settings
        /// are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        pub fn set_advanced_backup_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
        ) -> Self {
            self.advanced_backup_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupPlanInput`](crate::model::BackupPlanInput)
        pub fn build(self) -> crate::model::BackupPlanInput {
            crate::model::BackupPlanInput {
                backup_plan_name: self.backup_plan_name,
                rules: self.rules,
                advanced_backup_settings: self.advanced_backup_settings,
            }
        }
    }
}
impl BackupPlanInput {
    /// Creates a new builder-style object to manufacture [`BackupPlanInput`](crate::model::BackupPlanInput)
    pub fn builder() -> crate::model::backup_plan_input::Builder {
        crate::model::backup_plan_input::Builder::default()
    }
}

/// <p>Specifies a scheduled task used to back up a selection of resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupRuleInput {
    /// <p>An optional display name for a backup rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub target_backup_vault_name: std::option::Option<std::string::String>,
    /// <p>A CRON expression in UTC specifying when Backup initiates a backup
    /// job.</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
    /// doesn't start successfully. This value is optional.</p>
    pub start_window_minutes: std::option::Option<i64>,
    /// <p>A value in minutes after a backup job is successfully started before it must be
    /// completed or it will be canceled by Backup. This value is optional.</p>
    pub completion_window_minutes: std::option::Option<i64>,
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup will transition and expire backups automatically according
    /// to the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
    /// <p>To help organize your resources, you can assign your own metadata to the resources that
    /// you create. Each tag is a key-value pair.</p>
    pub recovery_point_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
    /// operation.</p>
    pub copy_actions: std::option::Option<std::vec::Vec<crate::model::CopyAction>>,
    /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
    /// (or not specified) causes Backup to create snapshot backups.</p>
    pub enable_continuous_backup: std::option::Option<bool>,
}
impl BackupRuleInput {
    /// <p>An optional display name for a backup rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn target_backup_vault_name(&self) -> std::option::Option<&str> {
        self.target_backup_vault_name.as_deref()
    }
    /// <p>A CRON expression in UTC specifying when Backup initiates a backup
    /// job.</p>
    pub fn schedule_expression(&self) -> std::option::Option<&str> {
        self.schedule_expression.as_deref()
    }
    /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
    /// doesn't start successfully. This value is optional.</p>
    pub fn start_window_minutes(&self) -> std::option::Option<i64> {
        self.start_window_minutes
    }
    /// <p>A value in minutes after a backup job is successfully started before it must be
    /// completed or it will be canceled by Backup. This value is optional.</p>
    pub fn completion_window_minutes(&self) -> std::option::Option<i64> {
        self.completion_window_minutes
    }
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup will transition and expire backups automatically according
    /// to the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>To help organize your resources, you can assign your own metadata to the resources that
    /// you create. Each tag is a key-value pair.</p>
    pub fn recovery_point_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.recovery_point_tags.as_ref()
    }
    /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
    /// operation.</p>
    pub fn copy_actions(&self) -> std::option::Option<&[crate::model::CopyAction]> {
        self.copy_actions.as_deref()
    }
    /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
    /// (or not specified) causes Backup to create snapshot backups.</p>
    pub fn enable_continuous_backup(&self) -> std::option::Option<bool> {
        self.enable_continuous_backup
    }
}
impl std::fmt::Debug for BackupRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupRuleInput");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("target_backup_vault_name", &self.target_backup_vault_name);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("start_window_minutes", &self.start_window_minutes);
        formatter.field("completion_window_minutes", &self.completion_window_minutes);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("recovery_point_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("copy_actions", &self.copy_actions);
        formatter.field("enable_continuous_backup", &self.enable_continuous_backup);
        formatter.finish()
    }
}
/// See [`BackupRuleInput`](crate::model::BackupRuleInput)
pub mod backup_rule_input {
    /// A builder for [`BackupRuleInput`](crate::model::BackupRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) target_backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) start_window_minutes: std::option::Option<i64>,
        pub(crate) completion_window_minutes: std::option::Option<i64>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
        pub(crate) recovery_point_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) copy_actions: std::option::Option<std::vec::Vec<crate::model::CopyAction>>,
        pub(crate) enable_continuous_backup: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An optional display name for a backup rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>An optional display name for a backup rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn target_backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_target_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_backup_vault_name = input;
            self
        }
        /// <p>A CRON expression in UTC specifying when Backup initiates a backup
        /// job.</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A CRON expression in UTC specifying when Backup initiates a backup
        /// job.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional.</p>
        pub fn start_window_minutes(mut self, input: i64) -> Self {
            self.start_window_minutes = Some(input);
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional.</p>
        pub fn set_start_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.start_window_minutes = input;
            self
        }
        /// <p>A value in minutes after a backup job is successfully started before it must be
        /// completed or it will be canceled by Backup. This value is optional.</p>
        pub fn completion_window_minutes(mut self, input: i64) -> Self {
            self.completion_window_minutes = Some(input);
            self
        }
        /// <p>A value in minutes after a backup job is successfully started before it must be
        /// completed or it will be canceled by Backup. This value is optional.</p>
        pub fn set_completion_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.completion_window_minutes = input;
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup will transition and expire backups automatically according
        /// to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup will transition and expire backups automatically according
        /// to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Adds a key-value pair to `recovery_point_tags`.
        ///
        /// To override the contents of this collection use [`set_recovery_point_tags`](Self::set_recovery_point_tags).
        ///
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair.</p>
        pub fn recovery_point_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.recovery_point_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.recovery_point_tags = Some(hash_map);
            self
        }
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair.</p>
        pub fn set_recovery_point_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.recovery_point_tags = input;
            self
        }
        /// Appends an item to `copy_actions`.
        ///
        /// To override the contents of this collection use [`set_copy_actions`](Self::set_copy_actions).
        ///
        /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
        /// operation.</p>
        pub fn copy_actions(mut self, input: impl Into<crate::model::CopyAction>) -> Self {
            let mut v = self.copy_actions.unwrap_or_default();
            v.push(input.into());
            self.copy_actions = Some(v);
            self
        }
        /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
        /// operation.</p>
        pub fn set_copy_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CopyAction>>,
        ) -> Self {
            self.copy_actions = input;
            self
        }
        /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
        /// (or not specified) causes Backup to create snapshot backups.</p>
        pub fn enable_continuous_backup(mut self, input: bool) -> Self {
            self.enable_continuous_backup = Some(input);
            self
        }
        /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
        /// (or not specified) causes Backup to create snapshot backups.</p>
        pub fn set_enable_continuous_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_continuous_backup = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupRuleInput`](crate::model::BackupRuleInput)
        pub fn build(self) -> crate::model::BackupRuleInput {
            crate::model::BackupRuleInput {
                rule_name: self.rule_name,
                target_backup_vault_name: self.target_backup_vault_name,
                schedule_expression: self.schedule_expression,
                start_window_minutes: self.start_window_minutes,
                completion_window_minutes: self.completion_window_minutes,
                lifecycle: self.lifecycle,
                recovery_point_tags: self.recovery_point_tags,
                copy_actions: self.copy_actions,
                enable_continuous_backup: self.enable_continuous_backup,
            }
        }
    }
}
impl BackupRuleInput {
    /// Creates a new builder-style object to manufacture [`BackupRuleInput`](crate::model::BackupRuleInput)
    pub fn builder() -> crate::model::backup_rule_input::Builder {
        crate::model::backup_rule_input::Builder::default()
    }
}

/// <p>The details of the copy operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyAction {
    /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
    /// a recovery point transitions to cold storage or is deleted.</p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
    /// than the “transition to cold after days” setting. The “transition to cold after days”
    /// setting cannot be changed after a backup has been transitioned to cold.</p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for
    /// the copied backup. For example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub destination_backup_vault_arn: std::option::Option<std::string::String>,
}
impl CopyAction {
    /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
    /// a recovery point transitions to cold storage or is deleted.</p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
    /// than the “transition to cold after days” setting. The “transition to cold after days”
    /// setting cannot be changed after a backup has been transitioned to cold.</p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for
    /// the copied backup. For example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn destination_backup_vault_arn(&self) -> std::option::Option<&str> {
        self.destination_backup_vault_arn.as_deref()
    }
}
impl std::fmt::Debug for CopyAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyAction");
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field(
            "destination_backup_vault_arn",
            &self.destination_backup_vault_arn,
        );
        formatter.finish()
    }
}
/// See [`CopyAction`](crate::model::CopyAction)
pub mod copy_action {
    /// A builder for [`CopyAction`](crate::model::CopyAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
        pub(crate) destination_backup_vault_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
        /// a recovery point transitions to cold storage or is deleted.</p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
        /// than the “transition to cold after days” setting. The “transition to cold after days”
        /// setting cannot be changed after a backup has been transitioned to cold.</p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
        /// a recovery point transitions to cold storage or is deleted.</p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
        /// than the “transition to cold after days” setting. The “transition to cold after days”
        /// setting cannot be changed after a backup has been transitioned to cold.</p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for
        /// the copied backup. For example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn destination_backup_vault_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for
        /// the copied backup. For example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_destination_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_backup_vault_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyAction`](crate::model::CopyAction)
        pub fn build(self) -> crate::model::CopyAction {
            crate::model::CopyAction {
                lifecycle: self.lifecycle,
                destination_backup_vault_arn: self.destination_backup_vault_arn,
            }
        }
    }
}
impl CopyAction {
    /// Creates a new builder-style object to manufacture [`CopyAction`](crate::model::CopyAction)
    pub fn builder() -> crate::model::copy_action::Builder {
        crate::model::copy_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupVaultEvent {
    #[allow(missing_docs)] // documentation missing in model
    BackupJobCompleted,
    #[allow(missing_docs)] // documentation missing in model
    BackupJobExpired,
    #[allow(missing_docs)] // documentation missing in model
    BackupJobFailed,
    #[allow(missing_docs)] // documentation missing in model
    BackupJobStarted,
    #[allow(missing_docs)] // documentation missing in model
    BackupJobSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    BackupPlanCreated,
    #[allow(missing_docs)] // documentation missing in model
    BackupPlanModified,
    #[allow(missing_docs)] // documentation missing in model
    CopyJobFailed,
    #[allow(missing_docs)] // documentation missing in model
    CopyJobStarted,
    #[allow(missing_docs)] // documentation missing in model
    CopyJobSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    RecoveryPointModified,
    #[allow(missing_docs)] // documentation missing in model
    RestoreJobCompleted,
    #[allow(missing_docs)] // documentation missing in model
    RestoreJobFailed,
    #[allow(missing_docs)] // documentation missing in model
    RestoreJobStarted,
    #[allow(missing_docs)] // documentation missing in model
    RestoreJobSuccessful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupVaultEvent {
    fn from(s: &str) -> Self {
        match s {
            "BACKUP_JOB_COMPLETED" => BackupVaultEvent::BackupJobCompleted,
            "BACKUP_JOB_EXPIRED" => BackupVaultEvent::BackupJobExpired,
            "BACKUP_JOB_FAILED" => BackupVaultEvent::BackupJobFailed,
            "BACKUP_JOB_STARTED" => BackupVaultEvent::BackupJobStarted,
            "BACKUP_JOB_SUCCESSFUL" => BackupVaultEvent::BackupJobSuccessful,
            "BACKUP_PLAN_CREATED" => BackupVaultEvent::BackupPlanCreated,
            "BACKUP_PLAN_MODIFIED" => BackupVaultEvent::BackupPlanModified,
            "COPY_JOB_FAILED" => BackupVaultEvent::CopyJobFailed,
            "COPY_JOB_STARTED" => BackupVaultEvent::CopyJobStarted,
            "COPY_JOB_SUCCESSFUL" => BackupVaultEvent::CopyJobSuccessful,
            "RECOVERY_POINT_MODIFIED" => BackupVaultEvent::RecoveryPointModified,
            "RESTORE_JOB_COMPLETED" => BackupVaultEvent::RestoreJobCompleted,
            "RESTORE_JOB_FAILED" => BackupVaultEvent::RestoreJobFailed,
            "RESTORE_JOB_STARTED" => BackupVaultEvent::RestoreJobStarted,
            "RESTORE_JOB_SUCCESSFUL" => BackupVaultEvent::RestoreJobSuccessful,
            other => BackupVaultEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupVaultEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupVaultEvent::from(s))
    }
}
impl BackupVaultEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupVaultEvent::BackupJobCompleted => "BACKUP_JOB_COMPLETED",
            BackupVaultEvent::BackupJobExpired => "BACKUP_JOB_EXPIRED",
            BackupVaultEvent::BackupJobFailed => "BACKUP_JOB_FAILED",
            BackupVaultEvent::BackupJobStarted => "BACKUP_JOB_STARTED",
            BackupVaultEvent::BackupJobSuccessful => "BACKUP_JOB_SUCCESSFUL",
            BackupVaultEvent::BackupPlanCreated => "BACKUP_PLAN_CREATED",
            BackupVaultEvent::BackupPlanModified => "BACKUP_PLAN_MODIFIED",
            BackupVaultEvent::CopyJobFailed => "COPY_JOB_FAILED",
            BackupVaultEvent::CopyJobStarted => "COPY_JOB_STARTED",
            BackupVaultEvent::CopyJobSuccessful => "COPY_JOB_SUCCESSFUL",
            BackupVaultEvent::RecoveryPointModified => "RECOVERY_POINT_MODIFIED",
            BackupVaultEvent::RestoreJobCompleted => "RESTORE_JOB_COMPLETED",
            BackupVaultEvent::RestoreJobFailed => "RESTORE_JOB_FAILED",
            BackupVaultEvent::RestoreJobStarted => "RESTORE_JOB_STARTED",
            BackupVaultEvent::RestoreJobSuccessful => "RESTORE_JOB_SUCCESSFUL",
            BackupVaultEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BACKUP_JOB_COMPLETED",
            "BACKUP_JOB_EXPIRED",
            "BACKUP_JOB_FAILED",
            "BACKUP_JOB_STARTED",
            "BACKUP_JOB_SUCCESSFUL",
            "BACKUP_PLAN_CREATED",
            "BACKUP_PLAN_MODIFIED",
            "COPY_JOB_FAILED",
            "COPY_JOB_STARTED",
            "COPY_JOB_SUCCESSFUL",
            "RECOVERY_POINT_MODIFIED",
            "RESTORE_JOB_COMPLETED",
            "RESTORE_JOB_FAILED",
            "RESTORE_JOB_STARTED",
            "RESTORE_JOB_SUCCESSFUL",
        ]
    }
}
impl AsRef<str> for BackupVaultEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains metadata about a restore job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreJobsListMember {
    /// <p>The account ID that owns the restore job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub restore_job_id: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a restore job is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
    /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A status code specifying the state of the job initiated by Backup to restore
    /// a recovery point.</p>
    pub status: std::option::Option<crate::model::RestoreJobStatus>,
    /// <p>A detailed message explaining the status of the job to restore a recovery point.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Contains an estimated percentage complete of a job at the time the job status was
    /// queried.</p>
    pub percent_done: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the restored resource.</p>
    pub backup_size_in_bytes: std::option::Option<i64>,
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The amount of time in minutes that a job restoring a recovery point is expected to
    /// take.</p>
    pub expected_completion_time_minutes: std::option::Option<i64>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub created_resource_arn: std::option::Option<std::string::String>,
    /// <p>The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store
    /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
    /// For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
    /// Amazon EC2.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl RestoreJobsListMember {
    /// <p>The account ID that owns the restore job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Uniquely identifies the job that restores a recovery point.</p>
    pub fn restore_job_id(&self) -> std::option::Option<&str> {
        self.restore_job_id.as_deref()
    }
    /// <p>An ARN that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The date and time a restore job is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
    /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>A status code specifying the state of the job initiated by Backup to restore
    /// a recovery point.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RestoreJobStatus> {
        self.status.as_ref()
    }
    /// <p>A detailed message explaining the status of the job to restore a recovery point.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Contains an estimated percentage complete of a job at the time the job status was
    /// queried.</p>
    pub fn percent_done(&self) -> std::option::Option<&str> {
        self.percent_done.as_deref()
    }
    /// <p>The size, in bytes, of the restored resource.</p>
    pub fn backup_size_in_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_in_bytes
    }
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The amount of time in minutes that a job restoring a recovery point is expected to
    /// take.</p>
    pub fn expected_completion_time_minutes(&self) -> std::option::Option<i64> {
        self.expected_completion_time_minutes
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub fn created_resource_arn(&self) -> std::option::Option<&str> {
        self.created_resource_arn.as_deref()
    }
    /// <p>The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store
    /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
    /// For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
    /// Amazon EC2.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for RestoreJobsListMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreJobsListMember");
        formatter.field("account_id", &self.account_id);
        formatter.field("restore_job_id", &self.restore_job_id);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("percent_done", &self.percent_done);
        formatter.field("backup_size_in_bytes", &self.backup_size_in_bytes);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field(
            "expected_completion_time_minutes",
            &self.expected_completion_time_minutes,
        );
        formatter.field("created_resource_arn", &self.created_resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`RestoreJobsListMember`](crate::model::RestoreJobsListMember)
pub mod restore_jobs_list_member {
    /// A builder for [`RestoreJobsListMember`](crate::model::RestoreJobsListMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) restore_job_id: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::RestoreJobStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) percent_done: std::option::Option<std::string::String>,
        pub(crate) backup_size_in_bytes: std::option::Option<i64>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) expected_completion_time_minutes: std::option::Option<i64>,
        pub(crate) created_resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID that owns the restore job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID that owns the restore job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn restore_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn set_restore_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.restore_job_id = input;
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The date and time a restore job is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a restore job is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
        /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
        /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>A status code specifying the state of the job initiated by Backup to restore
        /// a recovery point.</p>
        pub fn status(mut self, input: crate::model::RestoreJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A status code specifying the state of the job initiated by Backup to restore
        /// a recovery point.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RestoreJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed message explaining the status of the job to restore a recovery point.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A detailed message explaining the status of the job to restore a recovery point.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Contains an estimated percentage complete of a job at the time the job status was
        /// queried.</p>
        pub fn percent_done(mut self, input: impl Into<std::string::String>) -> Self {
            self.percent_done = Some(input.into());
            self
        }
        /// <p>Contains an estimated percentage complete of a job at the time the job status was
        /// queried.</p>
        pub fn set_percent_done(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.percent_done = input;
            self
        }
        /// <p>The size, in bytes, of the restored resource.</p>
        pub fn backup_size_in_bytes(mut self, input: i64) -> Self {
            self.backup_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the restored resource.</p>
        pub fn set_backup_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_in_bytes = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The amount of time in minutes that a job restoring a recovery point is expected to
        /// take.</p>
        pub fn expected_completion_time_minutes(mut self, input: i64) -> Self {
            self.expected_completion_time_minutes = Some(input);
            self
        }
        /// <p>The amount of time in minutes that a job restoring a recovery point is expected to
        /// take.</p>
        pub fn set_expected_completion_time_minutes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.expected_completion_time_minutes = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn created_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_created_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_resource_arn = input;
            self
        }
        /// <p>The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store
        /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
        /// For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
        /// Amazon EC2.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store
        /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
        /// For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
        /// Amazon EC2.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreJobsListMember`](crate::model::RestoreJobsListMember)
        pub fn build(self) -> crate::model::RestoreJobsListMember {
            crate::model::RestoreJobsListMember {
                account_id: self.account_id,
                restore_job_id: self.restore_job_id,
                recovery_point_arn: self.recovery_point_arn,
                creation_date: self.creation_date,
                completion_date: self.completion_date,
                status: self.status,
                status_message: self.status_message,
                percent_done: self.percent_done,
                backup_size_in_bytes: self.backup_size_in_bytes,
                iam_role_arn: self.iam_role_arn,
                expected_completion_time_minutes: self.expected_completion_time_minutes,
                created_resource_arn: self.created_resource_arn,
                resource_type: self.resource_type,
            }
        }
    }
}
impl RestoreJobsListMember {
    /// Creates a new builder-style object to manufacture [`RestoreJobsListMember`](crate::model::RestoreJobsListMember)
    pub fn builder() -> crate::model::restore_jobs_list_member::Builder {
        crate::model::restore_jobs_list_member::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RestoreJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RestoreJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => RestoreJobStatus::Aborted,
            "COMPLETED" => RestoreJobStatus::Completed,
            "FAILED" => RestoreJobStatus::Failed,
            "PENDING" => RestoreJobStatus::Pending,
            "RUNNING" => RestoreJobStatus::Running,
            other => RestoreJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RestoreJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RestoreJobStatus::from(s))
    }
}
impl RestoreJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RestoreJobStatus::Aborted => "ABORTED",
            RestoreJobStatus::Completed => "COMPLETED",
            RestoreJobStatus::Failed => "FAILED",
            RestoreJobStatus::Pending => "PENDING",
            RestoreJobStatus::Running => "RUNNING",
            RestoreJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABORTED", "COMPLETED", "FAILED", "PENDING", "RUNNING"]
    }
}
impl AsRef<str> for RestoreJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains detailed information about a report plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportPlan {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub report_plan_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the report plan. This name is between 1 and 256 characters starting
    /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
    /// (_).</p>
    pub report_plan_name: std::option::Option<std::string::String>,
    /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
    pub report_plan_description: std::option::Option<std::string::String>,
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
    /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
    /// coverage by Amazon Web Services Regions and frameworks.</p>
    pub report_setting: std::option::Option<crate::model::ReportSetting>,
    /// <p>Contains information about where and how to deliver your reports, specifically your
    /// Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
    pub report_delivery_channel: std::option::Option<crate::model::ReportDeliveryChannel>,
    /// <p>The deployment status of a report plan. The statuses are:</p>
    /// <p>
    /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS |
    /// COMPLETED</code>
    /// </p>
    pub deployment_status: std::option::Option<std::string::String>,
    /// <p>The date and time that a report plan is created, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that a report job associated with this report plan last attempted to
    /// run, in Unix format and Coordinated Universal Time (UTC). The value of
    /// <code>LastAttemptedExecutionTime</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub last_attempted_execution_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that a report job associated with this report plan last successfully
    /// ran, in Unix format and Coordinated Universal Time (UTC). The value of
    /// <code>LastSuccessfulExecutionTime</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub last_successful_execution_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ReportPlan {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub fn report_plan_arn(&self) -> std::option::Option<&str> {
        self.report_plan_arn.as_deref()
    }
    /// <p>The unique name of the report plan. This name is between 1 and 256 characters starting
    /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
    /// (_).</p>
    pub fn report_plan_name(&self) -> std::option::Option<&str> {
        self.report_plan_name.as_deref()
    }
    /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
    pub fn report_plan_description(&self) -> std::option::Option<&str> {
        self.report_plan_description.as_deref()
    }
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are:</p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
    /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
    /// coverage by Amazon Web Services Regions and frameworks.</p>
    pub fn report_setting(&self) -> std::option::Option<&crate::model::ReportSetting> {
        self.report_setting.as_ref()
    }
    /// <p>Contains information about where and how to deliver your reports, specifically your
    /// Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
    pub fn report_delivery_channel(
        &self,
    ) -> std::option::Option<&crate::model::ReportDeliveryChannel> {
        self.report_delivery_channel.as_ref()
    }
    /// <p>The deployment status of a report plan. The statuses are:</p>
    /// <p>
    /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS |
    /// COMPLETED</code>
    /// </p>
    pub fn deployment_status(&self) -> std::option::Option<&str> {
        self.deployment_status.as_deref()
    }
    /// <p>The date and time that a report plan is created, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time that a report job associated with this report plan last attempted to
    /// run, in Unix format and Coordinated Universal Time (UTC). The value of
    /// <code>LastAttemptedExecutionTime</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn last_attempted_execution_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_attempted_execution_time.as_ref()
    }
    /// <p>The date and time that a report job associated with this report plan last successfully
    /// ran, in Unix format and Coordinated Universal Time (UTC). The value of
    /// <code>LastSuccessfulExecutionTime</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn last_successful_execution_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_successful_execution_time.as_ref()
    }
}
impl std::fmt::Debug for ReportPlan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportPlan");
        formatter.field("report_plan_arn", &self.report_plan_arn);
        formatter.field("report_plan_name", &self.report_plan_name);
        formatter.field("report_plan_description", &self.report_plan_description);
        formatter.field("report_setting", &self.report_setting);
        formatter.field("report_delivery_channel", &self.report_delivery_channel);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field(
            "last_attempted_execution_time",
            &self.last_attempted_execution_time,
        );
        formatter.field(
            "last_successful_execution_time",
            &self.last_successful_execution_time,
        );
        formatter.finish()
    }
}
/// See [`ReportPlan`](crate::model::ReportPlan)
pub mod report_plan {
    /// A builder for [`ReportPlan`](crate::model::ReportPlan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_plan_arn: std::option::Option<std::string::String>,
        pub(crate) report_plan_name: std::option::Option<std::string::String>,
        pub(crate) report_plan_description: std::option::Option<std::string::String>,
        pub(crate) report_setting: std::option::Option<crate::model::ReportSetting>,
        pub(crate) report_delivery_channel:
            std::option::Option<crate::model::ReportDeliveryChannel>,
        pub(crate) deployment_status: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_attempted_execution_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_successful_execution_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn report_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_report_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_arn = input;
            self
        }
        /// <p>The unique name of the report plan. This name is between 1 and 256 characters starting
        /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
        /// (_).</p>
        pub fn report_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_name = Some(input.into());
            self
        }
        /// <p>The unique name of the report plan. This name is between 1 and 256 characters starting
        /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
        /// (_).</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_name = input;
            self
        }
        /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
        pub fn report_plan_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_description = Some(input.into());
            self
        }
        /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
        pub fn set_report_plan_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_description = input;
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn report_setting(mut self, input: crate::model::ReportSetting) -> Self {
            self.report_setting = Some(input);
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn set_report_setting(
            mut self,
            input: std::option::Option<crate::model::ReportSetting>,
        ) -> Self {
            self.report_setting = input;
            self
        }
        /// <p>Contains information about where and how to deliver your reports, specifically your
        /// Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
        pub fn report_delivery_channel(
            mut self,
            input: crate::model::ReportDeliveryChannel,
        ) -> Self {
            self.report_delivery_channel = Some(input);
            self
        }
        /// <p>Contains information about where and how to deliver your reports, specifically your
        /// Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
        pub fn set_report_delivery_channel(
            mut self,
            input: std::option::Option<crate::model::ReportDeliveryChannel>,
        ) -> Self {
            self.report_delivery_channel = input;
            self
        }
        /// <p>The deployment status of a report plan. The statuses are:</p>
        /// <p>
        /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS |
        /// COMPLETED</code>
        /// </p>
        pub fn deployment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status = Some(input.into());
            self
        }
        /// <p>The deployment status of a report plan. The statuses are:</p>
        /// <p>
        /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS |
        /// COMPLETED</code>
        /// </p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>The date and time that a report plan is created, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that a report plan is created, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that a report job associated with this report plan last attempted to
        /// run, in Unix format and Coordinated Universal Time (UTC). The value of
        /// <code>LastAttemptedExecutionTime</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn last_attempted_execution_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_attempted_execution_time = Some(input);
            self
        }
        /// <p>The date and time that a report job associated with this report plan last attempted to
        /// run, in Unix format and Coordinated Universal Time (UTC). The value of
        /// <code>LastAttemptedExecutionTime</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_last_attempted_execution_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_attempted_execution_time = input;
            self
        }
        /// <p>The date and time that a report job associated with this report plan last successfully
        /// ran, in Unix format and Coordinated Universal Time (UTC). The value of
        /// <code>LastSuccessfulExecutionTime</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn last_successful_execution_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_successful_execution_time = Some(input);
            self
        }
        /// <p>The date and time that a report job associated with this report plan last successfully
        /// ran, in Unix format and Coordinated Universal Time (UTC). The value of
        /// <code>LastSuccessfulExecutionTime</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_last_successful_execution_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_successful_execution_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportPlan`](crate::model::ReportPlan)
        pub fn build(self) -> crate::model::ReportPlan {
            crate::model::ReportPlan {
                report_plan_arn: self.report_plan_arn,
                report_plan_name: self.report_plan_name,
                report_plan_description: self.report_plan_description,
                report_setting: self.report_setting,
                report_delivery_channel: self.report_delivery_channel,
                deployment_status: self.deployment_status,
                creation_time: self.creation_time,
                last_attempted_execution_time: self.last_attempted_execution_time,
                last_successful_execution_time: self.last_successful_execution_time,
            }
        }
    }
}
impl ReportPlan {
    /// Creates a new builder-style object to manufacture [`ReportPlan`](crate::model::ReportPlan)
    pub fn builder() -> crate::model::report_plan::Builder {
        crate::model::report_plan::Builder::default()
    }
}

/// <p>Contains detailed information about a report job. A report job compiles a report based
/// on a report plan and publishes it to Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportJob {
    /// <p>The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded
    /// string that is at most 1,024 bytes long. Report job IDs cannot be edited.</p>
    pub report_job_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub report_plan_arn: std::option::Option<std::string::String>,
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are: </p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    pub report_template: std::option::Option<std::string::String>,
    /// <p>The date and time that a report job is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that a report job is completed, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>CompletionTime</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub completion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of a report job. The statuses are:</p>
    /// <p>
    /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
    /// </p>
    /// <p>
    /// <code>COMPLETED</code> means that the report is available for your review at your
    /// designated destination. If the status is <code>FAILED</code>, review the
    /// <code>StatusMessage</code> for the reason.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>A message explaining the status of the report job.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The S3 bucket name and S3 keys for the destination where the report job publishes the
    /// report.</p>
    pub report_destination: std::option::Option<crate::model::ReportDestination>,
}
impl ReportJob {
    /// <p>The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded
    /// string that is at most 1,024 bytes long. Report job IDs cannot be edited.</p>
    pub fn report_job_id(&self) -> std::option::Option<&str> {
        self.report_job_id.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub fn report_plan_arn(&self) -> std::option::Option<&str> {
        self.report_plan_arn.as_deref()
    }
    /// <p>Identifies the report template for the report. Reports are built using a report
    /// template. The report templates are: </p>
    /// <p>
    /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
    /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
    /// </p>
    pub fn report_template(&self) -> std::option::Option<&str> {
        self.report_template.as_deref()
    }
    /// <p>The date and time that a report job is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time that a report job is completed, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>CompletionTime</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn completion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_time.as_ref()
    }
    /// <p>The status of a report job. The statuses are:</p>
    /// <p>
    /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
    /// </p>
    /// <p>
    /// <code>COMPLETED</code> means that the report is available for your review at your
    /// designated destination. If the status is <code>FAILED</code>, review the
    /// <code>StatusMessage</code> for the reason.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A message explaining the status of the report job.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The S3 bucket name and S3 keys for the destination where the report job publishes the
    /// report.</p>
    pub fn report_destination(&self) -> std::option::Option<&crate::model::ReportDestination> {
        self.report_destination.as_ref()
    }
}
impl std::fmt::Debug for ReportJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportJob");
        formatter.field("report_job_id", &self.report_job_id);
        formatter.field("report_plan_arn", &self.report_plan_arn);
        formatter.field("report_template", &self.report_template);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("report_destination", &self.report_destination);
        formatter.finish()
    }
}
/// See [`ReportJob`](crate::model::ReportJob)
pub mod report_job {
    /// A builder for [`ReportJob`](crate::model::ReportJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_job_id: std::option::Option<std::string::String>,
        pub(crate) report_plan_arn: std::option::Option<std::string::String>,
        pub(crate) report_template: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) report_destination: std::option::Option<crate::model::ReportDestination>,
    }
    impl Builder {
        /// <p>The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded
        /// string that is at most 1,024 bytes long. Report job IDs cannot be edited.</p>
        pub fn report_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_job_id = Some(input.into());
            self
        }
        /// <p>The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded
        /// string that is at most 1,024 bytes long. Report job IDs cannot be edited.</p>
        pub fn set_report_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_job_id = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn report_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_report_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_plan_arn = input;
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are: </p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        pub fn report_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_template = Some(input.into());
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are: </p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        pub fn set_report_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_template = input;
            self
        }
        /// <p>The date and time that a report job is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that a report job is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that a report job is completed, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>CompletionTime</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn completion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p>The date and time that a report job is completed, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>CompletionTime</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// <p>The status of a report job. The statuses are:</p>
        /// <p>
        /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
        /// </p>
        /// <p>
        /// <code>COMPLETED</code> means that the report is available for your review at your
        /// designated destination. If the status is <code>FAILED</code>, review the
        /// <code>StatusMessage</code> for the reason.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of a report job. The statuses are:</p>
        /// <p>
        /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
        /// </p>
        /// <p>
        /// <code>COMPLETED</code> means that the report is available for your review at your
        /// designated destination. If the status is <code>FAILED</code>, review the
        /// <code>StatusMessage</code> for the reason.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A message explaining the status of the report job.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message explaining the status of the report job.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The S3 bucket name and S3 keys for the destination where the report job publishes the
        /// report.</p>
        pub fn report_destination(mut self, input: crate::model::ReportDestination) -> Self {
            self.report_destination = Some(input);
            self
        }
        /// <p>The S3 bucket name and S3 keys for the destination where the report job publishes the
        /// report.</p>
        pub fn set_report_destination(
            mut self,
            input: std::option::Option<crate::model::ReportDestination>,
        ) -> Self {
            self.report_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportJob`](crate::model::ReportJob)
        pub fn build(self) -> crate::model::ReportJob {
            crate::model::ReportJob {
                report_job_id: self.report_job_id,
                report_plan_arn: self.report_plan_arn,
                report_template: self.report_template,
                creation_time: self.creation_time,
                completion_time: self.completion_time,
                status: self.status,
                status_message: self.status_message,
                report_destination: self.report_destination,
            }
        }
    }
}
impl ReportJob {
    /// Creates a new builder-style object to manufacture [`ReportJob`](crate::model::ReportJob)
    pub fn builder() -> crate::model::report_job::Builder {
        crate::model::report_job::Builder::default()
    }
}

/// <p>Contains information from your report job about your report destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportDestination {
    /// <p>The unique name of the Amazon S3 bucket that receives your reports.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The object key that uniquely identifies your reports in your S3 bucket.</p>
    pub s3_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReportDestination {
    /// <p>The unique name of the Amazon S3 bucket that receives your reports.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The object key that uniquely identifies your reports in your S3 bucket.</p>
    pub fn s3_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.s3_keys.as_deref()
    }
}
impl std::fmt::Debug for ReportDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportDestination");
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_keys", &self.s3_keys);
        formatter.finish()
    }
}
/// See [`ReportDestination`](crate::model::ReportDestination)
pub mod report_destination {
    /// A builder for [`ReportDestination`](crate::model::ReportDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique name of the Amazon S3 bucket that receives your reports.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The unique name of the Amazon S3 bucket that receives your reports.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// Appends an item to `s3_keys`.
        ///
        /// To override the contents of this collection use [`set_s3_keys`](Self::set_s3_keys).
        ///
        /// <p>The object key that uniquely identifies your reports in your S3 bucket.</p>
        pub fn s3_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.s3_keys.unwrap_or_default();
            v.push(input.into());
            self.s3_keys = Some(v);
            self
        }
        /// <p>The object key that uniquely identifies your reports in your S3 bucket.</p>
        pub fn set_s3_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.s3_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportDestination`](crate::model::ReportDestination)
        pub fn build(self) -> crate::model::ReportDestination {
            crate::model::ReportDestination {
                s3_bucket_name: self.s3_bucket_name,
                s3_keys: self.s3_keys,
            }
        }
    }
}
impl ReportDestination {
    /// Creates a new builder-style object to manufacture [`ReportDestination`](crate::model::ReportDestination)
    pub fn builder() -> crate::model::report_destination::Builder {
        crate::model::report_destination::Builder::default()
    }
}

/// <p>Contains detailed information about a saved recovery point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryPointByResource {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A status code specifying the state of the recovery point.</p>
    pub status: std::option::Option<crate::model::RecoveryPointStatus>,
    /// <p>A message explaining the reason of the recovery point deletion failure.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of a backup.</p>
    pub backup_size_bytes: std::option::Option<i64>,
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
}
impl RecoveryPointByResource {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>A status code specifying the state of the recovery point.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RecoveryPointStatus> {
        self.status.as_ref()
    }
    /// <p>A message explaining the reason of the recovery point deletion failure.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>The size, in bytes, of a backup.</p>
    pub fn backup_size_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_bytes
    }
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
}
impl std::fmt::Debug for RecoveryPointByResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryPointByResource");
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("backup_size_bytes", &self.backup_size_bytes);
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.finish()
    }
}
/// See [`RecoveryPointByResource`](crate::model::RecoveryPointByResource)
pub mod recovery_point_by_resource {
    /// A builder for [`RecoveryPointByResource`](crate::model::RecoveryPointByResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::RecoveryPointStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) backup_size_bytes: std::option::Option<i64>,
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>A status code specifying the state of the recovery point.</p>
        pub fn status(mut self, input: crate::model::RecoveryPointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A status code specifying the state of the recovery point.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message explaining the reason of the recovery point deletion failure.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message explaining the reason of the recovery point deletion failure.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn backup_size_bytes(mut self, input: i64) -> Self {
            self.backup_size_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn set_backup_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_bytes = input;
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryPointByResource`](crate::model::RecoveryPointByResource)
        pub fn build(self) -> crate::model::RecoveryPointByResource {
            crate::model::RecoveryPointByResource {
                recovery_point_arn: self.recovery_point_arn,
                creation_date: self.creation_date,
                status: self.status,
                status_message: self.status_message,
                encryption_key_arn: self.encryption_key_arn,
                backup_size_bytes: self.backup_size_bytes,
                backup_vault_name: self.backup_vault_name,
            }
        }
    }
}
impl RecoveryPointByResource {
    /// Creates a new builder-style object to manufacture [`RecoveryPointByResource`](crate::model::RecoveryPointByResource)
    pub fn builder() -> crate::model::recovery_point_by_resource::Builder {
        crate::model::recovery_point_by_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecoveryPointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Partial,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecoveryPointStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => RecoveryPointStatus::Completed,
            "DELETING" => RecoveryPointStatus::Deleting,
            "EXPIRED" => RecoveryPointStatus::Expired,
            "PARTIAL" => RecoveryPointStatus::Partial,
            other => RecoveryPointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecoveryPointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecoveryPointStatus::from(s))
    }
}
impl RecoveryPointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecoveryPointStatus::Completed => "COMPLETED",
            RecoveryPointStatus::Deleting => "DELETING",
            RecoveryPointStatus::Expired => "EXPIRED",
            RecoveryPointStatus::Partial => "PARTIAL",
            RecoveryPointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "DELETING", "EXPIRED", "PARTIAL"]
    }
}
impl AsRef<str> for RecoveryPointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains detailed information about the recovery points stored in a backup vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryPointByBackupVault {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a backup vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>The backup vault where the recovery point was originally copied from. If the recovery
    /// point is restored to the same account this value will be <code>null</code>.</p>
    pub source_backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
    /// resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an
    /// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
    /// supported resource type is Amazon EC2.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Contains identifying information about the creation of a recovery point, including the
    /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
    /// and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
    pub created_by: std::option::Option<crate::model::RecoveryPointCreator>,
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A status code specifying the state of the recovery point.</p>
    pub status: std::option::Option<crate::model::RecoveryPointStatus>,
    /// <p>A message explaining the reason of the recovery point deletion failure.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
    /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The size, in bytes, of a backup.</p>
    pub backup_size_in_bytes: std::option::Option<i64>,
    /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
    /// <code>MoveToColdStorageAt</code> timestamps.</p>
    pub calculated_lifecycle: std::option::Option<crate::model::CalculatedLifecycle>,
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup transitions and expires backups automatically according to
    /// the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is
    /// encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
    pub is_encrypted: bool,
    /// <p>The date and time a recovery point was last restored, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub last_restore_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RecoveryPointByBackupVault {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An ARN that uniquely identifies a backup vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>The backup vault where the recovery point was originally copied from. If the recovery
    /// point is restored to the same account this value will be <code>null</code>.</p>
    pub fn source_backup_vault_arn(&self) -> std::option::Option<&str> {
        self.source_backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
    /// resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an
    /// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
    /// supported resource type is Amazon EC2.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Contains identifying information about the creation of a recovery point, including the
    /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
    /// and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::RecoveryPointCreator> {
        self.created_by.as_ref()
    }
    /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>A status code specifying the state of the recovery point.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RecoveryPointStatus> {
        self.status.as_ref()
    }
    /// <p>A message explaining the reason of the recovery point deletion failure.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
    /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>The size, in bytes, of a backup.</p>
    pub fn backup_size_in_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_in_bytes
    }
    /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
    /// <code>MoveToColdStorageAt</code> timestamps.</p>
    pub fn calculated_lifecycle(&self) -> std::option::Option<&crate::model::CalculatedLifecycle> {
        self.calculated_lifecycle.as_ref()
    }
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup transitions and expires backups automatically according to
    /// the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is
    /// encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
    pub fn is_encrypted(&self) -> bool {
        self.is_encrypted
    }
    /// <p>The date and time a recovery point was last restored, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub fn last_restore_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_restore_time.as_ref()
    }
}
impl std::fmt::Debug for RecoveryPointByBackupVault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryPointByBackupVault");
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("source_backup_vault_arn", &self.source_backup_vault_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("created_by", &self.created_by);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("backup_size_in_bytes", &self.backup_size_in_bytes);
        formatter.field("calculated_lifecycle", &self.calculated_lifecycle);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("is_encrypted", &self.is_encrypted);
        formatter.field("last_restore_time", &self.last_restore_time);
        formatter.finish()
    }
}
/// See [`RecoveryPointByBackupVault`](crate::model::RecoveryPointByBackupVault)
pub mod recovery_point_by_backup_vault {
    /// A builder for [`RecoveryPointByBackupVault`](crate::model::RecoveryPointByBackupVault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) source_backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::RecoveryPointCreator>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RecoveryPointStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) backup_size_in_bytes: std::option::Option<i64>,
        pub(crate) calculated_lifecycle: std::option::Option<crate::model::CalculatedLifecycle>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) is_encrypted: std::option::Option<bool>,
        pub(crate) last_restore_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An ARN that uniquely identifies a backup vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a backup vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>The backup vault where the recovery point was originally copied from. If the recovery
        /// point is restored to the same account this value will be <code>null</code>.</p>
        pub fn source_backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_vault_arn = Some(input.into());
            self
        }
        /// <p>The backup vault where the recovery point was originally copied from. If the recovery
        /// point is restored to the same account this value will be <code>null</code>.</p>
        pub fn set_source_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an
        /// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
        /// supported resource type is Amazon EC2.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource saved as a recovery point; for example, an
        /// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
        /// supported resource type is Amazon EC2.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Contains identifying information about the creation of a recovery point, including the
        /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
        /// and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
        pub fn created_by(mut self, input: crate::model::RecoveryPointCreator) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Contains identifying information about the creation of a recovery point, including the
        /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
        /// and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointCreator>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>A status code specifying the state of the recovery point.</p>
        pub fn status(mut self, input: crate::model::RecoveryPointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A status code specifying the state of the recovery point.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message explaining the reason of the recovery point deletion failure.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message explaining the reason of the recovery point deletion failure.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a recovery point is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
        /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date and time a job to restore a recovery point is completed, in Unix format and
        /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn backup_size_in_bytes(mut self, input: i64) -> Self {
            self.backup_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn set_backup_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_in_bytes = input;
            self
        }
        /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
        /// <code>MoveToColdStorageAt</code> timestamps.</p>
        pub fn calculated_lifecycle(mut self, input: crate::model::CalculatedLifecycle) -> Self {
            self.calculated_lifecycle = Some(input);
            self
        }
        /// <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
        /// <code>MoveToColdStorageAt</code> timestamps.</p>
        pub fn set_calculated_lifecycle(
            mut self,
            input: std::option::Option<crate::model::CalculatedLifecycle>,
        ) -> Self {
            self.calculated_lifecycle = input;
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is
        /// encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
        pub fn is_encrypted(mut self, input: bool) -> Self {
            self.is_encrypted = Some(input);
            self
        }
        /// <p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is
        /// encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>
        pub fn set_is_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.is_encrypted = input;
            self
        }
        /// <p>The date and time a recovery point was last restored, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn last_restore_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_restore_time = Some(input);
            self
        }
        /// <p>The date and time a recovery point was last restored, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn set_last_restore_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_restore_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryPointByBackupVault`](crate::model::RecoveryPointByBackupVault)
        pub fn build(self) -> crate::model::RecoveryPointByBackupVault {
            crate::model::RecoveryPointByBackupVault {
                recovery_point_arn: self.recovery_point_arn,
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                source_backup_vault_arn: self.source_backup_vault_arn,
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                created_by: self.created_by,
                iam_role_arn: self.iam_role_arn,
                status: self.status,
                status_message: self.status_message,
                creation_date: self.creation_date,
                completion_date: self.completion_date,
                backup_size_in_bytes: self.backup_size_in_bytes,
                calculated_lifecycle: self.calculated_lifecycle,
                lifecycle: self.lifecycle,
                encryption_key_arn: self.encryption_key_arn,
                is_encrypted: self.is_encrypted.unwrap_or_default(),
                last_restore_time: self.last_restore_time,
            }
        }
    }
}
impl RecoveryPointByBackupVault {
    /// Creates a new builder-style object to manufacture [`RecoveryPointByBackupVault`](crate::model::RecoveryPointByBackupVault)
    pub fn builder() -> crate::model::recovery_point_by_backup_vault::Builder {
        crate::model::recovery_point_by_backup_vault::Builder::default()
    }
}

/// <p>Contains information about the backup plan and rule that Backup used to
/// initiate the recovery point backup.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryPointCreator {
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub backup_plan_arn: std::option::Option<std::string::String>,
    /// <p>Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at
    /// most 1,024 bytes long. They cannot be edited.</p>
    pub backup_plan_version: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a rule used to schedule the backup of a selection of
    /// resources.</p>
    pub backup_rule_id: std::option::Option<std::string::String>,
}
impl RecoveryPointCreator {
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub fn backup_plan_arn(&self) -> std::option::Option<&str> {
        self.backup_plan_arn.as_deref()
    }
    /// <p>Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at
    /// most 1,024 bytes long. They cannot be edited.</p>
    pub fn backup_plan_version(&self) -> std::option::Option<&str> {
        self.backup_plan_version.as_deref()
    }
    /// <p>Uniquely identifies a rule used to schedule the backup of a selection of
    /// resources.</p>
    pub fn backup_rule_id(&self) -> std::option::Option<&str> {
        self.backup_rule_id.as_deref()
    }
}
impl std::fmt::Debug for RecoveryPointCreator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryPointCreator");
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("backup_plan_arn", &self.backup_plan_arn);
        formatter.field("backup_plan_version", &self.backup_plan_version);
        formatter.field("backup_rule_id", &self.backup_rule_id);
        formatter.finish()
    }
}
/// See [`RecoveryPointCreator`](crate::model::RecoveryPointCreator)
pub mod recovery_point_creator {
    /// A builder for [`RecoveryPointCreator`](crate::model::RecoveryPointCreator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_arn: std::option::Option<std::string::String>,
        pub(crate) backup_plan_version: std::option::Option<std::string::String>,
        pub(crate) backup_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn backup_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn set_backup_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_arn = input;
            self
        }
        /// <p>Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at
        /// most 1,024 bytes long. They cannot be edited.</p>
        pub fn backup_plan_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_version = Some(input.into());
            self
        }
        /// <p>Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at
        /// most 1,024 bytes long. They cannot be edited.</p>
        pub fn set_backup_plan_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_version = input;
            self
        }
        /// <p>Uniquely identifies a rule used to schedule the backup of a selection of
        /// resources.</p>
        pub fn backup_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_rule_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a rule used to schedule the backup of a selection of
        /// resources.</p>
        pub fn set_backup_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryPointCreator`](crate::model::RecoveryPointCreator)
        pub fn build(self) -> crate::model::RecoveryPointCreator {
            crate::model::RecoveryPointCreator {
                backup_plan_id: self.backup_plan_id,
                backup_plan_arn: self.backup_plan_arn,
                backup_plan_version: self.backup_plan_version,
                backup_rule_id: self.backup_rule_id,
            }
        }
    }
}
impl RecoveryPointCreator {
    /// Creates a new builder-style object to manufacture [`RecoveryPointCreator`](crate::model::RecoveryPointCreator)
    pub fn builder() -> crate::model::recovery_point_creator::Builder {
        crate::model::recovery_point_creator::Builder::default()
    }
}

/// <p>A structure that contains information about a backed-up resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectedResource {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For
    /// Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
    /// Amazon EC2.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The date and time a resource was last backed up, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub last_backup_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ProtectedResource {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For
    /// Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
    /// Amazon EC2.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The date and time a resource was last backed up, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn last_backup_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_backup_time.as_ref()
    }
}
impl std::fmt::Debug for ProtectedResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectedResource");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("last_backup_time", &self.last_backup_time);
        formatter.finish()
    }
}
/// See [`ProtectedResource`](crate::model::ProtectedResource)
pub mod protected_resource {
    /// A builder for [`ProtectedResource`](crate::model::ProtectedResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) last_backup_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For
        /// Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
        /// Amazon EC2.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For
        /// Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is
        /// Amazon EC2.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The date and time a resource was last backed up, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn last_backup_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_backup_time = Some(input);
            self
        }
        /// <p>The date and time a resource was last backed up, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_last_backup_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_backup_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectedResource`](crate::model::ProtectedResource)
        pub fn build(self) -> crate::model::ProtectedResource {
            crate::model::ProtectedResource {
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                last_backup_time: self.last_backup_time,
            }
        }
    }
}
impl ProtectedResource {
    /// Creates a new builder-style object to manufacture [`ProtectedResource`](crate::model::ProtectedResource)
    pub fn builder() -> crate::model::protected_resource::Builder {
        crate::model::protected_resource::Builder::default()
    }
}

/// <p>Contains detailed information about a framework. Frameworks contain controls, which
/// evaluate and report on your backup events and resources. Frameworks generate daily
/// compliance results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Framework {
    /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
    /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub framework_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub framework_arn: std::option::Option<std::string::String>,
    /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
    pub framework_description: std::option::Option<std::string::String>,
    /// <p>The number of controls contained by the framework.</p>
    pub number_of_controls: i32,
    /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The deployment status of a framework. The statuses are:</p>
    /// <p>
    /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED |
    /// FAILED</code>
    /// </p>
    pub deployment_status: std::option::Option<std::string::String>,
}
impl Framework {
    /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
    /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
    pub fn framework_name(&self) -> std::option::Option<&str> {
        self.framework_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
    /// depends on the resource type.</p>
    pub fn framework_arn(&self) -> std::option::Option<&str> {
        self.framework_arn.as_deref()
    }
    /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
    pub fn framework_description(&self) -> std::option::Option<&str> {
        self.framework_description.as_deref()
    }
    /// <p>The number of controls contained by the framework.</p>
    pub fn number_of_controls(&self) -> i32 {
        self.number_of_controls
    }
    /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The deployment status of a framework. The statuses are:</p>
    /// <p>
    /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED |
    /// FAILED</code>
    /// </p>
    pub fn deployment_status(&self) -> std::option::Option<&str> {
        self.deployment_status.as_deref()
    }
}
impl std::fmt::Debug for Framework {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Framework");
        formatter.field("framework_name", &self.framework_name);
        formatter.field("framework_arn", &self.framework_arn);
        formatter.field("framework_description", &self.framework_description);
        formatter.field("number_of_controls", &self.number_of_controls);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.finish()
    }
}
/// See [`Framework`](crate::model::Framework)
pub mod framework {
    /// A builder for [`Framework`](crate::model::Framework)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_name: std::option::Option<std::string::String>,
        pub(crate) framework_arn: std::option::Option<std::string::String>,
        pub(crate) framework_description: std::option::Option<std::string::String>,
        pub(crate) number_of_controls: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
        /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
        /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn framework_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_framework_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_arn = input;
            self
        }
        /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
        pub fn framework_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_description = Some(input.into());
            self
        }
        /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
        pub fn set_framework_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_description = input;
            self
        }
        /// <p>The number of controls contained by the framework.</p>
        pub fn number_of_controls(mut self, input: i32) -> Self {
            self.number_of_controls = Some(input);
            self
        }
        /// <p>The number of controls contained by the framework.</p>
        pub fn set_number_of_controls(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_controls = input;
            self
        }
        /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that a framework is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The deployment status of a framework. The statuses are:</p>
        /// <p>
        /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED |
        /// FAILED</code>
        /// </p>
        pub fn deployment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status = Some(input.into());
            self
        }
        /// <p>The deployment status of a framework. The statuses are:</p>
        /// <p>
        /// <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED |
        /// FAILED</code>
        /// </p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Framework`](crate::model::Framework)
        pub fn build(self) -> crate::model::Framework {
            crate::model::Framework {
                framework_name: self.framework_name,
                framework_arn: self.framework_arn,
                framework_description: self.framework_description,
                number_of_controls: self.number_of_controls.unwrap_or_default(),
                creation_time: self.creation_time,
                deployment_status: self.deployment_status,
            }
        }
    }
}
impl Framework {
    /// Creates a new builder-style object to manufacture [`Framework`](crate::model::Framework)
    pub fn builder() -> crate::model::framework::Builder {
        crate::model::framework::Builder::default()
    }
}

/// <p>Contains detailed information about a copy job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyJob {
    /// <p>The account ID that owns the copy job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a copy job.</p>
    pub copy_job_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>
    pub source_backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a source recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub source_recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for
    /// example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub destination_backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a destination recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub destination_recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store
    /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS)
    /// database.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a copy job is created, in Unix format and Coordinated Universal Time
    /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time a copy job is completed, in Unix format and Coordinated Universal Time
    /// (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
    /// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of a copy job.</p>
    pub state: std::option::Option<crate::model::CopyJobState>,
    /// <p>A detailed message explaining the status of the job to copy a resource.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of a copy job.</p>
    pub backup_size_in_bytes: std::option::Option<i64>,
    /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>Contains information about the backup plan and rule that Backup used to
    /// initiate the recovery point backup.</p>
    pub created_by: std::option::Option<crate::model::RecoveryPointCreator>,
    /// <p>The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl CopyJob {
    /// <p>The account ID that owns the copy job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Uniquely identifies a copy job.</p>
    pub fn copy_job_id(&self) -> std::option::Option<&str> {
        self.copy_job_id.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>
    pub fn source_backup_vault_arn(&self) -> std::option::Option<&str> {
        self.source_backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a source recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn source_recovery_point_arn(&self) -> std::option::Option<&str> {
        self.source_recovery_point_arn.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for
    /// example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn destination_backup_vault_arn(&self) -> std::option::Option<&str> {
        self.destination_backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a destination recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn destination_recovery_point_arn(&self) -> std::option::Option<&str> {
        self.destination_recovery_point_arn.as_deref()
    }
    /// <p>The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store
    /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS)
    /// database.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The date and time a copy job is created, in Unix format and Coordinated Universal Time
    /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time a copy job is completed, in Unix format and Coordinated Universal Time
    /// (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
    /// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>The current state of a copy job.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CopyJobState> {
        self.state.as_ref()
    }
    /// <p>A detailed message explaining the status of the job to copy a resource.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The size, in bytes, of a copy job.</p>
    pub fn backup_size_in_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_in_bytes
    }
    /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
    /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>Contains information about the backup plan and rule that Backup used to
    /// initiate the recovery point backup.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::RecoveryPointCreator> {
        self.created_by.as_ref()
    }
    /// <p>The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for CopyJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyJob");
        formatter.field("account_id", &self.account_id);
        formatter.field("copy_job_id", &self.copy_job_id);
        formatter.field("source_backup_vault_arn", &self.source_backup_vault_arn);
        formatter.field("source_recovery_point_arn", &self.source_recovery_point_arn);
        formatter.field(
            "destination_backup_vault_arn",
            &self.destination_backup_vault_arn,
        );
        formatter.field(
            "destination_recovery_point_arn",
            &self.destination_recovery_point_arn,
        );
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("state", &self.state);
        formatter.field("status_message", &self.status_message);
        formatter.field("backup_size_in_bytes", &self.backup_size_in_bytes);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("created_by", &self.created_by);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`CopyJob`](crate::model::CopyJob)
pub mod copy_job {
    /// A builder for [`CopyJob`](crate::model::CopyJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) copy_job_id: std::option::Option<std::string::String>,
        pub(crate) source_backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) source_recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) destination_backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) destination_recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::CopyJobState>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) backup_size_in_bytes: std::option::Option<i64>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::RecoveryPointCreator>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID that owns the copy job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID that owns the copy job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Uniquely identifies a copy job.</p>
        pub fn copy_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a copy job.</p>
        pub fn set_copy_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.copy_job_id = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>
        pub fn source_backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>
        pub fn set_source_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a source recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn source_recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a source recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_source_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_recovery_point_arn = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for
        /// example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn destination_backup_vault_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for
        /// example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_destination_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a destination recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn destination_recovery_point_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a destination recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_destination_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_recovery_point_arn = input;
            self
        }
        /// <p>The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store
        /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS)
        /// database.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store
        /// (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS)
        /// database.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The date and time a copy job is created, in Unix format and Coordinated Universal Time
        /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a copy job is created, in Unix format and Coordinated Universal Time
        /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time a copy job is completed, in Unix format and Coordinated Universal Time
        /// (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
        /// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date and time a copy job is completed, in Unix format and Coordinated Universal Time
        /// (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
        /// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>The current state of a copy job.</p>
        pub fn state(mut self, input: crate::model::CopyJobState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of a copy job.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::CopyJobState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A detailed message explaining the status of the job to copy a resource.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A detailed message explaining the status of the job to copy a resource.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The size, in bytes, of a copy job.</p>
        pub fn backup_size_in_bytes(mut self, input: i64) -> Self {
            self.backup_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of a copy job.</p>
        pub fn set_backup_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_in_bytes = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>Contains information about the backup plan and rule that Backup used to
        /// initiate the recovery point backup.</p>
        pub fn created_by(mut self, input: crate::model::RecoveryPointCreator) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Contains information about the backup plan and rule that Backup used to
        /// initiate the recovery point backup.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointCreator>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyJob`](crate::model::CopyJob)
        pub fn build(self) -> crate::model::CopyJob {
            crate::model::CopyJob {
                account_id: self.account_id,
                copy_job_id: self.copy_job_id,
                source_backup_vault_arn: self.source_backup_vault_arn,
                source_recovery_point_arn: self.source_recovery_point_arn,
                destination_backup_vault_arn: self.destination_backup_vault_arn,
                destination_recovery_point_arn: self.destination_recovery_point_arn,
                resource_arn: self.resource_arn,
                creation_date: self.creation_date,
                completion_date: self.completion_date,
                state: self.state,
                status_message: self.status_message,
                backup_size_in_bytes: self.backup_size_in_bytes,
                iam_role_arn: self.iam_role_arn,
                created_by: self.created_by,
                resource_type: self.resource_type,
            }
        }
    }
}
impl CopyJob {
    /// Creates a new builder-style object to manufacture [`CopyJob`](crate::model::CopyJob)
    pub fn builder() -> crate::model::copy_job::Builder {
        crate::model::copy_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CopyJobState {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CopyJobState {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => CopyJobState::Completed,
            "CREATED" => CopyJobState::Created,
            "FAILED" => CopyJobState::Failed,
            "RUNNING" => CopyJobState::Running,
            other => CopyJobState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CopyJobState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CopyJobState::from(s))
    }
}
impl CopyJobState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CopyJobState::Completed => "COMPLETED",
            CopyJobState::Created => "CREATED",
            CopyJobState::Failed => "FAILED",
            CopyJobState::Running => "RUNNING",
            CopyJobState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "CREATED", "FAILED", "RUNNING"]
    }
}
impl AsRef<str> for CopyJobState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains metadata about a backup vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupVaultListMember {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a resource backup is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The number of recovery points that are stored in a backup vault.</p>
    pub number_of_recovery_points: i64,
    /// <p>A Boolean value that indicates whether Backup Vault Lock applies to the
    /// selected backup vault. If <code>true</code>, Vault Lock prevents delete and update
    /// operations on the recovery points in the selected vault.</p>
    pub locked: std::option::Option<bool>,
    /// <p>The Backup Vault Lock setting that specifies the minimum retention period
    /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
    /// does not enforce a minimum retention period.</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
    /// retention period equal to or longer than the minimum retention period. If the job's
    /// retention period is shorter than that minimum retention period, then the vault fails the
    /// backup or copy job, and you should either modify your lifecycle settings or use a different
    /// vault. Recovery points already stored in the vault prior to Vault Lock are not
    /// affected.</p>
    pub min_retention_days: std::option::Option<i64>,
    /// <p>The Backup Vault Lock setting that specifies the maximum retention period
    /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
    /// does not enforce a maximum retention period on the recovery points in the vault (allowing
    /// indefinite storage).</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
    /// retention period equal to or shorter than the maximum retention period. If the job's
    /// retention period is longer than that maximum retention period, then the vault fails the
    /// backup or copy job, and you should either modify your lifecycle settings or use a different
    /// vault. Recovery points already stored in the vault prior to Vault Lock are not
    /// affected.</p>
    pub max_retention_days: std::option::Option<i64>,
    /// <p>The date and time when Backup Vault Lock configuration becomes immutable,
    /// meaning it cannot be changed or deleted.</p>
    /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change
    /// your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
    /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub lock_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl BackupVaultListMember {
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>The date and time a resource backup is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The server-side encryption key that is used to protect your backups; for example,
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The number of recovery points that are stored in a backup vault.</p>
    pub fn number_of_recovery_points(&self) -> i64 {
        self.number_of_recovery_points
    }
    /// <p>A Boolean value that indicates whether Backup Vault Lock applies to the
    /// selected backup vault. If <code>true</code>, Vault Lock prevents delete and update
    /// operations on the recovery points in the selected vault.</p>
    pub fn locked(&self) -> std::option::Option<bool> {
        self.locked
    }
    /// <p>The Backup Vault Lock setting that specifies the minimum retention period
    /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
    /// does not enforce a minimum retention period.</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
    /// retention period equal to or longer than the minimum retention period. If the job's
    /// retention period is shorter than that minimum retention period, then the vault fails the
    /// backup or copy job, and you should either modify your lifecycle settings or use a different
    /// vault. Recovery points already stored in the vault prior to Vault Lock are not
    /// affected.</p>
    pub fn min_retention_days(&self) -> std::option::Option<i64> {
        self.min_retention_days
    }
    /// <p>The Backup Vault Lock setting that specifies the maximum retention period
    /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
    /// does not enforce a maximum retention period on the recovery points in the vault (allowing
    /// indefinite storage).</p>
    /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
    /// retention period equal to or shorter than the maximum retention period. If the job's
    /// retention period is longer than that maximum retention period, then the vault fails the
    /// backup or copy job, and you should either modify your lifecycle settings or use a different
    /// vault. Recovery points already stored in the vault prior to Vault Lock are not
    /// affected.</p>
    pub fn max_retention_days(&self) -> std::option::Option<i64> {
        self.max_retention_days
    }
    /// <p>The date and time when Backup Vault Lock configuration becomes immutable,
    /// meaning it cannot be changed or deleted.</p>
    /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change
    /// your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
    /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub fn lock_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.lock_date.as_ref()
    }
}
impl std::fmt::Debug for BackupVaultListMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupVaultListMember");
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("number_of_recovery_points", &self.number_of_recovery_points);
        formatter.field("locked", &self.locked);
        formatter.field("min_retention_days", &self.min_retention_days);
        formatter.field("max_retention_days", &self.max_retention_days);
        formatter.field("lock_date", &self.lock_date);
        formatter.finish()
    }
}
/// See [`BackupVaultListMember`](crate::model::BackupVaultListMember)
pub mod backup_vault_list_member {
    /// A builder for [`BackupVaultListMember`](crate::model::BackupVaultListMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) number_of_recovery_points: std::option::Option<i64>,
        pub(crate) locked: std::option::Option<bool>,
        pub(crate) min_retention_days: std::option::Option<i64>,
        pub(crate) max_retention_days: std::option::Option<i64>,
        pub(crate) lock_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>The date and time a resource backup is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a resource backup is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The number of recovery points that are stored in a backup vault.</p>
        pub fn number_of_recovery_points(mut self, input: i64) -> Self {
            self.number_of_recovery_points = Some(input);
            self
        }
        /// <p>The number of recovery points that are stored in a backup vault.</p>
        pub fn set_number_of_recovery_points(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_recovery_points = input;
            self
        }
        /// <p>A Boolean value that indicates whether Backup Vault Lock applies to the
        /// selected backup vault. If <code>true</code>, Vault Lock prevents delete and update
        /// operations on the recovery points in the selected vault.</p>
        pub fn locked(mut self, input: bool) -> Self {
            self.locked = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether Backup Vault Lock applies to the
        /// selected backup vault. If <code>true</code>, Vault Lock prevents delete and update
        /// operations on the recovery points in the selected vault.</p>
        pub fn set_locked(mut self, input: std::option::Option<bool>) -> Self {
            self.locked = input;
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the minimum retention period
        /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
        /// does not enforce a minimum retention period.</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
        /// retention period equal to or longer than the minimum retention period. If the job's
        /// retention period is shorter than that minimum retention period, then the vault fails the
        /// backup or copy job, and you should either modify your lifecycle settings or use a different
        /// vault. Recovery points already stored in the vault prior to Vault Lock are not
        /// affected.</p>
        pub fn min_retention_days(mut self, input: i64) -> Self {
            self.min_retention_days = Some(input);
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the minimum retention period
        /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
        /// does not enforce a minimum retention period.</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
        /// retention period equal to or longer than the minimum retention period. If the job's
        /// retention period is shorter than that minimum retention period, then the vault fails the
        /// backup or copy job, and you should either modify your lifecycle settings or use a different
        /// vault. Recovery points already stored in the vault prior to Vault Lock are not
        /// affected.</p>
        pub fn set_min_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.min_retention_days = input;
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the maximum retention period
        /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
        /// does not enforce a maximum retention period on the recovery points in the vault (allowing
        /// indefinite storage).</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
        /// retention period equal to or shorter than the maximum retention period. If the job's
        /// retention period is longer than that maximum retention period, then the vault fails the
        /// backup or copy job, and you should either modify your lifecycle settings or use a different
        /// vault. Recovery points already stored in the vault prior to Vault Lock are not
        /// affected.</p>
        pub fn max_retention_days(mut self, input: i64) -> Self {
            self.max_retention_days = Some(input);
            self
        }
        /// <p>The Backup Vault Lock setting that specifies the maximum retention period
        /// that the vault retains its recovery points. If this parameter is not specified, Vault Lock
        /// does not enforce a maximum retention period on the recovery points in the vault (allowing
        /// indefinite storage).</p>
        /// <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a
        /// retention period equal to or shorter than the maximum retention period. If the job's
        /// retention period is longer than that maximum retention period, then the vault fails the
        /// backup or copy job, and you should either modify your lifecycle settings or use a different
        /// vault. Recovery points already stored in the vault prior to Vault Lock are not
        /// affected.</p>
        pub fn set_max_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.max_retention_days = input;
            self
        }
        /// <p>The date and time when Backup Vault Lock configuration becomes immutable,
        /// meaning it cannot be changed or deleted.</p>
        /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change
        /// your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
        /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn lock_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.lock_date = Some(input);
            self
        }
        /// <p>The date and time when Backup Vault Lock configuration becomes immutable,
        /// meaning it cannot be changed or deleted.</p>
        /// <p>If you applied Vault Lock to your vault without specifying a lock date, you can change
        /// your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p>
        /// <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn set_lock_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.lock_date = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupVaultListMember`](crate::model::BackupVaultListMember)
        pub fn build(self) -> crate::model::BackupVaultListMember {
            crate::model::BackupVaultListMember {
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                creation_date: self.creation_date,
                encryption_key_arn: self.encryption_key_arn,
                creator_request_id: self.creator_request_id,
                number_of_recovery_points: self.number_of_recovery_points.unwrap_or_default(),
                locked: self.locked,
                min_retention_days: self.min_retention_days,
                max_retention_days: self.max_retention_days,
                lock_date: self.lock_date,
            }
        }
    }
}
impl BackupVaultListMember {
    /// Creates a new builder-style object to manufacture [`BackupVaultListMember`](crate::model::BackupVaultListMember)
    pub fn builder() -> crate::model::backup_vault_list_member::Builder {
        crate::model::backup_vault_list_member::Builder::default()
    }
}

/// <p>Contains metadata about a <code>BackupSelection</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupSelectionsListMember {
    /// <p>Uniquely identifies a request to assign a set of resources to a backup plan.</p>
    pub selection_id: std::option::Option<std::string::String>,
    /// <p>The display name of a resource selection document.</p>
    pub selection_name: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point;
    /// for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
}
impl BackupSelectionsListMember {
    /// <p>Uniquely identifies a request to assign a set of resources to a backup plan.</p>
    pub fn selection_id(&self) -> std::option::Option<&str> {
        self.selection_id.as_deref()
    }
    /// <p>The display name of a resource selection document.</p>
    pub fn selection_name(&self) -> std::option::Option<&str> {
        self.selection_name.as_deref()
    }
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point;
    /// for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
}
impl std::fmt::Debug for BackupSelectionsListMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupSelectionsListMember");
        formatter.field("selection_id", &self.selection_id);
        formatter.field("selection_name", &self.selection_name);
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.finish()
    }
}
/// See [`BackupSelectionsListMember`](crate::model::BackupSelectionsListMember)
pub mod backup_selections_list_member {
    /// A builder for [`BackupSelectionsListMember`](crate::model::BackupSelectionsListMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selection_id: std::option::Option<std::string::String>,
        pub(crate) selection_name: std::option::Option<std::string::String>,
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a request to assign a set of resources to a backup plan.</p>
        pub fn selection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a request to assign a set of resources to a backup plan.</p>
        pub fn set_selection_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.selection_id = input;
            self
        }
        /// <p>The display name of a resource selection document.</p>
        pub fn selection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_name = Some(input.into());
            self
        }
        /// <p>The display name of a resource selection document.</p>
        pub fn set_selection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_name = input;
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a backup plan is created, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point;
        /// for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point;
        /// for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupSelectionsListMember`](crate::model::BackupSelectionsListMember)
        pub fn build(self) -> crate::model::BackupSelectionsListMember {
            crate::model::BackupSelectionsListMember {
                selection_id: self.selection_id,
                selection_name: self.selection_name,
                backup_plan_id: self.backup_plan_id,
                creation_date: self.creation_date,
                creator_request_id: self.creator_request_id,
                iam_role_arn: self.iam_role_arn,
            }
        }
    }
}
impl BackupSelectionsListMember {
    /// Creates a new builder-style object to manufacture [`BackupSelectionsListMember`](crate::model::BackupSelectionsListMember)
    pub fn builder() -> crate::model::backup_selections_list_member::Builder {
        crate::model::backup_selections_list_member::Builder::default()
    }
}

/// <p>Contains metadata about a backup plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupPlansListMember {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub backup_plan_arn: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a backup plan.</p>
    pub backup_plan_id: std::option::Option<std::string::String>,
    /// <p>The date and time a resource backup plan is created, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub deletion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
    /// long. Version IDs cannot be edited.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The display name of a saved backup plan.</p>
    pub backup_plan_name: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The last time a job to back up resources was run with this rule. A date and time, in
    /// Unix format and Coordinated Universal Time (UTC). The value of
    /// <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value
    /// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub last_execution_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains a list of <code>BackupOptions</code> for a resource type.</p>
    pub advanced_backup_settings:
        std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
}
impl BackupPlansListMember {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
    pub fn backup_plan_arn(&self) -> std::option::Option<&str> {
        self.backup_plan_arn.as_deref()
    }
    /// <p>Uniquely identifies a backup plan.</p>
    pub fn backup_plan_id(&self) -> std::option::Option<&str> {
        self.backup_plan_id.as_deref()
    }
    /// <p>The date and time a resource backup plan is created, in Unix format and Coordinated
    /// Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds.
    /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal
    /// Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For
    /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
    /// AM.</p>
    pub fn deletion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deletion_date.as_ref()
    }
    /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
    /// long. Version IDs cannot be edited.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The display name of a saved backup plan.</p>
    pub fn backup_plan_name(&self) -> std::option::Option<&str> {
        self.backup_plan_name.as_deref()
    }
    /// <p>A unique string that identifies the request and allows failed requests to be retried
    /// without the risk of running the operation twice.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The last time a job to back up resources was run with this rule. A date and time, in
    /// Unix format and Coordinated Universal Time (UTC). The value of
    /// <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value
    /// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn last_execution_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_execution_date.as_ref()
    }
    /// <p>Contains a list of <code>BackupOptions</code> for a resource type.</p>
    pub fn advanced_backup_settings(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedBackupSetting]> {
        self.advanced_backup_settings.as_deref()
    }
}
impl std::fmt::Debug for BackupPlansListMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupPlansListMember");
        formatter.field("backup_plan_arn", &self.backup_plan_arn);
        formatter.field("backup_plan_id", &self.backup_plan_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("deletion_date", &self.deletion_date);
        formatter.field("version_id", &self.version_id);
        formatter.field("backup_plan_name", &self.backup_plan_name);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("last_execution_date", &self.last_execution_date);
        formatter.field("advanced_backup_settings", &self.advanced_backup_settings);
        formatter.finish()
    }
}
/// See [`BackupPlansListMember`](crate::model::BackupPlansListMember)
pub mod backup_plans_list_member {
    /// A builder for [`BackupPlansListMember`](crate::model::BackupPlansListMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_arn: std::option::Option<std::string::String>,
        pub(crate) backup_plan_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deletion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_name: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) last_execution_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) advanced_backup_settings:
            std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn backup_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>
        pub fn set_backup_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_arn = input;
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_id = input;
            self
        }
        /// <p>The date and time a resource backup plan is created, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a resource backup plan is created, in Unix format and Coordinated
        /// Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds.
        /// For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn deletion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deletion_date = Some(input);
            self
        }
        /// <p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal
        /// Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For
        /// example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
        /// AM.</p>
        pub fn set_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deletion_date = input;
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
        /// long. Version IDs cannot be edited.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
        /// long. Version IDs cannot be edited.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The display name of a saved backup plan.</p>
        pub fn backup_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_name = Some(input.into());
            self
        }
        /// <p>The display name of a saved backup plan.</p>
        pub fn set_backup_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_name = input;
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The last time a job to back up resources was run with this rule. A date and time, in
        /// Unix format and Coordinated Universal Time (UTC). The value of
        /// <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value
        /// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn last_execution_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_execution_date = Some(input);
            self
        }
        /// <p>The last time a job to back up resources was run with this rule. A date and time, in
        /// Unix format and Coordinated Universal Time (UTC). The value of
        /// <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value
        /// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_last_execution_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_execution_date = input;
            self
        }
        /// Appends an item to `advanced_backup_settings`.
        ///
        /// To override the contents of this collection use [`set_advanced_backup_settings`](Self::set_advanced_backup_settings).
        ///
        /// <p>Contains a list of <code>BackupOptions</code> for a resource type.</p>
        pub fn advanced_backup_settings(
            mut self,
            input: impl Into<crate::model::AdvancedBackupSetting>,
        ) -> Self {
            let mut v = self.advanced_backup_settings.unwrap_or_default();
            v.push(input.into());
            self.advanced_backup_settings = Some(v);
            self
        }
        /// <p>Contains a list of <code>BackupOptions</code> for a resource type.</p>
        pub fn set_advanced_backup_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
        ) -> Self {
            self.advanced_backup_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupPlansListMember`](crate::model::BackupPlansListMember)
        pub fn build(self) -> crate::model::BackupPlansListMember {
            crate::model::BackupPlansListMember {
                backup_plan_arn: self.backup_plan_arn,
                backup_plan_id: self.backup_plan_id,
                creation_date: self.creation_date,
                deletion_date: self.deletion_date,
                version_id: self.version_id,
                backup_plan_name: self.backup_plan_name,
                creator_request_id: self.creator_request_id,
                last_execution_date: self.last_execution_date,
                advanced_backup_settings: self.advanced_backup_settings,
            }
        }
    }
}
impl BackupPlansListMember {
    /// Creates a new builder-style object to manufacture [`BackupPlansListMember`](crate::model::BackupPlansListMember)
    pub fn builder() -> crate::model::backup_plans_list_member::Builder {
        crate::model::backup_plans_list_member::Builder::default()
    }
}

/// <p>An object specifying metadata associated with a backup plan template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupPlanTemplatesListMember {
    /// <p>Uniquely identifies a stored backup plan template.</p>
    pub backup_plan_template_id: std::option::Option<std::string::String>,
    /// <p>The optional display name of a backup plan template.</p>
    pub backup_plan_template_name: std::option::Option<std::string::String>,
}
impl BackupPlanTemplatesListMember {
    /// <p>Uniquely identifies a stored backup plan template.</p>
    pub fn backup_plan_template_id(&self) -> std::option::Option<&str> {
        self.backup_plan_template_id.as_deref()
    }
    /// <p>The optional display name of a backup plan template.</p>
    pub fn backup_plan_template_name(&self) -> std::option::Option<&str> {
        self.backup_plan_template_name.as_deref()
    }
}
impl std::fmt::Debug for BackupPlanTemplatesListMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupPlanTemplatesListMember");
        formatter.field("backup_plan_template_id", &self.backup_plan_template_id);
        formatter.field("backup_plan_template_name", &self.backup_plan_template_name);
        formatter.finish()
    }
}
/// See [`BackupPlanTemplatesListMember`](crate::model::BackupPlanTemplatesListMember)
pub mod backup_plan_templates_list_member {
    /// A builder for [`BackupPlanTemplatesListMember`](crate::model::BackupPlanTemplatesListMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_template_id: std::option::Option<std::string::String>,
        pub(crate) backup_plan_template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Uniquely identifies a stored backup plan template.</p>
        pub fn backup_plan_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_template_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a stored backup plan template.</p>
        pub fn set_backup_plan_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_template_id = input;
            self
        }
        /// <p>The optional display name of a backup plan template.</p>
        pub fn backup_plan_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_template_name = Some(input.into());
            self
        }
        /// <p>The optional display name of a backup plan template.</p>
        pub fn set_backup_plan_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupPlanTemplatesListMember`](crate::model::BackupPlanTemplatesListMember)
        pub fn build(self) -> crate::model::BackupPlanTemplatesListMember {
            crate::model::BackupPlanTemplatesListMember {
                backup_plan_template_id: self.backup_plan_template_id,
                backup_plan_template_name: self.backup_plan_template_name,
            }
        }
    }
}
impl BackupPlanTemplatesListMember {
    /// Creates a new builder-style object to manufacture [`BackupPlanTemplatesListMember`](crate::model::BackupPlanTemplatesListMember)
    pub fn builder() -> crate::model::backup_plan_templates_list_member::Builder {
        crate::model::backup_plan_templates_list_member::Builder::default()
    }
}

/// <p>Contains detailed information about a backup job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupJob {
    /// <p>The account ID that owns the backup job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub backup_job_id: std::option::Option<std::string::String>,
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub backup_vault_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub backup_vault_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
    /// resource type.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The date and time a backup job is created, in Unix format and Coordinated Universal Time
    /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time a job to create a backup job is completed, in Unix format and
    /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of a resource recovery point.</p>
    pub state: std::option::Option<crate::model::BackupJobState>,
    /// <p>A detailed message explaining the status of the job to back up a resource.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Contains an estimated percentage complete of a job at the time the job status was
    /// queried.</p>
    pub percent_done: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of a backup.</p>
    pub backup_size_in_bytes: std::option::Option<i64>,
    /// <p>Specifies the IAM role ARN used to create the target recovery point. IAM roles other
    /// than the default role must include either <code>AWSBackup</code> or <code>AwsBackup</code>
    /// in the role name. For example,
    /// <code>arn:aws:iam::123456789012:role/AWSBackupRDSAccess</code>. Role names without those
    /// strings lack permissions to perform backup jobs.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>Contains identifying information about the creation of a backup job, including the
    /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
    /// and <code>BackupRuleId</code> of the backup plan used to create it.</p>
    pub created_by: std::option::Option<crate::model::RecoveryPointCreator>,
    /// <p>The date and time a job to back up resources is expected to be completed, in Unix format
    /// and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is
    /// accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January
    /// 26, 2018 12:11:30.087 AM.</p>
    pub expected_completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job
    /// must be started before it is canceled. The value is calculated by adding the start window
    /// to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2
    /// hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of
    /// <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087
    /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub start_by: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
    /// supported resource type is Amazon EC2.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The size in bytes transferred to a backup vault at the time that the job status was
    /// queried.</p>
    pub bytes_transferred: std::option::Option<i64>,
    /// <p>Specifies the backup option for a selected resource. This option is only available for
    /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
    /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
    /// <code>"WindowsVSS":"disabled"</code> to create a regular backup. If you specify an
    /// invalid option, you get an <code>InvalidParameterValueException</code> exception.</p>
    pub backup_options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the type of backup for a backup job.</p>
    pub backup_type: std::option::Option<std::string::String>,
}
impl BackupJob {
    /// <p>The account ID that owns the backup job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
    pub fn backup_job_id(&self) -> std::option::Option<&str> {
        self.backup_job_id.as_deref()
    }
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn backup_vault_name(&self) -> std::option::Option<&str> {
        self.backup_vault_name.as_deref()
    }
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
    pub fn backup_vault_arn(&self) -> std::option::Option<&str> {
        self.backup_vault_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a recovery point; for example,
    /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
    pub fn recovery_point_arn(&self) -> std::option::Option<&str> {
        self.recovery_point_arn.as_deref()
    }
    /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
    /// resource type.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The date and time a backup job is created, in Unix format and Coordinated Universal Time
    /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
    /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time a job to create a backup job is completed, in Unix format and
    /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
    /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
    /// 12:11:30.087 AM.</p>
    pub fn completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_date.as_ref()
    }
    /// <p>The current state of a resource recovery point.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::BackupJobState> {
        self.state.as_ref()
    }
    /// <p>A detailed message explaining the status of the job to back up a resource.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Contains an estimated percentage complete of a job at the time the job status was
    /// queried.</p>
    pub fn percent_done(&self) -> std::option::Option<&str> {
        self.percent_done.as_deref()
    }
    /// <p>The size, in bytes, of a backup.</p>
    pub fn backup_size_in_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_in_bytes
    }
    /// <p>Specifies the IAM role ARN used to create the target recovery point. IAM roles other
    /// than the default role must include either <code>AWSBackup</code> or <code>AwsBackup</code>
    /// in the role name. For example,
    /// <code>arn:aws:iam::123456789012:role/AWSBackupRDSAccess</code>. Role names without those
    /// strings lack permissions to perform backup jobs.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>Contains identifying information about the creation of a backup job, including the
    /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
    /// and <code>BackupRuleId</code> of the backup plan used to create it.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::RecoveryPointCreator> {
        self.created_by.as_ref()
    }
    /// <p>The date and time a job to back up resources is expected to be completed, in Unix format
    /// and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is
    /// accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January
    /// 26, 2018 12:11:30.087 AM.</p>
    pub fn expected_completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expected_completion_date.as_ref()
    }
    /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job
    /// must be started before it is canceled. The value is calculated by adding the start window
    /// to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2
    /// hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of
    /// <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087
    /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn start_by(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_by.as_ref()
    }
    /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
    /// supported resource type is Amazon EC2.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The size in bytes transferred to a backup vault at the time that the job status was
    /// queried.</p>
    pub fn bytes_transferred(&self) -> std::option::Option<i64> {
        self.bytes_transferred
    }
    /// <p>Specifies the backup option for a selected resource. This option is only available for
    /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
    /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
    /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
    /// <code>"WindowsVSS":"disabled"</code> to create a regular backup. If you specify an
    /// invalid option, you get an <code>InvalidParameterValueException</code> exception.</p>
    pub fn backup_options(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.backup_options.as_ref()
    }
    /// <p>Represents the type of backup for a backup job.</p>
    pub fn backup_type(&self) -> std::option::Option<&str> {
        self.backup_type.as_deref()
    }
}
impl std::fmt::Debug for BackupJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupJob");
        formatter.field("account_id", &self.account_id);
        formatter.field("backup_job_id", &self.backup_job_id);
        formatter.field("backup_vault_name", &self.backup_vault_name);
        formatter.field("backup_vault_arn", &self.backup_vault_arn);
        formatter.field("recovery_point_arn", &self.recovery_point_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("state", &self.state);
        formatter.field("status_message", &self.status_message);
        formatter.field("percent_done", &self.percent_done);
        formatter.field("backup_size_in_bytes", &self.backup_size_in_bytes);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("created_by", &self.created_by);
        formatter.field("expected_completion_date", &self.expected_completion_date);
        formatter.field("start_by", &self.start_by);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("bytes_transferred", &self.bytes_transferred);
        formatter.field("backup_options", &self.backup_options);
        formatter.field("backup_type", &self.backup_type);
        formatter.finish()
    }
}
/// See [`BackupJob`](crate::model::BackupJob)
pub mod backup_job {
    /// A builder for [`BackupJob`](crate::model::BackupJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) backup_job_id: std::option::Option<std::string::String>,
        pub(crate) backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) backup_vault_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::BackupJobState>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) percent_done: std::option::Option<std::string::String>,
        pub(crate) backup_size_in_bytes: std::option::Option<i64>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::RecoveryPointCreator>,
        pub(crate) expected_completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_by: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) bytes_transferred: std::option::Option<i64>,
        pub(crate) backup_options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) backup_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID that owns the backup job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID that owns the backup job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn backup_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_job_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn set_backup_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_job_id = input;
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_name = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn backup_vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_vault_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_vault_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_point_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_point_arn = input;
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The date and time a backup job is created, in Unix format and Coordinated Universal Time
        /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time a backup job is created, in Unix format and Coordinated Universal Time
        /// (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the
        /// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time a job to create a backup job is completed, in Unix format and
        /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_date = Some(input);
            self
        }
        /// <p>The date and time a job to create a backup job is completed, in Unix format and
        /// Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to
        /// milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
        /// 12:11:30.087 AM.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>The current state of a resource recovery point.</p>
        pub fn state(mut self, input: crate::model::BackupJobState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of a resource recovery point.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::BackupJobState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>A detailed message explaining the status of the job to back up a resource.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A detailed message explaining the status of the job to back up a resource.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Contains an estimated percentage complete of a job at the time the job status was
        /// queried.</p>
        pub fn percent_done(mut self, input: impl Into<std::string::String>) -> Self {
            self.percent_done = Some(input.into());
            self
        }
        /// <p>Contains an estimated percentage complete of a job at the time the job status was
        /// queried.</p>
        pub fn set_percent_done(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.percent_done = input;
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn backup_size_in_bytes(mut self, input: i64) -> Self {
            self.backup_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of a backup.</p>
        pub fn set_backup_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_in_bytes = input;
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point. IAM roles other
        /// than the default role must include either <code>AWSBackup</code> or <code>AwsBackup</code>
        /// in the role name. For example,
        /// <code>arn:aws:iam::123456789012:role/AWSBackupRDSAccess</code>. Role names without those
        /// strings lack permissions to perform backup jobs.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point. IAM roles other
        /// than the default role must include either <code>AWSBackup</code> or <code>AwsBackup</code>
        /// in the role name. For example,
        /// <code>arn:aws:iam::123456789012:role/AWSBackupRDSAccess</code>. Role names without those
        /// strings lack permissions to perform backup jobs.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>Contains identifying information about the creation of a backup job, including the
        /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
        /// and <code>BackupRuleId</code> of the backup plan used to create it.</p>
        pub fn created_by(mut self, input: crate::model::RecoveryPointCreator) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Contains identifying information about the creation of a backup job, including the
        /// <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>,
        /// and <code>BackupRuleId</code> of the backup plan used to create it.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::RecoveryPointCreator>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time a job to back up resources is expected to be completed, in Unix format
        /// and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is
        /// accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January
        /// 26, 2018 12:11:30.087 AM.</p>
        pub fn expected_completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expected_completion_date = Some(input);
            self
        }
        /// <p>The date and time a job to back up resources is expected to be completed, in Unix format
        /// and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is
        /// accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January
        /// 26, 2018 12:11:30.087 AM.</p>
        pub fn set_expected_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expected_completion_date = input;
            self
        }
        /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job
        /// must be started before it is canceled. The value is calculated by adding the start window
        /// to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2
        /// hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of
        /// <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087
        /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn start_by(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_by = Some(input);
            self
        }
        /// <p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job
        /// must be started before it is canceled. The value is calculated by adding the start window
        /// to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2
        /// hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of
        /// <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087
        /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_start_by(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_by = input;
            self
        }
        /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
        /// supported resource type is Amazon EC2.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
        /// supported resource type is Amazon EC2.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The size in bytes transferred to a backup vault at the time that the job status was
        /// queried.</p>
        pub fn bytes_transferred(mut self, input: i64) -> Self {
            self.bytes_transferred = Some(input);
            self
        }
        /// <p>The size in bytes transferred to a backup vault at the time that the job status was
        /// queried.</p>
        pub fn set_bytes_transferred(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_transferred = input;
            self
        }
        /// Adds a key-value pair to `backup_options`.
        ///
        /// To override the contents of this collection use [`set_backup_options`](Self::set_backup_options).
        ///
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
        /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
        /// <code>"WindowsVSS":"disabled"</code> to create a regular backup. If you specify an
        /// invalid option, you get an <code>InvalidParameterValueException</code> exception.</p>
        pub fn backup_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.backup_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.backup_options = Some(hash_map);
            self
        }
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
        /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
        /// <code>"WindowsVSS":"disabled"</code> to create a regular backup. If you specify an
        /// invalid option, you get an <code>InvalidParameterValueException</code> exception.</p>
        pub fn set_backup_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.backup_options = input;
            self
        }
        /// <p>Represents the type of backup for a backup job.</p>
        pub fn backup_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_type = Some(input.into());
            self
        }
        /// <p>Represents the type of backup for a backup job.</p>
        pub fn set_backup_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_type = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupJob`](crate::model::BackupJob)
        pub fn build(self) -> crate::model::BackupJob {
            crate::model::BackupJob {
                account_id: self.account_id,
                backup_job_id: self.backup_job_id,
                backup_vault_name: self.backup_vault_name,
                backup_vault_arn: self.backup_vault_arn,
                recovery_point_arn: self.recovery_point_arn,
                resource_arn: self.resource_arn,
                creation_date: self.creation_date,
                completion_date: self.completion_date,
                state: self.state,
                status_message: self.status_message,
                percent_done: self.percent_done,
                backup_size_in_bytes: self.backup_size_in_bytes,
                iam_role_arn: self.iam_role_arn,
                created_by: self.created_by,
                expected_completion_date: self.expected_completion_date,
                start_by: self.start_by,
                resource_type: self.resource_type,
                bytes_transferred: self.bytes_transferred,
                backup_options: self.backup_options,
                backup_type: self.backup_type,
            }
        }
    }
}
impl BackupJob {
    /// Creates a new builder-style object to manufacture [`BackupJob`](crate::model::BackupJob)
    pub fn builder() -> crate::model::backup_job::Builder {
        crate::model::backup_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupJobState {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Aborting,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupJobState {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => BackupJobState::Aborted,
            "ABORTING" => BackupJobState::Aborting,
            "COMPLETED" => BackupJobState::Completed,
            "CREATED" => BackupJobState::Created,
            "EXPIRED" => BackupJobState::Expired,
            "FAILED" => BackupJobState::Failed,
            "PENDING" => BackupJobState::Pending,
            "RUNNING" => BackupJobState::Running,
            other => BackupJobState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupJobState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupJobState::from(s))
    }
}
impl BackupJobState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupJobState::Aborted => "ABORTED",
            BackupJobState::Aborting => "ABORTING",
            BackupJobState::Completed => "COMPLETED",
            BackupJobState::Created => "CREATED",
            BackupJobState::Expired => "EXPIRED",
            BackupJobState::Failed => "FAILED",
            BackupJobState::Pending => "PENDING",
            BackupJobState::Running => "RUNNING",
            BackupJobState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ABORTED",
            "ABORTING",
            "COMPLETED",
            "CREATED",
            "EXPIRED",
            "FAILED",
            "PENDING",
            "RUNNING",
        ]
    }
}
impl AsRef<str> for BackupJobState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Used to specify a set of resources to a backup plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupSelection {
    /// <p>The display name of a resource selection document.</p>
    pub selection_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that Backup uses to authenticate when backing up the
    /// target resource; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>An array of strings that contain Amazon Resource Names (ARNs)
    ///
    /// of resources to assign to a backup plan.</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of conditions used to specify a set of resources to assign to a backup plan;
    /// for example, <code>"StringEquals": {"ec2:ResourceTag/Department": "accounting"</code>.
    /// Assigns the backup plan to every resource with at least one matching tag.</p>
    pub list_of_tags: std::option::Option<std::vec::Vec<crate::model::Condition>>,
    #[allow(missing_docs)] // documentation missing in model
    pub not_resources: std::option::Option<std::vec::Vec<std::string::String>>,
    #[allow(missing_docs)] // documentation missing in model
    pub conditions: std::option::Option<crate::model::Conditions>,
}
impl BackupSelection {
    /// <p>The display name of a resource selection document.</p>
    pub fn selection_name(&self) -> std::option::Option<&str> {
        self.selection_name.as_deref()
    }
    /// <p>The ARN of the IAM role that Backup uses to authenticate when backing up the
    /// target resource; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>An array of strings that contain Amazon Resource Names (ARNs)
    ///
    /// of resources to assign to a backup plan.</p>
    pub fn resources(&self) -> std::option::Option<&[std::string::String]> {
        self.resources.as_deref()
    }
    /// <p>An array of conditions used to specify a set of resources to assign to a backup plan;
    /// for example, <code>"StringEquals": {"ec2:ResourceTag/Department": "accounting"</code>.
    /// Assigns the backup plan to every resource with at least one matching tag.</p>
    pub fn list_of_tags(&self) -> std::option::Option<&[crate::model::Condition]> {
        self.list_of_tags.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn not_resources(&self) -> std::option::Option<&[std::string::String]> {
        self.not_resources.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn conditions(&self) -> std::option::Option<&crate::model::Conditions> {
        self.conditions.as_ref()
    }
}
impl std::fmt::Debug for BackupSelection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupSelection");
        formatter.field("selection_name", &self.selection_name);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("resources", &self.resources);
        formatter.field("list_of_tags", &self.list_of_tags);
        formatter.field("not_resources", &self.not_resources);
        formatter.field("conditions", &self.conditions);
        formatter.finish()
    }
}
/// See [`BackupSelection`](crate::model::BackupSelection)
pub mod backup_selection {
    /// A builder for [`BackupSelection`](crate::model::BackupSelection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selection_name: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) list_of_tags: std::option::Option<std::vec::Vec<crate::model::Condition>>,
        pub(crate) not_resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) conditions: std::option::Option<crate::model::Conditions>,
    }
    impl Builder {
        /// <p>The display name of a resource selection document.</p>
        pub fn selection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.selection_name = Some(input.into());
            self
        }
        /// <p>The display name of a resource selection document.</p>
        pub fn set_selection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selection_name = input;
            self
        }
        /// <p>The ARN of the IAM role that Backup uses to authenticate when backing up the
        /// target resource; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that Backup uses to authenticate when backing up the
        /// target resource; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>An array of strings that contain Amazon Resource Names (ARNs)
        ///
        /// of resources to assign to a backup plan.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>An array of strings that contain Amazon Resource Names (ARNs)
        ///
        /// of resources to assign to a backup plan.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `list_of_tags`.
        ///
        /// To override the contents of this collection use [`set_list_of_tags`](Self::set_list_of_tags).
        ///
        /// <p>An array of conditions used to specify a set of resources to assign to a backup plan;
        /// for example, <code>"StringEquals": {"ec2:ResourceTag/Department": "accounting"</code>.
        /// Assigns the backup plan to every resource with at least one matching tag.</p>
        pub fn list_of_tags(mut self, input: impl Into<crate::model::Condition>) -> Self {
            let mut v = self.list_of_tags.unwrap_or_default();
            v.push(input.into());
            self.list_of_tags = Some(v);
            self
        }
        /// <p>An array of conditions used to specify a set of resources to assign to a backup plan;
        /// for example, <code>"StringEquals": {"ec2:ResourceTag/Department": "accounting"</code>.
        /// Assigns the backup plan to every resource with at least one matching tag.</p>
        pub fn set_list_of_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Condition>>,
        ) -> Self {
            self.list_of_tags = input;
            self
        }
        /// Appends an item to `not_resources`.
        ///
        /// To override the contents of this collection use [`set_not_resources`](Self::set_not_resources).
        ///
        pub fn not_resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_resources.unwrap_or_default();
            v.push(input.into());
            self.not_resources = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_not_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_resources = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn conditions(mut self, input: crate::model::Conditions) -> Self {
            self.conditions = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_conditions(
            mut self,
            input: std::option::Option<crate::model::Conditions>,
        ) -> Self {
            self.conditions = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupSelection`](crate::model::BackupSelection)
        pub fn build(self) -> crate::model::BackupSelection {
            crate::model::BackupSelection {
                selection_name: self.selection_name,
                iam_role_arn: self.iam_role_arn,
                resources: self.resources,
                list_of_tags: self.list_of_tags,
                not_resources: self.not_resources,
                conditions: self.conditions,
            }
        }
    }
}
impl BackupSelection {
    /// Creates a new builder-style object to manufacture [`BackupSelection`](crate::model::BackupSelection)
    pub fn builder() -> crate::model::backup_selection::Builder {
        crate::model::backup_selection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Conditions {
    #[allow(missing_docs)] // documentation missing in model
    pub string_equals: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
    #[allow(missing_docs)] // documentation missing in model
    pub string_not_equals: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
    #[allow(missing_docs)] // documentation missing in model
    pub string_like: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
    #[allow(missing_docs)] // documentation missing in model
    pub string_not_like: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
}
impl Conditions {
    #[allow(missing_docs)] // documentation missing in model
    pub fn string_equals(&self) -> std::option::Option<&[crate::model::ConditionParameter]> {
        self.string_equals.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn string_not_equals(&self) -> std::option::Option<&[crate::model::ConditionParameter]> {
        self.string_not_equals.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn string_like(&self) -> std::option::Option<&[crate::model::ConditionParameter]> {
        self.string_like.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn string_not_like(&self) -> std::option::Option<&[crate::model::ConditionParameter]> {
        self.string_not_like.as_deref()
    }
}
impl std::fmt::Debug for Conditions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Conditions");
        formatter.field("string_equals", &self.string_equals);
        formatter.field("string_not_equals", &self.string_not_equals);
        formatter.field("string_like", &self.string_like);
        formatter.field("string_not_like", &self.string_not_like);
        formatter.finish()
    }
}
/// See [`Conditions`](crate::model::Conditions)
pub mod conditions {
    /// A builder for [`Conditions`](crate::model::Conditions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) string_equals:
            std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
        pub(crate) string_not_equals:
            std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
        pub(crate) string_like:
            std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
        pub(crate) string_not_like:
            std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
    }
    impl Builder {
        /// Appends an item to `string_equals`.
        ///
        /// To override the contents of this collection use [`set_string_equals`](Self::set_string_equals).
        ///
        pub fn string_equals(mut self, input: impl Into<crate::model::ConditionParameter>) -> Self {
            let mut v = self.string_equals.unwrap_or_default();
            v.push(input.into());
            self.string_equals = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_string_equals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
        ) -> Self {
            self.string_equals = input;
            self
        }
        /// Appends an item to `string_not_equals`.
        ///
        /// To override the contents of this collection use [`set_string_not_equals`](Self::set_string_not_equals).
        ///
        pub fn string_not_equals(
            mut self,
            input: impl Into<crate::model::ConditionParameter>,
        ) -> Self {
            let mut v = self.string_not_equals.unwrap_or_default();
            v.push(input.into());
            self.string_not_equals = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_string_not_equals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
        ) -> Self {
            self.string_not_equals = input;
            self
        }
        /// Appends an item to `string_like`.
        ///
        /// To override the contents of this collection use [`set_string_like`](Self::set_string_like).
        ///
        pub fn string_like(mut self, input: impl Into<crate::model::ConditionParameter>) -> Self {
            let mut v = self.string_like.unwrap_or_default();
            v.push(input.into());
            self.string_like = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_string_like(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
        ) -> Self {
            self.string_like = input;
            self
        }
        /// Appends an item to `string_not_like`.
        ///
        /// To override the contents of this collection use [`set_string_not_like`](Self::set_string_not_like).
        ///
        pub fn string_not_like(
            mut self,
            input: impl Into<crate::model::ConditionParameter>,
        ) -> Self {
            let mut v = self.string_not_like.unwrap_or_default();
            v.push(input.into());
            self.string_not_like = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_string_not_like(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConditionParameter>>,
        ) -> Self {
            self.string_not_like = input;
            self
        }
        /// Consumes the builder and constructs a [`Conditions`](crate::model::Conditions)
        pub fn build(self) -> crate::model::Conditions {
            crate::model::Conditions {
                string_equals: self.string_equals,
                string_not_equals: self.string_not_equals,
                string_like: self.string_like,
                string_not_like: self.string_not_like,
            }
        }
    }
}
impl Conditions {
    /// Creates a new builder-style object to manufacture [`Conditions`](crate::model::Conditions)
    pub fn builder() -> crate::model::conditions::Builder {
        crate::model::conditions::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConditionParameter {
    #[allow(missing_docs)] // documentation missing in model
    pub condition_key: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub condition_value: std::option::Option<std::string::String>,
}
impl ConditionParameter {
    #[allow(missing_docs)] // documentation missing in model
    pub fn condition_key(&self) -> std::option::Option<&str> {
        self.condition_key.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn condition_value(&self) -> std::option::Option<&str> {
        self.condition_value.as_deref()
    }
}
impl std::fmt::Debug for ConditionParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConditionParameter");
        formatter.field("condition_key", &self.condition_key);
        formatter.field("condition_value", &self.condition_value);
        formatter.finish()
    }
}
/// See [`ConditionParameter`](crate::model::ConditionParameter)
pub mod condition_parameter {
    /// A builder for [`ConditionParameter`](crate::model::ConditionParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition_key: std::option::Option<std::string::String>,
        pub(crate) condition_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn condition_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_key = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_condition_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_key = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn condition_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_value = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_condition_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ConditionParameter`](crate::model::ConditionParameter)
        pub fn build(self) -> crate::model::ConditionParameter {
            crate::model::ConditionParameter {
                condition_key: self.condition_key,
                condition_value: self.condition_value,
            }
        }
    }
}
impl ConditionParameter {
    /// Creates a new builder-style object to manufacture [`ConditionParameter`](crate::model::ConditionParameter)
    pub fn builder() -> crate::model::condition_parameter::Builder {
        crate::model::condition_parameter::Builder::default()
    }
}

/// <p>Contains an array of triplets made up of a condition type (such as
/// <code>StringEquals</code>), a key, and a value. Conditions are used to filter resources
/// in a selection that is assigned to a backup plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Condition {
    /// <p>An operation, such as <code>StringEquals</code>, that is applied to a key-value pair
    /// used to filter resources in a selection.</p>
    pub condition_type: std::option::Option<crate::model::ConditionType>,
    /// <p>The key in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
    /// "accounting"</code>, <code>"ec2:ResourceTag/Department"</code> is the key.</p>
    pub condition_key: std::option::Option<std::string::String>,
    /// <p>The value in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
    /// "accounting"</code>, <code>"accounting"</code> is the value.</p>
    pub condition_value: std::option::Option<std::string::String>,
}
impl Condition {
    /// <p>An operation, such as <code>StringEquals</code>, that is applied to a key-value pair
    /// used to filter resources in a selection.</p>
    pub fn condition_type(&self) -> std::option::Option<&crate::model::ConditionType> {
        self.condition_type.as_ref()
    }
    /// <p>The key in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
    /// "accounting"</code>, <code>"ec2:ResourceTag/Department"</code> is the key.</p>
    pub fn condition_key(&self) -> std::option::Option<&str> {
        self.condition_key.as_deref()
    }
    /// <p>The value in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
    /// "accounting"</code>, <code>"accounting"</code> is the value.</p>
    pub fn condition_value(&self) -> std::option::Option<&str> {
        self.condition_value.as_deref()
    }
}
impl std::fmt::Debug for Condition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Condition");
        formatter.field("condition_type", &self.condition_type);
        formatter.field("condition_key", &self.condition_key);
        formatter.field("condition_value", &self.condition_value);
        formatter.finish()
    }
}
/// See [`Condition`](crate::model::Condition)
pub mod condition {
    /// A builder for [`Condition`](crate::model::Condition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition_type: std::option::Option<crate::model::ConditionType>,
        pub(crate) condition_key: std::option::Option<std::string::String>,
        pub(crate) condition_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An operation, such as <code>StringEquals</code>, that is applied to a key-value pair
        /// used to filter resources in a selection.</p>
        pub fn condition_type(mut self, input: crate::model::ConditionType) -> Self {
            self.condition_type = Some(input);
            self
        }
        /// <p>An operation, such as <code>StringEquals</code>, that is applied to a key-value pair
        /// used to filter resources in a selection.</p>
        pub fn set_condition_type(
            mut self,
            input: std::option::Option<crate::model::ConditionType>,
        ) -> Self {
            self.condition_type = input;
            self
        }
        /// <p>The key in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
        /// "accounting"</code>, <code>"ec2:ResourceTag/Department"</code> is the key.</p>
        pub fn condition_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_key = Some(input.into());
            self
        }
        /// <p>The key in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
        /// "accounting"</code>, <code>"ec2:ResourceTag/Department"</code> is the key.</p>
        pub fn set_condition_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_key = input;
            self
        }
        /// <p>The value in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
        /// "accounting"</code>, <code>"accounting"</code> is the value.</p>
        pub fn condition_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_value = Some(input.into());
            self
        }
        /// <p>The value in a key-value pair. For example, in <code>"ec2:ResourceTag/Department":
        /// "accounting"</code>, <code>"accounting"</code> is the value.</p>
        pub fn set_condition_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Condition`](crate::model::Condition)
        pub fn build(self) -> crate::model::Condition {
            crate::model::Condition {
                condition_type: self.condition_type,
                condition_key: self.condition_key,
                condition_value: self.condition_value,
            }
        }
    }
}
impl Condition {
    /// Creates a new builder-style object to manufacture [`Condition`](crate::model::Condition)
    pub fn builder() -> crate::model::condition::Builder {
        crate::model::condition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConditionType {
    #[allow(missing_docs)] // documentation missing in model
    Stringequals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConditionType {
    fn from(s: &str) -> Self {
        match s {
            "STRINGEQUALS" => ConditionType::Stringequals,
            other => ConditionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConditionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConditionType::from(s))
    }
}
impl ConditionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConditionType::Stringequals => "STRINGEQUALS",
            ConditionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STRINGEQUALS"]
    }
}
impl AsRef<str> for ConditionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains an optional backup plan display name and an array of <code>BackupRule</code>
/// objects, each of which specifies a backup rule. Each rule in a backup plan is a separate
/// scheduled task and can back up a different selection of Amazon Web Services
/// resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupPlan {
    /// <p>The display name of a backup plan.</p>
    pub backup_plan_name: std::option::Option<std::string::String>,
    /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
    /// that is used to back up a selection of resources. </p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::BackupRule>>,
    /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
    pub advanced_backup_settings:
        std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
}
impl BackupPlan {
    /// <p>The display name of a backup plan.</p>
    pub fn backup_plan_name(&self) -> std::option::Option<&str> {
        self.backup_plan_name.as_deref()
    }
    /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
    /// that is used to back up a selection of resources. </p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::BackupRule]> {
        self.rules.as_deref()
    }
    /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
    pub fn advanced_backup_settings(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedBackupSetting]> {
        self.advanced_backup_settings.as_deref()
    }
}
impl std::fmt::Debug for BackupPlan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupPlan");
        formatter.field("backup_plan_name", &self.backup_plan_name);
        formatter.field("rules", &self.rules);
        formatter.field("advanced_backup_settings", &self.advanced_backup_settings);
        formatter.finish()
    }
}
/// See [`BackupPlan`](crate::model::BackupPlan)
pub mod backup_plan {
    /// A builder for [`BackupPlan`](crate::model::BackupPlan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_plan_name: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::BackupRule>>,
        pub(crate) advanced_backup_settings:
            std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
    }
    impl Builder {
        /// <p>The display name of a backup plan.</p>
        pub fn backup_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_plan_name = Some(input.into());
            self
        }
        /// <p>The display name of a backup plan.</p>
        pub fn set_backup_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_plan_name = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
        /// that is used to back up a selection of resources. </p>
        pub fn rules(mut self, input: impl Into<crate::model::BackupRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task
        /// that is used to back up a selection of resources. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Appends an item to `advanced_backup_settings`.
        ///
        /// To override the contents of this collection use [`set_advanced_backup_settings`](Self::set_advanced_backup_settings).
        ///
        /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
        pub fn advanced_backup_settings(
            mut self,
            input: impl Into<crate::model::AdvancedBackupSetting>,
        ) -> Self {
            let mut v = self.advanced_backup_settings.unwrap_or_default();
            v.push(input.into());
            self.advanced_backup_settings = Some(v);
            self
        }
        /// <p>Contains a list of <code>BackupOptions</code> for each resource type.</p>
        pub fn set_advanced_backup_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedBackupSetting>>,
        ) -> Self {
            self.advanced_backup_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupPlan`](crate::model::BackupPlan)
        pub fn build(self) -> crate::model::BackupPlan {
            crate::model::BackupPlan {
                backup_plan_name: self.backup_plan_name,
                rules: self.rules,
                advanced_backup_settings: self.advanced_backup_settings,
            }
        }
    }
}
impl BackupPlan {
    /// Creates a new builder-style object to manufacture [`BackupPlan`](crate::model::BackupPlan)
    pub fn builder() -> crate::model::backup_plan::Builder {
        crate::model::backup_plan::Builder::default()
    }
}

/// <p>Specifies a scheduled task used to back up a selection of resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupRule {
    /// <p>An optional display name for a backup rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub target_backup_vault_name: std::option::Option<std::string::String>,
    /// <p>A cron expression in UTC specifying when Backup initiates a backup job. For
    /// more information about cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User
    /// Guide.</i>. Prior to specifying a value for this parameter, we recommend testing
    /// your cron expression using one of the many available cron generator and testing
    /// tools.</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
    /// doesn't start successfully. This value is optional.</p>
    pub start_window_minutes: std::option::Option<i64>,
    /// <p>A value in minutes after a backup job is successfully started before it must be
    /// completed or it will be canceled by Backup. This value is optional.</p>
    pub completion_window_minutes: std::option::Option<i64>,
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup transitions and expires backups automatically according to
    /// the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub lifecycle: std::option::Option<crate::model::Lifecycle>,
    /// <p>An array of key-value pair strings that are assigned to resources that are associated
    /// with this rule when restored from backup.</p>
    pub recovery_point_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Uniquely identifies a rule that is used to schedule the backup of a selection of
    /// resources.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
    /// operation.</p>
    pub copy_actions: std::option::Option<std::vec::Vec<crate::model::CopyAction>>,
    /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
    /// (or not specified) causes Backup to create snapshot backups.</p>
    pub enable_continuous_backup: std::option::Option<bool>,
}
impl BackupRule {
    /// <p>An optional display name for a backup rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The name of a logical container where backups are stored. Backup vaults are identified
    /// by names that are unique to the account used to create them and the Amazon Web Services
    /// Region where they are created. They consist of lowercase letters, numbers, and
    /// hyphens.</p>
    pub fn target_backup_vault_name(&self) -> std::option::Option<&str> {
        self.target_backup_vault_name.as_deref()
    }
    /// <p>A cron expression in UTC specifying when Backup initiates a backup job. For
    /// more information about cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User
    /// Guide.</i>. Prior to specifying a value for this parameter, we recommend testing
    /// your cron expression using one of the many available cron generator and testing
    /// tools.</p>
    pub fn schedule_expression(&self) -> std::option::Option<&str> {
        self.schedule_expression.as_deref()
    }
    /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
    /// doesn't start successfully. This value is optional.</p>
    pub fn start_window_minutes(&self) -> std::option::Option<i64> {
        self.start_window_minutes
    }
    /// <p>A value in minutes after a backup job is successfully started before it must be
    /// completed or it will be canceled by Backup. This value is optional.</p>
    pub fn completion_window_minutes(&self) -> std::option::Option<i64> {
        self.completion_window_minutes
    }
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup transitions and expires backups automatically according to
    /// the lifecycle that you define. </p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold. </p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::Lifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>An array of key-value pair strings that are assigned to resources that are associated
    /// with this rule when restored from backup.</p>
    pub fn recovery_point_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.recovery_point_tags.as_ref()
    }
    /// <p>Uniquely identifies a rule that is used to schedule the backup of a selection of
    /// resources.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
    /// operation.</p>
    pub fn copy_actions(&self) -> std::option::Option<&[crate::model::CopyAction]> {
        self.copy_actions.as_deref()
    }
    /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
    /// (or not specified) causes Backup to create snapshot backups.</p>
    pub fn enable_continuous_backup(&self) -> std::option::Option<bool> {
        self.enable_continuous_backup
    }
}
impl std::fmt::Debug for BackupRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupRule");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("target_backup_vault_name", &self.target_backup_vault_name);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("start_window_minutes", &self.start_window_minutes);
        formatter.field("completion_window_minutes", &self.completion_window_minutes);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("recovery_point_tags", &"*** Sensitive Data Redacted ***");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("copy_actions", &self.copy_actions);
        formatter.field("enable_continuous_backup", &self.enable_continuous_backup);
        formatter.finish()
    }
}
/// See [`BackupRule`](crate::model::BackupRule)
pub mod backup_rule {
    /// A builder for [`BackupRule`](crate::model::BackupRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) target_backup_vault_name: std::option::Option<std::string::String>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) start_window_minutes: std::option::Option<i64>,
        pub(crate) completion_window_minutes: std::option::Option<i64>,
        pub(crate) lifecycle: std::option::Option<crate::model::Lifecycle>,
        pub(crate) recovery_point_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) copy_actions: std::option::Option<std::vec::Vec<crate::model::CopyAction>>,
        pub(crate) enable_continuous_backup: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An optional display name for a backup rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>An optional display name for a backup rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn target_backup_vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_backup_vault_name = Some(input.into());
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_target_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_backup_vault_name = input;
            self
        }
        /// <p>A cron expression in UTC specifying when Backup initiates a backup job. For
        /// more information about cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User
        /// Guide.</i>. Prior to specifying a value for this parameter, we recommend testing
        /// your cron expression using one of the many available cron generator and testing
        /// tools.</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A cron expression in UTC specifying when Backup initiates a backup job. For
        /// more information about cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User
        /// Guide.</i>. Prior to specifying a value for this parameter, we recommend testing
        /// your cron expression using one of the many available cron generator and testing
        /// tools.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional.</p>
        pub fn start_window_minutes(mut self, input: i64) -> Self {
            self.start_window_minutes = Some(input);
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional.</p>
        pub fn set_start_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.start_window_minutes = input;
            self
        }
        /// <p>A value in minutes after a backup job is successfully started before it must be
        /// completed or it will be canceled by Backup. This value is optional.</p>
        pub fn completion_window_minutes(mut self, input: i64) -> Self {
            self.completion_window_minutes = Some(input);
            self
        }
        /// <p>A value in minutes after a backup job is successfully started before it must be
        /// completed or it will be canceled by Backup. This value is optional.</p>
        pub fn set_completion_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.completion_window_minutes = input;
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, input: crate::model::Lifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Adds a key-value pair to `recovery_point_tags`.
        ///
        /// To override the contents of this collection use [`set_recovery_point_tags`](Self::set_recovery_point_tags).
        ///
        /// <p>An array of key-value pair strings that are assigned to resources that are associated
        /// with this rule when restored from backup.</p>
        pub fn recovery_point_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.recovery_point_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.recovery_point_tags = Some(hash_map);
            self
        }
        /// <p>An array of key-value pair strings that are assigned to resources that are associated
        /// with this rule when restored from backup.</p>
        pub fn set_recovery_point_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.recovery_point_tags = input;
            self
        }
        /// <p>Uniquely identifies a rule that is used to schedule the backup of a selection of
        /// resources.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>Uniquely identifies a rule that is used to schedule the backup of a selection of
        /// resources.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// Appends an item to `copy_actions`.
        ///
        /// To override the contents of this collection use [`set_copy_actions`](Self::set_copy_actions).
        ///
        /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
        /// operation.</p>
        pub fn copy_actions(mut self, input: impl Into<crate::model::CopyAction>) -> Self {
            let mut v = self.copy_actions.unwrap_or_default();
            v.push(input.into());
            self.copy_actions = Some(v);
            self
        }
        /// <p>An array of <code>CopyAction</code> objects, which contains the details of the copy
        /// operation.</p>
        pub fn set_copy_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CopyAction>>,
        ) -> Self {
            self.copy_actions = input;
            self
        }
        /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
        /// (or not specified) causes Backup to create snapshot backups.</p>
        pub fn enable_continuous_backup(mut self, input: bool) -> Self {
            self.enable_continuous_backup = Some(input);
            self
        }
        /// <p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False
        /// (or not specified) causes Backup to create snapshot backups.</p>
        pub fn set_enable_continuous_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_continuous_backup = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupRule`](crate::model::BackupRule)
        pub fn build(self) -> crate::model::BackupRule {
            crate::model::BackupRule {
                rule_name: self.rule_name,
                target_backup_vault_name: self.target_backup_vault_name,
                schedule_expression: self.schedule_expression,
                start_window_minutes: self.start_window_minutes,
                completion_window_minutes: self.completion_window_minutes,
                lifecycle: self.lifecycle,
                recovery_point_tags: self.recovery_point_tags,
                rule_id: self.rule_id,
                copy_actions: self.copy_actions,
                enable_continuous_backup: self.enable_continuous_backup,
            }
        }
    }
}
impl BackupRule {
    /// Creates a new builder-style object to manufacture [`BackupRule`](crate::model::BackupRule)
    pub fn builder() -> crate::model::backup_rule::Builder {
        crate::model::backup_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageClass {
    #[allow(missing_docs)] // documentation missing in model
    Cold,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Warm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageClass {
    fn from(s: &str) -> Self {
        match s {
            "COLD" => StorageClass::Cold,
            "DELETED" => StorageClass::Deleted,
            "WARM" => StorageClass::Warm,
            other => StorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageClass::from(s))
    }
}
impl StorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageClass::Cold => "COLD",
            StorageClass::Deleted => "DELETED",
            StorageClass::Warm => "WARM",
            StorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COLD", "DELETED", "WARM"]
    }
}
impl AsRef<str> for StorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
