// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateBackupPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backup_plan`](crate::client::Client::create_backup_plan).
///
/// See [`crate::client::fluent_builders::CreateBackupPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackupPlan {
    _private: (),
}
impl CreateBackupPlan {
    /// Creates a new builder-style object to manufacture [`CreateBackupPlanInput`](crate::input::CreateBackupPlanInput)
    pub fn builder() -> crate::input::create_backup_plan_input::Builder {
        crate::input::create_backup_plan_input::Builder::default()
    }
    /// Creates a new `CreateBackupPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackupPlan {
    type Output = std::result::Result<
        crate::output::CreateBackupPlanOutput,
        crate::error::CreateBackupPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backup_plan_error(response)
        } else {
            crate::operation_deser::parse_create_backup_plan_response(response)
        }
    }
}

/// Operation shape for `CreateBackupSelection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backup_selection`](crate::client::Client::create_backup_selection).
///
/// See [`crate::client::fluent_builders::CreateBackupSelection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackupSelection {
    _private: (),
}
impl CreateBackupSelection {
    /// Creates a new builder-style object to manufacture [`CreateBackupSelectionInput`](crate::input::CreateBackupSelectionInput)
    pub fn builder() -> crate::input::create_backup_selection_input::Builder {
        crate::input::create_backup_selection_input::Builder::default()
    }
    /// Creates a new `CreateBackupSelection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackupSelection {
    type Output = std::result::Result<
        crate::output::CreateBackupSelectionOutput,
        crate::error::CreateBackupSelectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backup_selection_error(response)
        } else {
            crate::operation_deser::parse_create_backup_selection_response(response)
        }
    }
}

/// Operation shape for `CreateBackupVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backup_vault`](crate::client::Client::create_backup_vault).
///
/// See [`crate::client::fluent_builders::CreateBackupVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackupVault {
    _private: (),
}
impl CreateBackupVault {
    /// Creates a new builder-style object to manufacture [`CreateBackupVaultInput`](crate::input::CreateBackupVaultInput)
    pub fn builder() -> crate::input::create_backup_vault_input::Builder {
        crate::input::create_backup_vault_input::Builder::default()
    }
    /// Creates a new `CreateBackupVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackupVault {
    type Output = std::result::Result<
        crate::output::CreateBackupVaultOutput,
        crate::error::CreateBackupVaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backup_vault_error(response)
        } else {
            crate::operation_deser::parse_create_backup_vault_response(response)
        }
    }
}

/// Operation shape for `CreateFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_framework`](crate::client::Client::create_framework).
///
/// See [`crate::client::fluent_builders::CreateFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFramework {
    _private: (),
}
impl CreateFramework {
    /// Creates a new builder-style object to manufacture [`CreateFrameworkInput`](crate::input::CreateFrameworkInput)
    pub fn builder() -> crate::input::create_framework_input::Builder {
        crate::input::create_framework_input::Builder::default()
    }
    /// Creates a new `CreateFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFramework {
    type Output = std::result::Result<
        crate::output::CreateFrameworkOutput,
        crate::error::CreateFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_framework_error(response)
        } else {
            crate::operation_deser::parse_create_framework_response(response)
        }
    }
}

/// Operation shape for `CreateReportPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_report_plan`](crate::client::Client::create_report_plan).
///
/// See [`crate::client::fluent_builders::CreateReportPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReportPlan {
    _private: (),
}
impl CreateReportPlan {
    /// Creates a new builder-style object to manufacture [`CreateReportPlanInput`](crate::input::CreateReportPlanInput)
    pub fn builder() -> crate::input::create_report_plan_input::Builder {
        crate::input::create_report_plan_input::Builder::default()
    }
    /// Creates a new `CreateReportPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReportPlan {
    type Output = std::result::Result<
        crate::output::CreateReportPlanOutput,
        crate::error::CreateReportPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_report_plan_error(response)
        } else {
            crate::operation_deser::parse_create_report_plan_response(response)
        }
    }
}

/// Operation shape for `DeleteBackupPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup_plan`](crate::client::Client::delete_backup_plan).
///
/// See [`crate::client::fluent_builders::DeleteBackupPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackupPlan {
    _private: (),
}
impl DeleteBackupPlan {
    /// Creates a new builder-style object to manufacture [`DeleteBackupPlanInput`](crate::input::DeleteBackupPlanInput)
    pub fn builder() -> crate::input::delete_backup_plan_input::Builder {
        crate::input::delete_backup_plan_input::Builder::default()
    }
    /// Creates a new `DeleteBackupPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackupPlan {
    type Output = std::result::Result<
        crate::output::DeleteBackupPlanOutput,
        crate::error::DeleteBackupPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_plan_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_plan_response(response)
        }
    }
}

/// Operation shape for `DeleteBackupSelection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup_selection`](crate::client::Client::delete_backup_selection).
///
/// See [`crate::client::fluent_builders::DeleteBackupSelection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackupSelection {
    _private: (),
}
impl DeleteBackupSelection {
    /// Creates a new builder-style object to manufacture [`DeleteBackupSelectionInput`](crate::input::DeleteBackupSelectionInput)
    pub fn builder() -> crate::input::delete_backup_selection_input::Builder {
        crate::input::delete_backup_selection_input::Builder::default()
    }
    /// Creates a new `DeleteBackupSelection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackupSelection {
    type Output = std::result::Result<
        crate::output::DeleteBackupSelectionOutput,
        crate::error::DeleteBackupSelectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_selection_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_selection_response(response)
        }
    }
}

/// Operation shape for `DeleteBackupVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup_vault`](crate::client::Client::delete_backup_vault).
///
/// See [`crate::client::fluent_builders::DeleteBackupVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackupVault {
    _private: (),
}
impl DeleteBackupVault {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultInput`](crate::input::DeleteBackupVaultInput)
    pub fn builder() -> crate::input::delete_backup_vault_input::Builder {
        crate::input::delete_backup_vault_input::Builder::default()
    }
    /// Creates a new `DeleteBackupVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackupVault {
    type Output = std::result::Result<
        crate::output::DeleteBackupVaultOutput,
        crate::error::DeleteBackupVaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_vault_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_vault_response(response)
        }
    }
}

/// Operation shape for `DeleteBackupVaultAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup_vault_access_policy`](crate::client::Client::delete_backup_vault_access_policy).
///
/// See [`crate::client::fluent_builders::DeleteBackupVaultAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackupVaultAccessPolicy {
    _private: (),
}
impl DeleteBackupVaultAccessPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultAccessPolicyInput`](crate::input::DeleteBackupVaultAccessPolicyInput)
    pub fn builder() -> crate::input::delete_backup_vault_access_policy_input::Builder {
        crate::input::delete_backup_vault_access_policy_input::Builder::default()
    }
    /// Creates a new `DeleteBackupVaultAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackupVaultAccessPolicy {
    type Output = std::result::Result<
        crate::output::DeleteBackupVaultAccessPolicyOutput,
        crate::error::DeleteBackupVaultAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_vault_access_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_vault_access_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteBackupVaultLockConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup_vault_lock_configuration`](crate::client::Client::delete_backup_vault_lock_configuration).
///
/// See [`crate::client::fluent_builders::DeleteBackupVaultLockConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackupVaultLockConfiguration {
    _private: (),
}
impl DeleteBackupVaultLockConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultLockConfigurationInput`](crate::input::DeleteBackupVaultLockConfigurationInput)
    pub fn builder() -> crate::input::delete_backup_vault_lock_configuration_input::Builder {
        crate::input::delete_backup_vault_lock_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteBackupVaultLockConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackupVaultLockConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteBackupVaultLockConfigurationOutput,
        crate::error::DeleteBackupVaultLockConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_vault_lock_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_vault_lock_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteBackupVaultNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup_vault_notifications`](crate::client::Client::delete_backup_vault_notifications).
///
/// See [`crate::client::fluent_builders::DeleteBackupVaultNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackupVaultNotifications {
    _private: (),
}
impl DeleteBackupVaultNotifications {
    /// Creates a new builder-style object to manufacture [`DeleteBackupVaultNotificationsInput`](crate::input::DeleteBackupVaultNotificationsInput)
    pub fn builder() -> crate::input::delete_backup_vault_notifications_input::Builder {
        crate::input::delete_backup_vault_notifications_input::Builder::default()
    }
    /// Creates a new `DeleteBackupVaultNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackupVaultNotifications {
    type Output = std::result::Result<
        crate::output::DeleteBackupVaultNotificationsOutput,
        crate::error::DeleteBackupVaultNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_vault_notifications_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_vault_notifications_response(response)
        }
    }
}

/// Operation shape for `DeleteFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_framework`](crate::client::Client::delete_framework).
///
/// See [`crate::client::fluent_builders::DeleteFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFramework {
    _private: (),
}
impl DeleteFramework {
    /// Creates a new builder-style object to manufacture [`DeleteFrameworkInput`](crate::input::DeleteFrameworkInput)
    pub fn builder() -> crate::input::delete_framework_input::Builder {
        crate::input::delete_framework_input::Builder::default()
    }
    /// Creates a new `DeleteFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFramework {
    type Output = std::result::Result<
        crate::output::DeleteFrameworkOutput,
        crate::error::DeleteFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_framework_error(response)
        } else {
            crate::operation_deser::parse_delete_framework_response(response)
        }
    }
}

/// Operation shape for `DeleteRecoveryPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_recovery_point`](crate::client::Client::delete_recovery_point).
///
/// See [`crate::client::fluent_builders::DeleteRecoveryPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRecoveryPoint {
    _private: (),
}
impl DeleteRecoveryPoint {
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryPointInput`](crate::input::DeleteRecoveryPointInput)
    pub fn builder() -> crate::input::delete_recovery_point_input::Builder {
        crate::input::delete_recovery_point_input::Builder::default()
    }
    /// Creates a new `DeleteRecoveryPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRecoveryPoint {
    type Output = std::result::Result<
        crate::output::DeleteRecoveryPointOutput,
        crate::error::DeleteRecoveryPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_recovery_point_error(response)
        } else {
            crate::operation_deser::parse_delete_recovery_point_response(response)
        }
    }
}

/// Operation shape for `DeleteReportPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_report_plan`](crate::client::Client::delete_report_plan).
///
/// See [`crate::client::fluent_builders::DeleteReportPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReportPlan {
    _private: (),
}
impl DeleteReportPlan {
    /// Creates a new builder-style object to manufacture [`DeleteReportPlanInput`](crate::input::DeleteReportPlanInput)
    pub fn builder() -> crate::input::delete_report_plan_input::Builder {
        crate::input::delete_report_plan_input::Builder::default()
    }
    /// Creates a new `DeleteReportPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReportPlan {
    type Output = std::result::Result<
        crate::output::DeleteReportPlanOutput,
        crate::error::DeleteReportPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_report_plan_error(response)
        } else {
            crate::operation_deser::parse_delete_report_plan_response(response)
        }
    }
}

/// Operation shape for `DescribeBackupJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_backup_job`](crate::client::Client::describe_backup_job).
///
/// See [`crate::client::fluent_builders::DescribeBackupJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBackupJob {
    _private: (),
}
impl DescribeBackupJob {
    /// Creates a new builder-style object to manufacture [`DescribeBackupJobInput`](crate::input::DescribeBackupJobInput)
    pub fn builder() -> crate::input::describe_backup_job_input::Builder {
        crate::input::describe_backup_job_input::Builder::default()
    }
    /// Creates a new `DescribeBackupJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBackupJob {
    type Output = std::result::Result<
        crate::output::DescribeBackupJobOutput,
        crate::error::DescribeBackupJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_backup_job_error(response)
        } else {
            crate::operation_deser::parse_describe_backup_job_response(response)
        }
    }
}

/// Operation shape for `DescribeBackupVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_backup_vault`](crate::client::Client::describe_backup_vault).
///
/// See [`crate::client::fluent_builders::DescribeBackupVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBackupVault {
    _private: (),
}
impl DescribeBackupVault {
    /// Creates a new builder-style object to manufacture [`DescribeBackupVaultInput`](crate::input::DescribeBackupVaultInput)
    pub fn builder() -> crate::input::describe_backup_vault_input::Builder {
        crate::input::describe_backup_vault_input::Builder::default()
    }
    /// Creates a new `DescribeBackupVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBackupVault {
    type Output = std::result::Result<
        crate::output::DescribeBackupVaultOutput,
        crate::error::DescribeBackupVaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_backup_vault_error(response)
        } else {
            crate::operation_deser::parse_describe_backup_vault_response(response)
        }
    }
}

/// Operation shape for `DescribeCopyJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_copy_job`](crate::client::Client::describe_copy_job).
///
/// See [`crate::client::fluent_builders::DescribeCopyJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCopyJob {
    _private: (),
}
impl DescribeCopyJob {
    /// Creates a new builder-style object to manufacture [`DescribeCopyJobInput`](crate::input::DescribeCopyJobInput)
    pub fn builder() -> crate::input::describe_copy_job_input::Builder {
        crate::input::describe_copy_job_input::Builder::default()
    }
    /// Creates a new `DescribeCopyJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCopyJob {
    type Output = std::result::Result<
        crate::output::DescribeCopyJobOutput,
        crate::error::DescribeCopyJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_copy_job_error(response)
        } else {
            crate::operation_deser::parse_describe_copy_job_response(response)
        }
    }
}

/// Operation shape for `DescribeFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_framework`](crate::client::Client::describe_framework).
///
/// See [`crate::client::fluent_builders::DescribeFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFramework {
    _private: (),
}
impl DescribeFramework {
    /// Creates a new builder-style object to manufacture [`DescribeFrameworkInput`](crate::input::DescribeFrameworkInput)
    pub fn builder() -> crate::input::describe_framework_input::Builder {
        crate::input::describe_framework_input::Builder::default()
    }
    /// Creates a new `DescribeFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFramework {
    type Output = std::result::Result<
        crate::output::DescribeFrameworkOutput,
        crate::error::DescribeFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_framework_error(response)
        } else {
            crate::operation_deser::parse_describe_framework_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_settings`](crate::client::Client::describe_global_settings).
///
/// See [`crate::client::fluent_builders::DescribeGlobalSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalSettings {
    _private: (),
}
impl DescribeGlobalSettings {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalSettingsInput`](crate::input::DescribeGlobalSettingsInput)
    pub fn builder() -> crate::input::describe_global_settings_input::Builder {
        crate::input::describe_global_settings_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalSettings {
    type Output = std::result::Result<
        crate::output::DescribeGlobalSettingsOutput,
        crate::error::DescribeGlobalSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_global_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeProtectedResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_protected_resource`](crate::client::Client::describe_protected_resource).
///
/// See [`crate::client::fluent_builders::DescribeProtectedResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProtectedResource {
    _private: (),
}
impl DescribeProtectedResource {
    /// Creates a new builder-style object to manufacture [`DescribeProtectedResourceInput`](crate::input::DescribeProtectedResourceInput)
    pub fn builder() -> crate::input::describe_protected_resource_input::Builder {
        crate::input::describe_protected_resource_input::Builder::default()
    }
    /// Creates a new `DescribeProtectedResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProtectedResource {
    type Output = std::result::Result<
        crate::output::DescribeProtectedResourceOutput,
        crate::error::DescribeProtectedResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_protected_resource_error(response)
        } else {
            crate::operation_deser::parse_describe_protected_resource_response(response)
        }
    }
}

/// Operation shape for `DescribeRecoveryPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_recovery_point`](crate::client::Client::describe_recovery_point).
///
/// See [`crate::client::fluent_builders::DescribeRecoveryPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRecoveryPoint {
    _private: (),
}
impl DescribeRecoveryPoint {
    /// Creates a new builder-style object to manufacture [`DescribeRecoveryPointInput`](crate::input::DescribeRecoveryPointInput)
    pub fn builder() -> crate::input::describe_recovery_point_input::Builder {
        crate::input::describe_recovery_point_input::Builder::default()
    }
    /// Creates a new `DescribeRecoveryPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRecoveryPoint {
    type Output = std::result::Result<
        crate::output::DescribeRecoveryPointOutput,
        crate::error::DescribeRecoveryPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_recovery_point_error(response)
        } else {
            crate::operation_deser::parse_describe_recovery_point_response(response)
        }
    }
}

/// Operation shape for `DescribeRegionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_region_settings`](crate::client::Client::describe_region_settings).
///
/// See [`crate::client::fluent_builders::DescribeRegionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRegionSettings {
    _private: (),
}
impl DescribeRegionSettings {
    /// Creates a new builder-style object to manufacture [`DescribeRegionSettingsInput`](crate::input::DescribeRegionSettingsInput)
    pub fn builder() -> crate::input::describe_region_settings_input::Builder {
        crate::input::describe_region_settings_input::Builder::default()
    }
    /// Creates a new `DescribeRegionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRegionSettings {
    type Output = std::result::Result<
        crate::output::DescribeRegionSettingsOutput,
        crate::error::DescribeRegionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_region_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_region_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeReportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_report_job`](crate::client::Client::describe_report_job).
///
/// See [`crate::client::fluent_builders::DescribeReportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReportJob {
    _private: (),
}
impl DescribeReportJob {
    /// Creates a new builder-style object to manufacture [`DescribeReportJobInput`](crate::input::DescribeReportJobInput)
    pub fn builder() -> crate::input::describe_report_job_input::Builder {
        crate::input::describe_report_job_input::Builder::default()
    }
    /// Creates a new `DescribeReportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReportJob {
    type Output = std::result::Result<
        crate::output::DescribeReportJobOutput,
        crate::error::DescribeReportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_report_job_error(response)
        } else {
            crate::operation_deser::parse_describe_report_job_response(response)
        }
    }
}

/// Operation shape for `DescribeReportPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_report_plan`](crate::client::Client::describe_report_plan).
///
/// See [`crate::client::fluent_builders::DescribeReportPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReportPlan {
    _private: (),
}
impl DescribeReportPlan {
    /// Creates a new builder-style object to manufacture [`DescribeReportPlanInput`](crate::input::DescribeReportPlanInput)
    pub fn builder() -> crate::input::describe_report_plan_input::Builder {
        crate::input::describe_report_plan_input::Builder::default()
    }
    /// Creates a new `DescribeReportPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReportPlan {
    type Output = std::result::Result<
        crate::output::DescribeReportPlanOutput,
        crate::error::DescribeReportPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_report_plan_error(response)
        } else {
            crate::operation_deser::parse_describe_report_plan_response(response)
        }
    }
}

/// Operation shape for `DescribeRestoreJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_restore_job`](crate::client::Client::describe_restore_job).
///
/// See [`crate::client::fluent_builders::DescribeRestoreJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRestoreJob {
    _private: (),
}
impl DescribeRestoreJob {
    /// Creates a new builder-style object to manufacture [`DescribeRestoreJobInput`](crate::input::DescribeRestoreJobInput)
    pub fn builder() -> crate::input::describe_restore_job_input::Builder {
        crate::input::describe_restore_job_input::Builder::default()
    }
    /// Creates a new `DescribeRestoreJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRestoreJob {
    type Output = std::result::Result<
        crate::output::DescribeRestoreJobOutput,
        crate::error::DescribeRestoreJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_restore_job_error(response)
        } else {
            crate::operation_deser::parse_describe_restore_job_response(response)
        }
    }
}

/// Operation shape for `DisassociateRecoveryPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_recovery_point`](crate::client::Client::disassociate_recovery_point).
///
/// See [`crate::client::fluent_builders::DisassociateRecoveryPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateRecoveryPoint {
    _private: (),
}
impl DisassociateRecoveryPoint {
    /// Creates a new builder-style object to manufacture [`DisassociateRecoveryPointInput`](crate::input::DisassociateRecoveryPointInput)
    pub fn builder() -> crate::input::disassociate_recovery_point_input::Builder {
        crate::input::disassociate_recovery_point_input::Builder::default()
    }
    /// Creates a new `DisassociateRecoveryPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateRecoveryPoint {
    type Output = std::result::Result<
        crate::output::DisassociateRecoveryPointOutput,
        crate::error::DisassociateRecoveryPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_recovery_point_error(response)
        } else {
            crate::operation_deser::parse_disassociate_recovery_point_response(response)
        }
    }
}

/// Operation shape for `ExportBackupPlanTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_backup_plan_template`](crate::client::Client::export_backup_plan_template).
///
/// See [`crate::client::fluent_builders::ExportBackupPlanTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportBackupPlanTemplate {
    _private: (),
}
impl ExportBackupPlanTemplate {
    /// Creates a new builder-style object to manufacture [`ExportBackupPlanTemplateInput`](crate::input::ExportBackupPlanTemplateInput)
    pub fn builder() -> crate::input::export_backup_plan_template_input::Builder {
        crate::input::export_backup_plan_template_input::Builder::default()
    }
    /// Creates a new `ExportBackupPlanTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportBackupPlanTemplate {
    type Output = std::result::Result<
        crate::output::ExportBackupPlanTemplateOutput,
        crate::error::ExportBackupPlanTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_backup_plan_template_error(response)
        } else {
            crate::operation_deser::parse_export_backup_plan_template_response(response)
        }
    }
}

/// Operation shape for `GetBackupPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backup_plan`](crate::client::Client::get_backup_plan).
///
/// See [`crate::client::fluent_builders::GetBackupPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackupPlan {
    _private: (),
}
impl GetBackupPlan {
    /// Creates a new builder-style object to manufacture [`GetBackupPlanInput`](crate::input::GetBackupPlanInput)
    pub fn builder() -> crate::input::get_backup_plan_input::Builder {
        crate::input::get_backup_plan_input::Builder::default()
    }
    /// Creates a new `GetBackupPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackupPlan {
    type Output =
        std::result::Result<crate::output::GetBackupPlanOutput, crate::error::GetBackupPlanError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backup_plan_error(response)
        } else {
            crate::operation_deser::parse_get_backup_plan_response(response)
        }
    }
}

/// Operation shape for `GetBackupPlanFromJSON`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backup_plan_from_json`](crate::client::Client::get_backup_plan_from_json).
///
/// See [`crate::client::fluent_builders::GetBackupPlanFromJSON`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackupPlanFromJSON {
    _private: (),
}
impl GetBackupPlanFromJSON {
    /// Creates a new builder-style object to manufacture [`GetBackupPlanFromJsonInput`](crate::input::GetBackupPlanFromJsonInput)
    pub fn builder() -> crate::input::get_backup_plan_from_json_input::Builder {
        crate::input::get_backup_plan_from_json_input::Builder::default()
    }
    /// Creates a new `GetBackupPlanFromJSON` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackupPlanFromJSON {
    type Output = std::result::Result<
        crate::output::GetBackupPlanFromJsonOutput,
        crate::error::GetBackupPlanFromJSONError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backup_plan_from_json_error(response)
        } else {
            crate::operation_deser::parse_get_backup_plan_from_json_response(response)
        }
    }
}

/// Operation shape for `GetBackupPlanFromTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backup_plan_from_template`](crate::client::Client::get_backup_plan_from_template).
///
/// See [`crate::client::fluent_builders::GetBackupPlanFromTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackupPlanFromTemplate {
    _private: (),
}
impl GetBackupPlanFromTemplate {
    /// Creates a new builder-style object to manufacture [`GetBackupPlanFromTemplateInput`](crate::input::GetBackupPlanFromTemplateInput)
    pub fn builder() -> crate::input::get_backup_plan_from_template_input::Builder {
        crate::input::get_backup_plan_from_template_input::Builder::default()
    }
    /// Creates a new `GetBackupPlanFromTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackupPlanFromTemplate {
    type Output = std::result::Result<
        crate::output::GetBackupPlanFromTemplateOutput,
        crate::error::GetBackupPlanFromTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backup_plan_from_template_error(response)
        } else {
            crate::operation_deser::parse_get_backup_plan_from_template_response(response)
        }
    }
}

/// Operation shape for `GetBackupSelection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backup_selection`](crate::client::Client::get_backup_selection).
///
/// See [`crate::client::fluent_builders::GetBackupSelection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackupSelection {
    _private: (),
}
impl GetBackupSelection {
    /// Creates a new builder-style object to manufacture [`GetBackupSelectionInput`](crate::input::GetBackupSelectionInput)
    pub fn builder() -> crate::input::get_backup_selection_input::Builder {
        crate::input::get_backup_selection_input::Builder::default()
    }
    /// Creates a new `GetBackupSelection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackupSelection {
    type Output = std::result::Result<
        crate::output::GetBackupSelectionOutput,
        crate::error::GetBackupSelectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backup_selection_error(response)
        } else {
            crate::operation_deser::parse_get_backup_selection_response(response)
        }
    }
}

/// Operation shape for `GetBackupVaultAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backup_vault_access_policy`](crate::client::Client::get_backup_vault_access_policy).
///
/// See [`crate::client::fluent_builders::GetBackupVaultAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackupVaultAccessPolicy {
    _private: (),
}
impl GetBackupVaultAccessPolicy {
    /// Creates a new builder-style object to manufacture [`GetBackupVaultAccessPolicyInput`](crate::input::GetBackupVaultAccessPolicyInput)
    pub fn builder() -> crate::input::get_backup_vault_access_policy_input::Builder {
        crate::input::get_backup_vault_access_policy_input::Builder::default()
    }
    /// Creates a new `GetBackupVaultAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackupVaultAccessPolicy {
    type Output = std::result::Result<
        crate::output::GetBackupVaultAccessPolicyOutput,
        crate::error::GetBackupVaultAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backup_vault_access_policy_error(response)
        } else {
            crate::operation_deser::parse_get_backup_vault_access_policy_response(response)
        }
    }
}

/// Operation shape for `GetBackupVaultNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_backup_vault_notifications`](crate::client::Client::get_backup_vault_notifications).
///
/// See [`crate::client::fluent_builders::GetBackupVaultNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBackupVaultNotifications {
    _private: (),
}
impl GetBackupVaultNotifications {
    /// Creates a new builder-style object to manufacture [`GetBackupVaultNotificationsInput`](crate::input::GetBackupVaultNotificationsInput)
    pub fn builder() -> crate::input::get_backup_vault_notifications_input::Builder {
        crate::input::get_backup_vault_notifications_input::Builder::default()
    }
    /// Creates a new `GetBackupVaultNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBackupVaultNotifications {
    type Output = std::result::Result<
        crate::output::GetBackupVaultNotificationsOutput,
        crate::error::GetBackupVaultNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_backup_vault_notifications_error(response)
        } else {
            crate::operation_deser::parse_get_backup_vault_notifications_response(response)
        }
    }
}

/// Operation shape for `GetRecoveryPointRestoreMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_recovery_point_restore_metadata`](crate::client::Client::get_recovery_point_restore_metadata).
///
/// See [`crate::client::fluent_builders::GetRecoveryPointRestoreMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecoveryPointRestoreMetadata {
    _private: (),
}
impl GetRecoveryPointRestoreMetadata {
    /// Creates a new builder-style object to manufacture [`GetRecoveryPointRestoreMetadataInput`](crate::input::GetRecoveryPointRestoreMetadataInput)
    pub fn builder() -> crate::input::get_recovery_point_restore_metadata_input::Builder {
        crate::input::get_recovery_point_restore_metadata_input::Builder::default()
    }
    /// Creates a new `GetRecoveryPointRestoreMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecoveryPointRestoreMetadata {
    type Output = std::result::Result<
        crate::output::GetRecoveryPointRestoreMetadataOutput,
        crate::error::GetRecoveryPointRestoreMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_recovery_point_restore_metadata_error(response)
        } else {
            crate::operation_deser::parse_get_recovery_point_restore_metadata_response(response)
        }
    }
}

/// Operation shape for `GetSupportedResourceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_supported_resource_types`](crate::client::Client::get_supported_resource_types).
///
/// See [`crate::client::fluent_builders::GetSupportedResourceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSupportedResourceTypes {
    _private: (),
}
impl GetSupportedResourceTypes {
    /// Creates a new builder-style object to manufacture [`GetSupportedResourceTypesInput`](crate::input::GetSupportedResourceTypesInput)
    pub fn builder() -> crate::input::get_supported_resource_types_input::Builder {
        crate::input::get_supported_resource_types_input::Builder::default()
    }
    /// Creates a new `GetSupportedResourceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSupportedResourceTypes {
    type Output = std::result::Result<
        crate::output::GetSupportedResourceTypesOutput,
        crate::error::GetSupportedResourceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_supported_resource_types_error(response)
        } else {
            crate::operation_deser::parse_get_supported_resource_types_response(response)
        }
    }
}

/// Operation shape for `ListBackupJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backup_jobs`](crate::client::Client::list_backup_jobs).
///
/// See [`crate::client::fluent_builders::ListBackupJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackupJobs {
    _private: (),
}
impl ListBackupJobs {
    /// Creates a new builder-style object to manufacture [`ListBackupJobsInput`](crate::input::ListBackupJobsInput)
    pub fn builder() -> crate::input::list_backup_jobs_input::Builder {
        crate::input::list_backup_jobs_input::Builder::default()
    }
    /// Creates a new `ListBackupJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackupJobs {
    type Output =
        std::result::Result<crate::output::ListBackupJobsOutput, crate::error::ListBackupJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backup_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_backup_jobs_response(response)
        }
    }
}

/// Operation shape for `ListBackupPlans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backup_plans`](crate::client::Client::list_backup_plans).
///
/// See [`crate::client::fluent_builders::ListBackupPlans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackupPlans {
    _private: (),
}
impl ListBackupPlans {
    /// Creates a new builder-style object to manufacture [`ListBackupPlansInput`](crate::input::ListBackupPlansInput)
    pub fn builder() -> crate::input::list_backup_plans_input::Builder {
        crate::input::list_backup_plans_input::Builder::default()
    }
    /// Creates a new `ListBackupPlans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackupPlans {
    type Output = std::result::Result<
        crate::output::ListBackupPlansOutput,
        crate::error::ListBackupPlansError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backup_plans_error(response)
        } else {
            crate::operation_deser::parse_list_backup_plans_response(response)
        }
    }
}

/// Operation shape for `ListBackupPlanTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backup_plan_templates`](crate::client::Client::list_backup_plan_templates).
///
/// See [`crate::client::fluent_builders::ListBackupPlanTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackupPlanTemplates {
    _private: (),
}
impl ListBackupPlanTemplates {
    /// Creates a new builder-style object to manufacture [`ListBackupPlanTemplatesInput`](crate::input::ListBackupPlanTemplatesInput)
    pub fn builder() -> crate::input::list_backup_plan_templates_input::Builder {
        crate::input::list_backup_plan_templates_input::Builder::default()
    }
    /// Creates a new `ListBackupPlanTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackupPlanTemplates {
    type Output = std::result::Result<
        crate::output::ListBackupPlanTemplatesOutput,
        crate::error::ListBackupPlanTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backup_plan_templates_error(response)
        } else {
            crate::operation_deser::parse_list_backup_plan_templates_response(response)
        }
    }
}

/// Operation shape for `ListBackupPlanVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backup_plan_versions`](crate::client::Client::list_backup_plan_versions).
///
/// See [`crate::client::fluent_builders::ListBackupPlanVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackupPlanVersions {
    _private: (),
}
impl ListBackupPlanVersions {
    /// Creates a new builder-style object to manufacture [`ListBackupPlanVersionsInput`](crate::input::ListBackupPlanVersionsInput)
    pub fn builder() -> crate::input::list_backup_plan_versions_input::Builder {
        crate::input::list_backup_plan_versions_input::Builder::default()
    }
    /// Creates a new `ListBackupPlanVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackupPlanVersions {
    type Output = std::result::Result<
        crate::output::ListBackupPlanVersionsOutput,
        crate::error::ListBackupPlanVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backup_plan_versions_error(response)
        } else {
            crate::operation_deser::parse_list_backup_plan_versions_response(response)
        }
    }
}

/// Operation shape for `ListBackupSelections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backup_selections`](crate::client::Client::list_backup_selections).
///
/// See [`crate::client::fluent_builders::ListBackupSelections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackupSelections {
    _private: (),
}
impl ListBackupSelections {
    /// Creates a new builder-style object to manufacture [`ListBackupSelectionsInput`](crate::input::ListBackupSelectionsInput)
    pub fn builder() -> crate::input::list_backup_selections_input::Builder {
        crate::input::list_backup_selections_input::Builder::default()
    }
    /// Creates a new `ListBackupSelections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackupSelections {
    type Output = std::result::Result<
        crate::output::ListBackupSelectionsOutput,
        crate::error::ListBackupSelectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backup_selections_error(response)
        } else {
            crate::operation_deser::parse_list_backup_selections_response(response)
        }
    }
}

/// Operation shape for `ListBackupVaults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backup_vaults`](crate::client::Client::list_backup_vaults).
///
/// See [`crate::client::fluent_builders::ListBackupVaults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackupVaults {
    _private: (),
}
impl ListBackupVaults {
    /// Creates a new builder-style object to manufacture [`ListBackupVaultsInput`](crate::input::ListBackupVaultsInput)
    pub fn builder() -> crate::input::list_backup_vaults_input::Builder {
        crate::input::list_backup_vaults_input::Builder::default()
    }
    /// Creates a new `ListBackupVaults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackupVaults {
    type Output = std::result::Result<
        crate::output::ListBackupVaultsOutput,
        crate::error::ListBackupVaultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backup_vaults_error(response)
        } else {
            crate::operation_deser::parse_list_backup_vaults_response(response)
        }
    }
}

/// Operation shape for `ListCopyJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_copy_jobs`](crate::client::Client::list_copy_jobs).
///
/// See [`crate::client::fluent_builders::ListCopyJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCopyJobs {
    _private: (),
}
impl ListCopyJobs {
    /// Creates a new builder-style object to manufacture [`ListCopyJobsInput`](crate::input::ListCopyJobsInput)
    pub fn builder() -> crate::input::list_copy_jobs_input::Builder {
        crate::input::list_copy_jobs_input::Builder::default()
    }
    /// Creates a new `ListCopyJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCopyJobs {
    type Output =
        std::result::Result<crate::output::ListCopyJobsOutput, crate::error::ListCopyJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_copy_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_copy_jobs_response(response)
        }
    }
}

/// Operation shape for `ListFrameworks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_frameworks`](crate::client::Client::list_frameworks).
///
/// See [`crate::client::fluent_builders::ListFrameworks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFrameworks {
    _private: (),
}
impl ListFrameworks {
    /// Creates a new builder-style object to manufacture [`ListFrameworksInput`](crate::input::ListFrameworksInput)
    pub fn builder() -> crate::input::list_frameworks_input::Builder {
        crate::input::list_frameworks_input::Builder::default()
    }
    /// Creates a new `ListFrameworks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFrameworks {
    type Output =
        std::result::Result<crate::output::ListFrameworksOutput, crate::error::ListFrameworksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_frameworks_error(response)
        } else {
            crate::operation_deser::parse_list_frameworks_response(response)
        }
    }
}

/// Operation shape for `ListProtectedResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_protected_resources`](crate::client::Client::list_protected_resources).
///
/// See [`crate::client::fluent_builders::ListProtectedResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProtectedResources {
    _private: (),
}
impl ListProtectedResources {
    /// Creates a new builder-style object to manufacture [`ListProtectedResourcesInput`](crate::input::ListProtectedResourcesInput)
    pub fn builder() -> crate::input::list_protected_resources_input::Builder {
        crate::input::list_protected_resources_input::Builder::default()
    }
    /// Creates a new `ListProtectedResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProtectedResources {
    type Output = std::result::Result<
        crate::output::ListProtectedResourcesOutput,
        crate::error::ListProtectedResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_protected_resources_error(response)
        } else {
            crate::operation_deser::parse_list_protected_resources_response(response)
        }
    }
}

/// Operation shape for `ListRecoveryPointsByBackupVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recovery_points_by_backup_vault`](crate::client::Client::list_recovery_points_by_backup_vault).
///
/// See [`crate::client::fluent_builders::ListRecoveryPointsByBackupVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecoveryPointsByBackupVault {
    _private: (),
}
impl ListRecoveryPointsByBackupVault {
    /// Creates a new builder-style object to manufacture [`ListRecoveryPointsByBackupVaultInput`](crate::input::ListRecoveryPointsByBackupVaultInput)
    pub fn builder() -> crate::input::list_recovery_points_by_backup_vault_input::Builder {
        crate::input::list_recovery_points_by_backup_vault_input::Builder::default()
    }
    /// Creates a new `ListRecoveryPointsByBackupVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecoveryPointsByBackupVault {
    type Output = std::result::Result<
        crate::output::ListRecoveryPointsByBackupVaultOutput,
        crate::error::ListRecoveryPointsByBackupVaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recovery_points_by_backup_vault_error(response)
        } else {
            crate::operation_deser::parse_list_recovery_points_by_backup_vault_response(response)
        }
    }
}

/// Operation shape for `ListRecoveryPointsByResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recovery_points_by_resource`](crate::client::Client::list_recovery_points_by_resource).
///
/// See [`crate::client::fluent_builders::ListRecoveryPointsByResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecoveryPointsByResource {
    _private: (),
}
impl ListRecoveryPointsByResource {
    /// Creates a new builder-style object to manufacture [`ListRecoveryPointsByResourceInput`](crate::input::ListRecoveryPointsByResourceInput)
    pub fn builder() -> crate::input::list_recovery_points_by_resource_input::Builder {
        crate::input::list_recovery_points_by_resource_input::Builder::default()
    }
    /// Creates a new `ListRecoveryPointsByResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecoveryPointsByResource {
    type Output = std::result::Result<
        crate::output::ListRecoveryPointsByResourceOutput,
        crate::error::ListRecoveryPointsByResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recovery_points_by_resource_error(response)
        } else {
            crate::operation_deser::parse_list_recovery_points_by_resource_response(response)
        }
    }
}

/// Operation shape for `ListReportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_report_jobs`](crate::client::Client::list_report_jobs).
///
/// See [`crate::client::fluent_builders::ListReportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReportJobs {
    _private: (),
}
impl ListReportJobs {
    /// Creates a new builder-style object to manufacture [`ListReportJobsInput`](crate::input::ListReportJobsInput)
    pub fn builder() -> crate::input::list_report_jobs_input::Builder {
        crate::input::list_report_jobs_input::Builder::default()
    }
    /// Creates a new `ListReportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReportJobs {
    type Output =
        std::result::Result<crate::output::ListReportJobsOutput, crate::error::ListReportJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_report_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_report_jobs_response(response)
        }
    }
}

/// Operation shape for `ListReportPlans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_report_plans`](crate::client::Client::list_report_plans).
///
/// See [`crate::client::fluent_builders::ListReportPlans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReportPlans {
    _private: (),
}
impl ListReportPlans {
    /// Creates a new builder-style object to manufacture [`ListReportPlansInput`](crate::input::ListReportPlansInput)
    pub fn builder() -> crate::input::list_report_plans_input::Builder {
        crate::input::list_report_plans_input::Builder::default()
    }
    /// Creates a new `ListReportPlans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReportPlans {
    type Output = std::result::Result<
        crate::output::ListReportPlansOutput,
        crate::error::ListReportPlansError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_report_plans_error(response)
        } else {
            crate::operation_deser::parse_list_report_plans_response(response)
        }
    }
}

/// Operation shape for `ListRestoreJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_restore_jobs`](crate::client::Client::list_restore_jobs).
///
/// See [`crate::client::fluent_builders::ListRestoreJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRestoreJobs {
    _private: (),
}
impl ListRestoreJobs {
    /// Creates a new builder-style object to manufacture [`ListRestoreJobsInput`](crate::input::ListRestoreJobsInput)
    pub fn builder() -> crate::input::list_restore_jobs_input::Builder {
        crate::input::list_restore_jobs_input::Builder::default()
    }
    /// Creates a new `ListRestoreJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRestoreJobs {
    type Output = std::result::Result<
        crate::output::ListRestoreJobsOutput,
        crate::error::ListRestoreJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_restore_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_restore_jobs_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `PutBackupVaultAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_backup_vault_access_policy`](crate::client::Client::put_backup_vault_access_policy).
///
/// See [`crate::client::fluent_builders::PutBackupVaultAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBackupVaultAccessPolicy {
    _private: (),
}
impl PutBackupVaultAccessPolicy {
    /// Creates a new builder-style object to manufacture [`PutBackupVaultAccessPolicyInput`](crate::input::PutBackupVaultAccessPolicyInput)
    pub fn builder() -> crate::input::put_backup_vault_access_policy_input::Builder {
        crate::input::put_backup_vault_access_policy_input::Builder::default()
    }
    /// Creates a new `PutBackupVaultAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBackupVaultAccessPolicy {
    type Output = std::result::Result<
        crate::output::PutBackupVaultAccessPolicyOutput,
        crate::error::PutBackupVaultAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_backup_vault_access_policy_error(response)
        } else {
            crate::operation_deser::parse_put_backup_vault_access_policy_response(response)
        }
    }
}

/// Operation shape for `PutBackupVaultLockConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_backup_vault_lock_configuration`](crate::client::Client::put_backup_vault_lock_configuration).
///
/// See [`crate::client::fluent_builders::PutBackupVaultLockConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBackupVaultLockConfiguration {
    _private: (),
}
impl PutBackupVaultLockConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBackupVaultLockConfigurationInput`](crate::input::PutBackupVaultLockConfigurationInput)
    pub fn builder() -> crate::input::put_backup_vault_lock_configuration_input::Builder {
        crate::input::put_backup_vault_lock_configuration_input::Builder::default()
    }
    /// Creates a new `PutBackupVaultLockConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBackupVaultLockConfiguration {
    type Output = std::result::Result<
        crate::output::PutBackupVaultLockConfigurationOutput,
        crate::error::PutBackupVaultLockConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_backup_vault_lock_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_backup_vault_lock_configuration_response(response)
        }
    }
}

/// Operation shape for `PutBackupVaultNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_backup_vault_notifications`](crate::client::Client::put_backup_vault_notifications).
///
/// See [`crate::client::fluent_builders::PutBackupVaultNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBackupVaultNotifications {
    _private: (),
}
impl PutBackupVaultNotifications {
    /// Creates a new builder-style object to manufacture [`PutBackupVaultNotificationsInput`](crate::input::PutBackupVaultNotificationsInput)
    pub fn builder() -> crate::input::put_backup_vault_notifications_input::Builder {
        crate::input::put_backup_vault_notifications_input::Builder::default()
    }
    /// Creates a new `PutBackupVaultNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBackupVaultNotifications {
    type Output = std::result::Result<
        crate::output::PutBackupVaultNotificationsOutput,
        crate::error::PutBackupVaultNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_backup_vault_notifications_error(response)
        } else {
            crate::operation_deser::parse_put_backup_vault_notifications_response(response)
        }
    }
}

/// Operation shape for `StartBackupJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_backup_job`](crate::client::Client::start_backup_job).
///
/// See [`crate::client::fluent_builders::StartBackupJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBackupJob {
    _private: (),
}
impl StartBackupJob {
    /// Creates a new builder-style object to manufacture [`StartBackupJobInput`](crate::input::StartBackupJobInput)
    pub fn builder() -> crate::input::start_backup_job_input::Builder {
        crate::input::start_backup_job_input::Builder::default()
    }
    /// Creates a new `StartBackupJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartBackupJob {
    type Output =
        std::result::Result<crate::output::StartBackupJobOutput, crate::error::StartBackupJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_backup_job_error(response)
        } else {
            crate::operation_deser::parse_start_backup_job_response(response)
        }
    }
}

/// Operation shape for `StartCopyJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_copy_job`](crate::client::Client::start_copy_job).
///
/// See [`crate::client::fluent_builders::StartCopyJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartCopyJob {
    _private: (),
}
impl StartCopyJob {
    /// Creates a new builder-style object to manufacture [`StartCopyJobInput`](crate::input::StartCopyJobInput)
    pub fn builder() -> crate::input::start_copy_job_input::Builder {
        crate::input::start_copy_job_input::Builder::default()
    }
    /// Creates a new `StartCopyJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartCopyJob {
    type Output =
        std::result::Result<crate::output::StartCopyJobOutput, crate::error::StartCopyJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_copy_job_error(response)
        } else {
            crate::operation_deser::parse_start_copy_job_response(response)
        }
    }
}

/// Operation shape for `StartReportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_report_job`](crate::client::Client::start_report_job).
///
/// See [`crate::client::fluent_builders::StartReportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartReportJob {
    _private: (),
}
impl StartReportJob {
    /// Creates a new builder-style object to manufacture [`StartReportJobInput`](crate::input::StartReportJobInput)
    pub fn builder() -> crate::input::start_report_job_input::Builder {
        crate::input::start_report_job_input::Builder::default()
    }
    /// Creates a new `StartReportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartReportJob {
    type Output =
        std::result::Result<crate::output::StartReportJobOutput, crate::error::StartReportJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_report_job_error(response)
        } else {
            crate::operation_deser::parse_start_report_job_response(response)
        }
    }
}

/// Operation shape for `StartRestoreJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_restore_job`](crate::client::Client::start_restore_job).
///
/// See [`crate::client::fluent_builders::StartRestoreJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartRestoreJob {
    _private: (),
}
impl StartRestoreJob {
    /// Creates a new builder-style object to manufacture [`StartRestoreJobInput`](crate::input::StartRestoreJobInput)
    pub fn builder() -> crate::input::start_restore_job_input::Builder {
        crate::input::start_restore_job_input::Builder::default()
    }
    /// Creates a new `StartRestoreJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartRestoreJob {
    type Output = std::result::Result<
        crate::output::StartRestoreJobOutput,
        crate::error::StartRestoreJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_restore_job_error(response)
        } else {
            crate::operation_deser::parse_start_restore_job_response(response)
        }
    }
}

/// Operation shape for `StopBackupJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_backup_job`](crate::client::Client::stop_backup_job).
///
/// See [`crate::client::fluent_builders::StopBackupJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopBackupJob {
    _private: (),
}
impl StopBackupJob {
    /// Creates a new builder-style object to manufacture [`StopBackupJobInput`](crate::input::StopBackupJobInput)
    pub fn builder() -> crate::input::stop_backup_job_input::Builder {
        crate::input::stop_backup_job_input::Builder::default()
    }
    /// Creates a new `StopBackupJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopBackupJob {
    type Output =
        std::result::Result<crate::output::StopBackupJobOutput, crate::error::StopBackupJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_backup_job_error(response)
        } else {
            crate::operation_deser::parse_stop_backup_job_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateBackupPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_backup_plan`](crate::client::Client::update_backup_plan).
///
/// See [`crate::client::fluent_builders::UpdateBackupPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBackupPlan {
    _private: (),
}
impl UpdateBackupPlan {
    /// Creates a new builder-style object to manufacture [`UpdateBackupPlanInput`](crate::input::UpdateBackupPlanInput)
    pub fn builder() -> crate::input::update_backup_plan_input::Builder {
        crate::input::update_backup_plan_input::Builder::default()
    }
    /// Creates a new `UpdateBackupPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBackupPlan {
    type Output = std::result::Result<
        crate::output::UpdateBackupPlanOutput,
        crate::error::UpdateBackupPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_backup_plan_error(response)
        } else {
            crate::operation_deser::parse_update_backup_plan_response(response)
        }
    }
}

/// Operation shape for `UpdateFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_framework`](crate::client::Client::update_framework).
///
/// See [`crate::client::fluent_builders::UpdateFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFramework {
    _private: (),
}
impl UpdateFramework {
    /// Creates a new builder-style object to manufacture [`UpdateFrameworkInput`](crate::input::UpdateFrameworkInput)
    pub fn builder() -> crate::input::update_framework_input::Builder {
        crate::input::update_framework_input::Builder::default()
    }
    /// Creates a new `UpdateFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFramework {
    type Output = std::result::Result<
        crate::output::UpdateFrameworkOutput,
        crate::error::UpdateFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_framework_error(response)
        } else {
            crate::operation_deser::parse_update_framework_response(response)
        }
    }
}

/// Operation shape for `UpdateGlobalSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_global_settings`](crate::client::Client::update_global_settings).
///
/// See [`crate::client::fluent_builders::UpdateGlobalSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGlobalSettings {
    _private: (),
}
impl UpdateGlobalSettings {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalSettingsInput`](crate::input::UpdateGlobalSettingsInput)
    pub fn builder() -> crate::input::update_global_settings_input::Builder {
        crate::input::update_global_settings_input::Builder::default()
    }
    /// Creates a new `UpdateGlobalSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGlobalSettings {
    type Output = std::result::Result<
        crate::output::UpdateGlobalSettingsOutput,
        crate::error::UpdateGlobalSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_global_settings_error(response)
        } else {
            crate::operation_deser::parse_update_global_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateRecoveryPointLifecycle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_recovery_point_lifecycle`](crate::client::Client::update_recovery_point_lifecycle).
///
/// See [`crate::client::fluent_builders::UpdateRecoveryPointLifecycle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRecoveryPointLifecycle {
    _private: (),
}
impl UpdateRecoveryPointLifecycle {
    /// Creates a new builder-style object to manufacture [`UpdateRecoveryPointLifecycleInput`](crate::input::UpdateRecoveryPointLifecycleInput)
    pub fn builder() -> crate::input::update_recovery_point_lifecycle_input::Builder {
        crate::input::update_recovery_point_lifecycle_input::Builder::default()
    }
    /// Creates a new `UpdateRecoveryPointLifecycle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRecoveryPointLifecycle {
    type Output = std::result::Result<
        crate::output::UpdateRecoveryPointLifecycleOutput,
        crate::error::UpdateRecoveryPointLifecycleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_recovery_point_lifecycle_error(response)
        } else {
            crate::operation_deser::parse_update_recovery_point_lifecycle_response(response)
        }
    }
}

/// Operation shape for `UpdateRegionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_region_settings`](crate::client::Client::update_region_settings).
///
/// See [`crate::client::fluent_builders::UpdateRegionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRegionSettings {
    _private: (),
}
impl UpdateRegionSettings {
    /// Creates a new builder-style object to manufacture [`UpdateRegionSettingsInput`](crate::input::UpdateRegionSettingsInput)
    pub fn builder() -> crate::input::update_region_settings_input::Builder {
        crate::input::update_region_settings_input::Builder::default()
    }
    /// Creates a new `UpdateRegionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRegionSettings {
    type Output = std::result::Result<
        crate::output::UpdateRegionSettingsOutput,
        crate::error::UpdateRegionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_region_settings_error(response)
        } else {
            crate::operation_deser::parse_update_region_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateReportPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_report_plan`](crate::client::Client::update_report_plan).
///
/// See [`crate::client::fluent_builders::UpdateReportPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReportPlan {
    _private: (),
}
impl UpdateReportPlan {
    /// Creates a new builder-style object to manufacture [`UpdateReportPlanInput`](crate::input::UpdateReportPlanInput)
    pub fn builder() -> crate::input::update_report_plan_input::Builder {
        crate::input::update_report_plan_input::Builder::default()
    }
    /// Creates a new `UpdateReportPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReportPlan {
    type Output = std::result::Result<
        crate::output::UpdateReportPlanOutput,
        crate::error::UpdateReportPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_report_plan_error(response)
        } else {
            crate::operation_deser::parse_update_report_plan_response(response)
        }
    }
}
