// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CryoControllerUserManager`.
///
/// This client allows ergonomic access to a `CryoControllerUserManager`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateBackupPlan` operation.
    ///
    /// See [`CreateBackupPlan`](crate::client::fluent_builders::CreateBackupPlan) for more information about the
    /// operation and its arguments.
    pub fn create_backup_plan(&self) -> fluent_builders::CreateBackupPlan<C, M, R> {
        fluent_builders::CreateBackupPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackupSelection` operation.
    ///
    /// See [`CreateBackupSelection`](crate::client::fluent_builders::CreateBackupSelection) for more information about the
    /// operation and its arguments.
    pub fn create_backup_selection(&self) -> fluent_builders::CreateBackupSelection<C, M, R> {
        fluent_builders::CreateBackupSelection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBackupVault` operation.
    ///
    /// See [`CreateBackupVault`](crate::client::fluent_builders::CreateBackupVault) for more information about the
    /// operation and its arguments.
    pub fn create_backup_vault(&self) -> fluent_builders::CreateBackupVault<C, M, R> {
        fluent_builders::CreateBackupVault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFramework` operation.
    ///
    /// See [`CreateFramework`](crate::client::fluent_builders::CreateFramework) for more information about the
    /// operation and its arguments.
    pub fn create_framework(&self) -> fluent_builders::CreateFramework<C, M, R> {
        fluent_builders::CreateFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReportPlan` operation.
    ///
    /// See [`CreateReportPlan`](crate::client::fluent_builders::CreateReportPlan) for more information about the
    /// operation and its arguments.
    pub fn create_report_plan(&self) -> fluent_builders::CreateReportPlan<C, M, R> {
        fluent_builders::CreateReportPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackupPlan` operation.
    ///
    /// See [`DeleteBackupPlan`](crate::client::fluent_builders::DeleteBackupPlan) for more information about the
    /// operation and its arguments.
    pub fn delete_backup_plan(&self) -> fluent_builders::DeleteBackupPlan<C, M, R> {
        fluent_builders::DeleteBackupPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackupSelection` operation.
    ///
    /// See [`DeleteBackupSelection`](crate::client::fluent_builders::DeleteBackupSelection) for more information about the
    /// operation and its arguments.
    pub fn delete_backup_selection(&self) -> fluent_builders::DeleteBackupSelection<C, M, R> {
        fluent_builders::DeleteBackupSelection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackupVault` operation.
    ///
    /// See [`DeleteBackupVault`](crate::client::fluent_builders::DeleteBackupVault) for more information about the
    /// operation and its arguments.
    pub fn delete_backup_vault(&self) -> fluent_builders::DeleteBackupVault<C, M, R> {
        fluent_builders::DeleteBackupVault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackupVaultAccessPolicy` operation.
    ///
    /// See [`DeleteBackupVaultAccessPolicy`](crate::client::fluent_builders::DeleteBackupVaultAccessPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_backup_vault_access_policy(
        &self,
    ) -> fluent_builders::DeleteBackupVaultAccessPolicy<C, M, R> {
        fluent_builders::DeleteBackupVaultAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackupVaultLockConfiguration` operation.
    ///
    /// See [`DeleteBackupVaultLockConfiguration`](crate::client::fluent_builders::DeleteBackupVaultLockConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_backup_vault_lock_configuration(
        &self,
    ) -> fluent_builders::DeleteBackupVaultLockConfiguration<C, M, R> {
        fluent_builders::DeleteBackupVaultLockConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackupVaultNotifications` operation.
    ///
    /// See [`DeleteBackupVaultNotifications`](crate::client::fluent_builders::DeleteBackupVaultNotifications) for more information about the
    /// operation and its arguments.
    pub fn delete_backup_vault_notifications(
        &self,
    ) -> fluent_builders::DeleteBackupVaultNotifications<C, M, R> {
        fluent_builders::DeleteBackupVaultNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFramework` operation.
    ///
    /// See [`DeleteFramework`](crate::client::fluent_builders::DeleteFramework) for more information about the
    /// operation and its arguments.
    pub fn delete_framework(&self) -> fluent_builders::DeleteFramework<C, M, R> {
        fluent_builders::DeleteFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecoveryPoint` operation.
    ///
    /// See [`DeleteRecoveryPoint`](crate::client::fluent_builders::DeleteRecoveryPoint) for more information about the
    /// operation and its arguments.
    pub fn delete_recovery_point(&self) -> fluent_builders::DeleteRecoveryPoint<C, M, R> {
        fluent_builders::DeleteRecoveryPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReportPlan` operation.
    ///
    /// See [`DeleteReportPlan`](crate::client::fluent_builders::DeleteReportPlan) for more information about the
    /// operation and its arguments.
    pub fn delete_report_plan(&self) -> fluent_builders::DeleteReportPlan<C, M, R> {
        fluent_builders::DeleteReportPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBackupJob` operation.
    ///
    /// See [`DescribeBackupJob`](crate::client::fluent_builders::DescribeBackupJob) for more information about the
    /// operation and its arguments.
    pub fn describe_backup_job(&self) -> fluent_builders::DescribeBackupJob<C, M, R> {
        fluent_builders::DescribeBackupJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBackupVault` operation.
    ///
    /// See [`DescribeBackupVault`](crate::client::fluent_builders::DescribeBackupVault) for more information about the
    /// operation and its arguments.
    pub fn describe_backup_vault(&self) -> fluent_builders::DescribeBackupVault<C, M, R> {
        fluent_builders::DescribeBackupVault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCopyJob` operation.
    ///
    /// See [`DescribeCopyJob`](crate::client::fluent_builders::DescribeCopyJob) for more information about the
    /// operation and its arguments.
    pub fn describe_copy_job(&self) -> fluent_builders::DescribeCopyJob<C, M, R> {
        fluent_builders::DescribeCopyJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFramework` operation.
    ///
    /// See [`DescribeFramework`](crate::client::fluent_builders::DescribeFramework) for more information about the
    /// operation and its arguments.
    pub fn describe_framework(&self) -> fluent_builders::DescribeFramework<C, M, R> {
        fluent_builders::DescribeFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGlobalSettings` operation.
    ///
    /// See [`DescribeGlobalSettings`](crate::client::fluent_builders::DescribeGlobalSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_global_settings(&self) -> fluent_builders::DescribeGlobalSettings<C, M, R> {
        fluent_builders::DescribeGlobalSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProtectedResource` operation.
    ///
    /// See [`DescribeProtectedResource`](crate::client::fluent_builders::DescribeProtectedResource) for more information about the
    /// operation and its arguments.
    pub fn describe_protected_resource(
        &self,
    ) -> fluent_builders::DescribeProtectedResource<C, M, R> {
        fluent_builders::DescribeProtectedResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecoveryPoint` operation.
    ///
    /// See [`DescribeRecoveryPoint`](crate::client::fluent_builders::DescribeRecoveryPoint) for more information about the
    /// operation and its arguments.
    pub fn describe_recovery_point(&self) -> fluent_builders::DescribeRecoveryPoint<C, M, R> {
        fluent_builders::DescribeRecoveryPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRegionSettings` operation.
    ///
    /// See [`DescribeRegionSettings`](crate::client::fluent_builders::DescribeRegionSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_region_settings(&self) -> fluent_builders::DescribeRegionSettings<C, M, R> {
        fluent_builders::DescribeRegionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReportJob` operation.
    ///
    /// See [`DescribeReportJob`](crate::client::fluent_builders::DescribeReportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_report_job(&self) -> fluent_builders::DescribeReportJob<C, M, R> {
        fluent_builders::DescribeReportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReportPlan` operation.
    ///
    /// See [`DescribeReportPlan`](crate::client::fluent_builders::DescribeReportPlan) for more information about the
    /// operation and its arguments.
    pub fn describe_report_plan(&self) -> fluent_builders::DescribeReportPlan<C, M, R> {
        fluent_builders::DescribeReportPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRestoreJob` operation.
    ///
    /// See [`DescribeRestoreJob`](crate::client::fluent_builders::DescribeRestoreJob) for more information about the
    /// operation and its arguments.
    pub fn describe_restore_job(&self) -> fluent_builders::DescribeRestoreJob<C, M, R> {
        fluent_builders::DescribeRestoreJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateRecoveryPoint` operation.
    ///
    /// See [`DisassociateRecoveryPoint`](crate::client::fluent_builders::DisassociateRecoveryPoint) for more information about the
    /// operation and its arguments.
    pub fn disassociate_recovery_point(
        &self,
    ) -> fluent_builders::DisassociateRecoveryPoint<C, M, R> {
        fluent_builders::DisassociateRecoveryPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportBackupPlanTemplate` operation.
    ///
    /// See [`ExportBackupPlanTemplate`](crate::client::fluent_builders::ExportBackupPlanTemplate) for more information about the
    /// operation and its arguments.
    pub fn export_backup_plan_template(
        &self,
    ) -> fluent_builders::ExportBackupPlanTemplate<C, M, R> {
        fluent_builders::ExportBackupPlanTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackupPlan` operation.
    ///
    /// See [`GetBackupPlan`](crate::client::fluent_builders::GetBackupPlan) for more information about the
    /// operation and its arguments.
    pub fn get_backup_plan(&self) -> fluent_builders::GetBackupPlan<C, M, R> {
        fluent_builders::GetBackupPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackupPlanFromJSON` operation.
    ///
    /// See [`GetBackupPlanFromJSON`](crate::client::fluent_builders::GetBackupPlanFromJSON) for more information about the
    /// operation and its arguments.
    pub fn get_backup_plan_from_json(&self) -> fluent_builders::GetBackupPlanFromJSON<C, M, R> {
        fluent_builders::GetBackupPlanFromJSON::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackupPlanFromTemplate` operation.
    ///
    /// See [`GetBackupPlanFromTemplate`](crate::client::fluent_builders::GetBackupPlanFromTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_backup_plan_from_template(
        &self,
    ) -> fluent_builders::GetBackupPlanFromTemplate<C, M, R> {
        fluent_builders::GetBackupPlanFromTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackupSelection` operation.
    ///
    /// See [`GetBackupSelection`](crate::client::fluent_builders::GetBackupSelection) for more information about the
    /// operation and its arguments.
    pub fn get_backup_selection(&self) -> fluent_builders::GetBackupSelection<C, M, R> {
        fluent_builders::GetBackupSelection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackupVaultAccessPolicy` operation.
    ///
    /// See [`GetBackupVaultAccessPolicy`](crate::client::fluent_builders::GetBackupVaultAccessPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_backup_vault_access_policy(
        &self,
    ) -> fluent_builders::GetBackupVaultAccessPolicy<C, M, R> {
        fluent_builders::GetBackupVaultAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBackupVaultNotifications` operation.
    ///
    /// See [`GetBackupVaultNotifications`](crate::client::fluent_builders::GetBackupVaultNotifications) for more information about the
    /// operation and its arguments.
    pub fn get_backup_vault_notifications(
        &self,
    ) -> fluent_builders::GetBackupVaultNotifications<C, M, R> {
        fluent_builders::GetBackupVaultNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecoveryPointRestoreMetadata` operation.
    ///
    /// See [`GetRecoveryPointRestoreMetadata`](crate::client::fluent_builders::GetRecoveryPointRestoreMetadata) for more information about the
    /// operation and its arguments.
    pub fn get_recovery_point_restore_metadata(
        &self,
    ) -> fluent_builders::GetRecoveryPointRestoreMetadata<C, M, R> {
        fluent_builders::GetRecoveryPointRestoreMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSupportedResourceTypes` operation.
    ///
    /// See [`GetSupportedResourceTypes`](crate::client::fluent_builders::GetSupportedResourceTypes) for more information about the
    /// operation and its arguments.
    pub fn get_supported_resource_types(
        &self,
    ) -> fluent_builders::GetSupportedResourceTypes<C, M, R> {
        fluent_builders::GetSupportedResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackupJobs` operation.
    ///
    /// See [`ListBackupJobs`](crate::client::fluent_builders::ListBackupJobs) for more information about the
    /// operation and its arguments.
    pub fn list_backup_jobs(&self) -> fluent_builders::ListBackupJobs<C, M, R> {
        fluent_builders::ListBackupJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackupPlans` operation.
    ///
    /// See [`ListBackupPlans`](crate::client::fluent_builders::ListBackupPlans) for more information about the
    /// operation and its arguments.
    pub fn list_backup_plans(&self) -> fluent_builders::ListBackupPlans<C, M, R> {
        fluent_builders::ListBackupPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackupPlanTemplates` operation.
    ///
    /// See [`ListBackupPlanTemplates`](crate::client::fluent_builders::ListBackupPlanTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_backup_plan_templates(&self) -> fluent_builders::ListBackupPlanTemplates<C, M, R> {
        fluent_builders::ListBackupPlanTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackupPlanVersions` operation.
    ///
    /// See [`ListBackupPlanVersions`](crate::client::fluent_builders::ListBackupPlanVersions) for more information about the
    /// operation and its arguments.
    pub fn list_backup_plan_versions(&self) -> fluent_builders::ListBackupPlanVersions<C, M, R> {
        fluent_builders::ListBackupPlanVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackupSelections` operation.
    ///
    /// See [`ListBackupSelections`](crate::client::fluent_builders::ListBackupSelections) for more information about the
    /// operation and its arguments.
    pub fn list_backup_selections(&self) -> fluent_builders::ListBackupSelections<C, M, R> {
        fluent_builders::ListBackupSelections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBackupVaults` operation.
    ///
    /// See [`ListBackupVaults`](crate::client::fluent_builders::ListBackupVaults) for more information about the
    /// operation and its arguments.
    pub fn list_backup_vaults(&self) -> fluent_builders::ListBackupVaults<C, M, R> {
        fluent_builders::ListBackupVaults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCopyJobs` operation.
    ///
    /// See [`ListCopyJobs`](crate::client::fluent_builders::ListCopyJobs) for more information about the
    /// operation and its arguments.
    pub fn list_copy_jobs(&self) -> fluent_builders::ListCopyJobs<C, M, R> {
        fluent_builders::ListCopyJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFrameworks` operation.
    ///
    /// See [`ListFrameworks`](crate::client::fluent_builders::ListFrameworks) for more information about the
    /// operation and its arguments.
    pub fn list_frameworks(&self) -> fluent_builders::ListFrameworks<C, M, R> {
        fluent_builders::ListFrameworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProtectedResources` operation.
    ///
    /// See [`ListProtectedResources`](crate::client::fluent_builders::ListProtectedResources) for more information about the
    /// operation and its arguments.
    pub fn list_protected_resources(&self) -> fluent_builders::ListProtectedResources<C, M, R> {
        fluent_builders::ListProtectedResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecoveryPointsByBackupVault` operation.
    ///
    /// See [`ListRecoveryPointsByBackupVault`](crate::client::fluent_builders::ListRecoveryPointsByBackupVault) for more information about the
    /// operation and its arguments.
    pub fn list_recovery_points_by_backup_vault(
        &self,
    ) -> fluent_builders::ListRecoveryPointsByBackupVault<C, M, R> {
        fluent_builders::ListRecoveryPointsByBackupVault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecoveryPointsByResource` operation.
    ///
    /// See [`ListRecoveryPointsByResource`](crate::client::fluent_builders::ListRecoveryPointsByResource) for more information about the
    /// operation and its arguments.
    pub fn list_recovery_points_by_resource(
        &self,
    ) -> fluent_builders::ListRecoveryPointsByResource<C, M, R> {
        fluent_builders::ListRecoveryPointsByResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReportJobs` operation.
    ///
    /// See [`ListReportJobs`](crate::client::fluent_builders::ListReportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_report_jobs(&self) -> fluent_builders::ListReportJobs<C, M, R> {
        fluent_builders::ListReportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReportPlans` operation.
    ///
    /// See [`ListReportPlans`](crate::client::fluent_builders::ListReportPlans) for more information about the
    /// operation and its arguments.
    pub fn list_report_plans(&self) -> fluent_builders::ListReportPlans<C, M, R> {
        fluent_builders::ListReportPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRestoreJobs` operation.
    ///
    /// See [`ListRestoreJobs`](crate::client::fluent_builders::ListRestoreJobs) for more information about the
    /// operation and its arguments.
    pub fn list_restore_jobs(&self) -> fluent_builders::ListRestoreJobs<C, M, R> {
        fluent_builders::ListRestoreJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutBackupVaultAccessPolicy` operation.
    ///
    /// See [`PutBackupVaultAccessPolicy`](crate::client::fluent_builders::PutBackupVaultAccessPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_backup_vault_access_policy(
        &self,
    ) -> fluent_builders::PutBackupVaultAccessPolicy<C, M, R> {
        fluent_builders::PutBackupVaultAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutBackupVaultLockConfiguration` operation.
    ///
    /// See [`PutBackupVaultLockConfiguration`](crate::client::fluent_builders::PutBackupVaultLockConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_backup_vault_lock_configuration(
        &self,
    ) -> fluent_builders::PutBackupVaultLockConfiguration<C, M, R> {
        fluent_builders::PutBackupVaultLockConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutBackupVaultNotifications` operation.
    ///
    /// See [`PutBackupVaultNotifications`](crate::client::fluent_builders::PutBackupVaultNotifications) for more information about the
    /// operation and its arguments.
    pub fn put_backup_vault_notifications(
        &self,
    ) -> fluent_builders::PutBackupVaultNotifications<C, M, R> {
        fluent_builders::PutBackupVaultNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartBackupJob` operation.
    ///
    /// See [`StartBackupJob`](crate::client::fluent_builders::StartBackupJob) for more information about the
    /// operation and its arguments.
    pub fn start_backup_job(&self) -> fluent_builders::StartBackupJob<C, M, R> {
        fluent_builders::StartBackupJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartCopyJob` operation.
    ///
    /// See [`StartCopyJob`](crate::client::fluent_builders::StartCopyJob) for more information about the
    /// operation and its arguments.
    pub fn start_copy_job(&self) -> fluent_builders::StartCopyJob<C, M, R> {
        fluent_builders::StartCopyJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartReportJob` operation.
    ///
    /// See [`StartReportJob`](crate::client::fluent_builders::StartReportJob) for more information about the
    /// operation and its arguments.
    pub fn start_report_job(&self) -> fluent_builders::StartReportJob<C, M, R> {
        fluent_builders::StartReportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartRestoreJob` operation.
    ///
    /// See [`StartRestoreJob`](crate::client::fluent_builders::StartRestoreJob) for more information about the
    /// operation and its arguments.
    pub fn start_restore_job(&self) -> fluent_builders::StartRestoreJob<C, M, R> {
        fluent_builders::StartRestoreJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopBackupJob` operation.
    ///
    /// See [`StopBackupJob`](crate::client::fluent_builders::StopBackupJob) for more information about the
    /// operation and its arguments.
    pub fn stop_backup_job(&self) -> fluent_builders::StopBackupJob<C, M, R> {
        fluent_builders::StopBackupJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBackupPlan` operation.
    ///
    /// See [`UpdateBackupPlan`](crate::client::fluent_builders::UpdateBackupPlan) for more information about the
    /// operation and its arguments.
    pub fn update_backup_plan(&self) -> fluent_builders::UpdateBackupPlan<C, M, R> {
        fluent_builders::UpdateBackupPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFramework` operation.
    ///
    /// See [`UpdateFramework`](crate::client::fluent_builders::UpdateFramework) for more information about the
    /// operation and its arguments.
    pub fn update_framework(&self) -> fluent_builders::UpdateFramework<C, M, R> {
        fluent_builders::UpdateFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGlobalSettings` operation.
    ///
    /// See [`UpdateGlobalSettings`](crate::client::fluent_builders::UpdateGlobalSettings) for more information about the
    /// operation and its arguments.
    pub fn update_global_settings(&self) -> fluent_builders::UpdateGlobalSettings<C, M, R> {
        fluent_builders::UpdateGlobalSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRecoveryPointLifecycle` operation.
    ///
    /// See [`UpdateRecoveryPointLifecycle`](crate::client::fluent_builders::UpdateRecoveryPointLifecycle) for more information about the
    /// operation and its arguments.
    pub fn update_recovery_point_lifecycle(
        &self,
    ) -> fluent_builders::UpdateRecoveryPointLifecycle<C, M, R> {
        fluent_builders::UpdateRecoveryPointLifecycle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRegionSettings` operation.
    ///
    /// See [`UpdateRegionSettings`](crate::client::fluent_builders::UpdateRegionSettings) for more information about the
    /// operation and its arguments.
    pub fn update_region_settings(&self) -> fluent_builders::UpdateRegionSettings<C, M, R> {
        fluent_builders::UpdateRegionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReportPlan` operation.
    ///
    /// See [`UpdateReportPlan`](crate::client::fluent_builders::UpdateReportPlan) for more information about the
    /// operation and its arguments.
    pub fn update_report_plan(&self) -> fluent_builders::UpdateReportPlan<C, M, R> {
        fluent_builders::UpdateReportPlan::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateBackupPlan`.
    ///
    /// <p>Creates a backup plan using a backup plan name and backup rules. A backup plan is a
    /// document that contains information that Backup uses to schedule tasks that
    /// create recovery points for resources.</p>
    /// <p>If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive
    /// an <code>AlreadyExistsException</code> exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBackupPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backup_plan_input::Builder,
    }
    impl<C, M, R> CreateBackupPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackupPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackupPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackupPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackupPlanInputOperationOutputAlias,
                crate::output::CreateBackupPlanOutput,
                crate::error::CreateBackupPlanError,
                crate::input::CreateBackupPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn backup_plan(mut self, inp: crate::model::BackupPlanInput) -> Self {
            self.inner = self.inner.backup_plan(inp);
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn set_backup_plan(
            mut self,
            input: std::option::Option<crate::model::BackupPlanInput>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan(input);
            self
        }
        /// Adds a key-value pair to `BackupPlanTags`.
        ///
        /// To override the contents of this collection use [`set_backup_plan_tags`](Self::set_backup_plan_tags).
        ///
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair. The specified tags are assigned to all backups
        /// created with this plan.</p>
        pub fn backup_plan_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.backup_plan_tags(k, v);
            self
        }
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair. The specified tags are assigned to all backups
        /// created with this plan.</p>
        pub fn set_backup_plan_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_tags(input);
            self
        }
        /// <p>Identifies the request and allows failed requests to be retried without the risk of
        /// running the operation twice. If the request includes a <code>CreatorRequestId</code> that
        /// matches an existing backup plan, that plan is returned. This parameter is optional.</p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>Identifies the request and allows failed requests to be retried without the risk of
        /// running the operation twice. If the request includes a <code>CreatorRequestId</code> that
        /// matches an existing backup plan, that plan is returned. This parameter is optional.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackupSelection`.
    ///
    /// <p>Creates a JSON document that specifies a set of resources to assign to a backup plan.
    /// Resources can be included by specifying patterns for a <code>ListOfTags</code> and selected
    /// <code>Resources</code>. </p>
    /// <p>For example, consider the following patterns:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Resources: "arn:aws:ec2:region:account-id:volume/volume-id"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConditionKey:"department"</code>
    /// </p>
    /// <p>
    /// <code>ConditionValue:"finance"</code>
    /// </p>
    /// <p>
    /// <code>ConditionType:"StringEquals"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConditionKey:"importance"</code>
    /// </p>
    /// <p>
    /// <code>ConditionValue:"critical"</code>
    /// </p>
    /// <p>
    /// <code>ConditionType:"StringEquals"</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Using these patterns would back up all Amazon Elastic Block Store (Amazon EBS)
    /// volumes that are tagged as <code>"department=finance"</code>,
    /// <code>"importance=critical"</code>, in addition to an EBS volume with the specified
    /// volume ID.</p>
    /// <p>Resources and conditions are additive in that all resources that match the pattern are
    /// selected. This shouldn't be confused with a logical AND, where all conditions must match.
    /// The matching patterns are logically put together using the OR operator.
    /// In other words, all patterns that match are selected for backup.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBackupSelection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backup_selection_input::Builder,
    }
    impl<C, M, R> CreateBackupSelection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackupSelection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackupSelectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackupSelectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackupSelectionInputOperationOutputAlias,
                crate::output::CreateBackupSelectionOutput,
                crate::error::CreateBackupSelectionError,
                crate::input::CreateBackupSelectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies the backup plan to be associated with the selection of
        /// resources.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies the backup plan to be associated with the selection of
        /// resources.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
        /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn backup_selection(mut self, inp: crate::model::BackupSelection) -> Self {
            self.inner = self.inner.backup_selection(inp);
            self
        }
        /// <p>Specifies the body of a request to assign a set of resources to a backup plan.</p>
        pub fn set_backup_selection(
            mut self,
            input: std::option::Option<crate::model::BackupSelection>,
        ) -> Self {
            self.inner = self.inner.set_backup_selection(input);
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackupVault`.
    ///
    /// <p>Creates a logical container where backups are stored. A <code>CreateBackupVault</code>
    /// request includes a name, optionally one or more resource tags, an encryption key, and a
    /// request ID.</p>
    /// <note>
    /// <p>Do not include sensitive data, such as passport numbers, in the name of a backup
    /// vault.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateBackupVault<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_backup_vault_input::Builder,
    }
    impl<C, M, R> CreateBackupVault<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBackupVault`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackupVaultOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackupVaultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBackupVaultInputOperationOutputAlias,
                crate::output::CreateBackupVaultOutput,
                crate::error::CreateBackupVaultError,
                crate::input::CreateBackupVaultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// Adds a key-value pair to `BackupVaultTags`.
        ///
        /// To override the contents of this collection use [`set_backup_vault_tags`](Self::set_backup_vault_tags).
        ///
        /// <p>Metadata that you can assign to help organize the resources that you create. Each tag is
        /// a key-value pair.</p>
        pub fn backup_vault_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.backup_vault_tags(k, v);
            self
        }
        /// <p>Metadata that you can assign to help organize the resources that you create. Each tag is
        /// a key-value pair.</p>
        pub fn set_backup_vault_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_tags(input);
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(inp);
            self
        }
        /// <p>The server-side encryption key that is used to protect your backups; for example,
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and allows failed requests to be retried
        /// without the risk of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFramework`.
    ///
    /// <p>Creates a framework with one or more controls. A framework is a collection of controls
    /// that you can use to evaluate your backup practices. By using pre-built customizable
    /// controls to define your policies, you can evaluate whether your backup practices comply
    /// with your policies and which resources are not yet in compliance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_framework_input::Builder,
    }
    impl<C, M, R> CreateFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFrameworkInputOperationOutputAlias,
                crate::output::CreateFrameworkOutput,
                crate::error::CreateFrameworkError,
                crate::input::CreateFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the framework. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn framework_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_name(inp);
            self
        }
        /// <p>The unique name of the framework. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_name(input);
            self
        }
        /// <p>An optional description of the framework with a maximum of 1,024 characters.</p>
        pub fn framework_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_description(inp);
            self
        }
        /// <p>An optional description of the framework with a maximum of 1,024 characters.</p>
        pub fn set_framework_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_description(input);
            self
        }
        /// Appends an item to `FrameworkControls`.
        ///
        /// To override the contents of this collection use [`set_framework_controls`](Self::set_framework_controls).
        ///
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn framework_controls(
            mut self,
            inp: impl Into<crate::model::FrameworkControl>,
        ) -> Self {
            self.inner = self.inner.framework_controls(inp);
            self
        }
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn set_framework_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        ) -> Self {
            self.inner = self.inner.set_framework_controls(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Adds a key-value pair to `FrameworkTags`.
        ///
        /// To override the contents of this collection use [`set_framework_tags`](Self::set_framework_tags).
        ///
        /// <p>Metadata that you can assign to help organize the frameworks that you create. Each tag
        /// is a key-value pair.</p>
        pub fn framework_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.framework_tags(k, v);
            self
        }
        /// <p>Metadata that you can assign to help organize the frameworks that you create. Each tag
        /// is a key-value pair.</p>
        pub fn set_framework_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_framework_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReportPlan`.
    ///
    /// <p>Creates a report plan. A report plan is a document that contains information about the
    /// contents of the report and where Backup will deliver it.</p>
    /// <p>If you call <code>CreateReportPlan</code> with a plan that already exists, you receive
    /// an <code>AlreadyExistsException</code> exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReportPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_report_plan_input::Builder,
    }
    impl<C, M, R> CreateReportPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReportPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReportPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReportPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReportPlanInputOperationOutputAlias,
                crate::output::CreateReportPlanOutput,
                crate::error::CreateReportPlanError,
                crate::input::CreateReportPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the report plan. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn report_plan_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_plan_name(inp);
            self
        }
        /// <p>The unique name of the report plan. The name must be between 1 and 256 characters,
        /// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
        /// underscores (_).</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_plan_name(input);
            self
        }
        /// <p>An optional description of the report plan with a maximum of 1,024 characters.</p>
        pub fn report_plan_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_plan_description(inp);
            self
        }
        /// <p>An optional description of the report plan with a maximum of 1,024 characters.</p>
        pub fn set_report_plan_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_plan_description(input);
            self
        }
        /// <p>A structure that contains information about where and how to deliver your reports,
        /// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
        /// reports.</p>
        pub fn report_delivery_channel(mut self, inp: crate::model::ReportDeliveryChannel) -> Self {
            self.inner = self.inner.report_delivery_channel(inp);
            self
        }
        /// <p>A structure that contains information about where and how to deliver your reports,
        /// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
        /// reports.</p>
        pub fn set_report_delivery_channel(
            mut self,
            input: std::option::Option<crate::model::ReportDeliveryChannel>,
        ) -> Self {
            self.inner = self.inner.set_report_delivery_channel(input);
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn report_setting(mut self, inp: crate::model::ReportSetting) -> Self {
            self.inner = self.inner.report_setting(inp);
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn set_report_setting(
            mut self,
            input: std::option::Option<crate::model::ReportSetting>,
        ) -> Self {
            self.inner = self.inner.set_report_setting(input);
            self
        }
        /// Adds a key-value pair to `ReportPlanTags`.
        ///
        /// To override the contents of this collection use [`set_report_plan_tags`](Self::set_report_plan_tags).
        ///
        /// <p>Metadata that you can assign to help organize the report plans that you create. Each tag
        /// is a key-value pair.</p>
        pub fn report_plan_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.report_plan_tags(k, v);
            self
        }
        /// <p>Metadata that you can assign to help organize the report plans that you create. Each tag
        /// is a key-value pair.</p>
        pub fn set_report_plan_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_report_plan_tags(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackupPlan`.
    ///
    /// <p>Deletes a backup plan. A backup plan can only be deleted after all associated selections
    /// of resources have been deleted. Deleting a backup plan deletes the current version of a
    /// backup plan. Previous versions, if any, will still exist.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackupPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_plan_input::Builder,
    }
    impl<C, M, R> DeleteBackupPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackupPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupPlanInputOperationOutputAlias,
                crate::output::DeleteBackupPlanOutput,
                crate::error::DeleteBackupPlanError,
                crate::input::DeleteBackupPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackupSelection`.
    ///
    /// <p>Deletes the resource selection associated with a backup plan that is specified by the
    /// <code>SelectionId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackupSelection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_selection_input::Builder,
    }
    impl<C, M, R> DeleteBackupSelection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackupSelection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupSelectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupSelectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupSelectionInputOperationOutputAlias,
                crate::output::DeleteBackupSelectionOutput,
                crate::error::DeleteBackupSelectionError,
                crate::input::DeleteBackupSelectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn selection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selection_id(inp);
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn set_selection_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_selection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackupVault`.
    ///
    /// <p>Deletes the backup vault identified by its name. A vault can be deleted only if it is
    /// empty.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackupVault<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_vault_input::Builder,
    }
    impl<C, M, R> DeleteBackupVault<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackupVault`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupVaultOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupVaultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupVaultInputOperationOutputAlias,
                crate::output::DeleteBackupVaultOutput,
                crate::error::DeleteBackupVaultError,
                crate::input::DeleteBackupVaultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackupVaultAccessPolicy`.
    ///
    /// <p>Deletes the policy document that manages permissions on a backup vault.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackupVaultAccessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_vault_access_policy_input::Builder,
    }
    impl<C, M, R> DeleteBackupVaultAccessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackupVaultAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupVaultAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupVaultAccessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupVaultAccessPolicyInputOperationOutputAlias,
                crate::output::DeleteBackupVaultAccessPolicyOutput,
                crate::error::DeleteBackupVaultAccessPolicyError,
                crate::input::DeleteBackupVaultAccessPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackupVaultLockConfiguration`.
    ///
    /// <p>Deletes Backup Vault Lock from a backup vault specified by a backup vault
    /// name.</p>
    /// <p>If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using
    /// API operations, and you will receive an <code>InvalidRequestException</code> if you attempt
    /// to do so. For more information, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the
    /// <i>Backup Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackupVaultLockConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_vault_lock_configuration_input::Builder,
    }
    impl<C, M, R> DeleteBackupVaultLockConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackupVaultLockConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupVaultLockConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteBackupVaultLockConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupVaultLockConfigurationInputOperationOutputAlias,
                crate::output::DeleteBackupVaultLockConfigurationOutput,
                crate::error::DeleteBackupVaultLockConfigurationError,
                crate::input::DeleteBackupVaultLockConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the backup vault from which to delete Backup Vault Lock.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of the backup vault from which to delete Backup Vault Lock.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackupVaultNotifications`.
    ///
    /// <p>Deletes event notifications for the specified backup vault.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackupVaultNotifications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_vault_notifications_input::Builder,
    }
    impl<C, M, R> DeleteBackupVaultNotifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackupVaultNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupVaultNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupVaultNotificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupVaultNotificationsInputOperationOutputAlias,
                crate::output::DeleteBackupVaultNotificationsOutput,
                crate::error::DeleteBackupVaultNotificationsError,
                crate::input::DeleteBackupVaultNotificationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Region where they are
        /// created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Region where they are
        /// created. They consist of lowercase letters, numbers, and hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFramework`.
    ///
    /// <p>Deletes the framework specified by a framework name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_framework_input::Builder,
    }
    impl<C, M, R> DeleteFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFrameworkInputOperationOutputAlias,
                crate::output::DeleteFrameworkOutput,
                crate::error::DeleteFrameworkError,
                crate::input::DeleteFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a framework.</p>
        pub fn framework_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_name(inp);
            self
        }
        /// <p>The unique name of a framework.</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecoveryPoint`.
    ///
    /// <p>Deletes the recovery point specified by a recovery point ID.</p>
    /// <p>If the recovery point ID belongs to a continuous backup, calling this endpoint deletes
    /// the existing continuous backup and stops future continuous backup.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRecoveryPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recovery_point_input::Builder,
    }
    impl<C, M, R> DeleteRecoveryPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecoveryPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecoveryPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecoveryPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecoveryPointInputOperationOutputAlias,
                crate::output::DeleteRecoveryPointOutput,
                crate::error::DeleteRecoveryPointError,
                crate::input::DeleteRecoveryPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_point_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReportPlan`.
    ///
    /// <p>Deletes the report plan specified by a report plan name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReportPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_report_plan_input::Builder,
    }
    impl<C, M, R> DeleteReportPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReportPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReportPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReportPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReportPlanInputOperationOutputAlias,
                crate::output::DeleteReportPlanOutput,
                crate::error::DeleteReportPlanError,
                crate::input::DeleteReportPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a report plan.</p>
        pub fn report_plan_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_plan_name(inp);
            self
        }
        /// <p>The unique name of a report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_plan_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackupJob`.
    ///
    /// <p>Returns backup job details for the specified <code>BackupJobId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBackupJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_backup_job_input::Builder,
    }
    impl<C, M, R> DescribeBackupJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBackupJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBackupJobInputOperationOutputAlias,
                crate::output::DescribeBackupJobOutput,
                crate::error::DescribeBackupJobError,
                crate::input::DescribeBackupJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn backup_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_job_id(inp);
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn set_backup_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackupVault`.
    ///
    /// <p>Returns metadata about a backup vault specified by its name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBackupVault<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_backup_vault_input::Builder,
    }
    impl<C, M, R> DescribeBackupVault<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBackupVault`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupVaultOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupVaultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBackupVaultInputOperationOutputAlias,
                crate::output::DescribeBackupVaultOutput,
                crate::error::DescribeBackupVaultError,
                crate::input::DescribeBackupVaultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCopyJob`.
    ///
    /// <p>Returns metadata associated with creating a copy of a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCopyJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_copy_job_input::Builder,
    }
    impl<C, M, R> DescribeCopyJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCopyJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCopyJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCopyJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCopyJobInputOperationOutputAlias,
                crate::output::DescribeCopyJobOutput,
                crate::error::DescribeCopyJobError,
                crate::input::DescribeCopyJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a copy job.</p>
        pub fn copy_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.copy_job_id(inp);
            self
        }
        /// <p>Uniquely identifies a copy job.</p>
        pub fn set_copy_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_copy_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFramework`.
    ///
    /// <p>Returns the framework details for the specified <code>FrameworkName</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_framework_input::Builder,
    }
    impl<C, M, R> DescribeFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFrameworkInputOperationOutputAlias,
                crate::output::DescribeFrameworkOutput,
                crate::error::DescribeFrameworkError,
                crate::input::DescribeFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a framework.</p>
        pub fn framework_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_name(inp);
            self
        }
        /// <p>The unique name of a framework.</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalSettings`.
    ///
    /// <p>Describes whether the Amazon Web Services account is opted in to cross-account backup.
    /// Returns an error if the account is not a member of an Organizations organization.
    /// Example: <code>describe-global-settings --region us-west-2</code>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGlobalSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_global_settings_input::Builder,
    }
    impl<C, M, R> DescribeGlobalSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGlobalSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGlobalSettingsInputOperationOutputAlias,
                crate::output::DescribeGlobalSettingsOutput,
                crate::error::DescribeGlobalSettingsError,
                crate::input::DescribeGlobalSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeProtectedResource`.
    ///
    /// <p>Returns information about a saved resource, including the last time it was backed up,
    /// its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved
    /// resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProtectedResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_protected_resource_input::Builder,
    }
    impl<C, M, R> DescribeProtectedResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProtectedResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProtectedResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProtectedResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProtectedResourceInputOperationOutputAlias,
                crate::output::DescribeProtectedResourceOutput,
                crate::error::DescribeProtectedResourceError,
                crate::input::DescribeProtectedResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecoveryPoint`.
    ///
    /// <p>Returns metadata associated with a recovery point, including ID, status, encryption, and
    /// lifecycle.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRecoveryPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_recovery_point_input::Builder,
    }
    impl<C, M, R> DescribeRecoveryPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecoveryPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecoveryPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecoveryPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecoveryPointInputOperationOutputAlias,
                crate::output::DescribeRecoveryPointOutput,
                crate::error::DescribeRecoveryPointError,
                crate::input::DescribeRecoveryPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_point_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRegionSettings`.
    ///
    /// <p>Returns the current service opt-in settings for the Region. If service opt-in is enabled
    /// for a service, Backup tries to protect that service's resources in this Region,
    /// when the resource is included in an on-demand backup or scheduled backup plan. Otherwise,
    /// Backup does not try to protect that service's resources in this
    /// Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRegionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_region_settings_input::Builder,
    }
    impl<C, M, R> DescribeRegionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRegionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRegionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRegionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRegionSettingsInputOperationOutputAlias,
                crate::output::DescribeRegionSettingsOutput,
                crate::error::DescribeRegionSettingsError,
                crate::input::DescribeRegionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeReportJob`.
    ///
    /// <p>Returns the details associated with creating a report as specified by its
    /// <code>ReportJobId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_report_job_input::Builder,
    }
    impl<C, M, R> DescribeReportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReportJobInputOperationOutputAlias,
                crate::output::DescribeReportJobOutput,
                crate::error::DescribeReportJobError,
                crate::input::DescribeReportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded
        /// string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
        pub fn report_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_job_id(inp);
            self
        }
        /// <p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded
        /// string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>
        pub fn set_report_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReportPlan`.
    ///
    /// <p>Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReportPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_report_plan_input::Builder,
    }
    impl<C, M, R> DescribeReportPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReportPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReportPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReportPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReportPlanInputOperationOutputAlias,
                crate::output::DescribeReportPlanOutput,
                crate::error::DescribeReportPlanError,
                crate::input::DescribeReportPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a report plan.</p>
        pub fn report_plan_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_plan_name(inp);
            self
        }
        /// <p>The unique name of a report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_plan_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRestoreJob`.
    ///
    /// <p>Returns metadata associated with a restore job that is specified by a job ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRestoreJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_restore_job_input::Builder,
    }
    impl<C, M, R> DescribeRestoreJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRestoreJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRestoreJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRestoreJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRestoreJobInputOperationOutputAlias,
                crate::output::DescribeRestoreJobOutput,
                crate::error::DescribeRestoreJobError,
                crate::input::DescribeRestoreJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn restore_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.restore_job_id(inp);
            self
        }
        /// <p>Uniquely identifies the job that restores a recovery point.</p>
        pub fn set_restore_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_restore_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateRecoveryPoint`.
    ///
    /// <p>Deletes the specified continuous backup recovery point from Backup and
    /// releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the
    /// lifecycle that you specified in your original backup plan.</p>
    /// <p>Does not support snapshot backup recovery points.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateRecoveryPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_recovery_point_input::Builder,
    }
    impl<C, M, R> DisassociateRecoveryPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateRecoveryPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateRecoveryPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateRecoveryPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateRecoveryPointInputOperationOutputAlias,
                crate::output::DisassociateRecoveryPointOutput,
                crate::error::DisassociateRecoveryPointError,
                crate::input::DisassociateRecoveryPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of an Backup vault.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The unique name of an Backup vault.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery
        /// point.</p>
        pub fn recovery_point_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_point_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery
        /// point.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportBackupPlanTemplate`.
    ///
    /// <p>Returns the backup plan that is specified by the plan ID as a backup template.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExportBackupPlanTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_backup_plan_template_input::Builder,
    }
    impl<C, M, R> ExportBackupPlanTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportBackupPlanTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportBackupPlanTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportBackupPlanTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportBackupPlanTemplateInputOperationOutputAlias,
                crate::output::ExportBackupPlanTemplateOutput,
                crate::error::ExportBackupPlanTemplateError,
                crate::input::ExportBackupPlanTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackupPlan`.
    ///
    /// <p>Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The
    /// details are the body of a backup plan in JSON format, in addition to plan metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBackupPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backup_plan_input::Builder,
    }
    impl<C, M, R> GetBackupPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackupPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackupPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackupPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackupPlanInputOperationOutputAlias,
                crate::output::GetBackupPlanOutput,
                crate::error::GetBackupPlanError,
                crate::input::GetBackupPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
        /// long. Version IDs cannot be edited.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
        /// long. Version IDs cannot be edited.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackupPlanFromJSON`.
    ///
    /// <p>Returns a valid JSON document specifying a backup plan or an error.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBackupPlanFromJSON<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backup_plan_from_json_input::Builder,
    }
    impl<C, M, R> GetBackupPlanFromJSON<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackupPlanFromJSON`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackupPlanFromJsonOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackupPlanFromJSONError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackupPlanFromJsonInputOperationOutputAlias,
                crate::output::GetBackupPlanFromJsonOutput,
                crate::error::GetBackupPlanFromJSONError,
                crate::input::GetBackupPlanFromJsonInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A customer-supplied backup plan document in JSON format.</p>
        pub fn backup_plan_template_json(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_template_json(inp);
            self
        }
        /// <p>A customer-supplied backup plan document in JSON format.</p>
        pub fn set_backup_plan_template_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_template_json(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackupPlanFromTemplate`.
    ///
    /// <p>Returns the template specified by its <code>templateId</code> as a backup plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBackupPlanFromTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backup_plan_from_template_input::Builder,
    }
    impl<C, M, R> GetBackupPlanFromTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackupPlanFromTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackupPlanFromTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackupPlanFromTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackupPlanFromTemplateInputOperationOutputAlias,
                crate::output::GetBackupPlanFromTemplateOutput,
                crate::error::GetBackupPlanFromTemplateError,
                crate::input::GetBackupPlanFromTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a stored backup plan template.</p>
        pub fn backup_plan_template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_template_id(inp);
            self
        }
        /// <p>Uniquely identifies a stored backup plan template.</p>
        pub fn set_backup_plan_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackupSelection`.
    ///
    /// <p>Returns selection metadata and a document in JSON format that specifies a list of
    /// resources that are associated with a backup plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBackupSelection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backup_selection_input::Builder,
    }
    impl<C, M, R> GetBackupSelection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackupSelection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackupSelectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackupSelectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackupSelectionInputOperationOutputAlias,
                crate::output::GetBackupSelectionOutput,
                crate::error::GetBackupSelectionError,
                crate::input::GetBackupSelectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn selection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selection_id(inp);
            self
        }
        /// <p>Uniquely identifies the body of a request to assign a set of resources to a backup
        /// plan.</p>
        pub fn set_selection_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_selection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackupVaultAccessPolicy`.
    ///
    /// <p>Returns the access policy document that is associated with the named backup
    /// vault.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBackupVaultAccessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backup_vault_access_policy_input::Builder,
    }
    impl<C, M, R> GetBackupVaultAccessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackupVaultAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackupVaultAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackupVaultAccessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackupVaultAccessPolicyInputOperationOutputAlias,
                crate::output::GetBackupVaultAccessPolicyOutput,
                crate::error::GetBackupVaultAccessPolicyError,
                crate::input::GetBackupVaultAccessPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBackupVaultNotifications`.
    ///
    /// <p>Returns event notifications for the specified backup vault.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBackupVaultNotifications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_backup_vault_notifications_input::Builder,
    }
    impl<C, M, R> GetBackupVaultNotifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBackupVaultNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBackupVaultNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBackupVaultNotificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBackupVaultNotificationsInputOperationOutputAlias,
                crate::output::GetBackupVaultNotificationsOutput,
                crate::error::GetBackupVaultNotificationsError,
                crate::input::GetBackupVaultNotificationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecoveryPointRestoreMetadata`.
    ///
    /// <p>Returns a set of metadata key-value pairs that were used to create the backup.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRecoveryPointRestoreMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recovery_point_restore_metadata_input::Builder,
    }
    impl<C, M, R> GetRecoveryPointRestoreMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecoveryPointRestoreMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecoveryPointRestoreMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecoveryPointRestoreMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecoveryPointRestoreMetadataInputOperationOutputAlias,
                crate::output::GetRecoveryPointRestoreMetadataOutput,
                crate::error::GetRecoveryPointRestoreMetadataError,
                crate::input::GetRecoveryPointRestoreMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_point_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSupportedResourceTypes`.
    ///
    /// <p>Returns the Amazon Web Services resource types supported by Backup.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSupportedResourceTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_supported_resource_types_input::Builder,
    }
    impl<C, M, R> GetSupportedResourceTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSupportedResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSupportedResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSupportedResourceTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSupportedResourceTypesInputOperationOutputAlias,
                crate::output::GetSupportedResourceTypesOutput,
                crate::error::GetSupportedResourceTypesError,
                crate::input::GetSupportedResourceTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListBackupJobs`.
    ///
    /// <p>Returns a list of existing backup jobs for an authenticated account for the last 30
    /// days. For a longer period of time, consider using these <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackupJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backup_jobs_input::Builder,
    }
    impl<C, M, R> ListBackupJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackupJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackupJobsInputOperationOutputAlias,
                crate::output::ListBackupJobsOutput,
                crate::error::ListBackupJobsError,
                crate::input::ListBackupJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Returns only backup jobs that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn by_resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_resource_arn(inp);
            self
        }
        /// <p>Returns only backup jobs that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn set_by_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_resource_arn(input);
            self
        }
        /// <p>Returns only backup jobs that are in the specified state.</p>
        pub fn by_state(mut self, inp: crate::model::BackupJobState) -> Self {
            self.inner = self.inner.by_state(inp);
            self
        }
        /// <p>Returns only backup jobs that are in the specified state.</p>
        pub fn set_by_state(
            mut self,
            input: std::option::Option<crate::model::BackupJobState>,
        ) -> Self {
            self.inner = self.inner.set_by_state(input);
            self
        }
        /// <p>Returns only backup jobs that will be stored in the specified backup vault. Backup
        /// vaults are identified by names that are unique to the account used to create them and the
        /// Amazon Web Services Region where they are created. They consist of lowercase letters,
        /// numbers, and hyphens.</p>
        pub fn by_backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_backup_vault_name(inp);
            self
        }
        /// <p>Returns only backup jobs that will be stored in the specified backup vault. Backup
        /// vaults are identified by names that are unique to the account used to create them and the
        /// Amazon Web Services Region where they are created. They consist of lowercase letters,
        /// numbers, and hyphens.</p>
        pub fn set_by_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_backup_vault_name(input);
            self
        }
        /// <p>Returns only backup jobs that were created before the specified date.</p>
        pub fn by_created_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_before(inp);
            self
        }
        /// <p>Returns only backup jobs that were created before the specified date.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_before(input);
            self
        }
        /// <p>Returns only backup jobs that were created after the specified date.</p>
        pub fn by_created_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_after(inp);
            self
        }
        /// <p>Returns only backup jobs that were created after the specified date.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_after(input);
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn by_resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_resource_type(inp);
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn set_by_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_resource_type(input);
            self
        }
        /// <p>The account ID to list the jobs from. Returns only backup jobs associated with the
        /// specified account ID.</p>
        /// <p>If used from an Organizations management account, passing <code>*</code> returns
        /// all jobs across the organization.</p>
        pub fn by_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_account_id(inp);
            self
        }
        /// <p>The account ID to list the jobs from. Returns only backup jobs associated with the
        /// specified account ID.</p>
        /// <p>If used from an Organizations management account, passing <code>*</code> returns
        /// all jobs across the organization.</p>
        pub fn set_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackupPlans`.
    ///
    /// <p>Returns a list of all active backup plans for an authenticated account. The list
    /// contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion
    /// dates, version IDs, plan names, and creator request IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackupPlans<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backup_plans_input::Builder,
    }
    impl<C, M, R> ListBackupPlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackupPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupPlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackupPlansInputOperationOutputAlias,
                crate::output::ListBackupPlansOutput,
                crate::error::ListBackupPlansError,
                crate::input::ListBackupPlansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup
        /// plans when set to <code>TRUE</code>.</p>
        pub fn include_deleted(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_deleted(inp);
            self
        }
        /// <p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup
        /// plans when set to <code>TRUE</code>.</p>
        pub fn set_include_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deleted(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackupPlanTemplates`.
    ///
    /// <p>Returns metadata of your saved backup plan templates, including the template ID, name,
    /// and the creation and deletion dates.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackupPlanTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backup_plan_templates_input::Builder,
    }
    impl<C, M, R> ListBackupPlanTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackupPlanTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupPlanTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupPlanTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackupPlanTemplatesInputOperationOutputAlias,
                crate::output::ListBackupPlanTemplatesOutput,
                crate::error::ListBackupPlanTemplatesError,
                crate::input::ListBackupPlanTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackupPlanVersions`.
    ///
    /// <p>Returns version metadata of your backup plans, including Amazon Resource Names (ARNs),
    /// backup plan IDs, creation and deletion dates, plan names, and version IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackupPlanVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backup_plan_versions_input::Builder,
    }
    impl<C, M, R> ListBackupPlanVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackupPlanVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupPlanVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupPlanVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackupPlanVersionsInputOperationOutputAlias,
                crate::output::ListBackupPlanVersionsOutput,
                crate::error::ListBackupPlanVersionsError,
                crate::input::ListBackupPlanVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackupSelections`.
    ///
    /// <p>Returns an array containing metadata of the resources associated with the target backup
    /// plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackupSelections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backup_selections_input::Builder,
    }
    impl<C, M, R> ListBackupSelections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackupSelections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupSelectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupSelectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackupSelectionsInputOperationOutputAlias,
                crate::output::ListBackupSelectionsOutput,
                crate::error::ListBackupSelectionsError,
                crate::input::ListBackupSelectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackupVaults`.
    ///
    /// <p>Returns a list of recovery point storage containers along with information about
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBackupVaults<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_backup_vaults_input::Builder,
    }
    impl<C, M, R> ListBackupVaults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBackupVaults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupVaultsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupVaultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBackupVaultsInputOperationOutputAlias,
                crate::output::ListBackupVaultsOutput,
                crate::error::ListBackupVaultsError,
                crate::input::ListBackupVaultsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCopyJobs`.
    ///
    /// <p>Returns metadata about your copy jobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCopyJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_copy_jobs_input::Builder,
    }
    impl<C, M, R> ListCopyJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCopyJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCopyJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCopyJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCopyJobsInputOperationOutputAlias,
                crate::output::ListCopyJobsOutput,
                crate::error::ListCopyJobsError,
                crate::input::ListCopyJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return maxResults number of items, NextToken allows you to return more items in
        /// your list starting at the location pointed to by the next token. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return maxResults number of items, NextToken allows you to return more items in
        /// your list starting at the location pointed to by the next token. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN).
        /// </p>
        pub fn by_resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_resource_arn(inp);
            self
        }
        /// <p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN).
        /// </p>
        pub fn set_by_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_resource_arn(input);
            self
        }
        /// <p>Returns only copy jobs that are in the specified state.</p>
        pub fn by_state(mut self, inp: crate::model::CopyJobState) -> Self {
            self.inner = self.inner.by_state(inp);
            self
        }
        /// <p>Returns only copy jobs that are in the specified state.</p>
        pub fn set_by_state(
            mut self,
            input: std::option::Option<crate::model::CopyJobState>,
        ) -> Self {
            self.inner = self.inner.set_by_state(input);
            self
        }
        /// <p>Returns only copy jobs that were created before the specified date.</p>
        pub fn by_created_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_before(inp);
            self
        }
        /// <p>Returns only copy jobs that were created before the specified date.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_before(input);
            self
        }
        /// <p>Returns only copy jobs that were created after the specified date.</p>
        pub fn by_created_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_after(inp);
            self
        }
        /// <p>Returns only copy jobs that were created after the specified date.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_after(input);
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn by_resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_resource_type(inp);
            self
        }
        /// <p>Returns only backup jobs for the specified resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn set_by_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_resource_type(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy
        /// from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
        /// </p>
        pub fn by_destination_vault_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_destination_vault_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy
        /// from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
        /// </p>
        pub fn set_by_destination_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_destination_vault_arn(input);
            self
        }
        /// <p>The account ID to list the jobs from. Returns only copy jobs associated with the
        /// specified account ID.</p>
        pub fn by_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_account_id(inp);
            self
        }
        /// <p>The account ID to list the jobs from. Returns only copy jobs associated with the
        /// specified account ID.</p>
        pub fn set_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFrameworks`.
    ///
    /// <p>Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFrameworks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_frameworks_input::Builder,
    }
    impl<C, M, R> ListFrameworks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFrameworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFrameworksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFrameworksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFrameworksInputOperationOutputAlias,
                crate::output::ListFrameworksOutput,
                crate::error::ListFrameworksError,
                crate::input::ListFrameworksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProtectedResources`.
    ///
    /// <p>Returns an array of resources successfully backed up by Backup, including
    /// the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a
    /// resource type.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProtectedResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_protected_resources_input::Builder,
    }
    impl<C, M, R> ListProtectedResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProtectedResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProtectedResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProtectedResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProtectedResourcesInputOperationOutputAlias,
                crate::output::ListProtectedResourcesOutput,
                crate::error::ListProtectedResourcesError,
                crate::input::ListProtectedResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecoveryPointsByBackupVault`.
    ///
    /// <p>Returns detailed information about the recovery points stored in a backup vault.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecoveryPointsByBackupVault<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recovery_points_by_backup_vault_input::Builder,
    }
    impl<C, M, R> ListRecoveryPointsByBackupVault<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecoveryPointsByBackupVault`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecoveryPointsByBackupVaultOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecoveryPointsByBackupVaultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecoveryPointsByBackupVaultInputOperationOutputAlias,
                crate::output::ListRecoveryPointsByBackupVaultOutput,
                crate::error::ListRecoveryPointsByBackupVaultError,
                crate::input::ListRecoveryPointsByBackupVaultInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        /// <note>
        /// <p>Backup vault name might not be available when a supported service creates the
        /// backup.</p>
        /// </note>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        /// <note>
        /// <p>Backup vault name might not be available when a supported service creates the
        /// backup.</p>
        /// </note>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Returns only recovery points that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn by_resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_resource_arn(inp);
            self
        }
        /// <p>Returns only recovery points that match the specified resource Amazon Resource Name
        /// (ARN).</p>
        pub fn set_by_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_resource_arn(input);
            self
        }
        /// <p>Returns only recovery points that match the specified resource type.</p>
        pub fn by_resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_resource_type(inp);
            self
        }
        /// <p>Returns only recovery points that match the specified resource type.</p>
        pub fn set_by_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_resource_type(input);
            self
        }
        /// <p>Returns only recovery points that match the specified backup plan ID.</p>
        pub fn by_backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_backup_plan_id(inp);
            self
        }
        /// <p>Returns only recovery points that match the specified backup plan ID.</p>
        pub fn set_by_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_backup_plan_id(input);
            self
        }
        /// <p>Returns only recovery points that were created before the specified timestamp.</p>
        pub fn by_created_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_before(inp);
            self
        }
        /// <p>Returns only recovery points that were created before the specified timestamp.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_before(input);
            self
        }
        /// <p>Returns only recovery points that were created after the specified timestamp.</p>
        pub fn by_created_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_after(inp);
            self
        }
        /// <p>Returns only recovery points that were created after the specified timestamp.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_after(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecoveryPointsByResource`.
    ///
    /// <p>Returns detailed information about all the recovery points of the type specified by a
    /// resource Amazon Resource Name (ARN).</p>
    /// <note>
    /// <p>For Amazon EFS and Amazon EC2, this action only lists recovery points
    /// created by Backup.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListRecoveryPointsByResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recovery_points_by_resource_input::Builder,
    }
    impl<C, M, R> ListRecoveryPointsByResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecoveryPointsByResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecoveryPointsByResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecoveryPointsByResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecoveryPointsByResourceInputOperationOutputAlias,
                crate::output::ListRecoveryPointsByResourceOutput,
                crate::error::ListRecoveryPointsByResourceError,
                crate::input::ListRecoveryPointsByResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the
        /// resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        /// <note>
        /// <p>Amazon RDS requires a value of at least 20.</p>
        /// </note>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        /// <note>
        /// <p>Amazon RDS requires a value of at least 20.</p>
        /// </note>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReportJobs`.
    ///
    /// <p>Returns details about your report jobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListReportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_report_jobs_input::Builder,
    }
    impl<C, M, R> ListReportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReportJobsInputOperationOutputAlias,
                crate::output::ListReportJobsOutput,
                crate::error::ListReportJobsError,
                crate::input::ListReportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns only report jobs with the specified report plan name.</p>
        pub fn by_report_plan_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_report_plan_name(inp);
            self
        }
        /// <p>Returns only report jobs with the specified report plan name.</p>
        pub fn set_by_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_report_plan_name(input);
            self
        }
        /// <p>Returns only report jobs that were created before the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn by_creation_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_creation_before(inp);
            self
        }
        /// <p>Returns only report jobs that were created before the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn set_by_creation_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_creation_before(input);
            self
        }
        /// <p>Returns only report jobs that were created after the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn by_creation_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_creation_after(inp);
            self
        }
        /// <p>Returns only report jobs that were created after the date and time specified in Unix
        /// format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents
        /// Friday, January 26, 2018 12:11:30 AM.</p>
        pub fn set_by_creation_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_creation_after(input);
            self
        }
        /// <p>Returns only report jobs that are in the specified status. The statuses are:</p>
        /// <p>
        /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
        /// </p>
        pub fn by_status(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_status(inp);
            self
        }
        /// <p>Returns only report jobs that are in the specified status. The statuses are:</p>
        /// <p>
        /// <code>CREATED | RUNNING | COMPLETED | FAILED</code>
        /// </p>
        pub fn set_by_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_by_status(input);
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReportPlans`.
    ///
    /// <p>Returns a list of your report plans. For detailed information about a single report
    /// plan, use <code>DescribeReportPlan</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListReportPlans<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_report_plans_input::Builder,
    }
    impl<C, M, R> ListReportPlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReportPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportPlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReportPlansInputOperationOutputAlias,
                crate::output::ListReportPlansOutput,
                crate::error::ListReportPlansError,
                crate::input::ListReportPlansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will
        /// return 1 MB of data.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRestoreJobs`.
    ///
    /// <p>Returns a list of jobs that Backup initiated to restore a saved resource,
    /// including details about the recovery process.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRestoreJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_restore_jobs_input::Builder,
    }
    impl<C, M, R> ListRestoreJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRestoreJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRestoreJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRestoreJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRestoreJobsInputOperationOutputAlias,
                crate::output::ListRestoreJobsOutput,
                crate::error::ListRestoreJobsError,
                crate::input::ListRestoreJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The account ID to list the jobs from. Returns only restore jobs associated with the
        /// specified account ID.</p>
        pub fn by_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.by_account_id(inp);
            self
        }
        /// <p>The account ID to list the jobs from. Returns only restore jobs associated with the
        /// specified account ID.</p>
        pub fn set_by_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_by_account_id(input);
            self
        }
        /// <p>Returns only restore jobs that were created before the specified date.</p>
        pub fn by_created_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_before(inp);
            self
        }
        /// <p>Returns only restore jobs that were created before the specified date.</p>
        pub fn set_by_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_before(input);
            self
        }
        /// <p>Returns only restore jobs that were created after the specified date.</p>
        pub fn by_created_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.by_created_after(inp);
            self
        }
        /// <p>Returns only restore jobs that were created after the specified date.</p>
        pub fn set_by_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_by_created_after(input);
            self
        }
        /// <p>Returns only restore jobs associated with the specified job status.</p>
        pub fn by_status(mut self, inp: crate::model::RestoreJobStatus) -> Self {
            self.inner = self.inner.by_status(inp);
            self
        }
        /// <p>Returns only restore jobs associated with the specified job status.</p>
        pub fn set_by_status(
            mut self,
            input: std::option::Option<crate::model::RestoreJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_by_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Returns a list of key-value pairs assigned to a target recovery point, backup plan, or
    /// backup vault.</p>
    /// <note>
    /// <p>
    /// <code>ListTags</code> are currently only supported with Amazon EFS
    /// backups.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the type of resource. Valid targets for <code>ListTags</code> are recovery
        /// points, backup plans, and backup vaults.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the type of resource. Valid targets for <code>ListTags</code> are recovery
        /// points, backup plans, and backup vaults.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next item following a partial list of returned items. For example, if a request is
        /// made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you
        /// to return more items in your list starting at the location pointed to by the next
        /// token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBackupVaultAccessPolicy`.
    ///
    /// <p>Sets a resource-based policy that is used to manage access permissions on the target
    /// backup vault. Requires a backup vault name and an access policy document in JSON
    /// format.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutBackupVaultAccessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_backup_vault_access_policy_input::Builder,
    }
    impl<C, M, R> PutBackupVaultAccessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBackupVaultAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBackupVaultAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBackupVaultAccessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBackupVaultAccessPolicyInputOperationOutputAlias,
                crate::output::PutBackupVaultAccessPolicyOutput,
                crate::error::PutBackupVaultAccessPolicyError,
                crate::input::PutBackupVaultAccessPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>The backup vault access policy document in JSON format.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The backup vault access policy document in JSON format.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBackupVaultLockConfiguration`.
    ///
    /// <p>Applies Backup Vault Lock to a backup vault, preventing attempts to delete
    /// any recovery point stored in or created in a backup vault. Vault Lock also prevents
    /// attempts to update the lifecycle policy that controls the retention period of any recovery
    /// point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and
    /// maximum retention period for future backup and copy jobs that target a backup vault.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutBackupVaultLockConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_backup_vault_lock_configuration_input::Builder,
    }
    impl<C, M, R> PutBackupVaultLockConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBackupVaultLockConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBackupVaultLockConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBackupVaultLockConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBackupVaultLockConfigurationInputOperationOutputAlias,
                crate::output::PutBackupVaultLockConfigurationOutput,
                crate::error::PutBackupVaultLockConfigurationError,
                crate::input::PutBackupVaultLockConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Backup Vault Lock configuration that specifies the name of the backup
        /// vault it protects.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the name of the backup
        /// vault it protects.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the minimum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to retain certain data for at least seven
        /// years (2555 days).</p>
        /// <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention
        /// period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or longer than the minimum retention
        /// period. If the job's retention period is shorter than that minimum retention period, then
        /// the vault fails that backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn min_retention_days(mut self, inp: i64) -> Self {
            self.inner = self.inner.min_retention_days(inp);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the minimum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to retain certain data for at least seven
        /// years (2555 days).</p>
        /// <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention
        /// period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or longer than the minimum retention
        /// period. If the job's retention period is shorter than that minimum retention period, then
        /// the vault fails that backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn set_min_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_min_retention_days(input);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the maximum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to destroy certain data after retaining
        /// it for four years (1460 days).</p>
        /// <p>If this parameter is not included, Vault Lock does not enforce a maximum retention
        /// period on the recovery points in the vault. If this parameter is included without a value,
        /// Vault Lock will not enforce a maximum retention period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or shorter than the maximum retention
        /// period. If the job's retention period is longer than that maximum retention period, then
        /// the vault fails the backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn max_retention_days(mut self, inp: i64) -> Self {
            self.inner = self.inner.max_retention_days(inp);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the maximum retention
        /// period that the vault retains its recovery points. This setting can be useful if, for
        /// example, your organization's policies require you to destroy certain data after retaining
        /// it for four years (1460 days).</p>
        /// <p>If this parameter is not included, Vault Lock does not enforce a maximum retention
        /// period on the recovery points in the vault. If this parameter is included without a value,
        /// Vault Lock will not enforce a maximum retention period.</p>
        /// <p>If this parameter is specified, any backup or copy job to the vault must have a
        /// lifecycle policy with a retention period equal to or shorter than the maximum retention
        /// period. If the job's retention period is longer than that maximum retention period, then
        /// the vault fails the backup or copy job, and you should either modify your lifecycle
        /// settings or use a different vault. Recovery points already saved in the vault prior to
        /// Vault Lock are not affected.</p>
        pub fn set_max_retention_days(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_max_retention_days(input);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the number of days before
        /// the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at
        /// 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p>
        /// <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect
        /// and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or
        /// greater.</p>
        /// <p>Before the lock date, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault
        /// Lock becomes immutable and cannot be changed or deleted.</p>
        /// <p>If this parameter is not specified, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code> at any time.</p>
        pub fn changeable_for_days(mut self, inp: i64) -> Self {
            self.inner = self.inner.changeable_for_days(inp);
            self
        }
        /// <p>The Backup Vault Lock configuration that specifies the number of days before
        /// the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at
        /// 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p>
        /// <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect
        /// and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or
        /// greater.</p>
        /// <p>Before the lock date, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault
        /// Lock becomes immutable and cannot be changed or deleted.</p>
        /// <p>If this parameter is not specified, you can delete Vault Lock from the vault using
        /// <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration
        /// using <code>PutBackupVaultLockConfiguration</code> at any time.</p>
        pub fn set_changeable_for_days(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_changeable_for_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBackupVaultNotifications`.
    ///
    /// <p>Turns on notifications on a backup vault for the specified topic and events.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutBackupVaultNotifications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_backup_vault_notifications_input::Builder,
    }
    impl<C, M, R> PutBackupVaultNotifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBackupVaultNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBackupVaultNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBackupVaultNotificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBackupVaultNotificationsInputOperationOutputAlias,
                crate::output::PutBackupVaultNotificationsOutput,
                crate::error::PutBackupVaultNotificationsError,
                crate::input::PutBackupVaultNotificationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for
        /// example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for
        /// example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// Appends an item to `BackupVaultEvents`.
        ///
        /// To override the contents of this collection use [`set_backup_vault_events`](Self::set_backup_vault_events).
        ///
        /// <p>An array of events that indicate the status of jobs to back up resources to the backup
        /// vault.</p>
        /// <note>
        /// <p>The following events are supported:</p>
        /// <p>
        /// <code>BACKUP_JOB_STARTED</code>, <code>BACKUP_JOB_COMPLETED</code>,</p>
        /// <p>
        /// <code>COPY_JOB_STARTED</code>, <code>COPY_JOB_SUCCESSFUL</code>,
        /// <code>COPY_JOB_FAILED</code>,</p>
        /// <p>
        /// <code>RESTORE_JOB_STARTED</code>, <code>RESTORE_JOB_COMPLETED</code>, and
        /// <code>RECOVERY_POINT_MODIFIED</code>.</p>
        /// <p>To find failed backup jobs, use <code>BACKUP_JOB_COMPLETED</code> and filter using
        /// event metadata.</p>
        /// <p>Other events in the following list are deprecated.</p>
        /// </note>
        pub fn backup_vault_events(
            mut self,
            inp: impl Into<crate::model::BackupVaultEvent>,
        ) -> Self {
            self.inner = self.inner.backup_vault_events(inp);
            self
        }
        /// <p>An array of events that indicate the status of jobs to back up resources to the backup
        /// vault.</p>
        /// <note>
        /// <p>The following events are supported:</p>
        /// <p>
        /// <code>BACKUP_JOB_STARTED</code>, <code>BACKUP_JOB_COMPLETED</code>,</p>
        /// <p>
        /// <code>COPY_JOB_STARTED</code>, <code>COPY_JOB_SUCCESSFUL</code>,
        /// <code>COPY_JOB_FAILED</code>,</p>
        /// <p>
        /// <code>RESTORE_JOB_STARTED</code>, <code>RESTORE_JOB_COMPLETED</code>, and
        /// <code>RECOVERY_POINT_MODIFIED</code>.</p>
        /// <p>To find failed backup jobs, use <code>BACKUP_JOB_COMPLETED</code> and filter using
        /// event metadata.</p>
        /// <p>Other events in the following list are deprecated.</p>
        /// </note>
        pub fn set_backup_vault_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupVaultEvent>>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_events(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBackupJob`.
    ///
    /// <p>Starts an on-demand backup job for the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartBackupJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_backup_job_input::Builder,
    }
    impl<C, M, R> StartBackupJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBackupJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBackupJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBackupJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartBackupJobInputOperationOutputAlias,
                crate::output::StartBackupJobOutput,
                crate::error::StartBackupJobError,
                crate::input::StartBackupJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN
        /// depends on the resource type.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>Specifies the IAM role ARN used to create the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartBackupJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartBackupJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional, and the default is 8 hours.</p>
        pub fn start_window_minutes(mut self, inp: i64) -> Self {
            self.inner = self.inner.start_window_minutes(inp);
            self
        }
        /// <p>A value in minutes after a backup is scheduled before a job will be canceled if it
        /// doesn't start successfully. This value is optional, and the default is 8 hours.</p>
        pub fn set_start_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_start_window_minutes(input);
            self
        }
        /// <p>A value in minutes during which a successfully started backup must complete, or else AWS
        /// Backup will cancel the job. This value is optional. This value begins counting down from
        /// when the backup was scheduled. It does not add additional time for
        /// <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p>
        pub fn complete_window_minutes(mut self, inp: i64) -> Self {
            self.inner = self.inner.complete_window_minutes(inp);
            self
        }
        /// <p>A value in minutes during which a successfully started backup must complete, or else AWS
        /// Backup will cancel the job. This value is optional. This value begins counting down from
        /// when the backup was scheduled. It does not add additional time for
        /// <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p>
        pub fn set_complete_window_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_complete_window_minutes(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup will transition and expire backups automatically according
        /// to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, inp: crate::model::Lifecycle) -> Self {
            self.inner = self.inner.lifecycle(inp);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup will transition and expire backups automatically according
        /// to the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle(input);
            self
        }
        /// Adds a key-value pair to `RecoveryPointTags`.
        ///
        /// To override the contents of this collection use [`set_recovery_point_tags`](Self::set_recovery_point_tags).
        ///
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair.</p>
        pub fn recovery_point_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.recovery_point_tags(k, v);
            self
        }
        /// <p>To help organize your resources, you can assign your own metadata to the resources that
        /// you create. Each tag is a key-value pair.</p>
        pub fn set_recovery_point_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_tags(input);
            self
        }
        /// Adds a key-value pair to `BackupOptions`.
        ///
        /// To override the contents of this collection use [`set_backup_options`](Self::set_backup_options).
        ///
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
        /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
        /// <code>"WindowsVSS""disabled"</code> to create a regular backup. The
        /// <code>WindowsVSS</code> option is not enabled by default.</p>
        pub fn backup_options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.backup_options(k, v);
            self
        }
        /// <p>Specifies the backup option for a selected resource. This option is only available for
        /// Windows Volume Shadow Copy Service (VSS) backup jobs.</p>
        /// <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the
        /// <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to
        /// <code>"WindowsVSS""disabled"</code> to create a regular backup. The
        /// <code>WindowsVSS</code> option is not enabled by default.</p>
        pub fn set_backup_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_backup_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCopyJob`.
    ///
    /// <p>Starts a job to create a one-time copy of the specified resource.</p>
    /// <p>Does not support continuous backups.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartCopyJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_copy_job_input::Builder,
    }
    impl<C, M, R> StartCopyJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartCopyJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCopyJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCopyJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartCopyJobInputOperationOutputAlias,
                crate::output::StartCopyJobOutput,
                crate::error::StartCopyJobError,
                crate::input::StartCopyJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An ARN that uniquely identifies a recovery point to use for the copy job; for example,
        /// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
        /// </p>
        pub fn recovery_point_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_point_arn(inp);
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point to use for the copy job; for example,
        /// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
        /// </p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_arn(input);
            self
        }
        /// <p>The name of a logical source container where backups are stored. Backup vaults are
        /// identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers,
        /// and hyphens.</p>
        pub fn source_backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical source container where backups are stored. Backup vaults are
        /// identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers,
        /// and hyphens.</p>
        pub fn set_source_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_backup_vault_name(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to
        /// copy to; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn destination_backup_vault_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_backup_vault_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to
        /// copy to; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>
        pub fn set_destination_backup_vault_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_backup_vault_arn(input);
            self
        }
        /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>Specifies the IAM role ARN used to copy the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency
        /// token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency
        /// token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
        /// a recovery point transitions to cold storage or is deleted.</p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
        /// than the “transition to cold after days” setting. The “transition to cold after days”
        /// setting cannot be changed after a backup has been transitioned to cold.</p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn lifecycle(mut self, inp: crate::model::Lifecycle) -> Self {
            self.inner = self.inner.lifecycle(inp);
            self
        }
        /// <p>Contains an array of <code>Transition</code> objects specifying how long in days before
        /// a recovery point transitions to cold storage or is deleted.</p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, on the console, the “expire after days” setting must be 90 days greater
        /// than the “transition to cold after days” setting. The “transition to cold after days”
        /// setting cannot be changed after a backup has been transitioned to cold.</p>
        /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReportJob`.
    ///
    /// <p>Starts an on-demand report job for the specified report plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartReportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_report_job_input::Builder,
    }
    impl<C, M, R> StartReportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartReportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartReportJobInputOperationOutputAlias,
                crate::output::StartReportJobOutput,
                crate::error::StartReportJobError,
                crate::input::StartReportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a report plan.</p>
        pub fn report_plan_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_plan_name(inp);
            self
        }
        /// <p>The unique name of a report plan.</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_plan_name(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartReportJobInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartReportJobInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRestoreJob`.
    ///
    /// <p>Recovers the saved resource identified by an Amazon Resource Name (ARN).</p>
    #[derive(std::fmt::Debug)]
    pub struct StartRestoreJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_restore_job_input::Builder,
    }
    impl<C, M, R> StartRestoreJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartRestoreJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRestoreJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartRestoreJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartRestoreJobInputOperationOutputAlias,
                crate::output::StartRestoreJobOutput,
                crate::error::StartRestoreJobError,
                crate::input::StartRestoreJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_point_arn(inp);
            self
        }
        /// <p>An ARN that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_arn(input);
            self
        }
        /// Adds a key-value pair to `Metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A set of metadata key-value pairs. Contains information, such as a resource name,
        /// required to restore a recovery point.</p>
        /// <p> You can get configuration metadata about a resource at the time it was backed up by
        /// calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those
        /// provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a
        /// resource. For example, you might need to provide a new resource name if the original
        /// already exists.</p>
        /// <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>file-system-id</code>: The ID of the Amazon EFS file system that is
        /// backed up by Backup. Returned in
        /// <code>GetRecoveryPointRestoreMetadata</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Encrypted</code>: A Boolean value that, if true, specifies that the file
        /// system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code>
        /// must be set to <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to
        /// encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PerformanceMode</code>: Specifies the throughput mode of the file
        /// system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationToken</code>: A user-supplied value that ensures the uniqueness
        /// (idempotency) of the request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>newFileSystem</code>: A Boolean value that, if true, specifies that the
        /// recovery point is restored to a new Amazon EFS file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ItemsToRestore</code>: An array of one to five strings where each string is
        /// a file path. Use <code>ItemsToRestore</code> to restore specific files or directories
        /// rather than the entire file system. This parameter is optional. For example,
        /// <code>"itemsToRestore":"[\"/my.test\"]"</code>.</p>
        /// </li>
        /// </ul>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k, v);
            self
        }
        /// <p>A set of metadata key-value pairs. Contains information, such as a resource name,
        /// required to restore a recovery point.</p>
        /// <p> You can get configuration metadata about a resource at the time it was backed up by
        /// calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those
        /// provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a
        /// resource. For example, you might need to provide a new resource name if the original
        /// already exists.</p>
        /// <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>file-system-id</code>: The ID of the Amazon EFS file system that is
        /// backed up by Backup. Returned in
        /// <code>GetRecoveryPointRestoreMetadata</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Encrypted</code>: A Boolean value that, if true, specifies that the file
        /// system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code>
        /// must be set to <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to
        /// encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PerformanceMode</code>: Specifies the throughput mode of the file
        /// system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationToken</code>: A user-supplied value that ensures the uniqueness
        /// (idempotency) of the request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>newFileSystem</code>: A Boolean value that, if true, specifies that the
        /// recovery point is restored to a new Amazon EFS file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ItemsToRestore</code>: An array of one to five strings where each string is
        /// a file path. Use <code>ItemsToRestore</code> to restore specific files or directories
        /// rather than the entire file system. This parameter is optional. For example,
        /// <code>"itemsToRestore":"[\"/my.test\"]"</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
        /// the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
        /// the target recovery point; for example,
        /// <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartRestoreJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>StartRestoreJob</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>Starts a job to restore a recovery point for one of the following resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>Starts a job to restore a recovery point for one of the following resources:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DynamoDB</code> for Amazon DynamoDB</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EBS</code> for Amazon Elastic Block Store</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EC2</code> for Amazon Elastic Compute Cloud</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EFS</code> for Amazon Elastic File System</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RDS</code> for Amazon Relational Database Service</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Aurora</code> for Amazon Aurora</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Storage Gateway</code> for Storage Gateway</p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBackupJob`.
    ///
    /// <p>Attempts to cancel a job to create a one-time backup of a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopBackupJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_backup_job_input::Builder,
    }
    impl<C, M, R> StopBackupJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopBackupJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBackupJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBackupJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopBackupJobInputOperationOutputAlias,
                crate::output::StopBackupJobOutput,
                crate::error::StopBackupJobError,
                crate::input::StopBackupJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn backup_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_job_id(inp);
            self
        }
        /// <p>Uniquely identifies a request to Backup to back up a resource.</p>
        pub fn set_backup_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault
    /// identified by an Amazon Resource Name (ARN).</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that are used to help organize your resources. You can assign your own
        /// metadata to the resources you create.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Key-value pairs that are used to help organize your resources. You can assign your own
        /// metadata to the resources you create.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a set of key-value pairs from a recovery point, backup plan, or backup vault
    /// identified by an Amazon Resource Name (ARN)</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of
        /// the tagged resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeyList`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of keys to identify which key-value tags to remove from a resource.</p>
        pub fn tag_key_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key_list(inp);
            self
        }
        /// <p>A list of keys to identify which key-value tags to remove from a resource.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_key_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBackupPlan`.
    ///
    /// <p>Updates an existing backup plan identified by its <code>backupPlanId</code> with the
    /// input document in JSON format. The new version is uniquely identified by a
    /// <code>VersionId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBackupPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_backup_plan_input::Builder,
    }
    impl<C, M, R> UpdateBackupPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBackupPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBackupPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBackupPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBackupPlanInputOperationOutputAlias,
                crate::output::UpdateBackupPlanOutput,
                crate::error::UpdateBackupPlanError,
                crate::input::UpdateBackupPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn backup_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_plan_id(inp);
            self
        }
        /// <p>Uniquely identifies a backup plan.</p>
        pub fn set_backup_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan_id(input);
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn backup_plan(mut self, inp: crate::model::BackupPlanInput) -> Self {
            self.inner = self.inner.backup_plan(inp);
            self
        }
        /// <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or
        /// more sets of <code>Rules</code>.</p>
        pub fn set_backup_plan(
            mut self,
            input: std::option::Option<crate::model::BackupPlanInput>,
        ) -> Self {
            self.inner = self.inner.set_backup_plan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFramework`.
    ///
    /// <p>Updates an existing framework identified by its <code>FrameworkName</code> with the
    /// input document in JSON format.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_framework_input::Builder,
    }
    impl<C, M, R> UpdateFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFrameworkInputOperationOutputAlias,
                crate::output::UpdateFrameworkOutput,
                crate::error::UpdateFrameworkError,
                crate::input::UpdateFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
        /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn framework_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_name(inp);
            self
        }
        /// <p>The unique name of a framework. This name is between 1 and 256 characters, starting with
        /// a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_name(input);
            self
        }
        /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
        pub fn framework_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_description(inp);
            self
        }
        /// <p>An optional description of the framework with a maximum 1,024 characters.</p>
        pub fn set_framework_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_description(input);
            self
        }
        /// Appends an item to `FrameworkControls`.
        ///
        /// To override the contents of this collection use [`set_framework_controls`](Self::set_framework_controls).
        ///
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn framework_controls(
            mut self,
            inp: impl Into<crate::model::FrameworkControl>,
        ) -> Self {
            self.inner = self.inner.framework_controls(inp);
            self
        }
        /// <p>A list of the controls that make up the framework. Each control in the list has a name,
        /// input parameters, and scope.</p>
        pub fn set_framework_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FrameworkControl>>,
        ) -> Self {
            self.inner = self.inner.set_framework_controls(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalSettings`.
    ///
    /// <p>Updates whether the Amazon Web Services account is opted in to cross-account backup.
    /// Returns an error if the account is not an Organizations management account. Use the
    /// <code>DescribeGlobalSettings</code> API to determine the current settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGlobalSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_global_settings_input::Builder,
    }
    impl<C, M, R> UpdateGlobalSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGlobalSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGlobalSettingsInputOperationOutputAlias,
                crate::output::UpdateGlobalSettingsOutput,
                crate::error::UpdateGlobalSettingsError,
                crate::input::UpdateGlobalSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `GlobalSettings`.
        ///
        /// To override the contents of this collection use [`set_global_settings`](Self::set_global_settings).
        ///
        /// <p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example:
        /// <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false
        /// --region us-west-2</code>.</p>
        pub fn global_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_settings(k, v);
            self
        }
        /// <p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example:
        /// <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false
        /// --region us-west-2</code>.</p>
        pub fn set_global_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_global_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecoveryPointLifecycle`.
    ///
    /// <p>Sets the transition lifecycle of a recovery point.</p>
    /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
    /// it expires. Backup transitions and expires backups automatically according to
    /// the lifecycle that you define.</p>
    /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
    /// days. Therefore, the “expire after days” setting must be 90 days greater than the
    /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
    /// be changed after a backup has been transitioned to cold.</p>
    /// <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>
    /// <p>Does not support continuous backups.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRecoveryPointLifecycle<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recovery_point_lifecycle_input::Builder,
    }
    impl<C, M, R> UpdateRecoveryPointLifecycle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecoveryPointLifecycle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecoveryPointLifecycleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecoveryPointLifecycleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecoveryPointLifecycleInputOperationOutputAlias,
                crate::output::UpdateRecoveryPointLifecycleOutput,
                crate::error::UpdateRecoveryPointLifecycleError,
                crate::input::UpdateRecoveryPointLifecycleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn backup_vault_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_vault_name(inp);
            self
        }
        /// <p>The name of a logical container where backups are stored. Backup vaults are identified
        /// by names that are unique to the account used to create them and the Amazon Web Services
        /// Region where they are created. They consist of lowercase letters, numbers, and
        /// hyphens.</p>
        pub fn set_backup_vault_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backup_vault_name(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn recovery_point_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_point_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
        /// <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
        pub fn set_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_point_arn(input);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        pub fn lifecycle(mut self, inp: crate::model::Lifecycle) -> Self {
            self.inner = self.inner.lifecycle(inp);
            self
        }
        /// <p>The lifecycle defines when a protected resource is transitioned to cold storage and when
        /// it expires. Backup transitions and expires backups automatically according to
        /// the lifecycle that you define. </p>
        /// <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90
        /// days. Therefore, the “expire after days” setting must be 90 days greater than the
        /// “transition to cold after days” setting. The “transition to cold after days” setting cannot
        /// be changed after a backup has been transitioned to cold. </p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::Lifecycle>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegionSettings`.
    ///
    /// <p>Updates the current service opt-in settings for the Region. If service-opt-in is enabled
    /// for a service, Backup tries to protect that service's resources in this Region,
    /// when the resource is included in an on-demand backup or scheduled backup plan. Otherwise,
    /// Backup does not try to protect that service's resources in this Region. Use
    /// the <code>DescribeRegionSettings</code> API to determine the resource types that are
    /// supported.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRegionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_region_settings_input::Builder,
    }
    impl<C, M, R> UpdateRegionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRegionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRegionSettingsInputOperationOutputAlias,
                crate::output::UpdateRegionSettingsOutput,
                crate::error::UpdateRegionSettingsError,
                crate::input::UpdateRegionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `ResourceTypeOptInPreference`.
        ///
        /// To override the contents of this collection use [`set_resource_type_opt_in_preference`](Self::set_resource_type_opt_in_preference).
        ///
        /// <p>Updates the list of services along with the opt-in preferences for the Region.</p>
        pub fn resource_type_opt_in_preference(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<bool>,
        ) -> Self {
            self.inner = self.inner.resource_type_opt_in_preference(k, v);
            self
        }
        /// <p>Updates the list of services along with the opt-in preferences for the Region.</p>
        pub fn set_resource_type_opt_in_preference(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, bool>>,
        ) -> Self {
            self.inner = self.inner.set_resource_type_opt_in_preference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReportPlan`.
    ///
    /// <p>Updates an existing report plan identified by its <code>ReportPlanName</code> with the
    /// input document in JSON format.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateReportPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_report_plan_input::Builder,
    }
    impl<C, M, R> UpdateReportPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReportPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReportPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReportPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReportPlanInputOperationOutputAlias,
                crate::output::UpdateReportPlanOutput,
                crate::error::UpdateReportPlanError,
                crate::input::UpdateReportPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the report plan. This name is between 1 and 256 characters, starting
        /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
        /// (_).</p>
        pub fn report_plan_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_plan_name(inp);
            self
        }
        /// <p>The unique name of the report plan. This name is between 1 and 256 characters, starting
        /// with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores
        /// (_).</p>
        pub fn set_report_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_plan_name(input);
            self
        }
        /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
        pub fn report_plan_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_plan_description(inp);
            self
        }
        /// <p>An optional description of the report plan with a maximum 1,024 characters.</p>
        pub fn set_report_plan_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_plan_description(input);
            self
        }
        /// <p>A structure that contains information about where to deliver your reports, specifically
        /// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
        pub fn report_delivery_channel(mut self, inp: crate::model::ReportDeliveryChannel) -> Self {
            self.inner = self.inner.report_delivery_channel(inp);
            self
        }
        /// <p>A structure that contains information about where to deliver your reports, specifically
        /// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>
        pub fn set_report_delivery_channel(
            mut self,
            input: std::option::Option<crate::model::ReportDeliveryChannel>,
        ) -> Self {
            self.inner = self.inner.set_report_delivery_channel(input);
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn report_setting(mut self, inp: crate::model::ReportSetting) -> Self {
            self.inner = self.inner.report_setting(inp);
            self
        }
        /// <p>Identifies the report template for the report. Reports are built using a report
        /// template. The report templates are:</p>
        /// <p>
        /// <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
        /// COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
        /// </p>
        /// <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
        /// <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report
        /// coverage by Amazon Web Services Regions and frameworks.</p>
        pub fn set_report_setting(
            mut self,
            input: std::option::Option<crate::model::ReportSetting>,
        ) -> Self {
            self.inner = self.inner.set_report_setting(input);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A customer-chosen string that you can use to distinguish between otherwise identical
        /// calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same
        /// idempotency token results in a success message with no action taken.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
