// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a scaling instruction for a scalable resource in a scaling plan. Each scaling instruction applies to one resource.</p>
/// <p>AWS Auto Scaling creates target tracking scaling policies based on the scaling instructions. Target tracking scaling policies adjust the capacity of your scalable resource as required to maintain resource utilization at the target value that you specified. </p>
/// <p>AWS Auto Scaling also configures predictive scaling for your Amazon EC2 Auto Scaling groups using a subset of parameters, including the load metric, the scaling metric, the target value for the scaling metric, the predictive scaling mode (forecast and scale or forecast only), and the desired behavior when the forecast capacity exceeds the maximum capacity of the resource. With predictive scaling, AWS Auto Scaling generates forecasts with traffic predictions for the two days ahead and schedules scaling actions that proactively add and remove resource capacity to match the forecast. </p> <important>
/// <p>We recommend waiting a minimum of 24 hours after creating an Auto Scaling group to configure predictive scaling. At minimum, there must be 24 hours of historical data to generate a forecast. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-best-practices.html">Best Practices for AWS Auto Scaling</a> in the <i>AWS Auto Scaling User Guide</i>.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingInstruction {
    /// <p>The namespace of the AWS service.</p>
    pub service_namespace: std::option::Option<crate::model::ServiceNamespace>,
    /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The scalable dimension associated with the resource.</p>
    /// <ul>
    /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// </ul>
    pub scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
    /// <p>The minimum capacity of the resource. </p>
    pub min_capacity: std::option::Option<i32>,
    /// <p>The maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for <b>PredictiveScalingMaxCapacityBehavior</b>. </p>
    pub max_capacity: std::option::Option<i32>,
    /// <p>The target tracking configurations (up to 10). Each of these structures must specify a unique scaling metric and a target value for the metric. </p>
    pub target_tracking_configurations:
        std::option::Option<std::vec::Vec<crate::model::TargetTrackingConfiguration>>,
    /// <p>The predefined load metric to use for predictive scaling. This parameter or a <b>CustomizedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
    pub predefined_load_metric_specification:
        std::option::Option<crate::model::PredefinedLoadMetricSpecification>,
    /// <p>The customized load metric to use for predictive scaling. This parameter or a <b>PredefinedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
    pub customized_load_metric_specification:
        std::option::Option<crate::model::CustomizedLoadMetricSpecification>,
    /// <p>The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete. </p>
    /// <p>The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds. </p>
    /// <p>Only valid when configuring predictive scaling. </p>
    pub scheduled_action_buffer_time: std::option::Option<i32>,
    /// <p>Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource. The default value is <code>SetForecastCapacityToMaxCapacity</code>.</p>
    /// <p>The following are possible values:</p>
    /// <ul>
    /// <li> <p> <code>SetForecastCapacityToMaxCapacity</code> - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit. </p> </li>
    /// <li> <p> <code>SetMaxCapacityToForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.</p> </li>
    /// <li> <p> <code>SetMaxCapacityAboveForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs. </p> </li>
    /// </ul>
    /// <p>Only valid when configuring predictive scaling.</p>
    pub predictive_scaling_max_capacity_behavior:
        std::option::Option<crate::model::PredictiveScalingMaxCapacityBehavior>,
    /// <p>The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.</p>
    /// <p>Only valid when configuring predictive scaling. Required if the <b>PredictiveScalingMaxCapacityBehavior</b> is set to <code>SetMaxCapacityAboveForecastCapacity</code>, and cannot be used otherwise.</p>
    /// <p>The range is 1-100.</p>
    pub predictive_scaling_max_capacity_buffer: std::option::Option<i32>,
    /// <p>The predictive scaling mode. The default value is <code>ForecastAndScale</code>. Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions based on the capacity forecast. </p>
    pub predictive_scaling_mode: std::option::Option<crate::model::PredictiveScalingMode>,
    /// <p>Controls whether a resource's externally created scaling policies are kept or replaced. </p>
    /// <p>The default value is <code>KeepExternalPolicies</code>. If the parameter is set to <code>ReplaceExternalPolicies</code>, any scaling policies that are external to AWS Auto Scaling are deleted and new target tracking scaling policies created. </p>
    /// <p>Only valid when configuring dynamic scaling. </p>
    /// <p>Condition: The number of existing policies to be replaced must be less than or equal to 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies and does not create new ones.</p>
    pub scaling_policy_update_behavior:
        std::option::Option<crate::model::ScalingPolicyUpdateBehavior>,
    /// <p>Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations. </p>
    /// <p>The default is enabled (<code>false</code>). </p>
    pub disable_dynamic_scaling: std::option::Option<bool>,
}
impl ScalingInstruction {
    /// <p>The namespace of the AWS service.</p>
    pub fn service_namespace(&self) -> std::option::Option<&crate::model::ServiceNamespace> {
        self.service_namespace.as_ref()
    }
    /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The scalable dimension associated with the resource.</p>
    /// <ul>
    /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// </ul>
    pub fn scalable_dimension(&self) -> std::option::Option<&crate::model::ScalableDimension> {
        self.scalable_dimension.as_ref()
    }
    /// <p>The minimum capacity of the resource. </p>
    pub fn min_capacity(&self) -> std::option::Option<i32> {
        self.min_capacity
    }
    /// <p>The maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for <b>PredictiveScalingMaxCapacityBehavior</b>. </p>
    pub fn max_capacity(&self) -> std::option::Option<i32> {
        self.max_capacity
    }
    /// <p>The target tracking configurations (up to 10). Each of these structures must specify a unique scaling metric and a target value for the metric. </p>
    pub fn target_tracking_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::TargetTrackingConfiguration]> {
        self.target_tracking_configurations.as_deref()
    }
    /// <p>The predefined load metric to use for predictive scaling. This parameter or a <b>CustomizedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
    pub fn predefined_load_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredefinedLoadMetricSpecification> {
        self.predefined_load_metric_specification.as_ref()
    }
    /// <p>The customized load metric to use for predictive scaling. This parameter or a <b>PredefinedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
    pub fn customized_load_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::CustomizedLoadMetricSpecification> {
        self.customized_load_metric_specification.as_ref()
    }
    /// <p>The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete. </p>
    /// <p>The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds. </p>
    /// <p>Only valid when configuring predictive scaling. </p>
    pub fn scheduled_action_buffer_time(&self) -> std::option::Option<i32> {
        self.scheduled_action_buffer_time
    }
    /// <p>Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource. The default value is <code>SetForecastCapacityToMaxCapacity</code>.</p>
    /// <p>The following are possible values:</p>
    /// <ul>
    /// <li> <p> <code>SetForecastCapacityToMaxCapacity</code> - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit. </p> </li>
    /// <li> <p> <code>SetMaxCapacityToForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.</p> </li>
    /// <li> <p> <code>SetMaxCapacityAboveForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs. </p> </li>
    /// </ul>
    /// <p>Only valid when configuring predictive scaling.</p>
    pub fn predictive_scaling_max_capacity_behavior(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingMaxCapacityBehavior> {
        self.predictive_scaling_max_capacity_behavior.as_ref()
    }
    /// <p>The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.</p>
    /// <p>Only valid when configuring predictive scaling. Required if the <b>PredictiveScalingMaxCapacityBehavior</b> is set to <code>SetMaxCapacityAboveForecastCapacity</code>, and cannot be used otherwise.</p>
    /// <p>The range is 1-100.</p>
    pub fn predictive_scaling_max_capacity_buffer(&self) -> std::option::Option<i32> {
        self.predictive_scaling_max_capacity_buffer
    }
    /// <p>The predictive scaling mode. The default value is <code>ForecastAndScale</code>. Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions based on the capacity forecast. </p>
    pub fn predictive_scaling_mode(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingMode> {
        self.predictive_scaling_mode.as_ref()
    }
    /// <p>Controls whether a resource's externally created scaling policies are kept or replaced. </p>
    /// <p>The default value is <code>KeepExternalPolicies</code>. If the parameter is set to <code>ReplaceExternalPolicies</code>, any scaling policies that are external to AWS Auto Scaling are deleted and new target tracking scaling policies created. </p>
    /// <p>Only valid when configuring dynamic scaling. </p>
    /// <p>Condition: The number of existing policies to be replaced must be less than or equal to 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies and does not create new ones.</p>
    pub fn scaling_policy_update_behavior(
        &self,
    ) -> std::option::Option<&crate::model::ScalingPolicyUpdateBehavior> {
        self.scaling_policy_update_behavior.as_ref()
    }
    /// <p>Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations. </p>
    /// <p>The default is enabled (<code>false</code>). </p>
    pub fn disable_dynamic_scaling(&self) -> std::option::Option<bool> {
        self.disable_dynamic_scaling
    }
}
impl std::fmt::Debug for ScalingInstruction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingInstruction");
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("scalable_dimension", &self.scalable_dimension);
        formatter.field("min_capacity", &self.min_capacity);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field(
            "target_tracking_configurations",
            &self.target_tracking_configurations,
        );
        formatter.field(
            "predefined_load_metric_specification",
            &self.predefined_load_metric_specification,
        );
        formatter.field(
            "customized_load_metric_specification",
            &self.customized_load_metric_specification,
        );
        formatter.field(
            "scheduled_action_buffer_time",
            &self.scheduled_action_buffer_time,
        );
        formatter.field(
            "predictive_scaling_max_capacity_behavior",
            &self.predictive_scaling_max_capacity_behavior,
        );
        formatter.field(
            "predictive_scaling_max_capacity_buffer",
            &self.predictive_scaling_max_capacity_buffer,
        );
        formatter.field("predictive_scaling_mode", &self.predictive_scaling_mode);
        formatter.field(
            "scaling_policy_update_behavior",
            &self.scaling_policy_update_behavior,
        );
        formatter.field("disable_dynamic_scaling", &self.disable_dynamic_scaling);
        formatter.finish()
    }
}
/// See [`ScalingInstruction`](crate::model::ScalingInstruction)
pub mod scaling_instruction {
    /// A builder for [`ScalingInstruction`](crate::model::ScalingInstruction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_namespace: std::option::Option<crate::model::ServiceNamespace>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
        pub(crate) min_capacity: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) target_tracking_configurations:
            std::option::Option<std::vec::Vec<crate::model::TargetTrackingConfiguration>>,
        pub(crate) predefined_load_metric_specification:
            std::option::Option<crate::model::PredefinedLoadMetricSpecification>,
        pub(crate) customized_load_metric_specification:
            std::option::Option<crate::model::CustomizedLoadMetricSpecification>,
        pub(crate) scheduled_action_buffer_time: std::option::Option<i32>,
        pub(crate) predictive_scaling_max_capacity_behavior:
            std::option::Option<crate::model::PredictiveScalingMaxCapacityBehavior>,
        pub(crate) predictive_scaling_max_capacity_buffer: std::option::Option<i32>,
        pub(crate) predictive_scaling_mode:
            std::option::Option<crate::model::PredictiveScalingMode>,
        pub(crate) scaling_policy_update_behavior:
            std::option::Option<crate::model::ScalingPolicyUpdateBehavior>,
        pub(crate) disable_dynamic_scaling: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The namespace of the AWS service.</p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.service_namespace = Some(input);
            self
        }
        /// <p>The namespace of the AWS service.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The scalable dimension associated with the resource.</p>
        /// <ul>
        /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// </ul>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.scalable_dimension = Some(input);
            self
        }
        /// <p>The scalable dimension associated with the resource.</p>
        /// <ul>
        /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// </ul>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.scalable_dimension = input;
            self
        }
        /// <p>The minimum capacity of the resource. </p>
        pub fn min_capacity(mut self, input: i32) -> Self {
            self.min_capacity = Some(input);
            self
        }
        /// <p>The minimum capacity of the resource. </p>
        pub fn set_min_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.min_capacity = input;
            self
        }
        /// <p>The maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for <b>PredictiveScalingMaxCapacityBehavior</b>. </p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for <b>PredictiveScalingMaxCapacityBehavior</b>. </p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// Appends an item to `target_tracking_configurations`.
        ///
        /// To override the contents of this collection use [`set_target_tracking_configurations`](Self::set_target_tracking_configurations).
        ///
        /// <p>The target tracking configurations (up to 10). Each of these structures must specify a unique scaling metric and a target value for the metric. </p>
        pub fn target_tracking_configurations(
            mut self,
            input: crate::model::TargetTrackingConfiguration,
        ) -> Self {
            let mut v = self.target_tracking_configurations.unwrap_or_default();
            v.push(input);
            self.target_tracking_configurations = Some(v);
            self
        }
        /// <p>The target tracking configurations (up to 10). Each of these structures must specify a unique scaling metric and a target value for the metric. </p>
        pub fn set_target_tracking_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetTrackingConfiguration>>,
        ) -> Self {
            self.target_tracking_configurations = input;
            self
        }
        /// <p>The predefined load metric to use for predictive scaling. This parameter or a <b>CustomizedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
        pub fn predefined_load_metric_specification(
            mut self,
            input: crate::model::PredefinedLoadMetricSpecification,
        ) -> Self {
            self.predefined_load_metric_specification = Some(input);
            self
        }
        /// <p>The predefined load metric to use for predictive scaling. This parameter or a <b>CustomizedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
        pub fn set_predefined_load_metric_specification(
            mut self,
            input: std::option::Option<crate::model::PredefinedLoadMetricSpecification>,
        ) -> Self {
            self.predefined_load_metric_specification = input;
            self
        }
        /// <p>The customized load metric to use for predictive scaling. This parameter or a <b>PredefinedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
        pub fn customized_load_metric_specification(
            mut self,
            input: crate::model::CustomizedLoadMetricSpecification,
        ) -> Self {
            self.customized_load_metric_specification = Some(input);
            self
        }
        /// <p>The customized load metric to use for predictive scaling. This parameter or a <b>PredefinedLoadMetricSpecification</b> is required when configuring predictive scaling, and cannot be used otherwise. </p>
        pub fn set_customized_load_metric_specification(
            mut self,
            input: std::option::Option<crate::model::CustomizedLoadMetricSpecification>,
        ) -> Self {
            self.customized_load_metric_specification = input;
            self
        }
        /// <p>The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete. </p>
        /// <p>The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds. </p>
        /// <p>Only valid when configuring predictive scaling. </p>
        pub fn scheduled_action_buffer_time(mut self, input: i32) -> Self {
            self.scheduled_action_buffer_time = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete. </p>
        /// <p>The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds. </p>
        /// <p>Only valid when configuring predictive scaling. </p>
        pub fn set_scheduled_action_buffer_time(mut self, input: std::option::Option<i32>) -> Self {
            self.scheduled_action_buffer_time = input;
            self
        }
        /// <p>Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource. The default value is <code>SetForecastCapacityToMaxCapacity</code>.</p>
        /// <p>The following are possible values:</p>
        /// <ul>
        /// <li> <p> <code>SetForecastCapacityToMaxCapacity</code> - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit. </p> </li>
        /// <li> <p> <code>SetMaxCapacityToForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.</p> </li>
        /// <li> <p> <code>SetMaxCapacityAboveForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs. </p> </li>
        /// </ul>
        /// <p>Only valid when configuring predictive scaling.</p>
        pub fn predictive_scaling_max_capacity_behavior(
            mut self,
            input: crate::model::PredictiveScalingMaxCapacityBehavior,
        ) -> Self {
            self.predictive_scaling_max_capacity_behavior = Some(input);
            self
        }
        /// <p>Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource. The default value is <code>SetForecastCapacityToMaxCapacity</code>.</p>
        /// <p>The following are possible values:</p>
        /// <ul>
        /// <li> <p> <code>SetForecastCapacityToMaxCapacity</code> - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit. </p> </li>
        /// <li> <p> <code>SetMaxCapacityToForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.</p> </li>
        /// <li> <p> <code>SetMaxCapacityAboveForecastCapacity</code> - AWS Auto Scaling may scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs. </p> </li>
        /// </ul>
        /// <p>Only valid when configuring predictive scaling.</p>
        pub fn set_predictive_scaling_max_capacity_behavior(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingMaxCapacityBehavior>,
        ) -> Self {
            self.predictive_scaling_max_capacity_behavior = input;
            self
        }
        /// <p>The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.</p>
        /// <p>Only valid when configuring predictive scaling. Required if the <b>PredictiveScalingMaxCapacityBehavior</b> is set to <code>SetMaxCapacityAboveForecastCapacity</code>, and cannot be used otherwise.</p>
        /// <p>The range is 1-100.</p>
        pub fn predictive_scaling_max_capacity_buffer(mut self, input: i32) -> Self {
            self.predictive_scaling_max_capacity_buffer = Some(input);
            self
        }
        /// <p>The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.</p>
        /// <p>Only valid when configuring predictive scaling. Required if the <b>PredictiveScalingMaxCapacityBehavior</b> is set to <code>SetMaxCapacityAboveForecastCapacity</code>, and cannot be used otherwise.</p>
        /// <p>The range is 1-100.</p>
        pub fn set_predictive_scaling_max_capacity_buffer(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.predictive_scaling_max_capacity_buffer = input;
            self
        }
        /// <p>The predictive scaling mode. The default value is <code>ForecastAndScale</code>. Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions based on the capacity forecast. </p>
        pub fn predictive_scaling_mode(
            mut self,
            input: crate::model::PredictiveScalingMode,
        ) -> Self {
            self.predictive_scaling_mode = Some(input);
            self
        }
        /// <p>The predictive scaling mode. The default value is <code>ForecastAndScale</code>. Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions based on the capacity forecast. </p>
        pub fn set_predictive_scaling_mode(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingMode>,
        ) -> Self {
            self.predictive_scaling_mode = input;
            self
        }
        /// <p>Controls whether a resource's externally created scaling policies are kept or replaced. </p>
        /// <p>The default value is <code>KeepExternalPolicies</code>. If the parameter is set to <code>ReplaceExternalPolicies</code>, any scaling policies that are external to AWS Auto Scaling are deleted and new target tracking scaling policies created. </p>
        /// <p>Only valid when configuring dynamic scaling. </p>
        /// <p>Condition: The number of existing policies to be replaced must be less than or equal to 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies and does not create new ones.</p>
        pub fn scaling_policy_update_behavior(
            mut self,
            input: crate::model::ScalingPolicyUpdateBehavior,
        ) -> Self {
            self.scaling_policy_update_behavior = Some(input);
            self
        }
        /// <p>Controls whether a resource's externally created scaling policies are kept or replaced. </p>
        /// <p>The default value is <code>KeepExternalPolicies</code>. If the parameter is set to <code>ReplaceExternalPolicies</code>, any scaling policies that are external to AWS Auto Scaling are deleted and new target tracking scaling policies created. </p>
        /// <p>Only valid when configuring dynamic scaling. </p>
        /// <p>Condition: The number of existing policies to be replaced must be less than or equal to 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies and does not create new ones.</p>
        pub fn set_scaling_policy_update_behavior(
            mut self,
            input: std::option::Option<crate::model::ScalingPolicyUpdateBehavior>,
        ) -> Self {
            self.scaling_policy_update_behavior = input;
            self
        }
        /// <p>Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations. </p>
        /// <p>The default is enabled (<code>false</code>). </p>
        pub fn disable_dynamic_scaling(mut self, input: bool) -> Self {
            self.disable_dynamic_scaling = Some(input);
            self
        }
        /// <p>Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations. </p>
        /// <p>The default is enabled (<code>false</code>). </p>
        pub fn set_disable_dynamic_scaling(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_dynamic_scaling = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingInstruction`](crate::model::ScalingInstruction)
        pub fn build(self) -> crate::model::ScalingInstruction {
            crate::model::ScalingInstruction {
                service_namespace: self.service_namespace,
                resource_id: self.resource_id,
                scalable_dimension: self.scalable_dimension,
                min_capacity: self.min_capacity,
                max_capacity: self.max_capacity,
                target_tracking_configurations: self.target_tracking_configurations,
                predefined_load_metric_specification: self.predefined_load_metric_specification,
                customized_load_metric_specification: self.customized_load_metric_specification,
                scheduled_action_buffer_time: self.scheduled_action_buffer_time,
                predictive_scaling_max_capacity_behavior: self
                    .predictive_scaling_max_capacity_behavior,
                predictive_scaling_max_capacity_buffer: self.predictive_scaling_max_capacity_buffer,
                predictive_scaling_mode: self.predictive_scaling_mode,
                scaling_policy_update_behavior: self.scaling_policy_update_behavior,
                disable_dynamic_scaling: self.disable_dynamic_scaling,
            }
        }
    }
}
impl ScalingInstruction {
    /// Creates a new builder-style object to manufacture [`ScalingInstruction`](crate::model::ScalingInstruction)
    pub fn builder() -> crate::model::scaling_instruction::Builder {
        crate::model::scaling_instruction::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingPolicyUpdateBehavior {
    #[allow(missing_docs)] // documentation missing in model
    KeepExternalPolicies,
    #[allow(missing_docs)] // documentation missing in model
    ReplaceExternalPolicies,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingPolicyUpdateBehavior {
    fn from(s: &str) -> Self {
        match s {
            "KeepExternalPolicies" => ScalingPolicyUpdateBehavior::KeepExternalPolicies,
            "ReplaceExternalPolicies" => ScalingPolicyUpdateBehavior::ReplaceExternalPolicies,
            other => ScalingPolicyUpdateBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingPolicyUpdateBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingPolicyUpdateBehavior::from(s))
    }
}
impl ScalingPolicyUpdateBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingPolicyUpdateBehavior::KeepExternalPolicies => "KeepExternalPolicies",
            ScalingPolicyUpdateBehavior::ReplaceExternalPolicies => "ReplaceExternalPolicies",
            ScalingPolicyUpdateBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KeepExternalPolicies", "ReplaceExternalPolicies"]
    }
}
impl AsRef<str> for ScalingPolicyUpdateBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredictiveScalingMode {
    #[allow(missing_docs)] // documentation missing in model
    ForecastAndScale,
    #[allow(missing_docs)] // documentation missing in model
    ForecastOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredictiveScalingMode {
    fn from(s: &str) -> Self {
        match s {
            "ForecastAndScale" => PredictiveScalingMode::ForecastAndScale,
            "ForecastOnly" => PredictiveScalingMode::ForecastOnly,
            other => PredictiveScalingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredictiveScalingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredictiveScalingMode::from(s))
    }
}
impl PredictiveScalingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredictiveScalingMode::ForecastAndScale => "ForecastAndScale",
            PredictiveScalingMode::ForecastOnly => "ForecastOnly",
            PredictiveScalingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ForecastAndScale", "ForecastOnly"]
    }
}
impl AsRef<str> for PredictiveScalingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredictiveScalingMaxCapacityBehavior {
    #[allow(missing_docs)] // documentation missing in model
    SetForecastCapacityToMaxCapacity,
    #[allow(missing_docs)] // documentation missing in model
    SetMaxCapacityAboveForecastCapacity,
    #[allow(missing_docs)] // documentation missing in model
    SetMaxCapacityToForecastCapacity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredictiveScalingMaxCapacityBehavior {
    fn from(s: &str) -> Self {
        match s {
            "SetForecastCapacityToMaxCapacity" => {
                PredictiveScalingMaxCapacityBehavior::SetForecastCapacityToMaxCapacity
            }
            "SetMaxCapacityAboveForecastCapacity" => {
                PredictiveScalingMaxCapacityBehavior::SetMaxCapacityAboveForecastCapacity
            }
            "SetMaxCapacityToForecastCapacity" => {
                PredictiveScalingMaxCapacityBehavior::SetMaxCapacityToForecastCapacity
            }
            other => PredictiveScalingMaxCapacityBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredictiveScalingMaxCapacityBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredictiveScalingMaxCapacityBehavior::from(s))
    }
}
impl PredictiveScalingMaxCapacityBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredictiveScalingMaxCapacityBehavior::SetForecastCapacityToMaxCapacity => {
                "SetForecastCapacityToMaxCapacity"
            }
            PredictiveScalingMaxCapacityBehavior::SetMaxCapacityAboveForecastCapacity => {
                "SetMaxCapacityAboveForecastCapacity"
            }
            PredictiveScalingMaxCapacityBehavior::SetMaxCapacityToForecastCapacity => {
                "SetMaxCapacityToForecastCapacity"
            }
            PredictiveScalingMaxCapacityBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "SetForecastCapacityToMaxCapacity",
            "SetMaxCapacityAboveForecastCapacity",
            "SetMaxCapacityToForecastCapacity",
        ]
    }
}
impl AsRef<str> for PredictiveScalingMaxCapacityBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a CloudWatch metric of your choosing that can be used for predictive scaling. </p>
/// <p>For predictive scaling to work with a customized load metric specification, AWS Auto Scaling needs access to the <code>Sum</code> and <code>Average</code> statistics that CloudWatch computes from metric data.</p>
/// <p>When you choose a load metric, make sure that the required <code>Sum</code> and <code>Average</code> statistics for your metric are available in CloudWatch and that they provide relevant data for predictive scaling. The <code>Sum</code> statistic must represent the total load on the resource, and the <code>Average</code> statistic must represent the average load per capacity unit of the resource. For example, there is a metric that counts the number of requests processed by your Auto Scaling group. If the <code>Sum</code> statistic represents the total request count processed by the group, then the <code>Average</code> statistic for the specified metric must represent the average request count processed by each instance of the group. </p>
/// <p>If you publish your own metrics, you can aggregate the data points at a given interval and then publish the aggregated data points to CloudWatch. Before AWS Auto Scaling generates the forecast, it sums up all the metric data points that occurred within each hour to match the granularity period that is used in the forecast (60 minutes).</p>
/// <p>For information about terminology, available metrics, or how to publish new metrics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch Concepts</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
/// <p>After creating your scaling plan, you can use the AWS Auto Scaling console to visualize forecasts for the specified metric. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource">View Scaling Information for a Resource</a> in the <i>AWS Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomizedLoadMetricSpecification {
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the metric.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The dimensions of the metric.</p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
    /// <p>The statistic of the metric. The only valid value is <code>Sum</code>.</p>
    pub statistic: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The unit of the metric.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl CustomizedLoadMetricSpecification {
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The namespace of the metric.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The dimensions of the metric.</p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::MetricDimension]> {
        self.dimensions.as_deref()
    }
    /// <p>The statistic of the metric. The only valid value is <code>Sum</code>.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::MetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The unit of the metric.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for CustomizedLoadMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomizedLoadMetricSpecification");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("statistic", &self.statistic);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`CustomizedLoadMetricSpecification`](crate::model::CustomizedLoadMetricSpecification)
pub mod customized_load_metric_specification {
    /// A builder for [`CustomizedLoadMetricSpecification`](crate::model::CustomizedLoadMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        pub(crate) statistic: std::option::Option<crate::model::MetricStatistic>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions of the metric.</p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.</p>
        pub fn dimensions(mut self, input: crate::model::MetricDimension) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input);
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions of the metric.</p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The statistic of the metric. The only valid value is <code>Sum</code>.</p>
        pub fn statistic(mut self, input: crate::model::MetricStatistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the metric. The only valid value is <code>Sum</code>.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::MetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomizedLoadMetricSpecification`](crate::model::CustomizedLoadMetricSpecification)
        pub fn build(self) -> crate::model::CustomizedLoadMetricSpecification {
            crate::model::CustomizedLoadMetricSpecification {
                metric_name: self.metric_name,
                namespace: self.namespace,
                dimensions: self.dimensions,
                statistic: self.statistic,
                unit: self.unit,
            }
        }
    }
}
impl CustomizedLoadMetricSpecification {
    /// Creates a new builder-style object to manufacture [`CustomizedLoadMetricSpecification`](crate::model::CustomizedLoadMetricSpecification)
    pub fn builder() -> crate::model::customized_load_metric_specification::Builder {
        crate::model::customized_load_metric_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricStatistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricStatistic {
    fn from(s: &str) -> Self {
        match s {
            "Average" => MetricStatistic::Average,
            "Maximum" => MetricStatistic::Maximum,
            "Minimum" => MetricStatistic::Minimum,
            "SampleCount" => MetricStatistic::SampleCount,
            "Sum" => MetricStatistic::Sum,
            other => MetricStatistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricStatistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricStatistic::from(s))
    }
}
impl MetricStatistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricStatistic::Average => "Average",
            MetricStatistic::Maximum => "Maximum",
            MetricStatistic::Minimum => "Minimum",
            MetricStatistic::SampleCount => "SampleCount",
            MetricStatistic::Sum => "Sum",
            MetricStatistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum", "Minimum", "SampleCount", "Sum"]
    }
}
impl AsRef<str> for MetricStatistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a dimension for a customized metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDimension {
    /// <p>The name of the dimension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the dimension.</p>
    pub value: std::option::Option<std::string::String>,
}
impl MetricDimension {
    /// <p>The name of the dimension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the dimension.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MetricDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MetricDimension`](crate::model::MetricDimension)
pub mod metric_dimension {
    /// A builder for [`MetricDimension`](crate::model::MetricDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDimension`](crate::model::MetricDimension)
        pub fn build(self) -> crate::model::MetricDimension {
            crate::model::MetricDimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl MetricDimension {
    /// Creates a new builder-style object to manufacture [`MetricDimension`](crate::model::MetricDimension)
    pub fn builder() -> crate::model::metric_dimension::Builder {
        crate::model::metric_dimension::Builder::default()
    }
}

/// <p>Represents a predefined metric that can be used for predictive scaling.</p>
/// <p>After creating your scaling plan, you can use the AWS Auto Scaling console to visualize forecasts for the specified metric. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource">View Scaling Information for a Resource</a> in the <i>AWS Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredefinedLoadMetricSpecification {
    /// <p>The metric type.</p>
    pub predefined_load_metric_type: std::option::Option<crate::model::LoadMetricType>,
    /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// /targetgroup/
    /// <target-group-name>
    /// /
    /// <target-group-id>
    /// , where:
    /// </target-group-id>
    /// </target-group-name>
    /// </load-balancer-id>
    /// </load-balancer-name></p>
    /// <ul>
    /// <li> <p>app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// is the final portion of the load balancer ARN
    /// </load-balancer-id>
    /// </load-balancer-name></p> </li>
    /// <li> <p>targetgroup/<target-group-name>
    /// /
    /// <target-group-id>
    /// is the final portion of the target group ARN.
    /// </target-group-id>
    /// </target-group-name></p> </li>
    /// </ul>
    /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub resource_label: std::option::Option<std::string::String>,
}
impl PredefinedLoadMetricSpecification {
    /// <p>The metric type.</p>
    pub fn predefined_load_metric_type(
        &self,
    ) -> std::option::Option<&crate::model::LoadMetricType> {
        self.predefined_load_metric_type.as_ref()
    }
    /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// /targetgroup/
    /// <target-group-name>
    /// /
    /// <target-group-id>
    /// , where:
    /// </target-group-id>
    /// </target-group-name>
    /// </load-balancer-id>
    /// </load-balancer-name></p>
    /// <ul>
    /// <li> <p>app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// is the final portion of the load balancer ARN
    /// </load-balancer-id>
    /// </load-balancer-name></p> </li>
    /// <li> <p>targetgroup/<target-group-name>
    /// /
    /// <target-group-id>
    /// is the final portion of the target group ARN.
    /// </target-group-id>
    /// </target-group-name></p> </li>
    /// </ul>
    /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn resource_label(&self) -> std::option::Option<&str> {
        self.resource_label.as_deref()
    }
}
impl std::fmt::Debug for PredefinedLoadMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredefinedLoadMetricSpecification");
        formatter.field(
            "predefined_load_metric_type",
            &self.predefined_load_metric_type,
        );
        formatter.field("resource_label", &self.resource_label);
        formatter.finish()
    }
}
/// See [`PredefinedLoadMetricSpecification`](crate::model::PredefinedLoadMetricSpecification)
pub mod predefined_load_metric_specification {
    /// A builder for [`PredefinedLoadMetricSpecification`](crate::model::PredefinedLoadMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_load_metric_type: std::option::Option<crate::model::LoadMetricType>,
        pub(crate) resource_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric type.</p>
        pub fn predefined_load_metric_type(mut self, input: crate::model::LoadMetricType) -> Self {
            self.predefined_load_metric_type = Some(input);
            self
        }
        /// <p>The metric type.</p>
        pub fn set_predefined_load_metric_type(
            mut self,
            input: std::option::Option<crate::model::LoadMetricType>,
        ) -> Self {
            self.predefined_load_metric_type = input;
            self
        }
        /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// /targetgroup/
        /// <target-group-name>
        /// /
        /// <target-group-id>
        /// , where:
        /// </target-group-id>
        /// </target-group-name>
        /// </load-balancer-id>
        /// </load-balancer-name></p>
        /// <ul>
        /// <li> <p>app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// is the final portion of the load balancer ARN
        /// </load-balancer-id>
        /// </load-balancer-name></p> </li>
        /// <li> <p>targetgroup/<target-group-name>
        /// /
        /// <target-group-id>
        /// is the final portion of the target group ARN.
        /// </target-group-id>
        /// </target-group-name></p> </li>
        /// </ul>
        /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn resource_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_label = Some(input.into());
            self
        }
        /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// /targetgroup/
        /// <target-group-name>
        /// /
        /// <target-group-id>
        /// , where:
        /// </target-group-id>
        /// </target-group-name>
        /// </load-balancer-id>
        /// </load-balancer-name></p>
        /// <ul>
        /// <li> <p>app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// is the final portion of the load balancer ARN
        /// </load-balancer-id>
        /// </load-balancer-name></p> </li>
        /// <li> <p>targetgroup/<target-group-name>
        /// /
        /// <target-group-id>
        /// is the final portion of the target group ARN.
        /// </target-group-id>
        /// </target-group-name></p> </li>
        /// </ul>
        /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_resource_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_label = input;
            self
        }
        /// Consumes the builder and constructs a [`PredefinedLoadMetricSpecification`](crate::model::PredefinedLoadMetricSpecification)
        pub fn build(self) -> crate::model::PredefinedLoadMetricSpecification {
            crate::model::PredefinedLoadMetricSpecification {
                predefined_load_metric_type: self.predefined_load_metric_type,
                resource_label: self.resource_label,
            }
        }
    }
}
impl PredefinedLoadMetricSpecification {
    /// Creates a new builder-style object to manufacture [`PredefinedLoadMetricSpecification`](crate::model::PredefinedLoadMetricSpecification)
    pub fn builder() -> crate::model::predefined_load_metric_specification::Builder {
        crate::model::predefined_load_metric_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadMetricType {
    #[allow(missing_docs)] // documentation missing in model
    AlbTargetGroupRequestCount,
    #[allow(missing_docs)] // documentation missing in model
    AsgTotalCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    AsgTotalNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    AsgTotalNetworkOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadMetricType {
    fn from(s: &str) -> Self {
        match s {
            "ALBTargetGroupRequestCount" => LoadMetricType::AlbTargetGroupRequestCount,
            "ASGTotalCPUUtilization" => LoadMetricType::AsgTotalCpuUtilization,
            "ASGTotalNetworkIn" => LoadMetricType::AsgTotalNetworkIn,
            "ASGTotalNetworkOut" => LoadMetricType::AsgTotalNetworkOut,
            other => LoadMetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadMetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadMetricType::from(s))
    }
}
impl LoadMetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadMetricType::AlbTargetGroupRequestCount => "ALBTargetGroupRequestCount",
            LoadMetricType::AsgTotalCpuUtilization => "ASGTotalCPUUtilization",
            LoadMetricType::AsgTotalNetworkIn => "ASGTotalNetworkIn",
            LoadMetricType::AsgTotalNetworkOut => "ASGTotalNetworkOut",
            LoadMetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALBTargetGroupRequestCount",
            "ASGTotalCPUUtilization",
            "ASGTotalNetworkIn",
            "ASGTotalNetworkOut",
        ]
    }
}
impl AsRef<str> for LoadMetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a target tracking configuration to use with AWS Auto Scaling. Used with <code>ScalingInstruction</code> and <code>ScalingPolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetTrackingConfiguration {
    /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
    pub predefined_scaling_metric_specification:
        std::option::Option<crate::model::PredefinedScalingMetricSpecification>,
    /// <p>A customized metric. You can specify either a predefined metric or a customized metric. </p>
    pub customized_scaling_metric_specification:
        std::option::Option<crate::model::CustomizedScalingMetricSpecification>,
    /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.</p>
    pub target_value: std::option::Option<f64>,
    /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource. </p>
    /// <p>The default value is <code>false</code>.</p>
    pub disable_scale_in: std::option::Option<bool>,
    /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect. This property is not used if the scalable resource is an Auto Scaling group.</p>
    /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends.</p>
    pub scale_out_cooldown: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling group.</p>
    /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
    pub scale_in_cooldown: std::option::Option<i32>,
    /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.</p>
    pub estimated_instance_warmup: std::option::Option<i32>,
}
impl TargetTrackingConfiguration {
    /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
    pub fn predefined_scaling_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredefinedScalingMetricSpecification> {
        self.predefined_scaling_metric_specification.as_ref()
    }
    /// <p>A customized metric. You can specify either a predefined metric or a customized metric. </p>
    pub fn customized_scaling_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::CustomizedScalingMetricSpecification> {
        self.customized_scaling_metric_specification.as_ref()
    }
    /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.</p>
    pub fn target_value(&self) -> std::option::Option<f64> {
        self.target_value
    }
    /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource. </p>
    /// <p>The default value is <code>false</code>.</p>
    pub fn disable_scale_in(&self) -> std::option::Option<bool> {
        self.disable_scale_in
    }
    /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect. This property is not used if the scalable resource is an Auto Scaling group.</p>
    /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends.</p>
    pub fn scale_out_cooldown(&self) -> std::option::Option<i32> {
        self.scale_out_cooldown
    }
    /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling group.</p>
    /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
    pub fn scale_in_cooldown(&self) -> std::option::Option<i32> {
        self.scale_in_cooldown
    }
    /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.</p>
    pub fn estimated_instance_warmup(&self) -> std::option::Option<i32> {
        self.estimated_instance_warmup
    }
}
impl std::fmt::Debug for TargetTrackingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetTrackingConfiguration");
        formatter.field(
            "predefined_scaling_metric_specification",
            &self.predefined_scaling_metric_specification,
        );
        formatter.field(
            "customized_scaling_metric_specification",
            &self.customized_scaling_metric_specification,
        );
        formatter.field("target_value", &self.target_value);
        formatter.field("disable_scale_in", &self.disable_scale_in);
        formatter.field("scale_out_cooldown", &self.scale_out_cooldown);
        formatter.field("scale_in_cooldown", &self.scale_in_cooldown);
        formatter.field("estimated_instance_warmup", &self.estimated_instance_warmup);
        formatter.finish()
    }
}
/// See [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
pub mod target_tracking_configuration {
    /// A builder for [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_scaling_metric_specification:
            std::option::Option<crate::model::PredefinedScalingMetricSpecification>,
        pub(crate) customized_scaling_metric_specification:
            std::option::Option<crate::model::CustomizedScalingMetricSpecification>,
        pub(crate) target_value: std::option::Option<f64>,
        pub(crate) disable_scale_in: std::option::Option<bool>,
        pub(crate) scale_out_cooldown: std::option::Option<i32>,
        pub(crate) scale_in_cooldown: std::option::Option<i32>,
        pub(crate) estimated_instance_warmup: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
        pub fn predefined_scaling_metric_specification(
            mut self,
            input: crate::model::PredefinedScalingMetricSpecification,
        ) -> Self {
            self.predefined_scaling_metric_specification = Some(input);
            self
        }
        /// <p>A predefined metric. You can specify either a predefined metric or a customized metric.</p>
        pub fn set_predefined_scaling_metric_specification(
            mut self,
            input: std::option::Option<crate::model::PredefinedScalingMetricSpecification>,
        ) -> Self {
            self.predefined_scaling_metric_specification = input;
            self
        }
        /// <p>A customized metric. You can specify either a predefined metric or a customized metric. </p>
        pub fn customized_scaling_metric_specification(
            mut self,
            input: crate::model::CustomizedScalingMetricSpecification,
        ) -> Self {
            self.customized_scaling_metric_specification = Some(input);
            self
        }
        /// <p>A customized metric. You can specify either a predefined metric or a customized metric. </p>
        pub fn set_customized_scaling_metric_specification(
            mut self,
            input: std::option::Option<crate::model::CustomizedScalingMetricSpecification>,
        ) -> Self {
            self.customized_scaling_metric_specification = input;
            self
        }
        /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.</p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.</p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource. </p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn disable_scale_in(mut self, input: bool) -> Self {
            self.disable_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>, scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource. </p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_disable_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_scale_in = input;
            self
        }
        /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect. This property is not used if the scalable resource is an Auto Scaling group.</p>
        /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends.</p>
        pub fn scale_out_cooldown(mut self, input: i32) -> Self {
            self.scale_out_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to wait for a previous scale-out activity to take effect. This property is not used if the scalable resource is an Auto Scaling group.</p>
        /// <p>With the <i>scale-out cooldown period</i>, the intention is to continuously (but not excessively) scale out. After Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends.</p>
        pub fn set_scale_out_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_out_cooldown = input;
            self
        }
        /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling group.</p>
        /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
        pub fn scale_in_cooldown(mut self, input: i32) -> Self {
            self.scale_in_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling group.</p>
        /// <p>With the <i>scale-in cooldown period</i>, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.</p>
        pub fn set_scale_in_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_in_cooldown = input;
            self
        }
        /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.</p>
        pub fn estimated_instance_warmup(mut self, input: i32) -> Self {
            self.estimated_instance_warmup = Some(input);
            self
        }
        /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.</p>
        pub fn set_estimated_instance_warmup(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_instance_warmup = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
        pub fn build(self) -> crate::model::TargetTrackingConfiguration {
            crate::model::TargetTrackingConfiguration {
                predefined_scaling_metric_specification: self
                    .predefined_scaling_metric_specification,
                customized_scaling_metric_specification: self
                    .customized_scaling_metric_specification,
                target_value: self.target_value,
                disable_scale_in: self.disable_scale_in,
                scale_out_cooldown: self.scale_out_cooldown,
                scale_in_cooldown: self.scale_in_cooldown,
                estimated_instance_warmup: self.estimated_instance_warmup,
            }
        }
    }
}
impl TargetTrackingConfiguration {
    /// Creates a new builder-style object to manufacture [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
    pub fn builder() -> crate::model::target_tracking_configuration::Builder {
        crate::model::target_tracking_configuration::Builder::default()
    }
}

/// <p>Represents a CloudWatch metric of your choosing that can be used for dynamic scaling as part of a target tracking scaling policy. </p>
/// <p>To create your customized scaling metric specification:</p>
/// <ul>
/// <li> <p>Add values for each required parameter from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish Custom Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p> </li>
/// <li> <p>Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases. </p> </li>
/// </ul>
/// <p>For information about terminology, available metrics, or how to publish new metrics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch Concepts</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomizedScalingMetricSpecification {
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the metric.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The dimensions of the metric.</p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized scaling metric specification.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
    /// <p>The statistic of the metric.</p>
    pub statistic: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The unit of the metric. </p>
    pub unit: std::option::Option<std::string::String>,
}
impl CustomizedScalingMetricSpecification {
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The namespace of the metric.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The dimensions of the metric.</p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized scaling metric specification.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::MetricDimension]> {
        self.dimensions.as_deref()
    }
    /// <p>The statistic of the metric.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::MetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The unit of the metric. </p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for CustomizedScalingMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomizedScalingMetricSpecification");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("statistic", &self.statistic);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`CustomizedScalingMetricSpecification`](crate::model::CustomizedScalingMetricSpecification)
pub mod customized_scaling_metric_specification {
    /// A builder for [`CustomizedScalingMetricSpecification`](crate::model::CustomizedScalingMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        pub(crate) statistic: std::option::Option<crate::model::MetricStatistic>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions of the metric.</p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized scaling metric specification.</p>
        pub fn dimensions(mut self, input: crate::model::MetricDimension) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input);
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions of the metric.</p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized scaling metric specification.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The statistic of the metric.</p>
        pub fn statistic(mut self, input: crate::model::MetricStatistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the metric.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::MetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The unit of the metric. </p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the metric. </p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomizedScalingMetricSpecification`](crate::model::CustomizedScalingMetricSpecification)
        pub fn build(self) -> crate::model::CustomizedScalingMetricSpecification {
            crate::model::CustomizedScalingMetricSpecification {
                metric_name: self.metric_name,
                namespace: self.namespace,
                dimensions: self.dimensions,
                statistic: self.statistic,
                unit: self.unit,
            }
        }
    }
}
impl CustomizedScalingMetricSpecification {
    /// Creates a new builder-style object to manufacture [`CustomizedScalingMetricSpecification`](crate::model::CustomizedScalingMetricSpecification)
    pub fn builder() -> crate::model::customized_scaling_metric_specification::Builder {
        crate::model::customized_scaling_metric_specification::Builder::default()
    }
}

/// <p>Represents a predefined metric that can be used for dynamic scaling as part of a target tracking scaling policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredefinedScalingMetricSpecification {
    /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot Fleet requests, and ECS services.</p>
    pub predefined_scaling_metric_type: std::option::Option<crate::model::ScalingMetricType>,
    /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// /targetgroup/
    /// <target-group-name>
    /// /
    /// <target-group-id>
    /// , where:
    /// </target-group-id>
    /// </target-group-name>
    /// </load-balancer-id>
    /// </load-balancer-name></p>
    /// <ul>
    /// <li> <p>app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// is the final portion of the load balancer ARN
    /// </load-balancer-id>
    /// </load-balancer-name></p> </li>
    /// <li> <p>targetgroup/<target-group-name>
    /// /
    /// <target-group-id>
    /// is the final portion of the target group ARN.
    /// </target-group-id>
    /// </target-group-name></p> </li>
    /// </ul>
    /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub resource_label: std::option::Option<std::string::String>,
}
impl PredefinedScalingMetricSpecification {
    /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot Fleet requests, and ECS services.</p>
    pub fn predefined_scaling_metric_type(
        &self,
    ) -> std::option::Option<&crate::model::ScalingMetricType> {
        self.predefined_scaling_metric_type.as_ref()
    }
    /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// /targetgroup/
    /// <target-group-name>
    /// /
    /// <target-group-id>
    /// , where:
    /// </target-group-id>
    /// </target-group-name>
    /// </load-balancer-id>
    /// </load-balancer-name></p>
    /// <ul>
    /// <li> <p>app/<load-balancer-name>
    /// /
    /// <load-balancer-id>
    /// is the final portion of the load balancer ARN
    /// </load-balancer-id>
    /// </load-balancer-name></p> </li>
    /// <li> <p>targetgroup/<target-group-name>
    /// /
    /// <target-group-id>
    /// is the final portion of the target group ARN.
    /// </target-group-id>
    /// </target-group-name></p> </li>
    /// </ul>
    /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn resource_label(&self) -> std::option::Option<&str> {
        self.resource_label.as_deref()
    }
}
impl std::fmt::Debug for PredefinedScalingMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredefinedScalingMetricSpecification");
        formatter.field(
            "predefined_scaling_metric_type",
            &self.predefined_scaling_metric_type,
        );
        formatter.field("resource_label", &self.resource_label);
        formatter.finish()
    }
}
/// See [`PredefinedScalingMetricSpecification`](crate::model::PredefinedScalingMetricSpecification)
pub mod predefined_scaling_metric_specification {
    /// A builder for [`PredefinedScalingMetricSpecification`](crate::model::PredefinedScalingMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_scaling_metric_type:
            std::option::Option<crate::model::ScalingMetricType>,
        pub(crate) resource_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot Fleet requests, and ECS services.</p>
        pub fn predefined_scaling_metric_type(
            mut self,
            input: crate::model::ScalingMetricType,
        ) -> Self {
            self.predefined_scaling_metric_type = Some(input);
            self
        }
        /// <p>The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot Fleet requests, and ECS services.</p>
        pub fn set_predefined_scaling_metric_type(
            mut self,
            input: std::option::Option<crate::model::ScalingMetricType>,
        ) -> Self {
            self.predefined_scaling_metric_type = input;
            self
        }
        /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// /targetgroup/
        /// <target-group-name>
        /// /
        /// <target-group-id>
        /// , where:
        /// </target-group-id>
        /// </target-group-name>
        /// </load-balancer-id>
        /// </load-balancer-name></p>
        /// <ul>
        /// <li> <p>app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// is the final portion of the load balancer ARN
        /// </load-balancer-id>
        /// </load-balancer-name></p> </li>
        /// <li> <p>targetgroup/<target-group-name>
        /// /
        /// <target-group-id>
        /// is the final portion of the target group ARN.
        /// </target-group-id>
        /// </target-group-name></p> </li>
        /// </ul>
        /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn resource_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_label = Some(input.into());
            self
        }
        /// <p>Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// /targetgroup/
        /// <target-group-name>
        /// /
        /// <target-group-id>
        /// , where:
        /// </target-group-id>
        /// </target-group-name>
        /// </load-balancer-id>
        /// </load-balancer-name></p>
        /// <ul>
        /// <li> <p>app/<load-balancer-name>
        /// /
        /// <load-balancer-id>
        /// is the final portion of the load balancer ARN
        /// </load-balancer-id>
        /// </load-balancer-name></p> </li>
        /// <li> <p>targetgroup/<target-group-name>
        /// /
        /// <target-group-id>
        /// is the final portion of the target group ARN.
        /// </target-group-id>
        /// </target-group-name></p> </li>
        /// </ul>
        /// <p>This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.</p>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_resource_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_label = input;
            self
        }
        /// Consumes the builder and constructs a [`PredefinedScalingMetricSpecification`](crate::model::PredefinedScalingMetricSpecification)
        pub fn build(self) -> crate::model::PredefinedScalingMetricSpecification {
            crate::model::PredefinedScalingMetricSpecification {
                predefined_scaling_metric_type: self.predefined_scaling_metric_type,
                resource_label: self.resource_label,
            }
        }
    }
}
impl PredefinedScalingMetricSpecification {
    /// Creates a new builder-style object to manufacture [`PredefinedScalingMetricSpecification`](crate::model::PredefinedScalingMetricSpecification)
    pub fn builder() -> crate::model::predefined_scaling_metric_specification::Builder {
        crate::model::predefined_scaling_metric_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingMetricType {
    #[allow(missing_docs)] // documentation missing in model
    AlbRequestCountPerTarget,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageNetworkOut,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbReadCapacityUtilization,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbWriteCapacityUtilization,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestAverageNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestAverageNetworkOut,
    #[allow(missing_docs)] // documentation missing in model
    EcsServiceAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    EcsServiceAverageMemoryUtilization,
    #[allow(missing_docs)] // documentation missing in model
    RdsReaderAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    RdsReaderAverageDatabaseConnections,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingMetricType {
    fn from(s: &str) -> Self {
        match s {
            "ALBRequestCountPerTarget" => ScalingMetricType::AlbRequestCountPerTarget,
            "ASGAverageCPUUtilization" => ScalingMetricType::AsgAverageCpuUtilization,
            "ASGAverageNetworkIn" => ScalingMetricType::AsgAverageNetworkIn,
            "ASGAverageNetworkOut" => ScalingMetricType::AsgAverageNetworkOut,
            "DynamoDBReadCapacityUtilization" => ScalingMetricType::DynamoDbReadCapacityUtilization,
            "DynamoDBWriteCapacityUtilization" => {
                ScalingMetricType::DynamoDbWriteCapacityUtilization
            }
            "EC2SpotFleetRequestAverageCPUUtilization" => {
                ScalingMetricType::Ec2SpotFleetRequestAverageCpuUtilization
            }
            "EC2SpotFleetRequestAverageNetworkIn" => {
                ScalingMetricType::Ec2SpotFleetRequestAverageNetworkIn
            }
            "EC2SpotFleetRequestAverageNetworkOut" => {
                ScalingMetricType::Ec2SpotFleetRequestAverageNetworkOut
            }
            "ECSServiceAverageCPUUtilization" => ScalingMetricType::EcsServiceAverageCpuUtilization,
            "ECSServiceAverageMemoryUtilization" => {
                ScalingMetricType::EcsServiceAverageMemoryUtilization
            }
            "RDSReaderAverageCPUUtilization" => ScalingMetricType::RdsReaderAverageCpuUtilization,
            "RDSReaderAverageDatabaseConnections" => {
                ScalingMetricType::RdsReaderAverageDatabaseConnections
            }
            other => ScalingMetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingMetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingMetricType::from(s))
    }
}
impl ScalingMetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingMetricType::AlbRequestCountPerTarget => "ALBRequestCountPerTarget",
            ScalingMetricType::AsgAverageCpuUtilization => "ASGAverageCPUUtilization",
            ScalingMetricType::AsgAverageNetworkIn => "ASGAverageNetworkIn",
            ScalingMetricType::AsgAverageNetworkOut => "ASGAverageNetworkOut",
            ScalingMetricType::DynamoDbReadCapacityUtilization => "DynamoDBReadCapacityUtilization",
            ScalingMetricType::DynamoDbWriteCapacityUtilization => {
                "DynamoDBWriteCapacityUtilization"
            }
            ScalingMetricType::Ec2SpotFleetRequestAverageCpuUtilization => {
                "EC2SpotFleetRequestAverageCPUUtilization"
            }
            ScalingMetricType::Ec2SpotFleetRequestAverageNetworkIn => {
                "EC2SpotFleetRequestAverageNetworkIn"
            }
            ScalingMetricType::Ec2SpotFleetRequestAverageNetworkOut => {
                "EC2SpotFleetRequestAverageNetworkOut"
            }
            ScalingMetricType::EcsServiceAverageCpuUtilization => "ECSServiceAverageCPUUtilization",
            ScalingMetricType::EcsServiceAverageMemoryUtilization => {
                "ECSServiceAverageMemoryUtilization"
            }
            ScalingMetricType::RdsReaderAverageCpuUtilization => "RDSReaderAverageCPUUtilization",
            ScalingMetricType::RdsReaderAverageDatabaseConnections => {
                "RDSReaderAverageDatabaseConnections"
            }
            ScalingMetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALBRequestCountPerTarget",
            "ASGAverageCPUUtilization",
            "ASGAverageNetworkIn",
            "ASGAverageNetworkOut",
            "DynamoDBReadCapacityUtilization",
            "DynamoDBWriteCapacityUtilization",
            "EC2SpotFleetRequestAverageCPUUtilization",
            "EC2SpotFleetRequestAverageNetworkIn",
            "EC2SpotFleetRequestAverageNetworkOut",
            "ECSServiceAverageCPUUtilization",
            "ECSServiceAverageMemoryUtilization",
            "RDSReaderAverageCPUUtilization",
            "RDSReaderAverageDatabaseConnections",
        ]
    }
}
impl AsRef<str> for ScalingMetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalableDimension {
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroupDesiredCapacity,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbIndexReadCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbIndexWriteCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbTableReadCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDbTableWriteCapacityUnits,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SpotFleetRequestTargetCapacity,
    #[allow(missing_docs)] // documentation missing in model
    EcsServiceDesiredCount,
    #[allow(missing_docs)] // documentation missing in model
    RdsClusterReadReplicaCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalableDimension {
    fn from(s: &str) -> Self {
        match s {
            "autoscaling:autoScalingGroup:DesiredCapacity" => {
                ScalableDimension::AutoScalingGroupDesiredCapacity
            }
            "dynamodb:index:ReadCapacityUnits" => ScalableDimension::DynamoDbIndexReadCapacityUnits,
            "dynamodb:index:WriteCapacityUnits" => {
                ScalableDimension::DynamoDbIndexWriteCapacityUnits
            }
            "dynamodb:table:ReadCapacityUnits" => ScalableDimension::DynamoDbTableReadCapacityUnits,
            "dynamodb:table:WriteCapacityUnits" => {
                ScalableDimension::DynamoDbTableWriteCapacityUnits
            }
            "ec2:spot-fleet-request:TargetCapacity" => {
                ScalableDimension::Ec2SpotFleetRequestTargetCapacity
            }
            "ecs:service:DesiredCount" => ScalableDimension::EcsServiceDesiredCount,
            "rds:cluster:ReadReplicaCount" => ScalableDimension::RdsClusterReadReplicaCount,
            other => ScalableDimension::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalableDimension {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalableDimension::from(s))
    }
}
impl ScalableDimension {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalableDimension::AutoScalingGroupDesiredCapacity => {
                "autoscaling:autoScalingGroup:DesiredCapacity"
            }
            ScalableDimension::DynamoDbIndexReadCapacityUnits => "dynamodb:index:ReadCapacityUnits",
            ScalableDimension::DynamoDbIndexWriteCapacityUnits => {
                "dynamodb:index:WriteCapacityUnits"
            }
            ScalableDimension::DynamoDbTableReadCapacityUnits => "dynamodb:table:ReadCapacityUnits",
            ScalableDimension::DynamoDbTableWriteCapacityUnits => {
                "dynamodb:table:WriteCapacityUnits"
            }
            ScalableDimension::Ec2SpotFleetRequestTargetCapacity => {
                "ec2:spot-fleet-request:TargetCapacity"
            }
            ScalableDimension::EcsServiceDesiredCount => "ecs:service:DesiredCount",
            ScalableDimension::RdsClusterReadReplicaCount => "rds:cluster:ReadReplicaCount",
            ScalableDimension::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "autoscaling:autoScalingGroup:DesiredCapacity",
            "dynamodb:index:ReadCapacityUnits",
            "dynamodb:index:WriteCapacityUnits",
            "dynamodb:table:ReadCapacityUnits",
            "dynamodb:table:WriteCapacityUnits",
            "ec2:spot-fleet-request:TargetCapacity",
            "ecs:service:DesiredCount",
            "rds:cluster:ReadReplicaCount",
        ]
    }
}
impl AsRef<str> for ScalableDimension {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceNamespace {
    #[allow(missing_docs)] // documentation missing in model
    Autoscaling,
    #[allow(missing_docs)] // documentation missing in model
    Dynamodb,
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Ecs,
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceNamespace {
    fn from(s: &str) -> Self {
        match s {
            "autoscaling" => ServiceNamespace::Autoscaling,
            "dynamodb" => ServiceNamespace::Dynamodb,
            "ec2" => ServiceNamespace::Ec2,
            "ecs" => ServiceNamespace::Ecs,
            "rds" => ServiceNamespace::Rds,
            other => ServiceNamespace::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceNamespace {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceNamespace::from(s))
    }
}
impl ServiceNamespace {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceNamespace::Autoscaling => "autoscaling",
            ServiceNamespace::Dynamodb => "dynamodb",
            ServiceNamespace::Ec2 => "ec2",
            ServiceNamespace::Ecs => "ecs",
            ServiceNamespace::Rds => "rds",
            ServiceNamespace::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["autoscaling", "dynamodb", "ec2", "ecs", "rds"]
    }
}
impl AsRef<str> for ServiceNamespace {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents an application source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSource {
    /// <p>The Amazon Resource Name (ARN) of a AWS CloudFormation stack.</p>
    pub cloud_formation_stack_arn: std::option::Option<std::string::String>,
    /// <p>A set of tags (up to 50).</p>
    pub tag_filters: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
}
impl ApplicationSource {
    /// <p>The Amazon Resource Name (ARN) of a AWS CloudFormation stack.</p>
    pub fn cloud_formation_stack_arn(&self) -> std::option::Option<&str> {
        self.cloud_formation_stack_arn.as_deref()
    }
    /// <p>A set of tags (up to 50).</p>
    pub fn tag_filters(&self) -> std::option::Option<&[crate::model::TagFilter]> {
        self.tag_filters.as_deref()
    }
}
impl std::fmt::Debug for ApplicationSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSource");
        formatter.field("cloud_formation_stack_arn", &self.cloud_formation_stack_arn);
        formatter.field("tag_filters", &self.tag_filters);
        formatter.finish()
    }
}
/// See [`ApplicationSource`](crate::model::ApplicationSource)
pub mod application_source {
    /// A builder for [`ApplicationSource`](crate::model::ApplicationSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation_stack_arn: std::option::Option<std::string::String>,
        pub(crate) tag_filters: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a AWS CloudFormation stack.</p>
        pub fn cloud_formation_stack_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_formation_stack_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a AWS CloudFormation stack.</p>
        pub fn set_cloud_formation_stack_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_formation_stack_arn = input;
            self
        }
        /// Appends an item to `tag_filters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>A set of tags (up to 50).</p>
        pub fn tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            let mut v = self.tag_filters.unwrap_or_default();
            v.push(input);
            self.tag_filters = Some(v);
            self
        }
        /// <p>A set of tags (up to 50).</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.tag_filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSource`](crate::model::ApplicationSource)
        pub fn build(self) -> crate::model::ApplicationSource {
            crate::model::ApplicationSource {
                cloud_formation_stack_arn: self.cloud_formation_stack_arn,
                tag_filters: self.tag_filters,
            }
        }
    }
}
impl ApplicationSource {
    /// Creates a new builder-style object to manufacture [`ApplicationSource`](crate::model::ApplicationSource)
    pub fn builder() -> crate::model::application_source::Builder {
        crate::model::application_source::Builder::default()
    }
}

/// <p>Represents a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagFilter {
    /// <p>The tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag values (0 to 20).</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TagFilter {
    /// <p>The tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag values (0 to 20).</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for TagFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`TagFilter`](crate::model::TagFilter)
pub mod tag_filter {
    /// A builder for [`TagFilter`](crate::model::TagFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The tag values (0 to 20).</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The tag values (0 to 20).</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagFilter`](crate::model::TagFilter)
        pub fn build(self) -> crate::model::TagFilter {
            crate::model::TagFilter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl TagFilter {
    /// Creates a new builder-style object to manufacture [`TagFilter`](crate::model::TagFilter)
    pub fn builder() -> crate::model::tag_filter::Builder {
        crate::model::tag_filter::Builder::default()
    }
}

/// <p>Represents a single value in the forecast data used for predictive scaling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Datapoint {
    /// <p>The time stamp for the data point in UTC format.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The value of the data point.</p>
    pub value: std::option::Option<f64>,
}
impl Datapoint {
    /// <p>The time stamp for the data point in UTC format.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>The value of the data point.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
}
impl std::fmt::Debug for Datapoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Datapoint");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Datapoint`](crate::model::Datapoint)
pub mod datapoint {
    /// A builder for [`Datapoint`](crate::model::Datapoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The time stamp for the data point in UTC format.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time stamp for the data point in UTC format.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The value of the data point.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the data point.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Datapoint`](crate::model::Datapoint)
        pub fn build(self) -> crate::model::Datapoint {
            crate::model::Datapoint {
                timestamp: self.timestamp,
                value: self.value,
            }
        }
    }
}
impl Datapoint {
    /// Creates a new builder-style object to manufacture [`Datapoint`](crate::model::Datapoint)
    pub fn builder() -> crate::model::datapoint::Builder {
        crate::model::datapoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ForecastDataType {
    #[allow(missing_docs)] // documentation missing in model
    CapacityForecast,
    #[allow(missing_docs)] // documentation missing in model
    LoadForecast,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledActionMaxCapacity,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledActionMinCapacity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ForecastDataType {
    fn from(s: &str) -> Self {
        match s {
            "CapacityForecast" => ForecastDataType::CapacityForecast,
            "LoadForecast" => ForecastDataType::LoadForecast,
            "ScheduledActionMaxCapacity" => ForecastDataType::ScheduledActionMaxCapacity,
            "ScheduledActionMinCapacity" => ForecastDataType::ScheduledActionMinCapacity,
            other => ForecastDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ForecastDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ForecastDataType::from(s))
    }
}
impl ForecastDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ForecastDataType::CapacityForecast => "CapacityForecast",
            ForecastDataType::LoadForecast => "LoadForecast",
            ForecastDataType::ScheduledActionMaxCapacity => "ScheduledActionMaxCapacity",
            ForecastDataType::ScheduledActionMinCapacity => "ScheduledActionMinCapacity",
            ForecastDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CapacityForecast",
            "LoadForecast",
            "ScheduledActionMaxCapacity",
            "ScheduledActionMinCapacity",
        ]
    }
}
impl AsRef<str> for ForecastDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a scaling plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingPlan {
    /// <p>The name of the scaling plan.</p>
    pub scaling_plan_name: std::option::Option<std::string::String>,
    /// <p>The version number of the scaling plan.</p>
    pub scaling_plan_version: std::option::Option<i64>,
    /// <p>A CloudFormation stack or a set of tags. You can create one scaling plan per application source.</p>
    pub application_source: std::option::Option<crate::model::ApplicationSource>,
    /// <p>The scaling instructions.</p>
    pub scaling_instructions: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
    /// <p>The status of the scaling plan.</p>
    /// <ul>
    /// <li> <p> <code>Active</code> - The scaling plan is active.</p> </li>
    /// <li> <p> <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more resources could not be applied.</p> </li>
    /// <li> <p> <code>CreationInProgress</code> - The scaling plan is being created.</p> </li>
    /// <li> <p> <code>CreationFailed</code> - The scaling plan could not be created.</p> </li>
    /// <li> <p> <code>DeletionInProgress</code> - The scaling plan is being deleted.</p> </li>
    /// <li> <p> <code>DeletionFailed</code> - The scaling plan could not be deleted.</p> </li>
    /// <li> <p> <code>UpdateInProgress</code> - The scaling plan is being updated.</p> </li>
    /// <li> <p> <code>UpdateFailed</code> - The scaling plan could not be updated.</p> </li>
    /// </ul>
    pub status_code: std::option::Option<crate::model::ScalingPlanStatusCode>,
    /// <p>A simple message about the current status of the scaling plan.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The Unix time stamp when the scaling plan entered the current status.</p>
    pub status_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix time stamp when the scaling plan was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ScalingPlan {
    /// <p>The name of the scaling plan.</p>
    pub fn scaling_plan_name(&self) -> std::option::Option<&str> {
        self.scaling_plan_name.as_deref()
    }
    /// <p>The version number of the scaling plan.</p>
    pub fn scaling_plan_version(&self) -> std::option::Option<i64> {
        self.scaling_plan_version
    }
    /// <p>A CloudFormation stack or a set of tags. You can create one scaling plan per application source.</p>
    pub fn application_source(&self) -> std::option::Option<&crate::model::ApplicationSource> {
        self.application_source.as_ref()
    }
    /// <p>The scaling instructions.</p>
    pub fn scaling_instructions(&self) -> std::option::Option<&[crate::model::ScalingInstruction]> {
        self.scaling_instructions.as_deref()
    }
    /// <p>The status of the scaling plan.</p>
    /// <ul>
    /// <li> <p> <code>Active</code> - The scaling plan is active.</p> </li>
    /// <li> <p> <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more resources could not be applied.</p> </li>
    /// <li> <p> <code>CreationInProgress</code> - The scaling plan is being created.</p> </li>
    /// <li> <p> <code>CreationFailed</code> - The scaling plan could not be created.</p> </li>
    /// <li> <p> <code>DeletionInProgress</code> - The scaling plan is being deleted.</p> </li>
    /// <li> <p> <code>DeletionFailed</code> - The scaling plan could not be deleted.</p> </li>
    /// <li> <p> <code>UpdateInProgress</code> - The scaling plan is being updated.</p> </li>
    /// <li> <p> <code>UpdateFailed</code> - The scaling plan could not be updated.</p> </li>
    /// </ul>
    pub fn status_code(&self) -> std::option::Option<&crate::model::ScalingPlanStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>A simple message about the current status of the scaling plan.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The Unix time stamp when the scaling plan entered the current status.</p>
    pub fn status_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.status_start_time.as_ref()
    }
    /// <p>The Unix time stamp when the scaling plan was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for ScalingPlan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingPlan");
        formatter.field("scaling_plan_name", &self.scaling_plan_name);
        formatter.field("scaling_plan_version", &self.scaling_plan_version);
        formatter.field("application_source", &self.application_source);
        formatter.field("scaling_instructions", &self.scaling_instructions);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("status_start_time", &self.status_start_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`ScalingPlan`](crate::model::ScalingPlan)
pub mod scaling_plan {
    /// A builder for [`ScalingPlan`](crate::model::ScalingPlan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_name: std::option::Option<std::string::String>,
        pub(crate) scaling_plan_version: std::option::Option<i64>,
        pub(crate) application_source: std::option::Option<crate::model::ApplicationSource>,
        pub(crate) scaling_instructions:
            std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
        pub(crate) status_code: std::option::Option<crate::model::ScalingPlanStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) status_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_plan_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_plan_name = input;
            self
        }
        /// <p>The version number of the scaling plan.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.scaling_plan_version = Some(input);
            self
        }
        /// <p>The version number of the scaling plan.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.scaling_plan_version = input;
            self
        }
        /// <p>A CloudFormation stack or a set of tags. You can create one scaling plan per application source.</p>
        pub fn application_source(mut self, input: crate::model::ApplicationSource) -> Self {
            self.application_source = Some(input);
            self
        }
        /// <p>A CloudFormation stack or a set of tags. You can create one scaling plan per application source.</p>
        pub fn set_application_source(
            mut self,
            input: std::option::Option<crate::model::ApplicationSource>,
        ) -> Self {
            self.application_source = input;
            self
        }
        /// Appends an item to `scaling_instructions`.
        ///
        /// To override the contents of this collection use [`set_scaling_instructions`](Self::set_scaling_instructions).
        ///
        /// <p>The scaling instructions.</p>
        pub fn scaling_instructions(mut self, input: crate::model::ScalingInstruction) -> Self {
            let mut v = self.scaling_instructions.unwrap_or_default();
            v.push(input);
            self.scaling_instructions = Some(v);
            self
        }
        /// <p>The scaling instructions.</p>
        pub fn set_scaling_instructions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
        ) -> Self {
            self.scaling_instructions = input;
            self
        }
        /// <p>The status of the scaling plan.</p>
        /// <ul>
        /// <li> <p> <code>Active</code> - The scaling plan is active.</p> </li>
        /// <li> <p> <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more resources could not be applied.</p> </li>
        /// <li> <p> <code>CreationInProgress</code> - The scaling plan is being created.</p> </li>
        /// <li> <p> <code>CreationFailed</code> - The scaling plan could not be created.</p> </li>
        /// <li> <p> <code>DeletionInProgress</code> - The scaling plan is being deleted.</p> </li>
        /// <li> <p> <code>DeletionFailed</code> - The scaling plan could not be deleted.</p> </li>
        /// <li> <p> <code>UpdateInProgress</code> - The scaling plan is being updated.</p> </li>
        /// <li> <p> <code>UpdateFailed</code> - The scaling plan could not be updated.</p> </li>
        /// </ul>
        pub fn status_code(mut self, input: crate::model::ScalingPlanStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status of the scaling plan.</p>
        /// <ul>
        /// <li> <p> <code>Active</code> - The scaling plan is active.</p> </li>
        /// <li> <p> <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more resources could not be applied.</p> </li>
        /// <li> <p> <code>CreationInProgress</code> - The scaling plan is being created.</p> </li>
        /// <li> <p> <code>CreationFailed</code> - The scaling plan could not be created.</p> </li>
        /// <li> <p> <code>DeletionInProgress</code> - The scaling plan is being deleted.</p> </li>
        /// <li> <p> <code>DeletionFailed</code> - The scaling plan could not be deleted.</p> </li>
        /// <li> <p> <code>UpdateInProgress</code> - The scaling plan is being updated.</p> </li>
        /// <li> <p> <code>UpdateFailed</code> - The scaling plan could not be updated.</p> </li>
        /// </ul>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::ScalingPlanStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>A simple message about the current status of the scaling plan.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A simple message about the current status of the scaling plan.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The Unix time stamp when the scaling plan entered the current status.</p>
        pub fn status_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.status_start_time = Some(input);
            self
        }
        /// <p>The Unix time stamp when the scaling plan entered the current status.</p>
        pub fn set_status_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.status_start_time = input;
            self
        }
        /// <p>The Unix time stamp when the scaling plan was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The Unix time stamp when the scaling plan was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingPlan`](crate::model::ScalingPlan)
        pub fn build(self) -> crate::model::ScalingPlan {
            crate::model::ScalingPlan {
                scaling_plan_name: self.scaling_plan_name,
                scaling_plan_version: self.scaling_plan_version,
                application_source: self.application_source,
                scaling_instructions: self.scaling_instructions,
                status_code: self.status_code,
                status_message: self.status_message,
                status_start_time: self.status_start_time,
                creation_time: self.creation_time,
            }
        }
    }
}
impl ScalingPlan {
    /// Creates a new builder-style object to manufacture [`ScalingPlan`](crate::model::ScalingPlan)
    pub fn builder() -> crate::model::scaling_plan::Builder {
        crate::model::scaling_plan::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingPlanStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    ActiveWithProblems,
    #[allow(missing_docs)] // documentation missing in model
    CreationFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeletionFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeletionInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingPlanStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "Active" => ScalingPlanStatusCode::Active,
            "ActiveWithProblems" => ScalingPlanStatusCode::ActiveWithProblems,
            "CreationFailed" => ScalingPlanStatusCode::CreationFailed,
            "CreationInProgress" => ScalingPlanStatusCode::CreationInProgress,
            "DeletionFailed" => ScalingPlanStatusCode::DeletionFailed,
            "DeletionInProgress" => ScalingPlanStatusCode::DeletionInProgress,
            "UpdateFailed" => ScalingPlanStatusCode::UpdateFailed,
            "UpdateInProgress" => ScalingPlanStatusCode::UpdateInProgress,
            other => ScalingPlanStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingPlanStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingPlanStatusCode::from(s))
    }
}
impl ScalingPlanStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingPlanStatusCode::Active => "Active",
            ScalingPlanStatusCode::ActiveWithProblems => "ActiveWithProblems",
            ScalingPlanStatusCode::CreationFailed => "CreationFailed",
            ScalingPlanStatusCode::CreationInProgress => "CreationInProgress",
            ScalingPlanStatusCode::DeletionFailed => "DeletionFailed",
            ScalingPlanStatusCode::DeletionInProgress => "DeletionInProgress",
            ScalingPlanStatusCode::UpdateFailed => "UpdateFailed",
            ScalingPlanStatusCode::UpdateInProgress => "UpdateInProgress",
            ScalingPlanStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Active",
            "ActiveWithProblems",
            "CreationFailed",
            "CreationInProgress",
            "DeletionFailed",
            "DeletionInProgress",
            "UpdateFailed",
            "UpdateInProgress",
        ]
    }
}
impl AsRef<str> for ScalingPlanStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a scalable resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingPlanResource {
    /// <p>The name of the scaling plan.</p>
    pub scaling_plan_name: std::option::Option<std::string::String>,
    /// <p>The version number of the scaling plan.</p>
    pub scaling_plan_version: std::option::Option<i64>,
    /// <p>The namespace of the AWS service.</p>
    pub service_namespace: std::option::Option<crate::model::ServiceNamespace>,
    /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// </ul>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The scalable dimension for the resource.</p>
    /// <ul>
    /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// </ul>
    pub scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
    /// <p>The scaling policies.</p>
    pub scaling_policies: std::option::Option<std::vec::Vec<crate::model::ScalingPolicy>>,
    /// <p>The scaling status of the resource.</p>
    /// <ul>
    /// <li> <p> <code>Active</code> - The scaling configuration is active.</p> </li>
    /// <li> <p> <code>Inactive</code> - The scaling configuration is not active because the scaling plan is being created or the scaling configuration could not be applied. Check the status message for more information.</p> </li>
    /// <li> <p> <code>PartiallyActive</code> - The scaling configuration is partially active because the scaling plan is being created or deleted or the scaling configuration could not be fully applied. Check the status message for more information.</p> </li>
    /// </ul>
    pub scaling_status_code: std::option::Option<crate::model::ScalingStatusCode>,
    /// <p>A simple message about the current scaling status of the resource.</p>
    pub scaling_status_message: std::option::Option<std::string::String>,
}
impl ScalingPlanResource {
    /// <p>The name of the scaling plan.</p>
    pub fn scaling_plan_name(&self) -> std::option::Option<&str> {
        self.scaling_plan_name.as_deref()
    }
    /// <p>The version number of the scaling plan.</p>
    pub fn scaling_plan_version(&self) -> std::option::Option<i64> {
        self.scaling_plan_version
    }
    /// <p>The namespace of the AWS service.</p>
    pub fn service_namespace(&self) -> std::option::Option<&crate::model::ServiceNamespace> {
        self.service_namespace.as_ref()
    }
    /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
    /// <ul>
    /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
    /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
    /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
    /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
    /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
    /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
    /// </ul>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The scalable dimension for the resource.</p>
    /// <ul>
    /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
    /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
    /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
    /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
    /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
    /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
    /// </ul>
    pub fn scalable_dimension(&self) -> std::option::Option<&crate::model::ScalableDimension> {
        self.scalable_dimension.as_ref()
    }
    /// <p>The scaling policies.</p>
    pub fn scaling_policies(&self) -> std::option::Option<&[crate::model::ScalingPolicy]> {
        self.scaling_policies.as_deref()
    }
    /// <p>The scaling status of the resource.</p>
    /// <ul>
    /// <li> <p> <code>Active</code> - The scaling configuration is active.</p> </li>
    /// <li> <p> <code>Inactive</code> - The scaling configuration is not active because the scaling plan is being created or the scaling configuration could not be applied. Check the status message for more information.</p> </li>
    /// <li> <p> <code>PartiallyActive</code> - The scaling configuration is partially active because the scaling plan is being created or deleted or the scaling configuration could not be fully applied. Check the status message for more information.</p> </li>
    /// </ul>
    pub fn scaling_status_code(&self) -> std::option::Option<&crate::model::ScalingStatusCode> {
        self.scaling_status_code.as_ref()
    }
    /// <p>A simple message about the current scaling status of the resource.</p>
    pub fn scaling_status_message(&self) -> std::option::Option<&str> {
        self.scaling_status_message.as_deref()
    }
}
impl std::fmt::Debug for ScalingPlanResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingPlanResource");
        formatter.field("scaling_plan_name", &self.scaling_plan_name);
        formatter.field("scaling_plan_version", &self.scaling_plan_version);
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("scalable_dimension", &self.scalable_dimension);
        formatter.field("scaling_policies", &self.scaling_policies);
        formatter.field("scaling_status_code", &self.scaling_status_code);
        formatter.field("scaling_status_message", &self.scaling_status_message);
        formatter.finish()
    }
}
/// See [`ScalingPlanResource`](crate::model::ScalingPlanResource)
pub mod scaling_plan_resource {
    /// A builder for [`ScalingPlanResource`](crate::model::ScalingPlanResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_name: std::option::Option<std::string::String>,
        pub(crate) scaling_plan_version: std::option::Option<i64>,
        pub(crate) service_namespace: std::option::Option<crate::model::ServiceNamespace>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
        pub(crate) scaling_policies:
            std::option::Option<std::vec::Vec<crate::model::ScalingPolicy>>,
        pub(crate) scaling_status_code: std::option::Option<crate::model::ScalingStatusCode>,
        pub(crate) scaling_status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_plan_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_plan_name = input;
            self
        }
        /// <p>The version number of the scaling plan.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.scaling_plan_version = Some(input);
            self
        }
        /// <p>The version number of the scaling plan.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.scaling_plan_version = input;
            self
        }
        /// <p>The namespace of the AWS service.</p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.service_namespace = Some(input);
            self
        }
        /// <p>The namespace of the AWS service.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// </ul>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource. This string consists of the resource type and unique identifier.</p>
        /// <ul>
        /// <li> <p>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code>.</p> </li>
        /// <li> <p>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code>.</p> </li>
        /// <li> <p>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.</p> </li>
        /// <li> <p>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code>.</p> </li>
        /// <li> <p>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code>.</p> </li>
        /// <li> <p>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code>.</p> </li>
        /// </ul>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The scalable dimension for the resource.</p>
        /// <ul>
        /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// </ul>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.scalable_dimension = Some(input);
            self
        }
        /// <p>The scalable dimension for the resource.</p>
        /// <ul>
        /// <li> <p> <code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</p> </li>
        /// <li> <p> <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</p> </li>
        /// <li> <p> <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</p> </li>
        /// <li> <p> <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</p> </li>
        /// <li> <p> <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</p> </li>
        /// <li> <p> <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</p> </li>
        /// </ul>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.scalable_dimension = input;
            self
        }
        /// Appends an item to `scaling_policies`.
        ///
        /// To override the contents of this collection use [`set_scaling_policies`](Self::set_scaling_policies).
        ///
        /// <p>The scaling policies.</p>
        pub fn scaling_policies(mut self, input: crate::model::ScalingPolicy) -> Self {
            let mut v = self.scaling_policies.unwrap_or_default();
            v.push(input);
            self.scaling_policies = Some(v);
            self
        }
        /// <p>The scaling policies.</p>
        pub fn set_scaling_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingPolicy>>,
        ) -> Self {
            self.scaling_policies = input;
            self
        }
        /// <p>The scaling status of the resource.</p>
        /// <ul>
        /// <li> <p> <code>Active</code> - The scaling configuration is active.</p> </li>
        /// <li> <p> <code>Inactive</code> - The scaling configuration is not active because the scaling plan is being created or the scaling configuration could not be applied. Check the status message for more information.</p> </li>
        /// <li> <p> <code>PartiallyActive</code> - The scaling configuration is partially active because the scaling plan is being created or deleted or the scaling configuration could not be fully applied. Check the status message for more information.</p> </li>
        /// </ul>
        pub fn scaling_status_code(mut self, input: crate::model::ScalingStatusCode) -> Self {
            self.scaling_status_code = Some(input);
            self
        }
        /// <p>The scaling status of the resource.</p>
        /// <ul>
        /// <li> <p> <code>Active</code> - The scaling configuration is active.</p> </li>
        /// <li> <p> <code>Inactive</code> - The scaling configuration is not active because the scaling plan is being created or the scaling configuration could not be applied. Check the status message for more information.</p> </li>
        /// <li> <p> <code>PartiallyActive</code> - The scaling configuration is partially active because the scaling plan is being created or deleted or the scaling configuration could not be fully applied. Check the status message for more information.</p> </li>
        /// </ul>
        pub fn set_scaling_status_code(
            mut self,
            input: std::option::Option<crate::model::ScalingStatusCode>,
        ) -> Self {
            self.scaling_status_code = input;
            self
        }
        /// <p>A simple message about the current scaling status of the resource.</p>
        pub fn scaling_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_status_message = Some(input.into());
            self
        }
        /// <p>A simple message about the current scaling status of the resource.</p>
        pub fn set_scaling_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingPlanResource`](crate::model::ScalingPlanResource)
        pub fn build(self) -> crate::model::ScalingPlanResource {
            crate::model::ScalingPlanResource {
                scaling_plan_name: self.scaling_plan_name,
                scaling_plan_version: self.scaling_plan_version,
                service_namespace: self.service_namespace,
                resource_id: self.resource_id,
                scalable_dimension: self.scalable_dimension,
                scaling_policies: self.scaling_policies,
                scaling_status_code: self.scaling_status_code,
                scaling_status_message: self.scaling_status_message,
            }
        }
    }
}
impl ScalingPlanResource {
    /// Creates a new builder-style object to manufacture [`ScalingPlanResource`](crate::model::ScalingPlanResource)
    pub fn builder() -> crate::model::scaling_plan_resource::Builder {
        crate::model::scaling_plan_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    PartiallyActive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "Active" => ScalingStatusCode::Active,
            "Inactive" => ScalingStatusCode::Inactive,
            "PartiallyActive" => ScalingStatusCode::PartiallyActive,
            other => ScalingStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingStatusCode::from(s))
    }
}
impl ScalingStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingStatusCode::Active => "Active",
            ScalingStatusCode::Inactive => "Inactive",
            ScalingStatusCode::PartiallyActive => "PartiallyActive",
            ScalingStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Inactive", "PartiallyActive"]
    }
}
impl AsRef<str> for ScalingStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a scaling policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingPolicy {
    /// <p>The name of the scaling policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The type of scaling policy.</p>
    pub policy_type: std::option::Option<crate::model::PolicyType>,
    /// <p>The target tracking scaling policy. Includes support for predefined or customized metrics.</p>
    pub target_tracking_configuration:
        std::option::Option<crate::model::TargetTrackingConfiguration>,
}
impl ScalingPolicy {
    /// <p>The name of the scaling policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The type of scaling policy.</p>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.policy_type.as_ref()
    }
    /// <p>The target tracking scaling policy. Includes support for predefined or customized metrics.</p>
    pub fn target_tracking_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TargetTrackingConfiguration> {
        self.target_tracking_configuration.as_ref()
    }
}
impl std::fmt::Debug for ScalingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingPolicy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_type", &self.policy_type);
        formatter.field(
            "target_tracking_configuration",
            &self.target_tracking_configuration,
        );
        formatter.finish()
    }
}
/// See [`ScalingPolicy`](crate::model::ScalingPolicy)
pub mod scaling_policy {
    /// A builder for [`ScalingPolicy`](crate::model::ScalingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
        pub(crate) target_tracking_configuration:
            std::option::Option<crate::model::TargetTrackingConfiguration>,
    }
    impl Builder {
        /// <p>The name of the scaling policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The type of scaling policy.</p>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The type of scaling policy.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>The target tracking scaling policy. Includes support for predefined or customized metrics.</p>
        pub fn target_tracking_configuration(
            mut self,
            input: crate::model::TargetTrackingConfiguration,
        ) -> Self {
            self.target_tracking_configuration = Some(input);
            self
        }
        /// <p>The target tracking scaling policy. Includes support for predefined or customized metrics.</p>
        pub fn set_target_tracking_configuration(
            mut self,
            input: std::option::Option<crate::model::TargetTrackingConfiguration>,
        ) -> Self {
            self.target_tracking_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingPolicy`](crate::model::ScalingPolicy)
        pub fn build(self) -> crate::model::ScalingPolicy {
            crate::model::ScalingPolicy {
                policy_name: self.policy_name,
                policy_type: self.policy_type,
                target_tracking_configuration: self.target_tracking_configuration,
            }
        }
    }
}
impl ScalingPolicy {
    /// Creates a new builder-style object to manufacture [`ScalingPolicy`](crate::model::ScalingPolicy)
    pub fn builder() -> crate::model::scaling_policy::Builder {
        crate::model::scaling_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyType {
    #[allow(missing_docs)] // documentation missing in model
    TargetTrackingScaling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyType {
    fn from(s: &str) -> Self {
        match s {
            "TargetTrackingScaling" => PolicyType::TargetTrackingScaling,
            other => PolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyType::from(s))
    }
}
impl PolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyType::TargetTrackingScaling => "TargetTrackingScaling",
            PolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TargetTrackingScaling"]
    }
}
impl AsRef<str> for PolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
