// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateScalingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateScalingPlanError {
    /// Kind of error that occurred.
    pub kind: CreateScalingPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateScalingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateScalingPlanErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to a scaling plan that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>Your account exceeded a limit. This exception is thrown when a per-account resource limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An exception was thrown for a validation issue. Review the parameters provided.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateScalingPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateScalingPlanErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            CreateScalingPlanErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateScalingPlanErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateScalingPlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateScalingPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateScalingPlanError {
    fn code(&self) -> Option<&str> {
        CreateScalingPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateScalingPlanError {
    /// Creates a new `CreateScalingPlanError`.
    pub fn new(kind: CreateScalingPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateScalingPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateScalingPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateScalingPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateScalingPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateScalingPlanErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScalingPlanErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScalingPlanErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScalingPlanErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScalingPlanErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScalingPlanErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScalingPlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScalingPlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateScalingPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateScalingPlanErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            CreateScalingPlanErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateScalingPlanErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateScalingPlanErrorKind::ValidationException(_inner) => Some(_inner),
            CreateScalingPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScalingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScalingPlanError {
    /// Kind of error that occurred.
    pub kind: DeleteScalingPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScalingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScalingPlanErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to a scaling plan that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified object could not be found.</p>
    ObjectNotFoundException(crate::error::ObjectNotFoundException),
    /// <p>An exception was thrown for a validation issue. Review the parameters provided.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScalingPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScalingPlanErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DeleteScalingPlanErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteScalingPlanErrorKind::ObjectNotFoundException(_inner) => _inner.fmt(f),
            DeleteScalingPlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteScalingPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScalingPlanError {
    fn code(&self) -> Option<&str> {
        DeleteScalingPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScalingPlanError {
    /// Creates a new `DeleteScalingPlanError`.
    pub fn new(kind: DeleteScalingPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScalingPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScalingPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScalingPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScalingPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScalingPlanErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPlanErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPlanErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPlanErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPlanErrorKind::ObjectNotFoundException`.
    pub fn is_object_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPlanErrorKind::ObjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteScalingPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScalingPlanErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DeleteScalingPlanErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteScalingPlanErrorKind::ObjectNotFoundException(_inner) => Some(_inner),
            DeleteScalingPlanErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteScalingPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingPlanResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingPlanResourcesError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingPlanResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingPlanResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingPlanResourcesErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to a scaling plan that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The token provided is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception was thrown for a validation issue. Review the parameters provided.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingPlanResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingPlanResourcesErrorKind::ConcurrentUpdateException(_inner) => {
                _inner.fmt(f)
            }
            DescribeScalingPlanResourcesErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeScalingPlanResourcesErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeScalingPlanResourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeScalingPlanResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingPlanResourcesError {
    fn code(&self) -> Option<&str> {
        DescribeScalingPlanResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingPlanResourcesError {
    /// Creates a new `DescribeScalingPlanResourcesError`.
    pub fn new(kind: DescribeScalingPlanResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingPlanResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingPlanResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingPlanResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingPlanResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalingPlanResourcesErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlanResourcesErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPlanResourcesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlanResourcesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPlanResourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlanResourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPlanResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlanResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeScalingPlanResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingPlanResourcesErrorKind::ConcurrentUpdateException(_inner) => {
                Some(_inner)
            }
            DescribeScalingPlanResourcesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScalingPlanResourcesErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            DescribeScalingPlanResourcesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeScalingPlanResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingPlansError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingPlansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingPlansErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to a scaling plan that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The token provided is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>An exception was thrown for a validation issue. Review the parameters provided.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingPlansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingPlansErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            DescribeScalingPlansErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeScalingPlansErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeScalingPlansErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeScalingPlansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingPlansError {
    fn code(&self) -> Option<&str> {
        DescribeScalingPlansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingPlansError {
    /// Creates a new `DescribeScalingPlansError`.
    pub fn new(kind: DescribeScalingPlansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingPlansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingPlansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingPlansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingPlansErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalingPlansErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlansErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPlansErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlansErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPlansErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlansErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPlansErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPlansErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeScalingPlansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingPlansErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            DescribeScalingPlansErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScalingPlansErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeScalingPlansErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeScalingPlansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetScalingPlanResourceForecastData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetScalingPlanResourceForecastDataError {
    /// Kind of error that occurred.
    pub kind: GetScalingPlanResourceForecastDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetScalingPlanResourceForecastData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetScalingPlanResourceForecastDataErrorKind {
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>An exception was thrown for a validation issue. Review the parameters provided.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetScalingPlanResourceForecastDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetScalingPlanResourceForecastDataErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetScalingPlanResourceForecastDataErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetScalingPlanResourceForecastDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetScalingPlanResourceForecastDataError {
    fn code(&self) -> Option<&str> {
        GetScalingPlanResourceForecastDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetScalingPlanResourceForecastDataError {
    /// Creates a new `GetScalingPlanResourceForecastDataError`.
    pub fn new(
        kind: GetScalingPlanResourceForecastDataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetScalingPlanResourceForecastDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetScalingPlanResourceForecastDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetScalingPlanResourceForecastDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetScalingPlanResourceForecastDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetScalingPlanResourceForecastDataErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetScalingPlanResourceForecastDataErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetScalingPlanResourceForecastDataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetScalingPlanResourceForecastDataErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetScalingPlanResourceForecastDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetScalingPlanResourceForecastDataErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            GetScalingPlanResourceForecastDataErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            GetScalingPlanResourceForecastDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateScalingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateScalingPlanError {
    /// Kind of error that occurred.
    pub kind: UpdateScalingPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateScalingPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateScalingPlanErrorKind {
    /// <p>Concurrent updates caused an exception, for example, if you request an update to a scaling plan that already has a pending update.</p>
    ConcurrentUpdateException(crate::error::ConcurrentUpdateException),
    /// <p>The service encountered an internal error.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified object could not be found.</p>
    ObjectNotFoundException(crate::error::ObjectNotFoundException),
    /// <p>An exception was thrown for a validation issue. Review the parameters provided.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateScalingPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateScalingPlanErrorKind::ConcurrentUpdateException(_inner) => _inner.fmt(f),
            UpdateScalingPlanErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateScalingPlanErrorKind::ObjectNotFoundException(_inner) => _inner.fmt(f),
            UpdateScalingPlanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateScalingPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateScalingPlanError {
    fn code(&self) -> Option<&str> {
        UpdateScalingPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateScalingPlanError {
    /// Creates a new `UpdateScalingPlanError`.
    pub fn new(kind: UpdateScalingPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateScalingPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateScalingPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateScalingPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateScalingPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateScalingPlanErrorKind::ConcurrentUpdateException`.
    pub fn is_concurrent_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingPlanErrorKind::ConcurrentUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateScalingPlanErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingPlanErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateScalingPlanErrorKind::ObjectNotFoundException`.
    pub fn is_object_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingPlanErrorKind::ObjectNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateScalingPlanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingPlanErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateScalingPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateScalingPlanErrorKind::ConcurrentUpdateException(_inner) => Some(_inner),
            UpdateScalingPlanErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateScalingPlanErrorKind::ObjectNotFoundException(_inner) => Some(_inner),
            UpdateScalingPlanErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateScalingPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An exception was thrown for a validation issue. Review the parameters provided.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The specified object could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ObjectNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ObjectNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ObjectNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ObjectNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ObjectNotFoundException {}
/// See [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
pub mod object_not_found_exception {
    /// A builder for [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
        pub fn build(self) -> crate::error::ObjectNotFoundException {
            crate::error::ObjectNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ObjectNotFoundException {
    /// Creates a new builder-style object to manufacture [`ObjectNotFoundException`](crate::error::ObjectNotFoundException)
    pub fn builder() -> crate::error::object_not_found_exception::Builder {
        crate::error::object_not_found_exception::Builder::default()
    }
}

/// <p>The service encountered an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>Concurrent updates caused an exception, for example, if you request an update to a scaling plan that already has a pending update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentUpdateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentUpdateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentUpdateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentUpdateException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentUpdateException {}
/// See [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
pub mod concurrent_update_exception {
    /// A builder for [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
        pub fn build(self) -> crate::error::ConcurrentUpdateException {
            crate::error::ConcurrentUpdateException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentUpdateException {
    /// Creates a new builder-style object to manufacture [`ConcurrentUpdateException`](crate::error::ConcurrentUpdateException)
    pub fn builder() -> crate::error::concurrent_update_exception::Builder {
        crate::error::concurrent_update_exception::Builder::default()
    }
}

/// <p>The token provided is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>Your account exceeded a limit. This exception is thrown when a per-account resource limit is exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
