// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Auto Scaling Plans
///
/// Client for invoking operations on AWS Auto Scaling Plans. Each operation on AWS Auto Scaling Plans is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_autoscalingplans::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_autoscalingplans::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_autoscalingplans::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateScalingPlan`](crate::client::fluent_builders::CreateScalingPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scaling_plan_name(impl Into<String>)`](crate::client::fluent_builders::CreateScalingPlan::scaling_plan_name) / [`set_scaling_plan_name(Option<String>)`](crate::client::fluent_builders::CreateScalingPlan::set_scaling_plan_name): <p>The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.</p>
    ///   - [`application_source(ApplicationSource)`](crate::client::fluent_builders::CreateScalingPlan::application_source) / [`set_application_source(Option<ApplicationSource>)`](crate::client::fluent_builders::CreateScalingPlan::set_application_source): <p>A CloudFormation stack or set of tags. You can create one scaling plan per application source.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    ///   - [`scaling_instructions(Vec<ScalingInstruction>)`](crate::client::fluent_builders::CreateScalingPlan::scaling_instructions) / [`set_scaling_instructions(Option<Vec<ScalingInstruction>>)`](crate::client::fluent_builders::CreateScalingPlan::set_scaling_instructions): <p>The scaling instructions.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    /// - On success, responds with [`CreateScalingPlanOutput`](crate::output::CreateScalingPlanOutput) with field(s):
    ///   - [`scaling_plan_version(Option<i64>)`](crate::output::CreateScalingPlanOutput::scaling_plan_version): <p>The version number of the scaling plan. This value is always <code>1</code>. Currently, you cannot have multiple scaling plan versions.</p>
    /// - On failure, responds with [`SdkError<CreateScalingPlanError>`](crate::error::CreateScalingPlanError)
    pub fn create_scaling_plan(&self) -> fluent_builders::CreateScalingPlan<C, M, R> {
        fluent_builders::CreateScalingPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteScalingPlan`](crate::client::fluent_builders::DeleteScalingPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scaling_plan_name(impl Into<String>)`](crate::client::fluent_builders::DeleteScalingPlan::scaling_plan_name) / [`set_scaling_plan_name(Option<String>)`](crate::client::fluent_builders::DeleteScalingPlan::set_scaling_plan_name): <p>The name of the scaling plan.</p>
    ///   - [`scaling_plan_version(i64)`](crate::client::fluent_builders::DeleteScalingPlan::scaling_plan_version) / [`set_scaling_plan_version(Option<i64>)`](crate::client::fluent_builders::DeleteScalingPlan::set_scaling_plan_version): <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
    /// - On success, responds with [`DeleteScalingPlanOutput`](crate::output::DeleteScalingPlanOutput)

    /// - On failure, responds with [`SdkError<DeleteScalingPlanError>`](crate::error::DeleteScalingPlanError)
    pub fn delete_scaling_plan(&self) -> fluent_builders::DeleteScalingPlan<C, M, R> {
        fluent_builders::DeleteScalingPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeScalingPlanResources`](crate::client::fluent_builders::DescribeScalingPlanResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scaling_plan_name(impl Into<String>)`](crate::client::fluent_builders::DescribeScalingPlanResources::scaling_plan_name) / [`set_scaling_plan_name(Option<String>)`](crate::client::fluent_builders::DescribeScalingPlanResources::set_scaling_plan_name): <p>The name of the scaling plan.</p>
    ///   - [`scaling_plan_version(i64)`](crate::client::fluent_builders::DescribeScalingPlanResources::scaling_plan_version) / [`set_scaling_plan_version(Option<i64>)`](crate::client::fluent_builders::DescribeScalingPlanResources::set_scaling_plan_version): <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeScalingPlanResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeScalingPlanResources::set_max_results): <p>The maximum number of scalable resources to return. The value must be between 1 and 50. The default value is 50.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeScalingPlanResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeScalingPlanResources::set_next_token): <p>The token for the next set of results.</p>
    /// - On success, responds with [`DescribeScalingPlanResourcesOutput`](crate::output::DescribeScalingPlanResourcesOutput) with field(s):
    ///   - [`scaling_plan_resources(Option<Vec<ScalingPlanResource>>)`](crate::output::DescribeScalingPlanResourcesOutput::scaling_plan_resources): <p>Information about the scalable resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeScalingPlanResourcesOutput::next_token): <p>The token required to get the next set of results. This value is <code>null</code> if there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeScalingPlanResourcesError>`](crate::error::DescribeScalingPlanResourcesError)
    pub fn describe_scaling_plan_resources(
        &self,
    ) -> fluent_builders::DescribeScalingPlanResources<C, M, R> {
        fluent_builders::DescribeScalingPlanResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeScalingPlans`](crate::client::fluent_builders::DescribeScalingPlans) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scaling_plan_names(Vec<String>)`](crate::client::fluent_builders::DescribeScalingPlans::scaling_plan_names) / [`set_scaling_plan_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeScalingPlans::set_scaling_plan_names): <p>The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling plan names.</p>
    ///   - [`scaling_plan_version(i64)`](crate::client::fluent_builders::DescribeScalingPlans::scaling_plan_version) / [`set_scaling_plan_version(Option<i64>)`](crate::client::fluent_builders::DescribeScalingPlans::set_scaling_plan_version): <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p> <note>   <p>If you specify a scaling plan version, you must also specify a scaling plan name.</p>  </note>
    ///   - [`application_sources(Vec<ApplicationSource>)`](crate::client::fluent_builders::DescribeScalingPlans::application_sources) / [`set_application_sources(Option<Vec<ApplicationSource>>)`](crate::client::fluent_builders::DescribeScalingPlans::set_application_sources): <p>The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify application sources.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeScalingPlans::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeScalingPlans::set_max_results): <p>The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is 50.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeScalingPlans::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeScalingPlans::set_next_token): <p>The token for the next set of results.</p>
    /// - On success, responds with [`DescribeScalingPlansOutput`](crate::output::DescribeScalingPlansOutput) with field(s):
    ///   - [`scaling_plans(Option<Vec<ScalingPlan>>)`](crate::output::DescribeScalingPlansOutput::scaling_plans): <p>Information about the scaling plans.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeScalingPlansOutput::next_token): <p>The token required to get the next set of results. This value is <code>null</code> if there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeScalingPlansError>`](crate::error::DescribeScalingPlansError)
    pub fn describe_scaling_plans(&self) -> fluent_builders::DescribeScalingPlans<C, M, R> {
        fluent_builders::DescribeScalingPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetScalingPlanResourceForecastData`](crate::client::fluent_builders::GetScalingPlanResourceForecastData) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scaling_plan_name(impl Into<String>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::scaling_plan_name) / [`set_scaling_plan_name(Option<String>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_scaling_plan_name): <p>The name of the scaling plan.</p>
    ///   - [`scaling_plan_version(i64)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::scaling_plan_version) / [`set_scaling_plan_version(Option<i64>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_scaling_plan_version): <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
    ///   - [`service_namespace(ServiceNamespace)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::service_namespace) / [`set_service_namespace(Option<ServiceNamespace>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_service_namespace): <p>The namespace of the AWS service. The only valid value is <code>autoscaling</code>. </p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_resource_id): <p>The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>) followed by the name of a specified Auto Scaling group (<code>my-asg</code>). Example: <code>autoScalingGroup/my-asg</code>. </p>
    ///   - [`scalable_dimension(ScalableDimension)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::scalable_dimension) / [`set_scalable_dimension(Option<ScalableDimension>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_scalable_dimension): <p>The scalable dimension for the resource. The only valid value is <code>autoscaling:autoScalingGroup:DesiredCapacity</code>. </p>
    ///   - [`forecast_data_type(ForecastDataType)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::forecast_data_type) / [`set_forecast_data_type(Option<ForecastDataType>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_forecast_data_type): <p>The type of forecast data to get.</p>  <ul>   <li> <p> <code>LoadForecast</code>: The load metric forecast. </p> </li>   <li> <p> <code>CapacityForecast</code>: The capacity forecast. </p> </li>   <li> <p> <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.</p> </li>   <li> <p> <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.</p> </li>  </ul>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_start_time): <p>The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56 days before the current date and time. </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetScalingPlanResourceForecastData::set_end_time): <p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is seven days. </p>  <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.</p>
    /// - On success, responds with [`GetScalingPlanResourceForecastDataOutput`](crate::output::GetScalingPlanResourceForecastDataOutput) with field(s):
    ///   - [`datapoints(Option<Vec<Datapoint>>)`](crate::output::GetScalingPlanResourceForecastDataOutput::datapoints): <p>The data points to return.</p>
    /// - On failure, responds with [`SdkError<GetScalingPlanResourceForecastDataError>`](crate::error::GetScalingPlanResourceForecastDataError)
    pub fn get_scaling_plan_resource_forecast_data(
        &self,
    ) -> fluent_builders::GetScalingPlanResourceForecastData<C, M, R> {
        fluent_builders::GetScalingPlanResourceForecastData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateScalingPlan`](crate::client::fluent_builders::UpdateScalingPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scaling_plan_name(impl Into<String>)`](crate::client::fluent_builders::UpdateScalingPlan::scaling_plan_name) / [`set_scaling_plan_name(Option<String>)`](crate::client::fluent_builders::UpdateScalingPlan::set_scaling_plan_name): <p>The name of the scaling plan.</p>
    ///   - [`scaling_plan_version(i64)`](crate::client::fluent_builders::UpdateScalingPlan::scaling_plan_version) / [`set_scaling_plan_version(Option<i64>)`](crate::client::fluent_builders::UpdateScalingPlan::set_scaling_plan_version): <p>The version number of the scaling plan. The only valid value is <code>1</code>. Currently, you cannot have multiple scaling plan versions.</p>
    ///   - [`application_source(ApplicationSource)`](crate::client::fluent_builders::UpdateScalingPlan::application_source) / [`set_application_source(Option<ApplicationSource>)`](crate::client::fluent_builders::UpdateScalingPlan::set_application_source): <p>A CloudFormation stack or set of tags.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    ///   - [`scaling_instructions(Vec<ScalingInstruction>)`](crate::client::fluent_builders::UpdateScalingPlan::scaling_instructions) / [`set_scaling_instructions(Option<Vec<ScalingInstruction>>)`](crate::client::fluent_builders::UpdateScalingPlan::set_scaling_instructions): <p>The scaling instructions.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    /// - On success, responds with [`UpdateScalingPlanOutput`](crate::output::UpdateScalingPlanOutput)

    /// - On failure, responds with [`SdkError<UpdateScalingPlanError>`](crate::error::UpdateScalingPlanError)
    pub fn update_scaling_plan(&self) -> fluent_builders::UpdateScalingPlan<C, M, R> {
        fluent_builders::UpdateScalingPlan::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateScalingPlan`.
    ///
    /// <p>Creates a scaling plan. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateScalingPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_scaling_plan_input::Builder,
    }
    impl<C, M, R> CreateScalingPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateScalingPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScalingPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScalingPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateScalingPlanInputOperationOutputAlias,
                crate::output::CreateScalingPlanOutput,
                crate::error::CreateScalingPlanError,
                crate::input::CreateScalingPlanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scaling_plan_name(input.into());
            self
        }
        /// <p>The name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scaling_plan_name(input);
            self
        }
        /// <p>A CloudFormation stack or set of tags. You can create one scaling plan per application source.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn application_source(mut self, input: crate::model::ApplicationSource) -> Self {
            self.inner = self.inner.application_source(input);
            self
        }
        /// <p>A CloudFormation stack or set of tags. You can create one scaling plan per application source.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_application_source(
            mut self,
            input: std::option::Option<crate::model::ApplicationSource>,
        ) -> Self {
            self.inner = self.inner.set_application_source(input);
            self
        }
        /// Appends an item to `ScalingInstructions`.
        ///
        /// To override the contents of this collection use [`set_scaling_instructions`](Self::set_scaling_instructions).
        ///
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn scaling_instructions(mut self, input: crate::model::ScalingInstruction) -> Self {
            self.inner = self.inner.scaling_instructions(input);
            self
        }
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_scaling_instructions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
        ) -> Self {
            self.inner = self.inner.set_scaling_instructions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteScalingPlan`.
    ///
    /// <p>Deletes the specified scaling plan.</p>
    /// <p>Deleting a scaling plan deletes the underlying <code>ScalingInstruction</code> for all of the scalable resources that are covered by the plan.</p>
    /// <p>If the plan has launched resources or has scaling activities in progress, you must delete those resources separately.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteScalingPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_scaling_plan_input::Builder,
    }
    impl<C, M, R> DeleteScalingPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteScalingPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScalingPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScalingPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteScalingPlanInputOperationOutputAlias,
                crate::output::DeleteScalingPlanOutput,
                crate::error::DeleteScalingPlanError,
                crate::input::DeleteScalingPlanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scaling_plan_name(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scaling_plan_name(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.inner = self.inner.scaling_plan_version(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_scaling_plan_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeScalingPlanResources`.
    ///
    /// <p>Describes the scalable resources in the specified scaling plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeScalingPlanResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_scaling_plan_resources_input::Builder,
    }
    impl<C, M, R> DescribeScalingPlanResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeScalingPlanResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScalingPlanResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScalingPlanResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeScalingPlanResourcesInputOperationOutputAlias,
                crate::output::DescribeScalingPlanResourcesOutput,
                crate::error::DescribeScalingPlanResourcesError,
                crate::input::DescribeScalingPlanResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scaling_plan_name(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scaling_plan_name(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.inner = self.inner.scaling_plan_version(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_scaling_plan_version(input);
            self
        }
        /// <p>The maximum number of scalable resources to return. The value must be between 1 and 50. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of scalable resources to return. The value must be between 1 and 50. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeScalingPlans`.
    ///
    /// <p>Describes one or more of your scaling plans.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeScalingPlans<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_scaling_plans_input::Builder,
    }
    impl<C, M, R> DescribeScalingPlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeScalingPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScalingPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScalingPlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeScalingPlansInputOperationOutputAlias,
                crate::output::DescribeScalingPlansOutput,
                crate::error::DescribeScalingPlansError,
                crate::input::DescribeScalingPlansInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ScalingPlanNames`.
        ///
        /// To override the contents of this collection use [`set_scaling_plan_names`](Self::set_scaling_plan_names).
        ///
        /// <p>The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling plan names.</p>
        pub fn scaling_plan_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scaling_plan_names(input.into());
            self
        }
        /// <p>The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling plan names.</p>
        pub fn set_scaling_plan_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_scaling_plan_names(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p> <note>
        /// <p>If you specify a scaling plan version, you must also specify a scaling plan name.</p>
        /// </note>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.inner = self.inner.scaling_plan_version(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p> <note>
        /// <p>If you specify a scaling plan version, you must also specify a scaling plan name.</p>
        /// </note>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_scaling_plan_version(input);
            self
        }
        /// Appends an item to `ApplicationSources`.
        ///
        /// To override the contents of this collection use [`set_application_sources`](Self::set_application_sources).
        ///
        /// <p>The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify application sources.</p>
        pub fn application_sources(mut self, input: crate::model::ApplicationSource) -> Self {
            self.inner = self.inner.application_sources(input);
            self
        }
        /// <p>The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify application sources.</p>
        pub fn set_application_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationSource>>,
        ) -> Self {
            self.inner = self.inner.set_application_sources(input);
            self
        }
        /// <p>The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetScalingPlanResourceForecastData`.
    ///
    /// <p>Retrieves the forecast data for a scalable resource.</p>
    /// <p>Capacity forecasts are represented as predicted values, or data points, that are calculated using historical data points from a specified CloudWatch load metric. Data points are available for up to 56 days. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetScalingPlanResourceForecastData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_scaling_plan_resource_forecast_data_input::Builder,
    }
    impl<C, M, R> GetScalingPlanResourceForecastData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetScalingPlanResourceForecastData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetScalingPlanResourceForecastDataOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetScalingPlanResourceForecastDataError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetScalingPlanResourceForecastDataInputOperationOutputAlias,
                crate::output::GetScalingPlanResourceForecastDataOutput,
                crate::error::GetScalingPlanResourceForecastDataError,
                crate::input::GetScalingPlanResourceForecastDataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scaling_plan_name(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scaling_plan_name(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.inner = self.inner.scaling_plan_version(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_scaling_plan_version(input);
            self
        }
        /// <p>The namespace of the AWS service. The only valid value is <code>autoscaling</code>. </p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.inner = self.inner.service_namespace(input);
            self
        }
        /// <p>The namespace of the AWS service. The only valid value is <code>autoscaling</code>. </p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.inner = self.inner.set_service_namespace(input);
            self
        }
        /// <p>The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>) followed by the name of a specified Auto Scaling group (<code>my-asg</code>). Example: <code>autoScalingGroup/my-asg</code>. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>) followed by the name of a specified Auto Scaling group (<code>my-asg</code>). Example: <code>autoScalingGroup/my-asg</code>. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The scalable dimension for the resource. The only valid value is <code>autoscaling:autoScalingGroup:DesiredCapacity</code>. </p>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.inner = self.inner.scalable_dimension(input);
            self
        }
        /// <p>The scalable dimension for the resource. The only valid value is <code>autoscaling:autoScalingGroup:DesiredCapacity</code>. </p>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.inner = self.inner.set_scalable_dimension(input);
            self
        }
        /// <p>The type of forecast data to get.</p>
        /// <ul>
        /// <li> <p> <code>LoadForecast</code>: The load metric forecast. </p> </li>
        /// <li> <p> <code>CapacityForecast</code>: The capacity forecast. </p> </li>
        /// <li> <p> <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.</p> </li>
        /// <li> <p> <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.</p> </li>
        /// </ul>
        pub fn forecast_data_type(mut self, input: crate::model::ForecastDataType) -> Self {
            self.inner = self.inner.forecast_data_type(input);
            self
        }
        /// <p>The type of forecast data to get.</p>
        /// <ul>
        /// <li> <p> <code>LoadForecast</code>: The load metric forecast. </p> </li>
        /// <li> <p> <code>CapacityForecast</code>: The capacity forecast. </p> </li>
        /// <li> <p> <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.</p> </li>
        /// <li> <p> <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.</p> </li>
        /// </ul>
        pub fn set_forecast_data_type(
            mut self,
            input: std::option::Option<crate::model::ForecastDataType>,
        ) -> Self {
            self.inner = self.inner.set_forecast_data_type(input);
            self
        }
        /// <p>The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56 days before the current date and time. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56 days before the current date and time. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is seven days. </p>
        /// <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is seven days. </p>
        /// <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateScalingPlan`.
    ///
    /// <p>Updates the specified scaling plan.</p>
    /// <p>You cannot update a scaling plan if it is in the process of being created, updated, or deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateScalingPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_scaling_plan_input::Builder,
    }
    impl<C, M, R> UpdateScalingPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateScalingPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateScalingPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateScalingPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateScalingPlanInputOperationOutputAlias,
                crate::output::UpdateScalingPlanOutput,
                crate::error::UpdateScalingPlanError,
                crate::input::UpdateScalingPlanInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scaling_plan_name(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scaling_plan_name(input);
            self
        }
        /// <p>The version number of the scaling plan. The only valid value is <code>1</code>. Currently, you cannot have multiple scaling plan versions.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.inner = self.inner.scaling_plan_version(input);
            self
        }
        /// <p>The version number of the scaling plan. The only valid value is <code>1</code>. Currently, you cannot have multiple scaling plan versions.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_scaling_plan_version(input);
            self
        }
        /// <p>A CloudFormation stack or set of tags.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn application_source(mut self, input: crate::model::ApplicationSource) -> Self {
            self.inner = self.inner.application_source(input);
            self
        }
        /// <p>A CloudFormation stack or set of tags.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_application_source(
            mut self,
            input: std::option::Option<crate::model::ApplicationSource>,
        ) -> Self {
            self.inner = self.inner.set_application_source(input);
            self
        }
        /// Appends an item to `ScalingInstructions`.
        ///
        /// To override the contents of this collection use [`set_scaling_instructions`](Self::set_scaling_instructions).
        ///
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn scaling_instructions(mut self, input: crate::model::ScalingInstruction) -> Self {
            self.inner = self.inner.scaling_instructions(input);
            self
        }
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_scaling_instructions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
        ) -> Self {
            self.inner = self.inner.set_scaling_instructions(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
