// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateScalingPlanInput`](crate::input::CreateScalingPlanInput)
pub mod create_scaling_plan_input {
    /// A builder for [`CreateScalingPlanInput`](crate::input::CreateScalingPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_name: std::option::Option<std::string::String>,
        pub(crate) application_source: std::option::Option<crate::model::ApplicationSource>,
        pub(crate) scaling_instructions:
            std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
    }
    impl Builder {
        /// <p>The name of the scaling plan. Names cannot contain vertical bars, colons, or forward
        /// slashes.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_plan_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling plan. Names cannot contain vertical bars, colons, or forward
        /// slashes.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_plan_name = input;
            self
        }
        /// <p>A CloudFormation stack or set of tags. You can create one scaling plan per application
        /// source.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn application_source(mut self, input: crate::model::ApplicationSource) -> Self {
            self.application_source = Some(input);
            self
        }
        /// <p>A CloudFormation stack or set of tags. You can create one scaling plan per application
        /// source.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_application_source(
            mut self,
            input: std::option::Option<crate::model::ApplicationSource>,
        ) -> Self {
            self.application_source = input;
            self
        }
        /// Appends an item to `scaling_instructions`.
        ///
        /// To override the contents of this collection use [`set_scaling_instructions`](Self::set_scaling_instructions).
        ///
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn scaling_instructions(
            mut self,
            input: impl Into<crate::model::ScalingInstruction>,
        ) -> Self {
            let mut v = self.scaling_instructions.unwrap_or_default();
            v.push(input.into());
            self.scaling_instructions = Some(v);
            self
        }
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_scaling_instructions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
        ) -> Self {
            self.scaling_instructions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScalingPlanInput`](crate::input::CreateScalingPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateScalingPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateScalingPlanInput {
                scaling_plan_name: self.scaling_plan_name,
                application_source: self.application_source,
                scaling_instructions: self.scaling_instructions,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateScalingPlanInputOperationOutputAlias = crate::operation::CreateScalingPlan;
#[doc(hidden)]
pub type CreateScalingPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateScalingPlanInput {
    /// Consumes the builder and constructs an Operation<[`CreateScalingPlan`](crate::operation::CreateScalingPlan)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateScalingPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateScalingPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateScalingPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateScalingPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AnyScaleScalingPlannerFrontendService.CreateScalingPlan",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_scaling_plan(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateScalingPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateScalingPlan",
            "autoscalingplans",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateScalingPlanInput`](crate::input::CreateScalingPlanInput)
    pub fn builder() -> crate::input::create_scaling_plan_input::Builder {
        crate::input::create_scaling_plan_input::Builder::default()
    }
}

/// See [`DeleteScalingPlanInput`](crate::input::DeleteScalingPlanInput)
pub mod delete_scaling_plan_input {
    /// A builder for [`DeleteScalingPlanInput`](crate::input::DeleteScalingPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_name: std::option::Option<std::string::String>,
        pub(crate) scaling_plan_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_plan_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_plan_name = input;
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.scaling_plan_version = Some(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.scaling_plan_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScalingPlanInput`](crate::input::DeleteScalingPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScalingPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScalingPlanInput {
                scaling_plan_name: self.scaling_plan_name,
                scaling_plan_version: self.scaling_plan_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteScalingPlanInputOperationOutputAlias = crate::operation::DeleteScalingPlan;
#[doc(hidden)]
pub type DeleteScalingPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteScalingPlanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteScalingPlan`](crate::operation::DeleteScalingPlan)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteScalingPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteScalingPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteScalingPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteScalingPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AnyScaleScalingPlannerFrontendService.DeleteScalingPlan",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_scaling_plan(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteScalingPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteScalingPlan",
            "autoscalingplans",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteScalingPlanInput`](crate::input::DeleteScalingPlanInput)
    pub fn builder() -> crate::input::delete_scaling_plan_input::Builder {
        crate::input::delete_scaling_plan_input::Builder::default()
    }
}

/// See [`DescribeScalingPlanResourcesInput`](crate::input::DescribeScalingPlanResourcesInput)
pub mod describe_scaling_plan_resources_input {
    /// A builder for [`DescribeScalingPlanResourcesInput`](crate::input::DescribeScalingPlanResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_name: std::option::Option<std::string::String>,
        pub(crate) scaling_plan_version: std::option::Option<i64>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_plan_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_plan_name = input;
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.scaling_plan_version = Some(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.scaling_plan_version = input;
            self
        }
        /// <p>The maximum number of scalable resources to return. The value must be between
        /// 1 and 50. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of scalable resources to return. The value must be between
        /// 1 and 50. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScalingPlanResourcesInput`](crate::input::DescribeScalingPlanResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScalingPlanResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScalingPlanResourcesInput {
                scaling_plan_name: self.scaling_plan_name,
                scaling_plan_version: self.scaling_plan_version,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScalingPlanResourcesInputOperationOutputAlias =
    crate::operation::DescribeScalingPlanResources;
#[doc(hidden)]
pub type DescribeScalingPlanResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeScalingPlanResourcesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScalingPlanResources`](crate::operation::DescribeScalingPlanResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScalingPlanResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeScalingPlanResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeScalingPlanResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeScalingPlanResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AnyScaleScalingPlannerFrontendService.DescribeScalingPlanResources",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_scaling_plan_resources(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScalingPlanResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScalingPlanResources",
            "autoscalingplans",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeScalingPlanResourcesInput`](crate::input::DescribeScalingPlanResourcesInput)
    pub fn builder() -> crate::input::describe_scaling_plan_resources_input::Builder {
        crate::input::describe_scaling_plan_resources_input::Builder::default()
    }
}

/// See [`DescribeScalingPlansInput`](crate::input::DescribeScalingPlansInput)
pub mod describe_scaling_plans_input {
    /// A builder for [`DescribeScalingPlansInput`](crate::input::DescribeScalingPlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scaling_plan_version: std::option::Option<i64>,
        pub(crate) application_sources:
            std::option::Option<std::vec::Vec<crate::model::ApplicationSource>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `scaling_plan_names`.
        ///
        /// To override the contents of this collection use [`set_scaling_plan_names`](Self::set_scaling_plan_names).
        ///
        /// <p>The names of the scaling plans (up to 10). If you specify application sources, you
        /// cannot specify scaling plan names.</p>
        pub fn scaling_plan_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.scaling_plan_names.unwrap_or_default();
            v.push(input.into());
            self.scaling_plan_names = Some(v);
            self
        }
        /// <p>The names of the scaling plans (up to 10). If you specify application sources, you
        /// cannot specify scaling plan names.</p>
        pub fn set_scaling_plan_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.scaling_plan_names = input;
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        /// <note>
        /// <p>If you specify a scaling plan version, you must also specify a scaling plan
        /// name.</p>
        /// </note>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.scaling_plan_version = Some(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        /// <note>
        /// <p>If you specify a scaling plan version, you must also specify a scaling plan
        /// name.</p>
        /// </note>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.scaling_plan_version = input;
            self
        }
        /// Appends an item to `application_sources`.
        ///
        /// To override the contents of this collection use [`set_application_sources`](Self::set_application_sources).
        ///
        /// <p>The sources for the applications (up to 10). If you specify scaling plan names, you
        /// cannot specify application sources.</p>
        pub fn application_sources(
            mut self,
            input: impl Into<crate::model::ApplicationSource>,
        ) -> Self {
            let mut v = self.application_sources.unwrap_or_default();
            v.push(input.into());
            self.application_sources = Some(v);
            self
        }
        /// <p>The sources for the applications (up to 10). If you specify scaling plan names, you
        /// cannot specify application sources.</p>
        pub fn set_application_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationSource>>,
        ) -> Self {
            self.application_sources = input;
            self
        }
        /// <p>The maximum number of scalable resources to return. This value can be between
        /// 1 and 50. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of scalable resources to return. This value can be between
        /// 1 and 50. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScalingPlansInput`](crate::input::DescribeScalingPlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScalingPlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScalingPlansInput {
                scaling_plan_names: self.scaling_plan_names,
                scaling_plan_version: self.scaling_plan_version,
                application_sources: self.application_sources,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScalingPlansInputOperationOutputAlias = crate::operation::DescribeScalingPlans;
#[doc(hidden)]
pub type DescribeScalingPlansInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeScalingPlansInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScalingPlans`](crate::operation::DescribeScalingPlans)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScalingPlans,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeScalingPlansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeScalingPlansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeScalingPlansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AnyScaleScalingPlannerFrontendService.DescribeScalingPlans",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_scaling_plans(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScalingPlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScalingPlans",
            "autoscalingplans",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeScalingPlansInput`](crate::input::DescribeScalingPlansInput)
    pub fn builder() -> crate::input::describe_scaling_plans_input::Builder {
        crate::input::describe_scaling_plans_input::Builder::default()
    }
}

/// See [`GetScalingPlanResourceForecastDataInput`](crate::input::GetScalingPlanResourceForecastDataInput)
pub mod get_scaling_plan_resource_forecast_data_input {
    /// A builder for [`GetScalingPlanResourceForecastDataInput`](crate::input::GetScalingPlanResourceForecastDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_name: std::option::Option<std::string::String>,
        pub(crate) scaling_plan_version: std::option::Option<i64>,
        pub(crate) service_namespace: std::option::Option<crate::model::ServiceNamespace>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
        pub(crate) forecast_data_type: std::option::Option<crate::model::ForecastDataType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_plan_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_plan_name = input;
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.scaling_plan_version = Some(input);
            self
        }
        /// <p>The version number of the scaling plan. Currently, the only valid value is
        /// <code>1</code>.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.scaling_plan_version = input;
            self
        }
        /// <p>The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
        /// </p>
        pub fn service_namespace(mut self, input: crate::model::ServiceNamespace) -> Self {
            self.service_namespace = Some(input);
            self
        }
        /// <p>The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
        /// </p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<crate::model::ServiceNamespace>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>)
        /// followed by the name of a specified Auto Scaling group (<code>my-asg</code>). Example:
        /// <code>autoScalingGroup/my-asg</code>. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>)
        /// followed by the name of a specified Auto Scaling group (<code>my-asg</code>). Example:
        /// <code>autoScalingGroup/my-asg</code>. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The scalable dimension for the resource. The only valid value is
        /// <code>autoscaling:autoScalingGroup:DesiredCapacity</code>. </p>
        pub fn scalable_dimension(mut self, input: crate::model::ScalableDimension) -> Self {
            self.scalable_dimension = Some(input);
            self
        }
        /// <p>The scalable dimension for the resource. The only valid value is
        /// <code>autoscaling:autoScalingGroup:DesiredCapacity</code>. </p>
        pub fn set_scalable_dimension(
            mut self,
            input: std::option::Option<crate::model::ScalableDimension>,
        ) -> Self {
            self.scalable_dimension = input;
            self
        }
        /// <p>The type of forecast data to get.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LoadForecast</code>: The load metric forecast. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CapacityForecast</code>: The capacity forecast. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled
        /// scaling action. This data is calculated as the larger of two values: the capacity
        /// forecast or the minimum capacity in the scaling instruction.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled
        /// scaling action. The calculation used is determined by the predictive scaling maximum
        /// capacity behavior setting in the scaling instruction.</p>
        /// </li>
        /// </ul>
        pub fn forecast_data_type(mut self, input: crate::model::ForecastDataType) -> Self {
            self.forecast_data_type = Some(input);
            self
        }
        /// <p>The type of forecast data to get.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LoadForecast</code>: The load metric forecast. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CapacityForecast</code>: The capacity forecast. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled
        /// scaling action. This data is calculated as the larger of two values: the capacity
        /// forecast or the minimum capacity in the scaling instruction.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled
        /// scaling action. The calculation used is determined by the predictive scaling maximum
        /// capacity behavior setting in the scaling instruction.</p>
        /// </li>
        /// </ul>
        pub fn set_forecast_data_type(
            mut self,
            input: std::option::Option<crate::model::ForecastDataType>,
        ) -> Self {
            self.forecast_data_type = input;
            self
        }
        /// <p>The inclusive start time of the time range for the forecast data to get. The date and
        /// time can be at most 56 days before the current date and time. </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The inclusive start time of the time range for the forecast data to get. The date and
        /// time can be at most 56 days before the current date and time. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time
        /// duration between the start and end time is seven days. </p>
        /// <p>Although this parameter can accept a date and time that is more than two days in the
        /// future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for
        /// periods of two days in advance.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time
        /// duration between the start and end time is seven days. </p>
        /// <p>Although this parameter can accept a date and time that is more than two days in the
        /// future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for
        /// periods of two days in advance.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetScalingPlanResourceForecastDataInput`](crate::input::GetScalingPlanResourceForecastDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetScalingPlanResourceForecastDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetScalingPlanResourceForecastDataInput {
                scaling_plan_name: self.scaling_plan_name,
                scaling_plan_version: self.scaling_plan_version,
                service_namespace: self.service_namespace,
                resource_id: self.resource_id,
                scalable_dimension: self.scalable_dimension,
                forecast_data_type: self.forecast_data_type,
                start_time: self.start_time,
                end_time: self.end_time,
            })
        }
    }
}
#[doc(hidden)]
pub type GetScalingPlanResourceForecastDataInputOperationOutputAlias =
    crate::operation::GetScalingPlanResourceForecastData;
#[doc(hidden)]
pub type GetScalingPlanResourceForecastDataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetScalingPlanResourceForecastDataInput {
    /// Consumes the builder and constructs an Operation<[`GetScalingPlanResourceForecastData`](crate::operation::GetScalingPlanResourceForecastData)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetScalingPlanResourceForecastData,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetScalingPlanResourceForecastDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetScalingPlanResourceForecastDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetScalingPlanResourceForecastDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AnyScaleScalingPlannerFrontendService.GetScalingPlanResourceForecastData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_scaling_plan_resource_forecast_data(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetScalingPlanResourceForecastData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetScalingPlanResourceForecastData",
            "autoscalingplans",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetScalingPlanResourceForecastDataInput`](crate::input::GetScalingPlanResourceForecastDataInput)
    pub fn builder() -> crate::input::get_scaling_plan_resource_forecast_data_input::Builder {
        crate::input::get_scaling_plan_resource_forecast_data_input::Builder::default()
    }
}

/// See [`UpdateScalingPlanInput`](crate::input::UpdateScalingPlanInput)
pub mod update_scaling_plan_input {
    /// A builder for [`UpdateScalingPlanInput`](crate::input::UpdateScalingPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_plan_name: std::option::Option<std::string::String>,
        pub(crate) scaling_plan_version: std::option::Option<i64>,
        pub(crate) application_source: std::option::Option<crate::model::ApplicationSource>,
        pub(crate) scaling_instructions:
            std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
    }
    impl Builder {
        /// <p>The name of the scaling plan.</p>
        pub fn scaling_plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scaling_plan_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling plan.</p>
        pub fn set_scaling_plan_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scaling_plan_name = input;
            self
        }
        /// <p>The version number of the scaling plan. The only valid value is <code>1</code>.
        /// Currently, you cannot have multiple scaling plan versions.</p>
        pub fn scaling_plan_version(mut self, input: i64) -> Self {
            self.scaling_plan_version = Some(input);
            self
        }
        /// <p>The version number of the scaling plan. The only valid value is <code>1</code>.
        /// Currently, you cannot have multiple scaling plan versions.</p>
        pub fn set_scaling_plan_version(mut self, input: std::option::Option<i64>) -> Self {
            self.scaling_plan_version = input;
            self
        }
        /// <p>A CloudFormation stack or set of tags.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn application_source(mut self, input: crate::model::ApplicationSource) -> Self {
            self.application_source = Some(input);
            self
        }
        /// <p>A CloudFormation stack or set of tags.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_application_source(
            mut self,
            input: std::option::Option<crate::model::ApplicationSource>,
        ) -> Self {
            self.application_source = input;
            self
        }
        /// Appends an item to `scaling_instructions`.
        ///
        /// To override the contents of this collection use [`set_scaling_instructions`](Self::set_scaling_instructions).
        ///
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn scaling_instructions(
            mut self,
            input: impl Into<crate::model::ScalingInstruction>,
        ) -> Self {
            let mut v = self.scaling_instructions.unwrap_or_default();
            v.push(input.into());
            self.scaling_instructions = Some(v);
            self
        }
        /// <p>The scaling instructions.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
        pub fn set_scaling_instructions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
        ) -> Self {
            self.scaling_instructions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateScalingPlanInput`](crate::input::UpdateScalingPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateScalingPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateScalingPlanInput {
                scaling_plan_name: self.scaling_plan_name,
                scaling_plan_version: self.scaling_plan_version,
                application_source: self.application_source,
                scaling_instructions: self.scaling_instructions,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateScalingPlanInputOperationOutputAlias = crate::operation::UpdateScalingPlan;
#[doc(hidden)]
pub type UpdateScalingPlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateScalingPlanInput {
    /// Consumes the builder and constructs an Operation<[`UpdateScalingPlan`](crate::operation::UpdateScalingPlan)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateScalingPlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateScalingPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateScalingPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateScalingPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AnyScaleScalingPlannerFrontendService.UpdateScalingPlan",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_scaling_plan(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateScalingPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateScalingPlan",
            "autoscalingplans",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateScalingPlanInput`](crate::input::UpdateScalingPlanInput)
    pub fn builder() -> crate::input::update_scaling_plan_input::Builder {
        crate::input::update_scaling_plan_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateScalingPlanInput {
    /// <p>The name of the scaling plan.</p>
    pub scaling_plan_name: std::option::Option<std::string::String>,
    /// <p>The version number of the scaling plan. The only valid value is <code>1</code>.
    /// Currently, you cannot have multiple scaling plan versions.</p>
    pub scaling_plan_version: std::option::Option<i64>,
    /// <p>A CloudFormation stack or set of tags.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    pub application_source: std::option::Option<crate::model::ApplicationSource>,
    /// <p>The scaling instructions.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    pub scaling_instructions: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
}
impl std::fmt::Debug for UpdateScalingPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateScalingPlanInput");
        formatter.field("scaling_plan_name", &self.scaling_plan_name);
        formatter.field("scaling_plan_version", &self.scaling_plan_version);
        formatter.field("application_source", &self.application_source);
        formatter.field("scaling_instructions", &self.scaling_instructions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetScalingPlanResourceForecastDataInput {
    /// <p>The name of the scaling plan.</p>
    pub scaling_plan_name: std::option::Option<std::string::String>,
    /// <p>The version number of the scaling plan. Currently, the only valid value is
    /// <code>1</code>.</p>
    pub scaling_plan_version: std::option::Option<i64>,
    /// <p>The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
    /// </p>
    pub service_namespace: std::option::Option<crate::model::ServiceNamespace>,
    /// <p>The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>)
    /// followed by the name of a specified Auto Scaling group (<code>my-asg</code>). Example:
    /// <code>autoScalingGroup/my-asg</code>. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The scalable dimension for the resource. The only valid value is
    /// <code>autoscaling:autoScalingGroup:DesiredCapacity</code>. </p>
    pub scalable_dimension: std::option::Option<crate::model::ScalableDimension>,
    /// <p>The type of forecast data to get.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LoadForecast</code>: The load metric forecast. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CapacityForecast</code>: The capacity forecast. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled
    /// scaling action. This data is calculated as the larger of two values: the capacity
    /// forecast or the minimum capacity in the scaling instruction.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled
    /// scaling action. The calculation used is determined by the predictive scaling maximum
    /// capacity behavior setting in the scaling instruction.</p>
    /// </li>
    /// </ul>
    pub forecast_data_type: std::option::Option<crate::model::ForecastDataType>,
    /// <p>The inclusive start time of the time range for the forecast data to get. The date and
    /// time can be at most 56 days before the current date and time. </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time
    /// duration between the start and end time is seven days. </p>
    /// <p>Although this parameter can accept a date and time that is more than two days in the
    /// future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for
    /// periods of two days in advance.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for GetScalingPlanResourceForecastDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetScalingPlanResourceForecastDataInput");
        formatter.field("scaling_plan_name", &self.scaling_plan_name);
        formatter.field("scaling_plan_version", &self.scaling_plan_version);
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("scalable_dimension", &self.scalable_dimension);
        formatter.field("forecast_data_type", &self.forecast_data_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScalingPlansInput {
    /// <p>The names of the scaling plans (up to 10). If you specify application sources, you
    /// cannot specify scaling plan names.</p>
    pub scaling_plan_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The version number of the scaling plan. Currently, the only valid value is
    /// <code>1</code>.</p>
    /// <note>
    /// <p>If you specify a scaling plan version, you must also specify a scaling plan
    /// name.</p>
    /// </note>
    pub scaling_plan_version: std::option::Option<i64>,
    /// <p>The sources for the applications (up to 10). If you specify scaling plan names, you
    /// cannot specify application sources.</p>
    pub application_sources: std::option::Option<std::vec::Vec<crate::model::ApplicationSource>>,
    /// <p>The maximum number of scalable resources to return. This value can be between
    /// 1 and 50. The default value is 50.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeScalingPlansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScalingPlansInput");
        formatter.field("scaling_plan_names", &self.scaling_plan_names);
        formatter.field("scaling_plan_version", &self.scaling_plan_version);
        formatter.field("application_sources", &self.application_sources);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScalingPlanResourcesInput {
    /// <p>The name of the scaling plan.</p>
    pub scaling_plan_name: std::option::Option<std::string::String>,
    /// <p>The version number of the scaling plan. Currently, the only valid value is
    /// <code>1</code>.</p>
    pub scaling_plan_version: std::option::Option<i64>,
    /// <p>The maximum number of scalable resources to return. The value must be between
    /// 1 and 50. The default value is 50.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeScalingPlanResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScalingPlanResourcesInput");
        formatter.field("scaling_plan_name", &self.scaling_plan_name);
        formatter.field("scaling_plan_version", &self.scaling_plan_version);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScalingPlanInput {
    /// <p>The name of the scaling plan.</p>
    pub scaling_plan_name: std::option::Option<std::string::String>,
    /// <p>The version number of the scaling plan. Currently, the only valid value is
    /// <code>1</code>.</p>
    pub scaling_plan_version: std::option::Option<i64>,
}
impl std::fmt::Debug for DeleteScalingPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScalingPlanInput");
        formatter.field("scaling_plan_name", &self.scaling_plan_name);
        formatter.field("scaling_plan_version", &self.scaling_plan_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateScalingPlanInput {
    /// <p>The name of the scaling plan. Names cannot contain vertical bars, colons, or forward
    /// slashes.</p>
    pub scaling_plan_name: std::option::Option<std::string::String>,
    /// <p>A CloudFormation stack or set of tags. You can create one scaling plan per application
    /// source.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    pub application_source: std::option::Option<crate::model::ApplicationSource>,
    /// <p>The scaling instructions.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction</a> in the <i>AWS Auto Scaling API Reference</i>.</p>
    pub scaling_instructions: std::option::Option<std::vec::Vec<crate::model::ScalingInstruction>>,
}
impl std::fmt::Debug for CreateScalingPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateScalingPlanInput");
        formatter.field("scaling_plan_name", &self.scaling_plan_name);
        formatter.field("application_source", &self.application_source);
        formatter.field("scaling_instructions", &self.scaling_instructions);
        formatter.finish()
    }
}
