// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AttachInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_instances`](crate::client::Client::attach_instances).
///
/// See [`crate::client::fluent_builders::AttachInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachInstances {
    _private: (),
}
impl AttachInstances {
    /// Creates a new builder-style object to manufacture [`AttachInstancesInput`](crate::input::AttachInstancesInput)
    pub fn builder() -> crate::input::attach_instances_input::Builder {
        crate::input::attach_instances_input::Builder::default()
    }
    /// Creates a new `AttachInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachInstances {
    type Output = std::result::Result<
        crate::output::AttachInstancesOutput,
        crate::error::AttachInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_instances_error(response)
        } else {
            crate::operation_deser::parse_attach_instances_response(response)
        }
    }
}

/// Operation shape for `AttachLoadBalancers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_load_balancers`](crate::client::Client::attach_load_balancers).
///
/// See [`crate::client::fluent_builders::AttachLoadBalancers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachLoadBalancers {
    _private: (),
}
impl AttachLoadBalancers {
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancersInput`](crate::input::AttachLoadBalancersInput)
    pub fn builder() -> crate::input::attach_load_balancers_input::Builder {
        crate::input::attach_load_balancers_input::Builder::default()
    }
    /// Creates a new `AttachLoadBalancers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachLoadBalancers {
    type Output = std::result::Result<
        crate::output::AttachLoadBalancersOutput,
        crate::error::AttachLoadBalancersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_load_balancers_error(response)
        } else {
            crate::operation_deser::parse_attach_load_balancers_response(response)
        }
    }
}

/// Operation shape for `AttachLoadBalancerTargetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_load_balancer_target_groups`](crate::client::Client::attach_load_balancer_target_groups).
///
/// See [`crate::client::fluent_builders::AttachLoadBalancerTargetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachLoadBalancerTargetGroups {
    _private: (),
}
impl AttachLoadBalancerTargetGroups {
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancerTargetGroupsInput`](crate::input::AttachLoadBalancerTargetGroupsInput)
    pub fn builder() -> crate::input::attach_load_balancer_target_groups_input::Builder {
        crate::input::attach_load_balancer_target_groups_input::Builder::default()
    }
    /// Creates a new `AttachLoadBalancerTargetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachLoadBalancerTargetGroups {
    type Output = std::result::Result<
        crate::output::AttachLoadBalancerTargetGroupsOutput,
        crate::error::AttachLoadBalancerTargetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_load_balancer_target_groups_error(response)
        } else {
            crate::operation_deser::parse_attach_load_balancer_target_groups_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteScheduledAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_scheduled_action`](crate::client::Client::batch_delete_scheduled_action).
///
/// See [`crate::client::fluent_builders::BatchDeleteScheduledAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteScheduledAction {
    _private: (),
}
impl BatchDeleteScheduledAction {
    /// Creates a new builder-style object to manufacture [`BatchDeleteScheduledActionInput`](crate::input::BatchDeleteScheduledActionInput)
    pub fn builder() -> crate::input::batch_delete_scheduled_action_input::Builder {
        crate::input::batch_delete_scheduled_action_input::Builder::default()
    }
    /// Creates a new `BatchDeleteScheduledAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteScheduledAction {
    type Output = std::result::Result<
        crate::output::BatchDeleteScheduledActionOutput,
        crate::error::BatchDeleteScheduledActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_scheduled_action_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_scheduled_action_response(response)
        }
    }
}

/// Operation shape for `BatchPutScheduledUpdateGroupAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_put_scheduled_update_group_action`](crate::client::Client::batch_put_scheduled_update_group_action).
///
/// See [`crate::client::fluent_builders::BatchPutScheduledUpdateGroupAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchPutScheduledUpdateGroupAction {
    _private: (),
}
impl BatchPutScheduledUpdateGroupAction {
    /// Creates a new builder-style object to manufacture [`BatchPutScheduledUpdateGroupActionInput`](crate::input::BatchPutScheduledUpdateGroupActionInput)
    pub fn builder() -> crate::input::batch_put_scheduled_update_group_action_input::Builder {
        crate::input::batch_put_scheduled_update_group_action_input::Builder::default()
    }
    /// Creates a new `BatchPutScheduledUpdateGroupAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchPutScheduledUpdateGroupAction {
    type Output = std::result::Result<
        crate::output::BatchPutScheduledUpdateGroupActionOutput,
        crate::error::BatchPutScheduledUpdateGroupActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_put_scheduled_update_group_action_error(response)
        } else {
            crate::operation_deser::parse_batch_put_scheduled_update_group_action_response(response)
        }
    }
}

/// Operation shape for `CancelInstanceRefresh`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_instance_refresh`](crate::client::Client::cancel_instance_refresh).
///
/// See [`crate::client::fluent_builders::CancelInstanceRefresh`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelInstanceRefresh {
    _private: (),
}
impl CancelInstanceRefresh {
    /// Creates a new builder-style object to manufacture [`CancelInstanceRefreshInput`](crate::input::CancelInstanceRefreshInput)
    pub fn builder() -> crate::input::cancel_instance_refresh_input::Builder {
        crate::input::cancel_instance_refresh_input::Builder::default()
    }
    /// Creates a new `CancelInstanceRefresh` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelInstanceRefresh {
    type Output = std::result::Result<
        crate::output::CancelInstanceRefreshOutput,
        crate::error::CancelInstanceRefreshError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_instance_refresh_error(response)
        } else {
            crate::operation_deser::parse_cancel_instance_refresh_response(response)
        }
    }
}

/// Operation shape for `CompleteLifecycleAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_lifecycle_action`](crate::client::Client::complete_lifecycle_action).
///
/// See [`crate::client::fluent_builders::CompleteLifecycleAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteLifecycleAction {
    _private: (),
}
impl CompleteLifecycleAction {
    /// Creates a new builder-style object to manufacture [`CompleteLifecycleActionInput`](crate::input::CompleteLifecycleActionInput)
    pub fn builder() -> crate::input::complete_lifecycle_action_input::Builder {
        crate::input::complete_lifecycle_action_input::Builder::default()
    }
    /// Creates a new `CompleteLifecycleAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteLifecycleAction {
    type Output = std::result::Result<
        crate::output::CompleteLifecycleActionOutput,
        crate::error::CompleteLifecycleActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_complete_lifecycle_action_error(response)
        } else {
            crate::operation_deser::parse_complete_lifecycle_action_response(response)
        }
    }
}

/// Operation shape for `CreateAutoScalingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_auto_scaling_group`](crate::client::Client::create_auto_scaling_group).
///
/// See [`crate::client::fluent_builders::CreateAutoScalingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAutoScalingGroup {
    _private: (),
}
impl CreateAutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`CreateAutoScalingGroupInput`](crate::input::CreateAutoScalingGroupInput)
    pub fn builder() -> crate::input::create_auto_scaling_group_input::Builder {
        crate::input::create_auto_scaling_group_input::Builder::default()
    }
    /// Creates a new `CreateAutoScalingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAutoScalingGroup {
    type Output = std::result::Result<
        crate::output::CreateAutoScalingGroupOutput,
        crate::error::CreateAutoScalingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_auto_scaling_group_error(response)
        } else {
            crate::operation_deser::parse_create_auto_scaling_group_response(response)
        }
    }
}

/// Operation shape for `CreateLaunchConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_launch_configuration`](crate::client::Client::create_launch_configuration).
///
/// See [`crate::client::fluent_builders::CreateLaunchConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLaunchConfiguration {
    _private: (),
}
impl CreateLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateLaunchConfigurationInput`](crate::input::CreateLaunchConfigurationInput)
    pub fn builder() -> crate::input::create_launch_configuration_input::Builder {
        crate::input::create_launch_configuration_input::Builder::default()
    }
    /// Creates a new `CreateLaunchConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLaunchConfiguration {
    type Output = std::result::Result<
        crate::output::CreateLaunchConfigurationOutput,
        crate::error::CreateLaunchConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_launch_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_launch_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateOrUpdateTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_or_update_tags`](crate::client::Client::create_or_update_tags).
///
/// See [`crate::client::fluent_builders::CreateOrUpdateTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOrUpdateTags {
    _private: (),
}
impl CreateOrUpdateTags {
    /// Creates a new builder-style object to manufacture [`CreateOrUpdateTagsInput`](crate::input::CreateOrUpdateTagsInput)
    pub fn builder() -> crate::input::create_or_update_tags_input::Builder {
        crate::input::create_or_update_tags_input::Builder::default()
    }
    /// Creates a new `CreateOrUpdateTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOrUpdateTags {
    type Output = std::result::Result<
        crate::output::CreateOrUpdateTagsOutput,
        crate::error::CreateOrUpdateTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_or_update_tags_error(response)
        } else {
            crate::operation_deser::parse_create_or_update_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteAutoScalingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_auto_scaling_group`](crate::client::Client::delete_auto_scaling_group).
///
/// See [`crate::client::fluent_builders::DeleteAutoScalingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAutoScalingGroup {
    _private: (),
}
impl DeleteAutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`DeleteAutoScalingGroupInput`](crate::input::DeleteAutoScalingGroupInput)
    pub fn builder() -> crate::input::delete_auto_scaling_group_input::Builder {
        crate::input::delete_auto_scaling_group_input::Builder::default()
    }
    /// Creates a new `DeleteAutoScalingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAutoScalingGroup {
    type Output = std::result::Result<
        crate::output::DeleteAutoScalingGroupOutput,
        crate::error::DeleteAutoScalingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_auto_scaling_group_error(response)
        } else {
            crate::operation_deser::parse_delete_auto_scaling_group_response(response)
        }
    }
}

/// Operation shape for `DeleteLaunchConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_launch_configuration`](crate::client::Client::delete_launch_configuration).
///
/// See [`crate::client::fluent_builders::DeleteLaunchConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLaunchConfiguration {
    _private: (),
}
impl DeleteLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteLaunchConfigurationInput`](crate::input::DeleteLaunchConfigurationInput)
    pub fn builder() -> crate::input::delete_launch_configuration_input::Builder {
        crate::input::delete_launch_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteLaunchConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLaunchConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteLaunchConfigurationOutput,
        crate::error::DeleteLaunchConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_launch_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_launch_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteLifecycleHook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_lifecycle_hook`](crate::client::Client::delete_lifecycle_hook).
///
/// See [`crate::client::fluent_builders::DeleteLifecycleHook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLifecycleHook {
    _private: (),
}
impl DeleteLifecycleHook {
    /// Creates a new builder-style object to manufacture [`DeleteLifecycleHookInput`](crate::input::DeleteLifecycleHookInput)
    pub fn builder() -> crate::input::delete_lifecycle_hook_input::Builder {
        crate::input::delete_lifecycle_hook_input::Builder::default()
    }
    /// Creates a new `DeleteLifecycleHook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLifecycleHook {
    type Output = std::result::Result<
        crate::output::DeleteLifecycleHookOutput,
        crate::error::DeleteLifecycleHookError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_lifecycle_hook_error(response)
        } else {
            crate::operation_deser::parse_delete_lifecycle_hook_response(response)
        }
    }
}

/// Operation shape for `DeleteNotificationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_notification_configuration`](crate::client::Client::delete_notification_configuration).
///
/// See [`crate::client::fluent_builders::DeleteNotificationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNotificationConfiguration {
    _private: (),
}
impl DeleteNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteNotificationConfigurationInput`](crate::input::DeleteNotificationConfigurationInput)
    pub fn builder() -> crate::input::delete_notification_configuration_input::Builder {
        crate::input::delete_notification_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteNotificationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNotificationConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteNotificationConfigurationOutput,
        crate::error::DeleteNotificationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_notification_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_notification_configuration_response(response)
        }
    }
}

/// Operation shape for `DeletePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_policy`](crate::client::Client::delete_policy).
///
/// See [`crate::client::fluent_builders::DeletePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePolicy {
    _private: (),
}
impl DeletePolicy {
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
    /// Creates a new `DeletePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePolicy {
    type Output =
        std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteScheduledAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_scheduled_action`](crate::client::Client::delete_scheduled_action).
///
/// See [`crate::client::fluent_builders::DeleteScheduledAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteScheduledAction {
    _private: (),
}
impl DeleteScheduledAction {
    /// Creates a new builder-style object to manufacture [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
    pub fn builder() -> crate::input::delete_scheduled_action_input::Builder {
        crate::input::delete_scheduled_action_input::Builder::default()
    }
    /// Creates a new `DeleteScheduledAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteScheduledAction {
    type Output = std::result::Result<
        crate::output::DeleteScheduledActionOutput,
        crate::error::DeleteScheduledActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_scheduled_action_error(response)
        } else {
            crate::operation_deser::parse_delete_scheduled_action_response(response)
        }
    }
}

/// Operation shape for `DeleteTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tags`](crate::client::Client::delete_tags).
///
/// See [`crate::client::fluent_builders::DeleteTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTags {
    _private: (),
}
impl DeleteTags {
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
    /// Creates a new `DeleteTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTags {
    type Output =
        std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tags_error(response)
        } else {
            crate::operation_deser::parse_delete_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteWarmPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_warm_pool`](crate::client::Client::delete_warm_pool).
///
/// See [`crate::client::fluent_builders::DeleteWarmPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWarmPool {
    _private: (),
}
impl DeleteWarmPool {
    /// Creates a new builder-style object to manufacture [`DeleteWarmPoolInput`](crate::input::DeleteWarmPoolInput)
    pub fn builder() -> crate::input::delete_warm_pool_input::Builder {
        crate::input::delete_warm_pool_input::Builder::default()
    }
    /// Creates a new `DeleteWarmPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWarmPool {
    type Output =
        std::result::Result<crate::output::DeleteWarmPoolOutput, crate::error::DeleteWarmPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_warm_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_warm_pool_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_limits`](crate::client::Client::describe_account_limits).
///
/// See [`crate::client::fluent_builders::DescribeAccountLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountLimits {
    _private: (),
}
impl DescribeAccountLimits {
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
    /// Creates a new `DescribeAccountLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountLimits {
    type Output = std::result::Result<
        crate::output::DescribeAccountLimitsOutput,
        crate::error::DescribeAccountLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_account_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeAdjustmentTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_adjustment_types`](crate::client::Client::describe_adjustment_types).
///
/// See [`crate::client::fluent_builders::DescribeAdjustmentTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAdjustmentTypes {
    _private: (),
}
impl DescribeAdjustmentTypes {
    /// Creates a new builder-style object to manufacture [`DescribeAdjustmentTypesInput`](crate::input::DescribeAdjustmentTypesInput)
    pub fn builder() -> crate::input::describe_adjustment_types_input::Builder {
        crate::input::describe_adjustment_types_input::Builder::default()
    }
    /// Creates a new `DescribeAdjustmentTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAdjustmentTypes {
    type Output = std::result::Result<
        crate::output::DescribeAdjustmentTypesOutput,
        crate::error::DescribeAdjustmentTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_adjustment_types_error(response)
        } else {
            crate::operation_deser::parse_describe_adjustment_types_response(response)
        }
    }
}

/// Operation shape for `DescribeAutoScalingGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_auto_scaling_groups`](crate::client::Client::describe_auto_scaling_groups).
///
/// See [`crate::client::fluent_builders::DescribeAutoScalingGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutoScalingGroups {
    _private: (),
}
impl DescribeAutoScalingGroups {
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingGroupsInput`](crate::input::DescribeAutoScalingGroupsInput)
    pub fn builder() -> crate::input::describe_auto_scaling_groups_input::Builder {
        crate::input::describe_auto_scaling_groups_input::Builder::default()
    }
    /// Creates a new `DescribeAutoScalingGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutoScalingGroups {
    type Output = std::result::Result<
        crate::output::DescribeAutoScalingGroupsOutput,
        crate::error::DescribeAutoScalingGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_auto_scaling_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_auto_scaling_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeAutoScalingInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_auto_scaling_instances`](crate::client::Client::describe_auto_scaling_instances).
///
/// See [`crate::client::fluent_builders::DescribeAutoScalingInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutoScalingInstances {
    _private: (),
}
impl DescribeAutoScalingInstances {
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingInstancesInput`](crate::input::DescribeAutoScalingInstancesInput)
    pub fn builder() -> crate::input::describe_auto_scaling_instances_input::Builder {
        crate::input::describe_auto_scaling_instances_input::Builder::default()
    }
    /// Creates a new `DescribeAutoScalingInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutoScalingInstances {
    type Output = std::result::Result<
        crate::output::DescribeAutoScalingInstancesOutput,
        crate::error::DescribeAutoScalingInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_auto_scaling_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_auto_scaling_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeAutoScalingNotificationTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_auto_scaling_notification_types`](crate::client::Client::describe_auto_scaling_notification_types).
///
/// See [`crate::client::fluent_builders::DescribeAutoScalingNotificationTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutoScalingNotificationTypes {
    _private: (),
}
impl DescribeAutoScalingNotificationTypes {
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingNotificationTypesInput`](crate::input::DescribeAutoScalingNotificationTypesInput)
    pub fn builder() -> crate::input::describe_auto_scaling_notification_types_input::Builder {
        crate::input::describe_auto_scaling_notification_types_input::Builder::default()
    }
    /// Creates a new `DescribeAutoScalingNotificationTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutoScalingNotificationTypes {
    type Output = std::result::Result<
        crate::output::DescribeAutoScalingNotificationTypesOutput,
        crate::error::DescribeAutoScalingNotificationTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_auto_scaling_notification_types_error(response)
        } else {
            crate::operation_deser::parse_describe_auto_scaling_notification_types_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeInstanceRefreshes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_refreshes`](crate::client::Client::describe_instance_refreshes).
///
/// See [`crate::client::fluent_builders::DescribeInstanceRefreshes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceRefreshes {
    _private: (),
}
impl DescribeInstanceRefreshes {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceRefreshesInput`](crate::input::DescribeInstanceRefreshesInput)
    pub fn builder() -> crate::input::describe_instance_refreshes_input::Builder {
        crate::input::describe_instance_refreshes_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceRefreshes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceRefreshes {
    type Output = std::result::Result<
        crate::output::DescribeInstanceRefreshesOutput,
        crate::error::DescribeInstanceRefreshesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_refreshes_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_refreshes_response(response)
        }
    }
}

/// Operation shape for `DescribeLaunchConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_launch_configurations`](crate::client::Client::describe_launch_configurations).
///
/// See [`crate::client::fluent_builders::DescribeLaunchConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLaunchConfigurations {
    _private: (),
}
impl DescribeLaunchConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeLaunchConfigurationsInput`](crate::input::DescribeLaunchConfigurationsInput)
    pub fn builder() -> crate::input::describe_launch_configurations_input::Builder {
        crate::input::describe_launch_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeLaunchConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLaunchConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeLaunchConfigurationsOutput,
        crate::error::DescribeLaunchConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_launch_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_launch_configurations_response(response)
        }
    }
}

/// Operation shape for `DescribeLifecycleHooks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_lifecycle_hooks`](crate::client::Client::describe_lifecycle_hooks).
///
/// See [`crate::client::fluent_builders::DescribeLifecycleHooks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLifecycleHooks {
    _private: (),
}
impl DescribeLifecycleHooks {
    /// Creates a new builder-style object to manufacture [`DescribeLifecycleHooksInput`](crate::input::DescribeLifecycleHooksInput)
    pub fn builder() -> crate::input::describe_lifecycle_hooks_input::Builder {
        crate::input::describe_lifecycle_hooks_input::Builder::default()
    }
    /// Creates a new `DescribeLifecycleHooks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLifecycleHooks {
    type Output = std::result::Result<
        crate::output::DescribeLifecycleHooksOutput,
        crate::error::DescribeLifecycleHooksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_lifecycle_hooks_error(response)
        } else {
            crate::operation_deser::parse_describe_lifecycle_hooks_response(response)
        }
    }
}

/// Operation shape for `DescribeLifecycleHookTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_lifecycle_hook_types`](crate::client::Client::describe_lifecycle_hook_types).
///
/// See [`crate::client::fluent_builders::DescribeLifecycleHookTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLifecycleHookTypes {
    _private: (),
}
impl DescribeLifecycleHookTypes {
    /// Creates a new builder-style object to manufacture [`DescribeLifecycleHookTypesInput`](crate::input::DescribeLifecycleHookTypesInput)
    pub fn builder() -> crate::input::describe_lifecycle_hook_types_input::Builder {
        crate::input::describe_lifecycle_hook_types_input::Builder::default()
    }
    /// Creates a new `DescribeLifecycleHookTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLifecycleHookTypes {
    type Output = std::result::Result<
        crate::output::DescribeLifecycleHookTypesOutput,
        crate::error::DescribeLifecycleHookTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_lifecycle_hook_types_error(response)
        } else {
            crate::operation_deser::parse_describe_lifecycle_hook_types_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancers`](crate::client::Client::describe_load_balancers).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancers {
    _private: (),
}
impl DescribeLoadBalancers {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    pub fn builder() -> crate::input::describe_load_balancers_input::Builder {
        crate::input::describe_load_balancers_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancers {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancersOutput,
        crate::error::DescribeLoadBalancersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancers_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancers_response(response)
        }
    }
}

/// Operation shape for `DescribeLoadBalancerTargetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_load_balancer_target_groups`](crate::client::Client::describe_load_balancer_target_groups).
///
/// See [`crate::client::fluent_builders::DescribeLoadBalancerTargetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoadBalancerTargetGroups {
    _private: (),
}
impl DescribeLoadBalancerTargetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerTargetGroupsInput`](crate::input::DescribeLoadBalancerTargetGroupsInput)
    pub fn builder() -> crate::input::describe_load_balancer_target_groups_input::Builder {
        crate::input::describe_load_balancer_target_groups_input::Builder::default()
    }
    /// Creates a new `DescribeLoadBalancerTargetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoadBalancerTargetGroups {
    type Output = std::result::Result<
        crate::output::DescribeLoadBalancerTargetGroupsOutput,
        crate::error::DescribeLoadBalancerTargetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_load_balancer_target_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_load_balancer_target_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeMetricCollectionTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_metric_collection_types`](crate::client::Client::describe_metric_collection_types).
///
/// See [`crate::client::fluent_builders::DescribeMetricCollectionTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMetricCollectionTypes {
    _private: (),
}
impl DescribeMetricCollectionTypes {
    /// Creates a new builder-style object to manufacture [`DescribeMetricCollectionTypesInput`](crate::input::DescribeMetricCollectionTypesInput)
    pub fn builder() -> crate::input::describe_metric_collection_types_input::Builder {
        crate::input::describe_metric_collection_types_input::Builder::default()
    }
    /// Creates a new `DescribeMetricCollectionTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMetricCollectionTypes {
    type Output = std::result::Result<
        crate::output::DescribeMetricCollectionTypesOutput,
        crate::error::DescribeMetricCollectionTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_metric_collection_types_error(response)
        } else {
            crate::operation_deser::parse_describe_metric_collection_types_response(response)
        }
    }
}

/// Operation shape for `DescribeNotificationConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_notification_configurations`](crate::client::Client::describe_notification_configurations).
///
/// See [`crate::client::fluent_builders::DescribeNotificationConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNotificationConfigurations {
    _private: (),
}
impl DescribeNotificationConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeNotificationConfigurationsInput`](crate::input::DescribeNotificationConfigurationsInput)
    pub fn builder() -> crate::input::describe_notification_configurations_input::Builder {
        crate::input::describe_notification_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeNotificationConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNotificationConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeNotificationConfigurationsOutput,
        crate::error::DescribeNotificationConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_notification_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_notification_configurations_response(response)
        }
    }
}

/// Operation shape for `DescribePolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_policies`](crate::client::Client::describe_policies).
///
/// See [`crate::client::fluent_builders::DescribePolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePolicies {
    _private: (),
}
impl DescribePolicies {
    /// Creates a new builder-style object to manufacture [`DescribePoliciesInput`](crate::input::DescribePoliciesInput)
    pub fn builder() -> crate::input::describe_policies_input::Builder {
        crate::input::describe_policies_input::Builder::default()
    }
    /// Creates a new `DescribePolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePolicies {
    type Output = std::result::Result<
        crate::output::DescribePoliciesOutput,
        crate::error::DescribePoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_policies_error(response)
        } else {
            crate::operation_deser::parse_describe_policies_response(response)
        }
    }
}

/// Operation shape for `DescribeScalingActivities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scaling_activities`](crate::client::Client::describe_scaling_activities).
///
/// See [`crate::client::fluent_builders::DescribeScalingActivities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScalingActivities {
    _private: (),
}
impl DescribeScalingActivities {
    /// Creates a new builder-style object to manufacture [`DescribeScalingActivitiesInput`](crate::input::DescribeScalingActivitiesInput)
    pub fn builder() -> crate::input::describe_scaling_activities_input::Builder {
        crate::input::describe_scaling_activities_input::Builder::default()
    }
    /// Creates a new `DescribeScalingActivities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScalingActivities {
    type Output = std::result::Result<
        crate::output::DescribeScalingActivitiesOutput,
        crate::error::DescribeScalingActivitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scaling_activities_error(response)
        } else {
            crate::operation_deser::parse_describe_scaling_activities_response(response)
        }
    }
}

/// Operation shape for `DescribeScalingProcessTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scaling_process_types`](crate::client::Client::describe_scaling_process_types).
///
/// See [`crate::client::fluent_builders::DescribeScalingProcessTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScalingProcessTypes {
    _private: (),
}
impl DescribeScalingProcessTypes {
    /// Creates a new builder-style object to manufacture [`DescribeScalingProcessTypesInput`](crate::input::DescribeScalingProcessTypesInput)
    pub fn builder() -> crate::input::describe_scaling_process_types_input::Builder {
        crate::input::describe_scaling_process_types_input::Builder::default()
    }
    /// Creates a new `DescribeScalingProcessTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScalingProcessTypes {
    type Output = std::result::Result<
        crate::output::DescribeScalingProcessTypesOutput,
        crate::error::DescribeScalingProcessTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scaling_process_types_error(response)
        } else {
            crate::operation_deser::parse_describe_scaling_process_types_response(response)
        }
    }
}

/// Operation shape for `DescribeScheduledActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scheduled_actions`](crate::client::Client::describe_scheduled_actions).
///
/// See [`crate::client::fluent_builders::DescribeScheduledActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScheduledActions {
    _private: (),
}
impl DescribeScheduledActions {
    /// Creates a new builder-style object to manufacture [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
    pub fn builder() -> crate::input::describe_scheduled_actions_input::Builder {
        crate::input::describe_scheduled_actions_input::Builder::default()
    }
    /// Creates a new `DescribeScheduledActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScheduledActions {
    type Output = std::result::Result<
        crate::output::DescribeScheduledActionsOutput,
        crate::error::DescribeScheduledActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scheduled_actions_error(response)
        } else {
            crate::operation_deser::parse_describe_scheduled_actions_response(response)
        }
    }
}

/// Operation shape for `DescribeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tags`](crate::client::Client::describe_tags).
///
/// See [`crate::client::fluent_builders::DescribeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTags {
    _private: (),
}
impl DescribeTags {
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
    /// Creates a new `DescribeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTags {
    type Output =
        std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeTerminationPolicyTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_termination_policy_types`](crate::client::Client::describe_termination_policy_types).
///
/// See [`crate::client::fluent_builders::DescribeTerminationPolicyTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTerminationPolicyTypes {
    _private: (),
}
impl DescribeTerminationPolicyTypes {
    /// Creates a new builder-style object to manufacture [`DescribeTerminationPolicyTypesInput`](crate::input::DescribeTerminationPolicyTypesInput)
    pub fn builder() -> crate::input::describe_termination_policy_types_input::Builder {
        crate::input::describe_termination_policy_types_input::Builder::default()
    }
    /// Creates a new `DescribeTerminationPolicyTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTerminationPolicyTypes {
    type Output = std::result::Result<
        crate::output::DescribeTerminationPolicyTypesOutput,
        crate::error::DescribeTerminationPolicyTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_termination_policy_types_error(response)
        } else {
            crate::operation_deser::parse_describe_termination_policy_types_response(response)
        }
    }
}

/// Operation shape for `DescribeWarmPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_warm_pool`](crate::client::Client::describe_warm_pool).
///
/// See [`crate::client::fluent_builders::DescribeWarmPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWarmPool {
    _private: (),
}
impl DescribeWarmPool {
    /// Creates a new builder-style object to manufacture [`DescribeWarmPoolInput`](crate::input::DescribeWarmPoolInput)
    pub fn builder() -> crate::input::describe_warm_pool_input::Builder {
        crate::input::describe_warm_pool_input::Builder::default()
    }
    /// Creates a new `DescribeWarmPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWarmPool {
    type Output = std::result::Result<
        crate::output::DescribeWarmPoolOutput,
        crate::error::DescribeWarmPoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_warm_pool_error(response)
        } else {
            crate::operation_deser::parse_describe_warm_pool_response(response)
        }
    }
}

/// Operation shape for `DetachInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_instances`](crate::client::Client::detach_instances).
///
/// See [`crate::client::fluent_builders::DetachInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachInstances {
    _private: (),
}
impl DetachInstances {
    /// Creates a new builder-style object to manufacture [`DetachInstancesInput`](crate::input::DetachInstancesInput)
    pub fn builder() -> crate::input::detach_instances_input::Builder {
        crate::input::detach_instances_input::Builder::default()
    }
    /// Creates a new `DetachInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachInstances {
    type Output = std::result::Result<
        crate::output::DetachInstancesOutput,
        crate::error::DetachInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_instances_error(response)
        } else {
            crate::operation_deser::parse_detach_instances_response(response)
        }
    }
}

/// Operation shape for `DetachLoadBalancers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_load_balancers`](crate::client::Client::detach_load_balancers).
///
/// See [`crate::client::fluent_builders::DetachLoadBalancers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachLoadBalancers {
    _private: (),
}
impl DetachLoadBalancers {
    /// Creates a new builder-style object to manufacture [`DetachLoadBalancersInput`](crate::input::DetachLoadBalancersInput)
    pub fn builder() -> crate::input::detach_load_balancers_input::Builder {
        crate::input::detach_load_balancers_input::Builder::default()
    }
    /// Creates a new `DetachLoadBalancers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachLoadBalancers {
    type Output = std::result::Result<
        crate::output::DetachLoadBalancersOutput,
        crate::error::DetachLoadBalancersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_load_balancers_error(response)
        } else {
            crate::operation_deser::parse_detach_load_balancers_response(response)
        }
    }
}

/// Operation shape for `DetachLoadBalancerTargetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_load_balancer_target_groups`](crate::client::Client::detach_load_balancer_target_groups).
///
/// See [`crate::client::fluent_builders::DetachLoadBalancerTargetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachLoadBalancerTargetGroups {
    _private: (),
}
impl DetachLoadBalancerTargetGroups {
    /// Creates a new builder-style object to manufacture [`DetachLoadBalancerTargetGroupsInput`](crate::input::DetachLoadBalancerTargetGroupsInput)
    pub fn builder() -> crate::input::detach_load_balancer_target_groups_input::Builder {
        crate::input::detach_load_balancer_target_groups_input::Builder::default()
    }
    /// Creates a new `DetachLoadBalancerTargetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachLoadBalancerTargetGroups {
    type Output = std::result::Result<
        crate::output::DetachLoadBalancerTargetGroupsOutput,
        crate::error::DetachLoadBalancerTargetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_load_balancer_target_groups_error(response)
        } else {
            crate::operation_deser::parse_detach_load_balancer_target_groups_response(response)
        }
    }
}

/// Operation shape for `DisableMetricsCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_metrics_collection`](crate::client::Client::disable_metrics_collection).
///
/// See [`crate::client::fluent_builders::DisableMetricsCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableMetricsCollection {
    _private: (),
}
impl DisableMetricsCollection {
    /// Creates a new builder-style object to manufacture [`DisableMetricsCollectionInput`](crate::input::DisableMetricsCollectionInput)
    pub fn builder() -> crate::input::disable_metrics_collection_input::Builder {
        crate::input::disable_metrics_collection_input::Builder::default()
    }
    /// Creates a new `DisableMetricsCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableMetricsCollection {
    type Output = std::result::Result<
        crate::output::DisableMetricsCollectionOutput,
        crate::error::DisableMetricsCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_metrics_collection_error(response)
        } else {
            crate::operation_deser::parse_disable_metrics_collection_response(response)
        }
    }
}

/// Operation shape for `EnableMetricsCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_metrics_collection`](crate::client::Client::enable_metrics_collection).
///
/// See [`crate::client::fluent_builders::EnableMetricsCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableMetricsCollection {
    _private: (),
}
impl EnableMetricsCollection {
    /// Creates a new builder-style object to manufacture [`EnableMetricsCollectionInput`](crate::input::EnableMetricsCollectionInput)
    pub fn builder() -> crate::input::enable_metrics_collection_input::Builder {
        crate::input::enable_metrics_collection_input::Builder::default()
    }
    /// Creates a new `EnableMetricsCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableMetricsCollection {
    type Output = std::result::Result<
        crate::output::EnableMetricsCollectionOutput,
        crate::error::EnableMetricsCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_metrics_collection_error(response)
        } else {
            crate::operation_deser::parse_enable_metrics_collection_response(response)
        }
    }
}

/// Operation shape for `EnterStandby`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enter_standby`](crate::client::Client::enter_standby).
///
/// See [`crate::client::fluent_builders::EnterStandby`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnterStandby {
    _private: (),
}
impl EnterStandby {
    /// Creates a new builder-style object to manufacture [`EnterStandbyInput`](crate::input::EnterStandbyInput)
    pub fn builder() -> crate::input::enter_standby_input::Builder {
        crate::input::enter_standby_input::Builder::default()
    }
    /// Creates a new `EnterStandby` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnterStandby {
    type Output =
        std::result::Result<crate::output::EnterStandbyOutput, crate::error::EnterStandbyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enter_standby_error(response)
        } else {
            crate::operation_deser::parse_enter_standby_response(response)
        }
    }
}

/// Operation shape for `ExecutePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_policy`](crate::client::Client::execute_policy).
///
/// See [`crate::client::fluent_builders::ExecutePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecutePolicy {
    _private: (),
}
impl ExecutePolicy {
    /// Creates a new builder-style object to manufacture [`ExecutePolicyInput`](crate::input::ExecutePolicyInput)
    pub fn builder() -> crate::input::execute_policy_input::Builder {
        crate::input::execute_policy_input::Builder::default()
    }
    /// Creates a new `ExecutePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecutePolicy {
    type Output =
        std::result::Result<crate::output::ExecutePolicyOutput, crate::error::ExecutePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_policy_error(response)
        } else {
            crate::operation_deser::parse_execute_policy_response(response)
        }
    }
}

/// Operation shape for `ExitStandby`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`exit_standby`](crate::client::Client::exit_standby).
///
/// See [`crate::client::fluent_builders::ExitStandby`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExitStandby {
    _private: (),
}
impl ExitStandby {
    /// Creates a new builder-style object to manufacture [`ExitStandbyInput`](crate::input::ExitStandbyInput)
    pub fn builder() -> crate::input::exit_standby_input::Builder {
        crate::input::exit_standby_input::Builder::default()
    }
    /// Creates a new `ExitStandby` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExitStandby {
    type Output =
        std::result::Result<crate::output::ExitStandbyOutput, crate::error::ExitStandbyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_exit_standby_error(response)
        } else {
            crate::operation_deser::parse_exit_standby_response(response)
        }
    }
}

/// Operation shape for `GetPredictiveScalingForecast`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_predictive_scaling_forecast`](crate::client::Client::get_predictive_scaling_forecast).
///
/// See [`crate::client::fluent_builders::GetPredictiveScalingForecast`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPredictiveScalingForecast {
    _private: (),
}
impl GetPredictiveScalingForecast {
    /// Creates a new builder-style object to manufacture [`GetPredictiveScalingForecastInput`](crate::input::GetPredictiveScalingForecastInput)
    pub fn builder() -> crate::input::get_predictive_scaling_forecast_input::Builder {
        crate::input::get_predictive_scaling_forecast_input::Builder::default()
    }
    /// Creates a new `GetPredictiveScalingForecast` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPredictiveScalingForecast {
    type Output = std::result::Result<
        crate::output::GetPredictiveScalingForecastOutput,
        crate::error::GetPredictiveScalingForecastError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_predictive_scaling_forecast_error(response)
        } else {
            crate::operation_deser::parse_get_predictive_scaling_forecast_response(response)
        }
    }
}

/// Operation shape for `PutLifecycleHook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_lifecycle_hook`](crate::client::Client::put_lifecycle_hook).
///
/// See [`crate::client::fluent_builders::PutLifecycleHook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLifecycleHook {
    _private: (),
}
impl PutLifecycleHook {
    /// Creates a new builder-style object to manufacture [`PutLifecycleHookInput`](crate::input::PutLifecycleHookInput)
    pub fn builder() -> crate::input::put_lifecycle_hook_input::Builder {
        crate::input::put_lifecycle_hook_input::Builder::default()
    }
    /// Creates a new `PutLifecycleHook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLifecycleHook {
    type Output = std::result::Result<
        crate::output::PutLifecycleHookOutput,
        crate::error::PutLifecycleHookError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_lifecycle_hook_error(response)
        } else {
            crate::operation_deser::parse_put_lifecycle_hook_response(response)
        }
    }
}

/// Operation shape for `PutNotificationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_notification_configuration`](crate::client::Client::put_notification_configuration).
///
/// See [`crate::client::fluent_builders::PutNotificationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutNotificationConfiguration {
    _private: (),
}
impl PutNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`PutNotificationConfigurationInput`](crate::input::PutNotificationConfigurationInput)
    pub fn builder() -> crate::input::put_notification_configuration_input::Builder {
        crate::input::put_notification_configuration_input::Builder::default()
    }
    /// Creates a new `PutNotificationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutNotificationConfiguration {
    type Output = std::result::Result<
        crate::output::PutNotificationConfigurationOutput,
        crate::error::PutNotificationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_notification_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_notification_configuration_response(response)
        }
    }
}

/// Operation shape for `PutScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_scaling_policy`](crate::client::Client::put_scaling_policy).
///
/// See [`crate::client::fluent_builders::PutScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutScalingPolicy {
    _private: (),
}
impl PutScalingPolicy {
    /// Creates a new builder-style object to manufacture [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
    pub fn builder() -> crate::input::put_scaling_policy_input::Builder {
        crate::input::put_scaling_policy_input::Builder::default()
    }
    /// Creates a new `PutScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutScalingPolicy {
    type Output = std::result::Result<
        crate::output::PutScalingPolicyOutput,
        crate::error::PutScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_put_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `PutScheduledUpdateGroupAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_scheduled_update_group_action`](crate::client::Client::put_scheduled_update_group_action).
///
/// See [`crate::client::fluent_builders::PutScheduledUpdateGroupAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutScheduledUpdateGroupAction {
    _private: (),
}
impl PutScheduledUpdateGroupAction {
    /// Creates a new builder-style object to manufacture [`PutScheduledUpdateGroupActionInput`](crate::input::PutScheduledUpdateGroupActionInput)
    pub fn builder() -> crate::input::put_scheduled_update_group_action_input::Builder {
        crate::input::put_scheduled_update_group_action_input::Builder::default()
    }
    /// Creates a new `PutScheduledUpdateGroupAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutScheduledUpdateGroupAction {
    type Output = std::result::Result<
        crate::output::PutScheduledUpdateGroupActionOutput,
        crate::error::PutScheduledUpdateGroupActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_scheduled_update_group_action_error(response)
        } else {
            crate::operation_deser::parse_put_scheduled_update_group_action_response(response)
        }
    }
}

/// Operation shape for `PutWarmPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_warm_pool`](crate::client::Client::put_warm_pool).
///
/// See [`crate::client::fluent_builders::PutWarmPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutWarmPool {
    _private: (),
}
impl PutWarmPool {
    /// Creates a new builder-style object to manufacture [`PutWarmPoolInput`](crate::input::PutWarmPoolInput)
    pub fn builder() -> crate::input::put_warm_pool_input::Builder {
        crate::input::put_warm_pool_input::Builder::default()
    }
    /// Creates a new `PutWarmPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutWarmPool {
    type Output =
        std::result::Result<crate::output::PutWarmPoolOutput, crate::error::PutWarmPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_warm_pool_error(response)
        } else {
            crate::operation_deser::parse_put_warm_pool_response(response)
        }
    }
}

/// Operation shape for `RecordLifecycleActionHeartbeat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`record_lifecycle_action_heartbeat`](crate::client::Client::record_lifecycle_action_heartbeat).
///
/// See [`crate::client::fluent_builders::RecordLifecycleActionHeartbeat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RecordLifecycleActionHeartbeat {
    _private: (),
}
impl RecordLifecycleActionHeartbeat {
    /// Creates a new builder-style object to manufacture [`RecordLifecycleActionHeartbeatInput`](crate::input::RecordLifecycleActionHeartbeatInput)
    pub fn builder() -> crate::input::record_lifecycle_action_heartbeat_input::Builder {
        crate::input::record_lifecycle_action_heartbeat_input::Builder::default()
    }
    /// Creates a new `RecordLifecycleActionHeartbeat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RecordLifecycleActionHeartbeat {
    type Output = std::result::Result<
        crate::output::RecordLifecycleActionHeartbeatOutput,
        crate::error::RecordLifecycleActionHeartbeatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_record_lifecycle_action_heartbeat_error(response)
        } else {
            crate::operation_deser::parse_record_lifecycle_action_heartbeat_response(response)
        }
    }
}

/// Operation shape for `ResumeProcesses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resume_processes`](crate::client::Client::resume_processes).
///
/// See [`crate::client::fluent_builders::ResumeProcesses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResumeProcesses {
    _private: (),
}
impl ResumeProcesses {
    /// Creates a new builder-style object to manufacture [`ResumeProcessesInput`](crate::input::ResumeProcessesInput)
    pub fn builder() -> crate::input::resume_processes_input::Builder {
        crate::input::resume_processes_input::Builder::default()
    }
    /// Creates a new `ResumeProcesses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResumeProcesses {
    type Output = std::result::Result<
        crate::output::ResumeProcessesOutput,
        crate::error::ResumeProcessesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resume_processes_error(response)
        } else {
            crate::operation_deser::parse_resume_processes_response(response)
        }
    }
}

/// Operation shape for `SetDesiredCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_desired_capacity`](crate::client::Client::set_desired_capacity).
///
/// See [`crate::client::fluent_builders::SetDesiredCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetDesiredCapacity {
    _private: (),
}
impl SetDesiredCapacity {
    /// Creates a new builder-style object to manufacture [`SetDesiredCapacityInput`](crate::input::SetDesiredCapacityInput)
    pub fn builder() -> crate::input::set_desired_capacity_input::Builder {
        crate::input::set_desired_capacity_input::Builder::default()
    }
    /// Creates a new `SetDesiredCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetDesiredCapacity {
    type Output = std::result::Result<
        crate::output::SetDesiredCapacityOutput,
        crate::error::SetDesiredCapacityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_desired_capacity_error(response)
        } else {
            crate::operation_deser::parse_set_desired_capacity_response(response)
        }
    }
}

/// Operation shape for `SetInstanceHealth`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_instance_health`](crate::client::Client::set_instance_health).
///
/// See [`crate::client::fluent_builders::SetInstanceHealth`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetInstanceHealth {
    _private: (),
}
impl SetInstanceHealth {
    /// Creates a new builder-style object to manufacture [`SetInstanceHealthInput`](crate::input::SetInstanceHealthInput)
    pub fn builder() -> crate::input::set_instance_health_input::Builder {
        crate::input::set_instance_health_input::Builder::default()
    }
    /// Creates a new `SetInstanceHealth` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetInstanceHealth {
    type Output = std::result::Result<
        crate::output::SetInstanceHealthOutput,
        crate::error::SetInstanceHealthError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_instance_health_error(response)
        } else {
            crate::operation_deser::parse_set_instance_health_response(response)
        }
    }
}

/// Operation shape for `SetInstanceProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_instance_protection`](crate::client::Client::set_instance_protection).
///
/// See [`crate::client::fluent_builders::SetInstanceProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetInstanceProtection {
    _private: (),
}
impl SetInstanceProtection {
    /// Creates a new builder-style object to manufacture [`SetInstanceProtectionInput`](crate::input::SetInstanceProtectionInput)
    pub fn builder() -> crate::input::set_instance_protection_input::Builder {
        crate::input::set_instance_protection_input::Builder::default()
    }
    /// Creates a new `SetInstanceProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetInstanceProtection {
    type Output = std::result::Result<
        crate::output::SetInstanceProtectionOutput,
        crate::error::SetInstanceProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_instance_protection_error(response)
        } else {
            crate::operation_deser::parse_set_instance_protection_response(response)
        }
    }
}

/// Operation shape for `StartInstanceRefresh`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_instance_refresh`](crate::client::Client::start_instance_refresh).
///
/// See [`crate::client::fluent_builders::StartInstanceRefresh`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartInstanceRefresh {
    _private: (),
}
impl StartInstanceRefresh {
    /// Creates a new builder-style object to manufacture [`StartInstanceRefreshInput`](crate::input::StartInstanceRefreshInput)
    pub fn builder() -> crate::input::start_instance_refresh_input::Builder {
        crate::input::start_instance_refresh_input::Builder::default()
    }
    /// Creates a new `StartInstanceRefresh` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartInstanceRefresh {
    type Output = std::result::Result<
        crate::output::StartInstanceRefreshOutput,
        crate::error::StartInstanceRefreshError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_instance_refresh_error(response)
        } else {
            crate::operation_deser::parse_start_instance_refresh_response(response)
        }
    }
}

/// Operation shape for `SuspendProcesses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`suspend_processes`](crate::client::Client::suspend_processes).
///
/// See [`crate::client::fluent_builders::SuspendProcesses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SuspendProcesses {
    _private: (),
}
impl SuspendProcesses {
    /// Creates a new builder-style object to manufacture [`SuspendProcessesInput`](crate::input::SuspendProcessesInput)
    pub fn builder() -> crate::input::suspend_processes_input::Builder {
        crate::input::suspend_processes_input::Builder::default()
    }
    /// Creates a new `SuspendProcesses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SuspendProcesses {
    type Output = std::result::Result<
        crate::output::SuspendProcessesOutput,
        crate::error::SuspendProcessesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_suspend_processes_error(response)
        } else {
            crate::operation_deser::parse_suspend_processes_response(response)
        }
    }
}

/// Operation shape for `TerminateInstanceInAutoScalingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_instance_in_auto_scaling_group`](crate::client::Client::terminate_instance_in_auto_scaling_group).
///
/// See [`crate::client::fluent_builders::TerminateInstanceInAutoScalingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateInstanceInAutoScalingGroup {
    _private: (),
}
impl TerminateInstanceInAutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`TerminateInstanceInAutoScalingGroupInput`](crate::input::TerminateInstanceInAutoScalingGroupInput)
    pub fn builder() -> crate::input::terminate_instance_in_auto_scaling_group_input::Builder {
        crate::input::terminate_instance_in_auto_scaling_group_input::Builder::default()
    }
    /// Creates a new `TerminateInstanceInAutoScalingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateInstanceInAutoScalingGroup {
    type Output = std::result::Result<
        crate::output::TerminateInstanceInAutoScalingGroupOutput,
        crate::error::TerminateInstanceInAutoScalingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_instance_in_auto_scaling_group_error(response)
        } else {
            crate::operation_deser::parse_terminate_instance_in_auto_scaling_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateAutoScalingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_auto_scaling_group`](crate::client::Client::update_auto_scaling_group).
///
/// See [`crate::client::fluent_builders::UpdateAutoScalingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAutoScalingGroup {
    _private: (),
}
impl UpdateAutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`UpdateAutoScalingGroupInput`](crate::input::UpdateAutoScalingGroupInput)
    pub fn builder() -> crate::input::update_auto_scaling_group_input::Builder {
        crate::input::update_auto_scaling_group_input::Builder::default()
    }
    /// Creates a new `UpdateAutoScalingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAutoScalingGroup {
    type Output = std::result::Result<
        crate::output::UpdateAutoScalingGroupOutput,
        crate::error::UpdateAutoScalingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_auto_scaling_group_error(response)
        } else {
            crate::operation_deser::parse_update_auto_scaling_group_response(response)
        }
    }
}
