// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The request failed because an active instance refresh for the specified Auto Scaling group was
    /// not found. </p>
    ActiveInstanceRefreshNotFoundFault(crate::error::ActiveInstanceRefreshNotFoundFault),
    /// <p>You already have an Auto Scaling group or launch configuration with this name.</p>
    AlreadyExistsFault(crate::error::AlreadyExistsFault),
    /// <p>The request failed because an active instance refresh operation already exists for the
    /// specified Auto Scaling group.</p>
    InstanceRefreshInProgressFault(crate::error::InstanceRefreshInProgressFault),
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// <p>The operation can't be performed because there are scaling activities in
    /// progress.</p>
    ScalingActivityInProgressFault(crate::error::ScalingActivityInProgressFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ActiveInstanceRefreshNotFoundFault(inner) => inner.fmt(f),
            Error::AlreadyExistsFault(inner) => inner.fmt(f),
            Error::InstanceRefreshInProgressFault(inner) => inner.fmt(f),
            Error::InvalidNextToken(inner) => inner.fmt(f),
            Error::LimitExceededFault(inner) => inner.fmt(f),
            Error::ResourceContentionFault(inner) => inner.fmt(f),
            Error::ResourceInUseFault(inner) => inner.fmt(f),
            Error::ScalingActivityInProgressFault(inner) => inner.fmt(f),
            Error::ServiceLinkedRoleFailure(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AttachInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AttachInstancesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AttachInstancesErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::AttachInstancesErrorKind::ServiceLinkedRoleFailure(inner) => {
                    Error::ServiceLinkedRoleFailure(inner)
                }
                crate::error::AttachInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AttachLoadBalancersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AttachLoadBalancersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AttachLoadBalancersErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::AttachLoadBalancersErrorKind::ServiceLinkedRoleFailure(inner) => {
                    Error::ServiceLinkedRoleFailure(inner)
                }
                crate::error::AttachLoadBalancersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AttachLoadBalancerTargetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AttachLoadBalancerTargetGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AttachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::AttachLoadBalancerTargetGroupsErrorKind::ServiceLinkedRoleFailure(
                    inner,
                ) => Error::ServiceLinkedRoleFailure(inner),
                crate::error::AttachLoadBalancerTargetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDeleteScheduledActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDeleteScheduledActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDeleteScheduledActionErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::BatchDeleteScheduledActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::BatchPutScheduledUpdateGroupActionError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::BatchPutScheduledUpdateGroupActionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchPutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(inner) => Error::AlreadyExistsFault(inner),
                crate::error::BatchPutScheduledUpdateGroupActionErrorKind::LimitExceededFault(inner) => Error::LimitExceededFault(inner),
                crate::error::BatchPutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(inner) => Error::ResourceContentionFault(inner),
                crate::error::BatchPutScheduledUpdateGroupActionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelInstanceRefreshError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelInstanceRefreshError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CancelInstanceRefreshErrorKind::ActiveInstanceRefreshNotFoundFault(inner) => Error::ActiveInstanceRefreshNotFoundFault(inner),
                crate::error::CancelInstanceRefreshErrorKind::LimitExceededFault(inner) => Error::LimitExceededFault(inner),
                crate::error::CancelInstanceRefreshErrorKind::ResourceContentionFault(inner) => Error::ResourceContentionFault(inner),
                crate::error::CancelInstanceRefreshErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CompleteLifecycleActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CompleteLifecycleActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CompleteLifecycleActionErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::CompleteLifecycleActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAutoScalingGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAutoScalingGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAutoScalingGroupErrorKind::AlreadyExistsFault(inner) => {
                    Error::AlreadyExistsFault(inner)
                }
                crate::error::CreateAutoScalingGroupErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::CreateAutoScalingGroupErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::CreateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(inner) => {
                    Error::ServiceLinkedRoleFailure(inner)
                }
                crate::error::CreateAutoScalingGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLaunchConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateLaunchConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLaunchConfigurationErrorKind::AlreadyExistsFault(inner) => {
                    Error::AlreadyExistsFault(inner)
                }
                crate::error::CreateLaunchConfigurationErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::CreateLaunchConfigurationErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::CreateLaunchConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateOrUpdateTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateOrUpdateTagsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateOrUpdateTagsErrorKind::AlreadyExistsFault(inner) => {
                    Error::AlreadyExistsFault(inner)
                }
                crate::error::CreateOrUpdateTagsErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::CreateOrUpdateTagsErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::CreateOrUpdateTagsErrorKind::ResourceInUseFault(inner) => {
                    Error::ResourceInUseFault(inner)
                }
                crate::error::CreateOrUpdateTagsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAutoScalingGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAutoScalingGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAutoScalingGroupErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DeleteAutoScalingGroupErrorKind::ResourceInUseFault(inner) => {
                    Error::ResourceInUseFault(inner)
                }
                crate::error::DeleteAutoScalingGroupErrorKind::ScalingActivityInProgressFault(
                    inner,
                ) => Error::ScalingActivityInProgressFault(inner),
                crate::error::DeleteAutoScalingGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLaunchConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteLaunchConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLaunchConfigurationErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DeleteLaunchConfigurationErrorKind::ResourceInUseFault(inner) => {
                    Error::ResourceInUseFault(inner)
                }
                crate::error::DeleteLaunchConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLifecycleHookError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteLifecycleHookError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLifecycleHookErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DeleteLifecycleHookErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteNotificationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteNotificationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteNotificationConfigurationErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DeleteNotificationConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeletePolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePolicyErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DeletePolicyErrorKind::ServiceLinkedRoleFailure(inner) => {
                    Error::ServiceLinkedRoleFailure(inner)
                }
                crate::error::DeletePolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteScheduledActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteScheduledActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteScheduledActionErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DeleteScheduledActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTagsErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DeleteTagsErrorKind::ResourceInUseFault(inner) => {
                    Error::ResourceInUseFault(inner)
                }
                crate::error::DeleteTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteWarmPoolError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteWarmPoolError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteWarmPoolErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::DeleteWarmPoolErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DeleteWarmPoolErrorKind::ResourceInUseFault(inner) => {
                    Error::ResourceInUseFault(inner)
                }
                crate::error::DeleteWarmPoolErrorKind::ScalingActivityInProgressFault(inner) => {
                    Error::ScalingActivityInProgressFault(inner)
                }
                crate::error::DeleteWarmPoolErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountLimitsErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribeAccountLimitsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAdjustmentTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAdjustmentTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAdjustmentTypesErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribeAdjustmentTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAutoScalingGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAutoScalingGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAutoScalingGroupsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeAutoScalingGroupsErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeAutoScalingGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAutoScalingInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAutoScalingInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAutoScalingInstancesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeAutoScalingInstancesErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeAutoScalingInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeAutoScalingNotificationTypesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAutoScalingNotificationTypesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAutoScalingNotificationTypesErrorKind::ResourceContentionFault(inner) => Error::ResourceContentionFault(inner),
                crate::error::DescribeAutoScalingNotificationTypesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInstanceRefreshesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInstanceRefreshesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeInstanceRefreshesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeInstanceRefreshesErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeInstanceRefreshesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLaunchConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLaunchConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLaunchConfigurationsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeLaunchConfigurationsErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeLaunchConfigurationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLifecycleHooksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLifecycleHooksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLifecycleHooksErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribeLifecycleHooksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLifecycleHookTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLifecycleHookTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLifecycleHookTypesErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeLifecycleHookTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLoadBalancersErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeLoadBalancersErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribeLoadBalancersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeLoadBalancerTargetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeLoadBalancerTargetGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeLoadBalancerTargetGroupsErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::DescribeLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(inner) => Error::ResourceContentionFault(inner),
                crate::error::DescribeLoadBalancerTargetGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeMetricCollectionTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeMetricCollectionTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMetricCollectionTypesErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeMetricCollectionTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeNotificationConfigurationsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeNotificationConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeNotificationConfigurationsErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::DescribeNotificationConfigurationsErrorKind::ResourceContentionFault(inner) => Error::ResourceContentionFault(inner),
                crate::error::DescribeNotificationConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePoliciesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePoliciesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribePoliciesErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribePoliciesErrorKind::ServiceLinkedRoleFailure(inner) => {
                    Error::ServiceLinkedRoleFailure(inner)
                }
                crate::error::DescribePoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeScalingActivitiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeScalingActivitiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeScalingActivitiesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeScalingActivitiesErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeScalingActivitiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeScalingProcessTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeScalingProcessTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeScalingProcessTypesErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeScalingProcessTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeScheduledActionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeScheduledActionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeScheduledActionsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeScheduledActionsErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribeScheduledActionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTagsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeTagsErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribeTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeTerminationPolicyTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeTerminationPolicyTypesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTerminationPolicyTypesErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DescribeTerminationPolicyTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeWarmPoolError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeWarmPoolError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeWarmPoolErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeWarmPoolErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::DescribeWarmPoolErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DescribeWarmPoolErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetachInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetachInstancesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetachInstancesErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DetachInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetachLoadBalancersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetachLoadBalancersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetachLoadBalancersErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DetachLoadBalancersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DetachLoadBalancerTargetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DetachLoadBalancerTargetGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::DetachLoadBalancerTargetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableMetricsCollectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisableMetricsCollectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableMetricsCollectionErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::DisableMetricsCollectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableMetricsCollectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::EnableMetricsCollectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableMetricsCollectionErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::EnableMetricsCollectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnterStandbyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EnterStandbyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnterStandbyErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::EnterStandbyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExecutePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ExecutePolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExecutePolicyErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::ExecutePolicyErrorKind::ScalingActivityInProgressFault(inner) => {
                    Error::ScalingActivityInProgressFault(inner)
                }
                crate::error::ExecutePolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExitStandbyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ExitStandbyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExitStandbyErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::ExitStandbyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPredictiveScalingForecastError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPredictiveScalingForecastError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPredictiveScalingForecastErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::GetPredictiveScalingForecastErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutLifecycleHookError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutLifecycleHookError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutLifecycleHookErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::PutLifecycleHookErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::PutLifecycleHookErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutNotificationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutNotificationConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutNotificationConfigurationErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::PutNotificationConfigurationErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::PutNotificationConfigurationErrorKind::ServiceLinkedRoleFailure(
                    inner,
                ) => Error::ServiceLinkedRoleFailure(inner),
                crate::error::PutNotificationConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutScalingPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutScalingPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutScalingPolicyErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::PutScalingPolicyErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::PutScalingPolicyErrorKind::ServiceLinkedRoleFailure(inner) => {
                    Error::ServiceLinkedRoleFailure(inner)
                }
                crate::error::PutScalingPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutScheduledUpdateGroupActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutScheduledUpdateGroupActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(inner) => {
                    Error::AlreadyExistsFault(inner)
                }
                crate::error::PutScheduledUpdateGroupActionErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::PutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::PutScheduledUpdateGroupActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutWarmPoolError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutWarmPoolError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutWarmPoolErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::PutWarmPoolErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::PutWarmPoolErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RecordLifecycleActionHeartbeatError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RecordLifecycleActionHeartbeatError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RecordLifecycleActionHeartbeatErrorKind::ResourceContentionFault(
                    inner,
                ) => Error::ResourceContentionFault(inner),
                crate::error::RecordLifecycleActionHeartbeatErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResumeProcessesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ResumeProcessesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResumeProcessesErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::ResumeProcessesErrorKind::ResourceInUseFault(inner) => {
                    Error::ResourceInUseFault(inner)
                }
                crate::error::ResumeProcessesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetDesiredCapacityError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetDesiredCapacityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetDesiredCapacityErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::SetDesiredCapacityErrorKind::ScalingActivityInProgressFault(
                    inner,
                ) => Error::ScalingActivityInProgressFault(inner),
                crate::error::SetDesiredCapacityErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetInstanceHealthError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetInstanceHealthError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetInstanceHealthErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::SetInstanceHealthErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetInstanceProtectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetInstanceProtectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetInstanceProtectionErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::SetInstanceProtectionErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::SetInstanceProtectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartInstanceRefreshError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartInstanceRefreshError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartInstanceRefreshErrorKind::InstanceRefreshInProgressFault(
                    inner,
                ) => Error::InstanceRefreshInProgressFault(inner),
                crate::error::StartInstanceRefreshErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::StartInstanceRefreshErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::StartInstanceRefreshErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SuspendProcessesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SuspendProcessesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SuspendProcessesErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::SuspendProcessesErrorKind::ResourceInUseFault(inner) => {
                    Error::ResourceInUseFault(inner)
                }
                crate::error::SuspendProcessesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::TerminateInstanceInAutoScalingGroupError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::TerminateInstanceInAutoScalingGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::TerminateInstanceInAutoScalingGroupErrorKind::ResourceContentionFault(inner) => Error::ResourceContentionFault(inner),
                crate::error::TerminateInstanceInAutoScalingGroupErrorKind::ScalingActivityInProgressFault(inner) => Error::ScalingActivityInProgressFault(inner),
                crate::error::TerminateInstanceInAutoScalingGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAutoScalingGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAutoScalingGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAutoScalingGroupErrorKind::ResourceContentionFault(inner) => {
                    Error::ResourceContentionFault(inner)
                }
                crate::error::UpdateAutoScalingGroupErrorKind::ScalingActivityInProgressFault(
                    inner,
                ) => Error::ScalingActivityInProgressFault(inner),
                crate::error::UpdateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(inner) => {
                    Error::ServiceLinkedRoleFailure(inner)
                }
                crate::error::UpdateAutoScalingGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
