// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AttachInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachInstancesError {
    /// Kind of error that occurred.
    pub kind: AttachInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachInstancesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachInstancesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            AttachInstancesErrorKind::ServiceLinkedRoleFailure(_inner) => _inner.fmt(f),
            AttachInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachInstancesError {
    fn code(&self) -> Option<&str> {
        AttachInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachInstancesError {
    /// Creates a new `AttachInstancesError`.
    pub fn new(kind: AttachInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachInstancesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `AttachInstancesErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for AttachInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachInstancesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            AttachInstancesErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            AttachInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachLoadBalancersError {
    /// Kind of error that occurred.
    pub kind: AttachLoadBalancersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachLoadBalancersErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachLoadBalancersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachLoadBalancersErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            AttachLoadBalancersErrorKind::ServiceLinkedRoleFailure(_inner) => _inner.fmt(f),
            AttachLoadBalancersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachLoadBalancersError {
    fn code(&self) -> Option<&str> {
        AttachLoadBalancersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachLoadBalancersError {
    /// Creates a new `AttachLoadBalancersError`.
    pub fn new(kind: AttachLoadBalancersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachLoadBalancersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachLoadBalancersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachLoadBalancersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachLoadBalancersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachLoadBalancersErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancersErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancersErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancersErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for AttachLoadBalancersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachLoadBalancersErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            AttachLoadBalancersErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            AttachLoadBalancersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachLoadBalancerTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachLoadBalancerTargetGroupsError {
    /// Kind of error that occurred.
    pub kind: AttachLoadBalancerTargetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachLoadBalancerTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachLoadBalancerTargetGroupsErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachLoadBalancerTargetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerTargetGroupsErrorKind::ServiceLinkedRoleFailure(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerTargetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachLoadBalancerTargetGroupsError {
    fn code(&self) -> Option<&str> {
        AttachLoadBalancerTargetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachLoadBalancerTargetGroupsError {
    /// Creates a new `AttachLoadBalancerTargetGroupsError`.
    pub fn new(
        kind: AttachLoadBalancerTargetGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachLoadBalancerTargetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachLoadBalancerTargetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachLoadBalancerTargetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachLoadBalancerTargetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTargetGroupsErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTargetGroupsErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for AttachLoadBalancerTargetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerTargetGroupsErrorKind::ServiceLinkedRoleFailure(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerTargetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteScheduledActionError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteScheduledActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteScheduledActionErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteScheduledActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteScheduledActionErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            BatchDeleteScheduledActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteScheduledActionError {
    fn code(&self) -> Option<&str> {
        BatchDeleteScheduledActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteScheduledActionError {
    /// Creates a new `BatchDeleteScheduledActionError`.
    pub fn new(kind: BatchDeleteScheduledActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteScheduledActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteScheduledActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteScheduledActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteScheduledActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteScheduledActionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteScheduledActionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for BatchDeleteScheduledActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteScheduledActionErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            BatchDeleteScheduledActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchPutScheduledUpdateGroupAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchPutScheduledUpdateGroupActionError {
    /// Kind of error that occurred.
    pub kind: BatchPutScheduledUpdateGroupActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchPutScheduledUpdateGroupAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchPutScheduledUpdateGroupActionErrorKind {
    /// <p>You already have an Auto Scaling group or launch configuration with this name.</p>
    AlreadyExistsFault(crate::error::AlreadyExistsFault),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchPutScheduledUpdateGroupActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchPutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            BatchPutScheduledUpdateGroupActionErrorKind::LimitExceededFault(_inner) => {
                _inner.fmt(f)
            }
            BatchPutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            BatchPutScheduledUpdateGroupActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchPutScheduledUpdateGroupActionError {
    fn code(&self) -> Option<&str> {
        BatchPutScheduledUpdateGroupActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchPutScheduledUpdateGroupActionError {
    /// Creates a new `BatchPutScheduledUpdateGroupActionError`.
    pub fn new(
        kind: BatchPutScheduledUpdateGroupActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchPutScheduledUpdateGroupActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchPutScheduledUpdateGroupActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchPutScheduledUpdateGroupActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchPutScheduledUpdateGroupActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchPutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault`.
    pub fn is_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutScheduledUpdateGroupActionErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutScheduledUpdateGroupActionErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutScheduledUpdateGroupActionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for BatchPutScheduledUpdateGroupActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchPutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(_inner) => Some(_inner),
            BatchPutScheduledUpdateGroupActionErrorKind::LimitExceededFault(_inner) => Some(_inner),
            BatchPutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            BatchPutScheduledUpdateGroupActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelInstanceRefresh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelInstanceRefreshError {
    /// Kind of error that occurred.
    pub kind: CancelInstanceRefreshErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelInstanceRefresh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelInstanceRefreshErrorKind {
    /// <p>The request failed because an active instance refresh for the specified Auto Scaling group was
    /// not found. </p>
    ActiveInstanceRefreshNotFoundFault(crate::error::ActiveInstanceRefreshNotFoundFault),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelInstanceRefreshError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelInstanceRefreshErrorKind::ActiveInstanceRefreshNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CancelInstanceRefreshErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            CancelInstanceRefreshErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            CancelInstanceRefreshErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelInstanceRefreshError {
    fn code(&self) -> Option<&str> {
        CancelInstanceRefreshError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelInstanceRefreshError {
    /// Creates a new `CancelInstanceRefreshError`.
    pub fn new(kind: CancelInstanceRefreshErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelInstanceRefreshError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelInstanceRefreshErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelInstanceRefreshError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelInstanceRefreshErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelInstanceRefreshErrorKind::ActiveInstanceRefreshNotFoundFault`.
    pub fn is_active_instance_refresh_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelInstanceRefreshErrorKind::ActiveInstanceRefreshNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInstanceRefreshErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelInstanceRefreshErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CancelInstanceRefreshErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelInstanceRefreshErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for CancelInstanceRefreshError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelInstanceRefreshErrorKind::ActiveInstanceRefreshNotFoundFault(_inner) => {
                Some(_inner)
            }
            CancelInstanceRefreshErrorKind::LimitExceededFault(_inner) => Some(_inner),
            CancelInstanceRefreshErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            CancelInstanceRefreshErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CompleteLifecycleAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CompleteLifecycleActionError {
    /// Kind of error that occurred.
    pub kind: CompleteLifecycleActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CompleteLifecycleAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CompleteLifecycleActionErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CompleteLifecycleActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CompleteLifecycleActionErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            CompleteLifecycleActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CompleteLifecycleActionError {
    fn code(&self) -> Option<&str> {
        CompleteLifecycleActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CompleteLifecycleActionError {
    /// Creates a new `CompleteLifecycleActionError`.
    pub fn new(kind: CompleteLifecycleActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CompleteLifecycleActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CompleteLifecycleActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CompleteLifecycleActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CompleteLifecycleActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CompleteLifecycleActionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLifecycleActionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for CompleteLifecycleActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CompleteLifecycleActionErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            CompleteLifecycleActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAutoScalingGroupError {
    /// Kind of error that occurred.
    pub kind: CreateAutoScalingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAutoScalingGroupErrorKind {
    /// <p>You already have an Auto Scaling group or launch configuration with this name.</p>
    AlreadyExistsFault(crate::error::AlreadyExistsFault),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAutoScalingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAutoScalingGroupErrorKind::AlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateAutoScalingGroupErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            CreateAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            CreateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(_inner) => _inner.fmt(f),
            CreateAutoScalingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAutoScalingGroupError {
    fn code(&self) -> Option<&str> {
        CreateAutoScalingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAutoScalingGroupError {
    /// Creates a new `CreateAutoScalingGroupError`.
    pub fn new(kind: CreateAutoScalingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAutoScalingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAutoScalingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAutoScalingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAutoScalingGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAutoScalingGroupErrorKind::AlreadyExistsFault`.
    pub fn is_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoScalingGroupErrorKind::AlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAutoScalingGroupErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoScalingGroupErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAutoScalingGroupErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoScalingGroupErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for CreateAutoScalingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAutoScalingGroupErrorKind::AlreadyExistsFault(_inner) => Some(_inner),
            CreateAutoScalingGroupErrorKind::LimitExceededFault(_inner) => Some(_inner),
            CreateAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            CreateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            CreateAutoScalingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLaunchConfigurationErrorKind {
    /// <p>You already have an Auto Scaling group or launch configuration with this name.</p>
    AlreadyExistsFault(crate::error::AlreadyExistsFault),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLaunchConfigurationErrorKind::AlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateLaunchConfigurationErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            CreateLaunchConfigurationErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            CreateLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLaunchConfigurationError {
    /// Creates a new `CreateLaunchConfigurationError`.
    pub fn new(kind: CreateLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLaunchConfigurationErrorKind::AlreadyExistsFault`.
    pub fn is_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchConfigurationErrorKind::AlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLaunchConfigurationErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchConfigurationErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLaunchConfigurationErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateLaunchConfigurationErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for CreateLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLaunchConfigurationErrorKind::AlreadyExistsFault(_inner) => Some(_inner),
            CreateLaunchConfigurationErrorKind::LimitExceededFault(_inner) => Some(_inner),
            CreateLaunchConfigurationErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            CreateLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOrUpdateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOrUpdateTagsError {
    /// Kind of error that occurred.
    pub kind: CreateOrUpdateTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOrUpdateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOrUpdateTagsErrorKind {
    /// <p>You already have an Auto Scaling group or launch configuration with this name.</p>
    AlreadyExistsFault(crate::error::AlreadyExistsFault),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOrUpdateTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOrUpdateTagsErrorKind::AlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateOrUpdateTagsErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            CreateOrUpdateTagsErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            CreateOrUpdateTagsErrorKind::ResourceInUseFault(_inner) => _inner.fmt(f),
            CreateOrUpdateTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOrUpdateTagsError {
    fn code(&self) -> Option<&str> {
        CreateOrUpdateTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOrUpdateTagsError {
    /// Creates a new `CreateOrUpdateTagsError`.
    pub fn new(kind: CreateOrUpdateTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOrUpdateTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOrUpdateTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOrUpdateTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOrUpdateTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOrUpdateTagsErrorKind::AlreadyExistsFault`.
    pub fn is_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrUpdateTagsErrorKind::AlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrUpdateTagsErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrUpdateTagsErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrUpdateTagsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrUpdateTagsErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOrUpdateTagsErrorKind::ResourceInUseFault`.
    pub fn is_resource_in_use_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateOrUpdateTagsErrorKind::ResourceInUseFault(_)
        )
    }
}
impl std::error::Error for CreateOrUpdateTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOrUpdateTagsErrorKind::AlreadyExistsFault(_inner) => Some(_inner),
            CreateOrUpdateTagsErrorKind::LimitExceededFault(_inner) => Some(_inner),
            CreateOrUpdateTagsErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            CreateOrUpdateTagsErrorKind::ResourceInUseFault(_inner) => Some(_inner),
            CreateOrUpdateTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAutoScalingGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteAutoScalingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAutoScalingGroupErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// <p>The operation can't be performed because there are scaling activities in
    /// progress.</p>
    ScalingActivityInProgressFault(crate::error::ScalingActivityInProgressFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAutoScalingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DeleteAutoScalingGroupErrorKind::ResourceInUseFault(_inner) => _inner.fmt(f),
            DeleteAutoScalingGroupErrorKind::ScalingActivityInProgressFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteAutoScalingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAutoScalingGroupError {
    fn code(&self) -> Option<&str> {
        DeleteAutoScalingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAutoScalingGroupError {
    /// Creates a new `DeleteAutoScalingGroupError`.
    pub fn new(kind: DeleteAutoScalingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAutoScalingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAutoScalingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAutoScalingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAutoScalingGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAutoScalingGroupErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoScalingGroupErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAutoScalingGroupErrorKind::ResourceInUseFault`.
    pub fn is_resource_in_use_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoScalingGroupErrorKind::ResourceInUseFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAutoScalingGroupErrorKind::ScalingActivityInProgressFault`.
    pub fn is_scaling_activity_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoScalingGroupErrorKind::ScalingActivityInProgressFault(_)
        )
    }
}
impl std::error::Error for DeleteAutoScalingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DeleteAutoScalingGroupErrorKind::ResourceInUseFault(_inner) => Some(_inner),
            DeleteAutoScalingGroupErrorKind::ScalingActivityInProgressFault(_inner) => Some(_inner),
            DeleteAutoScalingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLaunchConfigurationErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLaunchConfigurationErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DeleteLaunchConfigurationErrorKind::ResourceInUseFault(_inner) => _inner.fmt(f),
            DeleteLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLaunchConfigurationError {
    /// Creates a new `DeleteLaunchConfigurationError`.
    pub fn new(kind: DeleteLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLaunchConfigurationErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchConfigurationErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLaunchConfigurationErrorKind::ResourceInUseFault`.
    pub fn is_resource_in_use_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLaunchConfigurationErrorKind::ResourceInUseFault(_)
        )
    }
}
impl std::error::Error for DeleteLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLaunchConfigurationErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DeleteLaunchConfigurationErrorKind::ResourceInUseFault(_inner) => Some(_inner),
            DeleteLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLifecycleHook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLifecycleHookError {
    /// Kind of error that occurred.
    pub kind: DeleteLifecycleHookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLifecycleHook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLifecycleHookErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLifecycleHookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLifecycleHookErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DeleteLifecycleHookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLifecycleHookError {
    fn code(&self) -> Option<&str> {
        DeleteLifecycleHookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLifecycleHookError {
    /// Creates a new `DeleteLifecycleHookError`.
    pub fn new(kind: DeleteLifecycleHookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLifecycleHookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLifecycleHookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLifecycleHookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLifecycleHookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLifecycleHookErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecycleHookErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DeleteLifecycleHookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLifecycleHookErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DeleteLifecycleHookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNotificationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNotificationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteNotificationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNotificationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNotificationConfigurationErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNotificationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNotificationConfigurationErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteNotificationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNotificationConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteNotificationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNotificationConfigurationError {
    /// Creates a new `DeleteNotificationConfigurationError`.
    pub fn new(
        kind: DeleteNotificationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNotificationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNotificationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNotificationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNotificationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNotificationConfigurationErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNotificationConfigurationErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DeleteNotificationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNotificationConfigurationErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            DeleteNotificationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ServiceLinkedRoleFailure(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyError {
    fn code(&self) -> Option<&str> {
        DeletePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyError {
    /// Creates a new `DeletePolicyError`.
    pub fn new(kind: DeletePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for DeletePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DeletePolicyErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            DeletePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScheduledActionError {
    /// Kind of error that occurred.
    pub kind: DeleteScheduledActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScheduledActionErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScheduledActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScheduledActionErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DeleteScheduledActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScheduledActionError {
    fn code(&self) -> Option<&str> {
        DeleteScheduledActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScheduledActionError {
    /// Creates a new `DeleteScheduledActionError`.
    pub fn new(kind: DeleteScheduledActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScheduledActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScheduledActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScheduledActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScheduledActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScheduledActionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledActionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DeleteScheduledActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScheduledActionErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DeleteScheduledActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::ResourceInUseFault(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsError {
    fn code(&self) -> Option<&str> {
        DeleteTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsError {
    /// Creates a new `DeleteTagsError`.
    pub fn new(kind: DeleteTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::ResourceContentionFault(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::ResourceInUseFault`.
    pub fn is_resource_in_use_fault(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::ResourceInUseFault(_))
    }
}
impl std::error::Error for DeleteTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DeleteTagsErrorKind::ResourceInUseFault(_inner) => Some(_inner),
            DeleteTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWarmPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWarmPoolError {
    /// Kind of error that occurred.
    pub kind: DeleteWarmPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWarmPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWarmPoolErrorKind {
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// <p>The operation can't be performed because there are scaling activities in
    /// progress.</p>
    ScalingActivityInProgressFault(crate::error::ScalingActivityInProgressFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWarmPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWarmPoolErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            DeleteWarmPoolErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DeleteWarmPoolErrorKind::ResourceInUseFault(_inner) => _inner.fmt(f),
            DeleteWarmPoolErrorKind::ScalingActivityInProgressFault(_inner) => _inner.fmt(f),
            DeleteWarmPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWarmPoolError {
    fn code(&self) -> Option<&str> {
        DeleteWarmPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWarmPoolError {
    /// Creates a new `DeleteWarmPoolError`.
    pub fn new(kind: DeleteWarmPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWarmPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWarmPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWarmPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWarmPoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWarmPoolErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, DeleteWarmPoolErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `DeleteWarmPoolErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWarmPoolErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWarmPoolErrorKind::ResourceInUseFault`.
    pub fn is_resource_in_use_fault(&self) -> bool {
        matches!(&self.kind, DeleteWarmPoolErrorKind::ResourceInUseFault(_))
    }
    /// Returns `true` if the error kind is `DeleteWarmPoolErrorKind::ScalingActivityInProgressFault`.
    pub fn is_scaling_activity_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWarmPoolErrorKind::ScalingActivityInProgressFault(_)
        )
    }
}
impl std::error::Error for DeleteWarmPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWarmPoolErrorKind::LimitExceededFault(_inner) => Some(_inner),
            DeleteWarmPoolErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DeleteWarmPoolErrorKind::ResourceInUseFault(_inner) => Some(_inner),
            DeleteWarmPoolErrorKind::ScalingActivityInProgressFault(_inner) => Some(_inner),
            DeleteWarmPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountLimitsErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountLimitsErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeAccountLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountLimitsError {
    /// Creates a new `DescribeAccountLimitsError`.
    pub fn new(kind: DescribeAccountLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountLimitsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountLimitsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeAccountLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountLimitsErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAdjustmentTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAdjustmentTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeAdjustmentTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAdjustmentTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAdjustmentTypesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAdjustmentTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAdjustmentTypesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeAdjustmentTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAdjustmentTypesError {
    fn code(&self) -> Option<&str> {
        DescribeAdjustmentTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAdjustmentTypesError {
    /// Creates a new `DescribeAdjustmentTypesError`.
    pub fn new(kind: DescribeAdjustmentTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAdjustmentTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAdjustmentTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAdjustmentTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAdjustmentTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAdjustmentTypesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAdjustmentTypesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeAdjustmentTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAdjustmentTypesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeAdjustmentTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAutoScalingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAutoScalingGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeAutoScalingGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAutoScalingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAutoScalingGroupsErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAutoScalingGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAutoScalingGroupsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAutoScalingGroupsErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeAutoScalingGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAutoScalingGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeAutoScalingGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAutoScalingGroupsError {
    /// Creates a new `DescribeAutoScalingGroupsError`.
    pub fn new(kind: DescribeAutoScalingGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAutoScalingGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAutoScalingGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAutoScalingGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAutoScalingGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAutoScalingGroupsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingGroupsErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutoScalingGroupsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingGroupsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeAutoScalingGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAutoScalingGroupsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAutoScalingGroupsErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeAutoScalingGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAutoScalingInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAutoScalingInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeAutoScalingInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAutoScalingInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAutoScalingInstancesErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAutoScalingInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAutoScalingInstancesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAutoScalingInstancesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeAutoScalingInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAutoScalingInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeAutoScalingInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAutoScalingInstancesError {
    /// Creates a new `DescribeAutoScalingInstancesError`.
    pub fn new(kind: DescribeAutoScalingInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAutoScalingInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAutoScalingInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAutoScalingInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAutoScalingInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAutoScalingInstancesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingInstancesErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutoScalingInstancesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingInstancesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeAutoScalingInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAutoScalingInstancesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAutoScalingInstancesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeAutoScalingInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAutoScalingNotificationTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAutoScalingNotificationTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeAutoScalingNotificationTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAutoScalingNotificationTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAutoScalingNotificationTypesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAutoScalingNotificationTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAutoScalingNotificationTypesErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeAutoScalingNotificationTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAutoScalingNotificationTypesError {
    fn code(&self) -> Option<&str> {
        DescribeAutoScalingNotificationTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAutoScalingNotificationTypesError {
    /// Creates a new `DescribeAutoScalingNotificationTypesError`.
    pub fn new(
        kind: DescribeAutoScalingNotificationTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAutoScalingNotificationTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAutoScalingNotificationTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAutoScalingNotificationTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAutoScalingNotificationTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAutoScalingNotificationTypesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingNotificationTypesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeAutoScalingNotificationTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAutoScalingNotificationTypesErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            DescribeAutoScalingNotificationTypesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeInstanceRefreshes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceRefreshesError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceRefreshesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceRefreshes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceRefreshesErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceRefreshesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceRefreshesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeInstanceRefreshesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeInstanceRefreshesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceRefreshesError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceRefreshesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceRefreshesError {
    /// Creates a new `DescribeInstanceRefreshesError`.
    pub fn new(kind: DescribeInstanceRefreshesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceRefreshesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceRefreshesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceRefreshesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceRefreshesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceRefreshesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceRefreshesErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceRefreshesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceRefreshesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeInstanceRefreshesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceRefreshesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeInstanceRefreshesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeInstanceRefreshesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLaunchConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLaunchConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeLaunchConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLaunchConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLaunchConfigurationsErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLaunchConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLaunchConfigurationsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeLaunchConfigurationsErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeLaunchConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLaunchConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeLaunchConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLaunchConfigurationsError {
    /// Creates a new `DescribeLaunchConfigurationsError`.
    pub fn new(kind: DescribeLaunchConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLaunchConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLaunchConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLaunchConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLaunchConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLaunchConfigurationsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLaunchConfigurationsErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLaunchConfigurationsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLaunchConfigurationsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeLaunchConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLaunchConfigurationsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeLaunchConfigurationsErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeLaunchConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLifecycleHooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLifecycleHooksError {
    /// Kind of error that occurred.
    pub kind: DescribeLifecycleHooksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLifecycleHooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLifecycleHooksErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLifecycleHooksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLifecycleHooksErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeLifecycleHooksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLifecycleHooksError {
    fn code(&self) -> Option<&str> {
        DescribeLifecycleHooksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLifecycleHooksError {
    /// Creates a new `DescribeLifecycleHooksError`.
    pub fn new(kind: DescribeLifecycleHooksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLifecycleHooksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLifecycleHooksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLifecycleHooksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLifecycleHooksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLifecycleHooksErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLifecycleHooksErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeLifecycleHooksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLifecycleHooksErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeLifecycleHooksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLifecycleHookTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLifecycleHookTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeLifecycleHookTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLifecycleHookTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLifecycleHookTypesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLifecycleHookTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLifecycleHookTypesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeLifecycleHookTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLifecycleHookTypesError {
    fn code(&self) -> Option<&str> {
        DescribeLifecycleHookTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLifecycleHookTypesError {
    /// Creates a new `DescribeLifecycleHookTypesError`.
    pub fn new(kind: DescribeLifecycleHookTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLifecycleHookTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLifecycleHookTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLifecycleHookTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLifecycleHookTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLifecycleHookTypesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLifecycleHookTypesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeLifecycleHookTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLifecycleHookTypesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeLifecycleHookTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancersError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancersErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancersErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeLoadBalancersErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeLoadBalancersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancersError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancersError {
    /// Creates a new `DescribeLoadBalancersError`.
    pub fn new(kind: DescribeLoadBalancersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancersErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancersErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancersErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancersErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancersErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeLoadBalancersErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeLoadBalancersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoadBalancerTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoadBalancerTargetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeLoadBalancerTargetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoadBalancerTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoadBalancerTargetGroupsErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoadBalancerTargetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoadBalancerTargetGroupsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeLoadBalancerTargetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoadBalancerTargetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeLoadBalancerTargetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoadBalancerTargetGroupsError {
    /// Creates a new `DescribeLoadBalancerTargetGroupsError`.
    pub fn new(
        kind: DescribeLoadBalancerTargetGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoadBalancerTargetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoadBalancerTargetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoadBalancerTargetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoadBalancerTargetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerTargetGroupsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerTargetGroupsErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoadBalancerTargetGroupsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeLoadBalancerTargetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoadBalancerTargetGroupsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            DescribeLoadBalancerTargetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMetricCollectionTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMetricCollectionTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeMetricCollectionTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMetricCollectionTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMetricCollectionTypesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMetricCollectionTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMetricCollectionTypesErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeMetricCollectionTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMetricCollectionTypesError {
    fn code(&self) -> Option<&str> {
        DescribeMetricCollectionTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMetricCollectionTypesError {
    /// Creates a new `DescribeMetricCollectionTypesError`.
    pub fn new(
        kind: DescribeMetricCollectionTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMetricCollectionTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMetricCollectionTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMetricCollectionTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMetricCollectionTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMetricCollectionTypesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricCollectionTypesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeMetricCollectionTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMetricCollectionTypesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeMetricCollectionTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNotificationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNotificationConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeNotificationConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNotificationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNotificationConfigurationsErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNotificationConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNotificationConfigurationsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeNotificationConfigurationsErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeNotificationConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNotificationConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeNotificationConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNotificationConfigurationsError {
    /// Creates a new `DescribeNotificationConfigurationsError`.
    pub fn new(
        kind: DescribeNotificationConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNotificationConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNotificationConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNotificationConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNotificationConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNotificationConfigurationsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationConfigurationsErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNotificationConfigurationsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNotificationConfigurationsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeNotificationConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNotificationConfigurationsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeNotificationConfigurationsErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            DescribeNotificationConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePoliciesError {
    /// Kind of error that occurred.
    pub kind: DescribePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePoliciesErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePoliciesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribePoliciesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribePoliciesErrorKind::ServiceLinkedRoleFailure(_inner) => _inner.fmt(f),
            DescribePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePoliciesError {
    fn code(&self) -> Option<&str> {
        DescribePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePoliciesError {
    /// Creates a new `DescribePoliciesError`.
    pub fn new(kind: DescribePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePoliciesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, DescribePoliciesErrorKind::InvalidNextToken(_))
    }
    /// Returns `true` if the error kind is `DescribePoliciesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribePoliciesErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePoliciesErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            DescribePoliciesErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for DescribePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePoliciesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribePoliciesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribePoliciesErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            DescribePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingActivitiesError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingActivitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingActivitiesErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingActivitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingActivitiesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeScalingActivitiesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeScalingActivitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingActivitiesError {
    fn code(&self) -> Option<&str> {
        DescribeScalingActivitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingActivitiesError {
    /// Creates a new `DescribeScalingActivitiesError`.
    pub fn new(kind: DescribeScalingActivitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingActivitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingActivitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingActivitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingActivitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalingActivitiesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingActivitiesErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingActivitiesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingActivitiesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeScalingActivitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingActivitiesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeScalingActivitiesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeScalingActivitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingProcessTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingProcessTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingProcessTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingProcessTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingProcessTypesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingProcessTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingProcessTypesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeScalingProcessTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingProcessTypesError {
    fn code(&self) -> Option<&str> {
        DescribeScalingProcessTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingProcessTypesError {
    /// Creates a new `DescribeScalingProcessTypesError`.
    pub fn new(kind: DescribeScalingProcessTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingProcessTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingProcessTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingProcessTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingProcessTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalingProcessTypesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingProcessTypesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeScalingProcessTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingProcessTypesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeScalingProcessTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScheduledActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScheduledActionsError {
    /// Kind of error that occurred.
    pub kind: DescribeScheduledActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScheduledActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScheduledActionsErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScheduledActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScheduledActionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeScheduledActionsErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeScheduledActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScheduledActionsError {
    fn code(&self) -> Option<&str> {
        DescribeScheduledActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScheduledActionsError {
    /// Creates a new `DescribeScheduledActionsError`.
    pub fn new(kind: DescribeScheduledActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScheduledActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScheduledActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScheduledActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScheduledActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeScheduledActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScheduledActionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::InvalidNextToken(_))
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeTagsErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTerminationPolicyTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTerminationPolicyTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeTerminationPolicyTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTerminationPolicyTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTerminationPolicyTypesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTerminationPolicyTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTerminationPolicyTypesErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeTerminationPolicyTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTerminationPolicyTypesError {
    fn code(&self) -> Option<&str> {
        DescribeTerminationPolicyTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTerminationPolicyTypesError {
    /// Creates a new `DescribeTerminationPolicyTypesError`.
    pub fn new(
        kind: DescribeTerminationPolicyTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTerminationPolicyTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTerminationPolicyTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTerminationPolicyTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTerminationPolicyTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTerminationPolicyTypesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTerminationPolicyTypesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeTerminationPolicyTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTerminationPolicyTypesErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            DescribeTerminationPolicyTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWarmPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWarmPoolError {
    /// Kind of error that occurred.
    pub kind: DescribeWarmPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWarmPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWarmPoolErrorKind {
    /// <p>The <code>NextToken</code> value is not valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWarmPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWarmPoolErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeWarmPoolErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            DescribeWarmPoolErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DescribeWarmPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWarmPoolError {
    fn code(&self) -> Option<&str> {
        DescribeWarmPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWarmPoolError {
    /// Creates a new `DescribeWarmPoolError`.
    pub fn new(kind: DescribeWarmPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWarmPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWarmPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWarmPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWarmPoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWarmPoolErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, DescribeWarmPoolErrorKind::InvalidNextToken(_))
    }
    /// Returns `true` if the error kind is `DescribeWarmPoolErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, DescribeWarmPoolErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `DescribeWarmPoolErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWarmPoolErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DescribeWarmPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWarmPoolErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeWarmPoolErrorKind::LimitExceededFault(_inner) => Some(_inner),
            DescribeWarmPoolErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DescribeWarmPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachInstancesError {
    /// Kind of error that occurred.
    pub kind: DetachInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachInstancesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachInstancesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DetachInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachInstancesError {
    fn code(&self) -> Option<&str> {
        DetachInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachInstancesError {
    /// Creates a new `DetachInstancesError`.
    pub fn new(kind: DetachInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachInstancesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DetachInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachInstancesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DetachInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachLoadBalancersError {
    /// Kind of error that occurred.
    pub kind: DetachLoadBalancersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachLoadBalancersErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachLoadBalancersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachLoadBalancersErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DetachLoadBalancersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachLoadBalancersError {
    fn code(&self) -> Option<&str> {
        DetachLoadBalancersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachLoadBalancersError {
    /// Creates a new `DetachLoadBalancersError`.
    pub fn new(kind: DetachLoadBalancersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachLoadBalancersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachLoadBalancersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachLoadBalancersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachLoadBalancersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachLoadBalancersErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DetachLoadBalancersErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DetachLoadBalancersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachLoadBalancersErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DetachLoadBalancersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachLoadBalancerTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachLoadBalancerTargetGroupsError {
    /// Kind of error that occurred.
    pub kind: DetachLoadBalancerTargetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachLoadBalancerTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachLoadBalancerTargetGroupsErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachLoadBalancerTargetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            DetachLoadBalancerTargetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachLoadBalancerTargetGroupsError {
    fn code(&self) -> Option<&str> {
        DetachLoadBalancerTargetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachLoadBalancerTargetGroupsError {
    /// Creates a new `DetachLoadBalancerTargetGroupsError`.
    pub fn new(
        kind: DetachLoadBalancerTargetGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachLoadBalancerTargetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachLoadBalancerTargetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachLoadBalancerTargetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachLoadBalancerTargetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DetachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DetachLoadBalancerTargetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            DetachLoadBalancerTargetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableMetricsCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableMetricsCollectionError {
    /// Kind of error that occurred.
    pub kind: DisableMetricsCollectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableMetricsCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableMetricsCollectionErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableMetricsCollectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableMetricsCollectionErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            DisableMetricsCollectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableMetricsCollectionError {
    fn code(&self) -> Option<&str> {
        DisableMetricsCollectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableMetricsCollectionError {
    /// Creates a new `DisableMetricsCollectionError`.
    pub fn new(kind: DisableMetricsCollectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableMetricsCollectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableMetricsCollectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableMetricsCollectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableMetricsCollectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableMetricsCollectionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisableMetricsCollectionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for DisableMetricsCollectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableMetricsCollectionErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            DisableMetricsCollectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableMetricsCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableMetricsCollectionError {
    /// Kind of error that occurred.
    pub kind: EnableMetricsCollectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableMetricsCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableMetricsCollectionErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableMetricsCollectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableMetricsCollectionErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            EnableMetricsCollectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableMetricsCollectionError {
    fn code(&self) -> Option<&str> {
        EnableMetricsCollectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableMetricsCollectionError {
    /// Creates a new `EnableMetricsCollectionError`.
    pub fn new(kind: EnableMetricsCollectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableMetricsCollectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableMetricsCollectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableMetricsCollectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableMetricsCollectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableMetricsCollectionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableMetricsCollectionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for EnableMetricsCollectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableMetricsCollectionErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            EnableMetricsCollectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnterStandby` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnterStandbyError {
    /// Kind of error that occurred.
    pub kind: EnterStandbyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnterStandby` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnterStandbyErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnterStandbyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnterStandbyErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            EnterStandbyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnterStandbyError {
    fn code(&self) -> Option<&str> {
        EnterStandbyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnterStandbyError {
    /// Creates a new `EnterStandbyError`.
    pub fn new(kind: EnterStandbyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnterStandbyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnterStandbyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnterStandbyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnterStandbyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnterStandbyErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnterStandbyErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for EnterStandbyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnterStandbyErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            EnterStandbyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecutePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecutePolicyError {
    /// Kind of error that occurred.
    pub kind: ExecutePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecutePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecutePolicyErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because there are scaling activities in
    /// progress.</p>
    ScalingActivityInProgressFault(crate::error::ScalingActivityInProgressFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecutePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecutePolicyErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            ExecutePolicyErrorKind::ScalingActivityInProgressFault(_inner) => _inner.fmt(f),
            ExecutePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecutePolicyError {
    fn code(&self) -> Option<&str> {
        ExecutePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecutePolicyError {
    /// Creates a new `ExecutePolicyError`.
    pub fn new(kind: ExecutePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecutePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecutePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecutePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecutePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecutePolicyErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            ExecutePolicyErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `ExecutePolicyErrorKind::ScalingActivityInProgressFault`.
    pub fn is_scaling_activity_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            ExecutePolicyErrorKind::ScalingActivityInProgressFault(_)
        )
    }
}
impl std::error::Error for ExecutePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecutePolicyErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            ExecutePolicyErrorKind::ScalingActivityInProgressFault(_inner) => Some(_inner),
            ExecutePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExitStandby` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExitStandbyError {
    /// Kind of error that occurred.
    pub kind: ExitStandbyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExitStandby` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExitStandbyErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExitStandbyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExitStandbyErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            ExitStandbyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExitStandbyError {
    fn code(&self) -> Option<&str> {
        ExitStandbyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExitStandbyError {
    /// Creates a new `ExitStandbyError`.
    pub fn new(kind: ExitStandbyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExitStandbyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExitStandbyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExitStandbyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExitStandbyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExitStandbyErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(&self.kind, ExitStandbyErrorKind::ResourceContentionFault(_))
    }
}
impl std::error::Error for ExitStandbyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExitStandbyErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            ExitStandbyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPredictiveScalingForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPredictiveScalingForecastError {
    /// Kind of error that occurred.
    pub kind: GetPredictiveScalingForecastErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPredictiveScalingForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPredictiveScalingForecastErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPredictiveScalingForecastError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPredictiveScalingForecastErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            GetPredictiveScalingForecastErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPredictiveScalingForecastError {
    fn code(&self) -> Option<&str> {
        GetPredictiveScalingForecastError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPredictiveScalingForecastError {
    /// Creates a new `GetPredictiveScalingForecastError`.
    pub fn new(kind: GetPredictiveScalingForecastErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPredictiveScalingForecastError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPredictiveScalingForecastErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPredictiveScalingForecastError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPredictiveScalingForecastErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPredictiveScalingForecastErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetPredictiveScalingForecastErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for GetPredictiveScalingForecastError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPredictiveScalingForecastErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            GetPredictiveScalingForecastErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLifecycleHook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLifecycleHookError {
    /// Kind of error that occurred.
    pub kind: PutLifecycleHookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLifecycleHook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLifecycleHookErrorKind {
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLifecycleHookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLifecycleHookErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PutLifecycleHookErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            PutLifecycleHookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLifecycleHookError {
    fn code(&self) -> Option<&str> {
        PutLifecycleHookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLifecycleHookError {
    /// Creates a new `PutLifecycleHookError`.
    pub fn new(kind: PutLifecycleHookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLifecycleHookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLifecycleHookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLifecycleHookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLifecycleHookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutLifecycleHookErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, PutLifecycleHookErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `PutLifecycleHookErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecycleHookErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for PutLifecycleHookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLifecycleHookErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PutLifecycleHookErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            PutLifecycleHookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutNotificationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutNotificationConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutNotificationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutNotificationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutNotificationConfigurationErrorKind {
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutNotificationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutNotificationConfigurationErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PutNotificationConfigurationErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            PutNotificationConfigurationErrorKind::ServiceLinkedRoleFailure(_inner) => {
                _inner.fmt(f)
            }
            PutNotificationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutNotificationConfigurationError {
    fn code(&self) -> Option<&str> {
        PutNotificationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutNotificationConfigurationError {
    /// Creates a new `PutNotificationConfigurationError`.
    pub fn new(kind: PutNotificationConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutNotificationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutNotificationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutNotificationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutNotificationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutNotificationConfigurationErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutNotificationConfigurationErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `PutNotificationConfigurationErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutNotificationConfigurationErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `PutNotificationConfigurationErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            PutNotificationConfigurationErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for PutNotificationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutNotificationConfigurationErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PutNotificationConfigurationErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            PutNotificationConfigurationErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            PutNotificationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: PutScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutScalingPolicyErrorKind {
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutScalingPolicyErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::ServiceLinkedRoleFailure(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutScalingPolicyError {
    fn code(&self) -> Option<&str> {
        PutScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutScalingPolicyError {
    /// Creates a new `PutScalingPolicyError`.
    pub fn new(kind: PutScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, PutScalingPolicyErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for PutScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutScalingPolicyErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutScheduledUpdateGroupAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutScheduledUpdateGroupActionError {
    /// Kind of error that occurred.
    pub kind: PutScheduledUpdateGroupActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutScheduledUpdateGroupAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutScheduledUpdateGroupActionErrorKind {
    /// <p>You already have an Auto Scaling group or launch configuration with this name.</p>
    AlreadyExistsFault(crate::error::AlreadyExistsFault),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutScheduledUpdateGroupActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(_inner) => _inner.fmt(f),
            PutScheduledUpdateGroupActionErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            PutScheduledUpdateGroupActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutScheduledUpdateGroupActionError {
    fn code(&self) -> Option<&str> {
        PutScheduledUpdateGroupActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutScheduledUpdateGroupActionError {
    /// Creates a new `PutScheduledUpdateGroupActionError`.
    pub fn new(
        kind: PutScheduledUpdateGroupActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutScheduledUpdateGroupActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutScheduledUpdateGroupActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutScheduledUpdateGroupActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutScheduledUpdateGroupActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault`.
    pub fn is_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `PutScheduledUpdateGroupActionErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledUpdateGroupActionErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `PutScheduledUpdateGroupActionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for PutScheduledUpdateGroupActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(_inner) => Some(_inner),
            PutScheduledUpdateGroupActionErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            PutScheduledUpdateGroupActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutWarmPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutWarmPoolError {
    /// Kind of error that occurred.
    pub kind: PutWarmPoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutWarmPool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutWarmPoolErrorKind {
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutWarmPoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutWarmPoolErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PutWarmPoolErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            PutWarmPoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutWarmPoolError {
    fn code(&self) -> Option<&str> {
        PutWarmPoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutWarmPoolError {
    /// Creates a new `PutWarmPoolError`.
    pub fn new(kind: PutWarmPoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutWarmPoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutWarmPoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutWarmPoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutWarmPoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutWarmPoolErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, PutWarmPoolErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `PutWarmPoolErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(&self.kind, PutWarmPoolErrorKind::ResourceContentionFault(_))
    }
}
impl std::error::Error for PutWarmPoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutWarmPoolErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PutWarmPoolErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            PutWarmPoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RecordLifecycleActionHeartbeat` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RecordLifecycleActionHeartbeatError {
    /// Kind of error that occurred.
    pub kind: RecordLifecycleActionHeartbeatErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RecordLifecycleActionHeartbeat` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RecordLifecycleActionHeartbeatErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RecordLifecycleActionHeartbeatError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RecordLifecycleActionHeartbeatErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            RecordLifecycleActionHeartbeatErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RecordLifecycleActionHeartbeatError {
    fn code(&self) -> Option<&str> {
        RecordLifecycleActionHeartbeatError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RecordLifecycleActionHeartbeatError {
    /// Creates a new `RecordLifecycleActionHeartbeatError`.
    pub fn new(
        kind: RecordLifecycleActionHeartbeatErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RecordLifecycleActionHeartbeatError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RecordLifecycleActionHeartbeatErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RecordLifecycleActionHeartbeatError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RecordLifecycleActionHeartbeatErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RecordLifecycleActionHeartbeatErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            RecordLifecycleActionHeartbeatErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for RecordLifecycleActionHeartbeatError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RecordLifecycleActionHeartbeatErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            RecordLifecycleActionHeartbeatErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResumeProcesses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResumeProcessesError {
    /// Kind of error that occurred.
    pub kind: ResumeProcessesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResumeProcesses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResumeProcessesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResumeProcessesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResumeProcessesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            ResumeProcessesErrorKind::ResourceInUseFault(_inner) => _inner.fmt(f),
            ResumeProcessesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResumeProcessesError {
    fn code(&self) -> Option<&str> {
        ResumeProcessesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResumeProcessesError {
    /// Creates a new `ResumeProcessesError`.
    pub fn new(kind: ResumeProcessesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResumeProcessesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResumeProcessesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResumeProcessesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResumeProcessesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResumeProcessesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResumeProcessesErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeProcessesErrorKind::ResourceInUseFault`.
    pub fn is_resource_in_use_fault(&self) -> bool {
        matches!(&self.kind, ResumeProcessesErrorKind::ResourceInUseFault(_))
    }
}
impl std::error::Error for ResumeProcessesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResumeProcessesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            ResumeProcessesErrorKind::ResourceInUseFault(_inner) => Some(_inner),
            ResumeProcessesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetDesiredCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetDesiredCapacityError {
    /// Kind of error that occurred.
    pub kind: SetDesiredCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetDesiredCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetDesiredCapacityErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because there are scaling activities in
    /// progress.</p>
    ScalingActivityInProgressFault(crate::error::ScalingActivityInProgressFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetDesiredCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetDesiredCapacityErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            SetDesiredCapacityErrorKind::ScalingActivityInProgressFault(_inner) => _inner.fmt(f),
            SetDesiredCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetDesiredCapacityError {
    fn code(&self) -> Option<&str> {
        SetDesiredCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetDesiredCapacityError {
    /// Creates a new `SetDesiredCapacityError`.
    pub fn new(kind: SetDesiredCapacityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetDesiredCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetDesiredCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetDesiredCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetDesiredCapacityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetDesiredCapacityErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            SetDesiredCapacityErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `SetDesiredCapacityErrorKind::ScalingActivityInProgressFault`.
    pub fn is_scaling_activity_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            SetDesiredCapacityErrorKind::ScalingActivityInProgressFault(_)
        )
    }
}
impl std::error::Error for SetDesiredCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetDesiredCapacityErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            SetDesiredCapacityErrorKind::ScalingActivityInProgressFault(_inner) => Some(_inner),
            SetDesiredCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetInstanceHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetInstanceHealthError {
    /// Kind of error that occurred.
    pub kind: SetInstanceHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetInstanceHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetInstanceHealthErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetInstanceHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetInstanceHealthErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            SetInstanceHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetInstanceHealthError {
    fn code(&self) -> Option<&str> {
        SetInstanceHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetInstanceHealthError {
    /// Creates a new `SetInstanceHealthError`.
    pub fn new(kind: SetInstanceHealthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetInstanceHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetInstanceHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetInstanceHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetInstanceHealthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetInstanceHealthErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            SetInstanceHealthErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for SetInstanceHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetInstanceHealthErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            SetInstanceHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetInstanceProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetInstanceProtectionError {
    /// Kind of error that occurred.
    pub kind: SetInstanceProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetInstanceProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetInstanceProtectionErrorKind {
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetInstanceProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetInstanceProtectionErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            SetInstanceProtectionErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            SetInstanceProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetInstanceProtectionError {
    fn code(&self) -> Option<&str> {
        SetInstanceProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetInstanceProtectionError {
    /// Creates a new `SetInstanceProtectionError`.
    pub fn new(kind: SetInstanceProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetInstanceProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetInstanceProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetInstanceProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetInstanceProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetInstanceProtectionErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            SetInstanceProtectionErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `SetInstanceProtectionErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            SetInstanceProtectionErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for SetInstanceProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetInstanceProtectionErrorKind::LimitExceededFault(_inner) => Some(_inner),
            SetInstanceProtectionErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            SetInstanceProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartInstanceRefresh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartInstanceRefreshError {
    /// Kind of error that occurred.
    pub kind: StartInstanceRefreshErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartInstanceRefresh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartInstanceRefreshErrorKind {
    /// <p>The request failed because an active instance refresh operation already exists for the
    /// specified Auto Scaling group.</p>
    InstanceRefreshInProgressFault(crate::error::InstanceRefreshInProgressFault),
    /// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
    /// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
    /// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
    /// Reference</i>.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartInstanceRefreshError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartInstanceRefreshErrorKind::InstanceRefreshInProgressFault(_inner) => _inner.fmt(f),
            StartInstanceRefreshErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            StartInstanceRefreshErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            StartInstanceRefreshErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartInstanceRefreshError {
    fn code(&self) -> Option<&str> {
        StartInstanceRefreshError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartInstanceRefreshError {
    /// Creates a new `StartInstanceRefreshError`.
    pub fn new(kind: StartInstanceRefreshErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartInstanceRefreshError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartInstanceRefreshErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartInstanceRefreshError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartInstanceRefreshErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartInstanceRefreshErrorKind::InstanceRefreshInProgressFault`.
    pub fn is_instance_refresh_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartInstanceRefreshErrorKind::InstanceRefreshInProgressFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartInstanceRefreshErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartInstanceRefreshErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartInstanceRefreshErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartInstanceRefreshErrorKind::ResourceContentionFault(_)
        )
    }
}
impl std::error::Error for StartInstanceRefreshError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartInstanceRefreshErrorKind::InstanceRefreshInProgressFault(_inner) => Some(_inner),
            StartInstanceRefreshErrorKind::LimitExceededFault(_inner) => Some(_inner),
            StartInstanceRefreshErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            StartInstanceRefreshErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SuspendProcesses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SuspendProcessesError {
    /// Kind of error that occurred.
    pub kind: SuspendProcessesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SuspendProcesses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SuspendProcessesErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because the resource is in use.</p>
    ResourceInUseFault(crate::error::ResourceInUseFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SuspendProcessesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SuspendProcessesErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            SuspendProcessesErrorKind::ResourceInUseFault(_inner) => _inner.fmt(f),
            SuspendProcessesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SuspendProcessesError {
    fn code(&self) -> Option<&str> {
        SuspendProcessesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SuspendProcessesError {
    /// Creates a new `SuspendProcessesError`.
    pub fn new(kind: SuspendProcessesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SuspendProcessesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SuspendProcessesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SuspendProcessesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SuspendProcessesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SuspendProcessesErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            SuspendProcessesErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `SuspendProcessesErrorKind::ResourceInUseFault`.
    pub fn is_resource_in_use_fault(&self) -> bool {
        matches!(&self.kind, SuspendProcessesErrorKind::ResourceInUseFault(_))
    }
}
impl std::error::Error for SuspendProcessesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SuspendProcessesErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            SuspendProcessesErrorKind::ResourceInUseFault(_inner) => Some(_inner),
            SuspendProcessesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateInstanceInAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateInstanceInAutoScalingGroupError {
    /// Kind of error that occurred.
    pub kind: TerminateInstanceInAutoScalingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateInstanceInAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateInstanceInAutoScalingGroupErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because there are scaling activities in
    /// progress.</p>
    ScalingActivityInProgressFault(crate::error::ScalingActivityInProgressFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateInstanceInAutoScalingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateInstanceInAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => {
                _inner.fmt(f)
            }
            TerminateInstanceInAutoScalingGroupErrorKind::ScalingActivityInProgressFault(
                _inner,
            ) => _inner.fmt(f),
            TerminateInstanceInAutoScalingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateInstanceInAutoScalingGroupError {
    fn code(&self) -> Option<&str> {
        TerminateInstanceInAutoScalingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateInstanceInAutoScalingGroupError {
    /// Creates a new `TerminateInstanceInAutoScalingGroupError`.
    pub fn new(
        kind: TerminateInstanceInAutoScalingGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateInstanceInAutoScalingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateInstanceInAutoScalingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateInstanceInAutoScalingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateInstanceInAutoScalingGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TerminateInstanceInAutoScalingGroupErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            TerminateInstanceInAutoScalingGroupErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateInstanceInAutoScalingGroupErrorKind::ScalingActivityInProgressFault`.
    pub fn is_scaling_activity_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            TerminateInstanceInAutoScalingGroupErrorKind::ScalingActivityInProgressFault(_)
        )
    }
}
impl std::error::Error for TerminateInstanceInAutoScalingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateInstanceInAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => {
                Some(_inner)
            }
            TerminateInstanceInAutoScalingGroupErrorKind::ScalingActivityInProgressFault(
                _inner,
            ) => Some(_inner),
            TerminateInstanceInAutoScalingGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAutoScalingGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateAutoScalingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAutoScalingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAutoScalingGroupErrorKind {
    /// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
    /// instance, or load balancer).</p>
    ResourceContentionFault(crate::error::ResourceContentionFault),
    /// <p>The operation can't be performed because there are scaling activities in
    /// progress.</p>
    ScalingActivityInProgressFault(crate::error::ScalingActivityInProgressFault),
    /// <p>The service-linked role is not yet ready for use.</p>
    ServiceLinkedRoleFailure(crate::error::ServiceLinkedRoleFailure),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAutoScalingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => _inner.fmt(f),
            UpdateAutoScalingGroupErrorKind::ScalingActivityInProgressFault(_inner) => {
                _inner.fmt(f)
            }
            UpdateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(_inner) => _inner.fmt(f),
            UpdateAutoScalingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAutoScalingGroupError {
    fn code(&self) -> Option<&str> {
        UpdateAutoScalingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAutoScalingGroupError {
    /// Creates a new `UpdateAutoScalingGroupError`.
    pub fn new(kind: UpdateAutoScalingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAutoScalingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAutoScalingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAutoScalingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAutoScalingGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAutoScalingGroupErrorKind::ResourceContentionFault`.
    pub fn is_resource_contention_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAutoScalingGroupErrorKind::ResourceContentionFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAutoScalingGroupErrorKind::ScalingActivityInProgressFault`.
    pub fn is_scaling_activity_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAutoScalingGroupErrorKind::ScalingActivityInProgressFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure`.
    pub fn is_service_linked_role_failure(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(_)
        )
    }
}
impl std::error::Error for UpdateAutoScalingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAutoScalingGroupErrorKind::ResourceContentionFault(_inner) => Some(_inner),
            UpdateAutoScalingGroupErrorKind::ScalingActivityInProgressFault(_inner) => Some(_inner),
            UpdateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure(_inner) => Some(_inner),
            UpdateAutoScalingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The service-linked role is not yet ready for use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLinkedRoleFailure {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceLinkedRoleFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLinkedRoleFailure");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceLinkedRoleFailure {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLinkedRoleFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLinkedRoleFailure")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLinkedRoleFailure {}
/// See [`ServiceLinkedRoleFailure`](crate::error::ServiceLinkedRoleFailure)
pub mod service_linked_role_failure {
    /// A builder for [`ServiceLinkedRoleFailure`](crate::error::ServiceLinkedRoleFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLinkedRoleFailure`](crate::error::ServiceLinkedRoleFailure)
        pub fn build(self) -> crate::error::ServiceLinkedRoleFailure {
            crate::error::ServiceLinkedRoleFailure {
                message: self.message,
            }
        }
    }
}
impl ServiceLinkedRoleFailure {
    /// Creates a new builder-style object to manufacture [`ServiceLinkedRoleFailure`](crate::error::ServiceLinkedRoleFailure)
    pub fn builder() -> crate::error::service_linked_role_failure::Builder {
        crate::error::service_linked_role_failure::Builder::default()
    }
}

/// <p>The operation can't be performed because there are scaling activities in
/// progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingActivityInProgressFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScalingActivityInProgressFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingActivityInProgressFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScalingActivityInProgressFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScalingActivityInProgressFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScalingActivityInProgressFault")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScalingActivityInProgressFault {}
/// See [`ScalingActivityInProgressFault`](crate::error::ScalingActivityInProgressFault)
pub mod scaling_activity_in_progress_fault {
    /// A builder for [`ScalingActivityInProgressFault`](crate::error::ScalingActivityInProgressFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingActivityInProgressFault`](crate::error::ScalingActivityInProgressFault)
        pub fn build(self) -> crate::error::ScalingActivityInProgressFault {
            crate::error::ScalingActivityInProgressFault {
                message: self.message,
            }
        }
    }
}
impl ScalingActivityInProgressFault {
    /// Creates a new builder-style object to manufacture [`ScalingActivityInProgressFault`](crate::error::ScalingActivityInProgressFault)
    pub fn builder() -> crate::error::scaling_activity_in_progress_fault::Builder {
        crate::error::scaling_activity_in_progress_fault::Builder::default()
    }
}

/// <p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group,
/// instance, or load balancer).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceContentionFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceContentionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceContentionFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceContentionFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceContentionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceContentionFault")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceContentionFault {}
/// See [`ResourceContentionFault`](crate::error::ResourceContentionFault)
pub mod resource_contention_fault {
    /// A builder for [`ResourceContentionFault`](crate::error::ResourceContentionFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceContentionFault`](crate::error::ResourceContentionFault)
        pub fn build(self) -> crate::error::ResourceContentionFault {
            crate::error::ResourceContentionFault {
                message: self.message,
            }
        }
    }
}
impl ResourceContentionFault {
    /// Creates a new builder-style object to manufacture [`ResourceContentionFault`](crate::error::ResourceContentionFault)
    pub fn builder() -> crate::error::resource_contention_fault::Builder {
        crate::error::resource_contention_fault::Builder::default()
    }
}

/// <p>The operation can't be performed because the resource is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseFault")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseFault {}
/// See [`ResourceInUseFault`](crate::error::ResourceInUseFault)
pub mod resource_in_use_fault {
    /// A builder for [`ResourceInUseFault`](crate::error::ResourceInUseFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseFault`](crate::error::ResourceInUseFault)
        pub fn build(self) -> crate::error::ResourceInUseFault {
            crate::error::ResourceInUseFault {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseFault {
    /// Creates a new builder-style object to manufacture [`ResourceInUseFault`](crate::error::ResourceInUseFault)
    pub fn builder() -> crate::error::resource_in_use_fault::Builder {
        crate::error::resource_in_use_fault::Builder::default()
    }
}

/// <p>You have already reached a limit for your Amazon EC2 Auto Scaling
/// resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For
/// more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API
/// Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededFault")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededFault {}
/// See [`LimitExceededFault`](crate::error::LimitExceededFault)
pub mod limit_exceeded_fault {
    /// A builder for [`LimitExceededFault`](crate::error::LimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededFault`](crate::error::LimitExceededFault)
        pub fn build(self) -> crate::error::LimitExceededFault {
            crate::error::LimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl LimitExceededFault {
    /// Creates a new builder-style object to manufacture [`LimitExceededFault`](crate::error::LimitExceededFault)
    pub fn builder() -> crate::error::limit_exceeded_fault::Builder {
        crate::error::limit_exceeded_fault::Builder::default()
    }
}

/// <p>The request failed because an active instance refresh operation already exists for the
/// specified Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRefreshInProgressFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceRefreshInProgressFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRefreshInProgressFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InstanceRefreshInProgressFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InstanceRefreshInProgressFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InstanceRefreshInProgressFault")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InstanceRefreshInProgressFault {}
/// See [`InstanceRefreshInProgressFault`](crate::error::InstanceRefreshInProgressFault)
pub mod instance_refresh_in_progress_fault {
    /// A builder for [`InstanceRefreshInProgressFault`](crate::error::InstanceRefreshInProgressFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRefreshInProgressFault`](crate::error::InstanceRefreshInProgressFault)
        pub fn build(self) -> crate::error::InstanceRefreshInProgressFault {
            crate::error::InstanceRefreshInProgressFault {
                message: self.message,
            }
        }
    }
}
impl InstanceRefreshInProgressFault {
    /// Creates a new builder-style object to manufacture [`InstanceRefreshInProgressFault`](crate::error::InstanceRefreshInProgressFault)
    pub fn builder() -> crate::error::instance_refresh_in_progress_fault::Builder {
        crate::error::instance_refresh_in_progress_fault::Builder::default()
    }
}

/// <p>You already have an Auto Scaling group or launch configuration with this name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsFault")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsFault {}
/// See [`AlreadyExistsFault`](crate::error::AlreadyExistsFault)
pub mod already_exists_fault {
    /// A builder for [`AlreadyExistsFault`](crate::error::AlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsFault`](crate::error::AlreadyExistsFault)
        pub fn build(self) -> crate::error::AlreadyExistsFault {
            crate::error::AlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsFault`](crate::error::AlreadyExistsFault)
    pub fn builder() -> crate::error::already_exists_fault::Builder {
        crate::error::already_exists_fault::Builder::default()
    }
}

/// <p>The <code>NextToken</code> value is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextToken {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextToken");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextToken {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextToken")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextToken {}
/// See [`InvalidNextToken`](crate::error::InvalidNextToken)
pub mod invalid_next_token {
    /// A builder for [`InvalidNextToken`](crate::error::InvalidNextToken)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextToken`](crate::error::InvalidNextToken)
        pub fn build(self) -> crate::error::InvalidNextToken {
            crate::error::InvalidNextToken {
                message: self.message,
            }
        }
    }
}
impl InvalidNextToken {
    /// Creates a new builder-style object to manufacture [`InvalidNextToken`](crate::error::InvalidNextToken)
    pub fn builder() -> crate::error::invalid_next_token::Builder {
        crate::error::invalid_next_token::Builder::default()
    }
}

/// <p>The request failed because an active instance refresh for the specified Auto Scaling group was
/// not found. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveInstanceRefreshNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActiveInstanceRefreshNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveInstanceRefreshNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActiveInstanceRefreshNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActiveInstanceRefreshNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActiveInstanceRefreshNotFoundFault")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActiveInstanceRefreshNotFoundFault {}
/// See [`ActiveInstanceRefreshNotFoundFault`](crate::error::ActiveInstanceRefreshNotFoundFault)
pub mod active_instance_refresh_not_found_fault {
    /// A builder for [`ActiveInstanceRefreshNotFoundFault`](crate::error::ActiveInstanceRefreshNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveInstanceRefreshNotFoundFault`](crate::error::ActiveInstanceRefreshNotFoundFault)
        pub fn build(self) -> crate::error::ActiveInstanceRefreshNotFoundFault {
            crate::error::ActiveInstanceRefreshNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ActiveInstanceRefreshNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ActiveInstanceRefreshNotFoundFault`](crate::error::ActiveInstanceRefreshNotFoundFault)
    pub fn builder() -> crate::error::active_instance_refresh_not_found_fault::Builder {
        crate::error::active_instance_refresh_not_found_fault::Builder::default()
    }
}
