// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachInstancesOutput, crate::error::AttachInstancesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::AttachInstancesError {
            meta: generic,
            kind: crate::error::AttachInstancesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::AttachInstancesError {
            meta: generic,
            kind: crate::error::AttachInstancesErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachInstancesOutput, crate::error::AttachInstancesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_instances_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancersOutput,
    crate::error::AttachLoadBalancersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachLoadBalancersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachLoadBalancersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::AttachLoadBalancersError {
            meta: generic,
            kind: crate::error::AttachLoadBalancersErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::AttachLoadBalancersError {
            meta: generic,
            kind: crate::error::AttachLoadBalancersErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachLoadBalancersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancersOutput,
    crate::error::AttachLoadBalancersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_load_balancers_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancer_target_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancerTargetGroupsOutput,
    crate::error::AttachLoadBalancerTargetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachLoadBalancerTargetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachLoadBalancerTargetGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::AttachLoadBalancerTargetGroupsError {
            meta: generic,
            kind: crate::error::AttachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTargetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::AttachLoadBalancerTargetGroupsError {
            meta: generic,
            kind: crate::error::AttachLoadBalancerTargetGroupsErrorKind::ServiceLinkedRoleFailure(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::service_linked_role_failure::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTargetGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::AttachLoadBalancerTargetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancer_target_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancerTargetGroupsOutput,
    crate::error::AttachLoadBalancerTargetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::attach_load_balancer_target_groups_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_scheduled_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDeleteScheduledActionOutput,
    crate::error::BatchDeleteScheduledActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDeleteScheduledActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchDeleteScheduledActionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::BatchDeleteScheduledActionError {
            meta: generic,
            kind: crate::error::BatchDeleteScheduledActionErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchDeleteScheduledActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_scheduled_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDeleteScheduledActionOutput,
    crate::error::BatchDeleteScheduledActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_delete_scheduled_action_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_batch_delete_scheduled_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDeleteScheduledActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_put_scheduled_update_group_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchPutScheduledUpdateGroupActionOutput,
    crate::error::BatchPutScheduledUpdateGroupActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchPutScheduledUpdateGroupActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchPutScheduledUpdateGroupActionError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => {
            crate::error::BatchPutScheduledUpdateGroupActionError {
                meta: generic,
                kind: crate::error::BatchPutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::already_exists_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchPutScheduledUpdateGroupActionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        "LimitExceeded" => {
            crate::error::BatchPutScheduledUpdateGroupActionError {
                meta: generic,
                kind: crate::error::BatchPutScheduledUpdateGroupActionErrorKind::LimitExceededFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::limit_exceeded_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchPutScheduledUpdateGroupActionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        "ResourceContention" => crate::error::BatchPutScheduledUpdateGroupActionError {
            meta: generic,
            kind:
                crate::error::BatchPutScheduledUpdateGroupActionErrorKind::ResourceContentionFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_contention_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchPutScheduledUpdateGroupActionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::BatchPutScheduledUpdateGroupActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_put_scheduled_update_group_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchPutScheduledUpdateGroupActionOutput,
    crate::error::BatchPutScheduledUpdateGroupActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::batch_put_scheduled_update_group_action_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_batch_put_scheduled_update_group_action(response.body().as_ref(), output).map_err(crate::error::BatchPutScheduledUpdateGroupActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_instance_refresh_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelInstanceRefreshOutput,
    crate::error::CancelInstanceRefreshError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelInstanceRefreshError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelInstanceRefreshError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActiveInstanceRefreshNotFound" => {
            crate::error::CancelInstanceRefreshError {
                meta: generic,
                kind:
                    crate::error::CancelInstanceRefreshErrorKind::ActiveInstanceRefreshNotFoundFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::active_instance_refresh_not_found_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_active_instance_refresh_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelInstanceRefreshError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "LimitExceeded" => {
            crate::error::CancelInstanceRefreshError {
                meta: generic,
                kind: crate::error::CancelInstanceRefreshErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelInstanceRefreshError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::CancelInstanceRefreshError {
            meta: generic,
            kind: crate::error::CancelInstanceRefreshErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelInstanceRefreshError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelInstanceRefreshError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_instance_refresh_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelInstanceRefreshOutput,
    crate::error::CancelInstanceRefreshError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_instance_refresh_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_cancel_instance_refresh(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelInstanceRefreshError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_lifecycle_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteLifecycleActionOutput,
    crate::error::CompleteLifecycleActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteLifecycleActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CompleteLifecycleActionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::CompleteLifecycleActionError {
            meta: generic,
            kind: crate::error::CompleteLifecycleActionErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CompleteLifecycleActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CompleteLifecycleActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_lifecycle_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteLifecycleActionOutput,
    crate::error::CompleteLifecycleActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_lifecycle_action_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_auto_scaling_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAutoScalingGroupOutput,
    crate::error::CreateAutoScalingGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAutoScalingGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateAutoScalingGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => {
            crate::error::CreateAutoScalingGroupError {
                meta: generic,
                kind: crate::error::CreateAutoScalingGroupErrorKind::AlreadyExistsFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAutoScalingGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => {
            crate::error::CreateAutoScalingGroupError {
                meta: generic,
                kind: crate::error::CreateAutoScalingGroupErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAutoScalingGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::CreateAutoScalingGroupError {
            meta: generic,
            kind: crate::error::CreateAutoScalingGroupErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::CreateAutoScalingGroupError {
            meta: generic,
            kind: crate::error::CreateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAutoScalingGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_auto_scaling_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAutoScalingGroupOutput,
    crate::error::CreateAutoScalingGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_auto_scaling_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_launch_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLaunchConfigurationOutput,
    crate::error::CreateLaunchConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLaunchConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateLaunchConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => {
            crate::error::CreateLaunchConfigurationError {
                meta: generic,
                kind: crate::error::CreateLaunchConfigurationErrorKind::AlreadyExistsFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLaunchConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => {
            crate::error::CreateLaunchConfigurationError {
                meta: generic,
                kind: crate::error::CreateLaunchConfigurationErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLaunchConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::CreateLaunchConfigurationError {
            meta: generic,
            kind: crate::error::CreateLaunchConfigurationErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLaunchConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLaunchConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_launch_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLaunchConfigurationOutput,
    crate::error::CreateLaunchConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_launch_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_or_update_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOrUpdateTagsOutput,
    crate::error::CreateOrUpdateTagsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateOrUpdateTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateOrUpdateTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => {
            crate::error::CreateOrUpdateTagsError {
                meta: generic,
                kind: crate::error::CreateOrUpdateTagsErrorKind::AlreadyExistsFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOrUpdateTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => {
            crate::error::CreateOrUpdateTagsError {
                meta: generic,
                kind: crate::error::CreateOrUpdateTagsErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOrUpdateTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::CreateOrUpdateTagsError {
            meta: generic,
            kind: crate::error::CreateOrUpdateTagsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOrUpdateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::CreateOrUpdateTagsError {
            meta: generic,
            kind: crate::error::CreateOrUpdateTagsErrorKind::ResourceInUseFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOrUpdateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateOrUpdateTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_or_update_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOrUpdateTagsOutput,
    crate::error::CreateOrUpdateTagsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_or_update_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_auto_scaling_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAutoScalingGroupOutput,
    crate::error::DeleteAutoScalingGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAutoScalingGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAutoScalingGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DeleteAutoScalingGroupError {
            meta: generic,
            kind: crate::error::DeleteAutoScalingGroupErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::DeleteAutoScalingGroupError {
            meta: generic,
            kind: crate::error::DeleteAutoScalingGroupErrorKind::ResourceInUseFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScalingActivityInProgress" => crate::error::DeleteAutoScalingGroupError {
            meta: generic,
            kind: crate::error::DeleteAutoScalingGroupErrorKind::ScalingActivityInProgressFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scaling_activity_in_progress_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scaling_activity_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAutoScalingGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_auto_scaling_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAutoScalingGroupOutput,
    crate::error::DeleteAutoScalingGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_auto_scaling_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_launch_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLaunchConfigurationOutput,
    crate::error::DeleteLaunchConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLaunchConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteLaunchConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DeleteLaunchConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLaunchConfigurationErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLaunchConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::DeleteLaunchConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLaunchConfigurationErrorKind::ResourceInUseFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLaunchConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLaunchConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_launch_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLaunchConfigurationOutput,
    crate::error::DeleteLaunchConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_launch_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_lifecycle_hook_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLifecycleHookOutput,
    crate::error::DeleteLifecycleHookError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLifecycleHookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLifecycleHookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DeleteLifecycleHookError {
            meta: generic,
            kind: crate::error::DeleteLifecycleHookErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLifecycleHookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLifecycleHookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_lifecycle_hook_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLifecycleHookOutput,
    crate::error::DeleteLifecycleHookError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_lifecycle_hook_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notification_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotificationConfigurationOutput,
    crate::error::DeleteNotificationConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteNotificationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteNotificationConfigurationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DeleteNotificationConfigurationError {
            meta: generic,
            kind: crate::error::DeleteNotificationConfigurationErrorKind::ResourceContentionFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_contention_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteNotificationConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteNotificationConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notification_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotificationConfigurationOutput,
    crate::error::DeleteNotificationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_notification_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_scheduled_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteScheduledActionOutput,
    crate::error::DeleteScheduledActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteScheduledActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteScheduledActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DeleteScheduledActionError {
            meta: generic,
            kind: crate::error::DeleteScheduledActionErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteScheduledActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_scheduled_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteScheduledActionOutput,
    crate::error::DeleteScheduledActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_scheduled_action_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::ResourceInUseFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_warm_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWarmPoolOutput, crate::error::DeleteWarmPoolError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWarmPoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWarmPoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::DeleteWarmPoolError {
                meta: generic,
                kind: crate::error::DeleteWarmPoolErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteWarmPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DeleteWarmPoolError {
            meta: generic,
            kind: crate::error::DeleteWarmPoolErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteWarmPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::DeleteWarmPoolError {
            meta: generic,
            kind: crate::error::DeleteWarmPoolErrorKind::ResourceInUseFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteWarmPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScalingActivityInProgress" => crate::error::DeleteWarmPoolError {
            meta: generic,
            kind: crate::error::DeleteWarmPoolErrorKind::ScalingActivityInProgressFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scaling_activity_in_progress_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scaling_activity_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteWarmPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteWarmPoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_warm_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWarmPoolOutput, crate::error::DeleteWarmPoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_warm_pool_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAccountLimitsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeAccountLimitsError {
            meta: generic,
            kind: crate::error::DescribeAccountLimitsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAccountLimitsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountLimitsOutput,
    crate::error::DescribeAccountLimitsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_limits_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_account_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_adjustment_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAdjustmentTypesOutput,
    crate::error::DescribeAdjustmentTypesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAdjustmentTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAdjustmentTypesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeAdjustmentTypesError {
            meta: generic,
            kind: crate::error::DescribeAdjustmentTypesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAdjustmentTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAdjustmentTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_adjustment_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAdjustmentTypesOutput,
    crate::error::DescribeAdjustmentTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_adjustment_types_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_adjustment_types(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAdjustmentTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_scaling_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAutoScalingGroupsOutput,
    crate::error::DescribeAutoScalingGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAutoScalingGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAutoScalingGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeAutoScalingGroupsError {
                meta: generic,
                kind: crate::error::DescribeAutoScalingGroupsErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAutoScalingGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeAutoScalingGroupsError {
            meta: generic,
            kind: crate::error::DescribeAutoScalingGroupsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAutoScalingGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAutoScalingGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_scaling_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAutoScalingGroupsOutput,
    crate::error::DescribeAutoScalingGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_auto_scaling_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_auto_scaling_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAutoScalingGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_scaling_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAutoScalingInstancesOutput,
    crate::error::DescribeAutoScalingInstancesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAutoScalingInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAutoScalingInstancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeAutoScalingInstancesError {
                meta: generic,
                kind: crate::error::DescribeAutoScalingInstancesErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAutoScalingInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeAutoScalingInstancesError {
            meta: generic,
            kind: crate::error::DescribeAutoScalingInstancesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAutoScalingInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAutoScalingInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_scaling_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAutoScalingInstancesOutput,
    crate::error::DescribeAutoScalingInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_auto_scaling_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_auto_scaling_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAutoScalingInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_scaling_notification_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAutoScalingNotificationTypesOutput,
    crate::error::DescribeAutoScalingNotificationTypesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAutoScalingNotificationTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAutoScalingNotificationTypesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeAutoScalingNotificationTypesError {
            meta: generic,
            kind:
                crate::error::DescribeAutoScalingNotificationTypesErrorKind::ResourceContentionFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_contention_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAutoScalingNotificationTypesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeAutoScalingNotificationTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_scaling_notification_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAutoScalingNotificationTypesOutput,
    crate::error::DescribeAutoScalingNotificationTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_auto_scaling_notification_types_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_auto_scaling_notification_types(response.body().as_ref(), output).map_err(crate::error::DescribeAutoScalingNotificationTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instance_refreshes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstanceRefreshesOutput,
    crate::error::DescribeInstanceRefreshesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeInstanceRefreshesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeInstanceRefreshesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeInstanceRefreshesError {
                meta: generic,
                kind: crate::error::DescribeInstanceRefreshesErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceRefreshesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeInstanceRefreshesError {
            meta: generic,
            kind: crate::error::DescribeInstanceRefreshesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeInstanceRefreshesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeInstanceRefreshesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_instance_refreshes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInstanceRefreshesOutput,
    crate::error::DescribeInstanceRefreshesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_instance_refreshes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_instance_refreshes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeInstanceRefreshesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_launch_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLaunchConfigurationsOutput,
    crate::error::DescribeLaunchConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLaunchConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeLaunchConfigurationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeLaunchConfigurationsError {
                meta: generic,
                kind: crate::error::DescribeLaunchConfigurationsErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLaunchConfigurationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeLaunchConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeLaunchConfigurationsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLaunchConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLaunchConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_launch_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLaunchConfigurationsOutput,
    crate::error::DescribeLaunchConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_launch_configurations_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_launch_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLaunchConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lifecycle_hooks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLifecycleHooksOutput,
    crate::error::DescribeLifecycleHooksError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLifecycleHooksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeLifecycleHooksError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeLifecycleHooksError {
            meta: generic,
            kind: crate::error::DescribeLifecycleHooksErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLifecycleHooksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLifecycleHooksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lifecycle_hooks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLifecycleHooksOutput,
    crate::error::DescribeLifecycleHooksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_lifecycle_hooks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_lifecycle_hooks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLifecycleHooksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lifecycle_hook_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLifecycleHookTypesOutput,
    crate::error::DescribeLifecycleHookTypesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLifecycleHookTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeLifecycleHookTypesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeLifecycleHookTypesError {
            meta: generic,
            kind: crate::error::DescribeLifecycleHookTypesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLifecycleHookTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLifecycleHookTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lifecycle_hook_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLifecycleHookTypesOutput,
    crate::error::DescribeLifecycleHookTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_lifecycle_hook_types_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_lifecycle_hook_types(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLifecycleHookTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancersOutput,
    crate::error::DescribeLoadBalancersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLoadBalancersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeLoadBalancersError {
                meta: generic,
                kind: crate::error::DescribeLoadBalancersErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeLoadBalancersError {
            meta: generic,
            kind: crate::error::DescribeLoadBalancersErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLoadBalancersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancersOutput,
    crate::error::DescribeLoadBalancersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_load_balancers_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_load_balancers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLoadBalancersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_target_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerTargetGroupsOutput,
    crate::error::DescribeLoadBalancerTargetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoadBalancerTargetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeLoadBalancerTargetGroupsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeLoadBalancerTargetGroupsError {
                meta: generic,
                kind: crate::error::DescribeLoadBalancerTargetGroupsErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerTargetGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeLoadBalancerTargetGroupsError {
            meta: generic,
            kind: crate::error::DescribeLoadBalancerTargetGroupsErrorKind::ResourceContentionFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_contention_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoadBalancerTargetGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeLoadBalancerTargetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_load_balancer_target_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoadBalancerTargetGroupsOutput,
    crate::error::DescribeLoadBalancerTargetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_load_balancer_target_groups_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_load_balancer_target_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeLoadBalancerTargetGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_metric_collection_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMetricCollectionTypesOutput,
    crate::error::DescribeMetricCollectionTypesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeMetricCollectionTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeMetricCollectionTypesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeMetricCollectionTypesError {
            meta: generic,
            kind: crate::error::DescribeMetricCollectionTypesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeMetricCollectionTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeMetricCollectionTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_metric_collection_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMetricCollectionTypesOutput,
    crate::error::DescribeMetricCollectionTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_metric_collection_types_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_metric_collection_types(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeMetricCollectionTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notification_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotificationConfigurationsOutput,
    crate::error::DescribeNotificationConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeNotificationConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeNotificationConfigurationsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeNotificationConfigurationsError {
                meta: generic,
                kind: crate::error::DescribeNotificationConfigurationsErrorKind::InvalidNextToken(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::invalid_next_token::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationConfigurationsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        "ResourceContention" => crate::error::DescribeNotificationConfigurationsError {
            meta: generic,
            kind:
                crate::error::DescribeNotificationConfigurationsErrorKind::ResourceContentionFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_contention_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeNotificationConfigurationsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeNotificationConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notification_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotificationConfigurationsOutput,
    crate::error::DescribeNotificationConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_notification_configurations_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_notification_configurations(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeNotificationConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePoliciesOutput, crate::error::DescribePoliciesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribePoliciesError {
                meta: generic,
                kind: crate::error::DescribePoliciesErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribePoliciesError {
            meta: generic,
            kind: crate::error::DescribePoliciesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::DescribePoliciesError {
            meta: generic,
            kind: crate::error::DescribePoliciesErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePoliciesOutput, crate::error::DescribePoliciesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scaling_activities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScalingActivitiesOutput,
    crate::error::DescribeScalingActivitiesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeScalingActivitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeScalingActivitiesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeScalingActivitiesError {
                meta: generic,
                kind: crate::error::DescribeScalingActivitiesErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScalingActivitiesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeScalingActivitiesError {
            meta: generic,
            kind: crate::error::DescribeScalingActivitiesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScalingActivitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeScalingActivitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scaling_activities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScalingActivitiesOutput,
    crate::error::DescribeScalingActivitiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_scaling_activities_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_scaling_activities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeScalingActivitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scaling_process_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScalingProcessTypesOutput,
    crate::error::DescribeScalingProcessTypesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeScalingProcessTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeScalingProcessTypesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeScalingProcessTypesError {
            meta: generic,
            kind: crate::error::DescribeScalingProcessTypesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScalingProcessTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeScalingProcessTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scaling_process_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScalingProcessTypesOutput,
    crate::error::DescribeScalingProcessTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_scaling_process_types_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_scaling_process_types(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeScalingProcessTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scheduled_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScheduledActionsOutput,
    crate::error::DescribeScheduledActionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeScheduledActionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeScheduledActionsError {
                meta: generic,
                kind: crate::error::DescribeScheduledActionsErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeScheduledActionsError {
            meta: generic,
            kind: crate::error::DescribeScheduledActionsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeScheduledActionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scheduled_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScheduledActionsOutput,
    crate::error::DescribeScheduledActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_scheduled_actions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_scheduled_actions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeTagsError {
                meta: generic,
                kind: crate::error::DescribeTagsErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_termination_policy_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTerminationPolicyTypesOutput,
    crate::error::DescribeTerminationPolicyTypesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTerminationPolicyTypesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTerminationPolicyTypesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DescribeTerminationPolicyTypesError {
            meta: generic,
            kind: crate::error::DescribeTerminationPolicyTypesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTerminationPolicyTypesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTerminationPolicyTypesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_termination_policy_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTerminationPolicyTypesOutput,
    crate::error::DescribeTerminationPolicyTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_termination_policy_types_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_termination_policy_types(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeTerminationPolicyTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_warm_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeWarmPoolOutput, crate::error::DescribeWarmPoolError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWarmPoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeWarmPoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeWarmPoolError {
                meta: generic,
                kind: crate::error::DescribeWarmPoolErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeWarmPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => {
            crate::error::DescribeWarmPoolError {
                meta: generic,
                kind: crate::error::DescribeWarmPoolErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeWarmPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::DescribeWarmPoolError {
            meta: generic,
            kind: crate::error::DescribeWarmPoolErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeWarmPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeWarmPoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_warm_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeWarmPoolOutput, crate::error::DescribeWarmPoolError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_warm_pool_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_warm_pool(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWarmPoolError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachInstancesOutput, crate::error::DetachInstancesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DetachInstancesError {
            meta: generic,
            kind: crate::error::DetachInstancesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachInstancesOutput, crate::error::DetachInstancesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_detach_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetachInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_load_balancers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachLoadBalancersOutput,
    crate::error::DetachLoadBalancersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachLoadBalancersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachLoadBalancersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DetachLoadBalancersError {
            meta: generic,
            kind: crate::error::DetachLoadBalancersErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachLoadBalancersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_load_balancers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachLoadBalancersOutput,
    crate::error::DetachLoadBalancersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_load_balancers_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_load_balancer_target_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachLoadBalancerTargetGroupsOutput,
    crate::error::DetachLoadBalancerTargetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachLoadBalancerTargetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachLoadBalancerTargetGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DetachLoadBalancerTargetGroupsError {
            meta: generic,
            kind: crate::error::DetachLoadBalancerTargetGroupsErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachLoadBalancerTargetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachLoadBalancerTargetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_load_balancer_target_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachLoadBalancerTargetGroupsOutput,
    crate::error::DetachLoadBalancerTargetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::detach_load_balancer_target_groups_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_metrics_collection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableMetricsCollectionOutput,
    crate::error::DisableMetricsCollectionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableMetricsCollectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisableMetricsCollectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::DisableMetricsCollectionError {
            meta: generic,
            kind: crate::error::DisableMetricsCollectionErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableMetricsCollectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableMetricsCollectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_metrics_collection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableMetricsCollectionOutput,
    crate::error::DisableMetricsCollectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_metrics_collection_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_metrics_collection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableMetricsCollectionOutput,
    crate::error::EnableMetricsCollectionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableMetricsCollectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::EnableMetricsCollectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::EnableMetricsCollectionError {
            meta: generic,
            kind: crate::error::EnableMetricsCollectionErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableMetricsCollectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableMetricsCollectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_metrics_collection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableMetricsCollectionOutput,
    crate::error::EnableMetricsCollectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_metrics_collection_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enter_standby_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnterStandbyOutput, crate::error::EnterStandbyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnterStandbyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnterStandbyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::EnterStandbyError {
            meta: generic,
            kind: crate::error::EnterStandbyErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnterStandbyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnterStandbyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enter_standby_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnterStandbyOutput, crate::error::EnterStandbyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enter_standby_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_enter_standby(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EnterStandbyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecutePolicyOutput, crate::error::ExecutePolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecutePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExecutePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::ExecutePolicyError {
            meta: generic,
            kind: crate::error::ExecutePolicyErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ExecutePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScalingActivityInProgress" => crate::error::ExecutePolicyError {
            meta: generic,
            kind: crate::error::ExecutePolicyErrorKind::ScalingActivityInProgressFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scaling_activity_in_progress_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scaling_activity_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ExecutePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExecutePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecutePolicyOutput, crate::error::ExecutePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::execute_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_exit_standby_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExitStandbyOutput, crate::error::ExitStandbyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExitStandbyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExitStandbyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::ExitStandbyError {
            meta: generic,
            kind: crate::error::ExitStandbyErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ExitStandbyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExitStandbyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_exit_standby_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExitStandbyOutput, crate::error::ExitStandbyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::exit_standby_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_exit_standby(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExitStandbyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_predictive_scaling_forecast_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPredictiveScalingForecastOutput,
    crate::error::GetPredictiveScalingForecastError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPredictiveScalingForecastError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetPredictiveScalingForecastError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::GetPredictiveScalingForecastError {
            meta: generic,
            kind: crate::error::GetPredictiveScalingForecastErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPredictiveScalingForecastError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPredictiveScalingForecastError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_predictive_scaling_forecast_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPredictiveScalingForecastOutput,
    crate::error::GetPredictiveScalingForecastError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_predictive_scaling_forecast_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_predictive_scaling_forecast(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPredictiveScalingForecastError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lifecycle_hook_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutLifecycleHookOutput, crate::error::PutLifecycleHookError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutLifecycleHookError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutLifecycleHookError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::PutLifecycleHookError {
                meta: generic,
                kind: crate::error::PutLifecycleHookErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutLifecycleHookError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::PutLifecycleHookError {
            meta: generic,
            kind: crate::error::PutLifecycleHookErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutLifecycleHookError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutLifecycleHookError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lifecycle_hook_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutLifecycleHookOutput, crate::error::PutLifecycleHookError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_lifecycle_hook_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_notification_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutNotificationConfigurationOutput,
    crate::error::PutNotificationConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutNotificationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutNotificationConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::PutNotificationConfigurationError {
                meta: generic,
                kind: crate::error::PutNotificationConfigurationErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutNotificationConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::PutNotificationConfigurationError {
            meta: generic,
            kind: crate::error::PutNotificationConfigurationErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutNotificationConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::PutNotificationConfigurationError {
            meta: generic,
            kind: crate::error::PutNotificationConfigurationErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::PutNotificationConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutNotificationConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_notification_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutNotificationConfigurationOutput,
    crate::error::PutNotificationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_notification_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_scaling_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutScalingPolicyOutput, crate::error::PutScalingPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutScalingPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutScalingPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::PutScalingPolicyError {
                meta: generic,
                kind: crate::error::PutScalingPolicyErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutScalingPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::PutScalingPolicyError {
            meta: generic,
            kind: crate::error::PutScalingPolicyErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutScalingPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::PutScalingPolicyError {
            meta: generic,
            kind: crate::error::PutScalingPolicyErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::PutScalingPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutScalingPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_scaling_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutScalingPolicyOutput, crate::error::PutScalingPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_scaling_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_put_scaling_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutScalingPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_scheduled_update_group_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutScheduledUpdateGroupActionOutput,
    crate::error::PutScheduledUpdateGroupActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutScheduledUpdateGroupActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutScheduledUpdateGroupActionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => {
            crate::error::PutScheduledUpdateGroupActionError {
                meta: generic,
                kind: crate::error::PutScheduledUpdateGroupActionErrorKind::AlreadyExistsFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutScheduledUpdateGroupActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => {
            crate::error::PutScheduledUpdateGroupActionError {
                meta: generic,
                kind: crate::error::PutScheduledUpdateGroupActionErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutScheduledUpdateGroupActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::PutScheduledUpdateGroupActionError {
            meta: generic,
            kind: crate::error::PutScheduledUpdateGroupActionErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutScheduledUpdateGroupActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutScheduledUpdateGroupActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_scheduled_update_group_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutScheduledUpdateGroupActionOutput,
    crate::error::PutScheduledUpdateGroupActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_scheduled_update_group_action_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_warm_pool_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutWarmPoolOutput, crate::error::PutWarmPoolError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutWarmPoolError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutWarmPoolError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::PutWarmPoolError {
                meta: generic,
                kind: crate::error::PutWarmPoolErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutWarmPoolError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::PutWarmPoolError {
            meta: generic,
            kind: crate::error::PutWarmPoolErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutWarmPoolError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutWarmPoolError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_warm_pool_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutWarmPoolOutput, crate::error::PutWarmPoolError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_warm_pool_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_record_lifecycle_action_heartbeat_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RecordLifecycleActionHeartbeatOutput,
    crate::error::RecordLifecycleActionHeartbeatError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RecordLifecycleActionHeartbeatError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RecordLifecycleActionHeartbeatError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::RecordLifecycleActionHeartbeatError {
            meta: generic,
            kind: crate::error::RecordLifecycleActionHeartbeatErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RecordLifecycleActionHeartbeatError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RecordLifecycleActionHeartbeatError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_record_lifecycle_action_heartbeat_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RecordLifecycleActionHeartbeatOutput,
    crate::error::RecordLifecycleActionHeartbeatError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::record_lifecycle_action_heartbeat_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resume_processes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResumeProcessesOutput, crate::error::ResumeProcessesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResumeProcessesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResumeProcessesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::ResumeProcessesError {
            meta: generic,
            kind: crate::error::ResumeProcessesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResumeProcessesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::ResumeProcessesError {
            meta: generic,
            kind: crate::error::ResumeProcessesErrorKind::ResourceInUseFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResumeProcessesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResumeProcessesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resume_processes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResumeProcessesOutput, crate::error::ResumeProcessesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::resume_processes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_desired_capacity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetDesiredCapacityOutput,
    crate::error::SetDesiredCapacityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetDesiredCapacityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetDesiredCapacityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::SetDesiredCapacityError {
            meta: generic,
            kind: crate::error::SetDesiredCapacityErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SetDesiredCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScalingActivityInProgress" => crate::error::SetDesiredCapacityError {
            meta: generic,
            kind: crate::error::SetDesiredCapacityErrorKind::ScalingActivityInProgressFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scaling_activity_in_progress_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scaling_activity_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SetDesiredCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetDesiredCapacityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_desired_capacity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetDesiredCapacityOutput,
    crate::error::SetDesiredCapacityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_desired_capacity_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_instance_health_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetInstanceHealthOutput, crate::error::SetInstanceHealthError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetInstanceHealthError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetInstanceHealthError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::SetInstanceHealthError {
            meta: generic,
            kind: crate::error::SetInstanceHealthErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SetInstanceHealthError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetInstanceHealthError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_instance_health_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetInstanceHealthOutput, crate::error::SetInstanceHealthError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_instance_health_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_instance_protection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetInstanceProtectionOutput,
    crate::error::SetInstanceProtectionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetInstanceProtectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetInstanceProtectionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::SetInstanceProtectionError {
                meta: generic,
                kind: crate::error::SetInstanceProtectionErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SetInstanceProtectionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::SetInstanceProtectionError {
            meta: generic,
            kind: crate::error::SetInstanceProtectionErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SetInstanceProtectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetInstanceProtectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_instance_protection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetInstanceProtectionOutput,
    crate::error::SetInstanceProtectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_instance_protection_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_instance_refresh_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartInstanceRefreshOutput,
    crate::error::StartInstanceRefreshError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartInstanceRefreshError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartInstanceRefreshError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InstanceRefreshInProgress" => crate::error::StartInstanceRefreshError {
            meta: generic,
            kind: crate::error::StartInstanceRefreshErrorKind::InstanceRefreshInProgressFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::instance_refresh_in_progress_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_instance_refresh_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceRefreshError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => {
            crate::error::StartInstanceRefreshError {
                meta: generic,
                kind: crate::error::StartInstanceRefreshErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceRefreshError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceContention" => crate::error::StartInstanceRefreshError {
            meta: generic,
            kind: crate::error::StartInstanceRefreshErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceRefreshError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartInstanceRefreshError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_instance_refresh_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartInstanceRefreshOutput,
    crate::error::StartInstanceRefreshError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_instance_refresh_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_start_instance_refresh(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartInstanceRefreshError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_suspend_processes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SuspendProcessesOutput, crate::error::SuspendProcessesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SuspendProcessesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SuspendProcessesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::SuspendProcessesError {
            meta: generic,
            kind: crate::error::SuspendProcessesErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SuspendProcessesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => crate::error::SuspendProcessesError {
            meta: generic,
            kind: crate::error::SuspendProcessesErrorKind::ResourceInUseFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SuspendProcessesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SuspendProcessesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_suspend_processes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SuspendProcessesOutput, crate::error::SuspendProcessesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::suspend_processes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_instance_in_auto_scaling_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateInstanceInAutoScalingGroupOutput,
    crate::error::TerminateInstanceInAutoScalingGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TerminateInstanceInAutoScalingGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::TerminateInstanceInAutoScalingGroupError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::TerminateInstanceInAutoScalingGroupError { meta: generic, kind: crate::error::TerminateInstanceInAutoScalingGroupErrorKind::ResourceContentionFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TerminateInstanceInAutoScalingGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ScalingActivityInProgress" => crate::error::TerminateInstanceInAutoScalingGroupError { meta: generic, kind: crate::error::TerminateInstanceInAutoScalingGroupErrorKind::ScalingActivityInProgressFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::scaling_activity_in_progress_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scaling_activity_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TerminateInstanceInAutoScalingGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::TerminateInstanceInAutoScalingGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_instance_in_auto_scaling_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateInstanceInAutoScalingGroupOutput,
    crate::error::TerminateInstanceInAutoScalingGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::terminate_instance_in_auto_scaling_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_terminate_instance_in_auto_scaling_group(response.body().as_ref(), output).map_err(crate::error::TerminateInstanceInAutoScalingGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_auto_scaling_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAutoScalingGroupOutput,
    crate::error::UpdateAutoScalingGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAutoScalingGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAutoScalingGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceContention" => crate::error::UpdateAutoScalingGroupError {
            meta: generic,
            kind: crate::error::UpdateAutoScalingGroupErrorKind::ResourceContentionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_contention_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_contention_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScalingActivityInProgress" => crate::error::UpdateAutoScalingGroupError {
            meta: generic,
            kind: crate::error::UpdateAutoScalingGroupErrorKind::ScalingActivityInProgressFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scaling_activity_in_progress_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scaling_activity_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLinkedRoleFailure" => crate::error::UpdateAutoScalingGroupError {
            meta: generic,
            kind: crate::error::UpdateAutoScalingGroupErrorKind::ServiceLinkedRoleFailure({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_linked_role_failure::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_linked_role_failure_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAutoScalingGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAutoScalingGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_auto_scaling_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAutoScalingGroupOutput,
    crate::error::UpdateAutoScalingGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_auto_scaling_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}
